(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     93693,       2548]
NotebookOptionsPosition[     84242,       2212]
NotebookOutlinePosition[     85653,       2252]
CellTagsIndexPosition[     85567,       2247]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalDifferentialEquations"], 
          "Expressions with Heads That Are Not Symbols" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"], 
          "Approximate Functions and Interpolation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApproximateFunctionsAndInterpolation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equations\"\>", 
       2->"\<\"Expressions with Heads That Are Not Symbols\"\>", 
       3->"\<\"Approximate Functions and Interpolation\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interpolation" :> 
          Documentation`HelpLookup["paclet:ref/Interpolation"], 
          "CompiledFunction" :> 
          Documentation`HelpLookup["paclet:ref/CompiledFunction"], 
          "FunctionInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/FunctionInterpolation"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"], 
          "InterpolatingPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingPolynomial"], 
          "NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"], 
          "Blend" :> Documentation`HelpLookup["paclet:ref/Blend"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interpolation\"\>", 
       2->"\<\"CompiledFunction\"\>", 3->"\<\"FunctionInterpolation\"\>", 
       4->"\<\"Piecewise\"\>", 5->"\<\"InterpolatingPolynomial\"\>", 
       6->"\<\"NDSolve\"\>", 7->"\<\"Blend\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"], 
          "Differential Equations" :> 
          Documentation`HelpLookup["paclet:guide/DifferentialEquations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Curve Fitting & Approximate Functions\"\>", 
       2->"\<\"Differential Equations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InterpolatingFunction", "ObjectName",
 CellID->14195],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InterpolatingFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InterpolatingFunction"], "[", 
       RowBox[{
        StyleBox["domain", "TI"], ",", 
        StyleBox["table", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an approximate function whose values are \
found by interpolation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28252]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " works like ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21959],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"InterpolatingFunction", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " finds the value of an approximate function with a particular argument ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9600],

Cell[TextData[{
 "In standard output format, only the ",
 Cell[BoxData[
  StyleBox["domain", "TI"]], "InlineFormula"],
 " element of an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object is printed explicitly. The remaining elements are indicated by ",
 Cell[BoxData["<>"], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->226562029,
  ButtonNote->"226562029"]
}], "Notes",
 CellID->25883],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["domain", "TI"]], "InlineFormula"],
 " specifies the domain of the data from which the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " was constructed. "
}], "Notes",
 CellID->6117],

Cell["\<\
If you supply arguments outside of the domain, a warning is generated, and \
then an extrapolated value is returned. \
\>", "Notes",
 CellID->28900],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects that take any number of real arguments may be constructed. "
}], "Notes",
 CellID->32579],

Cell[TextData[{
 "You can take derivatives of ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects using ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32711],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " returns its results in terms of ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->21574]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->303652191],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->352021709],

Cell[TextData[{
 "Make an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object that will go through the given points:"
}], "ExampleText",
 CellID->537851269],

Cell[BoxData[
 RowBox[{
  RowBox[{"points", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170938725],

Cell["Only the domain is shown in standard output format:", "ExampleText",
 CellID->226562029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", " ", "=", " ", 
  RowBox[{"Interpolation", "[", "points", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14590076],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->313850972]
}, Open  ]],

Cell["Evaluate the function at a point in the domain:", "ExampleText",
 CellID->219379285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", "[", "2.5", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->410466833],

Cell[BoxData["3.6875`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->146244774]
}, Open  ]],

Cell["\<\
Plot the function over its domain, showing the interpolation points:\
\>", "ExampleText",
 CellID->126505186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ifun", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", " ", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", " ", "points"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->634680573],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWWuIVVUUPs6915nMeaTmODkvtcYZH5Ov0dKsGbOZfKWDmJZmjoN6lXyk
Y4ZhKYUTZg/MKJGaHz1AizI0h8AgEiIhEiIhKgiDsB9JkPRDCE7fWnvv2ees
u+4jcHDu7LXP/tb69nrtfY9LunrSG7Z29Wzu7qrv2Nm1I725e1d9+/admEoM
CoLgDH73jQowDjHi3zNhiL/Rz0Z8JvCoBn+T9i/JY+gpDUL+CartfIpRTeJp
TUTGZ1AvntcKuU7IRarWfKhqy1la07Vp6CKI0flA2Xlh2mrCTO5Oe1FWvxGH
IOnlzL3UKCwZNBC9qJXaLNFzbAwqGv8SsfJEjtlinu3t7cWDttblQVHfO98G
ifffu3jxu9+vXbse9EWer13bHSQYRTv/GDODIjr6+/sx09fXZ/ySgvDy4fMr
V3xw7K0LV6/+k2E/KeREnudSHnKD199o+/+XH+dk4vTpzzB1/Pjb1tPSa4PZ
t4gM4vTY6hMI1PXr/wYtYlWrkE0mf3HulwP7zw3sNUM3y0noRsS613/0809/
vskrAAI0O87s9PLlvzanT3148vvgDZbBa9GCPmKXHEBRvg5lK5h//cjX0EwD
wS6pWil1q2CF8umI4Kajyli+9MMfQF258nfwmuCWUlHlLGP99m2nCfWqYKij
KgTqFcHQo8gPw8Tqw4LZYNWGRL0kmOmo4QJ1iOXdPWcvfPNbdtQIh0IyUC94
kWWMOpe+SwyLVdStLKN9QD2t6mX501OX0A1o6FHkhUrx9CDLoAkF8dVRGwaF
BEK60fAFxxTtZiCTM1CjxK6fZxklhHzPh8Ku4QXynUGZ+siOqnJ5h62QFw64
GkHR0vCmmBdG81NsBlui4X6WQQvk4qujNgyq9+CX/Wd/pOFzLCM4KI98KHAC
E9rPsy5eYBq6anbHiv2Rvapa7G6fYGJ0FAmU7LDclZLYYueyLZhNp9N7RQ3c
XJAec6coKxuJqZKSksBoARUQomF2LQl7vgaJkydPVVVNPHr0mEX7DCyMQ10Y
r8OnRUYOLUhLvfDjHsoPdPpSE4yEj0lKRSJLEVXqjntYhnFQ8PZlLpg7BcoB
RUHD3SIXSmNZOk6w62HZ97dS1cZYwWyXk20XKVNR4wSznWG8QnTU7YLhk2G8
VnOhPMMdYThwZtCwPOaFBn56/qtfn9n7OQ23s4z2hSYWXx210SB8tTWMZ3pF
DhQ4YQvEbKvwgo4aH8bz/wnhBR3VyLLvjltEBG6JeaHJ5Td8RvzNargEjomv
jtpoEvzTToutkmEqaoLgv4ll3/1zoQABkIYbnceRd3SaDVdRE4XuDYKxR5EX
JonM2SCY6jYMyveKbpFRI1TUZBGf9UI2qKTSrSeLWHUJz/CJPdDxI0JERzPL
/qxcF8YrzejI1mObne9RUbAbPO7yGnEnRiMZLbuh1HYny747rWXZn5KFaZki
mK9x3MCFYlhpHRD9Bie9McXxt3W5RmSJ1ZGjX08N4zX6qGAxSs2BaSz7s+kR
YdejKDun81PcOcCSvLxK2KhSbRCKzpxVQnf21awTNmApeFjYuE1FzRCRXCFs
6SjzLcd32uXC1ujY7meG8dpcLmyMVm0YlK/FTmGjWkXNYtl392XCVi4UtIIh
daSlwlaNirpLZM5DLPuO5VHkhdkiYxY7m7byalUbd4fxjrFYeF5HGVu+RywM
432mTkXNYRmNAQcuDRcIxrlQPrcfFHGrj3lhrmDW7jxt78BjVBtzBbMHhJZc
KM9svvAl34eChNIT7hWRvZ9l3+EtUqBkf7uP5Y6OjeZKbd8FmDc4LTOWmNuO
qoVEg66rq8e4uLjYomtr61gusehcnY01JPv7+2fNmtPWtg1bNjq71h1qbp5J
74eMjnx34TaW/TfDuSLCdxTkjXkic03e+M7dkDUa81yOIABIRYv0edkQyzAT
Zf8t0VSQ7wDj1VyZ73IFSUYdwHQEVAxkypVGFWXy0H/DbnG2gaIe3KSi2oX/
TA/2NzYd1SGiME3sa4KKomqkM2SqY2r7/MSYzxbaVeZc9+8ZJqk6TTfx5/Yk
F0n7ZmeyilokUBOcr8CIbiLNKmqxQ4EdDRtdLsBdKEZzE8lALWEZEOurBoGa
Etv9UudZ8xLMfwvBfmj1VNWGQZm3YLTrsc539mY1TUUtc3kFD1Mum2+LaGv2
1J6uojojvkLXs9+UwRgyxWmGijLnLFqkzUY+y+mtIrwAx2CrLTE/8NmfNFzg
OzyvdJmKjolPUxUZdgwOy82bUCzkG3ASvkBdwBhSg8/KvJ1mpcMBBBJwboXj
hBkclAjH7II08X0sBT8jpubNN3mA34akQAeug374hXZ1D2vU7uur6aMCfOB0
7Az/UGybNj1lGjpYIYRQhUlow7cZeBUm+fQInB7XmUnke/IQMEHZlpdXYqao
KAUWCCOgmAS6zaItVOmH5saPvt7a2kpdvD0v4oTqs094NvN/rYJB/wE6anaX
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->54335602]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->674961214],

Cell["\<\
Get an InterpolatingFunction object approximating the solution of a \
differential equation:\
\>", "ExampleText",
 CellID->450599891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"u", " ", "/.", " ", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"u", "''"}], "[", "t", "]"}], " ", "+", " ", 
          RowBox[{"u", "[", "t", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", 
        " ", 
        RowBox[{
         RowBox[{"u", "[", "0", "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
        
        RowBox[{
         RowBox[{
          RowBox[{"u", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "1"}]}], 
       "}"}], ",", " ", "u", ",", " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->756026780],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.141592653589793`"}], "}"}], "}"}], 
    ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194270733]
}, Open  ]],

Cell["Plot the function and its derivative:", "ExampleText",
 CellID->16148586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ifun", "[", "t", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"ifun", "'"}], "[", "t", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->363814996],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->621319642]
}, Open  ]],

Cell["Find the indefinite integral of the solution:", "ExampleText",
 CellID->280737213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"ifun", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->201893979],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"InterpolatingFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "3.141592653589793`"}], "}"}], "}"}], 
     ",", "\<\"<>\"\>"}], "]"}],
   False,
   Editable->False], "[", "t", "]"}]], "Output",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->844230871]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->436278051],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->389375112]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->123699041],

Cell[TextData[{
 "Make an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " with exact data:"
}], "ExampleText",
 CellID->197407402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"points", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0"}], "}"}]}], "}"}]}], ";", 
  RowBox[{"ifun", " ", "=", " ", 
   RowBox[{"Interpolation", "[", "points", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->672405864],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85699538]
}, Open  ]],

Cell["Compute the value using exact arithmetic:", "ExampleText",
 CellID->48473202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", "[", 
  RowBox[{"5", "/", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26771674],

Cell[BoxData[
 FractionBox["59", "16"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->647931]
}, Open  ]],

Cell["Compute using machine number arithmetic:", "ExampleText",
 CellID->89384619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", "[", 
  RowBox[{"N", "[", 
   RowBox[{"5", "/", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12546371],

Cell[BoxData["3.6875`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->90739793]
}, Open  ]],

Cell["Compute using arbitrary precision arithmetic:", "ExampleText",
 CellID->104167853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"5", "/", "2"}], ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->109146484],

Cell[BoxData["3.6875`19.546837200269284"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->448874108]
}, Open  ]],

Cell[TextData[{
 "Make a new ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " with numerical values of all the data:"
}], "ExampleText",
 CellID->551703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nifun", " ", "=", " ", 
  RowBox[{"N", "[", "ifun", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->304925377],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "5.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->244426090]
}, Open  ]],

Cell[TextData[{
 "With this ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " values are computed using machine arithmetic:"
}], "ExampleText",
 CellID->274358029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nifun", "[", 
  RowBox[{"5", "/", "2"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->4401116],

Cell[BoxData["3.6875`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->406945059]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301895863],

Cell[TextData[{
 "Integrate an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->113492585],

Cell[BoxData[
 RowBox[{
  RowBox[{"ifun", " ", "=", " ", 
   RowBox[{"Interpolation", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "0"}], "}"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444668077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"ifun", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282189792],

Cell[BoxData[
 FractionBox["271", "24"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->659867331]
}, Open  ]],

Cell[TextData[{
 "Make a new ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " that is the indefinite integral:"
}], "ExampleText",
 CellID->88080372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"indef", "[", "x_", "]"}], " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"ifun", "[", "x", "]"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->219209819],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"InterpolatingFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
   False,
   Editable->False], "[", "x", "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->242507151]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ifun", "[", "x", "]"}], ",", " ", 
     RowBox[{"indef", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->541551268],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->76579616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23998086],

Cell[TextData[{
 "The derivative of an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " is another ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->59155920],

Cell[BoxData[
 RowBox[{
  RowBox[{"ifun", " ", "=", " ", 
   RowBox[{"Interpolation", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "0"}], "}"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->599575159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"difun", " ", "=", " ", 
  RowBox[{"ifun", "'"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250392216],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->400824878]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ifun", "[", "x", "]"}], ",", " ", 
     RowBox[{"difun", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->652002546],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->695045760]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171197],

Cell[TextData[{
 "Use partial derivatives of an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " to check the residual for a PDE:"
}], "ExampleText",
 CellID->47049274],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], " ", "\[Equal]",
         " ", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}]}], ",",
        " ", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"0", ",", "x"}], "]"}], " ", "\[Equal]", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "100"}], " ", 
          RowBox[{"x", "^", "2"}]}], "]"}]}], ",", " ", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "0"}], "]"}], " ", "\[Equal]", " ", "1"}], ",", 
       " ", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "1"}], "]"}], " ", "\[Equal]", " ", "0"}]}], "}"}],
      ",", " ", "u", ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"ifun", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"u", " ", "/.", " ", "sol"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->341712691],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29907655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"1", ",", "0"}], "]"}], "[", "ifun", "]"}], "[", 
     RowBox[{"1", ",", "x"}], "]"}], " ", "-", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"0", ",", "2"}], "]"}], "[", "ifun", "]"}], "[", 
     RowBox[{"1", ",", "x"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114242718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7757185]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37064866],

Cell[TextData[{
 "Make an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " that takes 4 arguments:"
}], "ExampleText",
 CellID->60080868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", " ", "=", " ", 
  RowBox[{"ListInterpolation", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", " ", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5", ",", "5", ",", "5"}], "}"}]}], "]"}], ",", " ", 
    
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48187113],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "2.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "3.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "4.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{451, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295125671]
}, Open  ]],

Cell["Integrate it across the first and last dimensions. ", "ExampleText",
 CellID->391609200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"integ", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"ifun", "[", 
     RowBox[{"x1", ",", " ", "x2", ",", " ", "x3", ",", " ", "x4"}], "]"}], 
    ",", " ", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x4", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32962015],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"InterpolatingFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "2.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "3.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
    "]"}],
   False,
   Editable->False], "[", 
  RowBox[{"x2", ",", "x3"}], "]"}]], "Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156833042]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"integ", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x2", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x3", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19748533],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->599090343]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->135299689],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " does a ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " polynomial interpolation:"
}], "ExampleText",
 CellID->13977696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"points", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0"}], "}"}]}], "}"}]}], ";", 
  RowBox[{"ifun", " ", "=", " ", 
   RowBox[{"Interpolation", "[", "points", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16929594],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72803770]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"pf", "[", "x_", "]"}], " ", "=", " ", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InterpolatingPolynomial", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", " ", "x"}], "]"}], 
       ",", " ", 
       RowBox[{"x", " ", "<", " ", "2"}]}], "}"}], ",", "\[IndentingNewLine]",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InterpolatingPolynomial", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "3"}], "}"}]}], "}"}], ",", " ", "x"}], "]"}], 
       ",", " ", 
       RowBox[{"2", " ", "\[LessEqual]", " ", "x", " ", "<", " ", "3"}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InterpolatingPolynomial", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"5", ",", "0"}], "}"}]}], "}"}], ",", " ", "x"}], "]"}], 
       ",", " ", 
       RowBox[{"x", " ", "\[GreaterEqual]", "  ", "3"}]}], "}"}]}], 
    "\[IndentingNewLine]", "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68312553],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNms1OE1EUgIdOS1uggAi0/oYIxMSFS3VjdKOuTIzxBRpiAgtjAyzQDS+g
Nq54BBaasNeFj8DCxFdgySNc507n0ttvzsyZtjShCTNz7px7/u+559zhdXt/
+/2H9v7OVnvt1W67s72ztbf28uNuNBROBcHUehAET1tB9Gyip/jP/jaiv95j
72ndXkP31gS3AM8Cvgf4Z0wltNfywcHBn/h3dnZGOncA1wFvAP7RpxseHh4m
o9XoYpFqwJ4GXEnwGtG9FN1Lyb0MvCrgmehSiUDSKyt0DvC+ktBx8rZEbWIu
lQsqMU6QkomyEG7EAvbhHndNyzRfyYb5dD+lMEijJnJqitaYwdwwwxfWxtOJ
D9z7koBHrUsJPn1XUeh8TsZryX0O71cKaUPbSVqlLbVYUDfKJMVMnm4z3l3X
zVlCW4W9rODHx0JqRIvVhmLHUaK0Cq3l1UlbzAP248j6at4Ml2tIb1aZL+WY
vBiQfSfnnGuS5zzdmnjP7F0Xqa4CqytiydnAZc7rgmQlgTb3qXoyn3jfTV5G
tpe7V/TNC09ya4HfmVi+vi0Pttb+Jc7i7twCTOs2QZVr5THgPZHrbYUrI7pp
5AxMbrsjcfN1DFyE5NjgcrhSF+ddcqOFWYcxG2j4z0VpWbVR2keAuQOwiqNU
Gv4zUSqbs1w1pe2hEh7hG4BvKvj1DLpaVTiparORzKt4dx+f2dlVw6FoXfqk
iJX1qpVwL55PT08P418sQAx7MqYjp48/B/xQ4SfvSMTSqwfNh1rlpXNoiJLS
h+UUHVeFVcX5sZdUX/u1b9b+77SSVsBgTX1+fj7g3Qj26FUudO/jzQl4RWr4
LPmy6lzNi46u5P08uqzh/MrY+cberY+jpjyYsvdCntFWoabRuDmP+48kzyiW
HrVTWQDscp6r4eumv28OWjpeCeHR0dHx8bEx6dpVs7TWuY1r6fEzyORz1GKG
l6qpmaw7HGbo+aIf9fSFxCcvCqy37fpcMl5HmnsiofWXc2a8PZ221k6g2HmR
Xoj5y0aO706n0+12i9hU3r8pB+2yTDt4MlFm5rKcU6AhakVmJHZ28yKXTXFU
3h1dtmbPabFDYZy+5ntHjzHINVJL6GsW4TyX8zhvMaF33+TVfcN2JowAPWtM
pkNa8mDrS8Z3Ma5ax+v2lRWMc8cv1unay1U9V3hgBs8V/mVi5e1qf8VZjFhG
KrMhvcAc8ATwN5ErM6C2rrhja1y/jsSV54U8maGtLocrdaWFOZ9S8PsQ6clS
0YKU6qFi8U2F65dCXLPOA5iPufdpFdtMBt1hzwOI/8bk9/GuG5FPTKm9VqnI
PV/xDn0a+OzQSwp/5vXxe/P0jLepkfyueTTL5nfRelc8DTx2xZols7pX7csW
9XB478xg98qcIJ+djxt/w65CLX5G1bpu5NU3mVV32VpPZtUwAsh1dSTbsHJz
+c1WeGEgdZfa10JaR/smN2xGZg2c/X10GL0ZE0uALXe/3xK/sntw3tcaY9KZ
vBMPFsuFXBVOJvY+5JHVGxXtcVi3cJ6t8l0V6/4f5eTkpJdRo01Jq0g0eWOb
D8QivSrXazyx0Piyu+F8mQsjilzcKQK7GXb5cn1tH3v/LRRM/QfvFupk\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{291, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->436732563]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"pf", "[", "x", "]"}], " ", "-", " ", 
    RowBox[{"ifun", "[", "x", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->142369932],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->360463172]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11303],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompiledFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CompiledFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2001]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2518],

Cell[TextData[ButtonBox["Numerical Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalDifferentialEquations"]], "Tutorials",
 CellID->28783],

Cell[TextData[ButtonBox["Expressions with Heads That Are Not Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"]], "Tutorials",
 CellID->1403],

Cell[TextData[ButtonBox["Approximate Functions and Interpolation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApproximateFunctionsAndInterpolation"]], "Tutorials",
 CellID->4031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->26861],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#16712"], None}]], "RelatedLinks",
 CellID->14565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->191676560],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CurveFittingAndApproximateFunctions"]], "MoreAbout",\

 CellID->227043425],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "MoreAbout",
 CellID->33131062]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InterpolatingFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 19.3844052}", "context" -> "System`", 
    "keywords" -> {
     "approximate functions", "Hermite interpolation", 
      "piecewise polynomial interpolation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InterpolatingFunction[domain, table] represents an approximate function \
whose values are found by interpolation. ", 
    "synonyms" -> {"interpolating function"}, "title" -> 
    "InterpolatingFunction", "type" -> "Symbol", "uri" -> 
    "ref/InterpolatingFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7887, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->303652191]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 85424, 2240}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3205, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3828, 98, 59, 1, 70, "ObjectName",
 CellID->14195],
Cell[3890, 101, 609, 18, 70, "Usage",
 CellID->28252]
}, Open  ]],
Cell[CellGroupData[{
Cell[4536, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5014, 141, 331, 12, 70, "Notes",
 CellID->21959],
Cell[5348, 155, 348, 11, 70, "Notes",
 CellID->9600],
Cell[5699, 168, 547, 17, 70, "Notes",
 CellID->25883],
Cell[6249, 187, 326, 10, 70, "Notes",
 CellID->6117],
Cell[6578, 199, 158, 4, 70, "Notes",
 CellID->28900],
Cell[6739, 205, 261, 7, 70, "Notes",
 CellID->32579],
Cell[7003, 214, 486, 18, 70, "Notes",
 CellID->32711],
Cell[7492, 234, 358, 12, 70, "Notes",
 CellID->21574]
}, Closed]],
Cell[CellGroupData[{
Cell[7887, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->303652191],
Cell[CellGroupData[{
Cell[8272, 265, 148, 5, 70, "ExampleSection",
 CellID->352021709],
Cell[8423, 272, 262, 8, 70, "ExampleText",
 CellID->537851269],
Cell[8688, 282, 532, 18, 70, "Input",
 CellID->170938725],
Cell[9223, 302, 94, 1, 70, "ExampleText",
 CellID->226562029],
Cell[CellGroupData[{
Cell[9342, 307, 149, 4, 28, "Input",
 CellID->14590076],
Cell[9494, 313, 356, 13, 36, "Output",
 CellID->313850972]
}, Open  ]],
Cell[9865, 329, 90, 1, 70, "ExampleText",
 CellID->219379285],
Cell[CellGroupData[{
Cell[9980, 334, 102, 3, 70, "Input",
 CellID->410466833],
Cell[10085, 339, 164, 5, 36, "Output",
 CellID->146244774]
}, Open  ]],
Cell[10264, 347, 119, 3, 70, "ExampleText",
 CellID->126505186],
Cell[CellGroupData[{
Cell[10408, 354, 341, 10, 28, "Input",
 CellID->634680573],
Cell[10752, 366, 2713, 49, 146, "Output",
 Evaluatable->False,
 CellID->54335602]
}, Open  ]],
Cell[13480, 418, 125, 3, 70, "ExampleDelimiter",
 CellID->674961214],
Cell[13608, 423, 143, 4, 70, "ExampleText",
 CellID->450599891],
Cell[CellGroupData[{
Cell[13776, 431, 802, 25, 70, "Input",
 CellID->756026780],
Cell[14581, 458, 380, 14, 36, "Output",
 CellID->194270733]
}, Open  ]],
Cell[14976, 475, 79, 1, 70, "ExampleText",
 CellID->16148586],
Cell[CellGroupData[{
Cell[15080, 480, 335, 11, 28, "Input",
 CellID->363814996],
Cell[15418, 493, 3311, 58, 128, "Output",
 Evaluatable->False,
 CellID->621319642]
}, Open  ]],
Cell[18744, 554, 88, 1, 70, "ExampleText",
 CellID->280737213],
Cell[CellGroupData[{
Cell[18857, 559, 160, 5, 70, "Input",
 CellID->201893979],
Cell[19020, 566, 416, 15, 36, "Output",
 CellID->844230871]
}, Open  ]],
Cell[CellGroupData[{
Cell[19473, 586, 191, 6, 28, "Input",
 CellID->436278051],
Cell[19667, 594, 2327, 42, 142, "Output",
 Evaluatable->False,
 CellID->389375112]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22043, 642, 220, 7, 70, "ExampleSection",
 CellID->123699041],
Cell[22266, 651, 233, 8, 70, "ExampleText",
 CellID->197407402],
Cell[CellGroupData[{
Cell[22524, 663, 619, 20, 70, "Input",
 CellID->672405864],
Cell[23146, 685, 355, 13, 36, "Output",
 CellID->85699538]
}, Open  ]],
Cell[23516, 701, 83, 1, 70, "ExampleText",
 CellID->48473202],
Cell[CellGroupData[{
Cell[23624, 706, 122, 4, 70, "Input",
 CellID->26771674],
Cell[23749, 712, 177, 6, 51, "Output",
 CellID->647931]
}, Open  ]],
Cell[23941, 721, 82, 1, 70, "ExampleText",
 CellID->89384619],
Cell[CellGroupData[{
Cell[24048, 726, 151, 5, 70, "Input",
 CellID->12546371],
Cell[24202, 733, 163, 5, 36, "Output",
 CellID->90739793]
}, Open  ]],
Cell[24380, 741, 88, 1, 70, "ExampleText",
 CellID->104167853],
Cell[CellGroupData[{
Cell[24493, 746, 178, 6, 70, "Input",
 CellID->109146484],
Cell[24674, 754, 183, 5, 36, "Output",
 CellID->448874108]
}, Open  ]],
Cell[24872, 762, 255, 8, 70, "ExampleText",
 CellID->551703],
Cell[CellGroupData[{
Cell[25152, 774, 137, 4, 70, "Input",
 CellID->304925377],
Cell[25292, 780, 360, 13, 36, "Output",
 CellID->244426090]
}, Open  ]],
Cell[25667, 796, 264, 8, 70, "ExampleText",
 CellID->274358029],
Cell[CellGroupData[{
Cell[25956, 808, 122, 4, 70, "Input",
 CellID->4401116],
Cell[26081, 814, 164, 5, 36, "Output",
 CellID->406945059]
}, Open  ]],
Cell[26260, 822, 125, 3, 70, "ExampleDelimiter",
 CellID->301895863],
Cell[26388, 827, 222, 8, 70, "ExampleText",
 CellID->113492585],
Cell[26613, 837, 590, 19, 70, "Input",
 CellID->444668077],
Cell[CellGroupData[{
Cell[27228, 860, 219, 7, 70, "Input",
 CellID->282189792],
Cell[27450, 869, 181, 6, 51, "Output",
 CellID->659867331]
}, Open  ]],
Cell[27646, 878, 251, 8, 70, "ExampleText",
 CellID->88080372],
Cell[CellGroupData[{
Cell[27922, 890, 233, 7, 70, "Input",
 CellID->219209819],
Cell[28158, 899, 391, 14, 36, "Output",
 CellID->242507151]
}, Open  ]],
Cell[CellGroupData[{
Cell[28586, 918, 310, 10, 70, "Input",
 CellID->541551268],
Cell[28899, 930, 3225, 57, 70, "Output",
 Evaluatable->False,
 CellID->76579616]
}, Open  ]],
Cell[32139, 990, 124, 3, 70, "ExampleDelimiter",
 CellID->23998086],
Cell[32266, 995, 391, 13, 70, "ExampleText",
 CellID->59155920],
Cell[32660, 1010, 590, 19, 70, "Input",
 CellID->599575159],
Cell[CellGroupData[{
Cell[33275, 1033, 127, 4, 70, "Input",
 CellID->250392216],
Cell[33405, 1039, 356, 13, 36, "Output",
 CellID->400824878]
}, Open  ]],
Cell[CellGroupData[{
Cell[33798, 1057, 310, 10, 70, "Input",
 CellID->652002546],
Cell[34111, 1069, 3291, 58, 70, "Output",
 Evaluatable->False,
 CellID->695045760]
}, Open  ]],
Cell[37417, 1130, 122, 3, 70, "ExampleDelimiter",
 CellID->171197],
Cell[37542, 1135, 270, 8, 70, "ExampleText",
 CellID->47049274],
Cell[CellGroupData[{
Cell[37837, 1147, 1345, 41, 70, "Input",
 CellID->341712691],
Cell[39185, 1190, 450, 17, 36, "Output",
 CellID->29907655]
}, Open  ]],
Cell[CellGroupData[{
Cell[39672, 1212, 594, 18, 70, "Input",
 CellID->114242718],
Cell[40269, 1232, 4931, 85, 70, "Output",
 Evaluatable->False,
 CellID->7757185]
}, Open  ]],
Cell[45215, 1320, 124, 3, 70, "ExampleDelimiter",
 CellID->37064866],
Cell[45342, 1325, 239, 8, 70, "ExampleText",
 CellID->60080868],
Cell[CellGroupData[{
Cell[45606, 1337, 618, 20, 70, "Input",
 CellID->48187113],
Cell[46227, 1359, 589, 21, 36, "Output",
 CellID->295125671]
}, Open  ]],
Cell[46831, 1383, 94, 1, 70, "ExampleText",
 CellID->391609200],
Cell[CellGroupData[{
Cell[46950, 1388, 407, 12, 70, "Input",
 CellID->32962015],
Cell[47360, 1402, 515, 19, 36, "Output",
 CellID->156833042]
}, Open  ]],
Cell[CellGroupData[{
Cell[47912, 1426, 263, 8, 70, "Input",
 CellID->19748533],
Cell[48178, 1436, 23258, 385, 70, "Output",
 Evaluatable->False,
 CellID->599090343]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[71485, 1827, 237, 7, 70, "ExampleSection",
 CellID->135299689],
Cell[71725, 1836, 362, 12, 70, "ExampleText",
 CellID->13977696],
Cell[CellGroupData[{
Cell[72112, 1852, 618, 20, 70, "Input",
 CellID->16929594],
Cell[72733, 1874, 355, 13, 36, "Output",
 CellID->72803770]
}, Open  ]],
Cell[CellGroupData[{
Cell[73125, 1892, 1984, 58, 70, "Input",
 CellID->68312553],
Cell[75112, 1952, 1854, 34, 70, "Output",
 Evaluatable->False,
 CellID->436732563]
}, Open  ]],
Cell[CellGroupData[{
Cell[77003, 1991, 340, 10, 70, "Input",
 CellID->142369932],
Cell[77346, 2003, 2432, 44, 70, "Output",
 Evaluatable->False,
 CellID->360463172]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79839, 2054, 311, 9, 70, "SeeAlsoSection",
 CellID->11303],
Cell[80153, 2065, 1751, 62, 70, "SeeAlso",
 CellID->2001]
}, Open  ]],
Cell[CellGroupData[{
Cell[81941, 2132, 313, 9, 70, "TutorialsSection",
 CellID->2518],
Cell[82257, 2143, 173, 3, 70, "Tutorials",
 CellID->28783],
Cell[82433, 2148, 193, 4, 70, "Tutorials",
 CellID->1403],
Cell[82629, 2154, 188, 4, 70, "Tutorials",
 CellID->4031]
}, Open  ]],
Cell[CellGroupData[{
Cell[82854, 2163, 321, 9, 70, "RelatedLinksSection",
 CellID->26861],
Cell[83178, 2174, 267, 6, 70, "RelatedLinks",
 CellID->14565]
}, Open  ]],
Cell[CellGroupData[{
Cell[83482, 2185, 319, 9, 70, "MoreAboutSection",
 CellID->191676560],
Cell[83804, 2196, 186, 4, 70, "MoreAbout",
 CellID->227043425],
Cell[83993, 2202, 154, 3, 70, "MoreAbout",
 CellID->33131062]
}, Open  ]],
Cell[84162, 2208, 50, 0, 70, "History"],
Cell[84215, 2210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

