(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33344,        955]
NotebookOptionsPosition[     28945,        812]
NotebookOutlinePosition[     30498,        853]
CellTagsIndexPosition[     30413,        848]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defer" :> Documentation`HelpLookup["paclet:ref/Defer"], 
          "DynamicSetting" :> 
          Documentation`HelpLookup["paclet:ref/DynamicSetting"], "Hold" :> 
          Documentation`HelpLookup["paclet:ref/Hold"], "DialogInput" :> 
          Documentation`HelpLookup["paclet:ref/DialogInput"], "DynamicModule" :> 
          Documentation`HelpLookup["paclet:ref/DynamicModule"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Defer\"\>", 
       2->"\<\"DynamicSetting\"\>", 3->"\<\"Hold\"\>", 
       4->"\<\"DialogInput\"\>", 
       5->"\<\"DynamicModule\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Custom Notation" :> 
          Documentation`HelpLookup["paclet:guide/DefiningCustomNotation"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedInput"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Defining Custom Notation\"\>", 
       2->"\<\"Generalized Input\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Interpretation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interpretation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interpretation"], "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an object which displays as ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     ", but is interpreted as the unevaluated form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " if supplied as input. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interpretation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interpretation"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], "=", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          RowBox[{
           StyleBox["y", "TI"], "=", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["e", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]allows local variables ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->8339]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Interpretation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpretation"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["vars", "TI"], "}"}], ",", 
    StyleBox["e", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " localizes variables like ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32094],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Interpretation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpretation"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", but evaluates ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " immediately after localizing variables. It makes ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " be evaluated only when the ",
 Cell[BoxData[
  ButtonBox["Interpretation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpretation"]], "InlineFormula"],
 " object is supplied as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input."
}], "Notes",
 CellID->7846],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Interpretation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpretation"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["vars", "TI"], "}"}], ",", 
    StyleBox["e", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " allows the following options, as in ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->4048],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Deinitialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deinitialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "an expression to evaluate when the ",
     Cell[BoxData[
      ButtonBox["Interpretation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Interpretation"]], "InlineFormula"],
     " can no longer be displayed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DynamicModuleValues",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DynamicModuleValues"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "dynamically updated data on variable values ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Initialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Initialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "an expression to evaluate when the ",
     Cell[BoxData[
      ButtonBox["Interpretation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Interpretation"]], "InlineFormula"],
     " is first displayed "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->18839]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->487421266],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->11157988],

Cell["Specify an interpretation for a string:", "ExampleText",
 CellID->1912196337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpretation", "[", 
  RowBox[{"\"\<x\>\"", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1191058604],

Cell[BoxData[
 InterpretationBox["\<\"x\"\>",
  1]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->450574795]
}, Open  ]],

Cell["\<\
Copy and paste the output above to use the string in calculations:\
\>", "ExampleText",
 CellID->685148938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  InterpretationBox["\"\<x\>\"",
   1], "+", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->199904994],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->728075129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135891425],

Cell["Specify scoped variables: ", "ExampleText",
 CellID->47886644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpretation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0.5"}], "}"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->424120117],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
   InterpretationBox[
    SliderBox[Dynamic[$CellContext`x$$]],
    $CellContext`x$$],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548170854]
}, Open  ]],

Cell["Copying and evaluating: ", "ExampleText",
 CellID->247062344],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   TagBox[
    DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
     InterpretationBox[
      SliderBox[Dynamic[$CellContext`x$$]],
      $CellContext`x$$],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ")"}], "2"]], "Input",
 CellLabel->"In[2]:=",
 CellID->29591880],

Cell[BoxData["0.25`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66096405]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Interpret a 2D graphic as a 3D graphic:", "ExampleText",
 CellID->304255635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpretation", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227258850],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[DiskBox[{0, 0}],
   ImageSize->Tiny],
  Graphics3D[
   Sphere[], ImageSize -> Tiny]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133493312]
}, Open  ]],

Cell["\<\
Copy, paste and evaluate the ouput above to get the resulting interpretation:\
\
\>", "ExampleText",
 CellID->465893938],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[DiskBox[{0, 0}],
   ImageSize->Tiny],
  Graphics3D[
   Sphere[], ImageSize -> Tiny]]], "Input",
 CellLabel->"In[2]:=",
 CellID->512194299],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  ImageSize->Tiny]], "Output",
 ImageSize->{96, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18800832,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Defer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Defer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DynamicSetting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DynamicSetting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DynamicModule",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DynamicModule"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "MoreAbout",
 CellID->418676595],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedInput"]], "MoreAbout",
 CellID->49645761]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interpretation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 36.4004658}", "context" -> "System`", 
    "keywords" -> {
     "interpretation of strings", "interpretation of expressions", 
      "interpretation of graphics", "interpretation of formulas", 
      "interpretation of controls"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Interpretation[e, expr] represents an object which displays as e, but is \
interpreted as the unevaluated form of expr if supplied as input. \
Interpretation[{x = x_0, y = y_0, ...}, e, expr] allows local variables x, y, \
... in e and expr.", "synonyms" -> {}, "title" -> "Interpretation", "type" -> 
    "Symbol", "uri" -> "ref/Interpretation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10460, 323, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->487421266]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30269, 841}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2298, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2921, 81, 1579, 37, 70, "ObjectNameGrid"],
Cell[4503, 120, 1932, 62, 70, "Usage",
 CellID->8339]
}, Open  ]],
Cell[CellGroupData[{
Cell[6472, 187, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6950, 204, 500, 18, 70, "Notes",
 CellID->32094],
Cell[7453, 224, 756, 26, 70, "Notes",
 CellID->7846],
Cell[8212, 252, 511, 18, 70, "Notes",
 CellID->4048],
Cell[8726, 272, 1697, 46, 70, "3ColumnTableMod",
 CellID->18839]
}, Closed]],
Cell[CellGroupData[{
Cell[10460, 323, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->487421266],
Cell[CellGroupData[{
Cell[10845, 337, 147, 5, 70, "ExampleSection",
 CellID->11157988],
Cell[10995, 344, 83, 1, 70, "ExampleText",
 CellID->1912196337],
Cell[CellGroupData[{
Cell[11103, 349, 142, 4, 28, "Input",
 CellID->1191058604],
Cell[11248, 355, 192, 7, 36, "Output",
 CellID->450574795]
}, Open  ]],
Cell[11455, 365, 117, 3, 70, "ExampleText",
 CellID->685148938],
Cell[CellGroupData[{
Cell[11597, 372, 128, 5, 28, "Input",
 CellID->199904994],
Cell[11728, 379, 158, 5, 36, "Output",
 CellID->728075129]
}, Open  ]],
Cell[11901, 387, 125, 3, 70, "ExampleDelimiter",
 CellID->135891425],
Cell[12029, 392, 68, 1, 70, "ExampleText",
 CellID->47886644],
Cell[CellGroupData[{
Cell[12122, 397, 264, 8, 70, "Input",
 CellID->424120117],
Cell[12389, 407, 348, 12, 70, "Output",
 CellID->548170854]
}, Open  ]],
Cell[12752, 422, 67, 1, 70, "ExampleText",
 CellID->247062344],
Cell[CellGroupData[{
Cell[12844, 427, 318, 11, 70, "Input",
 CellID->29591880],
Cell[13165, 440, 161, 5, 36, "Output",
 CellID->66096405]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13375, 451, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[13599, 460, 82, 1, 70, "ExampleText",
 CellID->304255635],
Cell[CellGroupData[{
Cell[13706, 465, 403, 12, 70, "Input",
 CellID->227258850],
Cell[14112, 479, 276, 10, 121, "Output",
 CellID->133493312]
}, Open  ]],
Cell[14403, 492, 130, 4, 70, "ExampleText",
 CellID->465893938],
Cell[CellGroupData[{
Cell[14558, 500, 186, 7, 70, "Input",
 CellID->512194299],
Cell[14747, 509, 11392, 192, 121, 81, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->18800832]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26200, 708, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[26519, 719, 1204, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[27760, 768, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[28081, 779, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[28266, 787, 299, 8, 70, "MoreAboutSection"],
Cell[28568, 797, 158, 3, 70, "MoreAbout",
 CellID->418676595],
Cell[28729, 802, 144, 3, 70, "MoreAbout",
 CellID->49645761]
}, Open  ]],
Cell[28888, 808, 27, 0, 70, "History"],
Cell[28918, 810, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

