(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14723,        523]
NotebookOptionsPosition[     11222,        404]
NotebookOutlinePosition[     12428,        439]
CellTagsIndexPosition[     12343,        434]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interrupts and Aborts" :> 
          Documentation`HelpLookup["paclet:tutorial/InterruptsAndAborts"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Interrupts and Aborts\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abort" :> Documentation`HelpLookup["paclet:ref/Abort"], 
          "TimeConstrained" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstrained"], 
          "MemoryConstrained" :> 
          Documentation`HelpLookup["paclet:ref/MemoryConstrained"], "Throw" :> 
          Documentation`HelpLookup["paclet:ref/Throw"], "$Inspector" :> 
          Documentation`HelpLookup["paclet:ref/$Inspector"], "LinkInterrupt" :> 
          Documentation`HelpLookup["paclet:ref/LinkInterrupt"], "$Aborted" :> 
          Documentation`HelpLookup["paclet:ref/$Aborted"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abort\"\>", 
       2->"\<\"TimeConstrained\"\>", 3->"\<\"MemoryConstrained\"\>", 
       4->"\<\"Throw\"\>", 5->"\<\"$Inspector\"\>", 
       6->"\<\"LinkInterrupt\"\>", 7->"\<\"$Aborted\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Flow Control\"\>", 
       2->"\<\"Looping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Interrupt", "ObjectName",
 CellID->19096],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interrupt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interrupt"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]generates an interrupt. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can call ",
 Cell[BoxData[
  ButtonBox["Interrupt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interrupt"]], "InlineFormula"],
 " anywhere within a computation. It has the same effect as an interactive \
interrupt at that point. "
}], "Notes",
 CellID->8476]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->712312346],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->522905607],

Cell["\<\
Interrupt a computation, bringing up a dialog box. The result here is from \
choosing to abort:\
\>", "ExampleText",
 CellID->16555032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", "a", "]"}], ";", " ", 
  RowBox[{"Interrupt", "[", "]"}], ";", " ", 
  RowBox[{"Print", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306308074],

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->580223299],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96482278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29181185],

Cell["\<\
A computation where a dialog box is brought up for every second of time \
taken:\
\>", "ExampleText",
 CellID->19155491],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"SessionTime", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"Pause", "[", 
       RowBox[{"i", "/", "10"}], "]"}], ";", " ", "i"}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"SessionTime", "[", "]"}], "-", "s"}], ">", "1"}], ",", 
      RowBox[{
       RowBox[{"Interrupt", "[", "]"}], ";", 
       RowBox[{"Print", "[", "\"\<Continued\>\"", "]"}], ";", 
       RowBox[{"s", " ", "=", " ", 
        RowBox[{"SessionTime", "[", "]"}]}]}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1000000"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->739110913],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->46795353],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->13206613],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->137051294],

Cell[BoxData["4"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->394228730],

Cell[BoxData["\<\"Continued\"\>"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->970361762],

Cell[BoxData["5"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->191562871],

Cell[BoxData["6"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->50606653],

Cell[BoxData["\<\"Continued\"\>"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->365231261],

Cell[BoxData["7"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->687543919],

Cell[BoxData["8"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->231199106]
}, Open  ]],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->436468637]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11922],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemoryConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemoryConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Inspector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Inspector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkInterrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkInterrupt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Aborted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Aborted"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17567]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11771],

Cell[TextData[ButtonBox["Interrupts and Aborts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InterruptsAndAborts"]], "Tutorials",
 CellID->23095]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->57061188],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->83277417]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interrupt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 37.3223644}", "context" -> "System`", 
    "keywords" -> {"abort", "terminate", "subsession", "dialog"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Interrupt[] generates an interrupt. ", "synonyms" -> {}, "title" -> 
    "Interrupt", "type" -> "Symbol", "uri" -> "ref/Interrupt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4471, 138, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->712312346]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12200, 427}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2521, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3144, 85, 47, 1, 70, "ObjectName",
 CellID->19096],
Cell[3194, 88, 439, 14, 70, "Usage",
 CellID->32619]
}, Open  ]],
Cell[CellGroupData[{
Cell[3670, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4148, 124, 286, 9, 70, "Notes",
 CellID->8476]
}, Closed]],
Cell[CellGroupData[{
Cell[4471, 138, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->712312346],
Cell[CellGroupData[{
Cell[4856, 152, 148, 5, 70, "ExampleSection",
 CellID->522905607],
Cell[5007, 159, 145, 4, 70, "ExampleText",
 CellID->16555032],
Cell[CellGroupData[{
Cell[5177, 167, 207, 6, 70, "Input",
 CellID->306308074],
Cell[5387, 175, 91, 2, 23, "Print",
 CellID->580223299],
Cell[5481, 179, 164, 5, 36, "Output",
 CellID->96482278]
}, Open  ]],
Cell[5660, 187, 124, 3, 70, "ExampleDelimiter",
 CellID->29181185],
Cell[5787, 192, 130, 4, 70, "ExampleText",
 CellID->19155491],
Cell[CellGroupData[{
Cell[5942, 200, 825, 25, 70, "Input",
 CellID->739110913],
Cell[CellGroupData[{
Cell[6792, 229, 90, 2, 70, "Print",
 CellID->46795353],
Cell[6885, 233, 90, 2, 70, "Print",
 CellID->13206613],
Cell[6978, 237, 91, 2, 70, "Print",
 CellID->137051294],
Cell[7072, 241, 91, 2, 70, "Print",
 CellID->394228730],
Cell[7166, 245, 107, 2, 70, "Print",
 CellID->970361762],
Cell[7276, 249, 91, 2, 70, "Print",
 CellID->191562871],
Cell[7370, 253, 90, 2, 70, "Print",
 CellID->50606653],
Cell[7463, 257, 107, 2, 70, "Print",
 CellID->365231261],
Cell[7573, 261, 91, 2, 70, "Print",
 CellID->687543919],
Cell[7667, 265, 91, 2, 70, "Print",
 CellID->231199106]
}, Open  ]],
Cell[7773, 270, 165, 5, 36, "Output",
 CellID->436468637]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7999, 282, 311, 9, 70, "SeeAlsoSection",
 CellID->11922],
Cell[8313, 293, 1710, 62, 70, "SeeAlso",
 CellID->17567]
}, Open  ]],
Cell[CellGroupData[{
Cell[10060, 360, 314, 9, 70, "TutorialsSection",
 CellID->11771],
Cell[10377, 371, 151, 3, 70, "Tutorials",
 CellID->23095]
}, Open  ]],
Cell[CellGroupData[{
Cell[10565, 379, 299, 8, 70, "MoreAboutSection"],
Cell[10867, 389, 134, 3, 70, "MoreAbout",
 CellID->57061188],
Cell[11004, 394, 146, 3, 70, "MoreAbout",
 CellID->83277417]
}, Open  ]],
Cell[11165, 400, 27, 0, 70, "History"],
Cell[11195, 402, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

