(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39080,       1482]
NotebookOptionsPosition[     30367,       1175]
NotebookOutlinePosition[     31795,       1214]
CellTagsIndexPosition[     31709,       1209]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding Limits" :> 
          Documentation`HelpLookup["paclet:tutorial/FindingLimits"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Finding Limits\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Range" :> Documentation`HelpLookup["paclet:ref/Range"], 
          "IntervalMemberQ" :> 
          Documentation`HelpLookup["paclet:ref/IntervalMemberQ"], 
          "IntervalUnion" :> 
          Documentation`HelpLookup["paclet:ref/IntervalUnion"], 
          "IntervalIntersection" :> 
          Documentation`HelpLookup["paclet:ref/IntervalIntersection"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Range\"\>", 
       2->"\<\"IntervalMemberQ\"\>", 3->"\<\"IntervalUnion\"\>", 
       4->"\<\"IntervalIntersection\"\>", 
       5->"\<\"Piecewise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval Arithmetic" :> 
          Documentation`HelpLookup["paclet:guide/IntervalArithmetic"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Interval Arithmetic\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Interval", "ObjectName",
 CellID->20078],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interval",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interval"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["min", "TI"], ",", 
         StyleBox["max", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the range of values between ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interval",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interval"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["min", "TI"], 
           StyleBox["1", "TR"]], 
          RowBox[{",", 
           SubscriptBox[
            StyleBox["max", "TI"], 
            StyleBox["1", "TR"]]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["min", "TI"], 
           StyleBox["2", "TR"]], 
          RowBox[{",", 
           SubscriptBox[
            StyleBox["max", "TI"], 
            StyleBox["2", "TR"]]}]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the union of the ranges ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["min", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["max", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["min", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["max", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21349]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can perform arithmetic and other operations on ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->8330],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Min",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Min"], "[", 
   StyleBox["interval", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"], "[", 
   StyleBox["interval", "TI"], "]"}]], "InlineFormula"],
 " give the end points of an interval. "
}], "Notes",
 CellID->14964],

Cell[TextData[{
 "For approximate machine\[Hyphen] or arbitrary\[Hyphen]precision numbers ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Interval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interval"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " yields an interval reflecting the uncertainty in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21695],

Cell[TextData[{
 "In operations on intervals that involve approximate numbers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always rounds lower limits down and upper limits up. "
}], "Notes",
 CellID->27772],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 " can be generated by functions such as ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31646],

Cell[TextData[{
 "Relational operators such as ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " yield explicit ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " results whenever they are given disjoint intervals. "
}], "Notes",
 CellID->27803]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->547201674],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->75973681],

Cell["Add intervals, getting an interval representing the result:", \
"ExampleText",
 CellID->813093827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], "]"}], "+", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232286535],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "8"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131944534]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->149916615],

Cell["Indeterminate limits can give intervals:", "ExampleText",
 CellID->344546887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227261643],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->712920326]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18284],

Cell["Squaring gives a non-negative interval:", "ExampleText",
 CellID->197481985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "5"}], "}"}], "]"}], "^", "2"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->773469327],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "25"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27096768]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304475],

Cell["Any function can be applied to an interval:", "ExampleText",
 CellID->29806453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"2.5", ",", "5.5"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101784819],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0.598472144103957`"}], "}"}], "]"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204966389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215753846],

Cell["Exact inputs yield exact interval results:", "ExampleText",
 CellID->162019266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389655342],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"Sin", "[", "2", "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->234886243]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "10"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56033954],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68946495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231581187],

Cell["Disjoint intervals can be generated:", "ExampleText",
 CellID->116800075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "5"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153672554],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "5"], ",", "\[Infinity]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{190, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->556494081]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78257074],

Cell["Exact comparisons can be made with intervals:", "ExampleText",
 CellID->28760414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"5", ",", "8"}], "}"}], "]"}], ">", "Pi"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->202009183],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195476038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1736952],

Cell["Solve an equation involving an interval:", "ExampleText",
 CellID->97267105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", "x"}], "+", "2"}], "==", 
    RowBox[{"Interval", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "5"}], "}"}], "]"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->899296680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Interval", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["4", "3"]}], ",", "1"}], "}"}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{176, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->671798253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292756538],

Cell["Approximate numbers automatically turn into intervals:", "ExampleText",
 CellID->402383582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interval", "[", "1.", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92807749],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"0.9999999999999998`", ",", "1.0000000000000002`"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54039341]
}, Open  ]],

Cell["Machine numbers always correspond to a certain interval:", "ExampleText",
 CellID->100287730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", "1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35168855],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2.2204460492503136`*^-16"}], ",", 
    "2.2204460492503136`*^-16"}], "}"}], "]"}]], "Output",
 ImageSize->{287, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->178325471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$MachineEpsilon"], "Input",
 CellLabel->"In[3]:=",
 CellID->605147037],

Cell[BoxData["2.220446049250313`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->66639112]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3269],

Cell[TextData[{
 "Find the interval that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " considers consistent with machine number ",
 Cell[BoxData["0."], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->69774131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interval", "[", "0.", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47322038],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2.2250738585072014`*^-308"}], ",", 
    "2.2250738585072014`*^-308"}], "}"}], "]"}]], "Output",
 ImageSize->{297, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15923857]
}, Open  ]],

Cell["Specifying a different precision gives a different interval:", \
"ExampleText",
 CellID->164834240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interval", "[", "0``500", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24237273],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1.9507750741`0.2902071977911669*^-500"}], ",", 
    "1.9507750741`0.2902071977911669*^-500"}], "}"}], "]"}]], "Output",
 ImageSize->{227, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->188726564]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23840],

Cell["\<\
Watch the widening of intervals in a system with sensitive dependence on \
initial conditions:\
\>", "ExampleText",
 CellID->75949360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"4", "#", 
     RowBox[{"(", 
      RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
   RowBox[{"Interval", "[", "0.5", "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24379984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"0.4999999999999999`", ",", "0.5000000000000001`"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"0.999999999999999`", ",", "1.0000000000000013`"}], "}"}], "]"}],
    ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "6.217248937900888`*^-15"}], ",", 
      "4.440892098500634`*^-15"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2.4868995751603718`*^-14"}], ",", 
      "1.7763568394002656`*^-14"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "9.94759830064174`*^-14"}], ",", 
      "7.105427357601243`*^-14"}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{584, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->505821165]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37398805],

Cell["\<\
With machine-precision evaluation, this gives a definite but incorrect value:\
\
\>", "ExampleText",
 CellID->11133846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"N", "[", "Pi", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162404799],

Cell[BoxData["1.2246467991473532`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83095460]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 ", the result spans the correct value:"
}], "ExampleText",
 CellID->20392599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"N", "[", "Pi", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->830672787],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "3.2162452993532737`*^-16"}], ",", 
    "5.665538897647981`*^-16"}], "}"}], "]"}]], "Output",
 ImageSize->{287, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->178266913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->184062068],

Cell["Show how the bounds of an interval vary with a parameter:", \
"ExampleText",
 CellID->757655621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{"Sin", "[", 
        RowBox[{"Interval", "[", 
         RowBox[{"{", 
          RowBox[{"6", ",", "x"}], "}"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Min", "[", "u", "]"}], ",", 
       RowBox[{"Max", "[", "u", "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316272767],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->806538176]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3968],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " to find end points of intervals:"
}], "ExampleText",
 CellID->89143806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347921817],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103377621]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->287501482],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->488858161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->888704995]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4228],

Cell["Intervals are always assumed independent:", "ExampleText",
 CellID->93948863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314685059],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70809555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "+", 
  RowBox[{"u", "^", "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->798956451],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "2"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100806363]
}, Open  ]],

Cell["\<\
A single real variable over the same range yields an interval with a \
different lower limit:\
\>", "ExampleText",
 CellID->8039224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"x", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "<", "x", "<", "1"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->435673878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->40757668]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15684],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalMemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntervalMemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalUnion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntervalUnion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalIntersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntervalIntersection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18205]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6698],

Cell[TextData[ButtonBox["Finding Limits",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingLimits"]], "Tutorials",
 CellID->15577]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->53078634],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntervalArithmetic"]], "MoreAbout",
 CellID->232911749]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interval - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 40.5099460}", "context" -> "System`", 
    "keywords" -> {
     "domains", "interval arithmetic", "ranges", "region", "spans", 
      "validated numeric computation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Interval[{min, max}] represents the range of values between min and max. \
Interval[{min_1 , max_1}, {min_2 , max_2}, ...] represents the union of the \
ranges min_1 to max_1, min_2 to max_2, .... ", "synonyms" -> {}, "title" -> 
    "Interval", "type" -> "Symbol", "uri" -> "ref/Interval"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7941, 277, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->547201674]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31566, 1202}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2207, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2830, 81, 46, 1, 70, "ObjectName",
 CellID->20078],
Cell[2879, 84, 2195, 75, 70, "Usage",
 CellID->21349]
}, Open  ]],
Cell[CellGroupData[{
Cell[5111, 164, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5589, 181, 232, 8, 70, "Notes",
 CellID->8330],
Cell[5824, 191, 429, 16, 70, "Notes",
 CellID->14964],
Cell[6256, 209, 473, 16, 70, "Notes",
 CellID->21695],
Cell[6732, 227, 217, 6, 70, "Notes",
 CellID->27772],
Cell[6952, 235, 326, 12, 70, "Notes",
 CellID->31646],
Cell[7281, 249, 623, 23, 70, "Notes",
 CellID->27803]
}, Closed]],
Cell[CellGroupData[{
Cell[7941, 277, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->547201674],
Cell[CellGroupData[{
Cell[8326, 291, 147, 5, 70, "ExampleSection",
 CellID->75973681],
Cell[8476, 298, 104, 2, 70, "ExampleText",
 CellID->813093827],
Cell[CellGroupData[{
Cell[8605, 304, 260, 9, 28, "Input",
 CellID->232286535],
Cell[8868, 315, 240, 8, 36, "Output",
 CellID->131944534]
}, Open  ]],
Cell[9123, 326, 125, 3, 70, "ExampleDelimiter",
 CellID->149916615],
Cell[9251, 331, 83, 1, 70, "ExampleText",
 CellID->344546887],
Cell[CellGroupData[{
Cell[9359, 336, 192, 6, 70, "Input",
 CellID->227261643],
Cell[9554, 344, 260, 9, 36, "Output",
 CellID->712920326]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9863, 359, 216, 7, 70, "ExampleSection",
 CellID->18284],
Cell[10082, 368, 82, 1, 70, "ExampleText",
 CellID->197481985],
Cell[CellGroupData[{
Cell[10189, 373, 197, 7, 70, "Input",
 CellID->773469327],
Cell[10389, 382, 240, 8, 36, "Output",
 CellID->27096768]
}, Open  ]],
Cell[10644, 393, 122, 3, 70, "ExampleDelimiter",
 CellID->304475],
Cell[10769, 398, 85, 1, 70, "ExampleText",
 CellID->29806453],
Cell[CellGroupData[{
Cell[10879, 403, 187, 6, 70, "Input",
 CellID->101784819],
Cell[11069, 411, 277, 9, 36, "Output",
 CellID->204966389]
}, Open  ]],
Cell[11361, 423, 125, 3, 70, "ExampleDelimiter",
 CellID->215753846],
Cell[11489, 428, 85, 1, 70, "ExampleText",
 CellID->162019266],
Cell[CellGroupData[{
Cell[11599, 433, 183, 6, 70, "Input",
 CellID->389655342],
Cell[11785, 441, 292, 10, 36, "Output",
 CellID->234886243]
}, Open  ]],
Cell[CellGroupData[{
Cell[12114, 456, 183, 6, 70, "Input",
 CellID->56033954],
Cell[12300, 464, 259, 9, 36, "Output",
 CellID->68946495]
}, Open  ]],
Cell[12574, 476, 125, 3, 70, "ExampleDelimiter",
 CellID->231581187],
Cell[12702, 481, 79, 1, 70, "ExampleText",
 CellID->116800075],
Cell[CellGroupData[{
Cell[12806, 486, 197, 7, 70, "Input",
 CellID->153672554],
Cell[13006, 495, 425, 15, 51, "Output",
 CellID->556494081]
}, Open  ]],
Cell[13446, 513, 124, 3, 70, "ExampleDelimiter",
 CellID->78257074],
Cell[13573, 518, 87, 1, 70, "ExampleText",
 CellID->28760414],
Cell[CellGroupData[{
Cell[13685, 523, 177, 6, 70, "Input",
 CellID->202009183],
Cell[13865, 531, 161, 5, 36, "Output",
 CellID->195476038]
}, Open  ]],
Cell[14041, 539, 123, 3, 70, "ExampleDelimiter",
 CellID->1736952],
Cell[14167, 544, 82, 1, 70, "ExampleText",
 CellID->97267105],
Cell[CellGroupData[{
Cell[14274, 549, 311, 12, 70, "Input",
 CellID->899296680],
Cell[14588, 563, 377, 14, 51, "Output",
 CellID->671798253]
}, Open  ]],
Cell[14980, 580, 125, 3, 70, "ExampleDelimiter",
 CellID->292756538],
Cell[15108, 585, 97, 1, 70, "ExampleText",
 CellID->402383582],
Cell[CellGroupData[{
Cell[15230, 590, 104, 3, 70, "Input",
 CellID->92807749],
Cell[15337, 595, 278, 9, 36, "Output",
 CellID->54039341]
}, Open  ]],
Cell[15630, 607, 99, 1, 70, "ExampleText",
 CellID->100287730],
Cell[CellGroupData[{
Cell[15754, 612, 91, 3, 70, "Input",
 CellID->35168855],
Cell[15848, 617, 311, 10, 39, "Output",
 CellID->178325471]
}, Open  ]],
Cell[CellGroupData[{
Cell[16196, 632, 84, 2, 70, "Input",
 CellID->605147037],
Cell[16283, 636, 179, 5, 36, "Output",
 CellID->66639112]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16511, 647, 238, 7, 70, "ExampleSection",
 CellID->3269],
Cell[16752, 656, 221, 8, 70, "ExampleText",
 CellID->69774131],
Cell[CellGroupData[{
Cell[16998, 668, 104, 3, 70, "Input",
 CellID->47322038],
Cell[17105, 673, 312, 10, 39, "Output",
 CellID->15923857]
}, Open  ]],
Cell[17432, 686, 105, 2, 70, "ExampleText",
 CellID->164834240],
Cell[CellGroupData[{
Cell[17562, 692, 108, 3, 70, "Input",
 CellID->24237273],
Cell[17673, 697, 337, 10, 39, "Output",
 CellID->188726564]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18059, 713, 223, 7, 70, "ExampleSection",
 CellID->23840],
Cell[18285, 722, 144, 4, 70, "ExampleText",
 CellID->75949360],
Cell[CellGroupData[{
Cell[18454, 730, 271, 9, 70, "Input",
 CellID->24379984],
Cell[18728, 741, 969, 30, 58, "Output",
 CellID->505821165]
}, Open  ]],
Cell[19712, 774, 124, 3, 70, "ExampleDelimiter",
 CellID->37398805],
Cell[19839, 779, 129, 4, 70, "ExampleText",
 CellID->11133846],
Cell[CellGroupData[{
Cell[19993, 787, 128, 4, 70, "Input",
 CellID->162404799],
Cell[20124, 793, 180, 5, 36, "Output",
 CellID->83095460]
}, Open  ]],
Cell[20319, 801, 223, 8, 70, "ExampleText",
 CellID->20392599],
Cell[CellGroupData[{
Cell[20567, 813, 164, 5, 70, "Input",
 CellID->830672787],
Cell[20734, 820, 310, 10, 39, "Output",
 CellID->178266913]
}, Open  ]],
Cell[21059, 833, 125, 3, 70, "ExampleDelimiter",
 CellID->184062068],
Cell[21187, 838, 102, 2, 70, "ExampleText",
 CellID->757655621],
Cell[CellGroupData[{
Cell[21314, 844, 553, 18, 70, "Input",
 CellID->316272767],
Cell[21870, 864, 2287, 42, 70, "Output",
 Evaluatable->False,
 CellID->806538176]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24206, 912, 232, 7, 70, "ExampleSection",
 CellID->3968],
Cell[24441, 921, 327, 13, 70, "ExampleText",
 CellID->89143806],
Cell[CellGroupData[{
Cell[24793, 938, 151, 5, 70, "Input",
 CellID->347921817],
Cell[24947, 945, 240, 8, 36, "Output",
 CellID->103377621]
}, Open  ]],
Cell[CellGroupData[{
Cell[25224, 958, 99, 3, 70, "Input",
 CellID->287501482],
Cell[25326, 963, 158, 5, 36, "Output",
 CellID->488858161]
}, Open  ]],
Cell[25499, 971, 125, 3, 70, "ExampleDelimiter",
 CellID->888704995]
}, Closed]],
Cell[CellGroupData[{
Cell[25661, 979, 225, 7, 70, "ExampleSection",
 CellID->4228],
Cell[25889, 988, 83, 1, 70, "ExampleText",
 CellID->93948863],
Cell[CellGroupData[{
Cell[25997, 993, 197, 7, 70, "Input",
 CellID->314685059],
Cell[26197, 1002, 259, 9, 36, "Output",
 CellID->70809555]
}, Open  ]],
Cell[CellGroupData[{
Cell[26493, 1016, 115, 4, 70, "Input",
 CellID->798956451],
Cell[26611, 1022, 260, 9, 36, "Output",
 CellID->100806363]
}, Open  ]],
Cell[26886, 1034, 142, 4, 70, "ExampleText",
 CellID->8039224],
Cell[CellGroupData[{
Cell[27053, 1042, 290, 11, 70, "Input",
 CellID->435673878],
Cell[27346, 1055, 346, 13, 51, "Output",
 CellID->40757668]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27753, 1075, 311, 9, 70, "SeeAlsoSection",
 CellID->15684],
Cell[28067, 1086, 1230, 44, 70, "SeeAlso",
 CellID->18205]
}, Open  ]],
Cell[CellGroupData[{
Cell[29334, 1135, 313, 9, 70, "TutorialsSection",
 CellID->6698],
Cell[29650, 1146, 138, 3, 70, "Tutorials",
 CellID->15577]
}, Open  ]],
Cell[CellGroupData[{
Cell[29825, 1154, 318, 9, 70, "MoreAboutSection",
 CellID->53078634],
Cell[30146, 1165, 149, 3, 70, "MoreAbout",
 CellID->232911749]
}, Open  ]],
Cell[30310, 1171, 27, 0, 70, "History"],
Cell[30340, 1173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

