(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36229,       1295]
NotebookOptionsPosition[     29596,       1060]
NotebookOutlinePosition[     30971,       1098]
CellTagsIndexPosition[     30885,       1093]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Matrix Inversion" :> 
          Documentation`HelpLookup["paclet:tutorial/MatrixInversion"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Matrix Inversion\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PseudoInverse" :> 
          Documentation`HelpLookup["paclet:ref/PseudoInverse"], "LinearSolve" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolve"], "RowReduce" :> 
          Documentation`HelpLookup["paclet:ref/RowReduce"], "NullSpace" :> 
          Documentation`HelpLookup["paclet:ref/NullSpace"], 
          "LinearSolveFunction" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolveFunction"], 
          "MatrixRank" :> 
          Documentation`HelpLookup["paclet:ref/MatrixRank"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PseudoInverse\"\>", 
       2->"\<\"LinearSolve\"\>", 3->"\<\"RowReduce\"\>", 
       4->"\<\"NullSpace\"\>", 5->"\<\"LinearSolveFunction\"\>", 
       6->"\<\"MatrixRank\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"Matrix Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Inverse", "ObjectName",
 CellID->9578],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Inverse",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Inverse"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse of a square matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29215]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Inverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inverse"]], "InlineFormula"],
 " works on both symbolic and numerical matrices. "
}], "Notes",
 CellID->19811],

Cell["\<\
For matrices with approximate real or complex numbers, the inverse is \
generated to the maximum possible precision given the input. A warning is \
given for ill\[Hyphen]conditioned matrices. \
\>", "Notes",
 CellID->29280],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " evaluates the inverse modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11834],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["ZeroTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZeroTest"], "->", 
     StyleBox["test", "TI"]}]}], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["test", "TI"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"]}], "]"}], "]"}], "]"}]], "InlineFormula"],
 " to determine whether matrix elements are zero. The default setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ZeroTest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZeroTest"], "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"#", "==", "0"}], "&"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19624],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option can also be given. Possible settings are as for ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17439]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570066446],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->431337882],

Cell["Inverse of a 2\[Times]2 matrix:", "ExampleText",
 CellID->21241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.4", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "6.7"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.43563068920676207`", ",", "0.13003901170351104`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0.1950585175552666`", ",", 
     RowBox[{"-", "0.09102730819245773`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59],

Cell["Enter the matrix in a grid:", "ExampleText",
 CellID->20383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"(", GridBox[{
     {"1", "2", "3"},
     {"4", "2", "2"},
     {"5", "1", "7"}
    }], ")"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19785],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", "7"]}], ",", 
     FractionBox["11", "42"], ",", 
     FractionBox["1", "21"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", "7"], ",", 
     FractionBox["4", "21"], ",", 
     RowBox[{"-", 
      FractionBox["5", "21"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "7"], ",", 
     RowBox[{"-", 
      FractionBox["3", "14"]}], ",", 
     FractionBox["1", "7"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{308, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16689],

Cell["Inverse of a symbolic matrix:", "ExampleText",
 CellID->27348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "v"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "u"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["u", 
      RowBox[{
       SuperscriptBox["u", "2"], "-", 
       SuperscriptBox["v", "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox["v", 
       RowBox[{
        SuperscriptBox["u", "2"], "-", 
        SuperscriptBox["v", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["v", 
       RowBox[{
        SuperscriptBox["u", "2"], "-", 
        SuperscriptBox["v", "2"]}]]}], ",", 
     FractionBox["u", 
      RowBox[{
       SuperscriptBox["u", "2"], "-", 
       SuperscriptBox["v", "2"]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{262, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12764]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21936],

Cell["Exact inverse of a Hilbert matrix:", "ExampleText",
 CellID->1895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"i", "+", "j"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25539],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\:f3a2", GridBox[{
     {"450", 
      RowBox[{"-", "4200"}], "12600", 
      RowBox[{"-", "15120"}], "6300"},
     {
      RowBox[{"-", "4200"}], "44100", 
      RowBox[{"-", "141120"}], "176400", 
      RowBox[{"-", "75600"}]},
     {"12600", 
      RowBox[{"-", "141120"}], "470400", 
      RowBox[{"-", "604800"}], "264600"},
     {
      RowBox[{"-", "15120"}], "176400", 
      RowBox[{"-", "604800"}], "793800", 
      RowBox[{"-", "352800"}]},
     {"6300", 
      RowBox[{"-", "75600"}], "264600", 
      RowBox[{"-", "352800"}], "158760"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
      "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{309, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->21274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23212],

Cell["\<\
Plot the imaginary parts of a Vandermonde matrix for a discrete Fourier \
transform: \
\>", "ExampleText",
 CellID->30511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArrayPlot", "[", 
   RowBox[{"Im", "[", "\n", " ", 
    RowBox[{"Inverse", "[", 
     RowBox[{"Table", "[", " ", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"2", " ", "Pi", " ", "I", " ", "i", " ", 
         RowBox[{"j", "/", "26."}]}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", " ", "25"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"j", ",", " ", "25"}], "}"}]}], "]"}], "]"}], "]"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22192],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm7FqwzAQhm2MvAg8d8zu92inbn4BEwrJUFrSPITmDn0gv1h7/yGBJnWI
A+HuNziWTv/dp0G+KDryul5Pb+/r9XxcDy+X9fN0Pn4dnj8uYhr6rut+cD91
0v6Vlt4wyTWgrVf3LR/9TdZx27YxpRSWZRnneR6naYoyjGdAH3YZhy6IQ0uP
fqj0A4kk7knEKJTFSzwiosozoA87IoMCYkOvs6z0JJK4KxFK6eqbkFd+RCQQ
0IcdUTADEBt6fYMqPYmmiTk3hrLeZCjCG1HRh73kTBAbep1VpSeRxF2JOTeG
4iUeMa98zZGwl5wJYkOvs6z0JJK4KzF7hZKNxTvmvah6w16igdjQa/av9CSS
SCKJD0D0kMlJtEH0sEMm0QbRw8kDifcgJgennSTaIOYVbrqKRKIJ4u21b9bJ
STRJ9PBNRaINoodfACTaIM4OzjlIZJ2cRM/E7GW6SkYiiSR6JnrI5CTaIHrY
IZNog+jhHIBEG8Tk4HyVRNbJSXRM/K/Knf9V3v8Bnd8czw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->369138220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30681],

Cell["\<\
Plot the inverse of a matrix, shading according to absolute value:\
\>", "ExampleText",
 CellID->9069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Inverse", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"i", " ", "j"}], ",", "19"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"i", "+", "j"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "20"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23531],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm0tLW1EQxyMu5qxSuintrp+hu36BdtVPoBsJhbgolTZ7N+7FLroJ6E5c
Kigoik8QlWjAN2LAB77jK76f7fyGm66aPmhKH4wQczk585sD+Z85M3NvXtWk
kq/f1KRqEzVPX76rqUvWJt4/ffH2nQ5VVsRisY+8Hsf0+pNe2Ysh/avk2v5i
H/RfxS+NSqFQeKYX8bu7O97D8fExY7K2tlbpFr9o8ZzZ9/f3NpuZ+hEWPvtH
Z8ve3p5cX1+H29tbubq6kpubG8nn87K7uyvT09NSV1cnyWQyTExMyPLysqyv
r4samt3R0ZGcnJyEs7Mz+570+3Iv7uW/9qIesAoao8way8XFRdnc3JR0Oi2J
REKqqqpCQ0ODLCwsyMDAgH3GXFZ0eXkZ1NNDpzu9PHSoGu8Ds9Evej4/Pzfr
jo4OGRkZkcHBwdDc3Gxj6LvoXe3wEHRFTnd6mehoFr1DPD09NYuNjY0veiav
U+sQ7QuZmZmxOUTkSPdBV+R0p5eRrjoPh4eHZp3L5eLZbFaamprQuQwNDYX6
+nrp7e2Vnp4eGRsbM3qk+SdOderXqURG/TSQcZJpzs7OyvDwsBFTqZR0dnZK
V1dXqK6ulra2NmltbTU6+sVWz/qgGi6hW6c7/WfpRE+NlA/QONodHR01HeNt
Z2dHtre3g2aUNgZd9R5nrmaeQesipzq1BHVra0symUygmiaDbG9vl8bGRuqb
eLGCRp+Q0S7RlPOaLFJrGypvJzv5ryFz0nd3d4eVlRWrfubn52V8fFz29/ct
3yTeTk5OUnuzY4jJZAlWvxOrqdmTyaTtIl1ZiY6Re3Evv9tLf3+/9PX1hdXV
Vbm4uJClpSWZmpqSg4MDq+/ZO+qJmt3iPxkGdFZArZ9IJAL9UffiXv6sFzpR
UOiDEu3ZPy0tLVRvcbwozTyQyZArU71R2dG1SqfTnBIlor2TnVyKTGTWCGz5
MpEaLUd9TtO3RmvrPDGGprPZrOXLVHFawTnVqSWoREosodB5InrOzc0ZHe0S
QTUfCGS0VGn0AehK0ftkRVq9hXw+73Snl4ke9QECPQL0SwcKD2ieiMq5rllq
oM6id0B3KpfLmV10r5yVOd3pZaLzxIZeWHSlisdDsUvPOc9+UF1/uX+Od95Z
Dec+tro6pzv9n6DrrrAsAzoW0b1Pe/Yj2lXW7WKMXBbPxbvz6pEnnJzs5J8k
66ePilZ0n+g40X3Smt46VJlMxrpO3E2PNGzxO9oHTnXqN56uQHvMJHLyHkVI
O/3pHGmWEOjko+lCoRCPbOyJTebgqfRTyu7BPZTJw/d+vRH9CqTiM+LE86E=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->277410529]
}, Open  ]],

Cell["Show positive entries as black and others as white:", "ExampleText",
 CellID->6086],

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Inverse", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"i", " ", "j"}], ",", "19"}], "]"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"i", "+", "j"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", ">", "0"}], ",", "Black", ",", "White"}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32196],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztldEJwzAMRA1dIQtkku7QEQL5zuoZIZQW+hN/KJx4JzcHQfkwd9LJkudl
e62P1tr0/d7/H+zP89hD73w0RvlV+VC6UX4qTxWy/XfTjfJT980tnygoH9x8
jp532wNuum79reKPSld1XpXPv82d235WwW0Pq0DlU8UHag9T74UqH0p31LpU
PFX2s9ueceuLW10qXaquKL8KlJ/UPGbzV6/r7u81nip7SZUPpTtqXSoe6p67
+UPpjlqXSpeqK8qvQrb/brrZ/NQ+dMunug8qHre67v5qebKjClV0qfeX6uOo
80vPzS8e/DIysw==
   "], {{0, 0}, {20, 20}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Input",
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"In[3]:=",
 CellID->22478]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19088],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", "m", "]"}], " ", ".", " ", "m"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16098],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "c"}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], " ", "c"}], "+", 
         RowBox[{"a", " ", "d"}]}]]}], "+", 
      FractionBox[
       RowBox[{"a", " ", "d"}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "c"}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], " ", "c"}], "+", 
         RowBox[{"a", " ", "d"}]}]]}], "+", 
      FractionBox[
       RowBox[{"a", " ", "d"}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{368, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31968]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19029],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31706]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"(", GridBox[{
     {"1", "2"},
     {"1", "2"}
    }], ")"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28128],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"sing\"\>"}], ":", 
  " ", "\<\"Matrix \\!\\({\\(\\({1, 2}\\)\\), \\(\\({1, 2}\\)\\)}\\) is \
singular. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/sing\\\", ButtonNote -> \
\\\"Inverse::sing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->489511942],

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455053577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"(", GridBox[{
     {"1", "2", "2"},
     {"3", "1", "4"}
    }], ")"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17405],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"matsq\"\>"}], ":", 
  " ", "\<\"Argument \\!\\({\\(\\({1, 2, 2}\\)\\), \\(\\({3, 1, 4}\\)\\)}\\) \
at position \\!\\(1\\) is not a nonempty square matrix. \\!\\(\\*ButtonBox[\\\
\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/matsq\\\", ButtonNote -> \
\\\"Inverse::matsq\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->361077789],

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341444492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27243],

Cell["\<\
Accurate inverses cannot be found for ill-conditioned machine-precision \
numerical matrices:\
\>", "ExampleText",
 CellID->17738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1.0", "/", 
      RowBox[{"(", 
       RowBox[{"i", "+", "j"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "10"}], "}"}]}], "]"}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(Inverse\\) of badly conditioned matrix \
\\!\\({\\(\\({0.5`, 0.3333333333333333`, 0.25`, 0.2`, \\(\\(\[LeftSkeleton] \
20 \[RightSkeleton]\\)\\), \\(\\(\[LeftSkeleton] 20 \[RightSkeleton]\\)\\), \
0.125`, 0.1111111111111111`, 0.1`, 0.09090909090909091`}\\)\\), \\(\\(\
\[LeftSkeleton] 8 \[RightSkeleton]\\)\\), \\(\\({\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)}\\)\\)}\\) may contain significant numerical errors. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/luc\\\", \
ButtonNote -> \\\"Inverse::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->315938005],

Cell[BoxData["6051.098852917552`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174924550]
}, Open  ]],

Cell["Exact result:", "ExampleText",
 CellID->24428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"i", "+", "j"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "10"}], "}"}]}], "]"}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23103],

Cell[BoxData["6050"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356020949]
}, Open  ]],

Cell["Arbitrary-precision result:", "ExampleText",
 CellID->21295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"i", "+", "j"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "10"}], "}"}]}], "]"}], ",", "30"}], "]"}], "]"}], 
  "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14997],

Cell[BoxData["6050.00000000000000000000000000000075227449`30."], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29205089]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16304],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PseudoInverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PseudoInverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolveFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolveFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixRank",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixRank"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26066]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19303],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->31413],

Cell[TextData[ButtonBox["Matrix Inversion",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MatrixInversion"]], "Tutorials",
 CellID->13001]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->14406],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#5783"], None}]], "RelatedLinks",
 CellID->24461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->92996997],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->128203747],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->831910887]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inverse - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 9.0903386}", "context" -> "System`", 
    "keywords" -> {
     "Cholesky", "cofactor expansion", "division-free row reduction", 
      "inverse of a matrix", "inversion of matrices", "invert", "Krylov", 
      "LINPACK", "multifrontal", "one-step row reduction"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Inverse[m] gives the inverse of a square matrix m. ", "synonyms" -> {}, 
    "title" -> "Inverse", "type" -> "Symbol", "uri" -> "ref/Inverse"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6743, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->570066446]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30742, 1086}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2752, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3375, 89, 44, 1, 70, "ObjectName",
 CellID->9578],
Cell[3422, 92, 553, 18, 70, "Usage",
 CellID->29215]
}, Open  ]],
Cell[CellGroupData[{
Cell[4012, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4490, 132, 213, 7, 70, "Notes",
 CellID->19811],
Cell[4706, 141, 233, 5, 70, "Notes",
 CellID->29280],
Cell[4942, 148, 471, 18, 70, "Notes",
 CellID->11834],
Cell[5416, 168, 929, 34, 70, "Notes",
 CellID->19624],
Cell[6348, 204, 358, 13, 70, "Notes",
 CellID->17439]
}, Closed]],
Cell[CellGroupData[{
Cell[6743, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570066446],
Cell[CellGroupData[{
Cell[7128, 236, 148, 5, 70, "ExampleSection",
 CellID->431337882],
Cell[7279, 243, 70, 1, 70, "ExampleText",
 CellID->21241],
Cell[CellGroupData[{
Cell[7374, 248, 274, 10, 28, "Input",
 CellID->13487],
Cell[7651, 260, 398, 13, 36, "Output",
 CellID->22511]
}, Open  ]],
Cell[8064, 276, 118, 3, 70, "ExampleDelimiter",
 CellID->59],
Cell[8185, 281, 66, 1, 70, "ExampleText",
 CellID->20383],
Cell[CellGroupData[{
Cell[8276, 286, 200, 8, 70, "Input",
 CellID->19785],
Cell[8479, 296, 673, 25, 51, "Output",
 CellID->702]
}, Open  ]],
Cell[9167, 324, 121, 3, 70, "ExampleDelimiter",
 CellID->16689],
Cell[9291, 329, 68, 1, 70, "ExampleText",
 CellID->27348],
Cell[CellGroupData[{
Cell[9384, 334, 248, 9, 70, "Input",
 CellID->31402],
Cell[9635, 345, 784, 29, 50, "Output",
 CellID->12764]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10468, 380, 223, 7, 70, "ExampleSection",
 CellID->21936],
Cell[10694, 389, 72, 1, 70, "ExampleText",
 CellID->1895],
Cell[CellGroupData[{
Cell[10791, 394, 390, 14, 70, "Input",
 CellID->25539],
Cell[11184, 410, 1088, 33, 108, "Output",
 CellID->21274]
}, Open  ]],
Cell[12287, 446, 121, 3, 70, "ExampleDelimiter",
 CellID->23212],
Cell[12411, 451, 132, 4, 70, "ExampleText",
 CellID->30511],
Cell[CellGroupData[{
Cell[12568, 459, 539, 16, 70, "Input",
 CellID->22192],
Cell[13110, 477, 801, 17, 70, "Output",
 Evaluatable->False,
 CellID->369138220]
}, Open  ]],
Cell[13926, 497, 121, 3, 70, "ExampleDelimiter",
 CellID->30681],
Cell[14050, 502, 112, 3, 70, "ExampleText",
 CellID->9069],
Cell[CellGroupData[{
Cell[14187, 509, 545, 18, 70, "Input",
 CellID->23531],
Cell[14735, 529, 1607, 31, 70, "Output",
 Evaluatable->False,
 CellID->277410529]
}, Open  ]],
Cell[16357, 563, 89, 1, 70, "ExampleText",
 CellID->6086],
Cell[16449, 566, 780, 26, 70, "Input",
 CellID->32196],
Cell[17232, 594, 601, 15, 70, "Input",
 CellID->22478]
}, Closed]],
Cell[CellGroupData[{
Cell[17870, 614, 233, 7, 70, "ExampleSection",
 CellID->19088],
Cell[18106, 623, 261, 10, 70, "Input",
 CellID->16595],
Cell[CellGroupData[{
Cell[18392, 637, 132, 4, 70, "Input",
 CellID->16098],
Cell[18527, 643, 1062, 39, 52, "Output",
 CellID->31968]
}, Open  ]],
Cell[CellGroupData[{
Cell[19626, 687, 100, 3, 70, "Input",
 CellID->19029],
Cell[19729, 692, 298, 11, 36, "Output",
 CellID->31706]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20076, 709, 226, 7, 70, "ExampleSection",
 CellID->18702],
Cell[CellGroupData[{
Cell[20327, 720, 168, 7, 70, "Input",
 CellID->28128],
Cell[20498, 729, 395, 8, 70, "Message",
 CellID->489511942],
Cell[20896, 739, 341, 12, 36, "Output",
 CellID->455053577]
}, Open  ]],
Cell[21252, 754, 121, 3, 70, "ExampleDelimiter",
 CellID->11110],
Cell[CellGroupData[{
Cell[21398, 761, 178, 7, 70, "Input",
 CellID->17405],
Cell[21579, 770, 449, 8, 70, "Message",
 CellID->361077789],
Cell[22031, 780, 361, 12, 36, "Output",
 CellID->341444492]
}, Open  ]],
Cell[22407, 795, 121, 3, 70, "ExampleDelimiter",
 CellID->27243],
Cell[22531, 800, 140, 4, 70, "ExampleText",
 CellID->17738],
Cell[CellGroupData[{
Cell[22696, 808, 431, 15, 70, "Input",
 CellID->200],
Cell[23130, 825, 751, 12, 70, "Message",
 CellID->315938005],
Cell[23884, 839, 175, 5, 36, "Output",
 CellID->174924550]
}, Open  ]],
Cell[24074, 847, 52, 1, 70, "ExampleText",
 CellID->24428],
Cell[CellGroupData[{
Cell[24151, 852, 431, 15, 70, "Input",
 CellID->23103],
Cell[24585, 869, 161, 5, 36, "Output",
 CellID->356020949]
}, Open  ]],
Cell[24761, 877, 66, 1, 70, "ExampleText",
 CellID->21295],
Cell[CellGroupData[{
Cell[24852, 882, 507, 18, 70, "Input",
 CellID->14997],
Cell[25362, 902, 204, 5, 36, "Output",
 CellID->29205089]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25627, 914, 311, 9, 70, "SeeAlsoSection",
 CellID->16304],
Cell[25941, 925, 1477, 53, 70, "SeeAlso",
 CellID->26066]
}, Open  ]],
Cell[CellGroupData[{
Cell[27455, 983, 314, 9, 70, "TutorialsSection",
 CellID->19303],
Cell[27772, 994, 149, 3, 70, "Tutorials",
 CellID->31413],
Cell[27924, 999, 142, 3, 70, "Tutorials",
 CellID->13001]
}, Open  ]],
Cell[CellGroupData[{
Cell[28103, 1007, 321, 9, 70, "RelatedLinksSection",
 CellID->14406],
Cell[28427, 1018, 266, 6, 70, "RelatedLinks",
 CellID->24461]
}, Open  ]],
Cell[CellGroupData[{
Cell[28730, 1029, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[29049, 1040, 138, 3, 70, "MoreAbout",
 CellID->92996997],
Cell[29190, 1045, 163, 3, 70, "MoreAbout",
 CellID->128203747],
Cell[29356, 1050, 145, 3, 70, "MoreAbout",
 CellID->831910887]
}, Open  ]],
Cell[29516, 1056, 50, 0, 70, "History"],
Cell[29569, 1058, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

