(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47625,       1424]
NotebookOptionsPosition[     40810,       1178]
NotebookOutlinePosition[     42073,       1215]
CellTagsIndexPosition[     41987,       1210]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Erfc" :> Documentation`HelpLookup["paclet:ref/Erfc"], 
          "InverseErf" :> Documentation`HelpLookup["paclet:ref/InverseErf"], 
          "InverseGammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseGammaRegularized"], 
          "InverseBetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseBetaRegularized"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Erfc\"\>", 
       2->"\<\"InverseErf\"\>", 3->"\<\"InverseGammaRegularized\"\>", 
       4->"\<\"InverseBetaRegularized\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Inverse Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseErfc", "ObjectName",
 CellID->8496],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseErfc",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseErfc"], "[", 
       StyleBox["s", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse complementary error function obtained \
as the solution for ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      FormBox[
       RowBox[{"s", "=", 
        RowBox[{"erfc", "(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "Explicit numerical values are given only for real values of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->27980],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseErfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErfc"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->247571332],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseErfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErfc"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseErfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErfc"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->533164336],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->33280994],

Cell["Evaluate numerically:", "ExampleText",
 CellID->26698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErfc", "[", "0.6", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5017],

Cell[BoxData["0.37080715859355795`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->655475469]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseErfc", "[", "s", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17896],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1mF2IVVUUx7f3eyZLqylMZ3TqIeihh16CHiwoMkpCIiIie7gN0sxDGtMU
lBQTiIZMRU2i41iTowV9PBiJERhIQiREQiREBWEQ9pAESQ8Dwe239jqf+6x7
7p3AgTn37L3/a63/Xl9nn/Nge2p829PtqYmx9uh9k+1nxifGnh3dtGOSqeoK
59xx/p9a47jvcOf/j3c6/K6Sa1XG/s8tmrPzfnzhwt/RuGaiDnKpLLz7bSNZ
rbA4X5gtlwlXXXX2ra8//uh7ua2XoPbsPvX5iR/zqNh+cVXs1Vit96WrmUG5
rlKvTJ/88uQvqZSrRnD+KvEwI1UztezY/tnZ735PtQwEKNEiQ0U/8fiH58//
VY4u2nhoy5GLF//Je8PVUlRxh3N+vLT07733HJLbRuIX2VnDRP/8059jT36S
ouOIKAdchcPyq0UdaezLUJjBWHfUAT9my2xcbps5PqoDMxjLrxZ1pJZs1H4/
JoCEUW5bJahUVyvHR1c/PXbutZnTcjtg6tjnxwQfNcTFDZqot/340qWlifFj
YN0VJmo2RsEaSm5ljo+uUv3R6pVJ7KtGprwZe0C3567y6FaACnP/DT/JPuYO
nIEqVFZ1/k8Nve7HZ775DevvHz3rru5qXYYzfsDOyMTnpk7goGv6YrvXT5JP
ROjRRz4glYf6knvVT2KGBkMqEuLrE19adbTb49nNzhe/oNLpSWtykdklozo8
2Co82MLpr351a80YT8ulgYdhCxDzuJqtD5vol71mtMF08/0L+AcWboOJ3ek1
J1i4QhRDN+a4boh+sxGMo7o+ikcl0CxrI8ZaLOea7B1j0KMvqWFSx4lXa130
Vc09jHTCDtgMEMPBuFqQGLEQTaJNayGnWcBBeF+qdW2wm1pBW+Xy8hzUGbxF
4DSNyTA64Lkf/ogiUq7l8vFbJz8tvCQp5xyVrFlFuZCvYQcIvV4pYRrnWvFZ
F2doOTNffU16GycWmiE5RyUxL30u1jK6DD7lngs7a++YDOX53bVxjiv3zBRq
IexNwwVt/ebk+mjncRcb6aTdTH5X+3iSacRT23uWWL2HtF2vW71OaouKp6pI
XXKEYNAISeA7cxF/zGOZpg7pFHQ+4HrEQ8Hdpv6H5TJAd6E64KzOhDkFQgUz
7zaZclu8LfJBbVFVmCN34cVeN5syD3hb6p8ksch6tUXKq1b/VD4ax6WgJcyW
cDy0THw49nFoaW4xqxRpHOrFMLvCKl+utXC80lov+GBjJmp4L8g06btbTbk7
ukSNIWnTzmXT7XE2EVISLgjVNlP/bRnfJalEWhFwSE2YMrd2utfydlPiFi+h
zEKJydwebvZI6NJS2Salo3wE+byp+yYvAV92SvXgIUKPl+Vp+4Ip4buVPJ/V
hvZKHCqn0JdMiXUxK1D4lBCoDYnbdI7/DTJqoFuRsIEW4dtl6r3Oo9FCquIR
9Cp6j4m+1qcXXtTTDFfxyl4TuzqjGR44UU8+Mzm2XqqOp4gFVNEozwt/4vUn
xmpc02G+y8kOqhBGUnqOP1v3fMfzbwJ1aCBFrPCReHC2L1m/LidOiCIO6X1d
5arx011OwuyK+HKzvy87etLFy7gNn+k7WE8p7Qrg8bT442Diw4rxvFSfUgxw
k9v5XFR0lT2S93J7yIyw9rX03fCdFNVIUPzpG9+CtYrziQJpvZCz7zenr7fu
vVQuet5SJQgdLsyrwOFAE3mKFZnMaJJdEEg5oQRfdSKrwWz0vraY030kj8Hv
cqsYiX0tm7vR+/xiEpXCCTeynqK65ZWuDprRYBx9nemBir7GpGyN843gou8t
Ke84mwwP6Eew0Hd9zhr6orjZ393KZt2K/wBwMhna\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14619567]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3996],

Cell["Exact results for special arguments:", "ExampleText",
 CellID->12432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErfc", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8394],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271213068]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErfc", "[", "1.", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17127],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->616760104]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12249],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->14108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseErfc", "[", 
    RowBox[{"33", "/", "100"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14397],

Cell[BoxData["0.\
6888025281165564504025047289052578354494899234937089922550616618017`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475858818]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->21819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErfc", "[", "0.330000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16585],

Cell[BoxData["0.68880252811655645040250472890550747637`24.985376412612148"], \
"Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->148613615]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10752],

Cell["Series expansion:", "ExampleText",
 CellID->6631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseErfc", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31236],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox["\[Pi]"], " ", 
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}]}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "2"],
    SeriesData[$CellContext`z, 1, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 1, {Rational[-1, 2] Pi^Rational[1, 2]}, 1, 2, 1],
  
  Editable->False]], "Output",
 ImageSize->{161, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->400024195]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseErfc", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->647],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"Log", "[", 
       FractionBox["2", "\[Pi]"], "]"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"Log", "[", "z", "]"}]}], "-", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"Log", "[", 
         FractionBox["2", "\[Pi]"], "]"}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", "z", "]"}]}]}], "]"}]}]], 
    SqrtBox["2"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2^Rational[-1, 2] (Log[2/Pi] - 2 Log[$CellContext`z] - Log[
      Log[2/Pi] - 2 Log[$CellContext`z]])^Rational[1, 2]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{342, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->339841280]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->373017311],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->329873703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseErfc", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->76603757],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["erfc", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{47, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->107325198]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22760],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseErfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErfc"]], "InlineFormula"],
 " threads element-wise over lists and arrays:"
}], "ExampleText",
 CellID->16613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErfc", "[", 
  RowBox[{"1", "/", 
   RowBox[{"{", 
    RowBox[{"2.", ",", "3.", ",", "4.", ",", "5."}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->15555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4769362762044698`", ",", "0.6840703496566227`", ",", 
   "0.8134198475976185`", ",", "0.9061938024368232`"}], "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33548054]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13588],

Cell["Generate Gaussian-distributed random numbers:", "ExampleText",
 CellID->14371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErfc", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}], ",", "10"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26673],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.25891728017072607`"}], ",", 
   RowBox[{"-", "0.6478781082895084`"}], ",", "0.5964740416891625`", ",", 
   "0.7419366411501639`", ",", "0.13033404507030652`", ",", 
   RowBox[{"-", "0.1278672912226788`"}], ",", "0.22737953241035028`", ",", 
   "0.1876182166324882`", ",", "0.6748740307756562`", ",", 
   RowBox[{"-", "0.35655968722365655`"}]}], "}"}]], "Output",
 ImageSize->{412, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368304899]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18312],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"InverseErfc", "[", "x", "]"}], "^", "2"}], "+", 
     RowBox[{"InverseErfc", "[", "x", "]"}]}], "==", "1"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Erfc", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox["5"]}], ")"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Erfc", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["5"]}], ")"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{346, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76836720]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25744],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->18918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"InverseErfc", "[", "z", "]"}], "==", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28213],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.48911634491408484`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43344476]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31974],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseErfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErfc"]], "InlineFormula"],
 " evaluates numerically only for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "s", "\[LessEqual]", "2"}], TraditionalForm]],
   "InlineMath"],
 ":"
}], "ExampleText",
 CellID->4779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseErfc", "[", "2.3", "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31728],

Cell[BoxData[
 RowBox[{"InverseErfc", "[", "2.3`", "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375229079]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17591],

Cell[TextData[{
 "Riemann surface of ",
 Cell[BoxData[
  ButtonBox["InverseErfc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErfc"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"Erfc", "[", 
        RowBox[{"wr", "+", 
         RowBox[{"\[ImaginaryI]", " ", "wi"}]}], "]"}], "]"}], ",", 
      RowBox[{"Im", "[", 
       RowBox[{"Erfc", "[", 
        RowBox[{"wr", "+", 
         RowBox[{"\[ImaginaryI]", " ", "wi"}]}], "]"}], "]"}], ",", "wi"}], 
     "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"wr", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"wi", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Opacity", "[", "0.66", "]"}], "}"}]}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"1", "/", "2"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18199],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytnQd4XNd155/fezMAKVGiZEmWYy1jJ7E3Wcfr2JGzXu9mvYqdOImd5vW3
q9iWbUmW5eTbJC6SrLJWL7RNSyLFTpEgQT42sYMgyqC3KRhMrwAHBEEABECw
i5bk8+nbPf9z7xsMHyAJybf8Lt60V+753XPPbece/tXdD3z/vn+6+4F/uPfu
D3/pR3f/4Pv/cO+PP/xn//Ij/sp6n2EYR/lv/a0Gv/+//E7+jr799tv8w5zj
N/ho8Qkmv5r8+lX59ps42vzxbfmnfzes2W8+oM//owWef5N+jmHxm/vuuw9v
P7PAa2/Uz7Lle3Ux3t6+wOuv18/2V1yPfwu9fol+/iI5k68vn/mHZYamFg2v
S/TzrnmH8/9Jn3cdPvnKv6tTjE/L6z/qeyx186xP8Obtk3L2/RWlWPnrdVfn
QD/3U3LNffrTLZ4nWJ57/Ec5+x79hFsXdPZ3KohU/vpez/qEXH2XfpZvAVfj
KeqZn9OfflNf/eF3IWeUr/rPc0r/Q/r63/Zc783NNW9fXXM++A73+6D+/WOe
+/nnud+76+Et7/CEW3ROfvc9noD6Y7ul8m960k1alo97nlTluX7xv/kJN2hZ
PuF5QrXn+kULfIKrFUv1fT/5/+m+f6Hv92nP/RZ5zq56+2rboLTkS/rTZ+bh
aLslaXxRf/ojz1mLPc8QzTL+RN/zc56zr/Gc/VE5+/M6//91QWf/sb63Uh1V
hea7sqznkgurbLNn7+fN3RLP71LrjPe/fXXdWqZfv7igq296zzK8Vd//S+9x
v9+Sy6/V5WC/531v0fn8S899r327wqYsIH+u/F/x3Oc6z3kfWeD9btD5+hvP
/a73nPfhBd7vOp2/v/Pcb6nnvN8sl2ZlHXCvrtQm752u1+cqCT+mP/0vz1k3
eJ5n6/OklRLa+PHvPVfd6LnKnCPvB+TlI/puXum9uVjo/Zbp/HxrnuvLreU8
192mr/uf8nvfCQqqNEK+0AgZVugk8c34aJg4WKFRqiyPdy3Jm+XrD+oneNtj
6J/ZWyK7b5hMfiTf+wTxM/FY2312WB5vmPxaFR6lJQt8ptuDlB6nr6dE/J6P
/LQ+fm/yEw07OAxBQ5Isfp4Vxh9k5CdGRomT4eeDzc9dXFFaszpwVb9T69pf
4+DvGqLuIeo5jsQ/8HNNPNjiB/NjQ8OgeYJM/VRf5OqnmnyoipwiX/gUzSn7
il7GbfJ6Y6WsVZ1D1CUJzx/Sz+cH4+nq0eWn85PNiH66zY/kDPSPEier/xQt
juhncx6QDW97r9oat+X7W+Sho8j36RykrkH9fJMzYPYeV/fhHASRCX68GUZp
8+MjkvjhJ/mZo4pB9BRxMkw+mP3IQ/8YRSTxeWMkLQXehN3kzZkqG7S9ZbuK
X1WVUOVjtxepQ1JnkUzOr7Goe9AlNkS9Q9Qn3DjDIegLkFnhYeJ8R5B1zrTZ
jzLjTEclcX4r8o+88sHmrJvIOJ6vZbD4YHGuXXv1G5LbRZ6S9dRWvq1Y60Wt
eWrLU3uBOgo6911F8ObcG6Bt2Mi7m30TmfdxviPDyDcS0zb7OffRk2Qjxz7O
7gCnMZQ+H/kLle/KPPt0nr3trbIgppd0hbbOWrhZi/TnoqcsSWuO+Niep448
5OkscN5YHC6LIvUMIilhgiIMyxKG5kZQFixKPydIE4UCsTiqHAZGyWR5DJtl
iUniB1v8AXKJHWTZqirKYG7vS3opvvK3ukRsjxR/BukCWa4YLVlqzVJbTkvS
mWeNYlGqIYWkvkFIERIpwmwJRIL+YYqeoGilBAOjOpmxU2THxpQ+KSkMk2Ww
RLH4LvyqEqTxa2nYaI5ROcO3zspiV8piziPLF3BY3JSl5iwFVMpQSwZitWep
I6dkypOxuLtAPQXqZZmKItMQhUUsSMP1miUyB1ga38BJio26CZWYRTDjY+oN
hBpnifhgDoxLqdjRcZaF/yL40/JYs/KY5faqek4L4C1Fr3R/Il82pqlJUnOa
zECajOtaM9SmBMxSV45Yvu489eSptwDpgoOQLqLqURQlNnCCWLYYSix2kssI
9Z1li3NC+fDBio/rMhsnV0LJ2cAERSdQt5SUPkjJEpqhuTp4U9kemPPUKZ9H
tv+O8xpYmpvv+akD+VLUnKJAilrS1Jqm9gyE62T5stSdmxUuVKTwEPUPQbiB
EsVOIP8ot/hJio+66ZSSyrASY5QYR+LPkCg+gTLkI0s4oTSSXwck+SCo1T9B
LCcnA7Ky7RzXxloKdb75G2NO/7PKIytGQ9KK+mGWh6ls18Sece4/pLSuIYP0
s9dKdz/m7AnTngg1JqkpQc1JaklSa4ra09SRpq4M9WSpN0d9eQoVKFKk/kGK
CpL4MCVGKIkuSBI2MnmKkmNugjjJCTITKNAyiUdedsRuMwdTUzAZgi0lzZfY
LHvITa5lvHleuas9cmO0anE7jpbUhGGvgiksifDDpOzIgGglGDzyC+fRFcjL
ziDtCtFuTkHaG6TXwtQUp0CCWpPUnqTOFPVmqC9LoTxF8tRfoGiRYiJ98gSl
Rih1ktKjlEbdTcO2pMcpPaGTmYLsSZFd/YP4JmOA/BbLb2n5rQi/MgObGdjz
aDv0u3IsVlUmgk+LPSR+D2dz18Kwyk21avX8uqEQKws0bGVRZ/1cZ1m5WbWP
pSAa1xDpP9x810POzl7a3Ut7++i1IO0PU0uM2uPUmaDeNIWyFMlSf56ieYoV
KS5GID1CmZOUGaUM6kUWqpwdp+wEEn8+zUQyk7NEkpNkqFEtFOQ0cTLs2GnY
kdOk7YFZ1hLUIsYUdpMVGp/XOvjmWD9vXbLn6JQxD8mPur9zd7ETFEHVLnfc
dN/NuEH3JgYFrZjD/hIsfWyY4idQSRqSYNMszcX2HtrRraVevLuHXuulA0E6
GKS2AeqMU2+SQmmAfehJxy9knhRFxT8zB6uRO025SdXf54PJOA1/elJ0cpI4
JeRHk1FaTNJkkK6e+ZigpblZ76BnC+FW9fbszALkuNbDDaM+s2NQ2Tx+7ZRk
oddym+qGqSZft5DShoSFW5TNbIkSw8TVqyEh0NhQp2lrJ23rpNoO2tGBL+/6
gbO/hw70UGuEOgdIRhfXxLIUL1BKamfuBOVPUn6U8mNUGKfCBLlKZtj5KcpJ
yk4pPfcxvZSgS2qu8UluuSaVKg5IijLJCopsqye0EhquFrLFrehZqONCNdE7
B+YtGS9hNbPaPkiqi27IqALnd+jP3OcV3reW+1cKdpCbtUGKDMGGx45TokSp
YbBpjFNzQsx+hja30pYW2tpC2wLktOLX/R2K1LU9UQrFKZamRI5SRcoK7OII
DY7S4BgVx6nIjIDwmuIUFafx69Ornfw05abpidVOdpoy05SeotQU5zE5hVZT
kDNwbhUmRVvNKOo/w+6XZKDem+EJ1T6GJHGfXTO3Zpl7yb73HKti745LpYbN
01Pyfl7iKQvMKVS1F7W2F2XQUSCTO+rSw70ZvUHVZcpTXwG9Cm5Fo4NoRxLH
KSWj7qYYWt22FHVkqDtL6xtoYwNtbqDaRm0prjnQSq091N1HoQilM5QtUH6I
inJxaZRKuhts+I9P0fFpGpqmwWkUQGFaSs5k8oYF9tOUmgZ7PtjxKYoLfiE/
yWOd06pXEpFkWGIvWOND46pLEpQ0Zx5+7mzLwrR8vlWiSrIYuZtt0OzWIvFr
G8Y+fDB5aKdGuHpYJEn63stU75QTOix5CqtWu0DxIiWH6InnnaaotGIJ6khS
T5pW1tErh+nRVSW+3ZbDtL0ORNvaqbuTBkJUzNBgkYakaRO+7x+ZpJEpGpmm
E2eoNENDMzQ4Q8UZnJCfoSfXONkzlDlD6TMaNYNOTFMc+g6Lgpsw6SjaPdiU
/tPaKgN3aMLVb7HQQTWWrJy3c1+r3pEnfr3BwxGjZ5sRmq0FsngwafHo2Kji
E9t5OCYJo5cc+vfcxmVhNVSvR7XwWYrlKVkQPe2n1ij94hfOyy86a19xNmxw
PvsNZ8Ve/LR6N736Gt60N1FPCyVDVEqTMFs0NkZjEzQ2SaemaXSGRs/SyFka
PkvHz7raXZghppcTjJkZ0EudcdFV0MM6WlToaXasoqddbTU1R5Mx2oBoB8e1
xvbptu4qHV26IJ2UeVt+rMzPtaKWM8QWTnkk0DR5hG62YozLV93/hFMeLnFd
NrkLbSzqTFIXK1uSgimKpGmAzWcWkj7ztKN7P6tXOJGMaqNEr59d80btjrf+
9z0BV+9uGS/ShNT2yQk6PUkTZ2jiLI2fo1PnaeQ8DZ/HT0PnqHiWCmcpfxYs
s4KTWSaFpckkzdgURv2CULEERTOCP6bG9KCE0qIFx5V17ZM0Z31JrGB5bcU7
Anu/RwPRhzdBz2opCj3WJl+AtdAO5NzBdJZHnMzgmhYB0SpDM26QuCfelkCv
sz1GnTH650c0M//Dj6BfxDV0pECTQ3T+pLYJ9Mab/PLpT73ksrs22kzP/FB3
olYvd2bGaGaapmdo6ixNnqeJC3Tqgrr2+tJ5GjpPxXOAmDsLgmmBmBKIShtj
nKZoADqJamz1C8qIVkZprsJu8oWgj6jL/McY56form7f7KEmaxAMzAwUyGZa
JsNiYjIDwZ1JThaP0w2rWbrt0n4F4mQsDXBrMqC/6ugnNNpRivRL5YrS8QSN
pemyNN09uxo0JVuUb7iPppJ0VncmjKVnL9DMRZq6RBMXcfqJizR8kY5fAKTC
eSF0FoRSAilxRusYty1VCpGqrEyIyaAoQAh11A8tYya2hwkeel2ZyZwZ6znr
DgwnwAntAg4WQ2qWZJjNObKaWKeauBbyiMa4qTGFfjj3Khvi1BBDhhsGqDEq
ncwIBUIU6KP2Hurspp4uGfJ3UaaPRkJ0Jf0GHiwW5NpPL3sEV66b5uNI1xvn
RVkvT9Cls3T5Em3c4sy8rnSp+uQlGr5EpYs0dEFgnRNYZ8lMzii88TPQJUN4
LQKsSl4uMqiUGT6tepwhSYat6RlW37hbP6Fd3lVJmdeSvmN5Nt67vhNQ2mUB
mdWUp6YckgFyxqLGLDVmqDGN1MApRfVJqo/TUaZnHmVy13zrQVSr+jDVh6i+
l4520dE2amqhtmbqbJztc1t0fFIXsNuCGR/o2jTOLzPBS29JD/SNM3TlAr1+
hS78Ch9PX6HRyzR8GQAHL1LhAuXOU/YcADK/xAzFRecUPd/ANEWnBeAU6HFb
MClWjakJRTSv0Dm2aBOEZgF9SIbnf1dqc+bLPeuUQq+Z9a6K8TWVU44aOTFA
q4H1r4H1D3NPi44JvqMJqovTkRgdjtJhqZKHQroVtA920oE2OtBMB46pltPq
23f5sTs3uT1T6XdV85u+tUN8fCt+mY+/nqE3L9Ibb6hR0KKR1+n4ZRpiYheF
2HlKn6MUQ0NbC2ZW7IxoNzQvil4hkE1B4YQagJlCCgtaatx0nWGU15avLdPB
8z7ooSK6JkSaCrNEGvMg0pBTRAzrWJaOZZAM8xiTWVKfpqNJqkvSkTgdjtOh
GB2SankghKHx3m7a0zGrS76d+2jPbm3derZMChm/zo9xg/PMRn6hS/Tmm79G
a/krOnlF2sbLQuQCZZjIeUqdA5H4WYrNoAaeUTUyKmpkXIs7+ZSXEvRlgvpQ
6/qUvbJ6x8g7GyUrE5KL+VrD3/BQUr4ZTUUqQzIb0RY25AEJifXmGEjVZ6k+
g8RvmdTiuhQwHU5oTAfEjO2P0L4w5miEz+KtjRrOpp14s3nDG3w8/OLoQ59/
3HA9sD637O7jm+OuXhmL33rzLX4Z+xWdeJ2YFL/PXqT0BUqdp+Q58gn8h1aX
5yGk/Y2I0nAKT1KI02npO9hBrTuMrE+bKJOp+Zmad61bUZs7RvaOuD7k4afW
gTQ/2H6mZzbAgjE7KBejMxkda1aGjnJKI9VxStERwXcoTgcF3/6BWc1a4nRR
bTvVBDDy2lBPaw7gtxc30YqXfvXZT7zy6uPH7/3EQ4ZbDxcHhumxVT33LXcC
yQt8bD7+5neXOweHaPAy5S6SmruJnKHINBLXLdgpZsZfg5yucWH0IBS9ECw9
0/ND2YANEF07xfTMnjFa+nbFnN87kMPv/85DTHq5vjKxxgLqpDHLLEf1LjNL
MWNahomD70iKDifpUIIOxGl/TI8zl+yJ0O4wOb1U20U1HZgz2BigdY208ggk
/N7PnO8td1bXXeGzlzv+AFaS+c2reweY0autOd93X3AMa0VzaU+BdsNc7EJO
duXo3hecEDr6IeFymoKnUf0MMAEHq1evHTCPXrR6fPAxF+/6f9U78PH27pd5
OEkNbkL3R1NCp0IoHcsLpZxL6WhWKGU0Jetwmg6n6FCSZFbOuH5fjF6T2rm7
n3ZFaEeItgzQ5iht6qcNEVofprVBYkpruumV1l8LHFCyGI8JNj4GsTMPHJwE
zk4hlCeGtCunYBkWfnQ/ZzHiOQ1TpZLVy/3P3nGxV5XMqpjX+/8VvKBPXk8+
n+ZkAlBVQ4FguiR5OPmYU10WnDgdSbuzFAeSdCBB++JgdP/Pna0JMvnFsO5n
vfmZ8/jBkmHzq3nfzxzDfqXlLaajks2MzGbWpmoGde9yR/GpzdJzDSV+syNH
tpMj/07NZmeWdkKv+SB8rJ0y7sLR1zNOICEZ4le8teVzzyl3Rsn1GaheoDZ5
KdmunWosiiaZDAp1zmRIfm11cLmfZTeZgWFtidHmGL3KRsncxAd7Y5TW9dPa
CDEJH8tvSk1iACy+ImCzmIZdm6HtWaQd3HIwBR9TMO953qlysmr+x0ET4qSJ
Xx00JB7JTY/kN3sk813Vvnnt80c8cuP3RXhqPVo11oXyfL9Zh1LYkabtKSTD
5INVy5Vm8bYkPVNX2pqkmgTVxGlLXEDEaFOMNg6QtYFpWOujpNSA6xgffE+u
CjCER1YFmMMDqwJS5Ia9NYNqw0Q4mdvleS4awwQf5lK9I6NafM2jmg/VogKK
SfcpJPHq5C9U7XB7QF6vVLG5XMJWgzYWxyTp2eajOWgcyKe5ZPhR9nZXek5m
LUPwM4Btkp6uK33v505Nkswa0YY4vSrJsDbFyWQUxiJ+c5+U/fMi/KOrAg+K
/BDdrOG72VvTtE0Q3POCY3HVAAPIbLPMvu1abhQB5OZXqIW/W+uDElz57KC8
5qn3xhwPRS8RUxNhGkWCcSiom0MfzJ2iiRlNxQATczv+UmQzDXObyJAiBsEm
gGuFtYX/NoPHZlaKBFTfML8Lzef6wGKK1FU1aWLBuexZ9ntU8aO8736eGbhy
Q2L1bwm/hRoaVtcpXdiGiYNnfAR18K4mz8/gd6TCl89ydUJ68Sz/sQKJgd7F
OunMlgGyUIVs+Wu51MopBWWA9bNYFwzfFlUrkhB9C1oYltywX5By/+VrhQdW
Bsx70J5qBhCLKZh34zsGoG4qRgLKJ8/ersp/qXzmXDCGrlMKh9ejFB8Xzctg
Xi9YfZa7PgUVsHfB/mZIih0WlDVRCe9HybPopmQQmU8hPX20JLbfxxVCWToW
fgsUA5JbSrdFZD7YkNPHAvM9WFolsIGaZdUKijTVqoKv4lfomG87/kTyFHWJ
q94c/5sqLbl3tt+eIznu/NGK+mKyxH5ukkXqclmLxIattd12c+aWFwsNnfaz
fJBJlV1Zpw0TB0vJKNLhYH3nOYevQ4Wx+KDGkOoLpUG+bcrCwMJWb2eNasCa
XMOQtvKcX7/Ot3ePg5LSXXd2e5W/rc+Wz6LZHaO0W/U/qvlgiopz6wqrKjXc
hM2RerZdSqFWSkaXNzLNr9/lgjY52xbXY9HsKrbrzOBuST9aGeCjYsQahOt8
ZT3h9O3nHKEnlPFVEmeyvJCf5fax3D6Wu7J8Jet88M5SKqnnXd3weNRa2i4A
APdjDwQVCMPkA0gYKHyAkKTmeLnpgRagIHegZeI/tFDbUCdYrGePlVTVF2n8
LOM9yx0kwfDjlQGLXywBMVvPwc2G/bOYQ42aBoT0hl2jbIakRdsS5K9NaHs8
iGSACaT4wIIZuOMKS+uNv0J2ecuyV7Hs6GShnVV6r9pdtD2WltiwWdRa19Ch
0psspk9q8XdegBQqbRGzjkq/JantNgtlsTwmWgRpIbl52CbJqMbBZiGPFXWy
WVjrmZ1B1vjBWY337mBZWJl/UMuNnmA1hLXLcu9hvdeSc/8yR26f07magFvm
ho8R3Pdzh1OtNNQGmEABQEHqvc0UHlwZ+PbzDicRHs2AJmLywcR3sKPcGnK6
6xkHbaRhv8SDjIRO6EGgTylcrHoXimEeAxUnCFVYMJk5fn4uD/H47RwlDxNO
78hkUZmJqhDbpU4wDsCRvgp0ZEnZ1ikjyWzuXo6KwGy+/QLAfOs55y7U/VfZ
rjEEc3NS9xL4/q8miJNhymfGo5AYfs0FamMxF2AxfE85wafdBEJVTMbbGryL
pZjjN3iLto5oO/3Mpgps/JVs9uRhLPxSV/jP0WtHyliw4WQwzzeUbOm7ci+m
NqP0BIdqheNuwfFDVhKXhckwzE2Qd2OcNkniXmNCbI9fPnzzaWezdKyNahz8
3MveGqejBaT6Aj21I2gyCpOZWIyhegEUrHIrMd+o4EatI5gTXMQcvPbClM/M
YpckNpncZmLk5geFnK7yPJj53i8cW/QiC/mzgKESNwg1woKVwmQSRvW3nodS
cPrms87GBDGKDXEczY0xRYbviLd+Pkh/2vrGU85mGXSxtsTIxwMwsw6ZeWJ7
8ElOO4JMx8d4eBxTnLUt8+nIjfPScX0Ul2oasvOC+xwg4lNEDgY7Tl1NZLci
4t+F/jL/OciRQsI8trPOaB7mNgxla4WJahK+g94xWPiYxU9eCoDFc843nuVv
Ib6PBd8Qo/UDSDKXtR4U+AN/CzKKFKNhMDz8MmygsY7kiYFwMkw+WEzIOooh
Dnfo60V7+C0O3M3Vdsb3ryLk9XXBSeh/VzMp2JfFneiX/vJgkF870FfHwdJV
SZMy/IyKSd2/wuG0Iy9r9sxK9MZmULWS0DN2W1E9GrgeZ66LkskDTKMaLAYw
6OTEg/CvP+nweJxRmD9l8e3HtwcZxpEckl9zAAaT5TdZfLQ6ho+7/mWbIG4D
C5J8kZYca1vv55641TVWlloAsNTWHubs312A2LtdTWF5ZX7IdvKz1WaRiPat
F5x/fhlasHxP4RvPOU++GPj6M87fP+OsFyVYJ0qwtp/W9NPqfua6JqrmC9Yy
CT8jWe+mDVE6yP3Z/7Mt6DvM+sfSW3U5qSsmE7BB4BhmNwokLYtVJjCnZ+3t
ayoWaFmBwu13g9i1zOBaMLBfPBTsHCOVQMFkCiYmDi0G8P0Vzk53huyWMgEM
cnJUm5Myz8JWcKlzmW9J0+YU3fW8wzS+/qxz5zPOAysCj/4i8LWnnP/xhLMq
ouTnptSwXgrSy0FaHWEuOFhrIrj3PvS79qEfsz9Dj24NProNyQSdQ1nyHYbV
PpKFftShR4gDKsxRSYYtcyKYIijoofG/ndccH1E+Sc3czI5qLT5YPLq/QXSJ
OfIr3ppM0uyA1xrjbJfEPHcVyLU50pVkmjskqTn/pQzv1RRtTNKGBK1P0LoY
rYnR1552HtlR+OoTzuO1hb/5qfPc1sKDzwW+/ChWC6yf9XBt+FkX1fTT1iht
j9EudGf2qtGK+XBN0LCY5/40HQBVPpgHeWR+iOsoczSPoGXE9GFOp6M5Kmsb
v6oZFzW/VqQ5ft9efyLt6DWPv5fyulCVVf2T/YnM7mZmZ7k62OXqoM3kfO16
/8euIu3E7B4OFrOqzdPWnCa2ZGMKoJjSKwP01Sedv3nC+cpPnb98zPlz8V74
04edLz4kyyrmelauxevDtD5E6/tofS9t6KPNIdrWTz/YGHxgU/DBzUFzb1I9
8bUk7cM8AA6+/Sk64KaDoHgIY6TDGWKCRyRh0g16aDI+sMNkNhvovFZAJPQM
GaHfQ+y6eQl6d1iVfWvK9LDipeZTumWCEVNrS/jgA81u+OZ0ixpyYqzga2t9
VOtR/KZdUtsYtZ6iwClqGqWGk1Q/QkdP6LWVrzzurkeplb/bv15Trvmrumhl
B61sp2+vCN77YvB7K4NbgrQtQk6UdsdpT5z2xtXq8WvcQ9qHvjOj3J+kA0k6
yLrJBM3DGVWP61x+WeEn85lo9iRBCzGjC00EP683vpefkJvTU/LWeKHXc4pu
ZGJVPeNk92D58aUjwe4JUsnumlCa0DVOnVgj6uBDFfNqHaOWMWqu4KU9jL7+
QuXqHcpZVvWuvf1e5/Z7nF820coWWt1O6zppUw/V9FFtmHYyrBjtiWnedz7m
3uFWbaffW9J5dztp/biBpavugS6weL2VqxaGtfJIkL+E2BYOS/kOZdlZ9I4J
ah+HrAGRtZFlHRX3tFFqHqMnG7K2MTtbbdifXvYUvyxfd2X5Xloi+rVXVmf2
xWl/HAsRXOyHOKXocBqLFGYd2586vcpTn9VrYzltc2Sl1l0d4oR1EO9uBO+s
0fw0vHtwMHLAzLzZy7WEX/1Mx5QVHOaCFbDgaX6FD/2quiC/cvrBSrWjope/
reo+7cKZoNZxKEL7hC5/X88UreqBk+OLmzbS+VHDnddx1yCMDy5/eAKUami5
rK6vOEwv1tOqJlrdQuvb6dVO2tpD24NYzNrdT3tkgR4MY8IwTgcTYHhYGMqa
mFBkgJZaVZRVxmN6mdvS3Lwe914/Z8VNTzfOLrzM0T7MV2M1B+uk1UysStZQ
g7KoiqVEn6wnrj4a5GuDWHfFweqbpJ5J6sbnTuZ3Hb/rm6aQ+Ec8vM55bAPY
Dl7E0jhdOe+8stL5yTMr/uJHhl65wYNvc75/J39e95McH3/+wsXb79jxmS/j
spf30SuHaG0dbThGm5qoppW2ddCOHiya7o7QXvH82DcAfAdiFfiSdCTFPSum
dzTDthp+ADnROVOIKWrXeKT3fjbLVrocM8XTC8eaaZVaQB3HMj3WmeHfoLlN
UFCvRzM3WaP2Yalflq3DU8pyrqnn3jB/CE0Rc+ybUlbCzl6k4mUqXaaRK7oP
QZeuoC/2j8+VLY/SyL3PDvLLmpcuvbTm1y+/qvW0av1rtOkQbT5K25poexvt
7MK2HLbTEWXv9kVlyd6E54PvUBzL0ocFW13KXYnFar/rM4GePxwCctqxQlbf
Gln/4DaAlTnNxKuH8xO9TlsvNY7pkeVUQJTV+T5u3cRDZIJ8WLKG61/IVcBw
2Sdpisz+aSXLg8qhQtnhxDk4W6QvUOYiZS9qj5XRKzQh3lDBnmCwLeir5Lek
Y82JQ2vO8LuaGpyyYQdt2oM3NUeotoGcFtrdQa/1gRV6FgdE4w4MwO8BDjZx
uEEcEa8bRgdoWPjHmi3cc0w460DtGiXBQ0XrnteyeckpUt4+K3pioGRrSgbM
mXKtEZ8HW9zafrRStzA/XqX3viifk4Ez2Nl5BvsxZuCzs7kpmDxHZvo8twyZ
C8AFrbtEy7c4TKyhG7W8tzv4lmCk4TdeD5/7+Z0r7r/9p5qf+Dr67/rKdnTe
dtPWPbRtH20/pPS1am877e+hQyE6HHE9tKBxh6Bxh+N0JCHMklSPadd6rqng
xszg2wRnCqVfililjr0XufcJOa/vtswXwMuhb0w8IBSXH77stsXKNyd8Girm
+nCZ/VNkRbWWxc4Q3JvE92txQhzBUmeppjmYEe+w7AV4qxQu0t72oPIg+9Wv
6M0L9JZYwbeKb053nOM3gZdLRqX2LT5+9MLAoStdB+FcVH+YDh6m3XW09xjt
a6YDrXot4miE6gRg3QC3BuB3JE51CTh71St+4v9lwbdQtiNyp5R1rzFHviY0
FAywWaUiebl4rZqi551hKHvx/cuLAqxaaMEBUOleFTyWGJ4V0Z68/eJCKJ5x
Jlzk7IdXO4wvfgb+huK5eRPTS5+DG9m2QLA2ENzeEtzREtzTFhx7HaKeu0KX
r9Drl+iK+CdeKdHF1K9PtMJTr27VWNk7DFMOdAJOkWNdb2VbKdKCszubqTVA
DQE63EJ1HVTfQw0haoi4fbhjUaqPIXFvJM56h1nghpS4ZkqCr6HdyFrYlFMa
2JxX/olWoAA/WTx4YRzfry0d+FVpzdMe4Vd5oRpwGYfySVJ+5NA/tBjwZZ3S
acD1c7XiZ7SrsCE0q9MzcOnMnoVvJ9PMn6fiBfh8Khs387oezV88TxdlO9HZ
Ik3GqNAK574ja2f4uOpzdyimcFOkk2hsxiNUDFGyT/aS91BfL3X1UlsPNfeJ
n68a4xuLmmT2ozFGjXFxCk6Ig3AK7q4GfIbhO2yLD7G4xFb4FmO6IZCH47Hy
PS7STR6O3h6h4ur1YgZ9+KBK4xt0k3hHqx1Pp+EGLD7AysFcnIPFw1V8z6Pi
ZS2+6DHl4S8GISnu6inlvW4yXMPKnaXtzcHiebc/OH6Jpi/TzCX4d8/wt6pm
fH7ZF577+I+lfXdr+vXOSufKMJ3O0EiaBmUlJhmngTiF4/Asb4/Q/eIE3BoV
p3MzENPtfnOSmpLYa83oUMubxGO9GZ1BdchV8jQZJ9QULL0rEd7enmLpPQss
xT8zqDfQVOgp1NQH7WR0FnY9ABl81GNqg4nsNElOq55NmpXztzKyfyIneymc
5uBzG5zh8zR6EY7wU5wu0NR5mjxLk3LN5AiNFWg4Rulu+uE9Tr1siPnbZXd8
Y9kd/ObTy+74xY/WfH3ZHSv+AB+nSzQ2RCeK9OxTjljv6o4YNjdgi0McG5Pa
ktj00KrnSALcMgcy/JcV/3/smrCVr3uRWlSd9q7heUfxipf3LGioKbqHTTKu
7mG3gk/rn+z/Er3rPw2li2q9w14x2UlixVx2ekdZWnBkzlD2DJn5Gb2/8vg5
OnEeO1XGz2PLimGOs0ZWj52hU7JtdfQEjRRpKE7xHupq0t7z/3jnuj8UersD
pRcOvHH7/c6KNjpzSvmiVseyFE5jO01vCvtqupLUmaSOlNpvU9WewQ6cNok4
Ac3MUktWbZwAQWiaib07LQWymaDXh3l+erdqi6giK/S5e+GC47I7ztQ6pvco
My1J0dNa22APY5PYN8Kpkth1KdmTx7lkYrkzlBfzWJyhXY3BkuyTOslphk4y
z5M4f2TS3fI3TENFyico0kudbRQISEObxY7Q1ducgeOqp3BNSTYNpYvYw9Wf
p0gOu7r6stSToW7Za6h2fPk6ZctSu6Q2PXtltcLuteT0ZifDlN1OBfK1Fum2
eai9jz+CliLm9Xr2eciNufsK3c0yhhlWu2uxJ8lSu0AnaUCS2v/lB70pSkxR
cgrVleGZoGdnBeFT0ls0se/0Y7sagqUZKp2h0jSVpqg0SaXTVJqg4+MCeJjy
xylXoHSSgn3U0U1NHbS1vdRdolU1uMnaLU6oSME8vVxPKxvp5SZ6uZlWtdCX
H3CSQxQfotggYgH0FylcwD7DPibTg1m17jxiZHRJhJMONBPtedUPa5OgNIZV
wfA35yF0NUOv57P4XQZ1gIiKvYIqdoSi6I+4sSVEAQ1FkhnGJCmSi+KTIJmU
lJrCnty0bM7N6m6jULxx57Hg4BQVJ7GvtzhOhTEqnJJt1SNSz4ewCTiRo1iS
+rgpkC00yzc7UoNvCR/HXlcG05OFY/DaJloXoLUttLaVHt5WWttJyRLFS9gG
Gx3CllicXMAmWezfLFC33j9rdRb0llrDxAGZay8guo+BfaC+tiL9loeSPYfj
bbr2LoSf0kAwjE4AIPBhX7KNXbKyUTkhO8VlD3Ma++kyU/TEK9CaHI/u8vzN
0qde0f3zwiTlJyg/Trkxyo5SZoTSw/TTF6BECamTAxmKpklGJL7gCVqxyVmx
wemTLcOG2c317/qNrbShjTa006ZO+uqDzsYuSg4D3EAJsUnCQ9jQHZTN3b2Y
xe3Bun63CnkkCXvBVdQpw90fzsliO/E778nN6x8tM0aIHACbFx4nt8aKvkXd
eA0q6oDsno+5aifk7IS7zT41qe18ZpKybsoxLDnW1gVlD8bSBx53QmnEROhK
INiaikTWd5yWr3Gc5hLXso4c7PyWTtrcSU9uL5mbu7kAE8xnWPiUJDaNGUI0
DAQYYkYSA2oQM9MqBhc+CyV8h6AF6h/iF/z7eaS/mo+3BpsVfCSah9YlS+K9
RN1oAtwYMCMJdpE4DRz8QCZipZkKA5E4Gb+bnaCtR4KZCcqMU3oMcUZSJxEX
ISHbpbjaDBQReqM/R+EshTIIycHtIPcfeocR0Kx7CIXPNeaZVc4zK51tjaWW
DG3tpqedUk0P1fQiNEVMAhJFJRQIgwpJcBCzD7R6Z2OH8J3sriGyOofoP8wj
79VEvD7QEvdKduqH3LAdhimxXiLjeueuZmRHVVQUG9Fh4hO6Fwk+kgwzxXUw
DY7pcao5HETAFTPFhw8kRyl5khInUOp8zcAQTHOkgM3foZxu7LrSCOjSEqfO
4whGwTUARiSPzc/cyj3xot5Vam/ro9o+xC8aOKGio9j9w8ATLiFqyhw2iN3W
je+6XK864/ffk9FHtDWCPvmgLahJkXHZgysRJipIqJ2CEyRxhHCwExOUdJOZ
5KuSoLv5UBABeLA2nhglY1l8RBfwT553YF8HKVxEBB+2x705mOTODOL7tMse
24CE/mFL2qo2Nsue3Md+6ewMiaqdBI/oCELoMAwVmSs8jKBvEqtOoub1lqB0
EM8bj7VSfu09fZWfrNIOBD7S8TQkFlKkHP+hKqqiBUnYILd2ah2RWFJ2YhzB
pVQyEZDJ3nQgqMMzIQYVN1Y3xETP+dKIspnKYEpjw1a2S+I/oQOUwbbjljQC
RPEYEC5ojSnZ0pfFBIUTRuykAcR5lHhk/SpenIRZQvw7iabrq5QOq/9Kcq+1
lRFWSMeMi6iYV1VRyD4gfRSExfLxATJaiDDlj53SwcI2HgiqQpE4YjcgRJrE
OMJwV1VjZeukGdE9kpzu36FbDG8iRPfyNbvxvtQOT+NPry6dcql9dJ68G1Dd
cnxBFQFPSWGLFA+9hDYQbxG/bBFimyHImR2T6G0b9gcHVEQqxEPjQpY4TXxB
SARQ8XRUa1bNXYHZPpXEK1BdeoyJZDDJY3Rk6J1y/7GK+gbaiGynovchVJwE
ipNIhIiAJxHlqmIq3t8p5BQh807S+v1BPh0RDU+4NUDUCWH3xCr4eySsjW55
JVCfiQ6gT1kYTqhW3KD/RQXLWe3wRo42K/Jq9uuIdvyqkk/nlnVFAkEiFqTF
GUXEQsO3bl+wfwQBvxA5ElHLkF+/qrF8F24/+yR8o0QvQkxH1VHoVH0DMYvc
VeWOqoo+Wub4e/P1BjiPPjfiJILSqQxKBEFhylmzJIYiomaeROJcrd0XNBBV
00T2qlT9CVXkrxcmVSI1ohmTVtrtxaDjop//V1dZFm/bJH298DvEloyouJmI
n8k5O0UqpGe/iixqq1ifkk0+IgJoGNFPJR6qCo5qGL3HSXLo61axRAd1syJx
dGdz9XFNUM1hhEXfEDRURQ5VD3SjmaoIp+qJa0AoxE+WCKh4ct8wntwrDzcR
sdTukRhUKpApYotC9dX8+3yxu60wyxsepWqJ1npSYqoaCOm6el8QgWTxJGMR
otpK+NXy43RcWH6g+wwZIavo7Z65Vj/fH1FoEZRWRcblm6tYuYaP7/h3+g5q
/+InNZtblTUZudpn6mv6XBUP4FOep3lH7X+tz5YZ4DltkHf39l/qs1Usyz/0
/OqdWfqSPltFIb1d59p71hf0WdJnnhMx3OsB9nl9topv/Z88v3rnsRHpGx9V
ZO/Pen71zul+Vt9b6qtEeEd+vWfdrs9SEf//i+dX73r+H+iz1f9c4I087l3b
+H19tvr/Jf7Y86t3lfd39dnSehr/7e3ZuefKs35HnyV3k5iO7zaP/WF99h1y
9h2eX72zs7fps6UFUbEw32X+0fV+Fksu5T5bw2fPulnfU2LSqrbJ60HsKUOc
/bdy9p95frXm4Y2zvyZnf+nt2fZtzowof7xTzpLcXtU6Vunf5f/fuCpiOuqf
pX/9jvz6ZT6iY/Nd+WS87/8B9oFYvg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210576426]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26384],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erfc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erfc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseErf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseGammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseBetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseBetaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15928]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25303],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->14720]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->11548],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/index.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/InverseErfc/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->806452931],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->439776458],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->184495486],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->460599403]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseErfc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 42.7600036}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseErfc[s] gives the inverse complementary error function obtained \
as the solution for z in s = erfc(z). ", "synonyms" -> {"inverse erfc"}, 
    "title" -> "InverseErfc", "type" -> "Symbol", "uri" -> 
    "ref/InverseErfc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5625, 185, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->533164336]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 41844, 1203}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2506, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3129, 85, 48, 1, 70, "ObjectName",
 CellID->8496],
Cell[3180, 88, 752, 24, 70, "Usage",
 CellID->23662]
}, Open  ]],
Cell[CellGroupData[{
Cell[3969, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4447, 134, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4570, 140, 324, 12, 70, "Notes",
 CellID->27980],
Cell[4897, 154, 254, 8, 70, "Notes",
 CellID->247571332],
Cell[5154, 164, 224, 7, 70, "Notes",
 CellID->31226],
Cell[5381, 173, 207, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5625, 185, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->533164336],
Cell[CellGroupData[{
Cell[6010, 199, 147, 5, 70, "ExampleSection",
 CellID->33280994],
Cell[6160, 206, 60, 1, 70, "ExampleText",
 CellID->26698],
Cell[CellGroupData[{
Cell[6245, 211, 104, 3, 28, "Input",
 CellID->5017],
Cell[6352, 216, 177, 5, 36, "Output",
 CellID->655475469]
}, Open  ]],
Cell[6544, 224, 121, 3, 70, "ExampleDelimiter",
 CellID->25227],
Cell[CellGroupData[{
Cell[6690, 231, 217, 7, 28, "Input",
 CellID->17896],
Cell[6910, 240, 2082, 38, 124, "Output",
 Evaluatable->False,
 CellID->14619567]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9041, 284, 215, 7, 70, "ExampleSection",
 CellID->3996],
Cell[9259, 293, 75, 1, 70, "ExampleText",
 CellID->12432],
Cell[CellGroupData[{
Cell[9359, 298, 102, 3, 70, "Input",
 CellID->8394],
Cell[9464, 303, 168, 5, 36, "Output",
 CellID->271213068]
}, Open  ]],
Cell[CellGroupData[{
Cell[9669, 313, 104, 3, 70, "Input",
 CellID->17127],
Cell[9776, 318, 160, 5, 36, "Output",
 CellID->616760104]
}, Open  ]],
Cell[9951, 326, 121, 3, 70, "ExampleDelimiter",
 CellID->12249],
Cell[10075, 331, 66, 1, 70, "ExampleText",
 CellID->14108],
Cell[CellGroupData[{
Cell[10166, 336, 184, 6, 70, "Input",
 CellID->14397],
Cell[10353, 344, 235, 7, 36, "Output",
 CellID->475858818]
}, Open  ]],
Cell[10603, 354, 109, 3, 70, "ExampleText",
 CellID->21819],
Cell[CellGroupData[{
Cell[10737, 361, 128, 3, 70, "Input",
 CellID->16585],
Cell[10868, 366, 219, 6, 36, "Output",
 CellID->148613615]
}, Open  ]],
Cell[11102, 375, 121, 3, 70, "ExampleDelimiter",
 CellID->10752],
Cell[11226, 380, 55, 1, 70, "ExampleText",
 CellID->6631],
Cell[CellGroupData[{
Cell[11306, 385, 219, 7, 70, "Input",
 CellID->31236],
Cell[11528, 394, 630, 22, 51, "Output",
 CellID->400024195]
}, Open  ]],
Cell[CellGroupData[{
Cell[12195, 421, 287, 9, 70, "Input",
 CellID->647],
Cell[12485, 432, 945, 30, 80, "Output",
 CellID->339841280]
}, Open  ]],
Cell[13445, 465, 125, 3, 70, "ExampleDelimiter",
 CellID->373017311],
Cell[13573, 470, 203, 7, 70, "ExampleText",
 CellID->329873703],
Cell[CellGroupData[{
Cell[13801, 481, 146, 5, 70, "Input",
 CellID->76603757],
Cell[13950, 488, 279, 9, 52, "Output",
 CellID->107325198]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14278, 503, 239, 7, 70, "ExampleSection",
 CellID->22760],
Cell[14520, 512, 223, 7, 70, "ExampleText",
 CellID->16613],
Cell[CellGroupData[{
Cell[14768, 523, 201, 7, 70, "Input",
 CellID->15555],
Cell[14972, 532, 302, 9, 36, "Output",
 CellID->33548054]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15323, 547, 223, 7, 70, "ExampleSection",
 CellID->13588],
Cell[15549, 556, 84, 1, 70, "ExampleText",
 CellID->14371],
Cell[CellGroupData[{
Cell[15658, 561, 216, 7, 70, "Input",
 CellID->26673],
Cell[15877, 570, 552, 13, 54, "Output",
 CellID->368304899]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16478, 589, 233, 7, 70, "ExampleSection",
 CellID->18312],
Cell[16714, 598, 69, 1, 70, "ExampleText",
 CellID->950],
Cell[CellGroupData[{
Cell[16808, 603, 286, 10, 70, "Input",
 CellID->6128],
Cell[17097, 615, 689, 25, 51, "Output",
 CellID->76836720]
}, Open  ]],
Cell[17801, 643, 121, 3, 70, "ExampleDelimiter",
 CellID->25744],
Cell[17925, 648, 92, 1, 70, "ExampleText",
 CellID->18918],
Cell[CellGroupData[{
Cell[18042, 653, 237, 8, 70, "Input",
 CellID->28213],
Cell[18282, 663, 227, 7, 36, "Output",
 CellID->43344476]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18558, 676, 226, 7, 70, "ExampleSection",
 CellID->31974],
Cell[18787, 685, 339, 12, 70, "ExampleText",
 CellID->4779],
Cell[CellGroupData[{
Cell[19151, 701, 123, 4, 70, "Input",
 CellID->31728],
Cell[19277, 707, 199, 6, 36, "Output",
 CellID->375229079]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19525, 719, 224, 7, 70, "ExampleSection",
 CellID->17591],
Cell[19752, 728, 204, 8, 70, "ExampleText",
 CellID->32380],
Cell[CellGroupData[{
Cell[19981, 740, 935, 29, 70, "Input",
 CellID->18199],
Cell[20919, 771, 16349, 272, 70, "Output",
 Evaluatable->False,
 CellID->210576426]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37329, 1050, 311, 9, 70, "SeeAlsoSection",
 CellID->26384],
Cell[37643, 1061, 995, 35, 70, "SeeAlso",
 CellID->15928]
}, Open  ]],
Cell[CellGroupData[{
Cell[38675, 1101, 314, 9, 70, "TutorialsSection",
 CellID->25303],
Cell[38992, 1112, 144, 3, 70, "Tutorials",
 CellID->14720]
}, Open  ]],
Cell[CellGroupData[{
Cell[39173, 1120, 321, 9, 70, "RelatedLinksSection",
 CellID->11548],
Cell[39497, 1131, 176, 4, 70, "RelatedLinks"],
Cell[39676, 1137, 196, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39909, 1146, 319, 9, 70, "MoreAboutSection",
 CellID->806452931],
Cell[40231, 1157, 191, 4, 70, "MoreAbout",
 CellID->439776458],
Cell[40425, 1163, 165, 3, 70, "MoreAbout",
 CellID->184495486],
Cell[40593, 1168, 145, 3, 70, "MoreAbout",
 CellID->460599403]
}, Open  ]],
Cell[40753, 1174, 27, 0, 70, "History"],
Cell[40783, 1176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

