(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52922,       1896]
NotebookOptionsPosition[     34704,       1335]
NotebookOutlinePosition[     43567,       1573]
CellTagsIndexPosition[     42410,       1545]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseFourierSinTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierSinTransform"], 
          "FourierCosTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierCosTransform"], 
          "InverseFourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierTransform"], 
          "InverseFourier" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourier"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseFourierSinTransform\"\>", 
       2->"\<\"FourierCosTransform\"\>", 3->"\<\"InverseFourierTransform\"\>",
        4->"\<\"InverseFourier\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseFourierCosTransform", "ObjectName",
 CellID->1482],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseFourierCosTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFourierCosTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["\[Omega]", "TR"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the symbolic inverse Fourier cosine transform of \
",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseFourierCosTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFourierCosTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multidimensional inverse Fourier cosine \
transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11495]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The inverse Fourier cosine transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "\[Omega]", ")"}], TraditionalForm]], "InlineMath"],
 " is by default defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
      RowBox[{"cos", "(", 
       RowBox[{"\[Omega]", "\[InvisibleSpace]", "t"}], ")"}], "d", 
      "\[InvisibleSpace]", "\[Omega]"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->23967],

Cell["\<\
Other definitions are used in some scientific and technical fields. \
\>", "Notes",
 CellID->17148],

Cell[TextData[{
 "Different choices of definitions can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12105],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " the inverse Fourier transform computed by ",
 Cell[BoxData[
  ButtonBox["InverseFourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierCosTransform"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    SqrtBox[
     FractionBox[
      RowBox[{"\[VerticalSeparator]", "b", "\[VerticalSeparator]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], 
       RowBox[{"1", "+", "a"}]]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
      RowBox[{"cos", "(", 
       RowBox[{
       "b", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]", "t"}], 
       ")"}], "d", "\[InvisibleSpace]", "\[Omega]"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->19556],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " and other options to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can also be given in ",
 Cell[BoxData[
  ButtonBox["InverseFourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierCosTransform"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27000]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->269674755],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->38636045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Omega]", "^", "2"}], "+", "1"}], ")"}]}], ",", "\[Omega]", 
   ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,5",
 CellLabel->"In[1]:=",
 CellID->409380582],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "t"}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{57, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,5",
 CellLabel->"Out[1]=",
 CellID->140757489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59341575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,1",
 CellLabel->"In[1]:=",
 CellID->510216563],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "\[Pi]"]], 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,1",
 CellLabel->"Out[1]=",
 CellID->165489108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->535862854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,7",
 CellLabel->"In[1]:=",
 CellID->71906731],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"Sign", "[", 
     RowBox[{"1", "-", "t"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{156, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,7",
 CellLabel->"Out[1]=",
 CellID->62789003]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26033],

Cell["Elementary functions:", "ExampleText",
 CellID->1337587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"\[Omega]", "^", "2"}]}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,12",
 CellLabel->"In[1]:=",
 CellID->559634976],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]]}], " ", 
  RowBox[{"Abs", "[", "t", "]"}]}]], "Output",
 ImageSize->{89, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,12",
 CellLabel->"Out[1]=",
 CellID->6919310]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Omega]", "^", "2"}]}], "/", "2"}], "]"}], ",", "\[Omega]", 
   ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,13",
 CellLabel->"In[2]:=",
 CellID->86052490],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["t", "2"], "2"]}]]], "Output",
 ImageSize->{30, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,13",
 CellLabel->"Out[2]=",
 CellID->87860160]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTan", "[", "\[Omega]", "]"}], "/", "\[Omega]"}], ",", 
   "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,15",
 CellLabel->"In[3]:=",
 CellID->295748689],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]]}], " ", 
  RowBox[{"ExpIntegralEi", "[", 
   RowBox[{"-", "t"}], "]"}]}]], "Output",
 ImageSize->{167, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,15",
 CellLabel->"Out[3]=",
 CellID->250292989]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Sech", "[", 
    RowBox[{"3", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,16",
 CellLabel->"In[4]:=",
 CellID->39179587],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sech", "[", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "t"}], "6"], "]"}]}]], "Output",
 ImageSize->{118, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,16",
 CellLabel->"Out[4]=",
 CellID->679657834]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->229510772],

Cell["Special functions:", "ExampleText",
 CellID->374012082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"In[1]:=",
 CellID->100635333],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["\[Pi]", "2"]], 
  SqrtBox[
   RowBox[{"1", "+", 
    SuperscriptBox["t", "2"]}]]]], "Output",
 ImageSize->{60, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"Out[1]=",
 CellID->216028186]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"\[Omega]", " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"-", "\[Omega]"}], "]"}]}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034695909109010687,5",
 CellLabel->"In[2]:=",
 CellID->446855038],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["t", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["t", "2"]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["t", "2"]}], "]"}]}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", 
   SuperscriptBox["t", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["t", "2"]}], ")"}]}]]], "Output",
 ImageSize->{168, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034695909109010687,5",
 CellLabel->"Out[2]=",
 CellID->58968513]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"-", 
      RowBox[{"\[Omega]", "^", "2"}]}]}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,17",
 CellLabel->"In[3]:=",
 CellID->419408488],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  SuperscriptBox["t", "2"], " ", 
  RowBox[{"BesselK", "[", 
   RowBox[{"1", ",", "t"}], "]"}]}]], "Output",
 ImageSize->{157, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,17",
 CellLabel->"Out[3]=",
 CellID->452892023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362298078],

Cell["Generalized functions:", "ExampleText",
 CellID->609824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"\[Omega]", "-", "1"}], "]"}], "/", 
    RowBox[{"\[Omega]", "^", "2"}]}], ",", " ", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034599492440594602,3",
 CellLabel->"In[1]:=",
 CellID->489072697],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Pi]"}], " ", "t"}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", "t", "]"}]}], "+", 
   RowBox[{"2", " ", "t", " ", 
    RowBox[{"SinIntegral", "[", "t", "]"}]}]}], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{230, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034599492440594602,3",
 CellLabel->"Out[1]=",
 CellID->616185867]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"\[Omega]", " ", 
    RowBox[{"HeavisideTheta", "[", "\[Omega]", "]"}], " ", 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"1", "-", "\[Omega]"}], "]"}]}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,25",
 CellLabel->"In[2]:=",
 CellID->731592460],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"Cos", "[", "t", "]"}], "+", 
     RowBox[{"t", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}], 
  SuperscriptBox["t", "2"]]], "Output",
 ImageSize->{190, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,25",
 CellLabel->"Out[2]=",
 CellID->203762625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32899182],

Cell["Multivariate transforms:", "ExampleText",
 CellID->268923354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[Omega]1", "^", "2"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[Omega]2", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56844988],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "t1"}], "-", "t2"}]], " ", "\[Pi]"}]], "Output",
 ImageSize->{67, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381936361]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Omega]1", "^", "2"}]}], "-", 
     RowBox[{"\[Omega]2", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57822787],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["t1", "2"], "4"]}], "-", 
    FractionBox[
     SuperscriptBox["t2", "2"], "4"]}]]}]], "Output",
 ImageSize->{73, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4491378]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2699],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->145440021],

Cell["\<\
Use assumptions to indicate the region of interest for the parameters:\
\>", "ExampleText",
 CellID->129286313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"Assumptions", "\[Rule]", " ", 
    RowBox[{"t", ">", " ", "1"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,22",
 CellLabel->"In[1]:=",
 CellID->786369123],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,22",
 CellLabel->"Out[1]=",
 CellID->66007201]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"t", " ", "<", " ", "1"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,23",
 CellLabel->"In[2]:=",
 CellID->320784725],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "\[Pi]"]], 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["t", "2"]}]]]], "Output",
 ImageSize->{60, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,23",
 CellLabel->"Out[2]=",
 CellID->440705483]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FourierParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->577065928],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->327143797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034599492440594602,9",
 CellLabel->"In[1]:=",
 CellID->379941444],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "\[Pi]"]], 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034599492440594602,9",
 CellLabel->"Out[1]=",
 CellID->24902661]
}, Open  ]],

Cell["\<\
Use non-default setting for different definition of transform:\
\>", "ExampleText",
 CellID->21669668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,28",
 CellLabel->"In[2]:=",
 CellID->257823649],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["t", "2"]}], ")"}]}]]], "Output",
 ImageSize->{66, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,28",
 CellLabel->"Out[2]=",
 CellID->284340463]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GenerateConditions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->567142764],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to get parameter conditions for when a result is valid:"
}], "ExampleText",
 CellID->327317843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"a", " ", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"GenerateConditions", " ", "\[Rule]", " ", "True"}]}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,19",
 CellLabel->"In[1]:=",
 CellID->205781283],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], "<", "0"}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"a", " ", 
      SqrtBox[
       FractionBox["2", "\[Pi]"]]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["t", "2"]}]]}], ",", 
   RowBox[{"FourierCosTransform", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", " ", "\[Omega]"}]], ",", "\[Omega]", ",", "t", ",", 
     RowBox[{"GenerateConditions", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{547, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,19",
 CellLabel->"Out[1]=",
 CellID->56692095]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9246],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierCosTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseFourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierCosTransform"]], "InlineFormula"],
 " are mutual inverses:"
}], "ExampleText",
 CellID->899866971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"FourierCosTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", " ", "\[Omega]"}], "]"}], 
   ",", "\[Omega]", ",", " ", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"In[1]:=",
 CellID->87244332],

Cell[BoxData[
 RowBox[{"f", "[", "t", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"Out[1]=",
 CellID->208380898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"InverseFourierCosTransform", "[", 
    RowBox[{
     RowBox[{"g", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", " ", "t"}], 
    "]"}], ",", "t", ",", " ", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22035133735460154583,1",
 CellLabel->"In[2]:=",
 CellID->72689112],

Cell[BoxData[
 RowBox[{"g", "[", "\[Omega]", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22035133735460154583,1",
 CellLabel->"Out[2]=",
 CellID->136242027]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "1"}], ")"}]}], ",", "t", ",", 
   "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[3]:=",
 CellID->517183249],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "\[Omega]"}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{57, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[3]=",
 CellID->22763973]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[4]:=",
 CellID->100959012],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[4]=",
 CellID->59077211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4553799],

Cell[TextData[{
 "For even functions results are identical to ",
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->211365622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"Abs", "[", "\[Omega]", "]"}]}], "]"}], ",", "\[Omega]", ",", 
   "t"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[1]:=",
 CellID->145126959],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "\[Pi]"]], 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[1]=",
 CellID->719875724]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"Abs", "[", "\[Omega]", "]"}]}], "]"}], ",", "\[Omega]", ",", 
   "t"}], " ", "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[2]:=",
 CellID->204658303],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "\[Pi]"]], 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[2]=",
 CellID->23167908]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16272],

Cell[TextData[{
 "Inverse Fourier cosine transforms may require generalized functions such as \
",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->238568336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{"1", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,31",
 CellLabel->"In[1]:=",
 CellID->741524577],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]], " ", 
  RowBox[{"DiracDelta", "[", "t", "]"}]}]], "Output",
 ImageSize->{133, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,31",
 CellLabel->"Out[1]=",
 CellID->920826650]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{"%", ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034695909109010687,1",
 CellLabel->"In[2]:=",
 CellID->350125888],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034695909109010687,1",
 CellLabel->"Out[2]=",
 CellID->395906880]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32429],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourier"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29116]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9665],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->9293]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->324509074],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->18534095]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseFourierCosTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 49.4789256}", "context" -> "System`", 
    "keywords" -> {
     "cosine transform", "Fourier cosine transform", "Fourier transform", 
      "integral transform", "inverse cosine Fourier transform"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseFourierCosTransform[expr, \\[Omega], t] gives the symbolic \
inverse Fourier cosine transform of expr. InverseFourierCosTransform[expr, \
{\\[Omega]_1, \\[Omega]_2, ...}, {t_1, t_2, ...}] gives the multidimensional \
inverse Fourier cosine transform of expr. ", 
    "synonyms" -> {"inverse fourier cos transform"}, "title" -> 
    "InverseFourierCosTransform", "type" -> "Symbol", "uri" -> 
    "ref/InverseFourierCosTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7968, 261, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->269674755]},
 "Ex--22034523510008951413,5"->{
  Cell[8525, 284, 316, 10, 28, "Input",
   CellTags->"Ex--22034523510008951413,5",
   CellID->409380582],
  Cell[8844, 296, 316, 11, 60, "Output",
   CellTags->"Ex--22034523510008951413,5",
   CellID->140757489]},
 "Ex--22034523510008951413,1"->{
  Cell[9324, 317, 264, 8, 28, "Input",
   CellTags->"Ex--22034523510008951413,1",
   CellID->510216563],
  Cell[9591, 327, 305, 11, 77, "Output",
   CellTags->"Ex--22034523510008951413,1",
   CellID->165489108]},
 "Ex--22034523510008951413,7"->{
  Cell[10061, 348, 244, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,7",
   CellID->71906731],
  Cell[10308, 357, 396, 14, 60, "Output",
   CellTags->"Ex--22034523510008951413,7",
   CellID->62789003]},
 "Ex--22034523510008951413,12"->{
  Cell[11059, 391, 263, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,12",
   CellID->559634976],
  Cell[11325, 401, 308, 11, 60, "Output",
   CellTags->"Ex--22034523510008951413,12",
   CellID->6919310]},
 "Ex--22034523510008951413,13"->{
  Cell[11670, 417, 318, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,13",
   CellID->86052490],
  Cell[11991, 429, 302, 10, 46, "Output",
   CellTags->"Ex--22034523510008951413,13",
   CellID->87860160]},
 "Ex--22034523510008951413,15"->{
  Cell[12330, 444, 281, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,15",
   CellID->295748689],
  Cell[12614, 454, 340, 12, 60, "Output",
   CellTags->"Ex--22034523510008951413,15",
   CellID->250292989]},
 "Ex--22034523510008951413,16"->{
  Cell[12991, 471, 265, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,16",
   CellID->39179587],
  Cell[13259, 481, 374, 13, 60, "Output",
   CellTags->"Ex--22034523510008951413,16",
   CellID->679657834]},
 "Ex--22034523510008951413,18"->{
  Cell[13862, 507, 274, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,18",
   CellID->100635333],
  Cell[14139, 517, 320, 12, 72, "Output",
   CellTags->"Ex--22034523510008951413,18",
   CellID->216028186]},
 "Ex--22034695909109010687,5"->{
  Cell[14496, 534, 307, 9, 70, "Input",
   CellTags->"Ex--22034695909109010687,5",
   CellID->446855038],
  Cell[14806, 545, 677, 25, 64, "Output",
   CellTags->"Ex--22034695909109010687,5",
   CellID->58968513]},
 "Ex--22034523510008951413,17"->{
  Cell[15520, 575, 378, 11, 70, "Input",
   CellTags->"Ex--22034523510008951413,17",
   CellID->419408488],
  Cell[15901, 588, 384, 13, 60, "Output",
   CellTags->"Ex--22034523510008951413,17",
   CellID->452892023]},
 "Ex--22034599492440594602,3"->{
  Cell[16515, 614, 343, 10, 70, "Input",
   CellTags->"Ex--22034599492440594602,3",
   CellID->489072697],
  Cell[16861, 626, 471, 16, 55, "Output",
   CellTags->"Ex--22034599492440594602,3",
   CellID->616185867]},
 "Ex--22034523510008951413,25"->{
  Cell[17369, 647, 374, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,25",
   CellID->731592460],
  Cell[17746, 659, 481, 17, 77, "Output",
   CellTags->"Ex--22034523510008951413,25",
   CellID->203762625]},
 "Ex--22034523510008951413,22"->{
  Cell[20800, 785, 356, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,22",
   CellID->786369123],
  Cell[21159, 796, 199, 6, 36, "Output",
   CellTags->"Ex--22034523510008951413,22",
   CellID->66007201]},
 "Ex--22034523510008951413,23"->{
  Cell[21395, 807, 356, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,23",
   CellID->320784725],
  Cell[21754, 818, 320, 12, 87, "Output",
   CellTags->"Ex--22034523510008951413,23",
   CellID->440705483]},
 "Ex--22034599492440594602,9"->{
  Cell[22736, 862, 264, 8, 70, "Input",
   CellTags->"Ex--22034599492440594602,9",
   CellID->379941444],
  Cell[23003, 872, 304, 11, 77, "Output",
   CellTags->"Ex--22034599492440594602,9",
   CellID->24902661]},
 "Ex--22034523510008951413,28"->{
  Cell[23459, 893, 374, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,28",
   CellID->257823649],
  Cell[23836, 905, 323, 11, 57, "Output",
   CellTags->"Ex--22034523510008951413,28",
   CellID->284340463]},
 "Ex--22034523510008951413,19"->{
  Cell[24840, 947, 333, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,19",
   CellID->205781283],
  Cell[25176, 958, 741, 24, 77, "Output",
   CellTags->"Ex--22034523510008951413,19",
   CellID->56692095]},
 "Ex--22034138112425334325,15"->{
  Cell[26623, 1014, 337, 9, 70, "Input",
   CellTags->"Ex--22034138112425334325,15",
   CellID->87244332],
  Cell[26963, 1025, 227, 7, 36, "Output",
   CellTags->"Ex--22034138112425334325,15",
   CellID->208380898]},
 "Ex--22035133735460154583,1"->{
  Cell[27227, 1037, 344, 9, 70, "Input",
   CellTags->"Ex--22035133735460154583,1",
   CellID->72689112],
  Cell[27574, 1048, 233, 7, 36, "Output",
   CellTags->"Ex--22035133735460154583,1",
   CellID->136242027]},
 "Ex--22034558506017011754,4"->{
  Cell[27844, 1060, 302, 10, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->517183249],
  Cell[28149, 1072, 322, 11, 60, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->22763973],
  Cell[29403, 1124, 298, 9, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->145126959],
  Cell[29704, 1135, 305, 11, 77, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->719875724]},
 "Ex--22034558506017011754,5"->{
  Cell[28508, 1088, 203, 5, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->100959012],
  Cell[28714, 1095, 266, 9, 52, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->59077211],
  Cell[30046, 1151, 300, 9, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->204658303],
  Cell[30349, 1162, 304, 11, 77, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->23167908]},
 "Ex--22034523510008951413,31"->{
  Cell[31221, 1201, 204, 5, 70, "Input",
   CellTags->"Ex--22034523510008951413,31",
   CellID->741524577],
  Cell[31428, 1208, 300, 10, 38, "Output",
   CellTags->"Ex--22034523510008951413,31",
   CellID->920826650]},
 "Ex--22034695909109010687,1"->{
  Cell[31765, 1223, 196, 5, 70, "Input",
   CellTags->"Ex--22034695909109010687,1",
   CellID->350125888],
  Cell[31964, 1230, 199, 6, 36, "Output",
   CellTags->"Ex--22034695909109010687,1",
   CellID->395906880]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36098, 1365},
 {"Ex--22034523510008951413,5", 36251, 1369},
 {"Ex--22034523510008951413,1", 36498, 1376},
 {"Ex--22034523510008951413,7", 36744, 1383},
 {"Ex--22034523510008951413,12", 36991, 1390},
 {"Ex--22034523510008951413,13", 37240, 1397},
 {"Ex--22034523510008951413,15", 37490, 1404},
 {"Ex--22034523510008951413,16", 37741, 1411},
 {"Ex--22034523510008951413,18", 37991, 1418},
 {"Ex--22034695909109010687,5", 38241, 1425},
 {"Ex--22034523510008951413,17", 38489, 1432},
 {"Ex--22034599492440594602,3", 38740, 1439},
 {"Ex--22034523510008951413,25", 38990, 1446},
 {"Ex--22034523510008951413,22", 39242, 1453},
 {"Ex--22034523510008951413,23", 39491, 1460},
 {"Ex--22034599492440594602,9", 39741, 1467},
 {"Ex--22034523510008951413,28", 39989, 1474},
 {"Ex--22034523510008951413,19", 40241, 1481},
 {"Ex--22034138112425334325,15", 40491, 1488},
 {"Ex--22035133735460154583,1", 40741, 1495},
 {"Ex--22034558506017011754,4", 40989, 1502},
 {"Ex--22034558506017011754,5", 41455, 1515},
 {"Ex--22034523510008951413,31", 41919, 1528},
 {"Ex--22034695909109010687,1", 42171, 1535}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2292, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2915, 82, 63, 1, 70, "ObjectName",
 CellID->1482],
Cell[2981, 85, 1763, 54, 70, "Usage",
 CellID->11495]
}, Open  ]],
Cell[CellGroupData[{
Cell[4781, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5259, 161, 635, 21, 70, "Notes",
 CellID->23967],
Cell[5897, 184, 109, 3, 70, "Notes",
 CellID->17148],
Cell[6009, 189, 259, 8, 70, "Notes",
 CellID->12105],
Cell[6271, 199, 1152, 38, 70, "Notes",
 CellID->19556],
Cell[7426, 239, 505, 17, 70, "Notes",
 CellID->27000]
}, Closed]],
Cell[CellGroupData[{
Cell[7968, 261, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->269674755],
Cell[CellGroupData[{
Cell[8353, 275, 147, 5, 70, "ExampleSection",
 CellID->38636045],
Cell[CellGroupData[{
Cell[8525, 284, 316, 10, 28, "Input",
 CellTags->"Ex--22034523510008951413,5",
 CellID->409380582],
Cell[8844, 296, 316, 11, 60, "Output",
 CellTags->"Ex--22034523510008951413,5",
 CellID->140757489]
}, Open  ]],
Cell[9175, 310, 124, 3, 70, "ExampleDelimiter",
 CellID->59341575],
Cell[CellGroupData[{
Cell[9324, 317, 264, 8, 28, "Input",
 CellTags->"Ex--22034523510008951413,1",
 CellID->510216563],
Cell[9591, 327, 305, 11, 77, "Output",
 CellTags->"Ex--22034523510008951413,1",
 CellID->165489108]
}, Open  ]],
Cell[9911, 341, 125, 3, 70, "ExampleDelimiter",
 CellID->535862854],
Cell[CellGroupData[{
Cell[10061, 348, 244, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,7",
 CellID->71906731],
Cell[10308, 357, 396, 14, 60, "Output",
 CellTags->"Ex--22034523510008951413,7",
 CellID->62789003]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10753, 377, 216, 7, 70, "ExampleSection",
 CellID->26033],
Cell[10972, 386, 62, 1, 70, "ExampleText",
 CellID->1337587],
Cell[CellGroupData[{
Cell[11059, 391, 263, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,12",
 CellID->559634976],
Cell[11325, 401, 308, 11, 60, "Output",
 CellTags->"Ex--22034523510008951413,12",
 CellID->6919310]
}, Open  ]],
Cell[CellGroupData[{
Cell[11670, 417, 318, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,13",
 CellID->86052490],
Cell[11991, 429, 302, 10, 46, "Output",
 CellTags->"Ex--22034523510008951413,13",
 CellID->87860160]
}, Open  ]],
Cell[CellGroupData[{
Cell[12330, 444, 281, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,15",
 CellID->295748689],
Cell[12614, 454, 340, 12, 60, "Output",
 CellTags->"Ex--22034523510008951413,15",
 CellID->250292989]
}, Open  ]],
Cell[CellGroupData[{
Cell[12991, 471, 265, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,16",
 CellID->39179587],
Cell[13259, 481, 374, 13, 60, "Output",
 CellTags->"Ex--22034523510008951413,16",
 CellID->679657834]
}, Open  ]],
Cell[13648, 497, 125, 3, 70, "ExampleDelimiter",
 CellID->229510772],
Cell[13776, 502, 61, 1, 70, "ExampleText",
 CellID->374012082],
Cell[CellGroupData[{
Cell[13862, 507, 274, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellID->100635333],
Cell[14139, 517, 320, 12, 72, "Output",
 CellTags->"Ex--22034523510008951413,18",
 CellID->216028186]
}, Open  ]],
Cell[CellGroupData[{
Cell[14496, 534, 307, 9, 70, "Input",
 CellTags->"Ex--22034695909109010687,5",
 CellID->446855038],
Cell[14806, 545, 677, 25, 64, "Output",
 CellTags->"Ex--22034695909109010687,5",
 CellID->58968513]
}, Open  ]],
Cell[CellGroupData[{
Cell[15520, 575, 378, 11, 70, "Input",
 CellTags->"Ex--22034523510008951413,17",
 CellID->419408488],
Cell[15901, 588, 384, 13, 60, "Output",
 CellTags->"Ex--22034523510008951413,17",
 CellID->452892023]
}, Open  ]],
Cell[16300, 604, 125, 3, 70, "ExampleDelimiter",
 CellID->362298078],
Cell[16428, 609, 62, 1, 70, "ExampleText",
 CellID->609824],
Cell[CellGroupData[{
Cell[16515, 614, 343, 10, 70, "Input",
 CellTags->"Ex--22034599492440594602,3",
 CellID->489072697],
Cell[16861, 626, 471, 16, 55, "Output",
 CellTags->"Ex--22034599492440594602,3",
 CellID->616185867]
}, Open  ]],
Cell[CellGroupData[{
Cell[17369, 647, 374, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,25",
 CellID->731592460],
Cell[17746, 659, 481, 17, 77, "Output",
 CellTags->"Ex--22034523510008951413,25",
 CellID->203762625]
}, Open  ]],
Cell[18242, 679, 124, 3, 70, "ExampleDelimiter",
 CellID->32899182],
Cell[18369, 684, 67, 1, 70, "ExampleText",
 CellID->268923354],
Cell[CellGroupData[{
Cell[18461, 689, 524, 17, 70, "Input",
 CellID->56844988],
Cell[18988, 708, 299, 10, 51, "Output",
 CellID->381936361]
}, Open  ]],
Cell[CellGroupData[{
Cell[19324, 723, 416, 13, 70, "Input",
 CellID->57822787],
Cell[19743, 738, 385, 14, 55, "Output",
 CellID->4491378]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20177, 758, 217, 7, 70, "ExampleSection",
 CellID->2699],
Cell[CellGroupData[{
Cell[20419, 769, 232, 7, 70, "ExampleSubsection",
 CellID->145440021],
Cell[20654, 778, 121, 3, 70, "ExampleText",
 CellID->129286313],
Cell[CellGroupData[{
Cell[20800, 785, 356, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,22",
 CellID->786369123],
Cell[21159, 796, 199, 6, 36, "Output",
 CellTags->"Ex--22034523510008951413,22",
 CellID->66007201]
}, Open  ]],
Cell[CellGroupData[{
Cell[21395, 807, 356, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,23",
 CellID->320784725],
Cell[21754, 818, 320, 12, 87, "Output",
 CellTags->"Ex--22034523510008951413,23",
 CellID->440705483]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22123, 836, 238, 7, 70, "ExampleSubsection",
 CellID->577065928],
Cell[22364, 845, 347, 13, 70, "ExampleText",
 CellID->327143797],
Cell[CellGroupData[{
Cell[22736, 862, 264, 8, 70, "Input",
 CellTags->"Ex--22034599492440594602,9",
 CellID->379941444],
Cell[23003, 872, 304, 11, 77, "Output",
 CellTags->"Ex--22034599492440594602,9",
 CellID->24902661]
}, Open  ]],
Cell[23322, 886, 112, 3, 70, "ExampleText",
 CellID->21669668],
Cell[CellGroupData[{
Cell[23459, 893, 374, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,28",
 CellID->257823649],
Cell[23836, 905, 323, 11, 57, "Output",
 CellTags->"Ex--22034523510008951413,28",
 CellID->284340463]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24208, 922, 239, 7, 70, "ExampleSubsection",
 CellID->567142764],
Cell[24450, 931, 365, 12, 70, "ExampleText",
 CellID->327317843],
Cell[CellGroupData[{
Cell[24840, 947, 333, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,19",
 CellID->205781283],
Cell[25176, 958, 741, 24, 77, "Output",
 CellTags->"Ex--22034523510008951413,19",
 CellID->56692095]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[25978, 989, 232, 7, 70, "ExampleSection",
 CellID->9246],
Cell[26213, 998, 385, 12, 70, "ExampleText",
 CellID->899866971],
Cell[CellGroupData[{
Cell[26623, 1014, 337, 9, 70, "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellID->87244332],
Cell[26963, 1025, 227, 7, 36, "Output",
 CellTags->"Ex--22034138112425334325,15",
 CellID->208380898]
}, Open  ]],
Cell[CellGroupData[{
Cell[27227, 1037, 344, 9, 70, "Input",
 CellTags->"Ex--22035133735460154583,1",
 CellID->72689112],
Cell[27574, 1048, 233, 7, 36, "Output",
 CellTags->"Ex--22035133735460154583,1",
 CellID->136242027]
}, Open  ]],
Cell[CellGroupData[{
Cell[27844, 1060, 302, 10, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->517183249],
Cell[28149, 1072, 322, 11, 60, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->22763973]
}, Open  ]],
Cell[CellGroupData[{
Cell[28508, 1088, 203, 5, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->100959012],
Cell[28714, 1095, 266, 9, 52, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->59077211]
}, Open  ]],
Cell[28995, 1107, 123, 3, 70, "ExampleDelimiter",
 CellID->4553799],
Cell[29121, 1112, 257, 8, 70, "ExampleText",
 CellID->211365622],
Cell[CellGroupData[{
Cell[29403, 1124, 298, 9, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->145126959],
Cell[29704, 1135, 305, 11, 77, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->719875724]
}, Open  ]],
Cell[CellGroupData[{
Cell[30046, 1151, 300, 9, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->204658303],
Cell[30349, 1162, 304, 11, 77, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->23167908]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30702, 1179, 226, 7, 70, "ExampleSection",
 CellID->16272],
Cell[30931, 1188, 265, 9, 70, "ExampleText",
 CellID->238568336],
Cell[CellGroupData[{
Cell[31221, 1201, 204, 5, 70, "Input",
 CellTags->"Ex--22034523510008951413,31",
 CellID->741524577],
Cell[31428, 1208, 300, 10, 38, "Output",
 CellTags->"Ex--22034523510008951413,31",
 CellID->920826650]
}, Open  ]],
Cell[CellGroupData[{
Cell[31765, 1223, 196, 5, 70, "Input",
 CellTags->"Ex--22034695909109010687,1",
 CellID->350125888],
Cell[31964, 1230, 199, 6, 36, "Output",
 CellTags->"Ex--22034695909109010687,1",
 CellID->395906880]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32224, 1243, 311, 9, 70, "SeeAlsoSection",
 CellID->32429],
Cell[32538, 1254, 1041, 35, 70, "SeeAlso",
 CellID->29116]
}, Open  ]],
Cell[CellGroupData[{
Cell[33616, 1294, 313, 9, 70, "TutorialsSection",
 CellID->9665],
Cell[33932, 1305, 193, 4, 70, "Tutorials",
 CellID->9293]
}, Open  ]],
Cell[CellGroupData[{
Cell[34162, 1314, 319, 9, 70, "MoreAboutSection",
 CellID->324509074],
Cell[34484, 1325, 148, 3, 70, "MoreAbout",
 CellID->18534095]
}, Open  ]],
Cell[34647, 1331, 27, 0, 70, "History"],
Cell[34677, 1333, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

