(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54121,       1942]
NotebookOptionsPosition[     35375,       1365]
NotebookOutlinePosition[     44525,       1611]
CellTagsIndexPosition[     43321,       1582]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseFourierCosTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierCosTransform"], 
          "FourierSinTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierSinTransform"], 
          "InverseFourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierTransform"], 
          "InverseFourier" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourier"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseFourierCosTransform\"\>", 
       2->"\<\"FourierSinTransform\"\>", 3->"\<\"InverseFourierTransform\"\>",
        4->"\<\"InverseFourier\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseFourierSinTransform", "ObjectName",
 CellID->18752],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseFourierSinTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFourierSinTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["\[Omega]", "TR"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the symbolic inverse Fourier sine transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseFourierSinTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFourierSinTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multidimensional inverse Fourier sine \
transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11435]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The inverse Fourier sine transform of a function",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "\[Omega]", ")"}], TraditionalForm]], "InlineMath"],
 " i",
 "s by default defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
      RowBox[{"sin", "(", 
       RowBox[{"\[Omega]", "\[InvisibleSpace]", "t"}], ")"}], "d", 
      "\[InvisibleSpace]", "\[Omega]"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->4100],

Cell["\<\
Other definitions are used in some scientific and technical fields. \
\>", "Notes",
 CellID->26208],

Cell[TextData[{
 "Different choices of definitions can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9865],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " the inverse Fourier transform computed by ",
 Cell[BoxData[
  ButtonBox["InverseFourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierSinTransform"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    SqrtBox[
     FractionBox[
      RowBox[{"\[VerticalSeparator]", "b", "\[VerticalSeparator]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], 
       RowBox[{"1", "+", "a"}]]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
      RowBox[{"sin", "(", 
       RowBox[{
       "b", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]", "t"}], 
       ")"}], "d", "\[InvisibleSpace]", "\[Omega]"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->3847],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " and other options to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can also be given in ",
 Cell[BoxData[
  ButtonBox["InverseFourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierSinTransform"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17041]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->933045461],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->41657092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"\[Omega]", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Omega]", "^", "2"}], "+", "1"}], ")"}]}], ",", " ", 
   "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,5",
 CellLabel->"In[1]:=",
 CellID->409380582],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "t"}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{57, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,5",
 CellLabel->"Out[1]=",
 CellID->102093026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59341575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,1",
 CellLabel->"In[1]:=",
 CellID->510216563],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "t"}], 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{49, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,1",
 CellLabel->"Out[1]=",
 CellID->251761870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->535862854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Log", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,7",
 CellLabel->"In[1]:=",
 CellID->71906731],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"(", 
     RowBox[{"EulerGamma", "+", 
      RowBox[{"Log", "[", "t", "]"}]}], ")"}]}], "t"]}]], "Output",
 ImageSize->{188, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,7",
 CellLabel->"Out[1]=",
 CellID->331947628]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9691],

Cell["Elementary functions:", "ExampleText",
 CellID->1337587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", "\[Omega]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,12",
 CellLabel->"In[1]:=",
 CellID->559634976],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sign", "[", "t", "]"}]}]], "Output",
 ImageSize->{88, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,12",
 CellLabel->"Out[1]=",
 CellID->33708635]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"\[Omega]", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"\[Omega]", "^", "2"}]}], "]"}]}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,13",
 CellLabel->"In[2]:=",
 CellID->86052490],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["t", "2"], "4"]}]], " ", "t"}], 
  RowBox[{"2", " ", 
   SqrtBox["2"]}]]], "Output",
 ImageSize->{45, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,13",
 CellLabel->"Out[2]=",
 CellID->152443410]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", "\[Omega]"}], "]"}], 
    RowBox[{"Cos", "[", "\[Omega]", "]"}]}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,14",
 CellLabel->"In[3]:=",
 CellID->93576955],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   SuperscriptBox["t", "3"]}], 
  RowBox[{"4", "+", 
   SuperscriptBox["t", "4"]}]]], "Output",
 ImageSize->{54, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,14",
 CellLabel->"Out[3]=",
 CellID->719233270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,15",
 CellLabel->"In[4]:=",
 CellID->295748689],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "t"}]], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]]}], "t"]], "Output",
 ImageSize->{58, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,15",
 CellLabel->"Out[4]=",
 CellID->141290310]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Csch", "[", 
    RowBox[{"2", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,16",
 CellLabel->"In[5]:=",
 CellID->39179587],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Tanh", "[", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "t"}], "4"], "]"}]}]], "Output",
 ImageSize->{118, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,16",
 CellLabel->"Out[5]=",
 CellID->569923844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23578002],

Cell["Special functions:", "ExampleText",
 CellID->266275944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"In[1]:=",
 CellID->193365295],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"ArcSinh", "[", "t", "]"}]}], 
  SqrtBox[
   RowBox[{"1", "+", 
    SuperscriptBox["t", "2"]}]]]], "Output",
 ImageSize->{112, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"Out[1]=",
 CellID->6350988]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", 
    RowBox[{"-", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034695909109010687,5",
 CellLabel->"In[2]:=",
 CellID->117726131],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["t", "2"]}], "]"}], 
   RowBox[{
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], " ", "t"}]]}]], "Output",
 ImageSize->{83, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034695909109010687,5",
 CellLabel->"Out[2]=",
 CellID->502880720]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Erf", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,17",
 CellLabel->"In[3]:=",
 CellID->446451859],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["t", "2"], "4"]}]], " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]]}], "t"]], "Output",
 ImageSize->{68, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,17",
 CellLabel->"Out[3]=",
 CellID->88421141]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304986378],

Cell["Generalized functions:", "ExampleText",
 CellID->246224435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"\[Omega]", "-", "1"}], "]"}], "/", "\[Omega]"}], ",", 
   "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034599492440594602,3",
 CellLabel->"In[1]:=",
 CellID->650689971],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", "-", 
   RowBox[{"2", " ", 
    RowBox[{"SinIntegral", "[", "t", "]"}]}]}], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{137, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034599492440594602,3",
 CellLabel->"Out[1]=",
 CellID->26800036]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"\[Omega]", " ", 
    RowBox[{"HeavisideTheta", "[", "\[Omega]", "]"}], 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"1", "-", "\[Omega]"}], "]"}]}], ",", " ", "\[Omega]", ",", 
   "t"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,25",
 CellLabel->"In[2]:=",
 CellID->807756863],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "t"}], " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], "+", 
     RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], 
  SuperscriptBox["t", "2"]]], "Output",
 ImageSize->{170, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,25",
 CellLabel->"Out[2]=",
 CellID->198897238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32899182],

Cell["Multivariate transforms:", "ExampleText",
 CellID->268923354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"\[Omega]1", " ", 
    RowBox[{"\[Omega]2", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[Omega]1", "^", "2"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[Omega]2", "^", "2"}]}], ")"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56844988],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "t1"}], "-", "t2"}]], " ", "\[Pi]"}]], "Output",
 ImageSize->{67, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45674680]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Omega]1", "^", "2"}]}], "-", 
     RowBox[{"\[Omega]2", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57822787],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["t1", "2"], "4"]}], "-", 
    FractionBox[
     SuperscriptBox["t2", "2"], "4"]}]], " ", 
  RowBox[{"Erfi", "[", 
   FractionBox["t1", "2"], "]"}], " ", 
  RowBox[{"Erfi", "[", 
   FractionBox["t2", "2"], "]"}]}]], "Output",
 ImageSize->{199, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->553334488]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17496],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->145440021],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " to indicate the region of interest for the parameters:"
}], "ExampleText",
 CellID->129286313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"t", ">", "1"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,22",
 CellLabel->"In[1]:=",
 CellID->786369123],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "\[Pi]"]], 
  SqrtBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["t", "2"]}]]]], "Output",
 ImageSize->{67, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,22",
 CellLabel->"Out[1]=",
 CellID->232276128]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"t", "<", "1"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,23",
 CellLabel->"In[2]:=",
 CellID->320784725],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,23",
 CellLabel->"Out[2]=",
 CellID->546134193]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FourierParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->577065928],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->327143797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034599492440594602,9",
 CellLabel->"In[1]:=",
 CellID->379941444],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "t"}], 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{49, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034599492440594602,9",
 CellLabel->"Out[1]=",
 CellID->131796329]
}, Open  ]],

Cell["\<\
Use a non-default setting for a different definition of the transform:\
\>", "ExampleText",
 CellID->21669668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,28",
 CellLabel->"In[2]:=",
 CellID->257823649],

Cell[BoxData[
 FractionBox["t", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["t", "2"]}], ")"}]}]]], "Output",
 ImageSize->{66, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,28",
 CellLabel->"Out[2]=",
 CellID->203890978]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GenerateConditions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->567142764],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to get parameter conditions for when a result is valid:"
}], "ExampleText",
 CellID->327317843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"a", " ", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"GenerateConditions", " ", "\[Rule]", " ", "True"}]}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,19",
 CellLabel->"In[1]:=",
 CellID->205781283],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], "<", "0"}], ",", 
   FractionBox[
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", "t"}], 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["t", "2"]}]], ",", 
   RowBox[{"FourierSinTransform", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", " ", "\[Omega]"}]], ",", "\[Omega]", ",", "t", ",", 
     RowBox[{"GenerateConditions", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{539, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,19",
 CellLabel->"Out[1]=",
 CellID->42314087]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9246],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierSinTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseFourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierSinTransform"]], "InlineFormula"],
 " are mutual inverses:"
}], "ExampleText",
 CellID->899866971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"FourierSinTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", " ", "\[Omega]"}], "]"}], 
   ",", "\[Omega]", ",", " ", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"In[1]:=",
 CellID->87244332],

Cell[BoxData[
 RowBox[{"f", "[", "t", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"Out[1]=",
 CellID->70000885]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"InverseFourierSinTransform", "[", 
    RowBox[{
     RowBox[{"g", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", "t"}], "]"}], 
   ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22035133735460154583,1",
 CellLabel->"In[2]:=",
 CellID->72689112],

Cell[BoxData[
 RowBox[{"g", "[", "\[Omega]", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22035133735460154583,1",
 CellLabel->"Out[2]=",
 CellID->254280906]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "1"}], ")"}]}], ",", "t", ",", 
   "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[3]:=",
 CellID->517183249],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "\[Omega]"}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{57, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[3]=",
 CellID->62094201]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[4]:=",
 CellID->100959012],

Cell[BoxData[
 FractionBox["t", 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[4]=",
 CellID->144917024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4553799],

Cell[TextData[{
 "For odd functions results are identical to ",
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 " except for a factor ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->211365622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", "\[Omega]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[1]:=",
 CellID->145126959],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sign", "[", "t", "]"}]}]], "Output",
 ImageSize->{88, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[1]=",
 CellID->272142374]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", "\[Omega]"}], ",", "\[Omega]", ",", "t"}], " ", 
  "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[2]:=",
 CellID->204658303],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sign", "[", "t", "]"}]}]], "Output",
 ImageSize->{107, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[2]=",
 CellID->79957765]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2784],

Cell[TextData[{
 "Inverse Fourier sine transforms may require generalized functions such as \
",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->238568336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{"\[Omega]", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,31",
 CellLabel->"In[1]:=",
 CellID->741524577],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]]}], " ", 
  RowBox[{
   SuperscriptBox["DiracDelta", "\[Prime]",
    MultilineFunction->None], "[", "t", "]"}]}]], "Output",
 ImageSize->{145, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,31",
 CellLabel->"Out[1]=",
 CellID->472792173]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{"%", ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034695909109010687,1",
 CellLabel->"In[2]:=",
 CellID->350125888],

Cell[BoxData["\[Omega]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034695909109010687,1",
 CellLabel->"Out[2]=",
 CellID->49056107]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21357],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourier"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19191]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26901],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->22927]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->263757729],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->96975518]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseFourierSinTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 51.1039672}", "context" -> "System`", 
    "keywords" -> {
     "Fourier sine transform", "Fourier transform", "integral transform", 
      "inverse sine Fourier transform", "sine transform"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseFourierSinTransform[expr, \\[Omega], t] gives the symbolic \
inverse Fourier sine transform of expr. InverseFourierSinTransform[expr, \
{\\[Omega]_1, \\[Omega]_2, ...}, {t_1, t_2, ...}] gives the multidimensional \
inverse Fourier sine transform of expr. ", 
    "synonyms" -> {"inverse fourier sin transform"}, "title" -> 
    "InverseFourierSinTransform", "type" -> "Symbol", "uri" -> 
    "ref/InverseFourierSinTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7968, 262, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->933045461]},
 "Ex--22034523510008951413,5"->{
  Cell[8525, 285, 328, 10, 28, "Input",
   CellTags->"Ex--22034523510008951413,5",
   CellID->409380582],
  Cell[8856, 297, 316, 11, 60, "Output",
   CellTags->"Ex--22034523510008951413,5",
   CellID->102093026]},
 "Ex--22034523510008951413,1"->{
  Cell[9336, 318, 264, 8, 28, "Input",
   CellTags->"Ex--22034523510008951413,1",
   CellID->510216563],
  Cell[9603, 328, 330, 12, 77, "Output",
   CellTags->"Ex--22034523510008951413,1",
   CellID->251761870]},
 "Ex--22034523510008951413,7"->{
  Cell[10098, 350, 243, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,7",
   CellID->71906731],
  Cell[10344, 359, 398, 14, 76, "Output",
   CellTags->"Ex--22034523510008951413,7",
   CellID->331947628]},
 "Ex--22034523510008951413,12"->{
  Cell[11096, 393, 238, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,12",
   CellID->559634976],
  Cell[11337, 402, 290, 10, 60, "Output",
   CellTags->"Ex--22034523510008951413,12",
   CellID->33708635]},
 "Ex--22034523510008951413,13"->{
  Cell[11664, 417, 324, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,13",
   CellID->86052490],
  Cell[11991, 429, 390, 14, 68, "Output",
   CellTags->"Ex--22034523510008951413,13",
   CellID->152443410]},
 "Ex--22034523510008951413,14"->{
  Cell[12418, 448, 324, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,14",
   CellID->93576955],
  Cell[12745, 460, 356, 13, 77, "Output",
   CellTags->"Ex--22034523510008951413,14",
   CellID->719233270]},
 "Ex--22034523510008951413,15"->{
  Cell[13138, 478, 248, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,15",
   CellID->295748689],
  Cell[13389, 487, 342, 12, 61, "Output",
   CellTags->"Ex--22034523510008951413,15",
   CellID->141290310]},
 "Ex--22034523510008951413,16"->{
  Cell[13768, 504, 265, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,16",
   CellID->39179587],
  Cell[14036, 514, 374, 13, 60, "Output",
   CellTags->"Ex--22034523510008951413,16",
   CellID->569923844]},
 "Ex--22034523510008951413,18"->{
  Cell[14638, 540, 274, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,18",
   CellID->193365295],
  Cell[14915, 550, 379, 14, 87, "Output",
   CellTags->"Ex--22034523510008951413,18",
   CellID->6350988]},
 "Ex--22034695909109010687,5"->{
  Cell[15331, 569, 274, 8, 70, "Input",
   CellTags->"Ex--22034695909109010687,5",
   CellID->117726131],
  Cell[15608, 579, 388, 14, 60, "Output",
   CellTags->"Ex--22034695909109010687,5",
   CellID->502880720]},
 "Ex--22034523510008951413,17"->{
  Cell[16033, 598, 245, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,17",
   CellID->446451859],
  Cell[16281, 607, 393, 14, 76, "Output",
   CellTags->"Ex--22034523510008951413,17",
   CellID->88421141]},
 "Ex--22034599492440594602,3"->{
  Cell[16907, 634, 314, 9, 70, "Input",
   CellTags->"Ex--22034599492440594602,3",
   CellID->650689971],
  Cell[17224, 645, 350, 12, 55, "Output",
   CellTags->"Ex--22034599492440594602,3",
   CellID->26800036]},
 "Ex--22034523510008951413,25"->{
  Cell[17611, 662, 375, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,25",
   CellID->807756863],
  Cell[17989, 674, 472, 17, 77, "Output",
   CellTags->"Ex--22034523510008951413,25",
   CellID->198897238]},
 "Ex--22034523510008951413,22"->{
  Cell[21340, 810, 346, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,22",
   CellID->786369123],
  Cell[21689, 821, 340, 13, 87, "Output",
   CellTags->"Ex--22034523510008951413,22",
   CellID->232276128]},
 "Ex--22034523510008951413,23"->{
  Cell[22066, 839, 346, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,23",
   CellID->320784725],
  Cell[22415, 850, 200, 6, 36, "Output",
   CellTags->"Ex--22034523510008951413,23",
   CellID->546134193]},
 "Ex--22034599492440594602,9"->{
  Cell[23277, 888, 264, 8, 70, "Input",
   CellTags->"Ex--22034599492440594602,9",
   CellID->379941444],
  Cell[23544, 898, 330, 12, 77, "Output",
   CellTags->"Ex--22034599492440594602,9",
   CellID->131796329]},
 "Ex--22034523510008951413,28"->{
  Cell[24034, 920, 374, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,28",
   CellID->257823649],
  Cell[24411, 932, 323, 11, 56, "Output",
   CellTags->"Ex--22034523510008951413,28",
   CellID->203890978]},
 "Ex--22034523510008951413,19"->{
  Cell[25415, 974, 333, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,19",
   CellID->205781283],
  Cell[25751, 985, 715, 23, 77, "Output",
   CellTags->"Ex--22034523510008951413,19",
   CellID->42314087]},
 "Ex--22034138112425334325,15"->{
  Cell[27172, 1040, 337, 9, 70, "Input",
   CellTags->"Ex--22034138112425334325,15",
   CellID->87244332],
  Cell[27512, 1051, 226, 7, 36, "Output",
   CellTags->"Ex--22034138112425334325,15",
   CellID->70000885]},
 "Ex--22035133735460154583,1"->{
  Cell[27775, 1063, 333, 9, 70, "Input",
   CellTags->"Ex--22035133735460154583,1",
   CellID->72689112],
  Cell[28111, 1074, 233, 7, 36, "Output",
   CellTags->"Ex--22035133735460154583,1",
   CellID->254280906]},
 "Ex--22034558506017011754,4"->{
  Cell[28381, 1086, 302, 10, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->517183249],
  Cell[28686, 1098, 322, 11, 60, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->62094201],
  Cell[30092, 1156, 237, 7, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->145126959],
  Cell[30332, 1165, 290, 10, 60, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->272142374]},
 "Ex--22034558506017011754,5"->{
  Cell[29045, 1114, 203, 5, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->100959012],
  Cell[29251, 1121, 267, 9, 51, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->144917024],
  Cell[30659, 1180, 239, 7, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->204658303],
  Cell[30901, 1189, 330, 11, 60, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->79957765]},
 "Ex--22034523510008951413,31"->{
  Cell[31796, 1228, 211, 5, 70, "Input",
   CellTags->"Ex--22034523510008951413,31",
   CellID->741524577],
  Cell[32010, 1235, 381, 13, 38, "Output",
   CellTags->"Ex--22034523510008951413,31",
   CellID->472792173]},
 "Ex--22034695909109010687,1"->{
  Cell[32428, 1253, 196, 5, 70, "Input",
   CellTags->"Ex--22034695909109010687,1",
   CellID->350125888],
  Cell[32627, 1260, 205, 6, 36, "Output",
   CellTags->"Ex--22034695909109010687,1",
   CellID->49056107]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36759, 1395},
 {"Ex--22034523510008951413,5", 36912, 1399},
 {"Ex--22034523510008951413,1", 37159, 1406},
 {"Ex--22034523510008951413,7", 37405, 1413},
 {"Ex--22034523510008951413,12", 37653, 1420},
 {"Ex--22034523510008951413,13", 37903, 1427},
 {"Ex--22034523510008951413,14", 38154, 1434},
 {"Ex--22034523510008951413,15", 38405, 1441},
 {"Ex--22034523510008951413,16", 38656, 1448},
 {"Ex--22034523510008951413,18", 38906, 1455},
 {"Ex--22034695909109010687,5", 39154, 1462},
 {"Ex--22034523510008951413,17", 39403, 1469},
 {"Ex--22034599492440594602,3", 39652, 1476},
 {"Ex--22034523510008951413,25", 39900, 1483},
 {"Ex--22034523510008951413,22", 40152, 1490},
 {"Ex--22034523510008951413,23", 40403, 1497},
 {"Ex--22034599492440594602,9", 40652, 1504},
 {"Ex--22034523510008951413,28", 40901, 1511},
 {"Ex--22034523510008951413,19", 41153, 1518},
 {"Ex--22034138112425334325,15", 41403, 1525},
 {"Ex--22035133735460154583,1", 41652, 1532},
 {"Ex--22034558506017011754,4", 41900, 1539},
 {"Ex--22034558506017011754,5", 42366, 1552},
 {"Ex--22034523510008951413,31", 42831, 1565},
 {"Ex--22034695909109010687,1", 43083, 1572}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2292, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2915, 82, 64, 1, 70, "ObjectName",
 CellID->18752],
Cell[2982, 85, 1757, 53, 70, "Usage",
 CellID->11435]
}, Open  ]],
Cell[CellGroupData[{
Cell[4776, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5254, 160, 642, 23, 70, "Notes",
 CellID->4100],
Cell[5899, 185, 109, 3, 70, "Notes",
 CellID->26208],
Cell[6011, 190, 258, 8, 70, "Notes",
 CellID->9865],
Cell[6272, 200, 1151, 38, 70, "Notes",
 CellID->3847],
Cell[7426, 240, 505, 17, 70, "Notes",
 CellID->17041]
}, Closed]],
Cell[CellGroupData[{
Cell[7968, 262, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->933045461],
Cell[CellGroupData[{
Cell[8353, 276, 147, 5, 70, "ExampleSection",
 CellID->41657092],
Cell[CellGroupData[{
Cell[8525, 285, 328, 10, 28, "Input",
 CellTags->"Ex--22034523510008951413,5",
 CellID->409380582],
Cell[8856, 297, 316, 11, 60, "Output",
 CellTags->"Ex--22034523510008951413,5",
 CellID->102093026]
}, Open  ]],
Cell[9187, 311, 124, 3, 70, "ExampleDelimiter",
 CellID->59341575],
Cell[CellGroupData[{
Cell[9336, 318, 264, 8, 28, "Input",
 CellTags->"Ex--22034523510008951413,1",
 CellID->510216563],
Cell[9603, 328, 330, 12, 77, "Output",
 CellTags->"Ex--22034523510008951413,1",
 CellID->251761870]
}, Open  ]],
Cell[9948, 343, 125, 3, 70, "ExampleDelimiter",
 CellID->535862854],
Cell[CellGroupData[{
Cell[10098, 350, 243, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,7",
 CellID->71906731],
Cell[10344, 359, 398, 14, 76, "Output",
 CellTags->"Ex--22034523510008951413,7",
 CellID->331947628]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10791, 379, 215, 7, 70, "ExampleSection",
 CellID->9691],
Cell[11009, 388, 62, 1, 70, "ExampleText",
 CellID->1337587],
Cell[CellGroupData[{
Cell[11096, 393, 238, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,12",
 CellID->559634976],
Cell[11337, 402, 290, 10, 60, "Output",
 CellTags->"Ex--22034523510008951413,12",
 CellID->33708635]
}, Open  ]],
Cell[CellGroupData[{
Cell[11664, 417, 324, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,13",
 CellID->86052490],
Cell[11991, 429, 390, 14, 68, "Output",
 CellTags->"Ex--22034523510008951413,13",
 CellID->152443410]
}, Open  ]],
Cell[CellGroupData[{
Cell[12418, 448, 324, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,14",
 CellID->93576955],
Cell[12745, 460, 356, 13, 77, "Output",
 CellTags->"Ex--22034523510008951413,14",
 CellID->719233270]
}, Open  ]],
Cell[CellGroupData[{
Cell[13138, 478, 248, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,15",
 CellID->295748689],
Cell[13389, 487, 342, 12, 61, "Output",
 CellTags->"Ex--22034523510008951413,15",
 CellID->141290310]
}, Open  ]],
Cell[CellGroupData[{
Cell[13768, 504, 265, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,16",
 CellID->39179587],
Cell[14036, 514, 374, 13, 60, "Output",
 CellTags->"Ex--22034523510008951413,16",
 CellID->569923844]
}, Open  ]],
Cell[14425, 530, 124, 3, 70, "ExampleDelimiter",
 CellID->23578002],
Cell[14552, 535, 61, 1, 70, "ExampleText",
 CellID->266275944],
Cell[CellGroupData[{
Cell[14638, 540, 274, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellID->193365295],
Cell[14915, 550, 379, 14, 87, "Output",
 CellTags->"Ex--22034523510008951413,18",
 CellID->6350988]
}, Open  ]],
Cell[CellGroupData[{
Cell[15331, 569, 274, 8, 70, "Input",
 CellTags->"Ex--22034695909109010687,5",
 CellID->117726131],
Cell[15608, 579, 388, 14, 60, "Output",
 CellTags->"Ex--22034695909109010687,5",
 CellID->502880720]
}, Open  ]],
Cell[CellGroupData[{
Cell[16033, 598, 245, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,17",
 CellID->446451859],
Cell[16281, 607, 393, 14, 76, "Output",
 CellTags->"Ex--22034523510008951413,17",
 CellID->88421141]
}, Open  ]],
Cell[16689, 624, 125, 3, 70, "ExampleDelimiter",
 CellID->304986378],
Cell[16817, 629, 65, 1, 70, "ExampleText",
 CellID->246224435],
Cell[CellGroupData[{
Cell[16907, 634, 314, 9, 70, "Input",
 CellTags->"Ex--22034599492440594602,3",
 CellID->650689971],
Cell[17224, 645, 350, 12, 55, "Output",
 CellTags->"Ex--22034599492440594602,3",
 CellID->26800036]
}, Open  ]],
Cell[CellGroupData[{
Cell[17611, 662, 375, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,25",
 CellID->807756863],
Cell[17989, 674, 472, 17, 77, "Output",
 CellTags->"Ex--22034523510008951413,25",
 CellID->198897238]
}, Open  ]],
Cell[18476, 694, 124, 3, 70, "ExampleDelimiter",
 CellID->32899182],
Cell[18603, 699, 67, 1, 70, "ExampleText",
 CellID->268923354],
Cell[CellGroupData[{
Cell[18695, 704, 573, 18, 70, "Input",
 CellID->56844988],
Cell[19271, 724, 298, 10, 51, "Output",
 CellID->45674680]
}, Open  ]],
Cell[CellGroupData[{
Cell[19606, 739, 416, 13, 70, "Input",
 CellID->57822787],
Cell[20025, 754, 516, 18, 55, "Output",
 CellID->553334488]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20590, 778, 218, 7, 70, "ExampleSection",
 CellID->17496],
Cell[CellGroupData[{
Cell[20833, 789, 232, 7, 70, "ExampleSubsection",
 CellID->145440021],
Cell[21068, 798, 247, 8, 70, "ExampleText",
 CellID->129286313],
Cell[CellGroupData[{
Cell[21340, 810, 346, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,22",
 CellID->786369123],
Cell[21689, 821, 340, 13, 87, "Output",
 CellTags->"Ex--22034523510008951413,22",
 CellID->232276128]
}, Open  ]],
Cell[CellGroupData[{
Cell[22066, 839, 346, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,23",
 CellID->320784725],
Cell[22415, 850, 200, 6, 36, "Output",
 CellTags->"Ex--22034523510008951413,23",
 CellID->546134193]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22664, 862, 238, 7, 70, "ExampleSubsection",
 CellID->577065928],
Cell[22905, 871, 347, 13, 70, "ExampleText",
 CellID->327143797],
Cell[CellGroupData[{
Cell[23277, 888, 264, 8, 70, "Input",
 CellTags->"Ex--22034599492440594602,9",
 CellID->379941444],
Cell[23544, 898, 330, 12, 77, "Output",
 CellTags->"Ex--22034599492440594602,9",
 CellID->131796329]
}, Open  ]],
Cell[23889, 913, 120, 3, 70, "ExampleText",
 CellID->21669668],
Cell[CellGroupData[{
Cell[24034, 920, 374, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,28",
 CellID->257823649],
Cell[24411, 932, 323, 11, 56, "Output",
 CellTags->"Ex--22034523510008951413,28",
 CellID->203890978]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24783, 949, 239, 7, 70, "ExampleSubsection",
 CellID->567142764],
Cell[25025, 958, 365, 12, 70, "ExampleText",
 CellID->327317843],
Cell[CellGroupData[{
Cell[25415, 974, 333, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,19",
 CellID->205781283],
Cell[25751, 985, 715, 23, 77, "Output",
 CellTags->"Ex--22034523510008951413,19",
 CellID->42314087]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26527, 1015, 232, 7, 70, "ExampleSection",
 CellID->9246],
Cell[26762, 1024, 385, 12, 70, "ExampleText",
 CellID->899866971],
Cell[CellGroupData[{
Cell[27172, 1040, 337, 9, 70, "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellID->87244332],
Cell[27512, 1051, 226, 7, 36, "Output",
 CellTags->"Ex--22034138112425334325,15",
 CellID->70000885]
}, Open  ]],
Cell[CellGroupData[{
Cell[27775, 1063, 333, 9, 70, "Input",
 CellTags->"Ex--22035133735460154583,1",
 CellID->72689112],
Cell[28111, 1074, 233, 7, 36, "Output",
 CellTags->"Ex--22035133735460154583,1",
 CellID->254280906]
}, Open  ]],
Cell[CellGroupData[{
Cell[28381, 1086, 302, 10, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->517183249],
Cell[28686, 1098, 322, 11, 60, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->62094201]
}, Open  ]],
Cell[CellGroupData[{
Cell[29045, 1114, 203, 5, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->100959012],
Cell[29251, 1121, 267, 9, 51, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->144917024]
}, Open  ]],
Cell[29533, 1133, 123, 3, 70, "ExampleDelimiter",
 CellID->4553799],
Cell[29659, 1138, 408, 14, 70, "ExampleText",
 CellID->211365622],
Cell[CellGroupData[{
Cell[30092, 1156, 237, 7, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->145126959],
Cell[30332, 1165, 290, 10, 60, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->272142374]
}, Open  ]],
Cell[CellGroupData[{
Cell[30659, 1180, 239, 7, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->204658303],
Cell[30901, 1189, 330, 11, 60, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->79957765]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31280, 1206, 225, 7, 70, "ExampleSection",
 CellID->2784],
Cell[31508, 1215, 263, 9, 70, "ExampleText",
 CellID->238568336],
Cell[CellGroupData[{
Cell[31796, 1228, 211, 5, 70, "Input",
 CellTags->"Ex--22034523510008951413,31",
 CellID->741524577],
Cell[32010, 1235, 381, 13, 38, "Output",
 CellTags->"Ex--22034523510008951413,31",
 CellID->472792173]
}, Open  ]],
Cell[CellGroupData[{
Cell[32428, 1253, 196, 5, 70, "Input",
 CellTags->"Ex--22034695909109010687,1",
 CellID->350125888],
Cell[32627, 1260, 205, 6, 36, "Output",
 CellTags->"Ex--22034695909109010687,1",
 CellID->49056107]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32893, 1273, 311, 9, 70, "SeeAlsoSection",
 CellID->21357],
Cell[33207, 1284, 1041, 35, 70, "SeeAlso",
 CellID->19191]
}, Open  ]],
Cell[CellGroupData[{
Cell[34285, 1324, 314, 9, 70, "TutorialsSection",
 CellID->26901],
Cell[34602, 1335, 194, 4, 70, "Tutorials",
 CellID->22927]
}, Open  ]],
Cell[CellGroupData[{
Cell[34833, 1344, 319, 9, 70, "MoreAboutSection",
 CellID->263757729],
Cell[35155, 1355, 148, 3, 70, "MoreAbout",
 CellID->96975518]
}, Open  ]],
Cell[35318, 1361, 27, 0, 70, "History"],
Cell[35348, 1363, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

