(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58548,       2157]
NotebookOptionsPosition[     47110,       1753]
NotebookOutlinePosition[     49345,       1811]
CellTagsIndexPosition[     49167,       1804]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:tutorial/IntegralTransforms"], 
          "Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Integral Transforms\"\>", 
       2->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseFourierSinTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierSinTransform"], 
          "InverseFourierCosTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierCosTransform"], 
          "InverseFourier" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourier"], 
          "FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"], 
          "InverseLaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseLaplaceTransform"], 
          "Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"InverseFourierSinTransform\"\>", 
       2->"\<\"InverseFourierCosTransform\"\>", 3->"\<\"InverseFourier\"\>", 
       4->"\<\"FourierTransform\"\>", 5->"\<\"InverseLaplaceTransform\"\>", 
       6->"\<\"Integrate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseFourierTransform", "ObjectName",
 CellID->9974],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseFourierTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", "\[Omega]", ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the symbolic inverse Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseFourierTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Omega]", 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox["\[Omega]", 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multidimensional inverse Fourier transform of \
",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->27296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The inverse Fourier transform of a function",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "\[Omega]", ")"}], TraditionalForm]], "InlineMath"],
 " ",
 "is by default defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"2", "\[Pi]"}]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
      SuperscriptBox["e", 
       RowBox[{"-", "i", "\[Omega]", "t"}]], "d", "\[InvisibleSpace]", 
      "\[Omega]"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->3764],

Cell["\<\
Other definitions are used in some scientific and technical fields. \
\>", "Notes",
 CellID->18223],

Cell[TextData[{
 "Different choices of definitions can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6607],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " the inverse Fourier transform computed by ",
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{"\[VerticalSeparator]", "b", "\[VerticalSeparator]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], 
       RowBox[{"1", "+", "a"}]]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"F", "(", "\[Omega]", ")"}], " ", 
      SuperscriptBox["e", 
       RowBox[{"-", "i", "b", "\[Omega]", "t"}]], "d", "\[InvisibleSpace]", 
      "\[Omega]"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->12074],

Cell[TextData[{
 "Some common choices for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "}"}]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}]], "InlineFormula"],
 " (default; modern physics), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"],
 " (pure mathematics; systems engineering), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]], "InlineFormula"],
 " (classical physics), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", 
    RowBox[{
     RowBox[{"-", "2"}], 
     ButtonBox["Pi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pi"]}]}], "}"}]], "InlineFormula"],
 " (signal processing). "
}], "Notes",
 CellID->790],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " and other options to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can also be given in ",
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->22599],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "\[Omega]", ",", 
    StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
 " yields an expression depending on the continuous variable ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " that represents the symbolic inverse Fourier transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with respect to the continuous variable ",
 Cell[BoxData["\[Omega]"], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourier"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " takes a finite list of numbers as input, and yields as output a list \
representing the discrete inverse Fourier transform of the input. "
}], "Notes",
 CellID->32518],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 " is output using ",
 Cell[BoxData[
  SuperscriptBox["\[ScriptCapitalF]", 
   RowBox[{"-", "1"}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3140]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->339442971],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->655245114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", 
       RowBox[{"Abs", "[", "\[Omega]", "]"}]}], ")"}]}], "*", 
    RowBox[{"Sin", "[", "\[Omega]", "]"}]}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79590435],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", "t"}], 
   RowBox[{"4", "+", 
    SuperscriptBox["t", "4"]}]]}]], "Output",
 ImageSize->{77, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292143739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->435950824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"1", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173378135],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]], " ", 
  RowBox[{"DiracDelta", "[", "t", "]"}]}]], "Output",
 ImageSize->{133, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166873612]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15124],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{43, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->324266687]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21640],

Cell["Elementary functions:", "ExampleText",
 CellID->53795168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"\[Omega]", "^", "2"}]}], ")"}]}], ",", "\[Omega]", ",", " ", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77848019],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    RowBox[{"Abs", "[", "t", "]"}]}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{82, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178127879]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"\[Omega]", "^", "2"}], ",", "\[Omega]", ",", " ", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194822829],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]]}], " ", 
  RowBox[{
   SuperscriptBox["DiracDelta", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "t", "]"}]}]], "Output",
 ImageSize->{148, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->673000688]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Omega]", "^", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"\[Omega]", "^", "3"}]}], ")"}]}], ",", "\[Omega]", ",", " ", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25734],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", 
         SqrtBox["3"]}], ")"}], " ", "t"}]], " ", 
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{"-", "t"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", 
         SqrtBox["3"]}], ")"}], " ", "t"}]], " ", 
     RowBox[{"HeavisideTheta", "[", "t", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "t"}]], " ", 
     RowBox[{"Sign", "[", "t", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{534, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12233197]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", "\[Omega]"}], ",", "\[Omega]", ",", " ", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1400],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sign", "[", "t", "]"}]}]], "Output",
 ImageSize->{107, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->213511358]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"\[Omega]", "^", "2"}]}], "]"}], ",", "\[Omega]", ",", " ", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->564391953],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["t", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->12272131]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "\[Omega]", "]"}], "^", "2"}], ",", "\[Omega]", ",", 
   " ", "t"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->67872223],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "t"}], "]"}]}], "+", 
  RowBox[{
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", "t", "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{"2", "+", "t"}], "]"}]}]}]], "Output",
 ImageSize->{491, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->9044318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1689],

Cell["Special functions:", "ExampleText",
 CellID->18815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", " ", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4336],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sign", "[", 
     RowBox[{"1", "-", "t"}], "]"}], "+", 
    RowBox[{"Sign", "[", 
     RowBox[{"1", "+", "t"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{217, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20351219]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"-", 
      RowBox[{"\[Omega]", "^", "2"}]}]}], "]"}], ",", "\[Omega]", ",", " ", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154387234],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  SuperscriptBox["t", "2"], " ", 
  RowBox[{"BesselK", "[", 
   RowBox[{"1", ",", 
    RowBox[{"Abs", "[", "t", "]"}]}], "]"}]}]], "Output",
 ImageSize->{192, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172951760]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26143],

Cell["Piecewise functions and distributions:", "ExampleText",
 CellID->25177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Omega]", "^", "2"}], " ", 
    RowBox[{"Sign", "[", "\[Omega]", "]"}]}], ",", "\[Omega]", ",", " ", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18523],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]]}], 
  SuperscriptBox["t", "3"]]], "Output",
 ImageSize->{60, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->488560025]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"HeavisideTheta", "[", "\[Omega]", "]"}], " ", 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"1", "-", "\[Omega]"}], "]"}]}], ",", "\[Omega]", ",", " ", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->182596577],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Cos", "[", "t", "]"}]}], "+", 
   RowBox[{"Sin", "[", "t", "]"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "t"}]]], "Output",
 ImageSize->{145, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13301881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->66461],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->292117866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFourierTransform", "[", 
   RowBox[{
    RowBox[{"F", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", "t"}], "]"}], "//",
   "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5300426],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[ScriptCapitalF]", "\[Omega]", 
     RowBox[{"-", "1"}]], "[", 
    RowBox[{"F", "(", "\[Omega]", ")"}], "]"}], 
   RowBox[{"(", "t", ")"}]}], TraditionalForm]], "Output",
 ImageSize->{71, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->49628404]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13948],

Cell["Multidimensional inverse Fourier transform:", "ExampleText",
 CellID->10886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", " ", "v"}], ")"}], "^", "3"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "+", 
        RowBox[{"v", "^", "2"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10505],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "128"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["x", "2"], "4"]}], "-", 
    FractionBox[
     SuperscriptBox["y", "2"], "4"]}]], " ", "x", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "6"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", "y", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "6"}], "+", 
    SuperscriptBox["y", "2"]}], ")"}]}]], "Output",
 ImageSize->{218, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->630032259]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7150],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32739],

Cell[TextData[{
 "The inverse Fourier transform of ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " is a piecewise function:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->22599,
  ButtonNote->"22599"]
}], "ExampleText",
 CellID->320106373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"3", ",", " ", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", 
   ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{
     RowBox[{"-", "1"}], " ", "<", "t", "  ", "<", " ", "1"}]}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190547095],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "t", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["t", "2"]}]}], ")"}]}], 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["t", "2"]}]]]], "Output",
 ImageSize->{126, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->377630378]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"3", ",", " ", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", 
   ",", "  ", 
   RowBox[{"Assumptions", " ", "\[Rule]", 
    RowBox[{"t", "  ", ">", " ", "1"}]}]}], "  ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166519481],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->665746695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"3", ",", " ", "\[Omega]"}], "]"}], ",", "\[Omega]", ",", "t", 
   ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", 
    RowBox[{"t", "  ", "<", " ", 
     RowBox[{"-", "1"}]}]}]}], "  ", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->196327874],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6463108]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FourierParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30229],

Cell["Default modern physics convention:", "ExampleText",
 CellID->20609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"1", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24740],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]], " ", 
  RowBox[{"DiracDelta", "[", "t", "]"}]}]], "Output",
 ImageSize->{133, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->351387913]
}, Open  ]],

Cell["Convention for pure mathematics, systems engineering:", "ExampleText",
 CellID->7346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"1", ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", "->", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30000],

Cell[BoxData[
 RowBox[{"DiracDelta", "[", "t", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->286593752]
}, Open  ]],

Cell["Convention for classical physics:", "ExampleText",
 CellID->11458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"1", ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13102],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]", " ", 
  RowBox[{"DiracDelta", "[", "t", "]"}]}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2293559]
}, Open  ]],

Cell["Convention for signal processing:", "ExampleText",
 CellID->760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"1", ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"-", "2"}], "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22206],

Cell[BoxData[
 RowBox[{"DiracDelta", "[", "t", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->92109640]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GenerateConditions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8472],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to get parameter conditions for when a result is valid:"
}], "ExampleText",
 CellID->243654745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      RowBox[{"\[Omega]", "^", "2"}]}], ")"}]}], ",", " ", "\[Omega]", ",", 
   "t", ",", " ", 
   RowBox[{"GenerateConditions", " ", "\[Rule]", " ", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22133938],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], ">", "0"}], ",", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["t", "2"], 
       RowBox[{"4", " ", "a"}]]}]], 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox["a"]}]], ",", 
   RowBox[{"InverseFourierTransform", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["\[Omega]", "2"]}]], ",", "\[Omega]", ",", "t", ",", 
     RowBox[{"GenerateConditions", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{441, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460582283]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18634],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 " are mutual inverses:"
}], "ExampleText",
 CellID->558643518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"InverseFourierTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", " ", "\[Omega]", "]"}], ",", " ", "\[Omega]", ",", " ",
      "t"}], "]"}], ",", "t", ",", "  ", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70250391],

Cell[BoxData[
 RowBox[{"f", "[", "\[Omega]", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->829356599]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     RowBox[{"g", "[", "t", "]"}], ",", "t", ",", "  ", "\[Omega]"}], "]"}], 
   ",", " ", "\[Omega]", ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50546575],

Cell[BoxData[
 RowBox[{"g", "[", "t", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->440608742]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", " ", 
     RowBox[{
      RowBox[{"\[Omega]", "^", "2"}], "+", "1"}], ")"}]}], ",", " ", 
   "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[3]:=",
 CellID->517183249],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    RowBox[{"Abs", "[", "t", "]"}]}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{82, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[3]=",
 CellID->45074877]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{"%", ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[4]:=",
 CellID->100959012],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[4]=",
 CellID->13384225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->429540358],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseFourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierCosTransform"]], "InlineFormula"],
 " are equal for even functions:"
}], "ExampleText",
 CellID->95469380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", " ", 
     RowBox[{"\[Omega]", "^", "2"}]}], "]"}], ",", " ", "\[Omega]", ",", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333107711],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["t", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->836671784]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"\[Omega]", "^", "2"}]}], "]"}], ",", " ", "\[Omega]", ",", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->352411717],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["t", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->162499688]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102569453],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseFourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierSinTransform"]], "InlineFormula"],
 " differ by ",
 Cell[BoxData[
  FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
 " for odd functions:"
}], "ExampleText",
 CellID->56304745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"\[Omega]", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"Abs", "[", "\[Omega]", "]"}]}], "]"}]}], ",", "\[Omega]", ",", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237371414],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", "t"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["t", "2"]}], ")"}], "2"]]}]], "Output",
 ImageSize->{77, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54602203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"\[Omega]", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"Abs", "[", "\[Omega]", "]"}]}], "]"}]}], ",", "\[Omega]", ",", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->487442395],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "t"}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["t", "2"]}], ")"}], "2"]]], "Output",
 ImageSize->{60, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->367009590]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16766],

Cell["\<\
The result from an inverse Fourier transform may not have the same form as \
the original:\
\>", "ExampleText",
 CellID->17690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"UnitStep", "[", 
     RowBox[{"2", "+", " ", "\[Omega]"}], "]"}], 
    RowBox[{"UnitStep", "[", 
     RowBox[{"2", "-", "\[Omega]"}], "]"}]}], ",", " ", "\[Omega]", ",", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30908],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "t"}], "]"}]}], "t"]], "Output",
 ImageSize->{94, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393883200]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{"%", ",", "t", ",", " ", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3394],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sign", "[", 
     RowBox[{"2", "-", "\[Omega]"}], "]"}], "+", 
    RowBox[{"Sign", "[", 
     RowBox[{"2", "+", "\[Omega]"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{182, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->380733260]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8853],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"sinc", "(", "\[Omega]", ")"}], "k"], TraditionalForm]], 
  "InlineMath"],
 " is a ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " convolution of box functions:"
}], "ExampleText",
 CellID->746031334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "@", 
      RowBox[{"InverseFourierTransform", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sinc", "[", "\[Omega]", "]"}], "k"], ",", "\[Omega]", ",", 
        "t"}], "]"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "4"}], ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167706887],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->110731314]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18037],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseLaplaceTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseLaplaceTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25365]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17103],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntegralTransforms"]], "Tutorials",
 CellID->7245],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->4257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->148936485],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->326197155]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseFourierTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 51.5102276}", "context" -> "System`", 
    "keywords" -> {
     "distributions", "Fourier transform", "function transform", 
      "integral operator", "integral transform", "Integrate", 
      "inverse Fourier", "inverse Fourier transform", "time domain"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseFourierTransform[expr, \\[Omega], t] gives the symbolic inverse \
Fourier transform of expr. InverseFourierTransform[expr, {\\[Omega]_1, \
\\[Omega]_2, ...}, {t_1, t_2, ...}] gives the multidimensional inverse \
Fourier transform of expr. ", "synonyms" -> {"inverse fourier transform"}, 
    "title" -> "InverseFourierTransform", "type" -> "Symbol", "uri" -> 
    "ref/InverseFourierTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10613, 349, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->339442971]},
 "Ex--22034558506017011754,4"->{
  Cell[32631, 1249, 323, 10, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->517183249],
  Cell[32957, 1261, 347, 12, 60, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->45074877]},
 "Ex--22034558506017011754,5"->{
  Cell[33341, 1278, 193, 5, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->100959012],
  Cell[33537, 1285, 273, 9, 52, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->13384225]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48525, 1783},
 {"Ex--22034558506017011754,4", 48679, 1787},
 {"Ex--22034558506017011754,5", 48929, 1794}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2707, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3330, 89, 60, 1, 70, "ObjectName",
 CellID->9974],
Cell[3393, 92, 1654, 50, 70, "Usage",
 CellID->27296]
}, Open  ]],
Cell[CellGroupData[{
Cell[5084, 147, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5562, 164, 671, 24, 70, "Notes",
 CellID->3764],
Cell[6236, 190, 109, 3, 70, "Notes",
 CellID->18223],
Cell[6348, 195, 258, 8, 70, "Notes",
 CellID->6607],
Cell[6609, 205, 1123, 37, 70, "Notes",
 CellID->12074],
Cell[7735, 244, 840, 32, 70, "Notes",
 CellID->790],
Cell[8578, 278, 547, 18, 70, "Notes",
 CellID->22599],
Cell[9128, 298, 980, 27, 70, "Notes",
 CellID->32518],
Cell[10111, 327, 465, 17, 70, "Notes",
 CellID->3140]
}, Closed]],
Cell[CellGroupData[{
Cell[10613, 349, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->339442971],
Cell[CellGroupData[{
Cell[10998, 363, 148, 5, 70, "ExampleSection",
 CellID->655245114],
Cell[CellGroupData[{
Cell[11171, 372, 339, 11, 28, "Input",
 CellID->79590435],
Cell[11513, 385, 344, 12, 77, "Output",
 CellID->292143739]
}, Open  ]],
Cell[11872, 400, 125, 3, 70, "ExampleDelimiter",
 CellID->435950824],
Cell[CellGroupData[{
Cell[12022, 407, 159, 4, 28, "Input",
 CellID->173378135],
Cell[12184, 413, 258, 9, 38, "Output",
 CellID->166873612]
}, Open  ]],
Cell[CellGroupData[{
Cell[12479, 427, 203, 6, 70, "Input",
 CellID->15124],
Cell[12685, 435, 218, 8, 55, "Output",
 CellID->324266687]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12952, 449, 216, 7, 70, "ExampleSection",
 CellID->21640],
Cell[13171, 458, 63, 1, 70, "ExampleText",
 CellID->53795168],
Cell[CellGroupData[{
Cell[13259, 463, 276, 9, 70, "Input",
 CellID->77848019],
Cell[13538, 474, 307, 11, 60, "Output",
 CellID->178127879]
}, Open  ]],
Cell[CellGroupData[{
Cell[13882, 490, 198, 6, 70, "Input",
 CellID->194822829],
Cell[14083, 498, 347, 12, 38, "Output",
 CellID->673000688]
}, Open  ]],
Cell[CellGroupData[{
Cell[14467, 515, 305, 10, 70, "Input",
 CellID->25734],
Cell[14775, 527, 1080, 34, 101, "Output",
 CellID->12233197]
}, Open  ]],
Cell[CellGroupData[{
Cell[15892, 566, 193, 6, 70, "Input",
 CellID->1400],
Cell[16088, 574, 290, 10, 60, "Output",
 CellID->213511358]
}, Open  ]],
Cell[CellGroupData[{
Cell[16415, 589, 252, 8, 70, "Input",
 CellID->564391953],
Cell[16670, 599, 296, 11, 68, "Output",
 CellID->12272131]
}, Open  ]],
Cell[CellGroupData[{
Cell[17003, 615, 230, 7, 70, "Input",
 CellID->67872223],
Cell[17236, 624, 647, 24, 60, "Output",
 CellID->9044318]
}, Open  ]],
Cell[17898, 651, 120, 3, 70, "ExampleDelimiter",
 CellID->1689],
Cell[18021, 656, 57, 1, 70, "ExampleText",
 CellID->18815],
Cell[CellGroupData[{
Cell[18103, 661, 201, 6, 70, "Input",
 CellID->4336],
Cell[18307, 669, 414, 15, 60, "Output",
 CellID->20351219]
}, Open  ]],
Cell[CellGroupData[{
Cell[18758, 689, 339, 10, 70, "Input",
 CellID->154387234],
Cell[19100, 701, 374, 13, 60, "Output",
 CellID->172951760]
}, Open  ]],
Cell[19489, 717, 121, 3, 70, "ExampleDelimiter",
 CellID->26143],
Cell[19613, 722, 77, 1, 70, "ExampleText",
 CellID->25177],
Cell[CellGroupData[{
Cell[19715, 727, 260, 8, 70, "Input",
 CellID->18523],
Cell[19978, 737, 287, 10, 77, "Output",
 CellID->488560025]
}, Open  ]],
Cell[CellGroupData[{
Cell[20302, 752, 323, 9, 70, "Input",
 CellID->182596577],
Cell[20628, 763, 406, 14, 55, "Output",
 CellID->13301881]
}, Open  ]],
Cell[21049, 780, 121, 3, 70, "ExampleDelimiter",
 CellID->66461],
Cell[21173, 785, 203, 7, 70, "ExampleText",
 CellID->292117866],
Cell[CellGroupData[{
Cell[21401, 796, 236, 7, 70, "Input",
 CellID->5300426],
Cell[21640, 805, 388, 12, 54, "Output",
 CellID->49628404]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22077, 823, 239, 7, 70, "ExampleSection",
 CellID->13948],
Cell[22319, 832, 82, 1, 70, "ExampleText",
 CellID->10886],
Cell[CellGroupData[{
Cell[22426, 837, 514, 18, 70, "Input",
 CellID->10505],
Cell[22943, 857, 633, 23, 56, "Output",
 CellID->630032259]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23625, 886, 217, 7, 70, "ExampleSection",
 CellID->7150],
Cell[CellGroupData[{
Cell[23867, 897, 228, 7, 70, "ExampleSubsection",
 CellID->32739],
Cell[24098, 906, 344, 12, 70, "ExampleText",
 CellID->320106373],
Cell[CellGroupData[{
Cell[24467, 922, 380, 11, 70, "Input",
 CellID->190547095],
Cell[24850, 935, 460, 17, 87, "Output",
 CellID->377630378]
}, Open  ]],
Cell[CellGroupData[{
Cell[25347, 957, 338, 9, 70, "Input",
 CellID->166519481],
Cell[25688, 968, 158, 5, 36, "Output",
 CellID->665746695]
}, Open  ]],
Cell[CellGroupData[{
Cell[25883, 978, 358, 10, 70, "Input",
 CellID->196327874],
Cell[26244, 990, 156, 5, 36, "Output",
 CellID->6463108]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26449, 1001, 234, 7, 70, "ExampleSubsection",
 CellID->30229],
Cell[26686, 1010, 73, 1, 70, "ExampleText",
 CellID->20609],
Cell[CellGroupData[{
Cell[26784, 1015, 155, 4, 70, "Input",
 CellID->24740],
Cell[26942, 1021, 258, 9, 38, "Output",
 CellID->351387913]
}, Open  ]],
Cell[27215, 1033, 91, 1, 70, "ExampleText",
 CellID->7346],
Cell[CellGroupData[{
Cell[27331, 1038, 279, 8, 70, "Input",
 CellID->30000],
Cell[27613, 1048, 194, 6, 36, "Output",
 CellID->286593752]
}, Open  ]],
Cell[27822, 1057, 72, 1, 70, "ExampleText",
 CellID->11458],
Cell[CellGroupData[{
Cell[27919, 1062, 279, 8, 70, "Input",
 CellID->13102],
Cell[28201, 1072, 230, 7, 36, "Output",
 CellID->2293559]
}, Open  ]],
Cell[28446, 1082, 70, 1, 70, "ExampleText",
 CellID->760],
Cell[CellGroupData[{
Cell[28541, 1087, 303, 9, 70, "Input",
 CellID->22206],
Cell[28847, 1098, 193, 6, 36, "Output",
 CellID->92109640]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29089, 1110, 234, 7, 70, "ExampleSubsection",
 CellID->8472],
Cell[29326, 1119, 365, 12, 70, "ExampleText",
 CellID->243654745],
Cell[CellGroupData[{
Cell[29716, 1135, 376, 12, 70, "Input",
 CellID->22133938],
Cell[30095, 1149, 780, 26, 94, "Output",
 CellID->460582283]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30936, 1182, 233, 7, 70, "ExampleSection",
 CellID->18634],
Cell[31172, 1191, 373, 12, 70, "ExampleText",
 CellID->558643518],
Cell[CellGroupData[{
Cell[31570, 1207, 309, 8, 70, "Input",
 CellID->70250391],
Cell[31882, 1217, 192, 6, 36, "Output",
 CellID->829356599]
}, Open  ]],
Cell[CellGroupData[{
Cell[32111, 1228, 295, 8, 70, "Input",
 CellID->50546575],
Cell[32409, 1238, 185, 6, 36, "Output",
 CellID->440608742]
}, Open  ]],
Cell[CellGroupData[{
Cell[32631, 1249, 323, 10, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->517183249],
Cell[32957, 1261, 347, 12, 60, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->45074877]
}, Open  ]],
Cell[CellGroupData[{
Cell[33341, 1278, 193, 5, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->100959012],
Cell[33537, 1285, 273, 9, 52, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->13384225]
}, Open  ]],
Cell[33825, 1297, 125, 3, 70, "ExampleDelimiter",
 CellID->429540358],
Cell[33953, 1302, 401, 12, 70, "ExampleText",
 CellID->95469380],
Cell[CellGroupData[{
Cell[34379, 1318, 257, 8, 70, "Input",
 CellID->333107711],
Cell[34639, 1328, 297, 11, 68, "Output",
 CellID->836671784]
}, Open  ]],
Cell[CellGroupData[{
Cell[34973, 1344, 255, 8, 70, "Input",
 CellID->352411717],
Cell[35231, 1354, 297, 11, 68, "Output",
 CellID->162499688]
}, Open  ]],
Cell[35543, 1368, 125, 3, 70, "ExampleDelimiter",
 CellID->102569453],
Cell[35671, 1373, 482, 15, 70, "ExampleText",
 CellID->56304745],
Cell[CellGroupData[{
Cell[36178, 1392, 288, 9, 70, "Input",
 CellID->237371414],
Cell[36469, 1403, 397, 14, 83, "Output",
 CellID->54602203]
}, Open  ]],
Cell[CellGroupData[{
Cell[36903, 1422, 291, 9, 70, "Input",
 CellID->487442395],
Cell[37197, 1433, 351, 13, 83, "Output",
 CellID->367009590]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37597, 1452, 226, 7, 70, "ExampleSection",
 CellID->16766],
Cell[37826, 1461, 137, 4, 70, "ExampleText",
 CellID->17690],
Cell[CellGroupData[{
Cell[37988, 1469, 328, 10, 70, "Input",
 CellID->30908],
Cell[38319, 1481, 297, 11, 76, "Output",
 CellID->393883200]
}, Open  ]],
Cell[CellGroupData[{
Cell[38653, 1497, 152, 4, 70, "Input",
 CellID->3394],
Cell[38808, 1503, 381, 13, 51, "Output",
 CellID->380733260]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39238, 1522, 223, 7, 70, "ExampleSection",
 CellID->8853],
Cell[39464, 1531, 462, 17, 70, "ExampleText",
 CellID->746031334],
Cell[CellGroupData[{
Cell[39951, 1552, 668, 19, 70, "Input",
 CellID->167706887],
Cell[40622, 1573, 3273, 58, 70, "Output",
 Evaluatable->False,
 CellID->110731314]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43956, 1638, 311, 9, 70, "SeeAlsoSection",
 CellID->18037],
Cell[44270, 1649, 1563, 53, 70, "SeeAlso",
 CellID->25365]
}, Open  ]],
Cell[CellGroupData[{
Cell[45870, 1707, 314, 9, 70, "TutorialsSection",
 CellID->17103],
Cell[46187, 1718, 147, 3, 70, "Tutorials",
 CellID->7245],
Cell[46337, 1723, 193, 4, 70, "Tutorials",
 CellID->4257]
}, Open  ]],
Cell[CellGroupData[{
Cell[46567, 1732, 319, 9, 70, "MoreAboutSection",
 CellID->148936485],
Cell[46889, 1743, 149, 3, 70, "MoreAbout",
 CellID->326197155]
}, Open  ]],
Cell[47053, 1749, 27, 0, 70, "History"],
Cell[47083, 1751, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

