(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37904,       1297]
NotebookOptionsPosition[     30644,       1045]
NotebookOutlinePosition[     31968,       1082]
CellTagsIndexPosition[     31882,       1077]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gamma" :> Documentation`HelpLookup["paclet:ref/Gamma"], 
          "GammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/GammaRegularized"], 
          "InverseBetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseBetaRegularized"], 
          "InverseErf" :> Documentation`HelpLookup["paclet:ref/InverseErf"], 
          "GammaDistribution" :> 
          Documentation`HelpLookup["paclet:ref/GammaDistribution"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Gamma\"\>", 
       2->"\<\"GammaRegularized\"\>", 3->"\<\"InverseBetaRegularized\"\>", 
       4->"\<\"InverseErf\"\>", 
       5->"\<\"GammaDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Gamma Functions and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/GammaFunctionsAndRelatedFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Functions Used in Statistics\"\>", 
       2->"\<\"Gamma Functions and Related Functions\"\>", 
       3->"\<\"Inverse Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseGammaRegularized", "ObjectName",
 CellID->11716],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseGammaRegularized",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseGammaRegularized"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse of the regularized incomplete gamma \
function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "With the regularized incomplete gamma function defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Q", "(", 
     RowBox[{"a", ",", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"\[CapitalGamma]", "(", 
      RowBox[{"a", ",", "z"}], ")"}], "/", 
     RowBox[{"\[CapitalGamma]", "(", "a", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseGammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGammaRegularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
 " is the solution for ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{"Q", "(", 
     RowBox[{"a", ",", "z"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->7229],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseGammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGammaRegularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the inverse of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaRegularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4466],

Cell[TextData[{
 "Note that the arguments of ",
 Cell[BoxData[
  ButtonBox["InverseGammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFormula"],
 " are arranged differently than in ",
 Cell[BoxData[
  ButtonBox["InverseBetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7783],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseGammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->33352532],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->336038571],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->124052014],

Cell["Evaluate numerically:", "ExampleText",
 CellID->10698211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseGammaRegularized", "[", 
  RowBox[{"2", ",", "0.55"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521805723],

Cell[BoxData["1.5234732121364185`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149044005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32819204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseGammaRegularized", "[", 
    RowBox[{"2", ",", "s"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269007598],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29628069]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->595907968],

Cell["Exact results for special arguments:", "ExampleText",
 CellID->199544668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseGammaRegularized", "[", 
  RowBox[{"2", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4519485],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112443470]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414450367],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->229407775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseGammaRegularized", "[", 
    RowBox[{"2", ",", 
     RowBox[{"33", "/", "100"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98147342],

Cell[BoxData["2.\
3037081413300490532294081374668183161448488372586509671799701313507`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->893910589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112014002],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->469443385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseGammaRegularized", "[", 
  RowBox[{"2", ",", "0.330000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242416311],

Cell[BoxData["2.30370814133004905322940813743962995846`23.518513939877895"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->605057716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->456171245],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->44351109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseGammaRegularized", "[", 
   RowBox[{"a", ",", "s"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404989654],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    InterpretationBox["Q",
     GammaRegularized,
     Editable->False,
     Selectable->False], 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"a", ",", "s"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{51, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->265963008]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->797555279],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->320645081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseGammaRegularized", "[", 
  RowBox[{
   RowBox[{"2", "/", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", " ", "0.3", ",", " ", "0.4", ",", " ", "0.5"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144784533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0973603351633192`", ",", "0.7652100311042875`", ",", 
   "0.5409271547633965`", ",", "0.37655600998502564`"}], "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9604484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266419500],

Cell["Evaluate the 3-argument generalized case:", "ExampleText",
 CellID->475818337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseGammaRegularized", "[", 
   RowBox[{"4", ",", 
    RowBox[{"3", "/", "4"}], ",", " ", "0.2"}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41360215],

Cell[BoxData["2.3324979233999867`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366014708]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5830171],

Cell["\<\
Model the PDF of the gamma distribution through uniformly distributed random \
numbers:\
\>", "ExampleText",
 CellID->756557088],

Cell[BoxData[
 RowBox[{
  RowBox[{"pmod", "[", 
   RowBox[{"\[Alpha]_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"InverseGammaRegularized", "[", 
   RowBox[{"\[Alpha]", ",", "\[Infinity]", ",", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", "n"}], "]"}], "-", "1"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->387945888],

Cell["Compare binned modeled distribution with exact distribution:", \
"ExampleText",
 CellID->638750397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]", "=", "2"}], ",", 
     RowBox[{"n", "=", "2000"}], ",", 
     RowBox[{"s", "=", "0.5"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"First", "[", "#", "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "#", "]"}], "/", "n"}], "/", "s"}]}], 
          "}"}], "&"}], "/@", 
        RowBox[{"Split", "[", 
         RowBox[{"Sort", "[", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{"pmod", "[", 
             RowBox[{"\[Alpha]", ",", "  ", "n"}], "]"}], ",", "s"}], "]"}], 
          "]"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"\[Alpha]", " ", "-", " ", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"E", "^", "x"}], " ", 
           RowBox[{"Gamma", "[", "\[Alpha]", "]"}]}], ")"}]}], "  ", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "8"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99698504],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWWtsFUUUHu7e25YKCviIEASVl69EUQM+gjwKLQVRSWggIai1QtoYxEBR
A0YlIC9RkYcCLbcolMq7iIAKGpWEiDE0MSUxamJqYvCHxETiDxKT63fmzO7s
np27t7c27d6Z2XO+8/rmzO7tjNrG+vkLaxsb6mpvrlpc+0J9Q92SmysXLcaS
10sp1YW/jTcqjHMY6b+uXA6f4esYXNO4NZJmHsnoHzUCl5RZp0+a0+2UmXta
e2xISzlQhtMlbefKsTIitkI2KIBe9KmXHhC4w4zXcd2e4T8o8G91xRVDTTnv
FEYfFtL1nB52x+cxeX0aVbAK3cEfmwctzIjwpxdhRphj/QTC+SJWs3reuqdj
/Ljtb204o8rEvFTM+4t5WqP2wbXTRBey0dX1Fw1Lhc1C87Ii5f/vvFh7OubM
5ctXOs7/vmH917ixYP5hlWrJfq/SK14/vej5Y/idN3dfCjnSevicXbNXpbGs
MsgaJFet/BI32o90Guvnvv0N85MnfjTW7Fx6VyLup6M5h08+i2S/kSyLofaF
MoDhHn6XL/sM/sJveD+9ugXjKRU7MZ40oYljLfvi9C9QwC/XGZoQgkvSY2nL
c3r8Il36B8z6+ac/2ZU1q78CLDzA+pzZbbgi21g/882v0Lx48W/G8wLzamIU
H0s0bNRzqBzY/8PUyqzS1Smve+bg0sYTgIMU7qGoEOOgp1Q0T3ciLaJL+aVL
/yAB8LShvh3SsL1509mtW84uePYw5EqFTxaJ9vBCTStwR+d218zHd4M3R9sv
XOj8Q82N2ty+7RwN67XGlSv/wiZkkQ6uxuRJzeqpqAYSRsP52ktowDxqiWig
B22EGLglNJEJGtZpfsMXNgQ85FotiMoCgIZPa/KwFVAeuYAJTOuj0sgoDZ/U
yMgcEo6ggQzqqOe07DU501kU/8zzZZFWqEMDnnPmjCztKb251By9jQPuQBBp
w22UGr54PrLpWQ0WI837aNrUFhiarWPh4ldM3IEBdKCf8a0xKYx+EBvCpii0
drqttaNy8s4li4/DB8mBhlgGwThVo/UgzkQH1NKoHIpH+Z/lo8Eeob0UYZTy
mJy0+IRGhONAREkR2ctRRN7gaqaewyA2ASEui0oheGSR0QgdUhTn8tiegBn1
mG8TCcYcg1eccjP0HC4hVBBevRrrBdQkH9VztADYpD3xmogVKTCxVvtchVpT
03emwgIVyQWP1TRdX64HloKCCml8Eqc0cinYjPwjnHCDC+ObUx5sRlBVfo1Y
R63Ucqbh6R9P9kIM0yEcJlOlwFnFAJEnihJXVzUSTK0pAuWNbqJ42lFwzqxN
ypnOCTIRzuoivUHdkbQKv6acfbWmSBQmLfuCrg8U6v1ri0RBR0A/0SeEBy/Q
r4jT62J1KjFcy4R0ufWyLmeYhutiXGAST9ByMAaTNFwvOAy7TGP1iJZkdBq+
GUNkAvNTuu1j2t1S5j4z1N5bG8NgWjOG7WUpPxPYaZTPlLgfwskEOLhNsmN9
fpldwbrcrmiYEvedWKgA7fCHtSxXh4Zvu2RNJ3xIywZxq3dEZgPKmTcDG91G
FyqaHJ06LMuKNHTKsoPmfQmRmRPzXZcsXIXDJkvwAdVGi1CbXLIIBokwstYH
pywCoZNvjPBhcyQLnHsU0eyB+/Qc2YIqebHFIpcEyDm/j90vuJtPGmnFhmZs
7tY03JpHmsvH0qyZJA0W44C4V/DiPSudDkvTE+loLUsHec1e4sX7eZD5KBot
cm2lbf54J9PwbhHjtjzYvKvvETHmk4aX2GSMjWARMg2352Q3Cp8aeu6fGqEu
Jyt+l6j4jly8U2YErhuTzySLaXnhwnR23xgmSAvq0vAOXUvuXNVVWTjc5ECV
72CE4gV1Yq4EaF7wDKeau4kl58SnO/X6kUOdU6uy1E1cWOGzO7QSQ2fOWQ9t
l2yOVTty9sSQLCdvF/OdlmUxLXvasJblZpIW85OGt+k5tzQaZgOtVBAz9w4a
jhI2sk4bzAx7ko4UNloStOy+HSls5deimkobuxJs2JqNEDaStLiV03C4sPWB
I2c2w8P8uXnO/tBpQ2aav0mz/TFJi49aGt7i2zK9YXeCls30ELpkgmcMcxbu
SdDlVwirGzxXGLtJujZvWjfNzxErV5yG0dZIJnmf2N48VETXmmDF5n+oyKRb
i23ZjniTsLU3QcvuedayT3z5tYizQwT7kmzYrA0W87ZIzrhL264wWNhoc9pg
LSSMHzfVIGHjowStmlmt48dto2fTQcIWayWdd65uyKjVVS3mSXWg8GUf6xbV
+Rlz65az2GDU8QcKT3uOadnp/AY1xIX9DhuZnGW6F9jEKwF/X2Uybp/aPcHK
Aw7MQuc027A9g23Yp3mWt/vFZaNQbug+MfwG4e/BGCP8yCULgu9YzFPw9cKr
g05Gsha/VdHwOmH/kFOrTLDhWmHLalGteuu79llpgJ4DHQBk43CCDRvPAIGS
pAX/wVt6t2aO4UUBu5uehI84tdhD/lbQVth2qSQty1f+Ls7uu/YELfiCjJNH
V/tzeEhvZkcjubtKeNLX8ORjJ3a58KBPzuw4kJdsubXYhu3k5b5H0IKuOpag
ZWteLuqTpGWj7S08/sSp1UdIlYq4jkdyxhm1p3VwKprvW044bfT1PYMN1NSe
27BBWiedWtpWGbTAAYSEyvCXtDjssfipU4ff2ZBsSCNZSMPnTrlC/72iWDt6
pBlfjZ059i3b3JD9xugV1UldOpTntPkk0Xwy4VOwO76ET4qeyvbzOWBOqFOx
XMm+LiOW59Gp/IwInShWqlCNVa//AHwIvXc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->101157915]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->265240994],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->100339472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseGammaRegularized", "[", 
  RowBox[{"3.5", ",", "0.66"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143097721],

Cell[BoxData["2.499849353296458`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197190382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"3.5", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->445931233],

Cell[BoxData["0.66`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->647744872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74630012],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->902743327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"InverseGammaRegularized", "[", 
       RowBox[{"\[Alpha]", ",", " ", "x"}], "]"}], "^", "2"}], "+", 
     RowBox[{"2", 
      RowBox[{"InverseGammaRegularized", "[", 
       RowBox[{"\[Alpha]", ",", " ", "x"}], "]"}]}]}], "==", "1"}], ",", " ", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347060710],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->323114252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"GammaRegularized", "[", 
      RowBox[{"\[Alpha]", ",", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["2"]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"GammaRegularized", "[", 
      RowBox[{"\[Alpha]", ",", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["2"]}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{494, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498400834]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->57436899],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFormula"],
 " evaluates numerically only for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "s", "\[LessEqual]", "1"}], TraditionalForm]],
   "InlineMath"],
 "."
}], "ExampleText",
 CellID->263677196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseGammaRegularized", "[", 
   RowBox[{"2", ",", " ", "1.2"}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36983623],

Cell[BoxData[
 RowBox[{"InverseGammaRegularized", "[", 
  RowBox[{"2", ",", "1.2`"}], "]"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140753287]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->720386025],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["Q", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"],
 " is not automatically ",
 Cell[BoxData[
  ButtonBox["InverseGammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16761904],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["Q", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[1]:=",
 CellID->210405011],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "Q"], "[", 
  RowBox[{"a", ",", "z"}], "]"}]], "Output",
 ImageSize->{55, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->499513516]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12444],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseBetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseBetaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseErf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GammaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->689]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17208],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->32105]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->29150],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/index.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/InverseGammaRegularized/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->202348940],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->283137099],

Cell[TextData[ButtonBox["Gamma Functions and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], "MoreAbout",
 CellID->105217316],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->631732128],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->727653099]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseGammaRegularized - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 52.9633898}", "context" -> "System`", 
    "keywords" -> {"inverse regularized gamma"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseGammaRegularized[a, s] gives the inverse of the regularized \
incomplete gamma function. ", "synonyms" -> {"inverse gamma regularized"}, 
    "title" -> "InverseGammaRegularized", "type" -> "Symbol", "uri" -> 
    "ref/InverseGammaRegularized"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7519, 247, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->336038571]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31739, 1070}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2757, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3380, 90, 61, 1, 70, "ObjectName",
 CellID->11716],
Cell[3444, 93, 592, 18, 70, "Usage",
 CellID->22815]
}, Open  ]],
Cell[CellGroupData[{
Cell[4073, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4551, 133, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4674, 139, 890, 32, 70, "Notes",
 CellID->7229],
Cell[5567, 173, 731, 26, 70, "Notes",
 CellID->4466],
Cell[6301, 201, 416, 13, 70, "Notes",
 CellID->7783],
Cell[6720, 216, 277, 8, 70, "Notes",
 CellID->33352532],
Cell[7000, 226, 248, 7, 70, "Notes",
 CellID->31226],
Cell[7251, 235, 231, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7519, 247, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->336038571],
Cell[CellGroupData[{
Cell[7904, 261, 148, 5, 70, "ExampleSection",
 CellID->124052014],
Cell[8055, 268, 63, 1, 70, "ExampleText",
 CellID->10698211],
Cell[CellGroupData[{
Cell[8143, 273, 145, 4, 28, "Input",
 CellID->521805723],
Cell[8291, 279, 176, 5, 36, "Output",
 CellID->149044005]
}, Open  ]],
Cell[8482, 287, 124, 3, 70, "ExampleDelimiter",
 CellID->32819204],
Cell[CellGroupData[{
Cell[8631, 294, 258, 8, 28, "Input",
 CellID->269007598],
Cell[8892, 304, 2281, 41, 141, "Output",
 Evaluatable->False,
 CellID->29628069]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11222, 351, 220, 7, 70, "ExampleSection",
 CellID->595907968],
Cell[11445, 360, 79, 1, 70, "ExampleText",
 CellID->199544668],
Cell[CellGroupData[{
Cell[11549, 365, 140, 4, 70, "Input",
 CellID->4519485],
Cell[11692, 371, 168, 5, 36, "Output",
 CellID->112443470]
}, Open  ]],
Cell[11875, 379, 125, 3, 70, "ExampleDelimiter",
 CellID->414450367],
Cell[12003, 384, 70, 1, 70, "ExampleText",
 CellID->229407775],
Cell[CellGroupData[{
Cell[12098, 389, 225, 7, 70, "Input",
 CellID->98147342],
Cell[12326, 398, 235, 7, 36, "Output",
 CellID->893910589]
}, Open  ]],
Cell[12576, 408, 125, 3, 70, "ExampleDelimiter",
 CellID->112014002],
Cell[12704, 413, 113, 3, 70, "ExampleText",
 CellID->469443385],
Cell[CellGroupData[{
Cell[12842, 420, 167, 4, 70, "Input",
 CellID->242416311],
Cell[13012, 426, 219, 6, 36, "Output",
 CellID->605057716]
}, Open  ]],
Cell[13246, 435, 125, 3, 70, "ExampleDelimiter",
 CellID->456171245],
Cell[13374, 440, 202, 7, 70, "ExampleText",
 CellID->44351109],
Cell[CellGroupData[{
Cell[13601, 451, 194, 6, 70, "Input",
 CellID->404989654],
Cell[13798, 459, 393, 14, 52, "Output",
 CellID->265963008]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14240, 479, 243, 7, 70, "ExampleSection",
 CellID->797555279],
Cell[14486, 488, 240, 7, 70, "ExampleText",
 CellID->320645081],
Cell[CellGroupData[{
Cell[14751, 499, 263, 8, 70, "Input",
 CellID->144784533],
Cell[15017, 509, 302, 9, 36, "Output",
 CellID->9604484]
}, Open  ]],
Cell[15334, 521, 125, 3, 70, "ExampleDelimiter",
 CellID->266419500],
Cell[15462, 526, 84, 1, 70, "ExampleText",
 CellID->475818337],
Cell[CellGroupData[{
Cell[15571, 531, 202, 6, 70, "Input",
 CellID->41360215],
Cell[15776, 539, 176, 5, 36, "Output",
 CellID->366014708]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16001, 550, 225, 7, 70, "ExampleSection",
 CellID->5830171],
Cell[16229, 559, 138, 4, 70, "ExampleText",
 CellID->756557088],
Cell[16370, 565, 411, 13, 70, "Input",
 CellID->387945888],
Cell[16784, 580, 105, 2, 70, "ExampleText",
 CellID->638750397],
Cell[CellGroupData[{
Cell[16914, 586, 1382, 42, 70, "Input",
 CellID->99698504],
Cell[18299, 630, 3055, 54, 70, "Output",
 Evaluatable->False,
 CellID->101157915]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21403, 690, 237, 7, 70, "ExampleSection",
 CellID->265240994],
Cell[21643, 699, 367, 12, 70, "ExampleText",
 CellID->100339472],
Cell[CellGroupData[{
Cell[22035, 715, 147, 4, 70, "Input",
 CellID->143097721],
Cell[22185, 721, 175, 5, 36, "Output",
 CellID->197190382]
}, Open  ]],
Cell[CellGroupData[{
Cell[22397, 731, 137, 4, 70, "Input",
 CellID->445931233],
Cell[22537, 737, 162, 5, 36, "Output",
 CellID->647744872]
}, Open  ]],
Cell[22714, 745, 124, 3, 70, "ExampleDelimiter",
 CellID->74630012],
Cell[22841, 750, 75, 1, 70, "ExampleText",
 CellID->902743327],
Cell[CellGroupData[{
Cell[22941, 755, 418, 13, 70, "Input",
 CellID->347060710],
Cell[23362, 770, 453, 8, 70, "Message",
 CellID->323114252],
Cell[23818, 780, 614, 21, 43, "Output",
 CellID->498400834]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24481, 807, 229, 7, 70, "ExampleSection",
 CellID->57436899],
Cell[24713, 816, 368, 12, 70, "ExampleText",
 CellID->263677196],
Cell[CellGroupData[{
Cell[25106, 832, 167, 5, 70, "Input",
 CellID->36983623],
Cell[25276, 839, 234, 7, 36, "Output",
 CellID->140753287]
}, Open  ]],
Cell[25525, 849, 125, 3, 70, "ExampleDelimiter",
 CellID->720386025],
Cell[25653, 854, 547, 20, 70, "ExampleText",
 CellID->16761904],
Cell[CellGroupData[{
Cell[26225, 878, 245, 9, 70, "Input",
 CellID->210405011],
Cell[26473, 889, 229, 8, 52, "Output",
 CellID->499513516]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26763, 904, 311, 9, 70, "SeeAlsoSection",
 CellID->12444],
Cell[27077, 915, 1244, 44, 70, "SeeAlso",
 CellID->689]
}, Open  ]],
Cell[CellGroupData[{
Cell[28358, 964, 314, 9, 70, "TutorialsSection",
 CellID->17208],
Cell[28675, 975, 144, 3, 70, "Tutorials",
 CellID->32105]
}, Open  ]],
Cell[CellGroupData[{
Cell[28856, 983, 321, 9, 70, "RelatedLinksSection",
 CellID->29150],
Cell[29180, 994, 176, 4, 70, "RelatedLinks"],
Cell[29359, 1000, 208, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29604, 1009, 319, 9, 70, "MoreAboutSection",
 CellID->202348940],
Cell[29926, 1020, 165, 3, 70, "MoreAbout",
 CellID->283137099],
Cell[30094, 1025, 182, 3, 70, "MoreAbout",
 CellID->105217316],
Cell[30279, 1030, 145, 3, 70, "MoreAbout",
 CellID->631732128],
Cell[30427, 1035, 145, 3, 70, "MoreAbout",
 CellID->727653099]
}, Open  ]],
Cell[30587, 1041, 27, 0, 70, "History"],
Cell[30617, 1043, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

