(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    663376,      11891]
NotebookOptionsPosition[    654693,      11593]
NotebookOutlinePosition[    656342,      11637]
CellTagsIndexPosition[    656202,      11631]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobiCD" :> Documentation`HelpLookup["paclet:ref/JacobiCD"], 
          "InverseJacobiCN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiCN"], 
          "InverseJacobiCS" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiCS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobiCD\"\>", 
       2->"\<\"InverseJacobiCN\"\>", 
       3->"\<\"InverseJacobiCS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseJacobiCD", "ObjectName",
 CellID->988],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseJacobiCD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseJacobiCD"], "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["cd", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["cd", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{"cd", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->32446],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCD"]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[PlusMinus]", "1"}], ",", 
    RowBox[{
     RowBox[{"\[PlusMinus]", "1"}], "/", 
     SqrtBox["m"]}]}], TraditionalForm]], "InlineMath"],
 "and infinity, and in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", 
    RowBox[{"-", "2"}]], TraditionalForm]], "InlineMath"],
 " and infinity."
}], "Notes",
 CellID->25303923],

Cell["\<\
The inverse Jacobi elliptic functions are related to elliptic integrals. \
\>", "Notes",
 CellID->20947],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseJacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCD"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->1284425],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCD"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCD"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17159630],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->51027777],

Cell["Evaluate numerically:", "ExampleText",
 CellID->156488630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCD", "[", 
  RowBox[{"0.3", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25804197],

Cell[BoxData["1.5470197468056177`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392896191]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{"%", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75588654],

Cell[BoxData["0.3000000000000001`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->353590317]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->306083438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->592668477],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10963214]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->280795932],

Cell["Series expansions:", "ExampleText",
 CellID->511351488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493847220],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"EllipticK", "[", "m", "]"}], "-", "z", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "6"]}], "-", 
      FractionBox["m", "6"]}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "40"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"2", " ", "m"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "6"],
    SeriesData[$CellContext`z, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    EllipticK[$CellContext`m], -1, 0, Rational[-1, 6] + 
    Rational[-1, 6] $CellContext`m, 0, 
    Rational[1, 40] (-3 - 2 $CellContext`m - 3 $CellContext`m^2)}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{382, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266489420]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183899751],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcCos", "[", "z", "]"}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["z", "2"]}]]}], "+", 
      RowBox[{"ArcCos", "[", "z", "]"}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcCos[$CellContext`z], 
    Rational[1, 4] ($CellContext`z (1 - $CellContext`z^2)^Rational[1, 2] + 
     ArcCos[$CellContext`z])}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{301, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11910797]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19903],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->55645938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCD", "[", 
  RowBox[{
   RowBox[{"0.2", "+", "I"}], ",", 
   RowBox[{"0.1", "-", 
    RowBox[{"0.3", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266251706],

Cell[BoxData[
 RowBox[{"1.4921507780315901`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.0183489578518048`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113815709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268824359],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->132691703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->866802414],

Cell[BoxData["1.\
3184519444959685987295829818048461230452813643687880783824714166194`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227359645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36479535],

Cell["\<\
The precision of the input tracks the precision of the output:\
\>", "ExampleText",
 CellID->579439215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCD", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "0.50000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->632752147],

Cell[BoxData["1.318451944495968598729582981804846123045279187131`30.\
8533580799589"], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267952482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->688497564],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCD"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->43876107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCD", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271543877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38191930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255377976],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->328717422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCD", "[", 
  RowBox[{"z", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617758456],

Cell[BoxData[
 RowBox[{"ArcCos", "[", "z", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153832064]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{"1", ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658205930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EllipticK", "[", "m", "]"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134200579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23210608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->471035179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseJacobiCD", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179888293],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["cd", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{59, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->81717893]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCD"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->120235099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], ",", "m"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->77454719],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"EllipticK", "[", "m", "]"}], "-", "x", "-", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["x", "3"]}], "6"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["m", "30"], "-", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["m", "2"]}], "40"]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["m", "315"]}], "+", 
      FractionBox[
       SuperscriptBox["m", "2"], "28"], "-", 
      FractionBox[
       RowBox[{"5", " ", 
        SuperscriptBox["m", "3"]}], "112"]}], ")"}], " ", 
    SuperscriptBox["x", "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 0, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    EllipticK[$CellContext`m], -1, 0, Rational[-1, 6] $CellContext`m, 0, 
    Rational[1, 30] $CellContext`m + Rational[-3, 40] $CellContext`m^2, 0, 
    Rational[-1, 315] $CellContext`m + Rational[1, 28] $CellContext`m^2 + 
    Rational[-5, 112] $CellContext`m^3}, 0, 9, 1],
  Editable->False]], "Output",
 ImageSize->{438, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46196308]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14269],

Cell["\<\
Plot contours of constant real and imaginary parts in the complex plane:\
\>", "ExampleText",
 CellID->147991225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"InverseJacobiCD", "[", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ",", 
        RowBox[{"1", "+", "I"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "24"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41283476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXWcVkX0/7fpRlGkQzoFae8jSHcqSEkqICgSKigiIC0p3SApKVIC8yAN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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{1641, 764, 413}, {5209, 5207, 1498}, {1858, 1697, 
           1234}, {5756, 5429, 483}, {6210, 6209, 2095}, {5816, 5818, 1844}, {
           4453, 6118, 764}, {1189, 2095, 1106}, {5424, 4174, 483}, {6347, 
           4965, 1234}, {1814, 1844, 1189}, {1815, 1887, 1344}, {1498, 1858, 
           1234}, {5882, 5691, 413}, {2329, 1637, 764}, {1887, 1697, 1344}, {
           2009, 1814, 1344}, {6569, 6568, 2329}, {5691, 4072, 413}, {1189, 
           1641, 413}, {6346, 6344, 2141}, {6209, 6893, 2095}, {2095, 1189, 
           413}, {7021, 7023, 2678}, {764, 1637, 413}, {1697, 2678, 1344}, {
           5785, 5784, 1815}, {5462, 5883, 1637}, {5823, 5820, 1845}, {1815, 
           1344, 1106}, {5179, 5854, 1106}, {4965, 5757, 1234}, {1814, 1189, 
           1106}, {4618, 5637, 1699}, {6047, 4007, 2009}, {1697, 2935, 
           1234}, {6688, 5209, 1498}, {4176, 7388, 2935}, {1344, 1814, 
           1106}, {5637, 5634, 1699}, {5636, 4618, 1699}, {4174, 6686, 483}, {
           6344, 6345, 2141}, {1845, 1641, 1189}, {4413, 5532, 1641}, {5176, 
           4453, 764}, {4456, 5176, 764}, {4405, 5462, 1637}, {5855, 5785, 
           1815}, {6892, 5179, 1106}, {5634, 5636, 1699}, {1498, 1234, 483}},
           VertexColors->None], 
          PolygonBox[{{4615, 7021, 2678, 1697}, {6043, 6047, 2009, 1344}, {
           5532, 4456, 764, 1641}, {7388, 6347, 1234, 2935}, {5782, 5816, 
           1844, 1814}, {5900, 5631, 1697, 1887}, {5852, 4615, 1697, 1858}, {
           6118, 6569, 2329, 764}, {6893, 6892, 1106, 2095}, {5820, 4413, 
           1641, 1845}, {5207, 5852, 1858, 1498}, {5466, 5823, 1845, 1189}, {
           5854, 5855, 1815, 1106}, {6686, 6688, 1498, 483}, {5883, 5882, 413,
            1637}, {6345, 5424, 483, 2141}, {5429, 6346, 2141, 483}, {5818, 
           5466, 1189, 1844}, {6568, 4405, 1637, 2329}, {7023, 6043, 1344, 
           2678}, {5757, 5756, 483, 1234}, {5631, 4176, 2935, 1697}, {4072, 
           6210, 2095, 413}, {4007, 5782, 1814, 2009}, {5784, 5900, 1887, 
           1815}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.33609582577421326`, 0.1316130906941191, 0.5894036582326326], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{6347, 7388, 2142}, {5424, 6345, 1620}, {6346, 5429, 
           1622}, {3591, 2142, 1369}, {4386, 5630, 1620}, {8042, 5054, 
           1369}, {5456, 5455, 1636}, {5055, 8042, 1369}, {3288, 1490, 
           1190}, {4964, 7042, 1857}, {1742, 1877, 1293}, {4617, 5171, 826}, {
           7065, 5930, 1293}, {5882, 5883, 1877}, {7041, 6001, 1046}, {4389, 
           6645, 1622}, {1857, 1369, 484}, {6210, 4072, 2096}, {2142, 3591, 
           1046}, {6936, 6937, 2609}, {2096, 1742, 1190}, {6114, 5230, 732}, {
           2659, 1742, 1293}, {1490, 2609, 1235}, {1369, 2142, 484}, {1636, 
           1293, 732}, {6797, 4389, 1622}, {8163, 8144, 3591}, {1795, 2607, 
           1046}, {2607, 2142, 1046}, {5230, 4406, 732}, {5455, 7066, 1636}, {
           1742, 2580, 1190}, {5630, 5425, 1620}, {6892, 6893, 2579}, {2610, 
           1857, 1235}, {6894, 6895, 2580}, {1490, 2579, 1190}, {7894, 7893, 
           3288}, {5631, 5900, 484}, {4176, 5631, 484}, {6999, 6998, 2659}, {
           6939, 6938, 2610}, {1235, 1857, 484}, {5425, 6343, 1620}, {5855, 
           5854, 1859}, {1622, 1795, 1046}, {5756, 5757, 1795}, {6001, 4815, 
           1046}, {5900, 5784, 484}, {5054, 8162, 1369}, {1859, 1490, 1235}, {
           4406, 5071, 732}, {4619, 6080, 826}, {4405, 6568, 732}, {6080, 
           4617, 826}},
           VertexColors->None], 
          PolygonBox[{{5757, 4965, 2607, 1795}, {5883, 5462, 1293, 1877}, {
           5467, 5824, 5823, 5466}, {5179, 6892, 2579, 1490}, {4616, 7022, 
           7021, 4615}, {5817, 5819, 5818, 5816}, {6044, 6048, 6047, 6043}, {
           6893, 6209, 1190, 2579}, {4414, 5533, 5532, 4413}, {6344, 6346, 
           1622, 826}, {4965, 6347, 2142, 2607}, {5638, 5635, 5634, 5637}, {
           5821, 4414, 4413, 5820}, {6935, 6939, 2610, 1235}, {6689, 5210, 
           5209, 6688}, {5819, 5467, 5466, 5818}, {7066, 7065, 1293, 1636}, {
           7042, 5055, 1369, 1857}, {4707, 6894, 2580, 1742}, {7893, 4045, 
           1490, 3288}, {5429, 5756, 1795, 1622}, {5824, 5821, 5820, 5823}, {
           8144, 7041, 1046, 3591}, {4457, 5177, 5176, 4456}, {5930, 6999, 
           2659, 1293}, {4008, 5783, 5782, 4007}, {5533, 4457, 4456, 5532}, {
           4175, 6687, 6686, 4174}, {5691, 5882, 1877, 1742}, {6645, 4619, 
           826, 1622}, {4454, 6119, 6118, 4453}, {5071, 5456, 1636, 732}, {
           5854, 5179, 1490, 1859}, {6687, 6689, 6688, 6686}, {4618, 5636, 
           1620, 826}, {4072, 5691, 1742, 2096}, {5783, 5817, 5816, 5782}, {
           6345, 6344, 826, 1620}, {6937, 6935, 1235, 2609}, {5853, 4616, 
           4615, 5852}, {4815, 6797, 1622, 1046}, {7024, 6044, 6043, 7023}, {
           4045, 6936, 2609, 1490}, {5785, 5855, 1859, 1235}, {7022, 7024, 
           7023, 7021}, {6938, 4964, 1857, 2610}, {5177, 4454, 4453, 5176}, {
           5208, 5853, 5852, 5207}, {7388, 4176, 484, 2142}, {6048, 4008, 
           4007, 6047}, {6209, 6210, 2096, 1190}, {6895, 6891, 1190, 2580}, {
           6119, 6570, 6569, 6118}, {6891, 7894, 3288, 1190}, {5462, 4405, 
           732, 1293}, {5784, 5785, 1235, 484}, {8162, 8163, 3591, 1369}, {
           6998, 4707, 1742, 2659}, {5210, 5208, 5207, 5209}},
           VertexColors->None], 
          PolygonBox[{{6570, 6114, 732, 6568, 6569}, {6343, 4175, 4174, 5424, 
           1620}, {5171, 5638, 5637, 4618, 826}, {5635, 4386, 1620, 5636, 
           5634}},
           VertexColors->None]}]}, 
       {RGBColor[0.367824155852017, 0.1867800879878904, 0.634001664428567], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUztoVEEUvbvPzOZt0PWtu3mbHTBskkoMRFzCBvHTCBaCEMEPJgoqBC0S
IanSRYX4wVqMH4JgsJVUIrp22ixqEa1stNuVRAtFQcVzOAMWl3nvzp1zzzlz
p3Z2Znw6a2anERFiMW/WQazmzK5hvY54t8msndf/D9Q0nL6ZbxXM1rabLWTM
fpewmZjVnTAWQ/1sn9lO5H92my2Vze4irqCmuc3sslePBaxv+3Xmaa/ZbUQD
mMeR35GazYHPADAi5F+B8B3klxCPUL+M/XuID6j5DIxPiJtbzGpVs37ERGw2
in5F1K5A5CFg1BLhEJd8mW851fG7p2j2Hbz3xdJKzdTyLafca5y9Cu3DZeVP
YX0G3CnUDQN7Dmd/Qa9DjDn5k0U+UxYWcwdy8vAGckexNx84joZ6cqO+88Dv
Bp+PwB+LpGcCuOORcEbyquf5M071Kbzp89r7WkECZx9i7w96OWAtsw7+V704
kNdMKm4ZcPlbEo+TyO9JpOsF9NaRb3Vpj9rYl7NCrfRkHb02KuK2H2d3JeLE
qAduF5C7H2bg4GbdPz0mV+ohnxp6TRZUP5joznhf58D9mNcddbB+QXT1gAv2
dwdujFmnes4E9zlL7zGnnao8fhKLNzlzVjmbq2EW6Dv7rlfVj71u4ftNUec4
m48LwuQdNtz/N0I91EKv12Ld14NUPtLDiteboW/kshH47MX+SsCkdzzPs1nk
o0S+cMYveWnyXndMz45shdaKZmIAeIOIyVjzcqIkHL6HdniTjHZ4m5yLTJgN
etAJefrQCm+BOtiTOIfB5WJZ/rIf+5DvtNeMsuZlr94D9Q6h/nkqn5tYmwW9
oX9dxZiL
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtk71rk3EQx79JbDQtWp8kT0zygCGtLmJBsWhT6MviJlQrqEiLIMWCQ1Jp
J7eKICr+AQpKESyikziJNHFSl9I6VAe3dlB8q4KKohY/xz3Dwf1+9723791V
zzZG60lJw8gmpLFDutwp/UTvS0v9BSkRSAfRF5HP2JOhVENPb5EWeLeQb5ul
lwTaD/ZvXurFfgY5EUknkRns8ynpR0naHTh2MCNtEKuL9wvec+CXstIF4j0G
/yjj2Btl183nPPjuGD8NPgP+WZx/AMxxbEOh576I9FLLkcCxi23SFLXUkRq1
vMGnjB4h+9qlVxAwCfY98d4h59Dn4eIO+iT+fQlpDb1BzDqyin4L3xHyTcDX
PWI8LDnGbA/QP2EfCN23rUNq5uihIh3eKn0Av4y+hlzfJl3hfRu/j5Fjrb71
ovQVuUv+0ZT7tohxtd1jnKKO03m3WU9W2yGbV+A1Wi9Wk9ViPe3lfyrm9xfz
m+F/VzyP37y74fpL0eONZzzWMvmWch6zBR/fS861cd5kP4b4H0QW0P9kvQer
fQXMyk7pNZKl3lk4uI//XGw3Ti7R60TOubeeDuR9phbf5rVu9ZR9dyxGf95n
ZLOpob8lZzLwXR0m5jjxr4U+e5tJFdu/0HfLduY5vXWVvbcx+i2Rvxh5bbYD
qxWfkc3GZlIBO7LdsWMZ37WOrO+u9W9c9gTOnXFqXB0j39HQObPZVMvua5xu
5P2G7HbspmzXZyOfvfmn6Cdd8N6t3lTgPVpvdnPGfbPT7cZRIubcuLYd6SHv
dMlnazf8FPuTgnNtO7yHfDcj31W7SQV+43bbdrP/AeS2lCE=
           "],
           VertexColors->None], 
          PolygonBox[{{4614, 5426, 5425, 5630, 1696}, {5531, 5178, 5177, 4457,
            1667}, {4411, 5822, 5821, 5824, 1639}, {5426, 6342, 2140, 6343, 
           5425}, {4415, 5530, 1667, 5533, 4414}, {5457, 3873, 100, 5455, 
           5456}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3995524859298207, 0.24194708528166164`, 0.6785996706245012], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVD1MU1EY/ShaCgzPV/r62ldNRIRBRANC1PoDk4sOCDJIMBKjDpqISRnQ
xcXNxeimURNtWHQgDjqoRZdGTcTIAsQY2IhRWjQuRlDPybnDzbvv+znf+c79
7m0+MzZwKWZmE1i1WM8is+dYc/VmRTgWsbpqzG4HZntTZp82miUSZvm42RJ8
pbTZAd/sC/YfQ7OmzWbrdWatGbMjyPkJ+0OsBYczjNjFUPYp5J7OmV2F/RBi
v2M/Ehf2FOoHG8weYN8PYvuw7iCm19VadLjEXEGtw/Cdimv1I68Bvh7Y15Jm
x/Hfhby2lHiwj5uBemF8UKecGsTk08Jlb0WHT4yRQDj/ENuDnDn47qOPSc9s
Hrayp37YyxrwO33FsB9qydwqdJuNKYZ8233Vj+H7Oa1636DBvVB8yPG9J555
YN51nKkBdacOK4j9m5IeJcT+ypoVgD8A3Kd10vAd7CmcS3ujuPNLHaj9iUh8
VqFVFesKOPahzg7sR502I07TR8DZH0iTFnC4gP0QfKuIuVavumeh1WCk/3X4
mxE3iJgh2EqhYtnfn6QwrwNzLBTXNtiepHTeL2H7gJwyeHYA43Io7Vi/kBIH
/rNPxnBeKgn1W4AGHYF8rFOTVq1jwOlG7lfEl9FfV6C5WsN3S6RZ68V+EHE/
YvLHk4phD/RzT9+om4FcJN7kPO+04lnvQe7vSPpw1jk3jN8WqTZxeBYLbo5j
gc6S57gMjq896ZlGbC6jmufQ1/ms+qw24ewcT/ZMG3Xg3aMu3G/N6CzJlVow
ruy4k9Ocm3PeN87eTKQ7TAzOY60v+2PwubhJd4o55E3OFeC3IGfCvQfEZ/wb
YBz1pfNSqLvHPjux3xVIS87ptOuR+dSP+Lx/5gufs0gf7TcQ/9aTjuw77TSZ
BuYrN1fj4Nnnqye+MSd99cl3aNjtySuRETeeT7ebYdoanH13IK7kOes05R15
EWouqSHrVELVOoj9rUD3sQiek1gZzGMV/hlP7yX7Yy8899ak5oa27cgdz+pt
4Izv9FWT/dDGuo0ZzRN5/ge03c0f
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtk01sTGEUhs/MMEa7GFfvdeeHxLRq0SohbTRFbCwsLNqpLpq0jYifhMRI
2gU2NlZqRWxISGhs2oVYsBAtmwaJRm1qFqIJCQ2mZd3ieXNmcXK/7zu/73ve
WzpZKV9ImtkRbB02ljfrCMw+8LicMUts4RFr4N5LwO7IbBW7nzbrx5q2ms1m
za4kzNY2mKU3843c150ym47NTvF2daPZCv6z1O4JzebXm+V4SxCb5G2C+hH1
O7mfJ75K/gD2l9gE/gf4P2M38d+KPP8T95aCWXPBe11i3n7O38gZTXjPKfB8
ZYYv2CTnFLk3iHmMr4f6a8S+Yf72RrMu7jOcZ2KfVTW2EdvKPL0pxzxI/j38
H/H3MW+ZezM5JayP8zPiu3LuW6BHG+dW7A+zniA/BZZk5FiE+R3xcwXnbjbp
2PfU+RMH3cTPN5m9x/Zz/lk0+1H0XQzh38XbKLjKad+ZZhnBhuszteO/zf4i
6g8T08b9acFnU/5c1jkRFxn4q8S+E+3iiTiAnzFskdr74OMt8RN53512IG2s
gO9yxjXyOuucist/5B/F3xL4LoVnL+fD1P9N7ELSsYlDcSeML+i/I3DtaQed
1JrO+i6WpEl61XK+a/WsEb8c++ya8WLonImrSujYhVlYxcEQfQ4Grh3tSFo4
DZ5axjUh7saJuR45h0bsauizSoOPeDsUeT1poBQ4xmr9f5gidjKs/y9oZhD/
eN65kAaWYtektPidcwe1rmWda+3wQOAa02yasQjW7TnXjjjbSe2HWd9FVXrZ
ZPYr57tVT2ldHAi7NH+XWncir6V9neN8LHAutZPj4B8oONf6h19S+1XsfnF+
hjmfx65NcRTyvy/G3lv/TAO9G3NeSzn/ATFrmJ4=
           "],
           VertexColors->None], 
          PolygonBox[{{6566, 6121, 6120, 4455, 2328}, {5515, 5103, 753, 4435, 
           5514}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.43128081600762436`, 0.2971140825754329, 0.7231976768204356], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVElsjVEY/fravtf/dfg7vKHvvao0tJpWa2NIxBA7GwuUKhZUiSFIkNTQ
NmpDkUgrjUSKhQWCVGJaUEFDWLQpCYpKWIiNVkJjQQ3n5FyxuPnvf+83nO98
535ljTuX7QiY2TmsdKz6LLPqsFluhll7zOyVb3YkzexL3GwMK4T7PRGz3Vgf
M81mRM22FZpdh3Mcd7Es2f/GN4B1HsEX58MHsT7g/Cq+/YjZjP2YZ/Y9JJuB
gPY85/26mPbZxWbhYsU+AkxjsNmF8w7sR7E/lCY/+jNOeZHZgpju5+Pb58s+
HTgHfdnfT5ltwv456jyaoZri8H2A+u7j/CviBT19n+K8NazcjHMPvhWw6Ubt
x5OKy5gjOJuLfRf2s4E3VQIsiLswV/70JV8NQWHtTMAfKwd5+jPFF/EzD+0P
4/sHHBtizoHPfmCrKBAe9oZntK8OyYf2xxCvATbZnmzIfxvyVuGsG1wMBXSX
5s75Nbevd3v2aNwTz4z7Cxie+LJpTEkT7C810htSnjWIPwy7ccRP81Qn+eQ9
cdJmFXxPoTdN8NuIvVcsrbz0xBN549mGlM7z3Dkx1yDO6Uz16lu6uGf8LeBm
OrDtNvWQ9+xFE/R4D3xdhG0fYt7FWoX79cB+s1AxyNtAjlkZYjUj576UeKem
Olyv3wHvr9j/3PzybirOH5aK8xpfdrzbjpytvuoehDYGkuKSunjrq8YW8LE5
KK7uwH5TQjnP474iIi1QH/yyv+zDqNN822SzOvj04H8pahjKFD+sgWes9xHi
zI7ojv0k9+xdrS//Hlc36yf+Vtj24n0uQZzL2F+h5oBvBDVdc+crUEcd1kFP
dbyJqBbOhuFS6YG83k397w97Rs6Ik/EY5wWwtySEayKmt0o+qYmWkGbIraT0
yrp6sX8WlSaf+tIiazmDPGexLsCvOUvxmedSUHVzPws9v52UhtirKUWql7Zr
POEpB+ZJsFnt5lBltmYOtVLv3sJj5C3CW67KVv3kmjwTL/NTe+bsybUP2/wS
xSLH9OM72puSboiBPPU5rraGZce4n1DfcuCpBMYm9OpGkeYH51SPs+Hb4Gzi
HKDm+d74FuaBs7VRaWskojdJjX1GDzcnFJNzemZUPNcjz0qsdviXIP6ksM45
82jL+J2wPYF1IKh3zHlNTbInnOnkZxEw/kzKP+A4oA3n3D8td7v3Q5xxN+vJ
M3MzF/kkVmKnrqg76pI9eo3e/UgK40nO16je0Cj6uy1f/edcbEoJM/N0uDnA
mVfttMSeN7i+b0xodtOGPWUPyG0e7HNj0tEE8tRG1d/mhLTIet9Dw5ES1Uq8
nF9dbrYPuPqoQc4v5mVO6otx2O+4q31agWY6Mf8F4YL+gA==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuIVWUYhr896cyeGXXNzF6z1z6Mh0lmEncanTShTG/qIrpIx3RMtKYx
7GwpTNEY1U2GXpQRQVQ3lZ0Ui6IudEyJJAvNhMJkoIIkihyjJKimw/PyrosP
/vX/73d6v8PqHbp/xX1NEbEZmYKs6ozIKhFlZIDz69WIn7OIn5DdnJdwd7IU
8SVyFedecMu7I5Yhczhfxt13YJuKEf8ie9KI/q6IW1ox3sw7by/VsdsWMdoS
MQj+W+4KYNvBvFa1T/l6FXkfPyPgt4G/dnrEOvCL8NMHfgb4sSRieLbfHixE
3N0R8XZqXyNglhLX2YrPN10QcQc2NyJPgD2L/yJvN2CzGVtlMKWeiC+IZztk
zG8Hj/2FyItgTxLD4VkRHxFP79SIY9MiDoDdn9nWBPIwbw8hT05xzD21iHFy
uBGSB/FxGuxXSBSd8waw75QjGujeBX4TsV1EPEfBz2s2d/WadcXhEXQTYpxH
bH+gczv6Q8j2guOf4H0Z+gWwLUXnchz9863OaRu5/Ac/i7G9D/395D9EfA18
rwZ/iPcfU/v+jfc6vsa521Uw5/2pa6zafgwHAb+z0Z9otc3nS66xajuMzSt4
/xP/PZzfg/9T8PfNLH8r5pm8TYLZgqm12JgOF5/g7wS238TeQt4uze0Js7Nq
DsXdtFb3ag9Sz3v24sSciy/hj9VcI9VGHKjWhzPnppq/RT4zyval/ugg3718
jxTM8T3wv6buXBT/ryXPiGbjHOd3wS7A5wvEu6DFsWgm5uQxLcb+s+Qwiv3z
Ta71kcS9pZr3g7me9+uQvoq5VI1VW3H6KdgdVc/Go8S0DtwkMX3N9yZsnsL+
M9w9kts/zfd46rNqNoruCPJ9wT33d805KZeZba79vZl7QT2wBFuvJK7tIDZX
8j2X7wuRFZyXEv81Zc/aU/RTf5JzgP5z6OwCc3WnY1POL8PdnXl9NfPqza3E
d2aqe1S7RD5kWzvlgdQ7RrtlM+cN2N/J2w5kfeJYdLc+j0m7pwFv8yveQU93
m3PlL04and4Bqu0J7s5k9iHbP2TebXvhZ0/VO07cXpnvF3Gs2evrcm+qpw6C
WcXdY5zfwOZfnJeXzKV6OqV/jiaulXbgGPkfrJub38E30F+NzuO5/j9wN1k2
l+qhrZzH8L+m6JopN/VIX57jotQ7ULtPM3Ir+NvKtq2ePVDxTGuWZWNL6pqq
luJcuYoD5a6cBzLHpFi04z4ktg9q5kociHv1vHpdNThObucy7xbt0Mu5a8df
VvQ8D5Prxrp3kXaYdvvaTs+qZla7QDrCii/N9iXd7kfNeFvFO1n6svl54n+C
/gWfcV6J/nCX49WOGqh5h2p3qib7OjzTqrd27s28/9JhrDjX7j5U9y7XDp9b
8k7XLtfO/h8treyI
           "],
           VertexColors->None], 
          PolygonBox[{{5447, 6545, 2316, 4442, 5446}, {5519, 4043, 4042, 5520,
            1659}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4630091460854281, 0.35228107986920426`, 0.7677956830163699], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlm9olWUYxu+5szN3drZzcmc72znHmUVNSwsXrGAV2Zc+9GcQYSoWpdMK
/AM1KQNXOTP8VH0qgyKhECoLoT5ETY2ywKnTyPyT0CcLTEsTZ6Syrh/XE354
eJ/3ee7nfq77uu77ft+ZS9c8vHpKRBzWqNe43BFxRWNBY8TC5ohFGt/URSxt
i/iqM2J/Ru/dEdfr/VAuolZvu7M6u7EW8arGYr0/JNsHNe6YGvFuNaK3HFFs
iNip+ajGQZ19Xs/P5WdA60/qzic0/szKRufWaj6p+Sd6fqzR0+i9i3puFIYp
uqess0Oa36D9atE4wbs4YcYe27+FcVOXsGlkmiLGsz63Teu3C9+xfMTvIuEe
+TvS7fcNGceFnz+E77LuXVdne+LYqvlO2Z7RvbPlb7/iO1C23W6t761EnNZd
fYplyTURF+T/kvZamjwn5r/0Ppwxr18nbk/Kx3Zw6p5Ojaxs3tD6bGGbqHh+
PO+9TzPGOVNczqvz87o0H5B9rup37u8r+V74mNXoc+BhjbhOaP+4xrVZ891a
M+dnmvxcL/tvu40DDGBFn3zG3DdXzdUrefMO5zvk58ZCxHLlxh49Wzp810/T
In6sOLYleq7S+xf15uJg1rqc173DOfM0Q3dGe8SI9kutOg9+4T4kf99NM4bn
MtaVs3dqPVPz+wvCta5qX/BD3OBcrrVBjdVa263nrqrzeVmL9QTPEd19Ku8c
J2+2NDhP0J88YA6XI0mHF8XDcMn5MtngJ/Gi+eKsuYbLlzLmE51Pla31pM6t
L7iOqBn8k2PEujXveHvE/zydGdVeg+I+p3m/fLc2OH5iJyf60lk0ght83qx7
HtFYK3+V6RF14qdL+T2n0ec5O6b7XxfPL+vs4UbfTS7B8Vj7VZ6xR1PigKsh
za8IW3vRnK3JWdtbNb+gs+93Owa4HWyxPb7JEfzPEZa5Gv3NzgGw3FbnOFgj
lpryZE7BGoxLq67p5uReab2r2/bgQyvizcvf9DZjzM2IeKBkbAeE7YdmxzFf
+/9WzBm89iZu4QUb/JMHrG2eYjzYkv88qUHmN7W5NpjTf+gb4PhSMZ5LZ9G/
t9k5MJ5znRA/93QlPDOy1hP+T4rLYyWvnVDc1ZrPk4+Lkn+0hFMw9qjGn+7y
feuk82sF3/+UuFpRtSbk9wHubXJ//Tn12C2yf7tszdmn9rCZLZ/97caOzsuS
dvU191966DPaf0/+n806l7el3gXv+CDP6f1vtbluNgnXr7KfyPlMMdUUdU8u
oj0D32iKj/PJz9yCewq5V2l2fcMbmvJkfa/270taH89aJ/KnmN6ZL9X9yzRW
6dxK5eelivfIWdbIW3r3mXQvvIGD2PFNruMfXPQnbB6Tj8c1Nmvtwy7XEjpe
1Nr9nc4dcpeYiRc+sUW77cJcrLmX7BDnezqs76MV1y06U6+RanZU/oaSdifa
XBv4pnZOJ8ztre6VcMOZSsoxvpnvlM1vq3x8VHKvoi7Rl7velKZHU+5xHj/U
ArafFW3/i+a/Ff29WFX2/wH9Zn6Ha/J/7cgDeGupuSZ557uH3sMJJ/VALXxf
dq+nny6sWht0YR8c6Mu8PcUFVvijvug91Dm6gBcbfA5qbbTgO49Jt6Pd/n5+
UDBWcP4j/ho6rQs5uCD1RL4NZ6c6H3hOpNwYSFzD8y3ys6LgGPmnGU846QEb
Uu/dp7jGyv7esjaS1vOKsanq7xK6DaecL9TMBXanFdeCimOkVxA3WhAb33L6
J98u/snIU/pqqfXq/oZkw3/TrPTvdJfivrvDGuwT9pUl5+p/kS5miA==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlslVUUhU/pYG8H7qW9Y/8OFkorWiSiqQpqxBcxjlGssyIW0MRCJJi2
xFYRiyGBKMaImGgk0fgigok8GCkihhemUgRKB+OTmghoGwMYwdRvZd2Hnf/s
/+yz9zprD6dx2eqHV00LIfQjRciJmhCurQ7hXZSSq0J4iPWG2hCeKA/hjwr2
UyHckwhhMTLEuh37x5BXsd2Eo5eTIZzN4Ks0hDcKfPYt5Mly+1iaDuHHeAiX
sP+zJIQm/HdHIfSVhfB3LIRt6I+jj7KXKA7hvqQxKPYwehG+CpG14BvE5jw4
niH+Js7OQV+P/2Wc7ywz/tPoQ0gF9lPsf5EL4fOcsQnjgXpjUOxjxFgC9r6G
EDoqfaeP0D8D740FjnmRWJeQtlJzdH8WjMjN6Lcgz7L3NLKn0Jimg7USeR3b
FvxVgmU6MsVdevD5If63ISfZO4V8ALY5M+ALrJWcHwbfP/j7HW5HwJfAVxzZ
gL9rsJ/L+gD+duBrIfzOY709Y1838G8A7Lfz7zj+/uLfGfwN8y8L1lH8jcBv
cRVnidWAzW74HIeP7eArQH+HHG9NeU+cvQC3Me47r9gcx9AfxH4m60ZkNusr
xGsnVivyPfH2I+di5nAxvt7jjluRu1l3g7UH+TZfP7m6EGqQHHd5E30BNuPg
nV9uTlZybiP6RWJNcIdu9N3wswvpYt0Od1nwZZBHZ5ibB7LOjThq5t+6fDyd
X4D+E5hPILeyfjvuGNqTzTFsq1LO1RX0AN/fYVNTboyT1Y6pWBOsW7K+o+7W
zHpN0jHk+5WkuVsOZ6vKzOGncDMY+a47yEcd+zORRqQWOU38XvC8hpzK+K7q
QfWe7lyMzUb2imKuEdXShSr7Uk2Ji7q8L3HSD/7ZcPJDgXvyMH6+BlttoXtE
vbkz7dpSjx7OuCZVi5fRy8FaETnX8rGX9R7irSfeIP/2EmMg6147ir9DYKyH
l/Mx18D8nHOuXA/AcR+cHM2Y27PwsQJ/J6vcu6vxV8fZffXubfXQrGr3rHp1
iP2OyDlVvsTplpRzolxsZt2F75WRfYnvpXHbaO851meI/xTne0tc46qNFvTJ
fP5VG0uwfSTlGlnI9ybu11Tqerwj7ZpXravHepPuIfWO7qNa34Jszte8ZsWd
1e5lzYyByByKu+NIRH7asLkwzTV/F/Fa0a9DFrG+DJ+LOP9VkWdkD2e71IPF
nqHKxfNpz1blRLV6W9qzUjU7CYYjcfeyer6Z9b7IsZcHz77r+bc2eAY2xc2Z
uJqFtCIvgWNNiWfEv+AZqfcsEaZvwNbR4FkjTCuw3x85V/I5xv7OpPnR+VHW
Y3HzeTX/XgTfuYTrQznQrNJMVz1oZh1kfSjtt0A128b5g3H3pzjr5P4t9a4t
zeCfiTc37rtN58xYxj2lXhpFfiPW+ynnX/H/S/uMbDXDfolcQ6odzRxh1UxS
7oX5E/Y/jvxWiRP1rnKmXKmHVStjSfuWfX/OHOju6lnV3nh+XxjUK1+m/Vao
ZzR7jmTce7qjsP6acK3KXrXZlM+NajQgU/ibCH4jNDs0I7vyM0S1pBnVnK+p
e5HWWr8detN68dOZce/Kx66Ea1q1rDdLtTyW5041XRb5zdFbozdAuV2XsL1y
/D8QhCZf
           "],
           VertexColors->None], 
          PolygonBox[{{4169, 6334, 1791, 5748, 4168}, {6123, 5234, 5233, 6117,
            2052}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.49473747616323177`, 0.4074480771629755, 0.8123936892123041], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtV1lslFUUvjLttJ2l03b+Wf9/ZiQIFQOopFCgJGCilB0kLBpQQUnxAWSJ
QSvEIAhFTUXRqPjkA6hs8UkltNJCgCiLDaAQJSokBaNGSSEsLg9+X7/zcPPf
Offcs37n3DMDn14557kBzrn6u5wL4ft7uXNnQPCxvqlz7sG0c9Vlzt3E/v2M
c1Oxjxedq8NqjjlXifPPEs5NwP0izpqqnevE3YlR7f+BzJ1x58Zivx/nzxSc
21rrXATKJiadm54VfWbJudlYQ8G7KO/ck1hbq5zbFIAOvq/A8zrkDobcfyFz
SqVzl6A/DzlNuFMFemtEi3vaQ1n3xqXrCcj7s0YyaNuBCud2gyfAvoDVgr0f
kZ1t2M8pySbKGA76wLBzm3G3CPv/gpw3BojWGBL9TfDMgD27Q7Lxstn5k+fc
xUC89IExey0kGeMKkrMaeo7Bx1lx2eNjTQPvz57u824zziZhXbAYj7c4j4Ef
+0Dbi/VQVHT61wh7phj/uynnrtbIzr3QfToqvSXov7ug34/Dhu2woSGuM/rw
POIwBN962zcAGy1Y8+FXO/JWU6M89ID/Ydh40ymu1M+8z8N3PlYX7g6CPQuw
74Q958FzNCYfmUPyMY8vAF+/+M59ifOOMunaAXp5lXBJTNJHymfueiGzq1r4
pN88Y0xyoPdA7h3cexb47EuI/9dKYZQ8bfB3As7OwO7uasnpg80T0zoj/RXk
bWMgH+ZGZSd96YA8FwgzzOUuiwmxQ6wTP4zfEIvbyZj2xN4YxPsLT9hIwZ4R
UfHHIa86UKwZ57mma3xa+qhrPe6t8xQLxos81EvcUo5XqZgSPy1O38CwzXgH
hivGzTd6BfIYzsqWEPSXBaoH5ou5Yh7mmf/USfwQH/SLuGOsWWujYdOouPrI
ceCozVdNjCqXP/RlDWz/Aznuxe9e9I//8soFbaFNtPklYGq/p1y/CN6ROWGK
/tFPxuoGzoZFhGfK+DwjOe0R6WQN0pYGs4exH2zxHwS77vFVH3dw90JRcilv
uMk8UKXzC4arJqupKxGzEzInwMf6lOpuG/S8FVfvORtWjGkD/biYlC+sXfIR
k3Ww9wjoSyskj3KJvaNhxZuY34DvnpDinIqLRl8YT8aa+x748RHsvxpRfhoM
h+RtMB7KvmrySRtl9Mkx4Zb4/Ri2fJKU3ADyMkWdsyZ67e7CsGqctd4IDI8t
qMexL01mzy5Tn2W//ZR1UateTxrzRzprkN+htj8M+WnsE7hbD50r8MbMtrpt
NVx9HZX99OM2MPpIWO/TZcspsfgObG9EzWYgq9P6LP3qQ3yu+3oPQuC55svO
bujqwjoFXTHQor7wfrBCGGFt0q6M2bYCeVxbI9wyJqSx5zDP7YY39u52w/A2
69XURQxxX7Bvs9FZN/STPmZhu+cLg1OMh/e6YfPykuI7ybBDOfz+bfv7wHM2
r99jUbtXiuqDh/AtJNV76EvKaoHY4J453YDe4qVUUxvRYzIl9XDWTdr4Ge+F
lvfvkJ8WX3r5hj9aUn7Jy1ymrA62mY/83W19lT2dvZd3Oy0/xGr/mxAWrX+F
ddaaUf0TO5w5WBu0nX2dvjIGFTgPYy0y2dTBd+d++BXxdYc1xl7OHC1GL3kq
p3eAdcv+xfjz/mirjfWQty4jLPwW03tNPO3ISC5llmO/Kq2edhr7lz1hknpY
s9R1CvHsg65y6JpV0jtEzJ8Cf11KcR0M2uZAPrOn36qUnC24uywnX3aklBvm
hX2PeeD+XFi9hvpmon8fSWsW4NuyJCcMr8R3VU5y2cMYI8pc5uutZbzY64g1
nh2qVD5Zv/RlbYXks2aZB9JvQN51rPG4dwJ4OJ9UPZRj/4OneYg9g/XBWliZ
VrwYq1cDzXOMJ+uc8x1l0g/OBKwnxp101iHnzQ9s5vwR945lJZ+xaUvIl9qM
5lTq+z6p39wTj92GyaaCehZ7xizwVPnqs2sgZ3VOfaXD8EdMDoOuaVnhIx9R
rfbvISNXUE/iTDrdky9dpithM0uHyWGPP1cSBpmTrQnlhf4dtHhyZuR5P2Zi
yit7P2cJvkucjccFqm3WddF6CutoCWQvLmn+Zf6HB8LAbfSDW3nZzp5ywzBD
WTwn9g8DV8ex3oa+EZ7eM9LZaxlv1ux7sPlkRphbAN7HsFrC8rHBZrOhteLr
sfd3muV9qr1jfdYPW63fcWbcntXcuA82F5Pyl3hirTC/jOVhi2cU8mtTentY
N99mVDt8u2g7Z5I9NpfwrbyUVq9n/2mAnqaU/N9lMxPzwjd5c07vMmcmzpfc
sy+wHhjjISn1R/bGncjbhxlhlHMIZyXeuwZflhZUN/TjRF6+XKnRzM1ZgjW0
12zkf50Z9n/nAcgemVasiAXKIB44P+63eZ6yzlmNc25a7ukNuujJN/q1hT0m
K3s2JdQvmGveOWt9739yksuR
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmIlWUUxl+d1TtzHZ27zTd3mcxlMrRSckkFtQVnLNMklchKS/SP3KlB
08QWt2Ki1D9aIApsQ6MFIilzIUdiZkycsZFSykBtobBR1BaKfg/P/ePhvt/3
nfeszznnDnp4xezlfUMIr4NS0JkK4eOBIXwEOjhXZUPIDghhXlUIg2MhrI34
Vh/Ch2AN51XpECoyIcyvCGFMWQg7ePcCaAXbwcIantHTChZw3grWI/8Z8v9g
r7shhCnoOF4ewiLeXZMPoQCex6mj2Pw2GcI57G/ieVxJCK8hPwxdW/qEsCse
wgT8XI3MWWwvRsdudO0BGwnmMWTWYesC9/dX2mYZ9+OFEKZVh/ALaKt1zIr1
MOcl+Hcj2I2tFuS7eT+d+82gi3MtdyvBthLr2Ex+jiSIkdy0gonIDMenY/h7
CUxSDnm+Hd/uByeQncO7e0E35xZ8PQl6wOPgzroQrpLbenTtIYaHyOFOnvf2
C+EnYniTWFuRaeZcjw8zON8NxuPr+8ivTLsmqsUB4j9N/CdBDzgFMsRfB0ag
/zL5D7kQ+oBzPC/uY9kN2Hwy8p15+B6hvw7M5Vw90DEpljvAkZR9ki8v8dzB
nc6MvykHo/DlJrAYU/3xrzlljogbTZz/IH8L8WcitVyLD7fxbiS2RoBbU+aa
aqDci3On8PW7nLkwqNy+ipNrij6Lq0Oxt6/cnN2E7LPgi1K/WxU5Bvl3lRxe
wP5O7L+I/fnIXOS5kvuTyUU/7vfjuTpr7n/O96+J7Sg43tc6VJvBfB8Xc42S
+FmB76lKc3Ql9pZHlr/Cu9GqD/Zmxp2Tn+HAoZRz9xY1WwT3t+FfrMScXQYn
52NjK7pnwbcCugeDa0Ee3EXuYw3msmIs510pSFbah2FwtTbj3pqBTCm5mJR2
rfPKD75tjiyfxcfGlHtMvbUbfb9xd1mxv8qQmYG/G9Exh7tn0PeqOMW7w5x7
sDE57R5S76inm7j7Hz78q57j/Aa/l4lpOrrPk7Mveb6e+38R3zF0nKd+p5Lu
HfX8xYQ5KO71ci7H3tv8ji3zzFFuV0eupXI8Hbn13P9V/qLzE+QXRO6dfXyf
pdyD94h/ODFejByjYpuE/Jasc6ZcqafLyOWf5D8bc46GJ+yzfI1iroU4K66q
JlOJf1eNc9FF/L3oL6s1X2XjEe5/nzR3R3K/Hd0H0ddZ7Zn1AXdvSDr34mA1
uY6DRvI9DPyuWYZ8B/LPEU8v8hP4PrXKMY3G3ijwLue9+JApmGPiVlO1e7lQ
5I56WrP6dHE2aGarVmlspAa4Zi/z/hVwuNw1u1LvHCh2zail5PJM2r3TFHfv
Xgcaiz3cF99KcuZaDpxD59mCayGffyDfm4nhb3rh0wrf1YzQbJCOW9POqXLZ
DSL641jW3PmqytyTDekWB99RrGBM3Bzpwt8T5D9fao4NrfFO0i4aAtoSnuGa
3erJW9A/Pu/d9CM6xxFfO/druJ/h+0l8n5LwrBUntBsO4Of+Ou+I/jnvIO0e
1Uy7Ildw7rUzVJvGgntZNZqArYl529LO064U58V17Uz1sjgtLot/2s1H0N+W
9o6+B/9mN5jLmhnJrDkmbmnGbyHGtRlzQTmO8X1mwrNMNR3L3R0Jx5aOe/c1
5L17tQMVW0txNynGjrR7Wr3crjmCviVZ1045Hkn8I3LeXdpJ2m1d2u/FHdei
/xIp72rNlHzCHBe3xekF+NOb9ezVTtCseQrMrfLM2Z6wz/L1ZnCgYI6IG+oh
1f6+Bn8TB7bXeWZpVmlnPsq3gwlzdVrcu3hokQvayT18+ybhXaWaH0r4jmSb
wYPw6YF6955msmLTfwj9d1CMG8jLEwM8SzWP1vG8IvLs10xaynNnjWeB4n+a
2FakvasVYxv+Xoo8izQztJu0I7UbtaNUe9WgvciBIVn7KN+0g7TL6/PuDe30
gcT0TI13vf6D/A+2h1Ky
           "],
           VertexColors->None], 
          PolygonBox[{{4118, 7941, 3305, 7946, 4117}, {5464, 5076, 5075, 4410,
            1638}},
           VertexColors->None]}]}, 
       {RGBColor[0.5264658062410356, 0.4626150744567468, 0.8569916954082385], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG2QlWUZx+9d9pyzeNizy56z7ywHSNFeJhNMwnIKddQSlmAoSKcRxJlF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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllslFUYhk9r/5kpbWln6Uxnpp0B2TUSAbUWL1AkssgiTRSEKBS4EFQK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           "],
           VertexColors->None], 
          PolygonBox[{{6286, 5277, 443, 4112, 6285}, {6538, 4440, 4439, 5106, 
           1448}},
           VertexColors->None]}]}, 
       {RGBColor[0.5581941363188392, 0.517782071750518, 0.9015897016041727], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHts1eUZx9/eW3p6KOe0p3dOnahtFXUIMwI6NWALarwsCBSHzkEmNdHM
OETEUlhkRvE2dYnGxLls3qZFEIFayFQw20SN865TZ4ai0wSdN9iIuu/H70Pm
H+/5vef9Pb/nfa7f53nfgy645OyLS1NKpfop0/PocSk92prSwsqUJmZTeq8m
pZNLUiq2pXRde0pTxqR0RsbPjfrgJK0fpLFa33aL9iKt91Sk9IR4bBnv71c3
pzSaT2mu1pv1fFzv3tX6Lv3/Ss+l4n+7aK4V/zOrU3quIaVL9b9ZMgyKZqXG
B+L/SUtKT441/TNaG9JYrPk3NeZzSnlKj2n/CzVuEX2hwvPztP5wMaWz61N6
v8R7rBP9ful8n2T5k8YU0TyXk46tfrdEew1rfqPoX6hK6SWt9YnmJ1q7QGOt
/k+UfL+qsR36tbag1f9rK/1+s9Z31VjXxzVvrPB/5ntk2/mScbbG8+I7rPUd
2uun4jEqOfaL5nzNL8mZz6xCSgPSfVg8hvXtQxoXJtt1R8G2nae1nGh3hy/w
A/9r5K99mhc0761NaaTE9twtvWZovVN2mBfvH9O7GaJ5VM+pollU4jk8O0v8
Letvyef/kE0/l33P0fdrtHa5xtOSYahOMmv/MZo/KZ7z9f4V6fJaq/2E/kul
84niVS/594rXgP5v0voc0V6d7HP8izznSv4FGv1697Bio7NJsSobfyn+SzQu
1Xfb9H+yeFyn+TTF0apm6z6seB7s+L9uPDeVWJd2jVnaa1LGOq7X2KyY3aTx
lNZKpcfL5Y6Z18RzR7N9daX2XJ71+5UhI/aco5g5R+PNascKtPj0asn7O+m+
XfaemjE9MvyBPMhZbuT/c43nd2Rtv/8kx/nPqmyLXaKtF68jy+3bfq1363mD
/H+jxlj9/0gx3qv5NbJVh/Ru13ha/lyv7zaQj1XO6yOy9n+3dDpS4yDJvKLC
Mh4l/m3icafira3Evnmn0n57scr5cLTW3642D+LndNFvarJfn6wwDTYoyLeN
GkcqTmrE4yWNB8VnbfgMfxXF5/Mq51pRco1gV411iq/1Rf8/VLSvVVuvOvn0
LNn5Vf3fr3j4LOe9yNH62Leo920a94jmr4qx6zWS5Mrr2yWSdUOp8QebgRud
sttxBfurXHpc1G77YvepVfZZl2QZFJ+PRX+TaF9v937o3dVo3RdqrK5y3P9N
+z/f4lwk7/o0HhGfmXqeUut468/6HfFDbvUGzQlaP1XzSZLzCel4knxxKypk
zGd5qZ+zgv60WtMzX1XnvCSG7lGM/avo2OrMmA6a26XHs0XjJd/NjnVkYE6O
nyX9zmn3HuDxsw3G5Hv1/EW97VeesT7IWSHaSo3LZYPtWm+qNa5+Lf9/o9Fc
6zWe4Paw+CyU7+6UrZbVOCb6xKcQdIsDe2aEreDFO3KWtZmxTo0oBP3J2r+3
3fZF/y/GOI/+rv3f1PhM/++Wv+6XPd+ocgx9FjQ9Ue+QHz0ea/W8Q9/dQY6U
GTPAxGnJMhZCx8UVzl1kI1+nRuxgL3DoCun1Pem7I+/82ieeGyVDfWDtosBV
3pHf8J+fNaaDT/CbF1izRWsDWdN9K0+F9z2j1DUBHCaXjwo+rC2L9Ql1rluN
Ie+UkHlv5Bx4d69w4rixjuMHM64R1NBzJfPsomtqlXDl9Fb77QHR3z/etH16
31v0Pt1Z24+cWBZyLCGGZYORVq+TP+AkOftFYPmpgf+DUd+J896I+a4K24p6
BKZQN/n+5ox9jc8/VUxtFP/ectfLkTLXKOrViznnBrhD7aUG48PBsOHk8CXv
wY+OwBBw9qoK798ZMUfOYvvF8S11a07UwhVBD36uy7pmE9vYAVnwBXT9Ue/g
PzfoB9rdM/GfPgF79Cfj14oy22irbLiywzGBrMiBPshKvQUrhqJ3woZg7hmx
L1jbW+o+ij6iP/yCbshNzJwpvVtlw1eqnZ99EVv0Npujpo8Rlk4U3QOlrhsr
Qv4FWeMata4m8B67jETdxW5gK/qhN3kIvsOHet4e+cXe5Ce5+VX0i2D1v+XD
6wv272HyabdGmeKtSzE4IlzKVDpHsBe2Avt3Bv5Tqw6ucO/xjeT7OmM8pzdc
lXetXyS9xja4P9wpPl1Z95LUzoEDfUutayL/uyMuiMlPK8yffUaz7vcaow+F
B33pKvltqMN9GRg2I/DzYul1TJP7IGoJNYq9dpQ5TogX+qD5ETO87wwaZCSf
qDuzo8cDz8GenpCtJ+zN/KqY4y96dvzRE7nVFTFAj3B41vk/5zsxO73OerK+
JXKLuKZmHZ/1/jnZ8J95y4if8Bs9A3ifa3FM0eee1+pedx/YU+dzxaLozcBD
/LciMKFS/O4bbyzCx9hlTeiyInyAP8G3jZET8CEv2AO7YjfONr0hzzuBhfQ2
k8X7B+Pdbw5WOXb55rfCvbvajCPYfnPwQe+RkIHcQidyZIj+PW/56CO/PevU
uPcpi3w4PGIKXVryrp1gJbz3B/8dioWBFufrXaK5uODYAm8WRd6DLdRNcGxW
xj3V2qhTnWFDYhT9iBMwnRwmTtif5y2BW8iFj/n+uuA5GHgHvu1qcM6Tp/h5
RvQJc2ucq+TpO8rF8bLV0qwxvjzvuJxVtP/QF2wmh/EBWAx2g9sLM7Y9sT5J
e32/wf3vQ23uV+hVkJdzBTLjC/Lh1sBR5ldHjpwb6/SMr0TfyNmMs+vG6Dew
F7ri25/n7MtteWMruDpN76dnXHeO0XNyxnWcunxMzN/KeL4+ehVqNfnF2qRY
hw9YSM9/mvb5qsN8qeWsg4f0WPRnjwR+Tot96c0qM8aHN9p8xuB8cb/8cEWH
372dMT38p4v/ng7L+pFiuTfn99QF7IbNPs66roD71Nwvo+4SkzsjLrfquS3r
cz3nOc517MvZ5Ok4nxwr/qtz9htYCj35d4n2v2uce8O5krdhnM8Kl2n99+Pc
w25Qv3yb5jcoFl9XPEzM+xxPX7Ml5FmVcy6RR4cqfoZEU1JnPWojBtgPWcl5
8H1L9EXo+EmcsalxH4e+e2LO+gTV2KJGZ7XtwLvZQfNF1F0wfGvY4ctYnx3Y
+EzgI3tDd+B8Pxr0XWFP7k92Bj3zJWFz+AyHnA/FuXlVnJ3JC+b0nMV4h/2L
qlP/bfA5hXMMOAvGglPgFXmc1fu87LuGc73eXysfjBHPKeN9liAvyGFqLnkx
QWuHNPjcxvnyL3nbEDwAr8C2dQ0+e/O/KJr19V7Hf/S45AL14NOofZz/4AfG
klfgNTjJncrMRp/1XtX8ibjPeVe832uwTC2tPsci23OS5YF69yuc3bnHIM65
C7m7zf0dNYgneLyVuGowHefgD4MP9vig3jYBQ8BAcgHfjoYP7251j35UnGGp
E8jfG2dF5Oxs810YdWpAtD9uNM0JdcYqei3OSdPbbRd66r3hx9KocfTYrHOu
pd9o1r4TcsZR+EIDRvHcF/ScmdgD/mDr3ljfLZ8emzMOES9DsddQ9PPM8cll
da4dF8lu1xT9/4AcyEDvTl3Hh9vbXG+gJ6fJbeJ5eeQ3snEHQs9F78SzNPi8
HHNothd8j0CP8aH2PC3OC9Tcg+ucLzO1fkrR/1dqz0M0T3Xekyf7boscZO9H
pW8h7/Ml59p7W322vbngMznnid8oPm9r8l1FSfBCzg1Nvgehj1sbtZO+dk/e
cYafycd1gQ/oi54HdLwy7nzqZZ8fif6wMcb5+XFGAxfvCJy8MHCHvrov+LL2
SeAP77hvIJ/JZXRbHntx5oMnOfVMYAg40x29KBiCf8EF/AcWZgIPkYPvd8f9
Z1fcwfXE93zLGbcn5l2xTo1+X7Ic3eIcaQ+cAqN+KYy8RqNPev1QzxOb3Ruv
afLdFr0/9WdB9Pyc1ej/qV/8Z06N47xIHCwLnIc/feZi5cr57b6bWBJnW/D/
j5KnssP2Q0dwnzoGvwXBn7ut0WrLTJ/EXRJ+BNOZgzNPNbmX4j24gB5gCGdH
7oKxP37F/sTtZNFOGesekHuX8S3GTPwNPbq3a+2Fou0+Er7A7+DmQOhFLuE3
eh56Ynom+qVfF4y5YAxr9M3f3vOM9R330rjzOD7WqTUTw1/oBJajI37Dj/SN
xMkR3/Ev9NzNcSaeG3eJ9BInRH/OfcboOOMDdEdEn098Dkf8c3aYF3H4P/jU
F1A=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uMVdUVxrfcec+FuTP3cufOfc5URPwDsAqaVrRUhZmBafGRiEVFS9uo
IKDGgq/wTJAoMqJgtNG2qBWhFWRQAY0pMqNQBQKCOKOAtoDPxFqhkUqQ/r58
54+Vs8/Za6/XXutb67RMmXnVjH4hhM+hMmheUwj3QfdCc6FV2RD+Ao1gc1t1
CCPrQtiYCqG6IoQ5lSHkCyEMg+/1qhDeqQ1hZzqEcey3QztYdxVDSCRDmMr5
o/BfyvpTvh2Mh7D+jBDOb0R2o2W9GoPYy8BzBF1vwZNmfSoXQiOyu3lv5f0r
eA6xfpXzRXSXoOfRvxz73x8YQkcihPHQPtbLkX28gTXy3kNHEVnvlkL4rn8I
swYgj/UxeIfizyC+jeO9HboRe2+pISboW4W+BZydzLfVrKewPwrev2HDm5kQ
7sbP2dAW1pvYb+LMbPmLzjZidxl0KdQK3ZQP4TpoPP50QHdg2xDOxNG/Gf+v
wZd1yN+M/AP4dA28WXia0dUO/7nsFwqO9SIubid7T6D3CnjXou923tuxZW05
tiCvA50tyG/n/N3sP4S8Hcg/gfyR+PdH7qkB/+uhp1lXILuyYN425M9A1nRo
NLE+E5k/4f43wVdb4Zg8xfsiYtzNOgdPK/pPcP6iuO/oWXg7sW8p9AzrA8S/
D/ofd3UM/Slsq4GqoSS0l/OP8VzG2ePsH4I3gw8Tsee/vK/BzlXIOYwtrdhX
iS918A+AKljPI/aDeJ7m/Bn4+D28J6E27qMH+/bhyzZ0vA3tZd2M7SVoArJi
+NRHfHqh3fAn8OkIfC+gf2SZa2Ansq/POTdeg77EnsPIX8P5xVAJP7NQifto
rvLd/S7vu9YdKheXpS1bOala24D8rqxrbip0K9SJrcfhWU18jyB/MLZ9yPtQ
9j5L+O6ls5L1HuK9G6pgnapHHv58Cu8h9F9ODQzK2BbJ3IP9eWTEyf1aqAdb
utO+u4nEtMDZDmL4U87fXOn1G9C15f72CnZ+iw+txGKyaob1FcjbX+U7amD9
14Rz5ynybw/rLmxYCu89fMtyvinrWOnMMc4/iv6t5b6j+di6BxnnSBbn13N+
bcqydEe72buJ+E+rMc+NyJrRYOw4CR3Fvw9zrp0/4N8z7K+Ehpc5R18mPtuV
A9AG1lci76Occ/GDKud6V6OxSjl/IbK/ILbnx41Z84nF2eiIkVufsX8O6yHQ
v8v8rQ5bh0d4eBJ7L2evrWRsGYiPj7B3CPkHoc4m5+Iu4rNzoHPyn8if2OS7
a+b8eL6v4H05NI71HPYHl5zb0nkD3x5H1l7sPRd7xvA+nBi2RPe9lfx5q9G5
NIv3Afg8Ibqv3irb0gf1RjY9jP/fYMfYMt+xsFQYJ2wTpv5ALGPEqx90ivXH
+Luy0bmpfOxLu8ZUW73Qy+j/Jc9PuP8ENbAd+/8BBWIxDPkrGo3Rwmb58CQ6
NuHDRugJ1l8XnEPKnRFxY+8idH5bbgxWrAekXA+KeaHJOa7cVk9YiZ1/zhlb
hYnCFmGKsEQYIyxSzihXhEnDMq4ZxU4xVK6VYd+kSuecekeBby0x95DB+PZ8
1r3xDXzcgG/nqfeh6xL234N/NDF4LLjmLoN/XcpYsw+aDjbcCd0B3QYtIPYj
sPF6bJscN7alImwUxq1H3ksl5556xI9TrlnVqnSq9wbhX9E9+AWea4ruVepp
0/g2NeVc0R1fwN7IonundA7F/v34cwp/Tle7VtTTd0Q1IyxXz1CvEKZ/D/+F
Rds6SRiI7u6ce8Vd2De25BpQ7p/JeyZhzBZWN7L+PbQUuXWVxvSzZFu9sUWY
ICx7M+teKkzbwnouMdoS84yg3BpTsmzlmHK7f71rWTmu3J4XzTLKcd3Fizlj
t+5E2KuZQbOCMFi9eTXnK+Lu0d183w5tg7ZCD8Hz23rX9jr0tyDrR9Bh1guC
a1U13hnV7NGUa061JgyfjfxHyell0CzWZ2H7z3M+G/obC4RRwiZhwmhinGD/
7BrrvA79v4ImYN8D6FyB/IXwtCH/hHIu65lDs8bFWc8Guxpsq2YEzSp9UW1q
ZulhP438YTXueZ1p54hyQ3eiXt7B+VFx93RhQ1/WuSEexUY9Xr1dMdIs+LOM
bVU9CjtHNbh2haHqjdfiW021e+QoYnBR3lifIT6vIbs86VlLM9TijGc+zXry
UbPLzby/X+YZ5v68Y6pY3pd37ivHlFuqgSHYlERfF/bM4sznCWOWsEqYodlv
Utax1AwYT1imZNWyfp2zB3OeRVTzPeg+3GDsUk9R7aoHq/eqhk/h737W9/Zz
zB7kW3PCs4fir14tHZKtnr0C+btS9l09UrPYf7D7m6Jnspno+k3WvW1jzLPX
r3lfUu0ZrAP5V+Y9G7bVejYXxghbNKNvRsZ8ZPTEPGNO0QyatSzJmMbZqXn3
fmHcQmxaDD0ALSh49v5BM1itZ/DvWJ/IGcs105/OGfOEdeL5O7JfKXpW18yk
2thY9CyvGlHt/iLtu1ANazY+gI0fJaIZOe9/BP0bjEXeg+TT10nPesqZudi0
lpilY55JLhZ/3rxjap0bn5Q82ytH/lRvHu2VxR1b9TD1LsX4uXrHULErZ/9q
zj8ZzdOquXvQ9wi2ndfPmPBwwT1KvWkJ66Lmff2zQIWia1s8S6IaV6+aVmcs
VM9S77wkqk310F6eH2Tdm4W5isXCKPaKyRye86HquH3W3UyPeoXu6GTSGCzs
1R1/mTRmCau+YD0PnqcTxgbJkK3i0V4mmr2Lke2aweXrzIJjJZ81S89NGps0
U7/L+h3o/ph7+L+Snlk0q6jGhE3NOf9bCKP076Eeqd6of5CBOf+z6F9FmKNa
uavg2Ktm/g9XdQry
           "],
           VertexColors->None], 
          PolygonBox[{{5560, 5564, 1528, 4253, 5559}, {6191, 5451, 5450, 6185,
            2081}},
           VertexColors->None]}]}, 
       {RGBColor[0.5830115801587294, 0.5583995719502508, 0.9099362304629933], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuQ1WUZx192Wc457O45u2e3ZQ9ndw9kpBOgzChiJuDERfESty6Wolwk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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ts1eUZx9/SQu/tOafX03NOD8PLzCIbyWTgZqmjYFtso5RFyYANSPCC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           "],
           VertexColors->None], 
          PolygonBox[{{6339, 4173, 4172, 5589, 1685}, {5327, 6250, 2115, 6258,
            5326}},
           VertexColors->None]}]}, 
       {RGBColor[0.6063392444441436, 0.5958806374652833, 0.9104680293585128], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl12MVeUVhj/mMD/nzJk5ZzjMmTlzhpmokTaRxBvDjFBBqa21gpSxqcVU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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl21s1WcZxp+2UNrS9vT0nJ6+nRcczpm4RD8YW0BahG7SjXbaqmACTjDb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           "],
           VertexColors->None], PolygonBox[{{7932, 4122, 4121, 7937, 3303}},
           VertexColors->None]}]}, 
       {RGBColor[0.6296669087295577, 0.6333617029803157, 0.9109998282540323], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l3uIleUWxt9mdG7u7d7ObfvtXd+2MjCK/goadThBpURQdDpIQUVlpEU3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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lslVUQxS8t3RB833t9bXldHi6QYDBREyObEVQgsUYaWSIogoAGDUiR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           "],
           VertexColors->None], PolygonBox[{{7925, 7924, 7923, 4116, 2122}},
           VertexColors->None]}]}, 
       {RGBColor[0.6529945730149718, 0.6708427684953482, 0.9115316271495517], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmMlVcZxg/M3Jlhdu4Mnd572zsiFakat5qwNkajNMTEkKqAKSAaZRcY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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twlNUZxk9ISEJC3G+/bEKSzW5EoFLbqVU7w33ACswIHUktyMUabW25
CNqABkgiko6CF0RRsIIEWoGOpQMi7RQ7DRWpCggERopODY6hXiKgglrRmeqg
v2ee/eOZPWfPOe95z3t73q//L39z/R29QgjnQAFYXRVCcTqEi0tC2MUfI6pD
GAn2FIVQx8bXI/6vCOFv4DjjL5Ih7MyEkOobQgXYydm/gLgwhLfzQ5jBWn4c
Qi8wnfEaztzJ7wKwmvERUM54T2kIL4KR3H+mJoQk92/h/hmVIXyYCGE0ax8i
c0M2hFPIGs5aO/f9h/E69n/SO4SB/JdlPqc2hNkgw/hz5M3njhjdR4F9qRD2
g7Podoj3Pof+e9lXyNnHkf9gvxAeAgd47xD+e4m9L4OHkb+f/S+w9wF0yGet
F6hi7zTkn2B9JmdauW8haAItYBb6z2F9QXEI/0P+vdjmPrCVvZdy5jhvL2G9
nvf15z0jWGsp560FflMHdm5n/UvGj3L+p6wX4Y/HkNeAjWai223osB15Z9Hv
RfavTnn/KvYn0eEW5m8xz3Lme/In9mrqgx+ZX4Xs85zZwN6uvBA2YusHkPcK
8jLM32d+K2/4hPXL2D+UtWHgIuYHseEU9G/Fhi1gcsZ7ezgzpNRnNvP/1fhi
DNjE+APuHllu355Gp9vlH9AI5oGfcL6dPXvR723Ob2G8GWTzrFMP4xGc31xg
+buZ/1N72B/Ycz8yHgYrwHLwKva6K2HfyeZJ3h+BCmLhWeY3o3Mbei0FDYy3
Yo+5/bz2JO8dzl3H8ffJ3r5zHfuOYc/XwFrGT3H3m7Fj70v0Wcb/bZFzRT78
L3fHvCkJTjJeBOrB/cjfhcwbuevn4DC2bODMNuSdRd4R3tMJ2upCuJb9r6D/
3LIQ+iK/ifmB4JjcGVumZCmmK5E1jvvHggrGU9H9hqx91UW83MJ/vwBvMJ/J
fWtZexJMRt7viL+FvOkb5F0ATYyXsLaFO1pYawYPos+drO1j/6Iy204xIN/L
hsfY3x9fXwxeYzyPuzrxwbsltumPsf0s/mvl7lexbxeyN9bYdoOwVxPnGkFV
vnNiMXL/hNxnwCLGl3B2ABha4JxW7KnGqLYoBueD59FxF2jUGX6T6BuBhYxP
VdlH8o1ysoNzQ7HVW8ROJe/rRp/97Ospcz78mrvu4R2trM3r5VitYk+/2DHb
lXWOKbdOsGeO3gwWMH6dN+xJOaYVy8qZzZybz3v/ir+6We/k7suwyRnGC5D/
Ljq/wP2Hy+zzGbWuaapl0xnfhuw1sWWrxs5l3oCOm4p856GUbaC3H0y59tbz
OynlGnyG/SNUP8HprGvLKmxQ2tc1o51968EA3j6swLaTTMmSDTvQfSX63Vtm
TlAtV44rt1XTb2TfE+wrzXNNnMg9X/P/V2BC7Nq4gb3tSddI1f6j6LC31Bxw
M2/czto25SPjQ5FjTrF2R55ryXgwLldTLgfdWdt+B/qO4Y7PkPkpGM34OfL3
KOcLLnLMLmPvfWBPvmtGK+sj067NiomxnPkBb5zF2jBkTuPs1DrX+kZieIdk
xvaVcvAJxR06VOfbhuKeX4Fbcxx0mr3rue8p1taDeuZ5zAOYxLgu6TfqbS8j
czd3rea/x0EH43pkTAGTwSTw59g1QbVAMVtM7BRWm9vECeLir5KOZXFyC764
hvWDxea4ibztajCWtUV97BvpJF3kI8X+ydi6KAc2sHd9jXNTNVmxeSrp3FCM
DsN274mzWb8W+/y/wjmkdXHKFPbfUGfbqYZ/nLGP5JuPGF8ZO0eVm1cwXo5d
9qVdq06UOJZ2ZdxbKKZG4a9TNa794pDFCXOeuE6cvC5lDlDtX8t4DdiRNHcq
vtW7qIardquHkW/OxO4l5KP3VKvSjv0L3D87MocrPhqx4UTuP8eZs2AC4z/G
rpGqjaoRg7H1/si1QjVWsb4KHR5NOeYVuxPBhFwMy7fK8ek5H4srvgDnc5zx
DLqM4o0bCZlt3J+I3DOoV/gZ+TIFuf8m/4+BySlz+0DOdRSa48/F5hRxydE+
5pZEtblNHFOUdg+k3kc931b2vh+791FPcSXzccyb811zqzm7OzJXKYcUW80J
13LF2GJsMiRtbldM5DH+HPt0o28d8gey/6XI3CPO68yaM8QVh8F3as2Z4spB
teaK71e7VxFnXKjM9YToOxX9rhM38u4U8wMlrh1LsM/dGdeQdyJzkLjn+WLX
7jZiY2mVa/hy9nWzp4bzJeg4oNI9lnqrfxSae+pzuScOuh57TOPcMnRfgv3G
ROZcce3oyLVxZcK9iGqkuGxFxrLFafLNHxKOLfloDroPr3Jvpf5CtWRprX2r
mqJaoprYkKspXZE5UVz4ZuTafxN4usgccBr9miPbXz20crOnyrErf0j37TWO
Bb0hiy7f5fz8IvcAOjs07VyWjB+y9/Ia94KqiY2MN8XmLtlcsXkg7VxVjKq2
FKbta9WYI2n3qOpN1QPcFLlnVq+snvS3+Lwt615cHCCukk1lS3HW+HJzlrhq
XLl7G8W8Yl09zl2RbSjbqaeTb1tzvbd8rNxbAR7K5aB6mVTG3xrqaVRrC5CR
H7nmihtVo1SbxJHiwvasa7c48W7GT8f+thGHq9dRzA7K9TzjWbtK/Whv54x6
EfVU6qXUk8hX/4qcy/LZ+ay/ufStpRx5JGkOUO1fmXRud+ZyQzmuWB1f49qt
mB2OfZvL7VvVKNUW2Uy2Uo1Rr3p7rrdWzyruUQwpdsRBP8pxqLhT31izU84Z
5Yp6XnGpvvn0rSdO/X3COaLc0DeSuHVnub9lxLGqjeJ8cb1qpHpJ9djqrdVT
9pSbY8WtstGS3DehvgWVs+vElVn3ovrGU2/097RzWz2SfCkbyTby6WDFf+xc
VAyr91eNVm3WN8DgWn9Tiiv0TSJfi3PENfL5t5LhKoo=
           "],
           VertexColors->None], PolygonBox[{{4527, 5273, 5272, 5567, 1679}},
           VertexColors->None]}]}, 
       {RGBColor[0.6763222373003859, 0.7083238340103808, 0.9120634260450712], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXlw1dUVx3+PR3jk8ZKQl4QkLxugthVBEGYQt5luggVqtWVTqy2gMYkJ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twlNUZxg+EBTaASXbXbNhNNoIzWm4mEktV6IzWES1YBx0SIpQWETBc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           "],
           VertexColors->None], 
          PolygonBox[{{4633, 6268, 6267, 6272, 839}, {4594, 5764, 1801, 5768, 
           4593}},
           VertexColors->None]}]}, 
       {RGBColor[0.6996499015858, 0.7458048995254133, 0.9125952249405906], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHts1tUZx0+hN9q+7dsbbd+XliDIHVuEki3Dy0DA6TZAuSwSEkZAlhhw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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3t01NURxy/ZPCBsmuzmscluNhT1oCAUkIRTqyhqbRVtOchLntVIsKct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           "],
           VertexColors->None], PolygonBox[{{6325, 6636, 2361, 4558, 6324}},
           VertexColors->None]}]}, 
       {RGBColor[0.722977565871214, 0.7832859650404457, 0.9131270238361101], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l21snXUZxv+ctqzr6ek5p6freevpXKQboFkibUeiGSAmBkICoyvqIhIY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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tslGUWxl9aoK1tmZnOlDLTmSlVAyouCZTWBPCaiEaMaHGXRS0qGBMv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           "],
           VertexColors->None], PolygonBox[{{4130, 6625, 2358, 6630, 4129}},
           VertexColors->None]}]}, 
       {RGBColor[0.7463052301566282, 0.8207670305554783, 0.9136588227316296], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMlNUZxj+Wvc7ehp29zcwOI1AsClvtIk0KmFJjRZcVBMFgweXWJmAV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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl01NUVxx9JnIQZYmYyM2EymUnAlqViUKPUnqKt7bHQQlBAaakLCYun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           "],
           VertexColors->None], PolygonBox[{{6241, 4082, 426, 5356, 6240}},
           VertexColors->None]}]}, 
       {RGBColor[0.7689191764350036, 0.8490949392866791, 0.9112139025921585], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuQ1WUZx989e4GzZ8/u2T174+xNmcwEUxDwliyg4TQhEiKYgDoymDGD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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twlGcVxl+ScEkCZJNNNpvdzaamVS5BgXJra00LjBXLTaBoKWhLB1C8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           "],
           VertexColors->None], 
          PolygonBox[{{7600, 4573, 4572, 5153, 1471}, {6655, 6979, 2643, 6978,
            6654}},
           VertexColors->None]}]}, 
       {RGBColor[0.7898690022367805, 0.8560811479636949, 0.9018283994067849], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2Q1WUVx397l927l3sv3H1l2d17t8AUDf+oKV4cQGHSeGdBMeMllElk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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl31wlVcRxk8SQnLJhdzcfN2bm/dGGzpCFb9GgXZaQi04CCQGKLYmVCmW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           "],
           VertexColors->None], 
          PolygonBox[{{6329, 5368, 5367, 6323, 2133}, {5539, 5543, 1654, 4431,
            5538}},
           VertexColors->None]}]}, 
       {RGBColor[0.8108188280385572, 0.8630673566407108, 0.8924428962214114], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHts1eUZx9/2lF5Ob6fn9JyWXs4Z6gYIGDJ3Y4kYVoybXEJhi5kBQRCy
TaZTdidZWKoS2QQVLKIybkpk0A7daMsfW7L9YSQZmoHJ3JSarFKy6JZlOCdm
i/t++n3M/nj7e8/7e97nfd7v830uv85Yf8/Ku6tTSvdUpZTRc7yoP+0prdbi
k6WU/lVIqV/zvtqUbqlLaaImpaf1e2xaSgN67pbMTMkf1fxHrSkdLvvd1Vq7
rjul32r+VG9KHfo9KJm7tP9FHbSkyvpenGadh2ssO1frJ7IpHdfYIVMmtecl
rZ/U81RTStP0XCqZVVrblvW+Ltm8SeOLsvFanTOn/f96eX5W8hf03K+9a6Xz
BskVamzzsGye1+4zTtf7brMl/1PZ/rDG41mvn2v0u9UtmjfrXN3hJo1jDdaT
6UzpynTbu1S6f6D1T0nPIe0/mPW5+7TvSY1lWt/VldIjGr9qsI6fh56dWjuX
153ARPtelfwT8eQ35z4iux7V2J8xDufDnjdrbNtl6X9AeGzT+J7uul1rD2pU
V1n21ZC/u873u122ndPvUexLfo5pnK3y2ezZk7H9o7HeV21MudeX9fxx1rbw
3BbzjTo/12bfzSgaI/AB/79m7YM1lZSeE8cWSr5YtC/xI37e2Gh7XheuO3tS
ukY2fF78uk/4vCGZTY2WOSN7kvBbpLXntG+J7jUp3Rc1viV/bQjewMvlNebt
oPAbr9g39+Xky+m+D3qHgnvwAFnwAT/OJy4Oa+8XKuYpXEQ3dq6SbTdq3Knz
LkpmUuMGnfeBdP9Bd18vHn2/1vcDE/D/dJV5kq8zBvxem7eP8e9wxrGwVfrf
Elefrhjfo4q7U63m0h6deUIY/iTZV2C/J/iAb/A1MXFH0fHwknT8O2+eopsz
uO9Z2VDT6BhcLNz6WozvG7L92wVjukO2P6RRnzFOJwKrUWGYVZzfqns9Kg7f
32a5e2sdW/j9eMjfGvkE7sPzAxnnmM3JZxyKePmH7H1fds+X7Czd9+288Vwm
PJdrnK83h3ji93dk64f1jvelel/f5nV4sjjuQm5bXrYf+c0d8R1PZMhRxEJf
zNEHt9BzST55RzYs1JnVel/VYsxTzOHCyib/Jr+xhtwGeK7nqibLHxGWv24z
n5BJoWdY9x0qGuNXhPnLGut0/li9cxB8BI/TncYEXsNL7rJYdypVHAus8Y54
r5JPjuYcr3M0/0/Oeaxe8xc0X1Ftv43k7JeXNS/ojn2y7ZB0fpB3zBAnZxpt
y59k4069+6f0z5P8db3Oj2M6c6TJ9yUmsAF7hnXftoJzP2t3xvrnpOP+vOtB
s96f1O9Rvbu3xXqwn+dozNFLDQBnZIhtfmMbdsGZtXre2GB+8g4ZbFkgzBYU
XC/IYfsi18F9fAaHweOasjFZE37h3Vea7DtkB2MvcfcJ8WGzdI5LZ6Mw2Ki7
DEkmK67eFev4ZH7O9/2M1tdJ5kyt9extNk/2UGc0DugeT8T6sohBuAsPOXMw
bMa+/ZETwGIw9LD2s6zjqD9kmKMPveAPN7ZHLrtccK4hz8CPseAYmIEvmPfI
rk2Su166fkcP0OTcsiGwRQaOgvuk5ic7Uvpa0XEPfmuC27cJ/9Wd9stI+Bj/
oJe9rF8l7K8u+wzwXhP471Y+eUxjRH79o3Svz5l71Drq8ZGMayNzct0FnTOu
canGuu8I275a4xzM/DW9/3OnewQwOxBYfVzn7+72Wp3Oqi26XlErJnLm2iXN
X1Ac1tQ6Z7+bcd6mVvCkXrBGXiO3z5Jse979wjrpe7bVOWpv+BRf0/tgL7l3
l2rdae1prnVNq65znqttc79Fn/BDPbeW/O5D6R4TPt2a3ybdM0u2gXuzxn3J
6/gP/Suk5+td7g2wiX4BPMEGjMjV1NhbSq6H2AjP4N5bPa4H5OkUOQ/ukZMu
R66eKwy35B0374k7c8WJVmqS9h7sNaeJE3gMh6lpW7td1zK9rsfU4gGd/0zB
/cYvc85ZU9wPXDcHzlvqjDV9zfnol+Zp7+q878yAs9ydHpC+gFzRLF80FY0x
a5Oxvq/HtmLnpegj2EvOphchdohhuIMf8Tm1HMyxBV585Hue2Nkn269vc42q
6L5ljSvC533ZuLbi+v8b4TdRtN/BcaLWtWiF7tJf8u8DnZZDZqTVfQD8ITao
qdTTIWHWVHC+fFPyfy+5JyJO+sLf80M3uYUYw4fkwF3y3fYu96Rgnw/8wQEd
YEF9eK1oXTNk+95u12y4Q9zDH2rvsXbXTfqAkTrbtih6b9ax62KP9Y5Fb4lN
1GVyNjnzOwXHM+eTz/qDM8Td43X2f5VkDkpXmTuWjSl4Uq9OR/2kb5gdsfnJ
nLl1Nmo0OMFj8gq1jVggT8/rtp+pV+S7qW+iyP/spW4RH+D2umzMFe2Ds4ET
XKN25qPP21Jw3pmIPp3+jHxFf4Tt9IQPyKff7TBeD7Y5b5Ib6Tn64tuEb6m3
i/Ydfdap6caYvo/6BtepgTuiT+NbBH7CR2rSzXXmAL1Mda91s4Y9rBOr1Dpw
ni0855Sdj+kPhmKdWtfQ69/P631LwfV/lux/pddcY8/KqJszheU3Cj6HnnRV
9KWsfazi9b1Ro+Ai/cKCsn9TL05FX/GQ7t3f5j56IO8eAj+Q56ZyF/lTZ3W3
Og/Qj38penL4siU4803p7634zs+3O6cTt3ClL74Tn825f+I3MU/MwYF+rf+l
3WcR3+yDl9eW3YtT7/ieo26Qqx+TPe9Fvz2319/JfIvQhw2ET/ke+qifhSvv
Rv6gj6DPwG/k6vHwEf0psUJOplYRG+TGJcFLOEl+AWvu+PsG8xJOLqq4X8ef
xMXCiI3j0Zvj36RzhzuMaT7vvpB45zvmQo9rBRw+EvnkSt79InyfqsNZvwMX
+ITOKbszjq/9Jdct/EYtfapkHG+XbRta7auJLv8fgdr4X9n7cIftp54sLlnv
QMQYmJGzbgr9yO4MeeLhcORwviEuxncZ9/tF3BH/8F20NPI9WCF/rOBvVPIN
dYf3+OW4bPtb3rj+D5o8Tdc=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslFUUhm+nZaYdWjvtzJQy05kRLRYKJUSMBhOQWoiKSKhQjYSwbwmL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           "],
           VertexColors->None], 
          PolygonBox[{{4730, 5509, 1655, 6761, 4729}, {5305, 4134, 4133, 6303,
            1549}},
           VertexColors->None]}]}, 
       {RGBColor[0.831768653840334, 0.8700535653177266, 0.8830573930360377], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2lslWUWxx9KS9u79LZ9e2mvt+VarRsggjpmikqh6gc1xrjgF40bHYOy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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtllls1FUUxk/XaTtTOu0s7XSmM5RFBCprTCwo0CImajQBFV+URcGwtKBs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           "],
           VertexColors->None], 
          PolygonBox[{{6617, 6616, 6615, 4085, 2111}, {5403, 4419, 1647, 5478,
            5402}},
           VertexColors->None]}]}, 
       {RGBColor[0.852718479642111, 0.8770397739947424, 0.8736718898506641], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNllls1UUUxqdyufvt7e297e1d2rJECUbZ9UGUpfroEjAx0cQY6osErLFK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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVls1FUUxk/b6XSWttNpO8u/M11so6jRLkh9EGSPvmiMNQE0McaaiEqp
UUALShGUFrSaGE2UwJsthkKqUXwSNRFQwB0TUllqa9BoifogsQUk8fflzMOX
OXf+957lu+d895ruJ7t6i81sBwiB9qzZ3BrsmFlzxOzVvNkQ6I6bPQJW15k9
X232HHgU+2fwY8Jse5FZGWe2pM06OR/BDpWZjWTM/syZhTk7wfq9lPuUr1fC
Zt/Um5Xgoxh8jR3ne1nS7F2SOg2StWZVYBB7Nwm2N5g9S+xnQBv2J+A4Z6ej
ZifKzd5oNNtPPreRz2sVZpX4O8f3cMxz3MY6A9JgKxhM+X+yB0A7uR/H5yVy
3UW83YHZQ+STxH8VWI7dwr5msAy7N+U5KZe1Kc9NHIkb5ThEPj9Qfw/x+8mn
mlqu8v84vj4uNSvFRw8xLsL1AvgIsR6DwxuIP5/1BH7m1Ti3qqEa7pJge8j3
X8l4jaotiY98ldk+zl/L+QfhuIP7DNjfEff7XJX1nJXrSuylcH49Mb+F3wvs
Wc//G0EfWAf2glGwD4yA73Nek2r5jBxWEu8X/E+BFdiX4X6celqpbwnxHsBe
BcbxPRnxu74TH3fk/M73U9sT2E9T2wbwK7kvg6Ol4Dz2QXx+wG8r9XSR4wz1
LiHfYvwnIu57ivMzMY+hu82DXOGOx8nn/sBjt/F9mL2d+FhBr4xx5hC+Tgfe
i80lZt9hP66e5PscYkTxcRfo5vsicJBcPkp7b7xe5Nz15Dx3cbge3xsy3qsB
uC/rnIvrLjBGn8SpuZtvTWU+KxOF/tTMiJuz8Hum0Tl6k1i3cK4l4vH6U+5T
vjZjN3H+K87/HfWeaOK/Yr5Vs3+A/W013gO6+yL8H4GP0pT3jnq8Lu81ybd6
ZA/1V9Cfiwv93s7+VurpY28v+vAY6w6wifUB+jeP/0MNPnvK4Tx5HyOfTeTy
dqXZi/h7KfC70kxfxb4CFsL1cvYfYe/hOvf9m+6U85Xg4ZBrzkliXcr4efX4
WfZOZVwbpFFR4h9ocC515h7u7t56z1317yLWW4Hb4qSTWm/Hfz39ewwOjuLv
izqPrZzPEa8/7dp1Hfvn4H+mxmtVD0oLpujNlrBrwnTae1a9+geYm3UNFd+6
sxlizwaejzTsL+50D/vmF7kmSgukkdJGacKawp3rPtZR30jaZ1KzOJx2bZBm
6P6kEZrV6ULsvkLvS6OkTZqBtcReE/hsS2PU+xXShIjPwO/UcmvCZ+FGfJbD
zQA98SlcXOD7JPm8zPfZmM+YZi+W8lnQDOrb+6yHwr7nJPu38N8/5pp3M/FW
U+O2qPfQLOvLGdcq3almfW9BWzTz0hr1+OaC5khbxIFql8ZIyxMpny3NzDv4
GgZnypzTi9xVvNFzH+XOYqx3JlxrNXMRfETzfvcbWY/y7aZat/VmlGddM6QV
4uipnL8peksUQ7X+F3jvqma9Pep59breoIXYC0C81HvsKHtPBK6F5SU+O+Jc
XGuGxM08avsy7ByJ+8G8a7fuQG/tYOFt0pv7Aud7M/42iOPD2J+DrSH3cXfK
Z16zLs3qrfccFFua9mGta6q0VGekvaM13mvS4MlanwH1vnp8UaNzKi4bqOcn
vYdZ10pp/L+sTyV8vqQZp7KuodJOzbi4WNzoZ8XJTmrbkfe3Q2+UtE5viN4O
ad7/aVsePA==
           "],
           VertexColors->None], 
          PolygonBox[{{5411, 6140, 2066, 6146, 5410}, {4622, 7629, 7628, 7623,
            830}},
           VertexColors->None]}]}, 
       {RGBColor[0.8736683054438878, 0.8840259826717582, 0.8642863866652906], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVUlsTVEY/nV6777We6033L7bh9qgixqiFRsLalqoxpAYFiQiIZGUBQkx
LSxMbW0ISRsrmpA0NS5q2FCiZtqKRqgK0dZGVdUYvi/fWZycc/77j9//nf9O
2rhtRW2WmTVjZWNFMmZtE8z25Ji9iptNwzqF846k2bmU2ecxZrV5ZrNCZk2Q
d+abHcB5H2yXFJltht52fM/F3h4z2wX9buh0YRWEzYZ9s2++zr9g9yMkneyI
2cyQYl1AnHzkMRn347hPx16P/SrkQUZ6QUh5nIDtPxSwFec+7J2I2RtgzzU7
BpuXkLeisC+eYu2FrD8BHzHlvBA+UxnpdcNmIXR6clQDY9D/QdjuCcn/aJa+
Ud4DHwsSssuFbBg6OyH/kza7iPr/wv/MYuQPDE/D5258H/GU1yTIHiHPIdyz
IqqftXcX6E5MksjrK7Cqg/xkUvgydityKM2Rf9bG74xL3clx3YkN+8M8KyB7
G+iezign5jMXua8vUk23YXvHVw3Lx5vVYP3MV6xe9OoI/CyG3fqksD6DvQz1
b0MOT3LVJ+bAvd6duTfkCOdy13/eo2H1lLptnvBmPVcLza4khCVtudPPUcR5
V6J6DwHbFl95tWANZik34k096jBffuf5MeqIjkNfEacRPpqwmoFvJXycLRF3
xxbrznM18Diclt8iYDUOq8zxl1xn/uQRZexRp/vGXFhfl9Nhz6uTwrknrDfA
732IuSatHH9j/4tV5cmGvogVucYciW1hWPwm90o88Zp35trp4q6Cj5VYr8N6
o+8zeqfMpdvpkO9bHOffEM+EuDE7pvdA+TRgMCMmntKOedO2Et+fB+pzFbBa
VKwcyDPK2KNm2K5Iy+Y7zs9j6vMNzJLrWB0F4s4Gx5+f0HkRU32b0Z9yX1xm
bL4PntfC36uY+st5w9rJ4Q3oUWNavCWPyh3mS+HbSwq3Ifh7CtsI/Lf5mimc
J/tTqp+103dBsfxfgF0z1qE8vUP2jX7Yq3WuX+Qoe0VeLYuKU7xXpFQDcyZv
Wh0nN8Hf/CK9xTvArx3rk6c8PnuaRfch+zBR9wFP3zl7q6N6F+wjsRtwcmLH
eUQ+TAXHRny9ozkRzSHa1ESVH20/Ob/E9Cb6kIkrLrnCt8eaOE9ZL+uuxPcD
KeFMjrW4WphPldPvcfmVun2Z+zaPs8RXbpRVuxzYowY3F/g/2ZVQrOxA75M4
PsS5NK45PYp9Slz6rx3urc5njcOdfeXMZl0PELPD1/+EWHYEwrMD9c6Ia6ay
VmLE3EcczrS9nNLc4az5iPNgSv+AZ4F4T35fRP8vYWU8xaxz/OQcGHJ95Jtb
Xej6BdtbE5TDtZT+W8S43/WefexLiMfk8OISYcG6+B74zvm+zvuaR+QUuZ9x
cs5y9ok9uofz3UC+I0n1gPj/B6YpLMM=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtslGUYhV/KlM4MtUM7zLXTClERFsg0EOICN0Jlo1GBBHChiTGhxtiy
0FDCpYksWqLEjaQoxJVpdEGqEqP1suFeICBijRUT6MIosIEAVpSqz8n5Fyf/
N9/3Xs97mYUv963rbYiIV0EKLMpHfF+NON8Y8Q4Xp0sRrbWIJXMj/mqKWF6M
WAFGZ0e8OSvis0rE6nLEfxipZSKeKUQ8DfqwdQD9VfMjPq347RI2v+6MOIX9
a/web8ZXLuI2PprTEUvxcZm3bej0Y7shG9HdGvEw9h4Cazj38e3CRh30ch5H
91TJsf0NWtoi/lFM2O8GM7yF4uN7H2xH5w1wA/uTKcdyk/u3U47p1wcj1rZb
99mWiLu8/QlaiO9dZLag+y8+qvjaOifiUfj6HD4aOe/jvQd7u3jfCbZw/hjd
T8B1+DkM7nAeAZNp5/wLMl3YmJ11vsplIb9vZZzTVbiYAtPovkfMbdSisWB+
VJMy5w5QAyXwXEfEE4n8Pd6HuNsD3gKDCXf9xLatzRzW845Bvieox4twvL/g
3GSjir9KzbXsIp7V2P6NfLs5T1DPZcSbRX4K2R3cHYT75zvsW/ov8daDrz3k
8xo2n6IWa8s+q2cUu2qs2iqHJ/l+if3l2OpFZoC7DcivB7s5H6dfxjsdqzhQ
bT/A5/sV13iG730wE+6BzWX3jHplU9m5q0aqjTjYz/cR6v04+Y8hvwT7P8PJ
cCrpYWxNcPcjGOZ8FdkpcCVtH6PcXcq5t9vRP4G9dvQXEf8fGccmG8NJjOq1
W+Is7Z5bkPeMqdY3M9Y9jY0bGdsYQmcQjDa4h44UPTOalWVNnpUzJfe++LiC
7gpsHEo5JnGpGdRZnI4UXEPVbhB+51LbLNiRsr9D5PZhMr8jWfdOOekt9dBX
+BorWXYnOh8hv5J4diE/wF0P5+m8Z0F3F4jnGPidfO5m3OtfFN1L6vmLvC3O
e7a0c/rneweoH1WDGm9nq+ZG/qbxfQ/MS7vn1Buq8aakR44ie7Jq7pXTd/TK
t53WFaeH0d0An5fT5lSzOpTMhmZ2Df5fbzU34qiecw6KfTsxn6uaA9nTjF7g
vZt8fprjmm6c5x2i3aEdc7zqmBSLOPgh555RrygH7baZZDdpx13MucaqrXZO
Mzk9UDa3e7F3hPiOInu7yTunzvlgu2ul+XsB25srllWPHit5Z2tXS2cpvx8r
ORftcO2yVwqeNe20AWR3F71r1ENjcPdNp3e1csgUPPPypR7R7EzmzJVmaH3F
M6VZEsfXi9652rXaGUV6rVDzf4s4026oJ/a0I9ZVvDO1K7Uj/wcQk/k0
           "],
           VertexColors->None], 
          PolygonBox[{{4053, 7504, 3065, 7503, 4052}, {4461, 5503, 5502, 5546,
            1671}},
           VertexColors->None]}]}, 
       {RGBColor[0.8946181312456647, 0.8910121913487741, 0.854900883479917], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1IVGEUvVn6Rkd5zejzzZvRIaMio0USFEG2qNRcJGGCtCmwICFMgsqg
PyotaWWBFBW5i36wkham1aKVKUFKmloLrYgoCYrMwkV0DudBi8t8c+99955z
7v2+kobm2oMZZnYCthD2wTE7GzG7uMDsu282kDTLxv8ozF9kNoTk1ymz0ZT+
d+SavUUsgXNdYNbtq8afhNnxxWZnENvnmf2Nm9UjZzLfbBx2JdMsD7Hf2ao5
7Jo9KjRrRd+NBWa9OH+Ef1uxWTVsNmp2OMssAyBn4G/DeRzWg/8rUW8kqVpd
6HUgpngTzMtRHQexCKwc9W8i5wbwtyI+BazvHfmfo+cX4OjCuR88emFfEdsE
PDXAMArMTai9tUA4iHfEFWbyJx9yqQL3StjaULP6LPnnUO+Xr7wJYC51pcMP
X1pT56XwH0X98/jOiUo/6rkOmCdSqnUHubdh0474lUXEsREaHIPOz4BtErWX
pzRHcmct1qGvMyk/uS2D/xDOOUWYcZH+V4Hreld12J/fUh8P8ULY6qh2hDPh
LG4By6wvLX/6miU14c4w9xzOFajZ7WoH1iCnMa7ZEfuGqDTfAs16AvlK0WdV
kWKnPelOzZtx3pXQLnwL9WX9J2mzPtiLXBl5kN/1lPqx18m4NCIv7uN+T3iq
OVPg+wQul1HjUlp7PZaS7tR8xtFMqNURzOd+oHMlvquJSYe88B6Q+zvOAnmf
M8V1jycMbeHOku846r9J6RvuCnnTz9pPXdWnzqzNee1ArzFXe8hveO/Ya3ux
OBA/OVMXajKXrRlw97grU+GeNwDLXk/34y60uefrDlAL+rhL1DUa1ulD/LEv
DeoSmgdnwX2l1uxJjPQRJ/drZ6DzVfxeg7nAMh/RPhHDEuDtSAtrCXZ+wJe+
fG/606p9KktcyWsI8ZZQT9771lDHTmDZHVMu9SBHavIw0DtCLhUJvQvUvt3T
HnAHLiCnPfj/NkyH+rTg3XpQqF68Z7WBYtyDRPgGEu9giLm8QLMh1rK0dpT7
Sc1eJqUb37PNMeEhD+4H63PvqsLZDcO3Il9zq0D+K1f68/454dvFOc2HGg7H
9RZzVtSLc2A+ubE/Z/IPZhjYMA==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE1IlGEUha9aOqOGP+PnN6MzQ4ZFRggVLVrkonS0QBcmiIsMLAiKiqAf
oQhK+6GVBVFQ1K7IknJTaLVoVxKkoKlt+iOipEVlFkHRc7izOPC+373vuefe
e2Zqeg607881s61gEWhLmbWCj3ycXGx2NzQ7Xmp2KmL2vsBsRczsO9+KuC9E
zeq5z4DL5K4lvipp9rTS7EaO2YYisyMVZofBQe5nKNDIebbE7Dz33Dyze+Qu
i3nsExwPuB8t9bP4MnGzzWAN9daBIvgHK52vFv7eCtegXL3ZHZi1lLn+Tji7
uTfH/a001VH7Ot/6813zq2qzi2mzgWKzOPld5HbEXdshcqZjrkn8yp+oMltP
zTH4f9F/JXqaiPfBvRo9L4jXZPuZ480U9a4kzEqiPs8h7j3U35fv+i5QuwS9
ryOuIQPXnjLXNw3qOf9Gz0nif8AkeqdAJ7GQ9w3UaszOJyg028LuMmAOffPo
ec6uxkKfjTRpdiOha9MMdwbOobfSlOaeoWYTSHEeIvcs+guivv+9Za5R2k6D
ZuWmvBfN/Fipe0a50izvtKRcizz0j1gOeg385TwPfoB+tLzhzZ3Qe1av77hv
o3ZHwvnkmTZizfA9yfMe5cUg6bOXJ2eYzXS171IzukV8MHQu8b9k/t+4RyO+
s5+cV8Z8l0v4Nso+HoFnxZ4jL11iDifyvT/NZjn32sBn1Apuw/EW7kjUvTFe
5b8NeWRH4B6U94bzfNfSJC3a+Wf0NMV9lsrRLuuS/tvRTkfQUph0r0tTbznf
0+5NzeAhXEvh/EruFzg3cd4V+D4+UP9cwjVKm3a4nXNDhXtRnhwmfj/huarX
z9sEiIM+MIG+hdBnox21k3szq189X2PWV6u9N3m2G/6NWX7NTF6ezf4/KC5u
eSyVrfEY/tHQtcuPA/Q2Xu7eVk+atTwjr2jm/wG8XaeW
           "],
           VertexColors->None], 
          PolygonBox[{{6145, 4445, 2319, 6554, 6144}, {3895, 5508, 5507, 5512,
            957}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1Uz2MTGEUPTtGlvfE22fNzjAzL0gUFAoFjWxlZykolBLN6kioUIxspffX
a3fXz+pIRKPQS/z3ViKZv0fCNl6cs+cqvnw/995z7z3nfgeXrl+4VgNwkWsb
V5YD9wtgnY/FbqDLNUiAlaZtei9T4OEUsEz/YWL7H55/0/atZttCC/iRAcd3
ABu8r9SBU9xHiWPkf2MvcJPr+3bgNP3nZ4HVuvGU9xH9z3SB2zNAh7gTvpcR
+7kNfGn7LnzFyH+t7lw632kAJzPXqV6U9y1xTkw7j/yW6PMsc20VezzccA/D
1Lh6Vy2KV+wi6zlPHn6lruk9V58+Y95HafSYOl5nYegsH2H3cuMvEGcxd9yA
9VQ144s72VVzjz5nuX6m5uZyI/ih//6djlFPRWg0CC7Ej2zdqHmeHF/KrY/2
qZbPm9yP5e7hxRw5ZY5W9D4KjT+S4w9t6/aU/PRDizL6V19XiNFj/N+a96u5
z9JrnHhmVOfdXa7n3R7gXuG7eFR/6ndfw5pt9U6MIrRQTcKTpmX4K7f0U796
f9z0jCqXuNFM/eegiljNkXpQrOxHp419TppybQZ2GfVU4SefSWq7eLs1Y75a
oVcZ+mr2NFuqaxxa9GP2V2P+VZ9sWzOTmCPp9Yp1vc6s7UbY9H6APLxsmrdh
aKLYr7PmXbwc6fj/KIe0XA9dHpDjT23nOET/53Pu+Y32jmtV/Fr8F2k+iRya
iydN41WhgXwmwYF89LeFofh/LXOzwg==
           "],
           VertexColors->None], 
          PolygonBox[{{4028, 6574, 2330, 2028}, {4430, 7494, 3058, 3059}, {
           5535, 6213, 2098, 1193}, {6059, 6058, 686, 723}, {7497, 7496, 540, 
           3058}, {7210, 7209, 1192, 1846}, {7123, 4816, 3215, 2797}, {5430, 
           7125, 2798, 247}, {7825, 7826, 2800, 686}, {5807, 4215, 536, 
           1834}, {4423, 7492, 3054, 3055}, {4073, 5825, 1846, 2098}, {7492, 
           4425, 3056, 3054}, {7824, 4384, 709, 3215}, {5238, 4898, 1834, 
           1510}, {3895, 7495, 3059, 126}, {7126, 7127, 2801, 2800}, {4425, 
           7501, 3064, 3056}, {7124, 7123, 2797, 2798}, {6145, 6142, 740, 
           758}, {5079, 5081, 765, 536}, {4013, 7493, 3055, 316}, {4219, 6392,
            723, 540}, {6071, 6074, 2028, 709}, {7128, 5430, 247, 2801}, {
           5475, 5474, 316, 1192}, {4459, 5535, 1193, 765}, {5406, 5401, 126, 
           740}, {7502, 5182, 758, 3064}, {6574, 5237, 1510, 2330}},
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6071, 4384, 7824, 4816, 7123, 7124, 7125, 5430, 7128, 7127,
            7126, 7826, 7825, 4367, 6055, 6058, 6059, 4398, 6392, 4219, 6060, 
           4220, 7496, 7497, 7494, 4430, 7495, 3895, 5508, 5401, 5406, 4422, 
           5413, 6142, 6145, 4445, 5182, 7502, 7501, 4425, 7492, 4423, 7493, 
           4013, 5474, 5475, 4926, 6212, 7209, 7210, 5825, 4073, 6213, 5535, 
           4459, 5702, 4458, 5081, 5079, 5814, 4215, 5807, 4898, 5238, 5237, 
           6574, 4028, 6074, 6071}],
          "2.76`"],
         Annotation[#, 2.76, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6133, 4904, 6865, 5173, 6864, 4902, 6130, 7189, 7190, 5701,
            4047, 6129, 6128, 6855, 7866, 7867, 7865, 7178, 7179, 5802, 6073, 
           6072, 6860, 4897, 6087, 6089, 6090, 5239, 6875, 5240, 4910, 5080, 
           3881, 5534, 7068, 7067, 5936, 4712, 5471, 5470, 6215, 6214, 6211, 
           6577, 6576, 5180, 5815, 4418, 5476, 4862, 5479, 4424, 5525, 4446, 
           5181, 7504, 4053, 6552, 6554, 6144, 6141, 5412, 4421, 5405, 5400, 
           5507, 5512, 4733, 6760, 4728, 7729, 5487, 6233, 6228, 5503, 4461, 
           5188, 4057, 6949, 6805, 6483, 6484, 6061, 6535, 6536, 4429, 6057, 
           6056, 6482, 6054, 6132, 6131, 4048, 5811, 4049, 6134, 6133}],
          "2.6399999999999997`"],
         Annotation[#, 2.6399999999999997`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5497, 5866, 5861, 5187, 5542, 5546, 5502, 6227, 6232, 5486,
            7728, 4727, 6759, 4732, 5511, 5506, 5399, 5404, 4420, 5411, 6140, 
           6143, 6553, 6551, 4052, 7503, 7505, 6555, 4447, 5345, 5344, 4061, 
           5758, 5759, 4917, 6878, 4916, 6879, 4051, 6575, 4050, 6137, 6135, 
           4417, 5386, 5935, 5385, 5452, 5453, 4911, 6193, 7193, 7194, 5812, 
           5813, 4913, 6874, 4912, 7881, 4036, 5381, 7186, 7185, 6088, 4896, 
           6859, 4892, 7868, 7869, 6857, 8164, 6856, 4891, 6853, 6854, 6850, 
           6852, 6851, 6863, 3888, 5934, 5933, 4711, 5684, 5683, 6083, 6082, 
           5299, 4276, 5810, 4903, 5111, 3944, 3889, 5352, 3894, 7076, 5941, 
           6157, 6156, 4056, 6489, 6490, 6488, 7137, 7136, 3978, 5552, 6652, 
           6653, 6651, 4622, 7629, 6659, 6983, 8156, 4183, 7394, 5797, 5492, 
           5497}],
          "2.52`"],
         Annotation[#, 2.52, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5496, 5865, 5860, 5186, 5541, 5545, 5501, 6226, 6231, 5485,
            7727, 4726, 6758, 4731, 5510, 5505, 5398, 5403, 4419, 5410, 6146, 
           5408, 4054, 6646, 4621, 6556, 6648, 6647, 4329, 5639, 5136, 5137, 
           4915, 6005, 6004, 6002, 4817, 5391, 6877, 5390, 6139, 6138, 6136, 
           6532, 6531, 5161, 5454, 4359, 5387, 6113, 6876, 4914, 6192, 6194, 
           6195, 5780, 7019, 5034, 7018, 5035, 7020, 4392, 7490, 6507, 6509, 
           6508, 4357, 5806, 4356, 5380, 5998, 3968, 5369, 3967, 7122, 7009, 
           7121, 8076, 7120, 4945, 6292, 7304, 7305, 5801, 4124, 7303, 7302, 
           7948, 7947, 5108, 7999, 8000, 7996, 7998, 7997, 5685, 7177, 7176, 
           7175, 4890, 5164, 4010, 7026, 4011, 8083, 7025, 6050, 6052, 6051, 
           4012, 5788, 7150, 7149, 6053, 4861, 5138, 3977, 4874, 7853, 4875, 
           7854, 4871, 7852, 4873, 7851, 4872, 7950, 7951, 7308, 7309, 5551, 
           4490, 6618, 4540, 6239, 6617, 6616, 4090, 6249, 6602, 6597, 7534, 
           7529, 6607, 6358, 6666, 7623, 7628, 6658, 6982, 8155, 4182, 7393, 
           5796, 5491, 5496}],
          "2.4`"],
         Annotation[#, 2.4, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5787, 5298, 8167, 5297, 3879, 3939, 8030, 5032, 8029, 5033,
            8031, 4856, 7843, 4858, 7841, 4857, 7842, 3966, 7468, 4348, 7467, 
           7470, 7469, 4324, 7451, 4323, 8158, 7062, 7063, 7969, 4980, 6364, 
           7396, 7397, 5870, 6367, 6366, 6365, 4981, 6958, 5155, 6883, 4921, 
           6201, 7035, 8092, 4068, 7036, 4067, 7966, 7967, 7965, 4973, 7968, 
           4970, 6951, 4972, 6950, 4971, 5642, 4628, 5160, 5159, 5779, 4358, 
           5384, 5755, 5754, 5388, 5389, 4404, 6530, 4403, 7491, 4005, 5472, 
           5473, 5163, 5162, 5869, 4361, 6802, 6803, 6003, 6006, 3973, 5548, 
           5549, 5550, 4620, 6348, 6350, 6351, 5346, 4177, 7389, 6353, 6650, 
           6649, 6147, 5409, 4368, 5477, 5478, 5402, 5397, 5504, 5509, 4730, 
           6757, 4725, 7726, 5484, 6230, 6225, 5500, 5544, 5540, 5185, 5859, 
           5864, 5495, 5490, 5795, 7392, 4181, 8154, 6981, 6657, 7627, 7622, 
           6665, 6357, 6606, 7528, 7533, 6596, 6601, 6248, 4089, 6615, 4085, 
           6244, 5361, 6592, 6587, 4344, 7461, 7466, 6465, 8098, 8108, 8103, 
           4139, 6629, 4134, 5305, 7311, 7310, 6619, 4541, 5027, 8081, 3984, 
           7856, 4877, 7855, 4878, 7857, 4876, 5037, 8142, 5036, 7828, 7722, 
           7723, 7721, 4723, 7724, 4710, 5700, 5932, 5110, 5109, 5786, 5787}],
          
          "2.28`"],
         Annotation[#, 2.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7056, 4703, 5107, 3938, 7061, 7060, 7059, 7717, 7716, 4274,
            7432, 4275, 7433, 4709, 7435, 4278, 7434, 4279, 8001, 8002, 7074, 
           7075, 5706, 4722, 7738, 4740, 7736, 4739, 7737, 4881, 5038, 8087, 
           4021, 5798, 4022, 8088, 4882, 5028, 5763, 4146, 8110, 4948, 5713, 
           5712, 5363, 6329, 5368, 5616, 5611, 5143, 7579, 7584, 7316, 7321, 
           4144, 7958, 7748, 7753, 7743, 7763, 7758, 5120, 5598, 5603, 5310, 
           6303, 4133, 6628, 4138, 8102, 8107, 8097, 6464, 7465, 7460, 4343, 
           6586, 6591, 5360, 6243, 4084, 6614, 4088, 6247, 6600, 6595, 7532, 
           7527, 6605, 6356, 6664, 7621, 7626, 6656, 6980, 8153, 4180, 7391, 
           5794, 5489, 5494, 5863, 5858, 5184, 5539, 5543, 5499, 6224, 6229, 
           5483, 7725, 4724, 6756, 4729, 6761, 4432, 5407, 4433, 5513, 4369, 
           5792, 4865, 5165, 4014, 5480, 6064, 6063, 6062, 4864, 6840, 4863, 
           5789, 6352, 6349, 4966, 6940, 6236, 6234, 4486, 6581, 4484, 6801, 
           4818, 6798, 6800, 6799, 5392, 6363, 6362, 6360, 4979, 6957, 4704, 
           5686, 5288, 6529, 5289, 4360, 6476, 6478, 6477, 3969, 5382, 5383, 
           4811, 6791, 7823, 7822, 5593, 4194, 5591, 5592, 4627, 7630, 4626, 
           7631, 3880, 7064, 3867, 7055, 7054, 7715, 7714, 4700, 5677, 7146, 
           6031, 4845, 6827, 6030, 6029, 4349, 6469, 4210, 7427, 4262, 7425, 
           4261, 7426, 4844, 7143, 7142, 7141, 4843, 5672, 5671, 3930, 7053, 
           7052, 5924, 4698, 4855, 8136, 4854, 7058, 7057, 7056}],
          "2.16`"],
         Annotation[#, 2.16, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz3EYx/HHcc7nzcz+G3GxLXHDuOJiSOaQrbADIdwoTHFBjhfON9Ic
swMmhibLbEI55KxEKy4IK2yUC+WQMq//xbvP93m+z/N5vr/v9zd6xbqitV0i
4h8yBkaUDIk4O0icKZGI6KQj5M8Ni+iWFdEdXVGk7vPQiEX2JmZELBB3GRFR
pXf68IhJcvkolu8qXy0/Q36y3O7siMX6plgn0iKykI3e9nshhX9P9ECZ2lKU
Y7+aA8hDLn5jHGp5tY+M+IJqPVWo553m/O/NTafDUZkecQQJuQH2s+gpvv2t
j8o3D4546azPnHmv3H7sQ7a4UH4UHSK+pK/QOediHnLMzcV69/GGT5s7++Zc
a8Xj5DfQPFpBZ7rHGWjit8e8MvVLsBQXUyNW6luFHWq2mVNlvZVuFxepr/Nt
53A2+Q78qu0nzMvEZB75ch1q29HXWfthoPwA7DNzjnsoxGzMlxuvb7O583mf
ptP0feD5CRvF61Fr/U5dsXO8dl8FvqWT12Me95Fixitez+RWi9fgrvXDZCz/
y/u0Wv+gK8TfzbgtbsFPnmPU52CauIZ/PeqQa69NbmzyHvTd0vfRed6i03fO
Tf6HmIpZKECqvgnqjznvYVTzPYE0vR36vuOXdWPyHLyb6XPf3kDrUYd74q/2
eqhbzfOQdy+nB+lyWmL2ed5nUIVHyXcxI1N9A30tvil/Bw/wUXydXsVlvBLX
q+ujfgu/Gr4V9CTdRJfxb1X3Ak/xVv0V9Qn1f53/T/J/UHdB/TVv0YTrKNX3
xPeX0SP27ltX0oXe74a7Py5OtddivYtHo3gn/Q8V2pZR
           "]],
          "2.04`"],
         Annotation[#, 2.04, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0Xloz2EcwPGHpKbYsM0ut7mGOTY3xT+uOUNqMlsWkyvlbtQ25+RKiXK2
YqUV5cgRJkcotaaVtIw/XDNH5tgfeH3/eP/ez+d5Pp/P83m+v54Fa+etaRVC
SPHTLjaE+MQQ9nYOYVD3EPZxojgBnZ39TgvhD36hPC6EFo63v0VuVqcQ9tu7
mRrCYPEC+0M4SW25PpnWwzAU2XKz+KD94XyAR3Ca3Gw+JJ6lz2GezZPkj0vR
k8fwfB7LJ+JD6KFmoTiDc3mX/ftcxtW8k5/psc08JdaliEkO4bxZV3QJ4QLP
sTcX6eK+6IeN7s5Wt4lH8mZ5zUnejp9Il7/c3hvrt8hRE2ev2Pyx3AcZ1qXq
p6kv4+m8lmfyHs7g3ZzDX813JiGEsyjtGEJBV/NyPt9zXo0iOcNRH9Uizr1d
/AdJmOH9L50NUD8QL7y92EzbsQMN5nmNcjkp5kpFMor0SeMV/J4/6VOn70Dr
EnuNen/GGm/95mw1fxLn+oaJ5htmvgTO5KH44OwjVslr794OiEWM2jgzTfWO
yfir/rH8+2hrrhp3PrVXKF4Zvdn6YRRH39vMtdbfOV/c5H+/Lb6OZvf0kt8P
E8WnzV2JCvSP/h97vfmkulvqGnybV/gbffdu/ndMwBRMRry6IfKPecMRnNL3
ePRGtR/UNeGn9eVoDr2v8TPvr+JKVKBa/NFZG3mFeh7y7lwu56W8yN3n9T6H
k3gkv8IdqfKruE580/5dPECD+CpfwkXUiCvlxcjfqt9pfdfxCd7AefrXynuO
J3glv6fco77fD/N/Fe/2fzTzH/Eo7220rvb2d7xe3kyUiav0HO/8jvv+ObvC
LXwj+i5y8vRd7DzNf5zPy8QJvkG9Od5ihPtH44vcJe5sLe8/z6um2Q==
           "]],
          "1.92`"],
         Annotation[#, 1.92, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz3EYx/FnoYYL5r/Z/Oc0Fw45XFCUw4WbJXOhuZCz2M0kQ26GnA+F
kthCs7DSSqs5G8IkJaW0zWnGJkRz3ohEXr+Ld5//832e5/M83+9+K1hRVrwm
IyL+IbNfRNfgiJ39I77TXXT0gIj1wyJ6y/10ttdZQ37ENRQ764vcgRE5dKO6
A6mItHgQ3gyJeIsx6Yg2uQq9f3lU0i7n3djHZz96DIo46bwwN2IWNqnfjAV8
81CsZh4q+JfSI/S3GRNwWr45O6IFffX2QQevJvEo+7eZ8xJfzf6GMrlyubU0
2245eCHfigL1z+hztCAl95g+xRNkib/leR8U2WOPPbr8/sz3C77bp9TeDc63
Ju9Et9HdWREX3fECZqtfLd5hh/Pi7bQTX+2ziv8WO0wcGjEJLeJm/OBR756V
vJvEi/V1J+8h7qJX9a50dlxcQlegp7pe6Mfvtt3voBH5Zg/1Rmk6LidiLKby
7q83K4FfCgOwku8rXu14gZdowx/1H+283F0+0RvOriQ7qS8wYyRmiKv51aIG
o+Q6nI2gVfqu62s3uxV/vVOR+87FdBRiJlL6xquv9LaHcILvUWTrfa/vE374
fS7Zg/dl+sC96mgtatAo/iDXQ10Jz4PeYyHdR5fR+Waf4X0KVbinvsaMtPo6
+lh8zfkt3EW7+BKtx1k8Eteqy1Rfzq+abxk9RjfQpfyb1D3EfbSqH672cPL/
Zv8v4j2+m276SzzZfTv9bnT3d3SdujnYKa7jOU3+pnn/km+K/qYNybuoWcp3
kXy+v+/y5JsQZ3uDNnu8xkTzp+Cz2iVmZqj7D08/ptA=
           "]],
          "1.7999999999999998`"],
         Annotation[#, 1.7999999999999998`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4649, 8131, 4650, 4229, 7412, 4230, 7413, 7648, 7647, 5255,
            3852, 8051, 4651, 5091, 3923, 3853, 7048, 6397, 4237, 5949, 5950, 
           5951, 7049, 6398, 4247, 5952, 5953, 7670, 7671, 7669, 4674, 6404, 
           4257, 5959, 4258, 6405, 4695, 6734, 6735, 5666, 5665, 3964, 5221, 
           7428, 7429, 6410, 6414, 6413, 6996, 6963, 6964, 6368, 7398, 4198, 
           5730, 6770, 7399, 6771, 6369, 6775, 6774, 6997, 7037, 5047, 7045, 
           5048, 7038, 4997, 6216, 4074, 5734, 6776, 7211, 6777, 6217, 6780, 
           6779, 5087, 5762, 4223, 5251, 6016, 3980, 7475, 4375, 7474, 7477, 
           7476, 4337, 6451, 6453, 8166, 6452, 6494, 5362, 3899, 7478, 4376, 
           6493, 4377, 7487, 7488, 7484, 7486, 7485, 4017, 7860, 4883, 7859, 
           4884, 5800, 5799, 4023, 7161, 6424, 4283, 6422, 4282, 6423, 4380, 
           4828, 8134, 4827, 5604, 4145, 8109, 4542, 6304, 6630, 4129, 6299, 
           5306, 5599, 5594, 5116, 7754, 7759, 7739, 7749, 7744, 7954, 4140, 
           7317, 7312, 7580, 7575, 5139, 5607, 5612, 5364, 6320, 6636, 6325, 
           4554, 6316, 6311, 6306, 4544, 6632, 5122, 7779, 4750, 7769, 4745, 
           7774, 4950, 7333, 7328, 7323, 4549, 7586, 5145, 7596, 4565, 7353, 
           7358, 7363, 4575, 7348, 7343, 7338, 4560, 7591, 5127, 7800, 4765, 
           7790, 4760, 7795, 4957, 7378, 7373, 7368, 4570, 5151, 3986, 5618, 
           4590, 5765, 4595, 5623, 4149, 4586, 8128, 4581, 3952, 3915, 8066, 
           4780, 4154, 7613, 4605, 7603, 4600, 7608, 3991, 5213, 4186, 5914, 
           4191, 5218, 6163, 7900, 7905, 7217, 7222, 4077, 5724, 5888}],
          "1.68`"],
         Annotation[#, 1.68, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/G3HP+QY45t2Bx/IPddyj+slP2jsbk2ckauacMkR+IP5ljm
WiOaWGlFRixZcya1JlkkETNXUW6xFY/fH8/f6/N+f17f9/v9+fy+3wFL8meu
axMRnf387hXRHU1dIgb3jRiIx+kRDWhMjpjdI2Ja14hk6yk0S9wuKSI3LWJr
N/t0J11Ew36RdU2/iAJaz5uk7mbxOM+0t39EvlZcQvfbP4RT1kUp6iGVr9r+
ct5LPSOW0b8olTuhVrH1XjTxlYtf05EY0tv8mGzOPfZb1RouP0gum6+5e8QI
8WtzvkETSvVOttfqzCWeaaEH6Xt7H/AOEz0zm6cX/qkZqRFT9cjAcLVHYCgy
+IbRCn1mmfUMzaY35fe7ywPYi30oxlE80b+vuvW8hf6DAhTq31GPTpiuRyZy
edIwqk/EaDTrM5aOwVX1N4g3YgZvFpbxDsU3ue/4gp/4gRr+LfQ6zeGdg7kY
x18m/0T+GH1KV5tnFXaZtVa8TX4HtiNX743YlJjJOUZhg3WZs2Q4d6H1PMzH
X/fWKNdC/+Ce3F2s0XMyKq3PIUefbNxyByvpYT1X0FKa7/n1WIs7eqyjbc3d
kqiPpeKL8q3WNWoOdH831elP6+gAmuY9e6nWC7z1br1Dg9wVMz2gVbQSFagT
v/dMG+dakvj/PDOX7qELaI5eZ70vp1GOu/wV3pcU/iramPgO5GtxGy/Fl+kF
nMdDcSVfB/4i9U6qu5YepwU0T/1HfPW4j2f86Ynvxdm+mvuzeLf/5hv9JR7v
jB+t69xDM83ny8ROcZWak+zf0K/VXjX9Ta/RYzx56s6zn+o+F9LFie/WHTw3
xyuM1n8CPvHm6vkP/wEjLahq
           "]],
          "1.56`"],
         Annotation[#, 1.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03toz1EYx/FHhKKY69ymWSn+MLcyRlEoTfpRmzW5JLkby22MUi7bkJRJ
c2fKpWTzh0tkchu5lUuxf+aSEUmEPxBe3z8+v/d5zvk8z3nO+Z1v5tzl04pb
RERHP3+7RRTRpw4Rw3tHZFNTRkQjpaVHzOkSMbNjRHr3iEKcId7Le6FPxM+0
iDr8jVcwx/qZThGb+kZM4immt9auiT/gMOs/ukZ8Na6w5y/jJv4G668ww/w4
dfrifd5K8yvVON85opYei+vwKG3uFbGF5uvrHq7iK1Tzpv5uUQNPe1xt/pza
tfRAzQE9Ih7iQLwkb4r123wrekYc51mONViC7cxvcA/HknzeOjpPN8wvNl9l
fhEupSU0Sy8z6Yb6Weqf5B2j/l1soG08d3A6FtBW+cvskyNnJNWrO9kZDpo7
RAeokecwXsX9+BL34Qusxi1yctVc77wFapThaPFl66NwnfgrXymOSHz878Wj
xSn+MfhBfJG/GXPF73AUPtPjAv6F9MaZlvI/VONRcu/JHYgX0Wn+d/IrjbfT
EWfOco6pfG3cQ1tqTTVqfPemSjCTrx9lUbPcoWpMwCE4EYclNfXQTOPFg8SD
KTu5G/Ur1T+MFfLL6UTyv1HKnvneSQEtNC7E6VSvRrnzXMMKLJV73fvb4xxV
dM6bq8Zy/e2kPPt+4cvj/+NNprBF8l3ovVR8ij/lW8mnIspI3gLOo9l01vpG
vir+lViTvG3zEykvofof1cuV99n6WPyGz/kv6Kua/4l+liX3RenJd4VltIYO
Wd9tfQftMr7qjHuwlfyhvGvFac5433qJ+YviNfjP3Gz7bDLOxzIswpZyUrxj
5XdznxMwX/w0+c/1+YQy9d2fXqvRyf3/pP8/KaVJ
           "]],
          "1.44`"],
         Annotation[#, 1.44, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3920, 3959, 4785, 7810, 4786, 5319, 5318, 7808, 7809, 7445,
            4303, 7443, 4302, 7444, 4772, 7805, 4773, 7806, 5989, 5988, 4295, 
           6440, 7086, 5985, 5984, 5983, 4291, 6436, 7080, 5980, 5979, 5977, 
           4284, 6425, 6785, 7812, 7813, 6784, 6845, 6844, 7138, 3981, 8077, 
           6843, 6017, 6460, 6459, 5088, 5301, 4224, 5253, 6376, 4201, 5735, 
           4200, 6374, 6372, 6969, 6968, 4217, 6889, 6890, 6204, 7208, 4070, 
           5731, 4069, 6202, 5225, 4212, 5528, 5069, 6416, 6417, 5995, 4265, 
           6415, 4846, 6828, 4847, 6829, 4696, 6738, 4701, 5928, 5929, 3870, 
           5335, 7831, 7832, 7830, 7834, 7833, 4840, 7837, 4842, 7835, 4841, 
           7836, 5275, 5276, 4839, 7139, 7140, 4000, 5668, 6716, 6443, 6444, 
           5991, 6466, 8074, 3961, 6467, 3962, 8075, 4801, 4528, 6919, 6920, 
           6291, 7925, 7924, 6913, 6918, 6721, 6731, 6726, 4319, 7558, 7563, 
           7280, 7285, 4106, 7636, 4111, 7295, 7290, 7573, 7568, 4252, 5563, 
           5567, 5272, 6278, 6283, 4938, 7918, 4682, 7675, 4687, 7680, 4313, 
           7543, 4519, 7247, 7252, 7257, 4637, 7272, 7267, 7262, 4524, 7548, 
           4243, 7538, 4514, 7232, 7237, 7242, 4933, 7913, 4666, 7660, 4671, 
           7665, 4308, 5557, 4504, 5329, 6252, 6256, 4631, 6271, 6266, 6261, 
           4508, 5263, 5258, 4493, 8123, 4498, 4099, 4657, 8054, 3856, 5322, 
           4464, 8118, 4469, 4094, 7518, 4479, 7508, 4474, 7513, 4610, 5199, 
           4159, 5909, 4164, 5204, 6098, 7884, 7889, 7200, 7205, 4064, 5649, 
           5877}],
          "1.3199999999999998`"],
         Annotation[#, 1.3199999999999998`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4788, 5727, 4787, 5022, 8069, 3921, 5721, 3919, 3958, 7115,
            7114, 4304, 4776, 8133, 4775, 5719, 4774, 8013, 5021, 7091, 7092, 
           3909, 5714, 3906, 3949, 5987, 5986, 4292, 6437, 7082, 5947, 4743, 
           6766, 4286, 5978, 4285, 6426, 6764, 6763, 6815, 6816, 4879, 6068, 
           7158, 4018, 5740, 4019, 6457, 6458, 6454, 6456, 6455, 3892, 5113, 
           5112, 5871, 4277, 5300, 6379, 6377, 4643, 6679, 6375, 6373, 4642, 
           6678, 5082, 6421, 4270, 6203, 4269, 6420, 6419, 4451, 6561, 6563, 
           6562, 4450, 5688, 4449, 5526, 3871, 3932, 5101, 4350, 6032, 6033, 
           6034, 4399, 6518, 6517, 6035, 4351, 6470, 5133, 6468, 4347, 6027, 
           6028, 6882, 4920, 6200, 7034, 5046, 8137, 4919, 7995, 5014, 7992, 
           7994, 7993, 3872, 7927, 7928, 7926, 7930, 7929, 4942, 7939, 7940, 
           7931, 7938, 7932, 4122, 7945, 7697, 7702, 7692, 7712, 7707, 5100, 
           5573, 5578, 5285, 6289, 5280, 4116, 7923, 6912, 6917, 6720, 6730, 
           6725, 4318, 7557, 7562, 7279, 7284, 4105, 7635, 4110, 7294, 7289, 
           7572, 7567, 4251, 5562, 5566, 5271, 6277, 6282, 4937, 7917, 4681, 
           7674, 4686, 7679, 4312, 7542, 4518, 7246, 7251, 7256, 4636, 7271, 
           7266, 7261, 4523, 7547, 4242, 7537, 4513, 7231, 7236, 7241, 4932, 
           7912, 4665, 7659, 4670, 7664, 4307, 5556, 4503, 5328, 6251, 6255, 
           4630, 6270, 6265, 6260, 4507, 5262, 5257, 4492, 8122, 4497, 4098, 
           4656, 8053, 3855, 5321, 4463, 8117, 4468, 4093, 7517, 4478, 7507, 
           4473, 7512, 4609, 5198, 4158, 5908, 4163, 5203, 6097, 7883, 7888, 
           7199, 7204, 4063, 5648, 5876}],
          "1.2`"],
         Annotation[#, 1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV00lIlVEYxvEjtBCcNSu1lBJqUdAuJVAjJa+ZBNfCFhYpaOXiFlhgkQQl
kVRmBAY26KIWDdCiLBSKKMthkWKoEBS0ySihsFUQ1e9b/H2+d37Puce1zUfj
iaQQQpI/sYwQsteEMJkZQiadoFm0mj+DjrNTaTrSsIN/74oQquiZohBu5oSw
h12Pft+f+W7Qt+rW54Xwhm6gjwpCqFSzW14Ffch+gF3ya3E+O4T97APYujKE
e7Rc3svlIZTSEr4t6EKP/F5ciRB7kc9Hz4mdxZKZ780cyQqhz87DtCzqh8VV
IXxdHcJPe5y25za+TlpBi/Vbhzb1X8zdp+8Re31T00ZT1aRgo1ktqDcrjnLx
MizwXc+1q5wm+VO0mabrnYE0xM1KMyNmvxpUYydm+eYxhzF93hS6Q4xiHGPY
pPaQ+GG0YIjdSkvMLEUTe8Qec843j2nzq51lQP9B3MJBd3GbZtlrWs1T9iV5
z+gc+7X6OjWv6En+D5jFeHQe8SF5E+x3qHVHSebnyU+mmXbMRQqKkI/vdhpV
N4E78nv1HaA5apbE/7njZe6lgtagCh/Fuvxu3Ug4RzuS+WaiN0g72R24xu5B
P9+w/s/Rp3eXGd2Imb1oRszuv+XV0b90Xv4JetdZ6vSJowEF4q20CY24L35K
3lX5x+ggu5y/ErFI9V/QvzR6I+Jl9Aedkf842kX+lH3a7JJArngn7UA7+sUv
i1/ARd/D0bumSeo3yz3OTvcWxsUT/E/Y7fQPX6M5nb7jtIM20KCmTm6Z+hzv
cjuNs6d9T9pzCoX2Lsan6P/bb/gL/wHzl5M1
           "]],
          "1.08`"],
         Annotation[#, 1.08, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz3EYx/FHZCW1mdMOtiHKDXbhkJwP8zeWHEoxF2slmTYshbiwyVq0
aHIxyfnCFGWmiJvZZA5b5jBWTqXIlLALa3J4/S/efZ7T93me3/P/Tyjdsa5i
UET8w870iMIxEWWpEeezI87hLHaJT8mNuJ0WUcU+iN8jIwYwW7yaP4POwky0
jIpYrEduZkQespGDrryIcfQZXSR/Ve8GPTr4m9kraSGGil3W5woaUSpWo+d2
b2rZrcm91FTYtRxNYyOuo0ltmvgv+X40q18tX+DNcizDCiTQ51s2ZUUUYyPG
q8/D0XERT+S36vOB5oo9pjn0VEbEnRERb9nvxZ777hNmvuNn6DGJv8b3ZbEz
8dWMhPm99KP9h3k7Vf4zPz95kxz3wDT2Qr0XIU2v9WY3sI/YZbzaOXrk0QE9
fqPPnHqxSezJyNf3pnk/xZvpD1on/5328Kfq101f4xVa3OW7mffofXdrQxl/
G67JF4yOmG7+KnpS7DjeqenBQfZ+3FD3Ur7IXi1q95rXgxd4YG6nXLO92vkd
WGnPcLMM9Sk01d1GYRhykYlee7Z6146L6o/pe4ame/ND/q+Zg91nAV2BpXgj
d8gNa1HuXpVIEeviD6cH+HtQz69Dg9gt/e8mv03vQ2bUImH2VzMSdu9XV0T/
0G71u+kl31Kkz1psQJb8FlqCYjTK71N3XP0OepY/X3wJEknV/5P+s737Ij+P
fqNd6puSu6jvtE+lXTroPG/moorf5d5PUeLbh/gNtouXoTr5f9S3zX1bkY3T
ftMaNYdxwX3OY6J+beo+mpkm3s5+iDo8xiP8B2h3m1g=
           "]],
          "0.96`"],
         Annotation[#, 0.96, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6824, 4836, 6821, 6823, 8169, 6822, 5670, 7713, 6732, 8170,
            6733, 7431, 7430, 4267, 6418, 4702, 5294, 4273, 5919, 5920, 5296, 
           5295, 5699, 5303, 3893, 5940, 5939, 4718, 6751, 4795, 6755, 4719, 
           6752, 6754, 6753, 5304, 3897, 7847, 4868, 6841, 4869, 6842, 7174, 
           7173, 4889, 7864, 6849, 6067, 4372, 6487, 5089, 5090, 4370, 5737, 
           4371, 5416, 6070, 5709, 4735, 6848, 4888, 7862, 7863, 6946, 6945, 
           6977, 7973, 4991, 7972, 4992, 7974, 4990, 7976, 7977, 7975, 4993, 
           4178, 8112, 8113, 8111, 6486, 6485, 7130, 8165, 7129, 7132, 7131, 
           6481, 4365, 6479, 4366, 5349, 5348, 4009, 6049, 5343, 4328, 5395, 
           5134, 6447, 5135, 4452, 6795, 4814, 6296, 4813, 6933, 6934, 6340, 
           7384, 7385, 5776, 5777, 4852, 6036, 6037, 6038, 5469, 5226, 5227, 
           5775, 5774, 4213, 5287, 4266, 5070, 5102, 6538, 4440, 6170, 6175, 
           6180, 5444, 6190, 6185, 5450, 6548, 6543, 6109, 6104, 6527, 6522, 
           6834, 5588, 4171, 6336, 5751, 5848, 5843, 4806, 5581, 4531, 5831, 
           5836, 5193, 7935, 4119, 7942, 7694, 7699, 7689, 7709, 7704, 5097, 
           5570, 5575, 5282, 6286, 5277, 4113, 7920, 6909, 6914, 6717, 6727, 
           6722, 4315, 7554, 7559, 7276, 7281, 4102, 7632, 4107, 7291, 7286, 
           7569, 7564, 4248, 5559, 4253, 7552, 7553, 7550, 4526, 7551, 5052, 
           5053, 4940, 5917, 5169, 5170, 5043, 7167, 7166, 7165, 4886, 7861, 
           6847, 6824}],
          "0.84`"],
         Annotation[#, 0.84, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5415, 4927, 5166, 4015, 5640, 7154, 7153, 8032, 8033, 7152,
            8084, 7151, 4867, 5856, 8044, 5056, 8043, 5057, 6948, 6947, 6804, 
           6495, 6496, 6069, 6908, 7908, 7909, 7225, 7226, 4081, 5736, 8015, 
           8016, 8014, 8018, 8017, 4488, 7523, 4489, 7524, 4335, 6011, 6012, 
           3976, 6497, 5302, 7480, 7481, 7479, 7483, 7482, 4334, 7454, 7456, 
           7455, 3887, 3943, 5695, 8071, 5696, 8147, 5058, 5906, 7718, 7047, 
           5062, 7046, 5061, 8049, 5682, 5680, 5681, 4809, 5905, 5077, 5078, 
           4810, 7991, 5011, 7990, 5010, 8025, 5029, 5031, 5030, 5894, 5895, 
           5745, 5744, 5893, 5743, 7298, 7297, 7296, 4941, 6290, 4112, 6285, 
           5281, 5574, 5569, 5096, 7703, 7708, 7688, 7698, 7693, 7941, 4118, 
           7934, 5192, 5835, 5830, 4530, 5580, 4805, 5842, 5847, 5750, 6335, 
           4170, 5587, 6833, 6521, 6526, 6103, 6108, 6542, 6547, 5449, 6184, 
           6189, 5443, 6179, 6174, 6169, 4439, 5106, 5518, 3937, 3877, 5461, 
           5076, 5464, 5463, 4214, 5229, 6124, 6642, 6643, 6341, 7386, 7387, 
           5341, 5342, 4963, 6932, 7960, 7959, 3970, 5529, 3971, 5393, 4363, 
           5436, 4364, 6513, 6514, 6510, 6512, 6511, 5243, 5244, 4426, 6148, 
           6150, 6151, 5396, 5760, 5414, 8091, 5415}],
          "0.72`"],
         Annotation[#, 0.72, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6450, 6008, 6009, 3975, 6503, 3974, 7135, 6007, 7015, 7014,
            4820, 6866, 4906, 7875, 4905, 6902, 6903, 6219, 7212, 7213, 5826, 
           6222, 6221, 6220, 4928, 7895, 6904, 6149, 6534, 6533, 5083, 5293, 
           4218, 5246, 6093, 6094, 5394, 6092, 6091, 6550, 4393, 5435, 6196, 
           5339, 4326, 5524, 4325, 5337, 4613, 6641, 4044, 5228, 6123, 5234, 
           4410, 5075, 5460, 3876, 3936, 5517, 5105, 4438, 6168, 6173, 6178, 
           5442, 6188, 6183, 5448, 6546, 6541, 6107, 6102, 6525, 6520, 6832, 
           5586, 4169, 6334, 5749, 5846, 5841, 4804, 5579, 4529, 5829, 5834, 
           5191, 7933, 4117, 7946, 5196, 4944, 7299, 7300, 7301, 5669, 4123, 
           6923, 6924, 6921, 4943, 6922, 5679, 6041, 6040, 6039, 4853, 7840, 
           7119, 7449, 7450, 7169, 7168, 4027, 5692, 7172, 7171, 7170, 4887, 
           6042, 4004, 5697, 5698, 7871, 7872, 6858, 4894, 5804, 5803, 7182, 
           7181, 7180, 4893, 7870, 4333, 6749, 6750, 6748, 4717, 7719, 6449, 
           6450}],
          "0.6`"],
         Annotation[#, 0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6524, 6101, 6106, 6540, 6545, 5447, 6182, 6187, 5441, 6177,
            6172, 6167, 4437, 5104, 5516, 3935, 3875, 5459, 5074, 4409, 5233, 
           6117, 6573, 6122, 6567, 6565, 4043, 5519, 5521, 5336, 4443, 5340, 
           5338, 4059, 5434, 4060, 7195, 6198, 4444, 5174, 4037, 5645, 5646, 
           5290, 4271, 5245, 4272, 5084, 6684, 3884, 5481, 7070, 7069, 5938, 
           5015, 7000, 4716, 6907, 4929, 6906, 7897, 7896, 4055, 5761, 7010, 
           7011, 6153, 7013, 7012, 4390, 6010, 4391, 6504, 4332, 6742, 6743, 
           5931, 5972, 8062, 3886, 3942, 7104, 7103, 7873, 4899, 7874, 4900, 
           7032, 7033, 7031, 5044, 8036, 4029, 5693, 5694, 4901, 5884, 5885, 
           5085, 3885, 5809, 3878, 7102, 7101, 7100, 4789, 5729, 5728, 4035, 
           5805, 7184, 7183, 6086, 4895, 5376, 5375, 3965, 5997, 4962, 6331, 
           6332, 6333, 5748, 4168, 5585, 6831, 6519, 6524}],
          "0.48`"],
         Annotation[#, 0.48, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6502, 6075, 6076, 6861, 6862, 6095, 7187, 4038, 5808, 7007,
            6740, 6741, 6078, 4708, 6739, 5351, 4032, 6081, 4427, 6152, 6154, 
           6155, 5427, 6905, 5428, 4715, 5423, 5937, 5422, 5628, 6685, 4645, 
           6683, 4646, 5292, 5291, 4203, 6381, 5438, 4395, 5781, 4394, 6838, 
           6839, 6197, 4860, 5468, 4412, 5522, 5523, 5175, 5520, 4042, 6564, 
           6566, 6121, 6572, 6116, 5232, 4408, 5073, 5458, 3874, 3934, 5515, 
           5103, 4436, 6166, 6171, 6176, 5440, 6186, 6181, 5446, 4442, 6111, 
           4441, 6539, 4040, 5373, 4041, 7188, 6112, 4402, 5158, 4003, 5433, 
           5235, 5236, 4416, 6126, 6127, 4046, 5379, 6796, 6501, 6502}],
          "0.36`"],
         Annotation[#, 0.36, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5378, 4355, 5851, 4354, 5377, 5999, 3972, 5421, 6515, 4396,
            6000, 4397, 6516, 4388, 6077, 6079, 4031, 6644, 4030, 5172, 4428, 
           5482, 4387, 5704, 4385, 5629, 4614, 5426, 6342, 6690, 6691, 6382, 
           6383, 6384, 5632, 5633, 4859, 6045, 7147, 7148, 5437, 4006, 6046, 
           5465, 4411, 5822, 4415, 5530, 5531, 5178, 4455, 6120, 6571, 6115, 
           5231, 4407, 5072, 5457, 3873, 3933, 5514, 4435, 5439, 4401, 5372, 
           4352, 5690, 4353, 5374, 6125, 5378}],
          "0.24`"],
         Annotation[#, 0.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6797, 4815, 6001, 7041, 8144, 8163, 8162, 5054, 8042, 5055,
            7042, 4964, 6938, 6939, 6935, 6937, 6936, 4045, 7893, 7894, 6891, 
           6895, 6894, 4707, 6998, 6999, 5930, 7065, 7066, 5455, 5456, 5071, 
           4406, 5230, 6114, 6570, 6119, 4454, 5177, 4457, 5533, 4414, 5821, 
           5824, 5467, 5819, 5817, 5783, 4008, 6048, 6044, 7024, 7022, 4616, 
           5853, 5208, 5210, 6689, 6687, 4175, 6343, 5425, 5630, 4386, 5635, 
           5638, 5171, 4617, 6080, 4619, 6645, 4389, 6797}],
          "0.12`"],
         Annotation[#, 0.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6893, 6209, 6210, 4072, 5691, 5882, 5883, 5462, 4405, 6568,
            6569, 6118, 4453, 5176, 4456, 5532, 4413, 5820, 5823, 5466, 5818, 
           5816, 5782, 4007, 6047, 6043, 7023, 7021, 4615, 5852, 5207, 5209, 
           6688, 6686, 4174, 5424, 6345, 6344, 6346, 5429, 5756, 5757, 4965, 
           6347, 7388, 4176, 5631, 5900, 5784, 5785, 5855, 5854, 5179, 6892, 
           6893}],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{5636, 4618, 5637, 5634, 5636}],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXd4VUW0t5OcJPReVJrSEVSkSIe96b2pIFVAuoA0QYpILwpIUxBQOoiC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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVM9LlFEUveqMM37+mNGvX+qkfTPTzFRiE9FEq1r61S4mNwWBFLRwRvph
EpmtgmmVaGD/gUkgrTJ1Ewi2bVW2KHAVEWlUkhFU53QetLh877v3vvvOPfe8
FwyNnK3Wm9kdWAOs4pk1t5gtwXk3YrYQM1utMxuA/znWL7Hub5K/jA35PrMv
vtkW8qcj+jJnKqL8dfzf2222t6i6zD1dVB7tWIvyS/geh33EeiwwuwHz42Yr
ncCVNHtRp9ySyzkX1z/Xy6gfFrX/VNrsQKBzuW8+q71jUbOv8G2acF6O63zG
51PKeQtsf3qV97rb7BMs1Wg2FNV3A/6ZDrMa/Dvx/ywmjpgfol4iqvoBOHnj
K/9El9lv1FxF7CSwZRG7iNyfjeKRHLLO4SbVepVBP7D7yNlsN0vuAdf14nPd
4a/tNxuFPcaea556YU9+D+okNa+cp32XkD+B8yc69R+2YpawYcT9fWZdSZ1P
/GGLesjDXy5oxuz1luu3P6kz/umhVWewPr952Cz8W25N/VRzZiOwgsOSczmM
F9x6DnwmgG0N8cG4dEY9/IjKxxzySy2w9+ttZk/bdC45Yd/Mp9am3Jo9cM18
8nEzEGZyylmSc9bb4Wq+A8+jgf7J69FD4vYRsE32CkcVZ871aG4TB83eo+5V
T9g4N9Y/Aw0OFKVRzrMWV+wB5j6Z1pyIbblR+BpQf6ZbvfLecSbU8zjq34ZV
PZ3B/ITLCd3sGKu4/O/A+A32JCbcvBvkh/eDa3KShQ43UtIh99PPvYvt0ij9
rF1xs2N82M13wemcvI2jjw+BZkVc5J+9HAFnix2aP3st9KnfbU+5rHce3Fwo
Smfkn9yRtzVfd4b3hdrIOQyZPsXoJxZqjnj4JdYlp6mB1v+YB12/xMa7QXwP
cYd2pfUGUGucK2dKvsg9NVaA5q+kpSPGFpz2qInQ6YR3iHeSMc6Y/PIN4b0c
c3ef+qJGyBVnse24JvfkmjzzfSr52hf44pS4y2m9X/Sn0ftnxKLN0mObr3q/
AvXD81ZSmitrTuPNmM1Ic9zDN4ZvGudGH/H8BSs815k=
           "],
           VertexColors->None], 
          PolygonBox[{{10325, 8232, 1976, 2632}, {6431, 11057, 2805, 698}, {
           10324, 4142, 454, 1975}, {8190, 4120, 448, 1478}, {4122, 9411, 
           2351, 1974}, {3758, 3694, 1785, 1378}, {12360, 6075, 3127, 3126}, {
           6200, 7126, 1564, 1378}, {7342, 7363, 1478, 448}, {4878, 11078, 
           2808, 2472}, {11304, 11303, 757, 2149}, {4120, 11298, 2821, 448}, {
           4319, 8847, 2149, 2674}, {4318, 7724, 1723, 2673}, {9147, 6200, 
           1378, 2185}, {8565, 4745, 2121, 2068}, {8179, 6898, 1527, 1963}, {
           12361, 7593, 489, 3127}, {5974, 8231, 1975, 2350}, {9127, 8451, 
           852, 2184}, {5101, 8767, 2143, 2821}, {7033, 4611, 1527, 1557}, {
           8451, 9168, 2185, 852}, {11078, 4897, 2134, 2808}, {9839, 6912, 
           423, 2600}, {5079, 3758, 1378, 750}, {12380, 10877, 1295, 3145}, {
           7849, 5974, 2350, 1785}, {6616, 8746, 2143, 750}, {9837, 9838, 
           2600, 2599}, {11300, 11299, 750, 2143}, {7063, 4777, 728, 1527}, {
           8564, 4573, 2068, 2067}, {12317, 6431, 698, 3083}, {8808, 8788, 
           737, 1976}, {8679, 10325, 2632, 2134}, {10875, 10874, 2669, 
           2670}, {6912, 8180, 1963, 423}, {8080, 8062, 695, 728}, {3760, 
           9608, 2472, 100}, {12362, 12363, 3126, 757}, {4918, 8699, 1399, 
           737}, {9411, 9107, 2184, 2351}, {8746, 6595, 448, 2143}, {8566, 
           8567, 2067, 454}, {7724, 4319, 2674, 1723}, {8726, 5081, 754, 
           1399}, {4793, 9837, 2599, 2805}, {7593, 10876, 2670, 489}, {10877, 
           10878, 2673, 1295}, {7147, 6616, 750, 1564}, {10874, 6021, 3083, 
           2669}, {4745, 12379, 3145, 2121}, {8191, 8211, 1974, 754}, {6898, 
           4759, 1557, 1527}, {6160, 3699, 100, 695}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3434109920501255, 0.14433218927753477`, 0.5996860093711079], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG1s1WcZxp+enuJ2Tk+hZW0ZCIWyvoSW9hSBQtlWZkmHLvrBGObiEl1h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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlntM1WUYxx84gHlUrgIGIQLCQdBzMPNCOsDZNHO11hRz2WrqWi7TTMU7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           "],
           VertexColors->None], 
          PolygonBox[{{6884, 7049, 7048, 4759, 727}, {7407, 7386, 628, 4537, 
           7406}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.37579040740041336`, 0.20063124802481047`, 0.6451991946812636], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFllls1kUUxad0+Vq6t3ytrRQoHwVStOKDW4IgRIPBGBPCIsQEkAAuKA8I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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lwldUZxg+EEJY2N9u92QgQQnLjvSGRTq3EESPajktbaZ0mVrqIAto6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           "],
           VertexColors->None], PolygonBox[{{3868, 6900, 6899, 7985, 1871}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.40816982275070113`, 0.2569303067720861, 0.6907123799914193], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQ1lUZx8++u++790UM30XdG+wl9mVdcBLBdLImMMemyzQJNiI2XVDw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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0lOUVxt9kMiELZrKQkZAFsieThIQqyHK07EVaxHpK8IBFtJIWKAEi
qwTZBBRqD0sNEkCsIhRQ9kh7WoIsYbMtmGDLXk7ZqgIlEUoLUvt7er8/njN3
Zr73/e571+e+mS+Of6Yy3DlXHuZcBJ9HA869kuzcdHAEeWW6c5MynPs80rmx
4KUS52YlOPcq+AlyUifn1j3s3Aqfc82tnbuZ59wZcBrcAAHWP8r6A6ztD6bE
ObcT7ACTQR77vFHG76xNQ5Htac4dAg1gG2hCj6W8ZwloRD7HbxtYsx6cRf57
e+fuhZw7FePcaA5wNsW5kiznisEZ5Ed4bnyRc5XgO8irEp1bzpploBY5hefO
JbEOtEUeyDObeXYTeBK5ONO5bvzXFRQh/wKdF6JvFfpOxl7/butcWalzpeAu
8j/jnXuX/9eCm8jD+f059BgOhiFXpjp3tZ1zV8A45NXst4hnp7PfW+zXj2f6
YLfeoC/yXvQ4lo9fQD3ylKBz+1l72c87sFdzmtlEtrgFhnKGPqA3KAfbc8ym
suU25AXotI19w3nfUzFm63z2y2tnNk/gnE/yngEgHvkGtr0O1qHbvmjsjU2y
+O8r1mZHOVeH7hH85gO7kG9znr9gh1jiIYKYiixwrh1IAX5wq9Rs9n9bIV8r
dO4+mB9hawYRczH8fjLWYvIEsfXXXPYEx5HH8+w80Jpno33mizvERYXPfLKF
fccX807WV2Ojp9HdLx3BYOSR2G9NR+wOnkduxVn64NfZ2PIKZ6pDHoMOS1j7
BOe7g11exE8vgNvI3dmnB8hu7cU8z/bmXL10NuSnidMP0GcdGIw8GHsksi4B
PIU8KmQ6SZeXQKjE9tDawhLzRbPnS/lkbJb5VL4cA5L5/T/E0rfo2558KuE9
h7BXAyhOtv/e74CvWtkzJ9C1kTj/DBxHHsGZ3+RzPvqP5f8Qa1YTExex9Xq+
L2Cfpfy2BMxHfiHJaoJqwcgks6V8KN/JpsrlxfhmUa7l9Cx0/BIbfgFeVfyx
5hli94dgG/LMEstp5XI1cgQ+TWGvS/irHzGwEv0O45tPkA9j3xz2eZ9nfkf8
PeBMWZyvO76Ii/R8xL7F/F8EHs+3WDuPrucCFnN30fFUG4vFP3Hme9SiGt7x
Eb4tYL8g349w/sMgGfkV9nge3UaoBubb2aaBqd4ZI7FjLe9fCfzIazhTkOeS
wWrkEHmby3laOM8QzrCQ71VgIlgA+rPHcDAM9AMr2loNUu2pQV4GpqLfB5x9
EudrYd+enO27oBk5McVqmGpXAvJZ3pVHHOWCM8i/7WAxrtjejbyfd4RxFgf2
Icdj8yByMgggH8HWtUGz9c+waTk2GE7NHgaGZFhu3eP/zhGWY6uwUyEx2IFn
I/j+UCerSapFF1T/U60Gq/beQB5FXbiAbqN5diDPHMIG32fPgaAB+UN0quKZ
Q+RePfVlIvsPIO6Pc/YD+GdTNjYnBvxgI/JB7HAAHPWZTop92eCMlwPqXZX4
fFyZ9bA38MlWdNkCXkd+gn0+zrTc/mO45UYdsbIrYDkymho5BrzL/5sw207F
NTiCbkejLdc7ghIv5zfhr1vEfQvPfsp+dTz7Jd9P8/0Yz/8303ws3z5Azkmy
HFFuZCPXqsajZz1YWWq9QzVPtU49pIkz14M9oBEMxz5ZfFZFWY5fw7b/ACv4
Xs77A9S++9S0eyAOuT22vc15BqHLRZ5/Fp2LiIsQGFpgsfg5+p6Ms5hUb/iU
uHgu1nrEfNb60aU/tp7rN180ebrIJ6olG1i731lN2YgcwH/7/BbD6u01cdYr
1eNlq7XsmRZtNmtBvyRskwiakafSl6eBn0baOxWrXXnXY9kWszuI151gIvod
dZarH5MXdfmWs4qtcOSwfIsxnXWsVzt15m7o07XM1qqGy5eymWwlnxYR21up
F1tASFyEuInE5n7QgPxVyHq2erViVr5TTVMtkw//xuduMMdnNpTu8awJhOwM
R7FlEDtv4HwxfuMGV/jt8sPGEcRFwtEzrINxkrvsOYgcq3iIs4WbLurp6uXS
SbVaPUe9RjV7FXsMYt0PFFvIj2KrcNV89HkNey7HxvOIjblgmSerRqs267cm
cA1cBY0e97gAznscpBw/haVZ76lE/3nYbRZ2C/dZz1VtqEUvn89qhGJLNpUt
FWO3scOMBOs9a33Wi/t7tVA9eTjvnIwuk8Aw5OlBq4mqhet9xt3mgNkeh5vA
mjKeqfEZhxB3ehYM9TiUdFcNbfbOIG4nTlXvcbyKfKv5qvWjQAPvXcHvNeAg
8gzqQk/i+RjvryV/fs9Zj4Mo3uf3WW1VTVUtVY0Vl/sm2XJRnE61Wzmu3FYN
315inFhc+Eexxm1Uo/d5HOcQfq0hTt4CDTnWy8QRxA3U0y5iv4oEiwXV1Ezi
9DLfJ0aZzT9MtB6h3rAZORrbPUYdP8j7vo40bqyYViyLI6tWiPOK66pmPFB/
TLdeEOK89zOsZ6pXFoL0gHEicaG0gHFj1TjVNnHkS9hmLzGRxtki0WcFclYb
s9UEbHgT/ackWC8/EmO9cQK2GV9qPbKF/5vBTmc1t6GdcRRxk6t+qzW7cq0W
q+bsRdcI+owP1Kcb16rn3HsSjXP5c60mqxZ34J1N6NMFfVqhz0z2S9LswrrR
kZaT2iufuMprb3t2ybAaqtopGy4ljrvzWzewBLkoz3q+en0s51nMmmowAyxK
Na4SRJdv/cZZlNtBkOzluGYTcQhxh0ov9yI9rqwcPI8tzoasd+5m/0n47eUU
m5V28M70eIsZxUoa8pwMm0E0e8zOsHfpGf2nd2qWe5vzjom0mU6xrhlJs5Fi
XrNVk5f7mrFOYO+Pcq03awZQ7s3h/bNTLAdlK8WEYkE2+4Lnq1k3Er51kuev
Ye8RbYyrV/mNq4ljiluKs6lWtiKHfxxrNVO9YxffJ8VaD2liv625NnsoJnbG
G2cTV9uBXJduMSDf70q33igOIe6gHvkOvtkBtoM1ILrUerx6exPv+Ey1kXfU
IUdH2CynGayvN9O14kxRIMxnM4K4n3JMuSUOWNfRappqmXSWbdTT1Mtko8tl
xqHFnS+V2WygGVqz8zqPq2hG0GwgzqJe34Oc7d7Wer56hziduJx6SDXnnplh
s7g4kLh1hVe7xLG7FNkMp9mtc5HV5uUFNuupRu9ldtoMYnw2Q6lWzsV3cwJW
M/tij9c6mq9UU6ux6VXOegXMSLdc1Uw7zMtZcd8QKPQ4cDf26JpnXEg1U7mo
GUSzh3IyhzXX2xqXEEfWWU9jx1OpdmbdHYiziavpDqGK2LlfbLkqnbcrNtDx
5VjjAJMTrKaoloizdc6wmqdapzuHyUHjqOKmiknpqpnhcU/ndGLwmwyrbeIk
yo2fByyXlSNzM20m1SzaXvNgjuWgck+cqiXbarpquThYhzbGkcWNFTP30W0P
Os4ItzsK1XZx2o1ejY9LtR6j3qIacb2NzSyaVTSTiRtN8e5KxJHuJ5pP5It7
icbV17B+dcA4e1/0jSqyWVbxqrsT9Xz1et2hyNeqYapd8vnb2CeGM22Jshoo
riwOUetxZs2+urMY583AJ3j+Bj5YxLNR2OARYul7hcYtVFN196A7E92V6A5C
vrqVYbVXPvul12PVW9/Mt9lKMatY1YylWNvIe36TajEnbr4P+ZNU4+iadXqA
7t7MU845DmKzA2BImq3VTKxZWHtothvlzdqa8XRXoRqp2qg7C3E97aG14nzi
jje9uytxSM2y4sziypppNxfbHYPuFtTj1Htfz7S7EPVgcS/lvHJdHKwXPilO
N19opnkv32ygs/8637jdv9B1mjOOp1zQDHXDy4k72C+KnGmMtTsR2UIxIN/L
JtfxxfGg+UIzs2JhoTdrKiZ0VydOJS6lOztxTd3Z6K5GnFN3PZpJNIvozkdc
+j1PN3Fqzd6649PdnmbwHPbNzrNZXRy9ADk/z7hsRaTV0nMh61WqqfKVarZq
tXwWRNcBHY0LiJPqLmyx1yt1J6a7pUsJlmu6Y1Lt1szY4NXwr0uMg4p7qmf8
mf0ag1a7FZP72ONgO+MKuiNTbPTCtz3TLEY0+/8q3XTVHUACZ4vvZHeHuoMQ
93zH6xXioH9IsJlRs6JyWL1ddwCa/dXjY4n9uwXGdcQJlUviUOJOyin57nbQ
eo18+D8XPTkH
           "],
           VertexColors->None], 
          PolygonBox[{{7233, 4253, 480, 7231, 7232}, {4630, 7605, 7604, 7625, 
           1535}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.44054923810098895`, 0.31322936551936176`, 0.736225565301575], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmWtwldUVhje5kJzknISIJiGay4GE2mAIVLQCrQM6/tBOO1o7DdjqtFqn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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXlYl1UWxy87sslP8AfEIggI/tgnywVb1KysmdKaJzW0xfYyUXIvQ9HS
0mkeQxNFabHGSkvBpXoyITMsrdRwykqtbNHJXbQsrebz7bx/fB8O73vfe+85
99xzvuf8skZV3jAm2Dm3Kci5UP5elOFcD/AY8qAw54Yij0h3rgLchJxwgXPN
nRgPOiE38OyhFOcWM/ZouHNhPudqeDYDhCL/mOTchlLn1oMfkFflOvcaaO7A
vCz8OvJqsJn/7+D/46nO7WW+r8Ax5HC+O1ni3AkQhjw70bnd3Z1rA48j909j
D/HOLQP9kB9nzOnOzt0Z4lxlDGOzWQtsAm0gKNm5UYxZwn67gIF+dC12bha4
ArkCnAg4ty3KuQejnbuadYaz72HgKuQXM9k3a1WA5ciPoOd7vAtlrn3oH44u
P8VhN/QZJnRlXjAADAVPJji3Bt1WgyeQ/WXO/c73qXz/O/vtpf/Z57hY1gW3
YOP+2L4fGIm8hvnr2Oto9raF+Tfz7dBS08WB5/m/E3McY65VPDrImr35/xbm
GhPp3FbsuBd8BVrB7ejbwHzLwG3I2dj05XznVoCuiWb7X7HZ2WQ7g1t5NgI7
VIBbkM/kYG+QFGw+MBGdnu3GnGAC8ivY4imdG/vZyX6K2N9s5nkcFCLPKnCu
iXGNYCZyIXYZgv6DQQHyLNapZ50lYCZyLfq8DO5Hl3vBA+yrrtC5ReB+ZD8+
8Bvf/Qo6Iy/GbktACHubh4+vYz/zsOFcsBY5DttMRu/97O1b9ljM3Fv5thUU
dTVfPsFZH483n5b8PPo8V2rPHmJf51n7HKhC3t+RfRc5FwD7kG/DF9/I4w6A
Wzubra9i7StzzebPsoeVyBs5yxfYw4gCs6FsV4Ecxh3I7+JcHghFDmPsCfbR
EGI+VoTOhWAGl7cG5HHndrLvB7DNfHw4A/26gFjOPyOC/bKHy9lbMf5TCq7j
XcBvvlLFmMXFdgfk+/KxijKbQ99+IH/k3VTW+IS569lDCP9n8U0mCEZuSbc9
a6/NyNfz7XCeb2T+8bHmmy9w7vNDzEfPo+O1zHcNOIc8qNjOVGd5dbHd7aPY
9Uii3fE6xvRg7IVgEfIqfKIOLAIrwdPoNwT9BoP5yGWsPZJ5RoBS5EbstwR5
DLq1Yr8/2UsSe3KxdgenYOcJYBr6TgfzOOcXOaM1DKlhv418uxZURdsZXMxZ
9MywWKk7UEhMGC37gwLkfsxfj68vAZcjT2LuieBR5q4GC3x2B+T7tcgvsdZJ
4s927LswxHxlBKjwfCYDn/qZOHAGpCMvYK4aMAPUgggwIMu5KM6/B/N/zHxN
rLsf36hFhxzeTWSdu9jrxzwr8ZuO0u1enkVg4ybucyMIR56OHof55idQjdwX
nY6i7ynmfgsE8f1cvq/m+1HB9u7mMvMVjRnDWuc5h2no8jP/byUu/J3/rwWt
yIcKLaYolhxEfpnxu7FFG1iB/A3rzmH+8cwfyfc1/P8dzxtYq4T9n+fMH0S/
0eBcd8sdusO6u8ohPfm2HOTy/SeMvx35PGN7EQuuizH5rxgcY8+OBiwnKRdt
5Qw2stZlrBmGPUMjTX6HZ19E2TOd9TAvtuvME/HbSdh8IkhAvhA7/g0sZe4i
xq/DpknYyA/WIq9lrXW5dpfuC7bYsos97UyyGKOzrUGPGSl2xq0Jdgfk++8j
P02MK2euPmA+cr18nTPZ5MzHFXsn6T4HWww+hX5NubaWfGwzugxEpyvAu8hb
2esiYu8zoBU5Hz87xbwnQR5yHXr14fta7k4ZiMF2xX47+z3MX8l6gxlzPRiD
3DdgOkvXcuQ+7PlP1voD9E6wu/cHuv4SZHfwDN99jt0+A6eRWxh3B34+l/f9
sV91svmMfOVR5CvwoeFgGBjQzXznEDjo+dCNxN17wN3gBpCabzFasfmCfMu1
96PniUjLuS3MuwqsBM1gG+Mexlengg+RL8uzHKbcdWme3cU7iHWjUu1ORuTb
Gpo7HMTgk2f5+wuIRj7ImHmMnQt+RJ6NXRqJDWuUE5FbultMUyxr7m65eCN4
28vJynXK0crNynnKxWNBpZeTLyq2mKxY3AN5GjH4IFztR/AI8il0GMA8/cFJ
5HL2kcQ7P+iDvEK5lXeD8I14/Kc813KMcovOfBpjIhgbrvlSjRtpTa0ljiQu
pTPS2YhTnSYOD0W+CbQXGXc7JDt4HC4JGxaAAPCDhgR7JnkZ8kd88w34GmwH
y3n+b/AUeAGs4oxbQDNYCerZ02vsbRVYgvw1Y9rBKbA/z/auMXonHTLZQw9w
IegiW2LTWWAmqATTfZaTlYurfcblivDJwizjdK8yTzG+UQReQf4ozu6I7oZy
7npssK7YuM8ObLoFG/3K2QyMMc4YqvzD2R/A1t9Hmy3kY5d6NhmEj6Rwbsng
auQm5urLveoWYznofY8Di/tuQf6W+Hwg02Kl7tQQ5E89PnCWO3odNv2B778H
/0A+zp35CnwJjoGidIsJigWFyBvwkc3o9S5Yjzw0zdbUWjchHyAm9eW7VHR7
ljUb0acqw7iocs6bnFkke44AbyBPx7cWgFpQnW+xrZ21Tvksxu1mXBuYSTys
izbuOhIcijUOq291Z3RXNMc1nEsueuSAQQXGlZQjlRvFmbbnmQ/o7LflWa4Y
x/xjiy1nyDeUo5Wb5SNz0OUhUAVmK7bkW05XLh+Wb1xyWoZxfXHK+3hWGm9c
VHdGd2kDY9an253SXSsBxd6d68keO7FXH7i4wLii7qTuojjjq9y3V8DbHYwT
ai5xqmZvzsPE0Cqf1U7KqeLmZfhPaYlxdHGls5ztL6XGmXqXWg5U7svBZ4bh
ey8mWe4fjA6jEizGKbbdjjxUdR4YHGSccie+/Bx4MsSr2XjXwNhlHa0mlK3G
sfbYErPZLtZqQ+9PwU7kPejynuo78DkYzje9Sm0vQ1h/BN+N5NxHgArkk+yh
O/cumrOPBTf7jUOKO4ozHgwYpxCX2IK9ffz/FmfzJohHLvAbpxWXlQ81qNbj
fHahz4YY46LHGfdhlHHSn1U7Yaffkbfx/j/c47s4hzvBS8j3kh9ymK+c+Tay
5gSf1WiqzcShlBv3gb1ejhQ3bmf+j6OMI7fz/aGA7fUM3/+E/L+AcTGdsdaO
7GJcTXuY5LMaT7Wd9ihfFYcVd5XPynfk8/J1+dBkn3FacVnVrLqL8ezvSIzd
ySEBq6FVOw9GDkYnH7rFgyDkCOYJLzDd/uKM3a3mvcqLieIie7yzEyeRruJo
4mbSWbWpYkahV6OKS3RgvsgC4xS7Ocue6HgxaCu02COfk68pBsnWirGKrbK5
cmklGOPlVNVOy71YrxpK3H8sc1cWWA2wNc04irhJa5rVdlPAZK/GewA/bc4y
7iAOoVibjY1Coyzm7uROXsvergE78i2Xquac6eVU9S7U01AvQz2MjcTSSzIt
lqoG1bfK8crtmkPcTzXmWo8DjsUmleBGfP2foC3OOL64vXoeOexlIe+rg2xP
GqsegnoH+uZ8J8vhyt3nkJ8usppBtcJ85CtLjAOJ+wwsMduJY4hbyIbiHt+D
7zwOcglnMKTQ7lZ7hHEL2WCHxzGUS7d7sVI5VblHPQj1HpSDFuIDz7D/XPRv
DLXYoz0M9GKQuNhMbF7T0TiZYoPueIUXIzLijWOKW6YjZyXaHdXdfCnYuFuE
x53E4ZTrFDMUK5TzFEvj2X/HQoupqv1Ug6v2Vg24nrPekGVcXeet3k9f4mJ5
svWAlOvUg1HvRTmvhTvwKHacBpo7WyxRT0S9EMWUEJAE/CA403xPHEXcRD54
gHOYk2V7V01S5DdOLC6smjEiy3pQ6j2FI8/DfodzrLZcHmpzyyayhdbITLSY
pFikmKVaKYSzCM6zmkncSTXPOY9DiUvEYtc90cYpFKuPBKx2UcxWb+I9dN+c
bD2KJL/V2Kqt/X6LteqpKH8p5mb6rKenXl49+W1pinEGcYV65CeZ+4mA7X1A
uNn2S/zsi1SzsWqHleBVr4ZQbageh3obqhHF3VTDqHYRh1OvRTWnak31XM4x
928B4xKqscaVmc/KV8UBVMurZ6denWr6qnjjSOJG4+Kt9lcMV+xWD0DcXTWJ
ahFxeHG1rV7vS5xNtlGMUmySjdSbUg9BvQP1qNSbutGrHdSj8rGfZJ43RFiM
Va4TRxI3Us77ItFqGNUue5AHsqd/ca7vMH5bkMXCTI9rKiaKOyxlb2tj7AxW
JxsHFfd8Pdl8XT0S9Ubk86odP+SbD+KthlStpZ6serGquWR7+Zx8TWegWkOc
/RGv5lAvQj4vX1dPQr6/G7mts90B9Ro+Y57/xlnPYWKK9YzUK1LP9OE862mp
lzUVOYH3S8Wp1Q9GrmPPF+BPKWBRsvWaqhhbEm09J9V26uGqd6sar3s3i9G6
q5Hy2Tjr4ap3O94Z11bNqFpRnFu9yzz8o1vAepiqJbWm1lJNqbX3MXZvgu3h
Me7aEd7VcjfDOhhXVE9DvQxxRvUWFsTZWuoxqDcTlmRj1aO5O2A5VLnzLjDF
bz1D9QpVU4tbLwxYr00cewXvPy027roj2mpP2WyqV4OqNh/pt16LavQO6HCa
/wtCrQbVXT/ucXHdedWi8gn5gmrS3tnGecR1eomb8H0uiIoyHdV7XQuavB5s
cJr1RNULDUqz3rPudL3Xg1avPDbd7rJ65rrL6sEf8+70piw7o7/OBnusSbQa
QNx/daL5SiFyQZr5zBl0iSqx3ox0Uu2gHKbcpRqiKc1ytnJ1Y5r5zgKvdyUf
Uu+pyXunHpR8UzlPuU4+WsBeRne0Xq50Vm5r8Wp15Tj1Eld5taB6iv347rZS
6/XIByO9mlS1qGoScQVxcnFxcQbZTj2qVs+GymXqsai3opwWim7t6LiUs/sk
2rjwHK9WECeWb6rnUe75qGpv1YiqDVWDT0izHrd62+PT7LcUcWZxZf2msoy/
9aXWW1NMUO9NNYhqD/Xgwlk/osTWFkfPTrEaXrV71xT7bSIbv+iabb9RiIs+
7LPaU5x0XpzlcOXue0IslqWUWO2pmKZernKEcoN6uuql6zcP/dahnrpyzW9+
+1Y5p5vPcoZyhThBn1KrMVRbqOdWx54XZ5nvqAemXsdHXi2vnodi2d3e3VJM
U+2iGKrYqRpGtYM4q7iqagjpppivWC8d1RtQjfmG1yNQryHY83X1HE5lGwcX
99ZvWooNIV4uV4yYwt8OifbbiGK0zjasxO6uzlhcOYm1/Z2NM6tW0W9a+i1L
NYve6U7qLmqMegfTvdpWPQT9lqEz0tnoNw31lg/7rBeoHrNqX/UM1StUDazf
Olq83o9+89Dd0p3TXdMdU29DMVexVj0OccfJXayXLA6pWqUs3nKNapZdXa2n
o16O4tP/AbiMNzc=
           "],
           VertexColors->None], 
          PolygonBox[{{11017, 8537, 1980, 11014, 11016}, {7277, 7285, 7284, 
           3946, 395}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.47292865345127677`, 0.3695284242666374, 0.7817387506117307], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH1slWcZxp+2px+nPeeU4nYOlH4daMtW1q8Z/UORjAzj1waLji20c9Al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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl4ldURxg8J2RBCNnJvSAK5hGxkuYFKVRYVWZRFMFSFxIRNAa2yBNyQ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           "],
           VertexColors->None], 
          PolygonBox[{{8633, 4697, 4696, 8639, 2113}, {10922, 8428, 550, 4391,
            10921}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5053080688015645, 0.42582748301391304`, 0.8272519359218863], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlllslVUUhU/pLb2dh0gLtLftlVKgBe6tc9QaUEk0TkkBleGBCIKJA0Rj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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd4lVUSxg+QQAKSehNySb9ppNwbwEcsFAtNFFsCLoEloFR3pQVdXRUB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           "],
           VertexColors->None], 
          PolygonBox[{{6933, 4703, 4702, 8647, 1537}, {6803, 4657, 1547, 6966,
            6802}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5376874841518524, 0.48212654176118874`, 0.8727651212320421], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1Vl1MnFUQHWD5WVh+FstCW9llZZcCW7YU/Gs0RduE6pO2QNVX1Gj8w5oI
RgwP2r6YVNCqoYVE01hsq1FbiInGFm1ilERjTdonYygJKj4UKqBQINZzOOPD
zd7v3jtzz5w5M3fjnV37nss0s0WMLIxba8yaMSL5Zt1Bs7k8swGsx5JmVRgv
Yu3phFnbdrO/sDcdMlsNmF2C8SD25rHWj/MbKs2uRcyS2OsvN7sKmz3YP47v
wRyzCvx+U2DWBbtaAJjEff3Yf9W0xjnXD+GeJxLCQV/vYu3+DLMmYGxImZXB
7p5ssx6cb8HvKyGdXc6VjwH3+XmWsG2B/Y7NZj8AWzb8TeD7LqwP4fe+YrPq
7f6dp1h3ZstuwW0Z78FCs8tZuo/7L2SIg9EcYVvBvDWoGLcC49m42cew3Yh7
f/R7OxHTLObVmPeGxCV5Ix5ieTtDPva4nx5g+x5+3sL6qWzFQzxdYbMo1pcQ
bwewt2McLZTPl0Na3wCOht1nDGefD4ufJpxrLhQ28sg5zz6UqzvINXExr8R2
CPsXPYcXs2RPW9pwvoQzB8DBkO8faTT7KimbyWzFSp/ziH01ZnbGc9SXqVxf
LhDP5PvEJsXMeOvB4VRYMdR5rphT5qkzV9+ViOtZnFnMFc7fQsoR88X5afi5
ki+d8fzXwHWjSncfhm1/XL4DwLZSBg4xj8EuitGRqZzTF3VO3GM58sncHoiJ
B/LX5BxS27RbAc4twJ/CmMX6IxvNQlGz7zKlmWnHth9cdWDsxveXiP2LTeLs
FuTzwZji3AFMwwHZkkfySb3xN+HzUviuKxc+6oC5Yw5ZH91eI1cj0h/t9sPv
QayVY34Kax9h1HiOqTtiGw8pHuboQoHmjOtsA+5L6G7W+uMJ1Sh/57z2eT/z
ypzeBM7Hge0prC2nzdbS8sc96pkaOwM+P4sr1rZSs0/iipd5pZ55ZsnnsVxp
YsK13Qz+7kiq5u/Okz64V4WzrSHV6be4/+FGfT+ZUH9hvyDv0RzVbhv22zF2
Ya0EZ4oxxvLUt7jGM7Rhr2FvHAtqzpoi171edzkViC2i/rRQZHY9Ld7I3wXv
fScD0hN5fiCmfDPXp3HnZER5Yc6YO961C7rYuk11QT/jrk/2lZLN6i1LmD+T
UC0Nec2QH+roRr3878V8X0z8rYCzT+Oy/RU18Xq513BQtcQ6Yg1xTl1M5auW
6IfanwlL/+To3qA0Sh+BmPywR0ad/3hIdUXMHFwnJ1yr8jOr4Ol6mfhhLtkj
OI+6Lc+wH+x1/Dzb1KgzfyDumYRwsBbZh9iXxrx2+P0esN3WqPuo/XdyxPOa
19Elj3fae8g83rKFSp0bdI2wNtgjqEtqkrarXoPH/P1gvh5LqE7ol28q++y6
Vgs1J2/sB+2l0jm1dMxts5Dn3cXqxytp1Qx1M86emha2AeTzzyrpiPplPC3w
/2+9ehz7G2uFOFkvmcCThTGSJ0xrjpn9fsTrMAP7hyOaU9djrj3yz1wyXynw
f65ePeElYOy7WZqcdG3w3nNJvQHUEXvirL9DfNfIIXGeTyoexsJ9nlvymlp2
zGW+Tt6I6ai/lauOn/liv1v1fnUC2H9Ka/3varN/qsUpz/zi5/rylcv/+9xJ
t23Ypj7IHliXUu9exx3Q20b9MLfkgZyQ+zfLZc+eTB75LpODKedh3SaguNhv
fw8q9iD+w+TX6HsYGqgNy7YnX3fxTurwuGObQz+ZrVCOk+D1Ddwbxv7tmL9f
rtpiz6VeiIV9lvdR27U8G9V/lPPoIbUp4eE782hCbw17bo/HWhcWJuJh/sgX
cZC/UedwAj0tmdJbTC3Uh6WHEeTzw6Tqe6bE7DXsdXtM/CUXjIHYyENNSm8w
+xS12ut9nn2zxf9fsQdMOp/ruQxKGz+npTNiJBetzu0Y/I3G9Q5QCx9EpIdr
FerL9F1Wqb5MPR8pUjyMhX3tiv9PoK7Zc6ntIf+fyjM7HRs1MF8kTsknezD7
KXsp36I7/T1a8foktsVK1S018x+Id69y
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmWl0VtUVho8YwAQlCQkJATIRAiEJGYQ6C46AdWhLoq3gIjgPraKAQ6ui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           "],
           VertexColors->None], 
          PolygonBox[{{5836, 7630, 7629, 6937, 1029}, {8650, 3960, 402, 8648, 
           8649}},
           VertexColors->None]}]}, 
       {RGBColor[0.5684131440741411, 0.5349439472203632, 0.9096034310840624], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlU1slFUUhi/MMO3MtB3b2pn+ZGYYOx1/CrUVE5SVsRhK2Rhk4RjFRDck
RDApIbZRutBEQyI/QSViTCqtNoqGwNYUTMDEEOLGhYkLCwu1MZS/WEypRt+H
9y5uvvvd755z3vOe95yv8sre7XtWhxC+1UpofVYM4aTWWCqE75MhTOm5Xx8O
dIfwr84ndedaYwiLjT6/nPX7U6tC2Jj0nvOHCiFMlORHZ4/VQtig9YMCfbgm
hPZMCLt0PpoOYUb3Z5P+9oj2p/R8QLa/lH3nUCWEwxV/S8huk55vKdbr+v6T
1kRDCF/o3m35PSvbm73+xvnnutulb+PCc7sawlH53aaYA7o7obMdup9RTjd6
7ROs5Az+nbK/qP2wzhOP6k7euY43GOOzWvfLtl1ra8pxmhocqyi8dzu8vyLe
MjXjg9MFYfo54TyGmh032SnOS8b1tGy/a1Us7edkuyVnDGABE3Gb5ed0yvxM
6ntCtlO6s1o5Hu9yLYZ0dzTlWCf0/URLCHX5bNE+p3VG30qyf6nB/sHFnvs8
+cb+mnweKpjjPnF3MPL8eM21oS4/ioPL4uc9+Xw55Tzglmc9cv2cYm7XupQy
X2OR51HVarLi3OqKdTVvLncqrxtVx4Pv3Wuce7EphGdS5mMkZc3hZ5XuJqqu
OXpCV/8pr9lGn1GLfj2/lv0xnQ93m2t4xjf+8E9NvmxyXag1e+Jj9020Pak4
/dLEWvHxkTDsSZr/53X+cYt1MN1gvuDqHZ3vLdsfPrDDzxXlukjN5OM+PY9U
jDGp/ft5Y1+vOOu0/pb2NgyqlwbNAbjASt/sll7erho/eB5MG1N7XwjzeZ9R
P7DAybxw9Gjt09kt2d2suhevqz6vtbp2X+nsVNW+lnr9jfO5rPlEY32D1jfa
BguaBs+BijGBZ6nTtaSOv4uD37RmFHtb2bWn7m3ST2vR9Zyuml84qseeQYdl
5bLSYS21CctK2fj/0N1c1XzC/a8l85+Xv7V97oF3M+aY3Df3qPZauZQxzUZe
FjPWAbVeTpozagpP8IUts2M+8nah2zOReUht0BGc05fMOHpzU5xZzCI4Wo6x
qB08EQudLEf9pNVTw2W/g+Vo2rqEC2bmPe0pp2mts2nfwx6f9NVUnNnjyv1g
3r2Iv/MF3yUX7MCMntEa2F7MeQ6ieXyMxJk/E3UMtlq/6t1vnqhVZ833mDfD
OeuBef9wwb0NbvqU2bIyEMI/WhezruGdXteR2dla8jw4XPCsQafnstYZvX1X
dstaF7L2V4oz+d4MyPr9qnJ8Uxg+FdbN3Z6JYMbP+aznCf7Oxf3G+A5mtDwX
z6ktWqHWLyivhapruaT4dwbsi9yoPxwSeyjOTPq7UnOPdxStP7THLP0zbcz7
26w/tLdOXK7XupVx/dAhcfmvbo38/1X0jEC71B8saKDeZXy8HxFv16u2Lyj+
q2XnR++AC5636O6I1gc6e0PcXKp4/6Sw7Gjz/4TZs9BqTfAPxwf8HI+zA2xo
/Eycd82K1VJzbuiZvNEP/7FEp2c/mNHurvhfHYu80RfkTQ9Qs+b4LwMvnIH5
mHr5iT73ALO8J/Yguv6kZG3vi5rGJ/oYiv+t/wHaDDaa
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mXl4ldURxo8kJCFAFpKQzezJzZ6bAD6gVUERSMCtGmqV0AQXXAtqAgpF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           "],
           VertexColors->None], 
          PolygonBox[{{7628, 6932, 6931, 7630, 1672}, {4710, 6473, 1428, 8650,
            4709}},
           VertexColors->None]}]}, 
       {RGBColor[0.592219506690682, 0.5731941477542892, 0.9101461428271206], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVU1sjFEUvZ0Z881MmUbDTDs1Mx3GJEjKhigrWlqRWLSRkAhRbMSUZSX+
BqFLEaTUT6b1syERNk1E0pDYYMNCIlSbaEsjtEIRv+c4b9LFy7vffffdd++5
594v07a3pd1nZrex/FinPbNzIbOtAbM81tWgWRP2gZlmHRmzMzB+kjRbXmPW
XWb2OmIWgv1B6P9A/xvrCu40JMzWzjabA6evppnFQ7o7kTX7iNUclt99sC3A
TxG6TNwsDf1gGnewLnryzTdeQA47mW9V4p2fMbNl8NHuaaf/kh3fPQyfR7B8
8Gnw58X15mrIJ1wuOyFX58zqoT8AXTO+t8DHSchtafm+kAI2VWbvEWsfcqmB
//M+2SWcTD3faYSfPcDqW7XZPehGQtqPIITNiGWyzmwIukPwfzgjX11LzJ6n
hf1XnH/B2uvJjvsc5udyeuTT+Y60zvJY/RFnExDWzGswpPvUr0EtKpDDU5wt
RQwNlfJDLIkVMavH2W6sAuL8jrptgH073huoNXtTK5tO3N2Od3txdxi2d/yS
tzHWacKBfNkTEM78pr4LexT++meqdjxnLAfdeTIgm+mow9oK4co8+Ab9P0T8
vfP1/TummrFe/eXCl9iug240Jl9NwL6hRjnex91oTu8UcX45Kc7x3ijWXf9U
nSiPwGZ7VmeNCWHHWFnnPpcjMSX2+8q0/whLfhfR+8RwRk4x8Xs99qYK4XQL
Nb+ZUT3Jp4mgsC/gbLhc+YbA08RifbPnyFfWdC70i6CfLFcMd8PK/SqwuTZf
3+QvcSSGx5HHMawA9CugW4mVQIzdnnywxwPgdTdqM4Y4WlPqYfYve7e5Wpwb
WQhuoHYPcPcvzn8Bo2JQ8dc7zvB73H2fQW6rguJP0emIbYfrY/p8iziH01Mz
pscTLzhXDlRotjDO//GWaS7wmzHTH+OlzzhyqsqpBoybvGEfDDruE58t8JeB
jS+iuLizT9mjAynVv7Vcc489+CytnqTshzwRNavzxK+epGq6H3VJLdJcG5+H
2uSUd2kekQ/cvztucM87PXFkz/Kbc5C1Zy9x1vEd9kUP6vkhJT05MuZwJMbs
01K/1ju+jSBOf0pY5t3M4FvElfwltpxzu1zvBOOaiezTIewv08L3bEhYlP4D
lFlHxsE4yU/2z1FPczvvep3yf53Tk3/sFfZ1b1aY0udRyAUsP/I+hRg+QV4H
ORcXJ+iPmFBHPxvBz/ascu0E/uNZxcI4iTdjYz3Ye3yLdfg0T2cLcbc6Ls7w
/L2zqUXdMlhjEWHBM2L4GDV/gtU/XbZjzr7OcZN1KZRqVqb6MCbGM6tG/0Vy
lf+llpS48A2zejimWUWuvHIzjXzgO6X5zd5lzTh3F1Qpr03IdSgmLn9GP0aT
4i/7mbOIHOYsv5TRrGus1HynXITthajy4qxh77Hv9if1fyLnmVc2rNxY57MO
T+b+zmFzHf5uZGX3tUp1Yo1YP8bCGE5mNVvJi39xHSsn
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXlY1WUWx1/BEFBBiOXCvYjIJnBR0PLJVi1TsXVqcJoncIAWS02pRCtz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           "],
           VertexColors->None], 
          PolygonBox[{{6981, 4676, 710, 6979, 6980}, {8156, 6936, 6935, 8159, 
           1948}},
           VertexColors->None]}]}, 
       {RGBColor[0.616025869307223, 0.6114443482882151, 0.9106888545701787], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtoVFcU3Zno3HsnmqnBzEzUzM01d0Ka+JgPBWlFG01C/5Q82oY0qUkV
oYRYqYhvq1AfH6JQ9U/FkqRQ2i//lLT0oxhQlP4FWmxokzT1T0Wn1FfXch3x
43DOPfecvfdae+19osFdHcMJM7uGUY7R6Zn9lDLbUGb2T4ANjE1Yd8ZmG0Oz
DvzPLTX7Hes7uNiD788x1s0z+3C+2c2k2Y9Y92KecOshnB3G2Iz1lrzZ1rz+
1TWbhRi7cb/X07wbvv4LZJPrnO/+YT2H/TIXzxrsd2E8wvrQMtiqMRtHPMms
2QnEmsS5vnqzPyOz9Tizt9asLW3WgvVh7LWnZWdsgdkoxpCnmd+7eAY2MquF
vztndjUvjK/PkYduTzO5mgK+BHh5Dg7GcPdBpdkTXG/Hflsong5gPojx/jzZ
e5aRzUbE8usSxfm4RvExNtp7t0E2iXetrzPknXvE2w1fjYivHuudsPUdeP0C
fifhr9kTPys88cF4/EAYiWNLQvnm3a6FwkMsD6vNjsHupxDEVcw1WdndjrtJ
TzndAz43pXV+Gb4/8sStF8jfnXLlsMflbqWnfcZAndAO42wFHxUNuk99+Q3i
tD8pu7SZgc3FgWx+jXg6YuXoG/BXifU1X7xerhW3xEE8IwlpmWvGebbC7G4g
XiYcHmJ5hd2db4W9K5G4Jq8fx+LnOOYjsfTX63RNfm5Umc1G0iI5Ijbi+gt7
lyPl7QDmqUXScl8szMT7HPEP4/uxL26IgxhPYs/List9wPRVRj7JGe3TN7nl
PeqH3BA37/YzxoI4/zklXOQgC3sX8K86UH1862qEdVlRq9okvi8dxjlX+9wv
BdINfVA7XJP/d5Cr30Lpjpw9LYi3HtcPmDvGVu3On4e2R3FmDBgSBfFCTkou
vzyzhjYwzjitcSafs+BgWyxNbAjkk/s73Tdr4SL+57LSSxNy96BefJU5HMzX
D/B5yeXlFM4vWS087FutLq/0wRiZ9xmcWVwl++Sx09XNrVXAjJjOQVP36szu
v6Vam2kyu10U94NV6pWs12nsf7ZId6mV/SmdZ366XI7ok//pd7kvHVOT5Vn1
UGJgv9wRqldSQ4yV52v8N32UtU+tU+fEVnLcZnzVPevrJXJ+OqM6yyCPg6F8
+Vn1KeZ6GthnY/FbX9Q31wn8LwtV0y/Qx/6oky/qhW8GY6Cvv1Pydw+48836
fq0tYiF28kS/5vbZ96Zgb2EsHOydn8TS1HXo4kZBNcz+x9wzLyMF8UvuaI9c
cv0LevDyonTyHux8ECt/1MXbOWmDmprJiEdiuOv65Elo5ESkPJBXvkmsqfxS
vSvrnbZLri4O4ezBSHloSas/suf8i15aWSttdTteyH9LqJgYT2mVaoP5Z04G
YuVltkl6IqbWtN4w1tR4JG1RV9Td95G0RJ3yLSQnR2O9JeRzbVpxM2bWJW3T
DuONmhVzeahckgNqc9K9HXyXeJ93WetRVrxT99TYpHsPiI/1tR82B0Ll/VZR
2mJ++6oUN2P+H6u+Dws=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd0l+UZht+gkoCQyAqEDBISSNhb60TAgaDiBD0VOIl7i8qwbhFEK1oX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           "],
           VertexColors->None], 
          PolygonBox[{{6433, 8646, 8645, 4701, 718}, {9270, 9284, 2101, 4675, 
           9269}},
           VertexColors->None]}]}, 
       {RGBColor[0.6398322319237639, 0.6496945488221411, 0.9112315663132368], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVUtsjFEUPlPtPEx1PNK/L9N/Ru8gXVQFi4pEvJeoerVFYoMIlWhSCYIg
IZUgqFdSYiFCRElsyk5ISqSxEAtVoy+LrpCUiITv893FzX/n3HPPOd93v3Mm
u7OtcX+Bmd3FmoT1bLpZd9ZsAMb9CbM2rIsRs61Rs6/YVxaabcZ+FPtS7B8U
y48+y1Jm8dk6602azcC3GT4rYU/O1v2n1WY9ZWYfYc/Wm2WwpiDGz7TZBNZ1
xL7kzK443edqLVScpphyB4Xye4FvFdbjuNkTrG7shwLU6FQnbTx7C2D9WF+L
zO4B1/uM2dhUs3eI963ObMt84Ea9ZajrslO+spxZeU7YXlXiPKf7Tfg9Glfu
AXzbPQ+HECsy2ewIeDgEHD9KzZajxj3A/gp8ni9S7PIyxT+JOn+lxes64H+e
VKy14Oc0zh6h3oU58UWuCkLVwRr2Yn/VCcsG1LAeK4S/w9ttrzGLIubLErNF
uL8L/t+Q50Qg7pYkZLuOmOPFws28F+HfjJibcDaMeoeyikucediuItcV2FpS
wvgMtTyv1Fkspi99eeeYr6c5JnxV3s5aqatucLAeuPqieqvhQO9FbHwr4urC
+UAgblnTYFzvnizSPephO+7ucHqPsMrsc1rYNxKH05194Ooy6u5ALSG0loe9
ISFf8kX/OVG9TwVyH8X5mlB4j9eafcjITkz0Ja5O2Mcy2l/Cvc9R1dUTkwaJ
cQS1t1UL+198I6E0+AZ6m+KkTWqY3JG3cfh8CoRxQSg8zEf9zvEaXg37qpR4
XZHQGfOxxpWlqvNOoHzMtQz+y1Pqmwlos9Hzz1qpQfZsFzhpdNLyNmofayQu
zWYrxMt96KQtqpjsmT+w3SiUjqhNaolzglwwJvHwTYi9pFh+9P+Nem6mxFMB
tBnJqZ9GMuKUfOaxP1UrXBFwcKJW+Wgby8rOfMzLHunxXNB+Froadjqnrqlv
6oT6Zn9RS4y1NKF6LsSEjbg4AwrKdY/2fq9D9j9nHG2Mx7nGmK/xjrcCvQu1
lU9KM+SJMckD5wHnAs8nobZgnvx6c7rPu8zH/m/3M3Pc73eH6nPW8B2+P+qE
gVrr83qb4e8M+N7iG/N9W5zmC3uPfTk3rtquwf4wFBa+MfuKfbemVG9A/mug
h1n1ercu+N8OhIm1UoespzmlWcA5QKwPPN5eP0tYD3soP01550bFO/XJ+VFd
r7vUI9+PNXci3rmsclB3Ga+9Edh+hfLd4KRXxj8DPr/g9+KE5ix5ZkxiJd/M
2+Q014iTPU9faqYjLa1QJ4dnmh2cqRnQ6ucL3/dAtf6T2KOM3+DvEut9rwfq
Pek1/3++Os1Y/p9xzjI+/+vW+Rne4Gtlnfx/SKb1ezWwrqpQPPbKEq9Pcl/i
xD9r45e5yAs5JZ+DgWYH58YofMec9P0PtlAbug==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmWl0VtUVhg+gQBgSTCADkIQM5EsIhlmsQ5HJCVTAIUgFXMSxVWi1JWid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           "],
           VertexColors->None], 
          PolygonBox[{{3894, 7987, 1542, 6942, 3893}, {5444, 9048, 9047, 6450,
            793}},
           VertexColors->None]}]}, 
       {RGBColor[0.6636385945403049, 0.6879447493560671, 0.911774278056295], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVVlIlGEUvW4zY2ma5DgzNVs6SkY6RW/RS/tbKUYuVFAQ9dCKFDgQWkFB
0UNIRkFBRdCDtkBBLj1oZfkQZhtEWrmU9NJKRQt1Tud7+Jhv7neXc89d/vim
ndU70s3sHE4GzruY2STOiNfsoMdsEOdFplk1zmUo7oFOUbbZXryvh6w2zywt
YpZKM0v6zA5nmd2C3rwSs7t+sxbYV0Je4ZP8etis3y/fl6aa9UK+Gz67c826
cIph7y8yWxMwa8iU/TjObMgHYDcffp/D5nsUMXHvAI5WvE84nZPA8qVC/5ug
9wznI7CNx80WzDUbhn48aTYG28XI4yxi7YdNL2I9gs1pl+8n4Hzpl+8kdKuB
Z0uWYhZWKu5PYPiBcwX3dsjL4GtOtriazBJfD/G2CLIPwDDmU74dILoOvH0O
ircn4HsU9oPQXVlotqHYrBl6W+H7GHA3evVGvPQ3AdnbmHLpCpmdmKa6kKcD
jocG+BvzK2YO7u9xLqcJF+tAbDlZqiF5PhqXHnVYB9ZjLd7TZiJWvjg8gvxe
Q+dUpnKeM0X6w4gR8qqOS6Bfjrxuw/89xL8WFiZyd8gjnOSXPJMHYuV7e4by
+BZ2ucD2R1h6V8PqJ/bC16D6g5hHoVMP+Sjij+C+DvdXuD+NiVNy9tIrLnuB
5xP6oiygvJrL4Q+nETkMefXLHJkHfRAPazXq+vMx/A3FxH9uAvkDw+Zs1aAZ
tn/YY+Cprli17nT9vMukR7/0yRw6nbwGeIf94o8Y2NfkLR++z0fVR3fAya+w
9NnTnA9yxl/64X0bdKOl6hNyTDtyyFp7pqjem9BvpaX6vxQ9trpY8zHoasOa
3AeW4yXy8QZc3fBrRplzk5sjznePRz1QgbmpjOg/857IV+416IGFQXHe4lMN
eN+MuUsPCDvzu+By/B1WjclNTo5i0P8AeAgk1KfboftuuvqWs0oZeyCGnFrj
2i+HgPcN8Nd7pMN38sb6EANrxH7n7uLczQLOvyWS34TtTNz73Iz2uTllDTvd
Xmp1s8U6bkS+qwqVH/01Op+1kC+DPOXT3BMLOSEWxqYOZ/FMnmanCPm1R/XG
vux1mFkz5sR8LaH9wt1Sn6ec+dbh4tJPvasJY3E/zXA7iruZuyblalfp9jBn
t8PZ9oD7SIF6jztmkdszjHfF8RZF7SJJ1Yd8tDguaMeZpy3r0x0S5ovIqT+k
HuQc0h/7Z19YdSLeg27Xkuc21PBkXN+QzxXqFXLe5fYQOXkK20SBeinlZoZx
n7k7/e9Cvjsj2uWc9aqI7P/PX7Zmmft+eVBc85vAfco5pm/2Lv0TF+eCc0QO
hh0PVQF9D/jGnhpx8gchzT/5P4X3thJ9J1cE1cfs17Oo47mEcHDfx5Li5h+e
DSS9
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd01FUWx18ooadA6gRnJm3SCxKKx4o0pSigrgHOUkxQUSmrrAQ4qxSR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           "],
           VertexColors->None], 
          PolygonBox[{{7648, 7637, 706, 4644, 7647}, {4629, 7624, 7623, 7613, 
           702}},
           VertexColors->None]}]}, 
       {RGBColor[0.6874449571568458, 0.7261949498899931, 0.912316989799353], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVUtIVGEUPr5mxkQtyXlddWaaO1MQaZG077EospdBtCmjx6IMiyCyEIoW
1srUsHYWWotaZEW5VyofEFJp9MKIiEoIRKIHifZ9fH+0uNxzz3/+c77zncdN
7T9W35RrZtfx5OE5VGB2K2C2CcqJkNndIijzzbLQvcJ3FEa/q8yG42ZfYTvu
bOqCZs8h90Geh82HarP2mFkPbPrxzIfkk7prGenTZWaZqNkA9O9xbw42axFr
NiT5BOTciFmLr/tTiNuH79fQv0yajYRxDvkSzsug3wl5njrY9Tq8W4PCPAe8
2VKz2hyz1qBsL0LOh10yTxhi8PMQ97/hOwtcJ3EnBX0T/A2FxcMzl2NjUDwx
N+a1vhz5JxXrIs4G8b4N/YGAZMa6DB+dldIxPt/U34fuPM52B5Rbb4HiEmdJ
oVkOdB3grTOms1nY/8HTHRBGf5Hsh6ErB6dzsBkNiyPysxDctPny5YGDj3Hx
sKxQXJPn41nUNSH5FGxzIqrFNDAcwVML+VGJ2faoeqQanMxElSP56nGYuxC3
JKOcmZPnK68mxH2ZQh4F4ptvcn4ONveAe1dAsQ45PkeBsQYxpvB9p1L1oH/2
xazrk2b4Pu3rmzVh/7EuDchjX0Iy82cPMN/V4K/BU+zdwJNAzrZAvcI3fX4C
ZxvLhfEp7jXDp5cnromNPPwolG/KzJs1I7aDqIOXEv6fCXFKPm9CzmbVF8We
6sQavUCsTwvNxoLi7FeVeONcRVz/DIOf+qh6gHYtDo/Bfh657wSWzUHxx7nb
4nqb9ozB/Jn7G8R6m9TdBwvENXEyp2mXSwY4f2fE1zpwsDUtHJyzbWn58ovE
CfUXgupR9jC5mnK4K8DB3oT6hruBe4T7YUNQvcB+yayArxXy1+FrNjgP74Cx
sUL7hneYD3NhTMag/zhq1+7r7GpK/JLbM77mn/XkrPRVal44s+SI/LQ4P+Rh
zL05s+SAvBCzB3+LS4W3FVjO4lkeEC/kgPbkuNVhe4KYXVXyvyiifcRz9jt7
jv3GWbmSUk37w9o15IF+/83EoNsd5PNzUr1IfaOn/cU6Ms7jsGKNO16JgZwd
dbyR4xch7SvyP+5k1mSPq8th5lhjNolzH3I6IV8D+doL7Ns16IV2zHxboey4
ozkjYwHxyr7n/l5SplludP8A9lJ3RvuaNsUZzTl7lP65c2lPHJwl2vNszO0/
zuKki7Ujqv1L/Oz1fOfjO3idiWn/cm8tjQjzXk//FfpfAn2sVLWvgP5LUvfJ
zYTjZGVCM8lZuQG5N6G+HolrB7GnuVNX+bLhf68u/X9Gec6a/ptbyvsRcyiu
OlbjXo2vmOSR3BI/9xX7knVkD7Ju7Ku/t2wIaQ==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl01dURx282tiDvZYXkJXkv2yNkTw0gHKmKLAqEXWuoLUsTFKhoq9QE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           "],
           VertexColors->None], 
          PolygonBox[{{6883, 7032, 7031, 7019, 308}, {9056, 6461, 800, 5448, 
           9055}},
           VertexColors->None]}]}, 
       {RGBColor[0.7112513197733868, 0.764445150423919, 0.9128597015424113], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VE1IlFEUvTrqzGA4zvgzjqOOn36TZWWU0C4C3UkFlsvKlNyE5R+hhlFU
QoskTVy4aBMtKqbatA2y2rVoo5E/LapFEIQNoSahdE7nubh8973vvXPvPffc
53X3nbqca2b3YAHYBBYPYY05Zs+rzV7AbhSYFabNMnGzrrBZR772tgNa/w2Z
9eHuSNLsW6XZGv6/Ljfb75tdx7mxlNk1WHueWUPQrAd3vsBfqTVbhi1gbyug
s4cRdwZ37yNuD9YbwG7B2WOwzZDW9LlHvwHnLwI7t0Z7WyHlwzMzyOeXy+dm
o1kW/jr8z4XC4plIWHnNBfQ/N6YzjyvMnsBG4PvAT8BakOd0Auuo2SPsz2M9
Cpx0UOsJx9tTrPOR+0esPfxvDYrTljKz4/Vmw+4Ov1nwdgW1lkZ0dw84e1Mu
PuoQ04O1BVUH+WUtD9CHl6j3FfLOAnMCd6ZDymHB5cHcGCMLzO6wav5fb1z9
YM0Z5DhfoF7QWCvziYWE15yjGMylF/4Q4lhc3A3DH/XFNY0xiJ8G9nvkH8hT
n3scfpvrMfvL/71VOrOOOhZrlWsSHGxCZ19xb65cXPAOc2RuxPmEs9+LVdc7
nNnnS4dHcC8JfgIF0tG2i0W+iMdYRSHVw1oyLi/2vRl39/r6l0ypxztcdjg+
qVueJz8n0EP/gDguxfkS2FH4GWBMFmkW2B/iEpN6YnzmTB0d9KWln/B9aOw0
/q/Cn41IO1nYalCYHzzMQkxaIs54gbDICzllLewV+8l+VQKjPiV/CLpKRMQD
dXTeaYmcvS0XR1XAX2pUzN8JzRLnqJMaiQh/qVY1s95+3B30NXvjuHvbk8Y5
31PVyuNHk9mdInFHjLMp4QzibNluzUIa/J2s1/ywVsbkLD+DvnalpSfyTf2w
R+QoE3bvjC+u6RPvTEqYUdydxH5xWNwRl5hNvmaM88W8Bjzl1ujrnaJemMfO
XIbQu8q4NLIJ/0+N+k9Maoi18N1gHPIcRY23PMViX2Nudshr0hO39RXqN+ug
Rvll/tGwsFjjVeSTE9cblsR3FuuKsLTPL7VHjdfFhHGpRj1mf/sRZzkqrfLt
KXHvzwr2hjzldA53O5P6t1Gj2WO9iziz7au2C/DHfHGXG5cm2Bu+YayNHLa7
d5M1siddri/U6aGk4i5FlRPzmQJeLK5a+dbPu3dpKqEamD/71+rwqfE1NzPk
NRYRt3djmgfiD/jinfv/AFaX6ts=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mXl01dURx28SEuEQIe+9EF7yQpIXEiArBCQgHlBBFgWSymJbcGFpggoH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           "],
           VertexColors->None], 
          PolygonBox[{{4609, 7047, 7046, 7061, 1525}, {8663, 4748, 726, 6451, 
           8662}},
           VertexColors->None]}]}, 
       {RGBColor[0.7350576823899277, 0.802695350957845, 0.9134024132854693], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVUtsjGEUvR2d+f/R6pi2+rdT7bSZv008gmDnERtLIhbEI6mWDRWqRcJC
hCLxCvGWVGKBikeCjURIPBYSLZJS9YithCqCEBFxTs5dfJn/+777OPfcc79p
bNu4eEPCzM5hjcIaSJodCc1WYJOuM/s6zqwF30XlZrewvw3jPtwvT5v9xfn4
yOxF3qy1GD44W4bVijhhk9ll3uE8rDc7XmW2JmU2J2c2GvvHyLMTa3i02XnE
fIaYz0PF/FZttiRjtjcpPMRyIKGcO1Ky2RqbXUX8V4i/APYLsVbDdm0gvIc9
Js/agKcY54vTivMFNSVRy9yU8K1wzPeBcQLi9rsf7+lLHOthE+L3G3y7GnGO
HBNh+wA+T2E/mNQZ8/I7GWg/XDD7XBCnr7NmFXlhuF4ifIw/1IA7rIFA9TE3
axwEN6NCnU9H/t34XQS8pTVmJVgHk+rPjXrV3B3IZm+R2Z9Q/M4rls9ux9OM
31XYb0vojHFpn/TYtJmZ1jn3iUD1MD771+3xP04xe1ilOkrQ6x6sIdh3gBOL
lJcYz8bCeQ94fiBmO3wzofb8npHWPWMSF3VBbNQEe0+ubiBPVSwf4prhmImJ
2Mh5F+4rpqpH7Ntd55Z1lXgt1MZPxzA7Jy0y3ylorQ/fF4uk8US5dN6JPr9F
z7KIlcXZvlqdj0FdJ/27B7X+i6Ut3he5b3kzciLud5zPQuz56FMOeFuKxSPx
P4FvDXjrgE0F7CubxRH7/8xngbNGPVKfldBOOWLODbQaQvH0C/3/Uqbe0vag
67k30hxS4+9T0jHnZRPwdmL9hu2VlHgnLvJX2iQOqek+x8DZPVon3JzvPsfD
mWj3ubgJDJ1l0st6fK/D6k9Jg8xDPYwUhIl4DlAXsXqThu2drPpewBzX1aoX
9CduYt4C282xdM1Z5ptADLWId7laNfQG4nLI9T4mLT0vBWenpgnrsUA9pz3n
ivPFvgSo+0Kk+jh3iVB46FfZJN9e5OmqF1f7gaUskq5OBOKRb+CuiWYfxgIv
YlyL9E4RP/V1OqO6qKeM6/+uf1Orrd4HauMler09o9jk44z70nas2xcmmcWT
9Ia+AX+bGnVHLMd8zqn3rOcaQczhvHiaUivdMya1cyaWfthL1sp+XUPPr9bp
TWI95ItcNfjbQu1Ra+wHe/EOGKrzmkdqLXS9ZcDDoVj9oC7aXRt8M+Jq9Yt6
ZjzO+2vYdkd6hz5BMyPj1G8u5qINv6kj5uU7wNlmjXvAwcq89ozb7/pJI9el
SG89e8ta2V9yTr7IO9+hVuef81pWo3ofQf+TY/0/US/UB31zyNPd6O8PaspF
ipNwG/JFPnLOCd+CAeftPxKH/Ok=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXlY1WUWx98QBEq4cC+yyCL3XlyQTa3EbbTdrBSysimcaUQfsLQRdbRJ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           "],
           VertexColors->None], 
          PolygonBox[{{8176, 6958, 422, 3993, 8175}, {7062, 7078, 7077, 4625, 
           696}},
           VertexColors->None]}]}, 
       {RGBColor[0.7588640450064688, 0.840945551491771, 0.9139451250285274], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1FUYxb/S6fxn2mFqeUxngLbWztQHiW10qQQXEjeWGGM0GETFKESN
RECEakx8LHiUIMSoMdGF0BYSeWqUqIlu1IXCQjTRmCgu1FBrK7TFreeXcwmL
m/+9d+79Huec77vTu37Tvc/Mi4gzGs0a+3sj/uiIGNfmqpaItcWIB/XDnS1e
M+fLeo3mB+dHvK8x1RaxS3f/THfXFX33XC5iVL99UYi4oSni1pzn65r9/TLN
OftQ8vVoe8RvsrVXPu7O2fZu2ZxfiyjXvJ815KfT9seWRrypUclHbNK9E5WI
C7JT6Ymo1iMmNJ/Q/ILGeBaxTPfe0X5N/t7I/P1Y9ndrb0SjVeuS/Lyqc3tl
/1PlNNMd8fw8+1uVct+yJOIexfpkk3GYVpyPCMM5fb/RmfU6+7TuHZOds4rt
YpvPkNMl+bhY9F3w21Py+lDJv5HvL9cotsGIrxTj9rztvaXzC5R7h8ZGnTva
pfxl//uc/dQa9kXepyrOvU/3Z4XzLQlL/OFrutl5/yWbi3XvfuUy3OT89+S8
/7PslGW3pL3nNN8gDLfI3oq8NQBfW9nTeFH7GxVvVlUO+n1XOWKbMHpMmExo
b2vdecE1GILltHA+IYw+0vrvvoh/NPYp1rm89+7S+cdls1C1v4v6fq14Ms1n
NJ/V2Kl5Xjh0KoaVune9/IwmTPqW2zd+98vOvkFjDQZwBl9wcjBpeER3tuWd
+1CLbaxJ+icn5uR3sNvrSe2f17esb6M/4mFh2NIacXqBdYkmpzLnQy5nhMdE
h+9xh9hfkq/vrjXfcF1ULgWNO/KupdU587Iys67XNhsj+AT/w8pnvGRe0Cj7
6Ao+XshsH7yYY49vlvxyFi6xg218UKefFzzH1wLl1dFvXdIbqHPsgBd6Bds5
6ed35TYjuzvE6cJ222Hvv4b30SncgCnaYw/9FfX7kU73jFPC9aRGU+a8yYvc
+bKmdnoHxOuAeUOPixrOfVvBOZPXmGy0iafLecd9KNUXeRM7Ns8m3jj/k+J6
LdU7PWEm1dpi7R+vGI8j2VXeLsvnsh6fI46pVNcLhVOlfrXP8QWHyT73C3gZ
VWytVWuCuMmNuz/K3g899j9cc9+BT3SIhtAPNQEnzKd09u12x3Vctfb6oPVM
r1hadL94V7G8V/caPn8tOh40OpY3prOKZ7LsPkG/oPap2dsV745245DpzHCa
L5O92UbiMOEFj2Opx5ELOqaWsHUJ/hv2Ta3sTBiiqfpy84MWsIUdapg4eBfA
5nDSAPfgGL6oDbDlDL0NDaNlejZcwuO/NfcXMHtZ+9VBx4QO6AFgS3wjqdfh
e2+ac/aVTv+GXs+lPrBE+59U3CPO3xzxYcXv25T4nVqsHqNYsi73I/KgR8MH
uXGvq+67m8XdgV7X4rNl8wd3e+rum+BPftQkfG0vWgNogZjp0ZzhrWvp8jne
nKPpnciJr5Zuc4JvYoA7chlKffWBdvd9sCUm+CR3evbmFMNNqrMbB/ymHSgY
dzAH7/tK7otwRb2yT51RC2DclPSEHdbgjf7pbYv6bYv3f2WyyfsPfvSiKz0a
TIZUKx90OeYnhP+GQftGu+SH3tApGiXHIvXVbSx4K57qdt2vEN6fdRin25Z4
zfxkxf8bwJB+MXTlfc9sm/72rexM9li35HUg/W/hXYQLcCP2fSn+0xXXyXSy
CX/YRV+ldH5aellddT2jXe6CD3XIGryuG7A+wOF/tYJfeQ==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl0ldUVxW8KmRiS8DK+kPG9BDJBgloJARaoRXAAgyKoDdoyNAHFClhA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           "],
           VertexColors->None], 
          PolygonBox[{{8671, 4776, 4775, 6430, 1421}, {6959, 8170, 1959, 3991,
            6958}},
           VertexColors->None]}]}, 
       {RGBColor[0.7806277481414481, 0.8529994359648371, 0.9059684729601044], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlltsVFUUhje9TQdm2g6k06HQGVrmEMqlHeMtMT5IjLwAESEm+KJWo+ID
ahQVFDSaGOMlagn6hIVEQWG4eItAIhiNJMZLogkKKoSLCUHakkqLPln8P/5N
eNgz++yz9rr8619rnc77Hl32SE0IYVSrViuvn28bQzg/IYTF9SHcobVM5wey
IXSlQnhKwtlSCGumhnBKsov0vk9ruWRuKIRwY8HPKyeG8LDWWemZWwzheIv3
49JxotZ60H1r1N9ZDmFm2baXZ3SW8bvrGmwH/T/MCGFrRwhP6uyBSggPVSx7
WYf+O6T/tzkhnJPcqegrtjhPpHee1i6drZKdoaYQhoP9TOnuGcncrDu314Xw
imQOZq0bmRW6N5Cx/zt1vkvrb8mNCIOJBWPwsdZYg/dNOnuv6PjwAdxK+r+Q
hNAq7M7Kp+35EH7vsX8XpGtI/93S/5VsLUj5GV/L2o/IhzszV2Nt75TOxPkp
1lgf+Nwm2S06G6l1TMR2vtZ4oY8Yq8Lvzxbn99XJIXzfHsIv0nFa8gejzOva
j+vOZunaJvkPtJ7W86WUz4jlouLbn9i/uxptd+4ExwI2B6RrrfAZlcxAvfFb
GfmwsMb5Qc864bBXOGyPPjfGXHQL49lav6blT411EOtr8nneNPtMrt6Q7RW6
e0n+LanzvqvsOInxsO59UWcdKZ2neac7H0rPCeG4RPv98iGXGDfyuChycpNk
B7Ta0z5bHM+xOZyyrVtS9g39zyjeNyvGqFX39gijoPfvlm0D/Z/pv03Pg9qv
nx7CTcL/5QnmGDiC4bUN9gNbdR3mKzyE14OR2+8Ip7czjqUqnZmS62RU3Hte
dndH7sAhcOjKqWaLxhDb1az5Bjfg3GW+Zc1v8GIhQ1yrpXtBq3tDdb5k5jvH
3zW6XnfHXIDHS9J5Qnh9E2PBJ2zCT3IJf6nHarSFD9TBjrxrIdVhjPBxsnIy
vWReUzd78uY6sWZjvJuFwZaMeZ7XWVvJ9XNU8eZKrmV8xHf8xK8V0befZ5jH
5ZjDs9FXsEAHvg3Kh+Py74h8v0a53dRmbOhDn+SN32DkAVj9qHz+VTI/ien9
DseVzFK9iW+zZPu/BvcF+E/dEB/+HGp0LPhIbskx/lOL8Bt88RFOgSc8+jRi
Bdc+inx7XPafKDn3cJH71NyxHtcbtbZOXL232dzLijOr1A+Xxj6Kb+SIfkMf
5AycqWGwo44HIuYD8R37fdJ/rtX8bRdWLwqrdMZzgDv0F/rWpIJribpfH/2h
/4A7fWNL1AkOx1o8P+gb/cJvQ6f7OO82R3+IcWHEc4P0HeqxnqWxLskpeG7U
Kkt+n2Q6ysa7X36+VXHPI07m3JWezZ66wx9kifFZ4TYz57ztS9xTqMGsYq0v
ugdx72C8S25Ppp1fZmBLl2N5QfJTK+53yB6IOPcm5hkco1aoGfoA/GNPXuAB
/YeYn8saO+I9rxyub/e8oLaqsZaHpXNI62jaGJ+OPZbnI1Ensy+ddh1vLXrG
kKNq5CK4lRXrl3nXPf2Zu9tjL4GDYM0M7Is9FIyYG/Q97oM//aGx7PqE2+Sq
P2//qYvxOLfR3R37P3OAPbauPIPJXsU0rWJewbnZUWY81gr4MCuYc9Qjvba7
15zva3b/ZU+d0B/ok9uKnt/MbmpuZJJz+nlie9hao2+MtXPM6+uneSahv0u6
Z/b6DrxPxbogJ8NNzsvaouttacQWXDhHLzVCXnZL5rEm40EvP5dz76rT/p5m
Y9gXv43oA+BK3jjv7DUX8Rkbh2MNgA0YgRv5hzfYXC3fKonlcuJmc5dr6qTy
MqXZfe0fvf83MY/hCPMPe5PVY1qazZ1B1f2Usn2aFePCn4J4NLXTfF0J3wv+
ltkY5xcc2Bm/p+i3X6u+7s55/iW690ePOUE9XorfDHy//DTD+WIujRWcP3K+
JOJArz2Tu+pLEnHG743R7kXFNJZ4Xg3F7zB4+GDFc5f6ndPr7wC+Adqk8/6c
ecUMbCjb7+kVcwI+JPEbE1u8uxDjGlPuRouO439+WKZK
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd81eUVxl9GloObndyQnXtvICGDipqA8IGqqDggKIhtQS2jCSqW4UdQ
Ai3WASIkCrYuhgZFUtxoaFkK7UcliAoyFCGpgpCAZYRqK6Pfx/P+8Xxycu/v
947znvc5zzk377f3Dp/U2Tm3spNzXfm7MdO5nWAH2ADKC5ybHe/cLFCGfR/o
3ZvPwTTskznY3fkOnMCuKHTuBnA9uBx8meVcUaJzPcFe7LiQc0+WO/f0Rc41
xjp3VbFzOUnOZYMrsa8IOFepcUA/7Bo+e4jv5oBq7MZS524JO3czWIU9jTke
A4+CqeDTdOdaeznXArZjL2G+F8DxLs5lxDm3lve+78b/7DUU41wbe1yT4Nw7
4Ah2X9a4HfsTUIn9J559H2wCD4ELGHNFNnuMYo/gDex/B1kP4znGm8WaBqQ6
1x/UYs8qYw+gGtSCwfgsu8i5LHA1diZra+LZf+CLLWAM8zYwZke0c28y/jrm
q2UvM8HfsRcls7+e7A88hX0d47zP2WwC12LH8dwoxrgVxGJPiDhXhx8XgvHY
bfgxPte5ADiC3S+f82b9O0Bf7OtZz8t57BEMwT7JWd3Lc5PACeyd7OEIOAx2
gBLWMQgMBL1AOs/8MY25Od8YMJtzv5HYuAHMwu5TZGvWWi8psr2cBh1+T0NY
1/Qezt0PrsP+H3uMIta6gv9i/47xJ4BjuPtmxo/FJ+PLzR4BjpXgS7AFHAWJ
+GEh/lwAErAnMG4l41aA8ZqD979jbYfAtdhPJFjMKdbmYy/WmvnuErAIe0kG
McrffuAF7Bv42x8/XQGux04gvhLB1TEWcxPx6yn8cRLUBO0u3MZYo7rbnTjM
mfwZ3z4NvsMegE9vBsNBfzCTvY0m7n4DHsSehR+GcK7XgVrsB9Is5hRrM7BX
sO5BrHug4gh7IfdoIfMuELA7OOPBvHc1OIU9sbeNqbFqepsvzoCfvE92EzeP
pXC/wC7s9ZzBOO7JWLAOeznz1DNPHViG/RVx2Ixv7yN+D8Ep0brvxPd6fHEC
glnE9xvY13rwFPY87lgHfjgF5mLP5wxOs7cO8Hi67XUMGO33nM54qexjEP59
n/syjDW/i783MP6sizlf4nYK80/W+WJ/g98qWWsF+Fc345K/4ufGiHHKPXw2
jXPcyV0bFmV3dyK+rCm1Ozw8aDGs2K0KGnfFsoa5nY3DaojZWjATVMvmmedC
xjU6/7W97A7r7jZhr+BvIX6PgAbs/ZzZQdb/Lfgau4B388H3+O5D9vcWa1vL
fpvAm9j1qbZn7VU+vYvPhuK3m8BE7AH4dC688hjoj72GGP8IfAjeAcn4pJXv
WkAS9tuc6xTuyWTwVopxu8bQu+L4bb1sD1p7M4hn/lJ8UwIC2PV89gTjzgd1
2PX4YCVx8Qqowx7HPIPwyUAwFjvAORSAfNANvMcYGfg0Dl9+z36CvBMFuopL
QHmy7UFrL8N+urfFsGJ3MXYSvmpkjFbe7UPMTcVP00Aq/6/mjCqDtgbNXYG9
vIfFoGJvGfa4dFuT1jIWe7r4nX00gPvT7W6u5711QbujjxBXqawjBTyMnZdu
OUK5IRe7J3FdVGbn/yhneAd3Zj9+vjHW/tdZfwq2+zNvYF1N4D3wUoH5JoZz
jM4wH92dbDGm2LoL+yjzdMBl+THGgWO5c3vFo/w/mP1OZ535fJbd2XwyHN88
yVnVg6pUyyU6szqfU06xhpPgMM8uIf6DrDUtz8Y6FmO5vC9xWZlmOT0Zv23E
5xtAEnaAmMkmdrJAN2yHT2/i2RvB+UKLLXGquFQxdpS52sFu/LMHdIQtByr3
HeD//cRCC3ftAPga+0zEOFLc+BMIpVgOVe4swN4G7+xhnt2gudjnmkTjYuWc
Rs4sxHcFYFWScfFmxv2g3Dj5ds4nzLgR5n+Y89mIj/JCdvc+Bs0FliOUG7Zi
r+Ac/sA5zAYN2GHmOMjd+xaEsGvCxjnimuqw3Q3F3DJ/R7bzTBzriAWfYM/F
1wfxTZi5QmAh66oH87kPS6OMi3SGOjtx0ufMO5S4uAl8hl3Auy8z9/3E/jKe
v4I5sjjXTNAPe2mJcbS4eQn2p8TsZ7mmfcQxbXy+jVj7gvN+rbPl/s74o1PE
NMA51nkZY10KzmLPxTdt+GEBa42Ls1wojhI3KSeK+2YGLdZ1B/Rsep7Fkt7Z
Texm8FkQ7MLO5b1m3tsKcrB3JFkOU+76PMm0xQhwi9cYezJMI0ob7s4wrjjB
Po/3MM6QdtSZ6CykIcWdW8HHnkMVW5t594OAjzHeG4UfbwX7sH9ZahwnbhtU
at8FPRfpGfliGdyzNN988hK+Pxa2WM5iz8tzLOcq1y4DH+WbppGW+RD7xzzT
INIeP2AXc4d24rMdoEh3iz3fQazeDjYkWWwfBe0+xr/1GlDa7xvsTqXGYeIu
hx3Cp7sY5wtQkG25WxpC2kE5/Nlc4zBx1zNgBtyxj2cPs/aaC0zrKecr10vz
jWOMGvZYDcZib2ENb4DXweZCyzXDeb8q3nKOuOtNxn0j1zhsb4lpMmmxPSCU
a3vWXgtyjVsWSQuUGce0pljMKlZbUmzuRtayKmBr6M4+Msttrcr5ym06w30+
x/XFp9ew7sGgEjuJ92YEjdsGxtjZ6w7q7ikG4opMQ0k7xWKPAUmMnyjdVWTa
SzGq2JQG28m9uI11jQI7IqbVqvg7LGKabaofQ+9OAZ0DdmY/n1XAtLY4VNwp
zd3KuKfDxn3FnexuxIBof0e2Mc/j+GIeaE4xraw1a63SzC/y912wBiwvMm0v
Hxd4jS8uXsm6XikzTpa2HsPno3NNY0srqaZTLSfNpFqunbhty7GaTtpGOb3O
axxpYdV8qvWkieMDxgk/cwH+XdvTOFLc2ASWwlPXEjfXgCXYI0stxyq3jig1
bq7wtaI4Wms7wD3Zn29rVK3Rx9cKqjmknVTDqHaRhtJZnePzs2V2Zk/4O6a7
NR/7SenBHNMCvWLNt4/j83kZ5uMZPDMejAPTwZp8u7O6q+/km/YUB4r7pEGl
fcXB4l5p4DlpVvOo1pGGuZx9taeYFrkzyrRSCC4pSDXNdCRoNZdqrcNB45I1
fi5xirSANJq0mTSBuFE5UblQHCmu2+a1mDhvIZ99zrOfgQWJpqXf41ze7W6a
WnY/1tM3xT4bwj4eDFquuC3WuPFenpuUaBwprTaPfc3NNM2m2NOd1F1UDCqW
FJOKRcXUQzw3hRiYDOZgN8ZbzaZabVW81Z6KAZ29atBUr+Gk3aSh5PsqMMyf
gWq1s7x3Jt5qNmnJbcRRc0/TlIqNF32sK0Z+JEa28Nxm8EOucdGzntvESeoF
XMV7VyZbT6Cdz1fzbE5n00yqDVTTqJZRjaBex0hiY0SG9Txq4q0Hot5HNfYf
IlbTq5afHbFaZq/nNtU04u5pvhchDp8MZ+Tz+fEL0UPExOvd7DPZ58DvscPK
s6zlbLT1Xi5l7j4Z1oNpw88fBK0XcEm0cftUzy1feC220fdqpMmGM1YquTMF
VOWZ1pRGkzaT5lRvYC3fNRVbj+AlfBFDzF7J+FVRVjunEKfJpVZDn+L7v/Hc
+RjTnMnEXA9QCJJ62FyquVRraU71Li5Lt9hXD+NV1v5rYu5XYKW31VNQL0Gf
NWRZDlXuPNDFamn1IIb4mvoA494ZMD0hDd3KHKdBB2gBiyN2JjqLRRGLxS95
Z2+exWQmMf0f9t0SZzW5ek238t7IYus5ScvFsc/YEtN0w3qYhpJ2GgqeLzRN
Ii3yXKHF5musfXW5xeg/iadJ3O171MMR73LWeeLarnbm7ayhgrEvB20By/UN
Xusr56vWFieIC1Rz62ykaZv9GakWUQ2k2kc1iXKv1vScz8HqJajGUW2jnoJy
UzyfBwotRymWI/g3nGUxLe2rnoh6IdLAz+CbR8DD4C9h63U94231vHRXXsu2
2NSdUWyeJ9bOZVqMqvaXZpFWUQ/AJVpNpFrofIL5+hd81zvJfK7ew0Tfa1AP
Qr5Xz069Op3BEd4JhUx7S49KS+gO6u5JU2yKWA5W7t0IaotN40vbzyy2Wkc9
BPUOVPMkcP6JOZabVLOLK6RBd3nOmJBmmk9ab3ya9QJbfWypJygtXMa5lQZM
E0uLLPaxJk0SDwclgFGxpqHUe9GatBb1YMT9ynnKdcoBh5JNE0gLHMQ+H7CY
U6ydCxjXrfW5U5zXwT5OpZsvVNPWlRuHiDtUIyi2NIbeVYx9zTz7wKtdrMb6
Snaq3S1xjLhdnD3Hc3w551wG1nW1HsgPYdMk0iK6M+LOEt/bE4e+kmU9DvU2
VHOot6Qz11mrx6RcHM3fqKDlZHGF7oBiX5yhWqc+z3Kxah5pJ/Uox3sNtTXD
YkD7VU2i3LXT9xqVwxTL6nmo16GYVu5Tj069OeXAQL7lOOU2nYl6I+rpVvoe
iXKNNKK0oXKOYl89aPWedQdUaygmFAuqOaKIka7ZVhvqTmeFrGehXoV6tuoN
iONW+h6BesHHg9YbVk9Y2kw5SrlJGk3cpJytXC2Oep2xUkLWO1YNLi28lH0u
STFNrNysHpR6T8rR8u0A3xuUjw8lWA2p2lE1rHrh9/Du3SnWE1etqR6bemuq
OXUXpZGkjXQnLyS2Xs427ldPW7039RzUa1AP7q1U67mp16aeXhp3KZqxenay
Hpy4QD30I54Tanm+qdRylWLwonzreanXdaE0FnPNyLZem3oUz+PnkfDA6ost
BoPl1kNU71A9ZHHZGV/7i9Ok3dSDfcFrOHGxemjqnYmT1YtQj0C9AfUk5Msx
/B1dYj6Vb7b42kU+OsZdagrbbxH6TUC1s3rosb6G1m8Nqumr/W8OWmtjifUy
tWbVZup5nPc1mmoP7Vl7VQ2iXr9yhHKDev7iEtWwql3FKepFz/Das8LnEv3G
od82lFPUq1MPYqvv2Wkv6tmpV6c9qZe5yXOheppDvQaT9lKPQGcVA9q72Jmp
ly4OEveop67fDlQzqlbUbwjqZeg3m72+p6Fcm+xzvXKufhuRxpC20G8kb7PG
llKrrTSHtINqUuc1hLTDA0HrZUhD6LcQ9cTVC9dvItIe1eXWu5cG+T9g6xu3

           "],
           VertexColors->None], 
          PolygonBox[{{8670, 8097, 8096, 4776, 2125}, {8171, 6965, 725, 8169, 
           8170}},
           VertexColors->None]}]}, 
       {RGBColor[0.8020074775343435, 0.8601290060343041, 0.8963903733511603], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1ts1EUUxgdaurvdlrZA79Dd0q2JIN1tBBEhsYrRCJSLMT6YoATfJKiJ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd41eUVx1+IkAn3Zi9CBjckJCS5WKOGKXEgS5YLW8FaxkMQ8RFpAWU9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           "],
           VertexColors->None], 
          PolygonBox[{{6882, 6178, 6177, 4608, 1524}, {4758, 8669, 1545, 6964,
            4757}},
           VertexColors->None]}]}, 
       {RGBColor[0.823387206927239, 0.8672585761037711, 0.8868122737422163], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl31sleUZxh9Le9qe99hCSzkFoR94WvWw0x4sLUQEqcaCVRckWeI/bHGa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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mXd4lVUSxg8JhCQXSU9ICCmQG9ILCChdWAFp0my4CqtLeRIUESyUJeDC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           "],
           VertexColors->None], 
          PolygonBox[{{5103, 8698, 8697, 8846, 2147}, {4753, 8661, 2122, 8659,
            4752}},
           VertexColors->None]}]}, 
       {RGBColor[0.8447669363201344, 0.8743881461732381, 0.8772341741332722], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHtwlNUZxs8m2Swk2XBJNptgEkhgE12zIQtUhdbigEBUJIodLYpYKYiX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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl0leURxt+EwIUkJmS92UkCSch6k0BFJSyWTSSAIgjKYlALUgIIR0Cl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           "],
           VertexColors->None], 
          PolygonBox[{{4448, 9167, 9166, 9187, 2027}, {7309, 3957, 399, 7301, 
           7308}},
           VertexColors->None]}]}, 
       {RGBColor[0.86614666571303, 0.8815177162427053, 0.8676560745243281], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXtsluUZxp+vX/tBv7YvPQAtQqlQKNhzmQotB52i6IZznnVDAc3UCcgk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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwltUVxm8WglkhC2Qh+UiAJF/2BOiILLIotUsCsoOi06QzGjCBQgtY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           "],
           VertexColors->None], 
          PolygonBox[{{7646, 7658, 1543, 4653, 7645}, {7101, 7123, 7122, 4038,
            432}},
           VertexColors->None]}]}, 
       {RGBColor[0.8875263951059255, 0.8886472863121723, 0.858077974915384], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l0ts1FUUxi/tzNB2GEprMoNiO2ILtCXTDsYFJhCU+NoAVkGKhg0+Wh4V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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGtwltUVhQ8hCZAECCEkIST5cjcJkAtCx7ZD0FjRouUikHBpfzS0NWCT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           "],
           VertexColors->None], PolygonBox[{{6877, 7998, 1873, 3904, 6876}},
           VertexColors->None]}]}, 
       {RGBColor[0.9089061244988209, 0.8957768563816393, 0.8484998753064399], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtslncVx8/7trSlb9+3XHphrJe1BQKltF2rMSYDHKDgtlKg7ehlDDNx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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1lntM1mUUx48otxfk4l5AEXl5ARsvILxa2lpNS03X1ARFwVu2tExNsFmr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           "],
           VertexColors->None], 
          PolygonBox[{{6648, 4207, 4206, 8374, 1468}, {9297, 5849, 1040, 8619,
            9296}, {6748, 7447, 1611, 7467, 6747}, {5629, 7509, 7508, 6768, 
           896}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVM1L1FEUvU7OBzOOqJgzY844zgwtxsFmNrWJioqCFDEjcBEEJfRl6aZV
FGiOtVAjWgdKEf0JoZFtXBRpRkFFtBFapJsgCDOSzuncaPH43d9795177rn3
vo4zw/1XAmY2gbUN63PG7CVWLGw2HjWL4rtVY/YWh1/jZr/gvBaXvQH/aEz/
tLlHP9rLCbNq0awxaFYHn/X4f1/ac0GdT7jPQsjsOuLN1srmdwarBXcKwNxE
3MGSWV9JeOmQYpFPud6sUi9M4tMml1Vwnw8rB/7Tj/48X3MO6w1mt4uK/S5t
9qHFbBrYafy3YfXC/xv2U43SYRR7Y1HZ1ag0os04x2C/gL1vp9l+rAz+L4Pv
UEl5HGwye9hqthjQIv59+P8MCJd3yXXUMXviikEO36Pi1Ov30n53xbFo7+o0
O9sk35Pg/Hs7MELScQ64PwLSmv+s0aOc2d6S9rvjikf8o+B4BGs5qPjcZ54j
0Op9wWypRv+8cwM4F4ARalYebb5PnGeIeTOi+nGNRVTHULtZEKscVi+wnqzF
YeDvqciPGlMHYjJ+t3NgnHMl7ZN7bbP4j+BeT0U4xGOvcZ/9Ml7RXgoriRUD
/nxO+dMnAa1OtSqvcLPyIT41o1asC7+zbnM2Vr2vuM9Y1HMra/a0qLOhDmjR
qVhV5LU7L/y7iBPPS7dJ+E4VletGSvrSh77Dbj/G+Zec+oscq77P+me8B6gN
dSdm1OeWNrVd87lLeP7kE0GOF0uqBXNirn97L6Z8qMlSF+qPdS8mXTdz0pa8
yJUcFlDDJ97PnEf6ciYfYIaet8rugyavc9KSvUOtebeKPh1IqX/Za5dK6reU
cyU3YnNmFr2XCj7v/94LcmV/jXmPTeHNKZTNGurMXnWJBzlw3sv+JrDvTpfV
e/3APrEDvQGsj/A9Dn6fIqovdaSGfAt4Tp0Zg3mSA2MmnWc2r3cz5rPLu9ST
91Z8Ntug+WRWdw+kNZ+cTc4X+XJeroLPm3bd4RxcyyvOLfRAJaOco/6mEf98
ST3E/kl4bakh36E592EPDnTo7A58p4uKyfypI/uW/TWYFe4MvgMN0jvpPcMc
qc0h1yfZqDeRbxT7jvWhVqwncyD/P8AB5Ro=
           "],
           VertexColors->None], 
          PolygonBox[{{7882, 8446, 2018, 1803}, {10886, 10887, 1727, 1297}, {
           7729, 4331, 2685, 1727}, {10940, 10920, 1979, 2018}, {6820, 6801, 
           126, 709}, {11982, 11980, 979, 2963}, {8145, 8127, 709, 720}, {
           5629, 6727, 1486, 1612}, {11371, 11374, 2839, 1486}, {5124, 11364, 
           2828, 758}, {10888, 8934, 1185, 2685}, {10893, 4376, 510, 2690}, {
           5848, 6967, 1548, 1678}, {4378, 7168, 1565, 804}, {8973, 8992, 
           1803, 126}, {9791, 6879, 413, 2590}, {9083, 8312, 2840, 2178}, {
           6847, 7942, 1840, 248}, {12700, 5148, 763, 3632}, {8911, 8891, 758,
            1978}, {8934, 5127, 761, 1185}, {8332, 8352, 1982, 763}, {6879, 
           7636, 1678, 413}, {11372, 4378, 804, 2838}, {9789, 9790, 2590, 
           2589}, {12676, 12656, 1466, 2828}, {6967, 5849, 2267, 1548}, {4457,
            11055, 2803, 590}, {10894, 6029, 3088, 2693}, {6848, 6847, 248, 
           979}, {11367, 11368, 2690, 761}, {6995, 4741, 720, 1548}, {11374, 
           5128, 762, 2839}, {8312, 8556, 2059, 2840}, {8954, 12700, 3632, 
           1466}, {12324, 4457, 590, 3088}, {12383, 6094, 1297, 1840}, {4707, 
           9789, 2589, 2803}, {7168, 11981, 2963, 1565}, {4184, 9103, 2179, 
           1982}, {9283, 4690, 1548, 2267}, {4377, 10895, 2693, 510}, {8536, 
           4565, 1486, 2059}, {4565, 7488, 1612, 1486}, {10366, 8272, 1978, 
           2634}, {9103, 4164, 2178, 2179}, {8292, 10366, 2634, 1979}, {11370,
            11373, 2838, 762}},
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8911, 8272, 10366, 8292, 8933, 10920, 10940, 8446, 7882, 
           7901, 8992, 8973, 6801, 6820, 4674, 6840, 8127, 8145, 4725, 6488, 
           4741, 6995, 4690, 9283, 9297, 5849, 6967, 5848, 7636, 6879, 9791, 
           9790, 9789, 4707, 11055, 4457, 12324, 6029, 10894, 10895, 4377, 
           7664, 4376, 10893, 10892, 11368, 11367, 5126, 11369, 5127, 8934, 
           10888, 4331, 7729, 10887, 10886, 10885, 6094, 12383, 7941, 7942, 
           6847, 6848, 5795, 11980, 11982, 11981, 7168, 4378, 11372, 11373, 
           11370, 5128, 11374, 11371, 6726, 6727, 5629, 7509, 7488, 4565, 
           8536, 11036, 8556, 8312, 9083, 12599, 4164, 9103, 4184, 8352, 8332,
            5148, 12700, 8954, 12620, 12656, 12676, 11344, 11364, 5124, 11324,
            8870, 8891, 8911}],
          "2.24`"],
         Annotation[#, 2.24, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{6648, 4207, 9014, 4229, 6748, 7447, 9431, 4208, 6648}],
          "2.24`"],
         Annotation[#, 2.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03toz1EYx/EHRWnNpbmOzQzt4vJzLanJiJjYNH5Y/uGvpX6bKKWkbCul
xMhckuRWpFZCUSv847pYlnKZa8Lmkj+GMfPa6r3P9znn8zznPOecX87GqlWp
PuHPv3PpEYsmRrzJiqjIjliPFYMi1tJ1eG282PwpvsfImhqRja7ciL/4g+X8
a3iTeMU/n/8EbzOuTIm4ip98v/ELy/jLeVfjGv9c/gbe+xg8NuLj8Ihua3yi
faZF9MU/cdAe2jlKLb528w3yO2iX+DNNiPeOiDhCC0dGzKAHxSdotbz8REQB
DhRE1GPMkIgvclcaK8UKNPGX0cTQiO/We67uN/qMfuX9hok8ZyZETKBn6QY9
JQoj9sh5kKN3PESH+u38HWgbHVGk55d0Fv+ASREXeUrlF6NM7qrMiFqatNdt
9BF/U+85yVkgPk33I805ZuOFvu6ie1zEDf2cx/vxEZvEO/P0RZvF13EW8yZH
9MswT1eiZnpEFUrw2/xxmml+r7yTSA6O2GedhXSOuR2+txvfbN+Z+k3SJ3qc
r79yVNtbIa2gtXJm86foVTlpxvLGRGSg0t30d6ajcc/7+IE23HbHR/nP2Xs9
Dtvjbtzkb6It6DQ+MN9bxAZ7fStuxnXMFl/g2clfoXa+O5tJh9EldLP7Wi9v
MWZgKf8H/lb+dOvX9eYbb0ILLokP091IYYu4i/8Af4N6SXWr6EJaQ3epn+4O
ung/4Cj/J94B7rvd90Bn2EMb9VjuHJ76rqS3aBH96DeQ8ntYh0b1tqp739nl
qlniLPOH+bbPDNrK8xnvrHnZe+3rHg55CyPoHfEv41XeUcqZ1qDOezuGRntJ
uaNK3v9nlafp
           "]],
          "2.1`"],
         Annotation[#, 2.1, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3727, 10977, 4456, 9632, 11693, 3782, 11694, 10978, 10979, 
           9633, 11695, 3783, 11696, 5843, 5844, 5766, 7632, 7633, 6149, 6227,
            3784, 12014, 5845, 9268, 12625, 5787, 11977, 5788, 9227, 5767, 
           7634, 5846, 7793, 6228, 7635, 5847, 7797, 6381, 12071, 12072, 9775,
            9776, 9777, 7579, 7580, 5790, 7798, 6316, 6317, 5923, 7693, 6863, 
           6864, 4742, 8163, 9792, 3965, 6721, 3966, 6954, 6955, 7658, 7646, 
           7657, 6953, 7997, 3904, 6876, 3891, 9734, 8618, 9295, 9281, 4688, 
           6993, 4739, 6486, 4723, 8143, 8125, 6838, 4672, 6818, 6799, 8971, 
           8990, 7899, 7880, 8444, 10938, 10918, 8931, 8290, 10364, 8270, 
           8909, 8889, 8868, 11322, 5122, 11362, 11342, 12674, 12654, 12618, 
           8952, 12698, 5146, 8330, 8350, 4182, 9101, 4162, 12597, 9081, 8310,
            8554, 11034, 8534, 4563, 7486, 7507, 6767, 7466, 6746, 4227, 9012,
            4205, 8373, 6667, 7207, 7187, 6248, 11781, 11801, 11721, 11761, 
           11741, 12226, 4248, 10405, 10385, 11413, 11393, 6336, 11453, 11473,
            10485, 10505, 10525, 5212, 10465, 10445, 10425, 5172, 11433, 6268,
            11866, 5672, 11826, 5652, 11846, 5994, 10585, 10565, 10545, 5192, 
           11493, 6356, 11533, 5252, 10665, 10685, 10705, 5292, 10645, 10625, 
           10605, 5232, 11513, 6288, 11926, 5718, 11886, 5698, 11906, 6014, 
           10765, 10745, 10725, 5272, 6376, 3846, 5354, 12553, 5374, 4271, 
           7251, 5334, 7272, 5313, 7229, 3815, 9581, 9560, 11951, 5746, 8394, 
           10786, 9034, 5416, 11554, 5395, 9684, 9705, 6114, 12466, 4353, 
           7827, 4374, 12487, 6135, 6510, 12141, 12162, 9860, 9881, 4015, 
           7533, 7784}],
          "1.9600000000000002`"],
         Annotation[#, 1.9600000000000002`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{3848, 4589, 12493, 4590, 4567, 7721, 4566, 6770, 3819, 
           6769, 7922, 7921, 7100, 5774, 7102, 7101, 7123, 4877, 7566, 4856, 
           7099, 5439, 12248, 12269, 10808, 10829, 4293, 7720, 4314, 10871, 
           10850, 12311, 12290, 6410, 12098, 12119, 9813, 9834, 3988, 7331, 
           7756}],
          "1.9600000000000002`"],
         Annotation[#, 1.9600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3659, 12394, 6038, 5494, 12333, 6040, 12331, 6039, 12332, 
           7310, 11587, 11588, 10946, 4397, 10945, 4398, 5495, 12395, 3660, 
           8448, 8449, 7907, 12680, 7908, 12568, 12569, 3756, 3687, 11990, 
           11991, 11989, 11993, 11992, 3849, 7946, 7947, 7912, 12633, 7913, 
           12571, 12572, 12573, 3690, 9516, 5970, 12204, 5971, 7385, 7384, 
           4121, 5972, 8189, 6637, 8723, 8722, 4447, 10966, 4448, 9167, 6220, 
           7146, 7167, 6636, 8766, 6615, 4119, 9410, 7362, 7383, 6712, 7426, 
           7405, 4536, 11236, 11256, 10263, 10283, 4078, 11579, 4098, 10323, 
           10303, 11296, 11276, 4443, 11196, 11216, 10203, 10223, 10243, 5969,
            12203, 5584, 11662, 5604, 11682, 4516, 11156, 5058, 10083, 10103, 
           10123, 5488, 10183, 10163, 10143, 5078, 11176, 4420, 11136, 5038, 
           10023, 10043, 10063, 5949, 12183, 5538, 11617, 5558, 11637, 4496, 
           11116, 4998, 9903, 9923, 9943, 5468, 10003, 9983, 9963, 5018, 6592,
            6572, 4958, 12533, 4978, 4058, 5515, 12415, 3680, 6691, 4815, 
           12513, 4835, 4038, 7122, 4876, 7565, 4855, 7098, 5438, 12247, 
           12268, 10807, 10828, 4292, 7719, 4313, 10870, 10849, 12310, 12289, 
           6409, 12097, 12118, 9812, 9833, 3987, 7330, 7755}],
          "1.8200000000000003`"],
         Annotation[#, 1.8200000000000003`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tozmEYx/FrOSRkzIaxYQ6bsx2U1MREIkOrhXhjb2Z5Zm1ZlNRmL6Sc
Ytq8WGhbxrJS1NTjlHKIZpEsh0JyeOeFWKF89uL7/P7Xff+u677+1/9+cipq
yvalRESmn8vTI7rQmhkxd27EHMzG/oyINYsj8qdEFGDjuIiq/Ih664smRNxZ
EHEPd7GO77783TwNPMd5CuVcFVegj+c5atWtwzVre9CZFbGXNsk5PzniirgL
7ep1YEDObme9phV0KV8+FquxBDVyh2VHHKWF4gI0855FNn+tvTo0q33BO17E
Fn094C/yfGBqRNLeJjVv01KanKRvOYNqZc+wLp4+J2K8OBUj5VWn6iHXHJAu
L3ep2TnvDF+G+Kq8brSp0yZ/jJwZ1g/Qbudf5Jspfs2zXI0B+lfP/4bmqU5J
jvnS1fRoWsRTWu/ME2az1pwrZ0cU013T9GH/vXO+YZ64WK1VvG+9WyEdof4V
+ZuduRpb+LfyHaHlatTRPjlJ3JSzSnyJnsRo52Tjjb4f4c/MiFt67MSnWb6N
+NA8c6PPxL1ox4pFESnp9mkpGgvMDBvw2/55mmn/mLw2lI93Z5xTQpfZO+i5
3nqVvjMX2qcvzGOldyzDPr3NpzvoETlF/Al6Q85oa7nmlIZKsx6+JGIKHrtP
P/Bu6K76Xi38HXo/jWY9NuAuf5L246f1UfMjsrBTrx/Ez9CLInEXzyH+HWrn
+cYFdCJdR6t82+3y1iIf6/k/87/kH+v8pqF860n0o1vcTBuQQI14kP8U/zn1
ytWtpiW0kR5Wf6xvMMj7GS38X3lH+N7fPY8yw3+0xzuWmcMrz5X0Hi2mX9z/
hLu8DT3q1ar7xOxy1Nxglnn+vzn6TKMveb7hozOv+3/E0D13FzLoQ/Ev69Xu
UcJMG9HkvrWiRy8J36iS9z+eFait
           "]],
          "1.8200000000000003`"],
         Annotation[#, 1.8200000000000003`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM1lUcx/GvZTOjWRqoiffiAc0L2lZNEN0s71oqldNZzoooSKPISluo
m9bMy7zM8rIWaWESrTsiy0sqamqkKUtr02RJF9M/LEnXrNfzx/v5nMvn+z3n
9z3nPD1mzJo4s0VE7PEzumtEeeeIlTdFFCYiJuHB/hFDcf2tTNkRaZjeO+IF
/HBzRELMbjpG/y78wduAwWkRNekRl9pFLOkSkXJLxBH9vXKfMXZanm9pz04R
j7aJeFV/sZgT5kt4/9KfRiutuwNrtX+3n6tolxkxlbdB+2t8hIXmi+6IWN42
orRvxBfmp9NyusZ+cjtEjBc3CAlU8ZfxD+OvoMf13zb+KeowS9xiOhszsMv8
Kr6N/OXyNppfSuvpFvkfkP+arIjzvCdRz1uLKfwpfSK6Ic/8RLRQr0Fi//St
vfXbo5m3EdX855xBCzW7W20atHcluZ1PXINaDO6pzvSqev6GMR3V8jbxaN8j
Yht9Hw1i+ibPqLua4Zxv6CW2gr8NHaWfyz9J+0nMRQ5fof1cMX7BfMK+z9MM
ul6dP7Hndc4m0/xamkUTSBObiovWzEyOI4GV6lLVPmK19g1iK31LCt3RL2In
vsJy89vpU+5BpwER18nR5F6dxSL9EWoyVr3GYRTGYDQ2yfUP72U04xLOiMnm
X+ZcFlizQM5D7uVhHMBBfIMnjO+j+7EHddiLx43PF7dU/EhrzMqI6C/fbnMj
9IejkucxfGfsPnPP85SiRkyK/W6lR819jyM4jmN4T2y1eqQmPfRLjLDWNjqc
1tDLOKCdLm84p650iLgSOXNpHgYjLflO3IHncEVMF+t3RSd0RjpOO/s57tBc
3CjXy/QlPK1uh8RMs85h+ghdRPuqXZl91rsDr+mfUs8PukVsRg9vdV3yrI1l
YL32Bnxo7hjt527Mtqfj2it4f6Kl+guttQTD7LPAncyhU93ZPkmPO96ETP0c
efL4T9rfANpSvs1yjLPWEIznv59vPs2Xo4QeFlOLz8Xk6b9Dl6K1dTrjhO+p
wxXfs9V3bcLP7uh0/Tnu+Fh6UL8a7+IedzxSzdOxmOecijESl8y/RTuaf13c
BuSr7xvWGUrvNPeidmny/dh3R285nx5xfrm+cQKesbcsOpnOFzOQv4h+Jqa1
sQx1aosCZ3Wt99AB+5z1BfyInf5n1vBvtPflWGWPZdjOX0vrcdF4q17OH1Ps
9ZT+QVRjoH4Fzxz+yXInvLts2o7eSwud+cPihqE/hvM38h/lT7H+gmS88VrU
Y4v+KlqGIszUb+Zfxr9avnx5i+lQOo++In+KM2jmbcQa/rO8LZ33r9qt1PBf
WuUbJ6jDMe0CuoPm0F+8uSL3+iFUyfesvPvVrrucI9Uy4Y10t8+2yffH05R8
A9b82P3+T84V7kKq89ir/7fxYveoSE3nYYH79iaq7KXIGRXw/g8N4R2/
           "]],
          "1.6800000000000002`"],
         Annotation[#, 1.6800000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H+sz3UUx/GDTXaTe8V1Re695PrtXkLNRXRNim7p3iSW7mrd7vYlbPpF
dS8bayJujBpr3bSu7t2VRVN9KyHSLHeMu/wIuYsSaasoIT2+fzy/r8/5fF7n
vN+fc96fb/cnZ5fMahER2/3clx1Rc2vEG+kRFb0iSvBwQcRo3HBLxHXacVBE
Wb+IZ/F9RkSenJ10gngYfuVpwsjMiE+7Rly8OWJpt4i0DhH7xbvUPuXeSXX2
0e5dIh5vF/GKeImcw57P4f1T/Bitt+42vOX6rP1cQ/veEdN4m1zvwEYs8jzR
P2J5+4i5AyM+9ryM1tDV9jMiK6JY3nDkoYG/kr+Iv5YeEr/t/kfYjVnyltDn
8AS2e76Sbz1/jbrNni+jjbRO/QfVb9En4jfeI2jkTWIqf9qAiGyM8vwhhH4N
l3veu/YVZ+ISbzO28p8zg9CzO/SmyfX2FD355DXpxcge+kyv6ecvmNBZL2+T
j8zuEZ/R99EkZ0BqRrl6hnPeoY/cWv6b6L3iEfwlrp/GfBTyVdjPZfeXi4fw
PGpfuXQcfTUvYi12mtli9FCr2T7TaVivqpNzYu1kvn3gkP1t9p5Xc+zH9TB1
+jkzQ2mRGY/FGGzRv7vpCu9djcnijfq6CR9iox40oK1av1v/Ak6qfwKrrN3R
2g3WbmeddGSgnr/YWmvVekrtdTSfnjez/vL7oS++EG/grcVVda7hCv7Fafn3
mElL/UjyDbXWEMw3v8/FL9B5eBEfWH+mniyyxmJMl3eWZxh/nef1qE35sAE7
7b1azg66C18j3fv94zu6jIv4G5fQTe/32H/m4Ihv6Y3I0ZdcdENbcTbtJP+c
9cZYd59ZNqLZGXjZjE7RY97pBxzFCRzHNnvIobnI1rccZKnTxbw601zxQNf5
vtfptIAe14819CCtpsfoXN5FergURc5nuXNQSKfJ6Z/ymOsZ9BIXqjmK/4h9
DaKtfMMb1LjfHu5CMf8DfAtoqRpz6HdyktgiZ5T4HboMbazTFYfNajcue+dP
9Ow9/OgMl4nnOdMT6V7xVryLO32T153DMjoRVXo7A+Nx0fM3aVZHZ17eOpTq
32vWGU1v9+x513NT34t9Z5lPKd1v5iO84yTMtLfedApdIGcwf4JultPGvZ76
lIFy82pp9p3wjXNxAUfxlXmu5l9v78ux0h4r8SV/kjbiD/db9zUrTLXXE+K9
2IrB4lqeefxT1M4z5wLano6lFc7MI/KKkI9x/M38B/jTrL8wle9+Eo2oE6+k
lUjgGfEl/tf5V6lXqu4MOppW0ZfUT0udX95mrOY/zdvKvH923VoPr9AG7zhJ
Hw66LqfbaCH9ybeU8H1ORoN6s9Xdo3c5ao7XyzxnPMc+M+gBnjOp/wRrbvLt
/admtbPQwTx2if9yf4ZzlNDTKix03tagwV4SZlTO+z92tByY
           "]],
          "1.54`"],
         Annotation[#, 1.54, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Hto1lUcx/GvgtpA27zfL3OPl7xuoebUBguxNEtdtZRoSC3hWalhBrN8
VDBCt2QpWlSSWZtpj0kXdA4yMzUQG5qNvKTWMCs3DTIHEqa9nj/e+zznnM/5
nu/5nu9vuc8sLVnSLiLq/XloUMS2ARFvZkcsGh4xD4+NjyhCx74Rt2n3/Iiy
UREv4aeciIQ9h+hM4wm4wtOEqT3F7B9xo1tE1cCIrO4RJ4wPi/2ruYvifE+H
9It4+u6Ilcbr7DltfSnvdeOn6C7nHsDbfv8pn1vIGRGxgLfJ72+wG2utJ0dH
bOgasWxsxJfWy+g2ulk+U3pHzLZvMhJI86f4i/nr6I/GW81/hiNYbN86uhwL
cdD6Rr7t/NvEbbZeTRvpTvEfFT9GRlzlPYNG3gbM588aEzEQ06zPxR13nGxv
Kx1p3ANtvM3Yy9/iDe5goto00YMZEnzq3KQWU4eqM72lnn9gZh+1zLMfPXIj
9tNaNNkzOvNGQ9QMLe4wwt46/s70QeMp/PP8fg4rUMi3SD43zW8wvpfnSXkN
ptPp68Mi3sEhb/YacsUK71gjn5rB6oOL9i50t5Xm3pNDin6sB3Ygz/1eNZ4l
Xrb4XZGDC/IcrZfO0xX6qBID9EB/1DtvH+YWeINeEUfHRWyiHcXerY5plFrb
6g0K+Mfz5mO5+i2WYxc5rhC7EkOdX+n8LvLsjLQ43cVp9Y738U1CLV8Z37d8
Leb3Oy/FV09X0vP0AlqdcRXX8JG71eIT6+es7aI/02Fq8aIc9oj5KVoz74Cz
7vesM3pb74s+aPFm6+WSo3bd5NYVZ3juMrfJvbJoJ+zPnClmyv3+og3GbWL/
IO5JXFLDtFyG8uYhFwflk6BXxDtuX5U3G6N3qulE2uqsfHqdTqBbzJ+SUw09
R5fJaa0+rEKxupTLtZAu4B2V8TjvMoYZF4oxjf+Mc8bT9r7PHWI87Pz7MZv/
Eb7VtESMpfS4PQ34wp5pxu/TanRyTj+cdr8juOl++9TuQ/yib8qMK/XrLHrM
eC8+wCTf2209VkZnYZX+qMAM3LD+Fu3VQz/b9y5K1Gy9c4pogbWX/V6W+Rbk
3Uvfl9ATajfFHefgebkNp6V0tT35/En6uT2dzOWpUzbK9VM7fdATR/XpNZzF
1/5nbObfLvcN2CjHFL7ib6CN+Nt8h3v0B+bL9YLxMexFvnEdTyV/qdgJ7zuO
5tAH6CLfwhP2FWMspvM385/kz3L+msx+8w1oxE7jjTSFJF4wbuN/g3+TeCXi
VtAiuoq+In6WN2jjbcZm/t9423vv3/3uoIb/0rQ7zlGHU36X0wO0kF7St0l9
+zjS4i0R9zu1GyTmDLVM+O4GyTObnuS5jIvO3OM7+E/MGr3QzXscNv7HfIU+
SqrpKqzRb1uQlkvSG5Xz/g+bKxQ3
           "]],
          "1.4000000000000001`"],
         Annotation[#, 1.4000000000000001`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H9M1lUUx/HDhspyYf5AhEQF/JGkorMmYm44Z2mWiWW6FnNF1GMlDXUz
C3TRmkEOMa3VSrKp6WgNM0oqM6e1uSKdsbRWJpVaklsqFGum9uKPN5/vvfdz
zz333POQ/fBTC8qTImK3P3cMi2gYGrGhX0TZ6Ij5WJAfMR29MiKu0AETI0ry
Ipbjuxsicu05QGcbT8YfPG0oTIv46MaIzgERNVkRKQMjjhgfFPuUuZPifE2H
Z0Y8mBrxrPE6e45bL+e9aPwA3eXcfXjV9+/yuYx+YyIW87b5/hzvotp64uaI
9f0jKsZH7LFeQhvoJvlMTY+Ya98U5KKRv5K/iH87/db4DfNNOIQn7VtHV2AJ
9luv59vK3yBuu/Va2kp3in+3+Nf4/sQJtPK2YBF/yriIoZh2U8Q9uOqOU+zt
oGOMB6KLtx3N/Oe8wVXcojZtdH8PI/nUuU0tCnPUmV5Wz7OYPUQtc+3HwOyI
vXQb2uzJ63mjEWqGc+4w2t7t/H3p7cZT+ef7fgRPo4CvTD7d5tcbT+K5X17D
6Ez6wqiI13DAmz2PEWJdk3OdfOqGqw92eddT9j/kflVyL3SPsWqUhzfl1IAt
+HhwRH+xBmCoff/QbvzC/zft6pnna+HLontppr6oVush9DmaQX90x1Z579Bn
e3iG8A4WLx29zfVBs/l08x/Q9gnqJLfVcu50xiWk8TZZS+Np0tO78Zf1C7jO
HXcYZ7pTDm9f43eMU+k22ocm5JFCy+hjeBTJzl0m3nl16uLrxCdq9YyYG6xv
RD2arFcgR31ykY3r3a0XfzKWyHWUHq91/ln7a+gZupG+jOVyX4GVmKEfu+TR
ibX2dvB9o57nrHUgX79cpJPpZu90zP46+gOtcE6196pBkRxL9VABXcw7tsfj
Pqcx0rhAjGn8J8SeQJPkt0OMO933Nszlv4tvDS0Wo5x+ZU8L3rdnmvEWWove
zsnAcfkeQre3/ND/krfxsx4sMV6lJ+fQw8bNeAu3+k1d0ZcldA6qJkUsxSx0
Wn+Fpg3Ss/a9jmJ98qJzptOJ1lb6rujpd3mn6e1iekS9prrjPDwut1F0IV1j
Tz5/gu62p7e5HHVKRalah54ahC/8rs/je3zmHTfxb5X7etTLsRKf8rfQVlww
nzxWz2KRXH8yPoxm5Btv51nFv1DsXP05nvajM2iZHrnPviKMw0z+dv6j/CnO
X9uz33wLWrHTuJ5WIoEnjLv4X+LfKF6xuEvpdFpFV4uf4g26eNuxif833iTv
fcZ3shr+SxvdcZ46HPNdSvfRAvqrnk74vdyLRvGWiful2mWJOUstc/VqljxT
6VGe0zjpzPf8Jv4Ts04v9PceB40vmV+qjxJqWoW1+m0zGuWS8EalvP8D1d4O
mw==
           "]],
          "1.2600000000000002`"],
         Annotation[#, 1.2600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1MlmUUx/HTjKGWpIBviRovvqWiWRNUnM1pmqWSma7F+oPcHvMlTctK
1M1yphLZtNK5yBYF0cwkKlpkTmu5Ip0xMVsWK3sxNUXZXDO1Ps8fX373ua/f
de5znes8ZJcumfXYdRFR489d/SIqsyJevCli3sCImbhvREQRru8dcYV2GxlR
cmvE4zjaNSLHnn10ingU/uRpxpjuER/1ibiYHrGhb0RqRsQh8X65f/buhDzf
0H43RzyUFrFSvN6eFuuLedvED9Ia323EK57/UM9lpA2KmMvb7PlzvIu11hND
I8q7RSwdHlFnvYRW0i3qKewZMc2+0chBLX8Z/wT+KvqdeIf3u3EAC+1bT5fh
Yey1vplvJ3+lvK3WN9ImWi3/vfJf4zuNY2jibcAc/tRhEX0wdnDEDFx1xtH2
/kUHitPRztuKev5T7uAqbtebZro3SR6fPjfrxZgcfaaX9fN3TOmll7n2Iz07
4mP6JprtGZK8o1v0DKecYYC9Vfyd6WRxIf9Mz4/gKRTwzVPPJe/LxSN5HlBX
XzqRrhsQsQ373Nmz6C/XNTVXqKeiv/6gJnmv4k9otfpeRRdxGibr1zjnGi9/
o32dzE9njPeuCM/oSap4JW2R6yiy9HaHs9xg/414TnxcvI7+QNPoJvoCyrFR
XSvkWkY/kKsObb7byRx2RKZ5yUAP3roeEUvUsoemWDvPN8OZpmOX+D1Uyz+I
922a6uw1tBOtpR3pO/Scfp+z9wz9G2exXA3FzpHuW92Qp3+5OC33E/I9iYTz
ZSZ7at7n8nb3PIde4PlK3oVqX4BF2C3ubb2JnrXvHLbzfus722i+Prd5N4pu
1fsjzlVBj9Ol1teaow2YoIel6iugc3kHJz3OeRK54gI5xvIfk3c4DbW/Jcfd
6h2Hafz38K2mxXIspl/b04A99owVv0Y3IsV3eqFF/QdwyXx96P/EG/jJfJWI
V5i3qfSguB6v4w6/lytmroROxarbIuZjEi5af5lmZpoB+7aj2Jw/7ztFdIS1
5Z6XJmdZ3Zl6XkwPmbdCZ5yOR9WWR2fT1fbk8yfo+/akeJetT11Q6h7+81vN
yI/4gp7B9/jMb34L/061l2OzGsvwKX8DbcJ57zsMieiJOWr9UXwQ9cgXV/Gs
4J8td475G0bT6J10nju+374JGIqJ/K38h/lTfX9Ncr/3DWhCtXgzLUMCC8Tt
/Jv4X5KvWN75tIiuok8nZ9kdtPO2Ygv/r7zhvn/z3EEP/6G1zjhdH454LqWN
tID+4reVMIuzkr8D+RbJ+6XeZck5SS9z/Bay1NmFHuY5iRO+ucuc/ytnhVno
6j72iy94P98cJfR0FdaYt62oVUvCHZXy/g+S7gWA
           "]],
          "1.12`"],
         Annotation[#, 1.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1M11UUx/GjOVYLU8SnQE0EExU0cqLERnOWZpmUpmtRf6Ab9OBCcNpS
2SwjyaENczYm2KLhcGU1NFpmDrW5YjpjaaUYK3uw3MpgM2c+9fr98eZzz72f
e+79nnt+ZCytWPhiv4jY4c+DYyIaR0VsHhSx7O6IBXhsakQhbrkz4iodfE9E
yaSIFfh2cESGPQfpHHEefufpwsxhEfvSI3qHRGwcHZGUGnFM3CH3j+a65fma
jk6LeOqOiJfFNfactL6c96L4SbrLufuxzfg397mCgRMilvB2GX+B3VhvvWxy
xKaUiIrciI+tl9BGWu8+M0ZEzLNvOjLQyr+Gv4i/mX4jbjC/B4fwvH01tBLP
4ID1LXw7+Rvl7bFeSztpi/yPyH+d70+cQidvOxbzJ+VEpKEgO+JRXPON0+39
g44Xp6CPtwdt/Oe9wTXcqzZd9ECCLD517lKLmePUmV5Rz18xZ6RaZtqPlIyI
T+i76LInO/FGY9UM531Dlr3N/LfRB8Qz+BcYL8Vq5PMtc59L5jeJp/I84V6j
6Cy6YXzEdhz0Zq9gjFzX3bnOferuUh/sSryr+FPa4n4piR6g/ehevdCf9vq2
V/XLeff7wZmn8a9euoyL8ja4e7qa7pa/FSvNp4lvpduGe1N5qp21DoPMb+bv
9RYr3fus+4w0n4bXxDV42niYPqky7ra+gp6hlbTWeRemRByRd7I8X9Ic2kEn
0cM0mx6iE+k037/PPZqce0N8Wp5U+YdiiDfdIGcKrbRWhRUI3pU0Va8k279H
vFr8Ab1d3IQs3/mXHJl0tHo1yHFRnGe8Vc1OyFtHv6cV1tbri40oUutS751P
l/BOSHjU5xzGifPlKOA/peY59Kaz3pPjIeffh3n8D/Oto8VyLKdf2dOOj+wp
EO+gtRjgnBE46fsP4ZJ32+sd38FZ/VIiXqV/5tKj4jY0YZr+v6qHSuhcrM2L
KMds9Fp/i6YOVTv73kaxvnjdOYV0irUq44pEb7p3qj4spsfUfYZvnI9n3S2T
LqLr7MnlL6Mf2jPA3Fh1Skap2t7w2xvivQ/TC/gOn3uXev6d7r4JW9xxDT7j
b6ed+Nt8/4kRw7HYXc+Ij6INueJmnlX8i+TOSPQSHUjvp8u880L7ijAJs/h7
+I/zJzm/OrHffDs60SLeQtegDM+J+/jf4H9TvmJ5y2khXUtfkj/JG/Tx9qCe
/2fem3r7F+P+aniZtvrG+epwwriU7qf59Ce+Mn3xOFrle0HeI2qXLudstczw
20p3z2R6nOccup35vv/T/8lZpxcGeY8O8T/my/VRmZquRbXf3Va06r0yb1TK
+z//rAD5
           "]],
          "0.9800000000000001`"],
         Annotation[#, 0.9800000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1o11UUx/GzySBQdFtqbb+ZezZ1PpWbJizE0ix15VKiUbpGW+VqFmk5
HRhhmthqDxjRNFpMFmHKqkVmogWSY1IjTWg6yh6s/qiUJOZD1uv3x3uf77n3
c88999z7W17N2sqGlIjY5c+dN0V05ES8MiaipjhiGe6dETEPqVkRl+mYmRFV
UyLW4pv0iFxrDtGF4pn4hWcAc8ZFfJiIOJ8ZsXVCRNr1Ef3iw3KfMTYozzGa
kx3x4OiIDeIt1pwwX8/7p/gBuse+B9Du+2f1DGPUpIiVvAO+P8O72Gy+dmrE
9oyIhmkR+81X0Q7aop6yGyIWWzcbuejmb+Qv5++kX4vfML4XR/CEdVvo03gI
B8038+3m75B3yPw22ke75L9H/qt8v+Ek+nh7sYI/rSQiC3NvjliKK84429pf
aaE4HRd4h9DDf84dXMEsvRmgB5MU8unzgF7MyddnOqyfP2HhjXpZYD3S8yI+
om9jwJpJyTvK1TOcc4YCazv5r6N3iMv4l/l+BOtRylejnovGt4un89yvrgSd
T18sitiJQ+7sBUyQ66qad6hnx0T9wZ7kvYo/pl3qS0++Aboz+R6caUOybppw
/ktyFVnTPz7iSeesxxk1nMYgljlHoV4VocL3Av1eSo9Zf8nbG8boZE3Wt3ln
7bTVuTPdx2s0g7bQbHsV2KcQWZhhbDrWWzPWXMJYu5oLnWW93MXOtc/cfrQZ
b8VT9npWnMWfz5+HaqzGcmMP01XI0btBv4UEfVS+JvukquNvOdaYT5XnP3Vu
NJ5i/HnaiA3YixZ9LXOmhD7l612RWgroKvFq3CrPKbkb7LlZv7ai3Fi1vpTS
lTzF/KfUehZ54lL7zuU/6WxT6TX535HjLvvdhsX8d/NtohVy1NMvrenFPmvm
it+k2zDCPuNxwjmO4KJ7+sB538Jpb6ZKvM4bWkSPinuwC7f4DVz2jqroImyc
FVGHBThvvo1mjvXGrHsdFd7uS/aZR6eZe8Z3Q/J9qjvTW6yg/fpb5oxL8Jja
8mkl3WRNCX8tfd+aEcYm6tNIVOvnv95TxvSIz+nv+Baf+h238O9W+3Y0q7ER
n/D30j78YTxlcsQ4rFDrd+Kj6EGJuJNnHX+l3LnueAodRW+nNe56uXXlmIz5
/EP8x/nT7N+UXG+8F33oEjfTRtTicfEF/pf5X5WvQt46Oi/5luhz8qe5gwu8
Q2jh/4H3mvf0o+8UPfyHdjvjEn34ync1PUBL6fd8td7FfeiWb428X+hdtpwL
9DLXby9bnSPpcZ6zGLTne/5XX5JzR/K36D4Oi/8yXucd1erpRjT5H92Kbm+v
1h1V8/4PIcD55Q==
           "]],
          "0.8400000000000001`"],
         Annotation[#, 0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H9M1WUUx/GjY2vTIVhioiSiib8VJ2huNmdqmkkKuuZdf5DuWmkT3ayJ
uvXLMkYU1jQXmVoYrZWFhmXmtDbSK65YWi2LlZama5VMa4Q/qtf9483nOc/3
nPOc5zznUrBkZXllt4jY7s/0gRH1eRHPZUUsLoyYi3vGRUxGt9yILtqrKCIx
MqISX2VH5Is5SGewx+EsnzZMzInYOyDi4o0Rz9wSkXFTRCv7kNw/2Dslz1E6
oH/Eol4Ra9gbxJzwfTnfP9j30l3O3Y+XrH9RTyd6DotYyLfN+hO8hcd8T46K
qO4dsWJMxHu+J2g9rVNPyc0Rs8RNQD4a+Vfxn8J/J/2SvdX+OziMh8RtoCtx
Hw74XstvG/96edt930hTtEH+u+S/yu88TiLFtxkL+GeMjuiHScMj7sYVd5wg
9lc6hJ2FDr7taOJ/zhtcQZHetNEDaW7lp89tejFxsD7TTv38GTP66eUQ8cgq
iPiA7kCbmML0Gw3SM5xzh8Fid/K/gd7BLuE/1/p+PIJifovVc9l+NXsMn3J1
9adT6ZNDIzbjoDd7HHlyXVVzjXpq8vUHu9Lvyt5HG9SXlZ4Bujk9D+60hj6M
f60L9aBITCY7ZU5y+I5Xd2vfiG/VcozOc5fp6dlgn0zfw50S9s7SY3K0Ypw5
HItL6nlZ7VvxpryFZmOJM47y2cVuwBvI9l4vOCclf7mYIusyWinHUXt71fIU
HWD/Q5pL99EzYyM2udsOPdiO3/i/L1em9RO+7xF3hG6x/zkdI67J3jVcRYue
zXdOXzF/yXMJCfV147+I5qt3mfr6mKkcrBffyV5lv4sOE7fbXjjvP5qnbxf0
5Hy6L5itTxV6UyzvQt+G6uc3zj2NQexiOSY556R+jKTX5Xldr+6U6zbM4j+b
3zpaKsdyekRMM3aLmcR+hW5Ed+fk4ITaD+Oy8/f4H/Aavjc7CfZqszSTtrCb
8CrG+y10macEnYm14yOWYhou+v4i7d3HrInbglLv/LRzJtPRvq2yXpGeU3X3
NpOltNUMlrjjHDygtgJaRteJGcU/Sd8V093eQL+nHqjwDtf8DrO96af0Ar7G
x/pex3+b2qtRq8YqfMS/mabwu/0Y4Z2wQK3fsVvQhFHsnXxW8y+TO98cjKA9
6e10sTecL24KhmMq/3b+x/lnOH99Ot5+M1JoYNfSKiTxILuD/7P8n5evVN6l
dDJdSx+VP8MbdPBtRx3/n/heN3tnrEMP/6aN7jhHH76wrqD7aTH9kV/SXMxD
o3zL5P1M73LlnKaX+WYsV5096HE+p3HKmW/7n/2PnDVmIdN7HGL/aX+pOUrq
6dr0PJvjTWg0e0lvVMH3f/lqBWY=
           "]],
          "0.7000000000000001`"],
         Annotation[#, 0.7000000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV039o1WUUx/GzBoFic6Xl1LzbzKVOc+Z0CYaYzl+5Sq3worCku0rLH2Hh
ppD4s7UmlmmmGS4mi6hk1SIz0wKpodRIK7SWP5pTIcuRhU4z7HX/eN/Pc57n
nPM9z3nOzX988cxFGRHR4Gd8ImLb7REvd4+Ye2fENDxQFDEa0Tuik940PCJZ
GLEQ32dHJMTspRPYw3CaTwtG3RrxUd+IC7dErO0Xkdkj4iB7n9y/2Dsmzze0
T5+IWVkRS9mrxRx2Pp/vH+xH6U7f3Y2N1m3quYSuAyMe5tti/TnewQvOU0Mi
qm+OWHBXxC7nSbqNblDPyF4Rk8SNQAIN/Cv5j+FfR79jb7H/HvbjKXGr6SLM
xh7ntfy2898mb6vzdbSZ1ss/Rf6r/M7iCJr5NmEm/8yhEb1QMijiflxxxxFi
z9D+7Cx08G1FI/92b3AFRXrTQvekGcBPn1v0YlR/faaX9PM3TMjRyzvEIys/
4mO6Ay1iCtJvlKdnaHeHfLF1/G+k97FH8p9m/RieQzG/ueq5aL+aPZTPDHX1
pmPpyoKITdjrzVagr1xX1Vyjnppc/cHO9LuyP6H16stKzwDdlJ4Hd1pKn8Z/
1gV6UCSmG7vZnOxDgv94dqEcSfco1eOj6lppvlYhw9lZ9/rJ3o9oc88885KP
09Y13qJSnrW36Q/7JfYpmus8gTm++br7zaZ5Zmez9UI1nHOPL9S0F6+52yU5
LuNZM74Y7fJ1stfQOfKdpn1oG51NN4p5hB5nn+d/gs5ir6J/ifuVbrH/9zD9
RUotN+hf8m7n7IHWM5zvUO8KOtH9J+EQO0fPe2GXOrfK+QaesZ6H9eqvRTd7
v2O7e12134l2+yO82xl6Vq9q9a+dTtbTcr0doNcn1Zarp8X8S8Qecf/B9Jrv
vS1uopz3YBLfyfyW0TJ1zadfi2nCB2JK2FvpOmTI3ROH3WM/Lvrmh779Fn42
V0n2EnNWSg+wG/EmhvufdJq1JC1Fld5UYBwuOH+VZvc0C+I2o8wcrPGd0XSI
s8XWC9IzrO5s9y6jB73rSHeciifUlken02ViCvmn6PtiMuz181/rgnJv8a//
aHfv8iU9hx/wmf/6Bv7b1V6NWjVW4lP+TbQZ5+1fR4/B/v9qPWp9AI0oZNfx
WcJ/utwJMzGIdqX30rne+iFxYzAQY/m38j/EP9P3l6fj7TehGfXsWlqJFJ5k
d/B/kf96+crkraCjaRV9Xv5Mb9DBtxUb+J/ge83snrK+bib/oQ3uOFUfvrUu
p7tpMT3OL2UuHkSDfPPk/UrvcuQcp5cJc5Wjzi70EJ+TOOab78p7Wc4as9DN
e+xj/2m/whyl9LQKy/0XX0GD2Ut5o3K+/wMOXw0d
           "]],
          "0.56`"],
         Annotation[#, 0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021M1WUYx/FLWpuOgFIDNY+CmoKmBkJuNqcoqEmFWcnaQrZjDzqNZiZi
6ZqFjGxU8ymzheForYeZ0TTzoTaXZ5qxtBdZrAfz6UUlm3OmZtM+58X3/P73
ff+u63/9r/s6Bcln59b3ioh2P+VDIrYMjng1J6JuZMRs3D8+YiJuDIi4TG+5
O6JmdMQSfH9rRELMXjrNeixO8XSh9PaInXdEnO8b8UoiIqNfxGHr/XL/bO+E
PIfowEER87IjlluvEXPM+ULev6wfodsHRuzGm57/UM8l9BkVMZe3y/OXeB+r
nCfHRDTfFrF4bMQnzmvoFtqqngl5EZXiipFAB38D/yT+Nvqd9Sb7H+IAnhK3
hj6Dx7DH+Tq+rfxb5O123kRTtF3+mfJf5TuL40jxduIh/oy7InJRVhhxH674
xmKxZ2iBdRZ6eLuxg/+0O7iCcXrTRfekGcGnz116UTpMn+kl/TyJae7m0HDx
yCqI+Iy+iy4xI9J3lK9nOO0b8sW28d9Mp1pP4J/teT6eQwlfnXou2G+2HsMz
R10D6GT60p0R67HXna3GILmuqrlFPS1D9Qfb0/dq/TltV19Wegbo+vQ8+Kbl
dBH+8zxCD8aJybROmZP9SPCXWxfJUeM7SuiLerAMi/hTaiuwl49V9vrzn/Wt
53AGw83OsPR8qa9MraXYZU53uqM5tBprcyMaveui+8uk9WpYgpt4ct3nanlm
Wp/0bS94X4YcvTDffh0qnc1ApXoaxFfQTHNYYa/W+eMo1JtH6TxMtV+OaXzP
85fT3vxT7D3sfLN659IN2IQ8dWykA+hm+p56s+l2ekP9vcRlIKWH+9L3gW/H
RWxzfpRm8Z50l03+k+fUv0+P2uhpnEKtvg7R4zJ1HJejkF6TY5uzCrH3pL9R
zAyeRlql1wvpN97ZiY/FlFm/RZsQ8vXDMbUdwAXv/tS738FP5qjGeqm5mk4P
Wu/A2xjvf3HZbNXQ6VhRHLEAU3De+Rs0p7+5E7cBVeb5Ze+ZSEc7q/e8OD2z
6s4xn1X0sDuboMez8ITahtJq2iimiD9JPxIT9gabn96odVf/+k9m691X9Bx+
wBdmoZV/q9qbsU6NDdjF30lT+NP+dfQt8n9X64+eD2IHiqzbeJbyV8udcD+j
aB96L61zvw+Km4SRmMzfzX+EP8P7V6bj7XcihXbrdbQBSTxp3cO/lv81+ark
XUAn0hV0mfwZ7qCHtxut/L/yXvPf+N3zdXN3kXb4xln6cNRzLd1NS+gvfElz
8QA65Hta3q/1Lk/OKXqZ8P/JU2dveoTnN5zwzg/k/UfOFrOQ6T72W/9tf4E5
SurpCqw0/6+jw+wl3VEt7//Uif4c
           "]],
          "0.42000000000000004`"],
         Annotation[#, 0.42000000000000004`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/GHaumMKC1RlFAiDUxM1Nw0Z2rmhcpuk/UHsn6k6azMnBcS
My8h0qxma5EtmgyjKxUtM4e2ufxNlyzrjyymoZm6ZbKpU6EL2uv3x5vPec75
nOec73OeH7nlzz26KC0iGv2ZlBNRmx2x8YaIsqERM3H/nRFjcbl/xCV63ciI
kmERT+OHGyOy7dlJJ4uH43eeVozuG/H5wIgzfSLW3RKRdlPEPnGL3L+aOyTP
Xtp/QMTsjIil4jX2HLQ+n/e0+DFanxWxHa8bH3OfC+h5e8QjvK3G32AbKq0n
7oio6h2xsDDiE+sltJZucp9R/SKm2jcS2WjgX8Y/jr+OHhC/af5D7MI8+9bQ
Z/A4dliv4dvCXytvm/X1NEm3yj9N/i6+E/gRSd5mPMyfNjyiL8bkR8xAp28c
ae8fdLA4HR28bWjiP+4NOlGoNq10R4rb+NS5VS1G36rO9IJ6HsVkb7M3z36k
50Z8Qd9Fqz15qTcarGY47hsG2VvHfw29RzyKf6bxHDyPIr4y9zlrvko8jOch
9+pHJ9DVQyI2Y6c3W4Usubrcudp9qgepD+pT7yr+km51v/RUD9DNqX7wTUvp
AvxrnKcGhfb0Eif1SQuy+SeJ8+Uo8R1FdKUaLMEC/qS7zeHZTctTZ/EekeMY
rjK+Wz+Mx2FxrnepV4csOsxdz8lXQGfp2y5vl+G883Qtzzqsxhq8hIvOfdEZ
05yZLt8M+VaJK5GrFoMxCPPMZ1mfS7szIxbZO9sZ9c74T3zFGTU0Yf4UfYKe
pJ0j9Jwz3lfPbTjh97NQLU/Rk2j1GziATLnL5a527gZMMa6g7bw5zn/BOGFu
o7wD9GJP37pSXIn3nF3vrGprPcyHuWvpBvEHaMQ573i1+cvue9T7t+O0vvlU
3ibU4V51vot3Kr1PjVfQYnefT7+ztxkfe88x4rfoelzRP33U+6C8u3BW3s98
1zv4xVqJeLFem0L3iJvwNkb4rVzSbyV0CpYX+X5MxBnrr9GMm72VfW+g2F3X
OmcsLbD2rPHCVB+7d4b6FNN9ajVKLabjSXfLobPoCnvy+RP0I3uu+KaB+qwH
Sr3h336n13un3fQkfsLXaryJf4u7V6HGHZfhK/5mmsSf5rvRu8D/AHf92XgP
mpAvruNZnOpDubO9z1Dak46nZd7nQfvGYQgm8Lfx7+dPc35Far/5ZiSxVVxD
lyGBueIO/pf5X5GvWN5yOpYup0vkT/MGHbxt2MR/hPcffdBu3K3nztMG3zhd
Hb43LqXbaRE9zJfQrw+gQb6n5P1W7TLlnKiW2X5Pme7Zg+7n+Q2HnNko70U5
q/VCL+/RIv7LfLmaJ9R0OSr0+qto8JtLeKNS3v8BRz0JHA==
           "]],
          "0.28`"],
         Annotation[#, 0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/Gn2XRKeAuFJDVJRUMDdG42Z2oqF81qFKsGNNTSmS50gs4u
UsqMohqtRV7YMFzrMipaZs7LxoLpirJWWcxKo+wqC523Lup6/f548/k+53zO
c855zvNjzJKKokeuioi3/Jk1KqLh+oinB0WUjY8owILsiGm4nBZxng7IiSi+
KeJhfDY4It2avXS2OAs/8nRiyrCId9IjTg2NeGqkDa6NOCTeJ/e3xo7K005T
R0TcMzBirbjamiPml/H+IS6iO6+L2I0XfJ9wnrPolxlxF2+n7w+xC4+aL8+K
qBkSsWKy+5gvpg20znlyUyPmWpeNdDTzV/JP52+kn4hfMv469uNB66rpStyL
PeZr+bbyN8jbZX4T7aBN8s+X/yLfz/gcHbytuJM/JkWkYOqEiHxccMdsa3+i
o8VJ6OHtQgt/tze4gElq00n3JBjLp86dajElQ53pWfU8jtnepv1G65E0JuJd
ugOd1mQk3ugGNUO3O4yytpG/D71VnMtf4LsUq5HDV+Y8vcZrxBN57nCu4XQG
fWJcRD32erPHkCbXRWfe4jxbRqsPdibeVfwebXK+pEQP0PpEP7jTWroc//rO
UINJ1vQXd+iTfUjnnyXOlKPYPXLoBjVYg+X8Hc5WynOALk7sxXtCjhT6qfXT
6eN83caOIcPbZHmjZvXYhS8T59RfX9HVOG2PDD3USwdYX2rtGHGFuRr+zVjp
jhvtV40Fxhcin++gOwzkTUahsd+G20eOV7Fdfbb7ffRRo2Z6Nd1Bn+XZYH6V
nBfd7bixbbz32afb3P30ws1+bziHpfKmyp+GIdYNxX98RdbdjSviy9joLO3Y
5X2a0WOulu+0fGfwF+rVopc+4OznnWe8+KT8v+BX9LGm2tw8eeZjkHgg2pz1
NnefayxPzxc4dz7mqvU8rPMOheJl9CN5WvEm71Txy3QTruinIWp8RL796NVr
b/ufsQ3fmCsWV+i9ObRN3IJXMNlv57z+K6ZzUJXr3TETp8w/T5NT9KZ1L6JQ
zz9pn2l0grlVvlck+tr5k/VwIT3kPrlqloclzjaSLqLrrMnkL6dvWHPFnUbo
u74oUa+//W6v8SYH6El8gQ/0Vh3/VmevQa0zVuJ9/lbagd+NX8Lgif4nOOvX
vtvQgkxxI08F/yK5073ZONqP3kLLvNHt1k3HWMzg7+I/zB/2X59Yb7wVHWgS
19JKlGOpuId/M/8z8hXKu5hOo1V0jfzhDXp4u1DH/x3vP3ryB9+X/FbO0GZ3
zFOHj32X0N00hx7jK9dvCxN9J99D8h5Uu2FyzlTLdP0yzDn70sM83+OoPV+T
95ycW/RCf++xT/yn8cVqXq6mVViv559Ds54s90YlvP8DMcIK0A==
           "]],
          "0.14`"],
         Annotation[#, 0.14, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtM1mUYx/FLTafk8gBokidSEQXkIJvmTJ1mWlmtYm0h20MWzmqhKTlz
zTJHNgqxA9Fy09FaZVQ0zZza5pLpiqm9yGKdlOqFKGUOlURy9HlefPndh991
P9d93defzBWrH6zsFxG7/Zk3PqJ+bMTLwyLKsiKW4K78iGL8d3PEZTqkIKJk
esQTOD48IkPMfjrffDrO8LSiMD3i01sizo+MeHFcRB89an7A2T8an3LOEToq
I+KhmyLWmm8Sc8J+RWpEh/kDdNeYiL2oNT4tny4MmhpxP2+r8Zd4D8/ZT+RE
bBkRsSrPfeyX0HpaI5+C0RELxc1ABhr51/HP4t9BvzV/w/oHOIjHxG2iT+Jh
7LO/la+Bv965bfY30xa60/l3OL+b7w+cRAtvM+7j76OpuRFF2RF34oo7zhD7
Ox1vnoJOnjY08bd7gyvIUZtWui/JZD51blWLwlvVmXap52+Y722OTBKPlMyI
z+i7aBWTmXyjiWqGdncYJ3YHf396u3kB/xLj5ViNfL4y+VywvsU8m+deeaXT
OfT5KRF12O/NNmK0s7rlXC2f6gnqg13JdzX/nO6UX0qyB2hdsh/caS1diR7j
TDXIETPYvEWfHEAG/zzzLGeUuEc+3aAGa7CSv0Vuy3kO0fLkb/GedkYqPSn+
+KiI24xL7A3Vn4+IL0WHepzFMAzHdvEdcn9G7B7jXPfLQ5F+molibLNeh1pk
2ZuS7BX3fhOz1WEWZurVIvTohd4ZvhVcxTX04BJvurxGYSL/BPTydrvbFVyQ
49PyGOc3rlm/QW617tCPDkB/NMh/kbsP0Gv/2KuwdpGmOTMVI5yRrQc30ml0
JO11ry6+183Pedftvs/LvO3i/rZeZ/0vuo1OkX+790hx5yFYJPaw9VS5nuH/
mK8Ju5Enh1ws5N/kTTbIq1XuFer9tbhmfGSvyPwtuhnX9dJwdz0hr4O4IJ9P
5PMOfrBXYl6p7xbQw+ZNeBu5vpvLeq+ELkBVoTfHXJy3/xodmqYvk/fDUv3+
gt8pplPtPWW8KtnT8hvq7ZbSo2pdoA6L8ajcxtJl9FkxWfwJ+qGY62o+xv0G
olSf/+ubvdF7HqJ/4jt8oQ41/A1y34KtclyHPfzNtAVnrfdi2DT/D+T6vfFh
NCHLfAdPJf8yZ2eo9WQ6iM6mZd7gHnGzMAlz+Nv4j/H30fXJeOvNaMFO8610
HRJYYd7J9xL/K85b6txyWkyr6Brn9/F1og01/D/zXtWzvxr36ouLtNEdF6vD
N8aldC/Npz/xJfTI3Wh03uPO/Urt0rzrXLXM0M9p6jSQHuP5Baf85vvOveTM
ar0w2HscMD9nvVzNE2pahfX68FU06q+ENyrl/R+NQAtV
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1XuQz2UUx/FjZiWZQbvI5rZLy16yy6htjDBNQumi/dG0zOyWy9CFDRk1
RklsQ42msWnaadmmXEa1smRQFjtMtuimdrpJ+qMwIdalkVm9vn+8fb7n+3ye
8z3nPM9vZU+pKJndJiL2+Gd474iqnhHLOkVM7h8xGmOLIobgv+4RLfT6QRGp
/IiZ+LJzRKY92+kIcR5+42nCoK4RH/aIOJke8WKviFa6X7xD7h88H5FnH+16
c0RJx4g54kX2HLI+LSPiL/F4uiYzoh6veT6qnnNoOyDiQd4mz5/gXTxnvawg
YsmNETMGRmy0nqJVdLl6im6KuMu+gchELf9c/mL+anpQ/Ib367ATU+xbRJ/A
RGyzXsm3mr9K3mbri2kjrZH/bvkv8h3HYTTy1uEB/laafmvE4NyIe3BBjwPt
/Z32ErfHKZ5mbOI/5gwuIN9smui2hFv4zLnJLAb1NWd6zjx/xQhns6+f/Wif
HfERfRtN9mQlZ5RlZjimh572VvO3oXeKi/hHe56E2Sjkm6ye094vEQ/guV9d
XehQujAnYiW2O7Pn0U2ui2peqp6lfcwHa5JzFW+mNeprn9wBujK5D3qaQ6fj
X89ZZpBvTztxo3uyA5n8w8U5cqT0UUgXmEEFpvM3qm0Szy5annyL96gc6fRw
sj/RbhGd6RW1buZL8dXRLfgYJ81lLe8J+rJ7e1TfK5xhmjzn9dWgtlz95mEA
CpCP43p9mKcEKWyTayvGqqvf4IiHvOtLx9Nr8oY9rXSvOq75RoH9u8X59At3
fL33G1Dsudb3b6Nr6e30AH2Ulsj9jzlfh/P6yuY/R2c632W+NYP2UcMzcp71
e6ygvcVPeZ+yPhETcMmeDu7qZfq0tTy+d/hz6Woz3qXnnZhq7TTPFHqGTqP1
7ms6XSf+ujDifVoiZ4Na9uAb777Fbs+r1PwZ/dtsL5pxSjwh6QOPYCJ6d1Gr
fs4kPfG0YL1vb0y+QRfo+aAemjDN2e01zzpssDZYvIouxlV3tJM7ckgfO3Ha
jD8w37fwvbWUeJb7PJI2iDfhTRT4Pba40yk6EvP0Uo5hOGn9VdpBjQvtex1j
9PKC7wyh/a096XlG8ltRXwdnPIbuN8cifYzCY2rrQcfRZ+3J4S+j6+25atbd
3eU0lOr/ktneYHa76B/4Clud03L+1Wpfgko1zsUW/jraiD+9v4KOef7OqPU7
zw3YhBxxNc8s/nFyZzqvfrQtvYNOdrfus68YfTGUv5n/AH8rnZ/s974OjagR
V9K5KMPj4lN8L/G/It8YecvpEDqPVsjfyncKzVjO/xPvZb+tXzxfcQfO0lo9
jjKHzz2X0npaSH/kK3OH7kWtfFPl/dTsMpzrMLPM9Hc3w5zS6AGen3HEN9+T
97ycS92Fds5jh/iE9+VmXmam8zDf/xcrUOuOlTmjUt7/AcDsHk4=
           "]],
          RowBox[{"-", "0.14`"}]],
         Annotation[#, -0.14, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/HHQFM3UVCTuIgo4iUBY9M5U2ehlqa1iDYhoTKj2hRFXTWz
1JlFma40WjYNsysVLUPmpWz+pkumlcti3bX+qGRzzbyVOarX7483n+9zzuc8
55znOT/y5y8ur+sWEZ/4M2lwxOaciCf6RlQVRkzHjSURpfgnM+IsvXJsRPno
iPtxpF9EpjVtdLJ4JH7iaUfJwIh3syNOZUQ8nhvRRQ+Kd8v9te/j8hygA7Ii
bkuLWCJeac1R8/f2j/hNfCvddnXETqz3/aPznEHqiIg5vO2+d2E7HjZffU3E
mvSI2qKIt8yX0820wXmKB0VMtW4MMtHEX88/jn8LPSx+zvjr2IN7rFtJH0AF
Ws2v42vk3yxvh/lVNEG3yn+D/Of5fsZnSPC2YDZ/F00fEzF2ZMQ0nHPHMdae
pDninujk6UAz/wk9OIdRatNOW5MU8Klzu1qUDFVnekY9f8BkvTkwzHr0zI94
j76Edmvykj0aomY44Q7Z1m7hD3qduJh/uu9KLEIRX5XznDa+RlzIc7Nz9acT
6IrhERvQpmePYKBc5515rfOszVMfbEv2Vfw+3ep8PZNvgG5Ivgd3WkIX4C/f
eWowypoe4oR3shuZ/JPEBXKUu0cRfUgN6rCAP+FslTx7aQ09TIfQY9bm0XRr
S+UcwfuFPQrVegSq5JqHO7GP7wLPRbzM16lW6VidvDdmG5+DW9BLb7P1uDfN
oeuvingWR9y/EVeoSwq6oTtScbucWd5lNj4ujvgIb6vbFDx1rZ7RSdjlXK2o
V8Mcnlxk4z/v6pjcr+B6vqkIe6a5Tx+8ZrzM2DBnXWbtEDo0WQe582k+3cGT
wpOKEn0qRoXf69/y9HWPfkjDv+JKv7cq1LpvjjNXOH/w3kEHi3ORwZuOxerU
i6/OPvPss4ieV9Na4zP5G+VJqNUBPCrHm/Jv15td4mnm2uh02n1AxH1+F7XY
5K09jyrvtVG/K+kOb/FV5PLly3/SPcfr7Sb3X4XL/GnGj9pjD07zvuN/0Iv4
yly5eKG3PIXuFzfjBYy231nvuZxOwVJ3qMFEnDL/DO1tzxXWbcQMZ3nMPqV0
uLkHk3dN/k7cu7dez6AHna3YHctwl7Nl0Vl0mTUF/NX0DWsuu9sg7zgFc/Xj
gt730u+99Bd8jg/VuCFZB2dfg3XOWI8P+FtoAr8av4Q+o7xVZ/3S9340o0C8
hWch/yy5M9V/KE2l42mV+s+0bhzyMYG/g/8QfxddnlxvvAUJbBWvo/Woxt3i
Tr7V/E/KN0PeGlpKl9I6+bv4OtGBBv5veS96j9/7vqT3f9AmdyxTh099z6U7
aRH9hq/am70JTfLNl3ef2mXo60S1zPTbyFCnFHqI5zsct+cOef+Uc6230EM/
dot/N16j5tVquhTLveOn0eSdVuvRXN7/AbnNB04=
           "]],
          RowBox[{"-", "0.28`"}]],
         Annotation[#, -0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HlslUUUxuEDWCtJlbLIFdACFmTpAlUMgUIUBBUxaDWxVG6VJbghQkFA
ggtBtCw1JoCx2FqCElmNgKRqQuQGoo2KCUvjjoIbVUJYNagVfb4/fn3nzLxz
vpkz57b31Fn3PNEmIjL+lOZFrLo64vkOERXXRYzBrYMiSvDXVRFn6KWDI8oG
RjyET3IjUvbsoiPE/fAdTxOKr4zY0iPieKeIZ66JaKV7xY1yHzY+KM8e2rl7
xN1XRMwSL7LnU+tTO0f8Ip5A67tFbMcK42+d5xTa9Yu4k7fJ+F2sw3zr6YKI
xR0jphdFvGW9jK6i1c5TlIq4yb4CpNDAP5t/CH8t/Vj8svk38R4m27eIPox7
sdP6Ur41/Kvkbbb+LM3QOvlHyX+O7wd8hgzvNoznb6W5hRGD+kfcgrPuWGDv
97SHOBstPM3YxH/EG5xFf7VpojsT+vCpc5NaFF+rzvSUen6DEd5mT779yO4d
sZW+iiZ78pI36qVmOOIO3e2t5f+Pb7i4iI4xNxGPo5CvwnlOmF8s7stzh3N1
okPpwr4RNdjlzRagi1znnHmJ8yzpqT6oT95V/Datc77spAdoTdIP7jSLTsOf
xnlq0N+eLHFGnzQixV8qzpejzD0K6Tw1mIlp/Blnm8izh84QD/D+HxpvlGct
rcX17n4DVhufcL551hbihLkab/WTey7XryuQ45uX47y3fFHfrXCvY/atocvE
R40b9fmP9hzDSTW9KEeqRB3pP/gXXcWtdIo9kzHKG8+R82Y6l85P7oGp1tqo
Wzndy9/B+XMxxzd2iHfic9+uw2/O9zs2q/kWbMU68yuTHF0jnnS3Yprj20X0
kLUNqLE+SLzQeiVNo6444jXskOMp86flnWR+rblabDe/wPwp8xXm75LzflqI
N5ypk3g9nahWA81NEBfQi+522P5mHMJGc1l+E+foJTQ7+b+B8d7qPnvLE+RZ
676F6lCEUt8ejlpn34+ecudhUnIGnOQdofZ17vU66jHYOzyqVx/DRr16EAfQ
zx02u8MrOCQus28Gz0i6W7wJqzHAb/KMvi6jI1HlO5UYhuPWl9P2XdTQvpcw
1vee1o8ltI+1R4ynJ78X/dHeb2Ms3evbRe43Gg/o7250HJ1jTz5/mm6w5299
0FU/t0W5+5/XI5ep3fv0KPZjh5pV869x9sVY6oyz8Q7/NprBz+YvIGeA+jrr
AePd2IR8cS3PDP5xcqe8R2/ajt5IK7zB7fYNQS8M5W/m38ffSucm+81vQwZ1
4qV0NtJ4UNzC9xz/C/KNlbeSltAqOlP+Vr4WNKOa/0veP7zv18YXvOFJ2uCO
o9XhI+Nyup0W0i/40nriNjTIN0XeD9Suo3cdppYpfddRndrSfTxf4aBvrpf3
tJxL9EyW92gU/2q+Us3TalqFuX5vy9CgJ9NJP/L+D8i8GGA=
           "]],
          RowBox[{"-", "0.42000000000000004`"}]],
         Annotation[#, -0.42000000000000004`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz3EYx/GHtpULm03+Nsxps2m2IaccQuQCyXJDKSJcoK0YZiYh5Fiz
nOaQ1JJzM1xhCf9wJbvCuJBGTtls5ZS8dvH+f37f5/t5nu/zPfyHraxYVN4j
IjL9VCUi0sdGbKVHsyO20CNjIi6lR2QMiLhVGnEbnUUR2zIjftBquozvMN9F
vlsjIppwEx3m29Eg3oIbYtfxVewLzos9xzWxq9ig1mfxM2IH1PvbL6Jc7IPY
R/zIUxONJfrJjRg/OGICeul1Ep2IIfyd+RFdqMyJ2Ihz4kPFC7Bf3ePqH+sf
cYjuM+6yzm976D064hd9ZO4hauRtR721TqHS90m6PiNiVEFEEUbIyccXPeyx
Zqq8zUOcHapwjD+fLw/9+VLM59BsZDrrPphm7h3vb3v8g3v6nDEs4i6dTu/g
NtZat3KQte2pzDkMp1MGRiSyzFunGSnGhWrl8na5s5XG5WjzfZDWII2/nl6l
WWqcpnVydnZj3GHdvvaz2fk04aC7qcLEUXruGzGX5tMdwyM+6WvJSD0NjVhn
vBizUSw+mecfPaFWjlircU++BHL7RCSd13H7uIw0vhZ6H1P5X+rvG17rp0Ru
kqbJaZTT6AySKLSndtqKi3pu0dcHpOlnAN44gyJvpZ3OMi5FRrEz5pnHf4U2
41lhxFt0YKb7qXc3zd7EdrkttJbW8e/mbbSHRXxrUI3l5u/QCziCx+ZP8I3j
r6BnjRPiRZiOYvX3ql8rr0zdBrqK7uBfyr+J/5z3cBNJzDffU94336+w3/yN
7jvDAt/vvd8V9Kk9Vnf/X4wXurMsZ3PfvT43ftH9Psw/cJ5/fNd4J230knGJ
nKR+XqPA25uKJuec8Naf0NXGZUhV5zvPT3czhs7BbP0swS61a93BFDn/AWyr
rfE=
           "]],
          RowBox[{"-", "0.56`"}]],
         Annotation[#, -0.56, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{7536, 7535, 9478, 3818, 9653, 9477, 7920, 5748, 11953, 
           11955, 11954, 12348, 7513, 12344, 12345, 12343, 12347, 12346, 5720,
            6052, 12563, 6051, 8484, 4470, 10990, 4469, 12600, 9213, 9322, 
           9321, 12041, 5876, 12040, 5877, 12042, 3917, 8578, 4579, 11042, 
           4578, 8584, 4580, 5153, 12446, 4250, 7209, 4251, 5152, 12534, 5151,
            7944, 7943, 8515, 11015, 11014, 11016, 8516, 4545, 7468, 7489, 
           6749, 7448, 6728, 4209, 8994, 4187, 8355, 6649, 7189, 7169, 6230, 
           11763, 11783, 11703, 11743, 11723, 12208, 4230, 10387, 10367, 
           11395, 11375, 6318, 11435, 11455, 10467, 10487, 10507, 5194, 10447,
            10427, 10407, 5154, 11415, 6250, 11848, 5654, 11808, 5634, 11828, 
           5976, 10567, 10547, 10527, 5174, 11475, 6338, 11515, 5234, 10647, 
           10667, 10687, 5274, 10627, 10607, 10587, 5214, 11495, 6270, 11908, 
           5700, 11868, 5680, 11888, 5996, 10747, 10727, 10707, 5254, 6358, 
           3828, 5336, 12535, 5356, 4253, 7233, 5316, 7254, 5295, 7211, 3797, 
           9563, 9542, 11933, 5728, 8376, 10768, 9016, 5398, 11536, 5377, 
           9666, 9687, 6096, 12448, 4335, 7809, 4356, 12469, 6117, 6492, 
           12123, 12144, 9842, 9863, 3997, 7515, 7766}],
          RowBox[{"-", "0.56`"}]],
         Annotation[#, -0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3752, 3817, 4476, 3919, 6016, 5749, 12557, 5750, 6850, 
           6849, 6852, 6853, 5418, 4252, 7231, 7232, 5315, 7253, 5294, 7210, 
           3796, 9562, 9541, 11932, 5727, 8375, 10767, 9015, 5397, 11535, 
           5376, 9665, 9686, 6095, 12447, 4334, 7808, 4355, 12468, 6116, 6491,
            12122, 12143, 9841, 9862, 3996, 7514, 7765}],
          RowBox[{"-", "0.7000000000000001`"}]],
         Annotation[#, -0.7000000000000001, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{5622, 12621, 5623, 4455, 10975, 4454, 10976, 3726, 10974, 
           4453, 10971, 10973, 10972, 3725, 5841, 12559, 5842, 5838, 12013, 
           5840, 12011, 5839, 12012, 3723, 11975, 5785, 11974, 5786, 11976, 
           5783, 7574, 7933, 9226, 5784, 7575, 5907, 9494, 6089, 8102, 9767, 
           9768, 7571, 7572, 5782, 7930, 7931, 7932, 5917, 9375, 3824, 6314, 
           4693, 8153, 9784, 9785, 6720, 3963, 6926, 6927, 7625, 7604, 7614, 
           6915, 7974, 3868, 6900, 7009, 7021, 6885, 7050, 7035, 4613, 7065, 
           4779, 6417, 4762, 8082, 8064, 6528, 4593, 6162, 3701, 3762, 9610, 
           9591, 11061, 4880, 11080, 4899, 8830, 8681, 10327, 8234, 8810, 
           8790, 8770, 8491, 4920, 8701, 6294, 8728, 5083, 8193, 8213, 4124, 
           9413, 9109, 9129, 8453, 9170, 9149, 6202, 7128, 7149, 6618, 8748, 
           6597, 4101, 9392, 7344, 7365, 6694, 7408, 7387, 4518, 11218, 11238,
            10245, 10265, 4060, 11561, 4080, 10305, 10285, 11278, 11258, 4425,
            11178, 11198, 10185, 10205, 10225, 5951, 12185, 5566, 11644, 5586,
            11664, 4498, 11138, 5040, 10065, 10085, 10105, 5470, 10165, 10145,
            10125, 5060, 11158, 4402, 11118, 5020, 10005, 10025, 10045, 5931, 
           12165, 5520, 11599, 5540, 11619, 4478, 11098, 4980, 9885, 9905, 
           9925, 5450, 9985, 9965, 9945, 5000, 6574, 6554, 4940, 12515, 4960, 
           4040, 5497, 12397, 3662, 6673, 4797, 12495, 4817, 4020, 7104, 4858,
            7547, 4837, 7080, 5420, 12229, 12250, 10789, 10810, 4274, 7701, 
           4295, 10852, 10831, 12292, 12271, 6391, 12079, 12100, 9794, 9815, 
           3969, 7312, 7737}],
          RowBox[{"-", "0.7000000000000001`"}]],
         Annotation[#, -0.7000000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4385, 6519, 9584, 9512, 9511, 9510, 5559, 11638, 4444, 
           5606, 5605, 5755, 11958, 5754, 9106, 5608, 9104, 5607, 9105, 6638, 
           7852, 7851, 7850, 5613, 9188, 5758, 9214, 9192, 9193, 9189, 9191, 
           9190, 6641, 3718, 7859, 5806, 9712, 9713, 3854, 12044, 3853, 12003,
            12004, 12002, 12006, 12005, 5818, 9482, 6059, 12349, 6058, 12631, 
           9627, 9628, 12350, 12351, 8168, 8167, 3990, 7696, 3989, 9836, 9835,
            12121, 12120, 4627, 12008, 12009, 12007, 5819, 7592, 9782, 9781, 
           8150, 5918, 6719, 6718, 11054, 4694, 8631, 4695, 8632, 4626, 7626, 
           7627, 6911, 7985, 6899, 7008, 7020, 6884, 7049, 7034, 4612, 7064, 
           4778, 6416, 4761, 8081, 8063, 6527, 4592, 6161, 3700, 3761, 9609, 
           9590, 11060, 4879, 11079, 4898, 8829, 8680, 10326, 8233, 8809, 
           8789, 8769, 8490, 4919, 8700, 6293, 8727, 5082, 8192, 8212, 4123, 
           9412, 9108, 9128, 8452, 9169, 9148, 6201, 7127, 7148, 6617, 8747, 
           6596, 4100, 9391, 7343, 7364, 6693, 7407, 7386, 4517, 11217, 11237,
            10244, 10264, 4059, 11560, 4079, 10304, 10284, 11277, 11257, 4424,
            11177, 11197, 10184, 10204, 10224, 5950, 12184, 5565, 11643, 5585,
            11663, 4497, 11137, 5039, 10064, 10084, 10104, 5469, 10164, 10144,
            10124, 5059, 11157, 4401, 11117, 5019, 10004, 10024, 10044, 5930, 
           12164, 5519, 11598, 5539, 11618, 4477, 11097, 4979, 9884, 9904, 
           9924, 5449, 9984, 9964, 9944, 4999, 6573, 6553, 4939, 12514, 4959, 
           4039, 5496, 12396, 3661, 6672, 4796, 12494, 4816, 4019, 7103, 4857,
            7546, 4836, 7079, 5419, 12228, 12249, 10788, 10809, 4273, 7700, 
           4294, 10851, 10830, 12291, 12270, 6390, 12078, 12099, 9793, 9814, 
           3968, 7311, 7736}],
          RowBox[{"-", "0.8400000000000001`"}]],
         Annotation[#, -0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8808, 8232, 10325, 8679, 8828, 4897, 11078, 4878, 11059, 
           9589, 9608, 3760, 3699, 6160, 4591, 6526, 8062, 8080, 4760, 6415, 
           4777, 7063, 4611, 7033, 7048, 4759, 6898, 8179, 8180, 6912, 9839, 
           9838, 9837, 4793, 11057, 6431, 12317, 6021, 10874, 10875, 10876, 
           7593, 12361, 6075, 12360, 12363, 12362, 5104, 11303, 11304, 8848, 
           8847, 4319, 7724, 4318, 10878, 10877, 12380, 12379, 4745, 8565, 
           4573, 8564, 8567, 8566, 4143, 7699, 4142, 10324, 8231, 5974, 7849, 
           3694, 3758, 5079, 11297, 5080, 11299, 11300, 8767, 5101, 11298, 
           4120, 8190, 6713, 4537, 7406, 6692, 7363, 7342, 9390, 4099, 6595, 
           8746, 6616, 7147, 7126, 6200, 9147, 9168, 8451, 9127, 9107, 9411, 
           4122, 8211, 8191, 5081, 8726, 6292, 8699, 4918, 8489, 8768, 8788, 
           8808}],
          RowBox[{"-", "0.9800000000000001`"}]],
         Annotation[#, -0.9800000000000001, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->787421845]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20632],

Cell["Compose with inverse function:", "ExampleText",
 CellID->196753002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{
     RowBox[{"JacobiCD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiCD", "[", 
    RowBox[{
     RowBox[{"InverseJacobiCD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5296189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{
     RowBox[{"JacobiCD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317875594]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81233632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->450491657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390870124],

Cell[TextData[{
 "Differentiate",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiCD"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiCD", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->809586479],

Cell[BoxData[
 FractionBox[
  RowBox[{"JacobiSN", "[", 
   RowBox[{
    RowBox[{"InverseJacobiCD", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["z", "2"]}]]], "Output",
 ImageSize->{241, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84549320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiCD", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192074691],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"JacobiAmplitude", "[", 
        RowBox[{
         RowBox[{"InverseJacobiCD", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "m"}], 
      "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"InverseJacobiCD", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{481, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128084378]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20875427],

Cell[TextData[{
 "Obtain",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiCD"}]], "InlineFormula"],
 " from solving equations containing elliptic functions:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiCD", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiCD", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554970152],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->385927150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCD", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCD", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70562291]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22797],

Cell["\<\
Machine-precision input is insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->3979231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCD", "[", 
  RowBox[{
   RowBox[{"10.", "^", "5"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563558634],

Cell[BoxData[
 RowBox[{"InverseJacobiCD", "[", 
  RowBox[{"100000.`", ",", "2"}], "]"}]], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295388444]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->260060486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{
     RowBox[{"10", "^", "5"}], ",", "2"}], "]"}], ",", "50"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->289346646],

Cell[BoxData[
 RowBox[{"1.\
3110217060782478629804804814681645310524577933290961280047731123883`50.\
15051499783199", "+", 
  RowBox[{"0``50.03290511563697", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181049368]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9354],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiCN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiCN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiCS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiCS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12366],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->13406]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->78426820],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->93199334]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseJacobiCD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 55.9790920}", "context" -> "System`", 
    "keywords" -> {"inverse Jacobi", "inverse Jacobi elliptic function cd"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseJacobiCD[v, m] gives the inverse Jacobi elliptic function cd -1 \
(v \\[VerticalSeparator] m).", "synonyms" -> {"inverse Jacobi CD"}, "title" -> 
    "InverseJacobiCD", "type" -> "Symbol", "uri" -> "ref/InverseJacobiCD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6328, 222, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->17159630]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[647244, 11296, 192, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->715886131],
  Cell[649254, 11380, 238, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->322808586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 655784, 11617},
 {"XRef-2005-4-26-23-37-1.8558342", 655940, 11621}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2058, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2681, 79, 51, 1, 70, "ObjectName",
 CellID->988],
Cell[2735, 82, 779, 25, 70, "Usage",
 CellID->23586]
}, Open  ]],
Cell[CellGroupData[{
Cell[3551, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4029, 129, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4152, 135, 533, 21, 70, "Notes",
 CellID->32446],
Cell[4688, 158, 770, 26, 70, "Notes",
 CellID->25303923],
Cell[5461, 186, 114, 3, 70, "Notes",
 CellID->20947],
Cell[5578, 191, 260, 8, 70, "Notes",
 CellID->1284425],
Cell[5841, 201, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6076, 210, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6328, 222, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17159630],
Cell[CellGroupData[{
Cell[6712, 236, 147, 5, 70, "ExampleSection",
 CellID->51027777],
Cell[6862, 243, 64, 1, 70, "ExampleText",
 CellID->156488630],
Cell[CellGroupData[{
Cell[6951, 248, 137, 4, 28, "Input",
 CellID->25804197],
Cell[7091, 254, 176, 5, 36, "Output",
 CellID->392896191]
}, Open  ]],
Cell[CellGroupData[{
Cell[7304, 264, 128, 4, 28, "Input",
 CellID->75588654],
Cell[7435, 270, 176, 5, 36, "Output",
 CellID->353590317]
}, Open  ]],
Cell[7626, 278, 125, 3, 70, "ExampleDelimiter",
 CellID->306083438],
Cell[CellGroupData[{
Cell[7776, 285, 297, 10, 28, "Input",
 CellID->592668477],
Cell[8076, 297, 2391, 43, 144, "Output",
 Evaluatable->False,
 CellID->10963214]
}, Open  ]],
Cell[10482, 343, 125, 3, 70, "ExampleDelimiter",
 CellID->280795932],
Cell[10610, 348, 61, 1, 70, "ExampleText",
 CellID->511351488],
Cell[CellGroupData[{
Cell[10696, 353, 252, 8, 70, "Input",
 CellID->493847220],
Cell[10951, 363, 1070, 34, 51, "Output",
 CellID->266489420]
}, Open  ]],
Cell[CellGroupData[{
Cell[12058, 402, 252, 8, 70, "Input",
 CellID->183899751],
Cell[12313, 412, 843, 27, 52, "Output",
 CellID->11910797]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13205, 445, 216, 7, 70, "ExampleSection",
 CellID->19903],
Cell[13424, 454, 73, 1, 70, "ExampleText",
 CellID->55645938],
Cell[CellGroupData[{
Cell[13522, 459, 208, 7, 70, "Input",
 CellID->266251706],
Cell[13733, 468, 273, 7, 36, "Output",
 CellID->113815709]
}, Open  ]],
Cell[14021, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->268824359],
Cell[14149, 483, 70, 1, 70, "ExampleText",
 CellID->132691703],
Cell[CellGroupData[{
Cell[14244, 488, 241, 8, 70, "Input",
 CellID->866802414],
Cell[14488, 498, 235, 7, 36, "Output",
 CellID->227359645]
}, Open  ]],
Cell[14738, 508, 124, 3, 70, "ExampleDelimiter",
 CellID->36479535],
Cell[14865, 513, 113, 3, 70, "ExampleText",
 CellID->579439215],
Cell[CellGroupData[{
Cell[15003, 520, 194, 6, 70, "Input",
 CellID->632752147],
Cell[15200, 528, 227, 6, 36, "Output",
 CellID->267952482]
}, Open  ]],
Cell[15442, 537, 125, 3, 70, "ExampleDelimiter",
 CellID->688497564],
Cell[15570, 542, 231, 7, 70, "ExampleText",
 CellID->43876107],
Cell[CellGroupData[{
Cell[15826, 553, 185, 6, 70, "Input",
 CellID->271543877],
Cell[16014, 561, 341, 11, 36, "Output",
 CellID->38191930]
}, Open  ]],
Cell[16370, 575, 125, 3, 70, "ExampleDelimiter",
 CellID->255377976],
Cell[16498, 580, 92, 1, 70, "ExampleText",
 CellID->328717422],
Cell[CellGroupData[{
Cell[16615, 585, 134, 4, 70, "Input",
 CellID->617758456],
Cell[16752, 591, 190, 6, 36, "Output",
 CellID->153832064]
}, Open  ]],
Cell[CellGroupData[{
Cell[16979, 602, 251, 8, 70, "Input",
 CellID->658205930],
Cell[17233, 612, 241, 8, 36, "Output",
 CellID->134200579]
}, Open  ]],
Cell[17489, 623, 124, 3, 70, "ExampleDelimiter",
 CellID->23210608],
Cell[17616, 628, 203, 7, 70, "ExampleText",
 CellID->471035179],
Cell[CellGroupData[{
Cell[17844, 639, 173, 5, 70, "Input",
 CellID->179888293],
Cell[18020, 646, 322, 11, 52, "Output",
 CellID->81717893]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18391, 663, 239, 7, 70, "ExampleSection",
 CellID->29214],
Cell[18633, 672, 225, 7, 70, "ExampleText",
 CellID->120235099],
Cell[CellGroupData[{
Cell[18883, 683, 248, 9, 70, "Input",
 CellID->77454719],
Cell[19134, 694, 1343, 41, 54, "Output",
 CellID->46196308]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20526, 741, 223, 7, 70, "ExampleSection",
 CellID->14269],
Cell[20752, 750, 123, 3, 70, "ExampleText",
 CellID->147991225],
Cell[CellGroupData[{
Cell[20900, 757, 716, 23, 70, "Input",
 CellID->41283476],
Cell[21619, 782, 623779, 10433, 70, "Output",
 CellID->787421845]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[645447, 11221, 233, 7, 70, "ExampleSection",
 CellID->20632],
Cell[645683, 11230, 73, 1, 70, "ExampleText",
 CellID->196753002],
Cell[CellGroupData[{
Cell[645781, 11235, 379, 12, 70, "Input",
 CellID->5296189],
Cell[646163, 11249, 340, 12, 36, "Output",
 CellID->317875594]
}, Open  ]],
Cell[646518, 11264, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[646789, 11276, 106, 3, 70, "Input",
 CellID->81233632],
Cell[646898, 11281, 203, 7, 36, "Output",
 CellID->450491657]
}, Open  ]],
Cell[647116, 11291, 125, 3, 70, "ExampleDelimiter",
 CellID->390870124],
Cell[647244, 11296, 192, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],
Cell[CellGroupData[{
Cell[647461, 11307, 225, 8, 70, "Input",
 CellID->809586479],
Cell[647689, 11317, 374, 13, 52, "Output",
 CellID->84549320]
}, Open  ]],
Cell[CellGroupData[{
Cell[648100, 11335, 225, 8, 70, "Input",
 CellID->192074691],
Cell[648328, 11345, 784, 27, 70, "Output",
 CellID->128084378]
}, Open  ]],
Cell[649127, 11375, 124, 3, 70, "ExampleDelimiter",
 CellID->20875427],
Cell[649254, 11380, 238, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],
Cell[CellGroupData[{
Cell[649517, 11391, 359, 13, 70, "Input",
 CellID->554970152],
Cell[649879, 11406, 453, 8, 70, "Message",
 CellID->385927150],
Cell[650335, 11416, 660, 24, 43, "Output",
 CellID->70562291]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[651044, 11446, 226, 7, 70, "ExampleSection",
 CellID->22797],
Cell[651273, 11455, 113, 3, 70, "ExampleText",
 CellID->3979231],
Cell[CellGroupData[{
Cell[651411, 11462, 160, 5, 70, "Input",
 CellID->563558634],
Cell[651574, 11469, 230, 7, 36, "Output",
 CellID->295388444]
}, Open  ]],
Cell[651819, 11479, 83, 1, 70, "ExampleText",
 CellID->260060486],
Cell[CellGroupData[{
Cell[651927, 11484, 218, 8, 70, "Input",
 CellID->289346646],
Cell[652148, 11494, 325, 9, 36, "Output",
 CellID->181049368]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[652534, 11510, 310, 9, 70, "SeeAlsoSection",
 CellID->9354],
Cell[652847, 11521, 724, 26, 70, "SeeAlso",
 CellID->14224]
}, Open  ]],
Cell[CellGroupData[{
Cell[653608, 11552, 314, 9, 70, "TutorialsSection",
 CellID->12366],
Cell[653925, 11563, 192, 4, 70, "Tutorials",
 CellID->13406]
}, Open  ]],
Cell[CellGroupData[{
Cell[654154, 11572, 318, 9, 70, "MoreAboutSection",
 CellID->78426820],
Cell[654475, 11583, 146, 3, 70, "MoreAbout",
 CellID->93199334]
}, Open  ]],
Cell[654636, 11589, 27, 0, 70, "History"],
Cell[654666, 11591, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

