(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    650232,      11654]
NotebookOptionsPosition[    641554,      11358]
NotebookOutlinePosition[    643277,      11404]
CellTagsIndexPosition[    643137,      11398]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobiNS" :> Documentation`HelpLookup["paclet:ref/JacobiNS"], 
          "InverseJacobiNC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiNC"], 
          "InverseJacobiND" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiND"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobiNS\"\>", 
       2->"\<\"InverseJacobiNC\"\>", 
       3->"\<\"InverseJacobiND\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseJacobiNS", "ObjectName",
 CellID->20394],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseJacobiNS",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseJacobiNS"], "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["ns", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29909]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["ns", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{"ns", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->19755],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiNS"]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[PlusMinus]", "1"}], ",", 
    RowBox[{
     RowBox[{"\[PlusMinus]", "1"}], "/", 
     SqrtBox["m"]}]}], TraditionalForm]], "InlineMath"],
 "and infinity, and in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", 
    RowBox[{"-", "2"}]], TraditionalForm]], "InlineMath"],
 " and infinity."
}], "Notes",
 CellID->539143431],

Cell["\<\
The inverse Jacobi elliptic functions are related to elliptic integrals. \
\>", "Notes",
 CellID->30293],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseJacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiNS"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->168171127],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiNS"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiNS"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126293866],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->352178110],

Cell["Evaluate numerically:", "ExampleText",
 CellID->417418768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiNS", "[", 
  RowBox[{"1.4", ",", "0.7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43059757],

Cell[BoxData["0.8585343674080562`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->569683017]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{"%", ",", "0.7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->438828716],

Cell[BoxData["1.4`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266178292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118591952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "4"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128214967],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->714605162]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5952488],

Cell["Series expansion:", "ExampleText",
 CellID->159088426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69272691],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcSin", "[", 
    FractionBox["1", "z"], "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["z", "2"]}], 
          SuperscriptBox["z", "2"]]], 
        RowBox[{"4", " ", "z"}]]}], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"ArcSin", "[", 
        FractionBox["1", "z"], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcSin[$CellContext`z^(-1)], 
    Rational[-1, 
       4] $CellContext`z^(-1) ($CellContext`z^(-2) (-1 + $CellContext`z^2))^
      Rational[1, 2] + Rational[1, 4] ArcSin[$CellContext`z^(-1)]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{310, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129126105]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19903],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->55645938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiNS", "[", 
  RowBox[{
   RowBox[{"0.2", "+", "I"}], ",", 
   RowBox[{"0.1", "-", 
    RowBox[{"0.3", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266251706],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.9489492730020621`"}], "+", 
  RowBox[{"3.2212744160099454`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113839517]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268824359],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->132691703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->866802414],

Cell[BoxData["0.\
3431160258826046578836458897973819299193820462814670133868631962184`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285866290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36479535],

Cell["\<\
The precision of the input tracks the precision of the output:\
\>", "ExampleText",
 CellID->579439215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiNS", "[", 
  RowBox[{"3", ",", "0.50000000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->632752147],

Cell[BoxData["0.34311602588260465788364588979738192991938108686`30.\
847897707634033"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139517369]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->688497564],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiNS"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->43876107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiNS", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271543877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403618187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255377976],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->328717422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617758456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCsc", "[", "z", "]"}], ",", 
   RowBox[{"ArcCoth", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->919579416]
}, Open  ]],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->368884824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiNS", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->508781695],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"InverseJacobiNS", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42351009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23210608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->471035179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseJacobiNS", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179888293],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["ns", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{59, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->278833701]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiNS"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->120235099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiNS", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "m"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "m", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77454719],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcSin", "[", 
    FractionBox["1", "x"], "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "2"]}], 
          SuperscriptBox["x", "2"]]], 
        RowBox[{"4", " ", "x"}]]}], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"ArcSin", "[", 
        FractionBox["1", "x"], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcSin[$CellContext`x^(-1)], 
    Rational[-1, 
       4] $CellContext`x^(-1) ($CellContext`x^(-2) (-1 + $CellContext`x^2))^
      Rational[1, 2] + Rational[1, 4] ArcSin[$CellContext`x^(-1)]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{310, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235791452]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14269],

Cell["\<\
Plot contours of constant real and imaginary parts in the complex plane:\
\>", "ExampleText",
 CellID->147991225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"InverseJacobiNS", "[", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ",", 
        RowBox[{"1", "+", "I"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "24"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41283476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEvXd8VcXz/5+EJGBXmiJKE5EqggqC6F5AUBCwACJFESnSQYpKk44goID0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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{5268, 6297, 1016}, {4536, 6250, 299}, {4960, 7400, 
           783}, {6091, 8681, 233}, {7616, 7621, 2585}, {7666, 5327, 2603}, {
           2589, 2604, 559}, {6307, 5268, 1016}, {8683, 7616, 2585}, {8316, 
           7403, 1048}, {1056, 784, 559}, {7286, 6307, 1016}, {8125, 7666, 
           2603}, {4506, 6091, 233}, {7691, 7692, 2613}, {5333, 6066, 1056}, {
           2604, 2613, 1056}, {6293, 4536, 299}, {7124, 7503, 2246}, {2444, 
           2772, 783}, {4637, 7204, 2246}, {2590, 1016, 299}, {7401, 7402, 
           2444}, {7627, 5265, 2591}, {8320, 8318, 3135}, {6067, 8316, 
           1048}, {2442, 2444, 783}, {6685, 7286, 1016}, {2585, 784, 233}, {
           2770, 1048, 783}, {7912, 7914, 2770}, {2591, 2589, 559}, {7690, 
           5333, 1056}, {784, 1048, 233}, {6976, 4962, 784}, {2604, 1056, 
           559}, {8105, 8103, 2966}, {7913, 4506, 233}, {4961, 6976, 784}, {
           1048, 2770, 233}, {784, 2585, 559}, {3135, 2591, 559}, {2589, 2590,
            299}, {2603, 2589, 299}, {7204, 7124, 2246}, {8449, 7399, 2442}, {
           7511, 7123, 2246}, {6250, 4535, 299}, {7400, 4959, 783}, {2772, 
           2770, 783}, {2590, 2592, 1016}, {8103, 8104, 2966}, {7629, 7631, 
           2592}},
           VertexColors->None], 
          PolygonBox[{{7624, 5263, 2590, 2589}, {4535, 8125, 2603, 299}, {
           7619, 8320, 3135, 559}, {8318, 7627, 2591, 3135}, {5263, 7629, 
           2592, 2590}, {4959, 8449, 2442, 783}, {7503, 8105, 2966, 2246}, {
           8104, 7511, 2246, 2966}, {4962, 6067, 1048, 784}, {7626, 5328, 
           2604, 2589}, {6066, 4961, 784, 1056}, {5328, 7691, 2613, 2604}, {
           5327, 7626, 2589, 2603}, {8681, 8683, 2585, 233}, {5698, 7912, 
           2770, 2772}, {6297, 6293, 299, 1016}, {7403, 4960, 783, 1048}, {
           7692, 7690, 1056, 2613}, {7914, 7913, 233, 2770}, {7399, 4637, 
           2246, 2442}, {5265, 7624, 2589, 2591}, {4665, 7401, 2444, 2442}, {
           7123, 4665, 2442, 2246}, {7621, 7619, 559, 2585}, {7631, 6685, 
           1016, 2592}, {7402, 5698, 2772, 2444}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3341037361397354, 0.12814938481345342`, 0.5866035352622954], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtU7tOVFEUXcNjgJmLjxkZJnDvTIarqI0xaiEiIdH4aFBig9HCkQ9gDBWF
hZ0mxsavQBOmwIKHoTChshEzX8BAIlx+ADvXcp3i5J6zz95rr7XOvo3F1rOl
HgALXL1ctwrA3Qi4wuC3UWCxDNQGgL+DwCnXeg74OAS0+r3frwE3Kz53mTuf
AAdDjl0ed/xRCjzgungG+D4G3OfdO8anmDfaB1zrcY954q8pXgI6rO3kXK9+
V5kz1QCeE/+I5+ZZIM07fkQO9wJmkfu9C8adY+4Tri7z7xBze8yYx8zJuDrU
2qoCP0bIlbWvyX+dmhNyWWDdat29blSsU1w2GNusu/dv+rQX2Rdx/BR4Nolz
EvssL7OC/dxmn8MJ1vY7Nh18FvcsNv8t3rfZq819gd+o5jf5ST6/gq7pgKkc
4W2NGFMeyj9xeJFYs/TK791x469Q3236WM7Zy5fBzxxjr8h7N7K3s+esUfzV
X281lze+OO/Qg43z9KjofMXF4QvjT4Pnw8RcLtunLMyVcDQjX+ueE+XpKz7C
EJb46w2lWXrF5f97836SPl2KPY/yQZzE5zgOc0OcJt/0fclzpXvlyauZYWtR
vnhoL/wPJdcof5WarlfNJyVmseH3VZ5mRDnypRV8Fn47aNfcqIfwNetZ8E1z
nYS3yVP349R3K1X3FqZ81wzpn9LczETG11fvqr3m9G3VPBLW/Ymdr3ns1sxL
PcRJfDYnwjxx/zD1fyhe8uZz7L7SqpmQ3jcV1yh/LeiRln/bAYPP
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtU89vjFEUPRXTXzMVfK2ZTOd9YzKjdhZioYtGEyE2fsRGwgJdkhixwKKh
1iIoI1FLEsOii1rQCiEtIS1TGf6BWpjOWFmxc07Ot7iZ+705597z7j2vNFE9
fmEDgHHGRsaN7cB1xjXGFON0BLQKwM0+YCkDNAaBPwHYmQKyJBwoA91FoN0P
VDYB94g9WHY+Ss4h5he3AbMpY36XgPfkv2N0mHeIn2SfMda+pR7DPIuBJrFT
5Czkgdd5580uIEPOYXLXiF0l5wf19BO/h/ixAeAttVRz1ldPA1dY/wm/HzMu
M68RP8P8IeM+8/0V4CU55W5g32ZgJUud7LHOWGb+nXoq5P3tdb8mv0+wf6vP
etLEDTC+ZYzR3T4yPiR3bJO7XjBWd3i0xT1Ue4b5BOc7zprHyI17gF/EdpU8
6zly1ni33ZxfNWWN0hK2+j/1i/O+o+4W8p7li6xraabPebc6+0TE/6Tm6YJ3
pN3s4uInOYerOeea2RHNNjJWM66T/7Rovu68GtxTvRryAbWPDFuPNLaptxUn
++JOloI9JS8tBnvpTORdy1Py2grPl4M994Ba5qn3FaOWc+9nRWuRBu1OmFqy
Q3Gnuce7g64hLSPs8a/Xmo4G71C7U41ZalsY4ixT9qR2JY2Lyc7kFXlE3pBn
7vD3K8+/MG4nuWbQSM7U+zN/PwVr2MHe5cQv0pBhv3TstyKPzg/Zc/KaNIir
HqqtGnNZe1peDj2exXnqOJfzTPbSG6Ml70LzuBT5Teh+8uAp1jgZ7Ddh5K2z
kWvJY3q7b4p+G9q3vK432Uk8/x8gK6Wl
           "],
           VertexColors->None], 
          PolygonBox[{{6251, 8126, 2984, 4535, 6250}, {7915, 4507, 4506, 7913,
            2771}},
           VertexColors->None]}]}, 
       {RGBColor[0.3667534690846834, 0.18491845285452146`, 0.632496684652879],
         EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtIlGEUvTVqzowzaeYDnYfjPIzMFllQGRn0IIIi3VQmCVEuR9FVFoQF
QZQRilSEE70gJVq46KHQoiQwe2wycadSi8yEFtauOqfzufiYf757v3vPPefe
GzvZ1pheaWY3cTw4/T6z5lVmxdlmw0VmdyP6boiaHcbZ4jfbjFOLk4Z/Du72
xs0ew2d7jtkU3rfg/mip2a4C+TSEze4hzhev2dNcs0n4LGSZzeJ/CrliSPwD
9uoCvT1XaPYKb2pgGysxe10iv9FKsyPFZgPIFUSc7mzF+ZhnNuNVHOKKB5W3
Enj8+L6YLSx5ZbqPAG80LttgQG8mEcdbYearkD/jzbqYHp/+E9tf5PqJuLdw
X40Yp9aYHchRnKqgeLgG7HUJvSPufo/ifMD99bVmv/Hdg3qv4lzwCSdzrlth
9hW1V4UUnzZywBpTuEuVm9Wj7iTypHDqgOk26voeEa/kpTJbtZCfX35xNIeY
h8LCsQDfxYh0on3eK5894PVKRN/MyXjMuw819oWUax78fcNJ5CrnWLn8HgHD
EPrgBuI9wP39iPqIeMgNMRFzY760acjX9zDuW4PSodL58Zc8jANvr+PqDPR/
HhLv1IF9Ri06cfcJPtEscf3H9UFezKyjUJxTn6m4cBwMy8b7NsRMlin+JfT5
+pDqJc640/Eh6/ELD337HJ7lGthLb33yow+1JW76tMTUB8T1DNzsTijWCHq4
C/k+I9coYo6USas/wHksrBo5J5w56nUH74cC0pR9yj4jNmqwzBntg84ngLz+
mGYi45Od2NpXqzbq2I0eH0Oucth3eGXjPe38pi7Lc84ayXF7iXhmDe8Dis09
Qc2Jtdb5sy4/4ifQGztzNdOX3VxP+9R3afg3hrUXWCvtJ2LymYB93PkwXlNQ
MTkfvP/fGz7xzm9iYh1LHmnclaua6c/8jMPeIb/klvgz7i37YrFY7zrx21yq
2jkDnAvOIOd31i8teshDSLk4i1VuHtkPrJ+6cLcF3exsQ01bY9oZnNek6yv2
KPVhHxMLNaZ25JXfGccT7WnHLTmgzwLizeNsCCj3hONqE/DPRcQLuU86/kfQ
a08iikvN3zjdySE54ltylnC88WQcHs4Td+DyzNU7PrkPet1O4J6bKVSfE+OA
2z/MPe2wNSHn8bA45Ry8KJIO3AENbiewHu4dcsseZF9Si7NFmhnGPl0qnXj/
DvHOV0j/jSHtL+rG3Vnj9idranW7pR32/XHt6Jf0jau3ytEXS1FpTDzUiPHj
iJEMqW5q3uF0/wcsUvTA
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtI1VEQxocsy/tXKU296L3/681UqIzoQWVRi7Ii6OVGK+kFtSlSbNG1
B2FBD8oWkkpJRGVQES1clBoUmQS9qBYV7VJskajQotpVv49xMTDnnDlzvvnm
m5PcV199eJKZ1WCTsW+5ZkuTZn8zzdIiZsfyzJ7MMrs+xewzAVsSZk/zzXZk
my0OzEpjZmXY6mlmlelmF3LM9kbN9mDn8SuxHXGzkQyz38Qv4u5gaPaK3G+w
fs5aZpr9SjOrmGr2nPUo78/L8r3trL+D6Sr+T/KfKjZrxoq4mwDPJXKdyPW7
p9n7jN9U4LF17N3ivJsa8sE/DIamqGMUthT+QJHZGjB94u4jalg726yW/cNw
sW262QL8uzPMOgLPtwtsu5POzW5iasG3nPW/TMfYwNv12J80x3eR98/y/ih+
MxhGiH1b4HhVYyN4s9h7z/0kd26HXoPeauON9SVm67AVYC+D81a4Pgf2lRm+
Vxd1zMLaPcW5XUg9ryPO8SC5BnivjHyDxF/h/v6oxypHO9x3sr6GtakP9LeY
mDawDFLzMrClJvhUjXeifkexXfi9aKMHu0ct97GP8JEoNAuxD/gv495T9VI9
GwPbCGez4foY1g83J8lzAnue529Xx71XwjBM7j72b3D3Hfk7iOujH71YO355
kWtKWpIGL8NViAVwdQC7CR9doXMpDQTUUxJzrYpzYU2xPhpzzKqlgXzl2V5T
Df5c8m1M9xnYGfeeq9fSdAQtBtgq3j7DeVWJ90y9esC6r9BnQNrPnuZcq4b2
Cc5VuzSZmuCgERxHYq4dcZYgV0ax51ZNpdRbBaavEX8zk/zb6NmSwDU7nu8c
i1thHqL2Hs7vBK4Jaa9zhmtdGtxA/vSEY1XN6rU0L/2p5w1R75F6Ux/1WXlS
6LVoZrYm/E/QXyAMh4h5pj8CO4j/MHSNSBvqof4WaVJa1B/zgveKclxr0ugc
am8JfZY1MxWs58d8dsT5ZrjfFPdZkT624g/luq/+qtbHWFfgNffmuYakHe3d
T/gdxWqmx3lrLPRZ/hJxbakGYZfGVIs4UO2qSdyPhh6rHjTD3/E8/xv1J/4o
dA1Ke9K4tKWZ0axIY63Mzdu491d/xH9j0M33
           "],
           VertexColors->None], 
          PolygonBox[{{5267, 7633, 7632, 7630, 1015}, {6241, 7316, 2364, 4743,
            6240}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.39940320202963153`, 0.2416875208955896, 0.6783898340434628], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lktsVXUQxgehj3vbe1v6uDe5vT1tvWJbirIgxhjfJiYYTdqQ+NpofMCG
RoxSE5TYYKpBBTaw1CbabgwShEKNgWAiJKaJIm1IZeGitdfWIrBrEEsTvx8z
XZycc/5n/t/MfPPN/E/H67u2vXWXmf2ia62uj5vNPk3MFteZjbebndY1UGs2
UW22tdKso8Lses7shq5n9H47qz31Zsu6f5sxO6rLBJiLd55fS5s1VAlfzw83
mk21+ntn2O/Qem/B7OR6s+41ZrcUyN+Vbr9X/hL5ntT6zRqzuTqze/W8knXf
xPBqh9krutLCGtb7R9ozor0P5M2+kb9+4U0rhhXhjK3xfcRLPuBxB/M95flS
yuya7IZr3XdZOLPCeFD4R4Szs8K5OS77c+Kgt03xaq1P+LcDf6je8yK/55Xr
nPbPC7csX/8qh05hLst2X9rtNxXNeoq+f0HcPy7cS/o2IX+7az2Xx7TWWjJ7
SjY/af2HSo/tfu27r+i5leXnBflbkK+DTbLTc0E4PS2+n71l5XFZV1fG46R2
1OhixAv/3LvieY84nBbufvn8R7mua9C7cjil+0yH1+4hxdIvDpoqnFdwwfhO
Wpq529dbZH8+77wdDd/4nVSMhxXr2SrHAAubg+JhY9F5apTt5jrn/0vlsz3r
ekzEx6GS84lG3si6TkzxvZl1vxvuMXs057U8rL2DFZ4LXPA8Jftf9f1AyfcQ
74lm3wvvaOl32Swq9hPrXSdXlPdYaLVF+57IORb1QH/s+y3jnGJzVngLwr2k
9ydzvgd7vrNGT1EHdHmHE33PFF2HaBNOsVntt61xXwn7lHq0reTagj80Codg
DkVvwh88oh1ip9+IbVQ8f5U4N9S1LuO6ox7nqrwXZxX7ULPjrvYMnO+MesEV
NRmp8boQB1pf7ddy2N+q8W/wiS/80Jvo4VjMAfx8ljg2eiBuakrt+yMv6ssz
67tUl7fzPi/KMS9YfyTntef9A2HuK7mPou55aXEy7e/0Ln7pp+HAGBf3Q+qZ
0ehT+mnzWp+DzAVsiAsu8TUQa9Sdun0ftWM29MV8OCMO32/2mUg/jSSuQ+bT
1TbnATxwwISzueBwt/AGdHWnnH84RofXhPF0zjXaVvBeom4Z2S3VuLbHpI1T
7T5HepXzn1r/T/u36Lkr5TP2uOKaLXgPURPyoEbkwDwkTvDoGTC/UL9+WHRt
9IjPF3M+7+lNYkOr28XxHtls1P53dX+n6P6KsukMPpl/0zED2/V9STwsVXtO
G1o8r9G8nxmcF+if/NESXHCuEH9D6JTnrphj1BTdd0Z/kXtf+GK2whFzfK+w
DyQez6aU8wfWMa1dznlONeIv3e76ZXb+EfOT/kB32NcWvW/h7Eftyxe87uTa
HTxva408q31uLRY8F3jpDBvqjRbgn/MMXaILzuT5OJcHY5ZRi09Uu88T55K6
LqZct2j5Sto5xPZI2P+sGA41eR3oIXqJ/qXOnH+joW2+0XP0CTmhAfpmquRr
9QXPkxyJl7jR5F/i8+VWj4N5DD56vq4YbyQe07O6P5d4TQbFx44G5/606j/e
5nMEzIngYV69c6bZZyo8caZRr5Na+zrx3K4W/L8EjTQW/HxCAxfyfn6TC9rv
DQ3AIXnsj3+NLaEl5h+9gm/qhE7gDd55Z/7c6a9qX+Nch3d4Q/sjwQNz7mbM
OvxyPmPHnfexOGcvhj75v5iJOPkPWI5/if8B/Bxukg==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtslWUQhodboac9Xs7puaT9e9rTorQUdWFMTNRYDC6MJkoTFRIvAW03
ohRajCCWYNQIWjZUayKSaIsbNUgVRErQFBM3XrAhgIkLiNBaRHYNVsX4vL5d
TDL/98038847l7+8dn3Hc3MjogeZj6ysj+hAphdFjM+JeLM54tNcRM2CiKev
ifgiQRojnq+OuITNEr4vZCOmKiP+4ruN71bkb/R/kFJDxPd5v42qiF+xbUls
O1Fp2/OcTVb6zRZiHWmK+Cgd8TFyU+IYsr+KbETv1hn2LcgT5Ygd10d8WRGR
ShvbIe6H5xrjiL6RTehDnK0tRrzF/QCyBv0y2E6T41Xw3YeP44WIb5CBeRH7
yb8rE5HURhxdGLGMeO/wZpR4R5BB9Lt4vx/MJbBthaMtnO3kzQ5kM3ov+D4j
fi/xrwXfByVzLG4HUvDLd3/Jud9CzCliXaw1liXgvaEuYjFyGvuXVQP8toE3
Lz65X0H8mxNzcwp/G4h5HDxjSDf6C9w1zOJfCv7dNfjk+9hCn/Xj6yA1GqI2
nfgcA9vWrLHU4q+v6JyUy0vIJLU5jO8yWE6QzyHeTsHXjXPsY4hchpHdvH19
nrl6lnfriubsIva/I6ewXcf9as6Xc96OrEK/d7HPpK9Ab+P8D/ydwd/eCnNR
BZ8zVebkAniO5ozlh7RrKY7EjWo6wdtJ5ATvp2jwTfBRhf0avlvh4+sGcyau
vkK/g5i74GAMbNnrXEv1jHpFNVWvCZOwqOfEdd8sN/9zjv/+GnOnHl2Nr38z
7kfNSC/1ehzbx5CevGuxHv5+q3BNbkf/ljdJyjX4ELtB/L2N7Cu6FzszrqXq
J+7SnFXXmsPL5Hqp5F4RZ2+U3CPqje0p1+4Tzt5LuYaatRd1lvbMPVJvDIqt
mdSsdBG3s+iZaUcWwf80/Ke578b2JNhuTTkH5XoYm1WVznkDem9irsWHctmD
r3eLzmkEzBNg+JHYrdTzFer7cL13g95rV9wP3gdT3gEF8swiXdzNgP/uvDEJ
i2rch74t8azOkMNO3r6ac+2fWeDaPln2rlCNT+Y9A+p9cTLO/Z4av83A764a
5yDsqol6Z7jgO/XQ2ax7Rr2indGAr1KzZ/dPOPou7x2o3fcUMbZzdyxv7OJ8
nO/qxLv0p5R7QzOg3lePtGObNPtuG2/q0Zfnrd/Dm0fRR5u8K7UTRnOeCc2C
OFUtNhc8i6rJFfJZlng3P5Ry73SAb2WDe+hcrTELq3aaaqWdNzhbswP4P9dk
LvVPeB9+R3LeZZr5zxu9c7VrtfOWEuu1nHtPO+6BkjEotmqq3ulJvMvVQ9oV
mknNonbGL9TqTNm90UI+B+iX2wreHdo5KWJVNppr7YSz2J4v21Y9ol5tqzNX
6tmf+b4z7129F3wHG30mXf8I9bpmVLOpnp8GR13G/wL9E+dnvNO1y7XD/gPF
rhBm
           "],
           VertexColors->None], 
          PolygonBox[{{7289, 6310, 6309, 7288, 2346}, {8018, 6672, 1529, 8016,
            8017}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.43205293497457964`, 0.29845658893665766`, 0.7242829834340464], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1ls1VUQxg+00Pa2vYXebra3t70UEigU9cHlASO+6EONUSmYkFiqCRJp
64omPkiJCxREoyYCD0UxIdGXhq20qLibaKW4EDDBJ43UrSSYkLhEo34/vjE+
nNxz5j9nzjcz38w5t3j3/bffNzul1DYrpRL9LqxI6c65Ke2ek1KxOaXfcyk9
WuY18rVSfkyyv/Ip7ZNuQ1VK/ZIPam/fvJRu0bxztufrNIpaH6tP6YcF/tY7
L/R13lLt31WaUqn0t7ektLXJ60F9X6jzNkv+heRfarQL3BKduVRjj+a3Su9X
/Q5JZ2tlSmPlKU0LQ6bcPoD38TmWs5czBwJn5/yUhjV6Nf+tNaUV8y0/lrU+
+7CDjWmdM1mdUrP2zhfm7+XHYekv0rcHc8aH/XM54wNbZ4dwtqc0T7G5XL9X
aDRWWbYs5Oeks1t7VpUErrn2F78HI4aDgZn5ee05oXmX9KcaUvq22Zh2a71D
WPuE/42sfdgsG+U6Z2Xe89GCc0D879eZFyV/STF6VeOVCucCG9vDzgXZ2FXh
9QHtu07n5eYYd02VObBacXuqxfs+qbb8R8XqJskfyHn/QvHme8nOyeYQWPLO
eYt0mjQ+qDCWnlbjIdbEnDjfVZvSNbL/t+ZXZpzrTs1fl/5rGt3SX6UYvF3v
XPRK/2rp/yWdd5Wjd8hTtQe5BAdjOvDktfeeWnMPzoFrRvOd4uCGkOPbHRGH
EzWOFZxhDV5ihWxfyMeFa6Lde+Bnd9hcLPl3OefqYcXpIY2RWY4peC7xqtQ4
WVMHK+uN62PF5trGlE4qd9tKHNe90l/c6JpB52vh7W12LaC7ptX68GWFctBT
4lqk9piXZc1xeDtSl9Ip6RcV47w4uVK5rsg63sQdm9TE5oz1L0r3T42ujDlN
/a+Xzn6dW1lvv4kl9vD9Ccm2FuzfVDGlg7XW/03n3iz5ilLXDL8bJH9a+jsk
36L9Z6T7T6vrgjrgTOp0POvv8C0j/buk36f1Ueo3a16RF2oFbi/L+zzOYC96
QxnH+PnoOaPK7+cZy5+UfLhgn/Hpkbz92iPdkSb3w02SPZh3nPYrt5cJ54c6
86TiV2hzbeaiN8LhG/X9TM45PKW8nY45HOmLWK2Tv82t5nBJwbHG54msbdPf
JgI7Pk4Fl0al/6xyd7rB/fZ0pWXDs4wPLlA7e4X9qxbjh6cTeXP1XrAUXK8z
wv6zxplK9wv6UWf0pUXRk8e193C7uUytvNzkeiG3s5ud35/Eh/E28+9SLKKu
BxTn/hqvV8m/bxpdR9wzRwrGtly2uzTqZP8HuFNwbtbXum45C951VPus48rR
9AJj7JF/Wzrco/5QPFa3xH2mONRlzDH41pBxTDhzb+SU7/Whs7Taa7DtEHeO
t/pbU8Z70eG3Mew8I513Wr2mD4OXfNGDr29wH76tyvvZC3eeq3N+zuv7rrgL
Zmrcl+EtcdpY454Ad/GBveBiDjbq/myt63SSOyL4QB3Qk+ESfJgM+aDOqVAd
nqxyfM/XmKebJCutNWemapz/rsCDDtj4nQl94v1WvWPOffFL1n1pTbPrFp4Q
L3wG83uy/0XROaOHXQh9Yrgn/KpSTE512BY8OhC9gvM4l5hcJb4cmu/eRo3T
ly/diVX2id5OTUzFHL/xn/5M76MHYqc33idw+0i7/cf3/nijIP8s7BC3AcWt
rOj4wv2x4D+2wdAbtUkfoT6RTQW2T6uMAx3iipx93NVwZTrk3PHok/+ZiDl3
YF+tewjY4D1z4sicfsidCd+pry7V3HKNmkr3F3o9fZs3ETJqoTxrOfGn15fH
vCzm3A3cq2ubXfPL2lxL/+3NhA73LT0LjpEP4gt+6m9J1GB/9EFiDt9ygf/F
dr+NuENukO3WDtslNiciPu83ujfRl+iDA/FG+lF52F7nGh2Lfs5dQE9kDZ6j
be6J9EN4y9nE8/OoT+qR+DUGHtbHwi/6N28s+hY1NBb2h+KO4Ry4+UK7+fmu
6n5nnWube2k8+7/ueOylf0/E3vKC7+z/7tZjwQG4MxHzufKxP2fudMd7An3w
zIu65t36UdEceFOYywq+s8lBT9x936pODymXnypWK+TT2Xa/PcDDu5mz6DEP
Rb3Qr4uRy0+Krlu4BjfgEzxBF+5TL9g7GjbpYbxriTM9C7vYBFdFYFva4rcp
8d4Yd8FI2NwY87XhJ3wGN+9LYoiMOXLuT+7UbZFTYocv3QW/t+iPGWG/L+c6
xqd18f6BR/3xrsbeZNjke1/UPvUIB/GRe7Av/suMBtbh6M8DgfmgYryzw7a4
2/qjb7+lvBzXeK3S9/CeeMdyTyBj/i+zc87u
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtslGUUhg/QlunYFug/N+fCdNohai9EF66sF0zUBUaRcgkkbQpEXEiL
KCzA2BpAKKUxakLbBUZNiMUFUWRao62UWyIXK9LQBBJN2lguiomudAFRn9cz
i5M5/5zvO9f3vF9u49aVnXPNbDdSgnSlzQ5HzHJhs4Zys38zZvMWmzXx3cXB
VXy3IO2cPYT9eWzLkYF5Zs04uMf9+kVmbdg/xr4B2wNxszvcbcfHqZhZImkW
R8bRy7GHkG7sj2Dfj747anYTX/n5ZhHODVebFZAA/Sv8VyIHQmZr8X8lZTaJ
7Cd+DfI4PpfkzbYs4Hyp2Ri5DtSYvVRhFsX/NLnczlFbpdcwXWv2BfEu8H0e
aeLs7/howVeEO0+i3yKny6off+sTZk9T3zJkHfpvWbPPAu5wduo+7OS4Jum9
WqL4nOvkXAcyiv4+/j9A4px/mTNv8v9BautFdqH3U9sr/G5GDqH3Ensv+d2m
H2+HvbZmcjo8x2t8jdh7Ut6PfvoxRW0/Iz8hV5Ek9aeQM9juceck+ig5D5Fr
HH/dCc9BsbuQq/g+RswXysAAci7qZ2Q7G/XZaSZBcYbt5L20xnv1D/4byLkx
7VgYpId3ifc30mGOoV3kexf7R+TzSbn3sgo/lUnv6RPEb0h5r99C7ufuIPnu
I9+znC+npkHOzeJvgphfY/sm69ipJ/517AXsJ5Br6Aeo5Z2o964bOc7/v4KB
ZrB1ifqezftMNctn0HeQ23bkL3JfQQ1x6kvXEbfK7EP89+BvW+BY68LfKPn1
RhxbEaSV803ks4B88+T7LrbvODNR5j43FWes2W5EP83Z1/ndhpxC/5Gcv885
NurAYyn6FuJdotYLyEPkUo8sRF/PmTX4ng2814qR4PtI4L3SzI9HHePC9kXk
HP7O59y3ZtKW8B6o9lb0+cIMNRyb4zGVmzCg2StHYW1r4LsvzN3C9xi2fKlj
ZoY5fh713UuW+ezOcKcQ8hlK3xP13um/TnyFVDOxfkCGwdII8kaFY3yImIP0
cAD5FP0p8JGi/lCVz0R3OwLHgnz0YZuIeWztdAm13Mn6bvbg70bOd0S7MSt8
RHyGmp04YVHSOUrctDDpu7gDfXvMd1JcNMO96ZxzUqbOMSushslnNfWtSvls
WslhL/pI2rmqN+S9Dee8VvX4JP0rECeM7ctK932jmJti7ANv47VuEydeIV4F
/v4k1h/IZvx1p52rS+b67msHrhU54Bd6szrjscXR4hphUNgT5/SwD2Wcu1jh
nD1Cr4azvvvakYeZxYZq321xViPfbdXOJcKguFg5KRfhobOIaWH5f84Tl9c6
FwojU+TzXMa5SpytWS6Lee8008ewH4n77unN+JazByPOVTGkJesz0mxWovdF
/IxsCfFL2jEjrOxEX8qZxqzPQjupt+hBpL/ofzLjMaXrzRPXztT6rohzh/AR
jvrbtZycr1P70bTrerNeDXxHtZvqobhtZ+BvnzjuPfLoS/hsFPPmYuckcZHe
lIHAOVFcqDdHXKgaVZs4UVy2gt8Xk85pemsejTt36c2ZrHOOEjcJE8Kqdlq7
LMzq7RvPeG/0Bhb4PlHju6AdE5eejvtbK04dyzqnikv1Rgib4jRxmTD6H3x7
J30=
           "],
           VertexColors->None], 
          PolygonBox[{{5272, 6689, 1910, 6300, 5271}, {6302, 7290, 7289, 4709,
            516}, {7126, 4540, 4539, 6296, 1910}, {6736, 6739, 1317, 4530, 
           6735}},
           VertexColors->None]}]}, 
       {RGBColor[0.4647026679195277, 0.35522565697772573`, 0.77017613282463], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl22M1NUVxi+7O8PM7LrvM7s7M7uzs6sLmF1B2/oSsKZNjfFtF3xt02gE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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmls1GUQxoduzy2H3e7CdrfdoyABbDk8QCJEqQlEgoC2ikIsZywgtmCi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           "],
           VertexColors->None], 
          PolygonBox[{{7050, 6279, 6278, 7049, 2192}, {6659, 8339, 3152, 4783,
            6658}, {7320, 4748, 4747, 6267, 1905}, {7860, 5577, 1320, 6301, 
           7859}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.49735240086447574`, 0.4119947250187938, 0.8160692822152137], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmFtwnVUZhlfT5tzsNMk+dadkJztFW8QkmkK1UrAHDxfEITFVZmDagoxm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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lslVUQhg+0RehCve3degv39vYCsQZoAZFFW8OaKIvQAJJAAhLUggVk
D0IroFQilP2HCAoqokQjIIWCGEhLQAuobKEBE1GIgOAPYyDSlsXndb4fb+75
zpkzZ2bOnHfmxqfMKp3Z2jl3CiSDlhznbvucuwWaGTclnHva71xvcI9xj5Bz
u1jzt3IulOLcd0HngjFkU50b3965fqz3Bx1RVpTkXFXEuRH5zo3KsD0nAs79
yfdNcJxx52znzuY5Nwf5MxjSk3O+ynLuS9CD8WB0DwFLWZ8HCjohz5m5bZyr
yHTunw7OPUB2O3s3tUMPawNznRvd1rknseenuHPfsL4X/Mg4g/OmhZ2b+Zhz
99GxBJ+qsXEAvo9D/i++O3Lu69jaF/3j0Xcv6twFZD/C37ns/wP5OPqfQEeQ
cS26D4AA45n43pXzB7F+gz2b8K0d823BRsZ98PsZMJh4jMDm5dh0m723wDLG
vVgrBNOdyQzjDl4EI8EL4FXsW4NNz2FrMeiOrXeZuwO6+c2XNRGLlXyqRvYV
1p5FtgTUstYHHzKxPR0bS/keC8aA0aAr8W1hTwO+rsD/Vfiykni9C97LNV2r
g3a2dI5jrh0+b8PXMvT5GK/EjkPo39HGfN+E/MagxWAdv0PxYwhYy/g8spOY
L0ixnJGvktGafI6TI0uIx3xisRAsYL4MW2agv5TzahkfBnHlG/FcQj7s4vsL
sJjxAOyrIrYl6ZYTqdhXhI6WDLN5GLnViTMW8V2Y5tz77FnK3ij6ismnPMa9
mGvN+CA50cgdXQG/gougMGgxkO/FYB/xifM+ShT79hbbo+g/ErAY3+1IvoL7
4A64gv9+Yl6aaTn3N/s7K//Y35+5fj67Y91tX8Yx9KxFTw22V2LjRMbjwUtg
ghfrR8TtYY7FvAj570OWqzdBJjKDfHY3uqMAem9yZu9MO3Oyl8PK3TOs/4KP
B5DfDy5741IvVzR3SOfifzm+Z4AKcnwn72VPisVcuTMQGwYELIcK/OajfFvP
fV1j/1VwC1/S2P98wt6w3m4B+DBkPvxvO/iA/Qnk88FmxnG/vVm91cmtLVfy
kF+QYTmzDNuuMXea8WrOqGD8NesjncmEuP916GpD7FvgsErWE6wvT7ac6O83
DhT39WM8O2g2yraunLeK79cS9rb0ZnS3TeCed8dTiVkZSEdXOWdsxZ+DEXt7
t8V5xKtTtnHfbL6f4rtXnnFNHjL7ieVJ7GkANYwfsObQd4zYpsGv+5i/mm+y
Yfa0QiYFJAMXNa57PGT3Lc7bgb+fglRkb/A9m71zwKp0y9lC9OUhX4v8VWw6
EzTOFdfqjpqDxhHihgT+DOW7OzHO4vwV6GxgPD3buPgIc5PC9mb1Vss5Lzli
nCguTIrYW3s5YrmmN3eJWL6TZbFN4ozahNkkW7YQ4zfwvTxuuaOYLmb926Bx
91iQ4Owq/JuVZj4pF2sCFhvlZGOWxUixuci4Km4cLO5dAU5jzw9h4xJx0m/I
9UD/jBSrAWtYm8a+MlAdNu6/xr6rcasBNZy922ex+RgbtoeNk8RF2xjPJdbh
gN31dOyPM58P/m1rZxwjfpvZf93ZHZ1Ebz2oAw3gXNxqmmrZWXAy12KuWB8F
TeToKGwek2o1V1ylN3zZ46zP0b0xYndfh/zP+JYXM+5STVXur2d9Uoq9gS7I
R5m7RDyGO+sN3kTPorj1CJX8LgDzQQU4ETebZetxMDxmHCtuLUozrtIdKPbi
rEfkwUNQn245vTzX3qzeqnJQsb0BrnsxPo9sF/UMra1n6JBlHCTuUQxlW6Vn
i2zsSWzfC1mtF4fn4+/FqMVKPjYSryy+i1KthvyufEN/EveXS/5d4L7O59tb
25BmtUUcJO5RjYlErAdQ7c+JGDc1s78p2zjqaMRqiGqH3oi4WT1Ws8fRZZw3
MMe4QTVdXLkB+fVh48yibLNJtqjHGULM32ZtORjss1o2ImaxVU2bx/xQfB4C
5jKeErU3pbfUv531QnqDenvqiQ5wxr6Y5ao4sgLZyoS9JcVYtWJC2N6uOGRv
2GzQ2XvC1vsdDhp3qgdUr6iapVqlnvF6xHpG9YrqmU5xt6dzLfdimcaVJcgW
+4wzP+O3jvOPtbc7yMe+txLWW6oHVK3ZH7FaoZoTCljNVa1Vjhb4jDPEFeJ4
1dZrfuu1VGOle2vAaqfOUO+knlO9pnooxVY9j3odxVi51+jVeuWg7lacLC7W
He/kvE9ilhuqIaXMj45a76s3eA696ztY7JVj4ua7Xu0XR0dC1uOot1FNV68w
0avl6hnEZeIMcYU4TW+tyuMqvbktIaspqiXijHqPI856nKHYnvDeomKcGbU7
1N21j9rb053oLvQG90StR1dvvturPZrTWDWoPmg5r1yvY9yNvQvDxv3qeacy
Xp1lvZN6NPUWOX6rzeoxlNvi0Govx9XrD/N6W/X86oVVc1Vr1ROLa8Wh4k5x
rv47KMeV2/oP8R+zFtD+
           "],
           VertexColors->None], 
          PolygonBox[{{7238, 7233, 1413, 6263, 7237}, {6324, 7695, 7694, 5334,
            1057}, {6470, 9064, 3647, 5774, 6469}, {6999, 5826, 5825, 6674, 
           1977}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5300021338094238, 0.46876379305986193`, 0.8619624316057974], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2ls1FUUxR8w0ymWDjPUzkymI21nqlZDZDFqlGCM0Q+aGKWGkACGiB+0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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lsVFUUxq+lQ6nSwkzb6XRKW2amQEACKghucUEB14A1RsUF10jdcUUQ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           "],
           VertexColors->None], 
          PolygonBox[{{7128, 6340, 6339, 7127, 2251}, {7220, 6180, 932, 7218, 
           7219}, {6891, 5568, 5567, 6741, 1996}},
           VertexColors->None]}]}, 
       {RGBColor[0.562651866754372, 0.5255328611009299, 0.9078555809963811], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l31snmUVxm/Wbt3bte/H3r1v377t+rG2IUSDbBGJiwVMhSjqDMOYzETD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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lsVFUUxi+lpbSUZWY602W6TVvckVZZlCUuIBgVF1wSTYyISqBQFCNu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           "],
           VertexColors->None], 
          PolygonBox[{{5444, 6812, 1909, 6291, 5443}, {6360, 7332, 7331, 4793,
            618}, {6688, 5116, 5115, 6692, 1981}, {6663, 6662, 6661, 4787, 
           1082}, {8252, 8256, 1874, 6173, 8251}},
           VertexColors->None]}]}, 
       {RGBColor[0.5869664878240127, 0.5647540081035981, 0.9100263901764797], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHts1tUZx09pKb28bd++pRdaaN++XJy6SetmRbxyiUMBEQxOEsmgTKTG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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ1WUZx9+FvdDeYM/vnL3CnnN2F6zBHJZiQQUKcJAVFoYlUCpmYElo
IXcV0AhWXRRBAbMIHCxHjWHdFASijLykWZPcNZtMwKnJCwEhUMkkOmJ9vnx/
f3znPL/ze9/n9j7v83x/2bbO1o4+IYSLIBc0l4fQWBPCMDAJ+ZXKEI4jHwO/
RT4yMISJ6RCGFoVw6+dCuBCFcHNFCN8CHyJXp0KoQN6TH8KfUfwEOrZnQmgv
DmF8aQh5PEfomVYQwomSEM5lQzgLrsoJ4WPWbGPtp6xZztq5PO9H1wEwuG8I
5azprMMuWMDeI+j/CWv/gr43wY+Rc6pDeJjf2f1C2IuN8/j0Gf9dAueQH0+E
cA37rwaPIV+ZxO/6EP4DhiJPwFZzVQib2Lsfm98bFEI+//fD3kXinY+vS8ES
0AZ6yMffsP1XsA25hDwdYP0h9o/AhybsDAeNYESd18pn+ao9/2XtDfzfgv5p
4BT5y0VHX3AS+TV0Dua3vRCb2B9DfsaBr4LR4H58WA4O4WtU4tyVondqgXN4
mP2ZMmxztp3sv4OYbyTWWeD2hHPzPvrfSzlHjeh6K/JZXAQp/u9i/27Osz3X
uS1i3a8LnON55GsHMWwHc5GbsDcE+4PBCORK/j+DrX+CCuQGcB75HKhHfpV1
f8TG6+APyEuJeyN+TcdeF/pvotYOsu4aYhtNzS3h/b/xYRrvu/Odqw/Yeybl
nL3L2ooGagW8k3RsM9H7tUrHuB78Dv9fAeuQZ1T5zHXWDxPTduy9iZ6qvBC2
YO8SudjK3k943wumcFaTwf9yfGYHOYP5PM9BbiM/q3mewP5GanM8+duIr9Ox
sRndNxHPAd6XYfebrF/D+07yfZp4T4EO5JX40oLvywaQC7CbPO0C+9A3BH/G
Yusq8EUwBjzDu7wK56KVGjmLntVZ18KsXNf62Hitan4G6+/Gp7tAa71z8zG5
uFjtHLXUIieta3qhcz+LnIwq8hkcxv9a6mEI9fQA/i8jP6XYG1DgO6qzyOJ/
psFnchKdZ8Ax8rmKGF5k/8/ASPTdyf4pDY5ZsS4Ba8jdd/FtKLX7IPn6Nvfv
VtAJFoJ2/NvJ+5ZS34lmauw6MAFMAofQXYV/qAz3o//lMvcw9a6XkH9Ifh5h
XWu+z6iZuEtrfFcn4uN6Yt2Qtu0NoIY949POPeou36V7eV5U5DvVH3sDQDG+
PEH8r2PnEDgIXgOjMr6zuqsjFTv+94ItrH+k0PIvsd/bz/+NzzpmxToOuRl7
Y/kdAyYh7yWnm8n5teQ7g7+rkd/jHBv6c/ewPzrpGtDZH+zrWn6q1rZU08pN
F/63FTlHy6iJ28GVPC9nzx7WHsbGTxUPGI7+Peh4Ev9uo3/czd67wALWLwT3
IK8C7UXOyQaUrgfPcT96sD9M/Z33DyB/RAJ/xbtnK9zLdYdLsDUH+5/wbkau
e/mfwBtxT+/G9pYK534tPiSJ7Rn+3wEi5DvJ06pB7s2n0Xk0cg9T75LOx9jb
BS7ku0YlP13mu63/VuLbCjCvyDlRb61Gd1Wle6xqvTvtWFXzZ3m+VOXZ8la+
Z598ki+agVOp53Vp147u8Iv8fwxdR8ELse8D+O2fcAwr0VcN5hP7LvT9HpsD
wVjltti98D71lGL3xE3s+ShybtWTCqo9QzQ71JOfTrjHqrc+lXAs6vnq9Ypp
cdYzTLNrEejKOibFkkBHB7X0Duv+Dm5B3ks9fBq596kmPo/ekaxvAlcgX8vv
qKRrbWu+e2s9e+sq3WOv5/0vkFfgW0++78YP8OWhhO+IanfYQN8d1bBmyaj4
rmimaNaqR3bEM3etZh6YWOw7vAb5g7RrSzk6jb2FrFsATiEneD+j0rWRw/vN
xLMJHOd5DfH8K2WOIG5wXtyFdyexewXnMTLPs0wcR9xGM62c96la3zWtOR1z
CHEH9XDN4u6sc6mZvIfa7M3atnqEuMQc/P1KUcwp6syJxIXeL/HZPiquUuAz
1uwcyJ6apGeoYlscn51iXC8OEdeD8ntfpXMueWmBe/HlGFPuyZdnbdybNHM1
K/+B7hNJz0zd1XNp30Xd2bX8/24qzgX+zSfG4bojxZ6BLyHfmPZsXlVsrpAG
i3LNGU6UeSZfnsWqBe7zz+N+op73jXpzHnGdr9ebm6wkHyvKzVF2sXYn2Mba
nn6eDfeIAxV7Rtyh+UIO3yjxmeaUO6fK5Yc5jk2cT1xPMao2xVHETVSjU8n1
Q+ibUmzONlm+8TyP5xXMh4TyRn4LC3xHn9ccAb8Bz8XcWBxG3EUcuQPbt4Cm
YI66r9qcWlz6VeQGcvAscW0s9RrN8qaYG2qmq7emI88u9VhxpQx+p5PmTDuJ
48vI+zibq3Pty9s8H0/ap9nUxMysZ20e9q/D/3WVrgXVlGalfJIvmpnqReJw
4m7qScPiO627LBuatQndr0LP3BZ0T89atzi7alM9R72mJubS6hHqDeLUk6rM
gcR9xKnVO8QJxQXVQ3TW4iTiIjrz/SnPIM0enanO+t6MuZTO/EKNZ7Zm9VF0
ttW5h6p3ioPp20UcT9xO3zDi3vPA3JiDa3a2VpnraYZqdmUjcxnNMM2CQZG5
mWaCerc4vri9evgRfKmL/O2hGheXUg2rdsWpxFW+AxbHnEVnpzug2tcZqrdq
pmuWq8dqrWaEZoP2aNaLA4yLZ75q/wuRubvuQAl7dpd59ovj91fdlTkX+qZS
rS5QzCWuWc3uL0X+dtCd24qPt9X7W0ycTL34+biW1ZNrI3NacVlxzv3oOlDn
XqmZniQ/EXiyj2viM9ZHFe436vEzefdCxtxOnHE2zy9nPMvU88T9ejO+W+KA
O5Dfxm53H38jLsTWzXX+1lAM6hWNkb815f9UamNarbmp9ugu6ZtT35q6Uz9K
+BtC3w6aEdenzWHEXcRx9O26u8a9RN+wmrWVGfcKzdyWKt8x3S1x9p6Mv0n1
LaqeIG4iTikuKY6SitwD1fsmg8aMe6Z6pXqkesv3M36nHhMic15xXeXwBvxp
Tsfcixz+H9c0M7I=
           "],
           VertexColors->None], 
          PolygonBox[{{4668, 7241, 7240, 6262, 474}, {6372, 9070, 9069, 5793, 
           1497}, {5339, 6754, 1914, 6326, 5338}, {6905, 6901, 489, 6227, 
           6904}, {6473, 4585, 4584, 6468, 1940}},
           VertexColors->None]}]}, 
       {RGBColor[0.6109715964219278, 0.6033235381279347, 0.9105736327157672], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXlwltUVxt+EsCT5vmxfQhISki8BEZBYwRFQ0VpBLFDoVBaxi7Xsli2U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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl01NUVx19IWAJJIJmZZJJMMpNJqGjBI2lLQVkEFAEP9BgIm8iRgCwV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           "],
           VertexColors->None], 
          PolygonBox[{{5585, 6892, 1917, 6351, 5584}, {8687, 6400, 6399, 8685,
            3373}, {6927, 5314, 1043, 6925, 6926}, {6273, 5109, 5108, 6182, 
           1876}},
           VertexColors->None]}]}, 
       {RGBColor[0.6349767050198428, 0.6418930681522714, 0.9111208752550547], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGlw1eUVxt/khoTkcgnJJSEkNzcbFlTaEepSqbK0tZZ2xlICii1+KFTG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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtw1NUVxy95kGxCCMlussnu5rEbkIjUShieBUGpMoUptAkhEKKd4VUE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           "],
           VertexColors->None], 
          PolygonBox[{{8714, 8250, 8249, 5293, 3379}, {4798, 8345, 1919, 6362,
            4797}, {6209, 6485, 6484, 6486, 1891}, {8968, 6646, 1363, 5654, 
           8967}},
           VertexColors->None]}]}, 
       {RGBColor[0.658981813617758, 0.680462598176608, 0.9116681177943421], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2QlWUZx++FfTlnd8/ZczgsB/bsnrO7hzFFBYRRATVxlGzKLClAbaBM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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVx28WQl6Sl5DkJe8l773kLYCAYUtki2GxgjpCAWUJm60t0BEk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           "],
           VertexColors->None], 
          PolygonBox[{{7135, 6436, 6435, 7133, 2253}, {5798, 6988, 1920, 6374,
            5797}, {5305, 6867, 2075, 6870, 5304}, {6908, 6451, 6450, 6903, 
           2095}},
           VertexColors->None]}]}, 
       {RGBColor[0.682986922215673, 0.7190321282009448, 0.9122153603336296], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuM1NUZxs/ed/YyO8syu8jszOwFsaCAsqTVAhYaGingloopotuAiDZp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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtw1NUVx29CyINdXrvZbDabfWQ3BBMhqQQJGJ5WWxREioy8K+0AjuFV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           "],
           VertexColors->None], 
          PolygonBox[{{6706, 8856, 8855, 5450, 1178}, {6049, 5428, 2027, 6806,
            6048}, {6937, 5320, 5319, 6936, 2103}, {6403, 6408, 1322, 4548, 
           6402}},
           VertexColors->None]}]}, 
       {RGBColor[0.7069920308135881, 0.7576016582252814, 0.9127626028729171], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmWmQldURhs+sd+6slxmGWZiNuailCYqyI6ZChJhgCEHjEoiipgRXKI2K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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUVxt/cEHJDSCA3uTe5+829gUiABEkgCRAMKKKUbUTZgri0Qke2
QavU1joDGHBaaEVFwbIJDGBZ2rFasHbEAiJlqiOLTRBBFsGCVgYRmbZI+3s8
3x/P3HO/713OOe9Znvcrf3DOXbN9zrn+Wc514Lc15tzToG+ec7WgLuBcbsq5
jqAWORB37tfFzo3Nd+5PvB/E/9VJ55bw/xD/D0ec68m4KnAI+XDQuS/Tzh0p
cO6TLBt7kP87C2zOhqhzm0E617ntKFDIPk0BG9uF9RaiSwPv/Sh5M//X834D
mNrZuaM5zn3EHjtL0AUcRb4ffR4AX0r3bOayX38wu6NzYfZ7vggZ3Ir8JKhi
7R7gHfZ7jPVW8+5gKTagzy6/c3P5X8B6f2S9HazxHv/Lw86lwH7kmxLO9Qa9
QGXCbM8wPh03H7yHrkVx81UrOn+GLmfBZPZ6nWffII/HR+uw/cc882FvFjjN
3mdAE3MHgw/zTMcfYuN0cA9j5/B/DDpU8r87GI28l/X2gK3Yti3f1kqEnLta
YGuOq+DMOL/L+HNnV+casaNV/sPeZeAO9qord+6/6Por/NcWszkauxEdD2Pj
ETANfQbwfg/vn2O/n7PX08w5hh412F0N2iMWS5PY/3wni6l5zF2Onrvx5Vye
dcb3YxVjzK1Dv8d5/0jCYiHF+LH4r5h4CYAxyC8FLcYUWy8ih9B/CmgBQbAs
aWess5VOWntazNbSHsc520/BSfAxWMTYJL8J0Iq8P2Y2yRbZ+C76vc+7S+iz
E/3O824q/rsXnENuZs9T6BLnXRFncgK5uMR8qWd1zD2LPX/H1ir8NQmdV7Hm
Ct7N5tmNMufu5NklxreCzRnnNoEWzvbJQnKOs3CcyaY8O5MazsKHTfN5f6AL
58j+C9jvC9bORcctrNWOr9rAZuSPmHsCfAKOglfQLztmsTWPNZZiczd0rABL
kL9LmI2y7XrCy13WOVrg5TDyMWy/D11rsbeONXuBnqAWZKFbDnPP+k3HBPoN
Qb9mEEeey/4fsO6uThbD+xi7Gn/8hXh8CBtrsH1O2GI7gv1XGNudZ12Rf8n4
5ciH2f8QeAG5kfnZrH2NuR3B28g+dByOL1rwV2/s6gW+Zf03eTaHWMwhRjqo
JoQsd2Mg6uVwBUiBJMiAbuUWI4qNCuSvWb+R5wexvzfrDUP326Lmy7uJ6Sad
LTa+BAYhb2Pv2ew1jlgsY04Dz4eCIaAeXGHNb8B4dFUBvqp4xodpbHmd8ZcC
VmNUW75Cng3+U2axUs2YWREbo3czkduwvYY1qsE/kDfwbD5zn8Df15iT5Iy2
4LvNIIE8Ah33MXcy+9/Lma1QXOPXHsTWeGKqDh/V4OMbfovhbHLwPM/OAR/y
fuaOQJ/puVaTJb8bMP/r2VfEz8fSibNrJ36aWL+d9X7fwWrQnawxArzBWD/P
uuOr06ztx1+5YDJyLfpEOf8NrDGL99NZbxP/7+L97ez3tyKLxWms8b5qk9DJ
YuwAcj5rjMixmluBPtPZL8BejejTPWw+k6+6IXfGJ13jVpuHZVts70Dn7cUW
48fi1gNU+9vj1hvlE5/XIyvRL4H9b2SZDZU8y4BhxEY+/tkbMJ/L1xP43w/b
+oM49qxlzqOMnQcG8K4RPIOvFscst+WjGaz/MPgD/0ex/hje3YwPTjG3JM/O
em/McklnflO55bhyuxI5w14VoKDQzmQQ8lPo9AswELkybjGi2OgOwsz5Dbbv
Yr1T6DMR3e4G48CElNXyR4tMF9X0VSmzUbYppn+reo3PD4GXkfsQj3/l/Tug
JmK5V+HlmnJQuV2DPdVlluPLmbcULAEvqK4x5jn2W0q6bMOH3+HLAynrrev4
P5Q5F1OW69d8lutvkbN/LrGcf4B3U0ALuB8MYfxWcnRXB6sR6jVdQKHXcxaA
KvTuAeYjP5i0nqheKA6xnrn9eFcHXkFuwIf1GYtVneltyDOIv4fBrcinoxZz
irVTUXuXxZouaWN64pNRrDUSVCFP4Vk188KFlgNf8H8l/9v8FlPyzS2MHRw0
H43JmI2ybTRyA34cHbPYUM1ehx+6svdi5N25tlct+/SN2J75rPFaiZeL6k8l
lmPKLeW09pJNskV7KtfXpazW6n0TazfwrB4MQm7OWIwptm4BD4UshhQ7P0Ju
B3Px20Vs+Qk2zYoa5xTXnIm8nvP5kHkXsH0Y5/OzqM3R2PlgN3M/QMeBBcYh
z8Wt56nXfQYug1Tacr0Ke5y4Sci41lPkzA7mDlB+qX+gf27YfCTfLAIzeVdH
z73QxXraFfa7BoYxfyTzO7HWddZf47caI+51PGi1ThxMvS/kcRP1wL2M/QH2
jAB7kC/j23sY/zV7Lcw1LnC1zGRxgkjYeqh6ZxhsDBrHErfagHwWXT4H58GZ
UrNFPVG9UDatxc9rwOEcq/Fb2PfVjHELxby4+JKgcW1xcuWqOJa4lXJ2QMI4
h7iGasAqnq0GQ/ONs6pXiDOKK6pnFGaMI4obinPO5/x8cetttTz7nPP7Z9R6
0SB0yuC/ipDJyukW1p4A0j6rgd0yxsnFxcUBEswtj1pvFOcRl1ONUW056cWC
aqhqp2LCx/9vy+xsX2P8W6y3MW21QT1EsaWYUCwoxpTL6uHq3crpAD4fxf4j
QVHYuJA/bLEhTjQQ2w4W291HHP160DituKxiZBbzshnzKu9e9lvvFIcRd1EP
3cr4I8xvYb2uOVYbTzP+VNxqpHq1OIi4h3q2zlocT9xOZ65cU84oV5RzJ7we
1e5xvk+xdXvQuKn2OJm2HFVunkhbb1OPUG9QjxtFXOWFLNfEccQlFXOKNXFK
6XbOyy3peCJlOabcWtfZ7mqLYnZ31J3tHO8vpOxdfZ5x7WrW6h00zi3u2Yjc
EDQOeiVqOabcUo0T1z6j+1DMOHea/CoHi33G+bSWarRqs9Z8BH9vZn4w13Jy
Ks/Wpo17qWeG0LUE39/g7N5m/gx0m5MyLidO0DlsHEvcSjVStbclZFxUNTjI
/JXFxo0mdrC7XqXXK3Xnmwr2Je3u1SfLuFhPUOVxsoYK49ji1vUV1pt0h9Xd
VT1qIXs/GzNfKQd091hQbHdZ3UHU6/uWGRdWz9dd4s2o9ULdKe7zdNDeugO/
qFqctLuvauxjpVZDVTv/1dG4ru6QujuK804Hv4uZbeJQusv1Yb2auN3pxNXX
RC2WxdnVu8SpxaXVw8QlZKNsE6e4wfPHS22vADq0ldqdWnfpevybxr/lGeM+
4iQz2Pti3HrPRerJ4IjVONW2pojd5fsljWvrTi+ucNy7y4kzXI8aJxAX0B1q
S6nduXTXUkyIe/40YXdPcVBxce3R5HFy1frvdehiNX9mkeksXVXz5rL2xIBx
uSf8xhVU0/d4nCEL3f8Xs1qnO5t660qer0hbj9VdVTWlyLuzKpb7JM03iukg
vijO2LcIxWhh3DipuKi+QSgXJhMPk4otJ5Q74iDfcw/FesRqnmqdeoq46KxS
+1YiTqreI44w2utBwyN2J9Fd5PaIcf1uSePe4vy6i8hm2ao7iWqZcki5o5qm
2B7CmOaAxbhsFccTt5PN+jYz3Ftb32j0rUIcp8r7ZqG7kTi9uLzuSOJai5jX
mjbOtSxtHFDc71nw74TdqXWX1jeFNcTXjIx9G1KPky4Rr1dKJ93FxDnENXQn
09rNHhfRHortOu/uqhgXt9U3hzEex9W3LnFgcV9989K3H3E4cTd9A9K3olVF
9m1A34x0Nss8XXVG4pplyKVp45z/Bx3/lZA=
           "],
           VertexColors->None], 
          PolygonBox[{{5548, 8926, 8925, 6464, 1297}, {4429, 7065, 1923, 6384,
            4428}, {8728, 5310, 3163, 8732, 8727}, {7886, 6765, 6764, 7885, 
           2744}},
           VertexColors->None]}]}, 
       {RGBColor[0.7309971394115031, 0.796171188249618, 0.9133098454122046], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXeQltUVxt/tve+yLOzut0UjAgIRRGLBMkCWojIxOkIEIiFDizpCKKIx
DoIBARvCQmgmoUlVEaUaUSkaDYnIxASVSSajRkUDJkYpmufHcxz/uPu+e997
zz33nOfUr3Hk7T+4LT1Jksf1J0PPTblJcldekjyo92N1STKwIUkKM5MkuypJ
WmuSZIDeR5UlybDKJJmiNdvzk2RHSZJckaZnYZK8pu/7NX8klSRD67VO348W
e82NWUnyhc4ZWJAk67VmoN4f1Bitvb/U3DbNPaExuTpJvmqTJCOzk+RZ/b9P
Y69GX9GYqPUTNIbrfX2p6Os5V+vmaDynNS/r3OHi+5jusFLfNoin7ZrfGjRe
1rhDvP+vPEkWi8548faZzp6pyx8UvT9q7NS+yyqS5PpzLAv+Z/7vuluV9owQ
v8M1bpY82mjMykmS/2js0P2Wac11Wn+txiSt3aXn7pBPdo7p8L43z3cfIn5G
xRmrMs3Drlg/pyhJBhVYZnO1t4N086z4/DJkuDTxc1C8D9Z8PvLR3kzd8dN2
Xp+t8bpoH9aaatEfWOK7cw7ncj58HQzekOk6vQ/V+o7SxWPtk2SJ9s/S/cq0
9pj2DhM/h0R3rsb3apPkEo0ter+3wLpEj8WiVSCsjNF7eZ73vqu5RdpfpPme
ei8s8/uEmCuM+dmiX6r1B0VzVZbPzEs3Js7XOJplfjrlmibyRu4T9f67QvMB
D91E52utWZ7hew0RjSVac6vu1EsY+FOacQfP4IR7g6uDwXth8I8uOQP5ntTc
rZU+65J884icE8lgiXAzRO8nCowr6A8IPLC+k858Q3p5Lc143R/4XiFdL9fI
yPD9OXus5hslgz0aYzT/hnSRpjFa969pFH50Vovmn9e+1eJ5t57Vuu9M3bc1
2/gCZ5yVp/Pbip/LNPdRoefB3kWyl54pf9tWaH6QxyNN0r/oF2cYJwfDLs7I
pnvJLt7XvRdl+5xvbI8ne3ukAJr5bJJ93QdfOrdHqd+hWS+7aVdjPe/RukeL
rK9WrbmgxPct0Z6teu4R/+N1p1+I1litXSnedjYnyXztycm2/XM+GNxUaRxy
9hiNexPbJe/YJnftFfddLRprmk0XvEBvHT5QvI+Vv9uZaaxBr7d42C06N4iP
nXou0Vmt0uVVkmMnya2jRiXY0LpUmrHP3PkxD067ZRmrB3Te0gJj/kSJ132Y
Yb3tCZn2Ez7nNPi8nuLxIo167Vun8QT+NPGT/8HMAn1/r4392XDJtCXHtnmx
7rqw3HqfJpqTdLcOol+r/+vEyweJfSS0wP8tkt8ftP7n+j5funhY4yaty822
7Ncmvgf2xF2gNS7b9NHDosBDrxz71Gs06vRtepHP4sza8HtgYXpgozX2Qr9U
cs/L9L6iTK9nLzzMy7bO54ScwAzYXxX4/4f0Mjxwi987HPZ1UHdaXWk7Jg4w
/6ZGvuRfUGLdYjutwcN0YayLMPBApnGAz12m+XFp5gt+nhO9w7LlfH1/q43l
izzO6Hla4+1cy2Re0FwUWOX9BtE+3lY40N53ddYG/b+vyPbepcR4wA66hC2c
F3LG770qXb1SbD9DHNobdzkcMW5fYANcoNOVpdYDfu9N6Xpwhu+BfyWu4L9q
5U8eq/C3p3WvAvHUQ/xcJlxdqdEgek8JO3fKLx1IjFm+w+e52ru2wn4Fez0Y
NttHdMprHSfSJf+u8hst8hsnS61DYjvnlYau35BvKW52TrFc9rFMoz7NWH4n
33juXmpMIP8J+c5XTmjvbp31cZ1pHS+xXcHbY6XGMRgmdmQW2KbJBx4qNQ+n
Audr9H6m1HteSvcdoYMNo4vjQfPhoMn6ljgD+mlNxhkY61HuGIP/36P5FzS2
SF73SI6ncmxLYJzcCvw/LTt9MuV7vyiZ7at1XOa++E3wzL27x/sJyWqAMNc3
13bEGmyJXAP5Ecf5n/XIijzu0nY+D8w3aPROdy5ATkBMbon3xTE/IGIWOO6c
bZkQS2eH/RMD1maZr2FplsHqxHsHRY6BTWKb5HjIDZmz5tJ8x07iJj5hUvA5
udTvZ2Nuqf8Hqwv17KJzWtKNhXcDD2BkSqn9af9844t17JsSe/+luQ/ybadg
k3PBJ7F6a5XtaITmhuc7v8X39c90rskcOWz/0BV00Ncnec4tlgf/+Ht4Psuj
1ozNsH+HL+Z5To57gSew1JpYNitDPh8Kv+Nr7QOQExhFVp1LfP+WiBfHA5Pk
MuxdErJ/OGQLHhcEhsdW2w6xwR9Kd/kFjof4cHJk+P9I5z5TaTySo+UVON8C
88Rjzm8UNptSth94YR6/RK49IvLt94XHDinvRw4LYw0yO4u7sPO8wPyWSp/N
/x2r7HPxt/1KrAPkv0lzTzY5P4L3K/PMPzzNTbcMue+ZsMlFxK72xjY5T26J
9+zU3PyUc3h8amPkVNQIq0oc9zdLPvcU2M8Tc+CFOIVcTwV2OeN02D42cTrk
jN56nGO6xNOVQfN08MaaW5TvDK5yLn1HtWMG8eJJvU8pc0yfkeOYQO6DDlhL
3oudl0f+fK3O6tXWOoV3chfOWpDrWoT91Fw3Rj1C7jM68p9bJYPbNHZkOq+H
J84g/4Vn4sWvRH+WRk+dN1rf7yg3D7eJx/llrg15PpLy+6SwM+wX++kfNkT+
eyJqq1uk5x/X2W7gF745kzhwMuR5MuS8JugMD7vD5xzJt9/ZV2jftbfQOdqq
JsdnfBU+jNz58zLXn9gt+TrfmP9UPnNQG9P5Z679BTjFVw0MX9ctZayD8wEx
D92/6axPmpzHEY9mau9x7X1ENB+t9/89pJPubZ1/wTfn41v+re/H630HapxF
UcPib/sGfeI5eSGY71/ib/jPBVo/pd71Hf7+wvbGwlTNvSUd3Z1nH7AqYjzP
1fFObUjesj5i3cmId9y/b9RNxE/iKJi/Id317Yyoy+ARf/WCzryr3nGWtRNj
PbU+ORY1wzDxNlFYWSna07X2Po1pWne3nnfWex/1L3PY4AjJc1q9aYFFalww
fFxxaqPkvFn67a5cYKjoDhKP7+S6BsDminXv9Lb2/+Q75EDU9eCdOhycZ1S6
LiV3Jw4QJ8Ao9+Oeh7Q+Q99/0857luq+r8oOjyWOLcMif/5KOvm62Pa4SWue
SjknORXyRK6va99eyahrjuU+M3ItcjB8AXaNDzqZZd81OHJi+Fkf+Td3J9ff
leX6oqNkMErx6eoiY3xM1CNtmpzrkOeQy70X+VydcrD6Rv8PHoZEX+VLyfN6
0dlZaJtbGXaHHWFDxME05Flr+R2qdx5GDjEv8lVs9O3QAfJ/qML1J7kPtggt
/G2WZHN7G8db/M1noYthondzvWPsjOidkK+SMxDTboq5EaHHzU3ONckzyZmI
s9haS6XjGX7vvzo/S+u66ft6zV1V4fwdXRLnkDO+F37XRE4M9qkTqWupE4qj
dv59kfW2Unh7vJ35HiC59W9wbUdu1T3yK9aT01BTP5pyrkaehs/dGjUrefp5
UROhc97RKb5wr/ben+HaHDro6EzEFGLLgQbXD8h7l+7bJ+oLbPr54HO6ZHys
2ljBv7wSfoMntQH4JD4vjNhN7414QE44JGpUzs0S72nl9oVPNznWEmdPxrqh
0Z94LnoCW/R9UpXtHn2A92OR2xyIc+GDd3zHx+Lxz9Wuwb8re72u1naFPktz
TeNA1DLsnV5hW4JuSrHivDr3KcDpV2GDPPm/d/TTuBcYo2ezLvqByPn+sMGu
Re6LTU1c1y6pcWy6psK+Bj+zockxGDtdUeNeJ/Fnl8amQtsofpb8AD+8sdD7
WH9IdNZX+bx06WtFO8fwccLG+JR7c8RUeivIkP8HRk8Pnulj0mvqpHO71rge
w89RH1Dv9hb959vb9/J8Id7ha2PwRt+QOWIxsXpyjeP12XW5nh9R4rPuj5wZ
34H/IScaFXkR31iD3OgHIl/mZ0eNCL7BBTIGG9Qx2Bz1bLrsMbPRvoB8mN4u
OTF9Hfpx1OnQHhH3xcaywz+skPyHV7nfSf4Fz8SXgeHDoMPeYcEbfbJt0dfF
n09Nt+/YXuj5A+FTN4aOXtT9Xko556X31lpl+8UGB0Yvgjp+Z6VtbUv4/d7R
h+N8enHgjtqJefKsX+dYJviPXuH78Yf5kZ8cActt/a0lfBj2gk/fF74XHwAf
8EOfD1skL72wrW0Ge5kTfQ7wU5Hjvie54ZSoj7C/0VXO7Yil5Lzkvvgf/P72
kMm2eMem0SdYo/6iT5xV6XfuNDvuVV7jHjd3Zd+O2IuvmxVr8G25cRb91Mtr
XPOSd2wOPRL7WIMvLAj5EC8WRK1NHCGXJxYQE+j3cs9jUeu1hJ+hZ5cX+Xyl
4sk7la4jidvLyrwGH01spb74UPZ9dYXxV9/GcY4YRx8TXGM3sxvsT/Gl9O3w
fWCbnIzcDD82SbR3NdsfEFe4x73Rj8rJ/rYWwG5zw9fTpwEnxIIO0bchpyO3
43eT0XEW2AIr+DbwQP3dEjkhMkO+38SQo5Eb0N/Pj1wX/0a/gf+vjZqd9z7i
94oq9185f2Tsx+92DSzST0TOyPsq1S6bo/9APU9dTw1E7sX3vKgHO0fdin6R
B/5nXvgq/AB5Y0H08JHZuCqvo+4ZH7UGuoYO+qbnRUwEM/hyfAJxilidE33d
zkEfOdMjgdfl0a/GF4Dtc3RWs0ZJsfOkF7PN43c091m9cYSt45uw94llzq3x
552Fnwuq3XudVuNcljyWuIF8kSd5Bu9To96pi3of3k9En78PuXl75x/kc19E
7k2NQT+A+x6psj/CF8HjrsxvbYUn/KDfnuFzOLNb6Ji6+PtRG/+00r/DgSX8
+dLoleE/OA8fQg1CfkBMpua9IPpXxO+Xs527t4rG+vb+v2/UHdAsjj42PNAH
TVW7HuYO3IWc7Uyj8zD4+7yt4x+xb4xoftloWdFP3RP+C977BX3kC7bA1QTR
71LtfuVvK/37CrXYj6SHLs1eezz4B3v0nehHgtG/yKZHpvw7HXkYNk28+4nm
/lrr/8EEdRt+k99P+H2C/LRf1F/wkyE/kNPgmpV8H/9PHOA3lvI6+6izOoy7
z4hagrx1R/Tc8C0z47cf4hS/MY6tdB03NWor6o55incLmty34w4PRI+beLUh
Yjq4XhHYps67vMI5SJl42d/gfgK+GB2S2y6WDq8pcw+Ammhr5LtPSH5rm913
xP7pfeKXwO3+yEWfES9bNVYVOe84FTEdfcAHcfZoteMZsQysvB61H72WxeX2
5+jwqSbvI1ZAD6xlNLovw5qN0vXRJp/dXOffw4h99IYvqXfvLD/68fD5QIN9
9Dd10a7wvfSpZsXvKfQ3dsT8yVjHO7/NUFNBa3fMQxPcpYrt1/jNh5iJvdIL
mx00L5bMejV7HT6yuNjn8ZswmANv9FE2VHs/vZ+fRe+OWHRus+MRv5XdU27M
Nmquqdm0+oYtnLVNzd0cPuf/Im5BlQ==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVxy9ZyB6yvOQlIXkveY99kSgBkU3BBahB0EqnUJaCICIVChRB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           "],
           VertexColors->None], 
          PolygonBox[{{6724, 6728, 6727, 5303, 1034}, {6439, 6893, 2088, 5591,
            6438}, {6515, 9008, 9007, 5723, 1444}, {6528, 5192, 979, 6200, 
           6527}},
           VertexColors->None]}]}, 
       {RGBColor[0.7550022480094183, 0.8347407182739547, 0.913857087951492], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQl1UZxw/Lwi67+2N32eX3g72yu9ytBFa8ACp3cAAxEbFcJgXC6o9Y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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lw1dUVx28Wsr9IyEueSV5e8l6oElwp0E7rKC6BQjGQqLgwBiUkbFoC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           "],
           VertexColors->None], 
          PolygonBox[{{6971, 6975, 6974, 5430, 1172}, {6197, 5047, 880, 6195, 
           6196}, {7061, 6498, 6497, 7060, 2196}, {5455, 6813, 1985, 6708, 
           5454}, {7774, 6548, 369, 7772, 7773}},
           VertexColors->None]}]}, 
       {RGBColor[0.7773380797141883, 0.8519024192006653, 0.9074422414675376], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l2tslVUWhndryzmF0guHntr2tOe0RRN0DDPRmBiioALRMVowatCI1zFI
Jhm8lrYiUS7RxMSiM/KDCRJIFAEtEY0GqkDSItZrx/EXlxkkE29k1IiXKLT4
Pr6LH1++/e2z9lrvetdtn/a7ll7/t/KU0vyylM7S+209eyr06J2tS6l3UkoH
9f1uMaXBtpRemJjSl5NT+kLPWsn8sSql8Ql6dHhQe0/r943J7+5Y396Z0pp8
SnsrLXel9mfL3irtr9azqCals6W7Wc9lE60bG2WSf7LcZ5A/pzalpbI1U9/L
64zlcu33S8d4h/HcUkppsWxt09k7G1JqnWYs38uHWj3fSObxQko3y9YMYX+x
wvZOyM6odH5WY71zJxrnTu3Pzgl7i2VWVRnvmPRvEZbLJTNdOvZp/6JMSpcK
21WNKe1qElate4TloPC9IfkNzSl1CdN3kjsWXOBfr/waku0jwrZVMg9J5nTG
fI8UjWefMDyh/Qd15mPZq9L7kOT3ZYxjTN/7JTtb/g4oZl9NTelPOj9HZ58Q
hufl837ZfFgy+/U9rvXpCfYTH+fLv+154zouDufI3kntX6HfF4ePtbJ/b5u/
D0rfLQ3mD57mREz75MtwnX0a0W+VwvWBcC4RP3urzM8K6ShMc34My15G74cl
s7k1pWdb/b15ijBr3SUMuxSfnRXmv7c6pd01juPbFcY4kJwX5A65cZv4/km+
LNTeC9WO2Uo9v8qvG3Lm7ket5+eMDz8OFO1L/1nmeJN8uVr2swV/49+OSfbx
S3E7q8M8szcQ+2BfH/jH9KzR/s6sck+2rpOtcumZJZ5n6unS/rcF5y55e7/s
b1HsT2Ws77LgE872BW9gIQ/AQ84erfHZFZG3iyV3rMZrfOF9NNZfV1sX9fK8
vl8JnZXCO6HV3/A6GNwSGzijfsn9WTnz36TYPZkzz+8W7AMYwMR5eBuV/tU6
+59kDMeiptBHLIgXWJYEHvA/WmesxHNlyAxXmDN60vsVrpGPtN6h2jqpGpub
8d5w7PdVOz+K5a4D4gSXu8V/VpiX67c28bat3DjpE+ub3SvAzln2r5jm3kHf
WKP43Kf1WMa5vShs4deKwDxU6Twmh/GDfWJBP1kea3xljb9PC3t/o+uPuuJN
Da7KO3cXRj8dj31soBee50jPzRNsjxqal3OsOHNcz6xyx5dey/oPOvu6fH6z
0v0PX+Hnpqx1nMGOTmoNX19qtr/0CN7MggeEa1v0B/J0WdG5Sh/kzcyYqbP/
1G//z9gOb2zNq7I9+k9rreNLnDdL9g7p/VFyb7arLnOOzQHZuV+63iGPxNM1
ys9fhO/OTnOEr9Q7vZMayUQfAf9AcE1uL1DeblV+3p11b8YO3Dyn3nKo05zs
Dw4ulJ7Vec8quONZGHwm7T3T4HnULL8LRdc3eD9vMuY9kumpl4zOfNZk3GCG
czigpuqztsks2iv5ZQ2uFXrBGc6oe3zDr9PqMWMdnoUf6f13yb+l9bVnS162
l+jM7snuj2CjtogHtcO5sk6fZX7jN75s1N4Djc6VV+E75hS9nxgT3y9CH/W+
MrjmLHOLecOsYb5xnrNfa70m/EV2ZcSGGQYf1As5ePFk+/6LZH+N+v1U7383
Oj7U5lDU0XjMNPK/XbmxMecedoFyZnqzcbwRXMItfYsapg/Vy/eGDttDx5ao
I2p2NOqRWhyNO8RC9bRNUy27Trl2a70xMLf/McV2yG/qgVp4LOucwk/yqDfv
uHYXPV+ROx48wNtS7d1XdGw+ke51je4D+FuMfkQ/29JkTh4VnjsaPPOIx+93
LGHrynmW0BPPk77z9VRPck/gTQ0vEJ5rO1333bWevfTPBTnPPOYd96iDkQ+/
99eKmKGy+UPJffdu1c49La6p/4mDrhbH9K+SOVzwmemy/3PeduGTuoPbpVN8
x+J+BW/YR/+Jks9z9lT0F37vE/ZL4p5J/OGFPjxDPJzX5jsI+bgr7mlw/Xrk
0o05z3VmOnwhw8y6tNH3HuqbXAIL8cUGtqgHuDmcfI86ofjPVs5cHXrJHWqX
35H7MDlWYCM3yJEd7V4vq3WvQuY17W1vt+wj1dZHb6GHU1fMYmSZJcgzu1hT
I8T8UMF+TJWOtUXfvxeFzDuBuTvOUm/cV8gf4vCXFsdiT8jAO1gGAw+6+oJn
6pKZil3y8V/1zkl6Mz0aDntq7due8LE71tQ4OUT+8B+BNfeBIzGnmfsH5MdI
wfmAPnxCJ/EltnBCLg5HfiBTWWc5amBe1r0Fv3vDX+xgD/zME/Kevt8inrar
J/w3eW6M5M0VseMsuC6K3s9c6A6/0HmNZC9ssT1yaCQ43tDmewB3AHjDLj6+
l3evL4t5+1j0Ae473PXwfUD5eH7k7YPC83PJerHZE3EkT3dHruI3/jMT2RuM
fe4j3GngKsu9stXzrTLuROB8qsl3Zep0bs53d/Qsj7PMnm5hOFXy/wa47w2d
cHP4TG7H3Zpeyp2KOB6J/ByK+zz3DO7T5Ag1xJ0RTlPWc4wzGWHYVXLuk7/9
kcNV8T+AWrtev99Ucn3BHb2U3sJ8Zu6ic6NyZ9MU3x3QOxp5hU+PBP4jsvXn
VtdAX71nKnLUQ3/c4YkT+NCxoeC7F/etkyXHZiT+v4zHrOHOzmwnl3rArueT
Cs8A5je94WXlWk+D95l7zHtq8a2IaVncK8jRofifyD1vZ/TbgejJ6OgJ/T+V
3H+pB+7XuXbnW1PRdw4wbc37TgNfHcqvc9v8/3Ms+ih6fwM5/mVp
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lwjWcUx59Ebm4S612SyHJzXel0qtpBtWbKKFqipMQSGp0RWyVCK4id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           "],
           VertexColors->None], 
          PolygonBox[{{4850, 8366, 2626, 7722, 4849}, {7015, 6539, 591, 7013, 
           7014}, {6567, 6564, 6563, 6137, 1861}, {5966, 6222, 1897, 5101, 
           5965}, {5753, 8287, 8286, 8291, 1463}},
           VertexColors->None]}]}, 
       {RGBColor[0.7988962964874597, 0.859091510055523, 0.8977841796721335], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl21snmUVx6+2T9/XPn26Pk/X99cPZP2iCDHO4RSUZVvQBEs33Bg4FRez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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lslGUQx6f0LpR2u+2Wbbut2/aDCV9EoyQKHqAcIh5cUkWKgFDuUylG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           "],
           VertexColors->None], 
          PolygonBox[{{6626, 6621, 396, 6020, 6625}, {6526, 5996, 5995, 5194, 
           1952}, {5728, 6969, 1950, 6517, 5727}},
           VertexColors->None]}]}, 
       {RGBColor[0.820454513260731, 0.8662806009103807, 0.8881261178767293], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2MlFcVxu/uzuwODDu7s7vM7A6w0/3QmLQQaUSiNH6AUj6kJKYptGAC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ls1FUQx18vdttSoLTd7W7p1m3BmKAmGo8oGJAi5bCAiCCXlFKwIEEi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           "],
           VertexColors->None], 
          PolygonBox[{{5211, 7593, 7592, 8614, 3354}, {6206, 6205, 6204, 5049,
            1865}, {6782, 6785, 1867, 5051, 6781}, {5460, 6814, 1949, 6510, 
           5459}},
           VertexColors->None]}]}, 
       {RGBColor[0.8420127300340025, 0.8734696917652385, 0.8784680560813253], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl29s3VUZx0//3Hvb23a43t57e9vd1u4yoyNI0IJGHGgFpmHoWESQYQBp
M3mjvnCrLoEZFWpwww00YbQZzsRlY/OFyUD0DRAQ1P1RXnRrR1dG90cTpHPs
HwPZ/H72fZK9OLnnPuec5zzn+3yfP7++b39v2XfrU0pL61Jq0O/pOSmd0Tis
/weaUprUWKb5pBZvyKV0RPPvz03pz7WUdjSm1J9J6XrJ79T64jrLnpCeD5t9
nrN3F1Na0ZvSdq29n/Pv7ZJfkI6vdqS0T2ef607pjxpTWvuT/jfp/E4ZNq75
ZNb6Gy5P6S7tn9B8WLJVGjPav6crpcvbU3pFOl/X2mHJ1+h3QLJb56VUkK6U
8+8/Jc9KvqQzpWnte0dvfSljPUsztg/bvtxou2Y0Pyr5rPY+LjVntf89jYc1
v1Z7BzTu174rZNtkKaWF2vezBuvcqLOnmvwm3nIuzh6TfEslpW0aW3R+ufDZ
NN939wuDm9uN/3LpeLFFuErfxo+k9JRGv+Sbc8YEbE62Wr5V8s/rrdfNM3bI
RmP/LRn78TXsabWccxPad2urbcWHxWbrxMazYeeNsmXpPK89VLSfeM+o5HuF
+2K9a5GwvF7jPul4Xut3iB/bZF99Qf7V/631vqO5yThje2dbSvsbjNdnJV+i
9d9XU/qDRkte7grcfldn3+8PX1zVl9KVfX7Hav2fajXv+D2o8aLu2iS7vi5b
T8ieLt3f3e07HhXej1SM36D0Tbfaj9NxljnnDzdaJ5iC+68DNzDDLxf0vs0F
6wArfjlLfFyTcYycbnVsgD+ynzZYfl62XND4iv6XhOFUj/k6Lu6ckt0Lssae
u7l3do45+rbsfyHvX87WCe+S/PKY5kPS/26TOX+yyXNwY/0nZe95RHpX6PfH
khd014Ti8Tad+0veHIWfx8XBQ0XbDfanQs+9OccKejpyjpPj2n9QOOzvNUd5
A3ZgA/EDfuSBLuF0qGZcF+jeLs2v0d49l6WUafF8uWy8o+w7bpL/b6yam8RR
f9a8/c8cz4mpb+aME5julP3P5p1n+iP22LNX9w5U/Z91eMael3XnmTbH1t+E
fVvpUnzsDD34Cd3g/1zecvZ8o8M5iPxTr3e0l4xFsc3vJ/eAKbrB+Yu6/wsa
4832yUt547ONmNB4WrLrpKNTun6UsV1gyfm/an2TsD0vP3xcew70+Dx28XZi
80KL8xr3vqH1hSX7AO690WY/jmp9a9Z5j5z9raJz9LWRtwY0/iu/n5jvM5+R
jqPStTfv3PnvqvPmP+TrPTXfTX5hHc4Q5+Rr5mv0nqJsGsra55WC/f7Lot/D
W8ACu7GZ/L0yaz7jb3IE/uIe4mFBcBaugecnSn4nbyT37Jrv/AO2yOAqtmHP
K5F7D7ZYPit+HS87XxOz5yJud8nGG6r2yxPKDWMFx/EJYf9ur8+fJM+1G/Nn
m/0OOPmA1veVjSV5lPzGG3bL/r1zHfcP6N0bpPe32vNW0WvIyYHkNHLbWM5+
xEcPSd/r2n8maywLgScxNRA1diRrOW9/UvrvrdjPy8XPm8uu1c/Xm6dw+a5G
y5gPVXyG/eQz8gx5lPw/HvbAm4u/ktf0xg01x+q+0DsTeQkZsUYtpkZSH++M
PM3Z3fLPqPy1Vly5p9t1Gr9cLZ2f7vUbsPfuDtu3JG+csAOM4QI4L5nj+ssd
1JOWsmsKeslr4ACXhqNGt5Yc28Qs6yOxBzzA4kjU1sWRD6e194qSc+GirM9x
LzG5KPLPgZJr/MLg7Kq4i15mIHLeYNb3oRP/kTcfC/7eHvlwRFz7ucYH0ZNk
8o6Fxpr7AHqAm9rdB1BrePdQ3AX+O7L2wSHZ0x65FD6RE8kN68Tfp3rM08mK
+YQt5JjPlfym81r7n8YL9a67zJdFDSVe4Ri5+L6wf73s3VC1rSXpK5adU4YC
W94NrtRt/Ii+D0Mn+eGDiMmKbJgpGdO5JefQpVEbj0W9+4FkKzVuiRp4Nnot
6gU1AL5RA6mJ9BLE2zshPxb70QNGR0LneuE6JkzW5W33WMQafuF+fAOXZ6PO
Uke4C6zIkfTExAh+5Qx+PCh9DxbdpxBHp6Nnhguro/5NaM/HSq7b2Dgbdr4v
357rdn9Mr7Ej+g36ldGwDd9SL/Hv09rbWbC/4Be8Jy/SkxEzxAu4/r3H2BJX
I+EfcOcccQffVwaXXo46Q71C37rQubbgmg0PqHvUReLhGdmzXWON3vCpXvd/
xNSbrZah91/iyECH7SdO4BYcoM5xD7h9reT+abDhEv+wjVr3parjnp5rJnwH
nvcHptgCr4lH7uVO3kSvuzF6YHrnT/bZFzPRv5GL+P74TnyDPFw1ptxPHc7U
bOOw5j/sdh3Dnyejx6S25KIXelUx1VBw/pkJnmEncTkR+ZEaR0xTU+gbL/aC
dY4L3su99OCnQj6s+1fVLuU57sd326NOg8G2qvM78QVXiQe4tKzD31HkhpHI
P8TjbdGDgDlchkfwmTln+b9FcdxQc0+3Ino7+D0YuMITvgXBAh9MBR7E46Oy
p63DuWS3eHdZyb3S6uib2TMa3yzgSKys6TGO9NpT0W+vla9+0ecealeX6wR8
+I1kYxqVNg++x6iX1IfhJnOeOvlg5Ld1Fdda1ocCA+zvUQ9Tnee+mPPowW/0
Qc+UHXvvlY0F719fcI9OT0IPTP6it5kUd6bnOm64f3PUKXLQquhhqE/D8U0K
R8Yr5kl/YA9vO/Wmcp/5+3Z8D3GW3uFofIeC/WDUkV9p75N9/l46Ez04OtlP
jrxYd3XP+o/67f8HhYJljA==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslFUUhg/LtHQDO9OZ6bSdacaqUYgaF9yQrZQULCIQA0KIoojLHzXR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           "],
           VertexColors->None], 
          PolygonBox[{{6220, 5100, 5099, 5979, 1758}, {8336, 4773, 4772, 6541,
            1954}, {6602, 6598, 680, 5899, 6601}, {6142, 5237, 1958, 6569, 
           6141}},
           VertexColors->None]}]}, 
       {RGBColor[0.8635709468072736, 0.8806587826200962, 0.8688099942859211], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFllts1FUQxqeF0m1Ll153wXbbbhujkqgRgxETH6RQaFMIEMRL4EFMEE0o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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWlslFUUhk8702WGmSGdaacd8JthZnBN1Ihi1EQToK20VEPrrhgjJor+
kD9KXWJLqkZoQWqJiVjF+EOImABhE0XAgAsRbcJiEapSCUaNsrgBEkWf1zM/
3uR+3733nPc9283PntvxaLmZdYMwSKbNyotmP8fNjoFfC2YnQU/I7BDfu8ab
Lakz64uaba02S9Sb7c6YfQbirMMps2HWX4IQ6xvOM9uHvd8SZoOcn5Mzewi0
jDFrBdfiL81+Gfsh8AT2O0EfpB6sNBvi7BdgSoXZnVVmf7F3FmyBTzO4YKLZ
bGzsKjObO9asDg5pMMreemzs4e6BGs6y/x7+3uDu8wE2Is7nEDy7Od8FDrJu
h28HKKtyGyNZs4uxvxO9O8BHGdcsrTtZfw9GwWFwFFyS9jv/nwU/8S9GHM6i
ZS0238X/JvA2vleBBdg5lvG9H0Mey0/BJ6WYRhvMnh5n9hSIsD7H+XX8X1ni
tzznOVEuFqPvOHtdtW7rpiqP/fXo+T3hOZjHdydoTXiMxaWLfHZGndObxOat
pNnNMfzxrxkt2+G/DTSx/jDjMZD27eDSvNnl4FTMa6SCuzPgOQfffcR8Pryf
BT2gG3xFLvbBecsYz8kg5yfxXcv3NHIyC673gmq49JPz03DbkXUtqoFmzl8F
5xull+84303UZyOIsb6F+E9mfyl7A6Ah5TlXrh/BfpzY9Aa+Vg2p9q5RzSe8
Bjvg3kaMZ4D2BueuHCj20tCCn6nwmQKmF7x29hKHPRmvoVf4/yKce4ndQtBH
bBaBMOul6F3G/mL2/w77mRPcOQ6eo/cWwXcvseiF80jMYzQ0zmOk2GTQsBpb
m8AEevEH+A9z9+Gc95JsLEDbC6DHvMa3wmsj9jaAD1jfitbTcDgS9RiJS33R
e0+c1mH7PnL0TqX7iAbew4rfWuytxsa/pf5SDV6W95woF6qBq/k+jK+BkGuY
FniNqjYPcH93wTVJy2bsd9R7zBXrdtZXcvaKnPe+auJxuD0Gmsu9Zl9WfQZe
m/vx8RLr/sB7XTG+DX0Xcj7J2Y+J9z/YOpfz3teMmImWRvh+x3oSehu52wSG
I+5DtaQcTy/V1CCx+rzgXA2NrwfOQb6r8dea9R5Rb7SAU1mvAeVeMR4lvicK
PjvlU9xuh2Mq4Rw1a2v4/iXuM/cOYr95vM8G5XBb3nOuXOfZH+T8Sc63VXrN
3l3jPalevIt1egIzECyp8B56Bv/fZH0WjaB3KtyHUp4Lab6H/XDRZ/0q9mu5
mwJHQj4DX+Nuf51rb6zy2m8taVUPqFdUY6ot9cx+bJ2f9Nhr5qhXm5Je2+rZ
P7nTnvbePoqG69i/n+8VFa5Js1Q9rV7WTP0WrpPzPvtVU23USWXSZ4tmTHfW
NUqbZtjXfKeT3mua2XprZqkf4/7mPEn/rw/ctzSugPOZetd2xnzWdoJ5pZmr
2f1+3mOvGR4qlu6Y5+yios8czRrlVL2zLPDaUA+9qn5P+VulN1OzdH5pFmqm
Li94DhR7cZyJrT+4sybiOdRbqjfqYOlNXcidSOC9qDMPpP0N1NunGIq7akK1
IA16S/Qm6y3Wm9JPbgcyXvua8f8B4CUsCA==
           "],
           VertexColors->None], 
          PolygonBox[{{5045, 6574, 1959, 6573, 5044}, {6610, 6606, 395, 6013, 
           6609}, {6219, 5970, 5969, 5100, 1896}, {5245, 6629, 6628, 6024, 
           1000}},
           VertexColors->None]}]}, 
       {RGBColor[0.885129163580545, 0.8878478734749539, 0.859151932490517], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVltsVFUU3QztdO6dYbDMzJ3auTNjKQx8a0ZoE0UStEobYlv0owWJkPgJ
P/hKlJCoiZJgTJw2Kv0APhCjaIixCUPFF/THR6IYXokWo/4YoP3g9UGpa7H2
x8k999y919l77bXPuV3bdw3tTJjZjxiLMbYkzfakzEbxnAnNOgOzdfhQDjS/
sshsODbbjFHE+xLYdOC5FzZ9bVr7DzZHfJ1zYt29z2wwoeeCzx8BxtlusxB2
b3WapYpmB2A7lTbbuMTsoRazCxmz44FsiPdxqL3Ot5v9WjVrwrbRavYZ1mex
15qs/B6DzQDi2YT1Ot4j7PngUmBj/Wf4/YIxCd+gbPZOTjk2PbYTGIUH4IPR
gv1n4TeH8Uqr4mA8TdjXMsLMJeTD3EaSWvukResfVMxuYsy3aO09xHQKvk8t
N3scox95Xr7f7F+ML/DtCdhurCjuBcck9lG8/xWK/zrsZjGfZjzII13V+2Bk
dgO+lzEvBXqSK/JBnsjJymVmv4Pzf0LVOU6rPpPYfxj8/4F5X1pxMt5zsGlg
bTd8t3aZZfPikJwTgzx8Dt+vcqr/p6F8aM86cu/1mK8Hdjov+zhQfMyF2LTf
gPnyktmb0MFH4G0c62NJ8TmNnH6oqMZTzvv0Ir0zDmJSO4dj6edb2I7G2uM7
zE9VxB/12x6q1kvzyod4VawnM9IPYzxTEeYh8HQY42VoqierJ/tjNWxXZVTf
12A/WRYu69V0bfN50ufUJN/JBXWQDhT/ppSwiPMicn+ppJpQa8Sn3m4XzE4j
nmMeP/VI3tZmhU/sF1D/Xe2q2x18nwnEJ3VCjbDu5JHrrAV5OepaulkQR3z/
CTX8piLNvIE67MU436b+YT2HEtqTezMv9mjTa8xaHPMebLpmuT4HTR4Ahzuz
8utxX+bHNebY698Y60nnkHndRV7zGFewx1hRNWO9qBf2LnNkb3akxCf96cd8
z8LvQrs0OOA5MP4IsfRE2ncf8v2tKk7u9WFSdsRjnYjZCf9SWpp8t6B+5rcE
4umt6hv7hD3NOlIf7CfmWEOvNYrCoZapaeJMuLY5H/H5Bu8F6pdxjro9v1Ob
T6bE7RFgvl+UzRA0PogRoZ7fI65bBfUf+bqYEQ88P0YdZ6gDw3uceY17rLfg
uxmc/A3fbcB7LtZ5zzPp9bzOpTq0ORwpDp5/PJfZR+OOxVwY+4TntTYS1+SZ
emad2Lc93kPkh3qcz4h/9iD7gtw+C99V3ertGdTo4S7ZHcTa7Uj+1xHz05Hu
qOfx7C2pn2p+XpNzxkoM8rYdNrUVuD9adT7Tjlr6Er37al732KPIOyzrjGds
I16XgaK4I2/U7Zz7s+bEY915j93zh18R8/0F6Yh78e6hRvYDe12sPPuB17rM
MWH/TKRY2bMXHZu6aHgMY84t33fAfl+kvtmD2K+hTsfb1ENrvI+uphUbcYhH
XOphoajzus/3oVZow7juVBUbz/6631Ps+4ZrcitstsQ6v5nfhxXlSIyrjnPJ
MbkX75ZOv194d5X9zOcerDfrQs1Vve7sP+bBPQPE8nakXMh5zc/JHO7kPMbi
jO6f0O9i/htwjf8bNxDb1xX9K/AM4llEjU1h7XpB/yZ13497Uderu6UXnmeX
vHeolx2ReJzw3iQXfYHOFHLC/Gf93+CE3//c6xB4OhjLtg79/pnT2cxeJfeM
k7jULPNiX/a7xv4HLjpLvw==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlU1s1GUQxoe29OO/7Wrp7n9Ld7sLrQrxXmKb+FGjVLEhUj6iCBpL1Btc
xGJE5KCJEDUa8aBcgAP4GSMoB1KEaikmYlVQSjBKjZ4UxQMFDlT9PXn2MNl3
9p2Zd+aZZ+a/cHjT0MaaiNiM1CG7ChFvIaO1ERNzIr6aHzG3jTvkJOdHSxEP
IR1NEZ3IPs7750UMEWR3fUR/V8RUa8SRTMSylohb2yN6FkZcb464h3hHyxGn
iLWd+AeSiHH0VzojLnH3Efphznfx/p3ct6Lfzf39xHyAWD0kOIP+VMH+09x/
V4n4F7nIe+d5YwX5/Mf9QENESn5T5PwTch45i3yLNJJvAzLJ+W9kjHyeJt4n
+KzDfy1SxLeEZHMRd9xErBuNyS/YDpLjhSbXtAfbZmocxHeA/z7j/igx329w
DsfQl5Lz8sQ2vWlEoTuivTFiy9yI3IKIN8j3D+qvJV4LeU3j/zG20+CZ8FYe
/M5xlxB/Fe/Vt9u+gH6a2s8go9TfT373dlVj1Bsz+TZ1Gk/FWIK+s822s+i7
yeW21LlszIJrh3NWrlPIPu73IOuIN8L9l9RyLe9efZi49pmcbeXzZzHiG/I5
TD5nVSPxHoEPa5ERncn/Cv7vJsY4g/9W/n8OSTi/yO9LHebSOzXG/gnivVfn
Hoh7W3Pmhji4HezOgNdp5IVCtTdtrk09Gsa+AMb16BX0z8l/iHp/TZzD9xVz
SNwRZ/vIfwD7xejLyX8Dto+nPh8Ao9Wcbwbf3/Hdhb6G+G0L3Lt24q9Gn8mb
29KvYb+ZmNsajeEN5HiKXL9GspyXlc1xcVsc2YH93m5j3Zs1F1ek5rrwehg9
z3t1za4/Q+5NyAS5XMImQ/39xD0iPnO/E99h9ZhYfVm/rZk+Wc1hPbbbcua+
OLMSfUvO/P0Z/Qd8by+Ze6o56NHKkrknfo8R4wQyjhxHlpLbP6m5tIgce8mt
hphFsO1AFhNvTWrs7gOTZ8CmlvtSxhgpV2Gg2pXzj9wlFdfW0+C3hKGwG6/u
pqnqbGtHnWv1DtLu0UxolwgTYaEZ0OyMgvf+xDP0YGpMheUF/luVmjPiym+J
d80h/FsS75yXud/QbSyFubj0WMm7UJxKqf8g/L04xz16m7degw+zdZ75WWpZ
BH/+ynhnifuakZHqDFzOm0PijnLcRD1LqO117RPsr+Y9Y5qtD7jvI15X0bMi
jBV7ODVX9cYOMLlcdm2q/zr2t8zzbs80eXa0EyerM6Rd+EXZsbUT1Rv1UL1T
j1Tb+pJ3o2rUbtUMava0Y6/ge7Vs7FTz8zlzTNzSTtMs9hTde82kdvGn+B2a
752s2ROHxB3N4Jv47i15t+obc4LYE2XvHnF8suJvjL4t2jnaFU9WjJV2xjFs
j5c9O+qfdtFYlavaSc/mPMPCWz3Wt+jVTmOjb5JmQZwX1zUT6oU4KS6qJ9r1
gwXPiu61y4dK/vaIX/8DX7EDFQ==
           "],
           VertexColors->None], 
          PolygonBox[{{5365, 6155, 6154, 6787, 2007}, {6580, 6582, 1757, 4613,
            6579}},
           VertexColors->None]}]}, 
       {RGBColor[0.9066873803538165, 0.8950369643298116, 0.8494938706951128], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtIVVEU3alP8159/p7vmd73bn5oVLMQKkhrENFQC42ij6/PLJtoVkKB
BRVG9JurgyCLRv4wS6WsIKWBKU5UJGgSiFSGg6DWap0Gh3vOuXuvvdfea5/K
ltaGCxlm1o2VidUWNUsXmi1mmUVyzF7hcggG9yNmxZ7ZV5zbYXOmULbnQrOz
WAd8rdx8sz+5ZscTZpdiZiuw74ffMu5TuM8rM+sJzHYCf7oE+CmzJsTJwjqI
/7VZik/894hZD5yhpNlstjCWHM6HLfDHeg6/SeBdK8U/+A76sqmH73msMU9c
Rj3lyz3t+I/7p57i034EeKPI6RDOY8gru0z7RuBbmbg0R4R1eZO+L90+jJvN
pXQmj0pfXOi/iHzq4Pe9yuxHlc5Pis36Atleh9/2uHLaB76+47sLdc3E+SL2
NdjvcDbkt+w4Rj3FYQ7parNbsFnD3YAvXozrI/f1mGp+NCI88uCZdR9EfwPg
FXjC4x0xeb+A/Z7N8nuAXJqQ8xfUYQq1msR6hv9HcPezVLFulpvdKJcfF/2I
5SH/Ofh3mXKhDhh/1VM/2IuMhDgzv6oKs92hYlNv7B1zNk+6pCZ/IeaxQHVo
g/1GXDas/YLjQC0Sn3E7kFcn1nyO+tnh9DkOjFiJMKk7xqP2qGXGI0Z/tvJl
TTYQ9w16th82JSXypy/rQjvaNOPuRKB5YT/STs/UbiRP8zSDPKd99Y46HXVa
pe4OB9JOAzi9TsmePecske9p/D8VCC/DUy6c1RZo4E5csVh71oP4/ZXQOlYy
X/E5y8RkLb/58q11+qB9L3BuOxzO994azXchajYRyJ51YX3IvRZaaC1SnXvg
21etOlK/7RXqKWdjxvEl76ibnRf43ssRhzrEuRLT/27MwduU+N1N6sw9/1Gv
/7XPL2v+DrZTKeFtw3z9DsVtGXdb46oxe96YUN/pV+B8WRfO3L/3Lab3izZX
sR9Iyo41iMZUB+qSnFgv9pyaoj7IY9gXF/Z8zfX0M2ozHep94lzyyz6yn+wh
e8E3gHPOGV8JVQtyXXJzwtoSb9VhDiOvkaR62RmT5pj/PGJ9CpXHBLiPp/TO
8V3he0qeS242/ms+7d7zXmA8TOgN4Kx3JaTrx/g+SkgvnHly5v16qeafs/8R
MWeL9PZw1qkJ5nwykI7JMRc2figOjEfNU6PUGrVLvbG+zI2+fwFuS+w+
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE1I1GEQxh9W19zd1NxdP1Z3/9sqBB261aUOVoeI6lRBgfQNdcsuWZSQ
YUEUEX3d1UOkRSdXpbRcyoJaMfAjoTIs6FAQ0RceOvSbxsPA+74z/2eeeWbm
nzvctvN4SNJ2rBTrqpMmUtL9ZdKnEqm1WjrdIM1y7y+TLtVKkaz0LSp9x7rT
Ug9Win8tAIv4u5ul9kppb1hqwXc1I4WIHQVvBrx14F8jfgq8Ke6r66U93Adi
0gVyNTVKG8qlOd7OJKW7OSldIRXxryd3CI4nyjzmNViRuFSOTXKeDqQsHB6R
7yE2x9s77C32Bivn24sNjp0DLwZeFOuS11RJvn3ki5BvC/4CeH9qpI3U0m+Y
CelHk/Qe/zYwDlLfDnKHl0tBROpNew7D3sr9Jdivsl5bCxh/s66JafGVtzh4
N+pc6zyN2I/vAHad2M+8dcA1Vu/aWg/a0eZko2trGvSidQ/2IuyaT4J/Bb03
cx8CfzdYu7CFEuf7lHqeYw+iHlMk/gt489STJ35lrWto2o1gVehxG35hvhX3
PNj96JOpcH4/m7xGq800aaOfR7OunWn6BKxiwvvbx/fj3GNJ779xGINbAv9g
yDV5hn+xxrnZzDwOvAemvWkySP6OpOe2+bFaVyT9W/vmPFyn6fMU1sm5Ffyx
wHNbD623VpPVYj0+xXk45dqYRqbFobT30jQxrpvqPJdxttmdrXZt7V6Fb5y3
e0v7MkOuj9Q/EfMZtNkzTsbFZnA44xoa/3jUZ3+62rU3jQop3znbNcO8TD+O
NPuuWY9t1vPEDKR85tfg/xB4r47hH+X8u8b78X+nMj5jNltVxNyCx6q4z571
NImvQL3zpd4D0852anJJw76c76zVbz0vS/hO2S6FOd8E707cZ93+AbarZ5Oe
y3bWuA5hg0uciynXzLSyf4ztzlDGtbAd+gX3kcD7YTWYlgtZ333T9Bz+zsBr
Nc7/AEORtnE=
           "],
           VertexColors->None], 
          PolygonBox[{{6583, 5238, 993, 5971, 6582}, {6605, 4870, 4869, 6600, 
           1964}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{2995, 2994, 323}, {4124, 1586, 502}, {8162, 7893, 
           1586}, {2401, 2402, 325}, {502, 1590, 323}, {494, 1590, 422}, {
           1590, 1591, 422}, {2576, 2401, 325}, {2403, 2401, 422}, {1367, 
           1591, 502}, {2759, 1592, 1367}, {1591, 1592, 422}, {5136, 7563, 
           2561}, {7146, 8140, 2261}, {2680, 2403, 422}, {5238, 6583, 1960}, {
           2401, 2576, 494}, {2758, 2680, 422}, {1961, 1759, 881}, {1592, 
           1591, 1367}, {2401, 494, 422}, {4883, 7360, 2402}, {1590, 2261, 
           323}, {1759, 997, 881}, {6608, 6612, 1965}, {6605, 6019, 1784}, {
           6453, 4565, 325}, {4684, 7264, 494}, {1784, 2329, 491}, {2759, 
           2822, 1592}, {2822, 2758, 1592}, {4565, 8617, 325}, {4030, 997, 
           491}, {1795, 996, 491}, {6034, 4882, 1795}, {2995, 4031, 2994}, {
           2329, 1795, 491}, {997, 1784, 491}, {8138, 8947, 2995}, {5243, 
           8616, 996}, {997, 4030, 881}, {7808, 5503, 2680}, {4030, 4031, 
           881}, {2994, 4030, 491}, {7563, 8143, 2561}, {4566, 6453, 325}, {
           2402, 2561, 325}, {7607, 4684, 494}, {8161, 8162, 1586}, {8946, 
           5050, 881}, {8616, 5242, 996}, {4870, 6605, 1784}, {4031, 4030, 
           2994}, {1966, 1784, 997}, {1586, 1367, 502}, {1759, 1965, 997}, {
           6620, 6616, 1966}, {1591, 1590, 502}, {4123, 2994, 491}, {2994, 
           502, 323}, {4124, 4125, 1586}, {2994, 4123, 502}, {4123, 4124, 
           502}, {6584, 5239, 1961}, {7361, 4884, 2403}, {4125, 4124, 996}, {
           6185, 4563, 323}, {8618, 7605, 2576}, {8139, 8138, 2995}, {4031, 
           2995, 881}, {996, 4123, 491}, {5663, 7892, 1367}, {7265, 7146, 
           2261}, {4882, 7604, 1795}, {4124, 4123, 996}, {6583, 6581, 1960}, {
           1592, 2758, 422}, {7892, 5664, 1367}, {2261, 1590, 494}, {7903, 
           5677, 2759}, {7605, 7608, 2576}, {4564, 6185, 323}},
           VertexColors->None], 
          PolygonBox[{{7255, 6034, 1795, 2329}, {8143, 4566, 325, 2561}, {
           6616, 4870, 1784, 1966}, {5980, 5238, 1960, 1759}, {7360, 5136, 
           2561, 2402}, {8140, 4564, 323, 2261}, {5242, 9279, 4125, 996}, {
           6612, 6017, 997, 1965}, {9279, 8161, 1586, 4125}, {6019, 7255, 
           2329, 1784}, {7359, 4883, 2402, 2401}, {5050, 6584, 1961, 881}, {
           7972, 5676, 2758, 2822}, {8947, 8946, 881, 2995}, {7264, 7265, 
           2261, 494}, {6581, 4617, 1759, 1960}, {6017, 6620, 1966, 997}, {
           7893, 5663, 1367, 1586}, {4884, 7359, 2401, 2403}, {7604, 5243, 
           996, 1795}, {5664, 7903, 2759, 1367}, {7608, 7607, 494, 2576}, {
           5239, 5980, 1759, 1961}, {4617, 6608, 1965, 1759}, {5503, 7361, 
           2403, 2680}, {5676, 7808, 2680, 2758}, {5677, 7972, 2822, 2759}, {
           4563, 8139, 2995, 323}, {8617, 8618, 2576, 325}},
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6584, 5239, 5980, 5238, 6583, 6581, 4617, 6608, 6612, 6017,
            6620, 6616, 4870, 6605, 6019, 7255, 6034, 4882, 7604, 5243, 8616, 
           5242, 9279, 8161, 8162, 7893, 5663, 7892, 5664, 7903, 5677, 7972, 
           5676, 7808, 5503, 7361, 4884, 7359, 4883, 7360, 5136, 7563, 8143, 
           4566, 6453, 4565, 8617, 8618, 7605, 7608, 7607, 4684, 7264, 7265, 
           7146, 8140, 4564, 6185, 4563, 8139, 8138, 8947, 8946, 5050, 6584}],
          
          "1.65`"],
         Annotation[#, 1.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7030, 5891, 7993, 5890, 7994, 6946, 6788, 6789, 5896, 7330,
            4774, 6035, 7329, 7328, 6156, 5365, 6155, 6780, 6776, 4443, 6593, 
           6597, 5903, 6604, 6600, 4869, 6615, 6619, 6016, 6611, 6607, 4616, 
           6580, 6582, 5971, 5240, 6144, 7251, 7252, 6150, 7868, 5620, 7253, 
           5621, 7869, 5068, 7871, 7872, 7259, 5622, 7873, 7870, 5714, 7263, 
           7262, 7256, 5244, 7606, 5952, 7435, 5953, 5131, 7877, 7878, 7875, 
           5624, 7876, 7564, 7565, 7231, 8188, 4646, 6036, 6037, 5135, 8541, 
           5134, 9278, 8037, 8038, 4463, 6454, 6101, 7946, 7947, 7945, 5768, 
           9059, 5770, 9058, 5769, 9121, 9122, 9120, 5880, 7029, 7030}],
          "1.5`"],
         Annotation[#, 1.5, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8983, 5689, 8982, 5688, 9115, 5872, 8262, 8263, 6970, 5729,
            5731, 9254, 5730, 4647, 8189, 8190, 8144, 8145, 4567, 8769, 4568, 
           8147, 8146, 5002, 8502, 5087, 7500, 5086, 8501, 6186, 8142, 8141, 
           7147, 5623, 7874, 5057, 6638, 5246, 5981, 5245, 6629, 6624, 4621, 
           8773, 8777, 7746, 7754, 7750, 5055, 6784, 6787, 6154, 6779, 6775, 
           4442, 6592, 6596, 5902, 6603, 6599, 4868, 6614, 6618, 6015, 6610, 
           6606, 4615, 6579, 4613, 6219, 5970, 6226, 5964, 6589, 5045, 6574, 
           6143, 7249, 7250, 6033, 8212, 8211, 7254, 5241, 7603, 5991, 7925, 
           5713, 7258, 7260, 7261, 6834, 8214, 8213, 7257, 5712, 7924, 5001, 
           7433, 8469, 7434, 7230, 9171, 7229, 9172, 4645, 5717, 8999, 5718, 
           9000, 5715, 6965, 8215, 7266, 5716, 7927, 7926, 7832, 5518, 7833, 
           5517, 8983}],
          "1.3499999999999999`"],
         Annotation[#, 1.3499999999999999`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8964, 5650, 8962, 5649, 8963, 6054, 6136, 5027, 7836, 5520,
            7835, 8908, 8907, 6862, 4763, 7986, 7987, 7985, 5887, 7032, 7031, 
           4837, 9078, 9079, 9075, 9077, 9076, 6835, 4762, 7492, 7493, 7490, 
           5070, 7491, 8094, 7112, 5519, 7834, 5005, 7160, 7161, 7162, 5132, 
           7561, 5133, 7562, 4888, 7071, 7557, 7558, 7560, 7559, 4439, 7096, 
           7095, 7094, 5502, 7807, 5501, 7901, 5674, 7899, 5673, 7900, 4630, 
           8587, 8588, 7567, 7569, 7568, 4880, 6502, 5909, 5910, 5237, 6142, 
           6578, 6573, 5044, 6588, 5963, 6225, 5969, 5100, 6220, 4614, 6201, 
           6013, 6609, 6014, 6617, 6613, 4867, 6598, 6602, 5901, 6595, 6591, 
           4441, 6774, 6778, 6153, 6786, 6783, 5054, 7749, 7753, 7745, 8776, 
           8772, 4620, 6623, 6628, 6024, 6637, 6633, 4876, 8634, 8638, 8622, 
           8630, 8626, 4447, 7577, 7581, 7573, 7589, 7585, 4773, 8336, 6546, 
           5364, 7248, 4676, 6122, 5600, 8943, 8945, 8944, 5069, 8493, 8495, 
           8494, 4678, 6964, 4677, 9173, 5710, 6127, 6126, 6102, 8041, 8040, 
           8039, 5468, 8862, 5467, 8964}],
          "1.2`"],
         Annotation[#, 1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6939, 6860, 6859, 7007, 6861, 4644, 7228, 7227, 5687, 7909,
            4881, 7902, 5675, 7199, 8177, 8178, 6896, 7198, 7197, 7196, 5672, 
           7898, 5067, 7487, 7489, 7488, 4675, 6032, 4674, 7245, 7656, 7655, 
           5186, 6814, 5460, 6501, 7064, 6496, 4438, 6566, 6569, 6141, 6577, 
           6572, 5043, 6587, 5962, 6224, 5968, 5099, 5979, 5975, 6205, 6206, 
           6145, 7190, 6018, 4866, 6990, 5899, 6601, 5900, 6594, 6590, 4440, 
           6773, 6777, 6152, 6785, 6782, 5053, 7748, 7752, 7744, 8775, 8771, 
           4619, 6622, 6627, 6023, 6636, 6632, 4875, 8633, 8637, 8621, 8629, 
           8625, 4446, 7576, 7580, 7572, 7588, 7584, 4772, 6541, 7017, 6545, 
           5854, 6538, 6534, 4597, 8596, 8600, 8592, 8608, 8604, 4810, 5202, 
           9215, 5198, 4451, 5206, 9219, 5210, 4854, 7597, 7601, 7593, 5211, 
           5958, 5212, 6547, 5020, 5601, 9164, 4558, 6187, 4559, 9165, 5845, 
           6900, 6899, 4679, 9174, 5711, 4607, 5025, 5003, 8470, 5004, 4890, 
           9184, 4889, 4500, 4464, 9146, 5469, 6058, 6057, 7081, 7080, 8965, 
           5651, 8152, 8153, 4574, 8975, 4573, 8151, 8150, 8472, 8471, 9130, 
           9131, 7444, 5008, 7166, 7167, 7896, 5670, 7179, 7971, 9105, 5856, 
           8978, 5669, 8986, 5691, 8984, 5690, 8985, 5858, 7882, 5644, 7881, 
           5645, 7884, 5647, 7883, 5646, 5850, 9259, 5849, 6938, 6939}],
          "1.05`"],
         Annotation[#, 1.05, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4468, 8044, 5474, 8864, 5931, 8867, 5476, 8865, 5475, 8866,
            6063, 4470, 8431, 4939, 8430, 4938, 5486, 5485, 8875, 8874, 8087, 
           4937, 8429, 5484, 8873, 8872, 8086, 4936, 8870, 8871, 8050, 8051, 
           8052, 5827, 7960, 5828, 9090, 5657, 8972, 5656, 8973, 5665, 9104, 
           5855, 7174, 8165, 8166, 6947, 4611, 8168, 8167, 8977, 8976, 5936, 
           7008, 4966, 6080, 6822, 6821, 6820, 8149, 8148, 7163, 5648, 7111, 
           4514, 6039, 4513, 7110, 7831, 7830, 4965, 9302, 6071, 7145, 7944, 
           5766, 7943, 8332, 8333, 6897, 6898, 5804, 7010, 5947, 9288, 5948, 
           9289, 5805, 7953, 9300, 7952, 7864, 7866, 9159, 7865, 5018, 6763, 
           5956, 5957, 5187, 6969, 5728, 6525, 6521, 4724, 6506, 6510, 5459, 
           6500, 7063, 6495, 4437, 6565, 6568, 6140, 6576, 6571, 5042, 6586, 
           5961, 6223, 5967, 5098, 5978, 5974, 6204, 5049, 6199, 6149, 7185, 
           7189, 5191, 5996, 6526, 5992, 5800, 9183, 4835, 6989, 4834, 9182, 
           5799, 5342, 6151, 5051, 6781, 5052, 7747, 7751, 7743, 8774, 8770, 
           4618, 6621, 6626, 6022, 6635, 6631, 4874, 8632, 8636, 8620, 8628, 
           8624, 4445, 7575, 7579, 7571, 7587, 7583, 4771, 6540, 7016, 6544, 
           5853, 6537, 6533, 4596, 8595, 8599, 8591, 8607, 8603, 4809, 5201, 
           9214, 5197, 4450, 5205, 9218, 5209, 4853, 7596, 7600, 7592, 8614, 
           8611, 4601, 6550, 7776, 6554, 5385, 6562, 6558, 4814, 5220, 9223, 
           5216, 4455, 5224, 9227, 5228, 4858, 5236, 9231, 5232, 4605, 5285, 
           9235, 5289, 4818, 8708, 8712, 8696, 8704, 8700, 4459}],
          "0.8999999999999999`"],
         Annotation[#, 0.8999999999999999, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8057, 8056, 5496, 6828, 6827, 7963, 7964, 7962, 7961, 7105,
            4950, 5495, 9151, 4474, 6826, 4472, 9150, 5834, 5492, 6825, 5832, 
           9291, 5833, 5489, 5831, 9256, 5830, 6824, 5488, 9093, 5829, 8053, 
           8054, 8055, 6823, 8049, 8048, 8047, 9092, 9091, 4935, 8428, 4934, 
           9244, 7806, 9245, 5473, 9282, 7837, 5522, 8909, 5523, 8910, 5521, 
           8960, 8961, 8957, 8959, 8958, 9103, 7407, 7368, 9295, 7369, 7367, 
           4887, 7431, 7432, 7428, 7430, 7429, 4434, 4497, 8079, 8080, 8468, 
           8467, 5000, 7705, 7706, 7704, 8767, 5352, 9280, 8133, 8134, 7729, 
           5353, 7728, 5354, 6031, 6030, 7325, 7324, 7784, 5391, 7723, 8366, 
           4850, 6768, 7889, 6772, 5661, 6762, 6758, 4593, 6514, 9010, 6517, 
           5727, 6524, 6520, 4723, 6505, 6509, 5458, 6499, 7062, 6494, 4436, 
           6564, 6567, 6139, 6575, 6570, 5041, 6585, 5960, 6222, 5966, 5097, 
           5977, 5973, 6203, 5048, 6198, 6148, 7184, 7188, 5190, 5995, 5194, 
           6530, 5084, 5599, 9163, 4556, 6217, 5377, 9243, 5381, 5313, 8731, 
           8287, 5753, 9179, 4757, 6846, 4756, 9178, 5752, 4510, 9152, 5511, 
           5056, 7176, 7497, 7498, 5085, 7499, 6020, 6625, 6021, 6634, 6630, 
           4873, 8631, 8635, 8619, 8627, 8623, 4444, 7574, 7578, 7570, 7586, 
           7582, 4770, 6539, 7015, 6543, 5852, 6536, 6532, 4595, 8594, 8598, 
           8590, 8606, 8602, 4808, 5200, 9213, 5196, 4449, 5204, 9217, 5208, 
           4852, 7595, 7599, 7591, 8613, 8610, 4600, 6549, 7775, 6553, 5384, 
           6561, 6557, 4813, 5219, 9222, 5215, 4454, 5223, 9226, 5227, 4857, 
           5235, 9230, 5231, 4604, 5284, 9234, 5288, 4817, 8707, 8711, 8695, 
           8703, 8699, 4458}],
          "0.75`"],
         Annotation[#, 0.75, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5494, 8444, 4949, 8442, 4948, 8443, 5491, 8439, 4945, 8437,
            4944, 8438, 5487, 8436, 4943, 8434, 4942, 8435, 5483, 7388, 4933, 
           8427, 4932, 9274, 7805, 5472, 7387, 4928, 7103, 4927, 7386, 5466, 
           8135, 9166, 8136, 7867, 8137, 4562, 6038, 4561, 8481, 5023, 7447, 
           5024, 6100, 6099, 6818, 9056, 5764, 9055, 5765, 9057, 5763, 9054, 
           5878, 9119, 6002, 7033, 5801, 6993, 7337, 4836, 6991, 6992, 5803, 
           9074, 5802, 4720, 6029, 4719, 7297, 7769, 7768, 5281, 6813, 5455, 
           6701, 6697, 4433, 7714, 7718, 7710, 7727, 7722, 4849, 6767, 7888, 
           6771, 5660, 6761, 6757, 4592, 6513, 9009, 6516, 5726, 6523, 6519, 
           4722, 6504, 6508, 5457, 6498, 7061, 6493, 4435, 6563, 6137, 6138, 
           5707, 6963, 5040, 6221, 5101, 5965, 5096, 5976, 5972, 6202, 5047, 
           6197, 6147, 7183, 7187, 5189, 5994, 5193, 6529, 5083, 5598, 9162, 
           4555, 6216, 5376, 9242, 5380, 5312, 8730, 8286, 8291, 9041, 9037, 
           8901, 8721, 8725, 8274, 8278, 8282, 5735, 6810, 6975, 6971, 5435, 
           6811, 4735, 8378, 4872, 8376, 4871, 8377, 5363, 8768, 4557, 5949, 
           5767, 7326, 7327, 4769, 6983, 4768, 7978, 7979, 7977, 5879, 7012, 
           7011, 7013, 7014, 6542, 5851, 6535, 6531, 4594, 8593, 8597, 8589, 
           8605, 8601, 4807, 5199, 9212, 5195, 4448, 5203, 9216, 5207, 4851, 
           7594, 7598, 7590, 8612, 8609, 4599, 6548, 7774, 6552, 5383, 6560, 
           6556, 4812, 5218, 9221, 5214, 4453, 5222, 9225, 5226, 4856, 5234, 
           9229, 5230, 4603, 5283, 9233, 5287, 4816, 8706, 8710, 8694, 8702, 
           8698, 4457}],
          "0.6`"],
         Annotation[#, 0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/H3GPlDYmYM28y5CRmjUCQLMRryh2MJw0aOua8/xF8ouTLH
H+Qqxzab4x/XiHIU8Ydy/rGEsrVNOUs8fn88f6/v+/M+P+9Pv+xFq2euSoqI
dn5KO0X8zo74i+9o0zsiCc9TIs6nRnTsG3Ga/hG3krZnl9Of/GW0HXsJLeEv
psnshfQp/4n0iJNo2yWighZnRszHPPwQ/zYrYq7v6Cm2c8R1cQ/7RFTx1fDV
4grGq1lNq7BZXIY5M9ETh9lp5r2tZ0NGxFX6lV6jjXRqr4gx3SNusQvoZIzC
BIzDx64RX3BB79fqnKNvnA81f578ERiMan1y9dtntv7iR4s7Q0fSsT0ijslZ
mhYxR7/ZmIFU9TriAQrdqwiLnBcj3dldM7WWn+5+/3xP6hbxRP3H4t4n5tBz
h71N5ivTq4Cm2FUHtBKbj+G4Ie6APR7EftxTuw7P5GS5R7OzFjSh0Izf6BQ6
zNyFak3FZ3aO/ebKGYjDfAv1LjLHCroM5WptpFsTbyl+HR1q1jW0ydwldlCK
Hnxr6XN9VtFmebm+hyAD/ZCNIjk5/IMwXZ98etzcefS+nHp7/4RX+IA3eCSn
t3715htAG8Um20sTbUNT1X1PO9N3dKB6JfbTytslozWOqr0+8Wb0nfm/m/eE
HVSwJzrf6332YDd28jXaRwNe4CWSkG9XQc/KP6V3mh479dyFm2oc4i/BYrxW
eyz/Hed12CZmO7ZggXtvpZVqVaGMfc7MpfSIu27ALT2WswvVaDbTNNpCK8Vd
xhV5m8TdFrdW3BB2jfNaVCX8qEaN8y2J/7vcWWr8ojPpNb7ruIoNif+qmEvm
vIj/klyecQ==
           "]],
          "0.44999999999999996`"],
         Annotation[#, 0.44999999999999996`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01to1nUcx/HvtqQLIXErm3Nte3ZS0vnMdvDRtmrmIYu1soKwtTyggmsb
EtoYlKBg3WgsXXlEFLOVtotuvFgGbpkW1IVjODUdK0z0whBDEFJ6/S/ez+f3
+/6+p9/3+f1Ta7pWdGZFRJ2fb5+IKC6POEFH8iLGSyO+s75MT9JrtHF6RCY3
omNGRC19tCQiB39Pi+gri7ggLp0fceVJ8Tgg7oK4LxMtiJgtpuypiJkoRj//
ilTEjqn2/Ofy28b/abqDviBnAz4Wl9HbgyK1CiPaxP1JV9Jefn3YiefFLebf
rp+s4oguOokOPh4xqv4puoxmsAjP4S91b6Bf7Jgcx+gl9rSa1XqsxRwMqDVL
rzv1WsF/Ab+jtI42msdeMevUe9s83sRryJNvCobxir5asJq9FflsP+onW3y+
uz20Xmp2v8h/nt8fSR9qbk1mzv6q+7ZgnvUzaFbrrnlU8q3AIXG/6ucgPauf
36y3iT+tr+10lTusxrt4D234yWyGMYQr6t3W02VaJl85SlCKFL5K7krrUYsM
5mOlPmpoK51L36Fp2qXv23pZq/4GFLBvor/ruYP+Y76zrKtQiHKUoEXMzOSt
oFkvNXSfvqrpGTET+r6OUVzFJZwTk1Jvwr0r6UVxaTobTWIKaFGyNuNptBW5
aBa3T8wd83xLzGE1svncs+8RN+YeA/YLzX0Bcqy71Ss1rxSq8dC9tpjNZvTI
NZbc0/oL8fOdZ1CPOuyX41/nS/gtxhH1ctiykYUiZ48l35E5jOAsW5W38TMd
wudy9GK3vjuxxvoi+xt8GvzHP8i5h+00bbQfc9Ytz4fo4/8B2p1vRFtyX3N9
kd9J/XaydWAD+6AejiXflf0i57e81/XsVfzm4CP5m9hPWK9j7+f/TfJG8DWO
J++Cz7h6/9EHOC/HOUw1v9f1m0t3yTHdN/UZzbNfqM+0s2yze9Y6i05yh0fw
PmqdtdNbfG9ish6/95+8JO9yvIz7/tdP+XyC/wECtKxW
           "]],
          "0.3`"],
         Annotation[#, 0.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Ftsznccx/EvXTas61BFHZ4enkcbRZuspURrRCI0ZkKCppZsIiQOFZbM
hbgo6qoXgmws6tSLisSFGwkutgwlkokiqywqLetYiFOJQ5ptr//F+/n8ft/f
9/T7/n95itZsWdY4KCLq/JwdFfEyP2IXTY2PKMI7+2HpiDd09ciIrWyraGlh
RBpPRkccdv6cvT9hTMRbBPvb4oiBvIhs9qVi1k2I2IAfUhHb0Mbejov8f8EN
db+Xczt2oEH8SuwWu09cC3rZ+/APuvFyYkQhnwzW22/EFjyTa7oar+gseo3m
q/XVuIihejuZG3FT3yF3uX1/gXPr13SFno/I14rv7DeNiOjS31b6mXo5yMZw
fI6/+DzENXU+lesqHUYHxG8T0y72FOqTvHo4jwvo4rffeZpvJunB+d/sj/AY
bXpt4nPJvS+jle0oNovJUnc0RrlDHnIxQ44y55ORdpda53MwG9fdd1kmosa6
Va/X9daiXoqtTu4cM6sV83xsxC32p85v0yG+exZeFUV8Qo+b43CajUb+H/j/
i0V839ADar+gi/U4gk8D8jBX3ESan6zFldFy/CFuEu0RV0g7xN3V4z3cSWaL
HvwqpsI8DunrC7pYXBktwRIxBeaUxnhMRSmeidnk/HfrdViP0+56xl3z5Dxs
JgXudYj2md9Ctir7SoT1IPzHv8n5YOvp4vqdvUar9RFcUqNO75fpMfujCb7D
Rvl2id2Nmc730mbsQb3z93qp8iYeJmpfwT7JdylBr30pTcm5mc+x5L3K24aO
pJ75XqHH7U9ggpmMQYP1t1iidh1+Y8vBSHzNvhwrsVa+n8ylRl9V5nhCjZk0
Q1vMstT9zrjzFHeuRAXK1bsrpo1fl3ztyVvl/wC17PNQjQU451vfoRfoR+7R
qF7QDXS+vuaIbZHjIPahXq1e9/8m+Q50wEyqvcudas7m/yWa+U0W10SnJe9W
3Wa9ZvTaLi6lxxIUo0xcp/o/8uvk/zO9z/9PlJtdJ/+DcvbpZ7B5fIzK5K2Y
RzWt8Q67xc1N3qU83chN/kfsm+n/c6y9sg==
           "]],
          "0.15`"],
         Annotation[#, 0.15, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Ftol3Ucx/HvLE95WC4P0zl3UnG2KWwyUzcX4lBylsrIpSskMjBxZupE
E9FYTtmFkORhHjEYeAJvvCioQLSuQkHdEP9zC48I6UxJdJq+nov3Ps/v+3zP
z2//vM9XL6pPi4gafxqHRrw3MiKDpkZFdKLSOZUfMYOWZUSszIooob1zI9Jw
a3jE7oKIS+9EFGdGXBsR0YH9w9jE/ZioPIVi8rIjxiEbrfwL8tQc4sy/iN9W
/hNoI50p53RsFlc2NqJnjFqjI+rEddFauovfbjSjQtws/iv084rvKvpGTsTP
Zrms/llaRcvwPsrxt7q30Sq2TY5jtJ29WM1JeizBRJxSa7xem/VawH8qv6N0
D98j9EN7mI9qDJJnIHbopc6ursh1gv04XurpJ/bJ+mozw3R5r9Bp9CrdQEvl
K8E9uRucC9U/SSfQEzTfuzzsVKNUH020hO6gxXIX4bQ+T6txCm/rOx2TxbTo
ocP7A3Qh/wX4wq6WY7Ac6/isxbf6fm5f5eIrMAN92D9hr8V2OZqSPOLnidtD
P6B76SR9/27mTv3exGVcRzsu6CvHPeqUYyy9KqaYFqJSTCYdnTyrPZQuwRp3
8wf+T9ytufxf0mdYxX+A9+k4wr8PfWTOXvS8Ogs816AadahFl5j7Yh+g1beo
ljctqWW2DfprQLod/2o/g+kdM65nu0uDX4V7uM65nK5N7oacRXgXWb7fKGSq
8dC+utGJLvyvnzl85uKGcwdSOKxGLlsTvaSHA/ppSXZsznrfZDv7TedbuI1D
zpX8ZmKL8/fOFz0v5t+ix4dmmq33KmzUx6d8PkvivDuMg3jMpx9bX7R5bsdb
Zktz7oUp9vfCNyyl8+TYas5GbEZ/fsv0XYdzavyBHGShhu8w8W/K1+Me9KPD
7TkDKfM/9a5a3iH0vDyZ9M/k98acj+gU+g+tl+srfIkCeXLQrXbK+V7ye4Mu
NNv1Lnyn7sd8lmATewO+wV9y/WY3vyT/32odwxo11mOFuOX4KLlD7D3295/4
V4ny/zeB/QH22dl9s+TLOR6LxXzNvpQ+saP+3j+luWzZ2KZut/MZ+hqTDsZP

           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtIl2cYx/Grwzr4IrIsS81Sa8kSOmGWlC3WAZJqZGZOtqADVHQcxRYd
zPlqwmK5oo2iwwv3ZkH0YjBhBekKYiOhwyj+LelAUaSd6KQd9nlefP0993Vf
v+u67vt5/Oet2LR4Y4+IWOBPfUZEyfCIdJrKiriJMutUfkQpLR4UsS47YiLt
PYoJd4ZGNBZEtA2OKBoWcS0z4gZ+HiLGtz9RdQp5Ro2IGI0cNMnPz9Mz3Vr+
OHm18sfSejpDzWnYwVc8OqIrV6+ciBq+dlpF98prRAOm882Sv8Y87+Wupz1H
RvzhLP/qX4rjcn7ia5N3S98Mex/kFOmRbZZGe1l0H20x0zf4Tt73cn537jZc
xK/WTTimzzE1j9Kj9Goyjz51PNm8H4vtlL8hmQdlPH3FD8jZjwnyms1y2qwT
5d4Xu+T5E+e9TE/w/IYT8lrl/YUW/On8zdir3g9osD8eHWKf83bSR1jpHEv5
q7AE3c5bSd/SxWZ9RyvoLefv1PuaGTqsr9M53uVs3DT/fyjw/q+IF9FClPFk
0uzkWZ3BtBrLMIuvkv5opsnYx/9cbB7/W/oa6/nT5AzAEf6P6BN334O28izy
XIFy1KAK7TwPeDvQ5H7u0c3u4w4t5/lUzmys8319jY04w/OL7zQlZ5GzLUSF
O3jnfmrdT7r83fS2Oofc5eHkvao1lXcaSnDBfinttteFuTxzkKZGf5y3P8X+
32YaYf+UuxwuPgyZGCt+Xc953v1dWmw9Vfy13DcodD955ixJ8s3Zot5J+pX8
/uZNS/7/nGEmPkOOvW/lV5t5l1qVtI5+SR+64z7qddIC38Iz+lS9ELvnuYq3
23yvMMldz1en1uz12IF+3sVyM9XgrF7nkIssVMjNUKeXXl1m6kuHqJeOlDt7
aa9c3YG0VZ1Mej75TXHmJ3QyfUQ3qLUWq5GvTi4e652yvp/8pqAdDck3jjp9
K+VUY7v4NmzBP2qddkfNaNLrODbrsRVr+FZhYfKdiXc5+wv+94nKf5og3oGD
7u2Bs+SpOQZLeTaJf0Gfu6N+9l/SkWI52KPvY+uT9H9weMkO
           "]],
          RowBox[{"-", "0.15`"}]],
         Annotation[#, -0.15, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV019M12UUx/FjSx1LViZ/BVQQEqmYYjn/m7q56SYXRKTOuYWEKAI6W5o2
Qy8qbGVXXriabjovLBAqN8s/OafT8qLIikaOnJuIExVd4szSXt+L9+/znOc5
f55znu8vv7qponFIRJT6ScuIKCyMSKfvpUU8NT4i03oYzaDD6d3siGXPRjTm
RLxGC8dFjEOf893O++0PJGRG/I3/0mlBxAOaYn+JmFW5EauxcUxEE/bZP4Cj
/I/jgtrr5XwLm7FUfCWaxX4srgU99q+gF924lReRxycfNew6rMMNucrUuE2n
0rM0Q63T9Gm6eHTEPdo9MuKZLDPAML08kOcJOspZhbrZcuXhDE5h+diIlRgu
zxa1d2AbFvGdbEaD8v6DKvmu6v2x9cCoiDvWBWZ8kw6V+zpdYW7NalXSd+lS
ukmeHLHz1ZqD6WhVq9p8Rjprc5ZOa9n35N3OPkvPq/MDxrLHYK++bvCZa/0K
JuAcvx/5nKdvunMtqjErP2ImVlnX4IQ5n8Qk9y3DZBSo+ZzZTEARJqIYj+Xq
l7NTP+fU+DOZMT2l/kXahc/09hc9KGc3PSFXgzobsAYL1J6LxWKuOG8yh6v0
gLh+2oceMVV8lid+qEA5TosJc79t/ST93KxSaQrqxdwX+xAL3e8u/dT9ysTs
QiWfKsy3P1vc69a9+lnATjX3Edgpbwvue/NBXHM+g73CvS/J1cx+pK9dvrFP
cNwsOsS143CievjC+UN3eZV/m3UrvsRhZ+lyTpPjIvs7HMMH/D5EqTseknMt
6vGLs6l8f6Yv0Z/oy7STlstTzH+PN3/Hu2zBZuTpeyvNsp+NHPbb7Fy6iZaI
/9U9n6e/0SI5uugL7N/pi/QP2uJNduIj7FVrH/bzfSP5D9MOd/gq6Qn/6rU9
+a+LHaB1yfdPZ+mh1Ld0mX+3+NnsOfja2RFMcfZNMgez/Rbfm/P73qVY/Yko
wTxv1MinAf8DunG41A==
           "]],
          RowBox[{"-", "0.3`"}]],
         Annotation[#, -0.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0nloz3Ecx/HPCn/ZsN9mM8Mu2h+IKTfFFD9X2ZoR+8MxR9jUHGnmNrLl
XpE//OFMrhQKWbPCJkeUM4pca5gYUcJjfzx/r8/78z4/7983fW5pXklMCCHR
z/ruIWzAgaQQuncJYWyvEMbgfGYI5zA/I4QKds9ICI1pIcxjz0W52BScFROf
GEIa/wL3C1GMRHdr+XvhrrwM/i3qbEUp/3IsRQmW4aD+WWIvqpciN4m9jj1R
fBQrxKzEBOdLYsbTHDUvmH0QvZcaQm95i3uaqauZ+BMQQQx/nrhAJ2eZXe0p
dCp28FehGv30qxS3Wv4mM2/GFuS62xNvRj2+8W1ztx373JXx7aVb2ZX4pM6A
9BA+0y/oaKbZ5o6lRfSpGQbyP6E59EtbLP4lh1Cn/xTnaYhiJgrwUv0P/M04
ov9bWmIHr2lUzmgxY7Goh71iKa7JecZ/zMyv6CF5j+lD1Mqpo8/NfpM+MNt9
ege75V2h1/EiwX+dEsJfs0bsLB5V7n+yq9vOSBOf7e62tzVgn/3XYD9G8NXL
H0mj5hiHW+yoWQbqXaXvDXam/MF8fWir2sXqJsg5w+5M57BPm2Wo/Y7CGKTw
reIrtIdy9fLpejqLflS3nfqfaLr/+CttUfevXm+dC+T+dv6BAd18U+pU2NlG
rEEHvYr8dzNRq1c9UpGMaWLj1Y7R65f3tqcR9Trhmb228kXVjaOxaFBrKnuX
3J0YZp5Es1x3LlR/BhrFTKcFuOr+Gk7iBB7pN0md487HcBR/9IzTLxbn9bzp
zZe9q6btO/eefOTaWZQ28S/0bSzBPJShFE3q9tX3u9xsOkRcMm1mp9JT/Fm0
hZ1G3/G/oUnmf08P8w/3/tHoj8HIwRz8Bx90oWQ=
           "]],
          RowBox[{"-", "0.44999999999999996`"}]],
         Annotation[#, -0.44999999999999996`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5393, 8393, 4893, 8058, 8059, 8060, 4377, 8395, 4895, 8062,
            8063, 8064, 4382, 8396, 4897, 8065, 8066, 8067, 4384, 7372, 4905, 
           7086, 7087, 7088, 8006, 7373, 4913, 7089, 7091, 7092, 7847, 7848, 
           7849, 7125, 8107, 4522, 6012, 6046, 8462, 4980, 7418, 4981, 6089, 
           6088, 4523, 6069, 6070, 5873, 7026, 5892, 9132, 5893, 9133, 5368, 
           7757, 7759, 7758, 4828, 6831, 4827, 8364, 8363, 5792, 9073, 5794, 
           9068, 5793, 9069, 6368, 4424, 8509, 8513, 7527, 7535, 7531, 4795, 
           6360, 7332, 6365, 5786, 6357, 6353, 4542, 6336, 7129, 6341, 5583, 
           6350, 6346, 4751, 6329, 6333, 5338, 6326, 7697, 6323, 4423, 6277, 
           7053, 6282, 5444, 6812, 5111, 6292, 7296, 6306, 5117, 6688, 5116, 
           7863, 5580, 7858, 5576, 8939, 6262, 7240, 7235, 6854, 5704, 6960, 
           5514, 6849, 6178, 7221, 6181, 5107, 5988, 4627, 6316, 4623, 5984, 
           5291, 8247, 8252, 8256, 6169, 4725, 9046, 5754, 9042, 5758, 9050, 
           5607, 6915, 5611, 9248, 5615, 5102, 6909, 5603, 6228, 6904, 6227, 
           8210, 8209, 8615, 7602, 8208, 8207, 7217, 7216, 9187, 4996, 8466, 
           7701, 7702, 5351, 7703, 4560, 5602, 5255, 8241, 8242, 4707, 6025, 
           4706, 8779, 8780, 8778, 5366, 6663, 6662, 8342, 6667, 5782, 6657, 
           6653, 4589, 8572, 8576, 8568, 8584, 8580, 4845, 5180, 9211, 5176, 
           4411, 5168, 9207, 5172, 4782, 6477, 6481, 5778, 6472, 9066, 6468, 
           4584, 8550, 8554, 8546, 8562, 8558, 4840, 5163, 9202, 5159, 4406, 
           5143, 9194, 5147, 4777, 5155, 9198, 5151, 4580, 5345, 9238, 5349, 
           4766, 8761, 8765, 8749, 8757, 8753, 8800}],
          RowBox[{"-", "0.6`"}]],
         Annotation[#, -0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4375, 7999, 5809, 6792, 6791, 4376, 8000, 7371, 4891, 7370,
            4892, 5811, 9290, 5810, 6793, 5812, 9255, 5813, 5392, 6794, 4380, 
           9137, 5814, 5395, 5815, 9138, 4381, 6795, 5396, 9082, 5817, 9080, 
           5816, 9081, 6796, 8809, 5398, 8808, 8811, 8810, 4904, 9301, 7084, 
           7085, 7812, 7813, 5504, 8892, 5505, 8893, 5497, 8886, 8887, 8071, 
           8072, 4480, 4391, 7390, 4396, 9144, 7389, 7045, 4863, 7415, 7416, 
           7412, 7414, 7413, 7417, 6068, 4401, 7055, 7054, 5445, 6086, 6085, 
           4792, 7949, 5783, 7948, 5784, 6830, 6829, 6832, 5500, 7951, 5789, 
           7950, 8344, 4794, 6985, 4793, 7331, 6364, 5785, 6356, 6352, 4541, 
           6335, 7128, 6340, 5582, 6349, 6345, 4750, 6328, 6332, 5337, 6325, 
           7696, 6322, 4422, 6276, 7052, 6281, 5443, 6291, 6287, 4714, 6305, 
           7293, 6314, 5275, 6692, 5115, 7862, 5579, 7857, 5575, 8938, 6261, 
           7239, 7234, 6853, 5703, 6959, 5513, 6848, 6177, 7220, 6180, 5106, 
           5987, 4626, 6315, 4622, 5983, 5290, 8246, 8251, 6173, 5060, 6709, 
           5059, 6168, 8090, 8089, 8903, 8902, 4987, 6683, 5942, 5943, 5329, 
           6891, 5568, 6749, 6745, 4824, 7682, 7686, 7670, 7678, 7674, 4415, 
           8647, 8651, 8643, 8659, 8655, 4787, 6661, 8341, 6666, 5781, 6656, 
           6652, 4588, 8571, 8575, 8567, 8583, 8579, 4844, 5179, 9210, 5175, 
           4410, 5167, 9206, 5171, 4781, 6476, 6480, 5777, 6471, 9065, 6467, 
           4583, 8549, 8553, 8545, 8561, 8557, 4839, 5162, 9201, 5158, 4405, 
           5142, 9193, 5146, 4776, 5154, 9197, 5150, 4579, 5344, 9237, 5348, 
           4765, 8760, 8764, 8748, 8756, 8752, 8799}],
          RowBox[{"-", "0.75`"}]],
         Annotation[#, -0.75, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4390, 5406, 4910, 5399, 9139, 4385, 4477, 8817, 8818, 8398,
            4899, 8070, 8819, 5400, 9140, 4386, 8400, 4900, 8399, 4901, 8401, 
           4387, 8403, 4902, 8402, 4903, 9085, 9086, 9083, 5818, 9084, 6797, 
           6798, 5401, 8003, 8004, 8005, 5410, 9087, 5820, 7958, 5819, 7959, 
           6800, 4518, 8098, 8097, 8916, 8915, 7838, 8445, 8448, 8447, 8446, 
           7115, 7116, 4519, 6803, 8100, 8099, 7117, 5534, 7107, 4505, 6010, 
           6043, 6044, 6840, 6839, 4919, 6045, 5424, 6087, 4979, 6885, 6886, 
           5937, 4521, 6790, 8781, 5369, 7760, 7762, 7761, 4989, 6984, 5945, 
           5946, 5331, 6751, 7127, 6339, 5581, 6348, 6344, 4749, 6327, 6331, 
           5336, 6324, 7695, 6321, 4421, 6275, 7051, 6280, 5442, 6290, 6286, 
           4713, 6304, 7292, 6313, 5274, 6691, 5114, 7861, 5578, 7856, 5574, 
           8937, 6260, 7238, 7233, 6852, 5702, 6958, 5512, 6847, 6176, 7219, 
           7218, 6026, 4877, 6249, 5904, 5905, 5256, 6999, 5826, 6682, 6678, 
           4791, 8675, 8679, 8663, 8671, 8667, 4534, 6738, 6741, 5567, 6748, 
           6744, 4823, 7681, 7685, 7669, 7677, 7673, 4414, 8646, 8650, 8642, 
           8658, 8654, 4786, 6660, 8340, 6665, 5780, 6655, 6651, 4587, 8570, 
           8574, 8566, 8582, 8578, 4843, 5178, 9209, 5174, 4409, 5166, 9205, 
           5170, 4780, 6475, 6479, 5776, 6470, 9064, 6466, 4582, 8548, 8552, 
           8544, 8560, 8556, 4838, 5161, 9200, 5157, 4404, 5141, 9192, 5145, 
           4775, 5153, 9196, 5149, 4578, 5343, 9236, 5347, 4764, 8759, 8763, 
           8747, 8755, 8751, 8798}],
          RowBox[{"-", "0.8999999999999999`"}]],
         Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{9143, 5423, 5920, 4487, 7042, 7041, 8931, 5558, 8115, 8116,
            4527, 9060, 5882, 9260, 5883, 5771, 9063, 5773, 9061, 5772, 9062, 
           5774, 6469, 5775, 6478, 6474, 4779, 5169, 9204, 5165, 4408, 5173, 
           9208, 5177, 4842, 8577, 8581, 8565, 8573, 8569, 4586, 6650, 6654, 
           5779, 6664, 8339, 6659, 4785, 8653, 8657, 8641, 8649, 8645, 4413, 
           7672, 7676, 7668, 7684, 7680, 4822, 6743, 6747, 5566, 6740, 6737, 
           4533, 8666, 8670, 8662, 8678, 8674, 4790, 6677, 6681, 5825, 6674, 
           8020, 6671, 4419, 6235, 9287, 6239, 5750, 6248, 7319, 6244, 4748, 
           7320, 6272, 6753, 6752, 5998, 6956, 6957, 6263, 7237, 6259, 8936, 
           5573, 7855, 5577, 7860, 5113, 6690, 5273, 6312, 7291, 6303, 4712, 
           6285, 6289, 5441, 6279, 7050, 6274, 4420, 6320, 7694, 5334, 7693, 
           5335, 7698, 5330, 7313, 7778, 9177, 4740, 7779, 4741, 5745, 9033, 
           5746, 6978, 6977, 4742, 8317, 7846, 5556, 7845, 5555, 8930, 6884, 
           8244, 8243, 7279, 5720, 7928, 5954, 7904, 5681, 7201, 7202, 4636, 
           6841, 7003, 6837, 6838, 6883, 6882, 5840, 9257, 5841, 5838, 7967, 
           5839, 7968, 5679, 6998, 5897, 5898, 5680, 8013, 8012, 8011, 5412, 
           8830, 5411, 6801, 8169, 7175, 5666, 7894, 7114, 7113, 4970, 7410, 
           4861, 4912, 9185, 4911, 5533, 4517, 9153, 5532, 5407, 6799, 4479, 
           5914, 5409, 8828, 5408, 8829, 5550, 4393, 9143}],
          RowBox[{"-", "1.05`"}]],
         Annotation[#, -1.05, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7120, 4977, 7816, 5507, 7106, 8088, 7449, 5028, 7448, 7451,
            7450, 4703, 6966, 4702, 8236, 8235, 9002, 9001, 9088, 6996, 6997, 
           5881, 7980, 7982, 7981, 4701, 6836, 8894, 8895, 7814, 5506, 7815, 
           4969, 6081, 4504, 8457, 4973, 8456, 4974, 8458, 4634, 8455, 4972, 
           8453, 4971, 8454, 4488, 4394, 7420, 4985, 7419, 4986, 5015, 9188, 
           5014, 5868, 8237, 8238, 4704, 6967, 4705, 8240, 8239, 8338, 8337, 
           4783, 6658, 4784, 8652, 8656, 8640, 8648, 8644, 4412, 7671, 7675, 
           7667, 7683, 7679, 4821, 6742, 6746, 5565, 6739, 6736, 4532, 8665, 
           8669, 8661, 8677, 8673, 4789, 6676, 6680, 5824, 6673, 8019, 6670, 
           4418, 6234, 9286, 6238, 5749, 6247, 7318, 6243, 4747, 6267, 6271, 
           5572, 6258, 8129, 6254, 4540, 7126, 6301, 7859, 5112, 6689, 5272, 
           6311, 7290, 6302, 4711, 6284, 6288, 5440, 6278, 7049, 5928, 5927, 
           7777, 5386, 7335, 7336, 4825, 6750, 4826, 7688, 7689, 7687, 8122, 
           8121, 8124, 8123, 7614, 5259, 7613, 5260, 7615, 8343, 7612, 5258, 
           7611, 5257, 8680, 6112, 7507, 7508, 7411, 4975, 7043, 4976, 7495, 
           5077, 7494, 5076, 7122, 7121, 7120}],
          RowBox[{"-", "1.2`"}]],
         Annotation[#, -1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7209, 5092, 7510, 5944, 7623, 5262, 7281, 7284, 7285, 5387,
            6052, 4923, 7634, 5276, 7294, 7295, 4710, 6684, 4709, 7289, 6310, 
           5271, 6300, 6296, 4539, 6253, 8128, 6257, 5571, 6270, 6266, 4746, 
           6242, 7317, 6246, 5748, 6237, 9285, 6233, 4417, 6669, 8018, 6672, 
           5823, 6679, 6675, 4788, 8672, 8676, 8660, 8668, 8664, 4531, 6735, 
           4530, 8934, 5563, 8933, 5564, 8935, 5560, 7853, 5844, 9101, 8117, 
           8118, 6121, 4529, 5941, 5033, 8170, 8171, 4612, 8564, 8371, 8372, 
           8370, 8374, 8373, 8409, 5692, 9253, 5693, 5551, 6881, 5836, 7966, 
           5837, 9100, 5552, 8928, 5553, 8929, 5508, 7818, 5509, 7817, 7910, 
           7911, 5695, 7232, 8200, 6955, 5694, 8989, 5697, 8987, 5696, 8988, 
           4631, 9170, 7180, 9169, 7181, 7351, 8375, 7350, 7044, 7509, 5091, 
           7208, 7755, 7756, 5367, 7212, 7211, 7209}],
          RowBox[{"-", "1.3499999999999999`"}]],
         Annotation[#, -1.3499999999999999`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8991, 8201, 8202, 8203, 6948, 6949, 5701, 7916, 7918, 7917,
            4395, 4489, 8542, 8543, 7566, 9275, 5088, 8503, 5089, 6084, 6083, 
           4635, 8181, 7200, 7506, 7505, 7842, 5554, 7841, 7844, 7843, 5078, 
           6009, 7352, 4862, 7513, 5093, 7207, 7213, 7214, 5700, 7819, 5510, 
           7210, 7821, 7820, 4988, 7618, 5261, 7280, 7282, 7283, 5332, 6000, 
           5999, 6693, 5267, 7633, 6687, 7288, 6309, 5270, 6299, 6295, 4538, 
           6252, 8127, 6256, 5570, 6269, 6265, 4745, 6241, 7316, 6245, 5747, 
           6236, 9284, 6232, 4416, 6668, 8017, 8016, 8015, 5822, 9089, 5499, 
           8890, 5498, 8891, 5719, 9003, 4708, 9175, 5870, 5869, 6890, 6889, 
           9102, 8990, 8991}],
          RowBox[{"-", "1.5`"}]],
         Annotation[#, -1.5, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7628, 5266, 7625, 5264, 7630, 7632, 6686, 7287, 6308, 5269,
            6298, 6294, 4537, 6251, 8126, 6255, 5569, 6268, 6264, 4744, 6240, 
           4743, 7314, 7315, 9030, 9031, 9029, 7942, 9032, 5744, 8888, 8889, 
           7854, 5562, 8932, 5561, 9283, 8119, 8120, 7906, 5682, 7905, 5683, 
           6951, 6950, 7206, 7205, 7203, 8459, 8461, 4978, 8460, 7501, 7502, 
           5090, 7504, 8106, 4520, 6192, 6008, 8504, 8505, 7512, 7515, 7514, 
           4666, 6842, 6843, 5699, 7108, 7915, 4507, 6092, 8682, 8684, 7617, 
           7622, 7620, 8321, 8319, 7628}],
          RowBox[{"-", "1.65`"}]],
         Annotation[#, -1.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7123, 4665, 7401, 7402, 5698, 7912, 7914, 7913, 4506, 6091,
            8681, 8683, 7616, 7621, 7619, 8320, 8318, 7627, 5265, 7624, 5263, 
           7629, 7631, 6685, 7286, 6307, 5268, 6297, 6293, 4536, 6250, 4535, 
           8125, 7666, 5327, 7626, 5328, 7691, 7692, 7690, 5333, 6066, 4961, 
           6976, 4962, 6067, 8316, 7403, 4960, 7400, 4959, 8449, 7399, 4637, 
           7204, 7124, 7503, 8105, 8103, 8104, 7511, 7123}],
          RowBox[{"-", "1.7999999999999998`"}]],
         Annotation[#, -1.7999999999999998`, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXd8T9f/+LNR1Ci1a9Qq1dJWW7TumxpFi6rdUrVrb6q22mrE3kGIGNXa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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVD1oU1EY/dJGk/fEvpRG26Y/L014fQ0F0QgKDnETDKL01dZBsNVAtVVb
Bw0O6qC7Lm2hagepg1JEEFxcHNzbqYu7g4uDEAe14jmcGzpc7s2933fO+c73
vYxcW0oWO8zsJlYn1lRkdgur4ZkdO2T2smIW+2Zfs2YfMmaPEfwjbRbiroH9
Bd6PIm7U14qwNlNmE57O2zjv+srdBsEK4lcryvfwexm4i6bY2MWXBsEzZPZx
v9k97CODOo8WzWpY68B6hFVH/gL0TIJrFWujUzzrTic1zGFtAfMi9sQT/sku
szXUGKfEv5KV5ia4LuXM5pFbjxEfC7fngHAmHAb5mFsLzO5HwmdM0r5Hnh+a
PcgIn16yxieR/OVvvpdczDj0XBiDB8i9PKY6WcPnHtz1q64jiD0T7tXNHrB2
aicHvZx0HlBDoV918jzVbVYtK4Z87Bv1vI9UA/UTr+EwT+N+s1ueNX31iu/s
Q6ukXjzL6o5aloB9pywt58bNrubV61/QWz9odttUz19fNVLLcafnBjyfwwrw
/gqc82VhvtunPXLzw1xipHPiIP6firjJ+x1cHfBtLaM+sSb2dAeaa85D1kdO
1r7les+YaWisxntzyHzeL/dBQ6CZmek1OxFJF7Vwp7ZTofrHM/HpLz0kJ/tH
3hbwd3rlQxp49QHh/xvWrNNP6n7u5pYz+LCgOZyFl61Qb1dCzUF7BriTdwEe
pAL1ZBq5d4eU+8UTLnk3+uQF9bxBTFdRXIeB18hJ89lANbPe85jDmbwwOK/0
ip6xdvaD/heK8p0c7PPPYXG1PWIMNTXd/LDnvyvqQbUoHdTwGr4+jfSNsU7+
1/D+bV79Jk7ivsP2N80zZ3s2Uv/Yu8R9o9TP/4FdNzOcr+tuxlhrEqrebwPy
i16R/5PT8B8h7Kdk
           "],
           VertexColors->None], 
          PolygonBox[{{5424, 10650, 2597, 2598}, {8181, 9317, 2266, 1946}, {
           5217, 5983, 1453, 975}, {10650, 5425, 2599, 2597}, {10034, 10046, 
           1916, 110}, {10904, 10645, 2591, 2678}, {8206, 8218, 1945, 642}, {
           7554, 7542, 617, 1717}, {8510, 5289, 975, 1970}, {8949, 3573, 109, 
           1717}, {9527, 4515, 2387, 2386}, {5215, 8168, 1945, 2499}, {6781, 
           7528, 1807, 617}, {8194, 8182, 109, 1945}, {9488, 4437, 777, 
           1123}, {8168, 5216, 1946, 1945}, {9317, 8510, 1970, 2266}, {9592, 
           9603, 2403, 462}, {9580, 9568, 110, 2403}, {3841, 10904, 2678, 
           2191}, {7922, 7934, 1717, 109}, {3914, 9535, 2388, 463}, {10319, 
           10331, 1949, 293}, {9658, 9647, 462, 2406}, {7527, 7141, 617, 
           1807}, {9625, 9636, 2406, 295}, {10066, 6307, 931, 2454}, {7540, 
           7541, 1717, 617}, {10646, 9488, 1123, 2591}, {6986, 10651, 2598, 
           427}, {9065, 9066, 2191, 842}, {8018, 8030, 1918, 618}, {8006, 
           7994, 293, 1918}, {9072, 3844, 427, 2197}, {10652, 3913, 463, 
           2599}, {6437, 6426, 295, 931}, {9526, 4513, 842, 1453}, {8254, 
           8242, 642, 1949}, {7970, 7958, 618, 1916}, {4523, 9527, 2386, 
           2388}, {6101, 10318, 2499, 109}, {4515, 10058, 2454, 2387}, {10746,
            10747, 2197, 777}},
           VertexColors->None]}]}, 
       {RGBColor[0.340234067494128, 0.138808375450792, 0.5952204575855283], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuMldUVhr+ZOTNzZg4wFw/DOMM5cztMGa7DJdoEFX+0lQJDkULTBhha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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhhe0pb290EsvpZTeDrS3Ay1za4CIaX1QSspULlIwzIhMQhFF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           "],
           VertexColors->None], 
          PolygonBox[{{7529, 6793, 1359, 7526, 7528}, {6300, 6293, 6292, 3913,
            1217}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.37256565722667107`, 0.19502427836483516`, 0.640666418204335], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXtw1NUVx38Jm91NsiGEbBJlE0I2yyNBUaht1ekUtJ0aWxG1ip2pgHTG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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwldUZxg9kIQlJbnKzXXJz701ubvYEWWILlU4utgU0qbKVpSMgjKhA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           "],
           VertexColors->None], 
          PolygonBox[{{6159, 7238, 1731, 3615, 6158}, {7086, 5651, 5650, 8661,
            1654}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4048972469592141, 0.25124018127887815`, 0.6861123788231414], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHts1tUZxw/te2n7XspreoO2Qt8WpW+LRtwMLtmyCepmJpBR0D+mM7hh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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0lOUVxt+EZAbIOslMMtlMMplJMgFC2TxCxSbQspnBQoIsLYhQkK3Y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           "],
           VertexColors->None], 
          PolygonBox[{{5726, 8123, 1934, 8713, 5725}, {6346, 5495, 5494, 7007,
            1543}},
           VertexColors->None]}]}, 
       {RGBColor[0.4372288366917572, 0.3074560841929213, 0.7315583394419479], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl0tsVVUUhrf0tr333AL3Yh82bdVyW0oRUeNbqkbBiVGMCBhRQHlp1Ggi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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVNUVxi/MBg2zdNvTPQs9M00vTPeMso8RImYaLRVrxqphEUTZhi2A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           "],
           VertexColors->None], 
          PolygonBox[{{7781, 5985, 785, 7778, 7780}, {6341, 3621, 3620, 7252, 
           1541}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4695604264243003, 0.36367198710696447`, 0.7770043000607545], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1tslVUahlcPu3t37y3TsvemCFamtnVoQRxjPICalKrxwDiJgALJTASs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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwldUZxg8EbghKlpub5JKbm0v2DRDKJhC2hI4SaNIKhGGxJCyyI4Io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           "],
           VertexColors->None], 
          PolygonBox[{{6579, 6566, 115, 6110, 6578}, {9002, 6348, 6347, 9004, 
           2160}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5018920161568434, 0.41988789002100757`, 0.8224502606795611], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1ls1FUUxg9lugwz0FZKWxlaOi3LACKI+gCRBAytiBjZAqEgslmNNRQa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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUVh1+2EMBASG5CIIEkQMgNwQUEUasjmtBRxCEqGmSxLIrKqtaq
CDLKJjoCdZkpCS7YKooKgoVKO0JB7ai00laoC1asrTitVqXquP/R55nz/fGb
e+693/e+5z3r77y1MxdetKBjSmlih5Q687lqSEr3gJ+DlWBKXUrXg+vAZDCn
OqW54LWClPK8M74kpdOKUjoVnI+8uXdKLfUpTQBPIB/pl9KZfJ4B3kWu6cv3
nnwH1cg7WbO5V0pNYAdyez6lBWA+aAOj+qR0IMd+YCTyzexxRyN6gpuQF6Pj
42ATuAW8U8V6rNsEDiOXDkvpg9KU1qPruT1S+htrru2f0oXK3VJ6mbOcxtov
dErpczB7cEpXgXcLU+qIQb5knSnoPhl8gbyEfeez7zz3Rm7j814+7wHrkceg
44esdxSchbx+YPym/Avk7pz7Q+wwCvtNZo+R7D8enA9OBi+xz/QBKT2ILlNA
Ke/dxPM3ghLkf1WmdB76/ZF372eNntitC893BkXI21njMfAo2AbOrmV/cB3n
f7JrSsdqsAe4Hl8/zvfvWbNrRUoF4DvkFtYYq0/ABOSiQSkdB8q6hM6edS3n
XFMSZ95cETbX1k8gv88aO7DTr8E/kD8tCht49k+Qd2H/l/Khizr9hXcOgWXY
+mW+n1kXMWTsnIF8PLrXgraO8c64spQuwQYTtQPyD5ylsDbO4jNvs/aZfP8C
272Ff5eyziDWGQhuRW7AL4fw/0GQR57NGU7hLKPAlcg7+X0Ezw0HO5CHNPD+
UN4HdcjN5SlNI6amgibkV3luIedcAF4x9o0t0BV93uNMrfz2IO/lu6d0Or81
F0UMG7tNyPuw0wHwGtgLrmuMnDKXrkX+Lz5Yxl63g4+RuxE/77DXYVCI/DRn
yNWGbXaCdfw2k3dngLXIfyD2G1l3KHgJ+a+89zqowZ8zUuRuDc9Wl0QOn4Cv
TwQzC+KZnLqQV+NAKfIu1mhFvhQ8Vxq5tA6UdY2ceoZnHkTvB8BW5Bz+qQHV
oBQU82xn0An0AjPx4Vj83wxmIP+Gd/6O3J39L+8UuTQa+53SEDm1FRQ0xFl7
YN8FrLGW3FgD5iPvIi4m4ZelvL8EjC0mB8xL0IzcjA6ngtGgqSZypZT9Sioi
Z47HBqdhz62sP5z157FuO3ZsA3ORW9i7CZwDJjSEbRaCBZmNRrH319jvKzAS
eQ3r3gfuBXeDlvKIQWNvAvIe9ryAfB4PdiPfQZ6sBIuwfYfCyMXtxNC23pGT
7dhoI/o9bE4gn8p5h4FGMBqcODRi1Ng8AfnphsgZc+Up5J7o1WtQ1J4FnK8T
fuoAxrLfY8TocGLsz6xzAJyEfB9xNxZ9jvHsj4+LWnGpOVgWNeMkbL6BZ47x
XwX5V8c7jaw3FAxGfo+98uRkPTiCPI46MYD3+oPzkC9Hpy+xxRdgGvIGdN7I
5+fstwh9dnKOzfzWWhA1aAc+bB8a/1mjffZkdFnYOd4ZxP/rrPFgIPIcznGQ
Z14H1yDfNSxqvLX9aI+onb1BcVZDL6qLGND306kfl6HjJPCnguh5rqUPtL1r
9kfvNvy2HlQhr+Pd7dhrG1iL3F4RNdVa2oa8Ar0WgZvB8nz0rgfAhqyH7WqI
nDAXnkO+BX3/UxS5ei/6Pt439nDtTX2jVy/Oep89+9GSqDHWll+VhG2NCWNB
Gyf8skX98NUvseFEzruX2LqsU/QcY9sYNnaNcWvnP1nr/aKooZutiTxfZ41G
Hs8ZLgB7u0UPHYOtzgZ7sN/czlE7+4DyrIZqS2uitVCbHmSfdr63gdeRb6+I
nmQvuq0icm9VxkXMQXPBHmFvMCeMpfnYal5ZxNQSztYbv+8nVr5ljzmc4Ubw
M/3fELWmL76o6BU15xpsMhgbDwJXIz+U5Yi5Yc1uIefPQ5dVnK22IN6tJ06G
DIg1Zg2JnDFXZg6J2rKV/bcUR41Rl1UDI5fVqRtrdW6M3m3OXcaZf1cZteoI
ex4irw+A18BBcCdnPMGYBKuRe7JHP3At9h5Gv7y7PHLU3Pysc8R+e8adzAFj
cTd4PotJba2Nta02X8q6d7q2/bEu9rJn26uPz7jfbHBlxgGN3e/At1kMa4sR
YHhmE3W3R9mbPMM35hW50Ql8jfwT8GLv4Db2/Kl83ye/6hQ1ZgZrDsNujWA6
8nDWuYTPieAk5EcqIqfMpY0V0QvXZLXVnngV683icyaYjbySfReBm8EKkCdm
q0AlqAe/xfbn9Awueys+6IL/t+Sit9jT5ALGvLEuJ7C3fMQ7GwqixzxmXbX/
gkfLgsuNAWdlnO5YZfhY324siNpqjbQ2WmPr2btjY9Te/fz/LLx5U334diM+
niq35vtoMAX5BXSYxrk+6BI2k7usYI3lPYPDVA2ImDFWKgdELOay3mtM2ivl
lHJJe6a93B5vb7enyxXk6NUZZ7B2V4HKrIZfjR43gPXdgkN6djmQ3EcbXMMe
kzh3K7i6OGJrSjY7GGNyJ3ugvU8OpS1by8P22tRebI+wN9iT96PjA/hjA3gV
eW9dzAzOCr8H31QFp5BLfI28nWfKWDMHttmviyIGjb0JyIM59+qB4Qt77IV9
YkZxNmlBHoENhoBDHSLHHmaPJ6174CF7MetuqQyuao0zt+Zz1nnVkWPOPpNA
azYDTRocPcje04rczG/FPNsLNCHX8nsN+CRFD9N2V4BZmQ1nZDFibMjJnGXW
oOeLXWKmuZg4GkH8/Lt76CzX6I89q8qDc4yXE5RFLTZm5Aqf46f/1QZnMDfz
2K2+KnL0cC44jtzm7VzMUnJIuaMzldzbmcNZQw6+BB/vwXa7weLimJX2ZVzW
mclZ7+HMds58R/pHT7OXPVsQ3GF4/5DlEM6CS7Na5Ez4VXH0bHu1PStvnwWV
oB5M4//l7L0MTC2OWUnONjebmZxF7JmbsplEX94P7st8eiG4uC7r9eTT0dKY
GZ0V3+4YuafPmrIcfLpPcC651lN9grs78zjryOGtPc6MzorWoB6c+S3y5s1u
4WN9OzKb9fRxIXn5A5/fg641wa3kbHI1OZbc/x18dbg2ZgB70bl9Qjd7krlp
DBu75qi12BpQmdVke6OcQi5hj5RL62N9K6cuKY6eaa90ZtnN91ZrAXi+OGy1
N8s1bfZt/5ipnKW+Qb4hF5xLrvVT44VY/BBdj4KmxsgFZ0RnQ3PC2Hwkq93G
qLXZGDJ2rNHO+v3Qq29DzPyvFMdM4SzxcnH0ImuitdCedAU5NQu8SX99qzBq
hTXA3LdmnFEbz/jftq4Rq9aUV7OYfa9X6KyuR3pFLDlTOEsYU3IXZzBnLzmM
ueaM4mxizr2QixnR2XBfLrikNtI2ckpnn88416fVMQM5G8nR5GbOSKt5bglY
DO4Ab1j/+gXXcAYy1q2p1lJjXtu4p3tpo9Nr4w7DuwtnFtcyJ8wF15SLy7Hk
VnJyY8kZ19nWmLIWaAPPbk1Yjl4tvDsBLENuLIkZytlpaElwVX2iL+Ss3oUY
M8aKdyLNxNKa8uAicna5o3c43t3IIa01q7OzWnOcneRQM7MZ6lx8VdgnuOn+
wujVHVgzDYye7aw6hXNMboyZ9bMsh8wdbSyXMyaNRTmds5I92t7szORdlDls
7non5az2Mfgom9nspXJCuaA91dy0h9g7zFHvPpyxna29A9lDTO+vj169kJy8
G/m2+pDtkW/k487Ju6Y3usVdgRxFbuKdwSFrQz7+885iPfv+CD2f6Ro143z+
G5eP2UqOLbeQE8mF5BjO0vmMyzhT21vyWW20x3zHWpPL4y7CniGXkmNNzziV
XKs5m4XlXN6NONM4y3hHoi5tucgddTLX2nNxt2LOeRdnzBgr3sk5C23P7p6c
ifTdDPafXh4+dHaYk3FxZwjv+lZks5B3ft5deMfm3Zp3GNYi70S8C7EmOSvb
U1uzmdm7MGPGWPFOTK7vTDkt4/zWIjmC3MCaNCObuZ211clYMsaNbWPKXr4y
44r2dO8OvCPybmhMlhve+XnXZ44YO864R7IY+j81SPzx
           "],
           VertexColors->None], 
          PolygonBox[{{6933, 6821, 369, 6931, 6932}, {5649, 8660, 8659, 8648, 
           1214}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5342236058893864, 0.47610379293505073`, 0.8678962212983676], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlc1rnWUQxSe5ublJ2tyYluY2TRpJosE2FwraP6B+oljEKuaj6MIoQlOi
UhcJtiAi5mZhpJpCC6LEjwiBqqBo2i78wm7FWjdCgotaaVMXdZGFEcHzy5ng
4uF93uedZ+bMmTPz9o698Njz9RHxqVZB69JAxBdtEet1EVUdPNEUcUPnEw3e
n9X5if6IZ7u0GiOmtP4tRjyMbU/EkNaTJdsO5d1vdXe2wXcX90Z82RHxZou/
D6fNyUpEpcO295Qjzsv/Z0VjGJHN37r7Xbt8y/+Y/C8U/L214Pcp+RuQzcKW
iFHZl3X+x66IlrL9czaSsZ6Sj+/l6xndu6n9B+3Gv6r3Sfm5VvICMz7v74uY
q/p7rTliWuvFcGz2YGvUt9+0HtHZ0VsjxrVe1fth5bTe628/6vmL1q8l4/xo
izE9XXIOxMIfMeAf2/YO28PxleT5VHfEivi6qveDBT+3Fnz2VrffsbuS53BK
rcjn0u3C3mr8D8n+UXH0IXaqaWu/67FZG2reW3Q9ifNOZ8TSNuErGDNn+L8s
m/2y/UeY71b8A1pfN7qeL/c7/ukma4J61ormC66Gxf1It+u1b4d8qu5DYNXd
+8T7ddkVb9FTuAcl1EndPVrynnyoEziXd0Z8ldg289+aNb2W3PYmX+zX5O+i
1ri4HlasVcVdbjD/1BV+Tij+NsWuKlZZeby3xzpCd9hih+5W0/+90tp+2Q3W
OUfyY/+Szi7fEXGmybql7uV8LuQevwuph2/Ufz/1mM8DujvT45xnsx7Eeq7T
dtgMq4aHtPrE21rJ9cIOX8RAnw80us7UaVn+zmpNlKyLtbQ/1+McwAx2vrO/
czDi8TZz+7ZqNddtHg8LQ/MO+5wT/7M7rVP0QDzO0ctrnb5LnUez1vTTGx3m
jliLBefy+/aI7VW/z1b8zn5GPqPJtfhZXBbbPE9uiP+PC87xLnHwec6uByvW
NzlXhWWpaLtj/a4HtSDO1fR/QfUfFZ5XZPu+/Mzv8j00Rf7gb+u3DqjVtLTR
ntrgiVbYn+z2TEF/4AX3VNG6RbN76839D8n/WLN7g76YF/fHK8bKvVreI8c/
M08w3uwyznf3uH/KOSPxwXzDrpqc1DcZBxgWs1fhGX/4Xc+Zwx577i7l3KV3
j2f/nupxH270YIv7kr46kv1CXnzjnT06b00MPI/kzGQm0j98H8qZQP9u9ELa
w8eZ/NfQn9zF9+viuNaXvArPfPbFJr/ERY/HOq29qeSRb+gcjdNDcDeV9hOp
Pzj5RP++lQHPX3SzkBpmXp4f+H/m0/vcPbRb83O3Zxk4Nmpc5/8K85H5A6/T
Oc+ZNys5cw7mDKWXwTSR/8eLA8YBhsnUAD5HVPdzOaNqmRd62ydsf3UZ64y4
ua3imlOb6zkb+Z/TG2CA79PJLbhr6QeOx7NG1B9dogHmIrGJy/+E2Uxe/wEw
ZBpi
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHtwldUVxQ+EkEAlyU1CcpPcC7l53pCL1PAQOiMFTRiHVxNbwiuhQ6Ag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           "],
           VertexColors->None], 
          PolygonBox[{{6544, 6555, 903, 3923, 6543}, {6737, 6359, 6358, 6742, 
           1570}, {7091, 6306, 6305, 5661, 1656}, {6731, 3574, 1443, 6736, 
           6730}},
           VertexColors->None]}]}, 
       {RGBColor[0.5658312291423921, 0.5307955283505138, 0.9095445713760252], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{9084, 9083, 2212}, {1074, 1229, 407}, {3744, 6816, 
           368}, {3745, 10400, 368}, {2648, 1477, 860}, {7091, 4514, 1534}, {
           4522, 9534, 845}, {7404, 6316, 1229}, {10412, 8372, 1957}, {7314, 
           7766, 1755}, {1002, 861, 593}, {6299, 6306, 1534}, {1229, 845, 
           407}, {1957, 861, 368}, {2065, 2064, 111}, {1954, 860, 593}, {6950,
            7404, 1229}, {7765, 8789, 461}, {8372, 8396, 1957}, {6032, 3845, 
           1477}, {11071, 4018, 935}, {9074, 9073, 861}, {3426, 6377, 111}, {
           8323, 3426, 111}, {1477, 1002, 860}, {1756, 1755, 407}, {898, 1754,
            407}, {2064, 1074, 461}, {7316, 7315, 1756}, {1074, 1755, 461}, {
           2064, 860, 111}, {860, 1002, 593}, {8789, 7012, 461}, {9073, 4549, 
           861}, {5078, 11071, 935}, {2212, 2211, 461}, {1534, 1911, 898}, {
           8864, 8863, 2065}, {1477, 2514, 1002}, {10450, 10451, 2514}, {5079,
            6695, 935}, {1755, 1074, 407}, {9534, 4530, 845}, {861, 1957, 
           593}, {2065, 2566, 1074}, {10065, 4522, 845}, {7312, 7313, 1754}, {
           8384, 4137, 593}, {8360, 8311, 1954}, {5372, 10621, 2566}, {4549, 
           6011, 861}, {6817, 5078, 935}, {845, 898, 407}, {2064, 2065, 
           1074}, {6683, 3745, 368}, {2064, 2211, 860}, {2211, 2648, 860}, {
           1911, 1754, 898}, {6719, 5079, 935}, {6306, 7091, 1534}, {8311, 
           8335, 1954}, {860, 1954, 111}, {9542, 3921, 898}, {2211, 2064, 
           461}, {6377, 3374, 111}, {4137, 8348, 593}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGlwluUVhp8qoDADCTEhISH5SCBkYbOCC+mMipo4HcU26chWgY4gqCgB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           "],
           VertexColors->None], 
          PolygonBox[{{6708, 6719, 935, 4018, 6707}, {4531, 10074, 10073, 
           10065, 845}},
           VertexColors->None]}]}, 
       {RGBColor[0.5896024288634306, 0.5689892318955472, 0.9100864815133691], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{6950, 5371, 1604}, {6448, 4005, 504}, {10074, 4531, 
           1535}, {4006, 6448, 504}, {6402, 4006, 504}, {1604, 1075, 504}, {
           1535, 1779, 504}, {8864, 3374, 2066}, {5373, 6414, 1075}, {4531, 
           6316, 1535}, {5372, 8863, 1075}, {1779, 1604, 504}, {5371, 10621, 
           1604}, {6315, 10074, 1535}, {6390, 5373, 1075}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mG2QlXUZxp9MwXR2OXvYhT0Lu2fZZZd9EcRgBaUZDXXXDyK2NMlLggko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           "],
           VertexColors->None], 
          PolygonBox[{{7391, 7390, 7389, 6315, 1535}, {6378, 8865, 2066, 3374,
            6377}},
           VertexColors->None]}]}, 
       {RGBColor[0.6133736285844692, 0.6071829354405806, 0.910628391650713], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{7391, 4005, 1778}, {7390, 7391, 1778}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mGtw1OUVxt9aLVjYXJZNNrfd3DfZJCWEmohCZ0DQxA9catIptxKw3AUk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           "],
           VertexColors->None], 
          PolygonBox[{{7392, 6472, 6471, 7390, 1778}, {6449, 7392, 1778, 4005,
            6448}},
           VertexColors->None]}]}, 
       {RGBColor[0.6371448283055078, 0.6453766389856138, 0.9111703017880568], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1U0FLVGEUPTaTg29MfZQzpfXgzTigs2kVUa6j1klCu3lPImthbdxYQoZU
i5KM+gHSWkFyFgktEoUWtSoCF7lJiNqL0qI6x/O1uMx9d8537vnOvV+a37k6
dQTAdUaBsd0JtFlY7QC+DgJZL7DDvNoHvOP3ef7XKgNzBE8wPtX5exI4OApM
1YD1CrBfArZGeI71Y+QbbQLTrP8oArPE/+F/G8xfDgDDVfe72QUsFM05dAo4
y+jj2Z0YeJE6b/Pse0a74FDPS/xdPw0sM34RA3K2gua9TvdcI2b8DHCNUaa2
Yuze6nubmM8l3ysv+F66ezt8K/9IvstN84lbvoj/ewQsFYzVucku64/I97vk
vsqlQfzPGsBDxg3iLiTAYmz989R+N7H30hcFPWV6M1sz162KfRTXW3JsNtzv
73HgYuJe8kMalT+P3UP8K+TPa/ZnkZwR84z1EebfYt+zzNoE/elmr6f9wOM0
zIO11pDrD4jHCXufcQdyxgfWzxE/mTrf6wHus+9Ch3Hqr1xc2gX5s0X8G+K/
EL8b2UfdfZTnVuv2dJmYR4OeTxb6aBbaG+2feA61hH3Iez17zUV4YYQVl/il
QTtyL/ig2m6oS+NS0Kl7Spf82Q44zXeFfr9ueE+110/qvo/mrl7SptlI7/83
koW6/PjZY/4riectbr2DpGKd2glxaRbTqT3VnWdqnpn0HHpTtVb13gjvRXNf
C16/GvCb0XvJgwbhxskzE/ZWOqOwn6rl4b3o3cob9Rprega6j3Zhrt8z1Fvp
Dvv5D1puoHs=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGlwV+UVh18FUZZACIQkLCEJBEL+SQWtoAidwYomTkdRwVbAClgWUVHW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           "],
           VertexColors->None], 
          PolygonBox[{{4573, 9591, 9590, 9567, 866}, {5066, 6805, 1552, 6447, 
           5065}},
           VertexColors->None]}]}, 
       {RGBColor[0.6609160280265464, 0.6835703425306472, 0.9117122119254008], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl39s1WcVxt97b2/vvW0vxQvYcts7KLS0gCYzQCE2JCbGOZDBpg7Iogka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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHl0VdUVxk8IARJISELGl/Flei8DVARldnU5EtQKSqIVsAxWQZQZuiDM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           "],
           VertexColors->None], PolygonBox[{{6657, 7330, 1769, 3936, 6656}},
           VertexColors->None]}]}, 
       {RGBColor[0.6846872277475848, 0.7217640460756806, 0.9122541220627446], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1twldUVx/c5XJKc7yQHcg4nCYkCoQI5XELAQBLx+lR0jBYYZ9ShJE4J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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd01tUZx29ekBBCEpI3+83gTSCLGLYNU1scBIqnld26GJUpyAjQgoDY
MsWeU0CkPW2DrLYgyFCWgELCCJVRllAsM5SteBQUKPTz9bl/fE+evL/7+93n
PvP73HD/kc+NCDjnRkY4V5u/+xs7dwGcB9XgYYZzKZnOJYMHyFvTnFsN3gdb
wOch5xbGOfcOOIE8qdC518BXfLR2PedK43mHdz+pZb/9M8j6dNaD/civ5Tj3
cTJrwEjkQIJzR/l7BEQgzy1ybhq4hnJj+F6rJs7NYa/ZoCVyOM+5KFAXNAT3
k22Nnt1D3ouOx8BRsAesy+JcYB9YC5Zwphh0qQ/eQz7VyLkD4DNwEtxmn6QC
5z6Kci6E/r/UWfnOAvAL5Dbs+SgoBqWgfiz2Yv0W1n+JPa+i+7fgr+je9hHn
dvLNS6AGfAoWN8SWYBWoAGdYexTMjrB3DmG/cSnOlYODyD9L4gzYtzXPPmHN
cc5wHpwDx8DQYuycbHu9Hs0+yfab5HL0mZjv3ADQH/wGVLFnSQPOACqR/8GZ
WnG2luDvyANBANtEgAHI81kzE8wA80AZ522bix1AZ+QPsOFAfDcArEE+yO+/
SuU3cAA5GduUJuJz7LMZDOVc99jrLhiSYros9raQTjuwxQawHmwvsm/3Ab39
Hrt5ZwvYDKpSLLbOYqcz8RZjNeBJ5E7gos6BzTuiQwfgkDezz2FwCGwCP0o0
HaWbfLiGOKohDrvj+xJsOD7MGnzwGBiHfIP1HfFHB3AdeQLnGA6GgfHgcoxz
heRRN77Vly2L0aEhyAZNQFNyIxfkgJJM030+350XtjM8zz4x2O4r/PlYPYuV
SWCij5mN2cQJ2Ep+zYp07sd84zv8dAc8kWlr53tf6R3Zuj/f7RdvNk/KsxxS
7iSCEnx2B7u2qUvM13FuMPtv52xt2Hsn8fY2MbYcLANzwQxiaBx+KgfTkTfi
411gJ/go13T5AnueLjCdNitnOHcp2IT8bLHZVLbshtwXnfew527QJ9Ny5ZTP
ReXM9iyLOcXaNuQVvLeKtSvBcuRW+CDIXhuiLGd11r0+93Xm4cTQ+CKrJcox
+V45UOljQLUuGtTzNe+KYoV924PLBeb7oewzJGwxcI79emOfXuAsclfi5QbP
roMuyFWc8zA4BCrT7Zlqqmqp1sRhsxjeqw9ikX+OD9KJt6noPgU8nWs2l62f
Qj7HmutgBc8mOMvVC3zrfIbl7GKwjfc/BhVplquDiMFXYixn15Mjj1OnO4J1
yInY/Ap1uBxbdCG+/8g+0fiyHliE3Ay9Ejj3B+xXSky0zrQYU2y1Ah1kT2rM
ONAe+QSxPo69ysHxxmbLpj62ZdNhyfaO1g5FPkAMlCF3Bp8h10mzGqTa8wjy
pTizqWxZE2dnuUk+3Ei1MynWVGMO+Ji7RlxM41xvgKuxZotZskOa2eQs781m
3SxwBvkkOjTn25eIhzJyKKA4VUwHzMajsUEGz0NglOKe52tlD7AU5JIrqWAs
vqgh/47EW09TL/tXvMViS2z4YZTF5MvoEUfcxIKXkL8P2xl1tu+QexBnL4EX
QXdQolzMsW+rB6o2vM27c5OsRiSkmc1kq3hwBh/fAbfBf8DlFOvZ6tX/RV6C
LpuIw43qd9ILG+1Ax+3KGeThoDe26QWGxVrv1Df0rnpoy5DpLF1bIA8gfrpg
wzjsNYj4GYNejbDrLepVW2y6Lmw9TL1rbdhqy+0ciyXVmGbs+y1nTw9YT+hC
HrXne+1AWaH1auX8Nt+zX0DvyegxCns/n265p3fKfA7Kl034XmWE+bQPv81j
vzj2CvD/nZD5QLa/jdwr1mqgal9P5PrkkQMPeRbN3ybqndhpEigqtt45D/zB
91BH3DZE12zwsNBsfw1c9T7oyfM12GQ16IE8i5gdyXsjwEzkdinWI37oDbXN
Fg+x/ad1zSZNFWMgB5SA6RkWk4rF3yHv42zTiJM3wN4c620tQHPf49SbVKNU
m9SjpJt00N7SsTHv9eBZd9AI+bf46SF5+lyk9ax7jY0TigveBR+GLcYV2xvC
9u5u33v1jVqqaSAWBMJWO5uDZr6G6uwTPfeQDcpY01PfAZ3DlqvysXyrnE0j
llZmW29TTMn26jnTvQ+G4LfyPKuV8vlY1r4F5oAx2cY9z/Hd05HGQfezdj1Y
B6rzrPfWxW6ROdaDJ4WM84jrTETOpzYeIqZaE9t/wh/V2Hw72CbbZ1hspHGu
1EYWIwepMUsVg9HGGcSV38HWC2KMM4/im6fww0nx5JBxJ9X4pzyHmoWubxIr
08DMsNXe5nx3TqTV4Ko443ziepXI8ehXJb7LfqMDxgXXeW4rTqhaGOD9iESr
iYXEYDF7HyHWXiEfnkkxDiPu8jTy8QbmQ/nuGPLX7JFZZGtlwz2FVkNVO3eL
53PeLezfnP3HEcOR5MgCdPozuvyE32YlWg4pd2YmWq1XD1DtV83/C3b/Rv3J
WY5W5pgP5btdOcaldGadVZxKsT4XvOVjviBsOkvXfOS+6PVr/DIB9EH+Jmg9
Tr1NNX04Md8PrA0Yv7mZaDVCtUE5p9zZx957sy2HxH01I2g2EAd+Epzmm/8G
ndIt98VhxF1UAzpi8y7iKKBDls1S6onH/Uw1O2g2km3UcxUbmzjnxhyLkVMJ
xjnFNUfzvFey1VjV1i3EbwvtzfNS1doI03WnnyWks2YpcXBxb81UVeTIYXAI
VObbXrLxLr+nuIBqegvPCRQbexOtFilGdNZiz1V1Ztm2G3b9aarZOEV8Ictm
EdWMV/mtH3gZDM+wWnDG9yLVhFLWPpplXLJHpOVODKjvc+gkcf8FOpwGnyfZ
WTsELfd05vboVkOeXgTtkBMLbObSrKUeu4wz3UW378FS5MWcebPODSpAhjgi
aAlCYautfYj73ilWY6WLZgTndcrAJqs4+0oQQl6cZJxTXLMiyWqbamgjX+Pu
o+9Y9B3PJx5H31v8/2LQfNUh2mZHcbQKP0NK1wi+45JMZ+VCK+Lk2SjLiVv8
fgVbXFauIdeA1qxrBS4mGRcXZ1vkOXnXNJuxNVt3STMu9yXfu9nYOF1hqvlI
vikQh+Icg8KWC8oJzbKacTXbaqbtit96NbTn4jibsm0m1iysmjQl13qget9k
5PtJloPKvXtJNpvkJlrsakYRd5OP5BtxONXWjKDVDtVY1bI6QYt91TTpfs/3
Hp1hR57VcNXu7XlWaysTbLZVzdWsKU4pLqmZU7G/2PteOaDYFccRt1EMTwma
z+Qr1ay/BY2Ti4uvCFos605BdwmKadWeJZzzvVyrQboraO25sO4MFGvvg1U+
5haFLKYVy++GjFsdwyZHs41jSVZMK5b1m3wrHxV4H4tbi0OIO4hjKzcUA/K9
ckS9biqY4nvemw1s5tCsMQ15JntuZe0WMCNkudOZvZ5JtBzS7CzOI66jGVqz
njicuJtmPvUqxbxiXT1Ldy1t/F2H7lzEVdXT1MvEWcVN1cPUu8RR1Xs2+llQ
PehSrnEacZka5HfBVHw1BSzMtdmqo6+dmrFGZNkdge4GXvW1VRxI3Ec1NoSN
80EeSAcP+MbX4Bb4H1gea5xdXH0Z8gxsWhFvXF8z9dg485F8MybOfCdOKC4o
H9bKt5hQLASQJ2fZjKHZ4nXkHmnGKcUlxUnFHcs8lxGHfEFxyrvzo2ymUy4r
R5QbyukLPD8BjoPzeVaLdGehuwrVJN11iJOIi+jOQ3cZmuE0u+lOQ1xeNUq1
SZxes7A4t7i2ZmJxT8WAfL/a3x3pTkF3CbpD0qy2w+eSZrZ8f+aAt6lsKZ/V
eJteIle6a14kV9pFm+6a6TXL6wziAvcSjIuIE4hbDSZuByUbx1It1cyhWUM1
VbOYashkP5P9njPlZFlvUA0cErQaqtqpPXVXt8PfBenOTndDujPUXaHuiFTb
xQnyfY3XXaHuKHU3OdvfRWimv+zvJHTXKA6919853ok1H8u3t3XPELQz66yq
6col3VHobkI5pbNVkXeV2XZG3e38EHOxdsej2V8zl2Yt3QGI61Z77ijOO9Xn
rHJVOaxekOBnOfUEzZ7SSbpoBtVdS5Xv5bpz2V9gPU29rLrAuKliWrEsjqq7
Q+WQckd3iLqrDflc0Z2tcm80OTEq1XJQtUGcbaavEXqmHqTeozWaFbVntZ8Z
77JmYKHd9Q6uZ7PtBH/3pRl3ic/xhb5malZsXeTXBmzWe+BzVTOf7n40Y2i2
0B2Q7jbU09TLdMchbiwOKu4pjqxZfLO/u9NMLm5/weeSOH4bz9k6+Tsn+aqH
n63ls/8D0ZeSHg==
           "],
           VertexColors->None], PolygonBox[{{8851, 5959, 5958, 8862, 2063}},
           VertexColors->None]}]}, 
       {RGBColor[0.7084584274686234, 0.7599577496207138, 0.9127960322000884], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{6616, 3676, 304}, {2891, 1124, 530}, {9300, 8133, 
           1253}, {10259, 5172, 958}, {1172, 1253, 530}, {10275, 10287, 
           2491}, {2798, 965, 956}, {4560, 8626, 1547}, {1173, 1638, 1172}, {
           1485, 1639, 1172}, {9214, 5692, 1238}, {1638, 1253, 1172}, {10261, 
           4086, 965}, {4085, 10288, 1238}, {1990, 1485, 1124}, {6039, 6897, 
           1484}, {958, 965, 529}, {1496, 958, 529}, {5345, 10558, 1071}, {
           5176, 10262, 961}, {10262, 5175, 961}, {1447, 2491, 961}, {10263, 
           3596, 1447}, {7025, 9311, 1638}, {2891, 1786, 956}, {10714, 7025, 
           1638}, {5171, 10259, 958}, {8951, 7214, 1124}, {5357, 5959, 
           1071}, {2799, 2798, 1786}, {3080, 2891, 956}, {1786, 2891, 530}, {
           1124, 1485, 530}, {8712, 7459, 1788}, {8133, 5736, 1253}, {10584, 
           5358, 1071}, {8950, 8951, 1124}, {1496, 1588, 958}, {6918, 6039, 
           1484}, {8697, 6963, 529}, {10258, 5168, 956}, {1172, 1484, 304}, {
           1639, 1484, 1172}, {8615, 5537, 1173}, {8551, 8550, 1990}, {9215, 
           4085, 1238}, {1253, 1788, 530}, {6887, 3677, 304}, {2798, 2799, 
           529}, {9190, 9202, 961}, {965, 2798, 529}, {4070, 8697, 529}, {
           2891, 3080, 1124}, {5959, 8851, 1071}, {1786, 2798, 956}, {6975, 
           6067, 1496}, {5169, 10258, 956}, {7423, 8685, 1786}, {3677, 6616, 
           304}, {1173, 1172, 304}, {5548, 8615, 1173}, {7459, 7471, 1788}, {
           1485, 1172, 530}, {7447, 7423, 1786}, {1588, 1447, 958}, {1547, 
           1173, 304}, {10558, 5357, 1071}, {3596, 10260, 1447}, {5692, 10570,
            1238}, {6067, 4420, 1496}, {8851, 10584, 1071}, {4086, 8120, 
           965}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwldUZh08WAYHkXkhuyIq5XEI2IAgEJS047dhWltqZltVaLZHFshfZ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           "],
           VertexColors->None], 
          PolygonBox[{{6365, 6007, 6006, 4560, 1547}, {6908, 6918, 1484, 4343,
            6907}},
           VertexColors->None]}]}, 
       {RGBColor[0.7322296271896619, 0.7981514531657472, 0.9133379423374324], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{5995, 7791, 1457}, {6008, 6654, 1457}, {6626, 6008, 
           1457}, {6365, 3676, 1457}, {7791, 6007, 1457}, {6007, 6365, 1457}},
           
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuQlmUZhx9hDcr224WVXXaBlT3IByweSsWSAsamUsBsmgC1gwVCB2XN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           "],
           VertexColors->None], 
          PolygonBox[{{6617, 6626, 1457, 3676, 6616}, {6654, 6653, 6652, 5995,
            1457}},
           VertexColors->None]}]}, 
       {RGBColor[0.7560008269107005, 0.8363451567107806, 0.9138798524747762], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{4603, 6655, 1562}, {6615, 6602, 1559}, {6603, 4588, 
           1559}, {6653, 6654, 1562}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwl9UVhm8hWGlLEhKSmIUkBEMgoSqtCq1YcOzY1qC1nangUrVisYuS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           "],
           VertexColors->None], 
          PolygonBox[{{6655, 4453, 4452, 6653, 1562}, {4453, 6603, 1559, 6602,
            4452}, {4588, 6123, 6122, 6615, 1559}, {6009, 4603, 1562, 6654, 
           6008}},
           VertexColors->None]}]}, 
       {RGBColor[0.7780248052950755, 0.85213142388344, 0.9071345890226974], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{2265, 1923, 1016}, {1027, 3091, 879}, {1511, 3091, 
           440}, {3091, 3092, 440}, {3093, 3092, 1027}, {2356, 3093, 1027}, {
           3092, 3093, 1498}, {1783, 1082, 517}, {2074, 1558, 1082}, {1498, 
           1913, 440}, {3091, 1511, 879}, {2011, 1481, 944}, {1481, 1016, 
           944}, {8067, 8079, 1923}, {9139, 9138, 945}, {10458, 10459, 
           2521}, {1082, 878, 517}, {1764, 878, 440}, {6635, 11318, 1027}, {
           1481, 2521, 1016}, {4056, 7094, 517}, {1783, 2467, 1082}, {1923, 
           2468, 944}, {6123, 4588, 878}, {1016, 1923, 944}, {4422, 6069, 
           1498}, {4603, 6009, 879}, {3092, 1498, 440}, {1765, 1904, 1764}, {
           11325, 9320, 2270}, {878, 1511, 440}, {7912, 9790, 1904}, {6577, 
           6590, 1558}, {2356, 2899, 2270}, {9138, 5096, 945}, {4589, 7027, 
           879}, {2073, 2467, 944}, {8903, 8891, 2073}, {7327, 7326, 1765}, {
           3093, 2356, 1498}, {1584, 1016, 945}, {6603, 4453, 1511}, {3092, 
           3091, 1027}, {6943, 6843, 1583}, {2899, 2356, 1027}, {878, 1764, 
           517}, {1082, 1558, 878}, {4453, 6655, 1511}, {1765, 1764, 440}, {
           2073, 2074, 1082}, {6831, 6943, 1583}, {1783, 2011, 944}, {1583, 
           1595, 945}, {7027, 4596, 879}, {9483, 4423, 2270}, {2467, 1783, 
           944}, {7406, 4056, 517}, {2467, 2073, 1082}, {2468, 2073, 944}, {
           9327, 9483, 2270}, {5096, 6012, 945}, {1913, 1765, 440}, {1784, 
           1783, 517}, {6037, 4043, 1481}, {6868, 6856, 1584}, {9790, 7913, 
           1904}, {9320, 9327, 2270}, {1595, 1584, 945}, {7410, 7409, 1784}, {
           1584, 2265, 1016}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwltUVxt8WEoxKFj6yGkJCgkBCK1hRrGLBsbWtoNXOFHCp1UK1iySt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           "],
           VertexColors->None], 
          PolygonBox[{{6844, 3769, 3768, 6831, 1583}, {6628, 4589, 879, 6009, 
           6627}},
           VertexColors->None]}]}, 
       {RGBColor[0.7993729560212665, 0.8592504633090046, 0.8975706366281382], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlUts1WUQxacv7r1NU7lUe6mtDU0ppRFtjBtdGGWhYqKJwSAqKUb3qKWi
C0yMXZmQkhj7XqhIMJjqgtAWRWAhC2KMVBamiSS9l43viJp4Nwjx/DhjXEy+
7/89Zs535sz8+158eedLjRFxQtYke6MYsdoacVDjSnPEWClie0PE+z0RH3RE
TOvQ27L9Wt+ncUE23RLxmZycGIw4Kzuivbd0/xmNI4WINZ1pk6+HdOY77X8l
+1B740Wfw/9ufe8ils48dUfETllRd9/U2THZnPbOaO2c7G6tXxWen3sj6uuM
dVgxhuXnHcX5VPO75GemzbGJW9V4usXnvil5Xk1c1Txzv3xd0npN32duFxcV
n9vYH9HeHvG84lxsNi9gJvarJX9v64u4T7YgbONdES/o/q3a/6UccbjL8zHt
jcquNHjcX7AfOB7NOf7h4Ibm13X3116f+3tLxDXZ4ZLf+26rMR8SNzOyea1/
3m7cYIbLp0vm5Ntm+8XngHx0yUa1N9lqPxONjg+OV/T2RcXdMeD7vHlSa/VG
4xjPfM2J29k23/9+a8TXt9g/a+zB4Rfdevd652Kz3n+5xb7uTb/1jEvMK5k7
co6uftK73+vxHm9ZLJqXC/J5odOY0dfegjV2oORckBP4vt5tzv+Qjz97zAEa
Qqto9mTBOvqnwXphDs6z0ldHYu7UO+qp8UVp4LLeuSwcP6gOZsX5J03WCyP6
x/dazn/vsUbBs1T0Pfg5JmzzstvWWZ+zyRX3+ObuE4r1eL9rcarVuuQMZzlD
3sndXPKPzeY689XMKXo50mHNPCctPys7LowPSqcPl83Bit50fqtr4i/hXRZv
BxXv44JrA1xV7a2V/M7VjIcG26SRR8vOI3hf32zM3D+d/QNe4fc/nus5P6V7
u3udP7RJDsnvWOaRvIMV3aAZdIE+yAv7Y1l39BF84pt8Vdrsf7jTuSfv4JtM
jf2mmDfKrkViTOc6OVrMPsId3nAxe8Nw9gfGm2cazAWckC9iEnst9XU8e149
MYFnj/BcE++1grlvHTD/6OjHDvu7yV36xxd3FzI+62A4VjJW1k72W5doCy2g
iVr2NPoQ2Ce2ab/sPktPmshexNmpPH+oZK7h6JGy8wpngxuFu914rm4S/k1+
G9qoFR3nNeX81HrrjZrGF37YX0gNNQ1FNAz9r6OFrJGZ1D5z9irJ4Uhqgj7D
P2ep4jxRl/QUNIAO4Yu45GQp66tWMq9w3iG+C32JN2uVWI/pfUtl/3M2yF+5
2zU2nX0OPdBD4Rqed+jsciX7l8YvN/gfyLvpR2A4qvW5QcfYnpjAgwbm883k
YCT7POPe1Dy65p+JhtHdSvbrj4rWKXiIzTfze1TXD2zxP5haOJD1Qs3V8z4Y
j95pnHALL3ACrl35XyBP+MXnk/3WChinKq4f6gBtNg5Zn/wzwLov67GWvZq8
VdM/Mc8nP/8CdBVGyw==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHl0VdUVxk+ETFCTvPfykkBCzEAIeYkD0gKhBQtURWoQcbUYEGxRKLQV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           "],
           VertexColors->None], 
          PolygonBox[{{9328, 8978, 2355, 9483, 9327}, {7165, 3457, 3456, 6530,
            1556}},
           VertexColors->None]}]}, 
       {RGBColor[0.8207211067474576, 0.866369502734569, 0.888006684233579], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1UUUxuf2cdtLC/QW8BZKi1B7W1AjshA1QNWFgMQUq4nRLjRAIxGE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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0ldUVxW/mPEJekvcykACBzCGAVsUCwUIliLosg+BaLUShtS2UQSBY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           "],
           VertexColors->None], 
          PolygonBox[{{9980, 9968, 919, 5025, 9979}, {6819, 6706, 6705, 5089, 
           1581}},
           VertexColors->None]}]}, 
       {RGBColor[0.8420692574736486, 0.8734885421601335, 0.8784427318390198], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlltsVFUUhnc7nc6cgUIH6Mz0YqFTWinFFwMJoRqBFqGFqIA+acQYjZZG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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHlwleUVxt8kNvcmkJCbuySBkJB7Q4Akou1Ay2ZFCMa2M4TNPyrrWB0Q
quwUcFiKBqGjEgRbFUEFppVFrO1AGLFsVacKSMI6BFQ2QSCQBClxRKC/Z87b
P565J1++77znPe9ZnvMWPT552DPJzrmxSc7dw+/rWc5NCTs3GbyG/GUX59K6
OhcEp5CHFjj3Ur5zL4IhyHU8XxnhN825g2AgcmNH566AAcjLYs69Uujc4oBz
LSywI9e5XWAn+BCMANMznZsGhiP3Y81j2c4dBX2RL+Y51xxyrglcQG5F3xlw
GtwEoc7Ojed//Vi7L/g9Oo62c+4ImIR8DRuHJZx7LujcTGzoUI4+9tYE2iM/
WOLcj3w/m29ngVz0pZc5tynduUH8PZ81RpU6NxLMQ96DnWew7TTYjfwmeq5i
ZyNYJZlvH+P3t6ARuVOxcxEQBoXgBLbcj54n0f8RNt2PjTPw5XRwH/Jw/r+V
34oks/lz/j4GjoLPwCjeGwkOpuJz8EyGc//l/RvgaeSL/C7nvRpwAbkd55MB
tqc49x77yWbPZ7GtHv2D2mBDkXMN7P8E2IE8pZ2dkc5mMvKjvD+f5/PACOSt
7HNXB+eqWXvoT7CH5/XYUye7kD/gm76cUx/wd+Q9Oeyd/2WD3chX2zv3O/z2
OGhEdqybjL4kcBfdMWIsQtyEQRR5WCfnRoNRYCi4zndL0bMEtCDnsU4GaAty
wcvoyGV/OeAl5KP4vB+x2BccQc4stzPTWWUgL8y3GFTsLUB+DjsmYfdEsAj5
LGdYwbsDwRnkq8TT3ZDF0gxwmW+Gse5QcAl5DBgN6vHPoVT79ix2nMkyHa18
e413r4KbyJ3Zx3VwBV++w/t/ijr3RTfnDoClyAHlGX6tAqnIF/lmFfIb4ELI
YmcCGO9j6A4+W89a68DtLubrr1jryzzzeRo+38h7G0DQyxF+w+3t2Sx0jue9
hcReT2LmCDZsxze14DDyH+LO/Zv43QtmIW8m5hqRr4BNyNt4Zxl+exlsjVou
qKaolign1oF/oOsDsBZ5bNx8Ll+PQS7h+bOcfQ/Wvo5PCnn2DnrfBgXIzTnm
M/nqMv//DfKvwUZqyyaQQ/7OCFnuVqgmcGavcJbLQR/kZnKhgjgYCJqQXyQG
ssiV6Xx7nXw4jE1r8MVqcAg5OWwxpVhKQt6XbXvWXj/PNlur0PtDutl8l3XO
o/ccuIOchN+DOkfgkOuoIxfAN+AgCGLrHfb+LvvJI56mlluNU22bgpxgzVr5
FcSR93DuMdZrYL2jAavFc4jJ2QVWk5/lnb28uwfMRa5ER3/VOfBwudWqxTyv
DlvNWokfNrL/DWAF8tfYsga7V4OvkGPEQis18iaIIteyxiTOYSLYlm+1eRbv
zexgNfoJ8mwt51HH2WRg3wjsWsnzSnzzFHgauR7f1HM2BSnWCxRjii31hAn4
ZCVYAcaDnyuuyftpoCfyKWzI7Gq17Hiq1cJDfPtIutVE5d5E1ngoYDm4qczO
TGe1EXlPmZ2pznI38gL2nMr7l4j3b4MWu3vRtydqMazcUQ+64HNIuZbC/pJz
LOeC6EgD77L+28TQVM5nEHuuAFOKzDfKeeW6fPQCfp3DPmeDxe0sNuVz+Vox
2phtPVC97wryNOKgAj8MBFNjpls9eIhf4zh+2QUa8OVf2fN59LRVTuD/fWBb
memUrq3Is7FjbL7VpqG830ydSUFvMmjqZr0iBLakWc9oi77V6HsTtEHejP9L
yI1Cvt+O/pHE/wH+tx88hnwVf54Bp0FjscV2H9arTbUY/1UH62HqXcPBIx0t
Z5QrlchZ/H8uek6kWAypVmwB7/macR4bGzmbK+AccoQ4LAXdQDhutbY7Z3tv
2GruSZ7VgYOgAUxTPybWw2Aq8gHy5Fvq5EWwX3WG9U+j+2vwVgfzvTiAer/O
QL1IMalYVE/6Pmo+lO9ao2ZbP+zsm2s2ZuCvzrlWy0YFjUupRqs2i1Mp1sax
77EdLebSss1m2RrMtlqimtXka0oNvvkZefxTsCxivU0+rPQ9Tr36l+h5IGo9
O6ur1RjVFp2pcmkCGO9zSr5oD/K8T8TFxvA7OmGcTLoU04pl6VTv6s3avcqt
h4kbqear1osjJVEnLoUs15VT6l3iCCN9D1PvTsPuYMR6uGJvHP4Zm2sx+Bpn
MoF1K7H1WtB63avoXhm1nqdaNol3JhZbTcuRTei5hH8/Yo+L2NM/wfqAxdCQ
Ussh5U4V8mL2FeA3FVQnrPaHEnY26gENxGFDwrhZm2SLje/AdR8jqoW3xRl9
TWwpsZ6mXtaMfIM4SItZL1INkm+z2E+7TPPx8rBxEHGPGuTyYssh5U4Z8t+w
vQdxezhoe1DvG+a5j3qgbO+C/pKY7WFnwjiiuOG/PLesiRnXFsfU2o3YdaXE
bBhEPPQGvdQHQQs6fgS3QHOpcd+8HON24sALupmP5dsgf/ePW84p1x4E3fFJ
umYEcC/oHTbOJK7UC9llG2cSV5oVMG4jjipuKo6jve7rZLVLe1ZvEScY43tM
C9/eYt+LnNWQ+XwTxZ4a3g2kWy1Wj1dvV03eUWo5pNz5sNR6WRy7irpYT9Os
8l1Hq32aWQJ8l1pmZ60aXuU5vLj7YOTPiq2mqZb9B7wasZlHs456WClrrsL+
dT7exC16gV94jqFZRj1IvUczzSfq0dgxF3ycb76v81xAZ1BXaGtqrYOFxs3F
ucS1xNFVW8Vpj/y/xsaMM4griIOdVPzx3q5k64maPYIg4GeQpcXW89Xrl4CF
6F0A5jAP3GIPCey8Q5zcBvEyq51L/buqoRnsd37c3r0NnuK9RxPGRTSzaDZS
z1Gv0Yz0fMRmIM0+z0WsV9Xiv/1p1rPU65eCJb7na7Zr8bGoGW9L3M5cZ53L
mfcnjh8qsVlNMdGabT1dvfxmttX+48jHyqwHJOPnPDjhw7y/Kslmpc3o3BS3
mUm1RD1hqq8pmp1UI6r9DKVZYr84RJnNFOJa8pF8I84VCBmHEHe4HDTfVfP8
+QLzobjeSdDgOV89sdyUY9x1A/G8nDOuKTQuVJtiuSrOJa6lnFUsqUaU+ZgS
d1DPUa8Rh1Dt1Ayj2UU1VLOLOL64vWYY9SLNmPf5nqRe3sr/bra3nq7aWkNd
XVZkNVa9RWems1KPke3fYMv5TNvD8UyrYapdx/xeNZNpFtOeJyXM5/K1clS1
4X3e3RK2GtGSYxxO3E0zz9Uc84l8oRquWB3ka5NiVrPmNmrEjXts5hQX0Iyq
2VSc4K2EcSpxqTUJm0WVYx/7mXRFyDi+uL04qHrbKfx9stB63KelVjNUKz4p
Ne6vGUuzlWaAAZxBPusPSLY7AsWWOLm4uGJM3D7Pz57i+JoFcsXfkm0mWB4z
TiwurD2cC9sMrtm7OsVmX3GsNn4G1t2FepZ6le4wqiLW89XrB0dsFlDMK9Y1
E4jrq2apVonzB1hvfQfjVpqJ1Os1Y2u2Vs9PKbcZQbNBMvL32Psk8hOaTcus
NokDifuoRmWE7c5Ddx1tNb/hk7XtzXZxQH27n//tyzQdmj1v8ftD2GZQxZpm
/kYfc5qVNWNpttLMvKLQckCxrzsi6VIPUe+QTt3VKOYUa00+F2WTbFFO6q5K
e5DturMSF9Wdw27PSZXrmsE0eynnZ4ZsRtRsqJqg2NfMrVlbOaBe0d33MvUM
3S39Oce4tO6YxE00I2s2Fkf5CzH6erFxFdXc+aU2w2h2mQeml9ozydNAI7re
j1stW+AsN3TnobsO5UgePnPUuwfSLIbG8s04cD5gNVqz+qc+VjWz94xbT1Yv
7gGWxOyZ5BdixmXFmcWVxWl1l6Q7Mt2N6U5J3FkzdoHn0BNCdqemuzTZIK6h
OyDd/Yhz6Gx1h6a7M51xNXoXgzj7iab4Wh6ztVXTv4jaHZPulg5EbfZUDCr2
NIOeEWcHiaDpEBfWN3pXnPiNTsbp1FvVY3WXpDuRVH+npLsm3cHo7kV3Trc9
J2v2HE1cc6fnRuKcuivSHZXupnRndC5uZ6KzkA3ierrzPOU5n7hupZ+dxXk1
K6vmrPEzs2qJ7jx116maotnrj3HrjZrBNKvvLrLZUDO7aklTgXEh1ZRNXW2m
0iylnqi70yqf67pD1V2LZm7N2rpzEXcTRxA3EIcbxj5GdrHeozu9WNQ4m7ia
Yka1e7qPPdXwKmwenLCz0h3P/wCcQW4L
           "],
           VertexColors->None], 
          PolygonBox[{{6328, 9043, 2179, 9042, 6327}, {8347, 3438, 3437, 8334,
            1955}},
           VertexColors->None]}]}, 
       {RGBColor[0.8634174081998397, 0.8806075815856981, 0.8688787794444606], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2tMlmUYx28QXt6DHF5B4OUggmAhfWg1M0lx1NyEXJrLL2o6ShMPQW2Z
ARt+MJU0QwStpOZqfKFZNkTrS8tmax2+iBu1cmmHrVpT+yBuHbX/j+tyfLj3
3M993891X4f/9b+up/KJ9lVt6SGEZWkhTNPz60QIY9EQZuvlSGkIAxrbIyHk
zgthtCiEEZ17Vu/tmSFszghhiUbn9BAWaT0nK4Tvtf6QBO6TjKPxEJq1/3Jt
CAc0CvT+3RyN3BA+0v5GzZ/U6NH8N313VnIW6HwiO4QuzfOn2TvznZK/VPfm
aGzU+pBGrs8jdSFkaQxL/qaSEM4Vh/CnbGnXfrnGW5Jxn2TM11gRN3mdLvOK
bPq5aup+nty7Rt/t1vg9w57IXq69eLbpxxlkYzP23qv39zNMZqIwhK80Tur9
Lsmv0xjUt8d1fijTfDc7bvubNG5pflNjv+SMaG84w/xZI790azRo/qKeZW7L
urIQmhSXNzWPy+7imhB6Nb8atbVe2b5B8tZrHNN7QyyEXdpbJTlvS5eN5SFc
lL7VmbZfn2b37PK7UplmN3axfybdznwqv07o+2va36d4ls8MIU93DMpvxzQ6
hJ0HomYbduHrvXo/JH0u6OzaMtMP3FxONz3/ke9LkiFcSjfspBw/3M+cOMbc
3+j/RanhEky2uC+Rv1UyHpf8lM61So8d+r4p3WJFzIh3qsj8ha/mRs2/3Ivu
+AIb71bcvhUmL+jMuO7o1f4yjZj2azItLmOy5bNCe8e+3VpbnWbYacwwXdG/
NdP0OCg52yJ2x0r55NG46XkiYt/2BcPxQKb5+nTC8ofcKRGes3It75ql/8NF
hqE22TQ4276JyfaLtRZ//DHkPgHnZz2PWnNCeK3a4vuMzt+QnD/I4Ux74qu1
WlunMexxGHb/E1d8hH9eihuWXwnmvytRiyP64gv8wNpVX5/EmL4dlC2ztLYw
3XJkcs3XOxM25x707XIeOBCZ0uV16f5qtclu8zwAJ+QO8URuo2MdnOSIr/Lm
WR4UKuafVIrblKvjCeM4+A0OIs+JNb6cV2T+bHX8Y3ul5DU5Xg9X6C7F/THJ
v8dlIed81ObEEe5EPmv4Kea+AsMxxw/580bEfP+B7mzXXrfOnNJ3IwnD3dIs
e4K9LsWuuM7uKlKu70ga33DPuN8FRy13veHn487RcHCB83BL3PxBTsdkx0St
YRFuXOmY7JON/Rp7dH9XwmIDTxFb8hm8cpY5GGvQN79MMz0HCqTLnfYekfyi
OuMydG9Luv6ad+TY+nbPCTBQAW9EzQ/omh83n6MrPEZekG8j7kPiMiNusTla
YD5CfoNsWTzdvmmW/J641aj/5OP9tSY3JR+m5xpfr3LuI0ZfSufPS00fdDvo
+oFtchIfjCZs3pwx9Y4fnktabIgLeOQJJrln2xy7i3i0eN0kzsQbLLE26jIX
ei0hR/A1fgVXxBguIk/h775C4/BWz2F4ZkvCsMx8s/zxfNLyHazdznX8yHfk
MmsXoiaTmIE57huSD7IKDUdgEF25G6yB+z7nhJvO87c5nXyPKb5RjXe0NyYs
PJ00uUXi5qPlxnnoBR9N1jXx/7lS4w34n5wn38mdnojlDHyQcA7nnZgRL+rJ
Oq8p2E0uYzt1YL3XAnzb7Pl7Ji+Ej0utzoLvU55rrZ53xGJAz36Neud19F3t
+f5uxGwHc5e8fj2i2K6YY7WT/RN+ZpfXbnRFZ/KfOb3OPufJmNcm+LnBc4g7
0aXVfT4hzrtebXinhrR4/q7x3gR7v1GNKC6x/uBklfU01KLV0mtLjvUO4/nK
i5T1TdToes816uAdjv+JiPVUnCG2aQnzFXqAP+yCb0PCME6M25x3Zqomdtca
b5+QDjeKrVc7W2n8C/ceKrT6Sqy2Jgyv+Jyeoj1pvAgPUCfIWbA55vjEvuwZ
ZiNr5309pTgXl5nvF0XNNuya5TaSTz9Jnx+rrD6AoSXepw14vwKG4a0jBZYH
2IS+1Jjr5cZrrO+VfXs0cuMWs0bnj2Hvg+GlD6nRScMyeYYP670m1nh/Ve82
oic+ouZQ/5d4jdzpvd9cj0u3f8v8X+GlRzok44bBGq+z1O2nSqxeEof3qiwW
2Yp5KmVxJQeaPE8va/+HKuNcOLLCfQ6nJp1X4blR5z36vLneL1FP8r2mwLPo
fsb7pF7nK+oG9QMuPek1Hj9vUKxeSBreybMBXz9SblxAXnC2w9fByFbnNXyZ
7pgEn/1+Bn8yX+jrHe5zYjuQmPJ3hfv8b93zV5XhBTtv+5K6Afaxh3u4jxjS
m3S6LdMLrb/Hpl/5b6iy/OHfApvIX3irxms/e/RMxA751Cd6OfxEjoNhanKD
1yz46XSe2YhMajM8BubobcAcsVzq/z7cOd/PgFf+SeiLkIdc7uK/jT6SObna
5mfgP3iQHDxUYbWf91bPTbiFurXA86VRuj1YanUVXLR4n5mjvEyV2N0rvZ9Y
4f8f2Iye5AjfgTF8vNj9AIct955/i/Me+pDn7d7nwZFwJfmFXOzFz4eLjNeQ
d1h69ZcaR272Ho7+jdy6P2L4JPfjLifN6xc46fc5+Jmsnd4Pw3O3/L/smtdP
ZHaKD/JKTS51Dz9cduzdcjn0DegCV6eljBPJ9f8BR7vlOQ==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mGl0lNUZxy8kJJPBSSbJzGQmCZBMAoGEitVTNRiotMS6nRK2fpAdUYlE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           "],
           VertexColors->None], 
          PolygonBox[{{7405, 6460, 6459, 4017, 1780}, {6870, 6871, 1564, 6679,
            6869}},
           VertexColors->None]}]}, 
       {RGBColor[0.8847655589260308, 0.8877266210112625, 0.8593148270499014], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHts1WcZx9/2tKflnLZwim1PL0dpKcjhHP7QLe4PZyhl03lJcBfWGJOp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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVx28WQvLSJITkvbxs4EsekLyEorZTWyiUxYC0TkuC4HRYBBQ6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           "],
           VertexColors->None], 
          PolygonBox[{{10762, 10761, 10760, 9095, 2213}, {5590, 7062, 1537, 
           6329, 5589}},
           VertexColors->None]}]}, 
       {RGBColor[0.9061137096522218, 0.894845660436827, 0.8497508746553423], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWtwldUVhr9zciGXQ5zYyQkSDkpC0ERE/dEZnYJOBZGLjZgwUwLoIF5a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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0ldUVxS/hJSEvJBBC3gtJHpK8F4YEGdq6qgXBioCIUgnalkGK1hEK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           "],
           VertexColors->None], 
          PolygonBox[{{3703, 6231, 6230, 7298, 1748}, {5030, 9985, 1536, 6324,
            5029}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXts19UZxs+vv/bXexUrLdiWW1tQWjdl0S2D4qUgMkAcyy6YCM6YjIzN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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwllnto1XUYxt/tbDvu2Lzs6C6ebW7zTOfSTIIuOLXwVuioJkEGqUmWIFlR
ToIcVJZ4L50uTWmWlEYZZUSWpVZWf4RZllGQeE0lRW1eapH2eXr+eOH3nvf6
fS/Pe2pmPNo8Jzci1kJ50A9FEcXXRnyRimiDP9kj4mBDRAf87vyIokERw6FV
hdgkIn5F3pmO2Mb3p8gXDI4o7xsxEmen4UeWRDyNTi3yn/ltRWnEcuhu+DPQ
xp4RRzL4K4i4Df3He0eUQuOTtjmfjSiDz8JXEfNb+P39I1bCZ+AL8DW7gt+w
vxX7DLrVxG8iVi3yqX0ihmHzVbeIz+ArkF+Ez/JdB7ViP5/8DmC/C/t/a+1D
tmOxyeBrVIlz30XMtgERq6EtyDZDCXRnV/MOZHuxP4r+67znMfxtwiZZR97o
1CO/Hp/zyPWGsoiJOc5Zb2msp3aFflMF+pXQHfBnkBfwnQ99Ti/uIt6DNREz
oUHo7lHPkCXq/D0EmznUc0eFbY8Soy3tHqk3K6lnC7negvynhHOexVseht4h
16X4f5u3bm5w77rnuzZb4dtTrlE/Yt1bFTEt6Rzbkc2GzmA/F51c9Efifzu6
h8hpDb4/yDgX1awI/7+hsxPf72HTydtPQFUM4dfI/6yk59AE+DuJ0Ul/jtOT
LLLF+HuO+boMTU55xlTL0WWutWr6EbXOYT5XFHrGNEuaIc2OZuopcunktzLy
mwXNx/8QcpqRck4Z6vVSr4i/sV0KrWJ+mqE2bI/BH650Tsqlid+OwB+FJiWd
cxX930WMF/A9iZwuUJtj+F8Jv5EY3/H2WcR4EV87iPcj+3aV943jfdvw+S78
3uKIRchfRn4I3/N6O5ZiVBO7ZUjEs92pJfJLg11T1VI16cL2Y3ysRbYEHylk
F9Hpm3KPW5mPb+jPOfJ5i5hXyOVN3vtPwjt8O73orn1JeCaHEW89PhaivwGf
KWxLoIN8j8PflVrvjHZFb9BsTWfGOpKescPlEQ/x5r0Frrl2cUTWvdZO5jBP
uXWe3Q95fxrdSmZmKrILwiViz+S9j/De8fT3DfK9MDBiWaF7rN5pJ7WL6mEH
9RpMD/YkvXMb4IfyhudzjCHK5Vy/iBsLnNMcchmD/2b8L6R/XyLvlXbvP+GN
AZ+H/6Zu3sFS9AdkPQuq0SFm7RK0mVzeh9+dMYYKO1Wzq+heybq38vEHuvuQ
j8qzTTOx9sCvI9YK7JfwnqUN3qUF2HeRawf5H0g458C+a6BroxpcU+8cFHsL
/F/Eupx1LYVxa+hHe4WxtjnhWq4jxtg813QovSuFTsP/rhmjF6srrDul0Ldg
a4lnTTehMe0Z1uwuR+cBatMC30R9V2Hf1ds7pt0qF17QizEZY4liTgO7Jtd4
djSD2o0uaES+d6SR/M6X21Y9EdZ1qzN2CvOENc9AT6aMOceZ3Qlp51IEn58x
JguLbyrwLgxEvizhnTiH/qtpY2EP9Ien7UO20lGte2Zsq5ovSttGui/BnyL2
fqgx3zdxE/5ra127dn57Av316HclvOPqbWvatupxDfW4lPXt0U7mojuRGc1J
GgNf43sj9H0YQ6eAtfdVGQtVY90W7bB2VzdG2HS20vL/MQrf57K+jfJZrtlI
+1Zvh86WGGOELap53SDfYN1e3XS97WqDsUpvPMbbptODnUljsGZlDHQi6Zk5
RT7XlRob1qmfxd4h7c7ihLE0P20sEqbuK/VN1i0Whuj2r+7p263/ADfXegc0
+4oxLmNMFZbqpusWtfbwrdJN0tvH9/HsqQYn0D+Z8S3Xzgsr+5caO4SZv5Df
aHI6nTDG5uCrYIBvq2ou2dli5y6dlgb/B9J/H83cPdXuuXotjFNt9B9B/w1U
I/X+/rR3WTMgbM2p924KY18pcc1UK92IuVljkLBHmKfbOrHOu6cb+x8H92Mu

           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3543, 3586, 7229, 7228, 7586, 7585, 3542, 3585, 8966, 8965,
            9478, 9477, 3541, 3584, 8964, 8963, 9471, 9470, 3540, 8959, 8958, 
           8957, 4379, 5408, 11339, 5407, 6981, 5406, 7104, 5787, 7145, 5934, 
           5935, 5788, 7105, 3538, 11026, 5806, 5805, 5920, 11382, 5919, 3690,
            5785, 11365, 5786, 5402, 6979, 5803, 10919, 5804, 10920, 4459, 
           10628, 5401, 10627, 10743, 10742, 5645, 3805, 6013, 5676, 9108, 
           9109, 9110, 7092, 3950, 7356, 7355, 9499, 9500, 9501, 9498, 7768, 
           9547, 9548, 7317, 7318, 7319, 5271, 6031, 6030, 6756, 4536, 9985, 
           5030, 9972, 9984, 9978, 3609, 9967, 3603, 8989, 8983, 9333, 9326, 
           11331, 11338, 11324, 6641, 4602, 7033, 4595, 6634, 6625, 3686, 
           6896, 6906, 6048, 6927, 6917, 4355, 8299, 8310, 7225, 8288, 8277, 
           3492, 8738, 8749, 8727, 8771, 8760, 5771, 10892, 10903, 10859, 
           10881, 10870, 3816, 10974, 10985, 10963, 11007, 10996, 5860, 5882, 
           11380, 5871, 3503, 4814, 11182, 4825, 4159, 4847, 11193, 4836, 
           3780, 4880, 11215, 4891, 4241, 4869, 11204, 4858, 3514, 4902, 
           11226, 4913, 4325, 4935, 11237, 4924, 3791, 4968, 11259, 4979, 
           4252, 4957, 11248, 4946, 3525, 4990, 11270, 5001, 4336, 5023, 
           11281, 5012, 3802, 5107, 11294, 5118, 4263, 10241, 10252, 10208, 
           10230, 10219, 3536}],
          "2.6399999999999997`"],
         Annotation[#, 2.6399999999999997`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{5143, 10009, 5042, 9997, 10033, 10021, 4001, 7138, 3989, 
           11070, 5894, 7275, 7287, 6195, 6207, 5615, 10727, 5603, 7075, 3966,
            7368, 7380, 8543, 8531, 7178, 7190, 6084, 6096, 5214, 9263, 9275, 
           9287, 10483, 10471, 4098, 7499, 7487, 9432, 9444, 9456, 9420, 8147,
            10300, 10312, 9227, 9239, 9251, 5255, 11317, 5267, 5202, 7663, 
           5190, 8159, 9057, 3702, 6231, 3703, 6256, 9549, 7769, 7770, 7664, 
           7666, 7665, 4125, 7650, 7651, 7648, 4471, 7649, 6131, 8933, 8932, 
           8544, 5403, 5694, 5693, 3708, 11033, 4465, 4375, 9457, 4376, 7581, 
           5933, 7143, 7144, 6015, 6014, 3709, 10926, 3710, 9064, 9063, 5642, 
           10741, 5409, 9462, 4380, 9461, 9464, 9463, 10638, 9473, 9474, 9472,
            9476, 9475, 10644, 8548, 8549, 9480, 9479, 4382, 7584, 5417}],
          "2.6399999999999997`"],
         Annotation[#, 2.6399999999999997`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtM1mUYx/ELF1vyeErzCQ0sEDyUa8611WQyQ4PVmgty9aYsaUZjoZti
s8iN2DqyhoJaWwsEtFdWWr6QNjvhqdRsuCVu2YlmafXYHuzFQ3n4/F98+f2v
677u6/7d1///UFK/rm5tXkQ0+HNqYsTFuRH/4iek5lnA+1MirkyLKF4QkaVn
J0V00SnibnrJ+us0X7yZHtKnNsnfGfE4fdf6ejombqDf2l9BfxNXJ2p9YdJX
XE4H7M9NjRgU3yDeYn1msk88mQ7aP2L9gDhDK60P0w/EJ+mH9mfSERv4ydER
jN4RcRVD+APn8Ls+G2krGrED7XhT/T2lEVVIYwFK0K/vytsjnsS9RfbSRoy7
ic9bIyah5xZnznR3rNH/5xkRF5BVs8l6jv4jruDtAVShqSyiGenZEUWYal9m
TkQhzdFrGMVud99fGLEX6ydHHKRf4vvpvOs9oPewcz+lX8mP8nhW3VJrhWpa
50e04WVMMKdlet6P5UjZ01UcUUA7eNrm+Rle1uBFPl6SOyHXQk/Sb/Cc2uN0
ljv3mdvb5tZL36H9dDvdmcyVvkd70I3l/Oyy53TyvZnrBczm7y2+HpJ/usR3
IF5Ny2g93S3/t7q/8CfmyU/zvrvsGcfjFfP7H53ia/pupXny/8mNYYv4qnwH
Dfli3nPyc/TZ6k5zaSn28/qs+BNazec+ul38MS2yvpc2iD+iPe4+Q5+sPt2e
a/isRhv6nVOlvo8uo7voJnP8XN2D9kws9/5pu15Hk1l7PkK/xjHc6L2tcH6t
u9bhYazEI+hUu877rfJ+m511n/69yXv13CtXYMbjMZ/Hx/RvlV+qZgOtmaUH
OtS10HIzDGe95vkyf+3mnLo54gszOoFhrHXWGTV1ejYnc0l+M3QVPZDMj89D
yXvi+zv6mXN+4PEFXg+rG3BWk+fVeEVtk14p3+ke+TQ9ps9BpHyT59QMod1M
d2CP83vxhj0tfIzpn3XXfH3rxW16PEo38v6Uuh9v803zn+GllnbibjN4lZYm
vzEUoMb/tQoMqT8uvoQRnEFl8o6Q5//KeTVZVMsvxl14Qq9T5jSI6c4fjzp3
XoXTno9iM7997vorv+f5zdBKPhfheeuNyLd/iflvU/uL2p20zP/dhZiAfX7v
hTTtvOsqMeTv
           "]],
          "2.4`"],
         Annotation[#, 2.4, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Gto1mUYx/FLGmrTbWo+PdvUcjrMnCIhGA6HTJoU9cJjL/KQWyoMlmfJ
liCBOZ2ROptBVJboi7IoMJqCUWxjeShlkS7IPCzUiTzGdMGz0vTzf/Hd777u
+zrd1/3fU1KzZv7qARHxij9n8yJuPhXRh0vInRjxgB4eFnHvsYjRkyN66e/5
EU20gP0xve28geawt9A2eeYm+2URi+mHztfRfvYq+ov4cvoXuypR51OTvOxS
ekx8dkREK/sR9m7nRUkcO5+2iu923sLO0ArnXfRL9s/0K/GZxyPW6ydLu3Fn
UsR9dOIGLuK6PBvpVtSiGY3YyX/6uIhKpFCGsTgo74KxEcvw7GixtBYDhutz
VEQePkmrWezuWCH/5aKIHvTyecN5lv7NLtfb86hEXWnEBqTGR4zCcHGZCRFp
mqX/4w4OufvRwoivsa4g4gT9EedTEcfpQrHf0Qtqd6EQeebxgbr5tIi9coz5
6vFFfbTbX2y9BKuSM7SJb0efvTV8bvFZS/9h1+ixGvtHRrylt0LzXu3sJRSZ
RyHS2K9GM7aZWZv4Ffp6DTU4ZbbvPh2xC/fNs5He49cn713sTGz7O+h/9ovl
brAe447X2TfQgy/kmaynMrSq0em8w149eyBN6+1NPVY6m43P7V0SdxlX0JLc
T51/rfuRTd5ZjqH8huAMar3NaXpS/Ck04310oAn7UOY83zczDAX4Vt5icxzk
fZqsz3uzCu+dMZeZ9BZdQH+zf4Bfj/t9VGJmau+lu+g59+3xBk3m1YDB8k5U
52X9bOUzi896OueJiPl4T856WurOD9x5u/Vd2qh+rrf6QY4z6MLryfeht3ly
bpCzKvn+6VLaIu8ed2qj1d7vHP1enT/0uNl82vkdU6vOejm28a2TK9c9jthP
0Z/kOYFc39tFPp1o9K7NOKL+p9ghpl4f/fL3umuOvNXst+VYRDfq/VV+fz4Z
8Zz+M3qZS/dimhm8Q0uS/xc8ijl+p8rRyf80+za6cQEVYl9A+I24xqcXVfZn
YAqWyHU2+YYwUv3BmOfOS/GrdQe26Pczd72q32v6zdAKfT6DTc5rkSN+pvnv
43uF7wE63m/nVAzBN947TVPqPQQ7KuFK
           "]],
          "2.16`"],
         Annotation[#, 2.16, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Gto1mUYx/FLh22POFv5uINmHlapc4gERsMhQpNO0NbKNzoPlOJs5lnL
hCGoqwXpZpMSSzv4ykRJcAqKa0ZBB2WWB9osm6dFPOZ0xYTK+vxffPf7X/d9
He/7fjb2peXVywZERI0/p3Ijfhsf0YefkZoQcZfuzYv4e1jEyNKIXnphaEQz
Hcr+gN6w30Cz2BvoSXkqk/VJEbPpTvsr6B32Ivq9+DJ6mV2RqP3JSV52MT0i
vv/+iHb2QPZW+4VJHDuXtovvtt/KztBy++fpZ+zv6H7xmfyIlfrpp924VRLx
DzpwHV24Js9qWo9atKARb/GfOi5iBtIowWh8LG/1mIi5eOwBsbQWcZ8+R0YM
wYcFao4wO16W/5eiiB708llnv5/+wS7T25OYgbqHIlYhXRwxAnniMo9E5NN+
+i9u4VOzHyqMOIAV90Yco204OzziKH1B7GF6Tu0CLBE/y1rbWGeGfOfzBb3A
P8d3CoOQjXtwQn+V6JS7U9xPmOIsmrBQn9vo9tER76IZTdjkHF410xlvZUfa
+dIW2jcq4nXr8+3Pw1y8wv5zorry9NEc+qzzegY31c1m76Wl+nua1oiZgx/Y
XUmc+Pec0068j1rzrbO2mFbq9TksYW/h24Bud3YZV5BR4yA9gHp7w+Ws4z/Q
rEUPR6wVV0DX0EI62HkUiamih72vNv200ufZzcl5mO8T+4P459l7w8wl7F3e
wzLv5C/3sF+tAe46R60imovP1ZtGfzdXNf3Rne52Vz3y7HI3O/g20bfpaX32
yNOszwZke5vj1Z7lLur5TOezks58UF94R871tFiPd53JFt+3aaO+Uvo7Ice3
OI+lyTvRS5Wcq+SsSH4HtIa2yrvNTCfpAnOepsfV6dTja2b6kt8Rtep8z8cm
vnVypcyxz3qafi3PMaT8Hrv4dKDRnbVgn/p78KaY9fq4I3+vWbPkXcDeKMeL
dLXe5/G76J09of+MXippEx51BpvpmOR3gxzM9PbK0MH/G/YNdOMcysU+hf/U
vMqnFxXWH0cp5sh1yjm1Y5j62agycw3O+P4KG8R+ZNZf9XtVvxlars8pWGO/
Flnipzn/7Xwv8d1Nx/kfOhmDcdB959O0ev8D87Hblg==
           "]],
          "1.92`"],
         Annotation[#, 1.92, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021olXUYx/FrezFPtOMeTnMPmbblVqYShdLYiFWTeudy+aZWLiRYLHJq
VGLYzLIWmC4WEdYq9EXoLBSZglHNUCgfWA9apFar2WIc9WwSEzKtz/3ie373
df+v5/99qld0ta7Mi4jlfo6nI/66NeISziJ1W8RVuqM44p9MRNX8iBz9cXpE
L02z36PnnW+i+ex19JA8S5L38yIeoe8676KX2U/SY+Lr6e/s5kSdL0jysmvo
fvFTpRFD7Dz2m87Lkzh2IR0SP+J8kJ2ljc5P0V3so3RAfHZGxCr9TNERTNwe
cQXD+BOncU6eNXQ9OtCHHrzOf2FNRBMymItZ+EjepTdHPIZFM8XSDvynft6N
Edfj/XI1q8yOFfL/UhkxhlxJxHPOp+gFdr3eHkATOudErEbmlohKFInL1kWU
0Sn6Lyaw3ex7KyI+QVdRxEH6BX4oizhAW8VenKWfpAYNu8jRmfq7P8njfRO9
D/diHFfMNMmn0TwNuKbHFL9id1+CNIowHWf1M2m+S6jFBHL4To4L9CLK9dI9
N2IG7TVbob09YaftOCO+m70BLyHN/2VaSM+pW6XPdzx3qF9SG/EULaUhX6Wz
XTdEVNAW9/yi5zoz1yItb4nZi7FZzT5xi8S9TZeZ7QXv+802zs4zcwHttu9p
dANt84232ucf9lsqfpQO2t12d7gDd6EOu9UZsIcD+NK9/4RjWKinj+k+bMQ2
bMEz9vK3/gbMGO58mp1U0ELsUa+BjutrKf1ezX41xvS0rVrvfLfSN+gJ84/J
02uOTSiwyzrf6DK9rudzD59VdLFZH8JmOdfSGnu6qudXPU/SHrtN2dvncnyD
U3ha3pN6aZFztZzNyf+BttFBebe4l0O0/SZ90M/U+VmPz5vpK3771er0vBwb
+XbKlTLHTu8z9Ig8B5Gyz9N8htFj533Yqf4HeE3MWn1clj9n1nx529ndcjxM
1+j9cX5nZvuO9Z/VyxK6FXfawSt0dvL/Se4Ui91PPYb5f80+jxGcRKPYB3FN
zVE+OTR7fzfm4VG5jtvTEErVL0CLmdvwrefDWCf2Q7P+pt9R/WZpoz7vwLPO
O5AvvsH+3+L7K99+Wu07W4Dr8Kn7LqMZ9f4Hi63byg==
           "]],
          "1.68`"],
         Annotation[#, 1.68, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV031olmUUx/GzQhda5h6ffMk0Zy3NRhRGwxGTJpVWW2v+UZslpDRahHNR
DcmClbWgNsMFtdKkBLENCWIvvdhmTZhNmYUWWauVNR3PZBU1odyqz/3H9/nd
577O9TvnXNf95G6oKd+UFRGP+DlyScTpJRF/4HtkL42YoO/OjPh7VsS8/Igx
+vWMiO30YvGbdNT6Npol3kIP8ilJ3l8XcT993fomek68kfbbX0B/Ehcnaj0/
8RXn0g77x1MRPeIQv2J9drJPPJ322D9kvV2coYXWT9D3xF/QVvszsyNq9DNO
h/Dbsoh/MIBfcRK/8KmlW1GFHWjAi/KXL44oQgpLsQC7+ZYtiliHm66wl1bh
X/VjfsQ0vDVHzcvNjof4D86LGMZYTsQT1sfpWXGB3m5DEaqvjtiM1FURczHD
vsw1EWk6Ts/jHXNX8q7ARt6r+XR6bpZ/dqEexBk6SUfpvd6XoZF/p3d35kV0
0fuszdfvGnGH+A7aTlfTJXPNpmaJfXejTk9PoUt+n977nMt+53OYpsQ52KOH
Ft/Iaf29Qc/QC66NuBBZaEtHrMw1qxrT1DiwIKIbn2IW3094pOlacTnW8T4v
v5nva/jcfe5xr710lMcGs2dokzOctLfenVR4nvD8ME1fFvEMrUX/pb5j855B
F46hF6VmXGm+u9AsbsNuzNTHX3oM5/0lHcEgnlbjUPIOH2IEg+jmX6SfNfjZ
3DfSPLTxb/Xf6US37+Mb9GM5/730A9SjBY14jP+fzr7VN/YfnWqGOfqfjvfV
WEFHfG9l9Ct1dqox7AxaknOS20Rfoked97D92821DVPcVZ7zXOsb2CrnFjk1
dJVZ78HLPOtorvOd0PPznn+nDc49270d4HEYJ/Ao3+N6KeW5mWdx8r+hlbSd
b6PzP0jXu8Oj9GN1vtXjk2b6TF6HWtWeH0S93Gpe2ebY532KHuLzEbLd80k5
A2jw7e3APvV34QV76vRxjv9Y8n3xXS9+lkc5rdX7A/K+uzLiVv1n9FJCm3CD
M3iOLkz+Z5iKVe6nAAPy+8SjGMJxFNp7OybVPCVnDMXe34xlqOB1xDn1IEf9
KSg1cyWOee7FFnvfNuuP+j2l3wwt1Of1eNx6FbLsX+H8X5X7g9yddJH/UT4u
wn73naYp9f4HNsXqgQ==
           "]],
          "1.44`"],
         Annotation[#, 1.44, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021o1mUUx/ET6ETN9HZpapozZ2ozLMOxERMnahJO0Tc+NSpptIi2hSLi
Ay6tCeoUhXxu1YthigTmtCQ3y4E1ZS40cW61Mq25ydRsgjJtfe4X3/v3P//r
XL9zznX971FLi+cXPRYR+X7O9ov4a2zEHTQhZVxEF/1iQMT91IghEyI66C9P
RGylfcV7aLv1DTTEK+kpPrOT7zMiFtCd1t+n98RLaZ39mfR3cW5SrWckfcVp
tMr+zoERNeJuutn6oOQ+cR9aY3+L90fFbTTb+kX6pfgnetD+tsERRfrppC24
9XzEA9TjGhrxJ58SuhoF2I4yfCx/0rMROUhgLIajgu/ctIjFeHm4vbQAj9Tv
HhbR++mIvU+p6bkdb/JvHhpxHR2JiGXWO+lNcabepiMHhekRxeg7JuJV64/T
mfQYr8/N+5laFbjxTMSU58xGb4tvobF/xHG+dz3/gzuYqP9P7D1nrckdNqNq
tPPC17jBc431k3o8ocda6w1IGxWRhQloMlMvmoprZuzCbZQ7g2W+iXV4B7uw
Gavk19FLqEQ1jmAx/6F6HoN+yMFLeENve51DJX5wZ+X0Lf2sp6VqLKRd5nqb
pg7SLy1BXXIm8/+N4ziP08hTZ4rZXsMO8SFUoL++/nWe3WhAK5qxSo1afTTg
G7SiGdX8c/QxC384pxdpOg7xP+iMjqHaOVxCHSbxr6RHUIrd2IL3+N8dYo/v
5j/a0wyD9d8HX6mRRVvd1Vz6szr71Ljuznc77x1yy+lGem689/ZvNdcG9PB9
prvf+b6b1XJekVNEp5l1DjbxXEHT/Be69Lw++a3QMved8mTEdzx+xEW8y/eC
XvJ4FvPMTf4X6CJ6lO8W53+K5o/QBz2hzmU9LjfT9/Kq1Cr0/DpK5RbySjHH
Ae8TtJbPt0hxv41y6lHmO9+OA+rvx0f2rNDHPf4dZg2++eK1PObREr0vkXdl
ZMRU/bfpZTYtx0Rn8CEdwS+BnpjmfjJRL/+MuB0tuIBse2fgoZpX5XQg1/vJ
GI+FvM46pxoMUL8H8sy8COc9n8ZKez8162/6varfNpqtzxfwgfUChP1Zzn+b
3F/l7qMj/Rcy0AuH3XcqTaj3P2Mt6bc=
           "]],
          "1.2`"],
         Annotation[#, 1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03to1lUYwPFHdJLi5W3e8/JmM7Mp3lA2ZOKEIMIp5R95JbXmBVEniYxp
NG8T1Kn5R5mW0B/DCxF56SK6rRyoU+dCHdmmU9MaG06lFIxZrs/7x/f9nnN+
5zzPcy7v0PcLZq7qEBHT/VzoHvHHaxGPUI+0ERFt/FUi4mmviH6jIlr5Wo+I
ndxV/3Nu8X0Tt4+MKORKcaalxvXf5U99X8FP9BdxtfUT+ZZ+bsq+Z6bi6if5
hPWP0yMq9J/zdt97p9bpd+EK6xuNH9dv5mzfr/Ih/fN82PrmvhEr1feYG/Eg
M+If1OAuruN3cQp4HfLxCUqwxfxxr0TkIIHhGIgD4s54OWIOxg+ylvPxr/zP
X4p4YWDEvn5yardggfgNAyLuocj4sxedkfZivsStfN94pfYx7BP/tDznUZiM
2I3N2Cp+tXh1ONjbHE7K9S2flKPKPdUiOTQiCyNRb01nTsddNbbhIUrl+NCd
fowl+AzbUZTKwXUoQzmOYo74/YdHDEM35GAs3uupXjWX4WdnXsoL1bORi+WY
xW1q/IDT+0Ss5wJUW1c/JOJPfI/LOIM8eSZnRLyFPfpHcAA91PX3q84XtWhC
A4rkqFJHLX5AExpQLn6OOt7EbW9lDGfgiPiHndF3KHcOdajGOPHL+CiKsRc7
sFz8v/pb4y7+40720Ef9XfCNHFnc5A3M4F/k2S/HPfe513nvMbeUt/LF141b
v9O+NqGj95Xhfb3jba4zZ5I5K3mqvU7HNjHXctJbblPzRu2HXOKdpLn7U2Kc
w1UsE/eKWvLEXCVmbuot82w+Lu4O51/J8werg0/K86sa19jTT+adkGup9jwU
m7tUrLTUGzOe4CpxfkSa+71uTg1Khvmf4KD8X2CzNWvV8UT8VnttT+XT/0iM
t7lA7XPN+807nqL+ZrVM41KMdgYbeJB4CXTCVPczETXmn9VvQSOuINvaN/BM
zjvmtCLX+ASMwCyxLjinCvSUvyPy7Hk2LmufQaG1X9rrTXXeUW8zZ6tzFFb7
no92Z5Pl/HeZe8Pc/TzEfyETnfG1+07nhHz/A6A04Fc=
           "]],
          "0.96`"],
         Annotation[#, 0.96, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02to1XUYwPEnnWSInqampnnK2dR5SUPZiEUTAgnXSAR1GZW4VESdKDKm
0lKbkM7KF2laQi+GKSLeKodtKwflrLlwDnXTqXkZG04jFYpVG33Oi+/5/n+3
53l+lzNm8eq5xY9FRIGfswMjbo+P+AMtSJsQ0c1fPRnx15CIYZMjuvjCoIgd
/IT259xpfDP3Tooo4VpxZqf6tefxZ8ZX8CPtRVxv/Qy+pp2XsvGsVFztJJ+w
/uHgiBrtHt5mfEhqnXZ/rrG+Tf9x7Q7OMd7EX2uf4QPWdwyLWKm+h9yGexMj
/kYDbuISfhenmNejCJ+iHB+aPy0jIhcJZGIk9olb8FxEIV58xlouwr/y94yM
eHxUxJ7hcvruxDvitz4dcQul+nu5B++lR/zKl3FXfy0fwx7xv5fnDEqejfgE
W7BV/HrxmrF/qDmclOsIV8lR554akRwTkY2JaLGmH6fjphq7cR8Vcqxxp+9j
CXZhG0pTObgZlajGURSKP3xcxFgMQC6m4u2EetVciR+deQW/q55NXCbHfO5W
42JOfypiAxej3rqWZMQdfItzOI18eV4eG/EadmofxD4MVNeDTOeGRrSjFaVy
1KmjEd+hHa2oFj9XHbNw3Vt5gTNwUPwDzugbVDuHZtRjmviVfBRl2I3tWC7+
nyOscRf/cV97GKr+/jgsRza3ewMF/Js8e+W45V53O++d5lbwVv4lS7/1O+xr
M/p4Xxne1xxvc705L5mzkmfa6+v4SMx1nPSWu9W8yfd9LvdO0tz9KTF+RhOW
iXteLflirhIzL/WWeQEfF3e786/lt0arg6vkuajGtfb0g3kn5FrqeyHKzF0q
VlrqjelPcJ04J5Hmfi+Z04Dy5/1PsF/+L7DFmnXqeCR+l732pvJpbxTjDS5W
+5vmXfaOX1F/h1pmcwWmOIMPeJR4CfTFTPczAw3m/6TdiTacR461r+IfOW+Y
04U8/dMxHvPFOuucajBI/j7It+cFOOf7NEqs/dJer6rzhno7OEedk7DaeBF6
nU228//Y3Cvm7uXR/gtZ6IdD7judE/L9Dzf73wk=
           "]],
          "0.72`"],
         Annotation[#, 0.72, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02to1XUYwPFnTjJEj0vzmiedt+Zdko1YNCEIcUlC5DRRw5ki6TSRMYuW
2oR0ar7Ia0IvxpxE5KWL1DZ1YE6dE22oW85bNTZcRikYqzboc158z/f/uz3P
87uczMJ1r69Ni4h5fs73j/j1uYg/0Iz0rIgu/jwj4vGgiMFTIjr5p0TEDn5S
ex93GN/MPZMjirlWnDmpfu03+FPj7/Aj7be43vqZfEs7L2XjWam42kk+Yf3D
gRE12t28zfjA1DrtPlxjfav+49rtnGP8Kh/WPsdV1rcPiVitvofcit8nRfyN
BtzDddwVp4g3ohCfoAwfmT99TEQuEhiH4Tgk7tzREQswY6S1XIh/5e8eEfHE
MxH7h8rpuwNLxG8ZHrGYbw+LKDG27ll1cbf+5U9FXOQbuK+vlo9hvzw/yHcO
xaMidmELtspTL24TKp82h5NyfsUn5ahzX41IZkZkYyKarenNGbin1i48QLkc
77rbD/A29mAbSlI5uAkVqMZRLBB/yISIMeiLXEzD4gHqVXMFTjv7cl6qnk1c
Ksd87lLjMs4YHPEeF6HeumZn8Ru+wSWcQb48L46NmI3d2kdwCP3U9dd454ZG
tKEFJXLUqaMR36INLagWP1cdr+C2NzOVM3FE/Cpn9DWqnUMT6jFd/Ao+ilLs
xXasEv9Pd1flLv7jXvYwSP198KUc2dzmLczly/IckOMX97rXee82t5y38oWJ
+q3fYV+bkeadZXpn87zRjea8YM5qnmWvr+JjMTdw0pvuUvMm3w+4zDtJd/ff
i/EjrmKluFfUki/mGjHzUm+aC/i4uNudfy0vSqqDT8pzTY3r7emUeSfkWuH7
TZSau0Ks9NQb05/gOnG+Q7r7vW5OA8rG+b+gUv6D2GLNBnU8Er/TXntS+bTf
F+M1LlL7QvNueMcvqb9dLXO4HFOcwYc8QrwEemGW+5mJBvPPanegFVeQY+3L
+EfOO+Z0Ik//85iA+WKdd0416C9/GvLtuQCXfJ9BsbWf2etNdd5RbzvnqHMS
1hovRI+zyXb+O8392dwDPNJ/IQu98YX7zuCEfP8DRxbeHA==
           "]],
          "0.48`"],
         Annotation[#, 0.48, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021MllUYwPEL3KymRCqIJhVEhqbhG8xoSmtrJbr6UKi01gtmWUZajGEt
UsMtxYIPaVpufWCmtaZpmkugZCvRkKayFIsyNQeLTNOWoeGy3/Ph//yfc9/n
XNd1rnPu7HmLH16UFBF1fvalRJzKjfgDnUgeE9HHH9wQ8fewiLTxEb18+PqI
1XyN8bvc4/0yvjIuopKbxZmReG78CL/j/fN8wfgJbrV+Mv9kPD1h73MTcY0z
ebv154dGNBn380rvhyTWGQ/kJuu7PN9m3M0F3h/iD4338ibru4dHLFTfee7C
73dEXEQbTuAIfhGnnJegDHWowRvm590aUYgU5GAENog7KytiDiZkWstluCx/
/416xRWjIi7xs9kRC5BnXp+1/6BePRPTIobq6yTefYvnqRHpxvnGw3gKp/Fg
tWXwVOPhfBdP5IvmX81Rx9iIc56V8hqxH8iIOGtcZHyK5/JMTLOX/8z/Cz2Y
IEYOSs3vVvN9QyJ2+n+Puqfgspp75Jill2f9v6r+jJsiBmECcnCtfM+J26r+
ktsinsTL1nbJ15Ae8ZF1W3gHHxa/SvxFNzsP7h8ZMc+zb/kofvOsmT/FOv3d
LfZeVIr9NpZjhX62qrUDGxN940z5tvAufWqxn3ZkypePMei0ZgCn4oQz6sMZ
1Mqx2J1+DU9jDVaiKpGDO9CARmzFHPHTb4/IxnUoxJ14TI/WqbkBX7lztfy4
epZytRwl3KfGpzhVL17hcrRa16kXv2IHDmAPiuW52/ncj3rjzdiAQer6c7S+
oR2ncQxVcrSoox07cRrH0Ch+YeJc8bNvZTxnYbP4m/ToMzTqQwdakSd+A29F
NdZiFRaIf26ENc7iX06yh6HqH4hP5Mjn0+7GLP5OnvVynHSua/W73txaXsH7
3YmT1q+2r2UI31eWu/OQb2GJOVPNWchF9joTb4pZwZnuX5+al/p/hmvck2Rn
/4UY3+AQnhH3oFqKxXxBzOmJb5ln8zZxV+l/Mz/qzu7nXfJ8r8aX7OlL87bL
Nd//UlSbO1+s5MQd8zyFW8T5HMnO94g5bahx1+uwUf73sNyaCnVcEL/XXq8k
8hm/KsaDXK72ueYddY+nqb9bLTO4FuP04HUeKV4KklDkfCajzfyvjXvQhYMo
sPZeXJLzuDm9mO75JIxGiVj79KkJg+UPFNvzbBzwfw8qrX3fXn9U53H1dnOB
OsfiRe/LcEVv8vX/LXN/MHc9j/It5GIAPnbeqZwi3/+QggFb
           "]],
          "0.24`"],
         Annotation[#, 0.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV031MlWUYx/HruLWaImXhG2QgkoqgZlDRkNbWKqTazBdsZVriKrJUxrCW
ltNVnF5cW06rf+rMaa1hqeiENNlKNKRZLNGiXCaDxZy1ao0KV/Q5f3zP77mf
c7387vu+nskr1ixYnYiIR/20XRPx8NSI7Ksj7qcNqMUtV0aczokoonOKInrG
RaTGRDROiEhgNJaOjWgujJhPHxKbJXbUdRHjMTwp4kXxhddHDIyOKB8f0Z0V
kSe+gxbTwhkRk/CHvGRxxPnJEYfllcnbQ4vpWnEbsBJD8m4SX8VLjfhqOtu7
78VOoe/lRrSgCRP5m39tRAGt569N/hP0Hutc/WbyWIZ8vKFPKZ9/8vlufsRd
vF5Ur0LOT7SazkO5fv9Oifgd/Zg1XT6WiO/LjrhDnWbPtzmLG/G3/fTrVeX8
Lnr+j59xvI7ELOTjcv0eV7ed54UFEcuwVm6Pfil+35fXRPfRr9VvUP9pnmvp
0ER36N0XtBs/e3eIfoRt9tKi9lHUq/0aNmLzVXrx2oUd9tZCc/RrogcynZP9
dCJHvxJMw2k5I2gmfsyLGMQFJPVYPS3iOazAm3gZDeketAsptGI3FqufZbby
cAXKUIwHndE2nlP41Bwm6VJ+6szoIG/LrTOdwTN0FdrTs+kMzmMfTuAIKtW/
1b3ciS3Wu/AORvLzq/sdQid6cQYN/Lfp34lm9OIMWtUvS98nfvB9FNFc7FJ/
p7PZi1b770I7ZqqforuxHlvRiMfU/8W87XQH/9CwhzH8X4YP9SihvWaiin6p
z3Y9zrnPrc55i9gk3UyPm4Vz8l+xrxcwbJ1rZu7zDawTc7OYWlphr/Pwkpp1
NMfcDfL8vOcLdJP5SLjzg2p8jq+wUt2TvFT6rp5Ucy5dRxfRj9VtdP6H6ANm
9Tg9oM83PK6xp8Pi9uhV43kJ1outUSuRni3vM2ibOvuRcK+nxHRgkxl/HTv0
fwsb5dTx8Zv6A/Z2Kd3P+lk17qWreK8W121+y/nv4+VumsQMZ7CBTlAvA4EK
9zMHHeI/s+5HD06iVO7t+EvPs2IGMNf7G1CAhWodc06fYJT+w/ZUac+LcML6
COrlvu39d3ye5bePlvI5HU/5/xFccjYlzv9Vsd+K3U6zfQNTMQIfuO9MmqHf
/2Gw3Ho=
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tMlmUYwPGLzdXQKItUIIPQNOTQPJQkah9cpq9rI01oeWgISzFLC9Em
mpNVoEUujQ5f8h1pW3lKRsG0+JDMilaxJjarabJczVlbrVjRUvq9H/7v/7nf
57qv67oPT371hiXr0yJit5/hgojt2IWNSKIVBaMjttwcMaU4Yj3vuj5i9k0R
64oi7udF3k/lKuNJfG9GxGLebLyCT3pfx43Ga7jV/Ff5DeN9XOH9Tm4xfpYT
5r/Hbxt/wF953zY54jB24HW8hKQ8T+dEbEPWODl5461ycbU5jZ5fRsn4iPS8
iCu5asmddltEBv7y3yTORof4uZzANKy27mWYqcZ8cYsxC2uxEuvF53MJxiBx
h/lYJf+6SRHP4NyN9kxfBWjV0wjjNs/tE+2fXvYYz+JXuIyHM61/QsQoMUv1
XYFKdN8SMU69qtsjaoxHiRmJPeIaeCuOWOMJrLoh4lvxVRypfeAG40ox1Tia
ihurf8/fqNuRH3FqTMTD8h7nJrFH+KHCiE3iZvNaXsBfylWT5Tz0/wk+RLgP
O/RxyT5ts4ZBznFuT3l+Xq2FPAe16twt7yZ+wD3KlfPqFOuVYyfOy3vKuFFM
s5gW3svn9fiadXxhbxLZEQNyTud39TKCR2NYD/+Yv9+afuXHnEGTM9yLBhxC
EsX2sIf70IX3ne9+HNBzrhqF+F6deVyKLjXOuGcDaEcvulEv/xnnO4BeDOE3
pMv/prUeQAvus657sED+j40/xzFcQD965H9c/5uRYb2P8qD9nyH/vyjXww/W
U8HL0ez9R76HJLfiEfOL9FOKa5GHTCxV75C72IUk+tCDev29wHtS9xRb8CSa
1bpkPwZxLvVt2Pc09IufzNORg1571Y0O+Q/qJ0evndxm//u4B43mbPc9vIg6
nHQmnWhV47Cej+Nn9+U0f4oq5zvEtf57wp7U89f+O6beQXvyDif5rLuxQb2V
voEl6JF7tTt0jdz5qW8c6RiDK+7IZfMS7uFFe/S352nmzkW7/PPk/0mvlZ7z
racEF53T7/gPZfIuVK8CP1rbHL7M88W/pd6f1jLDee+WJ1/PpShGrlqLnNca
/XabU8cTjcv1k8UH9dyJfZgg33d6vZMr1Kv2TST4Lt/ZkP9qzN+aWjOK1Dkq
tpRP8AXraRb/h3rjxRegSNxn5uXxaS7T6y/6LNDnc+ZdNW+sHkci07xl9qJc
f+3il/N1+gs0ISn+rF6m2r9Csf1iZ3Jt6u7jQWS7hytS34Pv5X9JEe5G
           "]],
          RowBox[{"-", "0.24`"}]],
         Annotation[#, -0.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1F1szWccwPGfLMSyYqta29GupVZ9WYpFN3QXwua4MZsjmbcUGeatWzUW
G6KRKWMSNBsXemIqoQQNaTNbbzRYJfQCiW1ZpiFbBMkEoYuX7XMuvv2e5/yf
38vze/6nhYs++6imT0RM9adjcMTcNyJyMiM+4DosxbhBEVeGRpRwRVnEtVcj
Uq9EbM6J+C874iWeMySitSRiOs+2N9PeF/MjhuBZXsQm+4tHRvw9IGK8mMtZ
Efn2n+dSLi6NGIp74hrKI64XRpwWVynuGJdyjX1fYRF6xb1lf0IvC+1P8pu+
+9XeQm56PaINLcjW3/RhEcO5Vn8d4pfwNOs89cr0WIkC7FBnrD7v63Pf8Igp
er0t30Qxf3KSp2K8ek9GRPyDmygfJR6z7L/xWsQkeVp9rjKL0XjkPDfVSpjf
bZ+f6idLr/1RjgL0VW+xvJ16/rAoYh5qxF5TL6Xfg+Ja+ARfkr9O/hV6Xsq9
uRHVvjvHl/GX737ko2h0lja5z6BW7m+wAfUvq6XXbux3tjbOVa+FTw40J+fp
Qq56YzASV8QEZ+CPgoiHuIUGNVYWR6zFAuzE16hL1+BupNCOI5gpf6Z3Kx/9
UIlSfGxGjXpO4SfvYQPP0U8Sv6fvkf9Vaywe6nW+5xlmsoaXoTP9rprJdZzA
L/gZ76v3tnuajO3WzdiD/vq767570YUeXEWd/B366UIrenAV7fJXpu8Xv/m9
lHAemuU/YFbH0W4e3ehEmfwpPoIvsQub8Yn8d5zngDt5zM/Nf5D+X8AhNcZw
j3ckwRfUqeAiTFKnWX/HsRdncRoJMZt4B6rxBZZjgTpV5p1AljsvRwFW6Wse
f4p3MANTME7+2c6wGKP1mUAVTtqfw0V4YF8GB5LyP03PMZ1bv996j+ux0P4t
5rLa592c7X1cx58jpcY2s/wOG3EU+3FRzCl3/oPfyGFOyL2et1tv4aTnTfy9
9W5ulGcJ11vX8hnP5/Ia6xn8rvgirrau4Gmev8fLrSfwVvGrzH2U/x9rudjz
RudOYTW2YgOe43/Am8Qn
           "]],
          RowBox[{"-", "0.48`"}]],
         Annotation[#, -0.48, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtMlmUYwPGrVrPJPBAGZCAShhwcHiam4QeX1WsfzObrpmJDzVOWCjKb
JxZzipa5lazDh3xn4ixgKrPBovgi60Cb8UHdPMwJy9WatdXUFU5T+70f/vyf
+3nu63Bfz/NS+Hrtwk0PRcTL/vRkRVQXR+Q8HvEK12Mtpo+KOPdURAlXlEdc
yI5IZUbsyY24nxMxnJc+EdFRGjGfl9ibae9j4yLG4L/8iF32Fz8T8duIiJli
zo6JyLf/By7l4rKIsfhbXNOkiIHCiG5xleKOcylvtG87VmJI3DT7E3pZYX+S
J7l30d7xfKggohOtyNbf/LyIQq7TX4/4NTzPOk+9Mj1WogAH1Jmqzxv6/Ozp
iLl6vS7fc2KucpJfwkz17hRF/IVrKC8Rj0X2/zI2Yo48Ha6rzGIy/nGea2ol
zO+667v6ydLrMJSjAI+ot1reXj2/OiFiGTaKvaBeSr9HxbXySf5Z/nr539Tz
Wh56MqLGve/5LH5172tuR7OzdMp9GnVyv4sGNI5WS6/9OOxsnZyrXiufGmlO
ztOHXPWmYALOiXkwPiLD9RW+hd/RpMZbEyO2Yjk+wG7Up2twP1LoQhsWyp/p
28rHo6hEKRabUbOeU/jGd9jES/WTxOX0e+Tbak3FLb2+5nmGmWzhN9Cb/lbN
ZAAn8SO+xYvqzfCensd+6xZ8gmH6+9P7HkIfBnEe9fL36KcPHRjEeXTJX5l+
v7jk91LCeWiR/4hZnUCXefSjF2Xyp7gN2/Ah9mCV/H84zxHv5F++Z/4j9f8w
vlBjCh/jQd/JABLWP6lXwUWYo16LPk/gU3yHbiTE7OIDqMHbWI/l6lWZewJZ
3n05CrBBf8t4HZ7FAszFdPmXOMtqTNZvAlU4ZX8OF+GmfRn8gJPy303PM51b
v+/7nhuxwv695rPZ9UHO9l3u4Fqk1HjPTD/CO2jHYZwR85V3/7nfypeckHsn
77fey0nPD/HH1ge5WZ413Ghdx6c9r+Yt1gt4tvgirrGu4Hmev8DrrWfxPvEb
zH+i/yNbudjzZudOYTP2oQH38D98DsaO
           "]],
          RowBox[{"-", "0.72`"}]],
         Annotation[#, -0.72, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Fto1mUcwPFfGIYDbU23ZVtTZ3MH2zRcWetCPL3eeMA3SF1syjwfcA7F
DuKQnKYJ6Si90BfnunCKcxgbWbtxpC2oXagwjWiiKGKikhKLPNHnvfju+3/+
/+d3eA7vxtXVJze+EBFz/ekeGbFkQkROVsQ8bsBKTHk54lJeRDGXT4zoz4lI
vRKx89WIZ7kRw3hxdkRHqTy8yNxMc18qiBiJJ69H7DC/qCji1vCIqWIujorI
N/8Cl3BRWcRoPBDX9GbEwLiIs+IqxZ3iEt5g3idYhkFxb5mf0MtS85M80bsr
5o7hI2MiOtGGbP3NzY8Yy/X66xa/gucY56lXqsdKFGCfOpP1+bc+DxdGzNDr
HfneE/MnJ3k2pqr33/iI+7iBshLx+MD8669FTJOnw3OVvajAP9ZzQ62E/bvj
+bF+svQ6FGUowBD1lsvbo+cFb0RUY4PYfvVS+v1WXBuf5t/kb5B/rZ5X8uDo
iBrvzvNF3PTuez6JZmvplPsc6uX+AtvQmKmWXvtw1No6OVe9Nj4zwj5ZTy9y
1ZuE8bgk5vnYiAzPf/Aj3EaTGuuKI7aiFl/hczSka3AfUujCCSyUP9PdyseL
qEQJPrRHzXpO4Qf3sIkX6yeJ39PnyP+qNRmP9PqR7xn2ZDOvRk/6rtqTAZzG
z/gRs9R72zlNx17jVhzEUP3ddd6D6MU1XEaD/N366UUHruEyuuSvTJ8vrvq9
FHMeWuU/Zq/a0WU/+tCDUvlTfAIfYz92ok7+v6yngo85lxY8dQbbnfUTnmBt
99yRdnM6nWu1PTvlecC7hHX+onY5F2Ka2q16bsch/ISzSOh1B+9DDbZgDWrV
rJIvgSz3oAwFWK/Xal6FdzAfMzBF/kXWtRwVek+gCmfMz+FCPDQvg59zUv7H
6b1N59bvl+52I5aav8tebfJ8gLPd0U95I1Jq7LG/X2M7TuIofhXznXvQ4ndz
nBNyf8Z7jXdx0vcj/I3xAW6WZwU3GtfzOd+X8Gbj+fy++EKuMS7nOb7P5DXG
7/Ju8evT++9/ylYu8r3ZulPYhN3Yhqf4H29cyBg=
           "]],
          RowBox[{"-", "0.96`"}]],
         Annotation[#, -0.96, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1F1o1XUcx/FvxsJd1Jxt01xTj03nbGa4subFzIezGzM6wqaLaTBnmtK2
JlJNh+jUTBCPTxd6MKbQkulQzlDbjdLDgvJCLTOijcQICYqUWGQl9DoX733+
v//v+/D5fX//s0Rz2/LWhyJipT+Dj9MZEcXjI16m7WjB3IKIa6URM2jV0xE3
SiIyhRE7Jkb8NyFiLF1RHNFfGbGUNogtEPvI5Ijx+KcsYpv48ukRPz8aMU/O
1aKIUvGf0wpaPitiIn6X110VMZyIuCCvWl4fraAbxb2D1zEq71nxSV5Wi0/R
Wd59J3YyPTYlIoteFPG39MmIKbSVv0H5a2id9ST9ZvJYjTLs1WcOn3/weXRa
xEJe76j3opwfaYouwTz9/n4q4jfcQuVM+Vgu/qdJEbXq9HuuMYvZ+NN5bumV
NL87nu/zU8hrHipRhjH6Nat7medXyiMasVHuDf0y/J6Q10vP0K/Vb1d/Pc8t
dPSJiCbvPqNXcdu78/QU0s6SVfsSWtXejU50jdOL1ys47mxZWqJfLz37mDk5
zxBK9HsG03BNzoOpEfmef6D38Au69XizImIzVmEftqM914NeQQYD+Bivql/g
2yrFw6hGBerNKM1zBhd9h910BT8pfJ+7R/qXXnNwj9fX7OebSQd9A5dz36qZ
DOMMvsAnWKzfc+7pJeyx7sFh5PH3q/sexRBGcB3t6g/yM4R+jOA6BtSv5iFL
F7jLm34zJ6x7cuixxdyH3MPb+nRgE741w2+Qlzub/QnuuNP7LdiKFueodzf1
/DTgoG/jEA5jRPwBmsZdeyfVHhB/0iwySKlZx2/W+1raR1Pm24g++8Pykuby
JZ9VNIFaPnvEnsYRfIoLSKq1je5FEzZhHVaZRY16SRT6bipRhg1m10jX4nks
w0LMVb/BeZsx27eRRA3Oii+mCdwVl08f0JT693N3kavN7wd+C11YLX6nubZ5
3k+LzOJd+hYyerzvPg5iK07hOL6Sc85386G7+Ygm1X6P7rHeSVP2j9FD1vtp
Wp01tMu6lV6yv5J2WC+j8+UnaJN1Fa2zv4ius36B7pK/wW9nuv9Bm2m5/bRz
Z9CGXejEv/gfPx7NUg==
           "]],
          RowBox[{"-", "1.2`"}]],
         Annotation[#, -1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV011M1XUYwPHHZsssEQQ0CQw6CBiU8yyLLtiwDlspruMrR4E20ZlSwGqu
cjFXvrvxsrKLOPOlNsmRzoaTojZbOtvKC7zQtRYuVzMuypVrbpl50YeLL9//
7/yf5/k9v+f/o6yta2XnlIjY5M9ofkRTRUTBrIhl3IWNWDQz4tLDEfO5ujri
8uyIbF7Euw9F/Dcn4j5eWxhxckHEUl4jNkfsvfMi8vBvScQO8Yn5Eb/OiFgs
Z6wgokj8ea7gxGMRc3BD3s6aiPGyiBF5SXlDXMHt4t7AS7glb6H4lF5axad5
gd+uiC3hgUcihjGIfP0tLY6Yxx36G5Xfxg3Wc+1XqcckinHAPk/o8099fvho
RL1eJ9R7Ws5PnObnsNh+/yQi/sA1VFXJxwrxPxdF1Klz0nOtWdTgb+e5Zq+U
+U14vq2fXL1ORRWKMcV+G9T9Ws/LyyMyaJd72X5Z/X4kb5BP8Pfqd6n/sp43
8q25Ec1+O8dj+MVvZ/g4+p1lWO2z6FB7D7ajO9deer2IQ842zIX2G+RTOebk
PBdQaL/HUYZLcu6WRkzz/CPfxHXstMeWyohtaEEP3kHX5B58EVmcxid4Uf0c
d6sI9yCJCqw2o349r+KkWX3uLl6dvF96+mHyO3IaLzjf86jU72zn/s3dzXcP
rnOv33twR4/rzTNttiswSy/dZpDHe3kf9qBc7H5O8E311sn5ir/AKDLWv3MT
f8nP6r3d/F7Bet9xHTJo0sdh3+oIctyJmZgudkK/Mzw/iAcwos6Qu5v0LVP2
7bUesO7hg87Q4Lc+zy2+7Tk1m/k8t/JabtTDQrlX9Vtv3yXIE3/Fecdwvz3H
ves1r4Mo8e5jziJtrg3u97A6dTzEad8jgyHvx9VKmf+35ljNpahT76jYT/EB
vsEIUmrt4ANoxuvYjBZ3oVa9FHLNqArF2GruGd6EJ9GIeixSf417tgE17lIK
tTglvoBL8Ze4aXyX0+rfNoupk7X1u9+37Uar+F1m3em5j/PN4E1+FVl77HW/
3sPbOI5D+E7OZ+7YYXftGKfUfov3We/itPcD/L51H/er08bd1h181vsmfs26
kZ+RX8rN1tXc4P0S3mz9FO+Wv9X/WrnvvI0T3vc7dxad2I3tuIP/ATCUyTc=

           "]],
          RowBox[{"-", "1.44`"}]],
         Annotation[#, -1.44, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1MlWUYwPHLIF/WDAMiDRRB8dhBDCZFGk7r8CHEdspIN7JCTNOFaGuV
yWylvbiW5MsHOeLMLeYoOw4nm2uzZculbeEKX0q2qNb8UK22xqa9fOnHhz//
536e67ru637hlLVtXtExLiJa/TlVELFyTkRBfsQy7kAbqvMiLhRHzOZkZcRQ
UUTmtojXpkb8e0fEeH789ohjd0U0crPYyWJzZ0RMwd/TI7aLL6+I+HlyRK2c
wcKIaeI/5wouT0YU4Xd5r8+LGC6LGJBXI6+PK3ijuBfxJEblzRef0stq8Wme
691FsSXcXRrRj17k66+xJGI6t+vvlPw13GA81Xxz9FiDYuwyT5U+/9DngfKI
JXq9pt69cq5ymh9Erfmuz4r4DSNIzJWPR8T/cGdEvTrHPNfZi0r8ZT0j5krZ
v2ueb+gnT685SKAYYb5WdT/V8/LZEauwUe6Q+TL6fV9eL3/E59XvUH+9ntt4
dFpEi3dneBA/eXeSj6LLWvrVPo12td/AVnROMZdev0KPtfVzofkK0Os5e2vE
UnM9gEJ8LGa8Xo5zLmf5Zr6gznv678Jle3AF3+ESFsu7ygfFrrWeZ1DvXcb4
fu7m732/xVwzzVuG2rG1qruAj3CPcz6IAfM8K3893nHm141f9Zy1rrCvE635
IeNG/KLOBONc7yfxOM7BTUiYa43vdzu3+ajCJ/Z9SNy3+NE6frVn28wx4nmG
s6rhHuNqHnWOy/TchEY8jOVYZC1f2teFfI4XWd9CVKm1wp16DI/ijHNq5l51
Wp3fWeOn+At+mpP6+drdfMX6L/E3WCw2q+cTKNLreXUvYhATrWdY3++K24cS
349wBml5DebqV7ue+zidcLfQ5/uwtaXckbP+95Ncinr1Dov9EPvxGQaQUms7
70ILnsc6PGF9deqlkGfdCRRjg/NZxWuxAE1Ygmr1m+1XKypnykMdsuILuBR/
ipvA/3Fa/Rv2JWestn7fdgadWC1+h3u6yfNuzrcHL/FzyJjjTb9de7ANR9GD
c3KO+3075B58wCm1X+a3jHdw2vdu3mu8m7vG7gp3Grfzad9X8hbjJr5Pfim3
GCe5wfelvM74Ht4pf4P7MMvdeYHLfe+y7gw2YSe24h/8Dx/lxhY=
           "]],
          RowBox[{"-", "1.68`"}]],
         Annotation[#, -1.68, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G9o1VUYwPEnI4P+TDd3p21zet0fvWulac1sYXhnoEZXcG64NNyWsZGa
YdmfOTH/5YuUshfuslDBETMxJg4lSNzUTKJVqG8caPViGUVBjbKUoD578b3f
e855nuec8/x+9yZbNix7+Y6IWOHj1ISI+oqIvLyIxbwezZg5LuLroohSTj0Y
cakgIpsbsXVSxK2JEXfx8kTE0VTEIq4Te5/YO0sixuHvyREd4pPlET/cHzFH
zmB+xCTxA1zGycqIBH6R93ZVxFAyok/eLHk9XMZt4l7DKozIe0h82llWis/w
dHOXxRZx55SIXnQj1/kWFUcU81rnOyW/iWuNJ9qv3BlnoRC77VPlnL865/5p
EfOddVi9x+Rc5QwvwBz7/VUa8TOuo2KGfCwVf60wokado75X60Ulfnef6/ZK
69+w7zedJ8dZx6AChfjP/Gp1TzvzM2URDWiTe8l+Wec9aL2bP+aL6q9X/0Vn
buaRByIazfXzIL43d4K/42Yx59X/HOfQpV+dWCH+gvG/6q2yb8bZCsbb354J
ftb4HvlNKMYy4z/M37A+wnXGk83fy23u/oL+tHILXzGfr4+v2mMCFyCBfOMz
7jWAfvwpfkaO/uvhI9hsrh379P6ce29x33q9akCTfduNz5rv4H7ezANc5Xnl
OscR91hqj1rxC/E0Nhp/M/oOqV+K5+X0yVluvs76sH7/iJ9wA6XOk6/Wp2o9
jF45x9Ht+Z10hsM817v3OKrxBOZhk7o79TIhdxfvQGr03VDvgnetnL/kKnNf
8Zvir/C3eFLNY2ofH+29PS/KvYxB3C1vSD/fFbcPRdYPcRYZebX62usuNdzD
men6hR7rQ+6X9h6c99tOcQlq1Dsg9gg+wBn0Ia1WB+9GI17BGjynt9XqpZGj
PxUoRKt3oIFbMBtLMB8z1a/zXFejcqo8VOOY+DwuwW/ixvJtzqh/0zs6ZrS2
877jWbVjpfhtfkvrfN/DuXqwiV9C1h47/Te9h7fwEbrwhZxP/H996Bkc5rTa
r/Mu422csd7J7xvv4b3qNHG78Vr+zHo9bzBewnPll3CjcYprrT/Fa4wf5e3y
W73v0/yeNnLS+l73zmIdtuMN/IP/AVg9wiY=
           "]],
          RowBox[{"-", "1.92`"}]],
         Annotation[#, -1.92, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Hto1WUYwPFnXbxkWztzaZsuzy7HdvFC5vxjYXRG4QXOgrmJKczaapKK
EnlF0Ik2KKVSyEOlQWJn3poieNuFInNFamgEDRL6w3+KAhFvBRV99sd339/7
e5/neZ/f+75n5e1rm9fkRcRif06Pj2iZGpEoipjPq/EKZjwWcXlSRAVX10Vc
nRCRTURsfSLir4kRD/GixyOO1ETM42ax48Q+8GREAe6VRWwRn0xF/JofMUvO
peKIieK/5EpO1kYU43d526ZFDJdHnJI3U16OK3mFuLewDLfkTROf1stS8Rme
6t01saW8b0pELw6iUH/zJkdM4pX6Oy1/OTcaT7BelR5nogTd1qnT5x/6/LAi
Yq5eb6g3W87PnOHnMct6dyojfsN1pKrlo0n8L6URDeoc8VxvL2pw0/dct1ba
/t3wfFc/+XrNQwol+M/7NnX79bywKqIVK+RetV5WvwfMH+TDPKT+avVf03M7
OvCJmvsxyjoLkxE95h+1R/kYh1q1O9V7HceN/1H3X6zT/3psQM5cD66IPSHm
Mp/kn9TK4RvxW/Vwgbdxh9j2kW8siOgy7tbbixiwVy9wPxeJTYn5XJ2ceoe4
h3Nc5Dv6fecgBlBr389zH87gHM6ixvuj4s/IS+qzHBW4qO5ka++xf3uxWewm
3C6MeMe9uO0M7yChhz69FPJ5Tqg1Xa0v1OjFV3Kb9FLg7DM82rsxeFDtsfwI
LvievWp+zWPFJcW1Os8muS/hW/dp0Ls2PQ3wkHGL86hS4zvPdWp8zxvt04/8
A551VsfEn0CxfobUvoZLGCVv2J6/K+4DlJr/lLPIyGvUQ691GjjHmaf0g5z5
YeumS/TqN13NZWhQb7/YHuzBIE4hrdYW7sYSrEUHXrbn9eqlke9OplCCTnvb
yq/iaSzAXMxQv9lvoA017l8a9TgmPsFl+FPcw/w3Z9S/697mjdTW79sj54el
4rv8hlZ53sWF9mAdv4GsNXb4n/QeNuEQPsJFOcf93/rYeXzGabXX807jLs6Y
38fvG+/i3eos583GK7nPfAuvMV7Ac+SX8RLjam40/xx3GD/D2+V3ukfl7sOb
nDS/23dnsQrbsQH38T/oHMFp
           "]],
          RowBox[{"-", "2.16`"}]],
         Annotation[#, -2.16, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G9M1HUcwPGPqx5UHGCEAZ4Bx8kRBEvEFs3WURtSnRrSRrahjc0WtqxV
JrqVTvOBmuZML5jYaA0jDPPMalaztdUTW8seFEu2VvSgVptri/48aet1D973
/n2/38/n8/38vve9qx98at2WBREx5ONcRURfY0T5DRGr+AlsRGtZxJeLI+o5
0xLx9aKI/MKIF6oi/rkp4ipeVxkxeUtEN/eKvU7sgpsjEvhrScQO8bVLI35I
RCyTc/HGiEXiL3CKa5sjKvCrvBdvjZipjyjIa5M3wSl+TNwzeAR/yGsRn9XL
evE5XmrukthqPlYbMY03UKa/7mREDQ/p75z8DdxlXGm/Bj22oQp77dOsz9/0
eTQVsVKvc+otl/Md5/huLLPfnw0Rv2AW6Sb5WC3+ck1EpzqTnjucRROueJ9Z
e2Wd35znef2U6DWQRhX+Mz+g7rX2vd1eH+l9BX+v3nnP7Z7XWFuLB7AauaLV
n1e7XY3laC/2hyPW6uxTizHzlXp6yP79xs2lEaNi2pzDa9zKI9zivbc7z2Fs
wxKxo5zkPFeocVytJnHlan2opw8wru8y44z5lH7SnDB+3fx71k9wiXGD+UI6
olSd03wG7yJl/h2exts4hSnUm3+LJ3ESCXkl+iyoeT2f4ctiDnnXg3gZZ80l
rC0Ue68zfd/4Hi4zV4pZ8Y1YJbYH3RjzbiM4os/7jPeh0ffX7FyuFO++5xQy
uN/ahLjDzmG35z2oMb9V/mI+am3M3XyV65zznO/uZ/yEH9HrLPv0ttY9exBr
8LFxQc5ZDLtP23GH73TS3p08Ludb9/VTcQPmLvBGfl5/35j/CneKmzJ3GhX2
/sI7X8JFXKOPGb3tE/cKqq2f4Dxy8rr0MK1mJ09wLuOuYML6jL2z1RGf+X/I
cBKd6h0XexKH8QkKyKq1g/eiH1swiIedd4d6WZQ4gzSqsKncPvwobkMPVqJV
/V6/pwE01clDB6bEl3MSv4u7mv/lnPrzfr9RrK3fl3w3w1gvfqffz2bP+7nM
GTzLjyNvj93+3w5iG97ECD6Xc8p/4Kj7Os5ZtZ/jPcY7OWf9GB8y3s8H1NnA
w8ZDfN56Hz9p3MMr5Ce5v/j74C7rd/GgcTvvkr/JHa1zf57mWusHvHcem7EL
W/E3/gd8wMJX
           "]],
          RowBox[{"-", "2.4`"}]],
         Annotation[#, -2.4, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3358, 8842, 8843, 7575, 7577, 7576, 10503, 9371, 9372, 
           9370, 9374, 9373, 10504, 9378, 9379, 9377, 9381, 9380, 10505, 
           10506, 9397, 4367, 9396, 4368, 5791, 11022, 3365, 6947, 5300, 5794,
            11412, 5793, 6948, 5795, 11366, 5796, 5304, 10543, 10544, 10541, 
           5333, 10542, 5492, 10923, 5815, 8999, 9000, 3617, 7004, 3618, 7250,
            5646, 9068, 9069, 9070, 7077, 3843, 9341, 4341, 9340, 4340, 10744,
            10745, 7320, 7321, 7322, 6987, 7081, 5647, 7090, 5648, 8661, 5650,
            8644, 8655, 8649, 3588, 6102, 6280, 6286, 5656, 6300, 6293, 3915, 
           9536, 4524, 9528, 4516, 10059, 10067, 6308, 7382, 6463, 5056, 6438,
            6427, 3640, 9626, 9637, 9615, 9659, 9648, 3903, 9593, 9604, 9558, 
           9581, 9569, 3415, 10035, 10047, 7947, 7971, 7959, 4196, 8019, 8031,
            7983, 8007, 7995, 3628, 10320, 10332, 8231, 8255, 8243, 4265, 
           8207, 8219, 8170, 8195, 8183, 3403, 7923, 7935, 7203, 7555, 7543, 
           4184, 6782, 7529, 6793, 5902, 6770, 6759, 3733, 9857, 9868, 9846, 
           9890, 9879, 4291, 4778, 11160, 4767, 3391, 4723, 11138, 4734, 4171,
            4756, 11149, 4745, 3722, 4701, 11127, 4712, 4280, 4690, 11116, 
           4679, 3380, 4635, 11094, 4646, 4160, 4668, 11105, 4657, 3711, 5220,
            11295, 5231, 4126, 10378, 10389, 10345, 10367, 10356, 10485}],
          RowBox[{"-", "2.6399999999999997`"}]],
         Annotation[#, -2.6399999999999997`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{5043, 9810, 4623, 9798, 9834, 9822, 3884, 7114, 3872, 
           11046, 5838, 4501, 6268, 6134, 6146, 5457, 10663, 5445, 6992, 3849,
            7680, 7692, 7668, 4473, 9502, 3549, 5936, 5321, 10517, 5309, 
           10529, 10782, 10770, 4071, 11389, 8662, 7600, 4397, 7588, 4385, 
           10597, 10609, 10585, 5359, 10794, 5695, 11352, 5707, 5156, 7631, 
           5144, 8084, 8108, 8096, 6158, 3615, 6208, 3614, 8997, 8998, 7643, 
           7645, 7644, 4099, 7500, 7501, 10516, 10515, 8847, 8848, 3548, 9487,
            4432, 7617, 4433, 5288, 5287, 3613, 4434, 7231, 7230, 4383, 7587, 
           3611, 7148, 7149, 5982, 5981, 6984, 6983, 3610, 8991, 8990, 5444, 
           10662, 10661, 8946, 8945, 8944, 9395, 9394, 3360, 3545, 8943, 8942,
            9376, 9375, 3359, 3544, 7195, 7194, 4364, 7578, 5295}],
          RowBox[{"-", "2.6399999999999997`"}]],
         Annotation[#, -2.6399999999999997`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{9065, 4513, 9526, 5983, 5217, 11084, 4100, 5289, 8510, 
           9317, 8181, 5216, 8168, 5215, 10318, 6101, 3573, 8949, 7201, 7541, 
           7540, 4182, 7141, 7527, 7526, 7528, 6781, 4183, 7542, 7554, 7202, 
           7934, 7922, 3402, 8182, 8194, 8169, 8218, 8206, 4264, 8242, 8254, 
           8230, 10331, 10319, 3627, 7994, 8006, 7982, 8030, 8018, 4195, 7958,
            7970, 7946, 10046, 10034, 3414, 9568, 9580, 9557, 9603, 9592, 
           3902, 9647, 9658, 9614, 9636, 9625, 3639, 6426, 6437, 5055, 6462, 
           7381, 6307, 10066, 10058, 4515, 9527, 4523, 9535, 3914, 6292, 3913,
            10652, 5425, 10650, 5424, 10651, 6986, 3844, 9072, 9071, 10747, 
           10746, 9011, 9010, 4437, 9488, 10646, 10645, 10904, 3841, 9066, 
           9065}],
          RowBox[{"-", "2.88`"}]],
         Annotation[#, -2.88, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170819134]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20632],

Cell["Compose with inverse function:", "ExampleText",
 CellID->196753002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{
     RowBox[{"JacobiNS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{
     RowBox[{"InverseJacobiNS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5296189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{
     RowBox[{"JacobiNS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386102272]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81233632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83975730]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390870124],

Cell[TextData[{
 "Differentiate",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiNS"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiNS", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->809586479],

Cell[BoxData[
 FractionBox[
  RowBox[{"JacobiCD", "[", 
   RowBox[{
    RowBox[{"InverseJacobiNS", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], 
  RowBox[{"1", "-", 
   SuperscriptBox["z", "2"]}]]], "Output",
 ImageSize->{241, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203279732]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiNS", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192074691],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"JacobiAmplitude", "[", 
        RowBox[{
         RowBox[{"InverseJacobiNS", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "m"}], 
      "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"InverseJacobiNS", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}], "-", 
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{"JacobiCD", "[", 
        RowBox[{
         RowBox[{"InverseJacobiNS", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "z"]}], 
    ")"}]}]}]], "Output",
 ImageSize->{494, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1230239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20875427],

Cell[TextData[{
 "Obtain",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiNS"}]], "InlineFormula"],
 " from solving equations containing elliptic functions:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiNS", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiNS", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554970152],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->51546747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiNS", "[", 
       RowBox[{
        RowBox[{"1", "-", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiNS", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17023462]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22797],

Cell["\<\
Machine-precision input is insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->3979231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiNS", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"10.", "^", "5"}]}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563558634],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->429131203]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->260060486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"10", "^", "5"}]}], ",", "2"}], "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->289346646],

Cell[BoxData[
 RowBox[{"7.07106781204225193931347739517578891968238671545340348890686`44.\
88238777542462*^-6", "+", 
  RowBox[{
  "1.3110287771460599052324197949455597068413774757158115814085596845294`50.\
150514997825674", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->834257388]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31364],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiNS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiNS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiNC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiNC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiND",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiND"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15947]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1861],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->1632]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->309380010],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->466904549]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseJacobiNS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 50, 45.9803720}", "context" -> "System`", 
    "keywords" -> {
     "inverse Jacobi", "inverse Jacobi elliptic function ns", 
      "inverse Jacobi NS", "inverse Jacobi elliptic function NS"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseJacobiNS[v, m] gives the inverse Jacobi elliptic function ns -1 \
(v \\[VerticalSeparator] m).", "synonyms" -> {"inverse Jacobi NS"}, "title" -> 
    "InverseJacobiNS", "type" -> "Symbol", "uri" -> "ref/InverseJacobiNS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6333, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->126293866]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[633846, 11054, 192, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->715886131],
  Cell[636051, 11144, 238, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->322808586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 642718, 11384},
 {"XRef-2005-4-26-23-37-1.8558342", 642875, 11388}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2058, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2681, 79, 53, 1, 70, "ObjectName",
 CellID->20394],
Cell[2737, 82, 779, 25, 70, "Usage",
 CellID->29909]
}, Open  ]],
Cell[CellGroupData[{
Cell[3553, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4031, 129, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4154, 135, 533, 21, 70, "Notes",
 CellID->19755],
Cell[4690, 158, 771, 26, 70, "Notes",
 CellID->539143431],
Cell[5464, 186, 114, 3, 70, "Notes",
 CellID->30293],
Cell[5581, 191, 262, 8, 70, "Notes",
 CellID->168171127],
Cell[5846, 201, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6081, 210, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6333, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126293866],
Cell[CellGroupData[{
Cell[6718, 236, 148, 5, 70, "ExampleSection",
 CellID->352178110],
Cell[6869, 243, 64, 1, 70, "ExampleText",
 CellID->417418768],
Cell[CellGroupData[{
Cell[6958, 248, 137, 4, 28, "Input",
 CellID->43059757],
Cell[7098, 254, 176, 5, 36, "Output",
 CellID->569683017]
}, Open  ]],
Cell[CellGroupData[{
Cell[7311, 264, 129, 4, 28, "Input",
 CellID->438828716],
Cell[7443, 270, 161, 5, 36, "Output",
 CellID->266178292]
}, Open  ]],
Cell[7619, 278, 125, 3, 70, "ExampleDelimiter",
 CellID->118591952],
Cell[CellGroupData[{
Cell[7769, 285, 297, 10, 28, "Input",
 CellID->128214967],
Cell[8069, 297, 2258, 41, 133, "Output",
 Evaluatable->False,
 CellID->714605162]
}, Open  ]],
Cell[10342, 341, 123, 3, 70, "ExampleDelimiter",
 CellID->5952488],
Cell[10468, 346, 60, 1, 70, "ExampleText",
 CellID->159088426],
Cell[CellGroupData[{
Cell[10553, 351, 251, 8, 70, "Input",
 CellID->69272691],
Cell[10807, 361, 1118, 36, 100, "Output",
 CellID->129126105]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11974, 403, 216, 7, 70, "ExampleSection",
 CellID->19903],
Cell[12193, 412, 73, 1, 70, "ExampleText",
 CellID->55645938],
Cell[CellGroupData[{
Cell[12291, 417, 208, 7, 70, "Input",
 CellID->266251706],
Cell[12502, 426, 270, 8, 36, "Output",
 CellID->113839517]
}, Open  ]],
Cell[12787, 437, 125, 3, 70, "ExampleDelimiter",
 CellID->268824359],
Cell[12915, 442, 70, 1, 70, "ExampleText",
 CellID->132691703],
Cell[CellGroupData[{
Cell[13010, 447, 215, 7, 70, "Input",
 CellID->866802414],
Cell[13228, 456, 235, 7, 36, "Output",
 CellID->285866290]
}, Open  ]],
Cell[13478, 466, 124, 3, 70, "ExampleDelimiter",
 CellID->36479535],
Cell[13605, 471, 113, 3, 70, "ExampleText",
 CellID->579439215],
Cell[CellGroupData[{
Cell[13743, 478, 167, 4, 70, "Input",
 CellID->632752147],
Cell[13913, 484, 228, 6, 36, "Output",
 CellID->139517369]
}, Open  ]],
Cell[14156, 493, 125, 3, 70, "ExampleDelimiter",
 CellID->688497564],
Cell[14284, 498, 231, 7, 70, "ExampleText",
 CellID->43876107],
Cell[CellGroupData[{
Cell[14540, 509, 185, 6, 70, "Input",
 CellID->271543877],
Cell[14728, 517, 342, 11, 36, "Output",
 CellID->403618187]
}, Open  ]],
Cell[15085, 531, 125, 3, 70, "ExampleDelimiter",
 CellID->255377976],
Cell[15213, 536, 92, 1, 70, "ExampleText",
 CellID->328717422],
Cell[CellGroupData[{
Cell[15330, 541, 251, 8, 70, "Input",
 CellID->617758456],
Cell[15584, 551, 273, 9, 36, "Output",
 CellID->919579416]
}, Open  ]],
Cell[15872, 563, 90, 1, 70, "ExampleText",
 CellID->368884824],
Cell[CellGroupData[{
Cell[15987, 568, 153, 5, 70, "Input",
 CellID->508781695],
Cell[16143, 575, 241, 8, 36, "Output",
 CellID->42351009]
}, Open  ]],
Cell[16399, 586, 124, 3, 70, "ExampleDelimiter",
 CellID->23210608],
Cell[16526, 591, 203, 7, 70, "ExampleText",
 CellID->471035179],
Cell[CellGroupData[{
Cell[16754, 602, 173, 5, 70, "Input",
 CellID->179888293],
Cell[16930, 609, 323, 11, 52, "Output",
 CellID->278833701]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17302, 626, 239, 7, 70, "ExampleSection",
 CellID->29214],
Cell[17544, 635, 225, 7, 70, "ExampleText",
 CellID->120235099],
Cell[CellGroupData[{
Cell[17794, 646, 271, 9, 70, "Input",
 CellID->77454719],
Cell[18068, 657, 1118, 36, 100, "Output",
 CellID->235791452]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19235, 699, 223, 7, 70, "ExampleSection",
 CellID->14269],
Cell[19461, 708, 123, 3, 70, "ExampleText",
 CellID->147991225],
Cell[CellGroupData[{
Cell[19609, 715, 716, 23, 70, "Input",
 CellID->41283476],
Cell[20328, 740, 611673, 10233, 70, "Output",
 CellID->170819134]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[632050, 10979, 233, 7, 70, "ExampleSection",
 CellID->20632],
Cell[632286, 10988, 73, 1, 70, "ExampleText",
 CellID->196753002],
Cell[CellGroupData[{
Cell[632384, 10993, 379, 12, 70, "Input",
 CellID->5296189],
Cell[632766, 11007, 340, 12, 36, "Output",
 CellID->386102272]
}, Open  ]],
Cell[633121, 11022, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[633392, 11034, 106, 3, 70, "Input",
 CellID->81233632],
Cell[633501, 11039, 202, 7, 36, "Output",
 CellID->83975730]
}, Open  ]],
Cell[633718, 11049, 125, 3, 70, "ExampleDelimiter",
 CellID->390870124],
Cell[633846, 11054, 192, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],
Cell[CellGroupData[{
Cell[634063, 11065, 225, 8, 70, "Input",
 CellID->809586479],
Cell[634291, 11075, 356, 12, 52, "Output",
 CellID->203279732]
}, Open  ]],
Cell[CellGroupData[{
Cell[634684, 11092, 225, 8, 70, "Input",
 CellID->192074691],
Cell[634912, 11102, 997, 34, 83, "Output",
 CellID->1230239]
}, Open  ]],
Cell[635924, 11139, 124, 3, 70, "ExampleDelimiter",
 CellID->20875427],
Cell[636051, 11144, 238, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],
Cell[CellGroupData[{
Cell[636314, 11155, 359, 13, 70, "Input",
 CellID->554970152],
Cell[636676, 11170, 452, 8, 70, "Message",
 CellID->51546747],
Cell[637131, 11180, 664, 24, 43, "Output",
 CellID->17023462]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[637844, 11210, 226, 7, 70, "ExampleSection",
 CellID->22797],
Cell[638073, 11219, 113, 3, 70, "ExampleText",
 CellID->3979231],
Cell[CellGroupData[{
Cell[638211, 11226, 185, 6, 70, "Input",
 CellID->563558634],
Cell[638399, 11234, 170, 5, 36, "Output",
 CellID->429131203]
}, Open  ]],
Cell[638584, 11242, 83, 1, 70, "ExampleText",
 CellID->260060486],
Cell[CellGroupData[{
Cell[638692, 11247, 246, 9, 70, "Input",
 CellID->289346646],
Cell[638941, 11258, 392, 10, 54, "Output",
 CellID->834257388]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[639394, 11275, 311, 9, 70, "SeeAlsoSection",
 CellID->31364],
Cell[639708, 11286, 724, 26, 70, "SeeAlso",
 CellID->15947]
}, Open  ]],
Cell[CellGroupData[{
Cell[640469, 11317, 313, 9, 70, "TutorialsSection",
 CellID->1861],
Cell[640785, 11328, 191, 4, 70, "Tutorials",
 CellID->1632]
}, Open  ]],
Cell[CellGroupData[{
Cell[641013, 11337, 319, 9, 70, "MoreAboutSection",
 CellID->309380010],
Cell[641335, 11348, 147, 3, 70, "MoreAbout",
 CellID->466904549]
}, Open  ]],
Cell[641497, 11354, 27, 0, 70, "History"],
Cell[641527, 11356, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

