(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49112,       1836]
NotebookOptionsPosition[     39022,       1483]
NotebookOutlinePosition[     41301,       1542]
CellTagsIndexPosition[     41123,       1535]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:tutorial/IntegralTransforms"], 
          "Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Integral Transforms\"\>", 
       2->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/LaplaceTransform"], 
          "InverseFourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierTransform"], 
          "InverseZTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseZTransform"], 
          "Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"LaplaceTransform\"\>", 
       2->"\<\"InverseFourierTransform\"\>", 3->"\<\"InverseZTransform\"\>", 
       4->"\<\"Integrate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseLaplaceTransform", "ObjectName",
 CellID->28898],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseLaplaceTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseLaplaceTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["s", "TI"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Laplace transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseLaplaceTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseLaplaceTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multidimensional inverse Laplace transform of \
",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The inverse Laplace transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", "i"}]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"\[Gamma]", "-", "i", "\[Infinity]"}], 
      RowBox[{"\[Gamma]", "+", "i", "\[Infinity]"}]], 
     RowBox[{
      RowBox[{"F", "(", "s", ")"}], 
      SuperscriptBox["e", 
       RowBox[{"s", "t"}]], "d", "\[InvisibleSpace]", "s"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  StyleBox["\[Gamma]", "TR"]], "InlineFormula"],
 " is an arbitrary positive constant chosen so that the contour of \
integration lies to the right of all singularities in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->30280],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " and other options to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can also be given in ",
 Cell[BoxData[
  ButtonBox["InverseLaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseLaplaceTransform"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16742],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InverseLaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseLaplaceTransform"]], "InlineFormula"],
 " is output using ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["\[ScriptCapitalL]", "TR"], 
   RowBox[{"-", 
    StyleBox["1", "TR"]}]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->17700901]
}], "Notes",
 CellID->19355]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146070591],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->153076946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s"}], ")"}]}], ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49334096],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "t"}]]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75366507]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", "s", "]"}], "^", "2"}], "/", "s"}], ",", "s", ",", 
   "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214884017],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["\[Pi]", "2"], "6"]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "EulerGamma"}], "-", 
     RowBox[{"Log", "[", "t", "]"}]}], ")"}], "2"]}]], "Output",
 ImageSize->{194, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->367949548]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Erf", "[", 
    RowBox[{"5", "*", 
     RowBox[{"Sqrt", "[", "s", "]"}]}], "]"}], ",", "s", ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->461384543],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracDelta", "[", "t", "]"}], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{
      RowBox[{"-", "25"}], "+", "t"}], "]"}]}], 
   RowBox[{"\[Pi]", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "25"}], "+", "t"}]], " ", "t"}]]}]], "Output",
 ImageSize->{276, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->387461953]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "''"}], "[", "t", "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10804],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "s"}], " ", 
   RowBox[{"f", "[", "0", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", "2"], " ", 
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", "0", "]"}]}]], "Output",
 ImageSize->{313, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89292796]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{"%", ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17381],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", "\[Prime]\[Prime]",
   MultilineFunction->None], "[", "t", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->539465741]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8966],

Cell["Rational functions:", "ExampleText",
 CellID->176223455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   FractionBox["s", 
    RowBox[{
     SuperscriptBox["s", "2"], "+", "1"}]], ",", "s", ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653190508],

Cell[BoxData[
 RowBox[{"Cos", "[", "t", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365708305]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["s", "2"], "-", "4"}]], ",", "s", ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204752690],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "t"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"4", " ", "t"}]]}], ")"}]}]], "Output",
 ImageSize->{107, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179080187]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "s", "+", 
     RowBox[{"5", 
      SuperscriptBox["s", "2"]}]}]], ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->307066940],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "t"}], "/", "10"}]], " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["19"], " ", "t"}], "10"], "]"}]}], 
  SqrtBox["19"]]], "Output",
 ImageSize->{126, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->334966844]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["s", "2"], "+", 
     SuperscriptBox["s", "4"]}]], ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->37777327],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "6"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "t"}], "/", "2"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", 
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["3"], " ", "t"}], "2"], "]"}]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["\[ExponentialE]", "t"], " ", 
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["3"], " ", "t"}], "2"], "]"}]}], "-", 
    RowBox[{
     SqrtBox["3"], " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["3"], " ", "t"}], "2"], "]"}]}], "-", 
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["\[ExponentialE]", "t"], " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["3"], " ", "t"}], "2"], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{513, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->67304848]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343909803],

Cell["Elementary functions:", "ExampleText",
 CellID->6889462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Sqrt", "[", "s", "]"}]}], ")"}]}], ",", "s", ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20049],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    SqrtBox["t"]}]], "-", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "t"], " ", 
   RowBox[{"Erfc", "[", 
    SqrtBox["t"], "]"}]}]}]], "Output",
 ImageSize->{154, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173894166]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", "s"}], ")"}]}], "/", "s"}], ",", "s", ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->486011849],

Cell[BoxData[
 RowBox[{"HeavisideTheta", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "+", "t"}], "]"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8014743]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "s", "]"}], "/", 
    RowBox[{"s", "^", "4"}]}], ",", " ", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->380719662],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  SuperscriptBox["t", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox["11", "6"], "-", "EulerGamma", "-", 
    RowBox[{"Log", "[", "t", "]"}]}], ")"}]}]], "Output",
 ImageSize->{203, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1635086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"2", "/", "s"}], "]"}], ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->62968874],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", "t"}], "]"}], "t"]], "Output",
 ImageSize->{61, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->232649621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->289689221],

Cell["Special functions:", "ExampleText",
 CellID->34878701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"s", ",", " ", "0", ",", " ", "1"}], "]"}], ",", "s", ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->439841820],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "t"}]]}]]], "Output",
 ImageSize->{32, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45965622]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"PolyGamma", "[", 
    RowBox[{"2", ",", " ", "s"}], "]"}], ",", "s", ",", "t"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->38742918],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SuperscriptBox["t", "2"], 
   RowBox[{"1", "-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "t"}]]}]]}]], "Output",
 ImageSize->{53, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->485103861]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"s", "+", "1"}], "]"}], "*", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"-", "s"}], "]"}]}], ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->40791904],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[ExponentialE]", 
   RowBox[{"1", "+", "t"}]]}]], "Output",
 ImageSize->{43, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2961596]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->943288649],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->17700901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseLaplaceTransform", "[", 
   RowBox[{
    RowBox[{"F", "[", "s", "]"}], ",", "s", ",", "t"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->760203434],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[ScriptCapitalL]", "s", 
     RowBox[{"-", "1"}]], "[", 
    RowBox[{"F", "(", "s", ")"}], "]"}], 
   RowBox[{"(", "t", ")"}]}], TraditionalForm]], "Output",
 ImageSize->{67, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->404206432]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29861],

Cell["Multidimensional inverse Laplace transform:", "ExampleText",
 CellID->17355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s1", "^", "2"}], " ", 
      RowBox[{"s2", "^", "3"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"s1", ",", "s2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26041],

Cell[BoxData[
 FractionBox[
  RowBox[{"t1", " ", 
   SuperscriptBox["t2", "2"]}], "2"]], "Output",
 ImageSize->{45, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->279409680]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4792],

Cell[TextData[{
 "Compute the step response to the linear system with transfer function ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["s", "2"], "+", "s", "+", "1"}]], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->477666769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "^", "2"}], "+", "s", "+", "1"}], ")"}]}], " ", 
    RowBox[{"1", "/", "s"}]}], ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->252914003],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "t"}], "/", "2"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{
         SqrtBox["3"], " ", "t"}], "2"], "]"}]}], "+", 
     RowBox[{
      SqrtBox["3"], " ", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{
         SqrtBox["3"], " ", "t"}], "2"], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{278, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104950437]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->466641185],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106768565]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293486343],

Cell["Solve a differential equation using Laplace transforms:", "ExampleText",
 CellID->32365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "''"}], "[", "t", "]"}], "+", 
     RowBox[{"f", "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "t"}], ")"}]}]}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30446],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "s"}], " ", 
    RowBox[{"f", "[", "0", "]"}]}], "+", 
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}], "+", 
   RowBox[{
    SuperscriptBox["s", "2"], " ", 
    RowBox[{"LaplaceTransform", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "0", "]"}]}], "\[Equal]", 
  FractionBox["1", 
   RowBox[{"3", "+", "s"}]]}]], "Output",
 ImageSize->{564, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131911660]
}, Open  ]],

Cell["Solve for the Laplace transform:", "ExampleText",
 CellID->5344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"LaplaceTransform", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      FractionBox["1", 
       RowBox[{"3", "+", "s"}]], "+", 
      RowBox[{"s", " ", 
       RowBox[{"f", "[", "0", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}]}], 
     RowBox[{"1", "+", 
      SuperscriptBox["s", "2"]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{357, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->285109672]
}, Open  ]],

Cell["Find the inverse transform:", "ExampleText",
 CellID->19990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{"%", ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "3"}], " ", "t"}]], "10"], "+", 
     RowBox[{
      FractionBox["1", "10"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cos", "[", "t", "]"}]}], "+", 
        RowBox[{"10", " ", 
         RowBox[{"Cos", "[", "t", "]"}], " ", 
         RowBox[{"f", "[", "0", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"Sin", "[", "t", "]"}]}], "+", 
        RowBox[{"10", " ", 
         RowBox[{"Sin", "[", "t", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "0", "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{476, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->397884281]
}, Open  ]],

Cell["Apply initial conditions:", "ExampleText",
 CellID->788277515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], "/.", 
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Rule]", " ", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "0", "]"}], "\[Rule]", " ", "3"}]}], 
    "}"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->561496961],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "3"}], " ", "t"}]], "10"], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"9", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], "+", 
     RowBox[{"33", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{204, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->585221204]
}, Open  ]],

Cell[TextData[{
 "Find the solution directly using ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", " ", "=", " ", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], "/.", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"f", "''"}], "[", "t", "]"}], "+", 
          RowBox[{"f", "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "3"}], "t"}], "]"}]}], ",", " ", 
        RowBox[{
         RowBox[{"f", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "'"}], "[", "0", "]"}], "\[Equal]", "3"}]}], "}"}], 
      ",", 
      RowBox[{"f", "[", "t", "]"}], ",", "t"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31053],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "10"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "3"}], " ", "t"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"9", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"3", " ", "t"}]], " ", 
     RowBox[{"Cos", "[", "t", "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "t", "]"}], "2"], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"3", " ", "t"}]], " ", 
     RowBox[{"Sin", "[", "t", "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "t", "]"}], "2"]}], ")"}]}]], "Output",
 ImageSize->{356, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->60015316]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"sol1", "-", "sol2"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->33253822],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->204765711]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32283],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseLaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseLaplaceTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFormula"],
 " are mutual inverses:"
}], "ExampleText",
 CellID->792293290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "s", "]"}], ",", "s", ",", " ", "t"}], "]"}], ",", "t",
    ",", " ", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70250391],

Cell[BoxData[
 RowBox[{"f", "[", "s", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84346434]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"g", "[", "t", "]"}], ",", "t", ",", " ", "s"}], "]"}], ",", "s",
    ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50546575],

Cell[BoxData[
 RowBox[{"g", "[", "t", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->269668134]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s", "^", "2"}], "+", "1"}], ")"}]}], ",", "s", ",", " ", "t"}],
   "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[3]:=",
 CellID->517183249],

Cell[BoxData[
 RowBox[{"Sin", "[", "t", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[3]=",
 CellID->39824494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{"%", ",", "t", ",", " ", "s"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[4]:=",
 CellID->100959012],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["s", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[4]=",
 CellID->252005661]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11237],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseLaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseLaplaceTransform"]], "InlineFormula"],
 " of a ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->36431887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", "/", "3"}], "}"}], ",", " ", 
        RowBox[{"{", "}"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", " ", 
          RowBox[{"1", "/", "3"}], ",", " ", 
          RowBox[{"1", "/", "3"}], ",", " ", 
          RowBox[{"2", "/", "3"}]}], "}"}], ",", " ", 
        RowBox[{"{", "}"}]}], "}"}], ",", " ", "\n", "    ", 
      RowBox[{
       RowBox[{"s", "^", "3"}], "/", "27"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "*", 
      RowBox[{"Sqrt", "[", "3", "]"}], "*", "Pi"}], ")"}]}], ",", " ", "s", 
   ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254405178],

Cell[BoxData[
 FractionBox["t", 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "3"]}]]], "Output",
 ImageSize->{41, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77760645]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30994],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LaplaceTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaplaceTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseZTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseZTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16969]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24190],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntegralTransforms"]], "Tutorials",
 CellID->29886],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->23283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->51937258],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->304991749]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseLaplaceTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 8.6215766}", "context" -> "System`", 
    "keywords" -> {
     "Bromwich integral", "function transform", "impulse response", 
      "integral operator", "integral transform", "Integrate", 
      "inverse Laplace transform", "Laplace transform", "step response", 
      "transfer function", "transfer matrix", "transient analysis"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseLaplaceTransform[expr, s, t] gives the inverse Laplace transform \
of expr. InverseLaplaceTransform[expr, {s_1, s_2, ...}, {t_1, t_2, ...}] \
gives the multidimensional inverse Laplace transform of expr. ", 
    "synonyms" -> {"inverse laplace transform"}, "title" -> 
    "InverseLaplaceTransform", "type" -> "Symbol", "uri" -> 
    "ref/InverseLaplaceTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7367, 239, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->146070591]},
 "Ex--22034558506017011754,4"->{
  Cell[33605, 1272, 303, 10, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->517183249],
  Cell[33911, 1284, 227, 7, 36, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->39824494]},
 "Ex--22034558506017011754,5"->{
  Cell[34175, 1296, 191, 5, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->100959012],
  Cell[34369, 1303, 267, 9, 52, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->252005661]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40482, 1514},
 {"Ex--22034558506017011754,4", 40635, 1518},
 {"Ex--22034558506017011754,5", 40884, 1525}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2376, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2999, 83, 61, 1, 70, "ObjectName",
 CellID->28898],
Cell[3063, 86, 1705, 53, 70, "Usage",
 CellID->30535]
}, Open  ]],
Cell[CellGroupData[{
Cell[4805, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5283, 161, 949, 30, 70, "Notes",
 CellID->30280],
Cell[6235, 193, 499, 17, 70, "Notes",
 CellID->16742],
Cell[6737, 212, 593, 22, 70, "Notes",
 CellID->19355]
}, Closed]],
Cell[CellGroupData[{
Cell[7367, 239, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146070591],
Cell[CellGroupData[{
Cell[7752, 253, 148, 5, 70, "ExampleSection",
 CellID->153076946],
Cell[CellGroupData[{
Cell[7925, 262, 226, 7, 28, "Input",
 CellID->49334096],
Cell[8154, 271, 212, 7, 36, "Output",
 CellID->75366507]
}, Open  ]],
Cell[CellGroupData[{
Cell[8403, 283, 238, 8, 28, "Input",
 CellID->214884017],
Cell[8644, 293, 387, 14, 54, "Output",
 CellID->367949548]
}, Open  ]],
Cell[CellGroupData[{
Cell[9068, 312, 245, 8, 28, "Input",
 CellID->461384543],
Cell[9316, 322, 456, 16, 55, "Output",
 CellID->387461953]
}, Open  ]],
Cell[9787, 341, 120, 3, 70, "ExampleDelimiter",
 CellID->2031],
Cell[CellGroupData[{
Cell[9932, 348, 194, 7, 70, "Input",
 CellID->10804],
Cell[10129, 357, 508, 17, 36, "Output",
 CellID->89292796]
}, Open  ]],
Cell[CellGroupData[{
Cell[10674, 379, 148, 4, 70, "Input",
 CellID->17381],
Cell[10825, 385, 252, 8, 36, "Output",
 CellID->539465741]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11126, 399, 215, 7, 70, "ExampleSection",
 CellID->8966],
Cell[11344, 408, 62, 1, 70, "ExampleText",
 CellID->176223455],
Cell[CellGroupData[{
Cell[11431, 413, 229, 8, 70, "Input",
 CellID->653190508],
Cell[11663, 423, 187, 6, 36, "Output",
 CellID->365708305]
}, Open  ]],
Cell[CellGroupData[{
Cell[11887, 434, 229, 8, 70, "Input",
 CellID->204752690],
Cell[12119, 444, 427, 15, 51, "Output",
 CellID->179080187]
}, Open  ]],
Cell[CellGroupData[{
Cell[12583, 464, 258, 8, 70, "Input",
 CellID->307066940],
Cell[12844, 474, 409, 15, 72, "Output",
 CellID->334966844]
}, Open  ]],
Cell[CellGroupData[{
Cell[13290, 494, 262, 8, 70, "Input",
 CellID->37777327],
Cell[13555, 504, 1048, 38, 61, "Output",
 CellID->67304848]
}, Open  ]],
Cell[14618, 545, 125, 3, 70, "ExampleDelimiter",
 CellID->343909803],
Cell[14746, 550, 62, 1, 70, "ExampleText",
 CellID->6889462],
Cell[CellGroupData[{
Cell[14833, 555, 261, 9, 70, "Input",
 CellID->20049],
Cell[15097, 566, 366, 14, 55, "Output",
 CellID->173894166]
}, Open  ]],
Cell[CellGroupData[{
Cell[15500, 585, 252, 9, 70, "Input",
 CellID->486011849],
Cell[15755, 596, 239, 8, 36, "Output",
 CellID->8014743]
}, Open  ]],
Cell[CellGroupData[{
Cell[16031, 609, 238, 7, 70, "Input",
 CellID->380719662],
Cell[16272, 618, 356, 12, 51, "Output",
 CellID->1635086]
}, Open  ]],
Cell[CellGroupData[{
Cell[16665, 635, 210, 6, 70, "Input",
 CellID->62968874],
Cell[16878, 643, 232, 8, 51, "Output",
 CellID->232649621]
}, Open  ]],
Cell[17125, 654, 125, 3, 70, "ExampleDelimiter",
 CellID->289689221],
Cell[17253, 659, 60, 1, 70, "ExampleText",
 CellID->34878701],
Cell[CellGroupData[{
Cell[17338, 664, 233, 7, 70, "Input",
 CellID->439841820],
Cell[17574, 673, 271, 9, 39, "Output",
 CellID->45965622]
}, Open  ]],
Cell[CellGroupData[{
Cell[17882, 687, 220, 7, 70, "Input",
 CellID->38742918],
Cell[18105, 696, 306, 11, 54, "Output",
 CellID->485103861]
}, Open  ]],
Cell[CellGroupData[{
Cell[18448, 712, 296, 9, 70, "Input",
 CellID->40791904],
Cell[18747, 723, 232, 8, 49, "Output",
 CellID->2961596]
}, Open  ]],
Cell[18994, 734, 125, 3, 70, "ExampleDelimiter",
 CellID->943288649],
Cell[19122, 739, 250, 8, 70, "ExampleText",
 CellID->17700901],
Cell[CellGroupData[{
Cell[19397, 751, 224, 7, 70, "Input",
 CellID->760203434],
Cell[19624, 760, 375, 12, 54, "Output",
 CellID->404206432]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20048, 778, 239, 7, 70, "ExampleSection",
 CellID->29861],
Cell[20290, 787, 82, 1, 70, "ExampleText",
 CellID->17355],
Cell[CellGroupData[{
Cell[20397, 792, 381, 13, 70, "Input",
 CellID->26041],
Cell[20781, 807, 228, 8, 54, "Output",
 CellID->279409680]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21058, 821, 222, 7, 70, "ExampleSection",
 CellID->4792],
Cell[21283, 830, 285, 10, 70, "ExampleText",
 CellID->477666769],
Cell[CellGroupData[{
Cell[21593, 844, 317, 10, 70, "Input",
 CellID->252914003],
Cell[21913, 856, 654, 24, 61, "Output",
 CellID->104950437]
}, Open  ]],
Cell[CellGroupData[{
Cell[22604, 885, 183, 6, 70, "Input",
 CellID->466641185],
Cell[22790, 893, 2307, 42, 70, "Output",
 Evaluatable->False,
 CellID->106768565]
}, Open  ]],
Cell[25112, 938, 125, 3, 70, "ExampleDelimiter",
 CellID->293486343],
Cell[25240, 943, 94, 1, 70, "ExampleText",
 CellID->32365],
Cell[CellGroupData[{
Cell[25359, 948, 381, 14, 70, "Input",
 CellID->30446],
Cell[25743, 964, 715, 23, 51, "Output",
 CellID->131911660]
}, Open  ]],
Cell[26473, 990, 70, 1, 70, "ExampleText",
 CellID->5344],
Cell[CellGroupData[{
Cell[26568, 995, 232, 8, 70, "Input",
 CellID->3333],
Cell[26803, 1005, 674, 22, 61, "Output",
 CellID->285109672]
}, Open  ]],
Cell[27492, 1030, 66, 1, 70, "ExampleText",
 CellID->19990],
Cell[CellGroupData[{
Cell[27583, 1035, 148, 4, 70, "Input",
 CellID->30907],
Cell[27734, 1041, 964, 31, 54, "Output",
 CellID->397884281]
}, Open  ]],
Cell[28713, 1075, 68, 1, 70, "ExampleText",
 CellID->788277515],
Cell[CellGroupData[{
Cell[28806, 1080, 460, 16, 70, "Input",
 CellID->561496961],
Cell[29269, 1098, 504, 18, 54, "Output",
 CellID->585221204]
}, Open  ]],
Cell[29788, 1119, 208, 8, 70, "ExampleText",
 CellID->12558],
Cell[CellGroupData[{
Cell[30021, 1131, 817, 26, 70, "Input",
 CellID->31053],
Cell[30841, 1159, 752, 24, 51, "Output",
 CellID->60015316]
}, Open  ]],
Cell[CellGroupData[{
Cell[31630, 1188, 132, 4, 70, "Input",
 CellID->33253822],
Cell[31765, 1194, 158, 5, 36, "Output",
 CellID->204765711]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31972, 1205, 233, 7, 70, "ExampleSection",
 CellID->32283],
Cell[32208, 1214, 373, 12, 70, "ExampleText",
 CellID->792293290],
Cell[CellGroupData[{
Cell[32606, 1230, 275, 8, 70, "Input",
 CellID->70250391],
Cell[32884, 1240, 184, 6, 36, "Output",
 CellID->84346434]
}, Open  ]],
Cell[CellGroupData[{
Cell[33105, 1251, 275, 8, 70, "Input",
 CellID->50546575],
Cell[33383, 1261, 185, 6, 36, "Output",
 CellID->269668134]
}, Open  ]],
Cell[CellGroupData[{
Cell[33605, 1272, 303, 10, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->517183249],
Cell[33911, 1284, 227, 7, 36, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->39824494]
}, Open  ]],
Cell[CellGroupData[{
Cell[34175, 1296, 191, 5, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->100959012],
Cell[34369, 1303, 267, 9, 52, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->252005661]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34685, 1318, 224, 7, 70, "ExampleSection",
 CellID->11237],
Cell[34912, 1327, 344, 12, 70, "ExampleText",
 CellID->36431887],
Cell[CellGroupData[{
Cell[35281, 1343, 853, 26, 70, "Input",
 CellID->254405178],
Cell[36137, 1371, 225, 8, 51, "Output",
 CellID->77760645]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36423, 1386, 311, 9, 70, "SeeAlsoSection",
 CellID->30994],
Cell[36737, 1397, 1007, 35, 70, "SeeAlso",
 CellID->16969]
}, Open  ]],
Cell[CellGroupData[{
Cell[37781, 1437, 314, 9, 70, "TutorialsSection",
 CellID->24190],
Cell[38098, 1448, 148, 3, 70, "Tutorials",
 CellID->29886],
Cell[38249, 1453, 194, 4, 70, "Tutorials",
 CellID->23283]
}, Open  ]],
Cell[CellGroupData[{
Cell[38480, 1462, 318, 9, 70, "MoreAboutSection",
 CellID->51937258],
Cell[38801, 1473, 149, 3, 70, "MoreAbout",
 CellID->304991749]
}, Open  ]],
Cell[38965, 1479, 27, 0, 70, "History"],
Cell[38995, 1481, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

