(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40042,       1328]
NotebookOptionsPosition[     33184,       1091]
NotebookOutlinePosition[     34640,       1131]
CellTagsIndexPosition[     34554,       1126]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassP"], 
          "WeierstrassPPrime" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassPPrime"], 
          "WeierstrassHalfPeriods" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassHalfPeriods"], 
          "WeierstrassInvariants" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassInvariants"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"WeierstrassP\"\>", 
       2->"\<\"WeierstrassPPrime\"\>", 3->"\<\"WeierstrassHalfPeriods\"\>", 
       4->"\<\"WeierstrassInvariants\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Elliptic Integrals\"\>", 3->"\<\"Inverse Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseWeierstrassP", "ObjectName",
 CellID->12174],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseWeierstrassP",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseWeierstrassP"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a value of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " for which the Weierstrass function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[WeierstrassP]", 
        RowBox[{"(", 
         RowBox[{"u", ";", 
          SubscriptBox["g", "2"], ",", 
          SubscriptBox["g", "3"]}], ")"}]}], TraditionalForm]], "InlineMath"],
     
     " is equal to ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14464]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " returned always lies in the fundamental period parallelogram defined by \
the complex half\[Hyphen]periods ",
 Cell[BoxData[
  FormBox["\[Omega]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Omega]", "\[Prime]"], TraditionalForm]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->3150],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseWeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseWeierstrassP"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["q", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " finds the unique value of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", 
    RowBox[{"\[WeierstrassP]", 
     RowBox[{"(", 
      RowBox[{"u", ";", 
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", 
    RowBox[{
     SuperscriptBox["\[WeierstrassP]", "\[Prime]"], 
     RowBox[{"(", 
      RowBox[{"u", ";", 
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". For such a value to exist, ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " must be related by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["q", "2"], "=", 
    RowBox[{
     RowBox[{"4", 
      SuperscriptBox["p", "3"]}], "-", 
     RowBox[{
      SubscriptBox["g", "2"], "p"}], "-", 
     SubscriptBox["g", "3"]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->8267],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseWeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseWeierstrassP"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->849438],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->447733532],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->223188750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseWeierstrassP", "[", 
  RowBox[{"2.", ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269299123],

Cell[BoxData[
 RowBox[{"-", "0.7150958141802448`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49801564]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassP", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->258664082],

Cell[BoxData["2.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12454124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->394763509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseWeierstrassP", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223344636],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzH88E3gcx/GZmPnVjG2nHiWJOvVAWfUIuQ83Kz1S6kF6KHaR61FqfmW5
8/CjkyuFndCjR6rTVVMqpVWbHB9H0oP86HJkY5uxESXuZpWk+/bH+/F6PP95
O8ck7IyjUiiUbWRfe1BjsCSBJMW1UoZWj5tNJ3xzqBRgrJKXu2v0uMJt5LC5
GQUoR2Urg1R61Mf3dVhbUiBw8emGdIUe97+vO+voQIG9RTOqib/1+IPtyQXe
KyggUsTVvmnS4y4/R/cfQylwMLciKkiiR975jcHPyylgftTJOfqwHs+xZiyd
tptAUOPlpm6DDqecnqUOT5mAZ8ncxOwZHbq2LspIK6LC5wTR2Gt3HXZuGKEV
+5uCeKOwKq5lGHPWNfou0ZiCt9E5JTVhGKs+MP7zFs8DOmt9sC1rGKsjR/hs
XzOQGeKruhuGsD648/t4pRm8XVZiOZM6hAFz7k/4eeYgEQdmnFoxhB3fnX9b
spIGvxsCVqcNaZHrXCCtbqVBZlKdW/EfWmQ8m54NO2YBOR2P1WyBFo2fEt4d
+oYOOaYh8jtLtbhzOiqO1kKHB81TF9uGBvFk4ctjycmWkJ76THvixiA+fRDp
Hcq0gmKZKnZLyiCml4cnP0AruJ99ufmG7yD6OMZEntlnDTGZc13n6IOYEKFt
HmXYgGi4ao3fPxrMWDvW7lBnA7xbvduuX9VgablpljTKFh7/5Dw5KtKgy4vf
pK+s5sPedZ/aZzZpsLbQsyixaj4M2tXLxYs0yDJW5o67MaB7kzQ6cUyNp2hp
82IyGNCOS44WlKoxW93ea9fBgNZm/7X3N6uRe2HgzQlXO8gKrf+1970Ku5et
DhWk2wHfpfNDV6UKP6baWKS02UG2m0fAx/0q7Lt51WTLUib4Nxp5oQtV6H+t
cXtkChMObc7fHv9qAMVC1zcvGpkQyJc/zDk/gGULA1utHe1BXbO1xhg2gKvE
I7PZB+3Ba2NbQT5nANN0/CR5gz1krRfsqejpx2Cqp8+3TAfQdfhzzpb1I+1d
5A6TGAcQ3RU4UGP7MbseKi/KHcAw0HNy8fJ+zAy7G5FEZ0HEaG/tmUklrm/v
5dP3saD8iKtX6yMl9rN4JyxkLEgSBeUJs5Ro7rqBHUBjQxMv+sq/W5U4zh59
7RfNhrLw1+p4jhLDO52YyXfZ4O3RuSZfr8DbEWWnbL+wYaFTv6RcpsD6xi4Q
hnPAizl5oC1XgeGGwhCahAOfQ4xevN0KrLCgXYz9zAGqUTA+uVyBT6jHbYTE
cvoB7jixZnYmM434iDopQ0e8YGpiXwFxTdfZ+Qri/L6e5TLihFYTbhNxYqVE
ajnHARm7JKOU2Gcrv62auG46z96HeBe/we9P4lmgR3GJU8Cn6imxNCRf4kF8
m+tRpCT++dalDS7EixexI8y+cMBw7K3Amth0QqfdTTwdGnBH5abAJaOCsFji
lupZ4ytiP21f8xHizpe18JJY1NN+4xfixD1B3S3Eo/UPhbeJj6flfrpHPK/G
U/OIWKyNDrpF7Cy9ueMv4vs2fuLrxJEVl7g9xG4VJi4Xvv5d4Ug0xELW2OES
4uKyIs448WNez6NC4nulVnnTxPS1Tyl5xM/FuTNfiHfqa7bkEP8PMN1z2w==

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  Method->{},
  PlotRange->{{2, 6}, {-0.715095798753124, -0.40860063836553195`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29235543]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19406],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->524176606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseWeierstrassP", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"{", 
    RowBox[{"I", ",", 
     RowBox[{"1", "-", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->319591460],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.5997309244909286`"}], "+", 
  RowBox[{"0.11468948237209349`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403808290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->491895460],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->37248354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseWeierstrassP", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->436702198],

Cell[BoxData[
 RowBox[{"-", 
  "0.7150958141802448211290408113718993802496706666942603086321886356216`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32763302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->416576201],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->380449385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseWeierstrassP", "[", 
  RowBox[{"2.00000000000000000000000", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16479581],

Cell[BoxData[
 RowBox[{"-", 
  "0.71509581418024482112904081137189924998`22.10957723151516"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92488861]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->387333667],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->136901804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseWeierstrassP", "[", 
   RowBox[{"z", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["g", "2"], ",", 
      SubscriptBox["g", "3"]}], "}"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90544291],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[WeierstrassP]", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{
    RowBox[{"z", ";", 
     SubscriptBox["g", "2"]}], ",", 
    SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "Output",
 ImageSize->{72, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->131468225]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30164],

Cell["Evaluate the generalized form numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->74024708],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "pp"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"2.", ",", 
     RowBox[{"2", 
      RowBox[{"Sqrt", "[", "7", "]"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294424259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "=", 
  RowBox[{"InverseWeierstrassP", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "pp"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5338350],

Cell[BoxData[
 RowBox[{"-", "0.7150958141802448`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9737848]
}, Open  ]],

Cell[TextData[{
 "These are the inverse relationships with ",
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WeierstrassPPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassPPrime"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->62577785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "==", 
  RowBox[{"WeierstrassP", "[", 
   RowBox[{"z", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->847588702],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127315717]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pp", "==", 
  RowBox[{"WeierstrassPPrime", "[", 
   RowBox[{"z", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->73881612],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->153699814]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32003],

Cell[TextData[{
 "Plot the real and imaginary part of ",
 Cell[BoxData[
  ButtonBox["InverseWeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseWeierstrassP"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->433087888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"InverseWeierstrassP", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "I"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"InverseWeierstrassP", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "I"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196917870],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263780591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->553424356],

Cell["Form derivatives:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->729716265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseWeierstrassP", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["g", "2"], ",", 
        SubscriptBox["g", "3"]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "6"}], "}"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213563709],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{433, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->20262435]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->286],

Cell[TextData[{
 "If the first argument does not represent a pair of values of Weierstrass ",
 Cell[BoxData[
  FormBox["\[WeierstrassP]", TraditionalForm]]],
 " functions, ",
 Cell[BoxData[
  ButtonBox["InverseWeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseWeierstrassP"]], "InlineFormula"],
 " stays unevaluated:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->31021770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseWeierstrassP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RandomReal", "[", "]"}], ",", 
     RowBox[{"RandomReal", "[", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233214181],

Cell[BoxData[
 RowBox[{"InverseWeierstrassP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.516930611459405`", ",", "0.10285435179454194`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Output",
 ImageSize->{339, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25506035]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187418545],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseWeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseWeierstrassP"]], "InlineFormula"],
 " evaluates to a vector\[Hyphen]valued first argument:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->813249628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseWeierstrassP", "[", 
  RowBox[{
   RowBox[{"WeierstrassP", "[", 
    RowBox[{"2", ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68323109],

Cell[BoxData[
 RowBox[{"InverseWeierstrassP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"WeierstrassP", "[", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"WeierstrassPPrime", "[", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Output",
 ImageSize->{573, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1234277]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22662],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassPPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassPPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassHalfPeriods",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassHalfPeriods"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassInvariants",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassInvariants"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30110]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21931],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->12084]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->3214],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/WeierstrassEllipticFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/InverseWeierstrassP/"],
    None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->451014745],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->666244026],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->421011333],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->110467924],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->226561794]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseWeierstrassP - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 9.8716086}", "context" -> "System`", 
    "keywords" -> {
     "elliptic functions", "inverse Weierstrass", 
      "inverse Weierstrass elliptic function", 
      "Weierstrass elliptic functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseWeierstrassP[p, {g_2, g_3}] gives a value of u for which the \
Weierstrass function \\[WeierstrassP] (u; g_2, g_3) is equal to p. ", 
    "synonyms" -> {"inverse weierstrass p"}, "title" -> "InverseWeierstrassP",
     "type" -> "Symbol", "uri" -> "ref/InverseWeierstrassP"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7543, 251, 357, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->849438]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34414, 1119}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2674, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3297, 89, 57, 1, 70, "ObjectName",
 CellID->12174],
Cell[3357, 92, 1193, 39, 70, "Usage",
 CellID->14464]
}, Open  ]],
Cell[CellGroupData[{
Cell[4587, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5065, 153, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5188, 159, 427, 15, 70, "Notes",
 CellID->3150],
Cell[5618, 176, 1645, 61, 70, "Notes",
 CellID->8267],
Cell[7266, 239, 240, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[7543, 251, 357, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->849438],
Cell[CellGroupData[{
Cell[7925, 265, 148, 5, 70, "ExampleSection",
 CellID->447733532],
Cell[8076, 272, 201, 5, 70, "ExampleText",
 CellID->223188750],
Cell[CellGroupData[{
Cell[8302, 281, 198, 6, 28, "Input",
 CellID->269299123],
Cell[8503, 289, 192, 6, 36, "Output",
 CellID->49801564]
}, Open  ]],
Cell[CellGroupData[{
Cell[8732, 300, 190, 6, 28, "Input",
 CellID->258664082],
Cell[8925, 308, 159, 5, 36, "Output",
 CellID->12454124]
}, Open  ]],
Cell[9099, 316, 125, 3, 70, "ExampleDelimiter",
 CellID->394763509],
Cell[CellGroupData[{
Cell[9249, 323, 307, 10, 70, "Input",
 CellID->223344636],
Cell[9559, 335, 2135, 44, 126, "Output",
 CellID->29235543]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11743, 385, 216, 7, 70, "ExampleSection",
 CellID->19406],
Cell[11962, 394, 226, 5, 70, "ExampleText",
 CellID->524176606],
Cell[CellGroupData[{
Cell[12213, 403, 239, 8, 70, "Input",
 CellID->319591460],
Cell[12455, 413, 271, 8, 36, "Output",
 CellID->403808290]
}, Open  ]],
Cell[12741, 424, 125, 3, 70, "ExampleDelimiter",
 CellID->491895460],
Cell[12869, 429, 206, 5, 70, "ExampleText",
 CellID->37248354],
Cell[CellGroupData[{
Cell[13100, 438, 246, 8, 70, "Input",
 CellID->436702198],
Cell[13349, 448, 252, 8, 36, "Output",
 CellID->32763302]
}, Open  ]],
Cell[13616, 459, 125, 3, 70, "ExampleDelimiter",
 CellID->416576201],
Cell[13744, 464, 113, 3, 70, "ExampleText",
 CellID->380449385],
Cell[CellGroupData[{
Cell[13882, 471, 210, 6, 70, "Input",
 CellID->16479581],
Cell[14095, 479, 235, 7, 36, "Output",
 CellID->92488861]
}, Open  ]],
Cell[14345, 489, 125, 3, 70, "ExampleDelimiter",
 CellID->387333667],
Cell[14473, 494, 340, 11, 70, "ExampleText",
 CellID->136901804],
Cell[CellGroupData[{
Cell[14838, 509, 282, 10, 70, "Input",
 CellID->90544291],
Cell[15123, 521, 388, 13, 52, "Output",
 CellID->131468225]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15560, 540, 239, 7, 70, "ExampleSection",
 CellID->30164],
Cell[15802, 549, 221, 5, 70, "ExampleText",
 CellID->74024708],
Cell[16026, 556, 266, 10, 70, "Input",
 CellID->294424259],
Cell[CellGroupData[{
Cell[16317, 570, 263, 9, 70, "Input",
 CellID->5338350],
Cell[16583, 581, 191, 6, 36, "Output",
 CellID->9737848]
}, Open  ]],
Cell[16789, 590, 378, 13, 70, "ExampleText",
 CellID->62577785],
Cell[CellGroupData[{
Cell[17192, 607, 207, 7, 70, "Input",
 CellID->847588702],
Cell[17402, 616, 161, 5, 36, "Output",
 CellID->127315717]
}, Open  ]],
Cell[CellGroupData[{
Cell[17600, 626, 212, 7, 70, "Input",
 CellID->73881612],
Cell[17815, 635, 161, 5, 36, "Output",
 CellID->153699814]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18025, 646, 223, 7, 70, "ExampleSection",
 CellID->32003],
Cell[18251, 655, 378, 12, 70, "ExampleText",
 CellID->433087888],
Cell[CellGroupData[{
Cell[18654, 671, 590, 19, 70, "Input",
 CellID->196917870],
Cell[19247, 692, 3263, 58, 70, "Output",
 Evaluatable->False,
 CellID->263780591]
}, Open  ]],
Cell[22525, 753, 125, 3, 70, "ExampleDelimiter",
 CellID->553424356],
Cell[22653, 758, 197, 5, 70, "ExampleText",
 CellID->729716265],
Cell[CellGroupData[{
Cell[22875, 767, 398, 14, 70, "Input",
 CellID->213563709],
Cell[23276, 783, 3230, 57, 70, "Output",
 Evaluatable->False,
 CellID->20262435]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26555, 846, 224, 7, 70, "ExampleSection",
 CellID->286],
Cell[26782, 855, 513, 15, 70, "ExampleText",
 CellID->31021770],
Cell[CellGroupData[{
Cell[27320, 874, 306, 10, 70, "Input",
 CellID->233214181],
Cell[27629, 886, 360, 11, 36, "Output",
 CellID->25506035]
}, Open  ]],
Cell[28004, 900, 125, 3, 70, "ExampleDelimiter",
 CellID->187418545],
Cell[28132, 905, 389, 11, 70, "ExampleText",
 CellID->813249628],
Cell[CellGroupData[{
Cell[28546, 920, 319, 10, 70, "Input",
 CellID->68323109],
Cell[28868, 932, 580, 19, 36, "Output",
 CellID->1234277]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29509, 958, 311, 9, 70, "SeeAlsoSection",
 CellID->22662],
Cell[29823, 969, 1021, 35, 70, "SeeAlso",
 CellID->30110]
}, Open  ]],
Cell[CellGroupData[{
Cell[30881, 1009, 314, 9, 70, "TutorialsSection",
 CellID->21931],
Cell[31198, 1020, 192, 4, 70, "Tutorials",
 CellID->12084]
}, Open  ]],
Cell[CellGroupData[{
Cell[31427, 1029, 320, 9, 70, "RelatedLinksSection",
 CellID->3214],
Cell[31750, 1040, 198, 4, 70, "RelatedLinks"],
Cell[31951, 1046, 209, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32197, 1055, 319, 9, 70, "MoreAboutSection",
 CellID->451014745],
Cell[32519, 1066, 147, 3, 70, "MoreAbout",
 CellID->666244026],
Cell[32669, 1071, 147, 3, 70, "MoreAbout",
 CellID->421011333],
Cell[32819, 1076, 145, 3, 70, "MoreAbout",
 CellID->110467924],
Cell[32967, 1081, 145, 3, 70, "MoreAbout",
 CellID->226561794]
}, Open  ]],
Cell[33127, 1087, 27, 0, 70, "History"],
Cell[33157, 1089, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

