(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19942,        702]
NotebookOptionsPosition[     16265,        581]
NotebookOutlinePosition[     17581,        618]
CellTagsIndexPosition[     17496,        613]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Grids, Rows, and Columns in Mathematica\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pane" :> Documentation`HelpLookup["paclet:ref/Pane"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"], "ItemSize" :> 
          Documentation`HelpLookup["paclet:ref/ItemSize"], "ItemStyle" :> 
          Documentation`HelpLookup["paclet:ref/ItemStyle"], "Spacings" :> 
          Documentation`HelpLookup["paclet:ref/Spacings"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"], "ImageSizeAction" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeAction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Pane\"\>", 2->"\<\"Style\"\>", 
       3->"\<\"ItemSize\"\>", 4->"\<\"ItemStyle\"\>", 5->"\<\"Spacings\"\>", 
       6->"\<\"Inset\"\>", 7->"\<\"ImageSizeAction\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Item", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Item",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Item"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an item within constructs such as ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["PopupMenu",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["TabView",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
     " that displays with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as the content, and with the specified options applied to the region \
containing ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12116]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can typically be given: ", "Notes",
 CellID->19621],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment within the containing region", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "background color for the containing region", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to include a frame around the containing region", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style for the frame", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ItemSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ItemSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size allowed for the item", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->330493237],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " specifies that a frame should be drawn around all edges of the item. "
}], "Notes",
 CellID->410799252],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["bottom", "TI"], ",", 
     StyleBox["left", "TI"], ",", 
     StyleBox["top", "TI"], ",", 
     StyleBox["right", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies what should be drawn on each edge of the item. "
}], "Notes",
 CellID->1018297811]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18654858],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->390198402],

Cell["Put a frame around the first element in a grid:", "ExampleText",
 CellID->563138480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "b"}], "}"}], ",",
     
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1616497056],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["a",
      Frame->True,
      StripOnInput->False], "b"},
    {"c", "d"}
   }],
  "Grid"]], "Output",
 ImageSize->{32, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1653925810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->708001031],

Cell["Draw the first element of the grid with a red background:", \
"ExampleText",
 CellID->166439990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Background", "\[Rule]", "Red"}]}], "]"}], ",", "b"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1312899963],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["a",
      Background->RGBColor[1, 0, 0],
      StripOnInput->False], "b"},
    {"c", "d"}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->502761902]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17192],

Cell["Draw a frame on certain faces of the item:", "ExampleText",
 CellID->1659632565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Item", "[", 
       RowBox[{"b", ",", 
        RowBox[{"Frame", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"False", ",", "True", ",", "True", ",", "False"}], 
          "}"}]}]}], "]"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->971291625],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b"},
    {"c", 
     ItemBox["b",
      Frame->{False, True, True, False},
      StripOnInput->False]}
   }],
  "Grid"]], "Output",
 ImageSize->{27, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1718619616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77312668],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " will apply its styles throughout the entire spanning area:"
}], "ExampleText",
 CellID->1681169372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Background", "\[Rule]", "Red"}]}], "]"}], ",", 
      "SpanFromLeft"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190956627],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["a",
      Background->RGBColor[1, 0, 0],
      StripOnInput->False], "\[SpanFromLeft]"},
    {"c", "d"}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1184833962]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11916],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ItemStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Spacings"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeAction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28744]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1116],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->18889]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Item",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Item"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Item - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 22.0906714}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Item[expr, options] represents an item within constructs such as Grid, \
PopupMenu or TabView that displays with expr as the content, and with the \
specified options applied to the region containing expr. ", "synonyms" -> {}, 
    "title" -> "Item", "type" -> "Symbol", "uri" -> "ref/Item"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8334, 250, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->18654858]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17354, 606}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1782, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2405, 66, 1569, 37, 70, "ObjectNameGrid"],
Cell[3977, 105, 1231, 39, 70, "Usage",
 CellID->12116]
}, Open  ]],
Cell[CellGroupData[{
Cell[5245, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5723, 166, 79, 1, 70, "Notes",
 CellID->19621],
Cell[5805, 169, 1726, 47, 70, "3ColumnTableMod",
 CellID->330493237],
Cell[7534, 218, 338, 11, 70, "Notes",
 CellID->410799252],
Cell[7875, 231, 422, 14, 70, "Notes",
 CellID->1018297811]
}, Closed]],
Cell[CellGroupData[{
Cell[8334, 250, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18654858],
Cell[CellGroupData[{
Cell[8718, 264, 148, 5, 70, "ExampleSection",
 CellID->390198402],
Cell[8869, 271, 90, 1, 70, "ExampleText",
 CellID->563138480],
Cell[CellGroupData[{
Cell[8984, 276, 360, 13, 28, "Input",
 CellID->1616497056],
Cell[9347, 291, 283, 13, 52, "Output",
 CellID->1653925810]
}, Open  ]],
Cell[9645, 307, 125, 3, 70, "ExampleDelimiter",
 CellID->708001031],
Cell[9773, 312, 102, 2, 70, "ExampleText",
 CellID->166439990],
Cell[CellGroupData[{
Cell[9900, 318, 364, 13, 70, "Input",
 CellID->1312899963],
Cell[10267, 333, 300, 13, 48, "Output",
 CellID->502761902]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10616, 352, 216, 7, 70, "ExampleSection",
 CellID->17192],
Cell[10835, 361, 86, 1, 70, "ExampleText",
 CellID->1659632565],
Cell[CellGroupData[{
Cell[10946, 366, 457, 15, 70, "Input",
 CellID->971291625],
Cell[11406, 383, 305, 13, 50, "Output",
 CellID->1718619616]
}, Open  ]],
Cell[11726, 399, 124, 3, 70, "ExampleDelimiter",
 CellID->77312668],
Cell[11853, 404, 229, 7, 70, "ExampleText",
 CellID->1681169372],
Cell[CellGroupData[{
Cell[12107, 415, 376, 13, 70, "Input",
 CellID->190956627],
Cell[12486, 430, 315, 13, 44, "Output",
 CellID->1184833962]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12862, 450, 311, 9, 70, "SeeAlsoSection",
 CellID->11916],
Cell[13176, 461, 1672, 62, 70, "SeeAlso",
 CellID->28744]
}, Open  ]],
Cell[CellGroupData[{
Cell[14885, 528, 313, 9, 70, "TutorialsSection",
 CellID->1116],
Cell[15201, 539, 299, 9, 70, "Tutorials",
 CellID->18889]
}, Open  ]],
Cell[CellGroupData[{
Cell[15537, 553, 305, 8, 70, "RelatedLinksSection"],
Cell[15845, 563, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[16208, 577, 27, 0, 70, "History"],
Cell[16238, 579, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

