(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42866,       1516]
NotebookOptionsPosition[     35904,       1276]
NotebookOutlinePosition[     37165,       1312]
CellTagsIndexPosition[     37079,       1307]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tables and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Item" :> Documentation`HelpLookup["paclet:ref/Item"], 
          "ItemSize" :> Documentation`HelpLookup["paclet:ref/ItemSize"], 
          "Background" :> Documentation`HelpLookup["paclet:ref/Background"], 
          "Frame" :> Documentation`HelpLookup["paclet:ref/Frame"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Item\"\>", 2->"\<\"ItemSize\"\>", 
       3->"\<\"Background\"\>", 4->"\<\"Frame\"\>", 
       5->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Grids & Tables\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ItemStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ItemStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ItemStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Column",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Column"]], "InlineFormula"],
     " and related constructs that specifies styles to use for items."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ItemStyle", "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " specifies that all items should use style specification ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Item style specifications can include all options to ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ", as well as options to ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Directive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directive"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["opt", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["opt", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " can be used to specify multiple options. "
}], "Notes",
 CellID->84740616],

Cell["\<\
Item style specifications are applied to the complete region of an item, not \
just its contents, so that, for example, backgrounds extend to the edge of \
the item.\
\>", "Notes",
 CellID->17210272],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["ItemStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemStyle"]], "InlineFormula"],
 " can be given as follows to apply separately to different items:"
}], "Notes",
 CellID->656693394],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["spec", "TI"], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to all items "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["x", "TI"]], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " at successive horizontal positions"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " at successive horizontal and vertical positions"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    FormBox[
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["spec", "TI"], 
        StyleBox["x", "TI"]], ",", 
       SubscriptBox[
        StyleBox["spec", "TI"], 
        StyleBox["y", "TI"]], ",", 
       StyleBox["rules", "TI"]}], "}"}],
     TraditionalForm], Cell[TextData[{
     "also allow explicit rules for individual ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     " elements"
    }], "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, {Left}}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->11051],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " can have the following forms:"
}], "Notes",
 CellID->25391],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     "; then use defaults "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["c", "TI"], "}"}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " in all cases "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}], "}"}], "}"}], Cell[TextData[{
     "alternate between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[TextData[{
     "cycle through all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", then repeatedly use ",
     StyleBox["c", "TI"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", then repeatedly use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ", but use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]]}]}]}], Cell[", ", "TableText"], 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]], Cell[", \[Ellipsis] }, ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], Cell[", \[Ellipsis] , ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]], Cell["}", "TableText"], 
      StyleBox[" ", "TR"]}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning, then cyclically use the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", then use the last sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning and the last sequence at the end"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "specify what to use at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " to override specifications in ",
     StyleBox["spec", "TI"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, {Left}}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, False, True, True, True, 
      True}}}},
 CellID->16534],

Cell[TextData[{
 "If multiple ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["rules", "TI"]], "InlineFormula"],
 " specify styles for a particular element, the styles are combined in the \
order they appear."
}], "Notes",
 CellID->830185079]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214036029],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->42840505],

Cell["Style all the elements in the grid:", "ExampleText",
 CellID->11043201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->646483028],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQTG//+DaE4oTSs+I9hGBtb/YPo/BAAFuEEUC7IQ7USY4CTIRbwk
0sxU0D04/E/vWMdMecSQo6lzNHWOps7R1DmaOkdT52jqHCqpk4ERAEZnuTo=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262354518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->615603161],

Cell["Style the first row:", "ExampleText",
 CellID->501567143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", "Red", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6373090],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZgKyQDQnlKYVnxFsIwMrhPoPBkAGAzeIZkEWop0IE8TXUBfx
kkgzU0H3oPA/3WMdM+URQ46mztHUOZo6R1PnaOokI3XCQvs/1Fwa8pFS539Y
gCHCEFmIdiJIqfM/NN2QQDNTQffg8D+9Yx0z5TEwAgDa0+f9\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->571749023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1373950644],

Cell["Use a style from the current stylesheet:", "ExampleText",
 CellID->8827871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<h1\>\"", ",", "\"\<h2\>\"", ",", "\"\<h3\>\""}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", "\"\<Subsection\>\"", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->498451071],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"h1\"\>", "\<\"h2\"\>", "\<\"h3\"\>"},
    {"x", "x", "x"},
    {"x", "x", "x"}
   },
   GridBoxItemStyle->{"Columns" -> {{Automatic}}, "Rows" -> {"Subsection"}}],
  "Grid"]], "Output",
 ImageSize->{80, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1854946178]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
Blue and red font colors for the first and second horizontal positions:\
\>", "ExampleText",
 CellID->946257814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red"}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1855750711],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZQKyQDQniAaJQWlOiDgDVJ5iPiPYRgZWMPUfAkAO4wbRLMhi
EBEGmAgD9USYIL6G+pgX6lNeqAsJ0cxU0D0o/E/3WMdMecSQo6lzNHWOps7R
1DmaOkdT52jqHCqpk4ERADIL8fM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205608300]
}, Open  ]],

Cell["\<\
Blue and red font colors for the first and last horizontal positions:\
\>", "ExampleText",
 CellID->1638673863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", "}"}], ",", "Red"}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1538714088],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZQKyQDQnhGaA8hmowv8P5QNpRrCNDKxg6j8EgBzGDaJZGGBi
QAZ1RZBtY4KTIB/zQl1KFA3Ux0wF3YPC/3SPdcyURww5mjpHU+do6hxNnaOp
czR1jqbOoZI6GRgBXTfx8w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202727438]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1861326313],

Cell["\<\
Blue and red font colors for the first and second vertical positions:\
\>", "ExampleText",
 CellID->482528275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554886156],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVMEOgjAM7TY9GMLdI7/hD+jJj2iICRyMBvn/WkaBES7ObMsOLNle+5LC
2r71jn3zeGLf1ljdOnw3bf2prq+OKaMAAHlfzsA2sWU3EjG6p2ZaszXgSTCW
r+wf4TgC2cUGFAMeXCoeo8es5UalJ5oA0Vnkn7zrW+X9cu7q3NWZsTqnapN8
N6LvqJOmgi01dKl4jKNOEt14oAkQnUf+qbv+9+wkUTmJ6qP5q9k514vmF75Q
8ZjV7KTSE02A6CzyT971rfJAfQHrsS3G\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->457141765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21555281],

Cell["Alternating blue and red font colors:", "ExampleText",
 CellID->954466853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Red"}], "}"}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1930194792],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZQKyQDQniAaJQWlOqDi15BnBNjKwgqn/EAByGDeIZkEWg4gg
K6KWGiaIr6Eu4oW6lJdIPjMVdA8K/9M91jFTHjHkaOocTZ2jqXM0dY6mztHU
OZo6h0rqZGAEAAeYuTo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271115730]
}, Open  ]],

Cell["\<\
Alternating font colors with orange superimposed in the first and last \
positions:\
\>", "ExampleText",
 CellID->1502355071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", "Red"}], "}"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "Orange"}], ",", 
          RowBox[{
           RowBox[{"-", "1"}], "\[Rule]", "Orange"}]}], "}"}]}], "}"}], ",", 
      "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->448480217],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyfS/AYj//wfRnGCaAcpngPCBupigNFnySOYzgm1kYAVSQN5/CGhg
YOAGibMApaBCMBEkgf+UqEG2jAnqa4iLeKEu5YX6AC8fqJ6ZCroHh//pHeuY
KY8YcjR1jqbO0dQ5mjpHU+do6hxNnUMldTIwAgBDN+E6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->215331245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100860804],

Cell["Style specific elements:", "ExampleText",
 CellID->2085162572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "Red"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->666653385],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZgKyQDQnlKYVnxFsIwMrhPoPBkAGAzeIZkEWop0IE8TXUBfx
kkgzU0H3oPA/3WMdM+URQxK0BxYb/+mfOv/DRP7TJXX+pyh1Eq17UPif7rFO
o9RJ9Vw0KMoOAulotOwcJGUnFXMJCakTuVgYqNRJRGmHJ3WSrXtw+J/esY6Z
8hgYAQomti8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540484142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24144160],

Cell["Style a region:", "ExampleText",
 CellID->541712211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "Red"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2099088016],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZgKyQDQnlKYVnxFsIwMrhPoPBkAGAzeIZkEWop0IE8TXUBfx
kkgzU0H3oPA/3WMdM+URQzLBQvs/1FxCfOqkzv+wAEOEIbIQLhGqps7/0HSD
ThOXOsnWPTj8T+9YH02do6lzNHWOps7R1EmN1MnACADynPvp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9757338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1128799210],

Cell["Overlapping specifications are unified when possible:", "ExampleText",
 CellID->857784872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "Red"}], ",", 
      RowBox[{"1", "\[Rule]", "16"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->732621393],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxItemStyle->{
    "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0]}, 
     "RowsIndexed" -> {1 -> 16}}],
  "Grid"]], "Output",
 ImageSize->{122, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1326425765]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " can be used to specify a style for the entire grid:"
}], "ExampleText",
 CellID->866656473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1661247757],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQTG//+DaE4oTSs+I9hGBtb/YPo/BAAFuEEUC7IQ7USY4CTIRbwk
0sxU0D04/E/vWMdMecSQo6lzNHWOps7R1DmaOkdT52jqHCqpk4ERAEZnuTo=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128420144]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["Column styles have precedence over row styles:", "ExampleText",
 CellID->567380668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "14"}], "]"}]}], ",", 
      RowBox[{"1", "\[Rule]", "16"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1139494396],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxItemStyle->{"ColumnsIndexed" -> {1 -> Directive[
         RGBColor[1, 0, 0], 14]}, "RowsIndexed" -> {1 -> 16}}],
  "Grid"]], "Output",
 ImageSize->{120, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110447583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1123448862],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 " to wrap multiple style directives:"
}], "ExampleText",
 CellID->1492514676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Red", ",", "Italic"}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1590541561],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwlAGxpQQDkP0fyALj
sv//gTQyycDyH0xDEBOQzQKkOYE0Mw35DAzMIFtZQbbCAVCUdxCIMoEpULAw
MEPlgKL8NOaDwwPoGCRRIJOfxvyB9OtgTwEgkhmJ5qIxHzVfEkOO5t3RvDua
d0fz7mjeHc27o3l3NO8OdMyN5t3RvDuQeZeBEQCX1mOB\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{118, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360348159]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Item",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Item"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Background",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Background"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->184805041]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ItemStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 22.8719414}", "context" -> "System`", 
    "keywords" -> {"grid cell style"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ItemStyle is an option for Grid, Column and related constructs that \
specifies styles to use for items.", "synonyms" -> {"item style"}, "title" -> 
    "ItemStyle", "type" -> "Symbol", "uri" -> "ref/ItemStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16409, 543, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->214036029]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36935, 1300}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2075, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2698, 77, 1574, 37, 70, "ObjectNameGrid"],
Cell[4275, 116, 748, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5060, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5538, 161, 263, 9, 70, "Notes",
 CellID->1067943069],
Cell[5804, 172, 768, 27, 70, "Notes",
 CellID->84740616],
Cell[6575, 201, 209, 5, 70, "Notes",
 CellID->17210272],
Cell[6787, 208, 259, 8, 70, "Notes",
 CellID->656693394],
Cell[7049, 218, 1924, 62, 70, "2ColumnTableMod",
 CellID->11051],
Cell[8976, 282, 190, 8, 70, "Notes",
 CellID->25391],
Cell[9169, 292, 6865, 232, 70, "2ColumnTableMod",
 CellID->16534],
Cell[16037, 526, 335, 12, 70, "Notes",
 CellID->830185079]
}, Closed]],
Cell[CellGroupData[{
Cell[16409, 543, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214036029],
Cell[CellGroupData[{
Cell[16794, 557, 147, 5, 70, "ExampleSection",
 CellID->42840505],
Cell[16944, 564, 77, 1, 70, "ExampleText",
 CellID->11043201],
Cell[CellGroupData[{
Cell[17046, 569, 283, 9, 28, "Input",
 CellID->646483028],
Cell[17332, 580, 394, 11, 78, "Output",
 Evaluatable->False,
 CellID->262354518]
}, Open  ]],
Cell[17741, 594, 125, 3, 70, "ExampleDelimiter",
 CellID->615603161],
Cell[17869, 599, 63, 1, 70, "ExampleText",
 CellID->501567143],
Cell[CellGroupData[{
Cell[17957, 604, 367, 12, 28, "Input",
 CellID->6373090],
Cell[18327, 618, 442, 11, 78, "Output",
 Evaluatable->False,
 CellID->571749023]
}, Open  ]],
Cell[18784, 632, 126, 3, 70, "ExampleDelimiter",
 CellID->1373950644],
Cell[18913, 637, 81, 1, 70, "ExampleText",
 CellID->8827871],
Cell[CellGroupData[{
Cell[19019, 642, 545, 17, 70, "Input",
 CellID->498451071],
Cell[19567, 661, 357, 12, 68, "Output",
 CellID->1854946178]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19973, 679, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[20197, 688, 122, 3, 70, "ExampleText",
 CellID->946257814],
Cell[CellGroupData[{
Cell[20344, 695, 399, 14, 70, "Input",
 CellID->1855750711],
Cell[20746, 711, 422, 11, 70, "Output",
 Evaluatable->False,
 CellID->205608300]
}, Open  ]],
Cell[21183, 725, 121, 3, 70, "ExampleText",
 CellID->1638673863],
Cell[CellGroupData[{
Cell[21329, 732, 433, 15, 70, "Input",
 CellID->1538714088],
Cell[21765, 749, 418, 11, 70, "Output",
 Evaluatable->False,
 CellID->202727438]
}, Open  ]],
Cell[22198, 763, 126, 3, 70, "ExampleDelimiter",
 CellID->1861326313],
Cell[22327, 768, 120, 3, 70, "ExampleText",
 CellID->482528275],
Cell[CellGroupData[{
Cell[22472, 775, 400, 13, 70, "Input",
 CellID->554886156],
Cell[22875, 790, 487, 12, 70, "Output",
 Evaluatable->False,
 CellID->457141765]
}, Open  ]],
Cell[23377, 805, 124, 3, 70, "ExampleDelimiter",
 CellID->21555281],
Cell[23504, 810, 80, 1, 70, "ExampleText",
 CellID->954466853],
Cell[CellGroupData[{
Cell[23609, 815, 428, 15, 70, "Input",
 CellID->1930194792],
Cell[24040, 832, 414, 11, 70, "Output",
 Evaluatable->False,
 CellID->271115730]
}, Open  ]],
Cell[24469, 846, 135, 4, 70, "ExampleText",
 CellID->1502355071],
Cell[CellGroupData[{
Cell[24629, 854, 667, 22, 70, "Input",
 CellID->448480217],
Cell[25299, 878, 438, 11, 70, "Output",
 Evaluatable->False,
 CellID->215331245]
}, Open  ]],
Cell[25752, 892, 125, 3, 70, "ExampleDelimiter",
 CellID->100860804],
Cell[25880, 897, 68, 1, 70, "ExampleText",
 CellID->2085162572],
Cell[CellGroupData[{
Cell[25973, 902, 615, 20, 70, "Input",
 CellID->666653385],
Cell[26591, 924, 467, 12, 70, "Output",
 Evaluatable->False,
 CellID->540484142]
}, Open  ]],
Cell[27073, 939, 124, 3, 70, "ExampleDelimiter",
 CellID->24144160],
Cell[27200, 944, 58, 1, 70, "ExampleText",
 CellID->541712211],
Cell[CellGroupData[{
Cell[27283, 949, 615, 20, 70, "Input",
 CellID->2099088016],
Cell[27901, 971, 440, 11, 70, "Output",
 Evaluatable->False,
 CellID->9757338]
}, Open  ]],
Cell[28356, 985, 126, 3, 70, "ExampleDelimiter",
 CellID->1128799210],
Cell[28485, 990, 96, 1, 70, "ExampleText",
 CellID->857784872],
Cell[CellGroupData[{
Cell[28606, 995, 401, 13, 70, "Input",
 CellID->732621393],
Cell[29010, 1010, 463, 15, 78, "Output",
 CellID->1326425765]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29522, 1031, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[29763, 1040, 231, 7, 70, "ExampleText",
 CellID->866656473],
Cell[CellGroupData[{
Cell[30019, 1051, 284, 9, 70, "Input",
 CellID->1661247757],
Cell[30306, 1062, 394, 11, 70, "Output",
 Evaluatable->False,
 CellID->128420144]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30749, 1079, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[30983, 1088, 89, 1, 70, "ExampleText",
 CellID->567380668],
Cell[CellGroupData[{
Cell[31097, 1093, 473, 15, 70, "Input",
 CellID->1139494396],
Cell[31573, 1110, 476, 14, 78, "Output",
 CellID->110447583]
}, Open  ]],
Cell[32064, 1127, 126, 3, 70, "ExampleDelimiter",
 CellID->1123448862],
Cell[32193, 1132, 224, 8, 70, "ExampleText",
 CellID->1492514676],
Cell[CellGroupData[{
Cell[32442, 1144, 410, 13, 70, "Input",
 CellID->1590541561],
Cell[32855, 1159, 439, 11, 70, "Output",
 Evaluatable->False,
 CellID->360348159]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33355, 1177, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[33674, 1188, 1174, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[34885, 1237, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[35206, 1248, 147, 3, 70, "Tutorials",
 CellID->22605]
}, Open  ]],
Cell[CellGroupData[{
Cell[35390, 1256, 299, 8, 70, "MoreAboutSection"],
Cell[35692, 1266, 140, 3, 70, "MoreAbout",
 CellID->184805041]
}, Open  ]],
Cell[35847, 1272, 27, 0, 70, "History"],
Cell[35877, 1274, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

