(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31497,       1150]
NotebookOptionsPosition[     25301,        937]
NotebookOutlinePosition[     26604,        974]
CellTagsIndexPosition[     26519,        969]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MatchingDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/MatchingDissimilarity"], 
          "DiceDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/DiceDissimilarity"], 
          "SokalSneathDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/SokalSneathDissimilarity"], 
          "RogersTanimotoDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/RogersTanimotoDissimilarity"], 
          "RussellRaoDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/RussellRaoDissimilarity"], 
          "YuleDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/YuleDissimilarity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MatchingDissimilarity\"\>", 
       2->"\<\"DiceDissimilarity\"\>", 3->"\<\"SokalSneathDissimilarity\"\>", 
       4->"\<\"RogersTanimotoDissimilarity\"\>", 
       5->"\<\"RussellRaoDissimilarity\"\>", 
       6->"\<\"YuleDissimilarity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>", 
       2->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["JaccardDissimilarity", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JaccardDissimilarity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JaccardDissimilarity"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jaccard dissimilarity between Boolean vectors \
",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17673]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 " works for both ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors and ",
 Cell[BoxData["0"], "InlineFormula"],
 ", ",
 Cell[BoxData["1"], "InlineFormula"],
 " vectors."
}], "Notes",
 CellID->38632218],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["JaccardDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JaccardDissimilarity"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["n", "TI"], "10"], "+", 
     SubscriptBox[
      StyleBox["n", "TI"], "01"]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["n", "TI"], "11"], "+", 
     SubscriptBox[
      StyleBox["n", "TI"], "10"], "+", 
     SubscriptBox[
      StyleBox["n", "TI"], "01"]}], ")"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " is the number of corresponding pairs of elements in ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " respectively equal to ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->72507031]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->500880057],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->738136667],

Cell["Jaccard dissimilarity between two Boolean vectors:", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JaccardDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279206382],

Cell[BoxData[
 FractionBox["3", "5"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599235354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->829874330],

Cell[TextData[{
 "The elements can also be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127306229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JaccardDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "False"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41497005],

Cell[BoxData[
 FractionBox["2", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19047846]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26816],

Cell["\<\
Compute dissimilarity between any 0, 1 vectors of equal length:\
\>", "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JaccardDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData[
 FractionBox["2", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68865495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell[TextData[{
 "Compute dissimilarity between any ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors of equal length:"
}], "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JaccardDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}], ",", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData[
 FractionBox["249", "368"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102867972]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->229],

Cell["Cluster 0, 1 data using Jaccard dissimilarity:", "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "JaccardDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->898656089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478877783],

Cell[TextData[{
 "Cluster ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " data using Jaccard dissimilarity:"
}], "ExampleText",
 CellID->68571327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "JaccardDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174963025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"False", ",", "False"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20770066]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24520],

Cell["Jaccard dissimilarity is bounded by 0 and 1:", "ExampleText",
 CellID->482006564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JaccardDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107213585],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393212230]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JaccardDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->582164693],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->236969388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->787503120],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["MatchingDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatchingDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->374591726],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->118519341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JaccardDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"MatchingDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37948204],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->591035792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->402417664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["DiceDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiceDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->504070259],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->593562083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JaccardDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"DiceDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197212249],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53542693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52926977],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 " is less than or equal to ",
 Cell[BoxData[
  ButtonBox["SokalSneathDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SokalSneathDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->50626675],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->2521331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JaccardDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[LessEqual]", 
  RowBox[{"SokalSneathDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154730870],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->78191190]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304312130],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 " is less than or equal to ",
 Cell[BoxData[
  ButtonBox["RussellRaoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RussellRaoDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3865182],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->16527881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JaccardDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[LessEqual]", 
  RowBox[{"RussellRaoDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->458713523],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7280980]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22336],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatchingDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatchingDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiceDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiceDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SokalSneathDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SokalSneathDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RogersTanimotoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RogersTanimotoDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RussellRaoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RussellRaoDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["YuleDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/YuleDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28315],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with JaccardDissimilarity",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
JaccardDissimilarity"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->280913524],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->199972516]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JaccardDissimilarity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 23.3094526}", "context" -> "System`", 
    "keywords" -> {"Jaccard dissimilarity"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JaccardDissimilarity[u, v] gives the Jaccard dissimilarity between \
Boolean vectors u and v.", "synonyms" -> {"jaccard dissimilarity"}, "title" -> 
    "JaccardDissimilarity", "type" -> "Symbol", "uri" -> 
    "ref/JaccardDissimilarity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8027, 249, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->500880057]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26376, 962}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2795, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3418, 91, 1585, 37, 70, "ObjectNameGrid"],
Cell[5006, 130, 732, 24, 70, "Usage",
 CellID->17673]
}, Open  ]],
Cell[CellGroupData[{
Cell[5775, 159, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6253, 176, 556, 21, 70, "Notes",
 CellID->38632218],
Cell[6812, 199, 1178, 45, 70, "Notes",
 CellID->72507031]
}, Closed]],
Cell[CellGroupData[{
Cell[8027, 249, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->500880057],
Cell[CellGroupData[{
Cell[8412, 263, 148, 5, 70, "ExampleSection",
 CellID->738136667],
Cell[8563, 270, 93, 1, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[8681, 275, 300, 9, 28, "Input",
 CellID->279206382],
Cell[8984, 286, 178, 6, 51, "Output",
 CellID->599235354]
}, Open  ]],
Cell[9177, 295, 125, 3, 70, "ExampleDelimiter",
 CellID->829874330],
Cell[9305, 300, 323, 13, 70, "ExampleText",
 CellID->127306229],
Cell[CellGroupData[{
Cell[9653, 317, 276, 8, 70, "Input",
 CellID->41497005],
Cell[9932, 327, 177, 6, 51, "Output",
 CellID->19047846]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10158, 339, 216, 7, 70, "ExampleSection",
 CellID->26816],
Cell[10377, 348, 113, 3, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[10515, 355, 275, 8, 70, "Input",
 CellID->488208944],
Cell[10793, 365, 177, 6, 51, "Output",
 CellID->68865495]
}, Open  ]],
Cell[10985, 374, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[11113, 379, 352, 13, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[11490, 396, 398, 13, 70, "Input",
 CellID->323525768],
Cell[11891, 411, 182, 6, 51, "Output",
 CellID->102867972]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12122, 423, 221, 7, 70, "ExampleSection",
 CellID->229],
Cell[12346, 432, 89, 1, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[12460, 437, 479, 16, 70, "Input",
 CellID->108189764],
Cell[12942, 455, 497, 18, 36, "Output",
 CellID->898656089]
}, Open  ]],
Cell[13454, 476, 125, 3, 70, "ExampleDelimiter",
 CellID->478877783],
Cell[13582, 481, 335, 13, 70, "ExampleText",
 CellID->68571327],
Cell[CellGroupData[{
Cell[13942, 498, 507, 16, 70, "Input",
 CellID->174963025],
Cell[14452, 516, 524, 18, 36, "Output",
 CellID->20770066]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15025, 540, 233, 7, 70, "ExampleSection",
 CellID->24520],
Cell[15261, 549, 87, 1, 70, "ExampleText",
 CellID->482006564],
Cell[CellGroupData[{
Cell[15373, 554, 277, 8, 70, "Input",
 CellID->107213585],
Cell[15653, 564, 158, 5, 36, "Output",
 CellID->393212230]
}, Open  ]],
Cell[CellGroupData[{
Cell[15848, 574, 277, 8, 70, "Input",
 CellID->582164693],
Cell[16128, 584, 158, 5, 36, "Output",
 CellID->236969388]
}, Open  ]],
Cell[16301, 592, 125, 3, 70, "ExampleDelimiter",
 CellID->787503120],
Cell[16429, 597, 381, 12, 70, "ExampleText",
 CellID->374591726],
Cell[16813, 611, 299, 10, 70, "Input",
 CellID->118519341],
Cell[CellGroupData[{
Cell[17137, 625, 248, 7, 70, "Input",
 CellID->37948204],
Cell[17388, 634, 161, 5, 36, "Output",
 CellID->591035792]
}, Open  ]],
Cell[17564, 642, 125, 3, 70, "ExampleDelimiter",
 CellID->402417664],
Cell[17692, 647, 373, 12, 70, "ExampleText",
 CellID->504070259],
Cell[18068, 661, 299, 10, 70, "Input",
 CellID->593562083],
Cell[CellGroupData[{
Cell[18392, 675, 245, 7, 70, "Input",
 CellID->197212249],
Cell[18640, 684, 160, 5, 36, "Output",
 CellID->53542693]
}, Open  ]],
Cell[18815, 692, 124, 3, 70, "ExampleDelimiter",
 CellID->52926977],
Cell[18942, 697, 383, 12, 70, "ExampleText",
 CellID->50626675],
Cell[19328, 711, 297, 10, 70, "Input",
 CellID->2521331],
Cell[CellGroupData[{
Cell[19650, 725, 249, 7, 70, "Input",
 CellID->154730870],
Cell[19902, 734, 160, 5, 36, "Output",
 CellID->78191190]
}, Open  ]],
Cell[20077, 742, 125, 3, 70, "ExampleDelimiter",
 CellID->304312130],
Cell[20205, 747, 380, 12, 70, "ExampleText",
 CellID->3865182],
Cell[20588, 761, 298, 10, 70, "Input",
 CellID->16527881],
Cell[CellGroupData[{
Cell[20911, 775, 248, 7, 70, "Input",
 CellID->458713523],
Cell[21162, 784, 159, 5, 36, "Output",
 CellID->7280980]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21382, 796, 311, 9, 70, "SeeAlsoSection",
 CellID->22336],
Cell[21696, 807, 1593, 53, 70, "SeeAlso",
 CellID->13985]
}, Open  ]],
Cell[CellGroupData[{
Cell[23326, 865, 314, 9, 70, "TutorialsSection",
 CellID->28315],
Cell[23643, 876, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[23850, 884, 305, 8, 70, "RelatedLinksSection"],
Cell[24158, 894, 382, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24577, 911, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[24896, 922, 179, 3, 70, "MoreAbout",
 CellID->280913524],
Cell[25078, 927, 151, 3, 70, "MoreAbout",
 CellID->199972516]
}, Open  ]],
Cell[25244, 933, 27, 0, 70, "History"],
Cell[25274, 935, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

