(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    125380,       3261]
NotebookOptionsPosition[    113903,       2860]
NotebookOutlinePosition[    115246,       2897]
CellTagsIndexPosition[    115159,       2892]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticE" :> Documentation`HelpLookup["paclet:ref/EllipticE"],
           "EllipticF" :> 
          Documentation`HelpLookup["paclet:ref/EllipticF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EllipticE\"\>", 
       2->"\<\"EllipticF\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Elliptic Integrals\"\>", 
       3->"\<\"Inverse Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiAmplitude", "ObjectName",
 CellID->16415],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiAmplitude",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiAmplitude"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the amplitude ",
     Cell[BoxData[
      FormBox[
       RowBox[{"am", "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     " for Jacobi elliptic functions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32191]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["JacobiAmplitude",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiAmplitude"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " converts from the argument ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " for an elliptic function to the amplitude ",
 Cell[BoxData[
  StyleBox["\[Phi]", "TR"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8965],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 " is the inverse of the elliptic integral of the first kind. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{"F", "(", 
     RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->29009],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->111625434],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->110996360],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->204925285],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->98904992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{"4.", ",", 
   RowBox[{"2", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->646827008],

Cell[BoxData["3.083696018729879`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253184497]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192742615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"x", ",", 
     RowBox[{"2", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37548294],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WElsVVUYPvS+xyu0hZapIFMLHXgQhgKKioi2QhlErIwJYVEbknaBGKgb
2ehGN7rRjWxw4ZA4LCASjAkmRhIDiZGEQELUxGBCYCEhkbhoQnL5/v8/5957
zv3f48Zo096+e873D+efz9s1PD565Ojw+NjIcMfg8eHXR8dGTnRsPXYcS9Ek
Y8w5/J2Ya/A5xif+OxfH+J99HsKzAVsH+G0yPaObN+/F/GO24xEZt04cZH1/
gm54/72LJpqYeGB3dgTISKWs8OrZM9fHRs/cvv236cd7CaCyQk2vQtXIS7/9
+tfIq19f+eWW2WZ117Wbwqv3708ce+2bj0//zOgsqqRSNfEq8Cff/A60ZrDQ
eZp59eKPf0Cz69fumIG6dmvhVZwbmn326RWzU0VNYyVh2VMfXX5j/DyU2a7i
Wnn18qU/Dx/6ImsV8Wgb7969+w9kgVHuPMJjJq9CF/gD3jdbVNQs1gjnwynB
C6oNeLJmO43BSAzRr/JpZxzkQJrweU7FzXNaHdj3Oc5nNquox5gbTggj4Rds
N3laLeB9sQ+kwY5ra0Sb8FvEeJH61ZdXoV1fBmdq0i1mOrD/8IOfIOrb8zeq
Vk4YaSUvqjt5CdHw7js/QCTo1hSKuaU5ulWF6LpzdFVeSXG1TthLz7JQDu3+
RIzDq7WzkHmX4R1YRQxKWbVSxa7wsXAWPstqDsscyuAFR0EXaER1pOp5nu1Y
wgHB7O23LqBw9Kq81jLu+wu/I2gRQUiibhW33kUScgmhi3Rf6sl7Irb5gdoB
VtjvVPk8yTiok+AWq7inc7iFKu4ZHwf953t6Pev2oTd+8aHNRqDuZ87GEtiA
Gco7nNCqRHCeTrIdVR3hT3WNqvyj438gtnkDf4MQ5mspJI1rlK0i0BIMmgrR
DWa0pKoytRAVdw9bZRBskFaJ68W99EHEnpUyTUU1Bqvd1mLtGWlSIZsDZJdF
LgvWI5VvT+adKlhSWW29b7JnCXE6d/ePfogqfO+0uoX1R6RK/4b9c5bviXVr
sEc8O5Ok5Rp36j4IBmneoRXC7O8KOHI2GOfXkP98fkcSSpAmuNBG3Xbd58ay
vRrLfcZ2ZrJGGEddOYpej7PmY9rtyNgBv/gQRrTTsKp6d19s8wN6Uf3Vuwg/
I5kFyBoNcbbi8LOcnM3a9yD/P5jRD1U5WSc5ZzmGQkuEJ638z/vJu50z/zN+
/1K/hjiM/1iJZo5DihcZedFpw3wKKYQv3QDM5GQVvVeyZ0+6W0l28YMMsFXj
lRQRco2kLgNrhlSURBXEQBhN5y8nqLSmYt3G4EsqD0HBQ7bG7lJRbE3qL0kt
3enJkiqU1sIdKhdBSe2CaflmlEdxB6LYhhWF3aCKkw4n2UOdcqun0XTHBeqC
C4S+wPvkEa1rc3dO53IclTux2Rvgwjoww50c9sP0Y56vSUWvfEegnoSkhVYQ
t7mQlNlOOxCBFGPapkJ00gOhF7SDOXGqjYXo5tKjDOvBTRj8EEQ0cT6VWFDr
2XyHoGkS6JRmg+q7BSr2cRW7KIelaF7nebvTx+CoNMn2qfyW+GfDIEIRu1rF
ypwvEwiSDA5Y6cmVeiHZLKm6QuVTdf4Dk8x9IYeT6T28HfSoWJnes7cCwnLH
46ribmek5xoVuyTxZ72bWZ9K21EojtaptOxR2yP9akavHAWlhAa2WlgTn33f
4Ohgu3SCF1vUv5lxXNvZHg4Ci3l1I32j8zrUQ+bjSO2qh+ROITVIWvwcFSd3
C6n2MhfPUnFyw0/n4ZleLPa788t0DbFtKpcBx8VOHa0qiqul7UDUW6Z7smT+
xzp2KRtbVB6Cggyrb7OKku+Ukt4i9T+HkrsArG272ZTEt5H1EOn1IqPk1kVn
aywUOUIFrjgN9aVKISrupxGCFAWZorqcixkC72YUKrD9lk7m8EflDXdy2ymp
OkWFNBpy55CvEu1sEtpIpsv8t5hm0kNhpeI3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71605667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10294418],

Cell["Series expansion about the origin:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->780295006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->831948513],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "-", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["z", "3"]}], "6"], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "m"}], "+", 
      SuperscriptBox["m", "2"]}], ")"}], " ", 
    SuperscriptBox["z", "5"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", "m"}], "-", 
       RowBox[{"44", " ", 
        SuperscriptBox["m", "2"]}], "-", 
       SuperscriptBox["m", "3"]}], ")"}], " ", 
     SuperscriptBox["z", "7"]}], "5040"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "9"],
    SeriesData[$CellContext`z, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[-1, 6] $CellContext`m, 0, 
    Rational[1, 120] (4 $CellContext`m + $CellContext`m^2), 0, 
    Rational[1, 5040] ((-16) $CellContext`m - 
     44 $CellContext`m^2 - $CellContext`m^3)}, 1, 9, 1],
  Editable->False]], "Output",
 ImageSize->{354, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149801024]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276262323],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "z"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 
   0, {$CellContext`z, 
    Rational[1, 8] ((-2) $CellContext`z + Sin[2 $CellContext`z])}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{198, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134493476]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26807],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->134807597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{
   RowBox[{"0.2", "+", 
    RowBox[{"0.1", " ", "I"}]}], ",", 
   RowBox[{"0.2", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188175606],

Cell[BoxData[
 RowBox[{"0.20036404855980558`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.09993068002807123`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->827776469]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->447917265],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->19443131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{
     RowBox[{"Pi", "/", "3"}], ",", 
     RowBox[{"1", "/", "5"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24979797],

Cell[BoxData["1.\
0165586491576824670186942551100936068189550267837342050072508494351`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30749915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36736915],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->115042209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{
   RowBox[{"Pi", "/", "3"}], ",", "0.200000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400693321],

Cell[BoxData["1.01655864915768246701869425511009360681`25.502036916220476"], \
"Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608527393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->309065136],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->116836921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9388441],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"\[Alpha]", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"\[Beta]", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{318, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51599813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44998441],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->138172044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"\[Phi]", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"\[Phi]", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190715332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Phi]", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[Pi]", "2"]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTan", "[", 
      SuperscriptBox["\[ExponentialE]", "\[Phi]"], "]"}]}]}]}], 
  "}"}]], "Output",
 ImageSize->{148, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329563920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16987112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["\[Pi]", "2"]}], "}"}]], "Output",
 ImageSize->{49, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->922252870]
}, Open  ]],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->318385893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->458817678],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"JacobiAmplitude", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->202326272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174641485],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->36012899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiAmplitude", "[", 
   RowBox[{"\[Phi]", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->276724680],

Cell[BoxData[
 FormBox[
  RowBox[{"am", "(", 
   RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->111072487]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10469],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->232408970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{"\[Phi]", ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "m"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "m", "]"}], "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35496030],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[Phi]", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Phi]", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "\[Phi]"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"3", " ", "\[Phi]"}], "64"], "-", 
      RowBox[{
       FractionBox["1", "16"], " ", "\[Phi]", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "\[Phi]"}], "]"}]}], "+", 
      RowBox[{
       FractionBox["1", "256"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"4", " ", "\[Phi]"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "3"],
    SeriesData[$CellContext`m, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 
   0, {$CellContext`\[Phi], Rational[-1, 4] $CellContext`\[Phi] + 
    Rational[1, 8] Sin[2 $CellContext`\[Phi]], 
    Rational[3, 64] $CellContext`\[Phi] + 
    Rational[-1, 16] $CellContext`\[Phi] Cos[2 $CellContext`\[Phi]] + 
    Rational[1, 256] Sin[4 $CellContext`\[Phi]]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{444, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->555770488]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Phi]", " ", 
     RowBox[{"Cos", "[", "\[Phi]", "]"}]}], "+", 
    RowBox[{
     RowBox[{"O", "[", "\[Phi]", "]"}], "^", "10"}]}], ",", "m"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134866489],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[Phi]", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox["m", "6"]}], ")"}], " ", 
    SuperscriptBox["\[Phi]", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"(", 
     RowBox[{"85", "-", 
      RowBox[{"26", " ", "m"}], "+", 
      SuperscriptBox["m", "2"]}], ")"}], " ", 
    SuperscriptBox["\[Phi]", "5"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"6727", "-", 
       RowBox[{"2739", " ", "m"}], "+", 
       RowBox[{"229", " ", 
        SuperscriptBox["m", "2"]}], "-", 
       SuperscriptBox["m", "3"]}], ")"}], " ", 
     SuperscriptBox["\[Phi]", "7"]}], "5040"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Phi]", "]"}], "9"],
    SeriesData[$CellContext`\[Phi], 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Phi], 0, {
   1, 0, Rational[1, 2] + Rational[-1, 6] $CellContext`m, 0, 
    Rational[1, 120] (85 - 26 $CellContext`m + $CellContext`m^2), 0, 
    Rational[1, 5040] (6727 - 2739 $CellContext`m + 
     229 $CellContext`m^2 - $CellContext`m^3)}, 1, 9, 1],
  Editable->False]], "Output",
 ImageSize->{480, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->360001463]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10308],

Cell["Solution of the pendulum equation in the overswing mode:", "ExampleText",
 CellID->613194956],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", "t_", "]"}], "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", "=", 
       RowBox[{"1", "+", 
        SuperscriptBox["10", 
         RowBox[{"-", "4"}]]}]}], "}"}], ",", 
     RowBox[{"2", 
      RowBox[{"JacobiAmplitude", "[", 
       RowBox[{
        RowBox[{"k", " ", "t"}], ",", 
        SuperscriptBox["k", 
         RowBox[{"-", "2"}]]}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->525913154],

Cell["Check:", "ExampleText",
 CellID->442448530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Phi]", "''"}], "[", "t", "]"}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"\[Phi]", "[", "t", "]"}], "]"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->181036549],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127298943]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->11360534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"\[Phi]", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "36"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->60809817],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->520695532]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->539687187],

Cell["Motion of a charged particle in a linear magnetic field:", "ExampleText",
 CellID->67673248],

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Omega]", "=", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"v0", " ", 
        RowBox[{"\[Gamma]", "/", "2"}]}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "t_", "]"}], " ", "=", " ", 
      RowBox[{"2", " ", 
       RowBox[{"\[Omega]", "/", "\[Gamma]"}], " ", 
       RowBox[{"JacobiSN", "[", 
        RowBox[{
         RowBox[{"\[Omega]", " ", "t"}], ",", 
         RowBox[{"-", "1"}]}], "]"}]}]}], ";", 
     RowBox[{
      RowBox[{"y", "[", "t_", "]"}], " ", "=", " ", 
      RowBox[{"2", " ", 
       RowBox[{"\[Omega]", "/", "\[Gamma]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"t", " ", "\[Omega]"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"EllipticE", "[", 
             RowBox[{
              RowBox[{"JacobiAmplitude", "[", 
               RowBox[{
                RowBox[{"\[Omega]", " ", "t"}], ",", 
                RowBox[{"-", "1"}]}], "]"}], ",", 
              RowBox[{"-", "1"}]}], "]"}], 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"JacobiSN", "[", 
                RowBox[{
                 RowBox[{"\[Omega]", " ", "t"}], ",", 
                 RowBox[{"-", "1"}]}], "]"}], "^", "2"}]}], "]"}]}], ")"}], 
          "/", 
          RowBox[{"JacobiDN", "[", 
           RowBox[{
            RowBox[{"\[Omega]", " ", "t"}], ",", 
            RowBox[{"-", "1"}]}], "]"}]}]}], ")"}]}]}]}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240797783],

Cell["\<\
Check the solution in Newton's equations of motion with Lorentz force:\
\>", "ExampleText",
 CellID->93355176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"y", "''"}], "[", "t", "]"}], ",", "0"}], "}"}], "-", 
     RowBox[{"\[Gamma]", " ", 
      RowBox[{"Cross", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "'"}], "[", "t", "]"}], ",", 
          RowBox[{
           RowBox[{"y", "'"}], "[", "t", "]"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          RowBox[{"x", "[", "t", "]"}]}], "}"}]}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", 
  "PowerExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->182161166],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "t", "]"}], "11"],
    SeriesData[$CellContext`t, 0, {}, 11, 11, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "t", "]"}], "11"],
    SeriesData[$CellContext`t, 0, {}, 11, 11, 1],
    Editable->False], ",", "0"}], "}"}]], "Output",
 ImageSize->{125, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->778913484]
}, Open  ]],

Cell["Plot particle trajectories for various initial velocities:", \
"ExampleText",
 CellID->705860128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
       RowBox[{"\[Gamma]", "\[Rule]", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"v0", ",", 
        RowBox[{"1", "/", "4"}], ",", "1", ",", 
        RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54950060],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{117, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->557903829]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332044099],

Cell["\<\
Relativistic solution of the sine\[Hyphen]Gordon equation:\
\>", "ExampleText",
 CellID->93325915],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"t_", ",", "x_"}], "]"}], "=", 
   RowBox[{"Pi", "-", 
    RowBox[{"2", 
     RowBox[{"JacobiAmplitude", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"x", "-", 
         RowBox[{"v", " ", "t"}]}], 
        RowBox[{"k", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["v", "2"]}]]}]], ",", 
       SuperscriptBox["k", "2"]}], "]"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410217908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"t", ",", "x"}], "]"}], ",", "t", ",", "t"}], "]"}], "-", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "]"}]}], "//", "FullSimplify"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->80399458],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->682710944]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->1028364091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"v", "\[Rule]", "0.9"}], ",", 
      RowBox[{"k", "\[Rule]", "1.01"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->477385932],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->114132877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16834063],

Cell["\<\
Parametrization of a rotating elastic rod (fixed at the origin):\
\>", "ExampleText",
 CellID->152098811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "s_", "]"}], "=", 
  RowBox[{"-", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"2", "k", " ", 
      RowBox[{"JacobiSN", "[", 
       RowBox[{
        RowBox[{"F", " ", "+", " ", 
         RowBox[{"\[Beta]", " ", "\[Sigma]"}]}], ",", 
        SuperscriptBox["k", "2"]}], "]"}], " ", 
      RowBox[{"JacobiDN", "[", 
       RowBox[{
        RowBox[{"F", " ", "+", " ", 
         RowBox[{"\[Beta]", " ", "\[Sigma]"}]}], ",", 
        SuperscriptBox["k", "2"]}], "]"}]}], " ", ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]", ",", "0", ",", "s"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22746234],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "k", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"JacobiCN", "[", 
       RowBox[{"F", ",", 
        SuperscriptBox["k", "2"]}], "]"}], "-", 
      RowBox[{"JacobiCN", "[", 
       RowBox[{
        RowBox[{"F", "+", 
         RowBox[{"s", " ", "\[Beta]"}]}], ",", 
        SuperscriptBox["k", "2"]}], "]"}]}], ")"}]}], "\[Beta]"]}]], "Output",\

 ImageSize->{294, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90300592]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "[", "s_", "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", " ", "-", 
     RowBox[{"2", 
      SuperscriptBox[
       RowBox[{"JacobiDN", "[", 
        RowBox[{
         RowBox[{"F", " ", "+", " ", 
          RowBox[{"\[Beta]", " ", "\[Sigma]"}]}], ",", 
         SuperscriptBox["k", "2"]}], "]"}], "2"]}]}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"\[Sigma]", ",", "0", ",", "s"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43798816],

Cell[BoxData[
 RowBox[{"s", "+", 
  RowBox[{
   FractionBox["1", "\[Beta]"], 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"EllipticE", "[", 
        RowBox[{
         RowBox[{"JacobiAmplitude", "[", 
          RowBox[{"F", ",", 
           SuperscriptBox["k", "2"]}], "]"}], ",", 
         SuperscriptBox["k", "2"]}], "]"}], " ", 
       RowBox[{"JacobiDN", "[", 
        RowBox[{"F", ",", 
         SuperscriptBox["k", "2"]}], "]"}]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["k", "2"], " ", 
         SuperscriptBox[
          RowBox[{"JacobiSN", "[", 
           RowBox[{"F", ",", 
            SuperscriptBox["k", "2"]}], "]"}], "2"]}]}]]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"EllipticE", "[", 
        RowBox[{
         RowBox[{"JacobiAmplitude", "[", 
          RowBox[{
           RowBox[{"F", "+", 
            RowBox[{"s", " ", "\[Beta]"}]}], ",", 
           SuperscriptBox["k", "2"]}], "]"}], ",", 
         SuperscriptBox["k", "2"]}], "]"}], " ", 
       RowBox[{"JacobiDN", "[", 
        RowBox[{
         RowBox[{"F", "+", 
          RowBox[{"s", " ", "\[Beta]"}]}], ",", 
         SuperscriptBox["k", "2"]}], "]"}]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["k", "2"], " ", 
         SuperscriptBox[
          RowBox[{"JacobiSN", "[", 
           RowBox[{
            RowBox[{"F", "+", 
             RowBox[{"s", " ", "\[Beta]"}]}], ",", 
            SuperscriptBox["k", "2"]}], "]"}], "2"]}]}]]]}], 
    ")"}]}]}]], "Output",
 ImageSize->{467, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->571981968]
}, Open  ]],

Cell["Plot the shape of the deformed rod:", "ExampleText",
 CellID->73064137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "[", "s", "]"}], ",", 
       RowBox[{"z", "[", "s", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k", "\[Rule]", "0.96"}], ",", 
       RowBox[{"\[Beta]", "\[Rule]", "1"}], ",", 
       RowBox[{"F", "\[Rule]", "1.1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->250281437],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdx3k4FHgcx3Er0TJj27bddlVoydFTaZEeu41vrdaVK7TOjsckRwldVGpS
lnFFjHKUbGnGHU8UKd8cLVpknE3IMGQMGcyRVbK//Xc/z/N+Ps9rg2+Ii5+i
goKCG+m///8uuCkmBhZbIpNaq2QeoQ3J9ZuEasWuyAxm5powtkH9WOVa5yI6
Mtukx/WSdkHV1lthvQWnkOmw0UOxwBlo7T3jb9hXkZkWHZLGPwzDuUNnG3LT
kBl1iK7hFAaG/IHB71j3cIW7Mqfa8ArIf/1mNF54D4tpD33lDOLMk+MLO/Ow
I+jWUFjvFaAxTg+0j+UhK9xqUjf6KmjmOIHVDjZqP+BNnRuJhvo4+mQoLx+r
rolLuwtjwYVFB7ZGKQYYLe+QBSZBp+Hq3RSbCtQ90H4h/RULfpCk6gdJnqFX
DGUpuDoXVPtvO3qyG/B1yqx1VhEHYnbo6NrmNWPZ21ovV4UyGPG2piqYtyF/
mWa+n0UFCLqzvXIoXGRGamgVmVbDpHldaLxfFxowWZzc47WQlaIS6JjQg75m
58zKX9aBysFek+SuPhzd4NMledoImZ6jES8meKhEF1ysymmCJFrkyXlRP/LD
I8WM5JdwRNQUtY7yFn38nRZNhtqAtaRXJF4cwvi7cmo+swMeXS+/M688jBX5
bj917+uEh8feNR1RGsGyucK4TK1ueJWs5VozOYL8AfPnn1/3QIC9gY/7sADn
u+ZWZNf3gYOpjuhF3SgW7/t09at0HriaB4ZMPBhD4/zRNOWMfmgJiaJxWe8w
1cbl+eWsQWD9mfPttqPj6GLpm9gYNQRMFH3u3yPEM3zpmvJWPjTSAs4IV04g
t3T5KUHLMNxYNIhO6JnAaaU1z7mNI/CzpupuO44IqxKSsb1PAPRQjxaB/yRu
ouftb3kzCisMZlsitk9hwBAe+ls2Bv6tZnsOfJpCiuy8pJY6DjNmrWoXH77H
eeXuD/GrhWArVXSpCZ/G+Y+DsfomE/A5I8VStlmMjbacsC93iSDre+/mpQEx
dqTWdVbYTEJBQrDNLw4zKGp9qTYdMAV7tYcsv7g/g476lVvYZ98DVei+kLNs
FnMZ1gs12dPgoxLledN7Fg8+Wa3wrkQMkeeNb2aUz2KMJjWDcWAGqJRQVq36
HL4RhBQwxTOgb/V6W5HfHDptPeveGz4LlYWm/3xqmEPq+gXvcLU5CBhMiOBp
S/CGC69t5605aL4Xuq47XIL2Q3cT1HUk0Emv7s7vlWA67UPZeIUECg1q49uM
pHh7ujqmaKcU1rZUKQzHSpHilmnlXCeF3rz0bDehFDO30BNznWVwjKWtamcp
w9Nxi1sre2RwmKttq86RobGtWoeunxxovdftNIhTdHrGtxNH9qjY6xFzL2Uv
WRF7NCg6WRDzH683CiS2P2i6/wRxgvF8UgnxSE6MbzvxI4vle82OyqG+avzy
tXwZCvcz6q395WBoMH8li/iaCY/nQTyWRv2DTcxJMZoNJGYfto6rJTZt5mol
Ess75NenidU2T0V2EGdq/JbnWCDDEzURZp4Bcuj7/T7bi/jH2CyHIOLAFNWC
o8QbuVVHLhC3fBSUXCK24ItSbxNrVnY+LiVmTOiKh4nLBr2ePCFW5WxSlhCv
UhI+/Yu4bGTzeqVAOTDtvq5/+5+79PbqET8LKmkUEVPiNH13EC8xHZvkxLSn
q87ZENPvS1sUC2W4MnhZiiexHO+0qhOXZc+wg4j/BQd35LY=
     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-1.3540180199743168`, 0.}, {0., 1.400736477002038}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5613121]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->518008283],

Cell["Form and plot generalized Fourier series:", "ExampleText",
 CellID->79423522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"m", ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], "^", "k"}]}], " ", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"k", " ", 
               RowBox[{"JacobiAmplitude", "[", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{
                   RowBox[{"EllipticK", "[", "m", "]"}], "/", "Pi"}], " ", 
                  "v"}], ",", "m"}], "]"}]}], "]"}], "/", "k"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "o"}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"o", ",", " ", "8"}], "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", " ", 
        RowBox[{
         RowBox[{"-", "2"}], "Pi"}], ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
      RowBox[{"MaxRecursion", " ", "\[Rule]", " ", "1"}]}], "]"}]}], "]"}], "/@",
   
  RowBox[{"{", 
   RowBox[{"0", ",", "0.6", ",", "0.99"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26803752],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{577, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43162716]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17415],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->145323232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"JacobiAmplitude", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{
     RowBox[{"EllipticF", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262680497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"JacobiAmplitude", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{
     RowBox[{"EllipticF", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{508, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175247855]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->344633100],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->207882507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15226415],

Cell[TextData[{
 "Apply trigonometric functions to ",
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26931970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"JacobiAmplitude", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "]"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"JacobiAmplitude", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->625950351],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131100142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->321380403],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->318452076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiAmplitude", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"3", 
      RowBox[{"JacobiAmplitude", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14596436],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->470603355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"EllipticF", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"EllipticF", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{512, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105586894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650712859],

Cell["Obtain from a differential equation:", "ExampleText",
 CellID->331826723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "z"], 
      RowBox[{"w", "[", "z", "]"}]}], "-", 
     RowBox[{"JacobiDN", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}], "\[Equal]", "0", "\[Equal]", "0"}], 
   ",", "w", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22739610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "+", 
       RowBox[{"JacobiAmplitude", "[", 
        RowBox[{"z", ",", "m"}], "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{342, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81532719]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6935],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is not sufficient to obtain the correct result:"
}], "ExampleText",
 CellID->227118962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{
   RowBox[{"10.", "^", "16"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->500769592],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->789202777]
}, Open  ]],

Cell["Use arbitrary-precision arithmetic instead:", "ExampleText",
 CellID->418960890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{
     RowBox[{"10", "^", "16"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300491492],

Cell[BoxData[
 RowBox[{"0.53929260409523424383312436406136972889`20.15051499783199", "+", 
  RowBox[{"0``20.418690533454555", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41838400]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26201],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticF"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4966]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->560],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->11645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->24139],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Amplitude.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/JacobiAmplitude/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->674857360],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->64942993],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->90657210],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->581906454]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiAmplitude - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 23.8563416}", "context" -> "System`", 
    "keywords" -> {
     "amplitude", "jacobi am", "jacobiam", "Jacobi amplitude", "pendulum"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "JacobiAmplitude[u, m] gives the amplitude am(u \\[VerticalSeparator] m) \
for Jacobi elliptic functions. ", "synonyms" -> {"jacobi amplitude"}, "title" -> 
    "JacobiAmplitude", "type" -> "Symbol", "uri" -> "ref/JacobiAmplitude"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6081, 208, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->110996360]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 115016, 2885}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2188, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2811, 81, 53, 1, 70, "ObjectName",
 CellID->16415],
Cell[2867, 84, 732, 23, 70, "Usage",
 CellID->32191]
}, Open  ]],
Cell[CellGroupData[{
Cell[3636, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4114, 129, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4237, 135, 479, 17, 70, "Notes",
 CellID->8965],
Cell[4719, 154, 607, 21, 70, "Notes",
 CellID->29009],
Cell[5329, 177, 262, 8, 70, "Notes",
 CellID->111625434],
Cell[5594, 187, 232, 7, 70, "Notes",
 CellID->31226],
Cell[5829, 196, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6081, 208, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->110996360],
Cell[CellGroupData[{
Cell[6466, 222, 148, 5, 70, "ExampleSection",
 CellID->204925285],
Cell[6617, 229, 200, 5, 70, "ExampleText",
 CellID->98904992],
Cell[CellGroupData[{
Cell[6842, 238, 159, 5, 28, "Input",
 CellID->646827008],
Cell[7004, 245, 175, 5, 36, "Output",
 CellID->253184497]
}, Open  ]],
Cell[7194, 253, 125, 3, 70, "ExampleDelimiter",
 CellID->192742615],
Cell[CellGroupData[{
Cell[7344, 260, 296, 10, 28, "Input",
 CellID->37548294],
Cell[7643, 272, 2200, 40, 136, "Output",
 Evaluatable->False,
 CellID->71605667]
}, Open  ]],
Cell[9858, 315, 124, 3, 70, "ExampleDelimiter",
 CellID->10294418],
Cell[9985, 320, 214, 5, 70, "ExampleText",
 CellID->780295006],
Cell[CellGroupData[{
Cell[10224, 329, 252, 8, 70, "Input",
 CellID->831948513],
Cell[10479, 339, 1194, 38, 56, "Output",
 CellID->149801024]
}, Open  ]],
Cell[CellGroupData[{
Cell[11710, 382, 252, 8, 70, "Input",
 CellID->276262323],
Cell[11965, 392, 732, 24, 51, "Output",
 CellID->134493476]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12746, 422, 216, 7, 70, "ExampleSection",
 CellID->26807],
Cell[12965, 431, 74, 1, 70, "ExampleText",
 CellID->134807597],
Cell[CellGroupData[{
Cell[13064, 436, 213, 7, 70, "Input",
 CellID->188175606],
Cell[13280, 445, 275, 7, 36, "Output",
 CellID->827776469]
}, Open  ]],
Cell[13570, 455, 125, 3, 70, "ExampleDelimiter",
 CellID->447917265],
Cell[13698, 460, 69, 1, 70, "ExampleText",
 CellID->19443131],
Cell[CellGroupData[{
Cell[13792, 465, 241, 8, 70, "Input",
 CellID->24979797],
Cell[14036, 475, 234, 7, 36, "Output",
 CellID->30749915]
}, Open  ]],
Cell[14285, 485, 124, 3, 70, "ExampleDelimiter",
 CellID->36736915],
Cell[14412, 490, 113, 3, 70, "ExampleText",
 CellID->115042209],
Cell[CellGroupData[{
Cell[14550, 497, 190, 6, 70, "Input",
 CellID->400693321],
Cell[14743, 505, 219, 6, 36, "Output",
 CellID->608527393]
}, Open  ]],
Cell[14977, 514, 125, 3, 70, "ExampleDelimiter",
 CellID->309065136],
Cell[15105, 519, 232, 7, 70, "ExampleText",
 CellID->116836921],
Cell[CellGroupData[{
Cell[15362, 530, 194, 6, 70, "Input",
 CellID->9388441],
Cell[15559, 538, 352, 11, 36, "Output",
 CellID->51599813]
}, Open  ]],
Cell[15926, 552, 124, 3, 70, "ExampleDelimiter",
 CellID->44998441],
Cell[16053, 557, 91, 1, 70, "ExampleText",
 CellID->138172044],
Cell[CellGroupData[{
Cell[16169, 562, 261, 8, 70, "Input",
 CellID->190715332],
Cell[16433, 572, 392, 14, 49, "Output",
 CellID->329563920]
}, Open  ]],
Cell[CellGroupData[{
Cell[16862, 591, 292, 10, 70, "Input",
 CellID->16987112],
Cell[17157, 603, 229, 8, 49, "Output",
 CellID->922252870]
}, Open  ]],
Cell[17401, 614, 90, 1, 70, "ExampleText",
 CellID->318385893],
Cell[CellGroupData[{
Cell[17516, 619, 153, 5, 70, "Input",
 CellID->458817678],
Cell[17672, 626, 242, 8, 36, "Output",
 CellID->202326272]
}, Open  ]],
Cell[17929, 637, 125, 3, 70, "ExampleDelimiter",
 CellID->174641485],
Cell[18057, 642, 202, 7, 70, "ExampleText",
 CellID->36012899],
Cell[CellGroupData[{
Cell[18284, 653, 178, 5, 70, "Input",
 CellID->276724680],
Cell[18465, 660, 283, 9, 50, "Output",
 CellID->111072487]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18797, 675, 239, 7, 70, "ExampleSection",
 CellID->10469],
Cell[19039, 684, 225, 7, 70, "ExampleText",
 CellID->232408970],
Cell[CellGroupData[{
Cell[19289, 695, 276, 9, 70, "Input",
 CellID->35496030],
Cell[19568, 706, 1397, 42, 51, "Output",
 CellID->555770488]
}, Open  ]],
Cell[CellGroupData[{
Cell[21002, 753, 291, 10, 70, "Input",
 CellID->134866489],
Cell[21296, 765, 1340, 40, 56, "Output",
 CellID->360001463]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22685, 811, 223, 7, 70, "ExampleSection",
 CellID->10308],
Cell[22911, 820, 99, 1, 70, "ExampleText",
 CellID->613194956],
Cell[23013, 823, 518, 18, 70, "Input",
 CellID->525913154],
Cell[23534, 843, 49, 1, 70, "ExampleText",
 CellID->442448530],
Cell[CellGroupData[{
Cell[23608, 848, 251, 9, 70, "Input",
 CellID->181036549],
Cell[23862, 859, 158, 5, 36, "Output",
 CellID->127298943]
}, Open  ]],
Cell[24035, 867, 60, 1, 70, "ExampleText",
 CellID->11360534],
Cell[CellGroupData[{
Cell[24120, 872, 216, 7, 70, "Input",
 CellID->60809817],
Cell[24339, 881, 2364, 43, 70, "Output",
 Evaluatable->False,
 CellID->520695532]
}, Open  ]],
Cell[26718, 927, 125, 3, 70, "ExampleDelimiter",
 CellID->539687187],
Cell[26846, 932, 98, 1, 70, "ExampleText",
 CellID->67673248],
Cell[26947, 935, 1668, 50, 70, "Input",
 CellID->240797783],
Cell[28618, 987, 120, 3, 70, "ExampleText",
 CellID->93355176],
Cell[CellGroupData[{
Cell[28763, 994, 826, 27, 70, "Input",
 CellID->182161166],
Cell[29592, 1023, 518, 17, 39, "Output",
 CellID->778913484]
}, Open  ]],
Cell[30125, 1043, 103, 2, 70, "ExampleText",
 CellID->705860128],
Cell[CellGroupData[{
Cell[30253, 1049, 618, 19, 70, "Input",
 CellID->54950060],
Cell[30874, 1070, 7256, 123, 70, "Output",
 Evaluatable->False,
 CellID->557903829]
}, Open  ]],
Cell[38145, 1196, 125, 3, 70, "ExampleDelimiter",
 CellID->332044099],
Cell[38273, 1201, 108, 3, 70, "ExampleText",
 CellID->93325915],
Cell[38384, 1206, 504, 18, 70, "Input",
 CellID->410217908],
Cell[CellGroupData[{
Cell[38913, 1228, 469, 16, 70, "Input",
 CellID->80399458],
Cell[39385, 1246, 158, 5, 36, "Output",
 CellID->682710944]
}, Open  ]],
Cell[39558, 1254, 62, 1, 70, "ExampleText",
 CellID->1028364091],
Cell[CellGroupData[{
Cell[39645, 1259, 477, 16, 70, "Input",
 CellID->477385932],
Cell[40125, 1277, 16585, 276, 70, "Output",
 Evaluatable->False,
 CellID->114132877]
}, Open  ]],
Cell[56725, 1556, 124, 3, 70, "ExampleDelimiter",
 CellID->16834063],
Cell[56852, 1561, 115, 3, 70, "ExampleText",
 CellID->152098811],
Cell[CellGroupData[{
Cell[56992, 1568, 674, 20, 70, "Input",
 CellID->22746234],
Cell[57669, 1590, 548, 19, 58, "Output",
 CellID->90300592]
}, Open  ]],
Cell[CellGroupData[{
Cell[58254, 1614, 516, 16, 70, "Input",
 CellID->43798816],
Cell[58773, 1632, 1731, 55, 121, "Output",
 CellID->571981968]
}, Open  ]],
Cell[60519, 1690, 77, 1, 70, "ExampleText",
 CellID->73064137],
Cell[CellGroupData[{
Cell[60621, 1695, 549, 17, 70, "Input",
 CellID->250281437],
Cell[61173, 1714, 2190, 44, 218, "Output",
 CellID->5613121]
}, Open  ]],
Cell[63378, 1761, 125, 3, 70, "ExampleDelimiter",
 CellID->518008283],
Cell[63506, 1766, 83, 1, 70, "ExampleText",
 CellID->79423522],
Cell[CellGroupData[{
Cell[63614, 1771, 1314, 39, 70, "Input",
 CellID->26803752],
Cell[64931, 1812, 38450, 634, 70, "Output",
 Evaluatable->False,
 CellID->43162716]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[103430, 2452, 233, 7, 70, "ExampleSection",
 CellID->17415],
Cell[103666, 2461, 74, 1, 70, "ExampleText",
 CellID->145323232],
Cell[CellGroupData[{
Cell[103765, 2466, 383, 12, 70, "Input",
 CellID->262680497],
Cell[104151, 2480, 472, 15, 36, "Output",
 CellID->175247855]
}, Open  ]],
Cell[104638, 2498, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[104909, 2510, 107, 3, 70, "Input",
 CellID->344633100],
Cell[105019, 2515, 203, 7, 36, "Output",
 CellID->207882507]
}, Open  ]],
Cell[105237, 2525, 124, 3, 70, "ExampleDelimiter",
 CellID->15226415],
Cell[105364, 2530, 229, 8, 70, "ExampleText",
 CellID->26931970],
Cell[CellGroupData[{
Cell[105618, 2542, 317, 10, 70, "Input",
 CellID->625950351],
Cell[105938, 2554, 326, 11, 36, "Output",
 CellID->131100142]
}, Open  ]],
Cell[106279, 2568, 125, 3, 70, "ExampleDelimiter",
 CellID->321380403],
Cell[106407, 2573, 75, 1, 70, "ExampleText",
 CellID->318452076],
Cell[CellGroupData[{
Cell[106507, 2578, 372, 13, 70, "Input",
 CellID->14596436],
Cell[106882, 2593, 453, 8, 70, "Message",
 CellID->470603355],
Cell[107338, 2603, 905, 33, 51, "Output",
 CellID->105586894]
}, Open  ]],
Cell[108258, 2639, 125, 3, 70, "ExampleDelimiter",
 CellID->650712859],
Cell[108386, 2644, 79, 1, 70, "ExampleText",
 CellID->331826723],
Cell[CellGroupData[{
Cell[108490, 2649, 365, 12, 70, "Input",
 CellID->22739610],
Cell[108858, 2663, 459, 15, 36, "Output",
 CellID->81532719]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[109366, 2684, 225, 7, 70, "ExampleSection",
 CellID->6935],
Cell[109594, 2693, 241, 7, 70, "ExampleText",
 CellID->227118962],
Cell[CellGroupData[{
Cell[109860, 2704, 162, 5, 70, "Input",
 CellID->500769592],
Cell[110025, 2711, 240, 7, 36, "Output",
 CellID->789202777]
}, Open  ]],
Cell[110280, 2721, 86, 1, 70, "ExampleText",
 CellID->418960890],
Cell[CellGroupData[{
Cell[110391, 2726, 221, 8, 70, "Input",
 CellID->300491492],
Cell[110615, 2736, 292, 7, 36, "Output",
 CellID->41838400]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[110968, 2750, 311, 9, 70, "SeeAlsoSection",
 CellID->26201],
Cell[111282, 2761, 454, 17, 70, "SeeAlso",
 CellID->4966]
}, Open  ]],
Cell[CellGroupData[{
Cell[111773, 2783, 312, 9, 70, "TutorialsSection",
 CellID->560],
Cell[112088, 2794, 192, 4, 70, "Tutorials",
 CellID->11645]
}, Open  ]],
Cell[CellGroupData[{
Cell[112317, 2803, 321, 9, 70, "RelatedLinksSection",
 CellID->24139],
Cell[112641, 2814, 180, 4, 70, "RelatedLinks"],
Cell[112824, 2820, 205, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113066, 2829, 319, 9, 70, "MoreAboutSection",
 CellID->674857360],
Cell[113388, 2840, 146, 3, 70, "MoreAbout",
 CellID->64942993],
Cell[113537, 2845, 146, 3, 70, "MoreAbout",
 CellID->90657210],
Cell[113686, 2850, 145, 3, 70, "MoreAbout",
 CellID->581906454]
}, Open  ]],
Cell[113846, 2856, 27, 0, 70, "History"],
Cell[113876, 2858, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

