(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61223,       2052]
NotebookOptionsPosition[     51852,       1720]
NotebookOutlinePosition[     53121,       1757]
CellTagsIndexPosition[     53035,       1752]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiCD" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiCD"], "JacobiCN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiCN"], "JacobiCS" :> 
          Documentation`HelpLookup["paclet:ref/JacobiCS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiCD\"\>", 
       2->"\<\"JacobiCN\"\>", 3->"\<\"JacobiCS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiCD", "ObjectName",
 CellID->27424],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiCD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiCD"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"cd", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18054]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cd", "(", "u", ")"}], "=", 
    FractionBox[
     RowBox[{"cos", "(", "\[Phi]", ")"}], 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        RowBox[{
         SuperscriptBox["sin", "2"], "(", "\[Phi]", ")"}]}]}]]]}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->24657],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"cd", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->39734437],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCD"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->98137581],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCD"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->413271315],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCD"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCD"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->107950490],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->2006385],

Cell["Evaluate numerically:", "ExampleText",
 CellID->111594280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{"3.14", ",", "0.3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249392632],

Cell[BoxData[
 RowBox[{"-", "0.9709181691615859`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40933930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23818265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9979915],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76399280]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148195268],

Cell["Series expansions:", "ExampleText",
 CellID->54535256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46915731],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
    SuperscriptBox["z", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"6", " ", "m"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"47", " ", "m"}], "-", 
      RowBox[{"107", " ", 
       SuperscriptBox["m", "2"]}], "+", 
      RowBox[{"61", " ", 
       SuperscriptBox["m", "3"]}]}], ")"}], " ", 
    SuperscriptBox["z", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "7"],
    SeriesData[$CellContext`z, 0, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[1, 2] (-1 + $CellContext`m), 0, 
    Rational[1, 24] (1 - 6 $CellContext`m + 5 $CellContext`m^2), 0, 
    Rational[1, 720] (-1 + 47 $CellContext`m - 107 $CellContext`m^2 + 
     61 $CellContext`m^3)}, 0, 7, 1],
  Editable->False]], "Output",
 ImageSize->{496, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->533175146]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->639497532],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"Cos", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "2"]}], "-", 
      RowBox[{
       RowBox[{"Sin", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Cos[$CellContext`z], 
    Rational[1, 8] (2 $CellContext`z Sin[$CellContext`z] + 
     4 Cos[$CellContext`z] Sin[$CellContext`z]^2 - Sin[$CellContext`z] 
     Sin[2 $CellContext`z])}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{430, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130915730]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1024],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->112890142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"0.2", "-", 
    RowBox[{"0.3", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353771037],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.1130810503471167`"}], "-", 
  RowBox[{"0.7462349276429439`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->620056659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105790448],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->186564984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380979824],

Cell[BoxData[
 RowBox[{"-", 
  "0.8674034560317645506429423067452445832230188443433496301529963508296`49.\
999999999999986"}]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66135636]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22253048],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->68762940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{"3", ",", "0.500000000000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->489102737],

Cell[BoxData[
 RowBox[{"-", 
  "0.867403456031764550642942306745244583223018844344`38.052090433700755"}]], \
"Output",
 ImageSize->{292, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106102631]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114938765],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCD"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->310520456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102445170],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{"1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiCD", "[", 
    RowBox[{"2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192415820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3359231],

Cell["Simple exact answers are generated automatically:", "ExampleText",
 CellID->259031270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiCD", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27419542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277558476]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiCD", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiCD", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37739192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "-", "m"}]]}]]], ",", "0"}], "}"}]], "Output",
 ImageSize->{141, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90698569]
}, Open  ]],

Cell["\<\
Parity transformations and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->341324251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->306710583],

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->62291637]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"4", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"2", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->118650963],

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->141211024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116659917],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->337581887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiCD", "[", 
   RowBox[{"u", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122807641],

Cell[BoxData[
 FormBox[
  RowBox[{"cd", "(", 
   RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->270444971]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12048],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCD"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->271403579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiCD", "[", 
   RowBox[{"u", ",", 
    RowBox[{"m", "+", 
     RowBox[{"m", "^", "2"}], "+", 
     RowBox[{
      RowBox[{"O", "[", "m", "]"}], "^", "3"}]}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104004036],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Cos", "[", "u", "]"}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Sin", "[", "u", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"u", "+", 
      RowBox[{
       RowBox[{"Cos", "[", "u", "]"}], " ", 
       RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}], " ", "m"}], "+", 
   RowBox[{
    FractionBox["1", "256"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"23", "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["u", "2"]}]}], ")"}], " ", 
       RowBox[{"Cos", "[", "u", "]"}]}], "-", 
      RowBox[{"24", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"3", " ", "u"}], "]"}]}], "+", 
      RowBox[{"Cos", "[", 
       RowBox[{"5", " ", "u"}], "]"}], "+", 
      RowBox[{"88", " ", "u", " ", 
       RowBox[{"Sin", "[", "u", "]"}]}], "-", 
      RowBox[{"12", " ", "u", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "u"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "3"],
    SeriesData[$CellContext`m, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Cos[$CellContext`u], Rational[1, 4] 
    Sin[$CellContext`u] ($CellContext`u + 
     Cos[$CellContext`u] Sin[$CellContext`u]), 
    Rational[1, 256] ((23 - 8 $CellContext`u^2) Cos[$CellContext`u] - 24 
     Cos[3 $CellContext`u] + Cos[5 $CellContext`u] + 
     88 $CellContext`u Sin[$CellContext`u] - 12 $CellContext`u 
     Sin[3 $CellContext`u])}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{543, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107436616]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16016],

Cell["Conformal map from a unit triangle to the unit disk:", "ExampleText",
 CellID->742868198],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "z_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "=", 
       RowBox[{"z", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "/", "3"}], "]"}], "3"], 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"1", "/", "3"}]], " ", 
          SuperscriptBox["3", 
           RowBox[{"1", "/", "4"}]], " ", "\[Pi]"}]]}]}], ",", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         FractionBox["\[Pi]", "12"], "]"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"11", "/", "6"}]], " ", 
       SqrtBox[
        RowBox[{"1", "-", "m"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"JacobiCD", "[", 
           RowBox[{"\[Zeta]", ",", "m"}], "]"}], " ", 
          RowBox[{"JacobiDN", "[", 
           RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SqrtBox[
           FractionBox["m", 
            RowBox[{"1", "-", "m"}]]], " ", 
          RowBox[{"JacobiCD", "[", 
           RowBox[{"\[Zeta]", ",", "m"}], "]"}], " ", 
          RowBox[{"JacobiDN", "[", 
           RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"JacobiCD", "[", 
            RowBox[{"\[Zeta]", ",", "m"}], "]"}], " ", 
           RowBox[{"JacobiDN", "[", 
            RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}], "2"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "4"}]], " ", 
        RowBox[{"JacobiDN", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}], " ", 
        RowBox[{"JacobiSN", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36571340],

Cell["Show points before and after the map:", "ExampleText",
 CellID->331249941],

Cell[BoxData[
 RowBox[{
  RowBox[{"trianglePoints", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "=", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", " ", "Pi", " ", 
          RowBox[{"I", "/", "3"}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Alpha]", "/", "8."}], " ", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"N", "[", 
              RowBox[{"#1", "+", 
               RowBox[{
                RowBox[{"j", "/", "16"}], 
                RowBox[{"(", 
                 RowBox[{"#2", "-", "#1"}], ")"}]}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "&"}], "@@@",
          
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", 
               RowBox[{"1", "/", "t"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "/", "t"}], ",", "1"}], "}"}]}], "}"}], "/", 
           SqrtBox["3"]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", "8"}], "}"}]}], "]"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->492487310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      "trianglePoints"}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"w", "[", "trianglePoints", "]"}]}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->508776826],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->622655281]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->715667511],

Cell[TextData[{
 "Solution of the Poisson\[Dash]Boltzmann equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"\[Psi]", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "x"}]}],
      MultilineFunction->None], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"\[Psi]", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "y"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "y"}]}],
      MultilineFunction->None]}], "\[LongEqual]", 
    RowBox[{"sinh", "(", 
     RowBox[{"\[Psi]", "(", 
      RowBox[{"x", ",", "y"}], ")"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->311825910],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{"x_", ",", " ", "y_"}], "]"}], "=", 
   RowBox[{"4", " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox["2", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Alpha]", "2"], "+", 
          SuperscriptBox["\[Beta]", "2"]}]]}]], " ", 
      RowBox[{"JacobiCD", "[", 
       RowBox[{
        RowBox[{"x", " ", "\[Alpha]"}], ",", 
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[Alpha]", "2"]}], ")"}], "2"], "-", 
          SuperscriptBox["\[Beta]", "4"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]]}], "]"}], " ", 
      RowBox[{"JacobiCD", "[", 
       RowBox[{
        RowBox[{"y", " ", "\[Beta]"}], ",", 
        FractionBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[Alpha]", "4"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[Beta]", "2"]}], ")"}], "2"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Beta]", "2"]}]]}], "]"}], 
      RowBox[{"JacobiDN", "[", 
       RowBox[{
        RowBox[{"x", " ", "\[Alpha]"}], ",", 
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[Alpha]", "2"]}], ")"}], "2"], "-", 
          SuperscriptBox["\[Beta]", "4"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]]}], "]"}], " ", 
      RowBox[{"JacobiDN", "[", 
       RowBox[{
        RowBox[{"y", " ", "\[Beta]"}], ",", 
        FractionBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[Alpha]", "4"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[Beta]", "2"]}], ")"}], "2"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Beta]", "2"]}]]}], "]"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210478124],

Cell["Check solution using series expansion:", "ExampleText",
 CellID->356412923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       RowBox[{"x", ",", "x"}]], 
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       RowBox[{"y", ",", "y"}]], 
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], "-", 
     RowBox[{"Sinh", "[", 
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "y"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}], "//", 
  "Normal"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331991668],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153155609]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11658],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->446884639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{
     RowBox[{"InverseJacobiCD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{
     RowBox[{"JacobiCD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150613467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiCD", "[", 
    RowBox[{
     RowBox[{"JacobiCD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33463487]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->63042172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7135577],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->650830190]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113076732],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->81298353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiCD", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"3", 
      RowBox[{"JacobiCD", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330205070],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->139020543],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCD", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCD", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{302, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587669083]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->690585279],

Cell["Integrals:", "ExampleText",
 CellID->243715871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223231688],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"JacobiND", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "+", 
    RowBox[{
     SqrtBox["m"], " ", 
     RowBox[{"JacobiSD", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}]}], "]"}], 
  SqrtBox["m"]]], "Output",
 ImageSize->{273, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117437962]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25675],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->449874585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCD", "[", 
  RowBox[{
   RowBox[{"10.", "^", "16"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268043320],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.7428549922704484`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10727779]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiCD", "[", 
    RowBox[{
     RowBox[{"10", "^", "16"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154941739],

Cell[BoxData[
 RowBox[{"2.0718657061156781563500742408556393547`20.15051499783199", "+", 
  RowBox[{"0``19.834153395881895", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->914896649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->777259805],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->632184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiCD", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "-", 
  FractionBox[
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], 
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19011457],

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiCD", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "-", 
  FractionBox[
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], 
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]]}]], "Output",
 ImageSize->{212, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156368365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72341539],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->203337946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   SuperscriptBox[
    RowBox[{"JacobiSN", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"JacobiCD", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"JacobiSN", "[", 
         RowBox[{"u", ",", "m"}], "]"}], "2"]}]}], ")"}]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->75249245],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox[
   RowBox[{"JacobiSN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"JacobiCD", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"m", " ", 
      SuperscriptBox[
       RowBox[{"JacobiSN", "[", 
        RowBox[{"u", ",", "m"}], "]"}], "2"]}]}], ")"}]}]}]], "Output",
 ImageSize->{393, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->173818238]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2173],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2998]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1768],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->3947]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->236623794],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->273257804]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiCD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 25.7626404}", "context" -> "System`", 
    "keywords" -> {
     "cd", "doubly periodic function", "Jacobi elliptic function cd"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "JacobiCD[u, m] gives the Jacobi elliptic function cd(u | m).", 
    "synonyms" -> {"Jacobi CD"}, "title" -> "JacobiCD", "type" -> "Symbol", 
    "uri" -> "ref/JacobiCD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6330, 226, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->107950490]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52892, 1745}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2018, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2641, 77, 46, 1, 70, "ObjectName",
 CellID->27424],
Cell[2690, 80, 676, 22, 70, "Usage",
 CellID->18054]
}, Open  ]],
Cell[CellGroupData[{
Cell[3403, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3881, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4004, 130, 561, 22, 70, "Notes",
 CellID->24657],
Cell[4568, 154, 831, 30, 70, "Notes",
 CellID->39734437],
Cell[5402, 186, 215, 7, 70, "Notes",
 CellID->98137581],
Cell[5620, 195, 248, 8, 70, "Notes",
 CellID->413271315],
Cell[5871, 205, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6092, 214, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6330, 226, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->107950490],
Cell[CellGroupData[{
Cell[6715, 240, 146, 5, 70, "ExampleSection",
 CellID->2006385],
Cell[6864, 247, 64, 1, 70, "ExampleText",
 CellID->111594280],
Cell[CellGroupData[{
Cell[6953, 252, 132, 4, 28, "Input",
 CellID->249392632],
Cell[7088, 258, 192, 6, 36, "Output",
 CellID->40933930]
}, Open  ]],
Cell[7295, 267, 124, 3, 70, "ExampleDelimiter",
 CellID->23818265],
Cell[CellGroupData[{
Cell[7444, 274, 288, 10, 28, "Input",
 CellID->9979915],
Cell[7735, 286, 3347, 59, 139, "Output",
 Evaluatable->False,
 CellID->76399280]
}, Open  ]],
Cell[11097, 348, 125, 3, 70, "ExampleDelimiter",
 CellID->148195268],
Cell[11225, 353, 60, 1, 70, "ExampleText",
 CellID->54535256],
Cell[CellGroupData[{
Cell[11310, 358, 244, 8, 70, "Input",
 CellID->46915731],
Cell[11557, 368, 1369, 43, 51, "Output",
 CellID->533175146]
}, Open  ]],
Cell[CellGroupData[{
Cell[12963, 416, 245, 8, 70, "Input",
 CellID->639497532],
Cell[13211, 426, 1097, 33, 51, "Output",
 CellID->130915730]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14357, 465, 215, 7, 70, "ExampleSection",
 CellID->1024],
Cell[14575, 474, 74, 1, 70, "ExampleText",
 CellID->112890142],
Cell[CellGroupData[{
Cell[14674, 479, 206, 7, 70, "Input",
 CellID->353771037],
Cell[14883, 488, 270, 8, 36, "Output",
 CellID->620056659]
}, Open  ]],
Cell[15168, 499, 125, 3, 70, "ExampleDelimiter",
 CellID->105790448],
Cell[15296, 504, 70, 1, 70, "ExampleText",
 CellID->186564984],
Cell[CellGroupData[{
Cell[15391, 509, 208, 7, 70, "Input",
 CellID->380979824],
Cell[15602, 518, 267, 8, 36, "Output",
 CellID->66135636]
}, Open  ]],
Cell[15884, 529, 124, 3, 70, "ExampleDelimiter",
 CellID->22253048],
Cell[16011, 534, 112, 3, 70, "ExampleText",
 CellID->68762940],
Cell[CellGroupData[{
Cell[16148, 541, 170, 5, 70, "Input",
 CellID->489102737],
Cell[16321, 548, 249, 8, 36, "Output",
 CellID->106102631]
}, Open  ]],
Cell[16585, 559, 125, 3, 70, "ExampleDelimiter",
 CellID->114938765],
Cell[16713, 564, 218, 7, 70, "ExampleText",
 CellID->310520456],
Cell[CellGroupData[{
Cell[16956, 575, 176, 6, 70, "Input",
 CellID->102445170],
Cell[17135, 583, 326, 11, 36, "Output",
 CellID->192415820]
}, Open  ]],
Cell[17476, 597, 123, 3, 70, "ExampleDelimiter",
 CellID->3359231],
Cell[17602, 602, 92, 1, 70, "ExampleText",
 CellID->259031270],
Cell[CellGroupData[{
Cell[17719, 607, 236, 8, 70, "Input",
 CellID->27419542],
Cell[17958, 617, 234, 8, 36, "Output",
 CellID->277558476]
}, Open  ]],
Cell[CellGroupData[{
Cell[18229, 630, 419, 15, 70, "Input",
 CellID->37739192],
Cell[18651, 647, 319, 12, 62, "Output",
 CellID->90698569]
}, Open  ]],
Cell[18985, 662, 126, 3, 70, "ExampleText",
 CellID->341324251],
Cell[CellGroupData[{
Cell[19136, 669, 146, 5, 70, "Input",
 CellID->306710583],
Cell[19285, 676, 215, 7, 36, "Output",
 CellID->62291637]
}, Open  ]],
Cell[CellGroupData[{
Cell[19537, 688, 321, 10, 70, "Input",
 CellID->118650963],
Cell[19861, 700, 216, 7, 36, "Output",
 CellID->141211024]
}, Open  ]],
Cell[20092, 710, 125, 3, 70, "ExampleDelimiter",
 CellID->116659917],
Cell[20220, 715, 203, 7, 70, "ExampleText",
 CellID->337581887],
Cell[CellGroupData[{
Cell[20448, 726, 166, 5, 70, "Input",
 CellID->122807641],
Cell[20617, 733, 278, 9, 50, "Output",
 CellID->270444971]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20944, 748, 239, 7, 70, "ExampleSection",
 CellID->12048],
Cell[21186, 757, 211, 7, 70, "ExampleText",
 CellID->271403579],
Cell[CellGroupData[{
Cell[21422, 768, 281, 10, 70, "Input",
 CellID->104004036],
Cell[21706, 780, 1744, 51, 81, "Output",
 CellID->107436616]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23499, 837, 223, 7, 70, "ExampleSection",
 CellID->16016],
Cell[23725, 846, 95, 1, 70, "ExampleText",
 CellID->742868198],
Cell[23823, 849, 2133, 66, 70, "Input",
 CellID->36571340],
Cell[25959, 917, 80, 1, 70, "ExampleText",
 CellID->331249941],
Cell[26042, 920, 1480, 46, 70, "Input",
 CellID->492487310],
Cell[CellGroupData[{
Cell[27547, 970, 868, 28, 70, "Input",
 CellID->508776826],
Cell[28418, 1000, 8671, 146, 70, "Output",
 Evaluatable->False,
 CellID->622655281]
}, Open  ]],
Cell[37104, 1149, 125, 3, 70, "ExampleDelimiter",
 CellID->715667511],
Cell[37232, 1154, 910, 30, 70, "ExampleText",
 CellID->311825910],
Cell[38145, 1186, 2178, 67, 70, "Input",
 CellID->210478124],
Cell[40326, 1255, 81, 1, 70, "ExampleText",
 CellID->356412923],
Cell[CellGroupData[{
Cell[40432, 1260, 724, 24, 70, "Input",
 CellID->331991668],
Cell[41159, 1286, 158, 5, 36, "Output",
 CellID->153155609]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41366, 1297, 233, 7, 70, "ExampleSection",
 CellID->11658],
Cell[41602, 1306, 74, 1, 70, "ExampleText",
 CellID->446884639],
Cell[CellGroupData[{
Cell[41701, 1311, 381, 12, 70, "Input",
 CellID->150613467],
Cell[42085, 1325, 336, 11, 36, "Output",
 CellID->33463487]
}, Open  ]],
Cell[42436, 1339, 245, 8, 70, "ExampleText",
 CellID->63042172],
Cell[CellGroupData[{
Cell[42706, 1351, 105, 3, 70, "Input",
 CellID->7135577],
Cell[42814, 1356, 203, 7, 36, "Output",
 CellID->650830190]
}, Open  ]],
Cell[43032, 1366, 125, 3, 70, "ExampleDelimiter",
 CellID->113076732],
Cell[43160, 1371, 74, 1, 70, "ExampleText",
 CellID->81298353],
Cell[CellGroupData[{
Cell[43259, 1376, 359, 13, 70, "Input",
 CellID->330205070],
Cell[43621, 1391, 453, 8, 70, "Message",
 CellID->139020543],
Cell[44077, 1401, 917, 33, 81, "Output",
 CellID->587669083]
}, Open  ]],
Cell[45009, 1437, 125, 3, 70, "ExampleDelimiter",
 CellID->690585279],
Cell[45137, 1442, 53, 1, 70, "ExampleText",
 CellID->243715871],
Cell[CellGroupData[{
Cell[45215, 1447, 189, 6, 70, "Input",
 CellID->223231688],
Cell[45407, 1455, 413, 15, 64, "Output",
 CellID->117437962]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45869, 1476, 226, 7, 70, "ExampleSection",
 CellID->25675],
Cell[46098, 1485, 118, 3, 70, "ExampleText",
 CellID->449874585],
Cell[CellGroupData[{
Cell[46241, 1492, 155, 5, 70, "Input",
 CellID->268043320],
Cell[46399, 1499, 261, 7, 36, "Output",
 CellID->10727779]
}, Open  ]],
Cell[CellGroupData[{
Cell[46697, 1511, 214, 8, 70, "Input",
 CellID->154941739],
Cell[46914, 1521, 292, 7, 36, "Output",
 CellID->914896649]
}, Open  ]],
Cell[47221, 1531, 125, 3, 70, "ExampleDelimiter",
 CellID->777259805],
Cell[47349, 1536, 127, 4, 70, "ExampleText",
 CellID->632184],
Cell[CellGroupData[{
Cell[47501, 1544, 293, 10, 70, "Input",
 CellID->19011457],
Cell[47797, 1556, 383, 13, 53, "Output",
 CellID->156368365]
}, Open  ]],
Cell[CellGroupData[{
Cell[48217, 1574, 107, 3, 70, "Input",
 CellID->72341539],
Cell[48327, 1579, 158, 5, 36, "Output",
 CellID->203337946]
}, Open  ]],
Cell[CellGroupData[{
Cell[48522, 1589, 542, 19, 70, "Input",
 CellID->75249245],
Cell[49067, 1610, 580, 20, 39, "Output",
 CellID->173818238]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49708, 1637, 310, 9, 70, "SeeAlsoSection",
 CellID->2173],
Cell[50021, 1648, 709, 26, 70, "SeeAlso",
 CellID->2998]
}, Open  ]],
Cell[CellGroupData[{
Cell[50767, 1679, 313, 9, 70, "TutorialsSection",
 CellID->1768],
Cell[51083, 1690, 191, 4, 70, "Tutorials",
 CellID->3947]
}, Open  ]],
Cell[CellGroupData[{
Cell[51311, 1699, 319, 9, 70, "MoreAboutSection",
 CellID->236623794],
Cell[51633, 1710, 147, 3, 70, "MoreAbout",
 CellID->273257804]
}, Open  ]],
Cell[51795, 1716, 27, 0, 70, "History"],
Cell[51825, 1718, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

