(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     80661,       2514]
NotebookOptionsPosition[     70221,       2146]
NotebookOutlinePosition[     71524,       2184]
CellTagsIndexPosition[     71438,       2179]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiDS" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiDS"], "JacobiDC" :> 
          Documentation`HelpLookup["paclet:ref/JacobiDC"], "JacobiDN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiDN"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiDS\"\>", 
       2->"\<\"JacobiDC\"\>", 3->"\<\"JacobiDN\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiDS", "ObjectName",
 CellID->13961],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiDS",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiDS"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"ds", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16742]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ds", "(", "u", ")"}], "=", 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        RowBox[{
         SuperscriptBox["sin", "2"], "(", "\[Phi]", ")"}]}]}]], 
     RowBox[{"sin", "(", "\[Phi]", ")"}]]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->11783],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"ds", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31252979],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDS"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->451583866],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDS"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->469802386],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDS"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDS"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17869684],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->480860721],

Cell["Evaluate numerically:", "ExampleText",
 CellID->297820305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{"2.5", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244687452],

Cell[BoxData["0.8721945749586348`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->706255440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->472748319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{"u", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->277635963],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96686408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28588389],

Cell["Series expansions:", "ExampleText",
 CellID->134741977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386567672],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "z"], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", "m"}]}], ")"}], " ", "z"}], "+", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "+", 
      RowBox[{"8", " ", "m"}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"31", "-", 
       RowBox[{"78", " ", "m"}], "+", 
       RowBox[{"48", " ", 
        SuperscriptBox["m", "2"]}], "-", 
       RowBox[{"32", " ", 
        SuperscriptBox["m", "3"]}]}], ")"}], " ", 
     SuperscriptBox["z", "5"]}], "15120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "6"],
    SeriesData[$CellContext`z, 0, {}, -1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[1, 6] (1 - 2 $CellContext`m), 0, 
    Rational[1, 360] (7 + 8 $CellContext`m - 8 $CellContext`m^2), 0, 
    Rational[1, 15120] (31 - 78 $CellContext`m + 48 $CellContext`m^2 - 
     32 $CellContext`m^3)}, -1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{472, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->900579888]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111422725],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Csc", "[", "z", "]"}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"Cot", "[", "z", "]"}], " ", 
       RowBox[{"Csc", "[", "z", "]"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], "-", 
      RowBox[{
       RowBox[{"Cot", "[", "z", "]"}], " ", 
       RowBox[{"Csc", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Csc[$CellContext`z], 
    Rational[1, 8] (2 $CellContext`z Cot[$CellContext`z] Csc[$CellContext`z] - 
     4 Sin[$CellContext`z] - Cot[$CellContext`z] Csc[$CellContext`z] 
     Sin[2 $CellContext`z])}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{470, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27491582]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7348],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->129846035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{
   RowBox[{"1.5", "+", 
    RowBox[{"0.5", "I"}]}], ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->759271466],

Cell[BoxData[
 RowBox[{"0.19499900994138405`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.42048863156064065`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23199105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->952308874],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->6417250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->391684793],

Cell[BoxData["0.\
8460413780441121459103102236660062331565151635430508658082897510377`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->546135940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189588955],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->174359713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{"2", ",", "0.33333333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->472054173],

Cell[BoxData["0.846041378044112145910310223666006233156515163542`36.\
939157541039975"], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121707811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->922083953],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDS"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->87194919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361152767],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{"1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiDS", "[", 
    RowBox[{"2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131952354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121451203],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->216197542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiDS", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270801590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Csc", "[", "z", "]"}], ",", 
   RowBox[{"Csch", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99202516]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiDS", "[", 
    RowBox[{
     RowBox[{"I", " ", 
      RowBox[{"EllipticK", "[", 
       RowBox[{"1", "-", "m"}], "]"}]}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiDS", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->830342569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "-", "m"}]]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "m"}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], ",", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    SqrtBox["m"]}], ",", 
   SqrtBox[
    RowBox[{"1", "-", "m"}]]}], "}"}]], "Output",
 ImageSize->{268, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89967177]
}, Open  ]],

Cell["\<\
Parity transformation and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->439505732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->290495360],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"JacobiDS", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->877661745]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"4", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"4", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->550321537],

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->12078594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->326179915],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->31189566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiDS", "[", 
   RowBox[{"u", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19997062],

Cell[BoxData[
 FormBox[
  RowBox[{"ds", "(", 
   RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->678404232]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7510],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDS"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->416500379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "z", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "z", "]"}], "^", "10"}]}], ",", "m"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->474046052],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "z"], "-", 
   FractionBox[
    RowBox[{"m", " ", "z"}], "3"], "+", 
   RowBox[{
    FractionBox["1", "90"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "m"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "36"}], " ", "m"}], "-", 
       RowBox[{"15", " ", 
        SuperscriptBox["m", "2"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["m", "3"]}]}], ")"}], " ", 
     SuperscriptBox["z", "5"]}], "1890"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "7"],
    SeriesData[$CellContext`z, 0, {}, -1, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[-1, 3] $CellContext`m, 0, 
    Rational[1, 90] ((-3) $CellContext`m - 2 $CellContext`m^2), 0, 
    Rational[1, 1890] ((-36) $CellContext`m - 15 $CellContext`m^2 - 
     4 $CellContext`m^3)}, -1, 7, 1],
  Editable->False]], "Output",
 ImageSize->{374, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38835528]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8110],

Cell["Conformal map from a rectangle to the unit disk:", "ExampleText",
 CellID->570863902],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"z_", ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"m", "=", 
      RowBox[{"InverseEllipticNomeQ", "[", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "Pi"}], " ", "2", " ", 
         RowBox[{"b", "/", "a"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"JacobiDN", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"EllipticK", "[", "m", "]"}], 
          FractionBox["z", "a"]}], ",", "m"}], "]"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"JacobiDS", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"EllipticK", "[", "m", "]"}], 
           FractionBox["z", "a"]}], ",", "m"}], "]"}]}]}], 
      RowBox[{
       RowBox[{"JacobiDN", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"EllipticK", "[", "m", "]"}], 
          FractionBox["z", "a"]}], ",", "m"}], "]"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"JacobiDS", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"EllipticK", "[", "m", "]"}], 
           FractionBox["z", "a"]}], ",", "m"}], "]"}]}]}]]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199487360],

Cell["Visualize the map:", "ExampleText",
 CellID->318950862],

Cell[BoxData[
 RowBox[{
  RowBox[{"points", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"pp", "=", "25"}], ",", 
       RowBox[{"a", "=", "1."}], ",", 
       RowBox[{"b", "=", "2."}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"x", " ", "+", " ", 
          RowBox[{"I", " ", "y"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", " ", "a"}], ",", "a", ",", 
           RowBox[{"2", 
            RowBox[{"a", "/", "pp"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "0", ",", 
           RowBox[{"2", " ", "b"}], ",", 
           RowBox[{"2", 
            RowBox[{"b", "/", "pp"}]}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}],
     "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->576994587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", " ", 
      RowBox[{"f", "[", "points", "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Identity", ",", 
       RowBox[{
        RowBox[{"w", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "&"}]}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->584095858],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->185584972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->323870425],

Cell[TextData[{
 "Generator for the hierarchy of solutions of the nonlinear diffusion \
equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"u", "(", 
       RowBox[{"t", ",", "x"}], ")"}]}], 
     RowBox[{"\[PartialD]", "t"}],
     MultilineFunction->None], "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"u", "(", 
        RowBox[{"t", ",", "x"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "x"}]}],
      MultilineFunction->None], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"u", "(", 
        RowBox[{"t", ",", "x"}], ")"}], "3"]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->69906327],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CurlyPhi]", "[", 
    RowBox[{"0", ",", "y_"}], "]"}], ":=", 
   RowBox[{"JacobiDS", "[", 
    RowBox[{"y", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CurlyPhi]", "[", 
   RowBox[{"n_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CurlyPhi]", "[", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", "y"}], "]"}], ",", "y"}], "]"}], "/", 
   RowBox[{"\[CurlyPhi]", "[", 
    RowBox[{
     RowBox[{"n", "-", "1"}], ",", "y"}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "x_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"\[CurlyPhi]", "[", 
     RowBox[{"n", ",", "y"}], "]"}]}], "/.", 
   RowBox[{"y", "->", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"6", " ", "t"}]}]}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->548759095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"k", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "x"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->458022657],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"JacobiDS", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"6", " ", "t"}], "+", 
       SuperscriptBox["x", "2"]}], ",", 
      FractionBox["1", "2"]}], "]"}]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"JacobiCS", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}], " ", 
      RowBox[{"JacobiNS", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}]}], 
     RowBox[{"JacobiDS", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"6", " ", "t"}], "+", 
        SuperscriptBox["x", "2"]}], ",", 
       FractionBox["1", "2"]}], "]"}]]}], ",", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"JacobiDS", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"6", " ", "t"}], "+", 
          SuperscriptBox["x", "2"]}], ",", 
         FractionBox["1", "2"]}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"JacobiNS", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"6", " ", "t"}], "+", 
             SuperscriptBox["x", "2"]}], ",", 
            FractionBox["1", "2"]}], "]"}], "2"], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"JacobiCS", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"6", " ", "t"}], "+", 
              SuperscriptBox["x", "2"]}], ",", 
             FractionBox["1", "2"]}], "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"JacobiNS", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"6", " ", "t"}], "+", 
                 SuperscriptBox["x", "2"]}], ",", 
                FractionBox["1", "2"]}], "]"}], "2"], 
             SuperscriptBox[
              RowBox[{"JacobiDS", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"6", " ", "t"}], "+", 
                 SuperscriptBox["x", "2"]}], ",", 
                FractionBox["1", "2"]}], "]"}], "2"]]}], ")"}]}]}], ")"}]}], 
      ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"JacobiCS", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"6", " ", "t"}], "+", 
          SuperscriptBox["x", "2"]}], ",", 
         FractionBox["1", "2"]}], "]"}], " ", 
       RowBox[{"JacobiNS", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"6", " ", "t"}], "+", 
          SuperscriptBox["x", "2"]}], ",", 
         FractionBox["1", "2"]}], "]"}]}], ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{547, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->672668103]
}, Open  ]],

Cell["Numerical check of the solutions:", "ExampleText",
 CellID->482807538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"%", ",", "t"}], "]"}], "-", 
   RowBox[{"D", "[", 
    RowBox[{"%", ",", "x", ",", "x"}], "]"}], "+", 
   RowBox[{"2", 
    RowBox[{"%", "^", "3"}]}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "2"}], ",", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"N", "[", 
      RowBox[{"3", ",", "100"}], "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->919980924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0``92.75312627959877", ",", "0``92.32054646714248", ",", 
   "0``91.00469026365224"}], "}"}]], "Output",
 ImageSize->{205, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->250951937]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208884986],

Cell["Conformal map from an ellipse to the unit disk:", "ExampleText",
 CellID->539250045],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"z_", ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"m", "=", 
       RowBox[{"InverseEllipticNomeQ", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}], "^", "2"}]}], "]"}]}], ",", "u"}], 
     "}"}], ",", 
    RowBox[{
     RowBox[{"u", "=", 
      RowBox[{"2", " ", 
       RowBox[{
        RowBox[{"EllipticK", "[", "m", "]"}], "/", "Pi"}], " ", 
       RowBox[{"ArcSin", "[", 
        RowBox[{"z", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], "]"}]}], "]"}]}]}], ";", 
     RowBox[{
      SuperscriptBox["m", 
       RowBox[{"1", "/", "2"}]], 
      RowBox[{
       RowBox[{"JacobiDN", "[", 
        RowBox[{"u", ",", "m"}], "]"}], "/", 
       RowBox[{"JacobiDS", "[", 
        RowBox[{"u", ",", "m"}], "]"}]}]}]}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35115403],

Cell["Visualize the map:", "ExampleText",
 CellID->250879779],

Cell[BoxData[
 RowBox[{
  RowBox[{"points", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", "=", "2"}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"r", "/", "8."}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", 
             RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], " ", "+", " ", 
            RowBox[{"I", " ", 
             RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[CurlyPhi]", ",", "0", ",", 
           RowBox[{"2", "Pi"}], ",", 
           RowBox[{"2", 
            RowBox[{"Pi", "/", "36"}]}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231984289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", " ", 
      RowBox[{"f", "[", "points", "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Identity", ",", 
       RowBox[{
        RowBox[{"w", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"2.", ",", "1"}], "}"}]}], "]"}], "&"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->670912061],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->532447611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52439645],

Cell["Cartesian coordinates of a pendulum:", "ExampleText",
 CellID->238044846],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Omega]", "=", 
        SqrtBox[
         FractionBox["g", "\[ScriptL]"]]}], ",", 
       RowBox[{"m", "=", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}], "2"]}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t_", "]"}], " ", "=", " ", 
       RowBox[{"2", "\[ScriptL]", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[CurlyPhi]0", "/", "2"}], "]"}], 
        RowBox[{
         RowBox[{
          RowBox[{"JacobiDN", "[", 
           RowBox[{
            RowBox[{"\[Omega]", " ", "t"}], ",", "m"}], "]"}], "^", "2"}], 
         "/", 
         RowBox[{"JacobiDS", "[", 
          RowBox[{
           RowBox[{"\[Omega]", " ", "t"}], ",", "m"}], "]"}]}]}]}], ";", 
      RowBox[{
       RowBox[{"y", "[", "t_", "]"}], " ", "=", 
       RowBox[{
        RowBox[{"-", "\[ScriptL]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{
            RowBox[{"JacobiDN", "[", 
             RowBox[{
              RowBox[{"\[Omega]", " ", "t"}], ",", "m"}], "]"}], "^", "2"}]}],
           "-", "1"}], ")"}]}]}]}]}], "]"}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42362533],

Cell["\<\
Plot the time\[Hyphen]dependence of the coordinates:\
\>", "ExampleText",
 CellID->17651317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[ScriptL]", "\[Rule]", "1"}], ",", 
       RowBox[{"g", "\[Rule]", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "\[Rule]", 
        RowBox[{"Pi", "/", "4"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.1", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22928806],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46620272]
}, Open  ]],

Cell["Plot the trajectory:", "ExampleText",
 CellID->504412009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[ScriptL]", "\[Rule]", "1"}], ",", 
       RowBox[{"g", "\[Rule]", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "\[Rule]", 
        RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.1", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1050792162],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->244565858]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31323],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->182095253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{
     RowBox[{"InverseJacobiDS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{
     RowBox[{"JacobiDS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493765924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{
     RowBox[{"JacobiDS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189682566]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->505999971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68594752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->284015202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27094000],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->28603597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiDS", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"3", 
      RowBox[{"JacobiDS", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->798905],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->412170907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiDS", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiDS", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{302, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560166749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187645606],

Cell["Integrals:", "ExampleText",
 CellID->230428239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128430086],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"JacobiCS", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], "+", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], "]"}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442893209]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19192],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->291661378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{
   RowBox[{"10.", "^", "15"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16218361],

Cell[BoxData[
 RowBox[{"0.6053873957938617`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.590362277975211`*^-16", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433472065]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiDS", "[", 
    RowBox[{
     RowBox[{"10", "^", "15"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46458592],

Cell[BoxData[
 RowBox[{"0.331746759543255496572002122891798925`20.15051499783199", "+", 
  RowBox[{"0``20.629708308403604", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52073878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93508236],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->91718301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"JacobiDS", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"JacobiCD", "[", 
        RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"JacobiSD", "[", 
        RowBox[{"u", ",", "m"}], "]"}], "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"JacobiSN", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "2"]}]}], "//", " ", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74336280],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox[
   RowBox[{"JacobiCN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], "2"], "-", 
  SuperscriptBox[
   RowBox[{"JacobiSN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], "2"]}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->624885338]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18144],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiDS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiDS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiDC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiDN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDN"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19751]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25062],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->13488]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->129905584],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->112878759]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiDS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 32.5596894}", "context" -> "System`", 
    "keywords" -> {
     "doubly periodic function", "ds", "elliptic Jacobi function", 
      "Jacobi elliptic function ds"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiDS[u, m] gives the Jacobi elliptic function ds(u | m).", 
    "synonyms" -> {"Jacobi DS"}, "title" -> "JacobiDS", "type" -> "Symbol", 
    "uri" -> "ref/JacobiDS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6337, 226, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->17869684]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 71296, 2172}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2018, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2641, 77, 46, 1, 70, "ObjectName",
 CellID->13961],
Cell[2690, 80, 676, 22, 70, "Usage",
 CellID->16742]
}, Open  ]],
Cell[CellGroupData[{
Cell[3403, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3881, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4004, 130, 560, 22, 70, "Notes",
 CellID->11783],
Cell[4567, 154, 838, 30, 70, "Notes",
 CellID->31252979],
Cell[5408, 186, 216, 7, 70, "Notes",
 CellID->451583866],
Cell[5627, 195, 248, 8, 70, "Notes",
 CellID->469802386],
Cell[5878, 205, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6099, 214, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6337, 226, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17869684],
Cell[CellGroupData[{
Cell[6721, 240, 148, 5, 70, "ExampleSection",
 CellID->480860721],
Cell[6872, 247, 64, 1, 70, "ExampleText",
 CellID->297820305],
Cell[CellGroupData[{
Cell[6961, 252, 131, 4, 28, "Input",
 CellID->244687452],
Cell[7095, 258, 176, 5, 36, "Output",
 CellID->706255440]
}, Open  ]],
Cell[7286, 266, 125, 3, 70, "ExampleDelimiter",
 CellID->472748319],
Cell[CellGroupData[{
Cell[7436, 273, 290, 10, 28, "Input",
 CellID->277635963],
Cell[7729, 285, 3331, 59, 141, "Output",
 Evaluatable->False,
 CellID->96686408]
}, Open  ]],
Cell[11075, 347, 124, 3, 70, "ExampleDelimiter",
 CellID->28588389],
Cell[11202, 352, 61, 1, 70, "ExampleText",
 CellID->134741977],
Cell[CellGroupData[{
Cell[11288, 357, 245, 8, 70, "Input",
 CellID->386567672],
Cell[11536, 367, 1354, 42, 56, "Output",
 CellID->900579888]
}, Open  ]],
Cell[CellGroupData[{
Cell[12927, 414, 245, 8, 70, "Input",
 CellID->111422725],
Cell[13175, 424, 1129, 33, 51, "Output",
 CellID->27491582]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14353, 463, 215, 7, 70, "ExampleSection",
 CellID->7348],
Cell[14571, 472, 74, 1, 70, "ExampleText",
 CellID->129846035],
Cell[CellGroupData[{
Cell[14670, 477, 199, 7, 70, "Input",
 CellID->759271466],
Cell[14872, 486, 274, 7, 36, "Output",
 CellID->23199105]
}, Open  ]],
Cell[15161, 496, 125, 3, 70, "ExampleDelimiter",
 CellID->952308874],
Cell[15289, 501, 68, 1, 70, "ExampleText",
 CellID->6417250],
Cell[CellGroupData[{
Cell[15382, 506, 208, 7, 70, "Input",
 CellID->391684793],
Cell[15593, 515, 235, 7, 36, "Output",
 CellID->546135940]
}, Open  ]],
Cell[15843, 525, 125, 3, 70, "ExampleDelimiter",
 CellID->189588955],
Cell[15971, 530, 113, 3, 70, "ExampleText",
 CellID->174359713],
Cell[CellGroupData[{
Cell[16109, 537, 169, 5, 70, "Input",
 CellID->472054173],
Cell[16281, 544, 229, 6, 36, "Output",
 CellID->121707811]
}, Open  ]],
Cell[16525, 553, 125, 3, 70, "ExampleDelimiter",
 CellID->922083953],
Cell[16653, 558, 217, 7, 70, "ExampleText",
 CellID->87194919],
Cell[CellGroupData[{
Cell[16895, 569, 176, 6, 70, "Input",
 CellID->361152767],
Cell[17074, 577, 326, 11, 36, "Output",
 CellID->131952354]
}, Open  ]],
Cell[17415, 591, 125, 3, 70, "ExampleDelimiter",
 CellID->121451203],
Cell[17543, 596, 91, 1, 70, "ExampleText",
 CellID->216197542],
Cell[CellGroupData[{
Cell[17659, 601, 237, 8, 70, "Input",
 CellID->270801590],
Cell[17899, 611, 266, 9, 36, "Output",
 CellID->99202516]
}, Open  ]],
Cell[CellGroupData[{
Cell[18202, 625, 514, 18, 70, "Input",
 CellID->830342569],
Cell[18719, 645, 534, 21, 49, "Output",
 CellID->89967177]
}, Open  ]],
Cell[19268, 669, 125, 3, 70, "ExampleText",
 CellID->439505732],
Cell[CellGroupData[{
Cell[19418, 676, 146, 5, 70, "Input",
 CellID->290495360],
Cell[19567, 683, 235, 8, 36, "Output",
 CellID->877661745]
}, Open  ]],
Cell[CellGroupData[{
Cell[19839, 696, 316, 10, 70, "Input",
 CellID->550321537],
Cell[20158, 708, 215, 7, 36, "Output",
 CellID->12078594]
}, Open  ]],
Cell[20388, 718, 125, 3, 70, "ExampleDelimiter",
 CellID->326179915],
Cell[20516, 723, 202, 7, 70, "ExampleText",
 CellID->31189566],
Cell[CellGroupData[{
Cell[20743, 734, 165, 5, 70, "Input",
 CellID->19997062],
Cell[20911, 741, 278, 9, 50, "Output",
 CellID->678404232]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21238, 756, 238, 7, 70, "ExampleSection",
 CellID->7510],
Cell[21479, 765, 211, 7, 70, "ExampleText",
 CellID->416500379],
Cell[CellGroupData[{
Cell[21715, 776, 245, 9, 70, "Input",
 CellID->474046052],
Cell[21963, 787, 1275, 41, 56, "Output",
 CellID->38835528]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23287, 834, 222, 7, 70, "ExampleSection",
 CellID->8110],
Cell[23512, 843, 91, 1, 70, "ExampleText",
 CellID->570863902],
Cell[23606, 846, 1346, 43, 70, "Input",
 CellID->199487360],
Cell[24955, 891, 61, 1, 70, "ExampleText",
 CellID->318950862],
Cell[25019, 894, 910, 28, 70, "Input",
 CellID->576994587],
Cell[CellGroupData[{
Cell[25954, 926, 861, 27, 70, "Input",
 CellID->584095858],
Cell[26818, 955, 6410, 109, 70, "Output",
 Evaluatable->False,
 CellID->185584972]
}, Open  ]],
Cell[33243, 1067, 125, 3, 70, "ExampleDelimiter",
 CellID->323870425],
Cell[33371, 1072, 831, 29, 70, "ExampleText",
 CellID->69906327],
Cell[34205, 1103, 993, 34, 70, "Input",
 CellID->548759095],
Cell[CellGroupData[{
Cell[35223, 1141, 331, 12, 70, "Input",
 CellID->458022657],
Cell[35557, 1155, 3002, 94, 178, "Output",
 CellID->672668103]
}, Open  ]],
Cell[38574, 1252, 76, 1, 70, "ExampleText",
 CellID->482807538],
Cell[CellGroupData[{
Cell[38675, 1257, 457, 16, 70, "Input",
 CellID->919980924],
Cell[39135, 1275, 278, 9, 39, "Output",
 CellID->250951937]
}, Open  ]],
Cell[39428, 1287, 125, 3, 70, "ExampleDelimiter",
 CellID->208884986],
Cell[39556, 1292, 90, 1, 70, "ExampleText",
 CellID->539250045],
Cell[39649, 1295, 1211, 40, 70, "Input",
 CellID->35115403],
Cell[40863, 1337, 61, 1, 70, "ExampleText",
 CellID->250879779],
Cell[40927, 1340, 917, 28, 70, "Input",
 CellID->231984289],
Cell[CellGroupData[{
Cell[41869, 1372, 802, 26, 70, "Input",
 CellID->670912061],
Cell[42674, 1400, 6536, 111, 70, "Output",
 Evaluatable->False,
 CellID->532447611]
}, Open  ]],
Cell[49225, 1514, 124, 3, 70, "ExampleDelimiter",
 CellID->52439645],
Cell[49352, 1519, 79, 1, 70, "ExampleText",
 CellID->238044846],
Cell[49434, 1522, 1334, 42, 70, "Input",
 CellID->42362533],
Cell[50771, 1566, 102, 3, 70, "ExampleText",
 CellID->17651317],
Cell[CellGroupData[{
Cell[50898, 1573, 583, 18, 70, "Input",
 CellID->22928806],
Cell[51484, 1593, 6055, 103, 70, "Output",
 Evaluatable->False,
 CellID->46620272]
}, Open  ]],
Cell[57554, 1699, 63, 1, 70, "ExampleText",
 CellID->504412009],
Cell[CellGroupData[{
Cell[57642, 1704, 595, 18, 70, "Input",
 CellID->1050792162],
Cell[58240, 1724, 2676, 48, 70, "Output",
 Evaluatable->False,
 CellID->244565858]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60965, 1778, 233, 7, 70, "ExampleSection",
 CellID->31323],
Cell[61201, 1787, 74, 1, 70, "ExampleText",
 CellID->182095253],
Cell[CellGroupData[{
Cell[61300, 1792, 381, 12, 70, "Input",
 CellID->493765924],
Cell[61684, 1806, 337, 11, 36, "Output",
 CellID->189682566]
}, Open  ]],
Cell[62036, 1820, 246, 8, 70, "ExampleText",
 CellID->505999971],
Cell[CellGroupData[{
Cell[62307, 1832, 106, 3, 70, "Input",
 CellID->68594752],
Cell[62416, 1837, 203, 7, 36, "Output",
 CellID->284015202]
}, Open  ]],
Cell[62634, 1847, 124, 3, 70, "ExampleDelimiter",
 CellID->27094000],
Cell[62761, 1852, 74, 1, 70, "ExampleText",
 CellID->28603597],
Cell[CellGroupData[{
Cell[62860, 1857, 356, 13, 70, "Input",
 CellID->798905],
Cell[63219, 1872, 453, 8, 70, "Message",
 CellID->412170907],
Cell[63675, 1882, 917, 33, 81, "Output",
 CellID->560166749]
}, Open  ]],
Cell[64607, 1918, 125, 3, 70, "ExampleDelimiter",
 CellID->187645606],
Cell[64735, 1923, 53, 1, 70, "ExampleText",
 CellID->230428239],
Cell[CellGroupData[{
Cell[64813, 1928, 194, 6, 70, "Input",
 CellID->128430086],
Cell[65010, 1936, 354, 12, 36, "Output",
 CellID->442893209]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65413, 1954, 226, 7, 70, "ExampleSection",
 CellID->19192],
Cell[65642, 1963, 118, 3, 70, "ExampleText",
 CellID->291661378],
Cell[CellGroupData[{
Cell[65785, 1970, 154, 5, 70, "Input",
 CellID->16218361],
Cell[65942, 1977, 277, 7, 36, "Output",
 CellID->433472065]
}, Open  ]],
Cell[CellGroupData[{
Cell[66256, 1989, 213, 8, 70, "Input",
 CellID->46458592],
Cell[66472, 1999, 290, 7, 36, "Output",
 CellID->52073878]
}, Open  ]],
Cell[66777, 2009, 124, 3, 70, "ExampleDelimiter",
 CellID->93508236],
Cell[66904, 2014, 129, 4, 70, "ExampleText",
 CellID->91718301],
Cell[CellGroupData[{
Cell[67058, 2022, 590, 20, 70, "Input",
 CellID->74336280],
Cell[67651, 2044, 361, 12, 36, "Output",
 CellID->624885338]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68073, 2063, 311, 9, 70, "SeeAlsoSection",
 CellID->18144],
Cell[68387, 2074, 710, 26, 70, "SeeAlso",
 CellID->19751]
}, Open  ]],
Cell[CellGroupData[{
Cell[69134, 2105, 314, 9, 70, "TutorialsSection",
 CellID->25062],
Cell[69451, 2116, 192, 4, 70, "Tutorials",
 CellID->13488]
}, Open  ]],
Cell[CellGroupData[{
Cell[69680, 2125, 319, 9, 70, "MoreAboutSection",
 CellID->129905584],
Cell[70002, 2136, 147, 3, 70, "MoreAbout",
 CellID->112878759]
}, Open  ]],
Cell[70164, 2142, 27, 0, 70, "History"],
Cell[70194, 2144, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

