(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    103396,       2810]
NotebookOptionsPosition[     93240,       2452]
NotebookOutlinePosition[     94543,       2490]
CellTagsIndexPosition[     94457,       2485]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiNC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiNC"], "JacobiND" :> 
          Documentation`HelpLookup["paclet:ref/JacobiND"], "JacobiNS" :> 
          Documentation`HelpLookup["paclet:ref/JacobiNS"], "JacobiCN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiCN"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiNC\"\>", 
       2->"\<\"JacobiND\"\>", 3->"\<\"JacobiNS\"\>", 
       4->"\<\"JacobiCN\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiNC", "ObjectName",
 CellID->8499],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiNC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiNC"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"nc", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8207]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"nc", "(", "u", ")"}], "=", 
    FractionBox["1", 
     RowBox[{"cos", "(", "\[Phi]", ")"}]]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->24065],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"nc", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17328219],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNC"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->8656038],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiNC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNC"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->879579261],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNC"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNC"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43192206],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->70015958],

Cell["Evaluate numerically:", "ExampleText",
 CellID->814676922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{"2.5", ",", "0.3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27188654],

Cell[BoxData[
 RowBox[{"-", "1.5973624900546226`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->741701180]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191905672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12000150],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45890747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390091798],

Cell["Series expansions about the origin:", "ExampleText",
 CellID->38477304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200709323],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    SuperscriptBox["z", "2"], "2"], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "-", 
      RowBox[{"4", " ", "m"}]}], ")"}], " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", 
    RowBox[{"(", 
     RowBox[{"61", "-", 
      RowBox[{"76", " ", "m"}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "8"],
    SeriesData[$CellContext`z, 0, {}, 0, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 0, 
    Rational[1, 2], 0, Rational[1, 24] (5 - 4 $CellContext`m), 0, 
    Rational[1, 720] (61 - 76 $CellContext`m + 16 $CellContext`m^2)}, 0, 8, 
   1],
  Editable->False]], "Output",
 ImageSize->{350, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141529613]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->260356113],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Sec", "[", "z", "]"}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "z", " ", 
       RowBox[{"Sec", "[", "z", "]"}], " ", 
       RowBox[{"Tan", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Sec", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "z"}], "]"}], " ", 
       RowBox[{"Tan", "[", "z", "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Sec[$CellContext`z], 
    Rational[1, 8] ((-2) $CellContext`z Sec[$CellContext`z] 
      Tan[$CellContext`z] + 
     Sec[$CellContext`z] Sin[2 $CellContext`z] Tan[$CellContext`z])}, 0, 2, 
   1],
  Editable->False]], "Output",
 ImageSize->{413, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->330817906]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14457],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->257841689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325910105],

Cell[BoxData[
 RowBox[{"0.8242623005144115`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.023274204247505113`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141686347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25415347],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->856906711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69210409],

Cell[BoxData[
 RowBox[{"-", 
  "4.6215340484807968474741291654888205722914368783657426812498471504594`50."}\
]], "Output",
 ImageSize->{369, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244942290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200525529],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->372977787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{"2", ",", "0.333333333333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2714330],

Cell[BoxData[
 RowBox[{"-", 
  "4.6215340484807968474741291654888205722914368783657426812365`40.\
53273729480376"}]], "Output",
 ImageSize->{299, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348015721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182528140],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNC"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->747487832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->536864854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiNC", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263730872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259414736],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->18087730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiNC", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365032203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sec", "[", "z", "]"}], ",", 
   RowBox[{"Cosh", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1962788]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiNC", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiNC", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175336906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox[
    SqrtBox[
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "-", "m"}]]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "m"}], ")"}], 
     RowBox[{"1", "/", "4"}]]], ",", "ComplexInfinity"}], "}"}]], "Output",
 ImageSize->{239, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->168059281]
}, Open  ]],

Cell["\<\
Parity transformations and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->336727663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->614178488],

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->183078831]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"4", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"4", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->674473773],

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->19247743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215688415],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->178560258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiNC", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292152639],

Cell[BoxData[
 FormBox[
  RowBox[{"nc", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->490776588]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23110],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNC"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->541124796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "8"}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271512446],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{"9", "-", 
      RowBox[{"4", " ", "m"}]}], ")"}], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", 
    RowBox[{"(", 
     RowBox[{"225", "-", 
      RowBox[{"156", " ", "m"}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["x", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"],
    SeriesData[$CellContext`x, 0, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 2], 0, Rational[1, 24] (9 - 4 $CellContext`m), 0, 
    Rational[1, 720] (225 - 156 $CellContext`m + 16 $CellContext`m^2)}, 0, 7, 
   1],
  Editable->False]], "Output",
 ImageSize->{364, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227483242]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31209],

Cell["Conformal map from a unit triangle to the unit disk:", "ExampleText",
 CellID->223864426],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "z_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "=", 
       FractionBox[
        RowBox[{"z", " ", 
         RowBox[{
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "/", "3"}], "]"}], "^", "3"}]}], 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"1", "/", "3"}]], 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], "\[Pi]"}]]}], ",", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"\[Pi]", "/", "12"}], "]"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"11", "/", "6"}]], 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", "/", "12"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"JacobiNC", "[", 
        RowBox[{"\[Zeta]", ",", "m"}], "]"}], "-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"Tan", "[", 
          RowBox[{"\[Pi]", "/", "12"}], "]"}], 
         RowBox[{"JacobiCN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}], "/", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], 
         RowBox[{"JacobiSC", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], 
         RowBox[{"JacobiDN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"JacobiNC", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"JacobiCN", "[", 
             RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}], "^", "2"}]}]}], 
       ")"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16049754],

Cell["Show points before and after the map:", "ExampleText",
 CellID->84846121],

Cell[BoxData[
 RowBox[{
  RowBox[{"trianglePoints", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "=", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", "Pi", " ", 
          RowBox[{"I", "/", "3"}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"s", "/", "8."}], " ", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"#1", "+", 
              RowBox[{
               RowBox[{"j", "/", "16"}], 
               RowBox[{"(", 
                RowBox[{"#2", "-", "#1"}], ")"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "&"}], "@@@",
          
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", 
               RowBox[{"1", "/", "t"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "/", "t"}], ",", "1"}], "}"}]}], "}"}], "/", 
           SqrtBox["3"]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"s", ",", "8"}], "}"}]}], "]"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272616709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      "trianglePoints"}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"w", "[", "trianglePoints", "]"}]}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126582686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->306702117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62716298],

Cell["Parametrize a lemniscate by arc length:", "ExampleText",
 CellID->301528815],

Cell[BoxData[
 RowBox[{
  RowBox[{"lemniscate", "[", "s_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"JacobiDN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], "/", 
     RowBox[{"JacobiNC", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"JacobiSN", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], "/", 
      RowBox[{"JacobiNC", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}]}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->800229651],

Cell["\<\
Show arc length parametrization and classical parametrization:\
\>", "ExampleText",
 CellID->59363360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "\[Theta]_", "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], ">", "0"}], ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], "]"}], ",", "0"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"lemniscate", "[", "s", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "/", "4"}], "]"}], "^", "2"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", "Pi"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17288740],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1m0uoXlcVx3fu991X2iRNk5uHNbkxfag1te+qTdNUQ1prm4qIOhAHsQjt
QCu1TnTiA8xEJzqxUOzAB7Q6qBQqQgWxIBbEglgQFaSC1IFFsDgoCMffWv/9
OGef8333Ozc1JF/OPmfvtf7rsdd+rX3u/GMPfeaz5x97+MHzx+559PznH3r4
wS8cu/uRR3k12RHCjq+FEO46FHhuePJ/9ufr/NOjnt5tv5PXXvvPS7/7O3/D
kv1Y2Ws34QQ/S0H1lvn2ca//+utvdOr/+U//HKgfJq+88q9WvRPO8R32O335
D//44Q9e+upXnn/kc88unT71eJh85MPf55m/Ycl+1ijznr8PP/QML5783m9f
+NVfAfZ2p5zkacI19rMMgp8+8/KFb/ySqp/42I+C0VxOtJdF+zvf/vXPnvvj
q6/+O9xrbVZBR/lb33yBb/fd+yQ1+Q1T5/7gp38i7moKd6rSYJg7H37x/F8e
/+6LVKVlkESf+uRTLYmEBA48wxO0tApXu078dxUSKIQaSAwtiqa5nfZtDX1R
AMaXv/RzICEi0vDmqqjvK63WOuqBLlXOnnkCHLABNbVM5nWnI0v/+OnfoyqI
ABE6KO+Mf+UTbaDPeypAizcYez1RFwY+UYFqPICSCs7f1HLca/IGxggjUjxg
bNrCKOKQB8EAftQACg+88faisgJqXqIP2ovNvvQeAWQ0EOAWe6MWJi3r8Bvs
3UplsU3XNcRgDg0QwgQab7zx3yD62AX66I+/iMGHU/6eNggPVJrRGHV4/VUe
JC140D1QjdZlIzAdc/rZ/lJrom/yZqwAAIbLoFbLfJUtqWOWOJywgknOgu4p
7vJ+V3iGsFqhmETER1OPgq7UY374ltZbuKEhk/J9/hbyOKzgma+pLkpFHrkq
woSxCKBEy2z/SBVKsgLfTN4jTspbTEHEN/wJ2TdTbZAVDKZ5gxCWhSBDGcRi
xSuczou/+Zv6thwi8oMidOHH5/f4G3QNM36pdDQhQFfqLKab7SLAK7PmTW4h
4Ikyb8H1Vqfj+phiMcCiDHAcTzZSzai39Z41lqP2a+88nCiigS8+9hwPHm2m
SEMRUJC7Ob1R7OKN6gALlhgQ+GM5Qg0HljWvTNLCDqZ8cm8ILvNE4cDiqeIx
QktWGUKa7XCuOU4jkkMtySCJrIr4QAAIUTjc6GX8Ef1a2b9PKSuWAnEsN5rI
i+gw4oY7QZ2iNCHPnyAJ0lM1XJvaybepvrJQ32qXN1KPyTScqo39CG797Xov
a5g2j7k26VrBJoznecBbiIICyDubOJ/A0nCSRiS1vQUJmg/Xpd6W/S15znLs
Iyux7FJNsAv6M3rXJc0hQ6Y0IaQhtT2eSJrkFa6LC82lPKUC1WRno7UEnYOO
+VDiBEaUGW5o+Y2V90c6+1qeLI6qSZHK9nhtKqNke7y+kilR2p/sEz3xhlSm
abZwxCVQ9nhjT5dLzfBINUlBqmXBvS0sps+bK+w+u5ugFGAUbvIypIXtaG6G
VVEFMjdZa8KaZDtYcb+liTGH+qYRRts5HpmCsKHZm3SHx1mUvqVlTRv91C81
Xymc4KFuO5qT4oVhvNXLGuLs0f1DPcW8J9rS9KxRw+aT7VFjKLZYcXfyMxpI
d7el/o3tbCy8OtmSGhYlCw8640I89qTeFCPEbUlrUDTZJIv6JI4OX+Pz3ibG
aCjQVg9bxo5diQq2NYv4zMMiJRayxysTb/RqFvTvJg5YDNuiHORtFt/EAVpQ
NJCXt6TR2GCPmQ9NgDJnVrMrIVa3Dycr7z2etBn7faaswXzODOFSLzA3i5Hg
ZOWt7nMxXpS3t7sdRM00GoLNzyeJazZ/3SsvaeI4gLim2TuS3ojqpqe3tdDU
fMwyIViPWZSP9GX+6rPwCUS13PQZdoynZne4W607orbdcpjJYm+yQIrllyRN
E8jt8c4m9v44KvjMekIvAKg9nsw04cNrZJ9BE1OiFdOCaEKA+gXt7mixHC0i
AqOw2cxeMch2Gict7u6MddfTe7iaz27MobEZeftaO/a6FI03alzRdlvhUm9A
iKi59Vh3Z9JojF/7F8Il27ZxuVYVZ1azZ/CnW7PtNVf0/KruNbsjbW85lSIY
UiKK2gtXk4ajL21sSf9IqwaawVmWem02ehIpDlycRFm7UetD8qw1TWcGtH+U
PIoefXnc3k57mnAU6UooGJBuI7bp06xx9NePiiHYLvai0hvVVhHAHOXAKClp
RzTpI9o9LB/O0e1Rb658WsiLfFc+zWut3y8oX8RMO5bV/M6wiftIXqWsd6Ut
k7tt+Wrykf76d+o1tTcVQn/WsVzZ9OAomZsUNGYg39etW6Ze/xcpNS7MllKR
3lZho6UsU8m+1zVlbRN685/KzvQAdL2wBtL89rLBLz4y8mxenFZW05Y9bV5w
aCbNYxV3WwH0NVvF1DJ8vyn4LfaHYPOdLv4yMmyBvyArk4IBZLVVlmbbKvJi
LskMtR9fjvTe1GPBnl6N7I0x4qQYUNvq8Ja0N7syMy1lGjdD5nbfgyvBFK2O
styCUsW1QFcqWdAiymip5kb+xSy51qS5ZZOiTp5bbjYl2tv/MySzNzigTDbI
tWW5KyqaR5tqNnT2zBNqmuZ3GZ3G8e2goyXWh/0wumKBWejUDjfH2b3dQOQc
1q/m5ZqH2eOdTXfe7k6QtZfmncIlgU1rH/JyGUC0I1fWUoNUwSqld6lql9Sk
FdUSsNdGSFR2dJzKNIvQRgATufx93qaExHoM8ajX2rcRzew1bZp6iWxG0yLx
+gjUxYKOaC2jVsWM936vXdbCyR/2VhoTleLdafqmoqiUoXyMfunXOgYNTmVF
SIP/EcZzM+TXrkjZIbg/WV1bNyGvTmN92aYMCsMo6+iiNf/pU4/H8rnkBRnf
Ay18eWRr4TqXbKwWPDzgNbTTb4+1ZDsciRSmJZzp6qmg/aqng1YAO/jfau6Y
g5ty1G4dYevygS2+jy1PZljzyJvMZ1cqa2kZI0bw3Rx7vOYi6buXrhSvSjbc
uEi60oPNPGXhYR8Y7jOU45RxXO+Wbhbt1VdVvLWPub1efnFRVLhHRE1+txM1
y+jlmQuToldv1dlHyGBnjFlFT6JVxrg+rXqkKnuVY3Ssc217PN30d4HSo889
MudSq8jzQS/ntatmgq19xvnUNaOsqeu0yyS8t9LWGAkLBt/1m7v66c49i3T3
eLnEXp1sImqcCp+aQVk7t/NmtfekMsSagR49LJnidFkE9vlPW/4UQn+u3JbQ
/OvupttbJGHpTbM4aI9/NgdJavve4lBG0jGSlmjUx6F9GCUYFd2X3bUi49nK
iyRjmSfOot2OlF3aks52zEW79MEx0hUP7SPwdsuEJGHUy7x2zTtp8WzBM4Um
WnPa45GEMi6EZtHPO+OD9LWvbjtZZ1JZq8C4k1xLmXx9V6VvP4tYbXNvfGvV
Ngx6caEqt3d6Td8f8HKJvUcr/Q/ykpNsyavehX1/5SdpVahNjn2VX59q0qpM
O/8WXSatFuVkoJxX3JWko0ubXjcH/CKv9BAaIB2ak0xTu/pm67sq7e9poS0n
MjoJUaS1+ekllS78LAOOpxP1GacwpyqJhuh4PIo9afgERicpZUzK50XLJYtR
M59pKH6mXgRXaHXOvOgFVq7PvApVgZ9HVSdcFj3uSBLGUVfndvWJ4+2JDK9M
v924GELdO0AQ6Q+fOBYPz5Tz8cp8ypLXRqCTle3ayKuT3xWezLl8OBTZeiU/
8+w3ctPJbBkrB89+LaKFvMxYmIv6v/nX8Pnvgaqn+pn3VEt9i1/9FU89ai01
W57QR3vVJ/S3pRb0eUm3KK89ydLRf4dP6pVPUUZCz3KwyK3YH/W4CM/+3gK+
Ec+9F8qtWFZuRZycb5srvh/HrVuT70dfb0usmGKx6aakYSoqyPX3VaeDb6xX
XN7qFeYLyo4p6xrLjrG5v7jUWTGjuJRcu5gV49EpnoN5jCsZSTHutjOSbMRo
Z9+1R459CR32UK7dcIYSn6Mu6wylWZTbGUsFkU587FFZPYdbNrFx+LrUw5Sx
hLbqNa7OMKGIZMp5PJFozM37Uv6m3HKYZuYa8718/hrReiQouXmg7eTmAURi
prF86Ow7aeZA0rlyW/GXmdl4sQfnbDxktmi1CJeDyQNiBp9o1Nl37ZxKi0JV
TqUUrBnM3HOptOt5KOla6f64iXp8yYG6seqr/ZzKsdyU0dfOqSy5WsqpzHmy
vFWa6PGunDFPdudCnNvlnC+LY+E8sGznyypVqp0vK0b9fNntcqZplTeb/ZwH
5c3mfGncGaWj6k2XHkTK5I750pf2MNT5kTk/Gp7KQ56XH51zP5E450crafqC
8qMX5ZjzoWltSLNElNUllA99LNVWLvpAljxGERmKu3vct5o1HEl6u9DPls+5
+XW2PFrhLZrOZ2k2K1LCPET04SKwyIadvPn8VunZMW++fdMiX+gASvvmAYbV
pQSsuHfhfuh6H7hnYbzzPQvZKrtNvmchj9CKsH0PorpnsTgan5+XGxbSTP+G
RfYD7w3BdxrXACa+Z888oe5KWwZ53czRHSeCIm6kmzmSM52ctVfzAzd1AEP/
09UkXbbp3NTRWks3dTAczHRTBwaymBrrrhBAq5s6gJZ+s2FzJtYwLvhLSSKt
6RK0rIe5vKsUdGuqfW1HflTudtEIGhBI97DCGprTjSpdiwIc7jTrPtcq6tW0
IN/NsltdTmkVAvliFjrp3OlSOw00mEvXx2I73SjLF7qQ02ajM/lDF83KddUu
0sl3wyhd8CztcpMr3ZPz8SZSTHfiNH8Aa7wT51t3Ex2H2aePNnGc6nwvd/He
1aFT7uxNqjt4nlPv4tS3/cKO/wFSlLpK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->319312720]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45060344],

Cell[TextData[{
 "Solution of an anharmonic oscillator ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Phi]", "\[Prime]\[Prime]",
      MultilineFunction->None], "(", "\[CurlyPhi]", ")"}], "\[LongEqual]", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"\[Phi]", "(", "\[CurlyPhi]", ")"}], "3"]}], "-", 
     RowBox[{"\[Phi]", "(", "\[CurlyPhi]", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->527255780],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"k_", ",", "\[CurlyPhi]_"}], "]"}], "=", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{"2", "k"}], 
      RowBox[{"1", "-", 
       RowBox[{"2", "k"}]}]]], 
    SuperscriptBox[
     RowBox[{"JacobiNC", "[", 
      RowBox[{
       RowBox[{
        SqrtBox[
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{"2", "k"}], 
           RowBox[{"1", "-", 
            RowBox[{"2", "k"}]}]]}]], "\[CurlyPhi]"}], ",", "k"}], "]"}], 
     RowBox[{"-", "1"}]]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8357967],

Cell["Plot various solutions:", "ExampleText",
 CellID->1012735069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"\[Phi]", "[", 
       RowBox[{"k", ",", "\[CurlyPhi]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0.1", ",", "0.4", ",", " ", "0.1"}], "}"}]}], "]"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", " ", 
     RowBox[{"12", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223431169],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202000225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->677879269],

Cell[TextData[{
 "Solution of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", " ", 
    SuperscriptBox["\[Phi]", "4"]}], TraditionalForm]], "InlineMath"],
 " field theory wave equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"\[Phi]", "(", 
        RowBox[{"x", ",", "t"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "t"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "t"}]}],
      MultilineFunction->None]}], "-", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"\[Phi]", "(", 
      RowBox[{"x", ",", "t"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[Phi]", "(", 
         RowBox[{"x", ",", "t"}], ")"}], "2"], "-", 
       SuperscriptBox["a", "2"]}], ")"}]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[PartialD]", "2"], 
      RowBox[{"\[Phi]", "(", 
       RowBox[{"x", ",", "t"}], ")"}]}], 
     RowBox[{
      RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
      RowBox[{"\[PartialD]", "x"}]}],
     MultilineFunction->None]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->162548322],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{
   SqrtBox[
    FractionBox[
     RowBox[{"2", "m"}], 
     RowBox[{
      RowBox[{"2", "m"}], "-", "1"}]]], "a", " ", 
   SuperscriptBox[
    RowBox[{"JacobiNC", "[", 
     RowBox[{
      RowBox[{
       SqrtBox[
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Lambda]", " ", 
           SuperscriptBox["a", "2"]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["v", "2"]}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "m"}], "-", "1"}], ")"}]}]]}]], 
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"v", " ", "t"}]}], ")"}]}], ",", "m"}], "]"}], 
    RowBox[{"-", "1"}]]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72158787],

Cell["Plot a solution:", "ExampleText",
 CellID->638105684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"\[Phi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m", "\[Rule]", "0.8"}], ",", 
       RowBox[{"\[Lambda]", "\[Rule]", 
        RowBox[{"-", "0.3"}]}], ",", 
       RowBox[{"m", "\[Rule]", "0.7"}], ",", 
       RowBox[{"v", "\[Rule]", "0.8"}], ",", 
       RowBox[{"a", "\[Rule]", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69120710],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->835331424]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->263],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->60474188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{
     RowBox[{"InverseJacobiNC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiNC", "[", 
    RowBox[{
     RowBox[{"JacobiNC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10346836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiNC", "[", 
    RowBox[{
     RowBox[{"JacobiNC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10689001]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261361129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1002723267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26733726],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->359994467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiNC", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiNC", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "\[Equal]", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68486567],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->609440566],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiNC", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiNC", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210642590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152043587],

Cell["Integrals:", "ExampleText",
 CellID->492528614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38096870],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"JacobiDC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", "m"}]], " ", 
     RowBox[{"JacobiSC", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}]}], "]"}], 
  SqrtBox[
   RowBox[{"1", "-", "m"}]]]], "Output",
 ImageSize->{293, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31020379]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10960],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->185729643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNC", "[", 
  RowBox[{
   RowBox[{"10.", "^", "20"}], ",", "E"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286079947],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.2874900798265365`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314491266]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{
     RowBox[{"10", "^", "20"}], ",", "E"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57974428],

Cell[BoxData[
 RowBox[{"1.24055998316483189318069455134732042527`20.15051499783199", "+", 
  RowBox[{"0``20.056897229846342", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149995204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51763701],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->350342914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"JacobiSC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "2"}], "+", "1", "-", 
   RowBox[{
    RowBox[{"JacobiNC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "2"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307497241],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox[
   RowBox[{"JacobiNC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"JacobiSC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "2"]}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99829337]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiDN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiCD", "[", 
    RowBox[{"u", ",", "m"}], "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15030758],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->228492786]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23683],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiNC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiNC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiND",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiND"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiNS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiNS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCN"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30090]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13901],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->29169]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->48512175],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->418431844]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiNC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 33.5440896}", "context" -> "System`", 
    "keywords" -> {
     "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic function nc", "nc"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiNC[u, m] gives the Jacobi elliptic function nc(u | m).", 
    "synonyms" -> {"Jacobi NC"}, "title" -> "JacobiNC", "type" -> "Symbol", 
    "uri" -> "ref/JacobiNC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6289, 223, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->43192206]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 94315, 2478}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2123, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2746, 79, 45, 1, 70, "ObjectName",
 CellID->8499],
Cell[2794, 82, 675, 22, 70, "Usage",
 CellID->8207]
}, Open  ]],
Cell[CellGroupData[{
Cell[3506, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3984, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4107, 132, 418, 17, 70, "Notes",
 CellID->24065],
Cell[4528, 151, 831, 30, 70, "Notes",
 CellID->17328219],
Cell[5362, 183, 214, 7, 70, "Notes",
 CellID->8656038],
Cell[5579, 192, 248, 8, 70, "Notes",
 CellID->879579261],
Cell[5830, 202, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6051, 211, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6289, 223, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43192206],
Cell[CellGroupData[{
Cell[6673, 237, 147, 5, 70, "ExampleSection",
 CellID->70015958],
Cell[6823, 244, 64, 1, 70, "ExampleText",
 CellID->814676922],
Cell[CellGroupData[{
Cell[6912, 249, 130, 4, 28, "Input",
 CellID->27188654],
Cell[7045, 255, 193, 6, 36, "Output",
 CellID->741701180]
}, Open  ]],
Cell[7253, 264, 125, 3, 70, "ExampleDelimiter",
 CellID->191905672],
Cell[CellGroupData[{
Cell[7403, 271, 291, 10, 28, "Input",
 CellID->12000150],
Cell[7697, 283, 4274, 74, 129, "Output",
 Evaluatable->False,
 CellID->45890747]
}, Open  ]],
Cell[11986, 360, 125, 3, 70, "ExampleDelimiter",
 CellID->390091798],
Cell[12114, 365, 77, 1, 70, "ExampleText",
 CellID->38477304],
Cell[CellGroupData[{
Cell[12216, 370, 245, 8, 70, "Input",
 CellID->200709323],
Cell[12464, 380, 1034, 33, 54, "Output",
 CellID->141529613]
}, Open  ]],
Cell[CellGroupData[{
Cell[13535, 418, 245, 8, 70, "Input",
 CellID->260356113],
Cell[13783, 428, 1065, 33, 51, "Output",
 CellID->330817906]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14897, 467, 216, 7, 70, "ExampleSection",
 CellID->14457],
Cell[15116, 476, 74, 1, 70, "ExampleText",
 CellID->257841689],
Cell[CellGroupData[{
Cell[15215, 481, 177, 6, 70, "Input",
 CellID->325910105],
Cell[15395, 489, 275, 7, 36, "Output",
 CellID->141686347]
}, Open  ]],
Cell[15685, 499, 124, 3, 70, "ExampleDelimiter",
 CellID->25415347],
Cell[15812, 504, 70, 1, 70, "ExampleText",
 CellID->856906711],
Cell[CellGroupData[{
Cell[15907, 509, 207, 7, 70, "Input",
 CellID->69210409],
Cell[16117, 518, 253, 8, 36, "Output",
 CellID->244942290]
}, Open  ]],
Cell[16385, 529, 125, 3, 70, "ExampleDelimiter",
 CellID->200525529],
Cell[16513, 534, 113, 3, 70, "ExampleText",
 CellID->372977787],
Cell[CellGroupData[{
Cell[16651, 541, 171, 5, 70, "Input",
 CellID->2714330],
Cell[16825, 548, 258, 8, 36, "Output",
 CellID->348015721]
}, Open  ]],
Cell[17098, 559, 125, 3, 70, "ExampleDelimiter",
 CellID->182528140],
Cell[17226, 564, 210, 7, 70, "ExampleText",
 CellID->747487832],
Cell[CellGroupData[{
Cell[17461, 575, 178, 6, 70, "Input",
 CellID->536864854],
Cell[17642, 583, 328, 11, 36, "Output",
 CellID->263730872]
}, Open  ]],
Cell[17985, 597, 125, 3, 70, "ExampleDelimiter",
 CellID->259414736],
Cell[18113, 602, 90, 1, 70, "ExampleText",
 CellID->18087730],
Cell[CellGroupData[{
Cell[18228, 607, 237, 8, 70, "Input",
 CellID->365032203],
Cell[18468, 617, 265, 9, 36, "Output",
 CellID->1962788]
}, Open  ]],
Cell[CellGroupData[{
Cell[18770, 631, 420, 15, 70, "Input",
 CellID->175336906],
Cell[19193, 648, 439, 16, 65, "Output",
 CellID->168059281]
}, Open  ]],
Cell[19647, 667, 126, 3, 70, "ExampleText",
 CellID->336727663],
Cell[CellGroupData[{
Cell[19798, 674, 146, 5, 70, "Input",
 CellID->614178488],
Cell[19947, 681, 216, 7, 36, "Output",
 CellID->183078831]
}, Open  ]],
Cell[CellGroupData[{
Cell[20200, 693, 321, 10, 70, "Input",
 CellID->674473773],
Cell[20524, 705, 215, 7, 36, "Output",
 CellID->19247743]
}, Open  ]],
Cell[20754, 715, 125, 3, 70, "ExampleDelimiter",
 CellID->215688415],
Cell[20882, 720, 203, 7, 70, "ExampleText",
 CellID->178560258],
Cell[CellGroupData[{
Cell[21110, 731, 166, 5, 70, "Input",
 CellID->292152639],
Cell[21279, 738, 278, 9, 50, "Output",
 CellID->490776588]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21606, 753, 239, 7, 70, "ExampleSection",
 CellID->23110],
Cell[21848, 762, 209, 7, 70, "ExampleText",
 CellID->541124796],
Cell[CellGroupData[{
Cell[22082, 773, 242, 8, 70, "Input",
 CellID->271512446],
Cell[22327, 783, 1038, 33, 54, "Output",
 CellID->227483242]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23414, 822, 223, 7, 70, "ExampleSection",
 CellID->31209],
Cell[23640, 831, 95, 1, 70, "ExampleText",
 CellID->223864426],
Cell[23738, 834, 1868, 59, 70, "Input",
 CellID->16049754],
Cell[25609, 895, 79, 1, 70, "ExampleText",
 CellID->84846121],
Cell[25691, 898, 1417, 45, 70, "Input",
 CellID->272616709],
Cell[CellGroupData[{
Cell[27133, 947, 868, 28, 70, "Input",
 CellID->126582686],
Cell[28004, 977, 8671, 146, 70, "Output",
 Evaluatable->False,
 CellID->306702117]
}, Open  ]],
Cell[36690, 1126, 124, 3, 70, "ExampleDelimiter",
 CellID->62716298],
Cell[36817, 1131, 82, 1, 70, "ExampleText",
 CellID->301528815],
Cell[36902, 1134, 910, 30, 70, "Input",
 CellID->800229651],
Cell[37815, 1166, 112, 3, 70, "ExampleText",
 CellID->59363360],
Cell[CellGroupData[{
Cell[37952, 1173, 1368, 42, 70, "Input",
 CellID->17288740],
Cell[39323, 1217, 5124, 88, 70, "Output",
 Evaluatable->False,
 CellID->319312720]
}, Open  ]],
Cell[44462, 1308, 124, 3, 70, "ExampleDelimiter",
 CellID->45060344],
Cell[44589, 1313, 489, 16, 70, "ExampleText",
 CellID->527255780],
Cell[45081, 1331, 617, 23, 70, "Input",
 CellID->8357967],
Cell[45701, 1356, 67, 1, 70, "ExampleText",
 CellID->1012735069],
Cell[CellGroupData[{
Cell[45793, 1361, 482, 15, 70, "Input",
 CellID->223431169],
Cell[46278, 1378, 19301, 320, 70, "Output",
 Evaluatable->False,
 CellID->202000225]
}, Open  ]],
Cell[65594, 1701, 125, 3, 70, "ExampleDelimiter",
 CellID->677879269],
Cell[65722, 1706, 1209, 40, 70, "ExampleText",
 CellID->162548322],
Cell[66934, 1748, 862, 31, 70, "Input",
 CellID->72158787],
Cell[67799, 1781, 59, 1, 70, "ExampleText",
 CellID->638105684],
Cell[CellGroupData[{
Cell[67883, 1786, 726, 22, 70, "Input",
 CellID->69120710],
Cell[68612, 1810, 15003, 250, 70, "Output",
 Evaluatable->False,
 CellID->835331424]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83664, 2066, 231, 7, 70, "ExampleSection",
 CellID->263],
Cell[83898, 2075, 73, 1, 70, "ExampleText",
 CellID->60474188],
Cell[CellGroupData[{
Cell[83996, 2080, 380, 12, 70, "Input",
 CellID->10346836],
Cell[84379, 2094, 336, 11, 36, "Output",
 CellID->10689001]
}, Open  ]],
Cell[84730, 2108, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[85001, 2120, 107, 3, 70, "Input",
 CellID->261361129],
Cell[85111, 2125, 204, 7, 36, "Output",
 CellID->1002723267]
}, Open  ]],
Cell[85330, 2135, 124, 3, 70, "ExampleDelimiter",
 CellID->26733726],
Cell[85457, 2140, 75, 1, 70, "ExampleText",
 CellID->359994467],
Cell[CellGroupData[{
Cell[85557, 2145, 364, 13, 70, "Input",
 CellID->68486567],
Cell[85924, 2160, 453, 8, 70, "Message",
 CellID->609440566],
Cell[86380, 2170, 661, 24, 43, "Output",
 CellID->210642590]
}, Open  ]],
Cell[87056, 2197, 125, 3, 70, "ExampleDelimiter",
 CellID->152043587],
Cell[87184, 2202, 53, 1, 70, "ExampleText",
 CellID->492528614],
Cell[CellGroupData[{
Cell[87262, 2207, 193, 6, 70, "Input",
 CellID->38096870],
Cell[87458, 2215, 463, 17, 64, "Output",
 CellID->31020379]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[87970, 2238, 226, 7, 70, "ExampleSection",
 CellID->10960],
Cell[88199, 2247, 118, 3, 70, "ExampleText",
 CellID->185729643],
Cell[CellGroupData[{
Cell[88342, 2254, 154, 5, 70, "Input",
 CellID->286079947],
Cell[88499, 2261, 262, 7, 36, "Output",
 CellID->314491266]
}, Open  ]],
Cell[CellGroupData[{
Cell[88798, 2273, 212, 8, 70, "Input",
 CellID->57974428],
Cell[89013, 2283, 293, 7, 36, "Output",
 CellID->149995204]
}, Open  ]],
Cell[89321, 2293, 124, 3, 70, "ExampleDelimiter",
 CellID->51763701],
Cell[89448, 2298, 130, 4, 70, "ExampleText",
 CellID->350342914],
Cell[CellGroupData[{
Cell[89603, 2306, 314, 11, 70, "Input",
 CellID->307497241],
Cell[89920, 2319, 360, 12, 36, "Output",
 CellID->99829337]
}, Open  ]],
Cell[CellGroupData[{
Cell[90317, 2336, 309, 10, 70, "Input",
 CellID->15030758],
Cell[90629, 2348, 158, 5, 36, "Output",
 CellID->228492786]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90848, 2360, 311, 9, 70, "SeeAlsoSection",
 CellID->23683],
Cell[91162, 2371, 955, 35, 70, "SeeAlso",
 CellID->30090]
}, Open  ]],
Cell[CellGroupData[{
Cell[92154, 2411, 314, 9, 70, "TutorialsSection",
 CellID->13901],
Cell[92471, 2422, 192, 4, 70, "Tutorials",
 CellID->29169]
}, Open  ]],
Cell[CellGroupData[{
Cell[92700, 2431, 318, 9, 70, "MoreAboutSection",
 CellID->48512175],
Cell[93021, 2442, 147, 3, 70, "MoreAbout",
 CellID->418431844]
}, Open  ]],
Cell[93183, 2448, 27, 0, 70, "History"],
Cell[93213, 2450, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

