(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    102890,       2905]
NotebookOptionsPosition[     91906,       2516]
NotebookOutlinePosition[     93210,       2554]
CellTagsIndexPosition[     93124,       2549]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiND" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiND"], "JacobiNC" :> 
          Documentation`HelpLookup["paclet:ref/JacobiNC"], "JacobiNS" :> 
          Documentation`HelpLookup["paclet:ref/JacobiNS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiND\"\>", 
       2->"\<\"JacobiNC\"\>", 3->"\<\"JacobiNS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiND", "ObjectName",
 CellID->30640],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiND",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiND"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"nd", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15805]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"nd", "(", "u", ")"}], "=", 
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        RowBox[{
         SuperscriptBox["sin", "2"], "(", "\[Phi]", ")"}]}]}]]]}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->18725],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"nd", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->154591450],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiND",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiND"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->496066754],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiND",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiND"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9059040],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiND",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiND"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiND",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiND"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->196913683],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->49028589],

Cell["Evaluate numerically:", "ExampleText",
 CellID->76990609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{"4.", ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209198024],

Cell[BoxData["1.0445786639040278`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->896445341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->773415040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{"x", ",", 
     RowBox[{"2", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51460028],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565840468]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293891961],

Cell["Series expansions about the origin:", "ExampleText",
 CellID->650576899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30530267],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["z", "2"]}], "2"], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "m"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"16", " ", "m"}], "-", 
      RowBox[{"76", " ", 
       SuperscriptBox["m", "2"]}], "+", 
      RowBox[{"61", " ", 
       SuperscriptBox["m", "3"]}]}], ")"}], " ", 
    SuperscriptBox["z", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "7"],
    SeriesData[$CellContext`z, 0, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[1, 2] $CellContext`m, 0, 
    Rational[1, 24] ((-4) $CellContext`m + 5 $CellContext`m^2), 0, 
    Rational[1, 720] (16 $CellContext`m - 76 $CellContext`m^2 + 
     61 $CellContext`m^3)}, 0, 7, 1],
  Editable->False]], "Output",
 ImageSize->{398, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->833094429]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63387534],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "z", "]"}], "2"], " ", "m"}], "+", 
   RowBox[{
    FractionBox["1", "32"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", "z", " ", 
       RowBox[{"Cos", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "2"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "4"]}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "z"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "3"],
    SeriesData[$CellContext`m, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
   1, Rational[1, 2] Sin[$CellContext`z]^2, 
    Rational[1, 32] ((-8) $CellContext`z Cos[$CellContext`z] 
      Sin[$CellContext`z] + 5 Sin[$CellContext`z]^2 + 8 Sin[$CellContext`z]^4 + 
     Sin[$CellContext`z] Sin[3 $CellContext`z])}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{570, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270090445]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->776],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->173838922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{
   RowBox[{"2.5", "-", "I"}], ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54319265],

Cell[BoxData[
 RowBox[{"0.9556103328225607`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.20788382805663166`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460027701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4931425],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->773462702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->396024805],

Cell[BoxData["1.\
0349148690167000530969354786359390684177965278586531741874199530365`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99584009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90109144],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->190007974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{"3", ",", "0.33333333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72246360],

Cell[BoxData["1.034914869016700053096935478635939068417796527857`37.\
12837281158047"], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520047655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3330211],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiND",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiND"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->425068119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362982229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.1055943872091933`", ",", "2.178426866957776`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57646871]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->344408209],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->27863076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiND", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226042640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"Cosh", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381699313]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiND", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiND", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150160566],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "m"}], ")"}], 
     RowBox[{"1", "/", "4"}]]], ",", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", "m"}]]]}], "}"}]], "Output",
 ImageSize->{156, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->412462518]
}, Open  ]],

Cell["\<\
Parity transformations and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->163771543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16826860],

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26323128]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"2", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"4", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->284029147],

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->301636932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327547108],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->40852950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiND", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580788833],

Cell[BoxData[
 FormBox[
  RowBox[{"nd", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->155857633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6445],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiND",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiND"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->71074308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "8"}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->627179959],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["m", "2"], " ", 
     SuperscriptBox["x", "4"]}], "24"], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"24", " ", 
       SuperscriptBox["m", "2"]}], "+", 
      RowBox[{"61", " ", 
       SuperscriptBox["m", "3"]}]}], ")"}], " ", 
    SuperscriptBox["x", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"],
    SeriesData[$CellContext`x, 0, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, Rational[1, 2] $CellContext`m, 0, Rational[5, 24] $CellContext`m^2, 
    0, Rational[1, 720] (24 $CellContext`m^2 + 61 $CellContext`m^3)}, 0, 7, 
   1],
  Editable->False]], "Output",
 ImageSize->{293, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311116375]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9795],

Cell["Cartesian coordinates of a pendulum:", "ExampleText",
 CellID->413685466],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "t_", "]"}], "=", 
   RowBox[{"2", "\[ScriptL]", " ", 
    RowBox[{"Sin", "[", 
     FractionBox["\[CurlyPhi]0", "2"], "]"}], 
    RowBox[{
     RowBox[{"JacobiSN", "[", 
      RowBox[{
       RowBox[{"t", 
        SqrtBox[
         FractionBox["g", "\[ScriptL]"]]}], " ", ",", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         FractionBox["\[CurlyPhi]0", "2"], "]"}], "2"]}], "]"}], "/", 
     RowBox[{"JacobiND", "[", 
      RowBox[{
       RowBox[{"t", " ", 
        SqrtBox[
         FractionBox["g", "\[ScriptL]"]]}], " ", ",", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         FractionBox["\[CurlyPhi]0", "2"], "]"}], "2"]}], "]"}]}]}]}], ";", 
  RowBox[{
   RowBox[{"y", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"-", "\[ScriptL]"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "/", " ", 
       RowBox[{
        RowBox[{"JacobiND", "[", 
         RowBox[{
          RowBox[{"t", 
           SqrtBox[
            FractionBox["g", "\[ScriptL]"]]}], ",", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            FractionBox["\[CurlyPhi]0", "2"], "]"}], "2"]}], "]"}], "^", 
        "2"}]}], " ", "-", " ", "1"}], ")"}]}]}], ";", " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740998761],

Cell["\<\
Plot the time\[Hyphen]dependence of the coordinates:\
\>", "ExampleText",
 CellID->574231334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[ScriptL]", "\[Rule]", "1"}], ",", 
       RowBox[{"g", "\[Rule]", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "\[Rule]", 
        RowBox[{"Pi", "/", "4"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70736255],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNW+2LXFcdnuzMvfOS2d3ZyW5e2gr9R8QPolJEih+CH0o+pEtlo9jWmIpG
kIrQQk1RWpQk6EabvtikH6IN0UKE0GBpoCQQGlraQk0xpEJDIaHCYmD83fOc
e557n3tm5u60RYdk9p57zu/9+f3OOfee+cbeA2sPfG/vgX2re+/+2v69D6/t
W/3B3V99aL/dam5pNBqn7f+3dzbsemRX7v/p0cj+Fr/b9t20rrmslV2M3Kcx
Z5fH3YiO9DSzrxbbjUYiI47idhN/ss9c3qzHZ+PWv7PLvmt/fPVfl0+cyy7n
7Wvug9ffWnD3r5z6u3Vx3O2N/9g4I3XjHJ0NmU5nFBPo6tqfDdjqem5ev/HS
/YfOPfbC+UMnnYTW+69efvnBX9u/985exJ3XnjplA06t/eqjd/7pqBLT3gbY
fbtp1yVexshGT+Zlw0xx4WXfmV1VXpuxzI0wDxk/cEpeObhuatglLhq97G5q
Up/f/fNPbtwMF+5+YiaaXLvEhecBhnb5P+Lc34wHsjtBdtfpFGQH8U6nVpCe
Ye6N9b/CgiDdPmcOHDEsOi7twNRadn3snoNZ7CHBwvnifY+D5sM3/2G4AC8D
pwUR9y89e/bC4dNVGbiOysB1RMa1i+8aXuCXrCpkOZsW/uZ+MeGmgqNvmqk+
N1E/zA3mjOzSeTY1pU118Depx+/9aTfPObOVdKasqRzomuYgcxP7IZP9ZrSZ
zn4zwuf0VLl2nfl4NrlqL+W6GDR2FPwEf0KuCUUAPB3i5sIz8jUHcfBV0giN
nP0h5p7eLDCWWW5Dr7OPPmP1gP2QTb03Kx8YrS/fSsrbZy7UlZ/lxdbgrwxf
TiwGeYlAPDWy6mXIzTXKOLREs7Z4rimapaJ5SzRLRfPPSi76De5+VmvWksuI
FJCVhMoEIHreRCl0C+j3vNkGb2QE+61tNmZZAXqDkgGK/cyKVtSnzIq4fFaF
uHxWg5bIU9+0xN64fGZlN+Y7sPe+M8MtxDltFt9U4p5IfNE2B5gbKJPVOxUf
tcSG9HOVq1hQufRNLreArzT4KKRJImhMJDvRZj2Jt8Pc5NusL4lkQyLZ0orK
1zazsZ581su4fLZb0ajQ/gLC6D37IP6J93EMa8U8SURKPLYae41tGXPj5ar3
I3J9jZxFbtH7ivXOGG9hHk4EoaDmXB+ryNXqotWLc368emh1myaf/NoSxabw
i1c38ovL1+rJ8fTeXNixESOQHtalY+bRsD71/YxVUzKjLViJz1vEis5bcfk6
b1Kf+LxJ+cFev4JtSzuODsovYK+4z3VtXdex3RFMoF/XZ5zR5gQjHcmgOYl5
fP0kMS9gXNfZ9eQzJ+LymRPT5LfHe7Fd3BPpTqO4Lyrsl0q7FozpSlyhESt4
5/9JluZTxTMOldx9It10XzvKd2y4H+TJfjfIKu13A2+/3/3ceSdF3tleOplg
ueWjJYvZXHoWYfg7sfb0c989HJ6RmGMMoXiuEZ5inN5/+A8PHzu5+qQln9co
8Cs9J7Fk/OPqL8fxwx0we2HPE+E5SVy3Ii9aNheehhiVMc/Gg++F1z/48d5n
nnjgd08/9dp8nu2+ZmHEj77/5998Z31t9/r16zf7OQ+bncnj0sVrj+z5/S9W
jz556Hycxw/3nwaPq1c/7kf1AA/Tw3jEIzJ0CNjYuL3nvhdNFWs99ODLRnaH
88bJE5fNggyjF6/Z/cad7u437z1+48Yndrlv7dSVNz9sYOyfTl0xKXZpt6zD
3y1y/suZt8fgAlr87ex7P3v0LG6df/X9nxx8xfFIv7X7eTCwz+r9L737zke7
Jo7HGNyHim58E2PG56XTovnIgTMWvlGoe8FaPx7msT/4qLHTsQ709jHrjfzW
rQ30NU0tU460wWe+n7LjGi65tnH9+j3H7NvPb8bCGFHDI4cvPPfsJUox9U0L
9ps+1ib944+ds9CMpzfnWwjYT/nx+XNJvA0pIVp+fIiS72d7e5Se7c3Sl9dI
Q/FZU2zcnvvIbHRJ5NoWYgs0+9luyvjN0k/yIdBLLpZKluvZ5YprG1gMMuyn
j7eLT1rSXhEfTaOHlvkzwOJz+/xZfioWDMQPiWBtRbDWisbhK1/+rQGN/WX6
uWPrbySC8RXBKHZjxaeVULot+uq7COjPbIccZjvkMGPRb0LN5OxyeVTOePQz
40Fv7rcgsJ/VZlnkww59g+ILKs2qaRf1SETPFbEjET2hlwXBQsF+TBCkpx1x
esrfTHyyJvRn/iSCs2Vpp4Iz9DP/Py39OP3dPn9sXjCz0c/M3jYqZzb6mZnL
gjv0hznS0xM3/hlQyPRlkT9J/6Le2h5InFOJM/RgvqSCs+Va9MQJ+s1J5irS
E6ewI69Q+V/VenFUrhZtiS6kssr4/frGbStE7Cc64vREJ/pZxYYiv/CkraIl
cwpcmHPbJIZtwcBQMNQWX4IeK7069NRyLmQgubUFcduEW1sQO5yJnshQ+kk+
1EgwckOJbEfGDyWybYncZuknaWmpbQlOLkT1kqC+I1k1FN/E6Zl10+gnaSmr
gQL+dMXXEfwMo/Rsx+nZVvpJWtL2jvgWUiwcFhT2c8UBKczVevSMzVDkx7Vc
EBx2BSeQwgqE/i998YinHwgO4/ScnzqC0yWhL791gw9l1VHINVAzl9HPXNVV
E/pZueL0nAWUntpVfcg5sSt4gxTOqehnvRtE6Vlv4/TE+0CsmqQl8dIVvC0J
3roS+UxKtsLt1aIjTnO6/gStiI+ecFsUaT3PTXHZE1zqzNoTXA6EfpLPiI+e
REJnxp7gcyCR7gk+69FTfiw7yjNTy72rhjhaQGy4/PMrKyB0SbjkJyrmRPdF
QWm+omwK2p3OreJTkvz0Vhg9xs+MXlFL+zb1cxR1Cz2I7pLQujVWu7h2tG8E
2vuTOdAqcMNYWM0qOhA8zkUpssNsW7K/UevmIxh2/WaP/atgMQ1xtAsYVskD
txJMxMpG5iFwY0aNs5E1WHOlesaoro1SKbN+j+RFQXJxH9IIOhGFC8IvjUUV
sK5kSY5M7NFZzZXn7HYyC4KdHv2wkxUiX/lrNumckdnHU46sCMqvGk3kH2cD
5Ty7lbK2KKHNVj/e71xhlG3lDKAzj1u7lt6uAteaa+Ns5fpQOde1NdMStFwh
d0f5SR+uhjBGVjf0A6YTH6PyGod+YGWCV8t7eeKUmuicWKyd42vovPimL9HR
DEU/194616GfGQl6rt3j9CJ/jJZcO4ML8a35hX6uvRei9GyDnrNRLfoxWtJ3
ffHNvNjeF98sROmZEaDnPN+X2ICelSuupT8dHOr4vOBmXnDVF/zNR+k5Hm2u
mfqSDVF69yRkPUc/dfYo0icgrbzt4zW239f6aL/PeNTAVmwEcxZQqzyHlFEA
UGVUUh4FmFZOprtRnWJ9Y92vPkkEtVdrbL9XaNwTVfq5lL2KMOv3786AMGZ3
r2wZoF7BuYwaw0vPLOvcp7pNscivikBFNOqqCm2ttlxVzUbPbIrSU0tbeXEU
perKdqtIzfqzVZtquzk6qSzUyq/6+xIBrS/grvWHu4Z69Fy1TKOnltl8Ni/4
ATVXNODOOWGhkBHkvll6nQllpqMPvcf7EpEF8TykcC2yIBEDPVc3s9ELPqml
3yeAC2v0oqB2q6B6Ubj2PhP6Mk4LWgIyFbyBC+sM+jnf6k4XUjjfop8VpR69
4JVa+pMEihtw4VoC/fo0QHf7HD8bveC2cCIdwMludgU7i+KfrYI99OvTE6Xn
Lniz9OJPv06OY4frEcXeQLDXm4E+q5EqV7SD2l47rl91d9MVzOp7h55grh49
a6TSi5Z+AQAtuX4dSLsrmEG/vDspYK4evT6h4njREpDxWtL2gfhW8ToQvPZm
otcnLKQXLbFk9aOIHzxJKu8Ii7iBFK53u4K3OD3begZB6ReDlshvXVERO5DE
etkV7CyJ/XF6Yq8r/kU/53elp6b52htVK/58nejrCvr0XElH0Ben1zc1rJhK
X9UT0XR7fasMeEfCOgf+rHPgX34fFqMLbzX8KQ/0sz7mdIOKPsCwPjMHPWfV
2Nu+8DR0Kl35nVKMruon+FDfNIC/vgvVN2v0v76ZG0r84/TytLpArxlCRHYE
sXp6ri0ZMxRE65tKfRMZp9c3maSvehR5j3GsAfE39Kw5Qxmv740/LX0BkdzX
wYwxb8J130Yfb5MYpLXomb36pl3poWv+dC126kv2534XGz9vQL563mCb2JXW
oqfd0+hhR7uADZgQ3fnTGgTZj2LE9QxIKm09IZTORM/xSj+jNXBHBUN6DicR
X+t5rXQmej0HJKu2mtY0pQalIhuy9EwdddczeXp2Ss9W6Zm/OL28vY7Ykr8f
kWzxqyJw0ROMesKNeIIWnPviJyC5ih9L71dVSr80wYrKE7zSWwWsEzCOuy49
a4p+PYsqb1wKc1ScnnPUivDzvzgrv80PVSx/Z1LVHh5ysbIZG+dPOZO3xGvo
54qjVaKjN6EtVzgrEbriyhraVn8Phzka3FjBtwuC/S+qQoagn/N7qxY9ER6n
l3Wv/P6Mq7SmIBX7AeZnU2zfXoueq6g4vcZMTkON+b0Xs7j4/De73CE+aIoP
d4gP9Y3ibPSM4XCC1qwSaOtvAYhD9PPs/04Zj35WjfBbAT8rxelVPuknaU3f
qO8d1zT4ZpRPW7sEl9Pp4O9d4kuli2uJ3ymFioLSg1+0pKEOjfJ6d8dnMHp5
gh7wln2bDdkrC/crnJbdMhPN2eadO6eOs8JUHWdKZOMomydmLcFsjKnYuCuP
u6lp0W58IUdzsb8V+g0adxU4mBRUvIptRyfcbWz5Ly/KwVw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72292735]
}, Open  ]],

Cell["Plot the trajectory:", "ExampleText",
 CellID->61543944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[ScriptL]", "\[Rule]", "1"}], ",", 
       RowBox[{"g", "\[Rule]", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "\[Rule]", 
        RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112567201],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18928870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111921390],

Cell[TextData[{
 "Periodic solution of the nonlinear Schr\[ODoubleDot]dinger equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", 
     FractionBox[
      RowBox[{"\[PartialD]", 
       RowBox[{"\[Psi]", "(", 
        RowBox[{"x", ",", "t"}], ")"}]}], 
      RowBox[{"\[PartialD]", "t"}],
      MultilineFunction->None]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"\[Psi]", "(", 
       RowBox[{"x", ",", "t"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"\[LeftBracketingBar]", 
        RowBox[{"\[Psi]", "(", 
         RowBox[{"x", ",", "t"}], ")"}], "\[RightBracketingBar]"}], "2"]}], 
     "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"\[Psi]", "(", 
        RowBox[{"x", ",", "t"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "x"}]}],
      MultilineFunction->None]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->454430028],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"r", " ", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"I", " ", "p", " ", "x"}], " ", "-", 
      RowBox[{"I", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"k", "^", "2"}]}], ")"}], " ", 
          RowBox[{"r", "^", "2"}]}]}], ")"}], " ", "t"}]}], "]"}], "/", 
    RowBox[{"JacobiND", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"r", " ", "x"}], "-", 
       RowBox[{"2", " ", "p", " ", "r", " ", "t"}]}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85598859],

Cell["Check the solution numerically:", "ExampleText",
 CellID->243072841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"I", " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "\[Equal]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"\[Psi]", "[", 
      RowBox[{"x", ",", "t"}], "]"}], " ", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"x", ",", "t"}], "]"}], "]"}], "^", "2"}]}], "-", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}]}], "/.", 
  
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1", "/", "3`50"}]}], ",", 
    RowBox[{"t", "\[Rule]", "1"}], ",", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"1", "/", "3"}]}], ",", 
    RowBox[{"r", "\[Rule]", "2"}], ",", 
    RowBox[{"p", "\[Rule]", 
     RowBox[{"1", "/", "3"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->547462835],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->382403180]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->13140881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"x", ",", "t"}], "]"}], "]"}], "^", "2"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "\[Rule]", "2"}], ",", 
       RowBox[{"p", "\[Rule]", 
        RowBox[{"1", "/", "3"}]}], ",", 
       RowBox[{"k", "\[Rule]", 
        RowBox[{"1", "/", "2"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11874055],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127692571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5648689],

Cell["Parametrize a lemniscate by arc length:", "ExampleText",
 CellID->134109120],

Cell[BoxData[
 RowBox[{
  RowBox[{"lemniscate", "[", "s_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"JacobiCN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], "/", 
     RowBox[{"JacobiND", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"JacobiCN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], 
     RowBox[{
      RowBox[{"JacobiSN", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->322057732],

Cell["\<\
Show arc length parametrization and classical parametrization:\
\>", "ExampleText",
 CellID->202525521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "\[Theta]_", "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], ">", "0"}], ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], "]"}], ",", "0"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"lemniscate", "[", "s", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "/", "4"}], "]"}], "^", "2"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", "Pi"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->977705893],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->78504850]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127122352],

Cell["\<\
Zero modes of the periodic supersymmetric partner potentials:\
\>", "ExampleText",
 CellID->966734789],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["V", "+"], "[", "z_", "]"}], ":=", 
  RowBox[{"2", "-", "m", "+", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"m", "-", "1"}], ")"}], 
    SuperscriptBox[
     RowBox[{"JacobiND", "[", 
      RowBox[{"z", ",", "m"}], "]"}], "2"]}]}]}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Psi]", "+"], "[", "z_", "]"}], ":=", 
  RowBox[{"JacobiND", "[", 
   RowBox[{"z", ",", "m"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->284388406],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["V", "-"], "[", "z_", "]"}], ":=", 
  RowBox[{"2", "-", "m", "-", 
   RowBox[{"2", 
    SuperscriptBox[
     RowBox[{"JacobiND", "[", 
      RowBox[{"z", ",", "m"}], "]"}], 
     RowBox[{"-", "2"}]]}]}]}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Psi]", "-"], "[", "z_", "]"}], ":=", 
  SuperscriptBox[
   RowBox[{"JacobiND", "[", 
    RowBox[{"z", ",", "m"}], "]"}], 
   RowBox[{"-", "1"}]]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->459433494],

Cell["Check the solutions:", "ExampleText",
 CellID->11270286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Psi]", "+"], "[", "z", "]"}], ",", "z", ",", "z"}], 
        "]"}]}], "+", 
      RowBox[{
       RowBox[{
        SubscriptBox["V", "+"], "[", "z", "]"}], 
       RowBox[{
        SubscriptBox["\[Psi]", "+"], "[", "z", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Psi]", "-"], "[", "z", "]"}], ",", "z", ",", "z"}], 
        "]"}]}], "+", 
      RowBox[{
       RowBox[{
        SubscriptBox["V", "-"], "[", "z", "]"}], 
       RowBox[{
        SubscriptBox["\[Psi]", "-"], "[", "z", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->207269448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "13"],
    SeriesData[$CellContext`z, 0, {}, 13, 13, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "13"],
    SeriesData[$CellContext`z, 0, {}, 13, 13, 1],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{107, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->582994318]
}, Open  ]],

Cell["Plot the zero modes:", "ExampleText",
 CellID->567907358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["V", "+"], "[", "z", "]"}], ",", 
         RowBox[{
          SubscriptBox["\[Psi]", "+"], "[", "z", "]"}]}], "}"}], "/.", 
       RowBox[{"m", "\[Rule]", 
        RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["V", "-"], "[", "z", "]"}], ",", 
         RowBox[{
          SubscriptBox["\[Psi]", "-"], "[", "z", "]"}]}], "}"}], "/.", 
       RowBox[{"m", "\[Rule]", 
        RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->177801083],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->242507914]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21198],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->38733992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{
     RowBox[{"InverseJacobiND", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiND", "[", 
    RowBox[{
     RowBox[{"JacobiND", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91105571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiND", "[", 
    RowBox[{
     RowBox[{"JacobiND", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41693786]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29056615],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136154763]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13124148],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->174253363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiND", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"3", 
      RowBox[{"JacobiND", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135344533],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->179721877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiND", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiND", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{302, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11890594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50397331],

Cell["Integrals:", "ExampleText",
 CellID->431065787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502017555],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"ArcCos", "[", 
    RowBox[{"JacobiCD", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "]"}], " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"JacobiCD", "[", 
       RowBox[{"z", ",", "m"}], "]"}], "2"]}]], " ", 
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "m"}], ")"}], " ", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}]]], "Output",
 ImageSize->{400, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->728875308]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"JacobiND", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "2"}], ",", " ", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17456227],

Cell[BoxData[
 FractionBox[
  RowBox[{
   FractionBox[
    RowBox[{"m", " ", 
     RowBox[{"JacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], " ", 
     RowBox[{"JacobiSN", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}], 
    RowBox[{"JacobiDN", "[", 
     RowBox[{"z", ",", "m"}], "]"}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"JacobiAmplitude", "[", 
        RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], " ", 
     RowBox[{"JacobiDN", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}], 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"JacobiSN", "[", 
         RowBox[{"z", ",", "m"}], "]"}], "2"]}]}]]]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "m"}]]], "Output",
 ImageSize->{406, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183963842]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8340],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->93054834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiND", "[", 
  RowBox[{
   RowBox[{"10.", "^", "15"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179876951],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3.0938679621991296`"}], "+", 
  RowBox[{"7.26415455565288`*^-16", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58075655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{
     RowBox[{"10", "^", "15"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145974042],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "5.43557022894356301145141409337877622026`20.15051499783199"}],
   "+", 
  RowBox[{"0``19.415269886522246", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->900252170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25780883],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->462276132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", 
   RowBox[{"m", " ", 
    RowBox[{
     RowBox[{"JacobiSD", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "^", "2"}]}], "-", 
   RowBox[{
    RowBox[{"JacobiND", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "^", "2"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378012421],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox[
   RowBox[{"JacobiND", "[", 
    RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
  RowBox[{"m", " ", 
   SuperscriptBox[
    RowBox[{"JacobiSD", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"]}]}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37648307]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiND", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiDS", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"u", ",", "m"}], "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72520131],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28734622]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22810],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiND",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiND"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiNC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiNC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiNS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiNS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13207]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12657],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->12149]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->127102146],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->187848387]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiND - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 34.5597406}", "context" -> "System`", 
    "keywords" -> {
     "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic function nd", "nd"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiND[u, m] gives the Jacobi elliptic function nd(u | m).", 
    "synonyms" -> {"Jacobi ND"}, "title" -> "JacobiND", "type" -> "Symbol", 
    "uri" -> "ref/JacobiND"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6299, 225, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->196913683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 92981, 2542}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2018, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2641, 77, 46, 1, 70, "ObjectName",
 CellID->30640],
Cell[2690, 80, 676, 22, 70, "Usage",
 CellID->15805]
}, Open  ]],
Cell[CellGroupData[{
Cell[3403, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3881, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4004, 130, 523, 21, 70, "Notes",
 CellID->18725],
Cell[4530, 153, 839, 30, 70, "Notes",
 CellID->154591450],
Cell[5372, 185, 216, 7, 70, "Notes",
 CellID->496066754],
Cell[5591, 194, 246, 8, 70, "Notes",
 CellID->9059040],
Cell[5840, 204, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6061, 213, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6299, 225, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->196913683],
Cell[CellGroupData[{
Cell[6684, 239, 147, 5, 70, "ExampleSection",
 CellID->49028589],
Cell[6834, 246, 63, 1, 70, "ExampleText",
 CellID->76990609],
Cell[CellGroupData[{
Cell[6922, 251, 152, 5, 28, "Input",
 CellID->209198024],
Cell[7077, 258, 176, 5, 36, "Output",
 CellID->896445341]
}, Open  ]],
Cell[7268, 266, 125, 3, 70, "ExampleDelimiter",
 CellID->773415040],
Cell[CellGroupData[{
Cell[7418, 273, 289, 10, 28, "Input",
 CellID->51460028],
Cell[7710, 285, 4966, 85, 172, "Output",
 Evaluatable->False,
 CellID->565840468]
}, Open  ]],
Cell[12691, 373, 125, 3, 70, "ExampleDelimiter",
 CellID->293891961],
Cell[12819, 378, 78, 1, 70, "ExampleText",
 CellID->650576899],
Cell[CellGroupData[{
Cell[12922, 383, 244, 8, 70, "Input",
 CellID->30530267],
Cell[13169, 393, 1253, 40, 54, "Output",
 CellID->833094429]
}, Open  ]],
Cell[CellGroupData[{
Cell[14459, 438, 244, 8, 70, "Input",
 CellID->63387534],
Cell[14706, 448, 1394, 41, 51, "Output",
 CellID->270090445]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16149, 495, 214, 7, 70, "ExampleSection",
 CellID->776],
Cell[16366, 504, 74, 1, 70, "ExampleText",
 CellID->173838922],
Cell[CellGroupData[{
Cell[16465, 509, 176, 6, 70, "Input",
 CellID->54319265],
Cell[16644, 517, 274, 7, 36, "Output",
 CellID->460027701]
}, Open  ]],
Cell[16933, 527, 123, 3, 70, "ExampleDelimiter",
 CellID->4931425],
Cell[17059, 532, 70, 1, 70, "ExampleText",
 CellID->773462702],
Cell[CellGroupData[{
Cell[17154, 537, 208, 7, 70, "Input",
 CellID->396024805],
Cell[17365, 546, 234, 7, 36, "Output",
 CellID->99584009]
}, Open  ]],
Cell[17614, 556, 124, 3, 70, "ExampleDelimiter",
 CellID->90109144],
Cell[17741, 561, 113, 3, 70, "ExampleText",
 CellID->190007974],
Cell[CellGroupData[{
Cell[17879, 568, 168, 5, 70, "Input",
 CellID->72246360],
Cell[18050, 575, 228, 6, 36, "Output",
 CellID->520047655]
}, Open  ]],
Cell[18293, 584, 123, 3, 70, "ExampleDelimiter",
 CellID->3330211],
Cell[18419, 589, 218, 7, 70, "ExampleText",
 CellID->425068119],
Cell[CellGroupData[{
Cell[18662, 600, 180, 6, 70, "Input",
 CellID->362982229],
Cell[18845, 608, 240, 8, 36, "Output",
 CellID->57646871]
}, Open  ]],
Cell[19100, 619, 125, 3, 70, "ExampleDelimiter",
 CellID->344408209],
Cell[19228, 624, 90, 1, 70, "ExampleText",
 CellID->27863076],
Cell[CellGroupData[{
Cell[19343, 629, 237, 8, 70, "Input",
 CellID->226042640],
Cell[19583, 639, 235, 8, 36, "Output",
 CellID->381699313]
}, Open  ]],
Cell[CellGroupData[{
Cell[19855, 652, 420, 15, 70, "Input",
 CellID->150160566],
Cell[20278, 669, 403, 15, 55, "Output",
 CellID->412462518]
}, Open  ]],
Cell[20696, 687, 126, 3, 70, "ExampleText",
 CellID->163771543],
Cell[CellGroupData[{
Cell[20847, 694, 145, 5, 70, "Input",
 CellID->16826860],
Cell[20995, 701, 215, 7, 36, "Output",
 CellID->26323128]
}, Open  ]],
Cell[CellGroupData[{
Cell[21247, 713, 321, 10, 70, "Input",
 CellID->284029147],
Cell[21571, 725, 216, 7, 36, "Output",
 CellID->301636932]
}, Open  ]],
Cell[21802, 735, 125, 3, 70, "ExampleDelimiter",
 CellID->327547108],
Cell[21930, 740, 202, 7, 70, "ExampleText",
 CellID->40852950],
Cell[CellGroupData[{
Cell[22157, 751, 166, 5, 70, "Input",
 CellID->580788833],
Cell[22326, 758, 278, 9, 50, "Output",
 CellID->155857633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22653, 773, 238, 7, 70, "ExampleSection",
 CellID->6445],
Cell[22894, 782, 210, 7, 70, "ExampleText",
 CellID->71074308],
Cell[CellGroupData[{
Cell[23129, 793, 242, 8, 70, "Input",
 CellID->627179959],
Cell[23374, 803, 1033, 33, 54, "Output",
 CellID->311116375]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24456, 842, 222, 7, 70, "ExampleSection",
 CellID->9795],
Cell[24681, 851, 79, 1, 70, "ExampleText",
 CellID->413685466],
Cell[24763, 854, 1301, 42, 70, "Input",
 CellID->740998761],
Cell[26067, 898, 103, 3, 70, "ExampleText",
 CellID->574231334],
Cell[CellGroupData[{
Cell[26195, 905, 581, 18, 70, "Input",
 CellID->70736255],
Cell[26779, 925, 5079, 87, 70, "Output",
 Evaluatable->False,
 CellID->72292735]
}, Open  ]],
Cell[31873, 1015, 62, 1, 70, "ExampleText",
 CellID->61543944],
Cell[CellGroupData[{
Cell[31960, 1020, 592, 18, 70, "Input",
 CellID->112567201],
Cell[32555, 1040, 2720, 49, 70, "Output",
 Evaluatable->False,
 CellID->18928870]
}, Open  ]],
Cell[35290, 1092, 125, 3, 70, "ExampleDelimiter",
 CellID->111921390],
Cell[35418, 1097, 1055, 33, 70, "ExampleText",
 CellID->454430028],
Cell[36476, 1132, 767, 25, 70, "Input",
 CellID->85598859],
Cell[37246, 1159, 74, 1, 70, "ExampleText",
 CellID->243072841],
Cell[CellGroupData[{
Cell[37345, 1164, 985, 33, 70, "Input",
 CellID->547462835],
Cell[38333, 1199, 161, 5, 36, "Output",
 CellID->382403180]
}, Open  ]],
Cell[38509, 1207, 60, 1, 70, "ExampleText",
 CellID->13140881],
Cell[CellGroupData[{
Cell[38594, 1212, 685, 22, 70, "Input",
 CellID->11874055],
Cell[39282, 1236, 22974, 381, 70, "Output",
 Evaluatable->False,
 CellID->127692571]
}, Open  ]],
Cell[62271, 1620, 123, 3, 70, "ExampleDelimiter",
 CellID->5648689],
Cell[62397, 1625, 82, 1, 70, "ExampleText",
 CellID->134109120],
Cell[62482, 1628, 901, 30, 70, "Input",
 CellID->322057732],
Cell[63386, 1660, 113, 3, 70, "ExampleText",
 CellID->202525521],
Cell[CellGroupData[{
Cell[63524, 1667, 1369, 42, 70, "Input",
 CellID->977705893],
Cell[64896, 1711, 5123, 88, 70, "Output",
 Evaluatable->False,
 CellID->78504850]
}, Open  ]],
Cell[70034, 1802, 125, 3, 70, "ExampleDelimiter",
 CellID->127122352],
Cell[70162, 1807, 112, 3, 70, "ExampleText",
 CellID->966734789],
Cell[70277, 1812, 496, 17, 70, "Input",
 CellID->284388406],
Cell[70776, 1831, 506, 18, 70, "Input",
 CellID->459433494],
Cell[71285, 1851, 62, 1, 70, "ExampleText",
 CellID->11270286],
Cell[CellGroupData[{
Cell[71372, 1856, 930, 32, 70, "Input",
 CellID->207269448],
Cell[72305, 1890, 508, 17, 39, "Output",
 CellID->582994318]
}, Open  ]],
Cell[72828, 1910, 63, 1, 70, "ExampleText",
 CellID->567907358],
Cell[CellGroupData[{
Cell[72916, 1915, 1070, 35, 70, "Input",
 CellID->177801083],
Cell[73989, 1952, 6853, 116, 70, "Output",
 Evaluatable->False,
 CellID->242507914]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80891, 2074, 233, 7, 70, "ExampleSection",
 CellID->21198],
Cell[81127, 2083, 73, 1, 70, "ExampleText",
 CellID->38733992],
Cell[CellGroupData[{
Cell[81225, 2088, 380, 12, 70, "Input",
 CellID->91105571],
Cell[81608, 2102, 336, 11, 36, "Output",
 CellID->41693786]
}, Open  ]],
Cell[81959, 2116, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[82230, 2128, 106, 3, 70, "Input",
 CellID->29056615],
Cell[82339, 2133, 203, 7, 36, "Output",
 CellID->136154763]
}, Open  ]],
Cell[82557, 2143, 124, 3, 70, "ExampleDelimiter",
 CellID->13124148],
Cell[82684, 2148, 75, 1, 70, "ExampleText",
 CellID->174253363],
Cell[CellGroupData[{
Cell[82784, 2153, 359, 13, 70, "Input",
 CellID->135344533],
Cell[83146, 2168, 453, 8, 70, "Message",
 CellID->179721877],
Cell[83602, 2178, 916, 33, 81, "Output",
 CellID->11890594]
}, Open  ]],
Cell[84533, 2214, 124, 3, 70, "ExampleDelimiter",
 CellID->50397331],
Cell[84660, 2219, 53, 1, 70, "ExampleText",
 CellID->431065787],
Cell[CellGroupData[{
Cell[84738, 2224, 194, 6, 70, "Input",
 CellID->502017555],
Cell[84935, 2232, 635, 22, 63, "Output",
 CellID->728875308]
}, Open  ]],
Cell[CellGroupData[{
Cell[85607, 2259, 222, 8, 70, "Input",
 CellID->17456227],
Cell[85832, 2269, 915, 31, 68, "Output",
 CellID->183963842]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86796, 2306, 225, 7, 70, "ExampleSection",
 CellID->8340],
Cell[87024, 2315, 117, 3, 70, "ExampleText",
 CellID->93054834],
Cell[CellGroupData[{
Cell[87166, 2322, 155, 5, 70, "Input",
 CellID->179876951],
Cell[87324, 2329, 272, 8, 36, "Output",
 CellID->58075655]
}, Open  ]],
Cell[CellGroupData[{
Cell[87633, 2342, 214, 8, 70, "Input",
 CellID->145974042],
Cell[87850, 2352, 314, 9, 36, "Output",
 CellID->900252170]
}, Open  ]],
Cell[88179, 2364, 124, 3, 70, "ExampleDelimiter",
 CellID->25780883],
Cell[88306, 2369, 130, 4, 70, "ExampleText",
 CellID->462276132],
Cell[CellGroupData[{
Cell[88461, 2377, 341, 12, 70, "Input",
 CellID->378012421],
Cell[88805, 2391, 386, 13, 36, "Output",
 CellID->37648307]
}, Open  ]],
Cell[CellGroupData[{
Cell[89228, 2409, 309, 10, 70, "Input",
 CellID->72520131],
Cell[89540, 2421, 157, 5, 36, "Output",
 CellID->28734622]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[89758, 2433, 311, 9, 70, "SeeAlsoSection",
 CellID->22810],
Cell[90072, 2444, 710, 26, 70, "SeeAlso",
 CellID->13207]
}, Open  ]],
Cell[CellGroupData[{
Cell[90819, 2475, 314, 9, 70, "TutorialsSection",
 CellID->12657],
Cell[91136, 2486, 192, 4, 70, "Tutorials",
 CellID->12149]
}, Open  ]],
Cell[CellGroupData[{
Cell[91365, 2495, 319, 9, 70, "MoreAboutSection",
 CellID->127102146],
Cell[91687, 2506, 147, 3, 70, "MoreAbout",
 CellID->187848387]
}, Open  ]],
Cell[91849, 2512, 27, 0, 70, "History"],
Cell[91879, 2514, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

