(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     80450,       2428]
NotebookOptionsPosition[     69677,       2046]
NotebookOutlinePosition[     70981,       2084]
CellTagsIndexPosition[     70895,       2079]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiNS" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiNS"], "JacobiNC" :> 
          Documentation`HelpLookup["paclet:ref/JacobiNC"], "JacobiND" :> 
          Documentation`HelpLookup["paclet:ref/JacobiND"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiNS\"\>", 
       2->"\<\"JacobiNC\"\>", 3->"\<\"JacobiND\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiNS", "ObjectName",
 CellID->8805],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiNS",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiNS"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"ns", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"ns", "(", "u", ")"}], "=", 
    FractionBox["1", 
     RowBox[{"sin", "(", "\[Phi]", ")"}]]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->23247],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"ns", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->54696440],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNS"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->93074778],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNS"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->342715226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNS"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNS"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->606229111],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->12415102],

Cell["Evaluate numerically:", "ExampleText",
 CellID->27705717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{"2.5", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110961154],

Cell[BoxData["1.122819387340312`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86722644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168566607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24633561],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23412339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71743901],

Cell["Series expansions about the origin:", "ExampleText",
 CellID->175072069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7816907],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "z"], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "m"}], ")"}], " ", "z"}], "+", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      RowBox[{"22", " ", "m"}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"31", "-", 
       RowBox[{"15", " ", "m"}], "-", 
       RowBox[{"15", " ", 
        SuperscriptBox["m", "2"]}], "+", 
       RowBox[{"31", " ", 
        SuperscriptBox["m", "3"]}]}], ")"}], " ", 
     SuperscriptBox["z", "5"]}], "15120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "8"],
    SeriesData[$CellContext`z, 0, {}, -1, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[1, 6] (1 + $CellContext`m), 0, 
    Rational[1, 360] (7 - 22 $CellContext`m + 7 $CellContext`m^2), 0, 
    Rational[1, 15120] (31 - 15 $CellContext`m - 15 $CellContext`m^2 + 
     31 $CellContext`m^3)}, -1, 8, 1],
  Editable->False]], "Output",
 ImageSize->{469, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->866063048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->565039078],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Csc", "[", "z", "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "4"], " ", "z", " ", 
       RowBox[{"Cot", "[", "z", "]"}], " ", 
       RowBox[{"Csc", "[", "z", "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"Cot", "[", "z", "]"}], " ", 
       RowBox[{"Csc", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Csc[$CellContext`z], 
    Rational[1, 4] $CellContext`z Cot[$CellContext`z] Csc[$CellContext`z] + 
    Rational[-1, 8] Cot[$CellContext`z] Csc[$CellContext`z] 
     Sin[2 $CellContext`z]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{409, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->860104461]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2517],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->257841689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325910105],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.12697805901789744`"}], "-", 
  RowBox[{"1.4443922419325221`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182384296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25415347],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->856906711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69210409],

Cell[BoxData["1.\
0242652716440764002753329012530130171133796832794609597474302848837`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13480914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200525529],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->372977787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{"2", ",", "0.333333333333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2714330],

Cell[BoxData["1.0242652716440764002753329012530130171133796832794609597471`40.\
94048297880807"], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168320924]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182528140],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNS"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->747487832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->536864854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38081932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259414736],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->276511220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365032203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Csc", "[", "z", "]"}], ",", 
   RowBox[{"Coth", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155116330]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175336906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ComplexInfinity", ",", 
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"1", "-", "m"}]]}]], ",", "1"}], "}"}]], "Output",
 ImageSize->{235, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219454824]
}, Open  ]],

Cell["\<\
Parity transformation and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->691227904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->79128576],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"JacobiNS", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->105215898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"4", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"2", " ", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23662150],

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->234400226]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215688415],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->178560258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiNS", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292152639],

Cell[BoxData[
 FormBox[
  RowBox[{"ns", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->112997365]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20568],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiNS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiNS"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->541124796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "x", "]"}], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271512446],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "+", 
   FractionBox[
    RowBox[{"m", " ", "x"}], "6"], "+", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", "m"}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"92", "-", 
       RowBox[{"39", " ", "m"}], "+", 
       RowBox[{"21", " ", 
        SuperscriptBox["m", "2"]}]}], ")"}], " ", 
     SuperscriptBox["x", "5"]}], "2160"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, -1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, Rational[1, 6] $CellContext`m, 0, 
    Rational[1, 360] ((-12) $CellContext`m + 7 $CellContext`m^2), 0, 
    Rational[1, 2160] (92 - 39 $CellContext`m + 21 $CellContext`m^2)}, -1, 6, 
   1],
  Editable->False]], "Output",
 ImageSize->{372, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->489998026]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30598],

Cell["\<\
Map a rectangle conformally onto the lower half\[Hyphen]plane:\
\>", "ExampleText",
 CellID->243016522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "24"}], ",", 
     RowBox[{"m", "=", "0.3"}], ",", "p"}], "}"}], ",", 
   RowBox[{
    RowBox[{"p", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", 
             RowBox[{"j", "/", "n"}]}], "-", "1"}], ")"}], 
          RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
         RowBox[{
          RowBox[{"k", "/", "n"}], " ", "I", " ", 
          RowBox[{"EllipticK", "[", 
           RowBox[{"1", "-", "m"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "0", ",", "n"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}]}], ";", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", "#", "]"}], ",", 
             RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
         "p"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", "#", "]"}], ",", 
             RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
         RowBox[{"JacobiNS", "[", 
          RowBox[{"p", ",", "m"}], "]"}]}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419126679],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 198},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->518178109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45086770],

Cell["Solution of the pendulum equation:", "ExampleText",
 CellID->31743841],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"t_", ",", "\[Phi]_"}], "]"}], "=", 
   RowBox[{"2", " ", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"\[Phi]", "/", "2"}], "]"}], " ", "/", 
      RowBox[{"JacobiNS", "[", 
       RowBox[{"t", ",", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"\[Phi]", "/", "2"}], "]"}], "^", "2"}]}], "]"}]}], 
     "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29058975],

Cell["Check the solution:", "ExampleText",
 CellID->764811467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"t", ",", "2"}], "]"}], ",", "t", ",", "t"}], "]"}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"t", ",", "2"}], "]"}], "]"}]}], "/.", 
  RowBox[{"t", "\[Rule]", 
   RowBox[{"N", "[", 
    RowBox[{"2", ",", "100"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11685600],

Cell[BoxData["0``97.27323618325153"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->264389432]
}, Open  ]],

Cell["Plot solutions:", "ExampleText",
 CellID->3891738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"t", ",", 
       RowBox[{"Pi", "/", "3"}]}], "]"}], ",", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"t", ",", 
       RowBox[{"Pi", "/", "2"}]}], "]"}], ",", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"99", "/", "100"}], " ", "Pi"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->278565811],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->475825320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->545851040],

Cell["\<\
Closed form of iterates of the Katsura\[Dash]Fukuda map:\
\>", "ExampleText",
 CellID->260673715],

Cell[BoxData[
 RowBox[{
  RowBox[{"xn", "[", 
   RowBox[{"n_", ",", "x0_", ",", "\[Lambda]_"}], "]"}], ":=", 
  SuperscriptBox[
   RowBox[{"JacobiNS", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["2", "n"], 
      RowBox[{"InverseJacobiSN", "[", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox["x0"]}], ",", "\[Lambda]"}], "]"}]}], ",", "\[Lambda]"}], 
    "]"}], 
   RowBox[{"-", "2"}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66124812],

Cell["Compare the closed form with explicit iterations:", "ExampleText",
 CellID->180760932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"xn", "[", 
     RowBox[{"n", ",", 
      RowBox[{"2", "/", "3"}], ",", 
      RowBox[{"3", "/", "7"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", " ", "6"}], "}"}]}], "]"}], " ", "//", 
  "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->566805796],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6666666666666666`", ",", "0.9688581314878887`", ",", 
   "0.19755067898006204`", ",", "0.6003256341355914`", ",", 
   "0.9970148110751031`", ",", "0.020695114388651223`", ",", 
   "0.08037779772502471`"}], "}"}]], "Output",
 ImageSize->{492, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94652325]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x0", "=", 
       RowBox[{"2", "/", "3"}]}], ",", 
      RowBox[{"\[Lambda]", "=", 
       RowBox[{"3", "/", "7"}]}]}], "}"}], ",", 
    RowBox[{"NestList", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"4", " ", "#", 
         RowBox[{"(", 
          RowBox[{"1", "-", "#"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Lambda]", "#"}]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Lambda]", " ", 
            SuperscriptBox["#", "2"]}]}], ")"}], "2"]], "&"}], ",", " ", "x0",
       ",", "6"}], "]"}]}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->802831686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6666666666666666`", ",", "0.9688581314878892`", ",", 
   "0.19755067898006198`", ",", "0.6003256341355913`", ",", 
   "0.9970148110751033`", ",", "0.020695114388650567`", ",", 
   "0.08037779772502222`"}], "}"}]], "Output",
 ImageSize->{492, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->154213273]
}, Open  ]],

Cell["Plot a few hundred iterates:", "ExampleText",
 CellID->385278230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"xn", "[", 
     RowBox[{"n", ",", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"1", "/", "5"}], ",", "100"}], "]"}], ",", 
      RowBox[{"2", "/", "3"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "250"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->63374752],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->232436556]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28797027],

Cell[TextData[{
 "Solution of the sinh\[Hyphen]Gordon equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "t"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "t"}]}],
      MultilineFunction->None], "+", 
     RowBox[{"sinh", "(", 
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "t"}], ")"}], ")"}]}], "\[LongEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->859664573],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", " ", "t_"}], "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{"ArcCosh", "[", 
    RowBox[{"JacobiNS", "[", 
     RowBox[{
      RowBox[{"x", "-", "t"}], ",", "m"}], "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->697372184],

Cell["Check the solution:", "ExampleText",
 CellID->123023636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "t"}], "]"}], "+", 
    RowBox[{"Sinh", "[", 
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"JacobiNS", "[", 
       RowBox[{
        RowBox[{"t", "-", "x"}], ",", "m"}], "]"}], "^", "2"}], "-", 
     RowBox[{
      RowBox[{"JacobiCS", "[", 
       RowBox[{
        RowBox[{"t", "-", "x"}], ",", "m"}], "]"}], "^", "2"}]}], "==", 
    "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107585666],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50352514]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->93628833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], "/.", 
      RowBox[{"m", "\[Rule]", 
       RowBox[{"2.5", "I"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2.2"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->285856041],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->256027432]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13636],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->60474188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{
     RowBox[{"InverseJacobiNS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{
     RowBox[{"JacobiNS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10346836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiNS", "[", 
    RowBox[{
     RowBox[{"JacobiNS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27401250]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261361129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159776661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26733726],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->359994467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiNS", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiNS", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68486567],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->230689891],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiNS", "[", 
       RowBox[{
        RowBox[{"1", "-", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiNS", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344459339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152043587],

Cell["Integrals:", "ExampleText",
 CellID->492528614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38096870],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"JacobiCS", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], "+", 
   RowBox[{"JacobiDS", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], "]"}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->447633887]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10191],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->185729643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiNS", "[", 
  RowBox[{
   RowBox[{"10.", "^", "16"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286079947],

Cell[BoxData[
 RowBox[{"0.0060868616731951375`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.9983056131381748`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310150062]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiNS", "[", 
    RowBox[{
     RowBox[{"10", "^", "16"}], ",", "3"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57974428],

Cell[BoxData[
 RowBox[{"2.16326836805962191334319689632167497026`20.150514997831987", "+", 
  RowBox[{"0``19.81540459788543", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144296650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51763701],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->350342914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"JacobiCS", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "2"}], "-", 
   RowBox[{
    RowBox[{"JacobiNS", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "2"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307497241],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox[
   RowBox[{"JacobiCS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "2"], "-", 
  SuperscriptBox[
   RowBox[{"JacobiNS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "2"]}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305686658]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiND", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiDS", "[", 
    RowBox[{"u", ",", "m"}], "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15030758],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278838587]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21030],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiNS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiNS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiNC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiNC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiND",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiND"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5784],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->18790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->17428502],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->153244750]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiNS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 35.9972774}", "context" -> "System`", 
    "keywords" -> {
     "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic function ns", "ns"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiNS[u, m] gives the Jacobi elliptic function ns(u | m).", 
    "synonyms" -> {"Jacobi NS"}, "title" -> "JacobiNS", "type" -> "Symbol", 
    "uri" -> "ref/JacobiNS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6184, 221, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->606229111]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 70752, 2072}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2018, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2641, 77, 45, 1, 70, "ObjectName",
 CellID->8805],
Cell[2689, 80, 674, 22, 70, "Usage",
 CellID->586]
}, Open  ]],
Cell[CellGroupData[{
Cell[3400, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3878, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4001, 130, 418, 17, 70, "Notes",
 CellID->23247],
Cell[4422, 149, 831, 30, 70, "Notes",
 CellID->54696440],
Cell[5256, 181, 215, 7, 70, "Notes",
 CellID->93074778],
Cell[5474, 190, 248, 8, 70, "Notes",
 CellID->342715226],
Cell[5725, 200, 218, 7, 70, "Notes",
 CellID->31226],
Cell[5946, 209, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6184, 221, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->606229111],
Cell[CellGroupData[{
Cell[6569, 235, 147, 5, 70, "ExampleSection",
 CellID->12415102],
Cell[6719, 242, 63, 1, 70, "ExampleText",
 CellID->27705717],
Cell[CellGroupData[{
Cell[6807, 247, 131, 4, 28, "Input",
 CellID->110961154],
Cell[6941, 253, 174, 5, 36, "Output",
 CellID->86722644]
}, Open  ]],
Cell[7130, 261, 125, 3, 70, "ExampleDelimiter",
 CellID->168566607],
Cell[CellGroupData[{
Cell[7280, 268, 291, 10, 28, "Input",
 CellID->24633561],
Cell[7574, 280, 4038, 70, 129, "Output",
 Evaluatable->False,
 CellID->23412339]
}, Open  ]],
Cell[11627, 353, 124, 3, 70, "ExampleDelimiter",
 CellID->71743901],
Cell[11754, 358, 78, 1, 70, "ExampleText",
 CellID->175072069],
Cell[CellGroupData[{
Cell[11857, 363, 243, 8, 70, "Input",
 CellID->7816907],
Cell[12103, 373, 1327, 41, 56, "Output",
 CellID->866063048]
}, Open  ]],
Cell[CellGroupData[{
Cell[13467, 419, 245, 8, 70, "Input",
 CellID->565039078],
Cell[13715, 429, 1074, 32, 51, "Output",
 CellID->860104461]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14838, 467, 215, 7, 70, "ExampleSection",
 CellID->2517],
Cell[15056, 476, 74, 1, 70, "ExampleText",
 CellID->257841689],
Cell[CellGroupData[{
Cell[15155, 481, 177, 6, 70, "Input",
 CellID->325910105],
Cell[15335, 489, 271, 8, 36, "Output",
 CellID->182384296]
}, Open  ]],
Cell[15621, 500, 124, 3, 70, "ExampleDelimiter",
 CellID->25415347],
Cell[15748, 505, 70, 1, 70, "ExampleText",
 CellID->856906711],
Cell[CellGroupData[{
Cell[15843, 510, 207, 7, 70, "Input",
 CellID->69210409],
Cell[16053, 519, 234, 7, 36, "Output",
 CellID->13480914]
}, Open  ]],
Cell[16302, 529, 125, 3, 70, "ExampleDelimiter",
 CellID->200525529],
Cell[16430, 534, 113, 3, 70, "ExampleText",
 CellID->372977787],
Cell[CellGroupData[{
Cell[16568, 541, 171, 5, 70, "Input",
 CellID->2714330],
Cell[16742, 548, 238, 6, 36, "Output",
 CellID->168320924]
}, Open  ]],
Cell[16995, 557, 125, 3, 70, "ExampleDelimiter",
 CellID->182528140],
Cell[17123, 562, 210, 7, 70, "ExampleText",
 CellID->747487832],
Cell[CellGroupData[{
Cell[17358, 573, 178, 6, 70, "Input",
 CellID->536864854],
Cell[17539, 581, 327, 11, 36, "Output",
 CellID->38081932]
}, Open  ]],
Cell[17881, 595, 125, 3, 70, "ExampleDelimiter",
 CellID->259414736],
Cell[18009, 600, 91, 1, 70, "ExampleText",
 CellID->276511220],
Cell[CellGroupData[{
Cell[18125, 605, 237, 8, 70, "Input",
 CellID->365032203],
Cell[18365, 615, 267, 9, 36, "Output",
 CellID->155116330]
}, Open  ]],
Cell[CellGroupData[{
Cell[18669, 629, 420, 15, 70, "Input",
 CellID->175336906],
Cell[19092, 646, 308, 11, 49, "Output",
 CellID->219454824]
}, Open  ]],
Cell[19415, 660, 125, 3, 70, "ExampleText",
 CellID->691227904],
Cell[CellGroupData[{
Cell[19565, 667, 145, 5, 70, "Input",
 CellID->79128576],
Cell[19713, 674, 235, 8, 36, "Output",
 CellID->105215898]
}, Open  ]],
Cell[CellGroupData[{
Cell[19985, 687, 320, 10, 70, "Input",
 CellID->23662150],
Cell[20308, 699, 216, 7, 36, "Output",
 CellID->234400226]
}, Open  ]],
Cell[20539, 709, 125, 3, 70, "ExampleDelimiter",
 CellID->215688415],
Cell[20667, 714, 203, 7, 70, "ExampleText",
 CellID->178560258],
Cell[CellGroupData[{
Cell[20895, 725, 166, 5, 70, "Input",
 CellID->292152639],
Cell[21064, 732, 278, 9, 50, "Output",
 CellID->112997365]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21391, 747, 239, 7, 70, "ExampleSection",
 CellID->20568],
Cell[21633, 756, 209, 7, 70, "ExampleText",
 CellID->541124796],
Cell[CellGroupData[{
Cell[21867, 767, 243, 8, 70, "Input",
 CellID->271512446],
Cell[22113, 777, 1177, 38, 56, "Output",
 CellID->489998026]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23339, 821, 223, 7, 70, "ExampleSection",
 CellID->30598],
Cell[23565, 830, 113, 3, 70, "ExampleText",
 CellID->243016522],
Cell[CellGroupData[{
Cell[23703, 837, 1742, 54, 70, "Input",
 CellID->419126679],
Cell[25448, 893, 4003, 70, 70, "Output",
 Evaluatable->False,
 CellID->518178109]
}, Open  ]],
Cell[29466, 966, 124, 3, 70, "ExampleDelimiter",
 CellID->45086770],
Cell[29593, 971, 76, 1, 70, "ExampleText",
 CellID->31743841],
Cell[29672, 974, 509, 17, 70, "Input",
 CellID->29058975],
Cell[30184, 993, 62, 1, 70, "ExampleText",
 CellID->764811467],
Cell[CellGroupData[{
Cell[30271, 998, 423, 14, 70, "Input",
 CellID->11685600],
Cell[30697, 1014, 177, 5, 36, "Output",
 CellID->264389432]
}, Open  ]],
Cell[30889, 1022, 56, 1, 70, "ExampleText",
 CellID->3891738],
Cell[CellGroupData[{
Cell[30970, 1027, 556, 18, 70, "Input",
 CellID->278565811],
Cell[31529, 1047, 4584, 79, 70, "Output",
 Evaluatable->False,
 CellID->475825320]
}, Open  ]],
Cell[36128, 1129, 125, 3, 70, "ExampleDelimiter",
 CellID->545851040],
Cell[36256, 1134, 107, 3, 70, "ExampleText",
 CellID->260673715],
Cell[36366, 1139, 459, 16, 70, "Input",
 CellID->66124812],
Cell[36828, 1157, 92, 1, 70, "ExampleText",
 CellID->180760932],
Cell[CellGroupData[{
Cell[36945, 1162, 344, 12, 70, "Input",
 CellID->566805796],
Cell[37292, 1176, 398, 11, 36, "Output",
 CellID->94652325]
}, Open  ]],
Cell[CellGroupData[{
Cell[37727, 1192, 813, 27, 70, "Input",
 CellID->802831686],
Cell[38543, 1221, 399, 11, 36, "Output",
 CellID->154213273]
}, Open  ]],
Cell[38957, 1235, 71, 1, 70, "ExampleText",
 CellID->385278230],
Cell[CellGroupData[{
Cell[39053, 1240, 407, 13, 70, "Input",
 CellID->63374752],
Cell[39463, 1255, 3474, 61, 70, "Output",
 Evaluatable->False,
 CellID->232436556]
}, Open  ]],
Cell[42952, 1319, 124, 3, 70, "ExampleDelimiter",
 CellID->28797027],
Cell[43079, 1324, 613, 21, 70, "ExampleText",
 CellID->859664573],
Cell[43695, 1347, 295, 10, 70, "Input",
 CellID->697372184],
Cell[43993, 1359, 62, 1, 70, "ExampleText",
 CellID->123023636],
Cell[CellGroupData[{
Cell[44080, 1364, 671, 23, 70, "Input",
 CellID->107585666],
Cell[44754, 1389, 157, 5, 36, "Output",
 CellID->50352514]
}, Open  ]],
Cell[44926, 1397, 60, 1, 70, "ExampleText",
 CellID->93628833],
Cell[CellGroupData[{
Cell[45011, 1402, 519, 16, 70, "Input",
 CellID->285856041],
Cell[45533, 1420, 14861, 248, 70, "Output",
 Evaluatable->False,
 CellID->256027432]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60443, 1674, 233, 7, 70, "ExampleSection",
 CellID->13636],
Cell[60679, 1683, 73, 1, 70, "ExampleText",
 CellID->60474188],
Cell[CellGroupData[{
Cell[60777, 1688, 380, 12, 70, "Input",
 CellID->10346836],
Cell[61160, 1702, 336, 11, 36, "Output",
 CellID->27401250]
}, Open  ]],
Cell[61511, 1716, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[61782, 1728, 107, 3, 70, "Input",
 CellID->261361129],
Cell[61892, 1733, 203, 7, 36, "Output",
 CellID->159776661]
}, Open  ]],
Cell[62110, 1743, 124, 3, 70, "ExampleDelimiter",
 CellID->26733726],
Cell[62237, 1748, 75, 1, 70, "ExampleText",
 CellID->359994467],
Cell[CellGroupData[{
Cell[62337, 1753, 358, 13, 70, "Input",
 CellID->68486567],
Cell[62698, 1768, 453, 8, 70, "Message",
 CellID->230689891],
Cell[63154, 1778, 665, 24, 43, "Output",
 CellID->344459339]
}, Open  ]],
Cell[63834, 1805, 125, 3, 70, "ExampleDelimiter",
 CellID->152043587],
Cell[63962, 1810, 53, 1, 70, "ExampleText",
 CellID->492528614],
Cell[CellGroupData[{
Cell[64040, 1815, 193, 6, 70, "Input",
 CellID->38096870],
Cell[64236, 1823, 354, 12, 36, "Output",
 CellID->447633887]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64639, 1841, 226, 7, 70, "ExampleSection",
 CellID->10191],
Cell[64868, 1850, 118, 3, 70, "ExampleText",
 CellID->185729643],
Cell[CellGroupData[{
Cell[65011, 1857, 154, 5, 70, "Input",
 CellID->286079947],
Cell[65168, 1864, 276, 7, 36, "Output",
 CellID->310150062]
}, Open  ]],
Cell[CellGroupData[{
Cell[65481, 1876, 212, 8, 70, "Input",
 CellID->57974428],
Cell[65696, 1886, 293, 7, 36, "Output",
 CellID->144296650]
}, Open  ]],
Cell[66004, 1896, 124, 3, 70, "ExampleDelimiter",
 CellID->51763701],
Cell[66131, 1901, 130, 4, 70, "ExampleText",
 CellID->350342914],
Cell[CellGroupData[{
Cell[66286, 1909, 314, 11, 70, "Input",
 CellID->307497241],
Cell[66603, 1922, 361, 12, 36, "Output",
 CellID->305686658]
}, Open  ]],
Cell[CellGroupData[{
Cell[67001, 1939, 309, 10, 70, "Input",
 CellID->15030758],
Cell[67313, 1951, 158, 5, 36, "Output",
 CellID->278838587]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67532, 1963, 311, 9, 70, "SeeAlsoSection",
 CellID->21030],
Cell[67846, 1974, 709, 26, 70, "SeeAlso",
 CellID->9374]
}, Open  ]],
Cell[CellGroupData[{
Cell[68592, 2005, 313, 9, 70, "TutorialsSection",
 CellID->5784],
Cell[68908, 2016, 192, 4, 70, "Tutorials",
 CellID->18790]
}, Open  ]],
Cell[CellGroupData[{
Cell[69137, 2025, 318, 9, 70, "MoreAboutSection",
 CellID->17428502],
Cell[69458, 2036, 147, 3, 70, "MoreAbout",
 CellID->153244750]
}, Open  ]],
Cell[69620, 2042, 27, 0, 70, "History"],
Cell[69650, 2044, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

