(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    135991,       3895]
NotebookOptionsPosition[    121623,       3391]
NotebookOutlinePosition[    122993,       3430]
CellTagsIndexPosition[    122906,       3425]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiSN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSN"], 
          "JacobiAmplitude" :> 
          Documentation`HelpLookup["paclet:ref/JacobiAmplitude"], "JacobiSC" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSC"], "JacobiSD" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSD"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiSN\"\>", 
       2->"\<\"JacobiAmplitude\"\>", 3->"\<\"JacobiSC\"\>", 
       4->"\<\"JacobiSD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiSN", "ObjectName",
 CellID->7794],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiSN",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiSN"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"sn", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3490]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sn", "(", "u", ")"}], "=", 
    RowBox[{"sin", "(", "\[Phi]", ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->32267],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"sn", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", "K", " ", 
    RowBox[{"(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->54696440],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSN"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->93074778],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSN"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->155112946],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSN"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSN"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->224356821],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->221069697],

Cell["Evaluate numerically:", "ExampleText",
 CellID->27705717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{"2.5", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110961154],

Cell[BoxData["0.8906151882260945`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136588789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168566607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24633561],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350224094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71743901],

Cell["Series expansions about the origin:", "ExampleText",
 CellID->175072069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7816907],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "6"]}], "-", 
      FractionBox["m", "6"]}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"14", " ", "m"}], "+", 
      SuperscriptBox["m", "2"]}], ")"}], " ", 
    SuperscriptBox["z", "5"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"135", " ", "m"}], "-", 
       RowBox[{"135", " ", 
        SuperscriptBox["m", "2"]}], "-", 
       SuperscriptBox["m", "3"]}], ")"}], " ", 
     SuperscriptBox["z", "7"]}], "5040"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "8"],
    SeriesData[$CellContext`z, 0, {}, 1, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[-1, 6] + Rational[-1, 6] $CellContext`m, 0, 
    Rational[1, 120] (1 + 14 $CellContext`m + $CellContext`m^2), 0, 
    Rational[1, 5040] (-1 - 135 $CellContext`m - 
     135 $CellContext`m^2 - $CellContext`m^3)}, 1, 8, 1],
  Editable->False]], "Output",
 ImageSize->{460, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76403001]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->565039078],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Sin", "[", "z", "]"}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "z", " ", 
       RowBox[{"Cos", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Sin[$CellContext`z], 
    Rational[1, 8] ((-2) $CellContext`z Cos[$CellContext`z] + 
     Cos[$CellContext`z] Sin[2 $CellContext`z])}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{323, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135578337]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20351],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->257841689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325910105],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.06039693658795792`"}], "+", 
  RowBox[{"0.6870231543848135`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288260610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25415347],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->856906711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69210409],

Cell[BoxData["0.\
976309582765480719279504873609160438821873400538100037258384174602`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->470931450]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->372977787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{"2", ",", "0.333333333333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2714330],

Cell[BoxData["0.9763095827654807192795048736091604388218734005381000372585`40.\
94048297880807"], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->212274494]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182528140],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSN"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->747487832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->536864854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225772103]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259414736],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->276511220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365032203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "z", "]"}], ",", 
   RowBox[{"Tanh", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136369750]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175336906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "-", "m"}]]}]]], ",", "1"}], "}"}]], "Output",
 ImageSize->{141, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89975962]
}, Open  ]],

Cell["\<\
Parity transformation and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->691227904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->79128576],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"JacobiSN", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16897672]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"4", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"2", " ", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23662150],

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->5935448]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215688415],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->178560258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiSN", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292152639],

Cell[BoxData[
 FormBox[
  RowBox[{"sn", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->1610708]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31356],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSN"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->541124796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "x", "]"}], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271512446],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["x", "3"]}], "6"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "12"], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "6"]}], "-", 
         FractionBox["m", "6"]}], ")"}]}], "+", 
      FractionBox[
       RowBox[{"7", " ", "m"}], "60"], "+", 
      FractionBox[
       SuperscriptBox["m", "2"], "120"]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, Rational[-1, 6] $CellContext`m, 0, Rational[1, 12] + 
    Rational[1, 2] (Rational[-1, 6] + Rational[-1, 6] $CellContext`m) + 
    Rational[7, 60] $CellContext`m + Rational[1, 120] $CellContext`m^2}, 1, 6,
    1],
  Editable->False]], "Output",
 ImageSize->{312, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->728049004]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27774],

Cell["Map a rectangle conformally onto the upper half-plane:", "ExampleText",
 CellID->243016522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "24"}], ",", 
     RowBox[{"m", "=", "0.3"}], ",", "p"}], "}"}], ",", 
   RowBox[{
    RowBox[{"p", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", 
             RowBox[{"j", "/", "n"}]}], "-", "1"}], ")"}], 
          RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
         RowBox[{
          RowBox[{"k", "/", "n"}], " ", "I", " ", 
          RowBox[{"EllipticK", "[", 
           RowBox[{"1", "-", "m"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "0", ",", "n"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], "]"}]}], ";", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", "#", "]"}], ",", 
             RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
         "p"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", "#", "]"}], ",", 
             RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
         RowBox[{"JacobiSN", "[", 
          RowBox[{"p", ",", "m"}], "]"}]}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419126679],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->483472707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45086770],

Cell["Solution of the pendulum equation:", "ExampleText",
 CellID->31743841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "[", 
   RowBox[{"t_", ",", "\[Phi]_"}], "]"}], "=", 
  RowBox[{"2", " ", 
   RowBox[{"ArcSin", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"\[Phi]", "/", "2"}], "]"}], " ", 
     RowBox[{"JacobiSN", "[", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"\[Phi]", "/", "2"}], "]"}], "^", "2"}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29058975],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"ArcSin", "[", 
   RowBox[{
    RowBox[{"JacobiSN", "[", 
     RowBox[{"t", ",", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        FractionBox["\[Phi]", "2"], "]"}], "2"]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     FractionBox["\[Phi]", "2"], "]"}]}], "]"}]}]], "Output",
 ImageSize->{259, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->752145551]
}, Open  ]],

Cell["Check the solution:", "ExampleText",
 CellID->764811467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"t", ",", "2"}], "]"}], ",", "t", ",", "t"}], "]"}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"t", ",", "2"}], "]"}], "]"}]}], "/.", 
  RowBox[{"t", "\[Rule]", 
   RowBox[{"N", "[", 
    RowBox[{"2", ",", "100"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11685600],

Cell[BoxData["0``97.30117200721915"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->190721973]
}, Open  ]],

Cell["Plot solutions:", "ExampleText",
 CellID->3891738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"t", ",", 
       RowBox[{"Pi", "/", "3"}]}], "]"}], ",", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"t", ",", 
       RowBox[{"Pi", "/", "2"}]}], "]"}], ",", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"99", "/", "100"}], " ", "Pi"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->278565811],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->746345128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252365793],

Cell["Cnoidal solution of the KdV equation:", "ExampleText",
 CellID->149088002],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", " ", "t_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "a"}], "+", 
    FractionBox[
     RowBox[{"2", " ", "a"}], "m"], "+", "\[Beta]", "-", 
    FractionBox[
     RowBox[{"2", " ", "a", " ", 
      RowBox[{"EllipticE", "[", "m", "]"}]}], 
     RowBox[{"m", " ", 
      RowBox[{"EllipticK", "[", "m", "]"}]}]], "+", 
    RowBox[{"2", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"JacobiSN", "[", 
         RowBox[{
          FractionBox[
           RowBox[{
            SqrtBox[
             FractionBox["a", "m"]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"12", " ", "a", " ", "t", " ", 
               RowBox[{"EllipticE", "[", "m", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "a", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", "t"}], "+", 
                 RowBox[{"m", " ", 
                  RowBox[{"(", 
                   RowBox[{"x", "-", 
                    RowBox[{"6", " ", "t", " ", "\[Beta]"}]}], ")"}]}]}], 
                ")"}], " ", 
               RowBox[{"EllipticK", "[", "m", "]"}]}]}], ")"}]}], 
           RowBox[{"m", " ", 
            RowBox[{"EllipticK", "[", "m", "]"}]}]], ",", "m"}], "]"}], 
        "2"]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->282606447],

Cell["A numerical check of the solution:", "ExampleText",
 CellID->86046418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], "+", 
    RowBox[{"6", " ", 
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}], "+", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "3"}], "}"}]}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Pi"}], ",", 
     RowBox[{"t", "\[Rule]", "E"}], ",", 
     RowBox[{"\[Beta]", "\[Rule]", "3"}], ",", 
     RowBox[{"a", "\[Rule]", "2"}], ",", 
     RowBox[{"m", "\[Rule]", 
      RowBox[{"1", "/", "4"}]}]}], "}"}]}], "//", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"22", ",", "50"}], "}"}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109683327],

Cell[BoxData["0``50."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10131165]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->708833465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Beta]", "\[Rule]", "1"}], ",", 
       RowBox[{"a", "\[Rule]", "2"}], ",", 
       RowBox[{"m", "\[Rule]", 
        RowBox[{"1", "/", "4"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->118294239],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9femTXNd131Nvs2BAgItIkZJtWUnsKJYJEdxAgQtEDgAKwOt935f3eu/Z
MQtmMANgZrADBCEQIAlaZEirZEuxpLKocjFRlHJVNqcSq5yUK67EpUql8iV/
QT5NJXc5d3n33e6ZAVVBDWa6X3ffe89yz/md5b42K3NNu1eZa9UqXz0+U5lq
tmqzXz02OYMueb9gGMan6P+7XzLQ4/+LHpH/n25tbaEXpN+n0W8feukweTaP
f3vRU/KMXV2QruKH3yJXF5WrLw24imcxfOKqYQyhPx709yCf1wNXne97hvxZ
+w1dPwPUGn56lb8Mry/COowAf922bfpArDaDfmMSn4S/Xhj1efJqVuHA4/DZ
YXIdDQczPqd996Mw5iihgL6bfuBZ7fsfhtH9ynX/Dj//EMxHiADBe9l7Tv/0
V/glPL6PDMrHAxoOasfcA2MOM2760ysb8e7pbGYZPTHDFswgVuflEsjAZ/aw
z0rrIhwcxkOULPzbstJrm9a7f4IfRy2PMqZHWdUBMlAN1jaGn43gTxYs9IMf
NBrpC5etD37YeP/HhGo0JhlP5QqM9zQZrwLjYT4aY3iYvIV+8INOO7V5rfzd
j/IXbplViy4SDcc0Rh7rD8lYRRhrPxEs/kAOj4V/kxWmrtzIrF2NtqaB/hge
Lrm4lj05b337ClmzdtxXgJe/BX8flcenP2TF4fmlaGcOuEF+o/HR0sOdicTZ
C4Zm3d8g47+8pe42tjPU9RDKRmHmLPlBD9pdeoVyz4OnHsIzV6xgxY7OLqUv
3mQyQH//sM+cTwB1T7A30gkMH/7l5TMYXkxsAE2CpyhakfZ0cvWihrY/6DPP
Y5od87huzj2CKi7HPJk1b4Wq7ejUAtlZ6rz/pM+8D8O8X+FzZSz0Q+aiOwXY
iab04F8BOhVoY9Fiu1ia6+t95tqn2X1fZu+i86IfPyGVU43m9OArRHZ0HXQ7
FCyd7nzdoZt7gbqv6meReOsls9I5KG89mERpZPyQcvGEhg5mrZ9U+OhBvzx0
ggxZMDZcfK5sv7kUqn6fTHR8S1hAw48eRCqdavjK7GvYVkkaSmcOEDFSCulV
r2terzKvurPovEdh3hG+z2wLbaNs/Exn/D61QGbIMk9azAqoq4Dn1P4xflAb
iB8SvfJSXSb8UVbxe2QVr8MqsA03hqi9RmYEqWA00yuGL6BFEc1Hqhu0TBMv
CfRbXo+fc4U+f7AV+WAtv0NW9jV49mX4u5fpxzBaHPUEwVLdLIO1RhbWgxfn
xT6Las++na9yhK8SNiY1AUSiZF145oCy3t8m6/wHytUntgTSkK+P8NVQ6n1E
SzAhRZBhDBuIsGVG8I8BfkqVekDeb/Sxh2tgBiy1l3I6yzihclpdG6XkK7Db
1FeZFX2ErycLK85hpjJryWwHkUQUOB0l5Jy09uho8Su0EHmQjQzEEHrIPB5m
WSRd2Z4iVTaPgCQfY3sdBJ6FlYN+gkUJYIkEBBVh0P5hnV4p1kmmjZAjdM3H
HaoBKHqArdDTsQ8k8riWDh+hQ2iaH9PhBTqiFqAlg8A7PEDg89HjFfTwuMDP
10rWD77CRQfb009q6eBy93NaECVmHLMQUTREdz38RMnLEcvpp0GvAgpFXskS
GAQ6YWoE+qCfcsmG0/E1WPcYyOEphYNk1QGFHlmLERGYDi+XDCGC2oBRoIUq
3Sm2h9mytqfFKzSNmQiwtqp//Rp5+PSWwJzOkR2YwaCwRV7/MN7r5HoUq80p
2DnAv7H+K/PzlcF7hxVeUz7/AfCXrf1LWyriEBxlus/0hawQ/xC+xmEllM9g
bYf5nsDXgxKvFB77pB1Afzt2wA6p+fqWFDnjVwtvruRjm+ThYy4NkmnLwD5W
tUdLlR+uROEikpKTGrxcQKEZsLRUi1z2eEShg3rmYfATT21JyIloe8lKRmbC
KC6ZniGrCVkqclE5mRWaJlHmJ+Qp+8JBqVdno/r7ekSlry+FYl/L9OJX+/ly
P6e4YIWyDbMCOMSLDdB2CKSvlONg2+LieQxsxG+Cdt0nZHokuik3GPruhwdI
XE72EIlcKATA+LFMdRHF+YQf+B2vE08zpvBDtWUeE4IkLiC/zI24zI24zA2X
XId3zQN1zxJraOxRru7fknII4GM5bPBS+g22EwNgw5lvQiZGi4O0GiLtcem5
h6CrONm//fY1pYxDKJd+qJSru/wrWspZ9mk/pyALlOdoHkDarz6O/8IAm0a2
3DuB2EKFXmGp4xb9LVPsRvBDWsus7hDvjigeZt4FropI91GZZoA8PMrjNipK
HaLBfTf9HWLed1AEFwB+yPKmekTMYYw5szh4ggfjg8906zz3/NwWMlTzGDx3
oTwscUPGx9TbMDVXEZiOXr/y3OPa533plkYdfiCqRxXpE/TGrRrLTQ1BriYg
2V/DMMCyUbrHLfME3tVUW4Z3QuMQp5FrOEcoujXL9sxh5XZCKZVC/ulJeK5G
TZTyR7ZEjpxS7MRUHoq24wJtC25QBAuiP4npCA/yRYwrkszigNtUOxd3jcPt
hRoDA37X2lEHJ3IHGCfUiJhEIDyuIvkzEY/AYn0yHibhiI+7JPrPL/tqwpNh
F/0+5xWga2QQvbLtxmL3mRy30XfwrL8398wEUKRmKwh2JtiTIRpdtg2/9kVm
B/maRUQh82Qg9TFOvcs36z22lwV2fGt4NTxRbQpJLwXk7a/jSvbZCUnu+PpT
wuLrom8o/ZBPY22L16fC9bZBHdoJ6xGuHzIFAmE6o3EnlwJSzGfoJNyfZwz3
kB9AGNyIxAFPi/EYtgYuuewE5LyAkxK3nmPcUiPgJ6iygM4Q22C48aGH6daQ
UoPC8KiMKawChRGWV0GWY9+ueSp4iHnhVfisoiM9X4WdFZEGGd0RveP3Y48P
cRPsP/rPjTSxBETUkHmhJ3lbmU+PCx105UvIZ0fkmiCG10WcIabwmhpdHGtA
2L2XjS7Tq1jeLMS8ivMh1GOk7e2nj24LLvGMYnI+okHzBDR7A2aTc0vdw+7s
hSsmkGmTNAx/aL/goE/moNBK0PE8piOP11KyaPoYOCgilJBlHrcMFacqtsqQ
PIGC0jx8X4s4TmfBZZ9N7YGbmxx1+SC1WiT6R11+Fja6yx7Ka+Xm0OFv4QVI
/8m6yWr8MkIwtuGwj+/YPKtNFhmfOT2ObHAEALGaQdVz2SvnsOJWHz7LXsLJ
Tz2SUvnt414rB+VbL8ETwtvR3yq3t80wgHmCTMspK30Q105dsYdqPfdxP93P
tspxJ8nB+7gADPDCfoo+6D+m4j4d1x34FKpZUlVN9l7O7MRuuU0DBJ7xjNuT
JIdGdbpC8gY5yJw6kRdTAq/IC/hMFi1hjotigaCD2jnmDNDM6ae7SiTah/8k
sheZCh3fobLp4Xl2SZPYc5ZnDyDJ04QQjxP6Ve+EPDSZIAUT9+O9My8QhnWg
PYj5PASmpEp+SlDlotZsiPMccAPlfGAgp8nVEcEBw0gd6NKwF/SuL8Jyc9vl
A4dY3Ami9IFlpCiR5W09zlyDIbAfXTPXGs41DVfdCH0bLE6oxzzdc/uzX699
/EsMbZASW07OEnUx5Bw1jZ+dz7V23MuhrISBOJef6UCuV+SWjtCYU7Hfen4H
JAvukd8FKwpA7OvOPQqMH5G47cZZWq478vJcf3SZKbN/doxYZ/zhPbnq8qWz
f4Ue5U+vYc7XLbNGmF+ARgqqPBKSYyVd3jsAuq5gHL4XBUL2OmWAfpIHO5Lv
QKp41AJO+sjUWxwjk2o5dHkZUnbJo9V6LG21D8aR12eiIJGELg8ouCbZEYn3
sQfivcd0xxGcb8vBP0e/F//opx4kBSQmJgeDgH6p8s9q3TnHDiB9MWaG4x4e
nzh0ysH954D7Q9ze0lYJqpQuqz5IBs4dIPag93NJQc3+BKTM5s7z+O54Q/up
R2X7dftPfx0r9BLJqXzxLA0WwvlmJNnG/GfZed5IRrM9BEFkwVt6Zf2XbRKj
PW4lXmjThUkSYBypfOeizvLsbhf4wSdKu9dgDp1lhLmvjQvfwGy/aqtlq8+0
X2A8xrlh0HG9RRajUYQx88KH65N/SXlmNqzcyaVkeBqpO4lvybuFFaK0EHxp
m0XWESPz2qAtfA5ek/2aONROfKtNec2yrRSPVayFGz92aC8wcP8utV3QK+r4
PKZm9p8sRlSs++expXgO4kpnrMR6pmTOM8veL39qSviGWIeRxjcv58yFRH7S
Pnw1e3IpVKhjB2CRAgxg7rzlRMlFG1fqCPfdFXo6KbU0bkSJaUi81JL1XiBM
atXMep3yGi95O3uj5seVrCDw3y/bDJH1GcB/TbQXk+upLI+u8p9Z90HRvlMK
NBPbefa75WPn49kps2Vj/lepxRqBYiBrDDKrddNqGBIe2iXv44db8YMtJ+/j
DN2zwqNmJ+xz4J3+0ZS0z4f4c2AgtddqJdIjR0ZMEm7OKchS1LJ83CLwMIe8
08Pszy6kwK9nI/ORSieW7REpjJlVO5rqBrkI6k0uBSmHnRUak2XdPV4+btyK
v9KKP91iETjY3iHDEH3AootNH02pFRdV+/t7wu0joQG812T7YPU+wQSWqcoS
/R/SyEzvlbW1672tF99Cl7InTuMXWo3C+NlosoNjrnrDbLdMq04Z5kJAZE88
JFqts5BTEMFY3Iq91owdaDrlQE9AiH3Gc1sKx/dyOTiyPC5+q/J4UP6rXBMz
yDlD0J48kwLD9nR+Ee+7rdKupPIQf56JLaDH1Vc2kuEZtDnMTgtJhVpwGjXQ
nkaDwFaTtW1Rexmg0QDI4kgz9kzT0VdE7bPB+tYKFFVxEeBX9nEpeA23D9hO
CnKGW818MR64IzH3HtBIwgsUFyDocfQo+gGd89yjA6PIYw8NkoL8HL95f+PQ
9bx5NlKdMCc7ZrshiyGYs6EXviqa0xUpoH/R15vRg32kQIAtbAwWjav1zzHu
pb0a3/F55aPdJdvKR0gxyrM3kPllnbYsnuKOY4hHKpqRs9tJR0W3REP229e/
ix7HU71QoWHWGqbdjEcnwMTY7KQCa5Mm1ZEseO8CNnLR8Ub0uYajn0OSjV/I
JscRpyqdPdx3u+ODAENWnHFq1MulIeXonTG+dr/0GTNi8WylL1iyURBFdRVn
u73QDyH3SPh0EvEJe09jjX7S4NeH29+8VT20lkjNmr1uPDeXPjVH+S8QboFr
BD3Rga9V63SXRI42Ii80oq855UD3jpdl1yTM//9bAqoV97ok4Mj4+Ofu/Gl2
+gxki1mtYQixoLJ4yZDxiNw1LrjO7JhDDmqkOBBpjdDrqdxy+eh64ehyJNsx
O6QuXMMzFixX1IFxUqg1Rc8wRY7XIy82Iod18mA5N5aTGxO8lxHrzjnv45zn
fknjVQdy3xEVjHAedaLfLbyxVOpuNubuTC5+HA9PoHeWqMUpz2+CbShY0Iku
V6ycnSXboy3GfbobFFtZHb+Uyp0xp6cgS8I2JYqxiWYMU7wVbE3Sw1x4R7yE
JFD3Qq2TjA58Vzk9IvjviOB4TRz0ZVjhvUfLe55t5NUMJ42O7II2AiAyGL19
538uNn6cfXMeGaH2lfewMM59AHV1g+wHD0/pI2rT7Xhymu90qmgEa26P2LQ9
0KpFEzqRLC+i3ysffmbW22arl4hN0/2A3xGaXQg2J6ilQrSFD9fDz9ZZ15Ms
B1k31A6dkcH7YecSMVj+V1gBNf5gVqePfo7UXt2oxq6hpzeu/4+6dTdcbiOb
BDoPNolwO5GczcXWopke83LgKbzM9g1AZxr974NFDKYdGOemzl8MTy7mx89E
0i2zhlU+PLcYbPbwziD7EgvgQJ3mEThDHOfaqABcnJZRK++jUTGTX5EF78PZ
tQy47TG27UmAOYw9N+z/dbH7d1PNH2WtNTjHW7QSjRnplFU5cskYCufb1Etw
DEJ5IGqfVFoPinHZhjf2ogf5+Gbl1fOJOG6JD59dJeLo8kANURg6YLM+ujjD
135ZHtQTAv+xXPAtA76A/xJZqBVN9TyPqOFBGkNushooB4Z5GCbZvjeEcGXM
il63sxg+nv3on1PLZAXf6py8X4yv4zN7BQtOZ7I+Sz6/dsydcpzRaQxHzl0I
zSGb06E4IVhpGnD+JCZGcklW1XjfA3M6wCsFzvNlYPx5Ll9/lkd4aFe3IJPB
6Gb0by6d/o90J+XSZye/80nn1Af51BrGRkXSm8x7SAKg6n3qX9x6sPUycMaR
aD9ERFa/h15vHrxePHEu8+ZceHI2OreUzOA4O3jQpudkBnFduY/ElpSp49U0
1pmoPamm4MWY0Ca5n4DznEnChYYMURXQdsy7pOAjy2+F7y2N/7wVejebXcbR
apkjU5YLQIsqCAkYhnySJ8P3oPvsQ9++fZ0c9sqrQ79z8zfTazdKR87G4j0s
ijdINgn6UbSRj86KQx+kauXpbpBzTIQK5V1D20pL7b3Jid4bVvdnuTG/yfAT
sxNMkJwGyXozvOLeOarP3Dv/+k8a0TvpwgKC8MGyHc12Q2WSpStZqcicQZw6
BrdeJWMnn46jFDjWKeWvt5eii0uaU75E2wLB15gcGRlaXKZYMYKxXNbMp915
am+WHqeQ3jmD9kBQxCn2HEZgor5Ar6sn9hml3KvoO173oQe9b73XOnb36tt/
g99RtZLJ2fzJVSogvNkKUqcFRbqhdEOKadE0OaE23K9vG3Vsi31VX09kFrFE
z4B7XPUcCkFRtnSfEU3FSO1I1MuDdMEIO0cAj02xqN8s1fkWY9ZGjvy9zEby
QI2Zxl1KS0QDsyc/yp48bdpW9fiV6tHLdNYKHo/BUGoZMeSKxXrRRFfyTTma
6XOdqtSh9IHWTPqcXEcfIBvHbvCRrNsWua8Qt4oaCY0qEtLlSmlWNZxvmXbD
bLRS5iyJjvw4WqpidILfm6diEdW5nFyj0VA+QBauSG36wIeThz5sHrmdjZ7B
r9Vg91BZoL/DydBs/jsrkWyLNwNQbEzzrmIWR72uD3qhFG0nGY5/wC/3lYno
Hya8Fn3RPo4TNF0F0k5TrZpr7aSXiy6reeBK7uQZc7IbK80V3ljBgVS1bnYn
TLvFvE6BhQ0envkEefFoQiczt03ZLqNOOPQQ51g8N5mOkdpSGfebIQdVGr+Q
O7UcKjZojzDDHGJ2qb7EbB5k9TM8T2Bm+JV+mUiQAn3ndufrAlopsTMnam1K
JxsvQ8eQ8ymeulB7eSMVnTObbXNm2mx1iCT2giQI1yOJVjTZM/PsbjN54Ryc
Vc4+CFeRxWDsgH/tKby+FC42Q5VG7chl+9XrmfAi7XyCzWxI9zDwcgMnrUU+
XeTAgDuXCTVpmt3I0OGQVhbqyQ7Zy0h9uRzIMItDtTbWXDJPz3I+jJCbxjRC
hXYyOJV5cz5SmQlWWsAEnhU1JDSn4CjZYgq7IfjgU7jv6sTEf/dUj6znIsvd
5+9Zr19JJ07T++kYBtwfi1lXNFjB4sZVRXG0N8Uthx0hBNf5vN3LhJwFw4jN
ls+0ZZXoEj15eCr/vcor59JhYg2mZ7LHF0tHVjOx5Uh3IVjvUbJ5Pc3h+Z28
Z4iV88BpmZT+VG6T3PgJ31Ft4rn3q8cvJTOzuA2QWinWmVGcvUCyk0UYS/Qe
S5GqgtTkyNRlFR+Y+8MK973aHeFnUtja2pJqacATR05ij8yLVHHNemmzfGwz
XToXXlzBLyH8RegOyMKgv53+nveAsEwBn3CHWFm+urb+i+L4WezOLfx04e6P
SRcIOz/EcsUs/21I9yQTJx3ZYLqTpv2xl+hdVnVHz3sWn+C/HuC7mkn0Ahc0
fR57Fcqbh26WI1fT7U30ODRzOogwFqsX4Yw0tUXBZs+QXLbJTrMjykeFLFjS
ZLAssqosVN+4x352Ix2eiU52N2/8G7yqSgPfWcsQFW+oFgUzdizao1ZQwAkZ
ofefabBMDI6yNKfH9VJhms8RsQHywd5BeO3sAPnooltanU9Za8nUXKTYDXem
IlPzyHOQPUKotDuisinfy8rpP/KWqfEn2nM6Lt717bUNLL75I2zI3v7QbJIp
K5aXeLBovINQeyzRY/dDk1oL1I62jBT17kpCpnRm68ElhN42+rmkQ9YzVjt2
NbF+OdO9mD+6FMrXg90JvG0mZmTHonbYs7YAd+W1fz2JIVR1dWovKT1VaTwU
z00kozPhbBMbM8vOvblUOLZCRWVw2CfkokXB8l52VJ00kqHWUemF3oF05DMA
PuUdvBPL3GklyIHAHqpFblVeOd9b+wBdSd28jd9WbfDDjbiDJov3eqq3DHE2
w0AchrIalLPnfqfykLzC6MTT71rPb6QiM2bLzoQXrMOXcqdoiElxKXRC8WhW
8fWc+SLzKmJIcR6sn/+34UD8TiSi6/DBu2WPtFuYnqj8d/PD0cGBY7TFn/67
/N3vkU0yhbxs2OrEJxZjEWzOS/bl0spNajOInXPE9+xeEzo5aM+LuqUgfGDt
yIb98pXWsVvoSnrxjFmvmxWSkpL8DL2bru1oweF7wJHH5FHLAEmI1bDzCX1q
K1r7peQq5XcNK3JxdMv3lct2HR3kExgtXfrF39du/3FlGleqrMSN7vqfNK5+
FCq34DZGRQHTpIwm45TQObm3hOOCgeiJrADf1ffyz34VmZ00Ww1kx/DLZdus
1SPJFmzXcl3FJ6x67OFtiZw5mnkG4GJ9HUa9JzMZTMVsIq+fA4/ryC2YcpfN
TmXiYzrcOIWN2fTsn5356K8m3/tZZmYN8rxFKar2mtKdJ7OO6Ib5oox4wbcr
2fCV2K9cqRw+l0hOoceJ9GwyPI3f1EBwuunsu6K7idcmlLuH9t83ohNOSksK
uy/FIW65jClXAzqZONfFEaw0zxAHRWZGeq1fxY+8sHbrry/98n8v/vDf1zbv
IurKeDJaXCc2Jl8/J1W9JLPvQmq6HmgmJ32tsB/i9TCZVY9swEJ6PSyqkq2E
wLgrwGOyewOLGpOX647EJslDSica1VzlQDntBQ/Dq5wmO2WuckPOFxqGOCcz
4H4g/dCBr/rS+XroSnfzvfm3/xn0wpasmbkfpmoLYNsKlqK58EDNmfW9w5Bs
yXQZXXmdmK+V45uJ0rw5O2V2OqbVgHi4grt+Y9kuVR3WN63KRcJnrI4kWxj6
qvbE2gDfQuWzT7nKa2KA7UvSKW+xszwPLB++70d7uXfRn1L34trqv662r2E9
pf1reWqzWE2Nta74TfmM5IA69fZY4WF+pXDyXH58KVztmR2MUjqtdxJZYuaq
NpwV52dpfYokfL9BKezXoYNRkEKJnKzW9xtLeUVH9w7jRd/uHXfeYDH/E/T0
6uZ/nZj7JGZNQpOpVB8ZCuUaoJgyOGB9myxfI3nA3UtG/cRDnd79zMWrWFGO
rSVLuKnCbNTlAIyuIlhqytaUy2tIMWfwspwR2LmUHtZJiXC4Rk5es7O90IPI
+u+xYtt0meLOYhKNA9G9Ybi9Ec92TSQ/yI8vpmqLpQouMQaLWGS5zFoyMw+c
KTPQwKqK/OSVpCm8bsWn3F46NPJBz5vP3yyFLiaaq+YiaRaQ1IbeCSVcn+SQ
wAP72H1vYKfGsBNY5P1aWTwCfsXL7VXdohklD3Slkx5EdvrOplpL5ePMtDrm
9wtlEftlW9y2R7xuGLUjF+PxXrBqd+MfFVMb9J5FLGfCbxQD9yhnHpFHpGr/
ndozsDPJCEyQql9Aj69/+rehNjZwKXMaLShktSMT89QNS3UauU+W9w4xhC/N
Jayb6D4V8qG9FeR+vo/Yyv2vGniQeGESW/qqhY/m0TXQ+Myy6Rby8rVwLXH5
QV4hMQVaGFTf1PrtQPvbd+zkreXwL+rJO7HiJJzeJNqDMwZBhlUok7Rn1gR/
TPnEfL/4Q7dWeW0GcJlkeobzx3DiKTq7FDu9Eqw0edMktS+5iRWOt6nIBkks
u43E6F3vZInRGl/plZUgCqGbdvHoaizew7ubHPTl4mLRCAs34AGrbKgd9/p4
QIcXXDySPK0FHa/hKgK5Vjw9FU9MgbOUMj1sejoSBXZ+nYx2gejI+6HTo/r6
xUz1XPL85cTKerg9xbLs5GNL7/2sfPYmh7uGXAsVeixXOui+6i+hx3VYbTST
XKgfupYxF2i6CcfSNZtHi+CJ8qwUyCyx1xQZF34i/cGk4kAR86d++va7f2+Q
QKN64ko2vEzvDGOwfeWwL2w/FX8jktH6qLHM/LVEbYHa5tTi+vl3fokeVC7d
D1c7/AYdTslIPYo+YevcnohK5Qk5whlOFGdlIVDPP3Pz+7TDxDCke0UzICf2
SZ5AYBYL7Sj62xYn4Dnz0dWplz+pnLwUyZOzOmXWI0v9cM7iF1nnRIBrKI+c
d4ToBkiDrBbXSHsX/qx07+PSsfNX7/5n9LRx50fJyWVQWHEGVaqGB5hVs9mX
zOgl8aQuJ7DXfvlq7aWNdGjObLc6b92n6oZ/N+s4PHbUWUAOyLKVJAsvzNpO
Mjuq1vIIej960Dr2DqUpWLFjqQmTIDb0gCoG3Tb89kmqz1M7ahy9EDvzMqJS
O/nG/aWz/xI97f7Tf5FfvQFNG0UaUjg8nVwPtdlXGekl8JRylWTOhsrjFyba
OC3cvnIPj9lpm7UGx2nsTAiapG1TFTQhv8c8mRJRZLXITMd3124IdA+/V3n1
fCzVQYC9fHQzGZ0BmTO+S5FnFgyVA4vwaEHgZf1Z+/6nZaX1YnlUL+MiRnLi
dGXtJk59Fi3r9LV0Y17K9YkuDXaOS8//LytX2R2tjX3xpQVzsmc2WwhrQbdK
kdm/Rtec6HAzbGoyU2qXiFxLY0hjO/6T5zhisF7eTKXnOofu5U+dxS/b7J5h
gNsDsN+KIoOpfBOHmXOex85+LhlgX075df5nv5pe+EEyhIsXq29/Zs1dgz4n
OZMncE7R4uJwRYxUHl8B30DuPjBmv3i5fHgVZ+ampnLHz4QzuO/RnJo1Zyf5
cOL8vZRPNViPAj83tXvOP6LwZuLWh9Tc4AYJkmFOBed41MhBpSPPnmPJMXVH
kBlc9w3Zxi/I8dxw88DVRvRGe/Gd2z/471PrH9FVGNQpstNkmEMyz/Ee+AJ6
LDq6f1uRAuH7Y6nSqvUS7oUw211zccGcmYLB5Lwo9smOepDInUuZDUOqDslO
wJlXUbwkwfKjhSNnQuV6sFYvjZ8HJleV2IL1UOKQ0Zbl7rw7osb6D+AvsRSj
n3yGA7DOtfcjNbzVu5fvo1nSxaVk/jQZv0QNP5qU1N9dnP0dHWf301livdXg
yrI5PWPWcdNbsNoINqABK9yaClldHkSp2p2z4p1FZ91CaiDYLk7SWXge+fqq
r63nw/hLPMkVC3+vUFkNDmhugKbXdMhcZz/U7kNlrbLnG72w8Nff+wmJfCtW
t/BxMX+RPqauhlpZZ2bDyfWvKlwneUJf47lr9jMbaKTw4rKHKh8CEQur4c6M
SFrmeM4ha4WtXmL+XLQ5I2NcZwTL6NBGO9t61UJwNWw1UXiPv4Ez00SMhpoB
iTtMG1hsaHN0bLSsLEHQ9/4WHThC+jwwqrSSt84V8M0QQ+Um9ycm+1Y2yBQ5
ufu7CnfJXc2xh1rr/EUmOB/uTqUu3ojOLAUrDT4cPV+HHqTWrpSuvIc4K6rH
7m5KOGe8C37KGQP70OW0OYOTJmTWMXIbHdtsEG66OumYX8xqcNPueDrG+ID+
Zqor4UornV2KJnAT2dRbn/Tj5tfA15HvCgGfWpx/J33jTnzlQriDcz4hu0Pn
K0BN5N73C5t3guWGsIE8a+DjgQdbN9PTrC7rpdVLnR0eyi+sme26zEW6Jumk
iLOH3YcdQ8ZilgRW08fbER0aXjzxaXf8/VRwhh7CbS3dpVxz7/B/qNNBmQ7q
OzIbsXgX8b/83vfR89yFm3Kig8dL4LV5ltVRDdDt9L69WKLjHl/tYXbhsxvI
gNZYKwWKnWoNxrkhblPwT6FuVprEvhjyWUPnHPg19g0rxtC6/W/L4YtUayg3
SKWe8OgfKTwieXi39R1uPH8lH1pOL65P/AT3GGZWL9OohmAIf7Tak5MxPCOu
+969z+F3xtrP3DLYv8LRFVw0sRtmvWmw8BbmRsMU66bVNssNU5yKV3ueGafI
Nw8MVd/YoAM7uEQ16fd0XFKzA4HTn/0tHYHCq9r527TrsLf2fgwxiN+hlN+z
cTSWnRKZAKlTZmf+QrtPkb9Yq76ykUjO4liwhY+XeAyO9eyO2ZmgrR/cuEn1
aamYD7zh356o4crvg1Vi3z1Oosa9fL0Xf/nr6qmL0VQ70Zw+f/dfFScv8EQE
44LhS+eW8vnzdG4vq+wY3MjzOvm22Q8XHwypczHcmIhlJ+huiGYnyU3ramZ3
kjKDaaxbW1lVh8UalO6vK9rwENtpUjaWrPGLih1rPHelnb89ufnhjT/+L73z
74u8gAGdhYX8eiP/bqawAhyQ+1O5pBTELHkdnrHve+d0OS7AdqixhLMGOGpP
dBHCNGeR1vSgpMZdYMnW3VNXHu/Lku2F71xW8KyjA03vJXHV7fbd/0YpTdUX
au236CHZYMlGAK9X/MTgcbRynypKs5qfd9R3suo5E8OB4mkkn4kumxOT5uk5
+C5yuRDa6YhoJuuM1GAc/C04PtbVT783XOLC2M64oHqLkQvd/1B4Hbc8Vss3
lot/Odn5AZGJxe4HwnM8Uo+92tMt5cOVyFLHD3JeZw+K7Chjg93JWGkOQ0+q
qUX2rRfcjkmfxZUOcr6K8OAbW1KM7tCfndBPszgzp/CXZa+3/5OBEzlzvJEB
15AKdYbFeSbH0ZekGJL+3kZGZyOhtbXq4fVEZCrYIVog+xeqddHmLNjOR0Hm
9A4yTysyH1Xo3kmcSSRPLFVj/GYpc6kevYNPCZatUngjkZqG15SsCboUj06p
OVVZ2wZQTe6jOVRKXonPnw+vngX1wqXMDsWT3uTcOUN866SPSdQ4oNA7skN6
eT3YLf8xWStaL76VNmcj5c7k+Md0WXRX8lxWcRaXYKOpnshsOqrwMupwoBos
N4L/AomV9WxqFak3QtDZtesG7X/zgV8zjG8qNLr7RndNo+57tvGLY3bwrVhx
At/vC8mzMUVT2Ohx+dhGJNd23tvE32ePO2VLv436zMLPrUMbyehMegXnaoic
MIWkLmk8s+U+deGMYBkRskVls6lVdG1P8UjtxLXrNzA8oqj9jP3nxZPnQgiI
QFac1m9yjjwgi0ZUdP2lLXHHDiwY+v1qzypy4neWc3l0ugEYWepZdO36gaOE
ZrKFOofv5cNn8S2hy5Z88sfkfRHyeV33tx3/FkiAfjvkc8ra/Xzt0gZ3xB2G
0afXRFezglFJP8e+1ou3svEzZt0KF1vJ6CzFqplTpP2nDF+V4ozSMMVPwXrp
t7c+r6xXdLbJ9ViRgZC7vJzrdVg/WXLDkwf/yGD/SkcJRKzhjAePcNEMkWQL
mWnqkfFIj8MqSeRnvAB6LU57CfwtV67F2py72FWHUH3k3tpRfDQ3lZiF1bHA
MRbv5Y6fiaV6UH3Fa3sE1vaPydoOKRzk32smOlsj8Va0NSfldaSVOrPYLAYd
gPiIZ8MVkXwQ8nambZXeOFc8thYpdHgTHP0OWrSsb5BVvkTk6u5bCJbtcHMq
dWomk15BvkGkkAsOjdchRjPjtJqSD6L5n2xwPp043Xr+7cKps+Faizd/MatM
fI7xLfz7caUHJnn+cn78TOXoRmniFjLlwTJx3CXHfTxApAzEsVo9R09ZiZcw
MP2G1lz0TLCF7wNvsHOeeDXE6hiH9Xzy1fP3rM1PClfvGZAHHuZ4srhyQ+RJ
xX2iPUxB1RNosJYvMl2Wdh6e+EWyjpcljaedoNFSLzO/Xrl0P5StU1+SnloF
YYkzmqz+ZRj8fJU0x5MwB6HSeFVnq3yLf/F3jfidZHiquHrVw6gdEyiFG0fX
WaEnYPTXyOivKaOz75Q0Hoq2JvC5l0oT37+3aHUv34eBSuqIj4EOv0FGPKKM
SLzcGC1zrFz/+crqp2jV1Aq2196HVtkSzyQoOopXeoyM++0tyWu6ZT98797/
abU+pPdSgDUS2vfCKCfIKG/ouKl6MV+2vFrP36H7dhQ+HySfH1fer9bKGP8C
8Kko+dRR5V1e5fle4GCSvPvYltQPqKA9PGaGvOtNJx+gawNfKJDXvyN92oab
n+BXK+RVzA2/TV9Fy/3C/wPCKT8E\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->338397092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42198802],

Cell["\<\
Closed form of iterates of the Katsura\[Dash]Fukuda map:\
\>", "ExampleText",
 CellID->357330519],

Cell[BoxData[
 RowBox[{
  RowBox[{"xn", "[", 
   RowBox[{"n_", ",", "x0_", ",", "\[Lambda]_"}], "]"}], ":=", 
  SuperscriptBox[
   RowBox[{"JacobiSN", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["2", "n"], 
      RowBox[{"InverseJacobiSN", "[", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox["x0"]}], ",", "\[Lambda]"}], "]"}]}], ",", "\[Lambda]"}], 
    "]"}], "2"]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136067157],

Cell["Compare the closed form with explicit iterations:", "ExampleText",
 CellID->39239601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"xn", "[", 
     RowBox[{"n", ",", 
      RowBox[{"2", "/", "3"}], ",", 
      RowBox[{"3", "/", "7"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", " ", "6"}], "}"}]}], "]"}], " ", "//", 
  "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6781781],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6666666666666666`", ",", "0.9688581314878885`", ",", 
   "0.19755067898006265`", ",", "0.6003256341355919`", ",", 
   "0.9970148110751027`", ",", "0.02069511438865122`", ",", 
   "0.08037779772502468`"}], "}"}]], "Output",
 ImageSize->{492, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49653347]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x0", "=", 
       RowBox[{"2", "/", "3"}]}], ",", 
      RowBox[{"\[Lambda]", "=", 
       RowBox[{"3", "/", "7"}]}]}], "}"}], ",", 
    RowBox[{"NestList", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"4", " ", "#", 
         RowBox[{"(", 
          RowBox[{"1", "-", "#"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Lambda]", "#"}]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Lambda]", " ", 
            SuperscriptBox["#", "2"]}]}], ")"}], "2"]], "&"}], ",", " ", "x0",
       ",", "6"}], "]"}]}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->477286424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6666666666666666`", ",", "0.9688581314878892`", ",", 
   "0.19755067898006198`", ",", "0.6003256341355913`", ",", 
   "0.9970148110751033`", ",", "0.020695114388650567`", ",", 
   "0.08037779772502222`"}], "}"}]], "Output",
 ImageSize->{492, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->41814453]
}, Open  ]],

Cell["Plot few hundred iterates:", "ExampleText",
 CellID->457053091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"xn", "[", 
     RowBox[{"n", ",", "0.2`100", ",", 
      RowBox[{"2", "/", "3"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "250"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->284217469],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNm82PVEUQwId588Hs9xewC+6HfMrHEpUElQQWdgWiQRQRVyPEbIgRjAJB
DCfDUQ96w4NijETEEA8eIJJ4MjExevLq2X9k7Nf9prvfr6vfm1k9YGRm6nV1
fXRXVVdVv31p5dqFdz5YuXbx/Mrc8asrVy5cPP/h3LHLV9WjZE2lUnmg/l2f
rKjfbfVL/3vQbqvv8HOX+kwUQqK+q+p7XQZXM7jzfDx7Xqnpadl/ndEx9V2L
zKpFZyX64Xz6mZLOUKoenP5MaVRqDs5jSDNGAScl+CPpR92OC1hlXKyKwE83
Y036/YhoOtozh7EuODxqWo4VjEcl8mAJP6/j7rax4Gqgy7rVaedmRClP/Fet
RKpVq0/HA+zQ/7VzAd0koKPxGv6T7uiPyBKJmuR3cI+3zp2450cuP4JVM+/2
8ccj+BMRfBPrwvg7Ao3Wa/j7O38tHPzy889+q1wCvMHNavpaOowaZvTrtT3x
4rcKVv+/fe5Hg15VQCVRGB37wLztgJ/VK7t85q6hY0hlFmWwDOKwlnBQfX7X
iYpG3rW+vH/+8c+byz+YGcYe1JOjS1+rJ+ozAW9NpaXmv/H63cOHvjJIaoJ6
cu7svYc//51p/eknv6qxK5fuVxqgYOzCwpld1LH6QxpWhC8rEsJ4AtjuXsal
hfEBTVTRU3IvLd5KV1yPqSdLR1JQfSrQLKpSifbdEG3EYNlJme5G6nQtEoxr
Kk07LlgLcD2YvKawrtMY3yjNz/F2cvYXaOew+kQ4rn0DMOlNifOdRuuBv1Gk
D//SWqR+Pg3svYC53mtBTeM3LGwRvbXKohtiQoHn1gE3IdNayGRksLBFDGWI
6zEAmtsB1wGPQSbGwXUYHwriih2zk8iDUYWWsh1wHfAE5veJ6wqdS72XXOi9
o+ByoMR+OZ+7PQz8iZz9JsDuBzwqxgvEWQ8eATxV4g/kT2+dENd0q+ij8Sg2
UrLGA6A3K1lCIMV8SeQZKYkk9MOjIpcBzFoQI4rjUkTFzRoCVcYU+s4QuLyS
s6JByVs9bhvEXXfwPnDbLerAWLtB9CQH7wOXGcmfO6laxWaqXv6ZVPJ1Xvrz
VPrR9DMLR3ETJJiBBBnHXAZbB0+RX8vSaHei8NLhW7m45qR4ClJIXBvgYjXP
aBiuftZm6J08cdvfQ+HkOiRwa4Jb6ikpuAuSbxP9GDssnFQ8jbYAHuxSJg1H
ov84ZNsG2eiH/cDfAliSSe99+CTIAMbEdYp76zTGZzC+BfBg4BmNzNPrnjzx
05zxdy/g15x/13GaB169A7Iz/3O0Uvn6gb0fnN8SIwtzzP3gUTTLYb0vWXMw
i5H1AmBtR3X6+KSEZbXmqXoW2C2MGx706EkJKyI/7dzxOgkqLSkaefCk5EcB
V+YhJzGLOfB4ARXYjjdrDlxkKlsx6whmMXJwBRzVdO8Y83hKzWH2BPBnC2SM
7xIzomeAL1NlZbENsJx3OarzwN8ZxJnEiwkZU6EuZ6Zfdm5wx5hlMrN/rB3G
5uiJmZPJ8eT5sBM8mRlzbbmWkkyp39ey71SUA6DBPJdnlFzhxNcxJoOfv3Cv
WL8w/vGcnBX3hvECVZ2QU1UFWeYwV84gHW9WQ7OAx0q8qhfZBktoMftdLPG1
RuBbzHhowYMlFBchISXSFm3jGnMQ7hvt4jk725eJ0ZA1N1eNmRC9sIBLzfY6
1UT2Crg29E5GmAMFfPzOp+579Pl5druTDN34+BfzZDN4sSKUqyXaalkNthn4
rBgdl6qNNPHaizWIXHtR5puS7wdY9Lob4FU0K35Ky2dZvCJeLOASP6150jDn
ol1xlxzXqq2f4r1S5lbVjv1Za2OEl7ViPsy6lhWo3D1w8I42YxNjUS5CZrOW
IYWpjQzVF45/E1kx9iIy3t3UXRnvdNZpaOBn6c8fuRXxAsbA7nknNoI6nhtF
i413gpjzPd2b5tkTrh87/oyw68W4UlyLdzQuup+RevOHALOLxQ6bxJs8qT/j
xGXQ1Pi5flBRHd1sexWbuwG109ndpUeLN2X0LN7iFfRfR62/p1LpYTtIXGZi
9DTi7wC8gPmOt7cSdph1PrMRjvNUZOw77bh5u/skZKTPMSs/U0AFfu/6VHY6
o7tMjX7Lqsl0wSw33CY6KRz1dG95ns8DZsbDnhpz5z0FsrPii98nMCtkZSdz
eRlUeYqyFuMubhWpvodZ2nubfucVq1Ha27mWwn1+OmfPKYs0ndsl+hBX/ZgU
H/pxDoWGF9wCddfbYT+E9SX7SowQ1YilDmOekabrfCB7xuqWuRcjArvCtDX2
acQ3K4KbNXauej1f6RGPA2bfmLbNOvGJVUkh303x5I13YWlf7LQxGo9Le1dQ
KSe2AxPv+jDzmAUPWrPEs9uVQk+k4JaZdQRXZhZSlXUPVyc114pdF97blnUd
ZwKPzd0QBJyZlbo3d8o6kYZTWSeS/V+xE5mrfJYt3apgW3x/IaycKDdXkCfb
zgI94nVy2dsCzIoolXgytsLby4vv/rTg3WEGcnI9GAvF+4mgfxIfN3KFt5yH
D2ZvfxXKFe/I0ftoNzxvuV48A7Q3tiy/didh/eLm7xEJ3DtdqZ0xq2LFwtyP
J6z8NgnljcddWd84P/mNNHbhmPfwTGO0YUxj5kqr5y7z5KdWpF+kRdy3GKlp
C/J7ePF8g3vPWoOrRPpjohZ894IW3wLMvdM5m1CrUBvW/XqPhPt/9gsYKaZE
Ldid01LnOrKaX/bm6aun7ihSRvIwu0yCueJdS8O/YzUU2W9gt44xvpnzbcYW
am508ru/9F7NP1cv2I6CnaPzw+DuVttW5K0UzaXfwvjhOmc8O5riTskRJO67
pEpf57sHRpPwJLBxZhBy22F24/RqZv3B6x89zJ4arfJ/ocL3cKU8pqzfwIyW
tqTHWzhtc/tEjyOHondr9VzWgXY4vhvaJgP9wzf2bYZpxeFJRbvg+zL0JWqb
eLvlshFGM81lGLlBO3gnKmc1Yic/5yvx896XytkQbb6nVUx7XRBX29qIKFHY
WLSBoawXWPMihZ0UudeI3ziYFWA2pqlsKpDSJESGrVk4G6xCTcAtlwfK8sfl
pdeE/Vl4WJf7lui2hIu4es/6QkmDk6hA1l7fxmd/RoTrzEhjXZh6EGlBSXjT
TpYgHt2Jzy5krSDa97I7UgeZJ5Gcr8Xh1f2lQfwkZL7Jt475NkKtIN73tDYe
xm3zWKjb7+lH4V8sVdb8C/XiUNU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->513098073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106121680],

Cell["\<\
Implicitly defined periodic maximal surface in Minkowski space:\
\>", "ExampleText",
 CellID->70197799],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{
    RowBox[{"JacobiSN", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"u", "[", 
        RowBox[{"x", ",", " ", "y"}], "]"}], 
       SqrtBox[
        RowBox[{"1", "-", "m"}]]], ",", "m"}], "]"}], "-", 
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cosh", "[", "y", "]"}]]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->545403570],

Cell["Calculate partial derivatives:", "ExampleText",
 CellID->775042007],

Cell[BoxData[
 RowBox[{
  RowBox[{"partials", " ", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"F", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"F", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", " ", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"F", ",", "x", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"F", ",", "x", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
        " ", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"F", ",", "y", ",", "y"}], "]"}], "\[Equal]", "0"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", " ", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "x"}], "]"}], ",", 
        " ", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y"}], "]"}], ",", 
        " ", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", "y", ",", "y"}], "]"}]}], 
       "}"}]}], "]"}], "//", "Simplify"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38110743],

Cell["Check numerically the equation for a maximal surface:", "ExampleText",
 CellID->286886582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[PartialD]", "y"], 
           RowBox[{"u", "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        RowBox[{"x", ",", "x"}]], 
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "y"], 
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        RowBox[{"x", ",", "y"}]], 
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[PartialD]", "x"], 
           RowBox[{"u", "[", 
            RowBox[{"x", ",", "y"}], "]"}]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        RowBox[{"y", ",", "y"}]], 
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}]}]}], "/.", "partials"}], " ", "/.", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", "m"}]], " ", 
     RowBox[{"InverseJacobiSN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sech", "[", "y", "]"}], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}], ",", "m"}], "]"}]}]}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "2"}], ",", 
    RowBox[{"m", "\[Rule]", "3``100"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->442171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0``96.13089462642698", "+", 
   RowBox[{"0``95.77922043058626", " ", "\[ImaginaryI]"}]}], "}"}]], "Output",\

 ImageSize->{152, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->71011110]
}, Open  ]],

Cell["Plot the maximal surface in Euclidean space:", "ExampleText",
 CellID->590635541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", "m"}]], " ", 
      RowBox[{"InverseJacobiSN", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"Sin", "[", "x", "]"}], 
         RowBox[{"Cosh", "[", "y", "]"}]], ",", "m"}], "]"}]}], "/.", 
     RowBox[{"m", "\[Rule]", 
      RowBox[{"1", "/", "3"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->529739353],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->909369650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14003814],

Cell[TextData[{
 "Solution of the Euler top equations for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "B"], "<", 
    FractionBox["\[ScriptCapitalE]", 
     SuperscriptBox["M", "2"]], "<", 
    FractionBox["1", "C"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->900364896],

Cell[BoxData[{
 RowBox[{
  RowBox[{"M1", "[", "t_", "]"}], ":=", 
  RowBox[{
   SqrtBox[
    RowBox[{"A", " ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["M", "2"], "-", 
       RowBox[{"C", " ", "\[ScriptCapitalE]"}]}], 
      RowBox[{"A", "-", "C"}]]}]], 
   RowBox[{"JacobiCN", "[", 
    RowBox[{
     RowBox[{
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"B", "-", "C"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "\[ScriptCapitalE]"}], "-", 
           SuperscriptBox["M", "2"]}], ")"}]}], 
        RowBox[{"A", " ", "B", " ", "C"}]]], " ", "t"}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "-", "B"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["M", "2"], "-", 
         RowBox[{"C", " ", "\[ScriptCapitalE]"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B", "-", "C"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", " ", "\[ScriptCapitalE]"}], "-", 
         SuperscriptBox["M", "2"]}], ")"}]}]]}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"M2", "[", "t_", "]"}], ":=", 
  RowBox[{
   SqrtBox[
    RowBox[{"B", " ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["M", "2"], "-", 
       RowBox[{"C", " ", "\[ScriptCapitalE]"}]}], 
      RowBox[{"B", "-", "C"}]]}]], " ", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{
     RowBox[{
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"B", "-", "C"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "\[ScriptCapitalE]"}], "-", 
           SuperscriptBox["M", "2"]}], ")"}]}], 
        RowBox[{"A", " ", "B", " ", "C"}]]], " ", "t"}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "-", "B"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["M", "2"], "-", 
         RowBox[{"C", " ", "\[ScriptCapitalE]"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B", "-", "C"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", " ", "\[ScriptCapitalE]"}], "-", 
         SuperscriptBox["M", "2"]}], ")"}]}]]}], "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"M3", "[", "t_", "]"}], ":=", 
  RowBox[{
   SqrtBox[
    RowBox[{"C", " ", 
     FractionBox[
      RowBox[{
       RowBox[{"A", " ", "\[ScriptCapitalE]"}], "-", 
       SuperscriptBox["M", "2"]}], 
      RowBox[{"A", "-", "C"}]]}]], " ", 
   RowBox[{"JacobiDN", "[", 
    RowBox[{
     RowBox[{
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"B", "-", "C"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "\[ScriptCapitalE]"}], "-", 
           SuperscriptBox["M", "2"]}], ")"}]}], 
        RowBox[{"A", " ", "B", " ", "C"}]]], " ", "t"}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "-", "B"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["M", "2"], "-", 
         RowBox[{"C", " ", "\[ScriptCapitalE]"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B", "-", "C"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", " ", "\[ScriptCapitalE]"}], "-", 
         SuperscriptBox["M", "2"]}], ")"}]}]]}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->61908539],

Cell["Check the solutions numerically:", "ExampleText",
 CellID->811821954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"M1", "'"}], "[", "t", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "B"], "-", 
        FractionBox["1", "C"]}], ")"}], 
      RowBox[{"M2", "[", "t", "]"}], " ", 
      RowBox[{"M3", "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"M2", "'"}], "[", "t", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "C"], "-", 
        FractionBox["1", "A"]}], ")"}], 
      RowBox[{"M3", "[", "t", "]"}], " ", 
      RowBox[{"M1", "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"M3", "'"}], "[", "t", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "A"], "-", 
        FractionBox["1", "B"]}], ")"}], 
      RowBox[{"M1", "[", "t", "]"}], " ", 
      RowBox[{"M2", "[", "t", "]"}]}]}]}], "}"}], " ", "/.", " ", 
  "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"M", "\[Rule]", "1"}], ",", 
    RowBox[{"\[ScriptCapitalE]", "\[Rule]", "1"}], ",", 
    RowBox[{"B", "\[Rule]", "2"}], ",", 
    RowBox[{"C", "\[Rule]", 
     RowBox[{"1", "/", "2"}]}], ",", 
    RowBox[{"A", "\[Rule]", "4"}], ",", 
    RowBox[{"t", "\[Rule]", "2."}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->380049673],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2017943]
}, Open  ]],

Cell["Plot the solutions:", "ExampleText",
 CellID->307433653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A", "=", "4"}], ",", 
     RowBox[{"B", "=", "2"}], ",", 
     RowBox[{"C", "=", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{"M", "=", "1"}], ",", 
     RowBox[{"\[ScriptCapitalE]", "=", "1"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"M1", "[", "t", "]"}], ",", 
        RowBox[{"M2", "[", "t", "]"}], ",", 
        RowBox[{"M3", "[", "t", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "12"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31968093],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->35678449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195098978],

Cell[TextData[{
 "Define a compacton solution of the nonlinear differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["u", "\[Prime]",
       MultilineFunction->None], "(", "\[Xi]", ")"}], "2"], "\[LongEqual]", 
    RowBox[{
     RowBox[{"u", "(", "\[Xi]", ")"}], "-", 
     SuperscriptBox[
      RowBox[{"u", "(", "\[Xi]", ")"}], "3"]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->457679889],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "\[Xi]_", "]"}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"JacobiSN", "[", 
      RowBox[{
       FractionBox["\[Xi]", "2"], ",", 
       RowBox[{"-", "1"}]}], "]"}], "2"], " ", 
    RowBox[{"Boole", "[", 
     RowBox[{"0", "\[LessEqual]", "\[Xi]", "\[LessEqual]", 
      RowBox[{"4", " ", 
       RowBox[{"EllipticK", "[", 
        RowBox[{"-", "1"}], "]"}]}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->592968067],

Cell["Verify the solution:", "ExampleText",
 CellID->389183570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{
     RowBox[{"u", "'"}], "[", "\[Xi]", "]"}], "2"], "==", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"u", "[", "\[Xi]", "]"}], "3"]}], " ", "+", " ", 
    RowBox[{"u", "[", "\[Xi]", "]"}]}]}], "/.", 
  RowBox[{"\[Xi]", "\[Rule]", 
   RowBox[{"1", "/", "3`50"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280418753],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->590356852]
}, Open  ]],

Cell["Plot the compacton:", "ExampleText",
 CellID->203380214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"u", "[", "\[Xi]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     RowBox[{"-", "1"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->340801477],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->85319661]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26083],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->60474188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{
     RowBox[{"InverseJacobiSN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{
     RowBox[{"JacobiSN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10346836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{
     RowBox[{"JacobiSN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195388471]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261361129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44281067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1057110923],

Cell[TextData[{
 "Evaluate as a result of applying ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->75877325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"JacobiAmplitude", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183159778],

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{"z", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13796147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26733726],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->359994467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiSN", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiSN", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68486567],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->45309518],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiSN", "[", 
       RowBox[{
        RowBox[{"1", "-", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiSN", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->899032536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30410386],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->342411737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiSN", "[", 
       RowBox[{"2", ",", "m"}], "]"}], "2"], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"JacobiSN", "[", 
        RowBox[{"4", ",", "m"}], "]"}], "2"]}]}], "\[Equal]", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->322259562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"m", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "1.9454647747395872`"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100090827]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152043587],

Cell["Integrals:", "ExampleText",
 CellID->492528614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38096870],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox["m"]}], " ", 
     RowBox[{"JacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}], "+", 
    RowBox[{"JacobiDN", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], "]"}], 
  SqrtBox["m"]]], "Output",
 ImageSize->{281, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->605251540]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"JacobiSN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "3"}], ",", " ", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85410578],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"JacobiCN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], " ", 
    RowBox[{"JacobiDN", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "m"}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox["m"]}], " ", 
        RowBox[{"JacobiCN", "[", 
         RowBox[{"z", ",", "m"}], "]"}]}], "+", 
       RowBox[{"JacobiDN", "[", 
        RowBox[{"z", ",", "m"}], "]"}]}], "]"}]}], 
    SqrtBox["m"]]}], 
  RowBox[{"2", " ", "m"}]]], "Output",
 ImageSize->{437, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222720993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79722263],

Cell["Solve the Painleve-VIII differential equation:", "ExampleText",
 CellID->2497687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"w", "''"}], "[", "z", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"w", "[", "z", "]"}], "+", 
     RowBox[{"2", 
      RowBox[{
       RowBox[{"w", "[", "z", "]"}], "^", "3"}]}]}]}], ",", 
   RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->628300303],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->429182808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["2"]], 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{"4", " ", 
             RowBox[{"C", "[", "1", "]"}]}]}]]}]], " ", 
        RowBox[{"JacobiSN", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", 
            SqrtBox["2"]], 
           RowBox[{"(", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["z", "2"]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                SqrtBox[
                 RowBox[{"1", "-", 
                  RowBox[{"4", " ", 
                   RowBox[{"C", "[", "1", "]"}]}]}]]}], "-", 
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"C", "[", "2", "]"}]}], "+", 
               RowBox[{"2", " ", "z", " ", 
                SqrtBox[
                 RowBox[{"1", "-", 
                  RowBox[{"4", " ", 
                   RowBox[{"C", "[", "1", "]"}]}]}]], " ", 
                RowBox[{"C", "[", "2", "]"}]}], "-", 
               SuperscriptBox[
                RowBox[{"C", "[", "2", "]"}], "2"], "+", 
               RowBox[{
                SqrtBox[
                 RowBox[{"1", "-", 
                  RowBox[{"4", " ", 
                   RowBox[{"C", "[", "1", "]"}]}]}]], " ", 
                SuperscriptBox[
                 RowBox[{"C", "[", "2", "]"}], "2"]}]}], ")"}]}], ")"}]}], 
          ",", 
          FractionBox[
           RowBox[{"1", "+", 
            SqrtBox[
             RowBox[{"1", "-", 
              RowBox[{"4", " ", 
               RowBox[{"C", "[", "1", "]"}]}]}]]}], 
           RowBox[{"1", "-", 
            SqrtBox[
             RowBox[{"1", "-", 
              RowBox[{"4", " ", 
               RowBox[{"C", "[", "1", "]"}]}]}]]}]]}], "]"}]}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["2"]], 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"4", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}]]}]], " ", 
       RowBox[{"JacobiSN", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", 
           SqrtBox["2"]], 
          RowBox[{"(", 
           RowBox[{"\[Sqrt]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["z", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SqrtBox[
                RowBox[{"1", "-", 
                 RowBox[{"4", " ", 
                  RowBox[{"C", "[", "1", "]"}]}]}]]}], "-", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{"C", "[", "2", "]"}]}], "+", 
              RowBox[{"2", " ", "z", " ", 
               SqrtBox[
                RowBox[{"1", "-", 
                 RowBox[{"4", " ", 
                  RowBox[{"C", "[", "1", "]"}]}]}]], " ", 
               RowBox[{"C", "[", "2", "]"}]}], "-", 
              SuperscriptBox[
               RowBox[{"C", "[", "2", "]"}], "2"], "+", 
              RowBox[{
               SqrtBox[
                RowBox[{"1", "-", 
                 RowBox[{"4", " ", 
                  RowBox[{"C", "[", "1", "]"}]}]}]], " ", 
               SuperscriptBox[
                RowBox[{"C", "[", "2", "]"}], "2"]}]}], ")"}]}], ")"}]}], ",",
          
         FractionBox[
          RowBox[{"1", "+", 
           SqrtBox[
            RowBox[{"1", "-", 
             RowBox[{"4", " ", 
              RowBox[{"C", "[", "1", "]"}]}]}]]}], 
          RowBox[{"1", "-", 
           SqrtBox[
            RowBox[{"1", "-", 
             RowBox[{"4", " ", 
              RowBox[{"C", "[", "1", "]"}]}]}]]}]]}], "]"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{534, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1062069]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23316],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->185729643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{
   RowBox[{"10.", "^", "20"}], ",", "E"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286079947],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548638470]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{
     RowBox[{"10", "^", "20"}], ",", "E"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57974428],

Cell[BoxData[
 RowBox[{"0.59179625416907716256867355555266035193`20.15051499783199", "+", 
  RowBox[{"0``20.37834278590709", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->162823162]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51763701],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->350342914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"JacobiSN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"JacobiCN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "2"}], "-", "1"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307497241],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox[
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "2"]}]], "Output",
 ImageSize->{246, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->633079167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiND", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiDS", "[", 
    RowBox[{"u", ",", "m"}], "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15030758],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83225808]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29528],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiAmplitude",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiAmplitude"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSD"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6249]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4561],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->2737]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->361521457],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->783923166],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->244593573],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->582108113]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
JacobiSN"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiSN - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 40.1380084}", "context" -> "System`", 
    "keywords" -> {
     "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic functions", "Jacobi elliptic function sn", 
      "pendulum problem", "sn", "snoid"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiSN[u, m] gives the Jacobi elliptic function sn(u | m).", 
    "synonyms" -> {"Jacobi SN"}, "title" -> "JacobiSN", "type" -> "Symbol", 
    "uri" -> "ref/JacobiSN"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6601, 227, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->224356821]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 122763, 3418}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2449, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3072, 85, 45, 1, 70, "ObjectName",
 CellID->7794],
Cell[3120, 88, 675, 22, 70, "Usage",
 CellID->3490]
}, Open  ]],
Cell[CellGroupData[{
Cell[3832, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4310, 132, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4433, 138, 391, 15, 70, "Notes",
 CellID->32267],
Cell[4827, 155, 843, 30, 70, "Notes",
 CellID->54696440],
Cell[5673, 187, 215, 7, 70, "Notes",
 CellID->93074778],
Cell[5891, 196, 248, 8, 70, "Notes",
 CellID->155112946],
Cell[6142, 206, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6363, 215, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6601, 227, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->224356821],
Cell[CellGroupData[{
Cell[6986, 241, 148, 5, 70, "ExampleSection",
 CellID->221069697],
Cell[7137, 248, 63, 1, 70, "ExampleText",
 CellID->27705717],
Cell[CellGroupData[{
Cell[7225, 253, 131, 4, 28, "Input",
 CellID->110961154],
Cell[7359, 259, 176, 5, 36, "Output",
 CellID->136588789]
}, Open  ]],
Cell[7550, 267, 125, 3, 70, "ExampleDelimiter",
 CellID->168566607],
Cell[CellGroupData[{
Cell[7700, 274, 291, 10, 28, "Input",
 CellID->24633561],
Cell[7994, 286, 3901, 68, 136, "Output",
 Evaluatable->False,
 CellID->350224094]
}, Open  ]],
Cell[11910, 357, 124, 3, 70, "ExampleDelimiter",
 CellID->71743901],
Cell[12037, 362, 78, 1, 70, "ExampleText",
 CellID->175072069],
Cell[CellGroupData[{
Cell[12140, 367, 243, 8, 70, "Input",
 CellID->7816907],
Cell[12386, 377, 1342, 42, 56, "Output",
 CellID->76403001]
}, Open  ]],
Cell[CellGroupData[{
Cell[13765, 424, 245, 8, 70, "Input",
 CellID->565039078],
Cell[14013, 434, 924, 29, 51, "Output",
 CellID->135578337]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14986, 469, 216, 7, 70, "ExampleSection",
 CellID->20351],
Cell[15205, 478, 74, 1, 70, "ExampleText",
 CellID->257841689],
Cell[CellGroupData[{
Cell[15304, 483, 177, 6, 70, "Input",
 CellID->325910105],
Cell[15484, 491, 271, 8, 36, "Output",
 CellID->288260610]
}, Open  ]],
Cell[15770, 502, 124, 3, 70, "ExampleDelimiter",
 CellID->25415347],
Cell[15897, 507, 70, 1, 70, "ExampleText",
 CellID->856906711],
Cell[CellGroupData[{
Cell[15992, 512, 207, 7, 70, "Input",
 CellID->69210409],
Cell[16202, 521, 234, 7, 36, "Output",
 CellID->470931450]
}, Open  ]],
Cell[16451, 531, 113, 3, 70, "ExampleText",
 CellID->372977787],
Cell[CellGroupData[{
Cell[16589, 538, 171, 5, 70, "Input",
 CellID->2714330],
Cell[16763, 545, 238, 6, 36, "Output",
 CellID->212274494]
}, Open  ]],
Cell[17016, 554, 125, 3, 70, "ExampleDelimiter",
 CellID->182528140],
Cell[17144, 559, 210, 7, 70, "ExampleText",
 CellID->747487832],
Cell[CellGroupData[{
Cell[17379, 570, 178, 6, 70, "Input",
 CellID->536864854],
Cell[17560, 578, 328, 11, 36, "Output",
 CellID->225772103]
}, Open  ]],
Cell[17903, 592, 125, 3, 70, "ExampleDelimiter",
 CellID->259414736],
Cell[18031, 597, 91, 1, 70, "ExampleText",
 CellID->276511220],
Cell[CellGroupData[{
Cell[18147, 602, 237, 8, 70, "Input",
 CellID->365032203],
Cell[18387, 612, 267, 9, 36, "Output",
 CellID->136369750]
}, Open  ]],
Cell[CellGroupData[{
Cell[18691, 626, 420, 15, 70, "Input",
 CellID->175336906],
Cell[19114, 643, 319, 12, 62, "Output",
 CellID->89975962]
}, Open  ]],
Cell[19448, 658, 125, 3, 70, "ExampleText",
 CellID->691227904],
Cell[CellGroupData[{
Cell[19598, 665, 145, 5, 70, "Input",
 CellID->79128576],
Cell[19746, 672, 234, 8, 36, "Output",
 CellID->16897672]
}, Open  ]],
Cell[CellGroupData[{
Cell[20017, 685, 320, 10, 70, "Input",
 CellID->23662150],
Cell[20340, 697, 214, 7, 36, "Output",
 CellID->5935448]
}, Open  ]],
Cell[20569, 707, 125, 3, 70, "ExampleDelimiter",
 CellID->215688415],
Cell[20697, 712, 203, 7, 70, "ExampleText",
 CellID->178560258],
Cell[CellGroupData[{
Cell[20925, 723, 166, 5, 70, "Input",
 CellID->292152639],
Cell[21094, 730, 276, 9, 50, "Output",
 CellID->1610708]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21419, 745, 239, 7, 70, "ExampleSection",
 CellID->31356],
Cell[21661, 754, 209, 7, 70, "ExampleText",
 CellID->541124796],
Cell[CellGroupData[{
Cell[21895, 765, 243, 8, 70, "Input",
 CellID->271512446],
Cell[22141, 775, 1171, 37, 54, "Output",
 CellID->728049004]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23361, 818, 223, 7, 70, "ExampleSection",
 CellID->27774],
Cell[23587, 827, 97, 1, 70, "ExampleText",
 CellID->243016522],
Cell[CellGroupData[{
Cell[23709, 832, 1742, 54, 70, "Input",
 CellID->419126679],
Cell[25454, 888, 3019, 54, 70, "Output",
 Evaluatable->False,
 CellID->483472707]
}, Open  ]],
Cell[28488, 945, 124, 3, 70, "ExampleDelimiter",
 CellID->45086770],
Cell[28615, 950, 76, 1, 70, "ExampleText",
 CellID->31743841],
Cell[CellGroupData[{
Cell[28716, 955, 473, 16, 70, "Input",
 CellID->29058975],
Cell[29192, 973, 457, 15, 52, "Output",
 CellID->752145551]
}, Open  ]],
Cell[29664, 991, 62, 1, 70, "ExampleText",
 CellID->764811467],
Cell[CellGroupData[{
Cell[29751, 996, 423, 14, 70, "Input",
 CellID->11685600],
Cell[30177, 1012, 177, 5, 36, "Output",
 CellID->190721973]
}, Open  ]],
Cell[30369, 1020, 56, 1, 70, "ExampleText",
 CellID->3891738],
Cell[CellGroupData[{
Cell[30450, 1025, 556, 18, 70, "Input",
 CellID->278565811],
Cell[31009, 1045, 4584, 79, 70, "Output",
 Evaluatable->False,
 CellID->746345128]
}, Open  ]],
Cell[35608, 1127, 125, 3, 70, "ExampleDelimiter",
 CellID->252365793],
Cell[35736, 1132, 80, 1, 70, "ExampleText",
 CellID->149088002],
Cell[35819, 1135, 1574, 46, 70, "Input",
 CellID->282606447],
Cell[37396, 1183, 76, 1, 70, "ExampleText",
 CellID->86046418],
Cell[CellGroupData[{
Cell[37497, 1188, 1051, 35, 70, "Input",
 CellID->109683327],
Cell[38551, 1225, 162, 5, 36, "Output",
 CellID->10131165]
}, Open  ]],
Cell[38728, 1233, 61, 1, 70, "ExampleText",
 CellID->708833465],
Cell[CellGroupData[{
Cell[38814, 1238, 594, 19, 70, "Input",
 CellID->118294239],
Cell[39411, 1259, 14515, 242, 70, "Output",
 Evaluatable->False,
 CellID->338397092]
}, Open  ]],
Cell[53941, 1504, 124, 3, 70, "ExampleDelimiter",
 CellID->42198802],
Cell[54068, 1509, 107, 3, 70, "ExampleText",
 CellID->357330519],
Cell[54178, 1514, 441, 15, 70, "Input",
 CellID->136067157],
Cell[54622, 1531, 91, 1, 70, "ExampleText",
 CellID->39239601],
Cell[CellGroupData[{
Cell[54738, 1536, 342, 12, 70, "Input",
 CellID->6781781],
Cell[55083, 1550, 397, 11, 36, "Output",
 CellID->49653347]
}, Open  ]],
Cell[CellGroupData[{
Cell[55517, 1566, 813, 27, 70, "Input",
 CellID->477286424],
Cell[56333, 1595, 398, 11, 36, "Output",
 CellID->41814453]
}, Open  ]],
Cell[56746, 1609, 69, 1, 70, "ExampleText",
 CellID->457053091],
Cell[CellGroupData[{
Cell[56840, 1614, 323, 10, 70, "Input",
 CellID->284217469],
Cell[57166, 1626, 3474, 61, 70, "Output",
 Evaluatable->False,
 CellID->513098073]
}, Open  ]],
Cell[60655, 1690, 125, 3, 70, "ExampleDelimiter",
 CellID->106121680],
Cell[60783, 1695, 113, 3, 70, "ExampleText",
 CellID->70197799],
Cell[60899, 1700, 425, 15, 70, "Input",
 CellID->545403570],
Cell[61327, 1717, 73, 1, 70, "ExampleText",
 CellID->775042007],
Cell[61403, 1720, 1681, 51, 70, "Input",
 CellID->38110743],
Cell[63087, 1773, 96, 1, 70, "ExampleText",
 CellID->286886582],
Cell[CellGroupData[{
Cell[63208, 1778, 1961, 64, 70, "Input",
 CellID->442171],
Cell[65172, 1844, 279, 9, 39, "Output",
 CellID->71011110]
}, Open  ]],
Cell[65466, 1856, 87, 1, 70, "ExampleText",
 CellID->590635541],
Cell[CellGroupData[{
Cell[65578, 1861, 712, 23, 70, "Input",
 CellID->529739353],
Cell[66293, 1886, 19582, 325, 70, "Output",
 Evaluatable->False,
 CellID->909369650]
}, Open  ]],
Cell[85890, 2214, 124, 3, 70, "ExampleDelimiter",
 CellID->14003814],
Cell[86017, 2219, 314, 11, 70, "ExampleText",
 CellID->900364896],
Cell[86334, 2232, 3418, 116, 70, "Input",
 CellID->61908539],
Cell[89755, 2350, 75, 1, 70, "ExampleText",
 CellID->811821954],
Cell[CellGroupData[{
Cell[89855, 2355, 1424, 45, 70, "Input",
 CellID->380049673],
Cell[91282, 2402, 221, 7, 36, "Output",
 CellID->2017943]
}, Open  ]],
Cell[91518, 2412, 62, 1, 70, "ExampleText",
 CellID->307433653],
Cell[CellGroupData[{
Cell[91605, 2417, 731, 23, 70, "Input",
 CellID->31968093],
Cell[92339, 2442, 5574, 95, 70, "Output",
 Evaluatable->False,
 CellID->35678449]
}, Open  ]],
Cell[97928, 2540, 125, 3, 70, "ExampleDelimiter",
 CellID->195098978],
Cell[98056, 2545, 484, 16, 70, "ExampleText",
 CellID->457679889],
Cell[98543, 2563, 500, 16, 70, "Input",
 CellID->592968067],
Cell[99046, 2581, 63, 1, 70, "ExampleText",
 CellID->389183570],
Cell[CellGroupData[{
Cell[99134, 2586, 408, 14, 70, "Input",
 CellID->280418753],
Cell[99545, 2602, 161, 5, 36, "Output",
 CellID->590356852]
}, Open  ]],
Cell[99721, 2610, 62, 1, 70, "ExampleText",
 CellID->203380214],
Cell[CellGroupData[{
Cell[99808, 2615, 240, 8, 70, "Input",
 CellID->340801477],
Cell[100051, 2625, 2603, 47, 70, "Output",
 Evaluatable->False,
 CellID->85319661]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102703, 2678, 233, 7, 70, "ExampleSection",
 CellID->26083],
Cell[102939, 2687, 73, 1, 70, "ExampleText",
 CellID->60474188],
Cell[CellGroupData[{
Cell[103037, 2692, 380, 12, 70, "Input",
 CellID->10346836],
Cell[103420, 2706, 337, 11, 36, "Output",
 CellID->195388471]
}, Open  ]],
Cell[103772, 2720, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[104043, 2732, 107, 3, 70, "Input",
 CellID->261361129],
Cell[104153, 2737, 202, 7, 36, "Output",
 CellID->44281067]
}, Open  ]],
Cell[104370, 2747, 126, 3, 70, "ExampleDelimiter",
 CellID->1057110923],
Cell[104499, 2752, 347, 13, 70, "ExampleText",
 CellID->75877325],
Cell[CellGroupData[{
Cell[104871, 2769, 165, 5, 70, "Input",
 CellID->183159778],
Cell[105039, 2776, 215, 7, 36, "Output",
 CellID->13796147]
}, Open  ]],
Cell[105269, 2786, 124, 3, 70, "ExampleDelimiter",
 CellID->26733726],
Cell[105396, 2791, 75, 1, 70, "ExampleText",
 CellID->359994467],
Cell[CellGroupData[{
Cell[105496, 2796, 358, 13, 70, "Input",
 CellID->68486567],
Cell[105857, 2811, 452, 8, 70, "Message",
 CellID->45309518],
Cell[106312, 2821, 665, 24, 43, "Output",
 CellID->899032536]
}, Open  ]],
Cell[106992, 2848, 124, 3, 70, "ExampleDelimiter",
 CellID->30410386],
Cell[107119, 2853, 96, 1, 70, "ExampleText",
 CellID->342411737],
Cell[CellGroupData[{
Cell[107240, 2858, 490, 17, 70, "Input",
 CellID->322259562],
Cell[107733, 2877, 311, 10, 36, "Output",
 CellID->100090827]
}, Open  ]],
Cell[108059, 2890, 125, 3, 70, "ExampleDelimiter",
 CellID->152043587],
Cell[108187, 2895, 53, 1, 70, "ExampleText",
 CellID->492528614],
Cell[CellGroupData[{
Cell[108265, 2900, 193, 6, 70, "Input",
 CellID->38096870],
Cell[108461, 2908, 435, 16, 64, "Output",
 CellID->605251540]
}, Open  ]],
Cell[CellGroupData[{
Cell[108933, 2929, 222, 8, 70, "Input",
 CellID->85410578],
Cell[109158, 2939, 760, 27, 78, "Output",
 CellID->222720993]
}, Open  ]],
Cell[109933, 2969, 124, 3, 70, "ExampleDelimiter",
 CellID->79722263],
Cell[110060, 2974, 87, 1, 70, "ExampleText",
 CellID->2497687],
Cell[CellGroupData[{
Cell[110172, 2979, 384, 13, 70, "Input",
 CellID->628300303],
Cell[110559, 2994, 453, 8, 70, "Message",
 CellID->429182808],
Cell[111015, 3004, 4245, 128, 209, "Output",
 CellID->1062069]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[115309, 3138, 226, 7, 70, "ExampleSection",
 CellID->23316],
Cell[115538, 3147, 118, 3, 70, "ExampleText",
 CellID->185729643],
Cell[CellGroupData[{
Cell[115681, 3154, 154, 5, 70, "Input",
 CellID->286079947],
Cell[115838, 3161, 240, 7, 36, "Output",
 CellID->548638470]
}, Open  ]],
Cell[CellGroupData[{
Cell[116115, 3173, 212, 8, 70, "Input",
 CellID->57974428],
Cell[116330, 3183, 292, 7, 36, "Output",
 CellID->162823162]
}, Open  ]],
Cell[116637, 3193, 124, 3, 70, "ExampleDelimiter",
 CellID->51763701],
Cell[116764, 3198, 130, 4, 70, "ExampleText",
 CellID->350342914],
Cell[CellGroupData[{
Cell[116919, 3206, 314, 11, 70, "Input",
 CellID->307497241],
Cell[117236, 3219, 379, 13, 36, "Output",
 CellID->633079167]
}, Open  ]],
Cell[CellGroupData[{
Cell[117652, 3237, 309, 10, 70, "Input",
 CellID->15030758],
Cell[117964, 3249, 157, 5, 36, "Output",
 CellID->83225808]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[118182, 3261, 311, 9, 70, "SeeAlsoSection",
 CellID->29528],
Cell[118496, 3272, 968, 35, 70, "SeeAlso",
 CellID->6249]
}, Open  ]],
Cell[CellGroupData[{
Cell[119501, 3312, 313, 9, 70, "TutorialsSection",
 CellID->4561],
Cell[119817, 3323, 191, 4, 70, "Tutorials",
 CellID->2737]
}, Open  ]],
Cell[CellGroupData[{
Cell[120045, 3332, 319, 9, 70, "MoreAboutSection",
 CellID->361521457],
Cell[120367, 3343, 147, 3, 70, "MoreAbout",
 CellID->783923166],
Cell[120517, 3348, 155, 3, 70, "MoreAbout",
 CellID->244593573],
Cell[120675, 3353, 145, 3, 70, "MoreAbout",
 CellID->582108113]
}, Open  ]],
Cell[CellGroupData[{
Cell[120857, 3361, 305, 8, 70, "RelatedLinksSection"],
Cell[121165, 3371, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[121566, 3387, 27, 0, 70, "History"],
Cell[121596, 3389, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

