(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37111,       1317]
NotebookOptionsPosition[     29925,       1065]
NotebookOutlinePosition[     31165,       1101]
CellTagsIndexPosition[     31079,       1096]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"KroneckerSymbol" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerSymbol"], 
          "FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], "MoebiusMu" :> 
          Documentation`HelpLookup["paclet:ref/MoebiusMu"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"KroneckerSymbol\"\>", 
       2->"\<\"FactorInteger\"\>", 
       3->"\<\"MoebiusMu\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 
       4->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiSymbol", "ObjectName",
 CellID->11973],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiSymbol",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiSymbol"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi symbol ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        FractionBox["n", "m"], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14775]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 "For prime ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", the Jacobi symbol reduces to the Legendre symbol. The Legendre symbol is \
equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", "1"}], TraditionalForm]], "InlineMath"],
 " depending on whether ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is a quadratic residue modulo ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8034],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->347171942],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->512776772],

Cell["Compute Jacobi symbols:", "ExampleText",
 CellID->243043993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{"10", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1035753004],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381854416]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"JacobiSymbol", "[", 
    RowBox[{"n", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "1", ",", "n", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29330036],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{421, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183054022]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->36392418],

Cell["Evaluate for large arguments:", "ExampleText",
 CellID->482009571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"10", "^", "10"}], "+", "1"}], ",", 
   RowBox[{"Prime", "[", "1000", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59436206],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24058471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104216800],

Cell["Second argument may be even:", "ExampleText",
 CellID->205247370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{"7", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193686831],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103867478]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25394879],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->204069933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiSymbol", "[", 
   RowBox[{"n", ",", "k"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80556042],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"(", 
    FractionBox["n", "k"], ")"}],
   JacobiSymbol,
   Editable->False], TraditionalForm]], "Output",
 ImageSize->{24, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->136480464]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->380633804],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFormula"],
 " threads element-wise over lists and arrays:"
}], "ExampleText",
 CellID->135915266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5", ",", "7", ",", "11"}], "}"}], ",", " ", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298100410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297764935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70276092],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFormula"],
 " works for negative first arguments:"
}], "ExampleText",
 CellID->719026138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{
   RowBox[{"-", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "3", ",", " ", "5", ",", " ", "7"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39877659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425547851]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->559976476],

Cell["\<\
Find Euler\[Hyphen]Jacobi pseudoprimes:\
\>", "ExampleText",
 CellID->370403771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10000", "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"GCD", "[", 
       RowBox[{"#", ",", "2"}], "]"}], "===", "1"}], "&&", "      ", 
     RowBox[{"Not", "[", 
      RowBox[{"PrimeQ", "[", "#", "]"}], "]"}], "&&", 
     RowBox[{
      RowBox[{"JacobiSymbol", "[", 
       RowBox[{"2", ",", "#"}], "]"}], "==", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"2", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#", "-", "1"}], ")"}], "/", "2"}], ")"}]}], ",", "#"}], 
       "]"}]}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->478528313],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "561", ",", "1105", ",", "1729", ",", "1905", ",", "2047", ",", "2465", ",",
    "4033", ",", "4681", ",", "6601", ",", "8321", ",", "8481"}], 
  "}"}]], "Output",
 ImageSize->{431, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->483899678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57025814],

Cell["The Gauss reciprocity law:", "ExampleText",
 CellID->245332218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiSymbol", "[", 
    RowBox[{"p", ",", " ", "q"}], "]"}], 
   RowBox[{"JacobiSymbol", "[", 
    RowBox[{"q", ",", " ", "p"}], "]"}]}], "==", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}], "/", "2"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"q", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9886723],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiSymbol", "[", 
    RowBox[{"p", ",", "q"}], "]"}], " ", 
   RowBox[{"JacobiSymbol", "[", 
    RowBox[{"q", ",", "p"}], "]"}]}], "\[Equal]", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "q"}], ")"}]}]]}]], "Output",
 ImageSize->{372, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330281575]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"GCD", "[", 
         RowBox[{"p", ",", "q"}], "]"}], "==", "1"}], ",", "%", ",", "True"}],
       "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"p", ",", " ", "3", ",", " ", "10", ",", " ", "2"}], "}"}], ",",
      "  ", 
     RowBox[{"{", 
      RowBox[{"q", ",", "3", ",", " ", "10", ",", " ", "2"}], "}"}]}], "]"}], 
   " ", "//", "Flatten"}], "//", "Union"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18809135],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->652001043]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->781660963],

Cell["Construct eigenvectors of the discrete Fourier transform:", \
"ExampleText",
 CellID->559013909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", "=", "13"}], "}"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"JacobiSymbol", "[", 
       RowBox[{"k", ",", "p"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", 
        RowBox[{"p", "-", "1"}]}], "}"}]}], "]"}]}], "]"}], "//", 
  "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323069172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "1.`", ",", 
   RowBox[{"-", "1.`"}], ",", "1.`", ",", "1.`", ",", 
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"-", "1.`"}], ",", "1.`", ",", "1.`", ",", 
   RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}]], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63848796]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fourier", "[", "%", "]"}], "//", "Chop", " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->555712361],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVtsOgjAMLUww4j0xwouXr9EnP4IQE3wwGvD/cQU05giWuPBghGRrT2+0
bCs7hLf4eA5vpyjc7pPwGp+idLu7JFqkLCIrIaJpQJrPNJcPflI9iHo8q4cs
owHgJeC1oJfsJbwC7Bvmo/IqFUg9Pdka+iXdAEY50nVJgxr7AN5nV2bBmKED
cldPDhX2HM0F/UTQS/6m8U31Y0Hfbzl/yb96tXKp88S5TXF+OAaem9fYTOeC
XvI3jW+qnwl6r+X8P/m/r51dYf2+dlOwWmTFvsDzKPW4Or9v5diTpR7YNO8R
YCtrvs/xW/3af2BYVWVXe1f739WO3YWlqqy2jbvQA2P3KW5mzKYNOLLurfCm
Sg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{370, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61460487]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->382067461],

Cell["Evaluate Gauss sums in closed form:", "ExampleText",
 CellID->121532551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"h", "=", "4"}], ",", 
      RowBox[{"p", "=", "11"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"k", "=", "1"}], "p"], 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"GCD", "[", 
           RowBox[{"k", ",", "p"}], "]"}], "\[Equal]", "1"}], ",", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"2", " ", "\[Pi]", " ", "\[ImaginaryI]", " ", "h", " ", 
            SuperscriptBox["k", "2"]}], "p"]], ",", "0"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"JacobiSymbol", "[", 
         RowBox[{"h", ",", "p"}], "]"}], " ", 
        SuperscriptBox["\[ImaginaryI]", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"p", "-", "1"}], "2"], ")"}], "2"]], " ", 
        SqrtBox["p"]}], "-", "1"}]}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92225258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["11"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["11"]}]}]}], "}"}]], "Output",
 ImageSize->{168, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27119061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->816112906],

Cell["Plot the nontrivial values of the Jacobi symbol:", "ExampleText",
 CellID->358335599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"JacobiSymbol", "[", 
      RowBox[{"n", ",", "m"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "1", ",", 
       RowBox[{"2", "n"}], ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "Red"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "\[Rule]", "Blue"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148303412],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW7Fu1EAQ3VNsyZbOhSMlggIpSkFBQ0FBQUMRAU0KCgoapEsESoRQUJKC
goKChoKChoKCgoaChoKCvzM79szu2z3nYkTusM9z0t3YMztvRued2Zndu/3Z
+dHzV7Pz48PZzsPT2euj48OznQcnp5a1MTHG/LLv39eMva7sVf0mln1t0HX9
Mj/tx+SquInj2ldmLaaWWmaVVLWwSolaXlnzquae5SnzSh6TdtRr5I29RH0Z
rC8Jy3KmpJMzFezY31T0GD9xNsE3wmSeYGXiH2GKrqWZ+jYq3wp7vxXZlHme
Ac2ZL9T5zz5sWzrl8VO1txJ7mZMbswk4NNeyCE/mTcZysUe5quB7wivV1lrY
ivNOTCXntNFFei6PWbqltvtlW9YWzCeRvsytgq8LWE+ktsF1xecuX89cVx96
7wPmCKwZCsgfWJ8W4AfmnpRlN9TOIO1grZjBvMJeBuvOODddVHvKPMwBb1d9
GIQPufE1aEylFkGKctK/qdidsdviHGO8fn7Mm8KYHMbeUuzO2PU4iLXWtdeE
a7Nc17G2IL5o7G21O1q7iQnX5jKYw2K34UtO93PamDuK3Rk7wGB9ec6kW14i
J5t3FbszNtYmQe/J964WMX4fG+NJxpP9e2pjODaM7zNwH5r2MLclZh0u9CqW
3lfchbiCI2dFQjeje3pWeyPAcOuty//zZxg4t/1zCc8zEOeR2lqqrZxjAOMj
7Fmb+MhYtq9YV4KFZ0XYD83XXPJcm970seLNxUm8N9K612LCPoHoE8X+O2zI
L209gMRC2iInn54qdi+wsT+TfS4/H7yM4vPZCDBwnyCuyzF2Wn/HYa8PFPdS
XMz1wbknPB+asy8UoxPGnpW9XKGsji+YI8GaMpebGnoycixXI1ZNnipAX/DO
1lQfz05wHcM8/UZ1/XddXbwXRPK366Zrwt9FSC/1boA68XqIcUPfx/uR6rk5
ElHifxioTnwu/LHHY+PzBBr/qcdjsX+V3obo53UeH60VX3o8lvaAv65Qhv3I
tyGNsfff/6P8x3Jly/pv1T9z+b9fkz8DgN0L\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17425741]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->723604111],

Cell[TextData[{
 "Reduce equations containing ",
 Cell[BoxData[
  ButtonBox["JacobiSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->109007859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"JacobiSymbol", "[", 
      RowBox[{"p", ",", "3"}], "]"}], "==", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{"JacobiSymbol", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", "3"}], "]"}]}], "-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"-", "5"}], "<", "p", "<", "5"}]}], ",", "p", ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4286335],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "\[Equal]", 
   RowBox[{"-", "4"}]}], "||", 
  RowBox[{"p", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"p", "\[Equal]", "2"}]}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226494585]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->414257981],

Cell[TextData[{
 "Successive differences of ",
 Cell[BoxData[
  ButtonBox["JacobiSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFormula"],
 " modulo 2:"
}], "ExampleText",
 CellID->19768499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{"Differences", ",", 
      RowBox[{"JacobiSymbol", "[", 
       RowBox[{
        RowBox[{"Range", "[", "100", "]"}], ",", "77"}], "]"}], ",", "100"}], 
     "]"}], ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->602961573],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWFuO6zYMHaPdSLfUJVy0393/X6e4nQuFc15yYtNJZICII5ESeQ5JKfnj
xz9//vjt4+Pj70/561N+/5Rt25ZcSH5S0u/Hkhs+FicXkYGPxckFpPCxOOmX
/0i5kQv49LYycFA/2317U9nGnjXycwHf3lFueBhrZNXJ+YJ4GDn6el1ymqCa
uOFk1cl5UjkA999VJ+cKrYnayxYnxwvqUSNHtZet3nW4QD5GDghH3X6/qtxg
j/oU6luLk2OE3XfRnQudM93+v6DQ+y75fbg4OZgPhj2rEXL36o7jJcRhP/JV
39d/K4eIrIPxYef6unc9lg/FBbtvVZ7Ke3dMTyvJWTFirs71dZ48RCIu3H9c
ZJ3u2J5OFNaKA/X7sei3x/hkEp3biIPRVv2Wv0CMTyPmd57lwNy1Fic7+EC4
q98bCPvkt3x3rE8isv8g/Mex+q7uyuuM9+LuUSz31fmC3gt/7XFfVVxeVzzV
+Z3elVedSLF5nWCM9NF7+d4d+xXFYulyX+mj8XUX5pLghziq70of6dapJb8k
+q2BMK/jSj+4K3TjcAlJz4I095U+O0fWeXIjMt8RdoiPcc7dB8xe3Xh0yzcs
Vf+qOCN8Cc6Sxzr0xgKxVGNf35kInK3NqPqmAvFyY1/j7NP1NfSJVN9NWK4m
Y+p8UDbJufKunKhcTcYUZ8rmBnDNx9aN0ckifxskYxVTx83MuTLod+N0iqjc
ZnnMagLhq9ZBnKjPbqxOEpnbCDNVEwjf0c6dF0E9deN1OB8VL4RnxUzZVV3E
oelN7ns3ZofzwbBij+ttal00zvSEfjduh/OhsECP621qXdeXkrvEgZi0iesX
7mE4J+u6cz68X7Rj+EgRd5mID2aTruvO+eR+cS8GVxJzl7E5r2zSdRHuokd9
e16ME3mXcfnubNJ1x3m0ftUhnHVj+RA+EK5szH1354Tiwe3n8uMV6sT1hTTf
GY4Mc2aPbBH+Zr92XO8Qii/DtWLhcGS6bD1km9RTse/G9a76YPgonGZwdP2n
6iB/2DjTORvLR4jKMRHnLhzVGYB4rXZqXNi3YzwjrjYQlklNzJwTivfqmxoX
9u04p+J6EYpd9bS950Td3/GPfFY6M5g0C8XV9YgRS5bzzNbVGvtUXBk+toPw
e3h9sLgZBnW84p3aKqzrmilXwdOOueNDxe1iT/oSq6HxXfGDvjufzdOOOxMV
j8Ngpi+pNevejO8ZroKnHXskigNXA2gu0Zk5Q6oeW0P5Ip52/Kuw/FaYOA4T
HbUXskE6Sa0GTzsHRSSWDBNVR6mO2kv1LNav2BpOLsDBDR8OS4YJ0p/VUXvN
5IXaM/m8AA8fP93xZ7bCBOGLvrMcrrppfbI11RrB90vwkWLJMKl2CG9mp7hh
um5NF4/53s0JjHMcT2oFxZasWfWdL1VP5YPa2+zRWh8szpk+rvBDcwy7xBd0
Bsz4lcxvd+K6V1yco58JRww/lpspN8hHpZvureY7+WCx3DgX9HGGC5ur66k5
tm7qM7NR89v5nMhe/M25oI+ztVRuMjvkB/M38XnW76+ps8T13L19nMXN+p7r
ccivVBfF5uoFLXGS2J7K/Ge5lfT1auPsFO6JblI3CoP/9U7ho/qgcHS9I+lV
dYxhNoM7W5fpJ/VIPg/lg/mgcKxP0nPcmFub+cS4meEJjSn77eD6cLmNMHK9
I40bvSd9Bvmj1mX7sHWc/XYgHygmhcfo22zPcWMqh5m+yyflG4srsd9O6lcK
a1YTMz3HjbH1GQfIB6fncm3C/pR+xWqX4T7bc5weW5/1pSSf2FrMN7fP8HlK
v6qYId0aw0zPQTqKQ1U3Kgbkg8oTpSNweCgfaK/6zuJnPOyNO1lf7Yfe0Xps
D6fDMNsezAeKFWHm+pjxGT7JfoqzJIZkrVRH7HcXH0mOV59YzGlOsUflptuX
+criS2JwOgKzu+ojyXHmn6oFxS17XA9CfjpflS+qByZxCszuqg8WQ1I/qhZm
6kPZqBxPfE38RfqpHeHxrvqoflUflX8KG4VXgqPbI/UVxajyh+XFJGZ31Uf1
i+UB2lthg8bcpxpL8GRxqHjY/qkdwWGKj7qWi1f5p3hU3M7YqPxVPqd1yDhO
7cj+U/3K5ajKM6TP8Etwm1lH+SPyFXLK/NxjR/aP+GBrKX8cBsjO1XhSe2ov
ZIt8Zj4qP/fYkf2j82O2L7HH9S1no+bRuok/aU9zvUjFxnwh+0fnB1sr9dXV
RlJbbj7pDanPaI/qS9Kn9mC2heeH8jHxFWHH5ma5Vjwk/qA5hifCRc3txCw6
P5SPVdf5rGJFn2oOYZBg53xG8aJ3N1f1wv0hH6NekrvMR7Z3mncqHlH71g/k
v4tXxfBgzCAfo15SczM+VzuHndNxNchqIOgh1s7N7cFsI3zUddC6rE6TvZk/
ak2XmzN+uHgSX5K5nZh9zNRaUuvVH9cjqk/KTtnP+OHiSe2OwOxf+pJvMg==

   "], {{0, 0}, {100, 101}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->Small]], "Output",
 ImageSize->{184, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84408589]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1979],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerSymbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MoebiusMu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MoebiusMu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18777]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12267],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->8726]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->22127],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/JacobiSymbol.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/NumberTheoryFunctions/JacobiSymbol/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
JacobiSymbol"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->750710026],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->70407554],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->37341449],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->118190750],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->181984645]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiSymbol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 41.2005356}", "context" -> "System`", 
    "keywords" -> {"Jacobi symbol", "Legendre symbol"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiSymbol[n, m] gives the Jacobi symbol (n/m). ", 
    "synonyms" -> {"jacobi symbol"}, "title" -> "JacobiSymbol", "type" -> 
    "Symbol", "uri" -> "ref/JacobiSymbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5274, 171, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->347171942]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30936, 1089}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2546, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3169, 87, 50, 1, 70, "ObjectName",
 CellID->11973],
Cell[3222, 90, 666, 22, 70, "Usage",
 CellID->14775]
}, Open  ]],
Cell[CellGroupData[{
Cell[3925, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4403, 134, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4538, 140, 483, 17, 70, "Notes",
 CellID->8034],
Cell[5024, 159, 213, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5274, 171, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->347171942],
Cell[CellGroupData[{
Cell[5659, 185, 148, 5, 70, "ExampleSection",
 CellID->512776772],
Cell[5810, 192, 66, 1, 70, "ExampleText",
 CellID->243043993],
Cell[CellGroupData[{
Cell[5901, 197, 133, 4, 28, "Input",
 CellID->1035753004],
Cell[6037, 203, 158, 5, 36, "Output",
 CellID->381854416]
}, Open  ]],
Cell[CellGroupData[{
Cell[6232, 213, 327, 10, 28, "Input",
 CellID->29330036],
Cell[6562, 225, 978, 31, 54, "Output",
 CellID->183054022]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7589, 262, 219, 7, 70, "ExampleSection",
 CellID->36392418],
Cell[7811, 271, 72, 1, 70, "ExampleText",
 CellID->482009571],
Cell[CellGroupData[{
Cell[7908, 276, 217, 7, 70, "Input",
 CellID->59436206],
Cell[8128, 285, 157, 5, 36, "Output",
 CellID->24058471]
}, Open  ]],
Cell[8300, 293, 125, 3, 70, "ExampleDelimiter",
 CellID->104216800],
Cell[8428, 298, 71, 1, 70, "ExampleText",
 CellID->205247370],
Cell[CellGroupData[{
Cell[8524, 303, 131, 4, 70, "Input",
 CellID->193686831],
Cell[8658, 309, 158, 5, 36, "Output",
 CellID->103867478]
}, Open  ]],
Cell[8831, 317, 124, 3, 70, "ExampleDelimiter",
 CellID->25394879],
Cell[8958, 322, 203, 7, 70, "ExampleText",
 CellID->204069933],
Cell[CellGroupData[{
Cell[9186, 333, 182, 6, 70, "Input",
 CellID->80556042],
Cell[9371, 341, 298, 11, 65, "Output",
 CellID->136480464]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9718, 358, 243, 7, 70, "ExampleSection",
 CellID->380633804],
Cell[9964, 367, 229, 7, 70, "ExampleText",
 CellID->135915266],
Cell[CellGroupData[{
Cell[10218, 378, 220, 7, 70, "Input",
 CellID->298100410],
Cell[10441, 387, 291, 10, 36, "Output",
 CellID->297764935]
}, Open  ]],
Cell[10747, 400, 124, 3, 70, "ExampleDelimiter",
 CellID->70276092],
Cell[10874, 405, 221, 7, 70, "ExampleText",
 CellID->719026138],
Cell[CellGroupData[{
Cell[11120, 416, 236, 8, 70, "Input",
 CellID->39877659],
Cell[11359, 426, 242, 8, 36, "Output",
 CellID->425547851]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11650, 440, 227, 7, 70, "ExampleSection",
 CellID->559976476],
Cell[11880, 449, 90, 3, 70, "ExampleText",
 CellID->370403771],
Cell[CellGroupData[{
Cell[11995, 456, 711, 23, 70, "Input",
 CellID->478528313],
Cell[12709, 481, 336, 10, 36, "Output",
 CellID->483899678]
}, Open  ]],
Cell[13060, 494, 124, 3, 70, "ExampleDelimiter",
 CellID->57025814],
Cell[13187, 499, 69, 1, 70, "ExampleText",
 CellID->245332218],
Cell[CellGroupData[{
Cell[13281, 504, 527, 19, 70, "Input",
 CellID->9886723],
Cell[13811, 525, 612, 22, 43, "Output",
 CellID->330281575]
}, Open  ]],
Cell[CellGroupData[{
Cell[14460, 552, 567, 18, 70, "Input",
 CellID->18809135],
Cell[15030, 572, 183, 6, 36, "Output",
 CellID->652001043]
}, Open  ]],
Cell[15228, 581, 125, 3, 70, "ExampleDelimiter",
 CellID->781660963],
Cell[15356, 586, 102, 2, 70, "ExampleText",
 CellID->559013909],
Cell[CellGroupData[{
Cell[15483, 592, 428, 15, 70, "Input",
 CellID->323069172],
Cell[15914, 609, 453, 13, 36, "Output",
 CellID->63848796]
}, Open  ]],
Cell[CellGroupData[{
Cell[16404, 627, 135, 4, 70, "Input",
 CellID->555712361],
Cell[16542, 633, 581, 14, 70, "Output",
 Evaluatable->False,
 CellID->61460487]
}, Open  ]],
Cell[17138, 650, 125, 3, 70, "ExampleDelimiter",
 CellID->382067461],
Cell[17266, 655, 78, 1, 70, "ExampleText",
 CellID->121532551],
Cell[CellGroupData[{
Cell[17369, 660, 1103, 34, 70, "Input",
 CellID->92225258],
Cell[18475, 696, 397, 15, 43, "Output",
 CellID->27119061]
}, Open  ]],
Cell[18887, 714, 125, 3, 70, "ExampleDelimiter",
 CellID->816112906],
Cell[19015, 719, 91, 1, 70, "ExampleText",
 CellID->358335599],
Cell[CellGroupData[{
Cell[19131, 724, 609, 19, 70, "Input",
 CellID->148303412],
Cell[19743, 745, 1285, 25, 70, "Output",
 Evaluatable->False,
 CellID->17425741]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21077, 776, 237, 7, 70, "ExampleSection",
 CellID->723604111],
Cell[21317, 785, 219, 8, 70, "ExampleText",
 CellID->109007859],
Cell[CellGroupData[{
Cell[21561, 797, 470, 16, 70, "Input",
 CellID->4286335],
Cell[22034, 815, 321, 11, 36, "Output",
 CellID->226494585]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22404, 832, 228, 7, 70, "ExampleSection",
 CellID->414257981],
Cell[22635, 841, 225, 8, 70, "ExampleText",
 CellID->19768499],
Cell[CellGroupData[{
Cell[22885, 853, 362, 11, 70, "Input",
 CellID->602961573],
Cell[23250, 866, 2826, 53, 202, "Output",
 CellID->84408589]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26137, 926, 310, 9, 70, "SeeAlsoSection",
 CellID->1979],
Cell[26450, 937, 722, 26, 70, "SeeAlso",
 CellID->18777]
}, Open  ]],
Cell[CellGroupData[{
Cell[27209, 968, 314, 9, 70, "TutorialsSection",
 CellID->12267],
Cell[27526, 979, 197, 4, 70, "Tutorials",
 CellID->8726]
}, Open  ]],
Cell[CellGroupData[{
Cell[27760, 988, 321, 9, 70, "RelatedLinksSection",
 CellID->22127],
Cell[28084, 999, 183, 4, 70, "RelatedLinks"],
Cell[28270, 1005, 206, 4, 70, "RelatedLinks"],
Cell[28479, 1011, 390, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28906, 1029, 319, 9, 70, "MoreAboutSection",
 CellID->750710026],
Cell[29228, 1040, 163, 3, 70, "MoreAbout",
 CellID->70407554],
Cell[29394, 1045, 154, 3, 70, "MoreAbout",
 CellID->37341449],
Cell[29551, 1050, 162, 3, 70, "MoreAbout",
 CellID->118190750],
Cell[29716, 1055, 137, 3, 70, "MoreAbout",
 CellID->181984645]
}, Open  ]],
Cell[29868, 1061, 27, 0, 70, "History"],
Cell[29898, 1063, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

