(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58453,       1938]
NotebookOptionsPosition[     50164,       1647]
NotebookOutlinePosition[     51529,       1685]
CellTagsIndexPosition[     51443,       1680]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingNestedLists"], 
          "Structural Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/StructuralOperations"], 
          "Combining Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/CombiningLists"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Rearranging Nested Lists\"\>", 
       2->"\<\"Structural Operations\"\>", 
       3->"\<\"Combining Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Union" :> Documentation`HelpLookup["paclet:ref/Union"], 
          "StringJoin" :> Documentation`HelpLookup["paclet:ref/StringJoin"], 
          "Append" :> Documentation`HelpLookup["paclet:ref/Append"], 
          "Prepend" :> Documentation`HelpLookup["paclet:ref/Prepend"], 
          "PadLeft" :> Documentation`HelpLookup["paclet:ref/PadLeft"], 
          "Flatten" :> Documentation`HelpLookup["paclet:ref/Flatten"], 
          "ArrayFlatten" :> 
          Documentation`HelpLookup["paclet:ref/ArrayFlatten"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Union\"\>", 2->"\<\"StringJoin\"\>",
        3->"\<\"Append\"\>", 4->"\<\"Prepend\"\>", 5->"\<\"PadLeft\"\>", 
       6->"\<\"Flatten\"\>", 7->"\<\"ArrayFlatten\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ListManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"Handling Arrays of Data\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Parts of Matrices\"\>", 
       5->"\<\"Rearranging & Restructuring Lists\"\>", 
       6->"\<\"Structural Operations on Expressions\"\>", 
       7->"\<\"New in 6.0: List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Join", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Join",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Join"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]concatenates lists or other expressions that share the \
same head."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Join",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Join"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]joins the objects at level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->29753]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Join",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Join"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects by effectively concatenating the corresponding ordinary lists. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->26009]
}], "Notes",
 CellID->22247],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Join",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Join"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " handles ragged arrays by effectively concatenating all successive elements \
at level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " in each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->311391138]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->125299366]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136805317],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->3125945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "x", ",", "y", ",", "u", ",", "v", ",", "w"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4774],

Cell["Infix syntax:", "ExampleText",
 CellID->18801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "~", "Join", "~", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "~", "Join", "~", 
  RowBox[{"{", 
   RowBox[{"u", ",", "v", ",", "w"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "x", ",", "y", ",", "u", ",", "v", ",", "w"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14410]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->403514029],

Cell["Join two matrices to make longer columns:", "ExampleText",
 CellID->128952776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408681152],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192295837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167352446],

Cell["Join columns of two matrices to make longer rows:", "ExampleText",
 CellID->261025858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", " ", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->787657734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367924718]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19340244],

Cell["\<\
With ragged arrays successive elements are effectively concatenated:\
\>", "ExampleText",
 CellID->311391138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", " ", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "3"}], "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "8", "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86935034],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63633446]
}, Open  ]],

Cell["\<\
The second row comes from the concatenation of nothing with {3,4}:\
\>", "ExampleText",
 CellID->459487451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "x", "}"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->264247001],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89126287]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81668544],

Cell["Join depth 3 arrays at different levels:", "ExampleText",
 CellID->371662220],

Cell[BoxData[{
 RowBox[{
  RowBox[{"aa", " ", "=", " ", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "#"], "&"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"bb", " ", "=", " ", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "#"], "&"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->19370597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{"aa", ",", " ", "bb"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->578318452],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWdtOAkEMHViQ9cIKCMZHngxfok9+BDEm8GA06v/rzLpLNseWdjoDSMKy
7U5P2zOd2/K0/tq8vK6/ts/r5ePH+n2zff5cPrx9eFXRc65/75y7vnP+/tvf
1d/2s/Jf5wbhWuz0ojzyl6EX+6AfN/pCsL9Q4lWMXooP8fF56S9BRH3V6KX4
Lxk8tKsYP6nxt3yhv5Z/iS+Ofw5P4sPKv5UvxE/tT5Tr9slZh17oe3Gi8Bba
oT2HN6WiNeBju3PiebC7VuLjqEC8gsEbZoofn7d2yD/ypeWfw9NUk4V/LV8c
vrU/JbmeXUxjipqbEIdbCyT80uivVLaL9a/NX7u2SvFQ1XNIvlX5D3Zy40VC
GTLtpOzLrN6OkzvmZI0mb+6xdW+bDWqrYTdmf8/OzCNVa8pnsMaREee7VLe2
xGLjpUXT8cJZU/uLY/TJf+fFVi9xvo/LyynHUXqfyLNP7NpVqGK5UrXC3djY
5Gus5nKfjL51eXfZC3KlaoV5VyZfdN7Y6uwgeefpg0P2t3QyytPftj7Q5Z2n
tqS679V2lhPJoPHenou6MmaM5ya0n4AsZaE5Vw+IqqgYPcrUuZeyGzN6iT8p
fnp96LLNP0Xu0FcKtjSb2PKyrR6Sb50v3Wxyyp39jNTiDlSX/Q2plXZKtl7V
+cKRlsKBJe6++7sHmjL6kYLzGDzpvYc1/onSX2r8yMfh3n4Fcd784rtSam0J
4qL5Ta0SCY9aK/bFaxpdzTsKV3/mfzSq2UDAyB/njejDEqfUn3mqbiVEis9j
2UJ7rKJUfByrC5BVPbHH/ipzfHMBPzY+qZrpKol9f3gPMv6/hM/RHttL+LPM
+GFWv/3+nd2RcbTttpVOTxq/CwZrn1+p6shT3G7TsIqUXO8HjVwwtA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{550, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80810415]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{"aa", ",", " ", "bb", ",", " ", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->113680946],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWdtSwjAQDZQKKhRUcHz0ycuP6JMf0WGcwQdHR/1/TGrr1MPGPUlD6Qxt
d7N79pZsm/JUfm2eX8uvl3V5/fhRvm9e1p/XD28flpUNjBmeGGPmV8beb+1d
9WuOqf0ZM3Ln7Jev0mN7yi05BP6s5meK/gmJV3j4LB76MSPxThPHq/mL4xN7
ciTyi5ofml8NL9TfBg/96IoXGy/SlXznqrhqDy25IKw5OdT34Z1J3kbgNXLo
nw8PZ3VsvGz8KHcsjDu9eSQ+i5dH4mWJ8dh4NbrqQlFrQuphiOPrdRr+JNLe
hJQT7Y3az7Kc6Dy5R06zdkxZQxSftVAac8vWln1uU7lOaI+Kt7ds9zuT0qzm
Sitv+2zvvZ1/TElLNp029rEw2xNaOp3tRpuL26ctPR/7yDmTh7j5kCYvfdRk
P3PxELa751zvHqH9NaN8mVJS+DY0i7I1o3N5KFtFjznU4uTq2Z4Vji4oqbh6
xtk6SmJLrud+bMXlUFuPg0ov5o1+VFtv9hVtGiPGfQfqL4DGKFBf7n9tb/yj
iI17zv+x/VWQ4sa8MfvNkbBKCw8faV+eWTzNX+65w3WeNLa4jnrIN+NzkYtv
eFz0FyIX3w4krKHZfVafefhjoKUVIuktPHxtD6mtitS5YLGYGnXJQ+o67e/r
jSOX9RW/5Uk9x5Gr+krN9HoPbKpjucNBDLFn/9G42OGg3zG9OSQulNfyFhND
ilzuZ9bcKZ5q4zjXV0BjJsQZ0aKXQE8V/7XZoPl/Hxif5l/X/HBVDv1+dQM0
/r+gjbuudrn96W4Y8bkgu6pltV0J2gn1+5bw2+dLSIzcv0nb+pgGUmbwDSsJ
yD4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{522, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->38810842]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{"aa", ",", " ", "bb", ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->306496838],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWFlOw0AMnbQJLdCkO+KzN2A5BHxxiKhCaj8QqPSk9EAlkyYQvdi1Z5Ko
lbLY8fg92zPuJG/pfvP+ke6363T1uku/Ntv19+rlc5ep+oExwY8xZnxvsvtj
dpcf9nfIDmNCe+6XuqMoD7JTlIk90MeFvs/o0T5h9Ih3w+A3xeH4SvEjH3w+
zE5WRH1S6BEvEexd+QxbwuH4Snxy+8ZZtdXqZeKE8E7pS/spxYYYj3gou+Jw
fDXZovig3TXx3I4bM/5Qz9lHSj6I74pzTu8i56vYa05SPQD9cL0N/UWFHTn3
K/KV0o7qIRr+2t7sy4uL01XGeLT18Y1Py9s3Pm192p5fvvOwm1WVj4r+5NxH
3UvZKQYq69DJuvQ9VFtTWNjbdHF1zdQtZ5JMxelXT7+4u6i+Ns7Lz1P3nLmv
XqmnkD1C5DJSWcUtWiHP2It3m4x0OcCdlBSHrh7Vqlo5UVnRcfn5uvKqR5eM
dFZSPVAO8nE+O8uwQC/3tyjTXOWnGAG1169iTZyw+Sz2iKpj3NI+vuRGvYVS
+jb7jMSV4xaf0bfF7ZI7sxmpnR9PFcf/jymjHwjZpbHnTtgTRi+9R0iz0oXb
zDEvyE2Xl25q0t1btBUXlasJ/zsupcHvCNRatOKS9TmvaW4FnpreVMWsI9RZ
ICYXR5PcdFO1J5CXIEuRPYO8AHnUsBoSP/SP/lzj02XZ9YvAw/G0Mu+KK7LG
74WPhd2yuEq7Qxwv4aM/HC/x1X3ltbcHxZ0JfgEGi/Vj\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->91631999]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27084],

Cell["Join expressions with any head:", "ExampleText",
 CellID->2084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"u", ",", "v", ",", "w"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11905],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "x", ",", "y", ",", "u", ",", "v", ",", "w"}],
   "]"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85904704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10259],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Join",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Join"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->26009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"Range", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10627],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53799670]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{"%", ",", "%", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4805],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "15", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 15, ">"],
     Editable->False], ",", 
    RowBox[{"{", "15", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2096687]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->163165145],

Cell["Augment a matrix by adding a row:", "ExampleText",
 CellID->27890403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", "3", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81247788],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"},
     {"1", "2", "3"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{61, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->809014745]
}, Open  ]],

Cell["Augment by a column:", "ExampleText",
 CellID->146560704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", "3", "]"}], ",", " ", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}], "]"}], ",", "2"}], 
   "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->138025308],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "1"},
     {"0", "1", "0", "2"},
     {"0", "0", "1", "3"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{76, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->256082643]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->488447169],

Cell["Make a block matrix:", "ExampleText",
 CellID->846295389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          SubscriptBox["a", "1"], 
          SubscriptBox["a", "1"], 
          SubscriptBox["a", "1"]},
         {
          SubscriptBox["a", "2"], 
          SubscriptBox["a", "2"], 
          SubscriptBox["a", "2"]},
         {
          SubscriptBox["a", "3"], 
          SubscriptBox["a", "3"], 
          SubscriptBox["a", "3"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
      " ", 
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          SubscriptBox["b", "1"], 
          SubscriptBox["b", "1"], 
          SubscriptBox["b", "1"]},
         {
          SubscriptBox["b", "2"], 
          SubscriptBox["b", "2"], 
          SubscriptBox["b", "2"]},
         {
          SubscriptBox["b", "3"], 
          SubscriptBox["b", "3"], 
          SubscriptBox["b", "3"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
      "2"}], "]"}], ",", " ", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          SubscriptBox["c", "1"], 
          SubscriptBox["c", "1"], 
          SubscriptBox["c", "1"]},
         {
          SubscriptBox["c", "2"], 
          SubscriptBox["c", "2"], 
          SubscriptBox["c", "2"]},
         {
          SubscriptBox["c", "3"], 
          SubscriptBox["c", "3"], 
          SubscriptBox["c", "3"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          SubscriptBox["d", "1"], 
          SubscriptBox["d", "1"], 
          SubscriptBox["d", "1"]},
         {
          SubscriptBox["d", "2"], 
          SubscriptBox["d", "2"], 
          SubscriptBox["d", "2"]},
         {
          SubscriptBox["d", "3"], 
          SubscriptBox["d", "3"], 
          SubscriptBox["d", "3"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
      "2"}], "]"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->960775677],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtvIjEQNoa9HIElhJNOKfNXkpOSa66+GkUnJcUpUS4FHemQ0lBuyU+g
3JKSkpKSkpKS0ufHPowxMM4+MLCRwJ7Z8Xg8Hs/HTvyr/fb452/77emhfX3/
2n55fHr4d333/EpZ5RJC6IN+fl8h2ie0xz8fhND2kn5jSn4Dtg0+ilGozLTw
P9RKma7xWRzOHQwGAbdMv5hQRSNtyncoiRPyv3C62+1K9oWzTadT3/cjrhON
4jLrNlUPWiraqclkonrC8zzZP9IoWQvTWkvj+ZqtOEOpM04vl8tOpxOvuxxy
xdI3eCumz9N4vmar6u00pcS6e70eXSTr4mjdeDweO1odTVOuNB824LmcRw8f
PYKrtvFYnM/noQ8rSOQ/tcXRksVGN4G8Olk9+fLMcZa4V2wG5UIWTSIRbtB6
R7bka+kMlrSj3xX6sKTCPN8CtlWw1iwxDmaFQ+zCvK8gq/nsuWak/KUMPHFU
mAeL2+PDvCSRnxf2NUA2ZoF9LmhmU+yrg7Ruxz778CpNKRa7ThANkBYWxXXD
fTKlYVYU2Ger1Oew76QwQMFslo/UUwXia/E46dNz+DoKLCuwLCep2oa1b2ph
Uewa7pMpfQaygsVpGhhUDfi6Op0JPwmW7b/emKYUbP/0nsjyPcvWN7sw46rY
WDPkW43eiVEPa85uw5APQ4zwV7Ja5brki4l3F8a5AM35Q7F0V45sgrTeEn2e
b4FG24pqcOyD1C4PtYZ5LNi3/yxmS0bcP14V2AeXKrBvN6fAvv1Ifa6G2e/3
t2rNp4YZ306RrfA8b7FYEGIf9om3ndlsNhwOWVf+b7Lv+8H9jVPAPuGJ0Wik
uSdANy/wz+l4gp6nldsc6u0dRldQXEN0d9DZVS9VrI7txTR+7cEw5n1M44hb
FFSvV29DpYddrkZ7OKe48sK6N4qFu3JcQxkvtP4keqz6zp+Ke4Wo9B+aMyxh
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{138, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->406861895]
}, Open  ]],

Cell[TextData[{
 "This can also be done with ",
 Cell[BoxData[
  ButtonBox["ArrayFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->93746382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArrayFlatten", "[", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {
            SubscriptBox["a", "1"], 
            SubscriptBox["a", "1"], 
            SubscriptBox["a", "1"]},
           {
            SubscriptBox["a", "2"], 
            SubscriptBox["a", "2"], 
            SubscriptBox["a", "2"]},
           {
            SubscriptBox["a", "3"], 
            SubscriptBox["a", "3"], 
            SubscriptBox["a", "3"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.7]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {
            SubscriptBox["b", "1"], 
            SubscriptBox["b", "1"], 
            SubscriptBox["b", "1"]},
           {
            SubscriptBox["b", "2"], 
            SubscriptBox["b", "2"], 
            SubscriptBox["b", "2"]},
           {
            SubscriptBox["b", "3"], 
            SubscriptBox["b", "3"], 
            SubscriptBox["b", "3"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.7]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]},
       {
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {
            SubscriptBox["c", "1"], 
            SubscriptBox["c", "1"], 
            SubscriptBox["c", "1"]},
           {
            SubscriptBox["c", "2"], 
            SubscriptBox["c", "2"], 
            SubscriptBox["c", "2"]},
           {
            SubscriptBox["c", "3"], 
            SubscriptBox["c", "3"], 
            SubscriptBox["c", "3"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.7]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
        TagBox[
         RowBox[{"(", "\[NoBreak]", GridBox[{
            {
             SubscriptBox["d", "1"], 
             SubscriptBox["d", "1"], 
             SubscriptBox["d", "1"]},
            {
             SubscriptBox["d", "2"], 
             SubscriptBox["d", "2"], 
             SubscriptBox["d", "2"]},
            {
             SubscriptBox["d", "3"], 
             SubscriptBox["d", "3"], 
             SubscriptBox["d", "3"]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.7]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
         Function[BoxForm`e$, 
          MatrixForm[BoxForm`e$]]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->206418055],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtvIjEQNoa9HIElhJNOKfNXkpOSa66+GkUnJcUpUS4FHemQ0lBuyU+g
3JKSkpKSkpKS0ufHPowxMM4+MLCRwJ7Z8Xg8Hs/HTvyr/fb452/77emhfX3/
2n55fHr4d333/EpZ5RJC6IN+fl8h2ie0xz8fhND2kn5jSn4Dtg0+ilGozLTw
P9RKma7xWRzOHQwGAbdMv5hQRSNtyncoiRPyv3C62+1K9oWzTadT3/cjrhON
4jLrNlUPWiraqclkonrC8zzZP9IoWQvTWkvj+ZqtOEOpM04vl8tOpxOvuxxy
xdI3eCumz9N4vmar6u00pcS6e70eXSTr4mjdeDweO1odTVOuNB824LmcRw8f
PYKrtvFYnM/noQ8rSOQ/tcXRksVGN4G8Olk9+fLMcZa4V2wG5UIWTSIRbtB6
R7bka+kMlrSj3xX6sKTCPN8CtlWw1iwxDmaFQ+zCvK8gq/nsuWak/KUMPHFU
mAeL2+PDvCSRnxf2NUA2ZoF9LmhmU+yrg7Ruxz778CpNKRa7ThANkBYWxXXD
fTKlYVYU2Ger1Oew76QwQMFslo/UUwXia/E46dNz+DoKLCuwLCep2oa1b2ph
Uewa7pMpfQaygsVpGhhUDfi6Op0JPwmW7b/emKYUbP/0nsjyPcvWN7sw46rY
WDPkW43eiVEPa85uw5APQ4zwV7Ja5brki4l3F8a5AM35Q7F0V45sgrTeEn2e
b4FG24pqcOyD1C4PtYZ5LNi3/yxmS0bcP14V2AeXKrBvN6fAvv1Ifa6G2e/3
t2rNp4YZ306RrfA8b7FYEGIf9om3ndlsNhwOWVf+b7Lv+8H9jVPAPuGJ0Wik
uSdANy/wz+l4gp6nldsc6u0dRldQXEN0d9DZVS9VrI7txTR+7cEw5n1M44hb
FFSvV29DpYddrkZ7OKe48sK6N4qFu3JcQxkvtP4keqz6zp+Ke4Wo9B+aMyxh
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{138, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->129241600]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->278641385],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Join",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Join"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]], ",", " ", 
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]], ",", " ", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", " ", "1"}], "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->550782773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->420989218],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", "3", ",", "4", ",", "5"}], 
  "}"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26123834]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113110271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", "3", ",", "4", ",", "5"}], 
  "}"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->805910500]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7771],

Cell["Successively double a list by joining to itself:", "ExampleText",
 CellID->16434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"#", ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{"{", "x", "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", 
     "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x",
      ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", 
     ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{336, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236138021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20496],

Cell[TextData[{
 "Build up the Thue-Morse sequence: [",
 ButtonBox["more info",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-889c-text"], None}],
 "]:"
}], "ExampleText",
 CellID->10943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"#", ",", 
      RowBox[{"1", "-", "#"}]}], "]"}], "&"}], ",", 
   RowBox[{"{", "1", "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11471],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0",
      ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0",
      ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
     ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", 
     ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", 
     ",", "1", ",", "1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{476, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250573448]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27673],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringJoin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringJoin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Append",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Append"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prepend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prepend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5637]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25610],

Cell[TextData[ButtonBox["Rearranging Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingNestedLists"]], "Tutorials",
 CellID->31969],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->2230],

Cell[TextData[ButtonBox["Combining Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombiningLists"]], "Tutorials",
 CellID->13709]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->64927752],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->193733144],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->55990958],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->58635935],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->119553023],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->609063],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->485418728],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->755884858]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Join"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Join - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 42.9193296}", "context" -> "System`", 
    "keywords" -> {
     "catenating lists", "concatenating lists", "merging lists", "splicing"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Join[list_1, list_2, ...] concatenates lists or other expressions that \
share the same head. Join[list_1, list_2, ..., n] joins the objects at level \
n in each of the list_i.", "synonyms" -> {}, "title" -> "Join", "type" -> 
    "Symbol", "uri" -> "ref/Join"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11874, 314, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->136805317]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51299, 1673}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3666, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4289, 105, 4188, 83, 70, "ObjectNameGrid"],
Cell[8480, 190, 1462, 48, 70, "Usage",
 CellID->29753]
}, Open  ]],
Cell[CellGroupData[{
Cell[9979, 243, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10457, 260, 454, 15, 70, "Notes",
 CellID->22247],
Cell[10914, 277, 923, 32, 70, "Notes",
 CellID->125299366]
}, Closed]],
Cell[CellGroupData[{
Cell[11874, 314, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136805317],
Cell[CellGroupData[{
Cell[12259, 328, 146, 5, 70, "ExampleSection",
 CellID->3125945],
Cell[CellGroupData[{
Cell[12430, 337, 295, 10, 28, "Input",
 CellID->6384],
Cell[12728, 349, 265, 9, 36, "Output",
 CellID->4434]
}, Open  ]],
Cell[13008, 361, 120, 3, 70, "ExampleDelimiter",
 CellID->4774],
Cell[13131, 366, 52, 1, 70, "ExampleText",
 CellID->18801],
Cell[CellGroupData[{
Cell[13208, 371, 285, 9, 28, "Input",
 CellID->17966],
Cell[13496, 382, 266, 9, 36, "Output",
 CellID->14410]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13811, 397, 220, 7, 70, "ExampleSection",
 CellID->403514029],
Cell[14034, 406, 84, 1, 70, "ExampleText",
 CellID->128952776],
Cell[CellGroupData[{
Cell[14143, 411, 438, 16, 70, "Input",
 CellID->408681152],
Cell[14584, 429, 420, 15, 36, "Output",
 CellID->192295837]
}, Open  ]],
Cell[15019, 447, 125, 3, 70, "ExampleDelimiter",
 CellID->167352446],
Cell[15147, 452, 92, 1, 70, "ExampleText",
 CellID->261025858],
Cell[CellGroupData[{
Cell[15264, 457, 456, 17, 70, "Input",
 CellID->787657734],
Cell[15723, 476, 342, 11, 36, "Output",
 CellID->367924718]
}, Open  ]],
Cell[16080, 490, 124, 3, 70, "ExampleDelimiter",
 CellID->19340244],
Cell[16207, 495, 119, 3, 70, "ExampleText",
 CellID->311391138],
Cell[CellGroupData[{
Cell[16351, 502, 509, 18, 70, "Input",
 CellID->86935034],
Cell[16863, 522, 341, 11, 36, "Output",
 CellID->63633446]
}, Open  ]],
Cell[17219, 536, 117, 3, 70, "ExampleText",
 CellID->459487451],
Cell[CellGroupData[{
Cell[17361, 543, 342, 12, 70, "Input",
 CellID->264247001],
Cell[17706, 557, 311, 11, 36, "Output",
 CellID->89126287]
}, Open  ]],
Cell[18032, 571, 124, 3, 70, "ExampleDelimiter",
 CellID->81668544],
Cell[18159, 576, 83, 1, 70, "ExampleText",
 CellID->371662220],
Cell[18245, 579, 530, 18, 70, "Input",
 CellID->19370597],
Cell[CellGroupData[{
Cell[18800, 601, 130, 4, 70, "Input",
 CellID->578318452],
Cell[18933, 607, 1121, 22, 70, "Output",
 Evaluatable->False,
 CellID->80810415]
}, Open  ]],
Cell[CellGroupData[{
Cell[20091, 634, 145, 4, 70, "Input",
 CellID->113680946],
Cell[20239, 640, 1069, 22, 70, "Output",
 Evaluatable->False,
 CellID->38810842]
}, Open  ]],
Cell[CellGroupData[{
Cell[21345, 667, 145, 4, 70, "Input",
 CellID->306496838],
Cell[21493, 673, 987, 20, 70, "Output",
 Evaluatable->False,
 CellID->91631999]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22529, 699, 239, 7, 70, "ExampleSection",
 CellID->27084],
Cell[22771, 708, 69, 1, 70, "ExampleText",
 CellID->2084],
Cell[CellGroupData[{
Cell[22865, 713, 311, 10, 70, "Input",
 CellID->11905],
Cell[23179, 725, 274, 9, 36, "Output",
 CellID->85904704]
}, Open  ]],
Cell[23468, 737, 121, 3, 70, "ExampleDelimiter",
 CellID->10259],
Cell[23592, 742, 364, 13, 70, "ExampleText",
 CellID->26009],
Cell[CellGroupData[{
Cell[23981, 759, 135, 4, 70, "Input",
 CellID->10627],
Cell[24119, 765, 452, 16, 36, "Output",
 CellID->53799670]
}, Open  ]],
Cell[CellGroupData[{
Cell[24608, 786, 128, 4, 70, "Input",
 CellID->4805],
Cell[24739, 792, 454, 16, 36, "Output",
 CellID->2096687]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25242, 814, 227, 7, 70, "ExampleSection",
 CellID->163165145],
Cell[25472, 823, 75, 1, 70, "ExampleText",
 CellID->27890403],
Cell[CellGroupData[{
Cell[25572, 828, 295, 10, 70, "Input",
 CellID->81247788],
Cell[25870, 840, 779, 24, 92, "Output",
 CellID->809014745]
}, Open  ]],
Cell[26664, 867, 63, 1, 70, "ExampleText",
 CellID->146560704],
Cell[CellGroupData[{
Cell[26752, 872, 348, 11, 70, "Input",
 CellID->138025308],
Cell[27103, 885, 772, 23, 78, "Output",
 CellID->256082643]
}, Open  ]],
Cell[27890, 911, 125, 3, 70, "ExampleDelimiter",
 CellID->488447169],
Cell[28018, 916, 63, 1, 70, "ExampleText",
 CellID->846295389],
Cell[CellGroupData[{
Cell[28106, 921, 3790, 112, 70, "Input",
 CellID->960775677],
Cell[31899, 1035, 1200, 24, 70, "Output",
 Evaluatable->False,
 CellID->406861895]
}, Open  ]],
Cell[33114, 1062, 217, 8, 70, "ExampleText",
 CellID->93746382],
Cell[CellGroupData[{
Cell[33356, 1074, 4547, 128, 70, "Input",
 CellID->206418055],
Cell[37906, 1204, 1200, 24, 70, "Output",
 Evaluatable->False,
 CellID->129241600]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39155, 1234, 237, 7, 70, "ExampleSection",
 CellID->278641385],
Cell[39395, 1243, 868, 33, 70, "ExampleText",
 CellID->550782773],
Cell[CellGroupData[{
Cell[40288, 1280, 401, 14, 70, "Input",
 CellID->420989218],
Cell[40692, 1296, 354, 12, 36, "Output",
 CellID->26123834]
}, Open  ]],
Cell[CellGroupData[{
Cell[41083, 1313, 476, 17, 70, "Input",
 CellID->113110271],
Cell[41562, 1332, 355, 12, 36, "Output",
 CellID->805910500]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41966, 1350, 223, 7, 70, "ExampleSection",
 CellID->7771],
Cell[42192, 1359, 87, 1, 70, "ExampleText",
 CellID->16434],
Cell[CellGroupData[{
Cell[42304, 1364, 235, 8, 70, "Input",
 CellID->31288],
Cell[42542, 1374, 702, 21, 54, "Output",
 CellID->236138021]
}, Open  ]],
Cell[43259, 1398, 121, 3, 70, "ExampleDelimiter",
 CellID->20496],
Cell[43383, 1403, 235, 8, 70, "ExampleText",
 CellID->10943],
Cell[CellGroupData[{
Cell[43643, 1415, 262, 9, 70, "Input",
 CellID->11471],
Cell[43908, 1426, 1090, 28, 71, "Output",
 CellID->250573448]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45059, 1461, 311, 9, 70, "SeeAlsoSection",
 CellID->27673],
Cell[45373, 1472, 1671, 62, 70, "SeeAlso",
 CellID->5637]
}, Open  ]],
Cell[CellGroupData[{
Cell[47081, 1539, 314, 9, 70, "TutorialsSection",
 CellID->25610],
Cell[47398, 1550, 157, 3, 70, "Tutorials",
 CellID->31969],
Cell[47558, 1555, 151, 3, 70, "Tutorials",
 CellID->2230],
Cell[47712, 1560, 140, 3, 70, "Tutorials",
 CellID->13709]
}, Open  ]],
Cell[CellGroupData[{
Cell[47889, 1568, 318, 9, 70, "MoreAboutSection",
 CellID->64927752],
Cell[48210, 1579, 153, 3, 70, "MoreAbout",
 CellID->193733144],
Cell[48366, 1584, 154, 3, 70, "MoreAbout",
 CellID->55990958],
Cell[48523, 1589, 144, 3, 70, "MoreAbout",
 CellID->58635935],
Cell[48670, 1594, 144, 3, 70, "MoreAbout",
 CellID->119553023],
Cell[48817, 1599, 174, 3, 70, "MoreAbout",
 CellID->609063],
Cell[48994, 1604, 181, 3, 70, "MoreAbout",
 CellID->485418728],
Cell[49178, 1609, 164, 3, 70, "MoreAbout",
 CellID->755884858]
}, Open  ]],
Cell[CellGroupData[{
Cell[49379, 1617, 305, 8, 70, "RelatedLinksSection"],
Cell[49687, 1627, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[50084, 1643, 50, 0, 70, "History"],
Cell[50137, 1645, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

