(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18867,        595]
NotebookOptionsPosition[     15700,        495]
NotebookOutlinePosition[     17132,        534]
CellTagsIndexPosition[     17047,        529]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotStyle" :> Documentation`HelpLookup["paclet:ref/PlotStyle"],
           "PlotMarkers" :> 
          Documentation`HelpLookup["paclet:ref/PlotMarkers"], "Filling" :> 
          Documentation`HelpLookup["paclet:ref/Filling"], "Point" :> 
          Documentation`HelpLookup["paclet:ref/Point"], "Line" :> 
          Documentation`HelpLookup["paclet:ref/Line"], "InterpolationOrder" :> 
          Documentation`HelpLookup["paclet:ref/InterpolationOrder"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"PlotStyle\"\>", 
       2->"\<\"PlotMarkers\"\>", 3->"\<\"Filling\"\>", 4->"\<\"Point\"\>", 
       5->"\<\"Line\"\>", 
       6->"\<\"InterpolationOrder\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Options & Styling\"\>", 
       2->"\<\"Plotting Options\"\>", 
       3->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Joined", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Joined",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ListPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
     " and related functions which specifies whether points in each dataset \
should be joined into a line, or should be plotted as separate points. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Joined", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " plots each dataset as a line."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Joined", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " plots all datasets as points."
}], "Notes",
 CellID->106484835],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Joined", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies separately whether to join each dataset. If there are more \
datasets than ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " given, the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are used cyclically. "
}], "Notes",
 CellID->55435801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Joined", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " specifies that a line rather than points should be drawn. The additional \
option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " specifies that the original points should also be indicated."
}], "Notes",
 CellID->784003466]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255366869],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->213300431],

Cell["Specify that points should be joined:", "ExampleText",
 CellID->81529745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "n"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", "n"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->505280435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{{1., -1.}, {2., 1.}, {3., -1.}, {4., 1.}, {5., -1.}, {6., 
       1.}, {7., -1.}, {8., 1.}, {9., -1.}, {10., 1.}}]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    PlotRange->{{0., 10.}, {-1., 1.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., -1.}, {2., 1.}, {3., -1.}, {4., 1.}, {5., -1.}, {6., 
       1.}, {7., -1.}, {8., 1.}, {9., -1.}, {10., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    PlotRange->{{0., 10.}, {-1., 1.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77410691]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->682975361],

Cell["Use both standard and joined plots with multiple datasets:", \
"ExampleText",
 CellID->580354268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"n", " ", "2", " ", 
           RowBox[{"Pi", "/", "3"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "/", "5"}], ",", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "n"}], "/", "10"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "50"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9640376],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{1., 0.8660254037844386}, {2., -0.8660254037844386}, {3., 0.}, {
      4., 0.8660254037844386}, {5., -0.8660254037844386}, {6., 0.}, {7., 
      0.8660254037844386}, {8., -0.8660254037844386}, {9., 0.}, {10., 
      0.8660254037844386}}]}}, {{}, {}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     PointBox[{{0.2, 0.9048374180359595}, {0.4, 0.8187307530779818}, {0.6, 
      0.7408182206817179}, {0.8, 0.6703200460356393}, {1., 
      0.6065306597126334}, {1.2, 0.5488116360940265}, {1.4, 
      0.4965853037914095}, {1.6, 0.44932896411722156`}, {1.8, 
      0.4065696597405991}, {2., 0.36787944117144233`}, {2.2, 
      0.33287108369807955`}, {2.4, 0.30119421191220214`}, {2.6, 
      0.2725317930340126}, {2.8, 0.2465969639416065}, {3., 
      0.22313016014842982`}, {3.2, 0.20189651799465538`}, {3.4, 
      0.18268352405273466`}, {3.6, 0.16529888822158653`}, {3.8, 
      0.14956861922263506`}, {4., 0.1353352832366127}, {4.2, 
      0.1224564282529819}, {4.4, 0.11080315836233387`}, {4.6, 
      0.10025884372280375`}, {4.8, 0.09071795328941251}, {5., 
      0.0820849986238988}, {5.2, 0.07427357821433388}, {5.4, 
      0.06720551273974976}, {5.6, 0.06081006262521797}, {5.8, 
      0.05502322005640723}, {6., 0.049787068367863944`}, {6.2, 
      0.0450492023935578}, {6.4, 0.04076220397836621}, {6.6, 
      0.036883167401240015`}, {6.8, 0.03337326996032608}, {7., 
      0.0301973834223185}, {7.2, 0.02732372244729256}, {7.4, 
      0.024723526470339388`}, {7.6, 0.0223707718561656}, {7.8, 
      0.02024191144580439}, {8., 0.01831563888873418}, {8.2, 
      0.016572675401761255`}, {8.4, 0.014995576820477703`}, {8.6, 
      0.013568559012200934`}, {8.8, 0.012277339903068436`}, {9., 
      0.011108996538242306`}, {9.2, 0.010051835744633586`}, {9.4, 
      0.009095277101695816}, {9.6, 0.00822974704902003}, {9.8, 
      0.007446583070924338}, {10., 0.006737946999085467}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283258547]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotMarkers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotMarkers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Filling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Filling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Line"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolationOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolationOrder"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->259776004],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->21674115],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->36742015]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Joined - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 42.5130692}", "context" -> "System`", 
    "keywords" -> {
     "joining style", "PlotJoined", "line plotting style", "connected plot", 
      "disjointed plot", "discrete plot", "continuous plot"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Joined is an option for ListPlot and related functions which specifies \
whether points in each dataset should be joined into a line, or should be \
plotted as separate points. ", "synonyms" -> {}, "title" -> "Joined", "type" -> 
    "Symbol", "uri" -> "ref/Joined"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7201, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->255366869]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16904, 522}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2063, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2686, 72, 1571, 37, 70, "ObjectNameGrid"],
Cell[4260, 111, 688, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4985, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5463, 152, 226, 8, 70, "Notes",
 CellID->1067943069],
Cell[5692, 162, 227, 8, 70, "Notes",
 CellID->106484835],
Cell[5922, 172, 681, 25, 70, "Notes",
 CellID->55435801],
Cell[6606, 199, 558, 18, 70, "Notes",
 CellID->784003466]
}, Closed]],
Cell[CellGroupData[{
Cell[7201, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255366869],
Cell[CellGroupData[{
Cell[7586, 236, 148, 5, 70, "ExampleSection",
 CellID->213300431],
Cell[7737, 243, 79, 1, 70, "ExampleText",
 CellID->81529745],
Cell[CellGroupData[{
Cell[7841, 248, 649, 22, 28, "Input",
 CellID->505280435],
Cell[8493, 272, 997, 29, 129, "Output",
 CellID->77410691]
}, Open  ]],
Cell[9505, 304, 125, 3, 70, "ExampleDelimiter",
 CellID->682975361],
Cell[9633, 309, 103, 2, 70, "ExampleText",
 CellID->580354268],
Cell[CellGroupData[{
Cell[9761, 315, 908, 29, 70, "Input",
 CellID->9640376],
Cell[10672, 346, 2283, 42, 117, "Output",
 CellID->283258547]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13016, 395, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[13335, 406, 1447, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[14819, 464, 299, 8, 70, "MoreAboutSection"],
Cell[15121, 474, 163, 3, 70, "MoreAbout",
 CellID->259776004],
Cell[15287, 479, 142, 3, 70, "MoreAbout",
 CellID->21674115],
Cell[15432, 484, 196, 4, 70, "MoreAbout",
 CellID->36742015]
}, Open  ]],
Cell[15643, 491, 27, 0, 70, "History"],
Cell[15673, 493, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

