(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20632,        747]
NotebookOptionsPosition[     15983,        586]
NotebookOutlinePosition[     17207,        622]
CellTagsIndexPosition[     17122,        617]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuedFraction"], 
          "ArithmeticGeometricMean" :> 
          Documentation`HelpLookup["paclet:ref/ArithmeticGeometricMean"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ContinuedFraction\"\>", 
       2->"\<\"ArithmeticGeometricMean\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematical Constants\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Khinchin", "ObjectName",
 CellID->21579],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Khinchin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Khinchin"]], "InlineFormula"],
     " \[LineSeparator]is Khinchin's constant, with numerical value ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[TildeEqual]", "2.68545"}], TraditionalForm]], "InlineMath"],
     
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Mathematical constant treated as numeric by ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " and as a constant by ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Khinchin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Khinchin"]], "InlineFormula"],
 " can be evaluated to any numerical precision using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2118],

Cell[TextData[{
 "Khinchin's constant (sometimes called Khintchine's constant) is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Product]", 
     RowBox[{"s", "=", "1"}], "\[Infinity]",
     LimitsPositioning->True], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"s", 
         RowBox[{"(", 
          RowBox[{"s", "+", "2"}], ")"}]}]]}], ")"}], 
     RowBox[{
      SubscriptBox["log", "2"], "s"}]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->16786]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->671811926],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->281221020],

Cell["Evaluate to any precision:", "ExampleText",
 CellID->14183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Khinchin", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11785],

Cell[BoxData["2.\
6854520010653064453097148354817956938203822939944629530511523455572`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203047725]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7238],

Cell["Do an exact numerical computation:", "ExampleText",
 CellID->31393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"Khinchin", "^", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32267],

Cell[BoxData["7975160530073655774671985794452796861418592"], "Output",
 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320322104]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->562258394],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->1001012652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Khinchin", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164987314],

Cell[BoxData[
 FormBox[
  TagBox["K",
   Function[{}, Khinchin]], TraditionalForm]], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->627086804]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14647],

Cell[TextData[{
 "Geometric mean of the first 1000 continued fraction terms in ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Apply", "[", 
    RowBox[{"Times", ",", 
     RowBox[{"ContinuedFraction", "[", 
      RowBox[{"Pi", ",", "1000"}], "]"}]}], "]"}], "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", "1000"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20611],

Cell[BoxData["2.6656255293203435`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579848167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "Khinchin", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20997],

Cell[BoxData["2.6854520010653062`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156969676]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Various symbolic relations are automatically used:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "<", "Khinchin", "<", "3"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->499274719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Various products give results that can be expressed using ",
 Cell[BoxData[
  ButtonBox["Khinchin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Khinchin"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"k", 
         RowBox[{"(", 
          RowBox[{"k", "+", "2"}], ")"}]}], ")"}]}]}], ")"}], "^", 
    RowBox[{"Log", "[", 
     RowBox[{"2", ",", "k"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["Khinchin"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336599187]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Terms in the continued fraction:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"ContinuedFraction", "[", 
    RowBox[{"Khinchin", ",", "400"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdmEuOm0UURgtGDD1gwIDBTwshhBAy7zcpXuENTgcSICGpBJoQAsQkgYRZ
DRl6Cf8SvIRagpdQS/ASEPI9LdXpye3j7z7qXWU/cf328cnDKaXNQyn9bw9/
+zPxTx4tnz+izxdhH5XF/zHx44qfpB+Jn8xj3afy+PnTyveM4p9V/HPyX4Z9
Lezzin9B8S8q/iXpLyv+FfGr4qhbL8Tnryv/G/J/M5h+vyX9bfE74jPiHBzz
VmHqvxs25rHCxL8nHWY83h/9qzh9MNarMOvoQ+kw8Weln5X+kerDrNuPpcP0
/xPlh+nfp9Jh6n+m/DD1P5cuTl8oP8z4fCkdJv4r5Ydp/ypsrJsMx76sq9G/
weQ/N/Ynnxv967nRv8Hs3+OwMa75ePSvcPSvidP5sHGuZJj1eH70b+L0ddg4
BzIc/aniBhP/zcgZpv8w/Rcn9j3tvzDqp+dCzHeTni6q/sVRrzDxMPP/7eif
xVXcYPr/neqLK0w8zDn9fdg413Pw4t+IRyceZv9cUv1Lo3+F4x5o0tPlUc8w
7b88+jeYe+2HUc/iKm7wUdgran8w50hFJ17+6arir47+FY56Deb8KGN/Jph8
cOQr0qv0GWa9wTFfXf7pWtT5PeoHn+6Ha6N/EVc48s8w5xUc93aXnq6P+SY4
zqcMxzugwJyPcNzjs/I1OO7rLj39qPow9eFob4EZf8XPcNzjDY5122Hm/yfV
F2eY+jD14cg3K77Jv0tPJ2P+6WT0zyejf5Fepc/iJv8uTj+HjfUzwfQfjv1R
5F/lP8PcN9I7zLv3xug/3Rj9Mxz1ivyr/Gdxg+N87dLTLyNP4gzH/BaY+w1m
/8H0H47x69LTTdW/OepZehFXOPb3LL3B8e7syp9+VX1xhhl/mPcFHPlmON4z
TXpX/nRL9W+N/ll6gVl/0meY81d6V/70W9hYjxMc93OGqQ+z/qTP4gYfHWyX
nuLcP71/4FhfWXqBmX+Y9Qez/uTf4T/D/jHqkziLi7jC1Jfe4Phe2GHun9uq
DzP/wbwbi/wrHPM3S2/K12Hqr0d9AdMe8VL+GY58Kzje00Xxa5jvm4rfSJ8V
vxU38Q6O+7PDcf7tg0+/J7IO6H/w9t7BTtKXMOtD+kp6gWN9rKVXxW/Es/y3
MO8b6Ttxl/9eeroz1luIpzuj/xLmfJC+gnkviNfKX+EYn414Vv6t9AbH7wY7
+Xf46GD30tPdMd/i7qhP4qU4w8y/9CJeiysc59sGjvfiLH2r+Kb6O+kdjv20
V3/TvdF/ATP/4qX8s3glLnC859cw+1/5N/DRwc5wjAf7kvFocPRnp/pd+ffi
9Nfov4CjvRMc63cpznD0ZwXH+VOUfw2z/uHYTxv5z2rPVvUbTP+Vv6t9e+VP
f4+8gJl/8VKcYc5/5SviNRzft2sw33s38p/FW9Vv0nfiDtN/6el+tCN+F1wE
87vudH/0X4ozzP6XXmDOf+kVPjrYDcz9B8f4bhXfpO/Uni7eKz49GPXFg1Gf
4NhvS+kZjv6tpBflX0uv4o14hum/8jX57+B4f3TF79Xe9M+p/h8cc6hI
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{229, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->359090994]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4826],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArithmeticGeometricMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArithmeticGeometricMean"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19578]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18578],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->20313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->2650],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/KhintchinesConstant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/Khinchin/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Khinchin"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->436128362],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->26024574]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Khinchin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 48.2944672}", "context" -> "System`", 
    "keywords" -> {"continued fractions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Khinchin is Khinchin's constant, with numerical value \\[TildeEqual] \
2.68545. ", "synonyms" -> {}, "title" -> "Khinchin", "type" -> "Symbol", 
    "uri" -> "ref/Khinchin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4966, 172, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->671811926]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16979, 610}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1940, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2563, 76, 46, 1, 70, "ObjectName",
 CellID->21579],
Cell[2612, 79, 559, 18, 70, "Usage",
 CellID->21031]
}, Open  ]],
Cell[CellGroupData[{
Cell[3208, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3686, 119, 349, 13, 70, "Notes",
 CellID->5918],
Cell[4038, 134, 328, 12, 70, "Notes",
 CellID->2118],
Cell[4369, 148, 560, 19, 70, "Notes",
 CellID->16786]
}, Closed]],
Cell[CellGroupData[{
Cell[4966, 172, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->671811926],
Cell[CellGroupData[{
Cell[5351, 186, 148, 5, 70, "ExampleSection",
 CellID->281221020],
Cell[5502, 193, 65, 1, 70, "ExampleText",
 CellID->14183],
Cell[CellGroupData[{
Cell[5592, 198, 124, 4, 28, "Input",
 CellID->11785],
Cell[5719, 204, 235, 7, 36, "Output",
 CellID->203047725]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6003, 217, 215, 7, 70, "ExampleSection",
 CellID->7238],
Cell[6221, 226, 73, 1, 70, "ExampleText",
 CellID->31393],
Cell[CellGroupData[{
Cell[6319, 231, 129, 4, 70, "Input",
 CellID->32267],
Cell[6451, 237, 201, 5, 36, "Output",
 CellID->320322104]
}, Open  ]],
Cell[6667, 245, 125, 3, 70, "ExampleDelimiter",
 CellID->562258394],
Cell[6795, 250, 204, 7, 70, "ExampleText",
 CellID->1001012652],
Cell[CellGroupData[{
Cell[7024, 261, 114, 3, 70, "Input",
 CellID->164987314],
Cell[7141, 266, 241, 8, 50, "Output",
 CellID->627086804]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7431, 280, 223, 7, 70, "ExampleSection",
 CellID->14647],
Cell[7657, 289, 182, 6, 70, "ExampleText",
 CellID->32457],
Cell[CellGroupData[{
Cell[7864, 299, 308, 10, 70, "Input",
 CellID->20611],
Cell[8175, 311, 176, 5, 36, "Output",
 CellID->579848167]
}, Open  ]],
Cell[CellGroupData[{
Cell[8388, 321, 100, 3, 70, "Input",
 CellID->20997],
Cell[8491, 326, 176, 5, 36, "Output",
 CellID->156969676]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8716, 337, 217, 6, 70, "ExampleSection"],
Cell[8936, 345, 73, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[9034, 349, 89, 2, 70, "Input"],
Cell[9126, 353, 161, 5, 36, "Output",
 CellID->499274719]
}, Open  ]],
Cell[9302, 361, 105, 2, 70, "ExampleDelimiter"],
Cell[9410, 365, 221, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[9656, 376, 445, 15, 70, "Input"],
Cell[10104, 393, 165, 5, 36, "Output",
 CellID->336599187]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10318, 404, 208, 6, 70, "ExampleSection"],
Cell[10529, 412, 55, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10609, 416, 225, 6, 70, "Input"],
Cell[10837, 424, 2048, 41, 161, "Output",
 CellID->359090994]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12946, 472, 310, 9, 70, "SeeAlsoSection",
 CellID->4826],
Cell[13259, 483, 499, 17, 70, "SeeAlso",
 CellID->19578]
}, Open  ]],
Cell[CellGroupData[{
Cell[13795, 505, 314, 9, 70, "TutorialsSection",
 CellID->18578],
Cell[14112, 516, 154, 3, 70, "Tutorials",
 CellID->20313]
}, Open  ]],
Cell[CellGroupData[{
Cell[14303, 524, 320, 9, 70, "RelatedLinksSection",
 CellID->2650],
Cell[14626, 535, 190, 4, 70, "RelatedLinks"],
Cell[14819, 541, 190, 4, 70, "RelatedLinks"],
Cell[15012, 547, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15435, 565, 319, 9, 70, "MoreAboutSection",
 CellID->436128362],
Cell[15757, 576, 154, 3, 70, "MoreAbout",
 CellID->26024574]
}, Open  ]],
Cell[15926, 582, 27, 0, 70, "History"],
Cell[15956, 584, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

