(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41412,       1508]
NotebookOptionsPosition[     33197,       1220]
NotebookOutlinePosition[     34603,       1258]
CellTagsIndexPosition[     34517,       1253]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DiscreteDelta" :> 
          Documentation`HelpLookup["paclet:ref/DiscreteDelta"], 
          "IdentityMatrix" :> 
          Documentation`HelpLookup["paclet:ref/IdentityMatrix"], "UnitVector" :> 
          Documentation`HelpLookup["paclet:ref/UnitVector"], "Equal" :> 
          Documentation`HelpLookup["paclet:ref/Equal"], "UnitStep" :> 
          Documentation`HelpLookup["paclet:ref/UnitStep"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "Boole" :> 
          Documentation`HelpLookup["paclet:ref/Boole"], "Signature" :> 
          Documentation`HelpLookup["paclet:ref/Signature"], "DiracDelta" :> 
          Documentation`HelpLookup["paclet:ref/DiracDelta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DiscreteDelta\"\>", 
       2->"\<\"IdentityMatrix\"\>", 3->"\<\"UnitVector\"\>", 
       4->"\<\"Equal\"\>", 5->"\<\"UnitStep\"\>", 6->"\<\"If\"\>", 
       7->"\<\"Boole\"\>", 8->"\<\"Signature\"\>", 
       9->"\<\"DiracDelta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tensors" :> 
          Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Tensors\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KroneckerDelta", "ObjectName",
 CellID->26474],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["KroneckerDelta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/KroneckerDelta"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Kronecker delta ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["n", "1"], " ", 
         SubscriptBox["n", "2"], " ", "\[Ellipsis]"}]], TraditionalForm]], 
      "InlineMath"],
     ", equal to 1 if all the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
     " are equal, and 0 otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"], "[", "0", "]"}]], 
  "InlineFormula"],
 " gives 1; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives 0 for other numeric ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17683],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["KroneckerDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerDelta"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15563]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23532555],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->54506916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", 
  RowBox[{"1", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31799907],

Cell[BoxData["0"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21395221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119101254],

Cell["Construct identity matrix:", "ExampleText",
 CellID->79242719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Array", "[", 
   RowBox[{"KroneckerDelta", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250548222],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVr1ug0AMPiA0aZPsHbNn6JwXaKc+BIoqJUPVKs3AxsjIyMgjMDIyMjIy
MjIyMl59f7kLvahJLpU6gARnG9ufZZ/P9+rtN2/v3n679hYvO+9zs11/LZ4/
diByLITQCt7lIwIaA0XfFcawql+XfJ0kSTB90JLyQRBw3qFaI0pWVZVlGSEJ
74DDGV+nsLqw3glvZVn2reM4Vn0SdSweoNGDVjqjBgcpR+i6zvd9ieAIKQNh
iFcijCkfhiG4I6R9QLCLonCNPUMKIZHHnml2mqa5TeyyTiqCrKk5AqSGbZk/
QJiIfHDe0iKQOqg7kKy2wFD09NZPg1Yvj6KDp5y/P8taX+d+RfV1nwwIA8KJ
jiadPMeX7MT/2l+XaEVRdIaWnNWqFpyXbdtiXim1k8UJyapQ13WapoRUT24Y
F3xis/n6W0X1UjYb8jzXzDcIjuOaI0CejmZz/37hGiPInEsEGzJkEjuxtSEH
NFoeo4x5ZOj5x/2KI7BLxW0QpC+GQHaY2qlip83pX3a/RNY3rlsvDA==\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{57, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->56173880]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177559186],

Cell["Use in sums to pick out elements:", "ExampleText",
 CellID->110154326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"KroneckerDelta", "[", 
     RowBox[{"a", ",", " ", "3"}], "]"}], " ", 
    RowBox[{"f", "[", "a", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->515022281],

Cell[BoxData[
 RowBox[{"f", "[", "3", "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59686922]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15819],

Cell["One\[Hyphen]argument form:", "ExampleText",
 CellID->225669532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"KroneckerDelta", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->350334794],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->428515341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107201057],

Cell["Multi\[Hyphen]argument form:", "ExampleText",
 CellID->592407739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", 
  RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191584790],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->580526029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198362057],

Cell["Arguments can be approximate numbers:", "ExampleText",
 CellID->878168419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", 
  RowBox[{"2", ",", "2."}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332421388],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366847390]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", 
  RowBox[{
   RowBox[{"2", "-", "I"}], ",", 
   RowBox[{"2.", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15134991],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42550195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257297806],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->218841731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KroneckerDelta", "[", 
   RowBox[{"n", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367317939],

Cell[BoxData[
 FormBox[
  SubscriptBox[
   InterpretationBox["\[Delta]",
    KroneckerDelta,
    Editable->False,
    Selectable->False], 
   RowBox[{"m", ",", "n"}]], TraditionalForm]], "Output",
 ImageSize->{25, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->80826062]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5646],

Cell["Use in sums to pick out terms:", "ExampleText",
 CellID->727968800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"KroneckerDelta", "[", 
     RowBox[{
      RowBox[{"k", "-", "j"}], ",", "3"}], "]"}], "/", 
    RowBox[{"j", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557685447],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "6"]], "Output",
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->645916172]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->778657541],

Cell["Generate a banded matrix with two superdiagonals:", "ExampleText",
 CellID->368857599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{"i", "-", "j", "+", "1"}], "]"}], "+", 
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{"i", "-", "j", "+", "2"}], "]"}]}], ")"}], "i", " ", 
     RowBox[{"j", "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->371306354],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "4", "9", "0", "0"},
     {"0", "0", "18", "32", "0"},
     {"0", "0", "0", "48", "75"},
     {"0", "0", "0", "0", "100"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{119, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->57306700]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314510121],

Cell["Pick out elements:", "ExampleText",
 CellID->38416448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"KroneckerDelta", "[", 
     RowBox[{"n", ",", 
      RowBox[{
       RowBox[{"EulerPhi", "[", "m", "]"}], "+", "1"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "60"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "60"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131510479],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCwgWLGAQEDZO0IAqMhTGswkkKYAYmkt63YecMNYPPd8PYx
MqCHTwcmNPHaOmwjmIERrcxACNDELuKFaWEzA7oQzezGaSNuPhVthXNRfcmA
W+nQAyieYkDzI83jlZZ24LQbljfpVMkzwMKWrn5lgFhM59BlINvGgeqZAQDw
3A/1
   "], {{0, 0}, {60, 60}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  ImageSize->{146., Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{150, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341440302]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27399],

Cell[TextData[{
 "Reduce an equation containing ",
 Cell[BoxData[
  ButtonBox["KroneckerDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->300709558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "-", 
      RowBox[{"KroneckerDelta", "[", 
       RowBox[{"a", ",", "3"}], "]"}]}], "==", "2"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "10"}], "<", "a", "<", "10"}]}], ",", "a", ",", 
   "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->390556080],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", "2"}], "||", 
  RowBox[{"a", "\[Equal]", "3"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24014908]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197093058],

Cell[TextData[{
 "The support of ",
 Cell[BoxData[
  ButtonBox["KroneckerDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerDelta"]], "InlineFormula"],
 " has measure zero:"
}], "ExampleText",
 CellID->48946250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"KroneckerDelta", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331757314],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->511583119]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21025],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["KroneckerDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerDelta"]], "InlineFormula"],
 " can stay unevaluated for numeric arguments: "
}], "ExampleText",
 CellID->142782870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", 
  RowBox[{"1", ",", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox[
        RowBox[{"2", "+", 
         SqrtBox["2"]}]]}]]}], "+", 
    RowBox[{"Cos", "[", 
     FractionBox["\[Pi]", "16"], "]"}], "+", 
    SuperscriptBox["10", 
     RowBox[{"-", "100"}]]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->674971173],

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{
    "1000000000000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000001", "/", 
     "100000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000"}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox[
        RowBox[{"2", "+", 
         SqrtBox["2"]}]]}]]}], "+", 
    RowBox[{"Cos", "[", 
     FractionBox["\[Pi]", "16"], "]"}]}]}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{580, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47028899]
}, Open  ]],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed: "
}], "ExampleText",
 CellID->375642859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->613040906],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(KroneckerDelta[\\(\\(1, \
\\(\\(\\(1000000000000000000 \\(\\(\[LeftSkeleton] 62 \[RightSkeleton]\\)\\) \
00000000000000000001\\)\\/\\(1000000000000000000 \\(\\(\[LeftSkeleton] 62 \
\[RightSkeleton]\\)\\) 00000000000000000000\\) - \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\) + \\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)\\)\\)\
\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->392335376],

Cell[BoxData["1"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97642817]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{"KroneckerDelta", "[", 
    RowBox[{"1", ",", 
     RowBox[{"1", "-", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SqrtBox[
        RowBox[{"2", "+", 
         SqrtBox[
          RowBox[{"2", "+", 
           SqrtBox["2"]}]]}]]}], "+", 
      RowBox[{"Cos", "[", 
       FractionBox["\[Pi]", "16"], "]"}], "+", 
      FractionBox["1", 
       SuperscriptBox["10", "100"]]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->200870550],

Cell[BoxData["0"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->641133820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->115805184],

Cell["\<\
Equality testing of the arguments takes numerical precision into account:\
\>", "ExampleText",
 CellID->326399821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", 
  RowBox[{"1", ",", "1.00000000000001"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253413615],

Cell[BoxData["1"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31257185]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7566],

Cell["\<\
Express products of signatures as sums of products of Kronecker deltas:\
\>", "ExampleText",
 CellID->318491507],

Cell[BoxData[
 RowBox[{
  RowBox[{"signatureExpand", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"Signature", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Longest", "[", "a___", "]"}], ",", "b___"}], "}"}], "]"}], 
     RowBox[{"Signature", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Longest", "[", "a___", "]"}], ",", "c___"}], "}"}], "]"}]}], 
    "]"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"{", "a", "}"}], "]"}], "!"}], 
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Signature", "[", "#", "]"}], 
          RowBox[{"Times", " ", "@@", 
           RowBox[{"(", 
            RowBox[{"KroneckerDelta", "@@@", 
             RowBox[{"Transpose", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "b", "}"}], ",", "#"}], "}"}], "]"}]}], 
            ")"}]}]}], ")"}], "&"}], "/@", 
       RowBox[{"Permutations", "[", 
        RowBox[{"{", "c", "}"}], "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31672446],

Cell["\<\
Special cases for 3D; summation over repeated indexes is assumed:\
\>", "ExampleText",
 CellID->204685161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"signatureExpand", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{
    RowBox[{"Signature", "[", 
     RowBox[{"{", 
      RowBox[{"a1", ",", "a2", ",", "a3"}], "}"}], "]"}], 
    RowBox[{"Signature", "[", 
     RowBox[{"{", 
      RowBox[{"a1", ",", "a2", ",", "a3"}], "}"}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21679717],

Cell[BoxData["6"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200530929]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"signatureExpand", "[", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{
     RowBox[{"Signature", "[", 
      RowBox[{"{", 
       RowBox[{"a1", ",", "a2", ",", "b3"}], "}"}], "]"}], 
     RowBox[{"Signature", "[", 
      RowBox[{"{", 
       RowBox[{"a1", ",", "a2", ",", "c3"}], "}"}], "]"}]}], "]"}], "]"}], "//",
   "TraditionalForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->515618517],

Cell[BoxData[
 FormBox[
  RowBox[{"2", " ", 
   SubscriptBox[
    InterpretationBox["\[Delta]",
     KroneckerDelta,
     Editable->False,
     Selectable->False], 
    RowBox[{"b3", ",", "c3"}]]}], TraditionalForm]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{41, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TraditionalForm=",
 CellID->39136184]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"signatureExpand", "[", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{
     RowBox[{"Signature", "[", 
      RowBox[{"{", 
       RowBox[{"a1", ",", "b2", ",", "b3"}], "}"}], "]"}], 
     RowBox[{"Signature", "[", 
      RowBox[{"{", 
       RowBox[{"a1", ",", "c2", ",", "c3"}], "}"}], "]"}]}], "]"}], "]"}], "//",
   "TraditionalForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->440512099],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVVc1OwzAMdpOUdgNNDHEo2mW3vQmceIhqQtoOCDT2CH3vkv9lttOmkRrH
Tvz5s+O2n/319PXdX8/Hfv9x6X9P5+Pf/v3nok2yAoBBP9sO9HrUK/sM46il
m1/MLI3VDtgh/TCzv7IorZ6FNgotlZagrBncObMDMlrA6I+Jh/RSEE+z081j
3yx6PBUhq0ipMbO6ZeQ8Qo6RepIz3l8TBBuqjhZ/7gHhvC6OrJDeFkZWHO7d
nSiCNJW1XTK6YJHKqrHJ+s8xwVURWSSeSc3hA8OhNCtiFXlrGhfdVJrLM1+V
wrufqCvpP44F1it3nM1IZioqsgxJJzEMQnfhs5tsZad4sB2VRclxWVIVEu2u
7vQbJLOMUiScX8swbYrRKK8160f7puF40Xz862GHW/hK1l6ukB7cxuTtMGFa
L7eZc8E/nJvDC3HdLwJ3x9J/YmdRcHWXorxFLsa48/KAdBdryMxQ/QO33esF
\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{132, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//TraditionalForm=",
 CellID->120257349]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"signatureExpand", "[", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{
     RowBox[{"Signature", "[", 
      RowBox[{"{", 
       RowBox[{"b1", ",", "b2", ",", "b3"}], "}"}], "]"}], 
     RowBox[{"Signature", "[", 
      RowBox[{"{", 
       RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], "]"}]}], "]"}], "]"}], "//",
   "TraditionalForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->282351],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWNtu00AQ3dhO0lxairhVtEDViuYj4Bme+IioQmofEKj0/4P3Ftyzs55Z
e50EIiXxzO4cn5md9eV8Wz/eff+xfry/XV9+fVj/uru//X355edD7SpHSo0+
KaU+nqn6eFMfma/+fK6/9tAenevf0o9uAvsC7BtmHONXifNfGFbP69+idpb1
vx5UlXErO0+PFG5k0bArcmbDU3+OIb4IZzmk1ywHM+Rwtb1kuVCs4yz0yJm4
EvzZka+cxYlxnOrf6u9aOcDG6hVg4/gsQGhGKAKxYhHMjPHW43AqwH2VzB2Z
LZK589nT3CcQ97J33efJ3HE8RJBxN1Uz0YWP6ZVJ2RkJOymORGc2hviTbDlV
O6iObLWmgzE7nBxtR4Z7sezNrBBgxq9Whe8xBsFfpbGf0V5myBAxu2eIu0eC
FMvU++fUemReUwlmS98F3iLubbJqydrei2dRnJKI9XuGzD6KQq0ZhVJ24kL2
a2+UPBm1o0ire5SlTmnVjmVI92iAncDDrFdLH7ZdR7Aywl2xwZ2HVwAZDtYo
vOpqz1S8WzG7SYBHV5/Pb5YlP6x21Ss7eVe35zYNPDIkLrunT5z+ncdwcCtb
uMo27dg8ja7BJ5F5lRv3eKfC88bwpPz8eT0/3AnVnnjYu9MS2ORWFd6Djc94
XPyVYbkYmOUHsLFzufjrbS2189z9X7j/G7D9+CritzlrYNSA8hy9TcwuVRnC
+dxqWSXJ78cWFSeqD/VUUZrz3Ngbnk2ypvSU/zIvmyh2u74VZRGobMfG8WxD
3gsS3kzSlaWuCgfu4n0oS+Q9eSfc+TOnqmLSuqOiZzvH35+G1IOGVihwVVCF
GUfxdqfCxN5G95+jnFm+aslytG9I4Q5JVyV8ThJ9aDdqBDKmlMPDUZ+Yvhep
TrvImOndDj0o0a+kiqJ9szoiz/uvqhjkKv5XKlSeDA9ZObR92XzCnZB9jm+J
3dSV4ZQMaqWmYrThVKg5GRfWF/nnzYdWGiPXxVYVrdvqxFXCkTH9k2hXJSlV
cZk15lNPUn2VH893KB4cvpQv8rAKFGo7nLrwDmzs3b7xnFph1RlU8YbWwbh4
jvX1ttbaKVWiVmD78TSFSo3+AMigcgU=\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{315, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//TraditionalForm=",
 CellID->96204029]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21697],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiscreteDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiscreteDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdentityMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IdentityMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitStep",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitStep"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiracDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiracDelta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29670]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26249],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->22797]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->131921801],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->79730358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
KroneckerDelta"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KroneckerDelta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 6.1230486}", "context" -> "System`", 
    "keywords" -> {"delta function", "Kronecker delta"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "KroneckerDelta[n_1, n_2, ...] gives the Kronecker delta \\[Delta] \
Subscript[n, 1] Subscript[n, 2] ..., equal to 1 if all the n_i are equal, and \
0 otherwise. ", "synonyms" -> {"Kronecker delta"}, "title" -> 
    "KroneckerDelta", "type" -> "Symbol", "uri" -> "ref/KroneckerDelta"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5762, 184, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23532555]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34375, 1246}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2606, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3229, 87, 52, 1, 70, "ObjectName",
 CellID->26474],
Cell[3284, 90, 1079, 34, 70, "Usage",
 CellID->29313]
}, Open  ]],
Cell[CellGroupData[{
Cell[4400, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4878, 146, 522, 19, 70, "Notes",
 CellID->17683],
Cell[5403, 167, 322, 12, 70, "Notes",
 CellID->15563]
}, Closed]],
Cell[CellGroupData[{
Cell[5762, 184, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23532555],
Cell[CellGroupData[{
Cell[6146, 198, 147, 5, 70, "ExampleSection",
 CellID->54506916],
Cell[CellGroupData[{
Cell[6318, 207, 132, 4, 28, "Input",
 CellID->31799907],
Cell[6453, 213, 205, 7, 36, "Output",
 CellID->21395221]
}, Open  ]],
Cell[6673, 223, 125, 3, 70, "ExampleDelimiter",
 CellID->119101254],
Cell[6801, 228, 68, 1, 70, "ExampleText",
 CellID->79242719],
Cell[CellGroupData[{
Cell[6894, 233, 222, 7, 28, "Input",
 CellID->250548222],
Cell[7119, 242, 814, 18, 78, "Output",
 Evaluatable->False,
 CellID->56173880]
}, Open  ]],
Cell[7948, 263, 125, 3, 70, "ExampleDelimiter",
 CellID->177559186],
Cell[8076, 268, 76, 1, 70, "ExampleText",
 CellID->110154326],
Cell[CellGroupData[{
Cell[8177, 273, 306, 10, 70, "Input",
 CellID->515022281],
Cell[8486, 285, 232, 8, 36, "Output",
 CellID->59686922]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8767, 299, 216, 7, 70, "ExampleSection",
 CellID->15819],
Cell[8986, 308, 69, 1, 70, "ExampleText",
 CellID->225669532],
Cell[CellGroupData[{
Cell[9080, 313, 246, 8, 70, "Input",
 CellID->350334794],
Cell[9329, 323, 233, 7, 36, "Output",
 CellID->428515341]
}, Open  ]],
Cell[9577, 333, 125, 3, 70, "ExampleDelimiter",
 CellID->107201057],
Cell[9705, 338, 71, 1, 70, "ExampleText",
 CellID->592407739],
Cell[CellGroupData[{
Cell[9801, 343, 153, 4, 70, "Input",
 CellID->191584790],
Cell[9957, 349, 158, 5, 36, "Output",
 CellID->580526029]
}, Open  ]],
Cell[10130, 357, 125, 3, 70, "ExampleDelimiter",
 CellID->198362057],
Cell[10258, 362, 80, 1, 70, "ExampleText",
 CellID->878168419],
Cell[CellGroupData[{
Cell[10363, 367, 134, 4, 70, "Input",
 CellID->332421388],
Cell[10500, 373, 158, 5, 36, "Output",
 CellID->366847390]
}, Open  ]],
Cell[CellGroupData[{
Cell[10695, 383, 181, 6, 70, "Input",
 CellID->15134991],
Cell[10879, 391, 157, 5, 36, "Output",
 CellID->42550195]
}, Open  ]],
Cell[11051, 399, 125, 3, 70, "ExampleDelimiter",
 CellID->257297806],
Cell[11179, 404, 203, 7, 70, "ExampleText",
 CellID->218841731],
Cell[CellGroupData[{
Cell[11407, 415, 172, 5, 70, "Input",
 CellID->367317939],
Cell[11582, 422, 342, 12, 52, "Output",
 CellID->80826062]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11973, 440, 222, 7, 70, "ExampleSection",
 CellID->5646],
Cell[12198, 449, 73, 1, 70, "ExampleText",
 CellID->727968800],
Cell[CellGroupData[{
Cell[12296, 454, 389, 13, 70, "Input",
 CellID->557685447],
Cell[12688, 469, 206, 7, 54, "Output",
 CellID->645916172]
}, Open  ]],
Cell[12909, 479, 125, 3, 70, "ExampleDelimiter",
 CellID->778657541],
Cell[13037, 484, 92, 1, 70, "ExampleText",
 CellID->368857599],
Cell[CellGroupData[{
Cell[13154, 489, 549, 17, 70, "Input",
 CellID->371306354],
Cell[13706, 508, 857, 25, 108, "Output",
 CellID->57306700]
}, Open  ]],
Cell[14578, 536, 125, 3, 70, "ExampleDelimiter",
 CellID->314510121],
Cell[14706, 541, 60, 1, 70, "ExampleText",
 CellID->38416448],
Cell[CellGroupData[{
Cell[14791, 546, 411, 13, 70, "Input",
 CellID->131510479],
Cell[15205, 561, 594, 17, 167, "Output",
 CellID->341440302]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15848, 584, 233, 7, 70, "ExampleSection",
 CellID->27399],
Cell[16084, 593, 225, 8, 70, "ExampleText",
 CellID->300709558],
Cell[CellGroupData[{
Cell[16334, 605, 364, 12, 70, "Input",
 CellID->390556080],
Cell[16701, 619, 240, 8, 36, "Output",
 CellID->24014908]
}, Open  ]],
Cell[16956, 630, 125, 3, 70, "ExampleDelimiter",
 CellID->197093058],
Cell[17084, 635, 226, 8, 70, "ExampleText",
 CellID->48946250],
Cell[CellGroupData[{
Cell[17335, 647, 250, 8, 70, "Input",
 CellID->331757314],
Cell[17588, 657, 158, 5, 36, "Output",
 CellID->511583119]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17795, 668, 226, 7, 70, "ExampleSection",
 CellID->21025],
Cell[18024, 677, 234, 7, 70, "ExampleText",
 CellID->142782870],
Cell[CellGroupData[{
Cell[18283, 688, 444, 16, 70, "Input",
 CellID->674971173],
Cell[18730, 706, 761, 24, 136, "Output",
 CellID->47028899]
}, Open  ]],
Cell[19506, 733, 247, 8, 70, "ExampleText",
 CellID->375642859],
Cell[CellGroupData[{
Cell[19778, 745, 121, 4, 70, "Input",
 CellID->613040906],
Cell[19902, 751, 757, 13, 70, "Message",
 CellID->392335376],
Cell[20662, 766, 205, 7, 36, "Output",
 CellID->97642817]
}, Open  ]],
Cell[CellGroupData[{
Cell[20904, 778, 597, 20, 70, "Input",
 CellID->200870550],
Cell[21504, 800, 206, 7, 36, "Output",
 CellID->641133820]
}, Open  ]],
Cell[21725, 810, 125, 3, 70, "ExampleDelimiter",
 CellID->115805184],
Cell[21853, 815, 124, 3, 70, "ExampleText",
 CellID->326399821],
Cell[CellGroupData[{
Cell[22002, 822, 148, 4, 70, "Input",
 CellID->253413615],
Cell[22153, 828, 205, 7, 36, "Output",
 CellID->31257185]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22407, 841, 223, 7, 70, "ExampleSection",
 CellID->7566],
Cell[22633, 850, 122, 3, 70, "ExampleText",
 CellID->318491507],
Cell[22758, 855, 1330, 42, 70, "Input",
 CellID->31672446],
Cell[24091, 899, 116, 3, 70, "ExampleText",
 CellID->204685161],
Cell[CellGroupData[{
Cell[24232, 906, 378, 12, 70, "Input",
 CellID->21679717],
Cell[24613, 920, 206, 7, 36, "Output",
 CellID->200530929]
}, Open  ]],
Cell[CellGroupData[{
Cell[24856, 932, 425, 13, 70, "Input",
 CellID->515618517],
Cell[25284, 947, 421, 15, 52, "Output",
 CellID->39136184]
}, Open  ]],
Cell[CellGroupData[{
Cell[25742, 967, 425, 13, 70, "Input",
 CellID->440512099],
Cell[26170, 982, 765, 18, 70, "Output",
 Evaluatable->False,
 CellID->120257349]
}, Open  ]],
Cell[CellGroupData[{
Cell[26972, 1005, 422, 13, 70, "Input",
 CellID->282351],
Cell[27397, 1020, 1406, 28, 70, "Output",
 Evaluatable->False,
 CellID->96204029]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28864, 1055, 311, 9, 70, "SeeAlsoSection",
 CellID->21697],
Cell[29178, 1066, 2174, 80, 70, "SeeAlso",
 CellID->29670]
}, Open  ]],
Cell[CellGroupData[{
Cell[31389, 1151, 314, 9, 70, "TutorialsSection",
 CellID->26249],
Cell[31706, 1162, 198, 4, 70, "Tutorials",
 CellID->22797]
}, Open  ]],
Cell[CellGroupData[{
Cell[31941, 1171, 319, 9, 70, "MoreAboutSection",
 CellID->131921801],
Cell[32263, 1182, 125, 3, 70, "MoreAbout",
 CellID->79730358]
}, Open  ]],
Cell[CellGroupData[{
Cell[32425, 1190, 305, 8, 70, "RelatedLinksSection"],
Cell[32733, 1200, 392, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[33140, 1216, 27, 0, 70, "History"],
Cell[33170, 1218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

