(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45726,       1633]
NotebookOptionsPosition[     37272,       1339]
NotebookOutlinePosition[     38677,       1378]
CellTagsIndexPosition[     38591,       1373]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinearSolveFunction" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolveFunction"], 
          "CholeskyDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CholeskyDecomposition"], 
          "QRDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/QRDecomposition"], 
          "SchurDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SchurDecomposition"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"LinearSolveFunction\"\>", 
       2->"\<\"CholeskyDecomposition\"\>", 3->"\<\"QRDecomposition\"\>", 
       4->"\<\"SchurDecomposition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Decompositions" :> 
          Documentation`HelpLookup["paclet:guide/MatrixDecompositions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"Matrix Decompositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LUDecomposition", "ObjectName",
 CellID->26292],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LUDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LUDecomposition"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a representation of the LU decomposition of a \
square matrix\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LUDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LUDecomposition"]], "InlineFormula"],
 " returns a list of three elements. The first element is a combination of \
upper\[Hyphen] and lower\[Hyphen]triangular matrices, the second element is a \
vector specifying rows used for pivoting, and for approximate numerical \
matrices ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " the third element is an estimate of the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["L", "TB"], 
   StyleBox["\[Infinity]", "TR"]]], "InlineFormula"],
 " condition number of ",
 Cell[BoxData[
  FormBox["m", Cell$$38228`TraditonalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->17253]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166447059],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->703761533],

Cell["Compute the LU decomposition of a matrix:", "ExampleText",
 CellID->8764851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"lu", ",", "p", ",", "c"}], "}"}], "=", 
  RowBox[{"LUDecomposition", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49955980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264269059]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["l", "TI"]], "InlineFormula"],
 " is in the strictly lower\[Hyphen]triangular part of ",
 Cell[BoxData[
  StyleBox["lu", "TI"]], "InlineFormula"],
 " with ones assumed along the diagonal:"
}], "ExampleText",
 CellID->127389212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{
   RowBox[{"lu", " ", 
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "<", "i"}]}], "\[Rule]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "+", 
   RowBox[{"IdentityMatrix", "[", "2", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12229262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47008550]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " is in the upper\[Hyphen]triangular part of ",
 Cell[BoxData[
  StyleBox["lu", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->118441480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"lu", " ", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{"j", "\[GreaterEqual]", "i"}]}], "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4069258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->300879587]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["l", "TI"], ".", 
   StyleBox["u", "TI"], " "}]], "InlineFormula"],
 "reconstructs the original matrix:"
}], "ExampleText",
 CellID->182088289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", ".", "u"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->279900643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->213492966]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14018],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]3 matrix:"
}], "ExampleText",
 CellID->260497107],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "8", ",", "27"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212040566],

Cell["Compute using exact arithmetic:", "ExampleText",
 CellID->407053303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LUDecomposition", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->174782924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->319756740]
}, Open  ]],

Cell["Compute using machine arithmetic:", "ExampleText",
 CellID->132496989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LUDecomposition", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->118162454],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "2.`", ",", "3.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "6.`", ",", "24.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.3333333333333333`", ",", 
       RowBox[{"-", "1.9999999999999996`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", "216.`"}], "}"}]], "Output",\

 ImageSize->{454, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->473689072]
}, Open  ]],

Cell["\<\
Compute using 20\[Hyphen]digit precision arithmetic:\
\>", "ExampleText",
 CellID->379692324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LUDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13566277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`20.", ",", "2.`20.", ",", "3.`20."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`20.", ",", "6.`20.", ",", "24.`20."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.`20.", ",", "0.33333333333333333333333333333333333334`20.", ",", 
       RowBox[{"-", "2.`20."}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", "216.`20."}], 
  "}"}]], "Output",
 ImageSize->{525, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->153329824]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100285302],

Cell["LU decomposition for a complex matrix:", "ExampleText",
 CellID->591351218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LUDecomposition", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"1", " ", "+", "I"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.4822238215594097`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.8026936346247593`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.10881307410528973`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.6437327013091825`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.47867857339714015`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.7273446953417211`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.9796988181639534`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.13930599128579257`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8330358240658947`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.23780554345776506`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.7568103270363068`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.21500730861855855`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.12352771952501063`"}], "+", 
        RowBox[{"0.08318936513887709`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.20954797161412864`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.20415612353906337`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.32345622783079586`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.18098907332310266`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.785399067238647`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.20569970734767162`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.0002545538258786062`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.32423434620857106`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.13166269422959198`"}], "+", 
        RowBox[{"0.554785099155602`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.4716490247153463`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.1627294700070462`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.10844834910594696`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.4289509729317968`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.07380884680307738`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.05759146836738051`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.11767965124372477`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.5772607834168219`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "1", ",", "3"}], "}"}], ",", 
   "48.25567184441964`"}], "}"}]], "Output",
 ImageSize->{483, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->481273390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314867746],

Cell["Compute a symbolic LU decomposition:", "ExampleText",
 CellID->299130182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LUDecomposition", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], 
       SubscriptBox["a", 
        RowBox[{"1", ",", "2"}]]},
      {
       SubscriptBox["a", 
        RowBox[{"2", ",", "1"}]], 
       SubscriptBox["a", 
        RowBox[{"2", ",", "2"}]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->792695422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], ",", 
       SubscriptBox["a", 
        RowBox[{"1", ",", "2"}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        SubscriptBox["a", 
         RowBox[{"2", ",", "1"}]], 
        SubscriptBox["a", 
         RowBox[{"1", ",", "1"}]]], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SubscriptBox["a", 
            RowBox[{"1", ",", "2"}]], " ", 
           SubscriptBox["a", 
            RowBox[{"2", ",", "1"}]]}], 
          SubscriptBox["a", 
           RowBox[{"1", ",", "1"}]]]}], "+", 
        SubscriptBox["a", 
         RowBox[{"2", ",", "2"}]]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{329, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1904694]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7391],

Cell["\<\
LU decompositions are mainly used to solve linear systems. Here is a \
5\[Times]5 random matrix:\
\>", "ExampleText",
 CellID->118198918],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315831543],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " sets up an LU decomposition in a functional form convenient for solving:"
}], "ExampleText",
 CellID->15538179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"luf", "=", 
  RowBox[{"LinearSolve", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->749074839],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266718230]
}, Open  ]],

Cell[TextData[{
 "This solves the system ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], ".", 
    StyleBox["x", "TI"]}], " ", "=", " ", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->196810963],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"1", ",", "5"}], "]"}]}], ";"}], "\n", 
 RowBox[{"x", "=", 
  RowBox[{"luf", "[", "b", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->94088446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.49742792362374993`", ",", "1.0555902425982788`", ",", 
   "0.047544369152991525`", ",", "0.10091977419365838`", ",", 
   "0.5430174163780539`"}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8448597]
}, Open  ]],

Cell[TextData[{
 "Verify that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is indeed the solution:"
}], "ExampleText",
 CellID->329686083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", "x"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->432053418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9999999999999999`", ",", "0.9999999999999999`", ",", "1.`", ",", "1.`", 
   ",", "0.9999999999999999`"}], "}"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->532588844]
}, Open  ]],

Cell[TextData[{
 "This can be done manually with the output of ",
 Cell[BoxData["LUDecompsition"], "InlineFormula"],
 " as well:"
}], "ExampleText",
 CellID->187268385],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lu", ",", "p", ",", "c"}], "}"}], "=", 
   RowBox[{"LUDecomposition", "[", "m", "]"}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->26812346],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["l", "TI"]], "InlineFormula"],
 " is in the strictly lower\[Hyphen]triangular part of ",
 Cell[BoxData[
  StyleBox["lu", "TI"]], "InlineFormula"],
 " with ones assumed along the diagonal:"
}], "ExampleText",
 CellID->6800148],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{
    RowBox[{"lu", " ", 
     RowBox[{"SparseArray", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
         RowBox[{"j", "<", "i"}]}], "\[Rule]", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], "+", 
    RowBox[{"IdentityMatrix", "[", "5", "]"}]}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "l", "]"}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->342915327],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "0"},
     {"0.023874566431538128`", "1", "0", "0", "0"},
     {"0.9391019214418829`", "0.3454386426367839`", "1", "0", "0"},
     {"0.2982075488261812`", "0.5882902089441774`", 
      RowBox[{"-", "0.6718968293035787`"}], "1", "0"},
     {"0.9227393636191618`", 
      RowBox[{"-", "0.3058983596600342`"}], 
      RowBox[{"-", "0.14060518278636125`"}], "0.719867693081173`", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{310, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->263461771]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " is in the upper\[Hyphen]triangular part of ",
 Cell[BoxData[
  StyleBox["lu", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->501376675],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"lu", " ", 
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[GreaterEqual]", "i"}]}], "\[Rule]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "u", "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->263901755],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.6123821164163943`", "0.37763744824027023`", "0.47782129514964633`", 
      "0.6536944992280151`", "0.38316490445712237`"},
     {"0", "0.794032897149774`", "0.5440153914319193`", 
      "0.11841602323946432`", "0.18440783866868726`"},
     {"0", "0", 
      RowBox[{"-", "0.6064006955462646`"}], 
      RowBox[{"-", "0.6455632783224049`"}], 
      RowBox[{"-", "0.3357393740210895`"}]},
     {"0", "0", "0", 
      RowBox[{"-", "0.2547568904096123`"}], 
      RowBox[{"-", "0.059635680201895636`"}]},
     {"0", "0", "0", "0", "0.697633165183411`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{367, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->43944197]
}, Open  ]],

Cell["Solve the system with two backsolves:", "ExampleText",
 CellID->499455332],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"l", ",", 
     RowBox[{"b", "[", 
      RowBox[{"[", "p", "]"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"u", ",", "y"}], "]"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->891034923],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.49742792362374993`", ",", "1.0555902425982788`", ",", 
   "0.047544369152991525`", ",", "0.10091977419365838`", ",", 
   "0.5430174163780539`"}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->100978920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->736026012],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a random 100\[Times]100 matrix:"
}], "ExampleText",
 CellID->45706210],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356456692],

Cell[TextData[{
 "Compute the LU decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->84317638],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lu", ",", "p", ",", "c"}], "}"}], "=", 
   RowBox[{"LUDecomposition", "[", "m", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->333376611],

Cell[TextData[{
 "The determinant of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is given by the product of the diagonal elements of ",
 Cell[BoxData[
  StyleBox["l", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->820058790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"lu", ",", "Times"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->803146469],

Cell[BoxData["9.261559717575754`*^24"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127369490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->109038411],

Cell[BoxData["9.261559717575641`*^24"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->255354490]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10202],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 6\[Times]6 random matrix:"
}], "ExampleText",
 CellID->697763639],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->158970283],

Cell[TextData[{
 "Compute the LU decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25812601],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lu", ",", "p", ",", "c"}], "}"}], "=", 
   RowBox[{"LUDecomposition", "[", "m", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282690832],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["l", "TI"]], "InlineFormula"],
 " is in the strictly lower\[Hyphen]triangular part of ",
 Cell[BoxData[
  StyleBox["lu", "TI"]], "InlineFormula"],
 " with ones assumed along the diagonal:"
}], "ExampleText",
 CellID->356403522],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"l", "=", 
   RowBox[{
    RowBox[{"lu", " ", 
     RowBox[{"SparseArray", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
         RowBox[{"j", "<", "i"}]}], "\[Rule]", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "6"}], "}"}]}], "]"}]}], "+", 
    RowBox[{"IdentityMatrix", "[", "6", "]"}]}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "l", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->173958753],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "0", "0"},
     {"0.48177719107409966`", "1", "0", "0", "0", "0"},
     {"0.6110453115802282`", "0.8542685226236053`", "1", "0", "0", "0"},
     {"0.22862536112094872`", "0.30708927609554854`", 
      RowBox[{"-", "0.33768630064130956`"}], "1", "0", "0"},
     {"0.43857895916281386`", "0.04269094266474335`", "0.19395155129474329`", 
      "0.5502470580548426`", "1", "0"},
     {"0.20922318240368432`", "0.4191024046803708`", "0.4802359918606473`", 
      RowBox[{"-", "0.13823250180893584`"}], 
      RowBox[{"-", "0.9921664505373525`"}], "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{382, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->122440334]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " is in the upper\[Hyphen]triangular part of ",
 Cell[BoxData[
  StyleBox["lu", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->319726754],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"lu", " ", 
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[GreaterEqual]", "i"}]}], "\[Rule]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "6"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "u", "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->60885097],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.8255758990089519`", "0.389825078474348`", "0.45417322801441795`", 
      "0.5005361709537928`", "0.8771183677298848`", "0.4520307390285492`"},
     {"0", "0.7761260755428852`", "0.46635030053765314`", 
      RowBox[{"-", "0.1521307839363306`"}], "0.4941188488089516`", 
      "0.7154149600184625`"},
     {"0", "0", 
      RowBox[{"-", "0.49471357590969`"}], "0.3839142775299776`", 
      RowBox[{"-", "0.04957328043878032`"}], 
      RowBox[{"-", "0.5094097925540592`"}]},
     {"0", "0", "0", "0.8806144307844957`", 
      RowBox[{"-", "0.07123790196607824`"}], "0.028597630828353697`"},
     {"0", "0", "0", "0", "0.356812135891895`", "0.5563338276606841`"},
     {"0", "0", "0", "0", "0", "1.349939760248312`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{438, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->10800035]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["l", "TI"], ".", 
   StyleBox["u", "TI"]}]], "InlineFormula"],
 " is equal to a permutation of the rows of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->758741699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"l", ".", "u"}], "-", 
    RowBox[{"m", "[", 
     RowBox[{"[", "p", "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->79268193],

Cell[BoxData["1.1102230246251565`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->256446453]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20649],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolveFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolveFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CholeskyDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CholeskyDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QRDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QRDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SchurDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SchurDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13186]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20024],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "Tutorials",
 CellID->26154]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->29510],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#5783"], None}]], "RelatedLinks",
 CellID->4745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->103859805],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->444945007],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->39320966],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "MoreAbout",
 CellID->171269080]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LUDecomposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 17.5872188}", "context" -> "System`", 
    "keywords" -> {
     "condition number of matrices", "Gaussian elimination", "LINPACK", 
      "repeated solution of linear systems", "row elimination", 
      "triangular matrices"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LUDecomposition[m] generates a representation of the LU decomposition of \
a square matrix m. ", "synonyms" -> {}, "title" -> "LUDecomposition", "type" -> 
    "Symbol", "uri" -> "ref/LUDecomposition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5123, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->166447059]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38448, 1366}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2521, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3144, 86, 53, 1, 70, "ObjectName",
 CellID->26292],
Cell[3200, 89, 622, 19, 70, "Usage",
 CellID->26439]
}, Open  ]],
Cell[CellGroupData[{
Cell[3859, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4337, 130, 749, 21, 70, "Notes",
 CellID->17253]
}, Closed]],
Cell[CellGroupData[{
Cell[5123, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166447059],
Cell[CellGroupData[{
Cell[5508, 170, 148, 5, 70, "ExampleSection",
 CellID->703761533],
Cell[5659, 177, 82, 1, 70, "ExampleText",
 CellID->8764851],
Cell[CellGroupData[{
Cell[5766, 182, 346, 12, 28, "Input",
 CellID->49955980],
Cell[6115, 196, 441, 16, 36, "Output",
 CellID->264269059]
}, Open  ]],
Cell[6571, 215, 269, 8, 70, "ExampleText",
 CellID->127389212],
Cell[CellGroupData[{
Cell[6865, 227, 454, 15, 28, "Input",
 CellID->12229262],
Cell[7322, 244, 301, 11, 36, "Output",
 CellID->47008550]
}, Open  ]],
Cell[7638, 258, 223, 8, 70, "ExampleText",
 CellID->118441480],
Cell[CellGroupData[{
Cell[7886, 270, 392, 13, 70, "Input",
 CellID->4069258],
Cell[8281, 285, 323, 12, 36, "Output",
 CellID->300879587]
}, Open  ]],
Cell[8619, 300, 197, 7, 70, "ExampleText",
 CellID->182088289],
Cell[CellGroupData[{
Cell[8841, 311, 92, 3, 70, "Input",
 CellID->279900643],
Cell[8936, 316, 302, 11, 36, "Output",
 CellID->213492966]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9287, 333, 216, 7, 70, "ExampleSection",
 CellID->14018],
Cell[9506, 342, 139, 5, 70, "ExampleText",
 CellID->260497107],
Cell[9648, 349, 359, 12, 70, "Input",
 CellID->212040566],
Cell[10010, 363, 74, 1, 70, "ExampleText",
 CellID->407053303],
Cell[CellGroupData[{
Cell[10109, 368, 111, 3, 70, "Input",
 CellID->174782924],
Cell[10223, 373, 521, 17, 36, "Output",
 CellID->319756740]
}, Open  ]],
Cell[10759, 393, 76, 1, 70, "ExampleText",
 CellID->132496989],
Cell[CellGroupData[{
Cell[10860, 398, 139, 4, 70, "Input",
 CellID->118162454],
Cell[11002, 404, 601, 19, 36, "Output",
 CellID->473689072]
}, Open  ]],
Cell[11618, 426, 103, 3, 70, "ExampleText",
 CellID->379692324],
Cell[CellGroupData[{
Cell[11746, 433, 163, 5, 70, "Input",
 CellID->13566277],
Cell[11912, 440, 645, 20, 88, "Output",
 CellID->153329824]
}, Open  ]],
Cell[12572, 463, 125, 3, 70, "ExampleDelimiter",
 CellID->100285302],
Cell[12700, 468, 81, 1, 70, "ExampleText",
 CellID->591351218],
Cell[CellGroupData[{
Cell[12806, 473, 257, 8, 70, "Input",
 CellID->25660],
Cell[13066, 483, 2730, 58, 122, "Output",
 CellID->481273390]
}, Open  ]],
Cell[15811, 544, 125, 3, 70, "ExampleDelimiter",
 CellID->314867746],
Cell[15939, 549, 79, 1, 70, "ExampleText",
 CellID->299130182],
Cell[CellGroupData[{
Cell[16043, 554, 907, 28, 70, "Input",
 CellID->792695422],
Cell[16953, 584, 1029, 36, 52, "Output",
 CellID->1904694]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18031, 626, 222, 7, 70, "ExampleSection",
 CellID->7391],
Cell[18256, 635, 147, 4, 70, "ExampleText",
 CellID->118198918],
Cell[18406, 641, 226, 8, 70, "Input",
 CellID->315831543],
Cell[18635, 651, 306, 9, 70, "ExampleText",
 CellID->15538179],
Cell[CellGroupData[{
Cell[18966, 664, 132, 4, 70, "Input",
 CellID->749074839],
Cell[19101, 670, 327, 12, 36, "Output",
 CellID->266718230]
}, Open  ]],
Cell[19443, 685, 311, 13, 70, "ExampleText",
 CellID->196810963],
Cell[CellGroupData[{
Cell[19779, 702, 240, 8, 70, "Input",
 CellID->94088446],
Cell[20022, 712, 337, 10, 36, "Output",
 CellID->8448597]
}, Open  ]],
Cell[20374, 725, 156, 6, 70, "ExampleText",
 CellID->329686083],
Cell[CellGroupData[{
Cell[20555, 735, 92, 3, 70, "Input",
 CellID->432053418],
Cell[20650, 740, 299, 9, 36, "Output",
 CellID->532588844]
}, Open  ]],
Cell[20964, 752, 168, 5, 70, "ExampleText",
 CellID->187268385],
Cell[21135, 759, 212, 7, 70, "Input",
 CellID->26812346],
Cell[21350, 768, 267, 8, 70, "ExampleText",
 CellID->6800148],
Cell[CellGroupData[{
Cell[21642, 780, 534, 17, 70, "Input",
 CellID->342915327],
Cell[22179, 799, 1100, 28, 108, "Output",
 CellID->263461771]
}, Open  ]],
Cell[23294, 830, 223, 8, 70, "ExampleText",
 CellID->501376675],
Cell[CellGroupData[{
Cell[23542, 842, 471, 15, 70, "Input",
 CellID->263901755],
Cell[24016, 859, 1250, 32, 108, "Output",
 CellID->43944197]
}, Open  ]],
Cell[25281, 894, 80, 1, 70, "ExampleText",
 CellID->499455332],
Cell[CellGroupData[{
Cell[25386, 899, 305, 10, 70, "Input",
 CellID->891034923],
Cell[25694, 911, 339, 10, 36, "Output",
 CellID->100978920]
}, Open  ]],
Cell[26048, 924, 125, 3, 70, "ExampleDelimiter",
 CellID->736026012],
Cell[26176, 929, 149, 5, 70, "ExampleText",
 CellID->45706210],
Cell[26328, 936, 230, 8, 70, "Input",
 CellID->356456692],
Cell[26561, 946, 152, 6, 70, "ExampleText",
 CellID->84317638],
Cell[26716, 954, 213, 7, 70, "Input",
 CellID->333376611],
Cell[26932, 963, 255, 9, 70, "ExampleText",
 CellID->820058790],
Cell[CellGroupData[{
Cell[27212, 976, 126, 4, 70, "Input",
 CellID->803146469],
Cell[27341, 982, 179, 5, 36, "Output",
 CellID->127369490]
}, Open  ]],
Cell[CellGroupData[{
Cell[27557, 992, 99, 3, 70, "Input",
 CellID->109038411],
Cell[27659, 997, 179, 5, 36, "Output",
 CellID->255354490]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27887, 1008, 233, 7, 70, "ExampleSection",
 CellID->10202],
Cell[28123, 1017, 146, 5, 70, "ExampleText",
 CellID->697763639],
Cell[28272, 1024, 226, 8, 70, "Input",
 CellID->158970283],
Cell[28501, 1034, 152, 6, 70, "ExampleText",
 CellID->25812601],
Cell[28656, 1042, 213, 7, 70, "Input",
 CellID->282690832],
Cell[28872, 1051, 269, 8, 70, "ExampleText",
 CellID->356403522],
Cell[CellGroupData[{
Cell[29166, 1063, 534, 17, 70, "Input",
 CellID->173958753],
Cell[29703, 1082, 1266, 30, 122, "Output",
 CellID->122440334]
}, Open  ]],
Cell[30984, 1115, 223, 8, 70, "ExampleText",
 CellID->319726754],
Cell[CellGroupData[{
Cell[31232, 1127, 470, 15, 70, "Input",
 CellID->60885097],
Cell[31705, 1144, 1416, 33, 122, "Output",
 CellID->10800035]
}, Open  ]],
Cell[33136, 1180, 264, 10, 70, "ExampleText",
 CellID->758741699],
Cell[CellGroupData[{
Cell[33425, 1194, 233, 8, 70, "Input",
 CellID->79268193],
Cell[33661, 1204, 181, 5, 36, "Output",
 CellID->256446453]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33903, 1216, 311, 9, 70, "SeeAlsoSection",
 CellID->20649],
Cell[34217, 1227, 1023, 35, 70, "SeeAlso",
 CellID->13186]
}, Open  ]],
Cell[CellGroupData[{
Cell[35277, 1267, 314, 9, 70, "TutorialsSection",
 CellID->20024],
Cell[35594, 1278, 161, 3, 70, "Tutorials",
 CellID->26154]
}, Open  ]],
Cell[CellGroupData[{
Cell[35792, 1286, 321, 9, 70, "RelatedLinksSection",
 CellID->29510],
Cell[36116, 1297, 265, 6, 70, "RelatedLinks",
 CellID->4745]
}, Open  ]],
Cell[CellGroupData[{
Cell[36418, 1308, 319, 9, 70, "MoreAboutSection",
 CellID->103859805],
Cell[36740, 1319, 139, 3, 70, "MoreAbout",
 CellID->444945007],
Cell[36882, 1324, 162, 3, 70, "MoreAbout",
 CellID->39320966],
Cell[37047, 1329, 153, 3, 70, "MoreAbout",
 CellID->171269080]
}, Open  ]],
Cell[37215, 1335, 27, 0, 70, "History"],
Cell[37245, 1337, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

