(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     72438,       2427]
NotebookOptionsPosition[     64553,       2152]
NotebookOutlinePosition[     65882,       2189]
CellTagsIndexPosition[     65796,       2184]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrameLabel" :> 
          Documentation`HelpLookup["paclet:ref/FrameLabel"], "Underscript" :> 
          Documentation`HelpLookup["paclet:ref/Underscript"], "PlotLabel" :> 
          Documentation`HelpLookup["paclet:ref/PlotLabel"], "Column" :> 
          Documentation`HelpLookup["paclet:ref/Column"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"], "Framed" :> 
          Documentation`HelpLookup["paclet:ref/Framed"], "Tooltip" :> 
          Documentation`HelpLookup["paclet:ref/Tooltip"], "ControlPlacement" :> 
          Documentation`HelpLookup["paclet:ref/ControlPlacement"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FrameLabel\"\>", 
       2->"\<\"Underscript\"\>", 3->"\<\"PlotLabel\"\>", 4->"\<\"Column\"\>", 
       5->"\<\"Panel\"\>", 6->"\<\"Framed\"\>", 7->"\<\"Tooltip\"\>", 
       8->"\<\"ControlPlacement\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>", 
       3->"\<\"Mathematical Typesetting\"\>", 
       4->"\<\"Notebook Formatting & Styling\"\>", 5->"\<\"Palettes\"\>", 
       6->"\<\"Stand-Alone Interfaces\"\>", 
       7->"\<\"User Interface Structuring & Layout\"\>", 
       8->"\<\"Viewers and Annotation\"\>", 
       9->"\<\"New in 6.0: Formatting & Styling\"\>", 
       10->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Labeled", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Labeled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Labeled"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["lbl", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " labeled with ",
     Cell[BoxData[
      StyleBox["lbl", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Labeled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Labeled"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["lbl", "TI"], ",", 
        StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]places ",
     Cell[BoxData[
      StyleBox["lbl", "TI"]], "InlineFormula"],
     " at a position specified by ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Labeled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Labeled"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["lbl", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["lbl", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["pos", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]places the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->13858]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Labeled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Labeled"]], "InlineFormula"],
 " can be used with graphics or any other expression. "
}], "Notes",
 CellID->2851],

Cell[TextData[{
 "Possible forms for the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pos", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->18703],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["side", "TI"], Cell[
    "centered on the specified side ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["side", "TI"], ",", 
      StyleBox["align", "TI"]}], "}"}], Cell[
    "on the specified side with the specified alignment ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->12914],

Cell[TextData[{
 "Possible forms for ",
 Cell[BoxData[
  StyleBox["side", "TI"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16134],

Cell[TextData[{
 "Possible forms for ",
 Cell[BoxData[
  StyleBox["align", "TI"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26758],

Cell[TextData[{
 "The effective default for ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 " is normally ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10394],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Labeled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Labeled"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " does not affect linewrapping of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31973]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134759762],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->369143543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "lbl"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241035251],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVM0OgjAMHgw0agA1HkwU5aKPohd8CEJM9GA06vvP/RQkXdEZPbhk7b6P
9Wfdyq64H/an4n4si2x7LS6HY3nLNuerpLjHGMvlnE2ZXAu50jMXQmoj51KG
kmRcQz04QMWnml4oqWihB/OVCGsMpgHa9X+2voQ+5dMtcmCwqVLobtfAHdIq
hdw46C7oZeOmXktcgx7CyYfYPAeO2D7kNUR6RJ3asq7eFOZD4HFFVRV4C0/5
oaO2v5mq0r//ameF3wEnbaN2Ft+VtQtXyWu9g+DLSPQJ3eoeCboLB075+M7R
FVYwFrhvE6hADJlUf776Vt76niC8oqwsLzjvMcRfi2fv2x1oupt5D2vuA/4=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{76, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12025974]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], ",", "lbl"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->133959630],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVUtvwjAMTpsGyhAwEIceGa+fwk4cuHCv0CQ4IBDw/4OduIBMgjwY0irF
yefEj35O3Xl5Wv9sy9NmVQ6+D+V+vVkdB7PdAVQ6UUotYUwKBWsLKzeW1sLs
5RdIA0qlHXSPJoj6oVOPUKLaukelKMwFk2nGTv0/2xRgGvIpi5x57Fkycrsb
XAtaDSk3TXOd5vFNpR5LpfM8p/otYCQAE9q5RluAwEvx7h3+lg2GO7/EtWgk
XoUPYu6TzV12zog9Vl+CDngwgXuAtdMRfcyPLJP47a/uzN/vyjLlJ3XQXyuu
5bW/O8W5yMSsYS7Zi9HlTMhq1rLhXtQU5Zi+lBHygbBteUfrEFNtyq76J1RW
z8XrMzwJMSTyzLtKj/Kc2mv3lHWN9/bBoig8ob4TA/Q71KmTM35LyHw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{86, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->193598123]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->504295994],

Cell["Label on the left:", "ExampleText",
 CellID->742082015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], ",", "lbl", 
   ",", "Left"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360213713],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVdsOgjAMLQwUNV5jIi8mvuin6JMPfgIxJvhgNOL/Y0uHl8IywaBL1u6s
W3fa3bbRLT6cottxHy021+gSH/fJYn2+YpdyACDBOgsB2ym2spqkKWqWc5Iq
CALgssPqIHRerDQnK7BDQU5/bW0J3BF4WBG33lYDxYqKgiIm6KOWq/oCd1G4
CEdCj0vmPVdXwupmQx5YU/EsGZBccs7Su6/75fg2CmXoN/lpOgazF8pquxFr
0zFKuyr10jf3ylNdGCWz6FmjoIy4ZdFVPG/el8xr5N9jzHdVcqp3vvqGjPQ+
isytF0eFt64s8wQHhXwM9Z4MdET5u5bPMnPMT4VKn/eFdM/CZSrw0hLr+6q2
V3+iWaxe2Jlf9f/+XWEY8ibwj4qQrfzrgnMHz9jYYA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{115, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472588700]
}, Open  ]],

Cell["Label on the left and top:", "ExampleText",
 CellID->4771058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Left", ",", "Top"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->242885152],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Vc1OwzAMTpNuK5u2AeLQ4y5DjAfg5wXgxGGPUE2VtgMCjb1/cWLTla9p
UgQsUpx89mfHdX76Uhy25Wtx2G2KxfO+eN/uNh+Lp7c9qUyilCqpL3NF84pm
rpdVRePcSpNlmeK2pp4QTBpWy3ZNrUnYcKe2DgGfAUZ+DA+Dqw0Aj0logucw
Xnj8jlEtQwsT88UVDIkBQePhWT3yRyRMh74rzjEzdquN1MaR/LRT1li8Uvm6
0b9YA5UV3wmw0Mt4Y0+7tXhiWiysS9orL99up7/MJFyhv9rhqXyRBvakV+Y6
vpM/vCMWzlzhWc9v1lzqOZNIvPFMCN+E2M2/Arz0Va13dHzFLiXfaxkx1/Ar
ddq3OM9zLjb/IQiytewh72V/bh16hNVWEa2uPR8aHPVdmzYP+6petX1G2XZX
8Vni4/nVblqZq+QTRUyg4A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{101, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->381243455]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->748],

Cell["Label a graphic:", "ExampleText",
 CellID->254295732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}], ",", 
   RowBox[{"Text", "[", "\"\<a circle\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1045575996],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     TagBox[
      InterpretationBox[
       GraphicsBox[CircleBox[{0, 0}]],
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"]},
    {
     InterpretationBox[
      InterpretationBox[Cell[BoxData["\<\"a circle\"\>"], "Text", "TR"],
       Text["a circle"]],
      "Labeled",
      Editable->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Graphics[
    Circle[{0, 0}]], 
   Text["a circle"]]]], "Output",
 ImageSize->{104, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->45062993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->409376469],

Cell["Label a slider:", "ExampleText",
 CellID->356736550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Slider", "[", "]"}], ",", "\"\<slider\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431049142],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     TagBox[
      InterpretationBox[
       SliderBox[0.5],
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"]},
    {
     InterpretationBox["\<\"slider\"\>",
      "Labeled",
      Editable->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Slider[], "slider"]]], "Output",
 ImageSize->{204, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296547651]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Slider", "[", "]"}], ",", "\"\<slider\>\"", ",", "Left"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->335635315],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     InterpretationBox["\<\"slider\"\>",
      "Labeled",
      Editable->True], 
     TagBox[
      InterpretationBox[
       SliderBox[0.5],
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Slider[], "slider", Left]]], "Output",
 ImageSize->{254, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5850563]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->379364954],

Cell["Use a checkbox as a label:", "ExampleText",
 CellID->72274661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], ",", 
   RowBox[{"Checkbox", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->754553265],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     TagBox[
      InterpretationBox[
       FrameBox[
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}],
        StripOnInput->False],
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"]},
    {
     InterpretationBox[
      CheckboxBox[False],
      "Labeled",
      Editable->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Framed[{$CellContext`a, $CellContext`b, $CellContext`c}], 
   Checkbox[]]]], "Output",
 ImageSize->{72, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88140752]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163404798],

Cell["Control the placement of labels:", "ExampleText",
 CellID->845568080],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112509734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{"g", ",", "lbl"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79178672],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     TagBox[
      InterpretationBox[
       GraphicsBox[CircleBox[{0, 0}],
        ImageSize->50],
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"]},
    {
     InterpretationBox["lbl",
      "Labeled",
      Editable->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Graphics[
    Circle[{0, 0}], ImageSize -> 50], $CellContext`lab]]], "Output",
 ImageSize->{54, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->402403891]
}, Open  ]],

Cell["Put the label at the bottom, aligned left:", "ExampleText",
 CellID->167713148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{"g", ",", "lbl", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Bottom", ",", "Left"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->235570020],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     TagBox[
      InterpretationBox[
       GraphicsBox[CircleBox[{0, 0}],
        ImageSize->50],
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"]},
    {
     ItemBox[
      InterpretationBox["lbl",
       "Labeled",
       Editable->True],
      Alignment->{Left, Inherited}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Graphics[
    Circle[{0, 0}], ImageSize -> 50], $CellContext`lab, {{
    Bottom, Left}}]]], "Output",
 ImageSize->{54, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->68851682]
}, Open  ]],

Cell["Put the label on the right, aligned at the top:", "ExampleText",
 CellID->671666783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{"g", ",", "lbl", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Right", ",", "Top"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5443000],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     TagBox[
      InterpretationBox[
       GraphicsBox[CircleBox[{0, 0}],
        ImageSize->50],
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"], 
     ItemBox[
      InterpretationBox["lbl",
       "Labeled",
       Editable->True],
      Alignment->{Inherited, Top}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Graphics[
    Circle[{0, 0}], ImageSize -> 50], $CellContext`lab, {{
    Right, Top}}]]], "Output",
 ImageSize->{83, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->679786054]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216957608],

Cell["Use graphics as labels:", "ExampleText",
 CellID->306643684],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->737661272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "d", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Top", ",", "Bottom", ",", "Left"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->724291948],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"", 
     InterpretationBox[
      GraphicsBox[CircleBox[{0, 0}],
       ImageSize->20],
      "Labeled",
      Editable->True]},
    {
     InterpretationBox[
      GraphicsBox[CircleBox[{0, 0}],
       ImageSize->20],
      "Labeled",
      Editable->True], 
     TagBox[
      InterpretationBox["265252859812191058636308480000000",
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"]},
    {"", 
     InterpretationBox[
      GraphicsBox[CircleBox[{0, 0}],
       ImageSize->20],
      "Labeled",
      Editable->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[265252859812191058636308480000000, {
    Graphics[
     Circle[{0, 0}], ImageSize -> 20], 
    Graphics[
     Circle[{0, 0}], ImageSize -> 20], 
    Graphics[
     Circle[{0, 0}], ImageSize -> 20]}, {Top, Bottom, Left}]]], "Output",
 ImageSize->{285, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62049603]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25772],

Cell["\<\
Label images with checkboxes, potentially for later processing:\
\>", "ExampleText",
 CellID->21244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{
     RowBox[{"ArrayPlot", "[", 
      RowBox[{
       RowBox[{"CellularAutomaton", "[", 
        RowBox[{"i", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"30", ",", "All"}], "}"}]}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "]"}], ",", 
     RowBox[{"Checkbox", "[", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "20", ",", "23"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31619],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[GridBox[{
      {
       TagBox[
        InterpretationBox[
         GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQB2JbIGakAFCgmSKLR+0dtXfU3lF7R+0dtXcI2AsArDAJ
Og==
           "], {{0, 0}, {61, 31}}, {0, 1}],
          Frame->Automatic,
          FrameTicks->{None, None},
          ImageSize->Small],
         "Labeled",
         Editable->True],
        "SkipImageSizeLevel"]},
      {
       InterpretationBox[
        CheckboxBox[False],
        "Labeled",
        Editable->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}}],
    Labeled[
     Graphics[
      Raster[CompressedData["
1:eJxTTMoPSmJiYGCQB2JbIGakAFCgmSKLR+0dtXfU3lF7R+0dtXcI2AsArDAJ
Og==
       "], {{0, 0}, {61, 31}}, {0, 1}], Frame -> Automatic, 
      FrameTicks -> {None, None}, ImageSize -> Small], 
     Checkbox[]]], ",", 
   InterpretationBox[GridBox[{
      {
       TagBox[
        InterpretationBox[
         GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQB2JbIGakBDBQAkZtHrV51OZRm0dtHrV5oG0m5C4CRuOX
BgAd3QXV
           "], {{0, 0}, {61, 31}}, {0, 1}],
          Frame->Automatic,
          FrameTicks->{None, None},
          ImageSize->Small],
         "Labeled",
         Editable->True],
        "SkipImageSizeLevel"]},
      {
       InterpretationBox[
        CheckboxBox[False],
        "Labeled",
        Editable->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}}],
    Labeled[
     Graphics[
      Raster[CompressedData["
1:eJxTTMoPSmJiYGCQB2JbIGakBDBQAkZtHrV51OZRm0dtHrV5oG0m5C4CRuOX
BgAd3QXV
       "], {{0, 0}, {61, 31}}, {0, 1}], Frame -> Automatic, 
      FrameTicks -> {None, None}, ImageSize -> Small], 
     Checkbox[]]], ",", 
   InterpretationBox[GridBox[{
      {
       TagBox[
        InterpretationBox[
         GraphicsBox[RasterBox[CompressedData["
1:eJydk9EJgDAMRBsXEQdxCUfoAu7/Z0UKMW3vkgghHkfyCEePel91K6Xsrc5W
RUTy9c1Lsn//2f7u6PviWvPjWu+N678X1f0Oe5/PtxkO09C3OcZ8m2PMX93r
81f3+nzE5T6eZb7Nk+U/7kZFpsk75mzUORu9Z85G75mzkeZspDnbn++M7c93
xtY9ztY9zs5xOzM7m71Xs8H3AFJ6CFQ=
           "], {{0, 0}, {61, 31}}, {0, 1}],
          Frame->Automatic,
          FrameTicks->{None, None},
          ImageSize->Small],
         "Labeled",
         Editable->True],
        "SkipImageSizeLevel"]},
      {
       InterpretationBox[
        CheckboxBox[False],
        "Labeled",
        Editable->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}}],
    Labeled[
     Graphics[
      Raster[CompressedData["
1:eJydk9EJgDAMRBsXEQdxCUfoAu7/Z0UKMW3vkgghHkfyCEePel91K6Xsrc5W
RUTy9c1Lsn//2f7u6PviWvPjWu+N678X1f0Oe5/PtxkO09C3OcZ8m2PMX93r
81f3+nzE5T6eZb7Nk+U/7kZFpsk75mzUORu9Z85G75mzkeZspDnbn++M7c93
xtY9ztY9zs5xOzM7m71Xs8H3AFJ6CFQ=
       "], {{0, 0}, {61, 31}}, {0, 1}], Frame -> Automatic, 
      FrameTicks -> {None, None}, ImageSize -> Small], 
     Checkbox[]]], ",", 
   InterpretationBox[GridBox[{
      {
       TagBox[
        InterpretationBox[
         GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQB2JbIGakBDBQAkZtHrV51OZRm0dtHrV5aNtMQBoAHYAF
1A==
           "], {{0, 0}, {61, 31}}, {0, 1}],
          Frame->Automatic,
          FrameTicks->{None, None},
          ImageSize->Small],
         "Labeled",
         Editable->True],
        "SkipImageSizeLevel"]},
      {
       InterpretationBox[
        CheckboxBox[False],
        "Labeled",
        Editable->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}}],
    Labeled[
     Graphics[
      Raster[CompressedData["
1:eJxTTMoPSmJiYGCQB2JbIGakBDBQAkZtHrV51OZRm0dtHrV5aNtMQBoAHYAF
1A==
       "], {{0, 0}, {61, 31}}, {0, 1}], Frame -> Automatic, 
      FrameTicks -> {None, None}, ImageSize -> Small], 
     Checkbox[]]]}], "}"}]], "Output",
 ImageSize->{401, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186458587]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Left"}], "}"}]}], "]"}], "&"}], ",", "x", ",", 
   "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1072438],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWN1rE0EQv+Qu1SR+NgErKKZJPxJ8kDYFQTBNUkzxoR9WVDCIhCK0qG2t
fVKf1MfqY+3fUP0n/Fvsk/4R5+3ebO4yO7N311QwcJnd+drfzM7OXrLU29t4
8bq3t7neKy3u9nY2Ntffljrbux7LTllW6qVlWd0xyxu73kg+4vPKe/yhebTs
PRnP6GqfsyJGGeXHlXzLyno07dE00GyEfk5Qp89VHINFHjznB/TUmpYd+MqS
mmo1y1LejOuH/OVdLrZl4FyTnN+QqxWgVcn9EytfTVJr2uBBz2ArsQ8VWTvC
0pTlNiOfDNaNyHxL0wllzrAPTSSvSasDyH4TaA60F9D8ptT+Fmt3Zkgtuk5r
sM5Zg39972YTrFBlMXPrqczVT3EVU03UGfkSwxeV5gzGEFEzs5rOqsapReXJ
UFszSP4AzUX12P2uceAGNSboGtA7UipsM+AzXJmqT3Sk1hqLNoyrTGrR3UNV
4jgpvWdYVa/PSoJ16cqhkZtQqD2Z+Odrm2p5gpE3GL6q5TIjXwgijqjxiqaj
d0q6xsuaXqjGDFVfRvI2mquqryD+ovQubkFVb+FOO4nmc665M9+X3q6TkeHz
MEpq0f1anQfahu6C82BzSc4dWPUKqaufmkICdHTl0h5orA0WlcCckXMb7Rwd
iaqL4n+A/xxCnGbjMJ3iIiO/xfDVKS4wcu4muwt28VFHdYGCpqPffXQX0C31
O3J+yJybuskoktfRXHWTIuLju7YFeudjocoxFTDG8KsM/zbD7zD8h7HRhW+V
OZd+c3jOewuqA+XbQTa4S4tIxVaPID7u8g3Qu4D4z0hM+AQgjNB5wjHTneIM
ygTdDS4y+Un5ctsn4nsENB+TfvZJ7huPej+apbcUGZ26AZ64/jn/AnSHxIN3
P63l5lECdNtk/s01IfwLk69AMU66SsVXL5am6JMC6BbQn7Gspsj4tkjudzd0
a5+q5yOSW4gdtwN74gzpK2k2HNazqk6BTu22DVa6r8tu+M1AcFdBP/i3x/8n
qAt7sA/0neQ+Jb3Stfv+hBZdd/CcDeMnfA4+oAiD0SHEeAT0huTSv6vpXS+d
0OIQYlR7PIwfEeMPoONsrMcQ40c5+0X6/BQpOwa88TQFos8sIjFqAaqpPqdJ
+pyOLW8BwmQWAmnViNQfWam/8Vc4GQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{363, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549707209]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Left", ",", "Right"}], "}"}]}], "]"}], "&"}], ",",
    "x", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25180389],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWUlPFEEU7lkQGTyxKBpNOIgDbhlAhCgXF2b0wBIFz44DCgk7E44mmngh
8WDixYsH9GD8GyrekV8gZzXqDyi7ul5117x+VV3V4k2Smap6e33vVU+9Zrxa
n59bqtYXatXuynp1dX6httFdXln3SbmM52Wuep73qsvz58yfBR/+N+p/xFQ/
2/W/m3yF2WD1hX83SX0W0DyvxR+z/piFsdUfc/5YNugU+JgPqaAVlxsz2GgF
f0f4OhfZqoQ6MiqV25KoJePyPOnFMVLFqoxRxSYfSu8C9VGwugRYb8G4EVCH
nDBfIqVHgDtssGibkUWSOkxSLxv86bK3rLevSI2Ell1yvKyRH9JaT1cLizHN
kSR8LGpmEcldAbqw0sNE1RRA6zFabwZSZ8g4ZH1Mktw+sNQLUr0GS3QdTJDU
XgdqMcmngsuUqzdFty/0Y1MnUxq5ImRGb92mOiZicn3pECNqZgLRzzGR27PA
F9o9sL/nMD4LqEdZ43PqRUA9RkaBa6eflKoD97jBkku1lEjqBkntSudTwW5A
702ROhH6camYAY38mtZ6+oopxbTrSYgZKqiE+JtAF9rNzPy0ehlIHSb9y2pp
J7kVsFQGqYLBEl0RbSS17ECVT+6mJN8KPh2uXhXdQ2idDf3a1E6HRm4MMmbv
zaZ62mJyFYed5/W+iVprQ/TbTNTELeDT1poBjyeIK28Vr0mtLeC+J7kcS76Z
a4j7jpS+Se79usZDxqDzwx/9FiCQyYSR8L1/d7DyTbunHGFJcPkU/zIncfYB
JfzrJLhfydgm/1p2HxBxsTTO1BO+D0jMhPsbDRHiqj8N2P5K5MmM2UnyOH6j
OKKZRPiuYW/TiTyJmJ0khcx/jFwwOpjZB6b2lR/JiHR95YxBx7ZznDbY0HWD
90Idlz4v0krXvymRWvRl0yG6UZ91H7CehPFpQK06YU7fK2WvVjZYtM0IfRun
e7gxgz9d9gb19mNvXqrMLceDGnnco0XW09VCf0yT7tYUfCxqph/Jyb5MWDnJ
RNWUWOOt+AZai37sFBmPrqroW7OsKvoWirs48R4pD5bp3sm2BunbNl2DdOwu
naF4V5JD6NM70FU1jRGu6k7XWGPvn6goXU6I7l6PT0inRk7Xk+qjS3fC4h0B
fcLaY3Iu3a0h8xbnFXcS8ry2IzrugmmvBU0Gixo67sAkfRbRL2i9cWn5xLwD
4yqMFyOtvIqaigPulAbQmmPOIT+N6CtofT7whSsN+fbEvVqNmc6pfD8ldyL2
L8yJMjkEnDlSf4eMRj7XHkIOd0hUs7GYZw0+zOhyTW76M+mJf9F1VATUt2F8
QErRb023SWrtH1mQz5I3MB6UH5mrIiD4Fkbx/youi2/Ba4DVp2C1asiZibfG
1NpIkoxyS0W015A9+n9dtUTeXgOySZJmjKKZl/kDzzP6BA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{315, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->228627713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114526584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"#", ",", "#", ",", "#", ",", "#"}], "}"}], ",", "All"}], 
     "]"}], "&"}], ",", "x", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->631807701],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw3ADidgkGIPs/kAXG
N/7/B9KYZC+QZAIqYILSrmDRPhDJAtIHBkCGG5jqh6pyx8LDpQe7Dbjcg5+s
QzOLkwDfDKyrHsNl3ESImIOpBqhJvGi0BRGylNhLnk/JC9WhlQYgpDaaifpo
fHUCfAmwKToY7jXEENEkQkQSTOlCzTaG0tpotBQJqqjrMuqEFnL4s0BlTkNp
VrAoM4hkRth/Fo3PNEhUcaHxjdD43USbghyTPbh1IeIELWRZ0PRwoMkTyvds
FOqnNR/df5AwYUITRQsjaHoC6efCkCGmDGWnSDc9RdDjjxEizAyhQCQb1C/C
/7HXNaI4xEmlQSkH1HgAuYARayyx0Mkl7FjDBD33MWGEpSBZMSA8yFIEpggr
Np8TKFf40fiE8qkgieoHptwY+JqD9qqw16yjbZ/B0/YZ3u3r0T7W8O5jMTAC
AEan5Jw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{216, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131221504]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}], ",", "All"}], "]"}], "&"}], ",", "x", 
   ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->354404188],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVk1LAzEQzW5bwS5etYiH4leRHvxExItYRU+KeBdZimAP0lrrST2rf0D9
e+pZqeI9bjaJZWeymzTd2haa6Zskk5c3k6QHfuv87MJv1ap+cb/pN85r1avi
Xr0ZuDIOIYQG3+sCCX5TgSj7cCPbdtC6QZcr7Gjo/WJtVs5gU/Oh+RajPAWK
m6NeATMxaV8VsXDsN8TEi+H2LuaNRXai9ppHNWNpp0AdxDoBuKBcq4GYniLP
ZMxuLkUkX9ipiCrJvb2sa7dTO1XLINaiJoOHBhnWV0BWoHmkwDLy4Fo7Mhhj
4skIFrkQMkQynf6S6F2l0TNxDDC0IyCOO4Dog9U1Z8Rxjv5v5WWNWOUBngG4
AvCtcVTGYVbYHWHv4md3FNXsQ8fwRrmGC7xgTZFFE84O/TtM3BnWKBvJ3kX2
HLMRjnJVeQ+0lTGhii7i+Gmh34dRxn6MRo3T5JorAgxv7i2A1zW5VrOYQLrg
MzmNPPj12UaeDWVV6BnJfcpbS9aQfCNlLW3Sbm61/kQdvHryFPS7mqTl7x21
aisajjq8pOkvGcTjmU7jpVoxGLNgMIb/b9ulyW/3GsBlgL0UowynQsNRPdSq
fQKx4OnTYb72M1IG3yQmHq7nC43egNB6XYxKl1k6atll6r7HKksDE/KAlLE7
gWl5eF4eafLtorNeilGGU6HhqB6KWuL8AvuTDEw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{255, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->806287230]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}], ",", "All"}], "]"}], "&"}], ",", 
   RowBox[{"Checkbox", "[", "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->354606901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[False], ",", 
   InterpretationBox[GridBox[{
      {
       InterpretationBox[
        CheckboxBox[False],
        "Labeled",
        Editable->True], 
       TagBox[
        InterpretationBox[
         CheckboxBox[False],
         "Labeled",
         Editable->True],
        "SkipImageSizeLevel"]},
      {"", 
       InterpretationBox[
        CheckboxBox[False],
        "Labeled",
        Editable->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}}],
    Labeled[
     Checkbox[], {
      Checkbox[], 
      Checkbox[]}, All]], ",", 
   InterpretationBox[GridBox[{
      {
       InterpretationBox[
        InterpretationBox[GridBox[{
           {
            InterpretationBox[
             CheckboxBox[False],
             "Labeled",
             Editable->True], 
            TagBox[
             InterpretationBox[
              CheckboxBox[False],
              "Labeled",
              Editable->True],
             "SkipImageSizeLevel"]},
           {"", 
            InterpretationBox[
             CheckboxBox[False],
             "Labeled",
             Editable->True]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
         Labeled[
          Checkbox[], {
           Checkbox[], 
           Checkbox[]}, All]],
        "Labeled",
        Editable->True], 
       TagBox[
        InterpretationBox[
         InterpretationBox[GridBox[{
            {
             InterpretationBox[
              CheckboxBox[False],
              "Labeled",
              Editable->True], 
             TagBox[
              InterpretationBox[
               CheckboxBox[False],
               "Labeled",
               Editable->True],
              "SkipImageSizeLevel"]},
            {"", 
             InterpretationBox[
              CheckboxBox[False],
              "Labeled",
              Editable->True]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
          Labeled[
           Checkbox[], {
            Checkbox[], 
            Checkbox[]}, All]],
         "Labeled",
         Editable->True],
        "SkipImageSizeLevel"]},
      {"", 
       InterpretationBox[
        InterpretationBox[GridBox[{
           {
            InterpretationBox[
             CheckboxBox[False],
             "Labeled",
             Editable->True], 
            TagBox[
             InterpretationBox[
              CheckboxBox[False],
              "Labeled",
              Editable->True],
             "SkipImageSizeLevel"]},
           {"", 
            InterpretationBox[
             CheckboxBox[False],
             "Labeled",
             Editable->True]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
         Labeled[
          Checkbox[], {
           Checkbox[], 
           Checkbox[]}, All]],
        "Labeled",
        Editable->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}}],
    Labeled[
     Labeled[
      Checkbox[], {
       Checkbox[], 
       Checkbox[]}, All], {
      Labeled[
       Checkbox[], {
        Checkbox[], 
        Checkbox[]}, All], 
      Labeled[
       Checkbox[], {
        Checkbox[], 
        Checkbox[]}, All]}, All]], ",", 
   InterpretationBox[GridBox[{
      {
       InterpretationBox[
        InterpretationBox[GridBox[{
           {
            InterpretationBox[
             InterpretationBox[GridBox[{
                {
                 InterpretationBox[
                  CheckboxBox[False],
                  "Labeled",
                  Editable->True], 
                 TagBox[
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True],
                  "SkipImageSizeLevel"]},
                {"", 
                 InterpretationBox[
                  CheckboxBox[False],
                  "Labeled",
                  Editable->True]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
              Labeled[
               Checkbox[], {
                Checkbox[], 
                Checkbox[]}, All]],
             "Labeled",
             Editable->True], 
            TagBox[
             InterpretationBox[
              InterpretationBox[GridBox[{
                 {
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True], 
                  TagBox[
                   InterpretationBox[
                    CheckboxBox[False],
                    "Labeled",
                    Editable->True],
                   "SkipImageSizeLevel"]},
                 {"", 
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Center}}, "RowsIndexed" -> {}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
               Labeled[
                Checkbox[], {
                 Checkbox[], 
                 Checkbox[]}, All]],
              "Labeled",
              Editable->True],
             "SkipImageSizeLevel"]},
           {"", 
            InterpretationBox[
             InterpretationBox[GridBox[{
                {
                 InterpretationBox[
                  CheckboxBox[False],
                  "Labeled",
                  Editable->True], 
                 TagBox[
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True],
                  "SkipImageSizeLevel"]},
                {"", 
                 InterpretationBox[
                  CheckboxBox[False],
                  "Labeled",
                  Editable->True]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
              Labeled[
               Checkbox[], {
                Checkbox[], 
                Checkbox[]}, All]],
             "Labeled",
             Editable->True]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
         Labeled[
          Labeled[
           Checkbox[], {
            Checkbox[], 
            Checkbox[]}, All], {
           Labeled[
            Checkbox[], {
             Checkbox[], 
             Checkbox[]}, All], 
           Labeled[
            Checkbox[], {
             Checkbox[], 
             Checkbox[]}, All]}, All]],
        "Labeled",
        Editable->True], 
       TagBox[
        InterpretationBox[
         InterpretationBox[GridBox[{
            {
             InterpretationBox[
              InterpretationBox[GridBox[{
                 {
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True], 
                  TagBox[
                   InterpretationBox[
                    CheckboxBox[False],
                    "Labeled",
                    Editable->True],
                   "SkipImageSizeLevel"]},
                 {"", 
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Center}}, "RowsIndexed" -> {}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
               Labeled[
                Checkbox[], {
                 Checkbox[], 
                 Checkbox[]}, All]],
              "Labeled",
              Editable->True], 
             TagBox[
              InterpretationBox[
               InterpretationBox[GridBox[{
                  {
                   InterpretationBox[
                    CheckboxBox[False],
                    "Labeled",
                    Editable->True], 
                   TagBox[
                    InterpretationBox[
                    CheckboxBox[False],
                    "Labeled",
                    Editable->True],
                    "SkipImageSizeLevel"]},
                  {"", 
                   InterpretationBox[
                    CheckboxBox[False],
                    "Labeled",
                    Editable->True]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                   "Rows" -> {{Center}}, "RowsIndexed" -> {}},
                 
                 GridBoxItemSize->{
                  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                   "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                Labeled[
                 Checkbox[], {
                  Checkbox[], 
                  Checkbox[]}, All]],
               "Labeled",
               Editable->True],
              "SkipImageSizeLevel"]},
            {"", 
             InterpretationBox[
              InterpretationBox[GridBox[{
                 {
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True], 
                  TagBox[
                   InterpretationBox[
                    CheckboxBox[False],
                    "Labeled",
                    Editable->True],
                   "SkipImageSizeLevel"]},
                 {"", 
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Center}}, "RowsIndexed" -> {}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
               Labeled[
                Checkbox[], {
                 Checkbox[], 
                 Checkbox[]}, All]],
              "Labeled",
              Editable->True]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
          Labeled[
           Labeled[
            Checkbox[], {
             Checkbox[], 
             Checkbox[]}, All], {
            Labeled[
             Checkbox[], {
              Checkbox[], 
              Checkbox[]}, All], 
            Labeled[
             Checkbox[], {
              Checkbox[], 
              Checkbox[]}, All]}, All]],
         "Labeled",
         Editable->True],
        "SkipImageSizeLevel"]},
      {"", 
       InterpretationBox[
        InterpretationBox[GridBox[{
           {
            InterpretationBox[
             InterpretationBox[GridBox[{
                {
                 InterpretationBox[
                  CheckboxBox[False],
                  "Labeled",
                  Editable->True], 
                 TagBox[
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True],
                  "SkipImageSizeLevel"]},
                {"", 
                 InterpretationBox[
                  CheckboxBox[False],
                  "Labeled",
                  Editable->True]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
              Labeled[
               Checkbox[], {
                Checkbox[], 
                Checkbox[]}, All]],
             "Labeled",
             Editable->True], 
            TagBox[
             InterpretationBox[
              InterpretationBox[GridBox[{
                 {
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True], 
                  TagBox[
                   InterpretationBox[
                    CheckboxBox[False],
                    "Labeled",
                    Editable->True],
                   "SkipImageSizeLevel"]},
                 {"", 
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Center}}, "RowsIndexed" -> {}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
               Labeled[
                Checkbox[], {
                 Checkbox[], 
                 Checkbox[]}, All]],
              "Labeled",
              Editable->True],
             "SkipImageSizeLevel"]},
           {"", 
            InterpretationBox[
             InterpretationBox[GridBox[{
                {
                 InterpretationBox[
                  CheckboxBox[False],
                  "Labeled",
                  Editable->True], 
                 TagBox[
                  InterpretationBox[
                   CheckboxBox[False],
                   "Labeled",
                   Editable->True],
                  "SkipImageSizeLevel"]},
                {"", 
                 InterpretationBox[
                  CheckboxBox[False],
                  "Labeled",
                  Editable->True]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
              Labeled[
               Checkbox[], {
                Checkbox[], 
                Checkbox[]}, All]],
             "Labeled",
             Editable->True]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
         Labeled[
          Labeled[
           Checkbox[], {
            Checkbox[], 
            Checkbox[]}, All], {
           Labeled[
            Checkbox[], {
             Checkbox[], 
             Checkbox[]}, All], 
           Labeled[
            Checkbox[], {
             Checkbox[], 
             Checkbox[]}, All]}, All]],
        "Labeled",
        Editable->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}}],
    Labeled[
     Labeled[
      Labeled[
       Checkbox[], {
        Checkbox[], 
        Checkbox[]}, All], {
       Labeled[
        Checkbox[], {
         Checkbox[], 
         Checkbox[]}, All], 
       Labeled[
        Checkbox[], {
         Checkbox[], 
         Checkbox[]}, All]}, All], {
      Labeled[
       Labeled[
        Checkbox[], {
         Checkbox[], 
         Checkbox[]}, All], {
        Labeled[
         Checkbox[], {
          Checkbox[], 
          Checkbox[]}, All], 
        Labeled[
         Checkbox[], {
          Checkbox[], 
          Checkbox[]}, All]}, All], 
      Labeled[
       Labeled[
        Checkbox[], {
         Checkbox[], 
         Checkbox[]}, All], {
        Labeled[
         Checkbox[], {
          Checkbox[], 
          Checkbox[]}, All], 
        Labeled[
         Checkbox[], {
          Checkbox[], 
          Checkbox[]}, All]}, All]}, All]]}], "}"}]], "Output",
 ImageSize->{349, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->63859202]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16163],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Underscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Framed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Framed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlPlacement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlPlacement"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16248]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1056],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Labeled",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Labeled"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->869468656],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->29602024],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->698678848],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->76530399],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->588829090],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->325632636],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->12282964],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->181957840],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->167278850],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->127985006],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->148190124]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Labeled - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 8.5918618}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Labeled[expr, lbl] displays expr labeled with lbl. Labeled[expr, lbl, \
pos] places lbl at a position specified by pos. Labeled[expr, {lbl_1, lbl_2, \
...}, {pos_1, ...}] places the lbl_i at positions pos_i. ", "synonyms" -> {}, 
    "title" -> "Labeled", "type" -> "Symbol", "uri" -> "ref/Labeled"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12234, 383, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->134759762]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 65652, 2177}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4061, 86, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4684, 113, 1572, 37, 70, "ObjectNameGrid"],
Cell[6259, 152, 2263, 76, 70, "Usage",
 CellID->13858]
}, Open  ]],
Cell[CellGroupData[{
Cell[8559, 233, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9037, 250, 216, 7, 70, "Notes",
 CellID->2851],
Cell[9256, 259, 184, 8, 70, "Notes",
 CellID->18703],
Cell[9443, 269, 737, 19, 70, "2ColumnTableMod",
 CellID->12914],
Cell[10183, 290, 617, 26, 70, "Notes",
 CellID->16134],
Cell[10803, 318, 740, 31, 70, "Notes",
 CellID->26758],
Cell[11546, 351, 273, 11, 70, "Notes",
 CellID->10394],
Cell[11822, 364, 375, 14, 70, "Notes",
 CellID->31973]
}, Closed]],
Cell[CellGroupData[{
Cell[12234, 383, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134759762],
Cell[CellGroupData[{
Cell[12619, 397, 148, 5, 70, "ExampleSection",
 CellID->369143543],
Cell[CellGroupData[{
Cell[12792, 406, 200, 7, 28, "Input",
 CellID->241035251],
Cell[12995, 415, 576, 14, 48, "Output",
 Evaluatable->False,
 CellID->12025974]
}, Open  ]],
Cell[CellGroupData[{
Cell[13608, 434, 236, 8, 28, "Input",
 CellID->133959630],
Cell[13847, 444, 633, 14, 58, "Output",
 Evaluatable->False,
 CellID->193598123]
}, Open  ]],
Cell[14495, 461, 125, 3, 70, "ExampleDelimiter",
 CellID->504295994],
Cell[14623, 466, 61, 1, 70, "ExampleText",
 CellID->742082015],
Cell[CellGroupData[{
Cell[14709, 471, 250, 8, 28, "Input",
 CellID->360213713],
Cell[14962, 481, 622, 14, 44, "Output",
 Evaluatable->False,
 CellID->472588700]
}, Open  ]],
Cell[15599, 498, 67, 1, 70, "ExampleText",
 CellID->4771058],
Cell[CellGroupData[{
Cell[15691, 503, 344, 11, 28, "Input",
 CellID->242885152],
Cell[16038, 516, 663, 15, 58, "Output",
 Evaluatable->False,
 CellID->381243455]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16750, 537, 214, 7, 70, "ExampleSection",
 CellID->748],
Cell[16967, 546, 59, 1, 70, "ExampleText",
 CellID->254295732],
Cell[CellGroupData[{
Cell[17051, 551, 240, 7, 70, "Input",
 CellID->1045575996],
Cell[17294, 560, 886, 31, 144, "Output",
 CellID->45062993]
}, Open  ]],
Cell[18195, 594, 125, 3, 70, "ExampleDelimiter",
 CellID->409376469],
Cell[18323, 599, 58, 1, 70, "ExampleText",
 CellID->356736550],
Cell[CellGroupData[{
Cell[18406, 604, 168, 5, 70, "Input",
 CellID->431049142],
Cell[18577, 611, 703, 26, 70, "Output",
 CellID->296547651]
}, Open  ]],
Cell[CellGroupData[{
Cell[19317, 642, 184, 6, 70, "Input",
 CellID->335635315],
Cell[19504, 650, 701, 25, 70, "Output",
 CellID->5850563]
}, Open  ]],
Cell[20220, 678, 125, 3, 70, "ExampleDelimiter",
 CellID->379364954],
Cell[20348, 683, 68, 1, 70, "ExampleText",
 CellID->72274661],
Cell[CellGroupData[{
Cell[20441, 688, 252, 8, 70, "Input",
 CellID->754553265],
Cell[20696, 698, 861, 31, 70, "Output",
 CellID->88140752]
}, Open  ]],
Cell[21572, 732, 125, 3, 70, "ExampleDelimiter",
 CellID->163404798],
Cell[21700, 737, 75, 1, 70, "ExampleText",
 CellID->845568080],
Cell[21778, 740, 243, 8, 70, "Input",
 CellID->112509734],
Cell[CellGroupData[{
Cell[22046, 752, 127, 4, 70, "Input",
 CellID->79178672],
Cell[22176, 758, 776, 28, 88, "Output",
 CellID->402403891]
}, Open  ]],
Cell[22967, 789, 85, 1, 70, "ExampleText",
 CellID->167713148],
Cell[CellGroupData[{
Cell[23077, 794, 221, 7, 70, "Input",
 CellID->235570020],
Cell[23301, 803, 852, 31, 88, "Output",
 CellID->68851682]
}, Open  ]],
Cell[24168, 837, 90, 1, 70, "ExampleText",
 CellID->671666783],
Cell[CellGroupData[{
Cell[24283, 842, 217, 7, 70, "Input",
 CellID->5443000],
Cell[24503, 851, 844, 30, 74, "Output",
 CellID->679786054]
}, Open  ]],
Cell[25362, 884, 125, 3, 70, "ExampleDelimiter",
 CellID->216957608],
Cell[25490, 889, 66, 1, 70, "ExampleText",
 CellID->306643684],
Cell[25559, 892, 243, 8, 70, "Input",
 CellID->737661272],
Cell[CellGroupData[{
Cell[25827, 904, 284, 9, 70, "Input",
 CellID->724291948],
Cell[26114, 915, 1218, 43, 94, "Output",
 CellID->62049603]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27381, 964, 223, 7, 70, "ExampleSection",
 CellID->25772],
Cell[27607, 973, 110, 3, 70, "ExampleText",
 CellID->21244],
Cell[CellGroupData[{
Cell[27742, 980, 631, 19, 70, "Input",
 CellID->31619],
Cell[28376, 1001, 4721, 147, 70, "Output",
 CellID->186458587]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33146, 1154, 224, 7, 70, "ExampleSection",
 CellID->14149],
Cell[CellGroupData[{
Cell[33395, 1165, 345, 12, 70, "Input",
 CellID->1072438],
Cell[33743, 1179, 1403, 27, 70, "Output",
 Evaluatable->False,
 CellID->549707209]
}, Open  ]],
Cell[CellGroupData[{
Cell[35183, 1211, 370, 12, 70, "Input",
 CellID->25180389],
Cell[35556, 1225, 1664, 31, 70, "Output",
 Evaluatable->False,
 CellID->228627713]
}, Open  ]],
Cell[37235, 1259, 125, 3, 70, "ExampleDelimiter",
 CellID->114526584],
Cell[CellGroupData[{
Cell[37385, 1266, 311, 10, 70, "Input",
 CellID->631807701],
Cell[37699, 1278, 709, 16, 70, "Output",
 Evaluatable->False,
 CellID->131221504]
}, Open  ]],
Cell[CellGroupData[{
Cell[38445, 1299, 289, 10, 70, "Input",
 CellID->354404188],
Cell[38737, 1311, 924, 19, 70, "Output",
 Evaluatable->False,
 CellID->806287230]
}, Open  ]],
Cell[CellGroupData[{
Cell[39698, 1335, 316, 10, 70, "Input",
 CellID->354606901],
Cell[40017, 1347, 18934, 599, 70, "Output",
 CellID->63859202]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59012, 1953, 311, 9, 70, "SeeAlsoSection",
 CellID->16163],
Cell[59326, 1964, 1933, 71, 70, "SeeAlso",
 CellID->16248]
}, Open  ]],
Cell[CellGroupData[{
Cell[61296, 2040, 313, 9, 70, "TutorialsSection",
 CellID->1056],
Cell[61612, 2051, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[61795, 2059, 305, 8, 70, "RelatedLinksSection"],
Cell[62103, 2069, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62499, 2086, 319, 9, 70, "MoreAboutSection",
 CellID->869468656],
Cell[62821, 2097, 172, 3, 70, "MoreAbout",
 CellID->29602024],
Cell[62996, 2102, 175, 3, 70, "MoreAbout",
 CellID->698678848],
Cell[63174, 2107, 158, 3, 70, "MoreAbout",
 CellID->76530399],
Cell[63335, 2112, 169, 3, 70, "MoreAbout",
 CellID->588829090],
Cell[63507, 2117, 128, 3, 70, "MoreAbout",
 CellID->325632636],
Cell[63638, 2122, 153, 3, 70, "MoreAbout",
 CellID->12282964],
Cell[63794, 2127, 180, 3, 70, "MoreAbout",
 CellID->181957840],
Cell[63977, 2132, 154, 3, 70, "MoreAbout",
 CellID->167278850],
Cell[64134, 2137, 171, 3, 70, "MoreAbout",
 CellID->127985006],
Cell[64308, 2142, 173, 3, 70, "MoreAbout",
 CellID->148190124]
}, Open  ]],
Cell[64496, 2148, 27, 0, 70, "History"],
Cell[64526, 2150, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

