(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9010,        300]
NotebookOptionsPosition[      6958,        237]
NotebookOutlinePosition[      8154,        268]
CellTagsIndexPosition[      8111,        265]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Language" :> Documentation`HelpLookup["paclet:ref/$Language"],
           "Hyphenation" :> 
          Documentation`HelpLookup["paclet:ref/Hyphenation"], "FormatType" :> 
          Documentation`HelpLookup["paclet:ref/FormatType"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$Language\"\>", 
       2->"\<\"Hyphenation\"\>", 3->"\<\"FormatType\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LanguageCategory", "ObjectName",
 CellID->26549],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LanguageCategory",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LanguageCategory"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which determines in what category of language the contents of the cell \
should be assumed to be for purposes of spell checking and hyphenation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17674]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["LanguageCategory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LanguageCategory"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->15483],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Formula\>\"", Cell[
    "mathematical formula ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"Mathematica\",
FontSlant->\"Plain\"]\)\>\"", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NaturalLanguage\>\"", Cell[
    "human natural language ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "do no spell checking or hyphenation ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->19911],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LanguageCategory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LanguageCategory"]], "InlineFormula"],
 " is normally set to ",
 Cell[BoxData["\"\<NaturalLanguage\>\""], "InlineFormula"],
 " for text cells, and to ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"Mathematica\",
FontSlant->\"Plain\"]\)\>\""], "InlineFormula"],
 " for input and output cells. "
}], "Notes",
 CellID->315],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LanguageCategory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LanguageCategory"]], "InlineFormula"],
 " is more often set at the level of styles than at the level of individual \
cells. "
}], "Notes",
 CellID->1609]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15406],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Language",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Language"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hyphenation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hyphenation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FormatType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormatType"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22667],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LanguageCategory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 12.3575832}", "context" -> "System`", 
    "keywords" -> {"hyphenation", "spell checking"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LanguageCategory is an option for Cell which determines in what category \
of language the contents of the cell should be assumed to be for purposes of \
spell checking and hyphenation. ", "synonyms" -> {"language category"}, 
    "title" -> "LanguageCategory", "type" -> "Symbol", "uri" -> 
    "ref/LanguageCategory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1447, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2070, 63, 54, 1, 70, "ObjectName",
 CellID->26549],
Cell[2127, 66, 698, 19, 70, "Usage",
 CellID->17674]
}, Open  ]],
Cell[CellGroupData[{
Cell[2862, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3340, 107, 216, 8, 70, "Notes",
 CellID->15483],
Cell[3559, 117, 1031, 26, 70, "2ColumnTableMod",
 CellID->19911],
Cell[4593, 145, 425, 13, 70, "Notes",
 CellID->315],
Cell[5021, 160, 265, 8, 70, "Notes",
 CellID->1609]
}, Closed]],
Cell[CellGroupData[{
Cell[5323, 173, 311, 9, 70, "SeeAlsoSection",
 CellID->15406],
Cell[5637, 184, 708, 26, 70, "SeeAlso",
 CellID->15896]
}, Open  ]],
Cell[CellGroupData[{
Cell[6382, 215, 314, 9, 70, "TutorialsSection",
 CellID->22667],
Cell[6699, 226, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[6901, 233, 27, 0, 70, "History"],
Cell[6931, 235, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

