(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    124566,       2767]
NotebookOptionsPosition[    117158,       2506]
NotebookOutlinePosition[    118539,       2543]
CellTagsIndexPosition[    118452,       2538]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExponentialDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ExponentialDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"ExponentialDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LaplaceDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LaplaceDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LaplaceDistribution"], "[", 
       RowBox[{
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a Laplace double exponential distribution \
with mean \[Mu] and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13843]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The Laplace distribution gives the distribution of the difference between two \
independent random variables with identical exponential distributions.\
\>", "Notes",
 CellID->441],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaplaceDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " be any real number and ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " to be any positive real number."
}], "Notes",
 CellID->3380],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaplaceDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->3402,
  ButtonNote->"3402"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->279711455],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->184768649],

Cell["The mean and variance of a Laplace distribution:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->3402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LaplaceDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23115],

Cell[BoxData["\[Mu]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86875734]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"LaplaceDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1723],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["\[Beta]", "2"]}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82404113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29448],

Cell["Probability density function:", "ExampleText",
 CellID->30323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"LaplaceDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11153],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "\[Mu]"}], ")"}], " ", 
      RowBox[{"Sign", "[", 
       RowBox[{"x", "-", "\[Mu]"}], "]"}]}], "\[Beta]"]}]], 
  RowBox[{"2", " ", "\[Beta]"}]]], "Output",
 ImageSize->{96, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152676366]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"LaplaceDistribution", "[", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24395],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->778796114]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22908],

Cell["\<\
Generate a set of pseudorandom numbers that are Laplace distributed:\
\>", "ExampleText",
 CellID->17411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"LaplaceDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.2713590869630941`"}], ",", "0.6467209013151187`", ",", 
   RowBox[{"-", "0.41544951911885747`"}], ",", "0.6939812752621439`", ",", 
   RowBox[{"-", "0.9561583175971725`"}]}], "}"}]], "Output",
 ImageSize->{359, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->592548891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26781],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"LaplaceDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3202],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110959101]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"LaplaceDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27256],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->546108099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8965],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a Laplace distribution:"
}], "ExampleText",
 CellID->18023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"LaplaceDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20769],

Cell[BoxData[
 RowBox[{"\[Mu]", "-", 
  RowBox[{"\[Beta]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "q"}]}], ")"}], " ", 
      RowBox[{"Sign", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "q"}]}], "]"}]}]}], "]"}], " ", 
   RowBox[{"Sign", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "q"}]}], "]"}]}]}]], "Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->645322304]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23684],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellID->26900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"LaplaceDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10968],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz38803kcB/AhU0yZ1d1p1YZdmhbprqsueX9KJ7Icp+XndW3zo6YrPFLD
JY9UrJ+uh0fIZXFReoyScg8lvxIzS2ceOUVMbamxfRetHyj32R/vx+vx/Ov1
ejsL9v8Sa0kikYLwmfNShoDsFZPuQ6yMoZNIamjtYXLDmBHg3BLyzI+shpm2
hiwmcw+Itn1wOUVRw6WmMwxrZiq0vfbjUZzUsHdDyu8fGBIIdx4Nf+ulhp6p
3XlGRiG8e156y0+oBpv+F256RgU8Df3q529b1VCikCaNMupg2Q5iXJsxDFU3
JP17PRRQ2lY7KDO9gHjoLhxL7gEX0rMNQi8N7NOyX96uegp5U+7CkQAt2Dof
cxtaqwafnPuZvdGv4KxDp3vJrpcw6VnbcWTzCAj6tzdaKV9BYjGtcJ7ba0h6
eEyw300HdJW23pV4DdWJlNBvAvTwUbZQ1Jr/BkrSE3Qrw4ygKMxyHPHWwVHp
dMi7sbfgxz51mSzXAalHjerTJkCz7pz6uu8oLD0QJ97ubgL/OVOcN/WjoDHl
77C7/x6WDfWVzXcdg61a0eHzSR/Bj1ITYZ89BkGa3OVLlkxCUvQPyqihMdA9
EGTKK6dgayonUsHWgwe1d7Hvb5/Bu/ua6p9kPdiCiT8w8QVE/sxx9k09bNFH
fnDhkZCra/Rn7zE99LXEWERyLBAXygT+zga4k9O6k2myQHL7m2entxkgzjpF
3dVliUI6Lb2aUg0gTE6/Q7lohWzEk2nFxQbwjF/exeXPQhk/HefyGw3w2JFj
l7LOGh0Wsp5kDBngXtXRIo4VGf1lySs4O2mAdAv3YOVzMloqvbHcZgEBtgNp
/vtu26DMKQ57N4cAbblznvSP2ajiRMXxRYiAvGVOs+p4c5BucmDXnlACci/G
tfOZtojZk+skExIQmfdrF2XEFvkkPHnDSCbg4+ayT9IGO9RUVCXjZhLwUrtJ
3JJNQaUDikqf0wSUbvCiP+Lbo1vXLh8i8gmoPJ5CjV8xF7koLkjkJQRk84SB
Vqa5yMhcuD/nOgGrB0oqsh/NQ8OLLTLoNQQUsIsqHwU6oGn7bmveXQKONJ0p
CKxzQJbNUmlsMwHb6LwyBYuKik5q6krbCdi4rz2KKqEi8mN6o0ZJgHSRgKU0
UdGWHSn3bFUEsB5cvRAU5YgG9XkL+L34vxUt7qoGR3Q5rV21/hkBcROzujvc
aeiAen2Q1SABgupxpuQcDV37vu/PVcMEyBWzs+qnaejH2vBVwRoC9voO53Zg
D22vOW22Q31dcS92uZIyYnZ4peiuEVu2pb4oBHvknPIt6zMNTSbYW4dik3m5
u85gv08U/8fD9h362mfnFxq6fiIpPQr7VZgxMAFbF3z1idkn/5VHiLFb3/V7
RmOrmlNTzmOHd2zUmC240i9rw95dPsPdiZ25R0r3nKEh0Xebl/CxWS8Osb2x
nQrjxWbLI4PXBGAX90lUZjtwLUKF2D5axQkBttRDeDIfe9VqIITYm66uL7iC
TRJFBMSY9zHml1djt4qT/zbbg/qwuRN7LaskLNa8T3LpcR+2sam22uyDlgef
a7Flazrt4rAXpgeNjmMn5gzGmt0wsfTTjLm/xtho9v9EXm1Q
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.5},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0, 5}, {0.5000000510204056, 0.9966310261566844}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396565040]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16633],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellID->13885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"LaplaceDistribution", "[", 
      RowBox[{"0", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Beta]", ",", 
     RowBox[{"1", "/", "10"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxtXQVUVU3XprG747UxsOtVubiP3V2I3aivHZgYqNiF3d2BBYrouaIogkpK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   "], {{{}, 
     {RGBColor[0.3361115040657084, 0.13164035100887134`, 0.5894256959679792], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlk1slFUUhu83085806lYaSFsDExLFCmxM0YNMbGlNaISWhOC8YcGjQsS
gVRXTktM3BcTVi7dk2DUlbUkGiuF1pBI1AVNXKj9DWJcUFa6qO/T8zZlceY7
c++557zn997au++fGCuklO6JiqI7Iv4/IpospXRRdFb8qP+fSrEGf078mSyl
6VLsz7WkNKPD+8V/rbUp0VPid6VY79L3E+vk7GBrSpfFT0tHsxRnkJ8z3yP+
QEvI/G27nB+T/H3pmxR1i19MAb6EH1pbsfxintKPecglyV0rbGP5wTjLWZxB
x0wlpc72wPN2W0oTOjtSCN1ZMc7i45yxgRH+hORfrKZ0VDQkn+YlM1/alp23
DHG6at+J37T5HVlgBssT5bAFnj7RgKhf9H0l8IENfdhA5x59r0g+F5+0/145
/GIf+/Br8mNR/txyDC4Vw/8p4V3OQ88RydVFjRRyB4qx9oW+g6J/xB/WmVeK
EcshnStXAv+CbH5XjTPEFrvE5zPt/yS5Wa19KHqrJXCulSKv5IjcUgfw64Xg
n5PMMeXhRjl4zu3xWfL+WzFyiuyQ5TlLHtFzU9/Pi+HrG8L1puiU5OaE5Zbi
8FVL6OCLHvCsliKO+7V/pRr4/hX/X1vU+HIWOuCxu25b2Fx3HfK9bz4J/2vy
/6x0dujvPtFex7cm6nb9NF1LO71Wc+/VfKbP5+C/Fa6n5cNt6e90vwpmGhY9
7zqhjsBELU1XIzfkpds2ODft/h31/x7bpi5m3RsFy4Nlyv1IndTsQ/0BrDuN
EaxPio7I9wHRuVLgrnuv3/vws8I2IF+WpPPRPOqb2u6yT632r9P6Wevy/w3P
klb3co/36Jvk3nlMOouVmCcDtlm3r52Wp0YuuU7wedYzAdzsUUfj4idEJ7Oo
/ZueJXurUd+cmStHvVKHg/oOic6XAmfy3OgybnhqjzpBvuR1fNnCscs4qQ3y
gl30beFpek6Ca9z8Xylmd4fjZdObP+jHzohzQDxeFcZnFaOFLHLU4Vxif8YY
flftf1ONWUKtHHetNW234Xz2u/7qrlPqghp93XOlqz3mI71Kvk9ngaVX8WNm
EXNw9Ba9LlyrecT8bop8gp9eYo4Mix7S3oZ9PliOuUnfdXgNX7ANBvw9Ln0f
S6ZYCPv0Mz4xwy6UY47tlr95HrOmvRiYOF/Lwh4xJgfXXANHJXs3j/uo3/Ed
ts0Rx/mZPPqWeNSNifWTjk3DsRt2fCd933LPMo+4G5h7C9LxsnSttEZvExfB
Tkv6v9i6fSeuu66IyWHj7Pa9sugegU+OwRnHYUcx/m/lhi+YLntW05vM8kOu
eXxcsOwH5agn/nPP/Om7htn5Qh428PeWfWYe3TZPj54vRw1f9Z2IfLUSOSNf
3eJ353EP9SkO1ytRB5+2xN2wVRN8c/t60D72micGzPpe86z1OkbU3ZJ9uej3
BTnAHvc/d9+IbcA/nAWPLXI26nz90RY9Q79wnzCLyR95XC1t3/OrW++T1sjf
RIq1Na+jGxvYwgbncAe8+ADmhmuSq2bFesZco6zf8bdmmdPO87Dx59l2/Swb
A3H41T1KvN9pixjwn/pAB3mjN8j/R8rDvmrMUO66ejV6tMm9lwdO4sYaPl3X
/o1q2AAr/hNn6uVQHvXxEvdbNTDN56ELPZsxMOamZw+zcbMP/AZkvnA3U6u/
6NzPFd/z0v9lW9TLhTzeduCa9/uN90rmdw1zb9zzvuFZsuF5Sjwbnju8mx73
24n+WPP74RjzLI+Zfe+B9+n/2UJB1w==
         "],
         VertexColors->None], 
        PolygonBox[{{2013, 3013, 1491, 811}, {3031, 2314, 121, 1508}, {1961, 
         2428, 911, 940}, {2462, 2338, 833, 942}, {2249, 2248, 568, 650}, {
         3006, 2101, 471, 808}, {2115, 3167, 1722, 358}, {2111, 1942, 782, 
         483}, {3167, 2114, 107, 1722}, {3030, 2119, 1508, 1507}, {2987, 2077,
          441, 1064}, {2848, 2847, 708, 911}, {2886, 1991, 314, 1346}, {3000, 
         2999, 338, 1224}, {1907, 2904, 1371, 484}, {2283, 3032, 1509, 366}, {
         2087, 3166, 1719, 338}, {3135, 1961, 940, 1643}, {2162, 2582, 1048, 
         1114}, {2120, 3030, 1507, 1509}, {2100, 1941, 780, 471}, {2767, 2274,
          650, 1200}, {1942, 1907, 484, 782}, {1941, 1904, 472, 780}, {2102, 
         2013, 811, 472}, {2169, 3072, 874, 590}, {1990, 2514, 987, 314}, {
         2513, 2247, 1200, 987}, {2460, 2596, 1064, 939}, {2314, 2315, 515, 
         121}, {3148, 2091, 340, 1657}, {2154, 2378, 841, 568}, {3014, 3012, 
         483, 1491}, {1900, 3148, 1657, 50}, {3155, 2118, 366, 1676}, {2905, 
         2810, 358, 1371}, {3091, 3092, 1346, 441}, {2084, 3137, 1644, 841}, {
         3138, 3134, 715, 1644}, {2092, 3001, 808, 463}, {1897, 2784, 1224, 
         36}, {2656, 2170, 590, 833}, {1914, 3155, 1676, 107}, {2348, 2347, 
         36, 708}, {2278, 2279, 463, 340}, {2735, 2162, 1114, 1173}, {3166, 
         2086, 50, 1719}, {2056, 2460, 939, 1048}, {2501, 2736, 1173, 630}, {
         3134, 3136, 1643, 715}, {2864, 2863, 630, 874}},
         VertexColors->None]}]}, 
     {RGBColor[0.42150251219716517`, 0.2801122530266835, 0.7094530879039938], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH9sltUVx5+374/ned6nChGjuIyhDiGLLqW2dTiTOWviFuMcWfsyCFGQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllW1o1mUUxu/nbc//5ZFERSsa09hmobGcVqsv1iyLYRhu2pbEMjdHUrOQ
Cl8oKyMVKbGgAkdmHwJDKotSodS5OTfNOSkykdKllZks+6DRvvS7uD4cOOe+
zst9zn3Ouac8uWJBZzaE8BqUh34uhtCUhrCwEMIiqBH+bBzCxVwId6PQD38Q
nR+Qv4dWRSG0JiG0gZWXhfAmWEsphG3wvfhbAv8YOl/Bd3O2GryIj9uwvZYJ
YStyB7QV+R1oBF8niHmG2CPgi3QXqDX4Ti3wzdDjyFeIuQNfO7G/iryGRJqQ
G0XYVuccq574lzOOOYR8EjoDvxf9S9guwV87vpdBD6Pbxdk48Dz47YqPfhX2
NeDPgV3gjkPEridmA/n1cTYHbCX5bcP+GlSO/dvo3Ak/H51XwVrx8Tq6a/C5
Hv3r8f8Bvgdi13InZ/Xo3gf1oLscm+fRfwR5fZlrMAd/o8T/J++c9Bad2L+S
85tMhz+ueoM3IM+G7yHeyYJrNhtf95bs+zLyE/BN6LwPv5+zP+AvQqfx3QK1
wS8gXiP+RtE5hP9uaBDfJ6Dl4C8ib4JfCp0m1k/QWnQ7iHkL+MzEvXMI+VF0
m6HDWb9ZG7oj5PASsQqcDaFfV3IvSOcweG/q2imHZvDt6E8AnwR+EF8HoGPI
30F14AdS965yUO2fRX9+8BvUJr6T7lLHnc4j34V8tOA3/QX5LNSvXsd+Mr6n
KF9i/ap6gU1EfzdYuwYGbFrsWldBo8R6g/hv4W8L9AD8BO4wg9iblU/RPaNe
UQ9qVpZGrq1mRrmUI+8pOKde5JrUvTeEfGvkHHT3e6BvwO7gbAC8H/oCbCXy
YrD3oE3gG1PPou70ENgp5LH4+jfj2dyQ+q6aUeV2MzHnZZ2jej+UPNuagfEl
11y1Vk57UtdMterGxxX4vxPP7nXodKFbgU4F2C7kH+EfjBy7BnmF3gdKqMs+
zmZFzkm56M3U+/dz1pHxDFyAn5U4d824cn2XGB/nnPMp/OzFvke9Av4y8jx0
XoDfgL+nkXPoT0X/OGeVYA2xe1czNzf1m+mtNNOatf8S7xrN3DC652LPvnZi
P/bDUBn8PmyWgfXEno3KjGdRNVDumsmZ+K5Nvatq8T8Dvhr/q7RrkAfh+yLv
JvlUbjegM6ngHHeDd2nmst4xz6j/i7Zdl/Mu+6vo2dNO027oLjqWdsRkzWbs
2debPFV0D6t31fPD+P8d/wnyMeT9qXeCdoFmZBy642PPnnaG3ubPyG+tN/oc
+y8T957u2Ifukdh30wxpd2hHajdqh2j3Z2Lvav0B2jXt4E157xy9XRq7V/SG
g6l3tna1/gjtniORa68ddCP4TbFnVTVbHPkP0t+zGftziXNUbkehT9CvRP4w
45krYTsm9u7XDvsU7LPEs1ef9e7RDtfu1g76NnXPqdc0g+eJ93XqWYjAF0be
sdqt2nER8sTEvhRzamQb6Q4gX4KfG/lv1IyuxVcx9d31Z3Tiqwr7HRnPzPTI
OSkX9bx6qSLyLKmn9JetK3q36k9rAW+G8hnX+Dd0p0WeBb25/vLVkXeb/nTN
SnXku2lmFPuj1H+V7vA/KLQT5Q==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5068935203286219, 0.42858415504449565`, 0.8294804798400083], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuMVdUVx899zT3nnkuVKglQ0860SBmoDYgORB0T0/ZDTZroiAhoG0eo
j6QwYEtERqJfLG3BJgLFdKipqcYoVknBFBWTom0Yny2PgYSagLTDxOLg2KQw
Tyb9//pfE/phZ+997tprr+d/rX2b7uloW1VMkuTJQpKUNC/Lk+ROjbsqSfKe
5nc0jmrd2JAk74vmGtHcKMLrNF7Rfp/GLo2ZGvdrnNa4WzQ9OnNHxftBXXBS
Y67GMX37Ttk0t2p/r9a3aH4qS5Ifp0nyLa2HNYY0jopmdtn8B7RuqyXJCtHM
02+Xif6LGvMlxyTNdY25Wi8XfbvGzaJZpm9LNVaWzHtPzfyf1nq31k+JbpbW
V9es29c178x8H/pB+3utXy9ZT/S9VHa4RGNHwbLfF/Kvlp3OVZPkEen3jZL1
xh7by75nutZV0TyiURLNs5qv1H3N+u0vuvNejYd1blXicx2aP9LcrnGr1q/o
95c13hTNC5pfrVquoni9qN9f05ik/fGg/0S8+zPzWFbwzPcmyfqE1ju13iX6
Weitsb9o22G3Vs1n9NshfT8cuuPfUl06aDRJ/x+V7D90Pyz65rj7IdnzB7r7
nvADMzHzG31/W/Kshb9+f6DuOPhhar/i0+ul0w0aPyWmGhxzi4knjSMRM8w9
ZeuyRt9Plm2z1bHeoPW4eBbEv0/ra8X7Ku0PFswP2Vk3BX9kaw/+8CRWBzS6
9O2xzHbEdugxM+ix9/qKbbgj1l2ac9ngw7LtVqnbXtyzN7Gf8NHz2o9VvJ9f
c/wRex9UrBe6Mh8NeTbq97Tuu3eL/5wG2/02ybZI44GSY/ay1HG7r2zf4Bdi
c2Wsyb8TGj3i2a+7FsjOm8mpon1+ZeL8GRaPdRpZyf5DX3h0h69znWusOG6Z
X684R7H9x+GLE3FfV/BBRu5okL5VjVR0owXPD2s+J9mXZ861k+L/eGaf/Efz
TTXnwtv6vipzrL6n+beZ43du3IVejdrvrRgrsOGRsOd+nV2ZOYbHivZDt8bk
kuVYE/nGjPzo+kbk9U1Fxyb8P4uchuZmyfyRcnik4N/nBg12gM+G4Dca6wuS
q7Vq3/drbs8dsysafBf2J/bJAeIr0/cnsbP4jhY9H9D3gzo3ULOtF0mGuxUb
lxadM8zEYUvVdsW/XxD9Ju1nFz3/OvcaDPhq2GJbwd+wyVbypOiYXSb+7XXv
wTrijpx6Wny+p982JebzWuTE9ZG7XZET7Fl/X7QDubEH27ZFvH1J367QmCba
f4nmk9QYhh1ag1cpcgV5iMvhsCcydwfuHZY91qXGr7OiXVi9GOOsOddbvhh3
2KahaPuc09lJNe+J9yxi9az4fZAaF7+ZGkfAjVc1/6FmXMf/300dA5/rnl8p
xh7V+rzuPl82/7HwG/IfDywmrzt09kGNzrDT+sBxfLItbPqGft9aNa7gf3wD
r3d0T7fGkZKxqjlybSRynPUS/X5HZixYKB8eSh1r+HlH2A7bLAhb4YOpFdeD
PLAf7H1Quu7Q2Z8Uo7ZHfUcWdEIefLI6/FIQ7eW572jS/Y2Z+wVq5lDE2HLR
LK07Z5rjLuxC/dtWdo0YTF0z1kb8D4de2KkzsPcayXY6tc+mlGw74nGwYh/g
C3oXcAA8OST6D8Onz0jvJVq/ID6dkvfxqtfTcvci1P7Tol9TdX3D329GTzBY
tn+J7ZdFszm17GD/p6EPMiIr9YEeZSJHJ+IPW8Fve/QG4OicsrF0XviCfNsv
eRamrg/E6KOR161RK8fCFuhN/JwR7bdTY9WXJVtP1bi4ROuljLJ7lM6Q7We5
85wcH9Z6MHePQ/0hF4nVW+SrtVXzpLfpib6OfP1TbjpqD7KDseBqb+Ta+1ED
qCPY+Jmw80jQgZEHI+YWRx3GZ8QYMYMsxxJjZHfgBhg8WjJm17k/d87MpI/I
bceP5cPbtG6r2Dd/LTmGwRNqMJhCDP6y6jikz3mr7B4PTL09tc9aAj/wFz0R
/JATXLwz7DZUsU2x56ei/1tg+2NVYyU4uUC0vTVjwOea/61xSvddKBojyAti
fDx63wncJ+YvxPcDgScXYk2OYSPOrpe+/amxdShoJvBxLPB8iuQaitykt4YO
244HPfuN4vNu7nzBD8fCF9hiKGIeHCffnoh+eHL4iJp0KnqA4ZAfOUcif7mT
HnZdzbE/Ht8PRM8wEjTDsUZ3ZLok+NMv4nfkeYl+QWNfyb1IU8X9AHHJuwOc
ulp6zM8v5hMz/cMERpNHX4uz9AwTPQ3rGfQ+gYf0XPMiH8ntMxGrp3T/PzLv
W3TPgtxnkJP3E7I2Rn8Ez6+kjlHi8yXFxbM6u6dku9E3EDPg9e7orem79kTv
NfJ/fQr85kSu0cPuircZeqAPdtgp/r/LzIvae1dqv72l7+9GH0U/xZ71P7Xu
zYxfYBz+oR/rSl0DyB369z9HD79C8x+rxi7qEPmDPKuVFx1194m8T64q+/1w
u2RYnNs3fZp7c+N0s3jPrplukb6dqNp3++LtQT421F2DwYmpUavoQ6gzUyKe
ecM1Ry+Nj9CDmjIrzqAjta4l+t6WqH3rAo/Z/6+vKDum0JHBGh3xx9S4Fyza
F/0h9as1en561TSzj8DlG6KXe67BNQMcyDL3jvgTLGgOOfEZvpsVfdmWijGN
fuaziuXclrlfoQ7sDV8PRAzPiLNrZI8zuWsCNep84NK1ufutadFT0ltSwzfp
2+bc93Hu8sxn6SvoQaGdTuzUfAdvhL6Ka/5DNffuxAm9xNmQcywwFpwvynft
NfePYNP+eG+QG/dHL7FR945WLQ91hHqFXtQxag91B35gNzx/Lvpf5NaBOkhv
TW3tTI2DbYFVg4FXUzL3oMQ/9XAk9R2cG4+z9Hr0B8gHppej5+R36jc0MzK/
LYkB3hyDgVGN8aYEE3jHTA6bdIUPsH9TvJnQi3f/qrr3EzUVW9CHESub4r04
Fj0hevAdXryb+6rGmOOywd9z+4MYwTfYnzp2Y+TOfaLdUnXdfL5qHfriPTIW
9hwIXaiDG+hhM8ck77CN8RbDHqWwSSEzX3jic+RG5u36fjo3vl6h9fTc/6OQ
50MRh7x7qJFg3YDmFdp3VNw7b4/+GV37KxfjdzDOsu8P3N4i2q2Zcxf7dIQM
6HxdYNd/AVpdg+g=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtol3UUx3//257n+T9buMwXitnWxWuCa0slMIroRUG92LzNabS5FkFu
M5KUGfrOSinapAtSQYMQL5NUEl3gutDUsmypYYVpuYU2W0WypXT5fPv24sA5
v+8553d+5zmXp7KprbY1G0J4CcpDD8UhnE1DuFwIYTPyqiiEH5MQfs6FcByF
i2D16PwN/he0GjwPPgN8ALwa/EPOpmVCqAKfhDwRuo9L7kLnPbAe9N+Hn4RO
B3JJMYQY2wtQJ/L80hCaS0K4jftfwHYT1IXuy/hbDL8QehR5CfJxYhnAfiW2
fdzxE/xFzsrwfyrvtzyM/EvBb2rFdzuUcs+MvLEy4pmTs84KsGp8fIr/PcSQ
Ry5AlfA1xPMm+nekftsszj7B9jRnH+BrAB9xqW2kOxX868g+5WsxPmP0E+gq
fBs6V8Db8NeBv/XQAL6Wgj+Jr968fVci353zHUfhj0F7cs7x79g+nzo3CXf0
EPtO8F7wrehXIE/Cx63wt0A16N6pb4L+dOxXoXsE+gr9qcjzUusIq0EnIvYS
6ETGOQhg/+BzFF9j0BbkUmgreCf6N+BrAlTJt9iBeoRuJ/K6zP/fGP5ZaFnG
NRVjG0E5bPPQFGLdhXwQvgJ6Cn51al/K0UJss9CD+H8C+8lg75DDoeA3XeC+
waJr8Qx3/IDuOagW7FLOsY8o5wW/oQH7K+DXwJZz9hrYJdULtq34rALvi5yb
WejXY18H3cv99cgl2PajcxLb2/HRn7gmVAvKqXpjLvoL8u6Ro+geg06h34jP
/apD8NngB8GH0f8+MvZtxnc9RjxVWd9ZAT45cS+pJlaAPwPehH0jNITtstRv
uR/5XfA3wF+Ff0UxwNdwluRc4xvwtTHxXfomg9gOQaPYb0DeBdacuFdVU+Ox
n4J9BfwezlrADnPn58jroHrkncj74FdBDcgd2NQSez/0FnJ36t5TDV+PvBB8
HFg1cinyGcVQcE8egb8H/HTBOTuMPC/2t1WPzySW6VBvxjmU7oKi3y6b2ciH
sElzruEtsXtEvaF4G2LXoGqvghgWxa5x1bZi0rddlHrW6Bt/qViwP5T3jPoC
7AR0Drkd/yNgv0Ln8z7Ttz+fuPZUA2fJTR/6nxU8w9ZEriHVjmruKv4nQgcK
znEl9nNT96J6eD7YEGcn8/axXrMD2h7cQ0tjz2jNZp1JVzNRs1A2Y2B/QuOI
fVvGvZRJPGvVU3qbZpBmj97YBbYVKsm6h7/Btkk+Mv5GH4F9nDiXa9A5wHtG
Y/OqmW3wu4vGn+Zsb9E6wlSTr+MrEzuWmeAPiAcvz3lGdkXeQdo9+oa6ezhy
rhWDevePxLNUPbw2dk+oF7QTtKvGJ64t7az1yMsS1+bj4DfCb0/cez34yzDr
slBL3jOlTN8zci8oB78VPSM0G/SNu+Gfg24Gm4CPtlLPMM0u7Ri9RTtOu01v
ku7m1LNSNs3wGyPvWs2k7sQ9o15RDzUWHbNiVUzXdF/qWtVO/C72DtDsH8m6
F6YV3ZvqibcT7yztqr34ewRsU+zdpJkxDH859u5Uj6r2tDO0K1SDmsU3xZ59
msmL4dtT76oxzVD4Fs7KS1xTg/B1iWezZszy2DlSbrQTymPnXLneBV1I7fM/
X1Az/EpoTtYzb63mW9G6+meoS71TtUs101+MnAO9XTb70N1f9KzTP0cZ+tel
ri3tqCXcvSNyLrRj/wVqsiZQ
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5847482423373572, 0.5611899048399145, 0.9099758210116734], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl3us13MYx7/nd/veTjgXtUKTto6Se6dsqDgWxuZakUuyROioXHIrzdBp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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVls1VUQxs+9/7v8lwsKLSjFNEFUREHcChpXqDEiJMYFjYgbIkjCUooK
ii2IaDVsEWwJJYIGRVTwRdCA8UlN0OiDRMElRg3QgGExkdqqQP19+fowycyZ
5cyZM/PNkKlz75qTDyG0QQWoXxzCY0kIT0chXAddAL+lHEJNMYR65KPon+Vs
JfxAqIy8CHkVfB20EdvnoZigVcgj0delxCL4F8RYgbwdeQ3ydGy+hf+asx3I
H0I78N2a+O6BuRCq4f/IQujB92rO3sH23EoIo0shjIEm4f8LZxOxvRf/FNsM
Gkrs1Zx9jP8I5JH4fxbZdyv215Qcow/+ndARfPtA67FdTg57qMXr+JzCdlDF
dw0iXky8sdjfhu1lxDuIfQf0D7b9uHMpvvORm5H7512Lx5Ebiq5JJ3JDZtsW
4n2HXEu8IQW/4Y7YNVTtyth0KTbUn/uvRJ7I/RMS12Yq8gZ0M/CpQv8Gd/TA
78P/TvQ7c/7LTs4GR/7TRu5qR36V+xqhC/EfBg3Hdxg0D/3s1H8j/dnKFboU
uZV4NdTiBfwfzbuGEXIROh/+Yc7Ow3awqOSeORO7h9Q7QyP71mM/u+QYR9Ed
5r593PUX+inoT+BfQL+LP3gG3SrOZmC7AP0nvG0XPp/D1+bsuwS5LXKM7fAf
QJ9G9hlArGrVj1yqoAfgJ0Mz8T2FzVri7c7cm/Xc9xvyS/ivR3cSaoNvhd6G
3wI1YdtVdm/VEH9d7B5Tby3l/nXk05a69spxQ+yaq5bq+Uvgh6f+vxGqP/qB
iWdntHqQ+BUoIZ8UilQL6Ay6l/HJY9+OvBHdJuha5GOJcx2nnkQuUd+h1O96
5G9iz5hma2fBs3Ys9uxq5mahWxa7l9Qj25AbevNVj0zhrr+Jfxrdrcjb4N9P
3B/6D/XiPdhPKvhNi5GbVLPIfzKeXPYrB+xvQg7Y9qBfDBvhU0YuQc3ImyNj
yXHsz4mMKS3IL/b+Rzt0MflcpP/MuWdz8HnoP2It4WwttmsSx3oL6obvghqC
3/B93NvzRffgLOR30e+O/IblyPNTv01vFNYt4mxOZMzbrPfz/13BZ3uI9RW0
n3gd3P8RummJ/dWDB+EPJO4t1WSkei9x7wqTfsS+ubdeR6Fb0NdDr3D3MuQh
5FKjHsP+OWEq/Hu9+QozZqB/Arqv4JqMwXd0Zturisayvpl7SZi2QviWebbU
Yw/prcScgP00aBT8PP6sgt9e4t3PXZOhu/N+8+3ok8TYdwT/halnTrP2FDnc
TOyxmXPXn6+UfcW9JZufM8eQ72HoBHx17N7Qn59Bfzrz3XrTQnR7U/euctRs
/k5unZF7ojvzjGu2hZHqlV/LxhLpD2WeYc2uMDoml5bYbxVmCRsXpM5dOf4b
G5OFxap5B/xMfLpLxgztMs2YZks7TdiSi70rhDHTM/ekelGYr7/9iRjHIv/x
k5lnWrOsHSFs+bPs3SOMuZz4V0B1BWP46bh3B+XcE8LWusx/K4xVLwxLjSXq
iQexHZB4VxbR94U/K/Eu0cyp12fH3pWyX0msU2Vju3amdu08qKnonatddzIx
VmrnbSp7x2m3aebGoa9PPcuaMe3i1tRYqBq+KTwtGyuFYdq1ryWeTe3cLzPP
uGZbMyTs1xuUu3aAsC6KvduEece1f5F/KLoH9Dc3pJ49/dEjsTFS2KidNT52
z6nXhDGN8HMz7169cVRqDBb2quaHEmOqsFR/prtuTI19ulOzcSD1rGpGyhXv
QO0+YW6u4p2nXVerHYdtvmJeM/Q/utIitw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6475303921006447, 0.6620633501905357, 0.9114070606546123], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMXVUVx8+duefec/a5gCRSpkQ+aPrSoIWIQWmdKRbRBpMmoomJkDQj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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWtolmUYx+93e98973M/b66g06Q+FLEtqFQq7GBtuWVJRdFRqCCW1jY3
9e1dluHaUtcBdZqrBG1uCh3oqFRSGARFfigKgiwSpUJiQbSyD9rBbf3+/vfh
gut6/v/ruu/7Oj3ntS2/fVlVCKEXySMzSyG8XgxhiI+PVofQhX5nDGEx+lV8
m8B+BZldE8L5fLswDaERacqF8C34FNhe7E/BLkA6iXct/mPg/+DTlIXwPZxH
0OcVQlgEviEJ4QvO3sa3DrjrwJdzmWXIu/DfQS4H/xj+XvQPkAXE+wS7B/4g
/JVwe5ACdh7ph1/AvhXsR/h/wh3k2z70e8AXge3n207OzvNtAvst8M1gW6LP
PoMznsW/gl3BXsL7VsJ9DOnDdwf8Gdy/FhkEPxf+XLi3YPfyllbwH4h/hG9f
g98L/hx2hn+C/z7wAbBnou+u+CPgVeD/Yg+Dt6N3IGX4m7AfKDpnytXLxLsb
33akG/5nNc7lafBPKTinI2CjOgO8i/jvgb2fOXdn47+x6Bzq/IYa13Y+eFPB
Ne5Ffzpxbgb4NkltW+AvhN+OvTHzm/SWIeybwQeIsSLvnlnMXR8s+azfFB/f
V5H14GXu04d/v87A921ilPG/Dvsa7Mt0P9UXWQ3/SviRWBmyDvss+AvRT+e8
3Tn31G5892TuFfWI3tKCNBf8pgTumZyxH2wU6QGrZM61eqARvQH5irMa4c8q
umfUK6rhXcp10bNQxfsiWIrUFFzTU9FrkVLBNYjw0+japfivRV8T3VvK+UNw
l2TuTdX8MNih6N45wBmvcVZdybOmmVwANsX983BvQpozz5RmSTlbit6ZuTfV
MxW4PaljaUYvBrsI6cZeTcxV6I9nzr16up/4fdG9WCb+LPQ5yNy8c/YLsQ4m
7uVDOde6Y3peVPMKdx2DcwfxLkk8C1eAj1d7JtZw1lOqT3DNR9FHkIPYuzQT
+HSkvtvnyHrid0ffRTN4ALul5N2kGtXDbUi9e7QjynBXIMVgny3Efh75EvsF
4j8MVp+5tpqZ7ejVRc/SpcQ4Qaz/kDL8Kc74C/0o0oZ9DHsc/Wfu2JbzTptN
vCP4J9XO0Qb1dnRvqmffRH8jute1I+rQ20qehZnYPxHr99S5VMxN3Gdz5rsq
R7cRuxZ8DvGP8u0G/G+M7iXtuG/gHgefBD+sniN2CakPnrGtcD8E15Jfiz2W
eCdrF3fmvAsniFFX4504I3WPqbd05h+cP170rGjGtqK/GN376iG9fSk+T1Y7
B5OZd5J2kWKG6J2hXaGeXRW9U0/u0rxn53ji3aIZ+hvuMeT+gt+kWTqReLdo
prbjvy16l2kHNKE3R9dKNdqBPhy9i7Xz7sum35xzzHOERedeOVJuPkrda8rR
/OicKpfacfqXvRSdO/3TWjPvKO0m7RS9/bvE/zrlQP8a1Uy10j9nD1ha8m7V
zP+aekY0G5qJq4k9L7q3NDNPoPdO97t6uCs6hnz1T2zFvj7636YeHdasZ56d
kz0ONhS9KzWT/wNwwPme
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.710312541863932, 0.7629367955411569, 0.9128383002975511], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlltsVVUQhnfbs0/PXqdybaFYjZoQBUQSoV4aTcBbIQoo+AIJwQQEpaAY
IApGLAUEykXaIlXUFlQoKClIlD6IUEolxgC+qBFEIVSJlWCC9RJEa/w/ZggP
kzVr7Vmz5/rPumna3InP5kZRdFtOFOVpHZmKolGiKdp/lYmi4yGKDmg/riCK
7gr2fZr4AeJLxM/KRtHTonlxFPXQvkr3aqTnZL74xPRMkXy75Jv0fYb4Y/q2
Q/z+lOm+XzKHcmwP/6nuVYgWy6Aa6V4v2ij9rX5nj2SekZ5u6Zmo/UzxxyV/
RvJzxF/U+QSdd2hdpfPpkt+n+8N11io+R+sT2s8W/67seke0Wmd9RNU62yz7
K/T9Ye0XICO93TnG99NZPbZKplB8jfhd4rPpKGoQf1R8SnHrJ5sbtX9AMpNi
s+E32dIluih9S/S9UrRS38rSFo+DHgNicdlHfRur/UviGyXbIHpPZy9ofV60
RPzHWj8SHRTfKX/XJubXCv2jQ1Sn5D4eW97IxXCd7XadQd+aU5avrOIWRIPS
9r3ZZVYqNq+IXtR+nXRv0j8apaNE/Eydl4k/Ldqesn915ph/+Fun7zWiJfq2
RetmUbX4ybHFBZld4m8U3yT+dsWtLFj9kSv0kq820Y95Fh9yMiu2XFBHTxVY
7H7KMxnqp1Q+fKaz2lxbDzv/q+L0WLDaIMalXkvf6+yHYLLUyYiU1dK3idUW
PLU4TN+ek571kg2y9U7ioH1VbHWTn7K6wbZXJbNO9LLO0m5zF7Utm4dlTdfd
wfqK3AzQeXG+1RG1OTplefxPZ0WS6++2lnisqIs5secxZbUCv102DxDtFL9X
Z2v1bV6u6ZvqNX8033qSfhwv2XGiGfKlVv95LWP5aveeJJ7UVqnH7CHJPBgs
D9QSNnR7LEvcxuXS9wsxzbGaaPL4k8d219mie82ee3qlv/fLOu0r88zmN2TL
J9I1V/wosCeYH9drvS7Y3Ue19g7Wu/PlU6fkL+j+N1qP5FsNkQP8q5CeVp0f
0PmRPMsJfpAXbOUePUKNkm9yvUby54PV9c+J/QO5QzprE22T7L1a7wlW03vk
x4eiA7HVY5v7O8Z5ahj/arBX+sfqXo9g2FmaaxhyUv04NNdwBjwB+wb6nt7r
cJv76mx+bJgLLgz1+xOC4SPYCIFZ4NWx2GzH11vky82icu1nBKsbauak1u8S
66cK+TE7a/9ABzWIPTu8P/BlATFJDG86JTs+GH6OIVfB6hQ8mOwYeNoxib6m
z8pdD/h7g8cc3SMcD8E4/KS/wEr6Dcwd6Ct+zXGcpA6ZQ+AaMQHD4OmLM7Lt
kWBYV+L6wG3wgJkBJvT1e9iPLes9R+TrC69JcpFO2/8PB5tnxOOo+C+D/RMb
utyO+xL7N/8FMzYFw40gHfWes2sTw1OwdJdkd4v2O6ZQ19h5Qve+ztgMRG9w
fE7AomD7bscg8CelszjYnjm8zGcxsaJvuct8GO35mC4/nhSdTxsWFaStH6cw
szKGOdQYdmNzrc6WS/8i6S9mRuvOHTov0j4/bXnpGawmiCd5vOS57CWdvROz
A4zCb2qPGJd5nFfobl3G5s6QtOWDXIAz2AjWMHOafO7Qz5UuM8nnC3VOH69I
GYaUe121eh/RQ+Ahds132+jBrbH1Ub3Pe2p+s/zYkrVvUx2fwQR8nej9FaVt
FlypUVZyV+29Shx4S5z1XFFz1bG9I6ipVd7nf2btDUH88XtVyvoCTL2QmF99
xJ/Pmv567wdsOOu4jP5ayb6db/+skuzSrP3jcm16HZ2K7T1ELKr8TUCt/q17
hcHyWat7ddmr9crKPzt8tnH3RGx93um28B9iAHZeSuz8XGz1iG3UXY3Pd+L3
umMMsxosYV406G5jMP/pfeJLTMFV3kwHfdaDwVtFayS7VrRY/Jta3wqWe/qN
M/CfmBd6T/0hn/7KWq13+buQemDPHCbvQ3hfJXYX7OQtRR/t1XmLqC22uU3P
kC/usQfDmau3Zm32MPeQZYbia3/H5X8k829i/2bW7fN5x2xKey9/ID92BpsZ
zLq+Pu+YG718duRqzQt2p4m5FGyWfh7be2qkx5VeIbb4tCFjfvVU3/cosD4j
NkVez1v9/kiv0yKPHW/q1f6u3sCbQVSVsnwXXpk1wbCPWqIXmT3ULX1DrVAP
w/29dQXv4amHBo8jMSxwPGLPW6bF3wzZjGETuDRI6+Dkak2Ve10xE875+4S3
HbWCT7/rblHG3iq8QdAJ/mxzGeJToHhcIxqctr4gxvQvNnAGRi2Vj8scA3do
fT/YzEBmr+vkfXHK337YNcbnHXkY7Xby5qZGyXsl72XRwpThabHXVY3srfJz
3hbt/i4udtwlVsSN/qRuC9OGVeBZmeMsNvN/Zgt3F6o2F2Uds1L2FieexLfZ
+RZ/Q+LL/9bEyQQ=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlltsVVUQhnfbs885e+0jokIKXqK+KGBC1HgjmkC8laiBgA9qojWCBQWl
hiJeC1QMQqW0SEDAFpA7Eoqo+KC0tFxiDIUYRaEgXvBCoxhrUUPrJX5/fh8m
mVn/rFlrz5r5Z18+oXL8tOIoilYiGWRKEkW7clE0PI6i6pIoWoE+EzkJuAq7
Mx9FV+JzJ3qDcOy3Ajr4bOxl2Cux52W8/7k0ip5GFhRFUQ0xq9h7SPHA5pUY
ewaZE9tnDHvHIuezfzX3qUVfhMzCnsJFT+P7CzIOuxm8EWwNsgD7KfCFxK9L
fNepxFsHthGpA58O/gRYC+d/XOL7DuS+neC7wXfg3w1+H/Hv5z4nsO8Guwfp
B97AeV+A78HegL2YeOXYx5HviXUr/g3oi5G12DOwJxPrcWQ68Wqw+8Aewi7H
7sJuxd6NHMC/inhHg2MqVitnvIvvTu57HXobe4aBNbPWgj6aPVehD0udmwrs
H8FvIsZI/O/F50X29mftWrAfWCsCuwO5S/mM/bbF2NmM3/hN9F5ycin+tdi9
7B3FWhn6w/gfA5uR+O32s7YerFCIoqFZco/9K9gtrN2G/gD+G4JrRLnWGxxG
P8JaS8Y5b8PuwN6Gvh2ZhF6BbOX7R7DnBb09Uo08j/zDfZfwva8Tezz+daxN
zfvbVSOrg2tQtaeauBm7Hf+Dse8k3yWs1WS8J48+Wm+M/SQ+S8HHJMbkswJs
OWuV5PeGEt+lEpn2/53Ocp+5qu/YNVnG2pfYP8WOORL7AHZn7Bzejv0p9lex
32BSzt+ob6tAb9N+ZJ9yi1zN2bvw/yi2fQjsYHAtKmf70DvYtxF9E7II3wZk
Kf7LyGEj+ipkHXYT9mupfYQtY21Nah9h67HfR38H2YPdjt2T+E31lmf5/pfA
ZukM8PmsxcE1pVrKcX4IzqlyGZTv1D2g2q9i7e/ENaVaKgLfEtwDqv167K7E
Naza7ea8T/i2nanvspcYZ9AXp757oOaGJuYkcVEZsh1sm/yL3CPSdyCtsddK
gntUvama/1B8l7he9MbtwTlXrtXjysV7qXtPORmM73qdEbtGN+F/LvU/LOtv
WI6dYg/JOt5R/A+r/4j1LWcMBh+ENLP/ooxzOQd5JXZOz0vcE+oF9ewj6L+D
F4jXwZt3gm9hbQT2d+B/gv2hNy6yz2Po3yA9sTmnHN9xwb2SA+/BPpM3121E
hotLEnOnOF9cM5H7n86ac44lPlNnieM+AG8i3vyMOWIE+nHWHiTWKNYWBnO2
+Kgae2DwN+jupRlzy+bgt9b+N4JzplxpZmwNzqlyqZkyIPgbdPeBmkHBnK/7
6g6aJUMSv71myoGce0K98DV2a86cL/4Rx16RmEPFnZphc9FfTsz1+ga9bZp3
bvTGtWCvJubqiUip7OBvEx805syx4lZxvri9K+fZI47vr/oInmWaIZotJ3OO
pRnzKLmeUHAtKOcXB3OquPQy5ALNwuBZp5mo2XVhYm7UDOsj3urUvTuA/aXo
g5Dri10T5xQ8AzX7xNHizn9zfgtxqGppP/jmjGtK3JUJ7mVxmLjrt8S9Lw5b
gn998LfrjevBu5Fs1pwjLuzN+a3EiZM5/0ji2tcZoeAcar96RHtrUnOJYvQr
uMZUG+op1XISzCWq6Z+xn039LxGBn9LsS80tfcjs1D7C1FOq7bXBs0w105Sa
Q8Qd4kT15ueJa0U9OjN1TMXSP4lm1Wd5z2LNrBPBM1CzTxy9N/ifQP8C4uC3
U3OWuEqcc2Mwp4tPNJM1i04l5jbNJHHBJcFvLU7QbPgrMTdqRoj7r8m7tzQD
/gNLFFfS
         "],
         VertexColors->None], 
        PolygonBox[{{2689, 2186, 2185, 2687, 1144}, {2671, 2192, 1144, 2688, 
         2670}, {2667, 2197, 1153, 2708, 2666}, {1971, 2705, 1152, 2704, 
         1970}, {2186, 2694, 1146, 2693, 2185}, {2678, 2193, 1145, 2691, 
         2677}, {2196, 2667, 2666, 2706, 1152}, {2194, 2678, 2677, 2695, 
         1146}, {2692, 1971, 1970, 2690, 1145}},
         VertexColors->None]}]}, 
     {RGBColor[0.7720281052631627, 0.850131684210528, 0.9098211052631557], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2QlmUVx+/n9X55toBkTWBZCmWGshzrg5mJ00zQsIqgwI4zJktiJrWM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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtln2QlXMUx5+7d++9z/Pcq1fbC1sh/UEKf0gowyjT6/ZCY4ZNLNXSajEl
Yw12RSVssWyrmrENbQa9eZloqRjRKoaYUk0iY4oa1dZSCZ+v7/3jzHPO7/x+
53fO+Z3zPc/5ZZXjpxcEQdAIFUKvZIJgFrQf4dVkEEwPg+B0Ngi6pIPghkQQ
NKB7LgqCpegeZP8z8HOhxchLoCm5INiB3Mb+E9D6OAiaoU3oijm/Ht2H0Gbk
z6FvsTcTeQ78r9CT8NVQPfwi6CrsDYbKsbUFR99FtxbamLTNsdg+jH8J9MXo
X4J/GWpIBcEG/FuC/YXsb2RvNfLz8LWRY6vAn4Pwv+XvG4r+AGfbY7M98Z/G
xjXE34r+JPohrHVBX8ja6+iKoFXoVkMPoy/n/jp0CzlfjDwNeTS6ksi84v8Y
fzYgt6A/D/lG5YIzZfg/ibXe2L8Quh/+ds5swtYn0D7k7ewfyP6P2D+B/RNY
a0S3DPoC/v2Ec7ebO/5IOqYW+BHYG4avC7D3LPoDGT+23vBL+O9Z2ws/mPM1
8HtYO5Y/fwb+PvIf8q1Hfyn6yyL7lkZexvoc6D3kBHc0wfdBP4SzPZBXIN+G
f5O4rydyBb4cY60j8kzkXeieIJ4Z7N/I2k7k7cgt2HuAtf7sb2Z/r4RjlG3Z
lC3dMQr91xnXZi/Od836jfQ2XaAs9u5CzqHLFrq2r4ycO9X4IfTzI9fubuSD
yLMj194O5L3Ij0Kz4DdD7eBHQSXwM7D/Ir6+k6/Hx1nbpfxH9r2OGP7ivgry
l1Id4uOpyHfqLr1BZ/iOUA22OiN3iH2HbP9fg/heyR1d0+7BNuTjUD9sn4Vc
B/8vthenXPN6q3Gc71PgNxuJvgdUnHYN5NCNw97xlHOiXlyE/FShe3IK+nNZ
m8j5ikLHdjHnL0k5xkb4NPtXIC+HjsAfhdYR22vQcM6PiJ3rGkL8FL4Un95K
u4a/Y+8PrF2X9BvXY6+MtXZpxyAs+Rm//0waU+Yh/4J8Ki/fi9wcGTtUEzsj
Y46wRjW8jb2TkVuRr00498IIYYPeoBbqlnVt7MG/I5HfXG+tO/XWa/DnzUK/
eXf0TdA6dAOh3yNjgrBAPZJSPrKu/fncdxH8Gvbcw319WduGfBibB9HtQi6F
vxUaXuCemAvfFhovqpCrkReExhJhSjF879i9qxyr14ZGxgr13FfotkJr4Vdy
vh/xNnPmZuK/Ke1cfBa7FpWTlaExV1i7lLUrpGftTnR3QGPwt0T4KewS/uWM
wcLeqegncvfVOfPCqBZs1+b9Vc7eVizo52oesDae/eMiY99g1krhs6FzWQlN
Rv4g41wpXuWinLWqpHMivlPos1r7G99+RB6bcE8cC21TtrprXuDP5aGxUhhY
HRpjhC3ToJLYGC9sH4t8NGNMEhaNQR6J/ifk1pR7/AXOPx3bN71pr9g1r1q/
AP3+jGtUtakZoVrdmvVbq2Y1277JOJeacWdz/mQeC9SjRcj/5LFVPS1svAX7
RQXGyCT6gtizVjPsjOo1k59dUN+sZ4zyqx5VbvaFzr1ypF4+J/KsUU+rNufF
rjXFE7O3NjZ2KSb14jJsNqXck4fgO8XGJs3YnrztqtC1ozcWtvTMGuuFMQ+h
uzt2rlXjwrYxsXMtjBMWbM141ggTZqNbGNoXvfcbyCtizzLNyHbolmN/NWeb
sbFFsy72rFaNTs2559Xr+ueoRPdYHq9Vk5qV6gn1gmamZq1qXrWumTso5ztk
W/8Y15OfbbF7qZT7izT/Q9eWMKsj+g6R/yXUcwM4Pyzyv4Z6qCF2TpVLYWp/
9IMiY6F6sizyDNXs1MyrYv+UjGeLfBY2j45di8LoR4i9LWNsUU2kQmOwsFdv
JGyaHBurhVHC5nJoQEEeo/U/E3o2KoeqbcWo2FTj+pc5kfUs0T+N/q26ha5t
4f1/jO1OHg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8284107368421129, 0.8689337894736867, 0.8845617368421018], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuw1VUVx3/3nnN+53fO70wRzTBMAg4iV3OES5mCcK/yUMB7kQDHAHmo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslVUQhr97e2+/7RoJ/iFQaMoiaqCAiEBpG0AgUEAWYywIqGURNJao
qEiCW3ELUVRAtmgFBQSBVlMWFTWCuBAVDfpDwxYJIYBiGgjigvi8ef0xuTPf
vGdmzpz3zLlldXMn1meDIHgNySGfJ0HwBXKiKAhqMkHQJQ2CzkjXfBB0Q9ZF
QXAgDoKf8L/Ogg/BTsCejd2IvQjsX2EQvAB2MbIafQn+RvwPEn8C/oOhY4/D
Pw77e+yR2GOw78M+j/0o+iPIIOw3ydmrOAgGYE/EPky8k8TrTb6z5P8NOYx+
BFmAv4H1a8nVAP4t1YLsYpNtsO8tBMFY8AXsy8TcC/4E/pnk/w5/PbnGEX8W
8auyrmUv31qyrulW1t+G3QD+FdafxT+dGPX4FvKthbXbkQbwLdjX4nsfTAf0
T4rcmztYf03WPcrjvxC61gA5F7oH2vt85G+w67Gb0LsDeQe7hBqqyb2GGNX4
qpBn0RcQ/1LsnqgXWWQ0vhqkkvwlxBiLPh7M3Tpf7J1gdyDDWL8KfDW+PeSY
TPxJYDZST6fUa0+S/0X8p0LH1pnuAFtGPePRNygG/tVIZZFjDkP/DMw04k3j
W0quGmRszj3bo/oj9/5bpK/WimN5x6wkdhUyi/WbMu7t7sRcU4+nYndNzc0C
/m2s7Qh+cLE5tY5ai1P3tpmfp/D3Zs0YYpeC+Qbf18iMjDmk3KpJtaiGH9F/
QB7Cfwy7ibUfkf8NsB8TozU0p8QlcUJcGwWmrsic643vU2JOwl+LFBJzRlwR
Bxeh3xS7N+LYRfx/Ir/nzMkK9C+RzdhDkM7E6oHdC71Pzlw9oJx5c7YO+wkw
U7Le40zs5ti1ioP7wFamvks9M671Zb71z7rm+eJGbC4tRn4Bezw1F5fSv2aw
PfGPxrcTWYbvVWQ1/pXEq8efx38dvqXIQHxzsXvg6wemU8EcFneH0I/D4ib+
WrBn8I9AHx77rHaCOcNeTyfm1s/sN8/adawpx24k5i7ytSFmj2LvrwPYKyNz
ZTmYh8Vlvk1j7Z3I49h12LPR70E6YLci7ch/dc7caYpcmzg0kVpKkRFZz7g2
+N4mf3v0zRnHeoxvc3KOuSb2jNRs3KyeE28LdhWxKpF51NsPzC34NhGzlPXt
Is8K1VCC3plv3VjfHRmOfTA19+bRk1GJe6Ze6Q4tJF5V7LvaRLyFmhey0WuR
KeBvT3x31YMn8c9I3AtxRLN8QOqz0Uz/SlwDU1Fszh2KPTM0K/QmjEndY/VW
nLtCveZbC3pHzQTs7Ylnic5kP/V1SbwXzaDp2m/sWaaeNYMfn/otGAr+afRn
Ur8d74HZD/5dMGv/n2+6e0si67qD/4hfkWd1jm8vkW8yPW8k1hHdd3KdRlrx
TSV/+8Q1q9aSnLGzI3NJa8pjc0TcEMfnoG8L3UvdEc1G3WndZc3Iy+S/n2+D
s56puptl2B/kfUe3RuaAzl4ze0VoDujsdcf1tm2IfZf0xqn3N6d+C3UGesv0
5uit0ZsmLh2LvFdxSmddpjc67zMXd8RpcVkcasU3Esxd4KNiv+WagZp9etOX
hb6zuqu/gj+Ofg780Yxn4g3k7lvwWUxRfazfmJr7OvNC5J6ql3qjLqD/kTiW
enIJ/d/E3NQM3Uv8itSzSzPhDLkOhT4b5bwY+U7rLutNWwH2cujZojuv2fJA
6FmgGbM89R61N82gPtQ6NPas0sxdqdlPzFUZv7nnI3NOXNMdPhV7xmq2iiNH
sY/Eno36j3Ej8fZFnkXqod6y6wvuhd60cvTd4kjWM+w5Yj2f+K3fSoxOxFof
ehboTRwEvqLgt0pvWgX+gbHv9pasudMz8X8bcUizYn5on2aGZlHbyLE1kwZg
94/930o1tGW/V6X+r6M9/we0pDbu
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8847933684210632, 0.8877358947368456, 0.8593023684210479], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG+Ql1UVx5/9/f9HWVE4vmBZIA0FIjBoSbAJFpZWSJlmNyAD3CkrJnbS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllltsVVUQhve5cfY+50QJRmt8QApeAkgNLbG2CBrtBVS0rUmbgNpiY1BJ
KFZj5KEkYmmi0RiMYkUN1BahRhSovWEskXrHS00pomgV1MRA5AUq9QL6/fkf
Jlmz/pl/1p41M2vn39dUsyYeBMGzSBJpTQdBbS4IXpwSBJ3oFazLkUnWTeyt
yQbBL8hEKgguwPFkJgia8akA/w6Co2EQNETsJYJgEzIVfQf2e7HvQdaiV4Fv
xvdGpBy9BL0W24mYYw+z1xrzGT6Eexz8d/Bi/FeAb2LvG+J1gF+Lvh/7PXAt
x+YdsHzi9bE+j83nYCOccQ9na8Q+h74dPB98BzFehrsd2YnejdTBV4/N82Dt
2D8GNgpnFbGfAr8J/S7wOPFWoI+gL4KvFPx79D+J9TD4ZfieJGY72NP4H+As
r2IzCD6AlON/GPshbG8Lffbd7L2JfXfWZ1PO5nOeD8B7wO7Bph/fXqQFfQv8
leBLcr6bRvaKsL0C/Vb0w3B0Efsi+C5MOWf61kexuTvpb16HXpxzbnTHD7Ce
B//7+J5lbyZ6P/ZLWS9BqtEfh/N+bNvQ10a+I93Nk/C9gr4d/VfwJzhPDbHH
0JfBV43NXPyvQe7E9zh7LXB34dOb8J19lDanuEqwL2T9LjaV8N3B3mrw+ewt
Y90J/zS4OsBf43sK4LwYfYjzv45+AJkB9hX2R7AvQO9BLwzN1YX/cc53c+Tc
qqab8a8B30y8vLTvTjWhWtAdjsL9NfgAXP3IbvA38G+DK873TIMvCH3Xyvli
9FXghTHXSB7+EXhnzDVQyjof/gr4x9lbB99C7Os4zy7wDtZzMz67fBZgW4j0
qR7wGYN/NOveOQb/KdaV+DTgHwdvZv0pnGVgGxPO9dvo5wLn/FjonlWvppBS
8H3oZ2LuydPEPpNxravH6uFvQFbCt0o5wnYMfFC5jbk3lEPlTj2yENsbsr5L
5Wgftm2ha1V3dgK790J/ayM2I6FzrNyKM0/1jf9zqu0p7uWD2OxNuqd/4Lyf
sNed9EypVD7Us3F/cwv858EnwFtV3+grwR/hexLI5fD3wlcOdxnyE9iPkWtV
M+djxUPeSjrGHMUOXXtH4z7bUuU85TOeTntGajZqhinWQ2nnVjHrI3PIVzPy
ENy17M2OuaZ2Ybsz61n5N+fdFrrGVduq6f3YX5JzLjrR/8D+UNZ3vzrls2pm
aVbpzOL+Evk24RgF4KXYX4fthrh7Uz2vXlePDoMtIubPrJennOvx0LlSzjdm
XWOqrWfA/8t6pmuWa+Y1wr9e8wy9OOFZ05fxrNLMGUS/kni3Y1sXuNY0UzRL
VHOzIteUamkIaYW/LetYmskzQ3+Dzq4ZdSZ0zpSrrez9g35p5Nia8eew/Vc1
nHQNlIHdEvltUw8JUw6VO9l0hZ7pmuUdSc8e1YhqQzNIs0R3oNxrpryA79mM
Z73ewJfQ/0I/lfSMHEZvwmdDwjnfCt9U+KYnPMMfDP2m6S1TT96bdU+oF9Rj
R1QrGc8y1bR6uyjn3lePf5Z2j6u3VYMFrOdFnkW6g+mst0R+2zST5+A7O+fe
1QweCD3jNdv1ZlzN+qqcZ7Pu6At8D0Z+q1RDs8AWRL47vQlFkWeYZpdqRrNr
fdpvmWbYYr2PkXtPb1gJ33d91m+DcjLJt/2Wdq0pZ31wncj4X0IzcTL0negu
lLMZOb9xetvUs3oLmtKe5XoTquGuyroW9Gb/D4UaMbk=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlslvllUUxu/3tbx9v0GgJtowiuJABzCCCWBdiKFCIViohihJBVmBRFGC
ChvKSiCR/gNuZGEgrlAxgq2wMCRUBkmQRCGalgbs4IKPYe/z63kaXZzc6Zxz
z/Sce5/cvrv7g2JKaUYhpTqNXVqcF93VvClPaWEppVd1UMtS+oYxxTl78FzT
+ZpKSn9qfUX7w6Im6erVeMvz0+WUzoi+qBeP+BdI74D2d9WFri7r67DOv8V3
R3RI83fFv6MhpUUp7vhHvH3FOIevoPmo5/DPlN6T4itp3CS5jaKd2m8TvSxq
T6EDXe3i+bk+5ujslB9rRa9NS6mnPuw9UAyZ9aJ1okNZ6EUnupnv0Hyb5LaK
tkt2i8/e1tjqO18SfSzZLu3v1bhB4+ui5hRr5i0pxi7vt1huZYrYn3T8Lziu
szTfLd4XFKMV8GlvhfcbNS4TPdS8T/qPZhGry+LdXIrYw7NENEM8ozpbrvls
zfuVn3HpfV/rDtHqQpyhr9H8xKmpGrGap/UD0XzRKp3f11h2LsqFsLlQCJ7p
njd6XdJdTWKeVR+248Nt7X8u+07Vha93RTVRayFqivmQaKIYuSSPI6436q5V
+o6VImZDlkfnuOfoqXnO+Wr7ic3YsMrzDsez7Bx04neKWCBTSZGHlY55x7Sw
qd1yHY7b19rrli1vpaiXbtfMUvn+nei6eG5K9k3qW/PLWYzwPKsYPyfakEVN
sUdddUtuj/ZnSPe5cuAKTJG3dyqRuxs6+0N0SfN7WWAYGw9q7M3iXmwfcnxu
OR749Jf0XxT9pPVXxeDFd+58I497sXHCdmI7frK+Knt+sWyz+FtEG3Xfoxq/
zCNH8LOHzGfa+7EcvYPa/K0c9UnM8PuE9g9ngb1Pddfj1fAZf8H9Ztc2+Nzi
+GyS7HH6USHyxh7x/1Z3teQRk3Man6+G/HrNz+ah53o5eh89CTl8QvYp8Z7O
Q+97DdGb6EvEEgyvNMY/yUI/OGYNltljDk6lJs0VzRHdlL7hPHKFXVtLIbvC
tTPLPWCd66/fOV3ku/ZaJ7roKeCXGhx3nVd8Ntu9ZYP7zCMpcIsdB9yD6ZmD
WejHZsYbvou7h10DJxxXYvK9bH6iGjUCXj/M4h14YP3gvVII/fT2gWL4sMh3
t7lHwrvYa3INRsh3Bz2mGnq73DOn+mez/ZpjHS3uQw/di+iX9BX8uqacXs3j
vUE/GNvhWIEJetSI3xbiRl9jHyxPYRJMEZNB53eqtiZxnUW9Us9bnC/ejEmM
uW+g47D1LLbP883X7vcJjCO/03VH/U1hvtN6L4hnTylsu+M3cJ/z1e/cHfFd
4IVYHra/pxSDpaXIF3Fs+d/7Qn8AU+CW/kuujhp3+5yXI7afd46eRWzGivF+
9LvPUR/EpKsu7sH3Qdf/JesfcA3QS14pRT/p8XtLvtYq52tEH2XRu8gHtq0z
HohXu+T2N4SP1MMc10Cra2IKYxVjbq/7HnghfoMNEcO5PgcTvDdX3AMb/X5S
U2O2GTz+mkc9nXdf7DX2t5UCzzccvwuWmWfd041fapYcLdel+0vBi46Dtu2U
/1LIPyOeM3nElPgNup+0ab+1GnXH+7+rIWQ7nU9iRN6oI3IHRsk9+Xha82V5
5Kfbfxh42xwz7L1IHypFPgZsC74vd0/BB7DVY3y1O+7oWOX+dds13WZsT/gt
pDa2u3aopT6/461+i3iTmvymL87+O58wD3tLvY8fC6rhy03l5Pc8/nQvyvaF
1XgH+IPQD2u2f9S+4NeY65ZeMdN/lWN5vFW9vn/E/wpqcdj1QT7QPew/DrK6
cvJtwBZqfnLP++O2v+Z52fHhvGKemv8w+HjXPRyeyf6UhSwx4+2c8F9oxPxl
/7tuO/dTOCgYw9QAY597wg95vGfYu8S1zr/skP+K8NCzK/Zh2DEgLzVjcsA9
8LgxDkbv+Y/B34F/AFif/A/aR+qJtx3dZ3X+WDVyOepckJf7riF8eSCe++X4
4/e7z1B7BxoC/9j5L+6bgjc=
         "],
         VertexColors->None], 
        PolygonBox[{{3112, 3116, 1617, 682}, {2910, 2912, 1378, 365}, {3119, 
         2123, 513, 1622}, {2802, 2239, 1622, 1255}, {2080, 2603, 945, 444}, {
         3111, 3109, 680, 1613}, {2250, 3127, 908, 701}, {2358, 3113, 1616, 
         852}, {2745, 2507, 638, 1179}, {2227, 3150, 1664, 469}, {2214, 2779, 
         1219, 654}, {3154, 2235, 365, 1673}, {2399, 2400, 730, 460}, {1896, 
         2270, 701, 40}, {3089, 2750, 1586, 1581}, {2368, 2367, 135, 527}, {
         2803, 2802, 1255, 1256}, {2208, 3089, 1581, 639}, {3147, 2226, 460, 
         1654}, {2465, 2464, 944, 945}, {3156, 1918, 119, 1678}, {3114, 3112, 
         682, 1616}, {3095, 3094, 444, 1350}, {2233, 2356, 849, 680}, {1993, 
         2889, 1350, 315}, {1899, 3147, 1654, 56}, {2165, 2744, 1179, 1117}, {
         2367, 2804, 1256, 135}, {3022, 2358, 852, 1499}, {2508, 2509, 875, 
         638}, {1913, 3154, 1673, 119}, {3143, 2182, 737, 1649}, {2887, 1992, 
         315, 989}, {2238, 3156, 1678, 513}, {2583, 2165, 1117, 1049}, {2232, 
         3108, 847, 679}, {3142, 3140, 718, 1648}, {3150, 1903, 56, 1664}, {
         3093, 2214, 654, 1586}, {1964, 3141, 1648, 948}, {2746, 2209, 639, 
         737}, {3104, 2229, 677, 847}, {3107, 2231, 679, 849}, {2264, 2515, 
         989, 1219}, {2772, 2255, 709, 875}, {3115, 2110, 850, 1617}, {2339, 
         2083, 837, 834}, {2273, 1898, 40, 730}, {2354, 2098, 469, 677}, {
         2256, 2773, 834, 709}, {2110, 3110, 1613, 850}, {2464, 2057, 1049, 
         944}, {2425, 1964, 948, 908}, {3140, 3144, 1649, 718}, {2911, 3022, 
         1499, 1378}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2083, 2339, 2071, 2773, 2256, 2771, 2255, 2772, 2390, 2509, 
         2508, 2507, 2745, 2744, 2165, 2583, 2057, 2464, 2465, 2603, 2080, 
         2510, 2751, 3094, 3095, 2888, 2889, 1993, 2418, 1992, 2887, 2515, 
         2264, 2779, 2214, 3093, 2750, 3089, 2208, 3090, 2209, 2746, 2182, 
         3143, 3144, 3140, 3142, 3141, 1964, 2425, 3127, 2250, 2768, 2251, 
         2270, 1896, 2401, 1898, 2273, 2267, 2400, 2399, 2090, 2226, 3147, 
         1899, 2353, 1903, 3150, 2227, 2098, 2354, 2228, 3103, 2229, 3104, 
         2099, 3108, 2232, 3106, 2231, 3107, 2356, 2233, 3109, 3111, 3110, 
         2110, 3115, 3116, 3112, 3114, 3113, 2358, 3022, 2911, 2912, 2910, 
         2026, 2235, 3154, 1913, 2363, 1918, 3156, 2238, 2123, 3119, 2239, 
         2802, 2803, 2804, 2367, 2368, 2131, 3186, 2130}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1967, 2849, 2469, 2173, 2468, 1966, 2153, 3163, 1937, 2377, 
         1933, 1956, 2835, 2834, 2048, 2968, 1930, 3159, 2143, 2042, 2948, 
         2950, 2949, 3054, 2375, 3123, 3124, 3122, 2244, 2372, 2371, 1924, 
         3158, 2243, 2036, 2925, 2035, 2926, 3043, 3042, 2370, 3121, 2241, 
         3120, 2242, 2366, 2365, 1917, 2814, 2813, 2812, 2029, 3028, 3029, 
         3027, 2117, 2361, 2362, 2234, 3153, 1912, 2357, 1908, 1943, 2809, 
         2808, 2021, 3011, 2109, 3010, 2108, 2355, 2106, 3105, 2230, 2794, 
         2795, 1906, 2309, 1902, 1940, 2807, 2806, 2161, 3071, 2160, 2384, 
         2893, 2524, 2759, 2758, 2763, 2422, 2003, 2897, 2896, 2224, 2292, 
         1965, 2984, 2064, 2983, 2986, 2985, 2061, 2586, 2060, 2981, 2299, 
         2328, 2659, 2174, 2658, 2175, 2350, 2349, 1968, 2470, 2211, 2875, 
         2876, 1989, 2416, 1988, 2526, 2527, 2525, 2898, 2005, 3176, 2605, 
         2081, 2604, 2082, 2606, 2874, 1987, 2415, 2873, 2872, 2511, 2210, 
         2459, 1957, 2334, 2458, 2457, 2456, 2164, 2742, 2743, 2741, 2207, 
         3088, 1976, 2296, 2212, 2512, 2877, 2878, 2407, 2424}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1936, 3162, 2152, 2054, 2977, 2053, 2978, 2146, 2967, 2047, 
         2964, 2966, 2965, 3057, 2376, 3126, 2245, 3125, 2246, 2374, 2373, 
         1927, 1954, 2822, 2821, 2038, 2938, 1923, 3157, 2135, 2034, 2924, 
         2033, 3179, 2637, 2129, 2572, 2030, 2915, 2571, 2634, 2633, 3037, 
         2364, 3118, 2236, 3117, 2237, 2360, 2359, 1911, 1946, 2447, 2446, 
         2025, 2557, 2798, 2797, 3021, 3020, 2020, 2441, 2019, 2547, 2107, 
         2539, 2012, 2434, 2538, 2537, 2618, 2760, 2761, 2218, 2894, 2895, 
         2001, 2421, 2002, 2222, 3101, 2223, 3102, 2219, 3100, 2221, 3099, 
         2220, 2272, 2271, 3068, 2159, 3067, 2158, 2383, 1999, 2892, 2587, 
         2063, 2982, 2062, 3132, 3133, 3129, 3131, 3130, 2397, 2852, 2851, 
         2850, 2178, 2352, 2351, 2402, 2176, 2778, 2177, 2660, 2166, 2650, 
         2652, 2651, 1960, 2341, 1959, 2846, 2845, 2891, 2890, 1994, 2595, 
         2076, 2594, 2075, 2289, 2288, 2591, 2072, 2482, 2484, 2485, 2748, 
         2747, 2385, 2386, 2335, 2066, 2408, 2294, 2696, 2697, 2481, 2857, 
         1977, 2405, 2480, 2479, 2749, 2191, 2762, 2225, 2684, 2782}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1935, 2840, 2839, 2838, 2052, 3061, 3062, 3060, 2145, 2581, 
         2046, 2963, 2045, 3181, 2641, 2142, 2580, 2041, 2947, 2040, 3180, 
         2640, 3053, 3052, 2578, 2579, 2577, 2639, 2638, 3048, 2575, 2576, 
         2574, 2636, 2635, 3041, 2369, 2765, 2766, 2764, 2240, 2321, 2320, 
         1916, 1948, 2449, 2448, 2563, 2562, 1910, 1945, 2445, 2444, 2024, 
         2909, 2554, 2796, 2443, 2442, 2440, 2018, 2903, 2544, 2793, 2436, 
         2435, 2433, 2011, 2617, 2097, 3004, 2096, 2753, 2754, 2518, 2755, 
         3164, 1996, 2756, 1995, 2517, 2516, 2520, 3174, 2519, 3175, 1997, 
         3173, 2757, 2217, 2521, 2522, 2523, 2398, 2776, 2259, 2775, 2260, 
         2777, 2069, 2291, 2290, 2396, 2059, 2980, 2329, 2471, 2661, 2662, 
         2331, 2330, 1981, 2412, 1982, 2495, 2494, 2729, 2728, 2297, 2721, 
         2722, 2493, 2862, 1980, 2410, 2492, 2491, 2490, 2200, 2713, 2058, 
         2703, 2195, 2483, 2858, 2859, 2381, 2382, 2197, 2667, 2196, 2705, 
         1971, 2692, 2193, 2678, 2194, 2694, 2186, 2689, 2192, 2671, 2686, 
         2683, 1894}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1893, 2682, 2685, 2670, 2688, 2687, 2185, 2693, 2695, 2677, 
         2691, 2690, 1970, 2704, 2706, 2666, 2708, 2707, 2155, 2701, 2702, 
         2698, 2700, 2699, 2327, 3082, 3083, 2712, 2715, 2714, 2198, 2719, 
         2720, 2716, 2718, 2717, 1978, 3086, 3087, 2727, 2731, 2730, 2201, 
         2725, 2726, 2723, 3085, 3084, 2724, 2588, 2589, 2584, 2585, 3170, 
         3172, 3171, 1973, 2995, 2996, 2994, 2998, 2997, 2000, 2992, 2993, 
         2989, 2991, 2990, 2346, 2342, 2343, 2265, 2345, 2344, 1998, 2419, 
         2420, 2266, 2781, 2780, 2752, 2615, 3149, 2616, 2534, 2536, 3187, 
         2535, 3009, 2619, 2620, 2543, 2546, 2545, 3019, 2623, 2624, 2553, 
         2556, 2555, 3026, 2628, 2629, 2561, 2565, 2564, 3036, 2631, 2632, 
         2568, 2570, 2569, 3040, 2920, 2921, 2919, 2923, 2922, 3047, 2934, 
         2935, 2933, 2937, 2936, 3051, 2943, 2944, 2942, 2946, 2945, 3056, 
         2959, 2960, 2958, 2962, 2961, 3059, 2973, 2974, 2972, 2976, 2975, 
         3066}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2151, 2971, 2051, 2970, 2050, 2144, 3160, 1932, 2833, 2832, 
         2831, 2044, 2957, 1929, 2827, 2826, 2825, 2039, 2941, 1926, 1953, 
         2820, 2819, 2932, 2931, 1922, 1951, 2818, 2817, 2918, 2917, 1921, 
         1950, 2127, 3039, 2128, 2319, 2318, 2630, 2559, 2560, 2558, 2627, 
         2626, 3025, 2551, 2552, 2550, 2908, 2023, 3178, 2622, 2113, 2542, 
         2017, 2438, 2016, 2541, 2105, 2533, 2010, 2430, 2009, 2787, 3185, 
         2095, 3003, 2647, 3069, 3070, 2646, 2664, 2663, 2854, 2856, 2855, 
         2853, 2261, 3139, 2179, 3098, 2216, 3096, 2215, 3097, 2300, 2301, 
         2213, 2882, 2883, 2884, 2417, 2881, 2880, 2879, 2263, 3145, 2068, 
         2287, 2286, 2427, 2055, 2326, 2085, 2607, 2609, 2608, 2275, 2411, 
         2006, 2303, 2486, 2710, 2711, 2488, 2489, 1979, 2409, 2861, 2860, 
         2487, 2199, 2709, 2269, 2645, 2157, 2473, 2156, 2644, 2379, 2380, 
         2181, 2665, 2180, 2668, 1969, 3081, 2189, 2676, 2190, 2681, 2184, 
         2675, 2187, 2669, 2673, 2672, 2732}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2150, 3063, 3065, 3064, 2837, 2836, 2049, 2969, 1931, 2830, 
         2829, 2828, 2956, 2955, 1928, 1955, 2140, 3055, 2141, 2325, 2324, 
         3050, 2929, 2930, 2927, 2037, 2928, 2134, 3044, 3046, 3045, 2454, 
         2453, 2032, 2573, 2805, 2452, 2451, 2450, 2567, 2566, 1915, 1947, 
         2121, 3035, 2122, 2313, 2312, 2625, 2548, 2549, 2907, 2906, 2022, 
         3177, 2621, 2112, 3016, 3018, 3017, 2439, 2437, 2015, 2540, 2792, 
         2432, 2431, 2429, 2532, 2531, 1901, 1939, 3002, 2093, 2613, 2094, 
         3078, 3079, 3075, 3077, 3076, 3080, 2183, 2654, 2167, 2653, 2168, 
         2770, 2253, 2769, 2252, 2285, 2284, 2426, 2171, 2395, 2467, 1963, 
         2393, 2394, 2172, 2657, 3074, 3073, 2302, 2340, 1958, 2844, 2843, 
         2869, 2868, 2871, 2870, 2593, 2074, 2592, 2073, 2298, 2004, 2590, 
         2067, 2474, 2599, 2600, 2602, 2601, 1972, 2472, 2333, 2065, 2403, 
         2293, 2679, 2680, 2477, 2478, 1974, 2404, 2476, 2475, 2734, 2188, 
         2733, 2203, 2674, 2202}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1983, 2406, 2500, 2499, 2498, 2204, 2295, 1975, 2738, 2205, 
         2737, 2740, 2739, 2163, 2455, 2841, 2842, 2332, 2336, 2337, 2262, 
         2502, 2503, 2504, 2413, 1984, 2865, 2598, 2079, 2988, 2078, 3183, 
         3184, 3182, 2597, 2979, 2463, 2506, 2505, 1985, 2414, 1986, 2867, 
         2866, 2206, 2466, 1962, 2391, 2392, 2258, 2774, 2257, 3128, 1938, 
         1895, 2305, 2306, 2388, 2387, 2277, 2612, 2089, 2610, 2088, 2611, 
         3165, 2007, 2899, 2528, 2530, 2529, 2614, 2308, 1905, 2789, 2788, 
         2103, 3007, 2280, 2281, 2791, 2790, 2104, 3008, 2014, 2900, 2902, 
         2901, 3015, 2310, 1909, 3152, 2116, 2282, 1944, 2801, 2800, 2799, 
         3024, 3023, 2027, 2913, 2028, 2914, 3034, 3033, 2316, 2317, 2126, 
         3038, 2125, 1949, 1920, 2916, 2031, 2815, 2816, 2133, 3168, 2132, 
         2322, 2323, 2137, 3049, 2136, 1952, 1925, 2939, 2940, 2823, 2824, 
         2139, 3169, 2138, 2952, 2043, 2951, 2954, 2953, 3058, 2268, 1934, 
         3161, 2147, 2148, 2642, 2149, 2643, 2649, 2648}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1919, 2124, 2315, 2314, 3031, 2119, 3030, 2120, 3032, 2283, 
         2118, 3155, 1914, 2311, 2114, 3167, 2115, 2811, 2810, 2905, 2904, 
         1907, 1942, 2111, 3012, 3014, 3013, 2013, 2102, 3151, 1904, 1941, 
         2100, 3005, 2101, 3006, 2008, 3001, 2092, 2785, 2786, 2279, 2278, 
         2091, 3148, 1900, 2307, 2086, 3166, 2087, 2276, 2999, 3000, 2783, 
         2784, 1897, 2304, 2347, 2348, 2254, 2461, 2847, 2848, 2428, 1961, 
         3135, 3136, 3134, 3138, 3137, 2084, 2378, 2154, 2423, 2248, 2249, 
         2274, 2767, 2247, 2513, 2514, 1990, 3146, 1991, 2886, 2885, 3092, 
         3091, 2497, 2496, 2077, 2987, 2596, 2460, 2056, 2582, 2162, 2735, 
         2736, 2501, 2863, 2864, 2389, 3072, 2169, 2655, 2170, 2656, 2070, 
         2338, 2462}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{-3, 3}, {
      Rational[1, 10], 3}}, {{-3, 3}, {0.1, 3}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509413701]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18032],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellID->23901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"LaplaceDistribution", "[", 
      RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "\[Mu]", "]"}], "==", "0"}], ",", 
      RowBox[{"\[Beta]", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12306],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94700870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17860],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], ",", 
   RowBox[{"LaplaceDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29527],

Cell[BoxData[
 RowBox[{
  RowBox[{"24", " ", 
   SuperscriptBox["\[Beta]", "4"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["\[Beta]", "2"], " ", 
   SuperscriptBox["\[Mu]", "2"]}], "+", 
  SuperscriptBox["\[Mu]", "4"]}]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375911045]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"CharacteristicFunction", "[", 
     RowBox[{
      RowBox[{"LaplaceDistribution", "[", 
       RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], ",", "t"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "4"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"t", "->", "0"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8343],

Cell[BoxData[
 RowBox[{
  RowBox[{"24", " ", 
   SuperscriptBox["\[Beta]", "4"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["\[Beta]", "2"], " ", 
   SuperscriptBox["\[Mu]", "2"]}], "+", 
  SuperscriptBox["\[Mu]", "4"]}]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29516701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->681585573],

Cell[TextData[{
 "Halves of the distribution are proportional to ",
 Cell[BoxData[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFormula"],
 " densities:"
}], "ExampleText",
 CellID->24027080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"LaplaceDistribution", "[", 
      RowBox[{"0", ",", "b"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134501587],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["x", "b"]}]], 
  RowBox[{"2", " ", "b"}]]], "Output",
 ImageSize->{29, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27024095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", 
    RowBox[{"1", "/", "b"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->573020911],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["x", "b"]}]], "b"]], "Output",
 ImageSize->{29, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43116963]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"LaplaceDistribution", "[", 
      RowBox[{"0", ",", "b"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"x", "<", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->83088291],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   FractionBox["x", "b"]], 
  RowBox[{"2", " ", "b"}]]], "Output",
 ImageSize->{26, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->914228844]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", 
    RowBox[{"1", "/", "b"}], "]"}], ",", 
   RowBox[{"-", "x"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->318796127],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   FractionBox["x", "b"]], "b"]], "Output",
 ImageSize->{24, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->722996214]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14161],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaplaceDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " is not a real number:"
}], "ExampleText",
 CellID->23234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LaplaceDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "I"}], ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10258],

Cell[BoxData[
 RowBox[{
  RowBox[{"LaplaceDistribution", "::", "\<\"realparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
real.\"\>"}]], "Message", "MSG",
 CellID->64675542],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LaplaceDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "\[ImaginaryI]"}], ",", "3"}], "]"}], "]"}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->677598463]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaplaceDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellID->5191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LaplaceDistribution", "[", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14443],

Cell[BoxData[
 RowBox[{
  RowBox[{"LaplaceDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-1\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->768435992],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LaplaceDistribution", "[", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138744282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"LaplaceDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Beta]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Mu]", "\[Rule]", "I"}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", "3"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10037311]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12628],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->6329]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19695],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->83063164]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LaplaceDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 12.7638436}", "context" -> "System`", 
    "keywords" -> {"double exponential distribution", "Laplace distribution"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LaplaceDistribution[\\[Mu], \\[Beta]] represents a Laplace double \
exponential distribution with mean \\[Mu] and scale parameter \\[Beta].", 
    "synonyms" -> {"laplace distribution"}, "title" -> "LaplaceDistribution", 
    "type" -> "Symbol", "uri" -> "ref/LaplaceDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6607, 210, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->279711455]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 118309, 2531}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1865, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2488, 76, 1584, 37, 70, "ObjectNameGrid"],
Cell[4075, 115, 701, 21, 70, "Usage",
 CellID->13843]
}, Open  ]],
Cell[CellGroupData[{
Cell[4813, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5291, 158, 189, 4, 70, "Notes",
 CellID->441],
Cell[5483, 164, 386, 13, 70, "Notes",
 CellID->3380],
Cell[5872, 179, 698, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[6607, 210, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->279711455],
Cell[CellGroupData[{
Cell[6992, 224, 148, 5, 70, "ExampleSection",
 CellID->184768649],
Cell[7143, 231, 134, 2, 70, "ExampleText",
 CellID->3402],
Cell[CellGroupData[{
Cell[7302, 237, 176, 5, 28, "Input",
 CellID->23115],
Cell[7481, 244, 161, 5, 36, "Output",
 CellID->86875734]
}, Open  ]],
Cell[CellGroupData[{
Cell[7679, 254, 179, 5, 28, "Input",
 CellID->1723],
Cell[7861, 261, 209, 7, 36, "Output",
 CellID->82404113]
}, Open  ]],
Cell[8085, 271, 121, 3, 70, "ExampleDelimiter",
 CellID->29448],
Cell[8209, 276, 68, 1, 70, "ExampleText",
 CellID->30323],
Cell[CellGroupData[{
Cell[8302, 281, 200, 6, 70, "Input",
 CellID->11153],
Cell[8505, 289, 445, 15, 64, "Output",
 CellID->152676366]
}, Open  ]],
Cell[CellGroupData[{
Cell[8987, 309, 359, 12, 28, "Input",
 CellID->24395],
Cell[9349, 323, 3234, 57, 175, "Output",
 Evaluatable->False,
 CellID->778796114]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12632, 386, 216, 7, 70, "ExampleSection",
 CellID->22908],
Cell[12851, 395, 115, 3, 70, "ExampleText",
 CellID->17411],
Cell[CellGroupData[{
Cell[12991, 402, 197, 6, 70, "Input",
 CellID->13993],
Cell[13191, 410, 382, 10, 36, "Output",
 CellID->592548891]
}, Open  ]],
Cell[13588, 423, 121, 3, 70, "ExampleDelimiter",
 CellID->26781],
Cell[13712, 428, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[13836, 435, 179, 5, 70, "Input",
 CellID->3202],
Cell[14018, 442, 158, 5, 36, "Output",
 CellID->110959101]
}, Open  ]],
Cell[CellGroupData[{
Cell[14213, 452, 180, 5, 70, "Input",
 CellID->27256],
Cell[14396, 459, 158, 5, 36, "Output",
 CellID->546108099]
}, Open  ]],
Cell[14569, 467, 120, 3, 70, "ExampleDelimiter",
 CellID->8965],
Cell[14692, 472, 238, 9, 70, "ExampleText",
 CellID->18023],
Cell[CellGroupData[{
Cell[14955, 485, 205, 6, 70, "Input",
 CellID->20769],
Cell[15163, 493, 634, 22, 36, "Output",
 CellID->645322304]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15846, 521, 223, 7, 70, "ExampleSection",
 CellID->23684],
Cell[16072, 530, 112, 3, 70, "ExampleText",
 CellID->26900],
Cell[CellGroupData[{
Cell[16209, 537, 310, 10, 70, "Input",
 CellID->10968],
Cell[16522, 549, 2181, 45, 170, "Output",
 CellID->396565040]
}, Open  ]],
Cell[18718, 597, 121, 3, 70, "ExampleDelimiter",
 CellID->16633],
Cell[18842, 602, 224, 9, 70, "ExampleText",
 CellID->13885],
Cell[CellGroupData[{
Cell[19091, 615, 444, 14, 70, "Input",
 CellID->348],
Cell[19538, 631, 87291, 1456, 70, "Output",
 CellID->509413701]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106878, 2093, 233, 7, 70, "ExampleSection",
 CellID->18032],
Cell[107114, 2102, 92, 1, 70, "ExampleText",
 CellID->23901],
Cell[CellGroupData[{
Cell[107231, 2107, 561, 17, 70, "Input",
 CellID->12306],
Cell[107795, 2126, 157, 5, 36, "Output",
 CellID->94700870]
}, Open  ]],
Cell[107967, 2134, 121, 3, 70, "ExampleDelimiter",
 CellID->17860],
Cell[108091, 2139, 97, 2, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[108213, 2145, 244, 7, 70, "Input",
 CellID->29527],
Cell[108460, 2154, 368, 12, 36, "Output",
 CellID->375911045]
}, Open  ]],
Cell[CellGroupData[{
Cell[108865, 2171, 404, 13, 70, "Input",
 CellID->8343],
Cell[109272, 2186, 367, 12, 36, "Output",
 CellID->29516701]
}, Open  ]],
Cell[109654, 2201, 125, 3, 70, "ExampleDelimiter",
 CellID->681585573],
Cell[109782, 2206, 269, 8, 70, "ExampleText",
 CellID->24027080],
Cell[CellGroupData[{
Cell[110076, 2218, 283, 9, 70, "Input",
 CellID->134501587],
Cell[110362, 2229, 280, 10, 59, "Output",
 CellID->27024095]
}, Open  ]],
Cell[CellGroupData[{
Cell[110679, 2244, 198, 6, 70, "Input",
 CellID->573020911],
Cell[110880, 2252, 257, 9, 58, "Output",
 CellID->43116963]
}, Open  ]],
Cell[CellGroupData[{
Cell[111174, 2266, 282, 9, 70, "Input",
 CellID->83088291],
Cell[111459, 2277, 261, 9, 59, "Output",
 CellID->914228844]
}, Open  ]],
Cell[CellGroupData[{
Cell[111757, 2291, 217, 7, 70, "Input",
 CellID->318796127],
Cell[111977, 2300, 238, 8, 58, "Output",
 CellID->722996214]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112264, 2314, 327, 9, 70, "ExampleSection",
 CellID->14161],
Cell[112594, 2325, 304, 10, 70, "ExampleText",
 CellID->23234],
Cell[CellGroupData[{
Cell[112923, 2339, 191, 6, 70, "Input",
 CellID->10258],
Cell[113117, 2347, 211, 5, 70, "Message",
 CellID->64675542],
Cell[113331, 2354, 296, 9, 36, "Output",
 CellID->677598463]
}, Open  ]],
Cell[113642, 2366, 314, 10, 70, "ExampleText",
 CellID->5191],
Cell[CellGroupData[{
Cell[113981, 2380, 186, 6, 70, "Input",
 CellID->14443],
Cell[114170, 2388, 200, 5, 70, "Message",
 CellID->768435992],
Cell[114373, 2395, 279, 9, 36, "Output",
 CellID->138744282]
}, Open  ]],
Cell[114667, 2407, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[114791, 2412, 144, 4, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[114960, 2420, 321, 10, 70, "Input",
 CellID->25838],
Cell[115284, 2432, 169, 5, 36, "Output",
 CellID->10037311]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[115514, 2444, 311, 9, 70, "SeeAlsoSection",
 CellID->12628],
Cell[115828, 2455, 225, 6, 70, "SeeAlso",
 CellID->6329]
}, Open  ]],
Cell[CellGroupData[{
Cell[116090, 2466, 314, 9, 70, "TutorialsSection",
 CellID->19695],
Cell[116407, 2477, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[116601, 2485, 299, 8, 70, "MoreAboutSection"],
Cell[116903, 2495, 183, 4, 70, "MoreAbout",
 CellID->83063164]
}, Open  ]],
Cell[117101, 2502, 27, 0, 70, "History"],
Cell[117131, 2504, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

