(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58948,       2253]
NotebookOptionsPosition[     46299,       1811]
NotebookOutlinePosition[     48972,       1882]
CellTagsIndexPosition[     48747,       1874]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:tutorial/IntegralTransforms"], 
          "Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Integral Transforms\"\>", 
       2->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseLaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseLaplaceTransform"], 
          "FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"], 
          "ZTransform" :> Documentation`HelpLookup["paclet:ref/ZTransform"], 
          "Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"InverseLaplaceTransform\"\>", 2->"\<\"FourierTransform\"\>", 
       3->"\<\"ZTransform\"\>", 4->"\<\"Integrate\"\>", 
       5->"\<\"Piecewise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Generalized Functions" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedFunctions"], 
          "Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Generalized Functions\"\>", 3->"\<\"Integral Transforms\"\>", 
       4->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LaplaceTransform", "ObjectName",
 CellID->21209],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LaplaceTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LaplaceTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Laplace transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LaplaceTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LaplaceTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multidimensional Laplace transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15669]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Laplace transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
    RowBox[{
     RowBox[{"f", "(", "t", ")"}], 
     SuperscriptBox["e", 
      RowBox[{"-", "s", "t"}]], 
     RowBox[{"\[DifferentialD]", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->9174],

Cell[TextData[{
 "The lower limit of the integral is effectively taken to be ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["0", "-"], TraditionalForm]], "InlineMath"],
 ", so that the Laplace transform of the Dirac delta function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is equal to 1. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->3775306]
}], "Notes",
 CellID->12865],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " and other options to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can also be given in ",
 Cell[BoxData[
  ButtonBox["LaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->250806612]
}], "Notes",
 CellID->26056],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFormula"],
 " is output using ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalL]", TraditionalForm]], "InlineMath"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->729833540]
}], "Notes",
 CellID->32206]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->137041175],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->225904877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "4"}], 
    RowBox[{"Sin", "[", "t", "]"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23764],

Cell[BoxData[
 FractionBox[
  RowBox[{"24", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["s", "4"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["s", "2"]}], ")"}], "5"]]], "Output",
 ImageSize->{124, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100407408]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"-", "t"}], ")"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->906712102],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "s"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320991480]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"t", "-", "1"}], "]"}], "t"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3178320],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "s"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "s"}], ")"}]}], 
  SuperscriptBox["s", "2"]]], "Output",
 ImageSize->{70, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20908865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->201202006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "''"}], "[", "t", "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29642],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "s"}], " ", 
   RowBox[{"f", "[", "0", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", "2"], " ", 
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", "0", "]"}]}]], "Output",
 ImageSize->{313, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154716322]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20574],

Cell["Elementary functions:", "ExampleText",
 CellID->53795168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{"t", ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->391773829],

Cell[BoxData[
 FractionBox["1", 
  SuperscriptBox["s", "2"]]], "Output",
 ImageSize->{21, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32409472]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "t"}], ")"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26756],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "s"], " ", "s", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"0", ",", "s"}], "]"}]}]}], "s"]}]], "Output",
 ImageSize->{143, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9984970]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"t", "^", "2"}], "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32156],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "s", " ", 
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["3", "4"], ",", 
         FractionBox["5", "4"]}], "}"}], ",", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["s", "4"], "64"]}]}], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", 
        FractionBox[
         SuperscriptBox["s", "2"], "4"], "]"}], "+", 
       RowBox[{"Sin", "[", 
        FractionBox[
         SuperscriptBox["s", "2"], "4"], "]"}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{490, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->183366970]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "t", "]"}], "^", "2"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25264],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"6", " ", 
    SuperscriptBox["EulerGamma", "2"]}], "+", 
   SuperscriptBox["\[Pi]", "2"], "+", 
   RowBox[{"6", " ", 
    RowBox[{"Log", "[", "s", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "EulerGamma"}], "+", 
      RowBox[{"Log", "[", "s", "]"}]}], ")"}]}]}], 
  RowBox[{"6", " ", "s"}]]], "Output",
 ImageSize->{336, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->29317883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7226],

Cell["Special functions:", "ExampleText",
 CellID->27688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"AiryAi", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19242],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["s", "3"], "3"]}]], " ", "s", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"ExpIntegralE", "[", 
       RowBox[{
        FractionBox["2", "3"], ",", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["s", "3"], "3"]}]}], "]"}], " ", 
      RowBox[{"Gamma", "[", 
       FractionBox["2", "3"], "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{"2", "/", "3"}]], " ", "s", " ", 
      RowBox[{"ExpIntegralE", "[", 
       RowBox[{
        FractionBox["1", "3"], ",", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["s", "3"], "3"]}]}], "]"}], " ", 
      RowBox[{"Gamma", "[", 
       FractionBox["4", "3"], "]"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["3", 
    RowBox[{"5", "/", "6"}]], " ", "\[Pi]"}]]], "Output",
 ImageSize->{517, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146425850]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"3", ",", "t"}], "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30114],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox["s", "2"]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"s", "+", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["s", "2"]}]]}], ")"}], "3"]}]]], "Output",
 ImageSize->{153, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59697743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16077],

Cell["Piecewise functions:", "ExampleText",
 CellID->32245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"UnitStep", "[", 
     RowBox[{"t", "-", "1"}], "]"}], 
    RowBox[{"Cos", "[", "t", "]"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19993],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "s"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"s", " ", 
      RowBox[{"Cos", "[", "1", "]"}]}], "-", 
     RowBox[{"Sin", "[", "1", "]"}]}], ")"}]}], 
  RowBox[{"1", "+", 
   SuperscriptBox["s", "2"]}]]], "Output",
 ImageSize->{150, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396410959]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "t", "]"}]}], "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27040],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[Pi]", " ", "s"}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Pi]", " ", "s"}]]}], ")"}], " ", "s"}]]], "Output",
 ImageSize->{73, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->710509055]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"t", ">", "Pi"}], ",", 
     RowBox[{"Cos", "[", "t", "]"}], ",", "t"}], "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9355],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Pi]"}], " ", "s"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Pi]", " ", "s"}]], "-", 
     RowBox[{"\[Pi]", " ", "s"}], "-", 
     FractionBox[
      SuperscriptBox["s", "3"], 
      RowBox[{"1", "+", 
       SuperscriptBox["s", "2"]}]]}], ")"}]}], 
  SuperscriptBox["s", "2"]]], "Output",
 ImageSize->{167, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3276027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62630558],

Cell[TextData[{
 "In these distributions, the integration region is taken to start at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["0", "-"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->3775306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"HeavisideTheta", "[", "t", "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347536560],

Cell[BoxData[
 FractionBox["1", "s"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192360859]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", "t", "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8330931],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41695891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->66685247],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->729833540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LaplaceTransform", "[", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->472080662],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[ScriptCapitalL]", "t"], "[", 
    RowBox[{"f", "(", "t", ")"}], "]"}], 
   RowBox[{"(", "s", ")"}]}], TraditionalForm]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->152353910]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30402],

Cell["Multidimensional Laplace transform:", "ExampleText",
 CellID->13648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", " ", "y"}], ")"}], "^", "2"}], " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "x"}], " ", "+", "y"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", " ", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", " ", "v"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27958],

Cell[BoxData[
 FractionBox["4", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "u"}], ")"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "v"}], ")"}], "3"]}]]], "Output",
 ImageSize->{112, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373610209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18689],

Cell["Integrals:", "ExampleText",
 CellID->32264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "u", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", " ", "0", ",", "t"}], "}"}]}], "]"}], ",", "t", ",", 
   "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15410],

Cell[BoxData[
 FractionBox[
  RowBox[{"LaplaceTransform", "[", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}], "s"]], "Output",\

 ImageSize->{199, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17855486]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25202],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFormula"],
 " threads itself over equations:"
}], "ExampleText",
 CellID->14285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "t", "]"}], "==", 
    RowBox[{"Log", "[", "t", "]"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28381],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"f", "[", "0", "]"}]}], "+", 
   RowBox[{"s", " ", 
    RowBox[{"LaplaceTransform", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}]}], 
  "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"EulerGamma", "+", 
     RowBox[{"Log", "[", "s", "]"}]}], "s"]}]}]], "Output",
 ImageSize->{407, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64069198]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->50618069],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->380832242],

Cell[TextData[{
 "Specify the range for a parameter using ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->250806612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"t", "/", "a"}], "]"}], ",", " ", "t", ",", " ", "s", ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{"a", " ", ">", " ", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->319892438],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"CosIntegral", "[", 
     RowBox[{"a", " ", "s"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", "s"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"a", " ", "s"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"2", " ", 
       RowBox[{"SinIntegral", "[", 
        RowBox[{"a", " ", "s"}], "]"}]}]}], ")"}]}]}], 
  RowBox[{"2", " ", "s"}]]], "Output",
 ImageSize->{402, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75708407]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GenerateConditions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->52724971],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to get parameter conditions for when a result is valid:"
}], "ExampleText",
 CellID->243654745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      RowBox[{"t", "^", "2"}]}], ")"}]}], ",", " ", "t", ",", " ", "s", ",", 
   " ", 
   RowBox[{"GenerateConditions", " ", "\[Rule]", " ", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54464552],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], ">", "0"}], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       SuperscriptBox["s", "2"], 
       RowBox[{"4", " ", "a"}]]], " ", 
     SqrtBox["\[Pi]"], " ", 
     RowBox[{"Erfc", "[", 
      FractionBox["s", 
       RowBox[{"2", " ", 
        SqrtBox["a"]}]], "]"}]}], 
    RowBox[{"2", " ", 
     SqrtBox["a"]}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "t"}], " ", 
       RowBox[{"(", 
        RowBox[{"s", "+", 
         RowBox[{"a", " ", "t"}]}], ")"}]}]], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "a", "]"}], "\[LessEqual]", "0"}]}], ",", 
     RowBox[{"GenerateConditions", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{558, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30866478]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4058],

Cell["Solve a differential equation using Laplace transforms:", "ExampleText",
 CellID->25652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "''"}], "[", "t", "]"}], "+", 
     RowBox[{"f", "[", "t", "]"}]}], "==", 
    RowBox[{"Sin", "[", "t", "]"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8696],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "s"}], " ", 
    RowBox[{"f", "[", "0", "]"}]}], "+", 
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}], "+", 
   RowBox[{
    SuperscriptBox["s", "2"], " ", 
    RowBox[{"LaplaceTransform", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "0", "]"}]}], "\[Equal]", 
  FractionBox["1", 
   RowBox[{"1", "+", 
    SuperscriptBox["s", "2"]}]]}]], "Output",
 ImageSize->{569, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325217259]
}, Open  ]],

Cell["Solve for the Laplace transform:", "ExampleText",
 CellID->20334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"LaplaceTransform", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"s", " ", 
       RowBox[{"f", "[", "0", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["s", "3"], " ", 
       RowBox[{"f", "[", "0", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "+", 
      RowBox[{
       SuperscriptBox["s", "2"], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "0", "]"}]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["s", "2"]}], ")"}], "2"]]}], "}"}], "}"}]], "Output",
 ImageSize->{460, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195057360]
}, Open  ]],

Cell["Find the inverse transform:", "ExampleText",
 CellID->14090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{"%", ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], " ", 
      RowBox[{"f", "[", "0", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "t"}], " ", 
         RowBox[{"Cos", "[", "t", "]"}]}], "+", 
        RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{394, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->153195972]
}, Open  ]],

Cell[TextData[{
 "Find the solution directly using ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "''"}], "[", "t", "]"}], "+", 
     RowBox[{"f", "[", "t", "]"}]}], "==", 
    RowBox[{"Sin", "[", "t", "]"}]}], ",", 
   RowBox[{"f", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->31113],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "t", " ", 
         RowBox[{"Cos", "[", "t", "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "t", "]"}], "2"], " ", 
         RowBox[{"Sin", "[", "t", "]"}]}], "+", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", "t"}], "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{570, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->572612842]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31212],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseLaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseLaplaceTransform"]], "InlineFormula"],
 " are mutual inverses:"
}], "ExampleText",
 CellID->23360077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", " ", "s"}], "]"}], ",", "s",
    ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70250391],

Cell[BoxData[
 RowBox[{"f", "[", "t", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143489133]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{
     RowBox[{"g", "[", "s", "]"}], ",", "s", ",", " ", "t"}], "]"}], ",", "t",
    ",", " ", "s"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50546575],

Cell[BoxData[
 RowBox[{"g", "[", "s", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54985289]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"-", 
      RowBox[{"t", "^", "2"}]}], ")"}]}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[3]:=",
 CellID->517183249],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    SuperscriptBox["s", "2"], "4"]], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"Erfc", "[", 
   FractionBox["s", "2"], "]"}]}]], "Output",
 ImageSize->{124, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[3]=",
 CellID->554049536]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{"%", ",", "s", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[4]:=",
 CellID->100959012],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{27, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[4]=",
 CellID->815459385]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->311771792],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " for numerical approximation:"
}], "ExampleText",
 CellID->10986222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"t", "^", "2"}]}], ")"}]}], ",", " ", "t", ",", " ", "s"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[1]:=",
 CellID->353355604],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CosIntegral", "[", "s", "]"}], " ", 
   RowBox[{"Sin", "[", "s", "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Cos", "[", "s", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"\[Pi]", "-", 
     RowBox[{"2", " ", 
      RowBox[{"SinIntegral", "[", "s", "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{362, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[1]=",
 CellID->322507710]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"s", "\[Rule]", " ", "0.4"}], "}"}]}]], "Input",
 CellTags->"Ex--22034558506017011754,12",
 CellLabel->"In[2]:=",
 CellID->131027253],

Cell[BoxData["0.9341187275901071`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,12",
 CellLabel->"Out[2]=",
 CellID->79736922]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " computes the transform for numeric values of the Laplace parameter ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->52039128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "0.4"}], " ", "t"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"t", "^", "2"}]}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11367299],

Cell[BoxData["0.9341187269067666`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->377328158]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26639],

Cell["\<\
Simplification can be required to get back the original form:\
\>", "ExampleText",
 CellID->11155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "t", "]"}], 
    RowBox[{"Exp", "[", "t", "]"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18279],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "s"}], ")"}], "2"]}]]], "Output",
 ImageSize->{82, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286526807]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{"%", ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7318],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "t"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "t"}]]}], ")"}]}]], "Output",
 ImageSize->{148, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54094266]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17476],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "t"], " ", 
  RowBox[{"Sin", "[", "t", "]"}]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22445911]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16634],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFormula"],
 " done in terms of ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->975066807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"t", "^", "8"}]}], ")"}]}], ",", " ", "t", ",", " ", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5028561],

Cell[BoxData[
 FractionBox[
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       FractionBox["7", "8"], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        FractionBox["1", "8"], ",", 
        FractionBox["1", "4"], ",", 
        FractionBox["3", "8"], ",", 
        FractionBox["1", "2"], ",", 
        FractionBox["5", "8"], ",", 
        FractionBox["3", "4"], ",", 
        FractionBox["7", "8"], ",", 
        FractionBox["7", "8"]}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    FractionBox[
     SuperscriptBox["s", "8"], "16777216"]}], "]"}], 
  RowBox[{"32", " ", 
   SuperscriptBox["\[Pi]", 
    RowBox[{"7", "/", "2"}]]}]]], "Output",
 ImageSize->{435, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37359129]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32648],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseLaplaceTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseLaplaceTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ZTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26606]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28954],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntegralTransforms"]], "Tutorials",
 CellID->11145],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->11251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->63288777],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->212958961],

Cell[TextData[ButtonBox["Generalized Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedFunctions"]], "MoreAbout",
 CellID->645487753],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->152748416],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->141642824]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LaplaceTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 13.5294882}", "context" -> "System`", 
    "keywords" -> {
     "function transform", "integral operator", "integral transform", 
      "Integrate", "inverse Laplace transform", "Laplace transform", 
      "operational calculus", "transfer function", "transient analysis"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LaplaceTransform[expr, t, s] gives the Laplace transform of expr. \
LaplaceTransform[expr, {t_1, t_2, ...}, {s_1, s_2, ...}] gives the \
multidimensional Laplace transform of expr. ", 
    "synonyms" -> {"Laplace transform"}, "title" -> "LaplaceTransform", 
    "type" -> "Symbol", "uri" -> "ref/LaplaceTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7790, 248, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->137041175]},
 "Ex--22034558506017011754,4"->{
  Cell[35298, 1369, 286, 10, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->517183249],
  Cell[35587, 1381, 418, 14, 55, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->554049536],
  Cell[36903, 1436, 301, 10, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->353355604],
  Cell[37207, 1448, 522, 17, 51, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->322507710]},
 "Ex--22034558506017011754,5"->{
  Cell[36042, 1400, 193, 5, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->100959012],
  Cell[36238, 1407, 279, 9, 40, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->815459385]},
 "Ex--22034558506017011754,12"->{
  Cell[37766, 1470, 195, 6, 70, "Input",
   CellTags->"Ex--22034558506017011754,12",
   CellID->131027253],
  Cell[37964, 1478, 217, 6, 36, "Output",
   CellTags->"Ex--22034558506017011754,12",
   CellID->79736922]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47636, 1840},
 {"Ex--22034558506017011754,4", 47789, 1844},
 {"Ex--22034558506017011754,5", 48257, 1857},
 {"Ex--22034558506017011754,12", 48507, 1864}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2842, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3465, 90, 54, 1, 70, "ObjectName",
 CellID->21209],
Cell[3522, 93, 1659, 52, 70, "Usage",
 CellID->15669]
}, Open  ]],
Cell[CellGroupData[{
Cell[5218, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5696, 167, 489, 17, 70, "Notes",
 CellID->9174],
Cell[6188, 186, 465, 14, 70, "Notes",
 CellID->12865],
Cell[6656, 202, 572, 20, 70, "Notes",
 CellID->26056],
Cell[7231, 224, 522, 19, 70, "Notes",
 CellID->32206]
}, Closed]],
Cell[CellGroupData[{
Cell[7790, 248, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->137041175],
Cell[CellGroupData[{
Cell[8175, 262, 148, 5, 70, "ExampleSection",
 CellID->225904877],
Cell[CellGroupData[{
Cell[8348, 271, 217, 7, 28, "Input",
 CellID->23764],
Cell[8568, 280, 471, 17, 63, "Output",
 CellID->100407408]
}, Open  ]],
Cell[CellGroupData[{
Cell[9076, 302, 215, 7, 28, "Input",
 CellID->906712102],
Cell[9294, 311, 201, 7, 51, "Output",
 CellID->320991480]
}, Open  ]],
Cell[9510, 321, 121, 3, 70, "ExampleDelimiter",
 CellID->11830],
Cell[CellGroupData[{
Cell[9656, 328, 234, 8, 70, "Input",
 CellID->3178320],
Cell[9893, 338, 332, 12, 53, "Output",
 CellID->20908865]
}, Open  ]],
Cell[10240, 353, 125, 3, 70, "ExampleDelimiter",
 CellID->201202006],
Cell[CellGroupData[{
Cell[10390, 360, 194, 7, 70, "Input",
 CellID->29642],
Cell[10587, 369, 509, 17, 36, "Output",
 CellID->154716322]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11145, 392, 216, 7, 70, "ExampleSection",
 CellID->20574],
Cell[11364, 401, 63, 1, 70, "ExampleText",
 CellID->53795168],
Cell[CellGroupData[{
Cell[11452, 406, 145, 4, 70, "Input",
 CellID->391773829],
Cell[11600, 412, 201, 7, 52, "Output",
 CellID->32409472]
}, Open  ]],
Cell[CellGroupData[{
Cell[11838, 424, 216, 7, 70, "Input",
 CellID->26756],
Cell[12057, 433, 377, 13, 52, "Output",
 CellID->9984970]
}, Open  ]],
Cell[CellGroupData[{
Cell[12471, 451, 197, 6, 70, "Input",
 CellID->32156],
Cell[12671, 459, 926, 33, 54, "Output",
 CellID->183366970]
}, Open  ]],
Cell[CellGroupData[{
Cell[13634, 497, 200, 7, 70, "Input",
 CellID->25264],
Cell[13837, 506, 509, 17, 55, "Output",
 CellID->29317883]
}, Open  ]],
Cell[14361, 526, 120, 3, 70, "ExampleDelimiter",
 CellID->7226],
Cell[14484, 531, 57, 1, 70, "ExampleText",
 CellID->27688],
Cell[CellGroupData[{
Cell[14566, 536, 175, 5, 70, "Input",
 CellID->19242],
Cell[14744, 543, 1075, 36, 71, "Output",
 CellID->146425850]
}, Open  ]],
Cell[CellGroupData[{
Cell[15856, 584, 201, 6, 70, "Input",
 CellID->30114],
Cell[16060, 592, 416, 16, 71, "Output",
 CellID->59697743]
}, Open  ]],
Cell[16491, 611, 121, 3, 70, "ExampleDelimiter",
 CellID->16077],
Cell[16615, 616, 59, 1, 70, "ExampleText",
 CellID->32245],
Cell[CellGroupData[{
Cell[16699, 621, 255, 8, 70, "Input",
 CellID->19993],
Cell[16957, 631, 451, 16, 53, "Output",
 CellID->396410959]
}, Open  ]],
Cell[CellGroupData[{
Cell[17445, 652, 233, 8, 70, "Input",
 CellID->27040],
Cell[17681, 662, 388, 13, 59, "Output",
 CellID->710509055]
}, Open  ]],
Cell[CellGroupData[{
Cell[18106, 680, 268, 9, 70, "Input",
 CellID->9355],
Cell[18377, 691, 613, 21, 65, "Output",
 CellID->3276027]
}, Open  ]],
Cell[19005, 715, 124, 3, 70, "ExampleDelimiter",
 CellID->62630558],
Cell[19132, 720, 265, 8, 70, "ExampleText",
 CellID->3775306],
Cell[CellGroupData[{
Cell[19422, 732, 190, 6, 70, "Input",
 CellID->347536560],
Cell[19615, 740, 178, 6, 51, "Output",
 CellID->192360859]
}, Open  ]],
Cell[CellGroupData[{
Cell[19830, 751, 184, 6, 70, "Input",
 CellID->8330931],
Cell[20017, 759, 157, 5, 36, "Output",
 CellID->41695891]
}, Open  ]],
Cell[20189, 767, 124, 3, 70, "ExampleDelimiter",
 CellID->66685247],
Cell[20316, 772, 251, 8, 70, "ExampleText",
 CellID->729833540],
Cell[CellGroupData[{
Cell[20592, 784, 217, 7, 70, "Input",
 CellID->472080662],
Cell[20812, 793, 344, 11, 50, "Output",
 CellID->152353910]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21205, 810, 239, 7, 70, "ExampleSection",
 CellID->30402],
Cell[21447, 819, 74, 1, 70, "ExampleText",
 CellID->13648],
Cell[CellGroupData[{
Cell[21546, 824, 457, 16, 70, "Input",
 CellID->27958],
Cell[22006, 842, 376, 14, 54, "Output",
 CellID->373610209]
}, Open  ]],
Cell[22397, 859, 121, 3, 70, "ExampleDelimiter",
 CellID->18689],
Cell[22521, 864, 49, 1, 70, "ExampleText",
 CellID->32264],
Cell[CellGroupData[{
Cell[22595, 869, 306, 10, 70, "Input",
 CellID->15410],
Cell[22904, 881, 287, 10, 51, "Output",
 CellID->17855486]
}, Open  ]],
Cell[23206, 894, 121, 3, 70, "ExampleDelimiter",
 CellID->25202],
Cell[23330, 899, 220, 7, 70, "ExampleText",
 CellID->14285],
Cell[CellGroupData[{
Cell[23575, 910, 249, 8, 70, "Input",
 CellID->28381],
Cell[23827, 920, 506, 18, 51, "Output",
 CellID->64069198]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24382, 944, 221, 7, 70, "ExampleSection",
 CellID->50618069],
Cell[CellGroupData[{
Cell[24628, 955, 232, 7, 70, "ExampleSubsection",
 CellID->380832242],
Cell[24863, 964, 277, 9, 70, "ExampleText",
 CellID->250806612],
Cell[CellGroupData[{
Cell[25165, 977, 314, 8, 70, "Input",
 CellID->319892438],
Cell[25482, 987, 618, 21, 52, "Output",
 CellID->75708407]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26149, 1014, 238, 7, 70, "ExampleSubsection",
 CellID->52724971],
Cell[26390, 1023, 365, 12, 70, "ExampleText",
 CellID->243654745],
Cell[CellGroupData[{
Cell[26780, 1039, 360, 12, 70, "Input",
 CellID->54464552],
Cell[27143, 1053, 1120, 37, 104, "Output",
 CellID->30866478]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28324, 1097, 222, 7, 70, "ExampleSection",
 CellID->4058],
Cell[28549, 1106, 94, 1, 70, "ExampleText",
 CellID->25652],
Cell[CellGroupData[{
Cell[28668, 1111, 307, 10, 70, "Input",
 CellID->8696],
Cell[28978, 1123, 741, 24, 52, "Output",
 CellID->325217259]
}, Open  ]],
Cell[29734, 1150, 71, 1, 70, "ExampleText",
 CellID->20334],
Cell[CellGroupData[{
Cell[29830, 1155, 233, 8, 70, "Input",
 CellID->30106],
Cell[30066, 1165, 948, 30, 61, "Output",
 CellID->195057360]
}, Open  ]],
Cell[31029, 1198, 66, 1, 70, "ExampleText",
 CellID->14090],
Cell[CellGroupData[{
Cell[31120, 1203, 147, 4, 70, "Input",
 CellID->6562],
Cell[31270, 1209, 788, 27, 51, "Output",
 CellID->153195972]
}, Open  ]],
Cell[32073, 1239, 207, 8, 70, "ExampleText",
 CellID->3259],
Cell[CellGroupData[{
Cell[32305, 1251, 327, 11, 70, "Input",
 CellID->31113],
Cell[32635, 1264, 982, 32, 51, "Output",
 CellID->572612842]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33666, 1302, 233, 7, 70, "ExampleSection",
 CellID->31212],
Cell[33902, 1311, 372, 12, 70, "ExampleText",
 CellID->23360077],
Cell[CellGroupData[{
Cell[34299, 1327, 275, 8, 70, "Input",
 CellID->70250391],
Cell[34577, 1337, 185, 6, 36, "Output",
 CellID->143489133]
}, Open  ]],
Cell[CellGroupData[{
Cell[34799, 1348, 275, 8, 70, "Input",
 CellID->50546575],
Cell[35077, 1358, 184, 6, 36, "Output",
 CellID->54985289]
}, Open  ]],
Cell[CellGroupData[{
Cell[35298, 1369, 286, 10, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->517183249],
Cell[35587, 1381, 418, 14, 55, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->554049536]
}, Open  ]],
Cell[CellGroupData[{
Cell[36042, 1400, 193, 5, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->100959012],
Cell[36238, 1407, 279, 9, 40, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->815459385]
}, Open  ]],
Cell[36532, 1419, 125, 3, 70, "ExampleDelimiter",
 CellID->311771792],
Cell[36660, 1424, 218, 8, 70, "ExampleText",
 CellID->10986222],
Cell[CellGroupData[{
Cell[36903, 1436, 301, 10, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->353355604],
Cell[37207, 1448, 522, 17, 51, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->322507710]
}, Open  ]],
Cell[CellGroupData[{
Cell[37766, 1470, 195, 6, 70, "Input",
 CellTags->"Ex--22034558506017011754,12",
 CellID->131027253],
Cell[37964, 1478, 217, 6, 36, "Output",
 CellTags->"Ex--22034558506017011754,12",
 CellID->79736922]
}, Open  ]],
Cell[38196, 1487, 311, 10, 70, "ExampleText",
 CellID->52039128],
Cell[CellGroupData[{
Cell[38532, 1501, 396, 14, 70, "Input",
 CellID->11367299],
Cell[38931, 1517, 176, 5, 36, "Output",
 CellID->377328158]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39156, 1528, 226, 7, 70, "ExampleSection",
 CellID->26639],
Cell[39385, 1537, 108, 3, 70, "ExampleText",
 CellID->11155],
Cell[CellGroupData[{
Cell[39518, 1544, 224, 7, 70, "Input",
 CellID->18279],
Cell[39745, 1553, 299, 11, 54, "Output",
 CellID->286526807]
}, Open  ]],
Cell[CellGroupData[{
Cell[40081, 1569, 147, 4, 70, "Input",
 CellID->7318],
Cell[40231, 1575, 532, 17, 51, "Output",
 CellID->54094266]
}, Open  ]],
Cell[CellGroupData[{
Cell[40800, 1597, 104, 3, 70, "Input",
 CellID->17476],
Cell[40907, 1602, 247, 8, 36, "Output",
 CellID->22445911]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41203, 1616, 224, 7, 70, "ExampleSection",
 CellID->16634],
Cell[41430, 1625, 334, 12, 70, "ExampleText",
 CellID->975066807],
Cell[CellGroupData[{
Cell[41789, 1641, 258, 9, 70, "Input",
 CellID->5028561],
Cell[42050, 1652, 921, 31, 64, "Output",
 CellID->37359129]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43032, 1690, 311, 9, 70, "SeeAlsoSection",
 CellID->32648],
Cell[43346, 1701, 1240, 44, 70, "SeeAlso",
 CellID->26606]
}, Open  ]],
Cell[CellGroupData[{
Cell[44623, 1750, 314, 9, 70, "TutorialsSection",
 CellID->28954],
Cell[44940, 1761, 148, 3, 70, "Tutorials",
 CellID->11145],
Cell[45091, 1766, 194, 4, 70, "Tutorials",
 CellID->11251]
}, Open  ]],
Cell[CellGroupData[{
Cell[45322, 1775, 318, 9, 70, "MoreAboutSection",
 CellID->63288777],
Cell[45643, 1786, 128, 3, 70, "MoreAbout",
 CellID->212958961],
Cell[45774, 1791, 153, 3, 70, "MoreAbout",
 CellID->645487753],
Cell[45930, 1796, 149, 3, 70, "MoreAbout",
 CellID->152748416],
Cell[46082, 1801, 145, 3, 70, "MoreAbout",
 CellID->141642824]
}, Open  ]],
Cell[46242, 1807, 27, 0, 70, "History"],
Cell[46272, 1809, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

