(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18591,        734]
NotebookOptionsPosition[     13966,        567]
NotebookOutlinePosition[     15188,        603]
CellTagsIndexPosition[     15103,        598]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Getting Pieces of Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GettingPiecesOfLists"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Getting Pieces of Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Part" :> Documentation`HelpLookup["paclet:ref/Part"], "First" :> 
          Documentation`HelpLookup["paclet:ref/First"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "Most" :> 
          Documentation`HelpLookup["paclet:ref/Most"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Part\"\>", 2->"\<\"First\"\>", 3->"\<\"Take\"\>",
        4->"\<\"Most\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"List Manipulation\"\>", 
       3->"\<\"Parts of Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Last", "ObjectName",
 CellID->2271],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Last",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Last"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the last element in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20683]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Last",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Last"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{"-", "1"}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21281]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->129121243],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->83953307],

Cell["Extract the last element of a list:", "ExampleText",
 CellID->6296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26662],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18230]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4428],

Cell["Extract the last row of a matrix:", "ExampleText",
 CellID->19438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e", ",", "f"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16793]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26348],

Cell[TextData[{
 "The head need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->28138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{
   RowBox[{"a", "^", "2"}], "+", 
   RowBox[{"b", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->763],

Cell[BoxData[
 SuperscriptBox["b", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22743]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18449],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Last",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Last"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->20337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"Range", "[", "100", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27496],

Cell[BoxData["100"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9459]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30900],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Last",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Last"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{"-", "1"}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "ExampleText",
 CellID->6861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21100],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8034],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5267]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6116],

Cell[TextData[{
 "The expression is evaluated before ",
 Cell[BoxData[
  ButtonBox["Last",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Last"]], "InlineFormula"],
 " is applied:"
}], "ExampleText",
 CellID->5242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{
   RowBox[{"b", "^", "2"}], "+", 
   RowBox[{"a", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15752],

Cell[BoxData[
 SuperscriptBox["b", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31920],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Last",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Last"]], "InlineFormula"],
 " always operates on the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of expressions:"
}], "ExampleText",
 CellID->31941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"1", "/", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4825],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27984]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"1", "/", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10433],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "1"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->29469]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23172],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Most",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Most"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3191]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17725],

Cell[TextData[ButtonBox["Getting Pieces of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GettingPiecesOfLists"]], "Tutorials",
 CellID->11583]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->397209143],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->214780149],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->60752601],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->588492198]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Last - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 14.6701424}", "context" -> "System`", 
    "keywords" -> {
     "last element of list", "last part", "last part of expression"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Last[expr] gives the last element in expr. ", "synonyms" -> {}, "title" -> 
    "Last", "type" -> "Symbol", "uri" -> "ref/Last"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4399, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->129121243]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14960, 591}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2267, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2890, 81, 41, 1, 70, "ObjectName",
 CellID->2271],
Cell[2934, 84, 542, 18, 70, "Usage",
 CellID->20683]
}, Open  ]],
Cell[CellGroupData[{
Cell[3513, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3991, 124, 371, 15, 70, "Notes",
 CellID->21281]
}, Closed]],
Cell[CellGroupData[{
Cell[4399, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->129121243],
Cell[CellGroupData[{
Cell[4784, 158, 147, 5, 70, "ExampleSection",
 CellID->83953307],
Cell[4934, 165, 73, 1, 70, "ExampleText",
 CellID->6296],
Cell[CellGroupData[{
Cell[5032, 170, 153, 5, 28, "Input",
 CellID->26662],
Cell[5188, 177, 154, 5, 36, "Output",
 CellID->18230]
}, Open  ]],
Cell[5357, 185, 120, 3, 70, "ExampleDelimiter",
 CellID->4428],
Cell[5480, 190, 72, 1, 70, "ExampleText",
 CellID->19438],
Cell[CellGroupData[{
Cell[5577, 195, 305, 11, 70, "Input",
 CellID->9547],
Cell[5885, 208, 199, 7, 36, "Output",
 CellID->16793]
}, Open  ]],
Cell[6099, 218, 121, 3, 70, "ExampleDelimiter",
 CellID->26348],
Cell[6223, 223, 192, 8, 70, "ExampleText",
 CellID->28138],
Cell[CellGroupData[{
Cell[6440, 235, 165, 6, 70, "Input",
 CellID->763],
Cell[6608, 243, 177, 6, 36, "Output",
 CellID->22743]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6834, 255, 239, 7, 70, "ExampleSection",
 CellID->18449],
Cell[7076, 264, 314, 12, 70, "ExampleText",
 CellID->20337],
Cell[CellGroupData[{
Cell[7415, 280, 169, 5, 70, "Input",
 CellID->27496],
Cell[7587, 287, 155, 5, 36, "Output",
 CellID->9459]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7791, 298, 233, 7, 70, "ExampleSection",
 CellID->30900],
Cell[8027, 307, 376, 15, 70, "ExampleText",
 CellID->6861],
Cell[CellGroupData[{
Cell[8428, 326, 153, 5, 70, "Input",
 CellID->21100],
Cell[8584, 333, 154, 5, 36, "Output",
 CellID->29183]
}, Open  ]],
Cell[CellGroupData[{
Cell[8775, 343, 191, 7, 70, "Input",
 CellID->8034],
Cell[8969, 352, 153, 5, 36, "Output",
 CellID->5267]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9171, 363, 225, 7, 70, "ExampleSection",
 CellID->6116],
Cell[9399, 372, 216, 8, 70, "ExampleText",
 CellID->5242],
Cell[CellGroupData[{
Cell[9640, 384, 167, 6, 70, "Input",
 CellID->15752],
Cell[9810, 392, 176, 6, 36, "Output",
 CellID->3735]
}, Open  ]],
Cell[10001, 401, 121, 3, 70, "ExampleDelimiter",
 CellID->31920],
Cell[10125, 406, 329, 12, 70, "ExampleText",
 CellID->31941],
Cell[CellGroupData[{
Cell[10479, 422, 118, 4, 70, "Input",
 CellID->4825],
Cell[10600, 428, 171, 6, 36, "Output",
 CellID->27984]
}, Open  ]],
Cell[CellGroupData[{
Cell[10808, 439, 123, 4, 70, "Input",
 CellID->10433],
Cell[10934, 445, 364, 14, 50, "Output",
 CellID->29469]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11359, 466, 311, 9, 70, "SeeAlsoSection",
 CellID->23172],
Cell[11673, 477, 910, 35, 70, "SeeAlso",
 CellID->3191]
}, Open  ]],
Cell[CellGroupData[{
Cell[12620, 517, 314, 9, 70, "TutorialsSection",
 CellID->17725],
Cell[12937, 528, 154, 3, 70, "Tutorials",
 CellID->11583]
}, Open  ]],
Cell[CellGroupData[{
Cell[13128, 536, 319, 9, 70, "MoreAboutSection",
 CellID->397209143],
Cell[13450, 547, 144, 3, 70, "MoreAbout",
 CellID->214780149],
Cell[13597, 552, 144, 3, 70, "MoreAbout",
 CellID->60752601],
Cell[13744, 557, 150, 3, 70, "MoreAbout",
 CellID->588492198]
}, Open  ]],
Cell[13909, 563, 27, 0, 70, "History"],
Cell[13939, 565, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

