(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    110379,       3019]
NotebookOptionsPosition[     99672,       2644]
NotebookOutlinePosition[    101083,       2683]
CellTagsIndexPosition[    100996,       2678]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orthogonal Polynomials" :> 
          Documentation`HelpLookup["paclet:tutorial/OrthogonalPolynomials"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Orthogonal Polynomials\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LegendreQ" :> Documentation`HelpLookup["paclet:ref/LegendreQ"],
           "SphericalHarmonicY" :> 
          Documentation`HelpLookup["paclet:ref/SphericalHarmonicY"], 
          "SpheroidalPS" :> 
          Documentation`HelpLookup["paclet:ref/SpheroidalPS"], "GegenbauerC" :> 
          Documentation`HelpLookup["paclet:ref/GegenbauerC"], "JacobiP" :> 
          Documentation`HelpLookup["paclet:ref/JacobiP"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LegendreQ\"\>", 2->"\<\"SphericalHarmonicY\"\>", 
       3->"\<\"SpheroidalPS\"\>", 4->"\<\"GegenbauerC\"\>", 
       5->"\<\"JacobiP\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions for Separable Coordinate Systems\"\>", 
       2->"\<\"Functions Used in Quantum Mechanics\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LegendreP", "ObjectName",
 CellID->20688],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LegendreP",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LegendreP"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Legendre polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["P", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LegendreP",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LegendreP"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the associated Legendre polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["P", "n", "m"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->6994]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "Explicit formulas are given for integers ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->7003],

Cell[TextData[{
 "The Legendre polynomials satisfy the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["d", "2"], "\[InvisibleSpace]", "y"}], "/", 
        RowBox[{"d", "\[InvisibleSpace]", 
         SuperscriptBox["x", "2"]}]}], ")"}]}], "-", 
     RowBox[{"2", "x", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "\[InvisibleSpace]", "y"}], "/", 
        RowBox[{"d", "\[InvisibleSpace]", "x"}]}], ")"}]}], "+", 
     RowBox[{"n", "\[InvisibleSpace]", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], "\[InvisibleSpace]", "y"}]}], "=", 
    "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->9299],

Cell["\<\
The Legendre polynomials are orthogonal with unit weight function. \
\>", "Notes",
 CellID->4775],

Cell[TextData[{
 "The associated Legendre polynomials are defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["P", "n", "m"], "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"m", "/", "2"}]], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d", "m"], "/", 
       RowBox[{"d", "\[InvisibleSpace]", 
        SuperscriptBox["x", "m"]}]}], ")"}], 
     RowBox[{
      SubscriptBox["P", "n"], "(", "x", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->1827],

Cell[TextData[{
 "For arbitrary complex values of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " give Legendre functions of the first kind. "
}], "Notes",
 CellID->6582],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives Legendre functions of type ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ". The default is type ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18077],

Cell[TextData[{
 "The symbolic form of type 1 involves ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["z", "2"]}], ")"}], 
    RowBox[{"m", "/", "2"}]], TraditionalForm]], "InlineMath"],
 ", of type 2 involves ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"m", "/", "2"}]], "/", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], 
     RowBox[{"m", "/", "2"}]]}], TraditionalForm]], "InlineMath"],
 " and of type 3 involves ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "z"}], ")"}], 
      RowBox[{"m", "/", "2"}]], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "z"}], ")"}]}], 
    RowBox[{"m", "/", "2"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->13304],

Cell[TextData[{
 "Type 1 is defined only for ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " within the unit circle in the complex plane. Type 2 represents an analytic \
continuation of type 1 outside the unit circle. "
}], "Notes",
 CellID->27109],

Cell[TextData[{
 "Type 2 functions have branch cuts from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane. "
}], "Notes",
 CellID->32660],

Cell[TextData[{
 "Type 3 functions have a single branch cut from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->17360],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric2F1Regularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric2F1Regularized"], "[", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["n", "TI"]}], ",", 
    RowBox[{
     StyleBox["n", "TI"], "+", "1"}], ",", 
    RowBox[{"1", "-", 
     StyleBox["m", "TI"]}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       StyleBox["z", "TI"]}], ")"}], "/", "2"}]}], "]"}]], "InlineFormula"],
 " multiplied by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"m", "/", "2"}]], "/", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], 
     RowBox[{"m", "/", "2"}]]}], TraditionalForm]], "InlineMath"],
 " for type 2 and by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"m", "/", "2"}]], "/", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "z"}], ")"}], 
     RowBox[{"m", "/", "2"}]]}], TraditionalForm]], "InlineMath"],
 " for type 3. "
}], "Notes",
 CellID->9261],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["LegendreP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreP"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->17939321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreP"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreP"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44716274],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->452495755],

Cell[TextData[{
 "Compute the 10",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " Legendre polynomial:"
}], "ExampleText",
 CellID->523069619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"10", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340121949],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "256"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "63"}], "+", 
    RowBox[{"3465", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"30030", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"90090", " ", 
     SuperscriptBox["x", "6"]}], "-", 
    RowBox[{"109395", " ", 
     SuperscriptBox["x", "8"]}], "+", 
    RowBox[{"46189", " ", 
     SuperscriptBox["x", "10"]}]}], ")"}]}]], "Output",
 ImageSize->{397, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112174708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252161789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"LegendreP", "[", 
    RowBox[{"10", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->334865119],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->802168197]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17896],

Cell[TextData[{
 "Compute the associated Legendre polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["P", "10", "2"], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->393201182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"10", ",", "2", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216121131],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["495", "128"]}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"7", "-", 
    RowBox[{"364", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2730", " ", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"6188", " ", 
     SuperscriptBox["x", "6"]}], "+", 
    RowBox[{"4199", " ", 
     SuperscriptBox["x", "8"]}]}], ")"}]}]], "Output",
 ImageSize->{336, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2214616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136792217],

Cell["Compute a half-integer associated Legendre function:", "ExampleText",
 CellID->292836148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4950792],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}]}], 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]], "Output",
 ImageSize->{197, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93789895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127540731],

Cell["Evaluate for fractional orders:", "ExampleText",
 CellID->204369770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1026262214],

Cell[BoxData["2.034342748581157`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216899410]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414133811],

Cell["Evaluate for complex orders and arguments:", "ExampleText",
 CellID->4320050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "/", "2"}], "+", "I"}], ",", 
   RowBox[{"1.5", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520242155],

Cell[BoxData[
 RowBox[{"5.204659495086079`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.29947945497630474`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51066495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103785716],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->113336957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"LegendreP", "[", 
    RowBox[{
     RowBox[{"3", "/", "2"}], ",", "2"}], "]"}], ",", "50"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->186586230],

Cell[BoxData["3.\
243939666040804915450228792970455767207515411017653870952807358518`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59327917]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->493308527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", "2.000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70173555],

Cell[BoxData["3.24393966604080491545022879255860110584`26.302336062198325"], \
"Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->201921195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20532249],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreP"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->588992016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63244004],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "x"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "3"]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{214, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232870983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13591990],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->23095068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LegendreP", "[", 
   RowBox[{"n", ",", "m", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121429025],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox[
    TagBox["P",
     LegendreP], "n", "m"], "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{32, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->715576241]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5539],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreP"]], "InlineFormula"],
 " can deal with real-valued intervals:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->101801384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"3", ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25403020],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "31"}], ",", "31"}], "}"}], "]"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18429951]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->181308297],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LegendreP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreP"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->112544170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", " ", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "5"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197685291],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     FractionBox["2", "\[Pi]"]]}], "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]]}]], "-", 
   FractionBox[
    RowBox[{"23", " ", 
     SuperscriptBox["x", "4"]}], 
    RowBox[{"48", " ", 
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   0, {-(2/Pi)^Rational[1, 2], 0, Rational[7, 2] (2 Pi)^Rational[-1, 2], 0, 
    Rational[-23, 48] (2 Pi)^Rational[-1, 2]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{221, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599165704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->319796208],

Cell[TextData[{
 "Different ",
 Cell[BoxData[
  ButtonBox["LegendreP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LegendreP"]], "InlineFormula"],
 " types give different symbolic forms:"
}], "ExampleText",
 CellID->868316270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"2", ",", "1", ",", "1", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85865882],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", "z", " ", 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["z", "2"]}]]}]], "Output",
 ImageSize->{83, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44081905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"2", ",", "1", ",", "2", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205513051],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", 
  SqrtBox[
   RowBox[{"1", "-", "z"}]], " ", "z", " ", 
  SqrtBox[
   RowBox[{"1", "+", "z"}]]}]], "Output",
 ImageSize->{122, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208433780]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"2", ",", "1", ",", "3", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6083004],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}], " ", "z", " ", 
    SqrtBox[
     RowBox[{"1", "+", "z"}]]}], 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", "z"}]]]}]], "Output",
 ImageSize->{123, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->363115489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211830054],

Cell["Types 2 and 3 have different branch cut structures:", "ExampleText",
 CellID->415200853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"LegendreP", "[", 
     RowBox[{"2", ",", "1", ",", "2", ",", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Abs", "[", "x", "]"}], ">", "1"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->215596748],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317889627]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"LegendreP", "[", 
     RowBox[{"2", ",", "1", ",", "3", ",", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"-", "1"}], "<", "x", "<", "1"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192489196],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80161350]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4262],

Cell["Angular momentum eigenfunctions:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->226929656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
         RowBox[{
          RowBox[{"f", "'"}], "[", "\[Theta]", "]"}]}], ",", "\[Theta]"}], 
       "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["m", "2"], 
      RowBox[{"f", "[", "\[Theta]", "]"}]}]}], "==", 
    RowBox[{
     RowBox[{"-", "\[Lambda]"}], 
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "+", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
     RowBox[{"f", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{"f", "[", "\[Theta]", "]"}], ",", "\[Theta]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->595684026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "\[Theta]", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"LegendreP", "[", 
       RowBox[{"\[Lambda]", ",", "m", ",", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LegendreQ", "[", 
       RowBox[{"\[Lambda]", ",", "m", ",", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->836516204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234199132],

Cell["\<\
Find quantum eigenfunctions for modified P\[ODoubleDot]schel\[Dash]Teller \
potential:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->25653568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"f", "''"}], "[", "x", "]"}]}], "-", 
     RowBox[{"j", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j", "+", "1"}], ")"}], "/", 
       RowBox[{
        RowBox[{"Cosh", "[", "x", "]"}], "^", "2"}]}], " ", 
      RowBox[{"f", "[", "x", "]"}]}]}], "==", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"n", "^", "2"}]}], " ", 
     RowBox[{"f", "[", "x", "]"}]}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->538712807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"LegendreP", "[", 
       RowBox[{"j", ",", "n", ",", 
        RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LegendreQ", "[", 
       RowBox[{"j", ",", "n", ",", 
        RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{476, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96669754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107518192],

Cell[TextData[{
 "Generalized Fourier transform for functions on interval ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " to ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->216996849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "+", 
      RowBox[{"1", "/", "2"}]}], ")"}], 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"LegendreP", "[", 
        RowBox[{"n", ",", "x"}], "]"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"Pi", " ", "x"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167276971],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["3", "\[Pi]"], ",", "0", ",", 
   FractionBox[
    RowBox[{"7", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "15"}], "+", 
       SuperscriptBox["\[Pi]", "2"]}], ")"}]}], 
    SuperscriptBox["\[Pi]", "3"]]}], "}"}]], "Output",
 ImageSize->{154, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72354318]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Pi", " ", "x"}], "]"}], ",", 
     RowBox[{"%", ".", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"LegendreP", "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "%", "]"}]}], "}"}]}], "]"}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->273457138],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->362772839]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15991],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand into simpler functions:"
}], "ExampleText",
 CellID->198009664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"LegendreP", "[", 
   RowBox[{
    FractionBox["3", "4"], ",", 
    FractionBox["1", "4"], ",", "2", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75070541],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"1", "/", "4"}]], " ", "x"}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], 
    RowBox[{"1", "/", "8"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], 
    RowBox[{"1", "/", "8"}]], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["3", "4"], "]"}]}]]], "Output",
 ImageSize->{186, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->564678260]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30538],

Cell["\<\
Cancellations in the polynomial form may lead to inaccurate numerical \
results:\
\>", "ExampleText",
 CellID->377633235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LegendreP", "[", 
   RowBox[{"60", ",", " ", "1", ",", "x"}], "]"}], "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"2", "/", "3"}], ",", "16"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300499535],

Cell[BoxData["0``-2.1882242489647385"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155320534]
}, Open  ]],

Cell["Evaluate the function directly:", "ExampleText",
 CellID->370676016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"60", ",", " ", "1", ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"2", "/", "3"}], ",", "16"}], "]"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60075057],

Cell[BoxData["1.15016667024023764849470610247`14.918202225944892"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70991757]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11646],

Cell["Visualize distribution of zeros:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->301669098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"n", ",", "x"}], "}"}], "/.", 
        RowBox[{"NSolve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"LegendreP", "[", 
            RowBox[{"n", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", "x"}], 
         "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "40"}], "}"}]}], "]"}], ",", "1"}], "]"}],
    ",", 
   RowBox[{"Axes", "\[Rule]", "False"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140751124],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69310961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->648462155],

Cell["Generalized Lissajous figures:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->233073333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LegendreP", "[", 
      RowBox[{"7", ",", "x"}], "]"}], ",", 
     RowBox[{"LegendreP", "[", 
      RowBox[{"13", ",", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->396600583],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82413679]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6132],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendreQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalHarmonicY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHarmonicY"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpheroidalPS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalPS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GegenbauerC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GegenbauerC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiP"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3056]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1302],

Cell[TextData[ButtonBox["Orthogonal Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrthogonalPolynomials"]], "Tutorials",
 CellID->207],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->1270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->36640026],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->789321949],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->186512111],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->70098683],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->62798213]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with LegendreP",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=LegendreP"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
LegendreP"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LegendreP - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 44.0771452}", "context" -> "System`", 
    "keywords" -> {
     "conical functions", "Legendre functions", "Legendre polynomials", 
      "ring functions", "toroidal functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LegendreP[n, x] gives the Legendre polynomial P_n (x). LegendreP[n, m, \
x] gives the associated Legendre polynomial SubsuperscriptBox[P, n, m](x). ", 
    "synonyms" -> {"Legendre P"}, "title" -> "LegendreP", "type" -> "Symbol", 
    "uri" -> "ref/LegendreP"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13012, 462, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->44716274]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 100853, 2671}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2923, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3546, 92, 47, 1, 70, "ObjectName",
 CellID->20688],
Cell[3596, 95, 1229, 41, 70, "Usage",
 CellID->6994]
}, Open  ]],
Cell[CellGroupData[{
Cell[4862, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5340, 158, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5463, 164, 233, 9, 70, "Notes",
 CellID->7003],
Cell[5699, 175, 848, 27, 70, "Notes",
 CellID->9299],
Cell[6550, 204, 107, 3, 70, "Notes",
 CellID->4775],
Cell[6660, 209, 720, 26, 70, "Notes",
 CellID->1827],
Cell[7383, 237, 800, 31, 70, "Notes",
 CellID->6582],
Cell[8186, 270, 512, 18, 70, "Notes",
 CellID->18077],
Cell[8701, 290, 956, 36, 70, "Notes",
 CellID->13304],
Cell[9660, 328, 270, 7, 70, "Notes",
 CellID->27109],
Cell[9933, 337, 570, 22, 70, "Notes",
 CellID->32660],
Cell[10506, 361, 287, 11, 70, "Notes",
 CellID->17360],
Cell[10796, 374, 1498, 55, 70, "Notes",
 CellID->9261],
Cell[12297, 431, 249, 8, 70, "Notes",
 CellID->17939321],
Cell[12549, 441, 220, 7, 70, "Notes",
 CellID->31226],
Cell[12772, 450, 203, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[13012, 462, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44716274],
Cell[CellGroupData[{
Cell[13396, 476, 148, 5, 70, "ExampleSection",
 CellID->452495755],
Cell[13547, 483, 180, 7, 70, "ExampleText",
 CellID->523069619],
Cell[CellGroupData[{
Cell[13752, 494, 129, 4, 28, "Input",
 CellID->340121949],
Cell[13884, 500, 593, 20, 51, "Output",
 CellID->112174708]
}, Open  ]],
Cell[14492, 523, 125, 3, 70, "ExampleDelimiter",
 CellID->252161789],
Cell[CellGroupData[{
Cell[14642, 530, 266, 9, 28, "Input",
 CellID->334865119],
Cell[14911, 541, 3661, 64, 134, "Output",
 Evaluatable->False,
 CellID->802168197]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18621, 611, 216, 7, 70, "ExampleSection",
 CellID->17896],
Cell[18840, 620, 250, 9, 70, "ExampleText",
 CellID->393201182],
Cell[CellGroupData[{
Cell[19115, 633, 139, 4, 70, "Input",
 CellID->216121131],
Cell[19257, 639, 622, 22, 51, "Output",
 CellID->2214616]
}, Open  ]],
Cell[19894, 664, 125, 3, 70, "ExampleDelimiter",
 CellID->136792217],
Cell[20022, 669, 95, 1, 70, "ExampleText",
 CellID->292836148],
Cell[CellGroupData[{
Cell[20142, 674, 184, 6, 70, "Input",
 CellID->4950792],
Cell[20329, 682, 745, 29, 82, "Output",
 CellID->93789895]
}, Open  ]],
Cell[21089, 714, 125, 3, 70, "ExampleDelimiter",
 CellID->127540731],
Cell[21217, 719, 74, 1, 70, "ExampleText",
 CellID->204369770],
Cell[CellGroupData[{
Cell[21316, 724, 155, 5, 70, "Input",
 CellID->1026262214],
Cell[21474, 731, 175, 5, 36, "Output",
 CellID->216899410]
}, Open  ]],
Cell[21664, 739, 125, 3, 70, "ExampleDelimiter",
 CellID->414133811],
Cell[21792, 744, 83, 1, 70, "ExampleText",
 CellID->4320050],
Cell[CellGroupData[{
Cell[21900, 749, 203, 7, 70, "Input",
 CellID->520242155],
Cell[22106, 758, 272, 7, 36, "Output",
 CellID->51066495]
}, Open  ]],
Cell[22393, 768, 125, 3, 70, "ExampleDelimiter",
 CellID->103785716],
Cell[22521, 773, 207, 5, 70, "ExampleText",
 CellID->113336957],
Cell[CellGroupData[{
Cell[22753, 782, 211, 8, 70, "Input",
 CellID->186586230],
Cell[22967, 792, 233, 7, 36, "Output",
 CellID->59327917]
}, Open  ]],
Cell[23215, 802, 113, 3, 70, "ExampleText",
 CellID->493308527],
Cell[CellGroupData[{
Cell[23353, 809, 182, 6, 70, "Input",
 CellID->70173555],
Cell[23538, 817, 219, 6, 36, "Output",
 CellID->201921195]
}, Open  ]],
Cell[23772, 826, 124, 3, 70, "ExampleDelimiter",
 CellID->20532249],
Cell[23899, 831, 212, 7, 70, "ExampleText",
 CellID->588992016],
Cell[CellGroupData[{
Cell[24136, 842, 186, 6, 70, "Input",
 CellID->63244004],
Cell[24325, 850, 594, 22, 51, "Output",
 CellID->232870983]
}, Open  ]],
Cell[24934, 875, 124, 3, 70, "ExampleDelimiter",
 CellID->13591990],
Cell[25061, 880, 202, 7, 70, "ExampleText",
 CellID->23095068],
Cell[CellGroupData[{
Cell[25288, 891, 180, 6, 70, "Input",
 CellID->121429025],
Cell[25471, 899, 293, 10, 52, "Output",
 CellID->715576241]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25813, 915, 238, 7, 70, "ExampleSection",
 CellID->5539],
Cell[26054, 924, 353, 11, 70, "ExampleText",
 CellID->101801384],
Cell[CellGroupData[{
Cell[26432, 939, 236, 8, 70, "Input",
 CellID->25403020],
Cell[26671, 949, 261, 9, 36, "Output",
 CellID->18429951]
}, Open  ]],
Cell[26947, 961, 125, 3, 70, "ExampleDelimiter",
 CellID->181308297],
Cell[27075, 966, 350, 11, 70, "ExampleText",
 CellID->112544170],
Cell[CellGroupData[{
Cell[27450, 981, 303, 10, 70, "Input",
 CellID->197685291],
Cell[27756, 993, 908, 31, 62, "Output",
 CellID->599165704]
}, Open  ]],
Cell[28679, 1027, 125, 3, 70, "ExampleDelimiter",
 CellID->319796208],
Cell[28807, 1032, 231, 8, 70, "ExampleText",
 CellID->868316270],
Cell[CellGroupData[{
Cell[29063, 1044, 147, 4, 70, "Input",
 CellID->85865882],
Cell[29213, 1050, 269, 10, 45, "Output",
 CellID->44081905]
}, Open  ]],
Cell[CellGroupData[{
Cell[29519, 1065, 148, 4, 70, "Input",
 CellID->205513051],
Cell[29670, 1071, 291, 11, 38, "Output",
 CellID->208433780]
}, Open  ]],
Cell[CellGroupData[{
Cell[29998, 1087, 146, 4, 70, "Input",
 CellID->6083004],
Cell[30147, 1093, 391, 15, 60, "Output",
 CellID->363115489]
}, Open  ]],
Cell[30553, 1111, 125, 3, 70, "ExampleDelimiter",
 CellID->211830054],
Cell[30681, 1116, 94, 1, 70, "ExampleText",
 CellID->415200853],
Cell[CellGroupData[{
Cell[30800, 1121, 701, 23, 70, "Input",
 CellID->215596748],
Cell[31504, 1146, 16117, 268, 70, "Output",
 Evaluatable->False,
 CellID->317889627]
}, Open  ]],
Cell[CellGroupData[{
Cell[47658, 1419, 699, 23, 70, "Input",
 CellID->192489196],
Cell[48360, 1444, 18910, 314, 70, "Output",
 Evaluatable->False,
 CellID->80161350]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67319, 1764, 222, 7, 70, "ExampleSection",
 CellID->4262],
Cell[67544, 1773, 212, 5, 70, "ExampleText",
 CellID->226929656],
Cell[CellGroupData[{
Cell[67781, 1782, 830, 26, 70, "Input",
 CellID->595684026],
Cell[68614, 1810, 673, 21, 36, "Output",
 CellID->836516204]
}, Open  ]],
Cell[69302, 1834, 125, 3, 70, "ExampleDelimiter",
 CellID->234199132],
Cell[69430, 1839, 273, 8, 70, "ExampleText",
 CellID->25653568],
Cell[CellGroupData[{
Cell[69728, 1851, 612, 21, 70, "Input",
 CellID->538712807],
Cell[70343, 1874, 637, 21, 36, "Output",
 CellID->96669754]
}, Open  ]],
Cell[70995, 1898, 125, 3, 70, "ExampleDelimiter",
 CellID->107518192],
Cell[71123, 1903, 223, 8, 70, "ExampleText",
 CellID->216996849],
Cell[CellGroupData[{
Cell[71371, 1915, 590, 20, 70, "Input",
 CellID->167276971],
Cell[71964, 1937, 436, 15, 57, "Output",
 CellID->72354318]
}, Open  ]],
Cell[CellGroupData[{
Cell[72437, 1957, 615, 21, 70, "Input",
 CellID->273457138],
Cell[73055, 1980, 6552, 111, 70, "Output",
 Evaluatable->False,
 CellID->362772839]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[79656, 2097, 233, 7, 70, "ExampleSection",
 CellID->15991],
Cell[79892, 2106, 232, 8, 70, "ExampleText",
 CellID->198009664],
Cell[CellGroupData[{
Cell[80149, 2118, 235, 7, 70, "Input",
 CellID->75070541],
Cell[80387, 2127, 543, 20, 63, "Output",
 CellID->564678260]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80979, 2153, 226, 7, 70, "ExampleSection",
 CellID->30538],
Cell[81208, 2162, 131, 4, 70, "ExampleText",
 CellID->377633235],
Cell[CellGroupData[{
Cell[81364, 2170, 279, 9, 70, "Input",
 CellID->300499535],
Cell[81646, 2181, 179, 5, 36, "Output",
 CellID->155320534]
}, Open  ]],
Cell[81840, 2189, 74, 1, 70, "ExampleText",
 CellID->370676016],
Cell[CellGroupData[{
Cell[81939, 2194, 229, 7, 70, "Input",
 CellID->60075057],
Cell[82171, 2203, 207, 5, 36, "Output",
 CellID->70991757]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82427, 2214, 224, 7, 70, "ExampleSection",
 CellID->11646],
Cell[82654, 2223, 212, 5, 70, "ExampleText",
 CellID->301669098],
Cell[CellGroupData[{
Cell[82891, 2232, 688, 22, 70, "Input",
 CellID->140751124],
Cell[83582, 2256, 4323, 75, 70, "Output",
 Evaluatable->False,
 CellID->69310961]
}, Open  ]],
Cell[87920, 2334, 125, 3, 70, "ExampleDelimiter",
 CellID->648462155],
Cell[88048, 2339, 210, 5, 70, "ExampleText",
 CellID->233073333],
Cell[CellGroupData[{
Cell[88283, 2348, 400, 13, 70, "Input",
 CellID->396600583],
Cell[88686, 2363, 6511, 111, 70, "Output",
 Evaluatable->False,
 CellID->82413679]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[95258, 2481, 310, 9, 70, "SeeAlsoSection",
 CellID->6132],
Cell[95571, 2492, 1219, 44, 70, "SeeAlso",
 CellID->3056]
}, Open  ]],
Cell[CellGroupData[{
Cell[96827, 2541, 313, 9, 70, "TutorialsSection",
 CellID->1302],
Cell[97143, 2552, 152, 3, 70, "Tutorials",
 CellID->207],
Cell[97298, 2557, 143, 3, 70, "Tutorials",
 CellID->1270]
}, Open  ]],
Cell[CellGroupData[{
Cell[97478, 2565, 318, 9, 70, "MoreAboutSection",
 CellID->36640026],
Cell[97799, 2576, 195, 4, 70, "MoreAbout",
 CellID->789321949],
Cell[97997, 2582, 178, 3, 70, "MoreAbout",
 CellID->186512111],
Cell[98178, 2587, 154, 3, 70, "MoreAbout",
 CellID->70098683],
Cell[98335, 2592, 144, 3, 70, "MoreAbout",
 CellID->62798213]
}, Open  ]],
Cell[CellGroupData[{
Cell[98516, 2600, 305, 8, 70, "RelatedLinksSection"],
Cell[98824, 2610, 363, 12, 70, "RelatedLinks"],
Cell[99190, 2624, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[99592, 2640, 50, 0, 70, "History"],
Cell[99645, 2642, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

