(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23872,        885]
NotebookOptionsPosition[     18704,        704]
NotebookOutlinePosition[     19979,        741]
CellTagsIndexPosition[     19894,        736]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Length" :> Documentation`HelpLookup["paclet:ref/Length"], 
          "Position" :> Documentation`HelpLookup["paclet:ref/Position"], 
          "TakeWhile" :> Documentation`HelpLookup["paclet:ref/TakeWhile"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Length\"\>", 
       2->"\<\"Position\"\>", 3->"\<\"TakeWhile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ListManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Functional Iteration\"\>", 3->"\<\"Functional Programming\"\>",
        4->"\<\"New in 6.0: List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LengthWhile", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LengthWhile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LengthWhile"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["crit", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of continuous elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " starting at the beginning of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " for which ",
     Cell[BoxData[
      RowBox[{
       StyleBox["crit", "TI"], "[", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->1030798883],

Cell["Find the length of the run of elements below 10:", "ExampleText",
 CellID->944758958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LengthWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
     "21"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", "<", "10"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->649655998],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67219196]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Elements of the list can be any expression:", "ExampleText",
 CellID->330266191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LengthWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "Pi", ",", "3", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "10"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Head", "[", "#", "]"}], "=!=", "List"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431239928],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330643141]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Find the length of the run of digits in ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " before a 7 occurs:"
}], "ExampleText",
 CellID->18165256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LengthWhile", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{"RealDigits", "[", 
     RowBox[{"Pi", ",", "10", ",", "100"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"#", "!=", "7"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268758183],

Cell[BoxData["13"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->755966826]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LengthWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LengthWhile"]], "InlineFormula"],
 " gives the length of the result from ",
 Cell[BoxData[
  ButtonBox["TakeWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TakeWhile"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12995697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
     "21"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", "<", "10"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->929400656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->499859442]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LengthWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
     "21"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", "<", "10"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->580366616],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81547082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->438254890],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LengthWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LengthWhile"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  RowBox[{
   StyleBox["crit", "TI"], "[", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for all elements:"
}], "ExampleText",
 CellID->47453321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LengthWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
     "21"}], "}"}], ",", "NumberQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166616232],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21516843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
    "21"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->741196323],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->558025687]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->833324505],

Cell[TextData[{
 "Otherwise it is 1 less than the first position for which ",
 Cell[BoxData[
  RowBox[{
   StyleBox["crit", "TI"], "[", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " is not ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->73354741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
    "21"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194807893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
   "21"}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->741394779]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LengthWhile", "[", 
  RowBox[{"data", ",", "OddQ"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->487810738],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->461512512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"OddQ", ",", "data"}], "]"}], ",", 
     RowBox[{"_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Not", "[", 
         RowBox[{"TrueQ", "[", "#", "]"}], "]"}], "&"}], ")"}]}], ",", 
     RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", "1"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->392756414],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->61630225]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "The count terminates for any value of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["crit", "TI"], "[", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " that is not ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->42305798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LengthWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"E", ",", "8", ",", "a", ",", "b", ",", "20", ",", "1.4"}], "}"}],
    ",", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"NumericQ", "[", "#", "]"}], ",", "True", ",", "#"}], "]"}], 
    "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162460669],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78617502]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"NumericQ", "[", "#", "]"}], ",", "True", ",", "#"}], "]"}], 
    "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"E", ",", "8", ",", "a", ",", "b", ",", "20", ",", "1.4"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127627803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "a", ",", "b", ",", "True", ",", "True"}],
   "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->527939906]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TakeWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TakeWhile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->15225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->99870726],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->66201896],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->143557073],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->106861535]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LengthWhile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 46.6865870}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LengthWhile[list, crit] gives the number of continuous elements e_i \
starting at the beginning of list for which crit[e_i] is True.", 
    "synonyms" -> {"length while"}, "title" -> "LengthWhile", "type" -> 
    "Symbol", "uri" -> "ref/LengthWhile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5789, 164, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19759, 729}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2426, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3049, 83, 1576, 37, 70, "ObjectNameGrid"],
Cell[4628, 122, 1124, 37, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5789, 164, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[6166, 178, 149, 5, 70, "ExampleSection",
 CellID->1030798883],
Cell[6318, 185, 91, 1, 70, "ExampleText",
 CellID->944758958],
Cell[CellGroupData[{
Cell[6434, 190, 297, 10, 28, "Input",
 CellID->649655998],
Cell[6734, 202, 157, 5, 36, "Output",
 CellID->67219196]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6940, 213, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[7164, 222, 86, 1, 70, "ExampleText",
 CellID->330266191],
Cell[CellGroupData[{
Cell[7275, 227, 433, 14, 70, "Input",
 CellID->431239928],
Cell[7711, 243, 158, 5, 36, "Output",
 CellID->330643141]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7918, 254, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[8148, 263, 182, 6, 70, "ExampleText",
 CellID->18165256],
Cell[CellGroupData[{
Cell[8355, 273, 287, 9, 70, "Input",
 CellID->268758183],
Cell[8645, 284, 159, 5, 36, "Output",
 CellID->755966826]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8853, 295, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[9094, 304, 346, 12, 70, "ExampleText",
 CellID->12995697],
Cell[CellGroupData[{
Cell[9465, 320, 295, 10, 70, "Input",
 CellID->929400656],
Cell[9763, 332, 247, 8, 36, "Output",
 CellID->499859442]
}, Open  ]],
Cell[CellGroupData[{
Cell[10047, 345, 297, 10, 70, "Input",
 CellID->580366616],
Cell[10347, 357, 157, 5, 36, "Output",
 CellID->81547082]
}, Open  ]],
Cell[10519, 365, 125, 3, 70, "ExampleDelimiter",
 CellID->438254890],
Cell[10647, 370, 616, 24, 70, "ExampleText",
 CellID->47453321],
Cell[CellGroupData[{
Cell[11288, 398, 258, 8, 70, "Input",
 CellID->166616232],
Cell[11549, 408, 157, 5, 36, "Output",
 CellID->21516843]
}, Open  ]],
Cell[CellGroupData[{
Cell[11743, 418, 220, 7, 70, "Input",
 CellID->741196323],
Cell[11966, 427, 158, 5, 36, "Output",
 CellID->558025687]
}, Open  ]],
Cell[12139, 435, 125, 3, 70, "ExampleDelimiter",
 CellID->833324505],
Cell[12267, 440, 398, 15, 70, "ExampleText",
 CellID->73354741],
Cell[CellGroupData[{
Cell[12690, 459, 213, 7, 70, "Input",
 CellID->194807893],
Cell[12906, 468, 273, 9, 36, "Output",
 CellID->741394779]
}, Open  ]],
Cell[CellGroupData[{
Cell[13216, 482, 136, 4, 70, "Input",
 CellID->487810738],
Cell[13355, 488, 158, 5, 36, "Output",
 CellID->461512512]
}, Open  ]],
Cell[CellGroupData[{
Cell[13550, 498, 497, 16, 70, "Input",
 CellID->392756414],
Cell[14050, 516, 157, 5, 36, "Output",
 CellID->61630225]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14256, 527, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[14490, 536, 384, 15, 70, "ExampleText",
 CellID->42305798],
Cell[CellGroupData[{
Cell[14899, 555, 359, 12, 70, "Input",
 CellID->162460669],
Cell[15261, 569, 157, 5, 36, "Output",
 CellID->78617502]
}, Open  ]],
Cell[CellGroupData[{
Cell[15455, 579, 352, 12, 70, "Input",
 CellID->127627803],
Cell[15810, 593, 259, 8, 36, "Output",
 CellID->527939906]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16130, 608, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16449, 619, 698, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[17184, 650, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[17505, 661, 167, 3, 70, "Tutorials",
 CellID->15225]
}, Open  ]],
Cell[CellGroupData[{
Cell[17709, 669, 299, 8, 70, "MoreAboutSection"],
Cell[18011, 679, 143, 3, 70, "MoreAbout",
 CellID->99870726],
Cell[18157, 684, 150, 3, 70, "MoreAbout",
 CellID->66201896],
Cell[18310, 689, 155, 3, 70, "MoreAbout",
 CellID->143557073],
Cell[18468, 694, 164, 3, 70, "MoreAbout",
 CellID->106861535]
}, Open  ]],
Cell[18647, 700, 27, 0, 70, "History"],
Cell[18677, 702, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

