(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    103001,       3292]
NotebookOptionsPosition[     87787,       2754]
NotebookOutlinePosition[     89155,       2793]
CellTagsIndexPosition[     89069,       2788]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LessEqual" :> Documentation`HelpLookup["paclet:ref/LessEqual"],
           "Greater" :> Documentation`HelpLookup["paclet:ref/Greater"], 
          "Positive" :> Documentation`HelpLookup["paclet:ref/Positive"], 
          "Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "RegionPlot" :> Documentation`HelpLookup["paclet:ref/RegionPlot"], 
          "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LessEqual\"\>", 
       2->"\<\"Greater\"\>", 3->"\<\"Positive\"\>", 4->"\<\"Element\"\>", 
       5->"\<\"RegionPlot\"\>", 
       6->"\<\"RegionPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Inequalities\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Less ",
 StyleBox["(<)", "OperatorCharacter"]
}], "ObjectName",
 CellID->5145],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "<", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " is determined to be less than ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], "<", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], "<", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["3", "TR"]]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     " form a strictly increasing sequence. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21933]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " when its arguments are real numbers. "
}], "Notes",
 CellID->25718],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " does some simplification when its arguments are not numbers. "
}], "Notes",
 CellID->13880],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " internally uses numerical approximations to establish numerical ordering. \
This process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7309]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->343071883],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->348403669],

Cell["Compare numbers:", "ExampleText",
 CellID->388749173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "<", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107391370],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33405018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "/", "17"}], "<", 
  RowBox[{"1", "/", "5"}], "<", 
  RowBox[{"Pi", "/", "10"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->765975626],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->530088003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->220123181],

Cell["Represent an inequality:", "ExampleText",
 CellID->7636295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"2", "x"}], "+", "1"}], "<", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402385732],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "3"]}], "<", "0"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25584289]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34392874],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}], "<", "x", "<", "1"}]}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->246088091]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->37986389],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Numeric Inequalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26431756],

Cell["Inequalities are defined only for real numbers:", "ExampleText",
 CellID->174079165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I", "<", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251460291],

Cell[BoxData[
 RowBox[{
  RowBox[{"Less", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\) attempted. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"Less::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->730258516],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", "<", "0"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->931688412]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44752292],

Cell["Compare rational numbers:", "ExampleText",
 CellID->234143528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "/", "2"}], "<", 
  RowBox[{"5", "/", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241292235],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148930065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153441603],

Cell["\<\
Approximate numbers that differ in at most their last eight binary digits are \
considered equal:\
\>", "ExampleText",
 CellID->34490633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "<", 
  RowBox[{"1.", "+", 
   RowBox[{
    RowBox[{"2", "^", "7"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37738947],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->504561010]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "<", 
  RowBox[{"1.", "+", 
   RowBox[{
    RowBox[{"2", "^", "8"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525645198],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99313453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87890771],

Cell["\<\
Compare an exact numeric expression and an approximate number:\
\>", "ExampleText",
 CellID->125178221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "<", "Pi"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315310371],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->912548784]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "<", 
  RowBox[{"Pi", 
   RowBox[{"(", 
    RowBox[{"1", "+", " ", 
     RowBox[{
      RowBox[{"2", "^", "12"}], " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "20"}]}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331846797],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->492969210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120733594],

Cell["\<\
Compare two exact numeric expressions; a numeric test may suffice to prove \
inequality:\
\>", "ExampleText",
 CellID->59148399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pi", "^", "E"}], "<", 
  RowBox[{"E", "^", "Pi"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398884990],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102411611]
}, Open  ]],

Cell["Disproving this inequality requires symbolic methods:", "ExampleText",
 CellID->207797078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "<", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"5", "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142094998],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->216307159]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5671903],

Cell[TextData[{
 "Symbolic and numeric methods used by ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " are insufficient to disprove this inequality:"
}], "ExampleText",
 CellID->135341977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "<", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "4"}], "-", 
      RowBox[{"10", 
       RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180221533],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\@2 + \\@3 - \\(\\(Root[\\(\\(\\(\\(\\(\\(1 - \
\\(\\(10\\\\ \\(Slot[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\)\\) + #1\\^4\\)\\) &\\)\\), 4, \
0\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->362360283],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "<", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]], "Output",
 ImageSize->{238, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->708967256]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " to decide the sign of algebraic numbers:"
}], "ExampleText",
 CellID->332144497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"%", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "<", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195979928],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->299322912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182534097],

Cell[TextData[{
 "Numeric methods used by ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " do not use sufficient precision to prove this inequality:"
}], "ExampleText",
 CellID->192423184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "<", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "4"}], "-", 
       RowBox[{"10", 
        RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], "+", 
   
   RowBox[{"10", "^", 
    RowBox[{"-", "100"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1546846],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(-\\(\\(1\\/\\(10000000000000000000000 \
\\(\\(\[LeftSkeleton] 54 \[RightSkeleton]\\)\\) \
000000000000000000000000\\)\\)\\)\\)\\) + \\@2 + \\@3 - \
\\(\\(Root[\\(\\(\\(\\(\\(\\(1 - \\(\\(10\\\\ \\(Slot[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\)\\) + #1\\^4\\)\\) &\\)\\), 4, \
0\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->593111767],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "<", 
  RowBox[{
   RowBox[{
   "1", "/", 
    "1000000000000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000"}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}]], "Output",
 ImageSize->{557, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139614176]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " proves the inequality using exact methods:"
}], "ExampleText",
 CellID->243941279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"%", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "<", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->476886642],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200961509]
}, Open  ]],

Cell[TextData[{
 "Increasing ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " may also prove the inequality:"
}], "ExampleText",
 CellID->304747643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "<", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "4"}], "-", 
         RowBox[{"10", 
          RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], 
     "+", 
     RowBox[{"10", "^", 
      RowBox[{"-", "100"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1018235179],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->398638185]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Inequalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->500815976],

Cell[TextData[{
 "Symbolic inequalities remain unevaluated, since ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " may not be a real number:"
}], "ExampleText",
 CellID->152622296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "<", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148403671],

Cell[BoxData[
 RowBox[{"x", "<", "x"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445363652]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to re-evaluate the inequality assuming that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is real:"
}], "ExampleText",
 CellID->66354079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205622433],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->578652116]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->154669696],

Cell["A symbolic inequality:", "ExampleText",
 CellID->156588813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ineq", "=", 
  RowBox[{"1", "<", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], "<", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486416913],

Cell[BoxData[
 RowBox[{"1", "<", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}], "<", "2"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->478423671]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find an explicit description of the solution set:"
}], "ExampleText",
 CellID->13316198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145270882],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox["2"]}], "<", "x", "<", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"2", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"2", "-", 
          SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], "<", "y", "<", 
       SqrtBox[
        RowBox[{"2", "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"1", "<", "x", "<", 
     SqrtBox["2"]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"2", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{442, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->337868867]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find a solution instance:"
}], "ExampleText",
 CellID->220870228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->159052583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", 
     SqrtBox[
      FractionBox["3", "2"]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{128, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->827108696]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " to optimize over the inequality-defined region:"
}], "ExampleText",
 CellID->279307693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], ",", "ineq"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->34810484],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no minimum in the region described by the \
constraints; returning a result on the boundary. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Minimize/wksol\\\", ButtonNote -> \
\\\"Minimize::wksol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->632794107],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{154, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->246195697]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to simplify under the inequality-defined assumptions:"
}], "ExampleText",
 CellID->266015669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}], "]"}], ",", "ineq"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->450815041],

Cell[BoxData[
 RowBox[{"2", "-", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->897813]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->136112774],

Cell[TextData[{
 "The negation of two-argument ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14000026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "<", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785552779],

Cell[BoxData[
 RowBox[{"x", "\[GreaterEqual]", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229573249]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->365519717],

Cell[TextData[{
 "The negation of three-argument ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " does not simplify automatically:"
}], "ExampleText",
 CellID->179461278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "<", "y", "<", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->900203775],

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"x", "<", "y", "<", "z"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418242264]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to express it in terms of two-argument ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103307650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->602057068],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[GreaterEqual]", "y"}], "||", 
  RowBox[{"y", "\[GreaterEqual]", "z"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30284692]
}, Open  ]],

Cell[TextData[{
 "This is not equivalent to three-argument ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22272967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"x", "\[GreaterEqual]", "y", "\[GreaterEqual]", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41719149],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[GreaterEqual]", "y"}], "&&", 
  RowBox[{"y", "\[GreaterEqual]", "z"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->239030389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81878561],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " cannot decide inequality between numeric expressions it returns \
unchanged:"
}], "ExampleText",
 CellID->294478095],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}], "/", "2"}]}], 
  ";"}], "\n", 
 RowBox[{"a", "<", "b"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->174240470],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(Log[\\(\\(\\@2 + \\@3\\)\\)]\\)\\) - \\(\
\\(1\\/2\\\\ \\(\\(Log[\\(\\(5 + \\(\\(2\\\\ \
\\@6\\)\\)\\)\\)]\\)\\)\\)\\)\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->530252097],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], "]"}], "<", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}]}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31526973]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses exact symbolic transformations to disprove the inequality:"
}], "ExampleText",
 CellID->60898104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106030961],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->232070952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351323024],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Negative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Negative"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "\[Element]", 
     TagBox["\[DoubleStruckCapitalR]",
      Function[{}, Reals]]}], "\[And]", 
    RowBox[{"x", "<", "0"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->265821182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Negative", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "I"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->875674151],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "False", ",", "False"}], "}"}]], "Output",\

 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->564425204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353480865],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve inequalities:"
}], "ExampleText",
 CellID->19228497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"3", "x"}], "+", "2"}], "<", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->821314495],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "<", "x", "<", 
   "1"}]}]], "Output",
 ImageSize->{504, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140243207]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "<", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23944515],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "4"]}]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "4"]}]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}]]}]}], ")"}]}]], "Output",
 ImageSize->{307, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->463821729]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->594673202],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find solution instances:"
}], "ExampleText",
 CellID->15549558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "<", 
    RowBox[{"-", 
     RowBox[{"z", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349268992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["1", 
      SqrtBox["2"]]}], ",", 
    RowBox[{"y", "\[Rule]", "0"}], ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{166, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->431245726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179330792],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 " to visualize solution sets of inequalities:"
}], "ExampleText",
 CellID->101578669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "<", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412249041],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311131464]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "<", 
    RowBox[{"-", 
     RowBox[{"z", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->467824785],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->147217818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146025985],

Cell["Inequality assumptions:", "ExampleText",
 CellID->342383645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", "<", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610693880],

Cell[BoxData[
 RowBox[{"-", "x"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314444252]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"a", "^", "n"}], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "a", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135321853],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234589721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->434755261],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " to solve optimization problems constrained by inequalities:"
}], "ExampleText",
 CellID->28281205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "^", "2"}], "-", 
       RowBox[{"4", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"x", "^", "4"}]}]}], "<", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140887538],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no minimum in the region described by the \
constraints; returning a result on the boundary. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Minimize/wksol\\\", ButtonNote -> \
\\\"Minimize::wksol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->813781046],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"27", "-", 
       RowBox[{"207", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"64", " ", 
        SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"27", "-", 
           RowBox[{"207", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"64", " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], "+", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"48", "-", 
           RowBox[{"111", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"64", " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}]}], ",", 
     
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"48", "-", 
          RowBox[{"111", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{441, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->976651358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38718160],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " to numerically solve constrained optimization problems:"
}], "ExampleText",
 CellID->445549592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", " ", 
     RowBox[{"1", "<", 
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], "+", 
       RowBox[{"Tan", "[", "y", "]"}]}], "<", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4920993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.1401408407383853`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.5700700002562602`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "1.5700708404821253`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203464789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->290571492],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " a function over the solution set of inequalities:"
}], "ExampleText",
 CellID->96643702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"Boole", "[", 
     RowBox[{"1", "<", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16786161],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", "\[Pi]"}], "4"]], "Output",
 ImageSize->{27, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->556122115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->379263837],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Quartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartiles"]], "InlineFormula"],
 " to the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " greatest number(s): "
}], "ExampleText",
 CellID->798766],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->662995740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x1", "<", "x2", "<", "x3"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10873149],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165119053]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{"x2", ",", "x3", ",", "x1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81695411],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->404502323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->270141323],

Cell["\<\
Inequalities for machine-precision approximate numbers can be subtle: \
\>", "ExampleText",
 CellID->46241802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.00001", "<", 
  RowBox[{"2.00006", "-", "2.00005"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107589248],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114991526]
}, Open  ]],

Cell["The strict inequality is based on extra digits:", "ExampleText",
 CellID->41469938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385657575],

Cell["0.000010000000000065512", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->172179241]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286128809],

Cell["\<\
Arbitrary-precision approximate numbers do not have this problem:\
\>", "ExampleText",
 CellID->62759660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.00001`16", "<", 
  RowBox[{"2.00006`16", "-", "2.00005`16"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108479341],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44544851]
}, Open  ]],

Cell[TextData[{
 "Thanks to automatic precision tracking, ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " knows to look only at the first ten digits:"
}], "ExampleText",
 CellID->446345418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"2.00006`16", "-", "2.00005`16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501825511],

Cell[BoxData["10.397928065738002`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->322434078]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194684669],

Cell["\<\
In this case, inequality between machine numbers gives the expected result:\
\>", "ExampleText",
 CellID->528956563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.1", "<", 
  RowBox[{"2.6", "-", "2.5"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544352754],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142489473]
}, Open  ]],

Cell[TextData[{
 "The extra digits in this case are ignored by ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->153335021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->551042265],

Cell["0.10000000000000009", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->171811128]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->961],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LessEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LessEqual"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Greater",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Greater"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Positive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Positive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8807]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5361],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->12045]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->851247964],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->967423949]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Less (<) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 52.8429946}", "context" -> "System`", 
    "keywords" -> {
     "inequality", "less", "less than", "strict inequality", 
      "strictly less than", "strong inequality"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "x < y yields True if x is determined to be less than y. x_1 < x_2 < x_3 \
yields True if the x_i form a strictly increasing sequence. ", 
    "synonyms" -> {"<"}, "title" -> "Less", "type" -> "Symbol", "uri" -> 
    "ref/Less"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6077, 203, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->343071883]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 88926, 2781}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2273, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2896, 81, 96, 4, 70, "ObjectName",
 CellID->5145],
Cell[2995, 87, 1378, 47, 70, "Usage",
 CellID->21933]
}, Open  ]],
Cell[CellGroupData[{
Cell[4410, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4888, 156, 442, 17, 70, "Notes",
 CellID->25718],
Cell[5333, 175, 221, 7, 70, "Notes",
 CellID->13880],
Cell[5557, 184, 483, 14, 70, "Notes",
 CellID->7309]
}, Closed]],
Cell[CellGroupData[{
Cell[6077, 203, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->343071883],
Cell[CellGroupData[{
Cell[6462, 217, 148, 5, 70, "ExampleSection",
 CellID->348403669],
Cell[6613, 224, 59, 1, 70, "ExampleText",
 CellID->388749173],
Cell[CellGroupData[{
Cell[6697, 229, 92, 3, 28, "Input",
 CellID->107391370],
Cell[6792, 234, 161, 5, 36, "Output",
 CellID->33405018]
}, Open  ]],
Cell[CellGroupData[{
Cell[6990, 244, 174, 6, 28, "Input",
 CellID->765975626],
Cell[7167, 252, 161, 5, 36, "Output",
 CellID->530088003]
}, Open  ]],
Cell[7343, 260, 125, 3, 70, "ExampleDelimiter",
 CellID->220123181],
Cell[7471, 265, 65, 1, 70, "ExampleText",
 CellID->7636295],
Cell[CellGroupData[{
Cell[7561, 270, 168, 6, 70, "Input",
 CellID->402385732],
Cell[7732, 278, 261, 9, 36, "Output",
 CellID->25584289]
}, Open  ]],
Cell[CellGroupData[{
Cell[8030, 292, 124, 4, 70, "Input",
 CellID->34392874],
Cell[8157, 298, 510, 20, 51, "Output",
 CellID->246088091]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8716, 324, 219, 7, 70, "ExampleSection",
 CellID->37986389],
Cell[CellGroupData[{
Cell[8960, 335, 240, 7, 70, "ExampleSubsection",
 CellID->26431756],
Cell[9203, 344, 90, 1, 70, "ExampleText",
 CellID->174079165],
Cell[CellGroupData[{
Cell[9318, 349, 92, 3, 70, "Input",
 CellID->251460291],
Cell[9413, 354, 375, 7, 70, "Message",
 CellID->730258516],
Cell[9791, 363, 192, 6, 36, "Output",
 CellID->931688412]
}, Open  ]],
Cell[9998, 372, 124, 3, 70, "ExampleDelimiter",
 CellID->44752292],
Cell[10125, 377, 68, 1, 70, "ExampleText",
 CellID->234143528],
Cell[CellGroupData[{
Cell[10218, 382, 138, 5, 70, "Input",
 CellID->241292235],
Cell[10359, 389, 161, 5, 36, "Output",
 CellID->148930065]
}, Open  ]],
Cell[10535, 397, 125, 3, 70, "ExampleDelimiter",
 CellID->153441603],
Cell[10663, 402, 147, 4, 70, "ExampleText",
 CellID->34490633],
Cell[CellGroupData[{
Cell[10835, 410, 213, 8, 70, "Input",
 CellID->37738947],
Cell[11051, 420, 162, 5, 36, "Output",
 CellID->504561010]
}, Open  ]],
Cell[CellGroupData[{
Cell[11250, 430, 214, 8, 70, "Input",
 CellID->525645198],
Cell[11467, 440, 160, 5, 36, "Output",
 CellID->99313453]
}, Open  ]],
Cell[11642, 448, 124, 3, 70, "ExampleDelimiter",
 CellID->87890771],
Cell[11769, 453, 113, 3, 70, "ExampleText",
 CellID->125178221],
Cell[CellGroupData[{
Cell[11907, 460, 147, 5, 70, "Input",
 CellID->315310371],
Cell[12057, 467, 162, 5, 36, "Output",
 CellID->912548784]
}, Open  ]],
Cell[CellGroupData[{
Cell[12256, 477, 325, 12, 70, "Input",
 CellID->331846797],
Cell[12584, 491, 161, 5, 36, "Output",
 CellID->492969210]
}, Open  ]],
Cell[12760, 499, 125, 3, 70, "ExampleDelimiter",
 CellID->120733594],
Cell[12888, 504, 138, 4, 70, "ExampleText",
 CellID->59148399],
Cell[CellGroupData[{
Cell[13051, 512, 140, 5, 70, "Input",
 CellID->398884990],
Cell[13194, 519, 161, 5, 36, "Output",
 CellID->102411611]
}, Open  ]],
Cell[13370, 527, 96, 1, 70, "ExampleText",
 CellID->207797078],
Cell[CellGroupData[{
Cell[13491, 532, 288, 10, 70, "Input",
 CellID->142094998],
Cell[13782, 544, 162, 5, 36, "Output",
 CellID->216307159]
}, Open  ]],
Cell[13959, 552, 123, 3, 70, "ExampleDelimiter",
 CellID->5671903],
Cell[14085, 557, 257, 8, 70, "ExampleText",
 CellID->135341977],
Cell[CellGroupData[{
Cell[14367, 569, 372, 14, 70, "Input",
 CellID->180221533],
Cell[14742, 585, 591, 11, 70, "Message",
 CellID->362360283],
Cell[15336, 598, 428, 16, 41, "Output",
 CellID->708967256]
}, Open  ]],
Cell[15779, 617, 231, 8, 70, "ExampleText",
 CellID->332144497],
Cell[CellGroupData[{
Cell[16035, 629, 265, 9, 70, "Input",
 CellID->195979928],
Cell[16303, 640, 162, 5, 36, "Output",
 CellID->299322912]
}, Open  ]],
Cell[16480, 648, 125, 3, 70, "ExampleDelimiter",
 CellID->182534097],
Cell[16608, 653, 256, 8, 70, "ExampleText",
 CellID->192423184],
Cell[CellGroupData[{
Cell[16889, 665, 447, 17, 70, "Input",
 CellID->1546846],
Cell[17339, 684, 729, 13, 70, "Message",
 CellID->593111767],
Cell[18071, 699, 593, 21, 75, "Output",
 CellID->139614176]
}, Open  ]],
Cell[18679, 723, 224, 7, 70, "ExampleText",
 CellID->243941279],
Cell[CellGroupData[{
Cell[18928, 734, 265, 9, 70, "Input",
 CellID->476886642],
Cell[19196, 745, 161, 5, 36, "Output",
 CellID->200961509]
}, Open  ]],
Cell[19372, 753, 244, 8, 70, "ExampleText",
 CellID->304747643],
Cell[CellGroupData[{
Cell[19641, 765, 602, 21, 70, "Input",
 CellID->1018235179],
Cell[20246, 788, 161, 5, 36, "Output",
 CellID->398638185]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20456, 799, 242, 7, 70, "ExampleSubsection",
 CellID->500815976],
Cell[20701, 808, 194, 6, 70, "ExampleText",
 CellID->152622296],
Cell[CellGroupData[{
Cell[20920, 818, 92, 3, 70, "Input",
 CellID->148403671],
Cell[21015, 823, 180, 6, 36, "Output",
 CellID->445363652]
}, Open  ]],
Cell[21210, 832, 297, 11, 70, "ExampleText",
 CellID->66354079],
Cell[CellGroupData[{
Cell[21532, 847, 189, 6, 70, "Input",
 CellID->205622433],
Cell[21724, 855, 162, 5, 36, "Output",
 CellID->578652116]
}, Open  ]],
Cell[21901, 863, 125, 3, 70, "ExampleDelimiter",
 CellID->154669696],
Cell[22029, 868, 65, 1, 70, "ExampleText",
 CellID->156588813],
Cell[CellGroupData[{
Cell[22119, 873, 202, 7, 70, "Input",
 CellID->486416913],
Cell[22324, 882, 263, 9, 36, "Output",
 CellID->478423671]
}, Open  ]],
Cell[22602, 894, 234, 8, 70, "ExampleText",
 CellID->13316198],
Cell[CellGroupData[{
Cell[22861, 906, 177, 6, 70, "Input",
 CellID->145270882],
Cell[23041, 914, 1446, 54, 116, "Output",
 CellID->337868867]
}, Open  ]],
Cell[24502, 971, 223, 8, 70, "ExampleText",
 CellID->220870228],
Cell[CellGroupData[{
Cell[24750, 983, 183, 6, 70, "Input",
 CellID->159052583],
Cell[24936, 991, 330, 12, 60, "Output",
 CellID->827108696]
}, Open  ]],
Cell[25281, 1006, 234, 8, 70, "ExampleText",
 CellID->279307693],
Cell[CellGroupData[{
Cell[25540, 1018, 307, 11, 70, "Input",
 CellID->34810484],
Cell[25850, 1031, 440, 8, 70, "Message",
 CellID->632794107],
Cell[26293, 1041, 375, 14, 43, "Output",
 CellID->246195697]
}, Open  ]],
Cell[26683, 1058, 236, 8, 70, "ExampleText",
 CellID->266015669],
Cell[CellGroupData[{
Cell[26944, 1070, 269, 10, 70, "Input",
 CellID->450815041],
Cell[27216, 1082, 201, 7, 36, "Output",
 CellID->897813]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27478, 1096, 238, 7, 70, "ExampleSection",
 CellID->136112774],
Cell[27719, 1105, 339, 13, 70, "ExampleText",
 CellID->14000026],
Cell[CellGroupData[{
Cell[28083, 1122, 122, 4, 70, "Input",
 CellID->785552779],
Cell[28208, 1128, 194, 6, 36, "Output",
 CellID->229573249]
}, Open  ]],
Cell[28417, 1137, 125, 3, 70, "ExampleDelimiter",
 CellID->365519717],
Cell[28545, 1142, 238, 8, 70, "ExampleText",
 CellID->179461278],
Cell[CellGroupData[{
Cell[28808, 1154, 132, 4, 70, "Input",
 CellID->900203775],
Cell[28943, 1160, 208, 7, 36, "Output",
 CellID->418242264]
}, Open  ]],
Cell[29166, 1170, 369, 13, 70, "ExampleText",
 CellID->103307650],
Cell[CellGroupData[{
Cell[29560, 1187, 109, 3, 70, "Input",
 CellID->602057068],
Cell[29672, 1192, 254, 8, 36, "Output",
 CellID->30284692]
}, Open  ]],
Cell[29941, 1203, 231, 8, 70, "ExampleText",
 CellID->22272967],
Cell[CellGroupData[{
Cell[30197, 1215, 172, 5, 70, "Input",
 CellID->41719149],
Cell[30372, 1222, 255, 8, 36, "Output",
 CellID->239030389]
}, Open  ]],
Cell[30642, 1233, 124, 3, 70, "ExampleDelimiter",
 CellID->81878561],
Cell[30769, 1238, 256, 9, 70, "ExampleText",
 CellID->294478095],
Cell[CellGroupData[{
Cell[31050, 1251, 463, 17, 70, "Input",
 CellID->174240470],
Cell[31516, 1270, 539, 10, 70, "Message",
 CellID->530252097],
Cell[32058, 1282, 405, 16, 51, "Output",
 CellID->31526973]
}, Open  ]],
Cell[32478, 1301, 248, 7, 70, "ExampleText",
 CellID->60898104],
Cell[CellGroupData[{
Cell[32751, 1312, 108, 3, 70, "Input",
 CellID->106030961],
Cell[32862, 1317, 162, 5, 36, "Output",
 CellID->232070952]
}, Open  ]],
Cell[33039, 1325, 125, 3, 70, "ExampleDelimiter",
 CellID->351323024],
Cell[33167, 1330, 467, 17, 70, "ExampleText",
 CellID->265821182],
Cell[CellGroupData[{
Cell[33659, 1351, 187, 6, 70, "Input",
 CellID->875674151],
Cell[33849, 1359, 241, 8, 36, "Output",
 CellID->564425204]
}, Open  ]],
Cell[34105, 1370, 125, 3, 70, "ExampleDelimiter",
 CellID->353480865],
Cell[34233, 1375, 204, 8, 70, "ExampleText",
 CellID->19228497],
Cell[CellGroupData[{
Cell[34462, 1387, 231, 8, 70, "Input",
 CellID->821314495],
Cell[34696, 1397, 740, 25, 39, "Output",
 CellID->140243207]
}, Open  ]],
Cell[CellGroupData[{
Cell[35473, 1427, 354, 13, 70, "Input",
 CellID->23944515],
Cell[35830, 1442, 1125, 41, 84, "Output",
 CellID->463821729]
}, Open  ]],
Cell[36970, 1486, 125, 3, 70, "ExampleDelimiter",
 CellID->594673202],
Cell[37098, 1491, 221, 8, 70, "ExampleText",
 CellID->15549558],
Cell[CellGroupData[{
Cell[37344, 1503, 417, 15, 70, "Input",
 CellID->349268992],
Cell[37764, 1520, 371, 13, 55, "Output",
 CellID->431245726]
}, Open  ]],
Cell[38150, 1536, 125, 3, 70, "ExampleDelimiter",
 CellID->179330792],
Cell[38278, 1541, 371, 13, 70, "ExampleText",
 CellID->101578669],
Cell[CellGroupData[{
Cell[38674, 1558, 480, 17, 70, "Input",
 CellID->412249041],
Cell[39157, 1577, 4942, 85, 70, "Output",
 Evaluatable->False,
 CellID->311131464]
}, Open  ]],
Cell[CellGroupData[{
Cell[44136, 1667, 618, 22, 70, "Input",
 CellID->467824785],
Cell[44757, 1691, 28508, 471, 70, "Output",
 Evaluatable->False,
 CellID->147217818]
}, Open  ]],
Cell[73280, 2165, 125, 3, 70, "ExampleDelimiter",
 CellID->146025985],
Cell[73408, 2170, 66, 1, 70, "ExampleText",
 CellID->342383645],
Cell[CellGroupData[{
Cell[73499, 2175, 206, 7, 70, "Input",
 CellID->610693880],
Cell[73708, 2184, 175, 6, 36, "Output",
 CellID->314444252]
}, Open  ]],
Cell[CellGroupData[{
Cell[73920, 2195, 291, 9, 70, "Input",
 CellID->135321853],
Cell[74214, 2206, 158, 5, 36, "Output",
 CellID->234589721]
}, Open  ]],
Cell[74387, 2214, 125, 3, 70, "ExampleDelimiter",
 CellID->434755261],
Cell[74515, 2219, 374, 13, 70, "ExampleText",
 CellID->28281205],
Cell[CellGroupData[{
Cell[74914, 2236, 446, 16, 70, "Input",
 CellID->140887538],
Cell[75363, 2254, 440, 8, 70, "Message",
 CellID->813781046],
Cell[75806, 2264, 1391, 46, 77, "Output",
 CellID->976651358]
}, Open  ]],
Cell[77212, 2313, 124, 3, 70, "ExampleDelimiter",
 CellID->38718160],
Cell[77339, 2318, 375, 13, 70, "ExampleText",
 CellID->445549592],
Cell[CellGroupData[{
Cell[77739, 2335, 388, 13, 70, "Input",
 CellID->4920993],
Cell[78130, 2350, 415, 14, 36, "Output",
 CellID->203464789]
}, Open  ]],
Cell[78560, 2367, 125, 3, 70, "ExampleDelimiter",
 CellID->290571492],
Cell[78688, 2372, 228, 7, 70, "ExampleText",
 CellID->96643702],
Cell[CellGroupData[{
Cell[78941, 2383, 527, 17, 70, "Input",
 CellID->16786161],
Cell[79471, 2402, 205, 7, 51, "Output",
 CellID->556122115]
}, Open  ]],
Cell[79691, 2412, 125, 3, 70, "ExampleDelimiter",
 CellID->379263837],
Cell[79819, 2417, 617, 24, 70, "ExampleText",
 CellID->798766],
Cell[80439, 2443, 231, 8, 70, "Input",
 CellID->662995740],
Cell[CellGroupData[{
Cell[80695, 2455, 104, 3, 70, "Input",
 CellID->10873149],
Cell[80802, 2460, 161, 5, 36, "Output",
 CellID->165119053]
}, Open  ]],
Cell[CellGroupData[{
Cell[81000, 2470, 161, 5, 70, "Input",
 CellID->81695411],
Cell[81164, 2477, 158, 5, 36, "Output",
 CellID->404502323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81371, 2488, 230, 7, 70, "ExampleSection",
 CellID->270141323],
Cell[81604, 2497, 120, 3, 70, "ExampleText",
 CellID->46241802],
Cell[CellGroupData[{
Cell[81749, 2504, 133, 4, 70, "Input",
 CellID->107589248],
Cell[81885, 2510, 161, 5, 36, "Output",
 CellID->114991526]
}, Open  ]],
Cell[82061, 2518, 89, 1, 70, "ExampleText",
 CellID->41469938],
Cell[CellGroupData[{
Cell[82175, 2523, 136, 4, 70, "Input",
 CellID->385657575],
Cell[82314, 2529, 183, 5, 50, "Output",
 CellID->172179241]
}, Open  ]],
Cell[82512, 2537, 125, 3, 70, "ExampleDelimiter",
 CellID->286128809],
Cell[82640, 2542, 115, 3, 70, "ExampleText",
 CellID->62759660],
Cell[CellGroupData[{
Cell[82780, 2549, 142, 4, 70, "Input",
 CellID->108479341],
Cell[82925, 2555, 161, 5, 36, "Output",
 CellID->44544851]
}, Open  ]],
Cell[83101, 2563, 258, 8, 70, "ExampleText",
 CellID->446345418],
Cell[CellGroupData[{
Cell[83384, 2575, 146, 4, 70, "Input",
 CellID->501825511],
Cell[83533, 2581, 176, 5, 36, "Output",
 CellID->322434078]
}, Open  ]],
Cell[83724, 2589, 125, 3, 70, "ExampleDelimiter",
 CellID->194684669],
Cell[83852, 2594, 126, 3, 70, "ExampleText",
 CellID->528956563],
Cell[CellGroupData[{
Cell[84003, 2601, 121, 4, 70, "Input",
 CellID->544352754],
Cell[84127, 2607, 162, 5, 36, "Output",
 CellID->142489473]
}, Open  ]],
Cell[84304, 2615, 220, 8, 70, "ExampleText",
 CellID->153335021],
Cell[CellGroupData[{
Cell[84549, 2627, 128, 4, 70, "Input",
 CellID->551042265],
Cell[84680, 2633, 179, 5, 50, "Output",
 CellID->171811128]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84920, 2645, 309, 9, 70, "SeeAlsoSection",
 CellID->961],
Cell[85232, 2656, 1440, 53, 70, "SeeAlso",
 CellID->8807]
}, Open  ]],
Cell[CellGroupData[{
Cell[86709, 2714, 313, 9, 70, "TutorialsSection",
 CellID->5361],
Cell[87025, 2725, 172, 3, 70, "Tutorials",
 CellID->12045]
}, Open  ]],
Cell[CellGroupData[{
Cell[87234, 2733, 319, 9, 70, "MoreAboutSection",
 CellID->851247964],
Cell[87556, 2744, 136, 3, 70, "MoreAbout",
 CellID->967423949]
}, Open  ]],
Cell[87707, 2750, 50, 0, 70, "History"],
Cell[87760, 2752, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

