(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    105321,       3371]
NotebookOptionsPosition[     90050,       2833]
NotebookOutlinePosition[     91417,       2870]
CellTagsIndexPosition[     91331,       2865]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Less" :> Documentation`HelpLookup["paclet:ref/Less"], 
          "GreaterEqual" :> 
          Documentation`HelpLookup["paclet:ref/GreaterEqual"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "RegionPlot" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot"], "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Less\"\>", 
       2->"\<\"GreaterEqual\"\>", 3->"\<\"Element\"\>", 
       4->"\<\"RegionPlot\"\>", 
       5->"\<\"RegionPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Inequalities\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "LessEqual ",
 StyleBox["(<=, \[LessEqual])", "OperatorCharacter"]
}], "ObjectName",
 CellID->17293],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "<=", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "\[LessEqual]", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " is determined to be less than or equal to ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], "\[LessEqual]", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], "\[LessEqual]", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["3", "TR"]]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     " form a nondecreasing sequence. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[LessEqual]", "y"}], TraditionalForm]], "InlineMath"],
 " can be entered as ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]<=\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", 
    RowBox[{"[", "LessEqual", "]"}]}], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20431],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " when its arguments are real numbers. "
}], "Notes",
 CellID->19262],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " does some simplification when its arguments are not numbers. "
}], "Notes",
 CellID->26967],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " internally uses numerical approximations to establish numerical ordering. \
This process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6092],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " is printed using\[NonBreakingSpace]",
 Cell[BoxData["\[LessEqual]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1121],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[LessEqual]", "y"}], TraditionalForm]], "InlineMath"],
 ", entered as ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]</\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", 
    RowBox[{"[", 
     ButtonBox["LessSlantEqual",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LessSlantEqual"], "]"}]}], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ", can be used on input as an alternative to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[LessEqual]", "y"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->24631]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->694228885],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->75894417],

Cell["Compare numbers:", "ExampleText",
 CellID->414328301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "\[LessEqual]", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107391370],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254403490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "/", "17"}], "\[LessEqual]", 
  RowBox[{"1", "/", "5"}], "\[LessEqual]", 
  RowBox[{"Pi", "/", "10"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->765975626],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224637617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179667355],

Cell["Represent an inequality:", "ExampleText",
 CellID->42591990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"2", "x"}], "+", "1"}], "\[LessEqual]", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402385732],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "3"]}], "\[LessEqual]", "0"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41708394]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34392874],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}], "\[LessEqual]", "x", "\[LessEqual]", 
   "1"}]}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->131253425]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->439993496],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Numeric Inequalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26431756],

Cell["Inequalities are defined only for real numbers:", "ExampleText",
 CellID->751430701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I", "\[LessEqual]", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251460291],

Cell[BoxData[
 RowBox[{
  RowBox[{"LessEqual", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\) attempted. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"LessEqual::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->247072860],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", "\[LessEqual]", "0"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73670275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103713054],

Cell["Compare rational numbers:", "ExampleText",
 CellID->234143528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "/", "2"}], "\[LessEqual]", 
  RowBox[{"5", "/", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241292235],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42554611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->607628],

Cell["\<\
Approximate numbers that differ in at most their last eight binary digits are \
considered equal:\
\>", "ExampleText",
 CellID->383967204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "\[LessEqual]", 
  RowBox[{"1.", "-", 
   RowBox[{
    RowBox[{"2", "^", "7"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37738947],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->973562210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "\[LessEqual]", 
  RowBox[{"1.", "-", 
   RowBox[{
    RowBox[{"2", "^", "8"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525645198],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->300860922]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28160997],

Cell["\<\
Compare an exact numeric expression and an approximate number:\
\>", "ExampleText",
 CellID->543101097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "\[LessEqual]", "Pi"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315310371],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328148429]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "\[LessEqual]", 
  RowBox[{"Pi", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"2", "^", "8"}], " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "20"}]}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331846797],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67305889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8417305],

Cell["\<\
Compare two exact numeric expressions; a numeric test may suffice to prove \
inequality:\
\>", "ExampleText",
 CellID->564553362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pi", "^", "E"}], "\[LessEqual]", 
  RowBox[{"E", "^", "Pi"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398884990],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96258309]
}, Open  ]],

Cell["Proving this inequality requires symbolic methods:", "ExampleText",
 CellID->207797078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[LessEqual]", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"5", "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142094998],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->579051375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->775917306],

Cell[TextData[{
 "Symbolic and numeric methods used by ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " are insufficient to prove this inequality:"
}], "ExampleText",
 CellID->135341977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[LessEqual]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "4"}], "-", 
      RowBox[{"10", 
       RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180221533],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\@2 + \\@3 - \\(\\(Root[\\(\\(\\(\\(\\(\\(1 - \
\\(\\(10\\\\ \\(Slot[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\)\\) + #1\\^4\\)\\) &\\)\\), 4, \
0\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->344038978],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "\[LessEqual]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]], "Output",
 ImageSize->{238, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->691795929]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " to decide the sign of algebraic numbers:"
}], "ExampleText",
 CellID->169332501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"%", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[LessEqual]", "0"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->195979928],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30833018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200136815],

Cell[TextData[{
 "Numeric methods used by ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " do not use sufficient precision to disprove this inequality:"
}], "ExampleText",
 CellID->192423184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[LessEqual]", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "4"}], "-", 
       RowBox[{"10", 
        RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], "-", 
   
   RowBox[{"10", "^", 
    RowBox[{"-", "100"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1546846],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(1\\/\\(10000000000000000000000 \\(\\(\
\[LeftSkeleton] 54 \[RightSkeleton]\\)\\) 000000000000000000000000\\) + \\@2 \
+ \\@3 - \\(\\(Root[\\(\\(\\(\\(\\(\\(1 - \\(\\(10\\\\ \\(Slot[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\^2\\)\\) + #1\\^4\\)\\) \
&\\)\\), 4, 0\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->630896599],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "\[LessEqual]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
    "1", "/", 
     "100000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000"}]}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}]], "Output",
 ImageSize->{564, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357036296]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " disproves the inequality using exact methods:"
}], "ExampleText",
 CellID->384720156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"%", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[LessEqual]", "0"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->476886642],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->317631462]
}, Open  ]],

Cell[TextData[{
 "Increasing ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " may also disprove the inequality:"
}], "ExampleText",
 CellID->321641904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "4"}], "-", 
         RowBox[{"10", 
          RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], 
     "-", 
     RowBox[{"10", "^", 
      RowBox[{"-", "100"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1018235179],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10289946]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Inequalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->500815976],

Cell[TextData[{
 "Symbolic inequalities remain unevaluated, since ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " may not be a real number:"
}], "ExampleText",
 CellID->152622296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[LessEqual]", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148403671],

Cell[BoxData[
 RowBox[{"x", "\[LessEqual]", "x"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61258928]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to re-evaluate the inequality assuming that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is real:"
}], "ExampleText",
 CellID->231864384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205622433],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179690589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->744167208],

Cell["A symbolic inequality:", "ExampleText",
 CellID->135671996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ineq", "=", 
  RowBox[{"1", "\[LessEqual]", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486416913],

Cell[BoxData[
 RowBox[{"1", "\[LessEqual]", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}], "\[LessEqual]", "2"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390217744]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find an explicit description of the solution set:"
}], "ExampleText",
 CellID->496282763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145270882],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox["2"]}], "<", "x", "<", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     SqrtBox[
      RowBox[{"2", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"2", "-", 
          SuperscriptBox["x", "2"]}]]}], "\[LessEqual]", "y", "\[LessEqual]", 
       
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], "\[LessEqual]", "y", "\[LessEqual]", 
       SqrtBox[
        RowBox[{"2", "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"1", "<", "x", "<", 
     SqrtBox["2"]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     SqrtBox[
      RowBox[{"2", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     SqrtBox["2"]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{442, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->565586233]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find a solution instance:"
}], "ExampleText",
 CellID->220870228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->159052583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->475181856]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " to optimize over the inequality-defined region:"
}], "ExampleText",
 CellID->279307693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], ",", "ineq"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->34810484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{154, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->215084767]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to simplify under the inequality-defined assumptions:"
}], "ExampleText",
 CellID->266015669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}], "]"}], ",", "ineq"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->450815041],

Cell[BoxData[
 RowBox[{"2", "-", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->355472971]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->336312689],

Cell[TextData[{
 "The negation of two-argument ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14000026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "\[LessEqual]", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785552779],

Cell[BoxData[
 RowBox[{"x", ">", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123663656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242933151],

Cell[TextData[{
 "The negation of three-argument ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " does not simplify automatically:"
}], "ExampleText",
 CellID->179461278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "\[LessEqual]", "y", "\[LessEqual]", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->900203775],

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"x", "\[LessEqual]", "y", "\[LessEqual]", "z"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579636095]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to express it in terms of two-argument ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103307650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->602057068],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", ">", "y"}], "||", 
  RowBox[{"y", ">", "z"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->541129116]
}, Open  ]],

Cell[TextData[{
 "This is not equivalent to three-argument ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22272967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"x", ">", "y", ">", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41719149],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", ">", "y"}], "&&", 
  RowBox[{"y", ">", "z"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->51902653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->115730864],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " cannot decide inequality between numeric expressions it returns \
unchanged:"
}], "ExampleText",
 CellID->294478095],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}], "/", "2"}]}], 
  ";"}], "\n", 
 RowBox[{"a", "\[LessEqual]", "b"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->174240470],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(Log[\\(\\(\\@2 + \\@3\\)\\)]\\)\\) - \\(\
\\(1\\/2\\\\ \\(\\(Log[\\(\\(5 + \\(\\(2\\\\ \
\\@6\\)\\)\\)\\)]\\)\\)\\)\\)\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->56652048],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], "]"}], "\[LessEqual]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}]}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204659026]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses exact symbolic transformations to prove the inequality:"
}], "ExampleText",
 CellID->631563206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106030961],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333688311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59795116],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NonPositive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonPositive"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "\[Element]", 
     TagBox["\[DoubleStruckCapitalR]",
      Function[{}, Reals]]}], "\[And]", 
    RowBox[{"x", "\[LessEqual]", "0"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->265821182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonPositive", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "I"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->875674151],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->635700419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167756223],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve inequalities:"
}], "ExampleText",
 CellID->608574232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"3", "x"}], "+", "2"}], "\[LessEqual]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->821314495],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "\[LessEqual]", 
   "x", "\[LessEqual]", "1"}]}]], "Output",
 ImageSize->{504, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->561849237]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[LessEqual]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23944515],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "4"]}]}]]}], "\[LessEqual]", "y", "\[LessEqual]",
      
     SqrtBox[
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "4"]}]}]]}], "\[LessEqual]", "y", "\[LessEqual]",
      
     SqrtBox[
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{520, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->654120798]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172292723],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find solution instances:"
}], "ExampleText",
 CellID->327696859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[LessEqual]", 
    RowBox[{"-", 
     RowBox[{"z", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349268992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "0"}], ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549646784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446828900],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 " to visualize solution sets of inequalities:"
}], "ExampleText",
 CellID->462388836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[LessEqual]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412249041],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143133026]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[LessEqual]", " ", 
    RowBox[{"-", 
     RowBox[{"z", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->467824785],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->358254623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->258662706],

Cell["Inequality assumptions:", "ExampleText",
 CellID->40412459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", "\[LessEqual]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610693880],

Cell[BoxData[
 RowBox[{"-", "x"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->424390729]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"a", "^", "n"}], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], "\[LessEqual]", "a", "\[LessEqual]", 
     RowBox[{"1", "/", "2"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135321853],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13414002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411574986],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " to solve optimization problems constrained by inequalities:"
}], "ExampleText",
 CellID->195365642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "^", "2"}], "-", 
       RowBox[{"4", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"x", "^", "4"}]}]}], "\[LessEqual]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140887538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"27", "-", 
       RowBox[{"207", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"64", " ", 
        SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"27", "-", 
           RowBox[{"207", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"64", " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], "+", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"48", "-", 
           RowBox[{"111", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"64", " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}]}], ",", 
     
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"48", "-", 
          RowBox[{"111", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{441, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333614239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177495409],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " to numerically solve constrained optimization problems:"
}], "ExampleText",
 CellID->10548147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", " ", 
     RowBox[{"1", "\[LessEqual]", 
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], "+", 
       RowBox[{"Tan", "[", "y", "]"}]}], "\[LessEqual]", "2"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4920993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.1401408407383853`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.5700700002562602`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "1.5700708404821253`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372329905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->586542266],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " a function over the solution set of inequalities:"
}], "ExampleText",
 CellID->5403656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"Boole", "[", 
     RowBox[{"1", "\[LessEqual]", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16786161],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", "\[Pi]"}], "4"]], "Output",
 ImageSize->{27, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->586652394]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396065631],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Quartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartiles"]], "InlineFormula"],
 " to the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " greatest number(s): "
}], "ExampleText",
 CellID->798766],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->662995740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x1", "\[LessEqual]", "x2", "\[LessEqual]", "x3"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10873149],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224469424]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{"x2", ",", "x3", ",", "x1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81695411],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1712551]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->111091014],

Cell["\<\
Inequalities for machine-precision approximate numbers can be subtle: \
\>", "ExampleText",
 CellID->179979003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], "\[LessEqual]", "0.00001"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107589248],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18038754]
}, Open  ]],

Cell["The result is based on extra digits:", "ExampleText",
 CellID->454896623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385657575],

Cell["0.000010000000000065512", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->94498024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16742838],

Cell["\<\
Arbitrary-precision approximate numbers do not have this problem:\
\>", "ExampleText",
 CellID->242045851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006`16", "-", "2.00005`16"}], "\[LessEqual]", 
  "0.00001`16"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108479341],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97025709]
}, Open  ]],

Cell[TextData[{
 "Thanks to automatic precision tracking ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 " knows to look only at the first ten digits:"
}], "ExampleText",
 CellID->446345418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"2.00006`16", "-", "2.00005`16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501825511],

Cell[BoxData["10.397928065738002`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->78675621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14265223],

Cell["\<\
In this case, inequality between machine numbers gives the expected result:\
\>", "ExampleText",
 CellID->10528118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], "\[LessEqual]", "0.1"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544352754],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->532584810]
}, Open  ]],

Cell[TextData[{
 "The extra digits in this case are ignored by ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->153335021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->551042265],

Cell["0.10000000000000009", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->249849603]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5669],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Less",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Less"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GreaterEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GreaterEqual"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17155]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2982],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->8566]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->293326227],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->511650533]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LessEqual (<=, \[LessEqual]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 48.1241238}", "context" -> "System`", 
    "keywords" -> {"inequality", "less or equal", "weak inequality"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "x <= y or x <= y yields True if x is determined to be less than or equal \
to y. x_1 <= x_2 <= x_3 yields True if the x_i form a nondecreasing sequence. \
", "synonyms" -> {"less equal", "<="}, "title" -> "LessEqual", "type" -> 
    "Symbol", "uri" -> "ref/LessEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8052, 281, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->694228885]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 91188, 2858}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2176, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2799, 80, 117, 4, 70, "ObjectName",
 CellID->17293],
Cell[2919, 86, 1548, 52, 70, "Usage",
 CellID->11955]
}, Open  ]],
Cell[CellGroupData[{
Cell[4504, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4982, 160, 602, 23, 70, "Notes",
 CellID->20431],
Cell[5587, 185, 452, 17, 70, "Notes",
 CellID->19262],
Cell[6042, 204, 231, 7, 70, "Notes",
 CellID->26967],
Cell[6276, 213, 493, 14, 70, "Notes",
 CellID->6092],
Cell[6772, 229, 402, 15, 70, "Notes",
 CellID->1121],
Cell[7177, 246, 838, 30, 70, "Notes",
 CellID->24631]
}, Closed]],
Cell[CellGroupData[{
Cell[8052, 281, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->694228885],
Cell[CellGroupData[{
Cell[8437, 295, 147, 5, 70, "ExampleSection",
 CellID->75894417],
Cell[8587, 302, 59, 1, 70, "ExampleText",
 CellID->414328301],
Cell[CellGroupData[{
Cell[8671, 307, 103, 3, 28, "Input",
 CellID->107391370],
Cell[8777, 312, 162, 5, 36, "Output",
 CellID->254403490]
}, Open  ]],
Cell[CellGroupData[{
Cell[8976, 322, 196, 6, 28, "Input",
 CellID->765975626],
Cell[9175, 330, 161, 5, 36, "Output",
 CellID->224637617]
}, Open  ]],
Cell[9351, 338, 125, 3, 70, "ExampleDelimiter",
 CellID->179667355],
Cell[9479, 343, 66, 1, 70, "ExampleText",
 CellID->42591990],
Cell[CellGroupData[{
Cell[9570, 348, 179, 6, 70, "Input",
 CellID->402385732],
Cell[9752, 356, 272, 9, 36, "Output",
 CellID->41708394]
}, Open  ]],
Cell[CellGroupData[{
Cell[10061, 370, 124, 4, 70, "Input",
 CellID->34392874],
Cell[10188, 376, 547, 21, 51, "Output",
 CellID->131253425]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10784, 403, 220, 7, 70, "ExampleSection",
 CellID->439993496],
Cell[CellGroupData[{
Cell[11029, 414, 240, 7, 70, "ExampleSubsection",
 CellID->26431756],
Cell[11272, 423, 90, 1, 70, "ExampleText",
 CellID->751430701],
Cell[CellGroupData[{
Cell[11387, 428, 103, 3, 70, "Input",
 CellID->251460291],
Cell[11493, 433, 385, 7, 70, "Message",
 CellID->247072860],
Cell[11881, 442, 202, 6, 36, "Output",
 CellID->73670275]
}, Open  ]],
Cell[12098, 451, 125, 3, 70, "ExampleDelimiter",
 CellID->103713054],
Cell[12226, 456, 68, 1, 70, "ExampleText",
 CellID->234143528],
Cell[CellGroupData[{
Cell[12319, 461, 149, 5, 70, "Input",
 CellID->241292235],
Cell[12471, 468, 160, 5, 36, "Output",
 CellID->42554611]
}, Open  ]],
Cell[12646, 476, 122, 3, 70, "ExampleDelimiter",
 CellID->607628],
Cell[12771, 481, 148, 4, 70, "ExampleText",
 CellID->383967204],
Cell[CellGroupData[{
Cell[12944, 489, 224, 8, 70, "Input",
 CellID->37738947],
Cell[13171, 499, 161, 5, 36, "Output",
 CellID->973562210]
}, Open  ]],
Cell[CellGroupData[{
Cell[13369, 509, 225, 8, 70, "Input",
 CellID->525645198],
Cell[13597, 519, 162, 5, 36, "Output",
 CellID->300860922]
}, Open  ]],
Cell[13774, 527, 124, 3, 70, "ExampleDelimiter",
 CellID->28160997],
Cell[13901, 532, 113, 3, 70, "ExampleText",
 CellID->543101097],
Cell[CellGroupData[{
Cell[14039, 539, 158, 5, 70, "Input",
 CellID->315310371],
Cell[14200, 546, 161, 5, 36, "Output",
 CellID->328148429]
}, Open  ]],
Cell[CellGroupData[{
Cell[14398, 556, 330, 12, 70, "Input",
 CellID->331846797],
Cell[14731, 570, 161, 5, 36, "Output",
 CellID->67305889]
}, Open  ]],
Cell[14907, 578, 123, 3, 70, "ExampleDelimiter",
 CellID->8417305],
Cell[15033, 583, 139, 4, 70, "ExampleText",
 CellID->564553362],
Cell[CellGroupData[{
Cell[15197, 591, 151, 5, 70, "Input",
 CellID->398884990],
Cell[15351, 598, 160, 5, 36, "Output",
 CellID->96258309]
}, Open  ]],
Cell[15526, 606, 93, 1, 70, "ExampleText",
 CellID->207797078],
Cell[CellGroupData[{
Cell[15644, 611, 299, 10, 70, "Input",
 CellID->142094998],
Cell[15946, 623, 161, 5, 36, "Output",
 CellID->579051375]
}, Open  ]],
Cell[16122, 631, 125, 3, 70, "ExampleDelimiter",
 CellID->775917306],
Cell[16250, 636, 264, 8, 70, "ExampleText",
 CellID->135341977],
Cell[CellGroupData[{
Cell[16539, 648, 383, 14, 70, "Input",
 CellID->180221533],
Cell[16925, 664, 591, 11, 70, "Message",
 CellID->344038978],
Cell[17519, 677, 439, 16, 41, "Output",
 CellID->691795929]
}, Open  ]],
Cell[17973, 696, 231, 8, 70, "ExampleText",
 CellID->169332501],
Cell[CellGroupData[{
Cell[18229, 708, 278, 10, 70, "Input",
 CellID->195979928],
Cell[18510, 720, 160, 5, 36, "Output",
 CellID->30833018]
}, Open  ]],
Cell[18685, 728, 125, 3, 70, "ExampleDelimiter",
 CellID->200136815],
Cell[18813, 733, 269, 8, 70, "ExampleText",
 CellID->192423184],
Cell[CellGroupData[{
Cell[19107, 745, 458, 17, 70, "Input",
 CellID->1546846],
Cell[19568, 764, 702, 12, 70, "Message",
 CellID->630896599],
Cell[20273, 778, 626, 22, 75, "Output",
 CellID->357036296]
}, Open  ]],
Cell[20914, 803, 227, 7, 70, "ExampleText",
 CellID->384720156],
Cell[CellGroupData[{
Cell[21166, 814, 278, 10, 70, "Input",
 CellID->476886642],
Cell[21447, 826, 162, 5, 36, "Output",
 CellID->317631462]
}, Open  ]],
Cell[21624, 834, 247, 8, 70, "ExampleText",
 CellID->321641904],
Cell[CellGroupData[{
Cell[21896, 846, 613, 21, 70, "Input",
 CellID->1018235179],
Cell[22512, 869, 161, 5, 36, "Output",
 CellID->10289946]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22722, 880, 242, 7, 70, "ExampleSubsection",
 CellID->500815976],
Cell[22967, 889, 194, 6, 70, "ExampleText",
 CellID->152622296],
Cell[CellGroupData[{
Cell[23186, 899, 103, 3, 70, "Input",
 CellID->148403671],
Cell[23292, 904, 190, 6, 36, "Output",
 CellID->61258928]
}, Open  ]],
Cell[23497, 913, 298, 11, 70, "ExampleText",
 CellID->231864384],
Cell[CellGroupData[{
Cell[23820, 928, 189, 6, 70, "Input",
 CellID->205622433],
Cell[24012, 936, 161, 5, 36, "Output",
 CellID->179690589]
}, Open  ]],
Cell[24188, 944, 125, 3, 70, "ExampleDelimiter",
 CellID->744167208],
Cell[24316, 949, 65, 1, 70, "ExampleText",
 CellID->135671996],
Cell[CellGroupData[{
Cell[24406, 954, 224, 7, 70, "Input",
 CellID->486416913],
Cell[24633, 963, 285, 9, 36, "Output",
 CellID->390217744]
}, Open  ]],
Cell[24933, 975, 235, 8, 70, "ExampleText",
 CellID->496282763],
Cell[CellGroupData[{
Cell[25193, 987, 177, 6, 70, "Input",
 CellID->145270882],
Cell[25373, 995, 1840, 66, 116, "Output",
 CellID->565586233]
}, Open  ]],
Cell[27228, 1064, 223, 8, 70, "ExampleText",
 CellID->220870228],
Cell[CellGroupData[{
Cell[27476, 1076, 183, 6, 70, "Input",
 CellID->159052583],
Cell[27662, 1084, 290, 10, 36, "Output",
 CellID->475181856]
}, Open  ]],
Cell[27967, 1097, 234, 8, 70, "ExampleText",
 CellID->279307693],
Cell[CellGroupData[{
Cell[28226, 1109, 307, 11, 70, "Input",
 CellID->34810484],
Cell[28536, 1122, 375, 14, 43, "Output",
 CellID->215084767]
}, Open  ]],
Cell[28926, 1139, 236, 8, 70, "ExampleText",
 CellID->266015669],
Cell[CellGroupData[{
Cell[29187, 1151, 269, 10, 70, "Input",
 CellID->450815041],
Cell[29459, 1163, 204, 7, 36, "Output",
 CellID->355472971]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29724, 1177, 238, 7, 70, "ExampleSection",
 CellID->336312689],
Cell[29965, 1186, 339, 13, 70, "ExampleText",
 CellID->14000026],
Cell[CellGroupData[{
Cell[30329, 1203, 133, 4, 70, "Input",
 CellID->785552779],
Cell[30465, 1209, 180, 6, 36, "Output",
 CellID->123663656]
}, Open  ]],
Cell[30660, 1218, 125, 3, 70, "ExampleDelimiter",
 CellID->242933151],
Cell[30788, 1223, 248, 8, 70, "ExampleText",
 CellID->179461278],
Cell[CellGroupData[{
Cell[31061, 1235, 154, 4, 70, "Input",
 CellID->900203775],
Cell[31218, 1241, 230, 7, 36, "Output",
 CellID->579636095]
}, Open  ]],
Cell[31463, 1251, 359, 13, 70, "ExampleText",
 CellID->103307650],
Cell[CellGroupData[{
Cell[31847, 1268, 109, 3, 70, "Input",
 CellID->602057068],
Cell[31959, 1273, 227, 8, 36, "Output",
 CellID->541129116]
}, Open  ]],
Cell[32201, 1284, 221, 8, 70, "ExampleText",
 CellID->22272967],
Cell[CellGroupData[{
Cell[32447, 1296, 141, 4, 70, "Input",
 CellID->41719149],
Cell[32591, 1302, 226, 8, 36, "Output",
 CellID->51902653]
}, Open  ]],
Cell[32832, 1313, 125, 3, 70, "ExampleDelimiter",
 CellID->115730864],
Cell[32960, 1318, 266, 9, 70, "ExampleText",
 CellID->294478095],
Cell[CellGroupData[{
Cell[33251, 1331, 474, 17, 70, "Input",
 CellID->174240470],
Cell[33728, 1350, 538, 10, 70, "Message",
 CellID->56652048],
Cell[34269, 1362, 417, 16, 51, "Output",
 CellID->204659026]
}, Open  ]],
Cell[34701, 1381, 246, 7, 70, "ExampleText",
 CellID->631563206],
Cell[CellGroupData[{
Cell[34972, 1392, 108, 3, 70, "Input",
 CellID->106030961],
Cell[35083, 1397, 161, 5, 36, "Output",
 CellID->333688311]
}, Open  ]],
Cell[35259, 1405, 124, 3, 70, "ExampleDelimiter",
 CellID->59795116],
Cell[35386, 1410, 484, 17, 70, "ExampleText",
 CellID->265821182],
Cell[CellGroupData[{
Cell[35895, 1431, 190, 6, 70, "Input",
 CellID->875674151],
Cell[36088, 1439, 240, 8, 36, "Output",
 CellID->635700419]
}, Open  ]],
Cell[36343, 1450, 125, 3, 70, "ExampleDelimiter",
 CellID->167756223],
Cell[36471, 1455, 205, 8, 70, "ExampleText",
 CellID->608574232],
Cell[CellGroupData[{
Cell[36701, 1467, 245, 9, 70, "Input",
 CellID->821314495],
Cell[36949, 1478, 773, 25, 39, "Output",
 CellID->561849237]
}, Open  ]],
Cell[CellGroupData[{
Cell[37759, 1508, 365, 13, 70, "Input",
 CellID->23944515],
Cell[38127, 1523, 1571, 56, 84, "Output",
 CellID->654120798]
}, Open  ]],
Cell[39713, 1582, 125, 3, 70, "ExampleDelimiter",
 CellID->172292723],
Cell[39841, 1587, 222, 8, 70, "ExampleText",
 CellID->327696859],
Cell[CellGroupData[{
Cell[40088, 1599, 428, 15, 70, "Input",
 CellID->349268992],
Cell[40519, 1616, 331, 11, 36, "Output",
 CellID->549646784]
}, Open  ]],
Cell[40865, 1630, 125, 3, 70, "ExampleDelimiter",
 CellID->446828900],
Cell[40993, 1635, 371, 13, 70, "ExampleText",
 CellID->462388836],
Cell[CellGroupData[{
Cell[41389, 1652, 491, 17, 70, "Input",
 CellID->412249041],
Cell[41883, 1671, 4942, 85, 70, "Output",
 Evaluatable->False,
 CellID->143133026]
}, Open  ]],
Cell[CellGroupData[{
Cell[46862, 1761, 634, 22, 70, "Input",
 CellID->467824785],
Cell[47499, 1785, 28508, 471, 70, "Output",
 Evaluatable->False,
 CellID->358254623]
}, Open  ]],
Cell[76022, 2259, 125, 3, 70, "ExampleDelimiter",
 CellID->258662706],
Cell[76150, 2264, 65, 1, 70, "ExampleText",
 CellID->40412459],
Cell[CellGroupData[{
Cell[76240, 2269, 217, 7, 70, "Input",
 CellID->610693880],
Cell[76460, 2278, 175, 6, 36, "Output",
 CellID->424390729]
}, Open  ]],
Cell[CellGroupData[{
Cell[76672, 2289, 366, 11, 70, "Input",
 CellID->135321853],
Cell[77041, 2302, 157, 5, 36, "Output",
 CellID->13414002]
}, Open  ]],
Cell[77213, 2310, 125, 3, 70, "ExampleDelimiter",
 CellID->411574986],
Cell[77341, 2315, 375, 13, 70, "ExampleText",
 CellID->195365642],
Cell[CellGroupData[{
Cell[77741, 2332, 462, 16, 70, "Input",
 CellID->140887538],
Cell[78206, 2350, 1391, 46, 77, "Output",
 CellID->333614239]
}, Open  ]],
Cell[79612, 2399, 125, 3, 70, "ExampleDelimiter",
 CellID->177495409],
Cell[79740, 2404, 374, 13, 70, "ExampleText",
 CellID->10548147],
Cell[CellGroupData[{
Cell[80139, 2421, 414, 14, 70, "Input",
 CellID->4920993],
Cell[80556, 2437, 415, 14, 36, "Output",
 CellID->372329905]
}, Open  ]],
Cell[80986, 2454, 125, 3, 70, "ExampleDelimiter",
 CellID->586542266],
Cell[81114, 2459, 227, 7, 70, "ExampleText",
 CellID->5403656],
Cell[CellGroupData[{
Cell[81366, 2470, 549, 17, 70, "Input",
 CellID->16786161],
Cell[81918, 2489, 205, 7, 51, "Output",
 CellID->586652394]
}, Open  ]],
Cell[82138, 2499, 125, 3, 70, "ExampleDelimiter",
 CellID->396065631],
Cell[82266, 2504, 617, 24, 70, "ExampleText",
 CellID->798766],
Cell[82886, 2530, 231, 8, 70, "Input",
 CellID->662995740],
Cell[CellGroupData[{
Cell[83142, 2542, 126, 3, 70, "Input",
 CellID->10873149],
Cell[83271, 2547, 161, 5, 36, "Output",
 CellID->224469424]
}, Open  ]],
Cell[CellGroupData[{
Cell[83469, 2557, 161, 5, 70, "Input",
 CellID->81695411],
Cell[83633, 2564, 156, 5, 36, "Output",
 CellID->1712551]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83838, 2575, 230, 7, 70, "ExampleSection",
 CellID->111091014],
Cell[84071, 2584, 121, 3, 70, "ExampleText",
 CellID->179979003],
Cell[CellGroupData[{
Cell[84217, 2591, 144, 4, 70, "Input",
 CellID->107589248],
Cell[84364, 2597, 161, 5, 36, "Output",
 CellID->18038754]
}, Open  ]],
Cell[84540, 2605, 79, 1, 70, "ExampleText",
 CellID->454896623],
Cell[CellGroupData[{
Cell[84644, 2610, 136, 4, 70, "Input",
 CellID->385657575],
Cell[84783, 2616, 182, 5, 50, "Output",
 CellID->94498024]
}, Open  ]],
Cell[84980, 2624, 124, 3, 70, "ExampleDelimiter",
 CellID->16742838],
Cell[85107, 2629, 116, 3, 70, "ExampleText",
 CellID->242045851],
Cell[CellGroupData[{
Cell[85248, 2636, 156, 5, 70, "Input",
 CellID->108479341],
Cell[85407, 2643, 160, 5, 36, "Output",
 CellID->97025709]
}, Open  ]],
Cell[85582, 2651, 267, 8, 70, "ExampleText",
 CellID->446345418],
Cell[CellGroupData[{
Cell[85874, 2663, 146, 4, 70, "Input",
 CellID->501825511],
Cell[86023, 2669, 175, 5, 36, "Output",
 CellID->78675621]
}, Open  ]],
Cell[86213, 2677, 124, 3, 70, "ExampleDelimiter",
 CellID->14265223],
Cell[86340, 2682, 125, 3, 70, "ExampleText",
 CellID->10528118],
Cell[CellGroupData[{
Cell[86490, 2689, 132, 4, 70, "Input",
 CellID->544352754],
Cell[86625, 2695, 161, 5, 36, "Output",
 CellID->532584810]
}, Open  ]],
Cell[86801, 2703, 230, 8, 70, "ExampleText",
 CellID->153335021],
Cell[CellGroupData[{
Cell[87056, 2715, 128, 4, 70, "Input",
 CellID->551042265],
Cell[87187, 2721, 179, 5, 50, "Output",
 CellID->249849603]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87427, 2733, 310, 9, 70, "SeeAlsoSection",
 CellID->5669],
Cell[87740, 2744, 1196, 44, 70, "SeeAlso",
 CellID->17155]
}, Open  ]],
Cell[CellGroupData[{
Cell[88973, 2793, 313, 9, 70, "TutorialsSection",
 CellID->2982],
Cell[89289, 2804, 171, 3, 70, "Tutorials",
 CellID->8566]
}, Open  ]],
Cell[CellGroupData[{
Cell[89497, 2812, 319, 9, 70, "MoreAboutSection",
 CellID->293326227],
Cell[89819, 2823, 136, 3, 70, "MoreAbout",
 CellID->511650533]
}, Open  ]],
Cell[89970, 2829, 50, 0, 70, "History"],
Cell[90023, 2831, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

