(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38811,        934]
NotebookOptionsPosition[     35429,        820]
NotebookOutlinePosition[     36652,        856]
CellTagsIndexPosition[     36567,        851]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Blue" :> Documentation`HelpLookup["paclet:ref/Blue"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Blue\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightBlue", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightBlue",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightBlue"]], "InlineFormula"],
     " \[LineSeparator]represents a light blue color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightBlue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightBlue"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"0.87", ",", "0.94", ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531798325],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->291675361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightBlue", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.87, 0.94, 1], EdgeForm[GrayLevel[0]], 
   DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->191250872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71672531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228042658],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WHuIlUUUn73ffe62e/fuZmuZtqZlL3tRWtYiuuvq7ro3bbNcImITSaPI
zPpH/zDIIPojgrAEI1BIAoMeIEUFghQVkRAGFfEJgRARJEF/BEH9zpmZb2bO
nXv1rqCs9ztnvvN+zHdmJmd2bdv61Myu7VtmBtfunNmxbfuWZwdHn96JpaRD
KbUf/6fnKsD/AeL/+9OzePq/JfwmeJUjjAA8CcwB3McUZfEmoZ+8w5UqCIo9
ejnRD/qXs2hbch5i/NSZf46dOIM/laOf5Kff/zXv57dhHxFs4tdHPz79zHOf
jK17W+Uff+IjlYwMHwR+6L0f25LnU0wxBYx75NGjEAUFRV4BsHvv8ampdz74
/Nd5s5S9kSng88uvfQ1zj3/3RyevfPPzX0/uOAbxeHV5lkmKc9F7+pI22GiC
7/WDJ1UP4/D7sa3vQ5qay1IGDLemxjp8orD3Mg71MIKoBzJqX0fdchmqPotD
B3jVZVGuSU8XcV0qpMwJLNPUcNuXmXxx6k/g8E5zN+hYz7jODoH6PRKDaBDY
H+WaIJ2vvvHtFbyOqCELBPZFqccZ//Sr32AJgfOEzlrgx7jNh/H6SoHXojrG
hMz5QmdvlGudzTUKhsCrGIczcInAapRrLeMnT/+9efpdiuygjTwsRLw9LvJH
60A4EVQCFwrLeoIq9XcDu0PIih1l/MiHvzy/+zMCFzG+75Uv3zz0PYHdzFts
6KFSrMs8fI2NNPyCd2qx9QutSriWK/cv3ZqemvPU4+y9RvhzSRv2EzpiexAR
hbVqiYh4VxN5hTS+I2h5aDI0OIFLbCchvyS/lTxfjsSHGdf7LIHXizh0BpVg
n1LKapsVZIn64QaRpc6g+rROKIAaAm9k/K0jP+x96QSBlWiFrxKVsJRxuI8g
E1huweX8WSr8LQeW9ZrsUbfkPbxsuwv+ULTlt6HH0PUZOdxL5l0xalevwKui
x/qjeUMxoiQzu733tYhFthJo51VN4iPtkHifwPO2rhF4AksmUpKO9Rf8SkTM
dbec0wbpS9WrPn8/9XsvFrNGG2C0ZwPJlLokLm2T/lc8OfaZKLMj6XSdZwX4
GdPWSn8SUfGVVj4UMzwr20LUjmoTDwqiU7oi9ueCmgegG03FNQ0J++9Mw67K
B5kZEvqXp2EnJ1Ed9wody4WOONc9abgj3S105aJcK9Jwl1shdGkumohe4C/T
gK1H7ZGp2iSs0nOvBjXSNnd8tSJWnVMX35bZxQJ/HS7KiW522vkWx7qDcJ3u
5u/T6P6tC1LdJXK/Kqhd/0u/TNSWo/T2Z9i6TEhc7eic73rzM53jZEZptVh1
h61KMxkOB5bqs6T7rtwuKt9Rq5Ifa1flt4mqH4n2Sk7IvVXgI4FViZB5S3o2
mKbWRHVoLjf538y4+1604nJx1xOCm4VHo1x5kYGb0nDfGQ38KYq3ej5y0yVP
7/yFbjZvx+c4Obc5L3jC19+6lvOqvEsoiphdx7g7fVyYXPfd1PMrZkVUJWV0
rA25Sbbu6udaYXczeXa+lvEsifjp+d+dOcdbyGusC4eXRZ4WWT3mXDYRZN7O
11IKT8TennK1yMpEUG2dtntMxy8UsV8frWjNJc+d7uw+GeXqEpYtSPUpvN6C
2lmmT8Q40uBgQ2A98KNbxE6f0d0J4L6ojm5jgTzRx6n1zYo7V/HNitfXGwKL
qrZqzT2MvJnYGNWRcSH+5PUciyPShN8f5fJvcYiqX+BTUa6atQgWUoxqguuB
wJ9MpsmxthT7krmf2ZRVZ7N7R1n//Z6vdHPF5+Y8ZMFXbHYopwdZZkXwNU4T
sgf4rsjcrkE4slq2K0gXSgKlu3mWsvleqht7PsoFkqABEUR7YhmLiAesr9cP
43xKMZ1uQwsRcE1VIA4BQaFAwcqhA4gw4gGbKc4Pz9LuPRfEZ3cdewv5Iq82
3jurjv8BFSQJDA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->79555891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->218031022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65126131],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.87, 0.94, 1]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62098085]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light blue can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->454548785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightBlue", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.87, 0.94, 1], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->295591627,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightBlue", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.87, 0.94, 1], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->960814760,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->13531007]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightBlue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 52, 59.9525516}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LightBlue represents a light blue color in graphics or style \
specifications.", "synonyms" -> {"light blue"}, "title" -> "LightBlue", 
    "type" -> "Symbol", "uri" -> "ref/LightBlue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5244, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->531798325]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36424, 844}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1651, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2274, 63, 1574, 37, 70, "ObjectNameGrid"],
Cell[3851, 102, 458, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4346, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4824, 138, 383, 14, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5244, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531798325],
Cell[CellGroupData[{
Cell[5629, 171, 148, 5, 70, "ExampleSection",
 CellID->291675361],
Cell[CellGroupData[{
Cell[5802, 180, 238, 7, 28, "Input",
 CellID->511908593],
Cell[6043, 189, 297, 9, 121, "Output",
 CellID->191250872]
}, Open  ]],
Cell[6355, 201, 124, 3, 70, "ExampleDelimiter",
 CellID->71672531],
Cell[CellGroupData[{
Cell[6504, 208, 292, 9, 28, "Input",
 CellID->228042658],
Cell[6799, 219, 2231, 41, 110, "Output",
 Evaluatable->False,
 CellID->79555891]
}, Open  ]],
Cell[9045, 263, 125, 3, 70, "ExampleDelimiter",
 CellID->218031022],
Cell[CellGroupData[{
Cell[9195, 270, 370, 12, 70, "Input",
 CellID->65126131],
Cell[9568, 284, 357, 13, 56, "Output",
 CellID->62098085]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9974, 303, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10208, 312, 115, 3, 70, "ExampleText",
 CellID->454548785],
Cell[CellGroupData[{
Cell[10348, 319, 191, 6, 70, "Input",
 CellID->165065652],
Cell[10542, 327, 13630, 228, 129, 92, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->295591627]
}, Open  ]],
Cell[24187, 558, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24298, 563, 268, 8, 70, "Input",
 CellID->280509553],
Cell[24569, 573, 8290, 142, 129, 115, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->960814760]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32920, 722, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[33239, 733, 1656, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[34932, 800, 299, 8, 70, "MoreAboutSection"],
Cell[35234, 810, 123, 3, 70, "MoreAbout",
 CellID->13531007]
}, Open  ]],
Cell[35372, 816, 27, 0, 70, "History"],
Cell[35402, 818, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

