(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37493,        906]
NotebookOptionsPosition[     34245,        796]
NotebookOutlinePosition[     35467,        832]
CellTagsIndexPosition[     35382,        827]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cyan" :> Documentation`HelpLookup["paclet:ref/Cyan"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cyan\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightCyan", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightCyan",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightCyan"]], "InlineFormula"],
     " \[LineSeparator]represents a light cyan color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightCyan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightCyan"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    ButtonBox["Cyan",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cyan"], ",", "0.9"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->487444962],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->252835600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightCyan", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.9, 1, 1], EdgeForm[GrayLevel[0]], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->145409058]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightCyan"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310096450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WFlonUUUntz/ronJzU2sqdZqaqt1qxvaajVImzQ1SZO0tlFDQYhVSB6s
0uZBpIjigg/6olAquIAWRVEoChUhDy7gAkVRVEQKUsFfHxRB8aEgxO+cmfln
5ty5t70pWNL7nzP/2Zf5z8z4zPzsfffPzM/tmenfum/mwdm5Pfv7hx/Yh6Wk
TSl1EP+nlyvAi4D4/8F0EU//t4TfBK9yhBGAJ4E5gE8yRVm8Segn73ClCoLi
gF5O9IP+5Szakpw7GT/+98mFL3/Bn8rRT3Li5L/m/coW7COCKX797sc/7X/4
g5GRV1R+bu97KhkafBH4G0d/aEmeT7GTKWDc3fe8DVFQUOQVAI889eGuqdff
//znFUuUvYMp4POzh76AuZ/9+Hs7r3z96197549CPF6dm2WS4lz0nr6k7Taa
4Dt0+CvVxTj8vnf2CKSp5Sylz3BraqzDJwp7N+NQDyOIui+j9nVMWC5D1WNx
6ACvOifKNe7pIq6zhZRlgWWaGm77MpNjJ/4EDu80d52ObYzr7BCo3yMxiAaB
vVGuMdL5/MvHzuN1RA1ZILAnSj3K+Eff/gZLCFwhdNYCP0ZtPozX5wu8FtUx
ImSuFDq7o1y32VyjYAi8kHE4A5cIrEa5tjL+/R//TO9+kyLbbyMPCxFvj4v8
0ToQTgSVwFXCsq6gSv3dwO4QsmKHGX9n4fhDjy4QuJrxp5/79KW3viGwk3mL
dT1UinWZh2+xkYZf8E6tsX6hVQnXcuX+pVvTU3Oaepy9Fwt/zmrBfkKHbA8i
orBWrRUR72ggr5DGdwQtD02GBidwre0k5JfkN5Pny5H4ION6nyXwMhGH9qAS
7FNK2WyzgixRP1wustQeVJ/WCQVQQ+AVjL965LvHn/mEwEq0wjeJSljHONxH
kAksN+Fy/qwT/pYDy7pN9qhb8h5ett0Ffyja8tvQZeh6jBzuJfOuGLWrW+BV
0WO90byhGFGSmd3e+1rEIlsJtPOqBvGRdki8R+B5W9cIPIElEylJx/oLfiUi
5rpbTmmD9KXqVZ+/n/q9F4tZvQ0w2rOBZEpdEpe2Sf8rnhz7TJTZkXS6TrMC
/Ixpa6U/iaj4SjMfihmelW0hake1gQcF0SkdEftzQc0D0I2m4poGhP03pGFX
5YPMDAj9G9Kwk5OojluEjg1CR5zr5jTckW4SunJRro1puMttFLo0F01Ej/GX
qc/Wo/bIVG0SVumpV4MaaZk7vloRq86p/9+WpcUCf20uyoludtr51sS6g3Cd
7sbv0+j+rQtS3ShyvymoXf9Lv17UlqP09mfYul5I3OzonO968zOd42RGabVY
db2tSjMZDgaW6rOk+65cJyrfUauSH2tX5deKqh+K9kpOyL1G4EOBVYmQeXW6
GExTW6I6NJeb/K9i3H0vmnG5uOsJwc3Cw1GuvMjAlWm47wwH/hTFWz0fuemS
p3f+Qjeat+NznJzbnBc84etvXdN5Vd4lFEXMLmXcnT7OTK77bur5FbMiqpIy
OtKC3CRbd/VzibC7kTw7X8t4lkT89PzvzpyjTeTV14XDyyJPq60ecy4bCzJv
52sphSdib0+5SGRlLKi2dts9puNXidhvi1a05pLnTnd2H49ydQjLLkj1KXyi
CbWzTJ+IcaTBwYbAicCPThE7fUZ3J4DJqI5OY4E80cep9c2KO1fxzYrX19sD
i6q2as09jLyZ2BHVkXEh/uT1Mosj0oTfHuXyb3GIqlfgO6NcNWsRLKQY1QTX
rsCfTKbJsbYU+5K5n5nKqrPRvaOs/17PV7q54nNzHrLgKzY7lNMdLLMi+Oqn
CdkDfFdkbtcgHFkt2xWkCyWB0r1ribL5XqoTez7KBZKgARFEe2IZi4gHrJ+c
fA3nU4rpdAtaiIBrqgJxCAgKBQpuHXgBEUY8YDPFefcS7T5wRnx217G3kE/w
av29s2r7D+ucZCM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->646607275]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightCyan"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->134587206],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.9, 1, 1]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->508751471]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light cyan can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightCyan", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.9, 1, 1], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->550086660,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightCyan", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.9, 1, 1], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->513568294,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cyan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cyan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->787261247]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightCyan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 0.9369518}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LightCyan represents a light cyan color in graphics or style \
specifications.", "synonyms" -> {"light cyan"}, "title" -> "LightCyan", 
    "type" -> "Symbol", "uri" -> "ref/LightCyan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5307, 160, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->487444962]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35239, 820}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1651, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2274, 63, 1574, 37, 70, "ObjectNameGrid"],
Cell[3851, 102, 458, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4346, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4824, 138, 446, 17, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5307, 160, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->487444962],
Cell[CellGroupData[{
Cell[5692, 174, 148, 5, 70, "ExampleSection",
 CellID->252835600],
Cell[CellGroupData[{
Cell[5865, 183, 238, 7, 28, "Input",
 CellID->511908593],
Cell[6106, 192, 289, 8, 121, "Output",
 CellID->145409058]
}, Open  ]],
Cell[CellGroupData[{
Cell[6432, 205, 292, 9, 28, "Input",
 CellID->310096450],
Cell[6727, 216, 2232, 41, 110, "Output",
 Evaluatable->False,
 CellID->646607275]
}, Open  ]],
Cell[CellGroupData[{
Cell[8996, 262, 371, 12, 70, "Input",
 CellID->134587206],
Cell[9370, 276, 354, 13, 56, "Output",
 CellID->508751471]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9773, 295, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10007, 304, 115, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[10147, 311, 191, 6, 70, "Input",
 CellID->165065652],
Cell[10341, 319, 13671, 229, 129, 88, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->550086660]
}, Open  ]],
Cell[24027, 551, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24138, 556, 268, 8, 70, "Input",
 CellID->280509553],
Cell[24409, 566, 7265, 125, 129, 111, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->513568294]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31735, 698, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[32054, 709, 1656, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[33747, 776, 299, 8, 70, "MoreAboutSection"],
Cell[34049, 786, 124, 3, 70, "MoreAbout",
 CellID->787261247]
}, Open  ]],
Cell[34188, 792, 27, 0, 70, "History"],
Cell[34218, 794, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

