(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38349,        921]
NotebookOptionsPosition[     35098,        811]
NotebookOutlinePosition[     36326,        847]
CellTagsIndexPosition[     36241,        842]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Green" :> Documentation`HelpLookup["paclet:ref/Green"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Green\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightGreen", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightGreen",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightGreen"]], "InlineFormula"],
     " \[LineSeparator]represents a light green color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightGreen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightGreen"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    ButtonBox["Green",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Green"], ",", "0.88"}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->266267477],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->455178171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightGreen", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
   DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->574094082]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310096450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WFtonEUUnuy/18Rks4k11VpNbbXe6g1ttRqkTZqapElbY7Sl+JAWMX2o
SgwIkgcL2hd9EMHiBS9IEKpQiqKl1AtahCBeUIpKUeR/8sknn3yK3zkz88/M
2dltNwXDZvec+c/9Mv+ZGZ+em3ns0PTcwQPT/dtnp5+aOXjg6f7hJ2exlLQp
pY7if+9KBXgJEP8fTZdSPPC+S/hO8ChHGAH4JTAH8AWmKIsnCX3lHa5UQVDM
6+VE/9BfzqItyXmE8V//+ePUDz/io3L0lfz+75/m+eoW7COCKX58/OtvZ589
MTLylso//sSHKhkafBP4wqfftCTPp5hkChj36P73IQoKirwCYP7IJ5NT7328
+N2qZcrezRTw+cXXTsPcM+fOtvPK93/9dmjuOMTj0eVZJinORe/Xl7TLRhN8
ry58qboYh9/7Z45BmlrJUvoMt6bGOnyisHczDvUwgqj7Mmpfx4TlMlQ9FocO
8KrLolzjni7iulRIWRFYpqnhti8zWUx/AQ7vNHedjh2M6+wQqJ8jMYgGgb1R
rjHS+fLbn1/B64gaskBgT5R6lPEvzv4ESwhcJXTWAj9GbT6M11cKvBbVMSJk
rhY6u6NcD9hco2AIvJpxOAOXCKxGubYz/vPf5/bsW6DI9tvIw0LE2+Mif7QO
hBNBJXCNsKwrqFJ/N7A7hKzYYcaPfbb4zHMfEbiW8SOvnHrjg68I7GTeYl0P
lWJd5uHbbKThF7xT66xfaFXCtVy5f+nW9NRcoB5n77XCn0tasJ/QIduDiCis
VetFxDsayCuk8R1By0OTocEJXG87Cfkl+c3k+XIkPsi43mcJvEHEoT2oBPsr
pWy1WUGWqB9uFFlqD6pP64QCqCHwJsbfOXHm8EsnCaxEK3yLqIQNjMN9BJnA
chMu588G4W85sKzbZI+6Je/hZdtd8IeiLd8NXYaux8jhXjLPilG7ugVeFT3W
G80bihElmdntPa9FLLKVQDuvahAfaYfEewSet3WNwBNYMpGSdKy/4FciYq67
5bw2SF+qXvX5+6nfe7GY1dsAoz0bSKbUJXFpm/S/4smxv4kyO5JO1wVWgJ8x
ba30JxEVX2nmQzHDs7ItRO2oNvCgIDqlI2J/Lqh5ALrRVFzTgLD/rjTsqnyQ
mQGhf1MadnIS1XGf0LFJ6Ihz3ZuGO9I9QlcuyrU5DXe5zUKX5qKJ6DC/mfps
PWqPTNUmYZWefzWokZa546sVseqc+v9tWV4s8GlzUU50s9POty7WHYTrdDd+
nkb3b12Q6m6R+y1B7fpv+o2ithyltz/D1o1C4lZH53zXm5/pHCczSqvFqjtt
VZrJcDCwVJ8l3XvlDlH5jlqV/Fi7Kr9dVP1QtFdyQu5tAh8KrEqEzFvTpWCa
2hbVobnc5H8L4+590YzLxV1PCG4WHo5y5UUGbk7DfWc48Kconur5yE2XPL3z
G7rRvB2f4+Tc5rzgCV+/65rOq/IuoShidj3j7vRxcXLde1PPr5gVUZWU0ZEW
5CbZuquf64TdjeTZ+VrGsyTip+d/d+YcbSKvvi4cXhZ5Wmv1mHPZWJB5O19L
KTwRe3vKNSIrY0G1tdvuMR2/RsR+R7SiNZc8d7qz+3iUq0NYdlWqT+ETTaid
ZfpEjCMNDjYETgR+dIrY6TO6OwHsjOroNBbIE32cWt+suHMV36x4fb0rsKhq
q9bcw8ibid1RHRkX4k9er7A4Ik34g1Eu/xaHqHoFPhnlqlmLYCHFqCa4Hgr8
yWSaHGtLsS+Z+5mprDob3TvK+u/1fKWbKz435yELvmKzQzk9zDIrgq9+mpA9
wHdF5nYNwpHVsl1BulASKN09y5TN91Kd2PNRLpAEDYgg2hPLWEQ8YP3Ezndx
PqWY7m1BCxFwTVUgDgFBoUDB/QOvI8KIB2ymOO9bpt3zF8Vndx17C/k8r9bf
O6u2/wC8QNmd\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->86412833]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->97872922],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.88, 1, 0.88]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->745948682]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light green can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightGreen", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.88, 1, 0.88], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->165569138,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVewdcI8mV99i7a/vOd+t0yd/5znv25ws+N5N2J2yand1mck4NDAxDhiGn
IQ855yxyzhlETiILgUAgIRSQkFBACOVEUv2+TzSMvasZ27vzg56urser/7/q
vVfVXfVu2/g5O7jb+LnY2Xxw1cfGy9nFzveDK54+hkfvfO/EiRP2hl+3fzlh
uP9/hjv090sAwIl3HBwcAPrvxK8PLycuGa7vGR5+gJY+M1y/byi9c/z/0dOP
DdfDP3zvaxoM12MNF45lf/TW2nPHtX97WHr3j60bbv4drT97rPvvDkvv/bH+
WMe/oTKnj3X85C/InDyW+flbZX6FyvzhuK1/MOqJ7xuVf4lK//5Y4z9/K+n/
Otb9S6Pad4zK/4JK/+5Y96++lfRvj6X/3aj2XaMyivTEB8dIPjCqfc+o/E+o
9L8f6/7tt5L+12PdvzOq/YFR+R9R6V8e6/7vbyX9z8fSvzeq/aFRGR099Hr4
8A9GtT8yKv8Clf75se6T30r6p8fSp41q/8aojNraib8/RnLWqPZvjco/Q6V/
fKz73LeS/ptj6QtGtT82Kv8Ulf7RsfTHf0X3n6S/7q//FxW9CyGPIeQphNhA
iBOEuECIG4R4QogPhHhDiHG7xuWf/EnzN3wdjQU/vwIht1H1lhBii6p3QxW/
hJAgCAmDkAgIiYaQWAiJg5B4CElA743H/++Myu//qc03/P7QXk/8Cwwh1yDk
zteaNtByR5sOgJDQ1+0aGk2CkFQIyYCQTAjJhpBcCMlHrzkQkgUhxv72F5D8
hXiBetKvDZiuot3xEELMIcQaQhy/1h3BEBKOYjJ0QTKEpKGADDgwJkihCVIM
IaUQUm74MUHKTyEVJw/vi00OcR/z/olRm3+PIjPuSWM+h9b/fQOwE7/+encd
GYKhu3whJBDtrkh0XJJe4zJ0DgZCigygUDiVZ5Dqs0jdGaThNNJwBmk8jTSe
RRrPIHWnkCoT5NujM45Ah1b7ziG6/ziyo0coOjsIcYYQDwjxQ43oFYREobZj
6LV0wxiaIHmnkcLTSMlppPw0Un0aqT2L1H+INH2EtJxH2i4g7ReRjk+Qzo+R
zotIJ1o0NFh7GnkD49+9FaNxJHv/NcbfXv0mRhcUo+9rjNGvMWYcdZ8JUnQa
KT2LVJ5Das4j9eeRpotIyydI22dI5+cI9hLS8wXSexnp+xLph5H+r5D+y4cw
ez5H2s+/ifTHb0X6Vi/6jQGqKWqIN17DPfJ8Z2O4Zgkm5iknzTNOWuScssCc
sig+/bTsQ4uqcxa1FywaPrFo+cy87ZJ552Uz7FdIzxWk/xoycB0ZuoEM30BG
biLfx91CUN8cMTy8ivR+ibRcQI5G/a/iNvamv3ndw/9jsILrX/Og58dmauYD
WQRCT8MgyyjIKh6yTj5pnX7mefaHzzEf2RR/ZFN+zrbqok3tpzYNl2xavrRp
h593XbHuvvas74bVwC3L4btPR+9Z4B6YjT9EJh4hk4+RqceHXT1luH+IjN09
ZIO9/Cb2v30rduP54oevsf+vKdrjBhd7ACFmh95v7gA9dYWsvCHrl9DzEMgm
ErKLg+yTIYf0k47ZZ5zyP3QqOu9cdtG56lOXukvOjV86t5g6t19zwt506rnt
2H/XYfC+/chDO9wT23Hk+aT5sykLq5mnT2ctzQlWh/ANV4IlMvsUmTY7pNV3
7U0GKNY37Nk4vh/65LuHDP5gsJmbEHIPMnsCPbWErOwgaxfIxhOy84ccgiHH
cMg5xsQl8aRr2im3rLPueefcCy96lH7qUXnJs/ZLzwZTz5Zrnu03PbruePTe
9+h/6D70xG3EzHXM4sWkpfP0M6eZ5w6zNnZztjbz9tZEeytD+wsOZosOyII9
QrRF5qyRmafI8D3EOP6+nYOx1LuvOUDXIfO70NPH0DMLyMYGsnOCHNwhJ1/o
RZCJW9gp96gzHvFnvFLOemd+6Jt73rfgE7+SS34VX/rXmPo3XHvZfNO/7Y5/
133/nkf+/YjfkLnfqKXP2DPvyede07aesw4ec45u884vFlycSa6OS272hvaX
3Z6R3SzJbubLrgjJBVlwRGZtEByCvIHwR2/lYTxi339tTSdhyMwUenoTevYA
sjGD7J9BTvaQywvI1QvyeAl5hZr4RJzyiz3rn/TRy/TzgTkXgjCfBhdfCi7/
KqT6akj9jdDmO6Ft90M7H4V2IyH9FiFDViGj1sFjtkGT9oHTjgGzzi/nXP2I
bj6LHl5Lnh5kbzeKzwsDCqqvPdXXZtXPmur7dMXbjOKFLLkh847fls37RmWU
yWkYsoAhqyuQzW3I7iHk9BR6YQO5O0Fe7pCPL+QfBAWEmwRFnw5OOBuaej4s
6+NXeZ+FF16OKDWNqLwWWXsrsvFeVOvDqI4nUVjzqD7LyEHryBHbyDGHiEmn
8OkXr2bdwuY9Qhe8Q0g+Qct+ARR//5UA39VAbwMIepArI9iJGWLPCLahB1nR
Ay1WX5qRvRGi65t8fvhWPmgUPm8oG3igP2YwZAlD1jBkew1yvAu9QCD3Z5C3
A+T3AgrwgoJemoSEngyLPB0e91FE0sXI9E+jcy7FYL6KLb4SV34jrvpOfP39
+ObHCe3mCV2WCT3W8QO28cMO8Tjn+IkXcdPusXjPmDnv6AW/KNLLyOXAcEpQ
GDUklBYWzHgVaMCwFuHNivBgRbqyI51YEXascOu1V5b0EDPKS2Te/U1GP3gr
I3SVeB7lYo5yeQ5D9lcgl1uQ+0PI2wLys4ECnUxC3E+F+Z4ODzwT+epsdPRH
sQkX41I/i8+8nJBnmlR0LbnsVnLV3ZTahymNSGqrRWrns7Rum9R++9Qhp9TR
F6nj7ilTXil4n2SCXxIxIJEUlLAcEk8Ji6WGR9MiIhlREWsxrwyA2HGB63H+
nHgfbrwHJ/4FJ86BE2vDirZkhJuvBCMzhjEyjlNHjN62gjhx4TUjKxiyMYUc
r0Ku1yGvu5DfEyjQCgqxg169MIn0PB3tfzY25KP4iHOJsReSkz5NSf8iNds0
DXM9veR2RsX9zOpHmfVmWc2WWe3W2Vi77F7H7AGXrBG3rDHPrEmfrBn/TEJA
xnxQ+mJo+vKrNEpkCjUqmRaTyIiLX4uPZSfGrCdFGmBtpITwUoN4qf68VG9e
ihsvxYmbZLseb8mMMSeHIId+c7iI/tGf53LxtZnZwJDzVcj9OuRzCwp4AAWb
QWHWUKQjFONmEudzKiHgbHLYR6lRF9PiP8tIuZyZaZqVez278E5O6YO8yid5
teb5jVb5rTb5nfaYbmdMvytmyAMz6p0/7pc/HZA/G5Q3F5q78Cp3KTKHHJ1N
jc2ixWcwEtPXklPZqcmctERuerwBFj8zUpAVLswOEWYHCLN8BVke/EwXXpot
J8WKEWe2GIygcfeQgPGq87238kP96WN0rI75mUKeVyG/G1DgHSjsERTxFIq2
geKcoSSPkyl+Z9KCzmWEf5wV83lO4uXctCt5WTfy8+8UFD0oLEeKqi2K6p8V
N9sWtzmUdLmU9LqVDHiWDPuUjPmXTAYWz4QUE14VESOKFqMLl2MLVhIwq0n5
9JRcZloOOyOLk5W5kZ3Oy00xIBPmxW/mx4gwkSJMmAgTJML4b+Z7CXNd+Nl2
nHRLWrzZ4Wi9dRX7dnafoNHO4FXOMORlCr28DgXfhl7dg6KfQHFWUKK9ScqL
U+leZzL9z2WHfJIbcSk/7suC5CuF6TeLc+6WYB6WliBlFZblNdblDXYVLY4V
HS8quz0q+7wrh/wqRwMqx4Mrp8IqZiMq5qMrFmLLlxLKKEml1NQSenoxM7OQ
lVWwnpPPzcvjYXIEBVkGZJvFqVslSeKSeHFJtLgkXFwSIi4J2Cry3ix4wc+z
ZWdYLEQgb7xJvp0dGts/RW3TCmXnCUMvr0AhN6CIO1DMQyjR/GSK9al0hzOZ
bmdzfD7KD7iICf28MOrL4virpSk3yzPvVuQ+rCw0qyq1rK56XlNnX9PoVNPq
WtvpUdvjUzfgXzccWIcLqZ14VTsTWUuIqSXG1ywmVS+nVK+kV9EyKxnZFWu5
5ez8Um5BMa+oSFBSICzNN4DbKs8SV6RvV6ZKqhIlVbGSqkhJZdh2RYC4zHuz
5MUGxpqRYf7d+BlGz+GIHAyFXoEib0Bxd6GkR1CaxclMmzM5Th/muZ8r8L1Q
HPRp6avLZdFXKhJuVqXdrc56VJNnVltkWVf2vL7avqHeubHZrbHNs7HLt6n3
ZdNgcNNIWNNYRNNkdBM+rmkusXEhuZGU1kDOqKdm19Fz65iYWlZhNae4aqOk
gl9WLqwo3awsNoAT1+RLanOldVnSujRZfbKsPl5WFy2tDZPUBIirvIVlTtxC
q2/HD11pfI6On8Hx3GHI38APhqKuQPE3oeT7UPoTKNvyZJ7t6QKXD4s9z5f6
f1oR/EVluGl1zI2axLt16Y8ass0aMZZNxc+by+1balxaG9xaW7za2n3bsAFt
fcHtQ6/aRyPbx2Pap+PbZpPa5lPbFjNal7NaKbktq/nNjMKmteJGdmkDt7yO
V1krqK7erKkS1VUY8Ekai6VNhbKmfFlztrw5Q9GSomhJkDdHyxrDJA0BWzWe
/HKH1RzEeN19xNI47rx/zNIwFbjAkB8MhRgowlDCFSjlFpTxAMoxgzDPThbZ
nyl9cb7c65Oql1/UhJjWRVyvj73TmPywOcOsJceyteB5W4lDe6VLR617Z6N3
V6tfV0cgtjsE2x+OHY7C4mKxEwnY6WQsIQ1LzMSScrrIeZ0rBR20og5maTur
vG29smWjuplf2ySsbxA11m011RjwSVsrZG1l8vZiRTtG0ZGr7MhSdqQq2hMU
7dGy1rDtJv/NOjd2qeV3Y2lriDEwFAxDkTAUD0OpplDWTSj3PlRgdrLE+nS5
w/lK109qvL+oC4AbQq83Rd5piX/YloK0Z1p25j7vKrTHljp3V7p313n3NPn1
tgb2dob09YT3DUT1Dcf1jyX2Tab0zaT3EbL6FnL7SPm95MIeakkPvax7rRLL
ru7i1Hby6tsFjW2bza1brc3itkYDPllnjbyrSoEtV3aXqLoLVT35qp4sVXea
Epuo6IqWtoeIW3w3ahyMLfbdv8jSFfXFCJRiCgxlmUL5N00KH5wqNT9T8fzD
aseLdW6fN/h81Rx4rTXsdnvUg454pCvlKTbzeU+efW+hc1+ZW3+V10Cd30BT
4GBb6GBX+FBv9NBA3NBI0vBY6vBUxhA+e2gub2ihYGipaJBSOrBaPkCv6l+r
7Vuv7+U29vCauwWtXaL2TnFn+3ZX6yHLnkZFb72yr0bVX6keKFMPFKsH8tUD
2ar+NGVfgrw7UtIZJGh2/3YsUb/8AvVLb9QjY1GWmTCUbwoV3Tpd9vBspcVH
tTbnG5w+bXK/3Op7tT3wVuer+9joJ90JFr2p1n1Z9gP5zoNFbkNlXsPVfiP1
gaPNoaPtEThsNK43HjeYNDaaNjaeOTaVMzabj5svxC2W4JbLRlcqR1erRxh1
w6yGofWmQW7rAL+9X9jZK8L2iLuxkt5OA0T5QKtysFk11KAarlWPVGlGyjUj
xZoRjGY4WzWUqhiIk/WGb3b4rtXaGNvtX+bqCEMBqF8moUTzDESvQuW3TlU9
Olv39Fyj7cctzpfa3U07fW9gg+71hD/ui7EYSHw2mGY3lO08ku82WuyFK/cb
qw4cbwidaImYaI+exMZP9iVNDqVNjWZOTeRMTedPzhZOzpdMksonl6smVmom
aPXjzKYxdssYp210o2OE3zW82T201Tuw3d8nGewxQFSMdCpH21W4FvVYk2a8
XjterR0v144Xa8cxalyWciRZPhSz1RvEbXP9blwNkTYMNd2010TLrkPVt0/W
Pzrb9PRCq+3nHc5fYT2u9/jd6Qt6OBBuPhRjNZJoO5rmNJbtOo7xmij2mywP
nKoJnW4In26JnumIn8Em4fvS8EOZeFzu7AQGP12Eny3FEyvwpGo8uXZmpWGa
1jTNbJ1id0xyuiZ43eOC3rHNftzW4Mj28JB0ZOCQ63ivagKrnuzQTLVpp5u1
0/Xa6WrtdLl2ulgzla+ayFCMJW4PhfOw3m/naryj8f4xV180EiXDUDYMFZpC
ZdegqhtQ/Z1TzY/PtT39pNP2crfL1T6PWwN+D4aCkZEIS1yszXiS40Tai8ls
z2mM70xxAL4iBF8TPtsQTWiJn+tImutOm+vLnB/Kncdh5ieK5qdL5wkV88Tq
eVLdHLlxjtpMoLfNMjtn2Vg8p2eG1zctGJzaHJ4Qj45v43DS8REDROXUoGq6
Tz3TrcF3aWfbdYQWHaFBR6jREcq1+CL1TK5yKk2Ci+H3B3w3rkEwFAdDGQY3
haFSU6jqKlR/41TznbPtjy92WV7qsTXtd7k55HlvxP8xLthiPOL5ZKz9VJLL
dLo7PttnFvOSUBIyV/FqviaK2BC30Jq02JG22J252J+7OIwh4YpJE2WkmUoS
oYZErF8kNS2SWxao7Qv0TuJaN5HdO88dIPCGZgUjeBFuRjw+JZmclE6NH3Kd
HVERhtRz/Zr5Hh0RqyO264gtOwsNOmK1dr5MPVegnM2STCYIR0K/G9cw1FNz
YagIhipgqO7aqaZbH7bdPd/1+NNeyy8H7K4NudwZ9Xw45m8+EfxsKsJuJtZ5
NsmNkO49l+NPxAQvlLxarIgi1cQtNSYttaYtd2Yud+eS+zHk4SIyrowyWUme
qSET6snEJjKplUxuX6Z2LdF7ltb6SOzBRe7wAm+UKBybF03OiadmJTMzstnp
Q67z4yriqGZhWLs4oCP16pawuqX2naUW3VK9llSlWShRzudJ8SnCsYjvwPUU
Os8YPBUDQ2UwVAObNF0723b7fNf9T3qfXBqwNB22u4lzuT/uiUz5W84E28xG
OM7Fus4neS2k+y3mBJEwYcslkeSKWHJNIqUhdaU1c6Ujh9qNofYXUYfLVnGV
qxM1qzP1q4QmKrGVSuqgkrEr1J4Vej9lbYjCHiFzccu88SXhFEk0syCeJUoI
c4c7PyfeVy5OqUgTmmWcljyiowzqKH06CnZnpV1HadaS6zTLFcrFAul8pmAy
2njOeefPc4XQCJyFDmoVbNIAn2y9eqbr5vnee58OPPlyxPLamO2dCZdH054W
eH9rQrD9fITLQqwHKcl3KT1gOSeUgolYKYmhViSs1qSsNmTQWnPoHfn07iJ6
fyljuJKBq2FM1DNmmhiEVgaxg0HC0sm9dGo/jT5EWxtdZY9RuRMrvCmKEE9G
gZ34qWyRqFiaM9yqKNPqlUktdUy7OqJbHdyh9e3QsLrVNi21UUOtUZJLpIs5
Anzcd2D6e3RSNZhvKWxSC59shk91mJ7puXF+4N7nI09MxyxvTtren3FBZj2t
5v1tF4KdFsPdlmK9yUkvKenB1OzwVUw0rSSeXpHMqElnNmQzW/LXOgpZ3aWs
/grWUA0LV8+eaGLNtLIIHSwilkXqZZEH1qhDTPooc22cwZ6ko/x+sUlc2Vok
S5aWZcskOWVBuTJveKymzWjoU1rGmI4xomMO6pi9OkanltGiptUrqeXSZQx/
LumN97MjpsY7UOjb53+hMw0G9VLDgLbBp7Dw2f4bHw/fuzz25Nqk5d0Z20cE
Z4t5z+eLfg5LwS/I4Z6UGD9qUhAtLYyeHcXAxDFLktYq0lg1WeyGvPWWwvWO
Ek53Bae/mjNUz8U1cSdaudMdHAKWQ+zlkAY45OF1Km79aAT/iTPL5M0zBAv0
TRJta5m6TVmRrpDlq0sK2qKKQTSIaNbwWtaUljWmY4/o2ANaVreW1aFmNiro
VZKVQv5C6ndg+ls0JBXCUDUMNcMmnfDpXtPzQ9c+w92FJx/fnHn6YM4WITpb
LXrYLvs5U4LcqeE+qzEB9MRQZlrEWnYsKz+RXZy6Xp7Jqc7lNhRstJRsdJTz
sNW8vjreUCN/tJU/0cGfxvJme3nopueJX9KmuEw8h0XgcObXeYtswRJrk8zc
WqFvU2lSGlXGoCiYy0oWSc1eOGTKwWs5U1rumJYzrOX0aThYFbtFzqwVrxbz
SOnfZUQ/QKcZg4vWwlArbNINfzhg+vHolS8mbl+deXibYPGIaGNBcnq+7O6w
4uu6GuRFf+XPjAleSwxnp0WvZ8Vz8lO4RRkb5Tm8agy/vkjQXCZorxJia4V9
jcLBls3Rjk107P5tfli4iBMujwtWpgQ0PJ9B4LGIG+uL3I0lLp+8Llxhb62y
tulMCZMuY63K2SvKdbKKSzpkujGn5eG1vEkND6fhDao3epScdhm7YYteyl5M
/ZZM0e9ev4KhkkOrhdrhU73wuWHTT8eufjV98zrhwT2i+RPScyuyo+2Ku/Oq
rzsj0HftVQArOnQ9IZKTGreRlcTLS+MXZQnK8oVVhZv1pZvNlaL22q2uhi2U
3QfjPeKpgS388NY8bmtxfGt5SkTBi1bnNhlE4dqiYH2Zz6Xw+NQNIY0rYqyL
19gS9pp0nSHn0hQbVCWPrOKjTIUEjXBGIxxXC0ZU/D4Fr1PCadxkltMXUr4D
y18eRiGoETbpgs/0w+dHTT+bvArjb9yav/9g0cxs2dp6xdGB5vaC4eO1FuDP
DgvmRIVvxEfzUhIEmanCvMzNwlxRWcFWVYm4rkJ85He/6W2TDHRJRnqkY/2S
ySEJflQyNy5ZmJIs4bcpc9urRDGdtLW2LGJTNrmrQh5dIGDyNlkbW+vcbc66
dIMl4zEVArpSSFVuklWiQ6Zq0axaNKUS4RTCAbmgW8xtFrAqjL8vf//Pc/xH
dCQb4ZMGax2EL4yZfj597Qrh5u2Fe4+Wkacrz2xoDk5MV3eWl8/6ywBuaCgv
MpIfFydMTt7MSN/KzRYfedzvGutkrU2yzlZZT6e8v1s+3CfHDcknR+Uz43LC
lJw4IyMRZGSilEqS0pclzJVt9qqYQ9/aYIr4LOHmukDE5Yl5XAl/XSpkyTeZ
ChFNuUVVislK8eLhLLM9oxCPy7eGpJs9Il4LZ638jS/of4Hhz2GoAIaaDhme
HYYvTMBf4K9dm791l3QPoTyxWrWyY9i5sF54rnv6cf2DeCHhgoiYzdiEI2v8
H0yhtKRUVlEpr6lVNDQoWlqUHR3Kbqyyv1c1NKjCjagmxlTTk8rZGeU8QWmY
FZcXFSvLchpFxliVsujS9bVtLlvM52wJN0SbPOGWgL+9uSERcaRbLPk2UyGh
KSQrCumSQnoYiOSSSdn2qFjUKxS0rjHL/gxH1GCPHh6dlnn/MKie7IHPjMIX
JuHLBNMbi9fvk++YUR9ZM546rNm6rjt7b3i85PuFClFOf0hMl6TlyLIx8vxi
RXG5srxaVV2vqm9WN7er27s02F5N34BmcFgzitOMT2qmZjSzBM3cvHphUb20
rKJQVKurSjpdsbYmZ7NlHI6Ut7HN54uFQpFIJBRvCbbFGxIJRyplyWQMuWxV
LqfI5SSZ7HCxsC3BbW71bQhaybSCb8ntxzBUD5v0wKdH4YvT8Jdz8E3S1Ycr
ty1oD23WLJzWn7tzj/zKJDBa/CpBEp0qTciUp+YpsgqVeaWqokp1WZ2mqlFb
16pt6tS1deu6+nW9Q7oB3M7IxM7YtG5yVjczryMs6ohLWhJFS17VUOlq2pqa
yVayOIr1DTmXL+MJJQKReFO8JdreFEv527INiXxdqliTKugyJVWqXJIoDlcH
W9IxgbifzW952y7hW5j9CIYqYagbPjUKfzwDf0WEby2bPqLefMpA+Zx28Be6
Bou8I8QvYyWhSbKodEV8tjIFo8oo1uSWawqqtaX1usrmndr2nUbsbmvvbufg
bvfIbv/43tDUHg6/OzG3O72wO7u0O0/ZWaTuLNN1FKZula1lcDRrG2q2QMkR
KjZEMr5YKpRsb0q3RHKhWMEXK7nbSrZExdxWrW6ryGLVgkiBN8DhiHtpG41v
3f/8JrOjc30w1AmfwhloHcWGs3ft1p+82LDyEti9FLmEij0jJf7xspAURUSm
KjZXnVSoSS/VZVfuYGp3iht3K1r3ajr3Gnr2Wwb224f3sbj9vsmDwZmDEcLB
OHF/irSPJ+/PUfcXaHsk5i6ZtUvl7NA2dAy+lrWpXhepuGIFTyLny6QCuXhT
IRKphFtq3paas6VZ29LQtjQUkXpRoMRvyMbQxfq3YoSOyAUYXoDvUK48pl2z
Yt1y4D505Vv4bNoEbjmFSdyjZb4JiqBU1assdXS+NqFIl1q+k1W9l1e/X9S8
X9Z+UIXV1/Xpm4b0baP6rnF9zzQYmAXD82BsUT+5rJ9Z0RNo+nnGwSLrYHl9
n7Kxt8rfpQt3mCItS6xZl6i4MuWGQs5XSgQqsVC9uanhb2q5m1r2ppYu1K4I
NIsbqlmWDEcRdhiQGnP63hucfvaa00XDDWwyeOhaBnK3KfAT+pVn7BuOG/fc
BIivyDpo2yFc5hqj8E5SBaRrQnO0kZiduJLd5Mq9jNqD3EZ9Qau+pFNf2QNq
B0DjMGgZAx2ToBsP+ubA4AIYXQLjFDC1CvAMMLemX1jXk7h6Mv9gRbi/Ktqj
i3eYEh1LpllXqLhKxYZaxtNs87VbAp1QoNsQ7KzzdQyedoWrIbGUeJp05I3Y
brzj+JrnN98n/rjfdQGGOuDzE/BXR0QZptbrBqJ33YWP/bYsgyV2EXKXWKVn
stovQxucuxNeuBdbtp9YdZBWd5DdrM9v1xdh9eV9oHoQ1I+C5nHQNg26ZkHP
PBgggWEywFHBBA1MM8EsWz/P0S/w9EsCPVl0QBXv0yR7DNkOU65jKTXrahVH
I+dqpRs68cbO5sYOb2OXw91hcnQrLM0iXTG9uNX33Xkermj+uE95Dj47An8x
B98iG0jCz9avOvJuu28+9N82D5E+j1Q4xqvcUrQ+mTuB+XthRftR5fvxNQcp
DQeZLfrcDn1ht760X185DGrHQOMkaMGDjjnQvQD6lsAgBYysgjEGmGSBGY6e
sKGfF+gXN/VLW3ry9gFVuk+T79GVO0y1dk2jZmmV7B3Z+s72+q5ofZe/vsth
7zKZuhWamrgkHTf++ma8InuT4Q+PRxKNQB/Bn+Hh60vwYzr8jH3FkXfNQ3TH
f/tJiMwqUmkXr36RqvPK2vXP3wsp3o+oOIitPUhq1Ke16rO79JheffEgKB8B
1eOgfho0zYK2edBFAj1k0E8FQ3SAWwPjbDDFBXi+niDUE0X6xW39kvSALD9Y
Ue6vqnZpGh1Dq2HuqJg78rVdydqeaG2Pz9zlMHYYVC15SUmYEPS+sZtj/E3j
TX6vd2bR9cqH8Icj8JUF+MEqbMU2deBd8RDd9N9+ECI3j1I9T9A4pu24Ze/6
YPYCS/bDKg+i6vTxTfqUdpCJBbl9oGAIlOBAxQSomQENBNCyANqXAJYCelfB
AAMMswCOAyY2wLQA4EVgTqwnSvSLMv2S4oCs2qeo96janVWdlrajou/K6XsS
+p6Itsdf3V1f2aGT1KQZycRfOx12zO1PZ0/B1058n4Ev4eG7FNhiDbbfgN03
r/tt3wmRP45SWSVo7dJ2XLL3PAv2/UsPgqv0EfUgphkkdoC0bpDVD/KHQdEY
KJsEVXhQNw8aF0HrMuhYAd000McEg2wwwgU4PpgQgmkRwG8DghTMy/ULSj1J
fbCk2SPrdik7upVd9cqefGVPsrInouzylndYCxrqjHzubafE3uR0SAk9DX4K
vkaEETpsy4FdhVd8t2+FyB5EqcwStNZpOw45+24FBz5l+oBqEFoPIltAXAdI
7gEZAyBnBGDGQfE0KJ8F1URQTwJNZNBGBZ0M0M0CfetgcAOMCABuE0xsgSkJ
mJGBWQWYUwGiRr+g3V/U7ZJ2dUu76qU9+dLeNmlvc2HX8DrHmFKQjP3n7fi/
/uT/HF5M4HvLsNUa7MK/4r11LUh2K1L1KF77NG3XJmffuVDvUQZ8q0FQA3jV
AqI7QUIPSB0EmSMgdxwUTIMSAqgggpolUE8BzaugjQE6WaCbA/p4YFAIRkQA
JwbjUjApB9NKgFcBgkY/pz2Y39md39USd9XEXdn8rpiwI5jRsseVK2874fM9
Q/EQ+TfnL4fXZ4r/AD9Zge05sIcQDpBci1DeidM8Sd2xyt63K9C7lOo9q/X+
DSC4FUR0gphekDgIUkdB1gTImwGFBFC6ACqXQM0KaKCBZiZoY4NOLujmgV4h
GBCB4W0wKgVjcjCuBJNq/bRGP6M7wO/s4ne0+F3lzK50Wiea1G4MK2jGc+0P
3sBt/I0LzU74PfyUBr/YgP224DD5jVjV/RSdWdb+M8yBQ6netUrv3aB/2QpC
OkFEL4gdBEmjIG0CZM+A/DlQuABKl0HlCqihgXomaGaDNi7o4AOsEPRsgf5t
MCgFw3IwqtTjVPoxzcG4dn9CtzOhU4/r5GNa8Yia3ydn/tQI03tvoD6MR4df
M1E7+W/42SrswYODtq9GKW4lah5k7prn71uXHDhW6d3qgXcLCOgEoT0gchDE
jYKkCZA2A7LmQN4CKFwGpSugggaqmaCeDZq4oIUP2jdB5xbo3ga9UtAvBwNK
/aBKP6TeH9bsDWu0QxrloEbSpxR0SJg/N8L57hs4jU9Mof75n7D5IuzNg8Mk
V+OUN9O0D3J3zYv2n1foHeuAWzPw6QABPSB0AESOgNgJkDQD0uZA1gLIWwaF
K6CEBsqZoIoNarmggQ+ahKB1C7SLQacEdMlAt0LfozzoUe31qnTdKhVWKW2X
CWo3ab/4q0iNfRK1g9/Avlw4YvtKovJ6pvY+Zte87OB5DXBsBG5twBsLAvpB
yDCIGAex0yCRAFKJIHMJ5FAAZhUUMUEpG1RwQDUP1ApAgwg0boHmbdAqBa0y
fZt8r02ua5WrmqWSWjH/n4zafucNdK/zFlDP+jUcIYKT5VezNXcLd80q9M/q
gH0LcO0EXr3AfwgE40D4JIjGg/h5kEwC6WSQRQW5dFCwBorWQSkXlPNBpRBU
b4KaLVAr1tdu79Vua2vEigqROHedeTRGRmvub6IxjmeoFf4rnLgN56huFeke
V+1bNhzYtumdsXqPfuA7DALHQeg0iCCAGCJIWALJFJC+CrIYIGcN5K+DAq6+
kKcv4utLhAfFwp1ioRrDk6Qy2Udx5M8g+VOeCCr1z4YbOE10pVB5p1KLNOxZ
te3bYQ9eDOg9R4DvOAicBqEEEE4E0UsgjgISqSCFDlKZ+vS1gwz2fgZbl85W
JTHFRxlZ7319bjyMZ0ftGb9dof30D1+XhfOEN6sVj5o0lp27Nr17TkN7rrh9
r8l9P/x+wNx+MHE/lLT3ank3nKx9RVYGk8RoRtE3skCOWjKOWsb5VR/+mb/7
CXh7PtZHXyv/ic/PjKSMc75e56UdSb/ODzKWOv+NMTGuNW7jEMk7f5T+x2Od
xlKHWUXvvn4veIO9ce9A4OunAI2t13jm+h9wlM13lK3wOv/KWOp3xzqPcoyM
7dB4PfLBsc6jLK1fHes0lvrVsU7UW04YZ6q9LVIeSh/lAP76WKex1C+OW/4N
KvUfRrXGc9tPjnX+Fyr9G6Pat73XHEr/Lyr9OsPOWOoHxwjQvDG0375uae8e
60At9sR/Gq4/cDjO1Tpx4nv/HyMQSx0=\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightGreen", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.88, 1, 0.88], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->640067111,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Green",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Green"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->16263435]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightGreen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 5.7652004}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LightGreen represents a light green color in graphics or style \
specifications.", "synonyms" -> {"light green"}, "title" -> "LightGreen", 
    "type" -> "Symbol", "uri" -> "ref/LightGreen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5322, 161, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->266267477]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36098, 835}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1654, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2277, 63, 1575, 37, 70, "ObjectNameGrid"],
Cell[3855, 102, 461, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4353, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4831, 138, 454, 18, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5322, 161, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->266267477],
Cell[CellGroupData[{
Cell[5707, 175, 148, 5, 70, "ExampleSection",
 CellID->455178171],
Cell[CellGroupData[{
Cell[5880, 184, 239, 7, 28, "Input",
 CellID->511908593],
Cell[6122, 193, 297, 9, 121, "Output",
 CellID->574094082]
}, Open  ]],
Cell[CellGroupData[{
Cell[6456, 207, 293, 9, 28, "Input",
 CellID->310096450],
Cell[6752, 218, 2227, 41, 110, "Output",
 Evaluatable->False,
 CellID->86412833]
}, Open  ]],
Cell[CellGroupData[{
Cell[9016, 264, 371, 12, 70, "Input",
 CellID->97872922],
Cell[9390, 278, 358, 13, 56, "Output",
 CellID->745948682]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9797, 297, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10031, 306, 116, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[10172, 313, 192, 6, 70, "Input",
 CellID->165065652],
Cell[10367, 321, 14033, 235, 129, 92, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->165569138]
}, Open  ]],
Cell[24415, 559, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24526, 564, 269, 8, 70, "Input",
 CellID->280509553],
Cell[24798, 574, 7728, 132, 129, 115, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->640067111]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32587, 713, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[32906, 724, 1658, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[34601, 791, 299, 8, 70, "MoreAboutSection"],
Cell[34903, 801, 123, 3, 70, "MoreAbout",
 CellID->16263435]
}, Open  ]],
Cell[35041, 807, 27, 0, 70, "History"],
Cell[35071, 809, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

