(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37284,        903]
NotebookOptionsPosition[     34024,        793]
NotebookOutlinePosition[     35263,        829]
CellTagsIndexPosition[     35178,        824]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Magenta" :> Documentation`HelpLookup["paclet:ref/Magenta"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Magenta\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightMagenta", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightMagenta",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightMagenta"]], "InlineFormula"],
     " \[LineSeparator]represents a light magenta color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightMagenta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightMagenta"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    ButtonBox["Magenta",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Magenta"], ",", "0.9"}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3550627],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->526475476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightMagenta", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.9, 1], EdgeForm[GrayLevel[0]], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->627727430]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightMagenta"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310096450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WFuIlVUU3nP+c51p5syZycYya0zLbnajtKwhHOeSM87kaDZJ+DAMwcyD
GJPRQ/ZgFL7US4EhCBKREPmQBEZUIAiCIEiBESSEgdpDESQ+CMHft9be+997
r7PP0TNCMp5/rf2v+2X/a++JmT1zr+2a2TM/O9M/ujDz+tz87Bv9I7sXsJS0
KaUO4P+OpQpwCoj/H0gv4en/lvCb4FWOMALwJDAH8H2mKIs3Cf3kHa5UQVDs
1cuJftC/nEVbkjPN+JXz185+dxF/Kkc/ybUL/5r3y1uwjwi28+uTx357e+Hb
8dHDKr977muVDA8eAv7NkV9akudTbGMKGDe78yhEQUGRVwDsf+fE9NYjp4//
vmyRsqeYAj4f/OA0zP311J/tvHL5x3/e3HUc4vHq9iyTFOei9/QlbbHRBN/n
n5xVXYzD7/nZryBNLWUpfYZbU2MdPlHYuxmHehhB1H0Zta9j0nIZqh6LQwd4
1W1RrglPF3HdKqQsCSzT1HDbl5lcOPM3cHinuet0bGZcZ4dA/R6JQTQI7I1y
jZPOwx+duYPXETVkgcCeKPUY4+dO/AFLCFwmdNYCP8ZsPozXdwq8FtWxSchc
LnR2R7lesLlGwRB4N+NwBi4RWI1yjTL+189Xd05/QZHtt5GHhYi3x0X+aB0I
J4JK4AphWVdQpf5uYHcIWbEjjP9w9Py+t74ncCXjH+8/9eWhnwjsZN5iXQ+V
Yl3m4cM20vAL3qlV1i+0KuFarty/dGt6am5Qj7P3XuHPLS3YT+iQ7UFEFNaq
1SLiHQ3kFdL4jqDlocnQ4ASutp2E/JL8ZvJ8ORLfyLjeZwl8QMShPagE+5RS
Bm1WkCXqhwdFltqD6tM6oQBqCHyI8WOfnvvw3ZMEVqIVvkFUwhrG4T6CTGC5
CZfzZ43wtxxY1m2yR92S9/Cy7S74Q9GW34YuQ9dj5HAvmXfFqF3dAq+KHuuN
5g3FiJLM7Pbe1yIW2UqgnVc1iI+0Q+I9As/bukbgCSyZSEk61l/wKxEx191y
XRukL1Wv+vz91O+9WMzqbYDRng0kU+qSuLRN+l/x5NhnosyOpNN1gxXgZ0xb
K/1JRMVXmvlQzPCsbAtRO6oNPCiITumI2J8Lah6AbjQV1zQg7H8qDbsqH2Rm
QOhfl4adnER1PCd0rBM64lzPpuGO9IzQlYtyrU/DXW690KW5aCLax1+mPluP
2iNTtUlYpddfDWqkZe74akWsOqf+f1sWFwv8tbkoJ7rZaedbFesOwnW6G79P
o/u3Lkj1tMj9hqB2/S/9WlFbjtLbn2HrWiFx0NE53/XmZzrHyYzSarHqSVuV
ZjLcGFiqz5Luu/KEqHxHrUp+rF2VPy6qfijaKzkh9zGBDwVWJULmo+mlYJoa
jurQXG7yf4Rx971oxuXiricENwuPRLnyIgMPp+G+MxL4UxRv9Xzkpkue3vkL
3Wjejs9xcm5zXvCEr791TedVeZdQFDG7n3F3+rg5ue67qedXzIqoSsrophbk
Jtm6q5/7hN2N5Nn5WsazJOKn53935hxrIq++LhxeFnlaafWYc9l4kHk7X0sp
PBF7e8o9IivjQbW12+4xHb9CxH5ztKI1lzx3urP7RJSrQ1h2V6pP4ZNNqJ1l
+kSMIw0ONgROBn50itjpM7o7AbwY1dFpLJAn+ji1vllx5yq+WfH6ektgUdVW
rbmHkTcTU1EdGRfiT14vsTgiTfjWKJd/i0NUvQLfFuWqWYtgIcWoJrheCvzJ
ZJoca0uxL5n7me1ZdTa6d5T13+v5SjdXfG7OQxZ8xWaHcnqZZVYEX/00IXuA
74rM7RqEI6tlu4J0oSRQuq8sUjbfS3Viz0e5QBI0IIJoTyxjEfGA9VMTn+F8
SjHd0YIWIuCaqkAcAoJCgYLnBw4iwogHbKY4v7pIu/feFJ/ddewt5Hu8Wn/v
rNr+A06AZCM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->22806608]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightMagenta"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->310824590],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 0.9, 1]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->394797410]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light magenta can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightMagenta", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.9, 1], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->60339970,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightMagenta", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.9, 1], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->141428443,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magenta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magenta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->49531394]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightMagenta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 19.2655460}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LightMagenta represents a light magenta color in graphics or style \
specifications.", "synonyms" -> {"light magenta"}, "title" -> "LightMagenta", 
    "type" -> "Symbol", "uri" -> "ref/LightMagenta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5343, 161, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3550627]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35037, 817}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1660, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2283, 63, 1577, 37, 70, "ObjectNameGrid"],
Cell[3863, 102, 467, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4367, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4845, 138, 461, 18, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5343, 161, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3550627],
Cell[CellGroupData[{
Cell[5726, 175, 148, 5, 70, "ExampleSection",
 CellID->526475476],
Cell[CellGroupData[{
Cell[5899, 184, 241, 7, 28, "Input",
 CellID->511908593],
Cell[6143, 193, 289, 8, 121, "Output",
 CellID->627727430]
}, Open  ]],
Cell[CellGroupData[{
Cell[6469, 206, 295, 9, 28, "Input",
 CellID->310096450],
Cell[6767, 217, 2227, 41, 110, "Output",
 Evaluatable->False,
 CellID->22806608]
}, Open  ]],
Cell[CellGroupData[{
Cell[9031, 263, 374, 12, 70, "Input",
 CellID->310824590],
Cell[9408, 277, 354, 13, 56, "Output",
 CellID->394797410]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9811, 296, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10045, 305, 118, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[10188, 312, 194, 6, 70, "Input",
 CellID->165065652],
Cell[10385, 320, 13207, 222, 129, 88, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->60339970]
}, Open  ]],
Cell[23607, 545, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[23718, 550, 271, 8, 70, "Input",
 CellID->280509553],
Cell[23992, 560, 7456, 128, 129, 111, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->141428443]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31509, 695, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[31828, 706, 1662, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[33527, 773, 299, 8, 70, "MoreAboutSection"],
Cell[33829, 783, 123, 3, 70, "MoreAbout",
 CellID->49531394]
}, Open  ]],
Cell[33967, 789, 27, 0, 70, "History"],
Cell[33997, 791, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

