(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39291,        934]
NotebookOptionsPosition[     36033,        824]
NotebookOutlinePosition[     37268,        860]
CellTagsIndexPosition[     37183,        855]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orange" :> Documentation`HelpLookup["paclet:ref/Orange"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Orange\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightOrange", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightOrange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightOrange"]], "InlineFormula"],
     " \[LineSeparator]represents a light orange color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightOrange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightOrange"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"1", ",", "0.9", ",", "0.75"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140536622],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->377517920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightOrange", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.9, 0.8], EdgeForm[GrayLevel[0]], DiskBox[{0, 0}]}]], "Output",\

 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->431635470]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightOrange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310096450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WEtslUUUnt7/Plvb29uKRREtguILX1FQtDGUPqSllYJYiWHRNCbtgmAq
xoW4wGjY6EYTDIaomEB8EhofmCCRBB8hkhgXutENG1y5cuXq9ztnZv6ZOXfu
hVsSm9t7z5n/vB/zn5mJmX1zz+2Z2Tc/O9M/ujDz/Nz87Av9I3sXsJS0KaUO
4X/XcgU4BcT/h9JLF/DA+y7hO8GjHGEE4JfAHMDXmaIsniT0lXe4UgVBsV8v
J/qH/nIWbUnONOP//Hn+l9Pf4aNy9JX8e/Fn83xlC/YRwU5+fG7x25cXPh4f
PaLye+eOq2R48F3gp45/05I8n2IHU8C42d0fQhQUFHkFwMFXPp/e/sH5r8+s
WKLsKaaAz4ffWIS5f/x4rp1X/vr1hxf3fATxeHR9lkmKc9H79SVts9EE37F3
vlRdjMPv+dljkKaWs5Q+w62psQ6fKOzdjEM9jCDqvoza1zFpuQxVj8WhA7zq
uijXhKeLuK4VUpYFlmlquO3LTC5e+B44vNPcdTq2Mq6zQ6B+jsQgGgT2RrnG
Sef7b31xA68jasgCgT1R6jHGfzt7FpYQuELorAV+jNl8GK9vFHgtqmOLkLlS
6OyOcj1hc42CIfBmxuEMXCKwGuUaZfzv33/aPX2UIttvIw8LEW+Pi/zROhBO
BJXAVcKyrqBK/d3A7hCyYkcYP/PZ6QMvfULgasbfPnjy0yNfEdjJvMW6HirF
uszDh22k4Re8U2usX2hVwrVcuX/p1vTUXKEeZ++twp9rWrCf0CHbg4gorFVr
RcQ7GsgrpPEdQctDk6HBCVxrOwn5JfnN5PlyJL6Zcb3PEniHiEN7UAn2V0oZ
tFlBlqgf7hRZag+qT+uEAqgh8C7GF4+eevPVEwRWohW+SVTCOsbhPoJMYLkJ
l/NnnfC3HFjWbbJH3ZL38LLtLvhD0Zbvhi5D12PkcC+ZZ8WoXd0Cr4oe643m
DcWIkszs9p7XIhbZSqCdVzWIj7RD4j0Cz9u6RuAJLJlISTrWX/ArETHX3XJZ
G6QvVa/6/P3U771YzOptgNGeDSRT6pK4tE36X/Hk2N9EmR1Jp+sKK8DPmLZW
+pOIiq8086GY4VnZFqJ2VBt4UBCd0hGxPxfUPADdaCquaUDY/1AadlU+yMyA
0L8hDTs5iep4TOjYIHTEuR5Nwx3pEaErF+XamIa73EahS3PRRHSA30x9th61
R6Zqk7BKL78a1EjL3PHVilh1Tv3/tiwtFvi0uSgnutlp51sT6w7CdbobP0+j
+7cuSPWwyP2moHb9N/16UVuO0tufYet6IXHQ0Tnf9eZnOsfJjNJqsepBW5Vm
MtwcWKrPku698oCofEetSn6sXZXfL6p+KNorOSH3PoEPBVYlQua96aVgmhqO
6tBcbvK/h3H3vmjG5eKuJwQ3C49EufIiA3en4b4zEvhTFE/1fOSmS57e+Q3d
aN6Oz3FybnNe8ISv33VN51V5l1AUMbudcXf6uDq57r2p51fMiqhKyuiWFuQm
2bqrn9uE3Y3k2flaxrMk4qfnf3fmHGsir74uHF4WeVpt9Zhz2XiQeTtfSyk8
EXt7yi0iK+NBtbXb7jEdv0rEfmu0ojWXPHe6s/tElKtDWHZTqk/hk02onWX6
RIwjDQ42BE4GfnSK2OkzujsBPBnV0WkskCf6OLW+WXHnKr5Z8fp6W2BR1Vat
uYeRNxNTUR0ZF+JPXi+zOCJN+PYol3+LQ1S9At8R5apZi2AhxagmuJ4K/Mlk
mhxrS7EvmfuZnVl1Nrp3lPXf6/lKN1d8bs5DFnzFZodyepplVgRf/TQhe4Dv
isztGoQjq2W7gnShJFC6zyxRNt9LdWLPR7lAEjQggmhPLGMR8YD1UxPv4XxK
Md3VghYi4JqqQBwCgkKBgscHDiPCiAdspjg/u0S7918Vn9117C3ka7xaf++s
2v4DYKyaaw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->780903143]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightOrange"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->363089124],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 0.9, 0.8]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->292889157]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light orange can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightOrange", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.9, 0.8], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->26334480,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightOrange", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.9, 0.8], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->198934854,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Orange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Orange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->82035931]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightOrange - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 19.7499334}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LightOrange represents a light orange color in graphics or style \
specifications.", "synonyms" -> {"light orange"}, "title" -> "LightOrange", 
    "type" -> "Symbol", "uri" -> "ref/LightOrange"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5261, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->140536622]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37040, 848}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1657, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2280, 63, 1576, 37, 70, "ObjectNameGrid"],
Cell[3859, 102, 464, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4360, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4838, 138, 386, 14, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5261, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140536622],
Cell[CellGroupData[{
Cell[5646, 171, 148, 5, 70, "ExampleSection",
 CellID->377517920],
Cell[CellGroupData[{
Cell[5819, 180, 240, 7, 28, "Input",
 CellID->511908593],
Cell[6062, 189, 293, 9, 121, "Output",
 CellID->431635470]
}, Open  ]],
Cell[CellGroupData[{
Cell[6392, 203, 294, 9, 28, "Input",
 CellID->310096450],
Cell[6689, 214, 2228, 41, 110, "Output",
 Evaluatable->False,
 CellID->780903143]
}, Open  ]],
Cell[CellGroupData[{
Cell[8954, 260, 373, 12, 70, "Input",
 CellID->363089124],
Cell[9330, 274, 356, 13, 56, "Output",
 CellID->292889157]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9735, 293, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[9969, 302, 117, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[10111, 309, 193, 6, 70, "Input",
 CellID->165065652],
Cell[10307, 317, 13965, 234, 129, 90, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->26334480]
}, Open  ]],
Cell[24287, 554, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24398, 559, 270, 8, 70, "Input",
 CellID->280509553],
Cell[24671, 569, 8788, 150, 129, 113, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->198934854]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33520, 726, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[33839, 737, 1660, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[35536, 804, 299, 8, 70, "MoreAboutSection"],
Cell[35838, 814, 123, 3, 70, "MoreAbout",
 CellID->82035931]
}, Open  ]],
Cell[35976, 820, 27, 0, 70, "History"],
Cell[36006, 822, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

