(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37370,        904]
NotebookOptionsPosition[     34093,        794]
NotebookOutlinePosition[     35350,        830]
CellTagsIndexPosition[     35265,        825]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pink" :> Documentation`HelpLookup["paclet:ref/Pink"], 
          "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Pink\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LightPink", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LightPink",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LightPink"]], "InlineFormula"],
     " \[LineSeparator]represents a light pink color in graphics or style \
specifications."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LightPink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LightPink"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"], "[", 
   RowBox[{
    ButtonBox["Pink",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Pink"], ",", "0.85"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6391876],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->318307128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightPink", ",", 
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.925, 0.925], EdgeForm[GrayLevel[0]], 
   DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1761122]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightPink"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310096450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WFtonEUUnuy/18Rks4k11VpNbbXe6g1ttRqkaZK2SRMbY22LKIQoNA8S
qfFBLEihIgjig1iogkWwIlXEIkVUlEIp4gW84AVRkYAQkPjkk0+/3zkz88/M
2dltNwXDZvec+c/9Mv+ZGZ+e3//Y49PzszPT/dsOTD+xf3bmyf6RuQNYStqU
Ukfwv2+lApwC4v8j6dISHnjfJXwneJQjjAD8EpgD+BxTlMWThL7yDleqICgO
6uVE/9BfzqItydnD+D8Li9+c/hkflaOv5N/Fv8zz1S3YRwS7+fGZU98/M//B
2PbXVX5u9j2VDA++BvzDE1+3JM+nmGIKGDfzyNsQBQVFXgHw/LMf7Zl684uP
f1i1TNmTTAGfj750Gub++tXv7byy+NPCU3MnIR6PLs0ySXEuer++pF02muA7
/upZ1cU4/J599F1IUytZSp/h1tRYh08U9m7GoR5GEHVfRu3rmLBchqrH4tAB
XnVJlGvc00VcFwspKwLLNDXc9mUmC9/9ARzeae46HTsZ19khUD9HYhANAnuj
XGOk89grZy7jdUQNWSCwJ0o9yviPZ3+BJQSuEjprgR+jNh/G68sFXovq2CFk
rhY6u6Nc222uUTAEXsk4nIFLBFajXNsY//u3Px/e+xZFtt9GHhYi3h4X+aN1
IJwIKoFrhGVdQZX6u4HdIWTFjjD+6fvfHnr6FIFrGX/5hc/eOfY5gZ3MW6zr
oVKsyzx82EYafsE7tc76hVYlXMuV+5duTU/Neepx9l4t/LmoBfsJHbI9iIjC
WrVeRLyjgbxCGt8RtDw0GRqcwPW2k5Bfkt9Mni9H4lsZ1/ssgdeJOLQHlWB/
pZRBmxVkifrhepGl9qD6tE4ogBoCb2D85PEvXzz8CYGVaIVvEZWwgXG4jyAT
WG7C5fzZIPwtB5Z1m+xRt+Q9vGy7C/5QtOW7ocvQ9Rg53EvmWTFqV7fAq6LH
eqN5QzGiJDO7vee1iEW2EmjnVQ3iI+2QeI/A87auEXgCSyZSko71F/xKRMx1
t5zTBulL1as+fz/1ey8Ws3obYLRnA8mUuiQubZP+Vzw59jdRZkfS6TrPCvAz
pq2V/iSi4ivNfChmeFa2hagd1QYeFESndETszwU1D0A3moprGhD235GGXZUP
MjMg9G9Kw05OojruETo2CR1xrrvTcEe6S+jKRbk2p+Eut1no0lw0ER3iN1Of
rUftkanaJKzSc68GNdIyd3y1IladU/+/LcuLBT5tLsqJbnba+dbFuoNwne7G
z9Po/q0LUt0pcr8lqF3/Tb9R1Jaj9PZn2LpRSBx0dM53vfmZznEyo7RarLrd
VqWZDLcGluqzpHuv3CYq31Grkh9rV+W3iqofivZKTsi9ReBDgVWJkHlzuhRM
U8NRHZrLTf43Me7eF824XNz1hOBm4ZEoV15k4MY03HdGAn+K4qmej9x0ydM7
v6EbzdvxOU7Obc4LnvD1u67pvCrvEooiZtcy7k4fFybXvTf1/IpZEVVJGd3R
gtwkW3f1c42wu5E8O1/LeJZE/PT8786co03k1deFw8siT2utHnMuGwsyb+dr
KYUnYm9PuUpkZSyotnbbPabj14jY74xWtOaS5053dh+PcnUIy65I9Sl8ogm1
s0yfiHGkwcGGwInAj04RO31GdyeA+6I6Oo0F8kQfp9Y3K+5cxTcrXl/vCiyq
2qo19zDyZmIyqiPjQvzJ6xUWR6QJvz/K5d/iEFWvwKeiXDVrESykGNUE1wOB
P5lMk2NtKfYlcz+zO6vORveOsv57PV/p5orPzXnIgq/Y7FBOD7LMiuCrnyZk
D/Bdkbldg3BktWxXkC6UBEp37zJl871UJ/Z8lAskQQMiiPbEMhYRD1g/Of4G
zqcU030taCECrqkKxCEgKBQouHfgKCKMeMBmivNDy7T74AXx2V3H3kIe5tX6
e2fV9h/mgTDK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->400859384]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightPink"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->61283112],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 0.925, 0.925]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{37, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->961421776]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Light pink can be affected by the colors of light sources in 3D:\
\>", "ExampleText",
 CellID->116670670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"LightPink", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165065652],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.925, 0.925], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->49085823,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Neutral lighting can be used to avoid this:", "ExampleText",
 CellID->278547368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightPink", ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280509553],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.925, 0.925], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->121132424,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->459419212]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightPink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 20.2343208}", "context" -> "System`", 
    "keywords" -> {"color", "pink", "light pink", "background"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LightPink represents a light pink color in graphics or style \
specifications.", "synonyms" -> {"light pink"}, "title" -> "LightPink", 
    "type" -> "Symbol", "uri" -> "ref/LightPink"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5308, 160, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6391876]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35124, 818}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1651, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2274, 63, 1574, 37, 70, "ObjectNameGrid"],
Cell[3851, 102, 458, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4346, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4824, 138, 447, 17, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[5308, 160, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6391876],
Cell[CellGroupData[{
Cell[5691, 174, 148, 5, 70, "ExampleSection",
 CellID->318307128],
Cell[CellGroupData[{
Cell[5864, 183, 238, 7, 28, "Input",
 CellID->511908593],
Cell[6105, 192, 297, 9, 121, "Output",
 CellID->1761122]
}, Open  ]],
Cell[CellGroupData[{
Cell[6439, 206, 292, 9, 28, "Input",
 CellID->310096450],
Cell[6734, 217, 2228, 41, 110, "Output",
 Evaluatable->False,
 CellID->400859384]
}, Open  ]],
Cell[CellGroupData[{
Cell[8999, 263, 370, 12, 70, "Input",
 CellID->61283112],
Cell[9372, 277, 360, 13, 56, "Output",
 CellID->961421776]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9781, 296, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[10015, 305, 115, 3, 70, "ExampleText",
 CellID->116670670],
Cell[CellGroupData[{
Cell[10155, 312, 191, 6, 70, "Input",
 CellID->165065652],
Cell[10349, 320, 13550, 227, 129, 94, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->49085823]
}, Open  ]],
Cell[23914, 550, 86, 1, 70, "ExampleText",
 CellID->278547368],
Cell[CellGroupData[{
Cell[24025, 555, 268, 8, 70, "Input",
 CellID->280509553],
Cell[24296, 565, 7226, 124, 129, 117, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->121132424]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31583, 696, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[31902, 707, 1656, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[33595, 774, 299, 8, 70, "MoreAboutSection"],
Cell[33897, 784, 124, 3, 70, "MoreAbout",
 CellID->459419212]
}, Open  ]],
Cell[34036, 790, 27, 0, 70, "History"],
Cell[34066, 792, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

