(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    111774,       3563]
NotebookOptionsPosition[     95430,       2963]
NotebookOutlinePosition[     96765,       3001]
CellTagsIndexPosition[     96679,       2996]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematics-BasicOperations"], "Limits" :> 
          Documentation`HelpLookup["paclet:tutorial/Limits"], 
          "Finding Limits" :> 
          Documentation`HelpLookup["paclet:tutorial/FindingLimits"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics: Basic Operations\"\>", 
       2->"\<\"Limits\"\>", 3->"\<\"Finding Limits\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series" :> Documentation`HelpLookup["paclet:ref/Series"], 
          "Residue" :> Documentation`HelpLookup["paclet:ref/Residue"], 
          "Derivative" :> Documentation`HelpLookup["paclet:ref/Derivative"], 
          "Assumptions" :> Documentation`HelpLookup["paclet:ref/Assumptions"],
           "DiracDelta" :> Documentation`HelpLookup["paclet:ref/DiracDelta"], 
          "PrincipalValue" :> 
          Documentation`HelpLookup["paclet:ref/PrincipalValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Series\"\>", 2->"\<\"Residue\"\>", 
       3->"\<\"Derivative\"\>", 4->"\<\"Assumptions\"\>", 
       5->"\<\"DiracDelta\"\>", 
       6->"\<\"PrincipalValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:guide/Calculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Limit", "ObjectName",
 CellID->14751],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Limit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Limit"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["x", "TI"], "->", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["0", "TR"]]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the limiting value of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " when ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " approaches ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9706]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["0", "TR"]]}], ",", 
    RowBox[{
     ButtonBox["Direction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Direction"], "->", "1"}]}], "]"}]], 
  "InlineFormula"],
 " computes the limit as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " approaches ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " from smaller values. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["0", "TR"]]}], ",", 
    RowBox[{
     ButtonBox["Direction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Direction"], "->", 
     RowBox[{"-", "1"}]}]}], "]"}]], "InlineFormula"],
 " computes the limit as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " approaches ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " from larger values. "
}], "Notes",
 CellID->12247],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 " objects to represent ranges of possible values, for example at essential \
singularities. "
}], "Notes",
 CellID->9297],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " returns unevaluated when it encounters functions about which it has no \
specific information. ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " therefore by default makes no explicit assumptions about symbolic \
functions. "
}], "Notes",
 CellID->21522],

Cell[TextData[{
 "Assumptions can be specified as a setting for the option ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4465],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["0", "TR"]]}]}], "]"}]], "InlineFormula"],
 " uses the setting ",
 Cell[BoxData[
  RowBox[{"Direction", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", which determines the direction from assumptions that have been given, \
using ",
 Cell[BoxData[
  RowBox[{"Direction", "->", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 " as the default. For limit points at infinity, the direction is determined \
from the direction of the infinity."
}], "Notes",
 CellID->271203821]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49929075],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->304063833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", "x"}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31773],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140554152]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", "/", "n"}]}], ")"}], "^", "n"}], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104729425],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "x"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96379815]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13824],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->167955079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"x", "\[Rule]", 
     SubscriptBox["x", "0"]}]}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23269876],

Cell[BoxData[
 FormBox[
  RowBox[{
   UnderscriptBox["lim", 
    RowBox[{"x", "\[Rule]", 
     SubscriptBox["x", "0"]}]], "\[ThinSpace]", 
   RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]], "Output",
 ImageSize->{50, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->53350392]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->254266467],

Cell["Limits of rational functions:", "ExampleText",
 CellID->499386752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", "x"}], "-", "8"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "-", "4"}], ")"}]}], ",", 
   RowBox[{"x", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170961846],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218970021]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"x", "-", "4"}], ")"}]}], ",", 
   RowBox[{"x", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39022342],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->401855]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"y", "-", "x"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->348553144],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->224731150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63955993],

Cell["Algebraic functions:", "ExampleText",
 CellID->418224840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "3"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", "x", "]"}], "-", "3"}], ")"}]}], ",", 
   RowBox[{"x", "\[Rule]", "9"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54245871],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281814950]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "-", "1"}], "]"}], "/", "x"}], ",", 
   RowBox[{"x", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->729382690],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132683831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133354727],

Cell["Piecewise functions:", "ExampleText",
 CellID->22372838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"45", ",", 
        RowBox[{"x", "==", "2"}]}], "}"}], "}"}], ",", 
     RowBox[{
      RowBox[{"3", "x"}], "-", "1"}]}], "]"}], ",", 
   RowBox[{"x", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118573047],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38483126]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"x", "^", "2"}], "]"}], "x"}], ",", 
   RowBox[{"x", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49408279],

Cell[BoxData["64"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40147555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"x", "^", "2"}], "]"}], "x"}], ",", 
   RowBox[{"x", "\[Rule]", "4"}], ",", 
   RowBox[{"Direction", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->290698066],

Cell[BoxData["60"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->108764210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12676681],

Cell["Elementary functions:", "ExampleText",
 CellID->619394011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"2", "x"}], "]"}], "/", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469911886],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24492783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "^", "2"}], "]"}]}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40534493],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->717759936]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"1", "/", "x"}], "-", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", "x"}], "]"}]}], "]"}], "-", 
      RowBox[{"Exp", "[", 
       RowBox[{"1", "/", "x"}], "]"}]}], ")"}]}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->61648180],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->551301263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"n", "!"}], "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "n"}], ")"}]}], "/", "n"}], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->644763310],

Cell[BoxData[
 FractionBox["1", "\[ExponentialE]"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->88742804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173120516],

Cell["Special functions:", "ExampleText",
 CellID->411629457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"x", "+", 
       RowBox[{"1", "/", "2"}]}], "]"}], "/", 
     RowBox[{"Gamma", "[", "x", "]"}]}], "/", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36332553],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89240426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselI", "[", 
     RowBox[{"1", ",", 
      RowBox[{"3", "x"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"BesselI", "[", 
        RowBox[{"1", ",", "x"}], "]"}], "^", "3"}]}], ")"}]}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->323777200],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->228703974]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Fibonacci", "[", 
     RowBox[{"k", "+", "1"}], "]"}], "/", 
    RowBox[{"Fibonacci", "[", "k", "]"}]}], ",", 
   RowBox[{"k", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->217559737],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", 
   SqrtBox["5"]}], 
  RowBox[{"1", "+", 
   SqrtBox["5"]}]]], "Output",
 ImageSize->{52, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->115440551]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", "-", "GoldenRatio"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->225537360],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->221846307]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23556],

Cell["\<\
Find a limit of a bounded oscillating function at essential singularity:\
\>", "ExampleText",
 CellID->69497671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115505675],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14103052]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18341],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Analytic",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15146],

Cell["Default settings assume generic functions are not analytic:", \
"ExampleText",
 CellID->898892060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "x0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306549608],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "x0"}]}], "]"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->896750302]
}, Open  ]],

Cell["Assume analyticity:", "ExampleText",
 CellID->395380111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "x0"}], ",", 
   RowBox[{"Analytic", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->293177578],

Cell[BoxData[
 RowBox[{"f", "[", "x0", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->483850193]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3857],

Cell["\<\
The limit may not exist or be different for different parameter values:\
\>", "ExampleText",
 CellID->84202386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", "^", "a"}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", "<", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91114993],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33542382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", "^", "a"}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", "\[Equal]", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55019752],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16694947]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", "^", "a"}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->509068381],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->633165565]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132001590],

Cell["Parameter\[Hyphen]dependent limit:", "ExampleText",
 CellID->450821277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "x"}], "/", 
    RowBox[{"x", "^", "a"}]}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->899800330],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253482533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "x"}], "/", 
    RowBox[{"x", "^", "a"}]}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"0", "<", "a", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58750394],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2079123]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Direction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21225],

Cell["Limits from the left and right:", "ExampleText",
 CellID->495846997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "\[Rule]", "0"}], ",", 
   RowBox[{"Direction", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52153848],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->606465199]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "\[Rule]", "0"}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58998040],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->545747238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204154322],

Cell["Limits at piecewise discontinuities:", "ExampleText",
 CellID->33093036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{"x", "^", "2"}], "]"}], 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"x", "\[Rule]", "2"}], ",", 
   RowBox[{"Direction", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213440380],

Cell[BoxData[
 RowBox[{"Sin", "[", "2", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72587540]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{"x", "^", "2"}], "]"}], 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"x", "\[Rule]", "2"}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->536258857],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4553312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{"x", "^", "2"}], "]"}], 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->253638],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->73882413]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27483774],

Cell["Limits at a pole:", "ExampleText",
 CellID->75714515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Pi", "/", "2"}]}], ",", 
   RowBox[{"Direction", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->893528557],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257939351]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Pi", "/", "2"}]}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->316315891],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->244225502]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145914665],

Cell["Limits at a branch cut:", "ExampleText",
 CellID->137059849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", 
    RowBox[{"2", "+", "x"}], "]"}], ",", 
   RowBox[{"x", "\[Rule]", "0"}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    RowBox[{"+", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91348169],

Cell[BoxData[
 RowBox[{"EllipticK", "[", "2", "]"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468373051]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", 
    RowBox[{"2", "+", "x"}], "]"}], ",", 
   RowBox[{"x", "\[Rule]", "0"}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    RowBox[{"-", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69622038],

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticK", "[", "2", "]"}], "+", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["5", "4"], "]"}]}], 
   RowBox[{"Gamma", "[", 
    FractionBox["3", "4"], "]"}]]}]], "Output",
 ImageSize->{213, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->131916354]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10216],

Cell["Find a linear asymptote:", "ExampleText",
 CellID->185696957],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "3"}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "x"}], "+", "1"}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->583272321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "/", "x"}], ",", 
    RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->712168362],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52838023]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "-", 
     RowBox[{"a", " ", "x"}]}], ",", 
    RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->522775589],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", "4"]}]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25016911]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", "b"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26653538],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->53086909]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227248905],

Cell["Riemann sums:", "ExampleText",
 CellID->148346480],

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannSum", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "a_", ",", "b_"}], "}"}], ",", "n_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"(", 
       RowBox[{"f", "/.", 
        RowBox[{"x", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"b", "-", "a"}], ")"}], 
            RowBox[{"k", "/", "n"}]}]}], ")"}]}]}], ")"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "-", "a"}], ")"}], "/", "n"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279904914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSum", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->867423956],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "n"}]}], ")"}]}], 
  RowBox[{"3", " ", 
   SuperscriptBox["n", "2"]}]]], "Output",
 ImageSize->{128, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->519855343]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"%", ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->576203928],

Cell[BoxData[
 FractionBox["8", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36537986]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->308178466],

Cell[BoxData[
 FractionBox["8", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->253478883]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSum", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"a", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->472902089],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", "a"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", "a"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[ExponentialE]", "a"]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "/", "n"}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "/", "n"}]]}], ")"}], " ", "n"}]]], "Output",
 ImageSize->{142, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->25192005]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"%", ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->171553322],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "a"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "a"}]]}], ")"}]}], "a"]], "Output",
 ImageSize->{85, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->528012736]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"a", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->270217325],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "a"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "a"}]]}], ")"}]}], "a"]], "Output",
 ImageSize->{85, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->100494896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157465257],

Cell["Improper integrals:", "ExampleText",
 CellID->415462601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "a"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17055948],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", "a"}], "a"]], "Output",
 ImageSize->{43, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->612702488]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"%", ",", 
   RowBox[{"a", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->97236815],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->539571493]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->472849917],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->46465902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18841528],

Cell["\<\
Check the asymptotic complexity of the fast Fourier transform:\
\>", "ExampleText",
 CellID->264867174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "k", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"f", "[", 
         RowBox[{"k", "/", "2"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"3", "/", "2"}], "k"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"f", "[", "k", "]"}], ",", "k"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567168591],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "k", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "k", " ", 
       RowBox[{"Log", "[", "2", "]"}]}], "+", 
      RowBox[{"3", " ", "k", " ", 
       RowBox[{"Log", "[", "k", "]"}]}]}], 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{217, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110639331]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f", "[", "k", "]"}], "/.", 
       RowBox[{"First", "[", "%", "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"k", " ", 
       RowBox[{"Log", "[", "k", "]"}]}], ")"}]}], ",", 
    RowBox[{"k", "\[Rule]", "Infinity"}]}], "]"}], 
  RowBox[{"(", 
   RowBox[{"k", " ", 
    RowBox[{"Log", "[", "k", "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->677330303],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", "k", " ", 
   RowBox[{"Log", "[", "k", "]"}]}], 
  RowBox[{"Log", "[", "4", "]"}]]], "Output",
 ImageSize->{71, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23044036]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15495],

Cell["\<\
Construct a rotation matrix as a limit of repeated infinitesimal \
transformations:\
\>", "ExampleText",
 CellID->30924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPower", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"\[Theta]", "/", "n"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Theta]"}], "/", "n"}], ",", "1"}], "}"}]}], "}"}], 
   ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24607],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81SE0EQ3vysoKIYAwloFYSIVrQELxw968mHSFFWwcHSQh5Dn4nH4hi3
Z3eS9Usn3ds72eWPKkhmp6f/pqdntufj2/jy7PuP8eX56Xjw9WL86+z89Pfg
y8+L5FGrEUWNP1EUfd6Jku+T5Jv7pZ+/yW/6Nf22k/yNk84PyWcr+Yza7nH2
c7S092PWu8f2Hi/tPZpKj2Kv2yQj6NFna/o0eslSdYEqJK8+S/UUqDos1ZZK
Lxsvp1e0C0/Rxq5er9Jc+tBGu3h/bwu62Lg4C9zYZvLwGfQitc4+9LWNC9r3
xGQf6mLjsp75J859RnO8nkMbLepmo5ucDrn2q0B80PbHDD3HB1c26mPlg/5q
Q7vJenVTsNJ7I2plk8dkMLTAwgO9ubbAC3keuNJRDwsP9L7Oiy47iGvuGNo9
06htdhTqrZMljbJ5Y2OS7q+4zpF7X0nXy+hQziJ+Ep3NqkOB66eCUjHykF6S
V58VtIZw/6hGe/LZWtJ8JHDfgHZXOQ7lYZaS5EiRrLMaqfJ5jVbtegmtNOPJ
C00mN5a1XtqhGk4/1I6oYp+0W1dXV1nmbrtMnrQzuliwEscP3fjRaHR9fT3r
/1/beBoz1cndKiCvKrsscvDETPOYvAa6WU5nuu44f1OCP0evi2+kyp98bqPV
9kweK7QdKukkq27mblqP1tI5GaW8LUj/MBd6rSlLUnzjqZ+yacul5clkVqOi
d+C17CHla5yJXiFueBqKBe7bGXe0tJyuOm5FdbXNBlZo0I+Oy9xbVCdHRW3c
OfHNHXXBs7ROKlqcb1u0UL0Jr9x2ndTQtlcZLaRbDDZUFzWhpNuiZVW2Vytd
Fy3aqm+L1VVaV3jaRp2bE75q+MKkTdH1ZtUOq5G44ur1lU6blfqqPeOD9XI8
1XEzK/ncc/U765ye7Vk7mqvzaiWiBzgP6TToAAU3Q6u1WSsxnM2bqtn2UZOv
dVM8x4YILD7zq5UuzXq1tlcrnZ99rFMecHzZ/ZCY401SOW7oH6wDldOtHDeX
0V3FhWboBMY+yqgGQv9+1v9eGL+of89pQY8Q+zD7RjFuRTJ4FIQFQXEylW5F
COCM7QbkxaMg6kdn7LvnUuTzvKT7fRsXPJ/XichI453CLH/Lj2/0OuwA8sZM
aOOCdtaJzPBoCPd8bofA84FU91iEHsBYfR2ID/qgbpQGxkNH5VWsNmuQBLg2
0KMWHujNutAZGA06L/Jv4cjrCNp8jpdG8aiI1SAwbN6gvEdNjEi0ZEdJ51ER
oVAWNqswmlBLvDvAfpQ6FLQsirJgbyUrsYrWlHSnYLGG+G4EsUKqTCE9RiSt
Ew2qYqikk+pqTr5YncOzWQirEQ1BWUK6kTwsSL+okpBGrM/O9BffItN2uJt8
9LC/owqNGEA5RZAPnEdvC8IDT/TpO33VcZ3PTVXEc/ruXXXOWrWV9eyaVPUI
iZ6oxwrUouzuWI3WiAMIjZ64T3PhsX06DACt/WV3/v1C3PA00ha4e/TDbUBq
2GYDpehuVfO3ZNQuepsq/R+FDgGQ192iBdbL7hPyo8po8XfwZefLFjWhpNui
5W4gP/hoKVrd5e/OpVxivcnX3BOXzzGhUA8PCJFlqIe0Li7999uie/j8fxF6
vXT37laJaDkXRTa0w31AePRVs83duZPVYe7c65UuzfpdRnrws4/1kwHHdyEG
AHfLctzQPzcJieHOCdN7phGM9WiEA6F/f1IOLfHOaUGPUmRD1PgHTHSmgw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{396, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352701204]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"n", "->", "Infinity"}]}], "]"}], "//", "FullSimplify"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->13429],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->71494979]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30220],

Cell["Difference quotients:", "ExampleText",
 CellID->443223937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", "+", "h"}], "]"}], "-", 
      RowBox[{"f", "[", "x", "]"}]}], ")"}], "/", "h"}], ",", 
   RowBox[{"h", "->", "0"}], ",", 
   RowBox[{"Analytic", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27079],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", "\[Prime]",
   MultilineFunction->None], "[", "x", "]"}]], "Output",
 ImageSize->{36, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131157934]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", "+", 
        RowBox[{"2", "h"}]}], "]"}], "-", 
      RowBox[{"2", 
       RowBox[{"f", "[", 
        RowBox[{"x", "+", "h"}], "]"}]}], "+", 
      RowBox[{"f", "[", "x", "]"}]}], ")"}], "/", 
    RowBox[{"h", "^", "2"}]}], ",", 
   RowBox[{"h", "\[Rule]", "0"}], ",", 
   RowBox[{"Analytic", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->220193251],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", "\[Prime]\[Prime]",
   MultilineFunction->None], "[", "x", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29240173]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"f", "[", 
        RowBox[{"x", "+", "h"}], "]"}]}], "-", 
      RowBox[{"1", "/", 
       RowBox[{"f", "[", "x", "]"}]}]}], ")"}], "/", "h"}], ",", 
   RowBox[{"h", "\[Rule]", "0"}], ",", 
   RowBox[{"Analytic", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95050233],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], 
   SuperscriptBox[
    RowBox[{"f", "[", "x", "]"}], "2"]]}]], "Output",
 ImageSize->{50, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->56799937]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->636968464],

Cell[TextData[{
 "The ",
 ButtonBox["''squeezing theorem''",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/SqueezingTheorem.html"], None}],
 ":"
}], "ExampleText",
 CellID->691014964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"1", "/", "x"}], "]"}]}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->530931797],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56848007]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"1", "/", "x"}], "]"}]}], ",", 
     RowBox[{"Abs", "[", "x", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Abs", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->207456195],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166665964]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22959],

Cell["The limits along coordinate axes are zero:", "ExampleText",
 CellID->301879707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", " ", "y"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->993552162],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344060161]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", " ", "y"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"y", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79991701],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49110708]
}, Open  ]],

Cell["The limit along the diagonal:", "ExampleText",
 CellID->145157183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", " ", "y"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}], "/.", 
    RowBox[{"x", "\[Rule]", "y"}]}], ",", 
   RowBox[{"y", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->570438699],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->304398386]
}, Open  ]],

Cell["Behavior around the origin:", "ExampleText",
 CellID->229151838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", " ", "y"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "  ", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ">", "0.03"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->475469606],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->59744017]
}, Open  ]],

Cell["Many different values can be achieved:", "ExampleText",
 CellID->389506392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", " ", "y"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}], "/.", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"t", " ", "y"}]}]}], ",", 
   RowBox[{"y", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->33925419],

Cell[BoxData[
 FractionBox["t", 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->261401862]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24448],

Cell["Differentiation by integration:", "ExampleText",
 CellID->290282119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", "=", "5"}], "}"}], ",", 
     RowBox[{
      RowBox[{"1", "/", "2"}], " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}], "!!"}], "/", 
       RowBox[{"h", "^", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], " ", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"LegendreP", "[", 
          RowBox[{"n", ",", 
           RowBox[{"t", "/", "h"}]}], "]"}], " ", 
         RowBox[{"f", "[", 
          RowBox[{"x", "+", "t"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"-", "h"}], ",", "h"}], "}"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"h", "\[Rule]", "0"}], ",", 
   RowBox[{"Analytic", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->737204760],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", "5", ")"}],
    Derivative],
   MultilineFunction->None], "[", "x", "]"}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316346404]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7687],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Residue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Residue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiracDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiracDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrincipalValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrincipalValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12974]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22239],

Cell[TextData[ButtonBox["Symbolic Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematics-BasicOperations"]], "Tutorials",
 CellID->82228336],

Cell[TextData[ButtonBox["Limits",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Limits"]], "Tutorials",
 CellID->9128],

Cell[TextData[ButtonBox["Finding Limits",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingLimits"]], "Tutorials",
 CellID->25859]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->117405102],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->212882812]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Limit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 22.5000038}", "context" -> "System`", 
    "keywords" -> {
     "asymptotic value", "behavior of function", "directed limit", 
      "epsilon-delta", "lim", "limiting value", "value at discontinuity"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Limit[expr, x -> x_0] finds the limiting value of expr when x approaches \
x_0. ", "synonyms" -> {}, "title" -> "Limit", "type" -> "Symbol", "uri" -> 
    "ref/Limit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8004, 272, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->49929075]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 96537, 2989}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2536, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3159, 86, 43, 1, 70, "ObjectName",
 CellID->14751],
Cell[3205, 89, 930, 32, 70, "Usage",
 CellID->9706]
}, Open  ]],
Cell[CellGroupData[{
Cell[4172, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4650, 143, 1402, 54, 70, "Notes",
 CellID->12247],
Cell[6055, 199, 384, 13, 70, "Notes",
 CellID->9297],
Cell[6442, 214, 455, 14, 70, "Notes",
 CellID->21522],
Cell[6900, 230, 236, 8, 70, "Notes",
 CellID->4465],
Cell[7139, 240, 828, 27, 70, "Notes",
 CellID->271203821]
}, Closed]],
Cell[CellGroupData[{
Cell[8004, 272, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49929075],
Cell[CellGroupData[{
Cell[8388, 286, 148, 5, 70, "ExampleSection",
 CellID->304063833],
Cell[CellGroupData[{
Cell[8561, 295, 201, 7, 28, "Input",
 CellID->31773],
Cell[8765, 304, 158, 5, 36, "Output",
 CellID->140554152]
}, Open  ]],
Cell[CellGroupData[{
Cell[8960, 314, 263, 9, 28, "Input",
 CellID->104729425],
Cell[9226, 325, 194, 6, 36, "Output",
 CellID->96379815]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9469, 337, 216, 7, 70, "ExampleSection",
 CellID->13824],
Cell[9688, 346, 203, 7, 70, "ExampleText",
 CellID->167955079],
Cell[CellGroupData[{
Cell[9916, 357, 248, 8, 70, "Input",
 CellID->23269876],
Cell[10167, 367, 348, 11, 62, "Output",
 CellID->53350392]
}, Open  ]],
Cell[10530, 381, 125, 3, 70, "ExampleDelimiter",
 CellID->254266467],
Cell[10658, 386, 72, 1, 70, "ExampleText",
 CellID->499386752],
Cell[CellGroupData[{
Cell[10755, 391, 339, 12, 70, "Input",
 CellID->170961846],
Cell[11097, 405, 158, 5, 36, "Output",
 CellID->218970021]
}, Open  ]],
Cell[CellGroupData[{
Cell[11292, 415, 228, 8, 70, "Input",
 CellID->39022342],
Cell[11523, 425, 165, 5, 36, "Output",
 CellID->401855]
}, Open  ]],
Cell[CellGroupData[{
Cell[11725, 435, 303, 10, 70, "Input",
 CellID->348553144],
Cell[12031, 447, 170, 5, 36, "Output",
 CellID->224731150]
}, Open  ]],
Cell[12216, 455, 124, 3, 70, "ExampleDelimiter",
 CellID->63955993],
Cell[12343, 460, 63, 1, 70, "ExampleText",
 CellID->418224840],
Cell[CellGroupData[{
Cell[12431, 465, 314, 11, 70, "Input",
 CellID->54245871],
Cell[12748, 478, 168, 5, 36, "Output",
 CellID->281814950]
}, Open  ]],
Cell[CellGroupData[{
Cell[12953, 488, 237, 8, 70, "Input",
 CellID->729382690],
Cell[13193, 498, 158, 5, 36, "Output",
 CellID->132683831]
}, Open  ]],
Cell[13366, 506, 125, 3, 70, "ExampleDelimiter",
 CellID->133354727],
Cell[13494, 511, 62, 1, 70, "ExampleText",
 CellID->22372838],
Cell[CellGroupData[{
Cell[13581, 516, 376, 13, 70, "Input",
 CellID->118573047],
Cell[13960, 531, 157, 5, 36, "Output",
 CellID->38483126]
}, Open  ]],
Cell[CellGroupData[{
Cell[14154, 541, 232, 8, 70, "Input",
 CellID->49408279],
Cell[14389, 551, 158, 5, 36, "Output",
 CellID->40147555]
}, Open  ]],
Cell[CellGroupData[{
Cell[14584, 561, 281, 9, 70, "Input",
 CellID->290698066],
Cell[14868, 572, 159, 5, 36, "Output",
 CellID->108764210]
}, Open  ]],
Cell[15042, 580, 124, 3, 70, "ExampleDelimiter",
 CellID->12676681],
Cell[15169, 585, 64, 1, 70, "ExampleText",
 CellID->619394011],
Cell[CellGroupData[{
Cell[15258, 590, 263, 9, 70, "Input",
 CellID->469911886],
Cell[15524, 601, 157, 5, 36, "Output",
 CellID->24492783]
}, Open  ]],
Cell[CellGroupData[{
Cell[15718, 611, 235, 8, 70, "Input",
 CellID->40534493],
Cell[15956, 621, 158, 5, 36, "Output",
 CellID->717759936]
}, Open  ]],
Cell[CellGroupData[{
Cell[16151, 631, 476, 16, 70, "Input",
 CellID->61648180],
Cell[16630, 649, 175, 6, 36, "Output",
 CellID->551301263]
}, Open  ]],
Cell[CellGroupData[{
Cell[16842, 660, 284, 10, 70, "Input",
 CellID->644763310],
Cell[17129, 672, 191, 6, 51, "Output",
 CellID->88742804]
}, Open  ]],
Cell[17335, 681, 125, 3, 70, "ExampleDelimiter",
 CellID->173120516],
Cell[17463, 686, 61, 1, 70, "ExampleText",
 CellID->411629457],
Cell[CellGroupData[{
Cell[17549, 691, 367, 12, 70, "Input",
 CellID->36332553],
Cell[17919, 705, 157, 5, 36, "Output",
 CellID->89240426]
}, Open  ]],
Cell[CellGroupData[{
Cell[18113, 715, 415, 14, 70, "Input",
 CellID->323777200],
Cell[18531, 731, 217, 8, 55, "Output",
 CellID->228703974]
}, Open  ]],
Cell[CellGroupData[{
Cell[18785, 744, 287, 9, 70, "Input",
 CellID->217559737],
Cell[19075, 755, 250, 10, 60, "Output",
 CellID->115440551]
}, Open  ]],
Cell[CellGroupData[{
Cell[19362, 770, 141, 4, 70, "Input",
 CellID->225537360],
Cell[19506, 776, 158, 5, 36, "Output",
 CellID->221846307]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19713, 787, 239, 7, 70, "ExampleSection",
 CellID->23556],
Cell[19955, 796, 122, 3, 70, "ExampleText",
 CellID->69497671],
Cell[CellGroupData[{
Cell[20102, 803, 192, 6, 70, "Input",
 CellID->115505675],
Cell[20297, 811, 259, 9, 36, "Output",
 CellID->14103052]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20605, 826, 218, 7, 70, "ExampleSection",
 CellID->18341],
Cell[CellGroupData[{
Cell[20848, 837, 225, 7, 70, "ExampleSubsection",
 CellID->15146],
Cell[21076, 846, 104, 2, 70, "ExampleText",
 CellID->898892060],
Cell[CellGroupData[{
Cell[21205, 852, 184, 6, 70, "Input",
 CellID->306549608],
Cell[21392, 860, 273, 9, 36, "Output",
 CellID->896750302]
}, Open  ]],
Cell[21680, 872, 62, 1, 70, "ExampleText",
 CellID->395380111],
Cell[CellGroupData[{
Cell[21767, 877, 234, 7, 70, "Input",
 CellID->293177578],
Cell[22004, 886, 186, 6, 36, "Output",
 CellID->483850193]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22239, 898, 227, 7, 70, "ExampleSubsection",
 CellID->3857],
Cell[22469, 907, 121, 3, 70, "ExampleText",
 CellID->84202386],
Cell[CellGroupData[{
Cell[22615, 914, 259, 8, 70, "Input",
 CellID->91114993],
Cell[22877, 924, 157, 5, 36, "Output",
 CellID->33542382]
}, Open  ]],
Cell[CellGroupData[{
Cell[23071, 934, 266, 8, 70, "Input",
 CellID->55019752],
Cell[23340, 944, 157, 5, 36, "Output",
 CellID->16694947]
}, Open  ]],
Cell[CellGroupData[{
Cell[23534, 954, 260, 8, 70, "Input",
 CellID->509068381],
Cell[23797, 964, 168, 5, 36, "Output",
 CellID->633165565]
}, Open  ]],
Cell[23980, 972, 125, 3, 70, "ExampleDelimiter",
 CellID->132001590],
Cell[24108, 977, 77, 1, 70, "ExampleText",
 CellID->450821277],
Cell[CellGroupData[{
Cell[24210, 982, 310, 10, 70, "Input",
 CellID->899800330],
Cell[24523, 994, 168, 5, 36, "Output",
 CellID->253482533]
}, Open  ]],
Cell[CellGroupData[{
Cell[24728, 1004, 319, 10, 70, "Input",
 CellID->58750394],
Cell[25050, 1016, 156, 5, 36, "Output",
 CellID->2079123]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25255, 1027, 226, 7, 70, "ExampleSubsection",
 CellID->21225],
Cell[25484, 1036, 74, 1, 70, "ExampleText",
 CellID->495846997],
Cell[CellGroupData[{
Cell[25583, 1041, 225, 7, 70, "Input",
 CellID->52153848],
Cell[25811, 1050, 185, 6, 36, "Output",
 CellID->606465199]
}, Open  ]],
Cell[CellGroupData[{
Cell[26033, 1061, 245, 8, 70, "Input",
 CellID->58998040],
Cell[26281, 1071, 168, 5, 36, "Output",
 CellID->545747238]
}, Open  ]],
Cell[26464, 1079, 125, 3, 70, "ExampleDelimiter",
 CellID->204154322],
Cell[26592, 1084, 78, 1, 70, "ExampleText",
 CellID->33093036],
Cell[CellGroupData[{
Cell[26695, 1089, 322, 10, 70, "Input",
 CellID->213440380],
Cell[27020, 1101, 186, 6, 36, "Output",
 CellID->72587540]
}, Open  ]],
Cell[CellGroupData[{
Cell[27243, 1112, 342, 11, 70, "Input",
 CellID->536258857],
Cell[27588, 1125, 156, 5, 36, "Output",
 CellID->4553312]
}, Open  ]],
Cell[CellGroupData[{
Cell[27781, 1135, 299, 10, 70, "Input",
 CellID->253638],
Cell[28083, 1147, 5368, 92, 70, "Output",
 Evaluatable->False,
 CellID->73882413]
}, Open  ]],
Cell[33466, 1242, 124, 3, 70, "ExampleDelimiter",
 CellID->27483774],
Cell[33593, 1247, 59, 1, 70, "ExampleText",
 CellID->75714515],
Cell[CellGroupData[{
Cell[33677, 1252, 259, 8, 70, "Input",
 CellID->893528557],
Cell[33939, 1262, 168, 5, 36, "Output",
 CellID->257939351]
}, Open  ]],
Cell[CellGroupData[{
Cell[34144, 1272, 279, 9, 70, "Input",
 CellID->316315891],
Cell[34426, 1283, 185, 6, 36, "Output",
 CellID->244225502]
}, Open  ]],
Cell[34626, 1292, 125, 3, 70, "ExampleDelimiter",
 CellID->145914665],
Cell[34754, 1297, 66, 1, 70, "ExampleText",
 CellID->137059849],
Cell[CellGroupData[{
Cell[34845, 1302, 283, 9, 70, "Input",
 CellID->91348169],
Cell[35131, 1313, 193, 6, 36, "Output",
 CellID->468373051]
}, Open  ]],
Cell[CellGroupData[{
Cell[35361, 1324, 283, 9, 70, "Input",
 CellID->69622038],
Cell[35647, 1335, 426, 14, 70, "Output",
 CellID->131916354]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[36134, 1356, 223, 7, 70, "ExampleSection",
 CellID->10216],
Cell[36360, 1365, 67, 1, 70, "ExampleText",
 CellID->185696957],
Cell[36430, 1368, 295, 11, 70, "Input",
 CellID->583272321],
Cell[CellGroupData[{
Cell[36750, 1383, 242, 8, 70, "Input",
 CellID->712168362],
Cell[36995, 1393, 177, 6, 51, "Output",
 CellID->52838023]
}, Open  ]],
Cell[CellGroupData[{
Cell[37209, 1404, 268, 9, 70, "Input",
 CellID->522775589],
Cell[37480, 1415, 195, 7, 51, "Output",
 CellID->25016911]
}, Open  ]],
Cell[CellGroupData[{
Cell[37712, 1427, 315, 11, 70, "Input",
 CellID->26653538],
Cell[38030, 1440, 3099, 55, 70, "Output",
 Evaluatable->False,
 CellID->53086909]
}, Open  ]],
Cell[41144, 1498, 125, 3, 70, "ExampleDelimiter",
 CellID->227248905],
Cell[41272, 1503, 56, 1, 70, "ExampleText",
 CellID->148346480],
Cell[41331, 1506, 818, 27, 70, "Input",
 CellID->279904914],
Cell[CellGroupData[{
Cell[42174, 1537, 222, 7, 70, "Input",
 CellID->867423956],
Cell[42399, 1546, 426, 16, 53, "Output",
 CellID->519855343]
}, Open  ]],
Cell[CellGroupData[{
Cell[42862, 1567, 161, 5, 70, "Input",
 CellID->576203928],
Cell[43026, 1574, 177, 6, 51, "Output",
 CellID->36537986]
}, Open  ]],
Cell[CellGroupData[{
Cell[43240, 1585, 211, 7, 70, "Input",
 CellID->308178466],
Cell[43454, 1594, 178, 6, 51, "Output",
 CellID->253478883]
}, Open  ]],
Cell[CellGroupData[{
Cell[43669, 1605, 254, 8, 70, "Input",
 CellID->472902089],
Cell[43926, 1615, 749, 25, 58, "Output",
 CellID->25192005]
}, Open  ]],
Cell[CellGroupData[{
Cell[44712, 1645, 161, 5, 70, "Input",
 CellID->171553322],
Cell[44876, 1652, 378, 13, 56, "Output",
 CellID->528012736]
}, Open  ]],
Cell[CellGroupData[{
Cell[45291, 1670, 243, 8, 70, "Input",
 CellID->270217325],
Cell[45537, 1680, 378, 13, 56, "Output",
 CellID->100494896]
}, Open  ]],
Cell[45930, 1696, 125, 3, 70, "ExampleDelimiter",
 CellID->157465257],
Cell[46058, 1701, 62, 1, 70, "ExampleText",
 CellID->415462601],
Cell[CellGroupData[{
Cell[46145, 1706, 310, 10, 70, "Input",
 CellID->17055948],
Cell[46458, 1718, 220, 8, 51, "Output",
 CellID->612702488]
}, Open  ]],
Cell[CellGroupData[{
Cell[46715, 1731, 160, 5, 70, "Input",
 CellID->97236815],
Cell[46878, 1738, 158, 5, 36, "Output",
 CellID->539571493]
}, Open  ]],
Cell[CellGroupData[{
Cell[47073, 1748, 243, 8, 70, "Input",
 CellID->472849917],
Cell[47319, 1758, 157, 5, 36, "Output",
 CellID->46465902]
}, Open  ]],
Cell[47491, 1766, 124, 3, 70, "ExampleDelimiter",
 CellID->18841528],
Cell[47618, 1771, 113, 3, 70, "ExampleText",
 CellID->264867174],
Cell[CellGroupData[{
Cell[47756, 1778, 514, 17, 70, "Input",
 CellID->567168591],
Cell[48273, 1797, 517, 17, 53, "Output",
 CellID->110639331]
}, Open  ]],
Cell[CellGroupData[{
Cell[48827, 1819, 497, 17, 70, "Input",
 CellID->677330303],
Cell[49327, 1838, 271, 9, 53, "Output",
 CellID->23044036]
}, Open  ]],
Cell[49613, 1850, 121, 3, 70, "ExampleDelimiter",
 CellID->15495],
Cell[49737, 1855, 130, 4, 70, "ExampleText",
 CellID->30924],
Cell[CellGroupData[{
Cell[49892, 1863, 379, 14, 70, "Input",
 CellID->24607],
Cell[50274, 1879, 1981, 37, 70, "Output",
 Evaluatable->False,
 CellID->352701204]
}, Open  ]],
Cell[CellGroupData[{
Cell[52292, 1921, 191, 7, 70, "Input",
 CellID->13429],
Cell[52486, 1930, 483, 16, 36, "Output",
 CellID->71494979]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53018, 1952, 233, 7, 70, "ExampleSection",
 CellID->30220],
Cell[53254, 1961, 64, 1, 70, "ExampleText",
 CellID->443223937],
Cell[CellGroupData[{
Cell[53343, 1966, 357, 12, 70, "Input",
 CellID->27079],
Cell[53703, 1980, 244, 8, 36, "Output",
 CellID->131157934]
}, Open  ]],
Cell[CellGroupData[{
Cell[53984, 1993, 514, 17, 70, "Input",
 CellID->220193251],
Cell[54501, 2012, 251, 8, 36, "Output",
 CellID->29240173]
}, Open  ]],
Cell[CellGroupData[{
Cell[54789, 2025, 427, 14, 70, "Input",
 CellID->95050233],
Cell[55219, 2041, 342, 12, 54, "Output",
 CellID->56799937]
}, Open  ]],
Cell[55576, 2056, 125, 3, 70, "ExampleDelimiter",
 CellID->636968464],
Cell[55704, 2061, 217, 8, 70, "ExampleText",
 CellID->691014964],
Cell[CellGroupData[{
Cell[55946, 2073, 236, 8, 70, "Input",
 CellID->530931797],
Cell[56185, 2083, 157, 5, 36, "Output",
 CellID->56848007]
}, Open  ]],
Cell[CellGroupData[{
Cell[56379, 2093, 438, 15, 70, "Input",
 CellID->207456195],
Cell[56820, 2110, 4844, 83, 70, "Output",
 Evaluatable->False,
 CellID->166665964]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61713, 2199, 226, 7, 70, "ExampleSection",
 CellID->22959],
Cell[61942, 2208, 85, 1, 70, "ExampleText",
 CellID->301879707],
Cell[CellGroupData[{
Cell[62052, 2213, 334, 12, 70, "Input",
 CellID->993552162],
Cell[62389, 2227, 158, 5, 36, "Output",
 CellID->344060161]
}, Open  ]],
Cell[CellGroupData[{
Cell[62584, 2237, 333, 12, 70, "Input",
 CellID->79991701],
Cell[62920, 2251, 157, 5, 36, "Output",
 CellID->49110708]
}, Open  ]],
Cell[63092, 2259, 72, 1, 70, "ExampleText",
 CellID->145157183],
Cell[CellGroupData[{
Cell[63189, 2264, 397, 14, 70, "Input",
 CellID->570438699],
Cell[63589, 2280, 178, 6, 51, "Output",
 CellID->304398386]
}, Open  ]],
Cell[63782, 2289, 70, 1, 70, "ExampleText",
 CellID->229151838],
Cell[CellGroupData[{
Cell[63877, 2294, 829, 27, 70, "Input",
 CellID->475469606],
Cell[64709, 2323, 25100, 416, 70, "Output",
 Evaluatable->False,
 CellID->59744017]
}, Open  ]],
Cell[89824, 2742, 81, 1, 70, "ExampleText",
 CellID->389506392],
Cell[CellGroupData[{
Cell[89930, 2747, 422, 15, 70, "Input",
 CellID->33925419],
Cell[90355, 2764, 226, 8, 51, "Output",
 CellID->261401862]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[90630, 2778, 224, 7, 70, "ExampleSection",
 CellID->24448],
Cell[90857, 2787, 74, 1, 70, "ExampleText",
 CellID->290282119],
Cell[CellGroupData[{
Cell[90956, 2792, 964, 31, 70, "Input",
 CellID->737204760],
Cell[91923, 2825, 290, 11, 36, "Output",
 CellID->316346404]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92274, 2843, 310, 9, 70, "SeeAlsoSection",
 CellID->7687],
Cell[92587, 2854, 1451, 53, 70, "SeeAlso",
 CellID->12974]
}, Open  ]],
Cell[CellGroupData[{
Cell[94075, 2912, 314, 9, 70, "TutorialsSection",
 CellID->22239],
Cell[94392, 2923, 190, 4, 70, "Tutorials",
 CellID->82228336],
Cell[94585, 2929, 122, 3, 70, "Tutorials",
 CellID->9128],
Cell[94710, 2934, 138, 3, 70, "Tutorials",
 CellID->25859]
}, Open  ]],
Cell[CellGroupData[{
Cell[94885, 2942, 319, 9, 70, "MoreAboutSection",
 CellID->117405102],
Cell[95207, 2953, 128, 3, 70, "MoreAbout",
 CellID->212882812]
}, Open  ]],
Cell[95350, 2959, 50, 0, 70, "History"],
Cell[95403, 2961, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

