(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15704,        558]
NotebookOptionsPosition[     12273,        447]
NotebookOutlinePosition[     13780,        487]
CellTagsIndexPosition[     13695,        482]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ScriptSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ScriptSizeMultipliers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"ScriptSizeMultipliers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Math Typesetting Options & Tweaking\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LimitsPositioning", "ObjectName",
 CellID->7300],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LimitsPositioning",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LimitsPositioning"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["UnderoverscriptBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/UnderoverscriptBox"]], "InlineFormula"],
     " and related boxes which specifies whether to change the positioning of \
underscripts and overscripts in the way conventional for limits. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12238]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderoverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderoverscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"], ",", 
    RowBox[{"LimitsPositioning", "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}]}], "]"}]], "InlineFormula"],
 " is always displayed with explicit underscripts and overscripts, as ",
 Cell[BoxData[
  UnderoverscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["y", "TI"], 
   StyleBox["z", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17726],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderoverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderoverscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"], ",", 
    RowBox[{"LimitsPositioning", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " is displayed as ",
 Cell[BoxData[
  UnderoverscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["y", "TI"], 
   StyleBox["z", "TI"]]], "InlineFormula"],
 " when large, and ",
 Cell[BoxData[
  SubsuperscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["y", "TI"], 
   StyleBox["z", "TI"]]], "InlineFormula"],
 " when small. "
}], "Notes",
 CellID->10867],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubsuperscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["y", "TI"], 
   StyleBox["z", "TI"]]], "InlineFormula"],
 " form is used when the box appears in a subscript or other script, or \
inline in a piece of text. "
}], "Notes",
 CellID->4085],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"LimitsPositioning", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " the display of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderoverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderoverscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " depends on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is \[Backslash]",
 Cell[BoxData[
  RowBox[{"[", 
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"], "]"}]], "InlineFormula"],
 ", \[Backslash]",
 Cell[BoxData[
  RowBox[{"[", 
   ButtonBox["Product",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Product"], "]"}]], "InlineFormula"],
 " or another form conventionally displayed with limits, then ",
 Cell[BoxData[
  RowBox[{"LimitsPositioning", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is effectively used. Otherwise, ",
 Cell[BoxData[
  RowBox[{"LimitsPositioning", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is used. "
}], "Notes",
 CellID->20226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LimitsPositioningTokens",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LimitsPositioningTokens"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " option which can be set to a list of forms for which ",
 Cell[BoxData[
  RowBox[{"LimitsPositioning", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " should be used. "
}], "Notes",
 CellID->30288]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7271936],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->81258538],

Cell["\<\
Define a low-level structure that has small underoverscript elements:\
\>", "ExampleText",
 CellID->83119784],

Cell[BoxData[
 RowBox[{
  RowBox[{"uoscripts", "=", 
   RowBox[{"FractionBox", "[", 
    RowBox[{
     RowBox[{"UnderoverscriptBox", "[", 
      RowBox[{"\"\<x\>\"", ",", "\"\<0\>\"", ",", "\"\<1\>\""}], "]"}], ",", 
     RowBox[{"UnderoverscriptBox", "[", 
      RowBox[{"\"\<\[Sum]\>\"", ",", "\"\<1\>\"", ",", "\"\<n\>\""}], "]"}]}],
     "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8094669],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LimitsPositioning", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the upper and lower scripts go to the right of the base:"
}], "ExampleText",
 CellID->245421796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", "uoscripts", "]"}], ",", "\"\<Output\>\"", ",", 
    RowBox[{"UnderoverscriptBoxOptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"LimitsPositioning", "\[Rule]", "True"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->97125154],

Cell[BoxData[
 FractionBox[
  UnderoverscriptBox["x", "0", "1"], 
  UnderoverscriptBox["\[Sum]", "1", "n"]]], "Output",
 ImageSize->{22, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 CellLabel->"Out[2]=",
 CellID->174768464]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LimitsPositioning", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the upper and lower scripts stay directly above and below:"
}], "ExampleText",
 CellID->140479715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", "uoscripts", "]"}], ",", "\"\<Output\>\"", ",", 
    RowBox[{"UnderoverscriptBoxOptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"LimitsPositioning", "\[Rule]", "False"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->600085753],

Cell[BoxData[
 FractionBox[
  UnderoverscriptBox["x", "0", "1"], 
  UnderoverscriptBox["\[Sum]", "1", "n"]]], "Output",
 ImageSize->{17, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 CellLabel->"Out[3]=",
 CellID->17434301]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LimitsPositioning", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the side positions are used with base ",
 Cell[BoxData[
  FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
 ", not with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->253078858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", "uoscripts", "]"}], ",", "\"\<Output\>\"", ",", 
    RowBox[{"UnderoverscriptBoxOptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"LimitsPositioning", "\[Rule]", "Automatic"}], "}"}]}]}], "]"}],
   "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->497758583],

Cell[BoxData[
 FractionBox[
  UnderoverscriptBox["x", "0", "1"], 
  UnderoverscriptBox["\[Sum]", "1", "n"]]], "Output",
 ImageSize->{22, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 UnderoverscriptBoxOptions->{LimitsPositioning->Automatic},
 CellLabel->"Out[4]=",
 CellID->18983817]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22716],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ScriptSizeMultipliers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptSizeMultipliers"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->23125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->71980384],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->116355096]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LimitsPositioning - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 23.9531660}", "context" -> "System`", 
    "keywords" -> {
     "\\displaystyle (TeX)", "inline typesetting", "display typesetting", 
      "summation limits", "product limits", "integration limits"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LimitsPositioning is an option for UnderoverscriptBox and related boxes \
which specifies whether to change the positioning of underscripts and \
overscripts in the way conventional for limits. ", 
    "synonyms" -> {"limits positioning"}, "title" -> "LimitsPositioning", 
    "type" -> "Symbol", "uri" -> "ref/LimitsPositioning"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6892, 244, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7271936]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13554, 475}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1257, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1880, 60, 54, 1, 70, "ObjectName",
 CellID->7300],
Cell[1937, 63, 721, 19, 70, "Usage",
 CellID->12238]
}, Open  ]],
Cell[CellGroupData[{
Cell[2695, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3173, 104, 657, 22, 70, "Notes",
 CellID->17726],
Cell[3833, 128, 767, 28, 70, "Notes",
 CellID->10867],
Cell[4603, 158, 285, 10, 70, "Notes",
 CellID->4085],
Cell[4891, 170, 1412, 49, 70, "Notes",
 CellID->20226],
Cell[6306, 221, 549, 18, 70, "Notes",
 CellID->30288]
}, Closed]],
Cell[CellGroupData[{
Cell[6892, 244, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7271936],
Cell[CellGroupData[{
Cell[7275, 258, 147, 5, 70, "ExampleSection",
 CellID->81258538],
Cell[7425, 265, 119, 3, 70, "ExampleText",
 CellID->83119784],
Cell[7547, 270, 408, 11, 70, "Input",
 CellID->8094669],
Cell[7958, 283, 280, 9, 70, "ExampleText",
 CellID->245421796],
Cell[CellGroupData[{
Cell[8263, 296, 362, 10, 47, "Input",
 CellID->97125154],
Cell[8628, 308, 304, 9, 57, "Output",
 CellID->174768464]
}, Open  ]],
Cell[8947, 320, 284, 9, 70, "ExampleText",
 CellID->140479715],
Cell[CellGroupData[{
Cell[9256, 333, 364, 10, 70, "Input",
 CellID->600085753],
Cell[9623, 345, 304, 9, 82, "Output",
 CellID->17434301]
}, Open  ]],
Cell[9942, 357, 420, 15, 70, "ExampleText",
 CellID->253078858],
Cell[CellGroupData[{
Cell[10387, 376, 368, 10, 70, "Input",
 CellID->497758583],
Cell[10758, 388, 308, 9, 68, "Output",
 CellID->18983817]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11127, 404, 311, 9, 70, "SeeAlsoSection",
 CellID->22716],
Cell[11441, 415, 222, 6, 70, "SeeAlso",
 CellID->23125]
}, Open  ]],
Cell[CellGroupData[{
Cell[11700, 426, 318, 9, 70, "MoreAboutSection",
 CellID->71980384],
Cell[12021, 437, 180, 3, 70, "MoreAbout",
 CellID->116355096]
}, Open  ]],
Cell[12216, 443, 27, 0, 70, "History"],
Cell[12246, 445, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

