(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18863,        580]
NotebookOptionsPosition[     15152,        459]
NotebookOutlinePosition[     16729,        503]
CellTagsIndexPosition[     16611,        497]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LineIndentMaxFraction" :> 
          Documentation`HelpLookup["paclet:ref/LineIndentMaxFraction"], 
          "PageWidth" :> Documentation`HelpLookup["paclet:ref/PageWidth"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"LineIndentMaxFraction\"\>", 
       2->"\<\"PageWidth\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"], 
          "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematical Typesetting\"\>", 
       2->"\<\"Math Typesetting Options & Tweaking\"\>", 
       3->"\<\"Text Layout Options\"\>", 
       4->"\<\"Text Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LineIndent", "ObjectName",
 CellID->31912],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LineIndent",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LineIndent"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies how many ems of indentation to add at the beginnings \
of lines for each level of nesting in an expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The typical default setting is ",
 Cell[BoxData[
  RowBox[{"LineIndent", "->", "1"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1163],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["LineIndent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineIndent"]], "InlineFormula"],
 " determines the amount of indentation that will be inserted after any \
explicit ",
 StyleBox["Return", "KeyEvent"],
 " is entered when ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AutoIndent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoIndent"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->890]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->656722],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->153552294],

Cell["Specify the size of indentation:", "ExampleText",
 CellID->358696996],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcde \>\"", ",", 
      RowBox[{"{", "40", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8271777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineIndent", "\[Rule]", "1"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->318287936],

Cell[BoxData[
 FrameBox[
  InterpretationBox[Cell[BoxData[
    StyleBox["\<\"abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde \"\>",
     StripOnInput->False,
     LineIndent->1]], "Text", "TR"],
   Text[
    Style[
    "abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde ", LineIndent -> 1]]],
  StripOnInput->False]], "Output",
 ImageSize->{452, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40616788]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->395850782],

Cell["No indentation:", "ExampleText",
 CellID->120976664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineIndent", "\[Rule]", "0"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39576492],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnN1OgzAYhsv4GUY953BX4oFRFw+8CLKYbAdGM3dXS/QSa38osNkZg7q1
+JAA/drvfQYrKx1vwkO9WT4+1ZvVop7N1/XLcrV4nd09r1VVmgiRvAkhriqh
ylKVzKqXd7WqclqWpbCLDrdqTWxV6jKl2W3VmtjE6FtStcl0XWa/hCZBBZNm
n7uKpq1AgSIIxZn3ip7oTdHFpuCEaRvavF78VTtcuHDhnoKrx8Xho5wZTKdt
Xj9VTGHAgHFUxrk8NAtPhUPZ5P1xItv99DZRz5ly9OjRD9aX8uA9Nu/ihis+
38N9sc4zB9YH2KOACRMmzIFM/2jlnpQYTtZxRDu7aIlZn6hrCrRo0Zoa/1NF
M/fvxRfEUcX+/130atyxv1fdr/9yxPsQvcTfbcGZRBGrAmcSLly44+biTMKA
MRYGziR69KHpcSZhwoQZBxNnEi1anEni78c4k2OMcSa7s9abUF3GIS04kyj+
QnHrvdpicwXgwoV7PO61xIWDAeNnjLnE/UKPfld/I3GfYML830z/KICrg3ZM
Wv/TF57Dnzb2z8vplRB7JXZ34957VnoTqhOx31JVlS11b7A0VTqvectl8gHQ
+P+Z\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{430, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93136387]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22663],

Cell[TextData[{
 "Create a cell with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AutoIndent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoIndent"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " with specific line indent:"
}], "ExampleText",
 CellID->415326673],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"ExpressionCell", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\"\<Input\>\"", ",", 
      RowBox[{"LineIndent", "\[Rule]", "5"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124210351],

Cell[TextData[{
 "When you press the ",
 Cell[BoxData[
  FormBox[
   DynamicBox[ToBoxes[
     If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
    ImageSizeCache->{36., {0., 8.}}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " key, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " inserts the indentation according to ",
 Cell[BoxData[
  ButtonBox["LineIndent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineIndent"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->128077075],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etTVPcdx/Ht9HFK/oU+z+M6SiaXajM+SqYdjWN0hKWAt0nSOEzbGZ2k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   "], {{0, 0}, {508, 142}}, {0, 255}],
  ImageSize->{508 0.75, 142 0.75},
  PlotRange->{{0, 508}, {0, 142}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->191602107]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17427],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LineIndentMaxFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineIndentMaxFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageWidth"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->698]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->110949386],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->125305889],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->531601659],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->317407292],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->380613599]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LineIndent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 32.3127550}", "context" -> "System`", 
    "keywords" -> {
     "text indentation", "formula indentation", "pretty printing indentation",
       "expression indentation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LineIndent is an option for Style and Cell which specifies how many ems \
of indentation to add at the beginnings of lines for each level of nesting in \
an expression. ", "synonyms" -> {"line indent"}, "title" -> "LineIndent", 
    "type" -> "Symbol", "uri" -> "ref/LineIndent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4543, 150, 357, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->656722]},
 "Notebook Image"->{
  Cell[9239, 316, 4011, 68, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->191602107]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16346, 486},
 {"Notebook Image", 16484, 490}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1790, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2413, 68, 48, 1, 70, "ObjectName",
 CellID->31912],
Cell[2464, 71, 809, 24, 70, "Usage",
 CellID->32353]
}, Open  ]],
Cell[CellGroupData[{
Cell[3310, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3788, 117, 156, 6, 70, "Notes",
 CellID->1163],
Cell[3947, 125, 559, 20, 70, "Notes",
 CellID->890]
}, Closed]],
Cell[CellGroupData[{
Cell[4543, 150, 357, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->656722],
Cell[CellGroupData[{
Cell[4925, 164, 148, 5, 70, "ExampleSection",
 CellID->153552294],
Cell[5076, 171, 75, 1, 70, "ExampleText",
 CellID->358696996],
Cell[5154, 174, 243, 8, 70, "Input",
 CellID->8271777],
Cell[CellGroupData[{
Cell[5422, 186, 227, 7, 28, "Input",
 CellID->318287936],
Cell[5652, 195, 851, 20, 83, "Output",
 CellID->40616788]
}, Open  ]],
Cell[6518, 218, 125, 3, 70, "ExampleDelimiter",
 CellID->395850782],
Cell[6646, 223, 58, 1, 70, "ExampleText",
 CellID->120976664],
Cell[CellGroupData[{
Cell[6729, 228, 226, 7, 28, "Input",
 CellID->39576492],
Cell[6958, 237, 825, 18, 83, "Output",
 Evaluatable->False,
 CellID->93136387]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7832, 261, 216, 7, 70, "ExampleSection",
 CellID->22663],
Cell[8051, 270, 335, 12, 70, "ExampleText",
 CellID->415326673],
Cell[8389, 284, 311, 10, 70, "Input",
 CellID->124210351],
Cell[8703, 296, 533, 18, 70, "ExampleText",
 CellID->128077075],
Cell[9239, 316, 4011, 68, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->191602107]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13299, 390, 311, 9, 70, "SeeAlsoSection",
 CellID->17427],
Cell[13613, 401, 477, 17, 70, "SeeAlso",
 CellID->698]
}, Open  ]],
Cell[CellGroupData[{
Cell[14127, 423, 319, 9, 70, "MoreAboutSection",
 CellID->110949386],
Cell[14449, 434, 159, 3, 70, "MoreAbout",
 CellID->125305889],
Cell[14611, 439, 180, 3, 70, "MoreAbout",
 CellID->531601659],
Cell[14794, 444, 148, 3, 70, "MoreAbout",
 CellID->317407292],
Cell[14945, 449, 135, 3, 70, "MoreAbout",
 CellID->380613599]
}, Open  ]],
Cell[15095, 455, 27, 0, 70, "History"],
Cell[15125, 457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

