(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25790,        956]
NotebookOptionsPosition[     20776,        790]
NotebookOutlinePosition[     22320,        830]
CellTagsIndexPosition[     22235,        825]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TransformationMatrix" :> 
          Documentation`HelpLookup["paclet:ref/TransformationMatrix"], 
          "AffineTransform" :> 
          Documentation`HelpLookup["paclet:ref/AffineTransform"], 
          "TransformationFunction" :> 
          Documentation`HelpLookup["paclet:ref/TransformationFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"TransformationMatrix\"\>", 
       2->"\<\"AffineTransform\"\>", 
       3->"\<\"TransformationFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geometric Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LinearFractionalTransform", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearFractionalTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearFractionalTransform"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a ",
     Cell[BoxData[
      ButtonBox["TransformationFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
     " that represents a linear fractional transformation defined by the \
homogeneous matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearFractionalTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearFractionalTransform"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["a", "TI"], ",", 
         StyleBox["b", "TI"], ",", 
         StyleBox["c", "TI"], ",", 
         StyleBox["d", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a linear fractional transformation that maps \
",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", ".", "r"}], "+", "b"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", ".", "r"}], "+", "d"}], ")"}]}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearFractionalTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearFractionalTransform"]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["TransformationFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
 " which can be applied to vectors."
}], "Notes",
 CellID->108862120],

Cell[TextData[{
 "For ordinary linear fractional transforms in ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " dimensions, ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], "\[Times]", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " matrix."
}], "Notes",
 CellID->60721000],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearFractionalTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearFractionalTransform"]], "InlineFormula"],
 " in general supports ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "\[Times]", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " matrices for transformations in ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " dimensions."
}], "Notes",
 CellID->518398028],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearFractionalTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearFractionalTransform"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], ",", 
     StyleBox["d", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is a matrix, ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " are vectors, and ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is a scalar."
}], "Notes",
 CellID->191764735]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->604231187],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->472802579],

Cell[TextData[{
 "This creates the linear fractional transform ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", ".", "x"}], "+", "b"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"c", ".", "x"}], "+", "d"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ": "
}], "ExampleText",
 CellID->98612308],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "17"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->280208943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"LinearFractionalTransform", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351206262],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "2", "5"},
     {"3", "4", "6"},
     {"7", "8", "17"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{237, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->725842643]
}, Open  ]],

Cell["This is the corresponding formula:", "ExampleText",
 CellID->278349523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->57094035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"5", "+", "x", "+", 
     RowBox[{"2", " ", "y"}]}], 
    RowBox[{"17", "+", 
     RowBox[{"7", " ", "x"}], "+", 
     RowBox[{"8", " ", "y"}]}]], ",", 
   FractionBox[
    RowBox[{"6", "+", 
     RowBox[{"3", " ", "x"}], "+", 
     RowBox[{"4", " ", "y"}]}], 
    RowBox[{"17", "+", 
     RowBox[{"7", " ", "x"}], "+", 
     RowBox[{"8", " ", "y"}]}]]}], "}"}]], "Output",
 ImageSize->{184, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->463081216]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "If the scalar ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " is omitted it is taken to be ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->197606026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearFractionalTransform", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12484493],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "2", "5"},
     {"3", "4", "6"},
     {"7", "8", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{230, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348692348]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20998276],

Cell["\<\
A single matrix is taken to be the homogeneous representation of the \
transform: \
\>", "ExampleText",
 CellID->294283038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearFractionalTransform", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->407222144],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "2", "5"},
     {"3", "4", "6"},
     {"7", "8", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{230, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80756701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191509926],

Cell[TextData[{
 "Suppose you have a linear fractional transform ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->88206187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"LinearFractionalTransform", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "1"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->290884616],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "2", "5"},
     {"3", "4", "6"},
     {"7", "8", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{230, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->887555109]
}, Open  ]],

Cell[TextData[{
 "The inverse is computed by applying ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->47064046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"InverseFunction", "[", "t", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19181290],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["22", "7"]}], 
      FractionBox["19", "7"], 
      RowBox[{"-", 
       FractionBox["4", "7"]}]},
     {
      FractionBox["39", "14"], 
      RowBox[{"-", 
       FractionBox["17", "7"]}], 
      FractionBox["9", "14"]},
     {
      RowBox[{"-", 
       FractionBox["2", "7"]}], 
      FractionBox["3", "7"], 
      RowBox[{"-", 
       FractionBox["1", "7"]}]}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{271, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->417340184]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " are inverses: "
}], "ExampleText",
 CellID->564884396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Composition", "[", 
  RowBox[{"s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->302654440],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{230, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->75150432]
}, Open  ]],

Cell["This shows the same thing using formulas: ", "ExampleText",
 CellID->165876210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"t", "[", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->198775020],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"5", "+", "x", "+", 
     RowBox[{"2", " ", "y"}]}], 
    RowBox[{"1", "+", 
     RowBox[{"7", " ", "x"}], "+", 
     RowBox[{"8", " ", "y"}]}]], ",", 
   FractionBox[
    RowBox[{"6", "+", 
     RowBox[{"3", " ", "x"}], "+", 
     RowBox[{"4", " ", "y"}]}], 
    RowBox[{"1", "+", 
     RowBox[{"7", " ", "x"}], "+", 
     RowBox[{"8", " ", "y"}]}]]}], "}"}]], "Output",
 ImageSize->{170, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->96702630]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"s", "[", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->942033940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox["4", "7"]}], "-", 
     FractionBox[
      RowBox[{"22", " ", "u"}], "7"], "+", 
     FractionBox[
      RowBox[{"19", " ", "v"}], "7"]}], 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "7"]}], "-", 
     FractionBox[
      RowBox[{"2", " ", "u"}], "7"], "+", 
     FractionBox[
      RowBox[{"3", " ", "v"}], "7"]}]], ",", 
   FractionBox[
    RowBox[{
     FractionBox["9", "14"], "+", 
     FractionBox[
      RowBox[{"39", " ", "u"}], "14"], "-", 
     FractionBox[
      RowBox[{"17", " ", "v"}], "7"]}], 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "7"]}], "-", 
     FractionBox[
      RowBox[{"2", " ", "u"}], "7"], "+", 
     FractionBox[
      RowBox[{"3", " ", "v"}], "7"]}]]}], "}"}]], "Output",
 ImageSize->{205, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->529544307]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "/.", " ", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "\[Rule]", "g"}], "]"}]}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->517391711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"u", ",", "v"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->391510082]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AffineTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AffineTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->310828272],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->93625145]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinearFractionalTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 24.4063026}", "context" -> "System`", 
    "keywords" -> {"conformal mapping", "linear fractional transformation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LinearFractionalTransform[m] gives a TransformationFunction that \
represents a linear fractional transformation defined by the homogeneous \
matrix m. LinearFractionalTransform[{a, b, c, d}] represents a linear \
fractional transformation that maps r to (a.r + b)/(c.r + d). ", 
    "synonyms" -> {"linear fractional transform"}, "title" -> 
    "LinearFractionalTransform", "type" -> "Symbol", "uri" -> 
    "ref/LinearFractionalTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8017, 260, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->604231187]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22092, 818}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1484, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2107, 63, 1590, 37, 70, "ObjectNameGrid"],
Cell[3700, 102, 1715, 53, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5452, 160, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5930, 177, 399, 12, 70, "Notes",
 CellID->108862120],
Cell[6332, 191, 450, 17, 70, "Notes",
 CellID->60721000],
Cell[6785, 210, 491, 16, 70, "Notes",
 CellID->518398028],
Cell[7279, 228, 701, 27, 70, "Notes",
 CellID->191764735]
}, Closed]],
Cell[CellGroupData[{
Cell[8017, 260, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->604231187],
Cell[CellGroupData[{
Cell[8402, 274, 148, 5, 70, "ExampleSection",
 CellID->472802579],
Cell[8553, 281, 356, 14, 70, "ExampleText",
 CellID->98612308],
Cell[8912, 297, 573, 21, 70, "Input",
 CellID->280208943],
Cell[CellGroupData[{
Cell[9510, 322, 213, 6, 28, "Input",
 CellID->351206262],
Cell[9726, 330, 406, 14, 64, "Output",
 CellID->725842643]
}, Open  ]],
Cell[10147, 347, 77, 1, 70, "ExampleText",
 CellID->278349523],
Cell[CellGroupData[{
Cell[10249, 352, 143, 5, 70, "Input",
 CellID->57094035],
Cell[10395, 359, 572, 20, 53, "Output",
 CellID->463081216]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11016, 385, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[11240, 394, 241, 9, 70, "ExampleText",
 CellID->197606026],
Cell[CellGroupData[{
Cell[11506, 407, 445, 15, 70, "Input",
 CellID->12484493],
Cell[11954, 424, 405, 14, 64, "Output",
 CellID->348692348]
}, Open  ]],
Cell[12374, 441, 124, 3, 70, "ExampleDelimiter",
 CellID->20998276],
Cell[12501, 446, 133, 4, 70, "ExampleText",
 CellID->294283038],
Cell[CellGroupData[{
Cell[12659, 454, 361, 11, 70, "Input",
 CellID->407222144],
Cell[13023, 467, 404, 14, 64, "Output",
 CellID->80756701]
}, Open  ]],
Cell[13442, 484, 125, 3, 70, "ExampleDelimiter",
 CellID->191509926],
Cell[13570, 489, 167, 6, 70, "ExampleText",
 CellID->88206187],
Cell[CellGroupData[{
Cell[13762, 499, 392, 12, 70, "Input",
 CellID->290884616],
Cell[14157, 513, 405, 14, 64, "Output",
 CellID->887555109]
}, Open  ]],
Cell[14577, 530, 233, 8, 70, "ExampleText",
 CellID->47064046],
Cell[CellGroupData[{
Cell[14835, 542, 133, 4, 70, "Input",
 CellID->19181290],
Cell[14971, 548, 751, 28, 92, "Output",
 CellID->417340184]
}, Open  ]],
Cell[15737, 579, 218, 9, 70, "ExampleText",
 CellID->564884396],
Cell[CellGroupData[{
Cell[15980, 592, 130, 4, 70, "Input",
 CellID->302654440],
Cell[16113, 598, 404, 14, 64, "Output",
 CellID->75150432]
}, Open  ]],
Cell[16532, 615, 85, 1, 70, "ExampleText",
 CellID->165876210],
Cell[CellGroupData[{
Cell[16642, 620, 169, 6, 70, "Input",
 CellID->198775020],
Cell[16814, 628, 569, 20, 53, "Output",
 CellID->96702630]
}, Open  ]],
Cell[CellGroupData[{
Cell[17420, 653, 169, 6, 70, "Input",
 CellID->942033940],
Cell[17592, 661, 964, 36, 68, "Output",
 CellID->529544307]
}, Open  ]],
Cell[CellGroupData[{
Cell[18593, 702, 250, 9, 70, "Input",
 CellID->517391711],
Cell[18846, 713, 203, 7, 36, "Output",
 CellID->391510082]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19110, 727, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19429, 738, 766, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[20232, 769, 319, 9, 70, "MoreAboutSection",
 CellID->310828272],
Cell[20554, 780, 150, 3, 70, "MoreAbout",
 CellID->93625145]
}, Open  ]],
Cell[20719, 786, 27, 0, 70, "History"],
Cell[20749, 788, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

