(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77406,       2686]
NotebookOptionsPosition[     65353,       2288]
NotebookOutlinePosition[     67794,       2341]
CellTagsIndexPosition[     67708,       2336]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Optimization" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalOptimization"], 
          "Constrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Numerical Optimization\"\>", 
       2->"\<\"Constrained Optimization\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NMinimize" :> Documentation`HelpLookup["paclet:ref/NMinimize"],
           "Minimize" :> Documentation`HelpLookup["paclet:ref/Minimize"], 
          "FindMinimum" :> 
          Documentation`HelpLookup["paclet:ref/FindMinimum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NMinimize\"\>", 
       2->"\<\"Minimize\"\>", 3->"\<\"FindMinimum\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"Matrix-Based Minimization\"\>", 4->"\<\"Optimization\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LinearProgramming", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearProgramming",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearProgramming"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a vector ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " which minimizes the quantity ",
     Cell[BoxData[
      RowBox[{
       StyleBox["c", "TI"], ".", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     " subject to the constraints ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], ".", 
       StyleBox["x", "TI"], "\[GreaterEqual]", 
       StyleBox["b", "TI"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "\[GreaterEqual]", "0"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearProgramming",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearProgramming"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["s", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["s", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a vector ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " which minimizes ",
     Cell[BoxData[
      RowBox[{
       StyleBox["c", "TI"], ".", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     " subject to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "\[GreaterEqual]", "0"}]], "InlineFormula"],
     " and linear constraints specified by the matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and the pairs ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["i", "TI"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
     ". For each row ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ", the corresponding constraint is ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["i", "TI"]], ".", 
        StyleBox["x", "TI"]}], "\[GreaterEqual]", 
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["i", "TI"]]}]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["i", "TI"]], "==", "1"}]], "InlineFormula"],
     ", or ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["i", "TI"]], ".", 
        StyleBox["x", "TI"]}], "==", 
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["i", "TI"]]}]], "InlineFormula"],
     " if  ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["i", "TI"]], "==", "0"}]], "InlineFormula"],
     ", or ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["i", "TI"]], ".", 
        StyleBox["x", "TI"]}], "\[LessEqual]", 
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["i", "TI"]]}]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["i", "TI"]], "==", 
       RowBox[{"-", "1"}]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearProgramming",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearProgramming"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]minimizes ",
     Cell[BoxData[
      RowBox[{
       StyleBox["c", "TI"], ".", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     " subject to the constraints specified by ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "\[GreaterEqual]", 
       StyleBox["l", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearProgramming",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearProgramming"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["l", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["l", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]minimizes ",
     Cell[BoxData[
      RowBox[{
       StyleBox["c", "TI"], ".", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     " subject to the constraints specified by ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], "\[GreaterEqual]", 
       SubscriptBox[
        StyleBox["l", "TI"], 
        StyleBox["i", "TI"]]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearProgramming",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearProgramming"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["l", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["l", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]minimizes ",
     Cell[BoxData[
      RowBox[{
       StyleBox["c", "TI"], ".", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     " subject to the constraints specified by ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["l", "TI"], 
        StyleBox["i", "TI"]], "\[LessEqual]", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], "\[LessEqual]", 
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["i", "TI"]]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearProgramming",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearProgramming"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["lu", "TI"], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the elements of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to be in the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ", either ",
     Cell[BoxData[
      ButtonBox["Reals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Integers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearProgramming",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearProgramming"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["lu", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["dom", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["dom", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to be in the domain ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dom", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "All entries in the vectors ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " and the matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " must be real numbers. "
}], "Notes",
 CellID->11505],

Cell[TextData[{
 "The bounds ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["l", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must be real numbers or ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " is equivalent to specifying no bounds."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->28337575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 " gives exact rational number or integer results if its input consists of \
exact rational numbers. "
}], "Notes",
 CellID->23007],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 " returns unevaluated if no solution can be found. "
}], "Notes",
 CellID->32497],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 " finds approximate numerical results if its input contains approximate \
numbers. The option ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 " specifies the tolerance to be used for internal comparisons. The default \
is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tolerance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tolerance"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", which does exact comparisons for exact numbers, and uses tolerance ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]], TraditionalForm]], "InlineMath"],
 " for approximate numbers. "
}], "Notes",
 CellID->13369],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects can be used in ",
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29276],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", "\"\<InteriorPoint\>\""}]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 " uses interior point methods. "
}], "Notes",
 CellID->31663]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19750748],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->158906218],

Cell[TextData[{
 "Minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "y"}], TraditionalForm]], "InlineMath"],
 ", subject to constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"2", " ", "y"}]}], "\[GreaterEqual]", "3"}], TraditionalForm]], 
  "InlineMath"],
 ", and implicit non-negative constraints:"
}], "ExampleText",
 CellID->1474998837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469959187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["3", "2"]}], "}"}]], "Output",
 ImageSize->{48, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23292826]
}, Open  ]],

Cell[TextData[{
 "Solve the problem with equality constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"2", " ", "y"}]}], "\[LongEqual]", "3"}], TraditionalForm]], 
  "InlineMath"],
 ", and implicit non-negative constraints:"
}], "ExampleText",
 CellID->1559386368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->442911341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["3", "2"]}], "}"}]], "Output",
 ImageSize->{48, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->559315324]
}, Open  ]],

Cell[TextData[{
 "Solve the problem with equality constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"2", " ", "y"}]}], "\[LessEqual]", "3"}], TraditionalForm]], 
  "InlineMath"],
 ", and implicit non-negative constraints:"
}], "ExampleText",
 CellID->246215122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1869185706],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->273168487]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13929],

Cell[TextData[{
 "Minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "y"}], TraditionalForm]], "InlineMath"],
 ", subject to constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"2", " ", "y"}]}], "\[GreaterEqual]", "3"}], TraditionalForm]], 
  "InlineMath"],
 ", and lower bounds ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[GreaterEqual]", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "\[GreaterEqual]", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1706965103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1849139817],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "2"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579396184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->212853883],

Cell[TextData[{
 "Minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "y"}], TraditionalForm]], "InlineMath"],
 ", subject to constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"2", " ", "y"}]}], "\[GreaterEqual]", "3"}], TraditionalForm]], 
  "InlineMath"],
 ", and bounds ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[GreaterEqual]", "x", "\[GreaterEqual]", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[GreaterEqual]", "y", "\[GreaterEqual]", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->30245430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->705812622],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202637962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->800928779],

Cell[TextData[{
 "Minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"3", " ", "y"}]}], TraditionalForm]], "InlineMath"],
 ", subject to constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "-", 
     RowBox[{"2", " ", "y"}]}], "\[LessEqual]", "3"}], TraditionalForm]], 
  "InlineMath"],
 ", and upper bounds ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[LessEqual]", "1"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "\[LessEqual]", "1"}], TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->1750647063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "2"}]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Infinity"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Infinity"}], ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2009537565],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250442061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->835620242],

Cell[TextData[{
 "Minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "y"}], TraditionalForm]], "InlineMath"],
 ", subject to constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"5", " ", "x"}], "+", 
     RowBox[{"2", " ", "y"}]}], "\[GreaterEqual]", "3"}], TraditionalForm]], 
  "InlineMath"],
 " and implicit non-negative constraints:"
}], "ExampleText",
 CellID->1028903214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.", ",", "1."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"5.", ",", "2."}], "}"}], "}"}], ",", 
   RowBox[{"{", "3.", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1465120257],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->463133516]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->854669685],

Cell[TextData[{
 "Minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}]}], TraditionalForm]], "InlineMath"],
 " subject to bounds ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[GreaterEqual]", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "\[GreaterEqual]", 
    RowBox[{"-", "2"}]}], TraditionalForm]], "InlineMath"],
 " only:"
}], "ExampleText",
 CellID->171300706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "}"}], "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1912185059],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491344929]
}, Open  ]],

Cell["\<\
Solve the same kind of problem, but with both variables integers:\
\>", "ExampleText",
 CellID->1323535812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.", ",", "1."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"5.", ",", "2."}], "}"}], "}"}], ",", 
   RowBox[{"{", "3.", "}"}], ",", "Automatic", ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1876408764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30812176]
}, Open  ]],

Cell["\<\
Solve the same problem, but with the first variable an integer:\
\>", "ExampleText",
 CellID->980298026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.", ",", "1."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"5.", ",", "2."}], "}"}], "}"}], ",", 
   RowBox[{"{", "3.", "}"}], ",", "Automatic", ",", 
   RowBox[{"{", 
    RowBox[{"Integers", ",", "Reals"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1486160659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->438020667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->409309306],

Cell["\<\
Solve larger LPs, in this case 200,000 variables and 10,000 constraints:\
\>", "ExampleText",
 CellID->821732306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "=", 
    RowBox[{"LinearProgramming", "[", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"2", " ", 
        RowBox[{"10", "^", "5"}]}], "]"}], ",", 
      RowBox[{"SparseArray", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Band", "[", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1."}], ",", 
          RowBox[{
           RowBox[{"Band", "[", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", " ", "2."}]}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"10", "^", "4"}], ",", 
          RowBox[{"2", " ", 
           RowBox[{"10", "^", "5"}]}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{"10", "^", "4"}], "]"}]}], "]"}]}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340674627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.693999999999999`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32092503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"x", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->71553041],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.08458913162478296`", ",", "0.4862385351991109`", ",", 
   "0.7573302730204022`", ",", "1.1216066703942538`", ",", 
   "1.439385784619916`", ",", "1.7804722530309305`", ",", "2.10989528422261`",
    ",", "2.4451647411474466`", ",", "2.777515906055149`", ",", 
   "3.1113300292775694`"}], "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23559307]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1656],

Cell[TextData[{
 "Objective, constraints and bounds can all be specified as ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1622544201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], "\[Rule]", "1"}], "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373571150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->570405808]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29445],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28516],

Cell[TextData[{
 Cell[BoxData["\"\<InteriorPoint\>\""], "InlineFormula"],
 " is faster than ",
 Cell[BoxData["\"\<Simplex\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<RevisedSimplex\>\""], "InlineFormula"],
 ", though only works for machine-precision problems:"
}], "ExampleText",
 CellID->544566958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"LinearProgramming", "[", 
    RowBox[{
     RowBox[{"Range", "[", "200", "]"}], ",", 
     RowBox[{"SparseArray", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Band", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1."}], ",", 
         RowBox[{
          RowBox[{"Band", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", " ", "2."}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "200"}], "}"}]}], "]"}], ",", 
     RowBox[{"Range", "[", "100", "]"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<Simplex\>\""}]}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1362581318],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.29100000000000115`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133123650]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"LinearProgramming", "[", 
    RowBox[{
     RowBox[{"Range", "[", "200", "]"}], ",", 
     RowBox[{"SparseArray", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Band", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1."}], ",", 
         RowBox[{
          RowBox[{"Band", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", " ", "2."}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "200"}], "}"}]}], "]"}], ",", 
     RowBox[{"Range", "[", "100", "]"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<InteriorPoint\>\""}]}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1531053728],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.02000000000000167`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42051160]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Tolerance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->27553],

Cell[TextData[{
 "If an approximated solution is sufficient, a loose ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 " option makes the solution process faster:"
}], "ExampleText",
 CellID->1003535082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"LinearProgramming", "[", 
    RowBox[{
     RowBox[{"Range", "[", "20000", "]"}], ",", 
     RowBox[{"SparseArray", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Band", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1."}], ",", 
         RowBox[{
          RowBox[{"Band", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", " ", "2."}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10000", ",", "20000"}], "}"}]}], "]"}], ",", 
     RowBox[{"Range", "[", "10000", "]"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<InteriorPoint\>\""}]}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73938038],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3109999999999995`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147677776]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"LinearProgramming", "[", 
    RowBox[{
     RowBox[{"Range", "[", "20000", "]"}], ",", 
     RowBox[{"SparseArray", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Band", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1."}], ",", 
         RowBox[{
          RowBox[{"Band", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", " ", "2."}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10000", ",", "20000"}], "}"}]}], "]"}], ",", 
     RowBox[{"Range", "[", "10000", "]"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<InteriorPoint\>\""}], ",", 
     RowBox[{"Tolerance", "\[Rule]", " ", "1."}]}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1892080241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5210000000000001`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22874544]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27612],

Cell[TextData[{
 "A linear programming problem can also be solved using ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1163810205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "}"}], ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1644797350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "3"], ",", "0"}], "}"}]], "Output",
 ImageSize->{48, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320480189]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"3", "x"}], "+", 
         RowBox[{"4", "y"}]}], "\[GreaterEqual]", "5"}], "&&", 
       RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
       RowBox[{"y", "\[GreaterEqual]", "0"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1278911898],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "3"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["5", "3"]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{130, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19051428]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2003110317],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " can be used to solve inexact linear programming problems:"
}], "ExampleText",
 CellID->375058702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"3", "x"}], "+", 
         RowBox[{"4", "y"}]}], "\[GreaterEqual]", "5"}], "&&", 
       RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
       RowBox[{"y", "\[GreaterEqual]", "0"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232242203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.6666666666666665`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.6666666666666665`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->395167652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"3", "x"}], "+", 
         RowBox[{"4", "y"}]}], "\[GreaterEqual]", "5"}], "&&", 
       RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
       RowBox[{"y", "\[GreaterEqual]", "0"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "30"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1648624989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.66666666666666666666666666666666666666`28.76955107862173", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
     "x", "\[Rule]", 
      "1.66666666666666666666666666666666666666`28.847711655616944"}], ",", 
     RowBox[{"y", "\[Rule]", "0``30."}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{576, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->498314583]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24297],

Cell["\<\
Integer programming algorithm is limited to for machine-number problems:\
\>", "ExampleText",
 CellID->2001017660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", "Automatic", ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1664072560],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearProgramming", "::", "\<\"lpip\"\>"}], ":", 
  " ", "\<\"Warning: Problem specified contains integer variables. Only \
machine number algorithm is available; the problem will be converted into \
machine precision.\"\>"}]], "Message", "MSG",
 CellID->45892058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31289271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1062965230],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<InteriorPoint\>\""], "InlineFormula"],
 " method only works for machine numbers:"
}], "ExampleText",
 CellID->87934528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<InteriorPoint\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->615116774],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearProgramming", "::", "\<\"lpipp\"\>"}], ":", 
  " ", "\<\"Warning: Method -> InteriorPoint specified for \
non-machine-precision problem. A machine-precision result will be given. If a \
non-machine-precision result is needed, set the option to Method -> \
\\!\\(\\\"Simplex\\\"\\).\"\>"}]], "Message", "MSG",
 CellID->537372006],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6000000000097225`", ",", "1.7256914330145014`*^-11"}], 
  "}"}]], "Output",
 ImageSize->{140, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578544322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292662029],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<InteriorPoint\>\""], "InlineFormula"],
 " method may return a solution in the middle of the optimal solution set:"
}], "ExampleText",
 CellID->1735677223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1."}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1.", ",", "1."}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1.", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<InteriorPoint\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2019640246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4999999995803501`", ",", "0.4999999995803501`"}], 
  "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->524050626]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Simplex\>\""], "InlineFormula"],
 " method always returns a solution at a corner of the optimal solution set:"
}], "ExampleText",
 CellID->1824994461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1."}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1.", ",", "1."}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1.", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Simplex\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1953686089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18106277]
}, Open  ]],

Cell[TextData[{
 "In this case the optimal solution set is the set of all points on the line \
segment between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", ",", "0"}], ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "1"}], ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->201054120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "x"}], "-", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "+", "y"}], "\[LessEqual]", "1"}], "&&", 
       RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
       RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->173744307],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->836033206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1807974385],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<InteriorPoint\>\""], "InlineFormula"],
 " method may not always be able to tell if a problem is infeasible or \
unbounded:"
}], "ExampleText",
 CellID->36073883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1."}], ",", 
     RowBox[{"-", "1."}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1.", ",", "1."}], "}"}], "}"}], ",", 
   RowBox[{"{", "1.", "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<InteriorPoint\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->704723545],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearProgramming", "::", "\<\"lpdinf\"\>"}], ":", 
  " ", "\<\"The dual of this problem is infeasible, which implies that this \
problem is either unbounded or infeasible. Setting the option Method -> \
\\!\\(\\\"Simplex\\\"\\) should give a more definite answer, though large \
problems may take longer computing time.\"\>"}]], "Message", "MSG",
 CellID->79164839],

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1.`", ",", "1.`"}], "}"}], "}"}], ",", 
   RowBox[{"{", "1.`", "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\<\"InteriorPoint\"\>"}]}], "]"}]], "Output",\

 ImageSize->{484, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257680994]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3249],

Cell[TextData[{
 "This expresses the Klee\[Dash]Minty problem of dimension ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 " syntax:"
}], "ExampleText",
 CellID->1874428683],

Cell[BoxData[
 RowBox[{
  RowBox[{"KleeMinty", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "rhs"}], "}"}], ",", 
    RowBox[{
     RowBox[{"c", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["10", 
          RowBox[{"n", "-", "i"}]]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"a", "[", "i_", "]"}], ":=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["10", 
            RowBox[{"i", "-", "j"}]]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"n", "-", "i"}], "}"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"rhs", "[", "i_", "]"}], ":=", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["100", 
         RowBox[{"i", "-", "1"}]], ",", 
        RowBox[{"-", "1"}]}], "}"}]}], ";", 
     RowBox[{"m", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"a", "[", "i", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";", 
     RowBox[{"b", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"rhs", "[", "i", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";", 
     RowBox[{"{", 
      RowBox[{"c", ",", "m", ",", "b"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131235350],

Cell["\<\
Because scaling is applied internally, the simplex algorithm converges very \
quickly:\
\>", "ExampleText",
 CellID->2029432718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Apply", "[", 
   RowBox[{"LinearProgramming", ",", 
    RowBox[{"KleeMinty", "[", "16", "]"}]}], "]"}], "//", "Timing"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->2047489804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.010000000000000526`", ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "1000000000000000000000000000000"}], "}"}]}], "}"}]], "Output",
 ImageSize->{583, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51866229]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4914],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NMinimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NMinimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMinimum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMinimum"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5230]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15216],

Cell[TextData[ButtonBox["Numerical Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalOptimization"]], "Tutorials",
 CellID->13361],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstrainedOptimizationOverview"]], "Tutorials",\

 CellID->78894921]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->79],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#17945"], None}]], "RelatedLinks",
 CellID->7555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->964888739],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->72896119],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->83378376],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "MoreAbout",
 CellID->270353451],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "MoreAbout",
 CellID->291210017],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->37672109]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinearProgramming - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 24.9375662}", "context" -> "System`", 
    "keywords" -> {
     "integer programming", "interior point methods", "Karmarkar algorithm", 
      "linear constraints", "linear objective function", 
      "linear optimization", "LP", "operations research", 
      "simplex algorithm"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinearProgramming[c, m, b] finds a vector x which minimizes the quantity \
c.x subject to the constraints m.x >= b and x >= 0. LinearProgramming[c, m, \
{{b_1, s_1}, {b_2, s_2}, ...}] finds a vector x which minimizes c.x subject \
to x >= 0 and linear constraints specified by the matrix m and the pairs \
{b_i, s_i}. For each row m_i of m, the corresponding constraint is m_i.x >= \
b_i if s_i == 1, or m_i.x == b_i if s_i == 0, or m_i.x <= b_i if s_i == -1. \
LinearProgramming[c, m, b, l] minimizes c.x subject to the constraints \
specified by m and b and x >= l. LinearProgramming[c, m, b, {l_1, l_2, ...}] \
minimizes c.x subject to the constraints specified by m and b and x_i >= l_i. \
LinearProgramming[c, m, b, {{l_1, u_1}, {l_2, u_2}, ...}] minimizes c.x \
subject to the constraints specified by m and b and l_i <= x_i <= u_i. \
LinearProgramming[c, m, b, lu, dom] takes the elements of x to be in the \
domain dom, either Reals or Integers. LinearProgramming[c, m, b, lu, {dom_1, \
dom_2, ...}] takes x_i to be in the domain dom_i.", 
    "synonyms" -> {"linear programming"}, "title" -> "LinearProgramming", 
    "type" -> "Symbol", "uri" -> "ref/LinearProgramming"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21720, 670, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19750748]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 67565, 2329}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2772, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3395, 90, 4201, 83, 70, "ObjectNameGrid"],
Cell[7599, 175, 10150, 338, 70, "Usage",
 CellID->21984]
}, Open  ]],
Cell[CellGroupData[{
Cell[17786, 518, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[18264, 535, 305, 12, 70, "Notes",
 CellID->11505],
Cell[18572, 549, 573, 24, 70, "Notes",
 CellID->5471],
Cell[19148, 575, 331, 10, 70, "Notes",
 CellID->28337575],
Cell[19482, 587, 284, 8, 70, "Notes",
 CellID->23007],
Cell[19769, 597, 235, 7, 70, "Notes",
 CellID->32497],
Cell[20007, 606, 932, 28, 70, "Notes",
 CellID->13369],
Cell[20942, 636, 341, 12, 70, "Notes",
 CellID->29276],
Cell[21286, 650, 397, 15, 70, "Notes",
 CellID->31663]
}, Closed]],
Cell[CellGroupData[{
Cell[21720, 670, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19750748],
Cell[CellGroupData[{
Cell[22104, 684, 148, 5, 70, "ExampleSection",
 CellID->158906218],
Cell[22255, 691, 386, 14, 70, "ExampleText",
 CellID->1474998837],
Cell[CellGroupData[{
Cell[22666, 709, 294, 10, 28, "Input",
 CellID->469959187],
Cell[22963, 721, 224, 8, 51, "Output",
 CellID->23292826]
}, Open  ]],
Cell[23202, 732, 300, 10, 70, "ExampleText",
 CellID->1559386368],
Cell[CellGroupData[{
Cell[23527, 746, 345, 12, 28, "Input",
 CellID->442911341],
Cell[23875, 760, 225, 8, 51, "Output",
 CellID->559315324]
}, Open  ]],
Cell[24115, 771, 299, 10, 70, "ExampleText",
 CellID->246215122],
Cell[CellGroupData[{
Cell[24439, 785, 368, 13, 70, "Input",
 CellID->1869185706],
Cell[24810, 800, 203, 7, 36, "Output",
 CellID->273168487]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25062, 813, 216, 7, 70, "ExampleSection",
 CellID->13929],
Cell[25281, 822, 622, 24, 70, "ExampleText",
 CellID->1706965103],
Cell[CellGroupData[{
Cell[25928, 850, 396, 14, 70, "Input",
 CellID->1849139817],
Cell[26327, 866, 222, 8, 36, "Output",
 CellID->579396184]
}, Open  ]],
Cell[26564, 877, 125, 3, 70, "ExampleDelimiter",
 CellID->212853883],
Cell[26692, 882, 663, 24, 70, "ExampleText",
 CellID->30245430],
Cell[CellGroupData[{
Cell[27380, 910, 505, 18, 70, "Input",
 CellID->705812622],
Cell[27888, 930, 203, 7, 36, "Output",
 CellID->202637962]
}, Open  ]],
Cell[28106, 940, 125, 3, 70, "ExampleDelimiter",
 CellID->800928779],
Cell[28234, 945, 645, 25, 70, "ExampleText",
 CellID->1750647063],
Cell[CellGroupData[{
Cell[28904, 974, 661, 25, 70, "Input",
 CellID->2009537565],
Cell[29568, 1001, 222, 8, 36, "Output",
 CellID->250442061]
}, Open  ]],
Cell[29805, 1012, 125, 3, 70, "ExampleDelimiter",
 CellID->835620242],
Cell[29933, 1017, 411, 15, 70, "ExampleText",
 CellID->1028903214],
Cell[CellGroupData[{
Cell[30369, 1036, 300, 10, 70, "Input",
 CellID->1465120257],
Cell[30672, 1048, 208, 7, 36, "Output",
 CellID->463133516]
}, Open  ]],
Cell[30895, 1058, 125, 3, 70, "ExampleDelimiter",
 CellID->854669685],
Cell[31023, 1063, 494, 19, 70, "ExampleText",
 CellID->171300706],
Cell[CellGroupData[{
Cell[31542, 1086, 360, 13, 70, "Input",
 CellID->1912185059],
Cell[31905, 1101, 241, 9, 36, "Output",
 CellID->491344929]
}, Open  ]],
Cell[32161, 1113, 117, 3, 70, "ExampleText",
 CellID->1323535812],
Cell[CellGroupData[{
Cell[32303, 1120, 338, 11, 70, "Input",
 CellID->1876408764],
Cell[32644, 1133, 202, 7, 36, "Output",
 CellID->30812176]
}, Open  ]],
Cell[32861, 1143, 114, 3, 70, "ExampleText",
 CellID->980298026],
Cell[CellGroupData[{
Cell[33000, 1150, 388, 12, 70, "Input",
 CellID->1486160659],
Cell[33391, 1164, 205, 7, 36, "Output",
 CellID->438020667]
}, Open  ]],
Cell[33611, 1174, 125, 3, 70, "ExampleDelimiter",
 CellID->409309306],
Cell[33739, 1179, 123, 3, 70, "ExampleText",
 CellID->821732306],
Cell[CellGroupData[{
Cell[33887, 1186, 973, 31, 70, "Input",
 CellID->340674627],
Cell[34863, 1219, 222, 7, 36, "Output",
 CellID->32092503]
}, Open  ]],
Cell[CellGroupData[{
Cell[35122, 1231, 123, 4, 70, "Input",
 CellID->71553041],
Cell[35248, 1237, 479, 12, 54, "Output",
 CellID->23559307]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35776, 1255, 238, 7, 70, "ExampleSection",
 CellID->1656],
Cell[36017, 1264, 249, 8, 70, "ExampleText",
 CellID->1622544201],
Cell[CellGroupData[{
Cell[36291, 1276, 442, 14, 70, "Input",
 CellID->373571150],
Cell[36736, 1292, 223, 7, 36, "Output",
 CellID->570405808]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37008, 1305, 218, 7, 70, "ExampleSection",
 CellID->29445],
Cell[CellGroupData[{
Cell[37251, 1316, 223, 7, 70, "ExampleSubsection",
 CellID->28516],
Cell[37477, 1325, 308, 8, 70, "ExampleText",
 CellID->544566958],
Cell[CellGroupData[{
Cell[37810, 1337, 821, 25, 70, "Input",
 CellID->1362581318],
Cell[38634, 1364, 225, 7, 36, "Output",
 CellID->133123650]
}, Open  ]],
Cell[CellGroupData[{
Cell[38896, 1376, 827, 25, 70, "Input",
 CellID->1531053728],
Cell[39726, 1403, 224, 7, 36, "Output",
 CellID->42051160]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39999, 1416, 226, 7, 70, "ExampleSubsection",
 CellID->27553],
Cell[40228, 1425, 278, 8, 70, "ExampleText",
 CellID->1003535082],
Cell[CellGroupData[{
Cell[40531, 1437, 833, 25, 70, "Input",
 CellID->73938038],
Cell[41367, 1464, 224, 7, 36, "Output",
 CellID->147677776]
}, Open  ]],
Cell[CellGroupData[{
Cell[41628, 1476, 891, 26, 70, "Input",
 CellID->1892080241],
Cell[42522, 1504, 223, 7, 36, "Output",
 CellID->22874544]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[42806, 1518, 233, 7, 70, "ExampleSection",
 CellID->27612],
Cell[43042, 1527, 238, 8, 70, "ExampleText",
 CellID->1163810205],
Cell[CellGroupData[{
Cell[43305, 1539, 295, 10, 70, "Input",
 CellID->1644797350],
Cell[43603, 1551, 225, 8, 51, "Output",
 CellID->320480189]
}, Open  ]],
Cell[CellGroupData[{
Cell[43865, 1564, 544, 18, 70, "Input",
 CellID->1278911898],
Cell[44412, 1584, 363, 13, 51, "Output",
 CellID->19051428]
}, Open  ]],
Cell[44790, 1600, 126, 3, 70, "ExampleDelimiter",
 CellID->2003110317],
Cell[44919, 1605, 371, 12, 70, "ExampleText",
 CellID->375058702],
Cell[CellGroupData[{
Cell[45315, 1621, 546, 18, 70, "Input",
 CellID->232242203],
Cell[45864, 1641, 355, 11, 36, "Output",
 CellID->395167652]
}, Open  ]],
Cell[CellGroupData[{
Cell[46256, 1657, 601, 19, 70, "Input",
 CellID->1648624989],
Cell[46860, 1678, 450, 13, 39, "Output",
 CellID->498314583]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47359, 1697, 226, 7, 70, "ExampleSection",
 CellID->24297],
Cell[47588, 1706, 124, 3, 70, "ExampleText",
 CellID->2001017660],
Cell[CellGroupData[{
Cell[47737, 1713, 333, 11, 70, "Input",
 CellID->1664072560],
Cell[48073, 1726, 299, 6, 70, "Message",
 CellID->45892058],
Cell[48375, 1734, 202, 7, 36, "Output",
 CellID->31289271]
}, Open  ]],
Cell[48592, 1744, 126, 3, 70, "ExampleDelimiter",
 CellID->1062965230],
Cell[48721, 1749, 163, 5, 70, "ExampleText",
 CellID->87934528],
Cell[CellGroupData[{
Cell[48909, 1758, 359, 11, 70, "Input",
 CellID->615116774],
Cell[49271, 1771, 369, 7, 70, "Message",
 CellID->537372006],
Cell[49643, 1780, 248, 8, 39, "Output",
 CellID->578544322]
}, Open  ]],
Cell[49906, 1791, 125, 3, 70, "ExampleDelimiter",
 CellID->292662029],
Cell[50034, 1796, 198, 5, 70, "ExampleText",
 CellID->1735677223],
Cell[CellGroupData[{
Cell[50257, 1805, 479, 16, 70, "Input",
 CellID->2019640246],
Cell[50739, 1823, 242, 8, 36, "Output",
 CellID->524050626]
}, Open  ]],
Cell[50996, 1834, 194, 5, 70, "ExampleText",
 CellID->1824994461],
Cell[CellGroupData[{
Cell[51215, 1843, 473, 16, 70, "Input",
 CellID->1953686089],
Cell[51691, 1861, 206, 7, 36, "Output",
 CellID->18106277]
}, Open  ]],
Cell[51912, 1871, 393, 14, 70, "ExampleText",
 CellID->201054120],
Cell[CellGroupData[{
Cell[52330, 1889, 669, 20, 70, "Input",
 CellID->173744307],
Cell[53002, 1911, 3799, 66, 70, "Output",
 Evaluatable->False,
 CellID->836033206]
}, Open  ]],
Cell[56816, 1980, 126, 3, 70, "ExampleDelimiter",
 CellID->1807974385],
Cell[56945, 1985, 205, 6, 70, "ExampleText",
 CellID->36073883],
Cell[CellGroupData[{
Cell[57175, 1995, 406, 13, 70, "Input",
 CellID->704723545],
Cell[57584, 2010, 401, 7, 70, "Message",
 CellID->79164839],
Cell[57988, 2019, 502, 17, 36, "Output",
 CellID->257680994]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58539, 2042, 223, 7, 70, "ExampleSection",
 CellID->3249],
Cell[58765, 2051, 362, 12, 70, "ExampleText",
 CellID->1874428683],
Cell[59130, 2065, 1760, 55, 70, "Input",
 CellID->131235350],
Cell[60893, 2122, 138, 4, 70, "ExampleText",
 CellID->2029432718],
Cell[CellGroupData[{
Cell[61056, 2130, 212, 7, 70, "Input",
 CellID->2047489804],
Cell[61271, 2139, 459, 12, 36, "Output",
 CellID->51866229]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61791, 2158, 310, 9, 70, "SeeAlsoSection",
 CellID->4914],
Cell[62104, 2169, 703, 26, 70, "SeeAlso",
 CellID->5230]
}, Open  ]],
Cell[CellGroupData[{
Cell[62844, 2200, 314, 9, 70, "TutorialsSection",
 CellID->15216],
Cell[63161, 2211, 154, 3, 70, "Tutorials",
 CellID->13361],
Cell[63318, 2216, 171, 4, 70, "Tutorials",
 CellID->78894921]
}, Open  ]],
Cell[CellGroupData[{
Cell[63526, 2225, 318, 9, 70, "RelatedLinksSection",
 CellID->79],
Cell[63847, 2236, 266, 6, 70, "RelatedLinks",
 CellID->7555]
}, Open  ]],
Cell[CellGroupData[{
Cell[64150, 2247, 319, 9, 70, "MoreAboutSection",
 CellID->964888739],
Cell[64472, 2258, 138, 3, 70, "MoreAbout",
 CellID->72896119],
Cell[64613, 2263, 162, 3, 70, "MoreAbout",
 CellID->83378376],
Cell[64778, 2268, 160, 3, 70, "MoreAbout",
 CellID->270353451],
Cell[64941, 2273, 136, 3, 70, "MoreAbout",
 CellID->291210017],
Cell[65080, 2278, 178, 3, 70, "MoreAbout",
 CellID->37672109]
}, Open  ]],
Cell[65273, 2284, 50, 0, 70, "History"],
Cell[65326, 2286, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

